<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// check to make sure VB_AREA is defined
if (defined('VB_AREA'))
{
	// setup some defaults if nothing is set
	if (!isset($user['vbp_receivespoints'])) { $user['vbp_receivespoints'] = 1; }
	if (!isset($user['vbp_storeaccess'])) { $user['vbp_storeaccess'] = 1; }
	if (empty($user[$vbulletin->options['vbbux_pointsfield']])) { $user[$vbulletin->options['vbbux_pointsfield']] = $vbulletin->options['vbbux_perregistration']; }

	// display the edit options for vbplaza
	print_table_break('', $INNERTABLEWIDTH);
	print_table_header(construct_phrase($vbphrase['vbplaza_x_settings'], $vbphrase['vbbux_name']), 2);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_can_receive_points'], $vbphrase['vbbux_points']), 'vbp_receivespoints', $user['vbp_receivespoints']);
	print_input_row($vbphrase['vbbux_points'], 'vbp_points', $user[$vbulletin->options['vbbux_pointsfield']]);
	print_input_row($vbphrase['vbbux_bank'], 'vbp_bank', $user[$vbulletin->options['vbbux_bankfield']]);
	print_input_row($vbphrase['vbbux_next_interest'], 'vbp_nextbankinterest', $user['vbp_nextbankinterest']);
	print_table_header(construct_phrase($vbphrase['vbplaza_x_settings'], $vbphrase['vbplaza_name']), 2);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_can_access_vbplaza'], $vbphrase['vbplaza_name']), 'vbp_storeaccess', $user['vbp_storeaccess']);
	print_input_row($vbphrase['vbplaza_generic_permissions'], 'vbp_genericperm', $user['vbp_genericperm']);
	print_input_row($vbphrase['vbplaza_moderator_permissions'], 'vbp_modperm', $user['vbp_modperm']);
	print_input_row($vbphrase['vbplaza_administrator_permissions'], 'vbp_adminperm', $user['vbp_adminperm']);
	print_input_row($vbphrase['vbplaza_change_always_items'], 'vbp_changealwaysitems', $user['vbp_changealwaysitems']);
	print_input_row(construct_phrase($vbphrase['vbplaza_x_color'], $vbphrase['username']), 'vbp_nametextcolor', $user['vbp_nametextcolor']);
	print_input_row(construct_phrase($vbphrase['vbplaza_x_glow_color'], $vbphrase['username']), 'vbp_nameglowcolor', $user['vbp_nameglowcolor']);
	print_input_row(construct_phrase($vbphrase['vbplaza_x_shadow_color'], $vbphrase['username']), 'vbp_nameshadowcolor', $user['vbp_nameshadowcolor']);
	print_input_row(construct_phrase($vbphrase['vbplaza_x_font_type'], $vbphrase['username']), 'vbp_namefonttype', $user['vbp_namefonttype']);
	print_input_row(construct_phrase($vbphrase['vbplaza_x_color'], $vbphrase['user_title']), 'vbp_titletextcolor', $user['vbp_titletextcolor']);
	print_input_row(construct_phrase($vbphrase['vbplaza_x_glow_color'], $vbphrase['user_title']), 'vbp_titleglowcolor', $user['vbp_titleglowcolor']);
	print_input_row(construct_phrase($vbphrase['vbplaza_x_shadow_color'], $vbphrase['user_title']), 'vbp_titleshadowcolor', $user['vbp_titleshadowcolor']);
	print_input_row(construct_phrase($vbphrase['vbplaza_x_font_type'], $vbphrase['user_title']), 'vbp_titlefonttype', $user['vbp_titlefonttype']);
	print_table_header($vbphrase['vbplaza_display_flags'], 2);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_bold_x'], $vbphrase['username']), 'vbp_displayflags[boldusername]', ($user['vbp_displayflags'] & $vbulletin->bf_misc_vbpdisplayflags['boldusername']) ? 1 : 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_italic_x'], $vbphrase['username']), 'vbp_displayflags[italicusername]', ($user['vbp_displayflags'] & $vbulletin->bf_misc_vbpdisplayflags['italicusername']) ? 1 : 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_underline_x'], $vbphrase['username']), 'vbp_displayflags[underlinedusername]', ($user['vbp_displayflags'] & $vbulletin->bf_misc_vbpdisplayflags['underlinedusername']) ? 1 : 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_bold_x'], $vbphrase['user_title']), 'vbp_displayflags[boldusertitle]', ($user['vbp_displayflags'] & $vbulletin->bf_misc_vbpdisplayflags['boldusertitle']) ? 1 : 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_italic_x'], $vbphrase['user_title']), 'vbp_displayflags[italicusertitle]', ($user['vbp_displayflags'] & $vbulletin->bf_misc_vbpdisplayflags['italicusertitle']) ? 1 : 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_underline_x'], $vbphrase['user_title']), 'vbp_displayflags[underlinedusertitle]', ($user['vbp_displayflags'] & $vbulletin->bf_misc_vbpdisplayflags['underlinedusertitle']) ? 1 : 0);
	print_yes_no_row($vbphrase['vbplaza_horizontal_postbit'], 'vbp_displayflags[horizontalpostbit]', ($user['vbp_displayflags'] & $vbulletin->bf_misc_vbpdisplayflags['horizontalpostbit']) ? 1 : 0);
	print_yes_no_row($vbphrase['vbplaza_legacy_postbit'], 'vbp_displayflags[legacypostbit]', ($user['vbp_displayflags'] & $vbulletin->bf_misc_vbpdisplayflags['legacypostbit']) ? 1 : 0);
	print_table_header($vbphrase['vbplaza_other_flags'], 2);
	print_yes_no_row($vbphrase['vbplaza_bypass_post_flood'], 'vbp_otherflags[bypasspostflood]', ($user['vbp_otherflags'] & $vbulletin->bf_misc_vbpotherflags['bypasspostflood']) ? 1 : 0);
	print_yes_no_row($vbphrase['vbplaza_give_unlimited_rep'], 'vbp_otherflags[giveunlimitedrep]', ($user['vbp_otherflags'] & $vbulletin->bf_misc_vbpotherflags['giveunlimitedrep']) ? 1 : 0);
	print_yes_no_row($vbphrase['vbplaza_see_deletion_notices'], 'vbp_otherflags[seedeletionnotices]', ($user['vbp_otherflags'] & $vbulletin->bf_misc_vbpotherflags['seedeletionnotices']) ? 1 : 0);
	print_yes_no_row($vbphrase['vbplaza_bypass_pm_flood'], 'vbp_otherflags[bypasspmflood]', ($user['vbp_otherflags'] & $vbulletin->bf_misc_vbpotherflags['bypasspmflood']) ? 1 : 0);
	print_yes_no_row($vbphrase['vbplaza_bypass_search_flood'], 'vbp_otherflags[bypasssearchflood]', ($user['vbp_otherflags'] & $vbulletin->bf_misc_vbpotherflags['bypasssearchflood']) ? 1 : 0);
	print_yes_no_row($vbphrase['vbplaza_can_use_message_tracking'], 'vbp_otherflags[canusemessagetracking]', ($user['vbp_otherflags'] & $vbulletin->bf_misc_vbpotherflags['canusemessagetracking']) ? 1 : 0);
	print_yes_no_row($vbphrase['vbplaza_can_deny_pm_receipts'], 'vbp_otherflags[candenypmreceipts]', ($user['vbp_otherflags'] & $vbulletin->bf_misc_vbpotherflags['candenypmreceipts']) ? 1 : 0);
	print_yes_no_row($vbphrase['vbplaza_arcade_access'], 'vbp_otherflags[arcadeaccess]', ($user['vbp_otherflags'] & $vbulletin->bf_misc_vbpotherflags['arcadeaccess']) ? 1 : 0);
	print_table_header($vbphrase['vbplaza_immunity'], 2);
	print_yes_no_row($vbphrase['vbplaza_thief'], 'vbp_immunity[thief]', ($user['vbp_immunity'] & $vbulletin->bf_misc_vbpimmunity['thief']) ? 1 : 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_change_x'], $vbphrase['user_title']), 'vbp_immunity[changeusertitle]', ($user['vbp_immunity'] & $vbulletin->bf_misc_vbpimmunity['changeusertitle']) ? 1 : 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_change_x'], $vbphrase['vbplaza_default_avatar']), 'vbp_immunity[changedefaultavatar]', ($user['vbp_immunity'] & $vbulletin->bf_misc_vbpimmunity['changedefaultavatar']) ? 1 : 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_remove_x'], $vbphrase['vbplaza_default_avatar']), 'vbp_immunity[removedefaultavatar]', ($user['vbp_immunity'] & $vbulletin->bf_misc_vbpimmunity['removedefaultavatar']) ? 1 : 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_change_x'], $vbphrase['vbplaza_custom_avatar']), 'vbp_immunity[changecustomavatar]', ($user['vbp_immunity'] & $vbulletin->bf_misc_vbpimmunity['changecustomavatar']) ? 1 : 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_remove_x'], $vbphrase['vbplaza_custom_avatar']), 'vbp_immunity[removecustomavatar]', ($user['vbp_immunity'] & $vbulletin->bf_misc_vbpimmunity['removecustomavatar']) ? 1 : 0);
	print_yes_no_row(construct_phrase($vbphrase['vbplaza_change_x'], $vbphrase['reputation']), 'vbp_immunity[changereputation]', ($user['vbp_immunity'] & $vbulletin->bf_misc_vbpimmunity['changereputation']) ? 1 : 0);

	// now check for user history
	$userhistory = unserialize($user['vbp_history']);
	if (is_array($userhistory) && !empty($userhistory))
	{
		// start off the new history table
		print_table_break('', $INNERTABLEWIDTH);
		print_table_header($vbphrase['vbplaza_name'] . " " . $vbphrase['vbplaza_item_history'], 3);
		print_cells_row(array(construct_phrase($vbphrase['vbplaza_x_id'], $vbphrase['vbplaza_item']), $vbphrase['vbplaza_item_name'], $vbphrase['vbplaza_item_cost']), 1, 'tcat');

		// cache all of the $vbplazaoptions
		$vbplazaoptions = array();
		$items = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbplaza_item ORDER BY category, displayorder");
		while ($item = $vbulletin->db->fetch_array($items))
		{
			// cache this item
			$vbplazaoptions[$item['itemid']] = $item;
		}

		// free the items
		$vbulletin->db->free_result($items);

		// process each history entry
		foreach($userhistory AS $key => $item)
		{
			// clear out the cells
			$cell = array();

			// try to get the itemname from the cache
			if (!empty($vbplazaoptions[$item['itemid']]))
			{
				// set this as the $item name
				$item['name'] = $vbplazaoptions[$item['itemid']]['name'];
			}
			else
			{
				// set the name to something
				$item['name'] = $vbphrase['vbplaza_no_name'];
			}

			// setup and display the cells
			$cell[] = $item['itemid'];
			$cell[] = $item['name'];
			$cell[] = vb_number_format($item['finalcost'], $vbulletin->options['vbplaza_decimalplaces']);
			print_cells_row($cell);
		}
	}
}
?>