<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'vbplaza_lottery');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('vbplaza', 'forum', 'cpuser', 'cpoption');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_vbplaza.php');

// ############################# LOG ACTION ###############################
log_admin_action();

// check if the admin requires super administrator access for 'lottery'
// NOTE: To enable this enter the below line into your config.php
// $config['vbPlaza']['lottery']['requiresuperadmin'] = true;
if ($vbulletin->config['vbPlaza']['lottery']['requiresuperadmin'])
{
	// check if the user is a super administrator
	$userids = explode(',', str_replace(' ', '', $vbulletin->config['SpecialUsers']['superadministrators']));
	if (!in_array($vbulletin->userinfo['userid'], $userids))
	{
		print_stop_message('vbplaza_no_permission_admin_lottery');
	}
}

// check that moderators are allowed to use these
if ($vbulletin->options['vbplaza_modcpenabled'] == 0)
{
	// display the header
	print_cp_header('vbLottery v' . $vbulletin->options['vbplaza_version'] . ' Moderator');

	// display message that these functions are disabled
	print_form_header('vbplaza_lottery', 'vbplazadisabled');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_name'] . " - " . $vbphrase['vbplaza_disabled_by_administrator'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_disabled_by_administrator_message']);
	print_table_footer(2, "");

	// display the footer
	print_cp_footer();
	exit;
}

// cache the vbplazalotteries
$vbplazalotteries = array();
if ($lotteries = $db->query_read("
	SELECT *
	FROM " . TABLE_PREFIX . "vbplaza_lottery
	ORDER BY lotteryid
"))
{
	// start processing the items
	while ($lottery = $db->fetch_array($lotteries))
	{
		// cache this item
		$vbplazalotteries[$lottery[lotteryid]] = $lottery;
	}
}

// free the lotteries
$vbulletin->db->free_result($lotteries);

// display the header
print_cp_header('vbPlaza Lottery v' . $vbulletin->options['vbplaza_version'] . ' Moderator');

// check if an action is set
if (!isset($_REQUEST['do']))
{
	// force it to list the lotterys
	$_REQUEST['do'] = 'lotterylist';
}

// check if its updating a lottery
if ($_POST['do'] == 'updatelottery')
{
	// check if its deleting an option
	if (isset($_POST['delete']))
	{
		// verify the lottery is deletable
		if (is_numeric($_POST['lotteryid']) && ($_POST['lotteryid'] >= 11))
		{
			// delete all of the tickets purchased for this lottery
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "vbplaza_lotteryticket WHERE lotteryid = '" . $_POST['lotteryid'] . "'");

			// delete this lottery from the vbp_lottery table
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "vbplaza_lottery WHERE lotteryid = '" . $_POST['lotteryid'] . "'");
		}
	}
	else
	{
		// update the lottery's settings
		require_once(DIR . '/includes/functions_misc.php');
		if (is_numeric($_POST['lotteryid']) && is_array($_POST['lottery']))
		{
			// build the querystr
			$querstr = '';
			foreach($_POST['lottery'] AS $key => $field)
			{
				// check if it should add a comma
				if (isset($querystr)) { $querystr .= ", "; }

				// check if this key is the enddateline
				if ($key == 'enddateline')
				{
					// rebuild the unix time stamp
					$field = vbmktime($field['hour'], $field['minute'], $field['second'], $field['month'], $field['day'], $field['year']);

					// verify that the $field is valid
					if ($field < 0)
					{
						// force it to the current time
						$field = TIMENOW;
					}
				}

				// check if this key is the allowedgroups
				if (($key == 'allowedgroups') || ($key == 'deniedgroups'))
				{
					// dont allow them to update these fields
					continue;
				}

				// add this field
				$querystr .= "$key = '" . addslashes($field) . "'";
			}

			// if there is a querystr, run it
			if (isset($querystr))
			{
				// send the query to update
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "vbplaza_lottery
					SET
						" . $querystr . "
					WHERE lotteryid = '" . $_POST['lotteryid'] . "'
				");
			}
		}
	}

	// do the redirect now
	define('CP_REDIRECT', 'vbplaza_lottery.php?do=lotterylist');
	print_stop_message('saved_settings_successfully');
}

// check if its doing a quick update
if ($_POST['do'] == 'quickupdate')
{
	// check that order is an array
	if (is_array($_POST['ticketcost']) && is_array($_POST['jackpot']) && is_array($_POST['winningtax']) && is_array($_POST['ticketssold']))
	{
		// process all of the vbplazalotteries
		$lotteries = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbplaza_lottery");
		while ($lottery = $db->fetch_array($lotteries))
		{
			// check if this data is true
			if (!isset($_POST['ticketcost']["$lottery[lotteryid]"]))
			{
				continue;
			}

			// send the query to update
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "vbplaza_lottery
				SET
					ticketcost = '" . $_POST['ticketcost']["$lottery[lotteryid]"] . "',
					jackpot = '" . $_POST['jackpot'][$lottery[lotteryid]] . "',
					winningtax = '" . $_POST['winningtax'][$lottery[lotteryid]] . "',
					ticketssold = '" . $_POST['ticketssold']["$lottery[lotteryid]"] . "',
					active = '" . $_POST['active']["$lottery[lotteryid]"] . "'
				WHERE lotteryid = '" . $lottery['lotteryid'] . "'
			");
		}

		// free the lotteries
		$vbulletin->db->free_result($lotteries);
	}

	// do the redirect now
	define('CP_REDIRECT', 'vbplaza_lottery.php?do=lotterylist');
	print_stop_message('saved_settings_successfully');
}

// check if its searching the lottery winners
if ($_REQUEST['do'] == 'searchlotterywinners')
{
	// build the search terms if any
	$searchterms = array();
	if (is_numeric($_REQUEST['userid']))
	{
		// add this to the search terms
		$searchterms[] = "userid = '" . $_REQUEST['userid'] . "'";
	}
	if (!empty($_REQUEST['username']))
	{
		// add this to the search terms
		$searchterms[] = "username LIKE '%" . $db->escape_string($_REQUEST['username']) . "%'";
	}

	// check if there are any searchterms
	if (!empty($searchterms))
	{
		// implode the string
		$wherestr = "WHERE " . implode(" OR ", $searchterms);
	}

	// verify that $_REQUEST['page'] is set
	$perpage = 50;
	if (!is_numeric($_REQUEST['page'])) { $_REQUEST['page'] = 1; }

	// setup the $limitstr
	if ($_REQUEST['page'] > 1)
	{
		// setup the $skip start
		$skip = $perpage * ($_REQUEST['page'] - 1);

		// update the $limitstr properly
		$limitstr = "LIMIT $skip, $perpage";
	}
	else
	{
		// set $skip to be 1
		$skip = 1;

		// update the $limitstr properly
		$limitstr = "LIMIT 0, $perpage";
	}

	// check out how many items are found like this
	$itemhistory = $db->query_first("
		SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "vbplaza_lotterywinner
		" . $wherestr . "
	");

	// check if any rows were found
	if ($itemhistory['count'] > 0)
	{
		// build the total page
		$totalpages = ceil($itemhistory['count'] / $perpage);

		// select the rows from the database
		$winners = $db->query_read("
			SELECT * FROM " . TABLE_PREFIX . "vbplaza_lotterywinner
			" . $wherestr . "
			ORDER BY dateline DESC
			" . $limitstr . "
		");

		// process each winner
		$winnercache = array();
		while ($winner = $db->fetch_array($winners))
		{
			// add this winner
			$winnercache["$winner[winnerid]"] = $winner;
		}

		// free the winners
		$vbulletin->db->free_result($winners);

		// check if its not the first page
		if ($_REQUEST['page'] != 1)
		{
			$prv = $_REQUEST['page'] - 1;
			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['first_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbplaza_lottery.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchlotterywinners&itemid=" . $_REQUEST['itemid'] . "&itemname=" . $_REQUEST['itemname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=1'\">";
			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['prev_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbplaza_lottery.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchlotterywinners&itemid=" . $_REQUEST['itemid'] . "&itemname=" . $_REQUEST['itemname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$prv'\">";
		}
		if ($_REQUEST['page'] != $totalpages)
		{
			$nxt = $_REQUEST['page'] + 1;
			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['next_page'] . " &gt;\" tabindex=\"1\" onclick=\"window.location='vbplaza_lottery.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchlotterywinners&itemid=" . $_REQUEST['itemid'] . "&itemname=" . $_REQUEST['itemname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$nxt'\">";
			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['last_page'] . " &raquo;\" tabindex=\"1\" onclick=\"window.location='vbplaza_lottery.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchlotterywinners&itemid=" . $_REQUEST['itemid'] . "&itemname=" . $_REQUEST['itemname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$totalpages'\">";
		}

		// display message that the refill was successful
		print_form_header('vbplaza_lottery', 'searchlotterywinners');
		print_description_row(construct_link_code($vbphrase['restart'], "vbplaza_lottery.php?do=lotterywinners"), 0, 5, 'thead', $stylevar['right']);
		print_table_header("<font size=3>" . $vbphrase['vbplaza_search_lottery_winners'] . "</font>", 5);
		print_cells_row(array($vbphrase['vbplaza_winner_id'], $vbphrase['vbplaza_lottery_name'], $vbphrase['vbplaza_lottery_winner'], $vbphrase['vbplaza_jackpot'], $vbphrase['vbplaza_lottery_date_won']), 1, 'tcat');

		// process each row
		foreach($winnercache AS $winnerid => $winner)
		{
			// clear out the cells
			$cell = array();

			// setup and display the cells
			$cell[] = $winner['winnerid'];
			$cell[] = $winner['lotteryname'];
			$cell[] = $winner['username'];
			$cell[] = $winner['jackpot'];
			$cell[] = vbdate($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $winner['dateline']);
			print_cells_row($cell);
		}

		// finish off the footer
		print_table_footer(5, "$firstpage $prevpage &nbsp; $nextpage $lastpage");
	}
	else
	{
		// display message that nothing was found
		print_form_header('vbplaza_lottery', 'searchlotterywinners');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_search_lottery_winners'] . "</font>", 2);
		print_description_row($vbphrase['vbplaza_no_lottery_winners_found']);
		print_table_footer(2, "");
	}
}

// check if its editing a lottery
if ($_REQUEST['do'] == 'editlottery')
{
	// build delete button if possible
	$deleteoption = '';
	if ($_REQUEST['lotteryid'] >= 11)
	{
		// setup up the $deleteoption
		$deleteoption = "<input type=\"submit\" name=\"delete\" class=\"button\" tabindex=\"1\" value=\"" . construct_phrase($vbphrase['vbplaza_delete_x'], $vbphrase['vbplaza_lottery']) . "\" accesskey=\"s\" /> &nbsp; ";
	}

	// cache the lottery
	$lottery = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_lottery WHERE lotteryid = '" . $_REQUEST['lotteryid'] . "'");
	print_form_header('vbplaza_lottery', 'updatelottery');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_edit'] . " " . $lottery['name'] . "</font>", 2);
	construct_hidden_code('lotteryid', $_REQUEST['lotteryid']);
	print_yes_no_row($vbphrase['vbplaza_active'], 'lottery[active]', $lottery['active']);
	print_yes_no_row($vbphrase['vbplaza_lottery_recurring'], 'lottery[recurring]', $lottery['recurring']);
	print_yes_no_row($vbphrase['vbplaza_lottery_ticket_builds_jackpot'], 'lottery[ticketbuild]', $lottery['ticketbuild']);
	print_input_row($vbphrase['vbplaza_time_active'], 'lottery[timeactive]', $lottery['timeactive']);
	print_time_row($vbphrase['vbplaza_ending_time'], 'lottery[enddateline]', $lottery['enddateline']);
	print_input_row($vbphrase['vbplaza_ticket_price'], 'lottery[ticketcost]', $lottery['ticketcost']);
	print_input_row($vbphrase['vbplaza_starting_jackpot_amount'], 'lottery[startingjackpot]', $lottery['startingjackpot']);
	print_input_row($vbphrase['vbplaza_jackpot_amount'], 'lottery[jackpot]', $lottery['jackpot']);
	print_input_row($vbphrase['vbplaza_winning_tax'], 'lottery[winningtax]', $lottery['winningtax']);
	print_input_row($vbphrase['vbplaza_max_tickets_per_user'], 'lottery[maxticketperuser]', $lottery['maxticketperuser']);
	print_input_row($vbphrase['vbplaza_maximum_tickets'], 'lottery[maxtickets]', $lottery['maxtickets']);
	print_input_row($vbphrase['vbplaza_minimum_tickets'], 'lottery[mintickets]', $lottery['mintickets']);
	print_input_row($vbphrase['vbplaza_tickets_sold'], 'lottery[ticketssold]', $lottery['ticketssold']);
	print_input_row($vbphrase['vbplaza_lottery_name'], 'lottery[name]', $lottery['name']);
	print_textarea_row(construct_phrase($vbphrase['vbplaza_x_description'], $vbphrase['vbplaza_lottery']), 'lottery[description]', $lottery['description']);
	print_input_row($vbphrase['vbplaza_lottery_image_location'], 'lottery[imagelocation]', $lottery['imagelocation']);
	print_table_footer(2, $deleteoption . "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" />");
}

// check if it is searching the lottery winners
if ($_REQUEST['do'] == 'lotterywinners')
{
	// display that there are no categories found
	print_form_header('vbplaza_lottery', 'searchlotterywinners');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_search_lottery_winners'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_search_criteria']);
	print_input_row($vbphrase['username'], 'username', '');
	print_input_row($vbphrase['userid'], 'userid', '');
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_search_lottery_winners'] . "\" accesskey=\"s\" />");
}

// check if it is listing the options
if ($_REQUEST['do'] == 'lotterylist')
{
	// start the output
	print_form_header('vbplaza_lottery', 'quickupdate');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_vblottery_list'] . "</font>", 6);
	print_cells_row(array($vbphrase['vbplaza_lottery_name'], $vbphrase['vbplaza_ticket_price'], $vbphrase['vbplaza_jackpot_amount'], $vbphrase['vbplaza_winning_tax'], $vbphrase['vbplaza_tickets_sold'], $vbphrase['vbplaza_active']), 1, 'tcat');

	// process all cached lotterys
	foreach($vbplazalotteries AS $lottery)
	{
		// verify the lottery is valid
		if (is_numeric($lottery['lotteryid']))
		{
			// clear out the cells
			$cell = array();

			// setup and display the cells
			$cell[] = "<a href=\"vbplaza_lottery.php?do=editlottery&amp;lotteryid=" . $lottery['lotteryid'] . "\">" . $lottery['name'] . "</a>";
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"ticketcost[$lottery[lotteryid]]\" value=\"$lottery[ticketcost]\" size=\"6\" title=\"" . $vbphrase['vbplaza_lottery_cost'] . "\" />";
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"jackpot[$lottery[lotteryid]]\" value=\"$lottery[jackpot]\" size=\"10\" title=\"" . $vbphrase['vbplaza_lottery_tax'] . "\" />";
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"winningtax[$lottery[lotteryid]]\" value=\"$lottery[winningtax]\" size=\"10\" title=\"" . $vbphrase['vbplaza_lottery_tax'] . "\" />";
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"ticketssold[$lottery[lotteryid]]\" value=\"$lottery[ticketssold]\" size=\"6\" title=\"" . $vbphrase['vbplaza_lotterys_sold'] . "\" />";
			$activemods = array('1' => $vbphrase['yes'], '0' => $vbphrase['no']);
			$cell[] = "<select name=\"active[$lottery[lotteryid]]\" class=\"bginput\">\n" . construct_select_options($activemods, $lottery['active']) . "\t</select>";
			print_cells_row($cell);
		}
	}

	// finish off the table
	print_table_footer(6, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" />");
}

// display the footer
print_cp_footer();
?>