<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// verify that vbPlaza is running
if (!VBPLAZA_RUNNING)
{
	// simply exit for now
	exit;
}

// function so it can print and flush the output live
function vbplaza_printf($message)
{
	// echo the message
	echo $message;

	// flush the output
	if (function_exists('ob_flush'))
	{
		// only run this if its available
		@ob_flush();
	}
	flush();
}

// function to setup the serialized data
function vbplaza_setup_special_template($templatename)
{
	global $vbulletin;

	// check if this data needs to be unserialized
	$data = $vbulletin->$templatename;
	if (($data[0] == 'a') && ($data[1] == ':'))
	{
		// unserialize the data
		$vbulletin->$templatename = unserialize($vbulletin->$templatename);
	}

	// verify that it is indeed an array
	if (!is_array($vbulletin->$templatename))
	{
		// set it up to be an empty array
		$vbulletin->$templatename = array();
	}
}

// function to cache the vbplazaoptions
function vbplaza_cache_items($categoryid = '', $itemid = '')
{
	global $vbulletin;

	// check if it should list smaller portions
	$wherestr = '';
	if (is_numeric($itemid) && ($itemid > 0))
	{
		// add this to the $wherestr
		$wherestr = " AND itemid = '" . $itemid . "'";
	}
	else if (is_numeric($categoryid) && ($categoryid > 0))
	{
		// add this to the $wherestr
		$wherestr = " AND category = '" . $categoryid . "'";
	}

	// cache the vbplazaoptions
	unset($founditems);
	if ($items = $vbulletin->db->query_read("
		SELECT items.*, category.name AS categoryname, category.allowedgroups AS categoryallowedgroups, category.deniedgroups AS categorydeniedgroups
		FROM " . TABLE_PREFIX . "vbplaza_item AS items
		LEFT JOIN " . TABLE_PREFIX . "vbplaza_category AS category ON (category.categoryid = items.category)
		WHERE items.active = 1
			" . $wherestr . "
		ORDER BY displayorder
	"))
	{
		// start caching the items
		while ($item = $vbulletin->db->fetch_array($items))
		{
			// cache this item
			$founditems[$item[itemid]] = $item;
		}
	}

	// free the items
	$vbulletin->db->free_result($items);

	// return the found items
	return $founditems;
}

// function to calculate how many points a post is worth
function vbplaza_calculate_post_points($post, $forumid, $type = '')
{
	global $vbulletin;

	// use the cache for the $foruminfo
	$foruminfo = $vbulletin->forumcache["$forumid"];

	// check if it's creating a thread
	$totalpoints = 0;
	if ($type == 'thread')
	{
		// check if it should give the user some points
		if (($vbulletin->options['vbbux_perthread'] != 0) && ($foruminfo['vbbux_perthread'] != 0))
		{
			// set the amount of points to give properly
			$totalpoints = $vbulletin->options['vbbux_perthread'] * $foruminfo['vbbux_perthread'];
		}
	}
	else
	{
		// check if it should give the user some points
		if (($vbulletin->options['vbbux_perreply'] != 0) && ($foruminfo['vbbux_perreply'] != 0))
		{
			// set the amount of points to give properly
			$totalpoints = $vbulletin->options['vbbux_perreply'] * $foruminfo['vbbux_perreply'];
		}
	}

	// check if it found some points
	if ($totalpoints != 0)
	{
		// check if there is any bonus per posted character
		if ($vbulletin->options['vbbux_perpostedcharacter'] != 0)
		{
			// copy the message into a temp variable
			$message = $post['message'];

			// check if it should strip white space
			if ($vbulletin->options['vbbux_stripwhitespace'])
			{
				// strip out the white space
				$message = preg_replace('/\s\s+/', ' ', $message);
			}

			// check if it should strip bbcode
			if ($vbulletin->options['vbbux_stripbbcodes'])
			{
				// parse out the bbcode
				require_once(DIR . '/includes/class_bbcode.php');
				$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
				$message = $bbcode_parser->parse($message, $forumid, true);

				// strip out the html
				$message = $vbulletin->input->clean($message, TYPE_NOHTML);
			}

			// increase $totalpoints for the per posted character bonus
			$totalpoints += ($vbulletin->options['vbbux_perpostedcharacter'] * strlen($message));
		}

		// check if the user is a moderator and if moderators get more
		if (is_member_of($vbulletin->userinfo, 7) && ($vbulletin->options['vbbux_extrapermods'] != 0))
		{
			// increase the amount of points for moderators
			$totalpoints = $totalpoints * $vbulletin->options['vbbux_extrapermods'];
		}
		// check if the user is a super moderator and if super moderators get more
		else if (is_member_of($vbulletin->userinfo, 5) && ($vbulletin->options['vbbux_extrapersmods'] != 0))
		{
			// increase the amount of points for moderators
			$totalpoints = $totalpoints * $vbulletin->options['vbbux_extrapersmods'];
		}
	}

	// return the $totalpoints
	return $totalpoints;
}

// function to check if the user has enough points to cover the cost of the item
// $xfertype = 0 means that the user is trying to remove an option
// $xfertype = 1 means that the user is trying to purchase an option
function vbplaza_calculate_total_cost($action, $userdiscount = true, $taxable = true)
{
	global $vbulletin;

	// force cost to be 0 if its empty
	if (empty($action['cost']) || ($action['cost'] == 0)) { $action['cost'] = 0; }

	// set the current userpoints
	$action['finalpoints'] = $vbulletin->userinfo[$vbulletin->options['vbbux_pointsfield']];
	$action['userpoints'] = vb_number_format($action['finalpoints'], $vbulletin->options['vbplaza_decimalplaces']);

	// set the current bankpoints
	$action['finalbankpoints'] = $vbulletin->userinfo[$vbulletin->options['vbbux_bankfield']];
	$action['bankpoints'] = vb_number_format($action['finalbankpoints'], $vbulletin->options['vbplaza_decimalplaces']);

	// check if this usergroup gets a discount (discount is on the base price, not the taxed price)
	if (($userdiscount == true) && ($vbulletin->userinfo['permissions']['vbp_discountrate'] > 0))
	{
		// verify the discountrate is < 100
		if ($vbulletin->userinfo['permissions']['vbp_discountrate'] <= 100)
		{
			// generate the overall discount rate
			$action['discountrate'] = ((100 - $vbulletin->userinfo['permissions']['vbp_discountrate']) / 100);

			// calculate the item cost with the discounted rate
			$action['cost'] = $action['cost'] * $action['discountrate'];
		}
	}

	// check if this user gets a senior member discount
	if (($userdiscount == true) && ($vbulletin->options['vbplaza_seniordiscountrate'] != 0) && !empty($vbulletin->userinfo['birthday']))
	{
		// get the current variables properly
		$curyear = date('Y');
		$curmonth = date('m');
		$curday = date('d');

		// get the birthday variables properly
		list($usermonth, $userday, $useryear) = explode("-", $vbulletin->userinfo['birthday']);

		// verify that the $useryear is valid
		if (($useryear >= 1900) && ($useryear < $curyear))
		{
			// verify that the $useryear is < $curyear found
			$userage = 0;
			if ($useryear < $curyear)
			{
				// start calculating the $userage
				$userage = $curyear - $useryear;

				// check if the $curmonth is <= $usermonth
				if ($curmonth < $usermonth)
				{
					// user has not had a birthday this year yet
					$userage--;
				}
				else if ($curmonth == $usermonth)
				{
					// check if the $userday is < $curday
					if ($curday < $userday)
					{
						// user has not had a birthday this year yet
						$userage--;
					}
				}
			}

			// check if the user gets a senior discount or not
			if ($userage && ($userage >= $vbulletin->options['vbplaza_seniordiscountage']))
			{
				// generate the overall discount rate
				$action['discountrate'] = ((100 - $vbulletin->options['vbplaza_seniordiscountrate']) / 100);

				// calculate the item cost with the discounted rate
				$action['cost'] = $action['cost'] * $action['discountrate'];
			}
		}
	}

	// check if this user gets a loyal member discount
	if (($userdiscount == true) && ($vbulletin->options['vbplaza_loyalmemberdiscountrate'] != 0))
	{
		// check if this user has been registered for more than x days
		if ((TIMENOW - $vbulletin->userinfo['joindate']) > ($vbulletin->options['vbplaza_loyalmembertimeframe'] * 86400))
		{
			// generate the overall discount rate
			$action['discountrate'] = ((100 - $vbulletin->options['vbplaza_loyalmemberdiscountrate']) / 100);

			// calculate the item cost with the discounted rate
			$action['cost'] = $action['cost'] * $action['discountrate'];
		}
	}

	// setup the itemcost
	$action['itemcost'] = $action['cost'];

	// generate the item cost with the item tax percentage
	if (($taxable == true) && ($action['tax'] > 0))
	{
		// generate the item taxes
		$action['itemtax'] = ($action['tax'] / 100.0);
		$action['itemtaxamount'] = $action['itemcost'] * $action['itemtax'];

		// calculate the itemcost with the item tax too
		$action['itemcost'] = $action['itemcost'] + $action['itemtaxamount'];
	}

	// now generate the final item cost with the overall tax percentage
	$action['finalcost'] = $action['itemcost'];
	if (($taxable == true) && ($vbulletin->options['vbplaza_federaltaxpercent'] > 0))
	{
		// generate the federal taxes
		$action['federaltax'] = ($vbulletin->options['vbplaza_federaltaxpercent'] / 100.0);
		$action['federaltaxamount'] = $action['finalcost'] * $action['federaltax'];

		// add the final federaltax amount to the final cost
		$action['finalcost'] = $action['finalcost'] + $action['federaltaxamount'];
	}

	// round off the 'finalcost'
	$action['finalcost'] = round($action['finalcost'], 5);

	// format all of the numbers properly
	$action['cost'] = vb_number_format($action['cost'], $vbulletin->options['vbplaza_decimalplaces']);
	$action['totalcost'] = vb_number_format($action['finalcost'], $vbulletin->options['vbplaza_decimalplaces']);
	$action['tax'] = vb_number_format($action['tax'], $vbulletin->options['vbplaza_decimalplaces']);

	// check if the user has enough points
	if ($action['finalpoints'] >= $action['finalcost'])
	{
		// set that this action should not be allowed
		$action['isallowed'] = 0;
		return $action;
	}

	// check if there are some items left
	if (($action['cost'] != 0) && ($action['quantity'] == 0))
	{
		// set that this action should not be allowed
		$action['isallowed'] = 0;
		return $action;
	}

	// set that this action seems to be allowable
	$action['isallowed'] = 1;
	return $action;
}

// function to validate the costs
function vbplaza_validate_cost($action)
{
	// check if the user has enough points
	if ($action['finalpoints'] < $action['finalcost'])
	{
		// display error, not enough points
		eval(standard_error(fetch_error('vbplaza_not_enough_points')));
	}

	// check if there are some items left
	if (($action['defquantity'] != 0) && ($action['quantity'] == 0))
	{
		// display error, no items left
		eval(standard_error(fetch_error('vbplaza_item_out_of_stock')));
	}
}

// build the proper $allowedusergroups & $deniedusergroups
function vbplaza_build_proper_usergroups($action, $vbplazacategories)
{
	// get the category's allowedgroups
	$categoryallowedgroups = $vbplazacategories[$action['category']]['allowedgroups'];

	// check if the categoryallowedgroups is empty
	$allowedgroups = array();
	if (!$action['overridepermissions'] && !empty($categoryallowedgroups))
	{
		// explode these into an array
		$usergroups = explode(",", $categoryallowedgroups);

		// process each usergroup
		foreach($usergroups AS $usergroupid)
		{
			// add this to the allowedgroups
			$allowedgroups[$usergroupid] = $usergroupid;
		}
	}

	// now check if it has any addition option allowedgroups to merge in
	if (!empty($action['allowedgroups']))
	{
		// explode these into an array
		$usergroups = explode(",", $action['allowedgroups']);

		// process each usergroup
		foreach($usergroups AS $usergroupid)
		{
			// add this to the allowedgroups
			$allowedgroups[$usergroupid] = $usergroupid;
		}
	}

	// get the category's denied usergroups
	$categorydeniedgroups = $vbplazacategories[$action['category']]['deniedgroups'];

	// check if the categorydeniedgroups is empty
	$deniedgroups = array();
	if (!$action['overridepermissions'] && !empty($categorydeniedgroups))
	{
		// explode these into an array
		$usergroups = explode(",", $categorydeniedgroups);

		// process each usergroup
		foreach($usergroups AS $usergroupid)
		{
			// add this to the deniedgroups
			$deniedgroups[$usergroupid] = $usergroupid;
		}
	}

	// now check if it has any addition option deniedgroups to merge in
	if (!empty($action['deniedgroups']))
	{
		// explode these into an array
		$usergroups = explode(",", $action['deniedgroups']);

		// process each usergroup
		foreach($usergroups AS $usergroupid)
		{
			// add this to the deniedgroups
			$deniedgroups[$usergroupid] = $usergroupid;
		}
	}

	// rebuild the final allowedgroups/deniedgroups
	if (!empty($allowedgroups))
	$action['allowedgroups'] = implode(",", $allowedgroups);
	$action['deniedgroups'] = implode(",", $deniedgroups);

	// return the new action fields
	return $action;
}

// function to check if the user is in the allowed usergroups
function vbplaza_check_allowed($userinfo, $allowedgroups, $deniedgroups)
{
	// set it to return disabled by default
	$isallowed = 0;

	// setup the $allowed
	$allowed = array();
	if (!empty($allowedgroups))
	{
		// explode the $allowedgroups
		$allowed = explode(",", $allowedgroups);
	}

	// setup the $denied
	$denied = array();
	if (!empty($deniedgroups))
	{
		// explode the $deniedgroups
		$denied = explode(",", $deniedgroups);
	}

	// check if the user is in the allowedgroups
	if (is_member_of($userinfo, $allowed)) { $isallowed = 1; }

	// check if the user is in the deniedgroups
	if (is_member_of($userinfo, $denied)) { $isallowed = 0; }

	// return if they are allowed or not
	return $isallowed;
}

// function to add an action to the history
function vbplaza_add_history($userinfo, $action)
{
	// calculate the expired time
	if ($action['expirydate'])
	{
		// calculate the $expirydate
		$expirydate = TIMENOW + ($action['expirydate'] * 86400);
	}
	else
	{
		// set the $expirydate to 0
		$expirydate = '0';
	}

	// clear out the $newhistory array
	$newhistory = array();

	// always add some things into the array
	$newhistory['itemid'] = $action['itemid'];
	$newhistory['finalcost'] = $action['finalcost'];
	$newhistory['dateline'] = TIMENOW;
	$newhistory['expires'] = $expirydate;
	if (!empty($action['threadid'])) { $newhistory['threadid'] = $action['threadid']; }
	if (!empty($action['forumid'])) { $newhistory['forumid'] = $action['forumid']; }
	if (!empty($action['usergroupid'])) { $newhistory['usergroupid'] = $action['usergroupid']; }
	if (!empty($action['touserid'])) { $newhistory['touserid'] = $action['touserid']; }
	if (!empty($action['tousername'])) { $newhistory['tousername'] = $action['tousername']; }
	if (!empty($action['fromuserid'])) { $newhistory['fromuserid'] = $action['fromuserid']; }
	if (!empty($action['fromusername'])) { $newhistory['fromusername'] = $action['fromusername']; }
	if (!empty($action['giftid'])) { $newhistory['giftid'] = $action['giftid']; }
	if (!empty($action['ribbonid'])) { $newhistory['ribbonid'] = $action['ribbonid']; }
	if (!empty($action['reason'])) { $newhistory['reason'] = $action['reason']; }

	// keep the old history
	$userhistory = $userinfo['vbp_history'];
	if (!empty($userhistory))
	{
		// try to unserialize it
		$userhistory = unserialize($userhistory);
	}

	// add this current history to the finalhistory
	$userhistory[] = $newhistory;

	// try to serialize it
	$userhistory = serialize($userhistory);

	// return the $userhistory
	return $userhistory;
}

// function to remove an action from the history
function vbplaza_remove_history($userinfo, $action)
{
	// get the old history
	$userhistory = $userinfo['vbp_history'];
	if (!empty($userhistory))
	{
		// try to unserialize it
		$userhistory = unserialize($userhistory);

		// process each user history
		foreach($userhistory AS $key => $history)
		{
			// check if this option is expired
			if ($history['itemid'] == $action['itemid'])
			{
				// attempt to unset this from the userhistory
				unset($userhistory[$key]);
			}
		}
	}

	// try to serialize it
	$userhistory = serialize($userhistory);

	// return the $userhistory
	return $userhistory;
}

// function to verify the set name
function vbplaza_verify_set_name($action, $setname)
{
	global $vbphrase;

	// verify that the $action['setname'] is valid
	if (empty($setname) || !is_string($setname))
	{
		// display error, option set name is invalid
		eval(standard_error(fetch_error('vbplaza_item_set_name_invalid', $vbphrase['vbplaza_name'])));
	}

	// return the setname
	return $setname;
}

// function to verify the set value
function vbplaza_verify_set_value($action, $setvalue)
{
	global $vbulletin, $vbphrase;

	// verify that the $setvalue is valid
	if (empty($setvalue))
	{
		// display error, option set value is invalid
		eval(standard_error(fetch_error('vbplaza_item_set_value_invalid', $vbphrase['vbplaza_name'])));
	}

	// it needs to be evalulated
	if (!eval('$setvalue = ' . $setvalue . '; return true;'))
	{
		// display error, option set value is invalid
		eval(standard_error(fetch_error('vbplaza_item_set_value_invalid', $vbphrase['vbplaza_name'])));
	}

	// check if $setvalue is a string
	if (is_string($setvalue))
	{
		// add the slashes to $setvalue
		$setvalue = $vbulletin->db->escape_string($setvalue);
	}

	// return the setvalue
	return $setvalue;
}

// function to verify the where name
function vbplaza_verify_where_name($action, $wherename)
{
	global $vbphrase;

	// verify that the wherename is valid if its set
	if (empty($wherename))
	{
		// we are going to assume where name should be userid
		$wherename = 'userid';
	}
	else if (!is_string($wherename))
	{
		// display error, option where name is invalid
		eval(standard_error(fetch_error('vbplaza_item_where_name_invalid', $vbphrase['vbplaza_name'])));
	}

	// return the wherename
	return $wherename;
}

// function to verify the where value
function vbplaza_verify_where_value($action, $wherevalue)
{
	global $vbulletin, $vbphrase;

	// verify that the where value is valid if its set
	if (empty($wherevalue))
	{
		// we are going to assume it wants the purchasers userid
		$wherevalue = $vbulletin->userinfo['userid'];
	}
	else
	{
		// try to evalute it as php
		if (!eval('$wherevalue = ' . $wherevalue . '; return true;'))
		{
			// display error, option where value is invalid
			eval(standard_error(fetch_error('vbplaza_item_where_value_invalid', $vbphrase['vbplaza_name'])));
		}

		// check if $wherevalue is a string
		if (is_string($wherevalue))
		{
			// add the slashes to the $wherevalue
			$wherevalue = $vbulletin->db->escape_string($wherevalue);
		}
	}

	// return the wherevalue
	return $wherevalue;
}

// function to update this purchase to the user
function vbplaza_user_purchase_update(&$userinfo, $action, $extrafields = '', $forcetype = false)
{
	global $vbulletin;

	// clear out the queryfields
	$queryfields = array();

	// calculate the queryfields based on purchase/removal
	if ($forcetype == true)
	{
		// verify that there should be a points adjustment
		if ($action['nopointschange'] != true)
		{
			// check if its removing points
			if ($action['removal'] == true)
			{
				// check if this users points are known
				if (!empty($userinfo[$vbulletin->options['vbbux_pointsfield']]))
				{
					// update the users points value that gets displayed
					$userinfo[$vbulletin->options['vbbux_pointsfield']] -= $action['finalcost'];
				}

				// add to the query field to decrease this user's points
				$queryfields[] = "`" . $vbulletin->options['vbbux_pointsfield'] . "` = `" . $vbulletin->options['vbbux_pointsfield'] . "` - " . $action['finalcost'];
			}
			else
			{
				// check if this users points are known
				if (!empty($userinfo[$vbulletin->options['vbbux_pointsfield']]))
				{
					// update the users points value that gets displayed
					$userinfo[$vbulletin->options['vbbux_pointsfield']] += $action['finalcost'];
				}

				// add to the query field to increase this user's points
				$queryfields[] = "`" . $vbulletin->options['vbbux_pointsfield'] . "` = `" . $vbulletin->options['vbbux_pointsfield'] . "` + " . $action['finalcost'];
			}
		}
	}
	else
	{
		// check if this item is one that can changealways
		if (!$action['changealways'])
		{
			// check if its doing a purchase or a refund
			if ($action['removal'] == true)
			{
				// check if it should give the user the points back
				if ($vbulletin->options['vbplaza_removeablerefunds'])
				{
					// check if this users points are known
					if (!empty($userinfo[$vbulletin->options['vbbux_pointsfield']]))
					{
						// update the users points value that gets displayed
						$userinfo[$vbulletin->options['vbbux_pointsfield']] += $action['finalcost'];
					}

					// add to the query field to increase this user's points
					$queryfields[] = "`" . $vbulletin->options['vbbux_pointsfield'] . "` = `" . $vbulletin->options['vbbux_pointsfield'] . "` + " . $action['finalcost'];
				}
			}
			else
			{
				// check if this users points are known
				if (!empty($userinfo[$vbulletin->options['vbbux_pointsfield']]))
				{
					// update the users points value that gets displayed
					$userinfo[$vbulletin->options['vbbux_pointsfield']] -= $action['finalcost'];
				}

				// add to the query field to decrease this user's points
				$queryfields[] = "`" . $vbulletin->options['vbbux_pointsfield'] . "` = `" . $vbulletin->options['vbbux_pointsfield'] . "` - " . $action['finalcost'];
			}
		}
		else
		{
			// check if its empty first
			if (!empty($userinfo['vbp_changealwaysitems']))
			{
				// check if this user has any changealways features
				$changealways = explode(",", $userinfo['vbp_changealwaysitems']);
			}
			else
			{
				// clear out the $changealways array
				$changealways = array();
			}

			// check if it should be removed from the array
			if ($action['removal'] == true)
			{
				// check if it should give the user the points back
				if ($vbulletin->options['vbplaza_removeablerefunds'])
				{
					// check if this users points are known
					if (!empty($userinfo[$vbulletin->options['vbbux_pointsfield']]))
					{
						// update the users points value that gets displayed
						$userinfo[$vbulletin->options['vbbux_pointsfield']] += $action['finalcost'];
					}

					// add to the query field to increase this user's points
					$queryfields[] = "`" . $vbulletin->options['vbbux_pointsfield'] . "` = `" . $vbulletin->options['vbbux_pointsfield'] . "` + " . $action['finalcost'];
				}

				// process each part of the array to remove the proper one
				foreach($changealways AS $key => $itemid)
				{
					// check if this is the one we want to remove
					if ($itemid == $action['itemid'])
					{
						// remove this item from the $changealways
						unset($changealways[$key]);
					}
				}
			}
			else
			{
				// check if this is an array
				if (empty($changealways) || !in_array($action['itemid'], $changealways))
				{
					// check if this users points are known
					if (!empty($userinfo[$vbulletin->options['vbbux_pointsfield']]))
					{
						// update the users points value that gets displayed
						$userinfo[$vbulletin->options['vbbux_pointsfield']] -= $action['finalcost'];
					}

					// add to the query field to decrease this user's points
					$queryfields[] = "`" . $vbulletin->options['vbbux_pointsfield'] . "` = `" . $vbulletin->options['vbbux_pointsfield'] . "` - " . $action['finalcost'];

					// add this to the $changealways array
					$changealways[] = $action['itemid'];
				}
			}

			// now rebuild the changealways field
			$changestr = implode(",", $changealways);

			// add this to the queryfields
			$queryfields[] = "vbp_changealwaysitems = '" . $changestr . "'";
		}
	}

	// check if it should log this transaction
	if ($action['loghistory'])
	{
		// if being forced, always add history
		if ($forcetype == true)
		{
			// add this to the user's history
			$userhistory = vbplaza_add_history($userinfo, $action);
		}
		else
		{
			// check if it is removing the history or not
			if ($action['removal'] == true)
			{
				// remove this purchase from the user's history
				$userhistory = vbplaza_remove_history($userinfo, $action);
			}
			else
			{
				// add this purchase to the user's history
				$userhistory = vbplaza_add_history($userinfo, $action);
			}
		}

		// add this to the query fields
		$queryfields[] = "vbp_history = '" . $vbulletin->db->escape_string($userhistory) . "'";
	}

	// check if it has any $extrafields to add to the query
	if (!empty($extrafields) && is_array($extrafields))
	{
		// process each $extrafields
		foreach($extrafields AS $field)
		{
			// verify that the field is not empty as well
			if (!empty($field))
			{
				// add this to the queryfields
				$queryfields[] = $field;
			}
		}
	}

	// build the querystr from the queryfields
	$querystr = implode(", ", $queryfields);

	// lastly, verify that $querystr is not empty and it should send the query
	if (!empty($querystr))
	{
		// send off the query to update this user
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
			SET
				" . $querystr . "
			WHERE userid = '" . $userinfo['userid'] . "'
		");
	}
}

// function to handle updating the quantity sold
function vbplaza_update_quantity_sold($action)
{
	global $vbulletin;

	// check if it should update the quantity too
	$updatequantity = '';
	if ($action['defquantity'] > 0)
	{
		// update the quantity
		$updatequantity = ", quantity = quantity - 1";
	}

	// send the query to update the vbplaza_item
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "vbplaza_item
		SET
			sold = sold + 1
			" . $updatequantity . "
		WHERE itemid = '" . $action['itemid'] . "'
	");

	// verify that the finalcost is set
	if (!is_numeric($action['finalcost'])) { $action['finalcost'] = 0; }

	// add this this purchase into the history
	$vbulletin->db->query_write("
		INSERT INTO " . TABLE_PREFIX . "vbplaza_itemhistory (historyid, itemid, itemname, userid, username, dateline, finalcost, extrainfo)
		VALUES
		(
			0,
			'" . $action['itemid'] . "',
			'" . $vbulletin->db->escape_string($action['name']) . "',
			'" . $vbulletin->userinfo['userid'] . "',
			'" . $vbulletin->db->escape_string($vbulletin->userinfo['username']) . "',
			'" . TIMENOW . "',
			'" . $action['finalcost'] . "',
			'" . $vbulletin->db->escape_string($action['extrainfo']) . "'
		)
	");

	// add the taxes to the vbbuxfederalbank
	if (is_numeric($action['federaltaxamount']) && ($action['finalcost'] > 0))
	{
		// update the datastore to update the vbbuxfederalbank amount
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "datastore
			SET
				data = data + " . $action['finalcost'] . "
			WHERE title = 'vbbuxfederalbank'
		");
	}
}

// function to update the datastore for the ribbons
function vbplaza_update_datastore_ribbons()
{
	global $vbulletin;

	// buiuld the $vbplazaribbons
	$vbplazaribbons = array();
	$ribbons = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbplaza_ribbonitem ORDER BY displayorder, name");
	while ($ribbon = $vbulletin->db->fetch_array($ribbons))
	{
		// cache this ribbonitem
		$vbplazaribbons["$ribbon[displayorder]"] = $ribbon;
	}

	// free the ribbons
	$vbulletin->db->free_result($ribbons);

	// serialize the data
	$vbplazaribbons = serialize($vbplazaribbons);

	// dump the data into the database
	$vbulletin->db->query_write("
		REPLACE INTO " . TABLE_PREFIX . "datastore (title, data)
		VALUES ('vbplazaribbons', '" . $vbulletin->db->escape_string($vbplazaribbons) . "')
	");
}

// function to handle updating the category / option cache
function vbplaza_update_datastore($forceupdate = false, $vbplazacategory = array(), $vbplazaoptions = array())
{
	global $vbulletin;

	// check if it should query the data first
	if ($forceupdate)
	{
		// build the vbplazacategorycache
		$vbplazacategory = array();
		$categories = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbplaza_category WHERE active = 1");
		while ($category = $vbulletin->db->fetch_array($categories))
		{
			// cache this category
			$vbplazacategory[$category['categoryid']] = $category;
		}

		// free the categories
		$vbulletin->db->free_result($categories);

		// build the vbplazaoptioncache
		$vbplazaoptions = array();
		$items = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbplaza_item WHERE active = 1");
		while ($item = $vbulletin->db->fetch_array($items))
		{
			// cache this item
			$vbplazaoptions[$item['itemid']] = $item;
		}

		// free the items
		$vbulletin->db->free_result($items);
	}

	// reserialize the data
	$vbplazacategory = serialize($vbplazacategory);
	$vbplazaoptions = serialize($vbplazaoptions);

	// dump the data into the database
	$vbulletin->db->query_write("
		REPLACE INTO " . TABLE_PREFIX . "datastore (title, data)
		VALUES
			('vbplazacategory', '" . $vbulletin->db->escape_string($vbplazacategory) . "'),
			('vbplazaoptions', '" . $vbulletin->db->escape_string($vbplazaoptions) . "')
	");
}

// function to quickly add points
function vbplaza_quick_add_points($userinfo, $givepoints, $extrafields)
{
	global $vbulletin;

	// add these points into the user's info
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
		SET
			`" . $vbulletin->options['vbbux_pointsfield'] . "` = `" . $vbulletin->options['vbbux_pointsfield'] . "` + " . $givepoints . "
			" . $extrafields . "
		WHERE userid = '" . $vbulletin->userinfo['userid'] . "'
	");
}

// function to quickly subtract points
function vbplaza_quick_subtract_points($userinfo, $givepoints, $extrafields)
{
	global $vbulletin;

	// verify the user has enough points first
	if (($userinfo[$vbulletin->options['vbbux_pointsfield']] - $givepoints) > 0)
	{
		// add these points into the user's info
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
			SET
				`" . $vbulletin->options['vbbux_pointsfield'] . "` = `" . $vbulletin->options['vbbux_pointsfield'] . "` - " . $givepoints . "
				" . $extrafields . "
			WHERE userid = '" . $vbulletin->userinfo['userid'] . "'
		");

		// return ok
		return true;
	}

	// return not ok
	return false;
}

// function to sort an array by fieldname
function vbplaza_sort_internal($array1, $array2)
{
	// return the result
	return strnatcmp($array1['displayorder'], $array2['displayorder']);
}

// function that will sort by display order
function vbplaza_sort_by_display_order($data)
{
	// call the usort function
	usort($data, 'vbplaza_sort_internal');

	// return the data
	return $data;
}

// function to construct the breadcrumbs
function vbplaza_construct_navbits($navitems)
{
	global $vbphrase;

	// add the default $navbits first
	$navbits = array('vbplaza.php?' . $vbulletin->session->vars['sessionurl'] => $vbphrase['vbplaza_name']);

	// add the rest of the navitems
	if (is_array($navitems))
	{
		// process each navitem
		foreach($navitems AS $key => $item)
		{
			// verify its not empty
			if (!empty($item))
			{
				// insert this into $navbits
				$navbits[$key] = $item;
			}
		}
	}

	// return the $navbits
	return $navbits;
}

// function to send a private message
function vbplaza_send_pm($fromuser, $touser, $title, $message)
{
	global $vbulletin, $permissions;

	// verify the $userid is valid
	if (!is_array($touser))
	{
		// fetch the userinfo for this userid
		$touser = fetch_userinfo($touser);

		// lastly check it found this user
		if (!is_numeric($touser['userid']) || !is_array($touser) || ($touser['userid'] == 0))
		{
			// simply return for now
			return 0;
		}
	}

	// check who it should send the PM from
	if (!is_array($fromuser) || ($fromuser['userid'] == 0))
	{
		// check if it knows who to send the PM from
		if (!$vbulletin->options['vbplaza_defaultpmuserid'])
		{
			// simply return for now
			return 0;
		}

		// fetch the userinfo for this userid
		$fromuser = fetch_userinfo($vbulletin->options['vbplaza_defaultpmuserid']);

		// lastly check it found this user
		if (!is_numeric($fromuser['userid']) || !is_array($fromuser) || ($fromuser['userid'] == 0))
		{
			// simply return for now
			return 0;
		}
	}

	// send the private message now
	$permissions['pmsendmax'] = 10;
	$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
	$pmdm->set('fromuserid', $fromuser['userid']);
	$pmdm->set('fromusername', $fromuser['username']);
	$pmdm->set('title', $title);
	$pmdm->set('message', $message);
	$pmdm->set_recipients($touser['username'], $permissions);
	$pmdm->set('dateline', TIMENOW);
	$pmdm->set('showsignature', 1);
	$pmdm->set_info('savecopy', 0);
	$pmdm->pre_save();

	// only save it if there are no errors
	if (empty($pmdm->errors))
	{
		// save the private message
		$pmdm->save();
	}

	// return that the PM was sent
	return 1;
}


// function to fix the serialized fields into proper format
function vbplaza_action_fixup_fields_settings($action)
{
	// simply unserialize the inputfields
	$action['inputfields'] = unserialize($action['inputfields']);

	// unserialize the option settings to process further
	$action['optionsettings'] = unserialize($action['optionsettings']);

	// verify that optionsettings is an array
	if (is_array($action['optionsettings']) && !empty($action['optionsettings']))
	{
		// process each variable here
		foreach($action['optionsettings'] AS $key => $optionsetting)
		{
			// verify that this $action['varname'] is already taken
			if (!isset($action[$optionsetting['varname']]))
			{
				// check if it should do anything to the value
				if ($optionsetting['type'] == '1')
				{
					// option value should be 0 or 1
					$optionsetting['value'] &= 1;
				}
				else if ($optionsetting['type'] == '2')
				{
					// option value should be a number
					$optionsetting['value'] = intval($optionsetting['value']);
				}

				// add this variable to the $action array
				$action[$optionsetting['varname']] = $optionsetting['value'];
			}
		}
	}

	// return the updated $action
	return $action;
}

// function to check if the user is flooding this option
function vbplaza_action_check_for_flood($action)
{
	global $vbulletin;

	// check if this action has a floodcheck time
	if ($action['floodcheck'] != 0)
	{
		// select the last time this user did this action
		$lastaction = $vbulletin->db->query_first("
			SELECT dateline
			FROM " . TABLE_PREFIX . "vbplaza_itemhistory
			WHERE itemid = '" . $action['itemid'] . "'
				AND userid = '" . $vbulletin->userinfo['userid'] . "'
			ORDER BY dateline DESC
			LIMIT 1
		");

		// check if the user is flooding
		if (TIMENOW < ($lastaction['dateline'] + $action['floodcheck']))
		{
			// set that they are flooding
			$action['flooding'] = true;

			// set the times to be displayed properly
			$action['lastusage'] = vbdate($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $lastaction['dateline']);
			$action['timenow'] = vbdate($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], TIMENOW);
			$action['nextusage'] = vbdate($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $lastaction['dateline'] + $action['floodcheck']);

			// display error, you can not purchase this item this often
			eval(standard_error(fetch_error('vbplaza_action_protected_flood_message', $action['lastusage'], $action['timenow'], $action['nextusage'])));
		}
	}

	// return the action
	return $action;
}

// function to check and refill any options that need to be refilled
function vbplaza_check_and_refill_options(&$vbplazaoptions)
{
	global $vbulletin;

	// verify $vbplazaoptions is an array
	if (is_array($vbplazaoptions))
	{
		// process each store option
		$updatedoptions = array();
		foreach($vbplazaoptions AS $itemid => $option)
		{
			// check if this item needs to be refilled
			if ($option['defquantity'] && (!$option['refilldateline'] || ($option['refilldateline'] < TIMENOW)))
			{
				// update this items quantity & refilldateline
				$vbplazaoptions[$itemid]['quantity'] = $vbplazaoptions[$itemid]['defquantity'];
				$vbplazaoptions[$itemid]['refilldateline'] = TIMENOW + $vbulletin->options['vbplaza_defaultrefillrate'];

				// add this option to $updatedoptions
				$updatedoptions[] = "itemid = '" . $itemid . "'";
			}
		}

		// check if there are any items to update
		if (!empty($updatedoptions))
		{
			// build the $wherestr
			$wherestr = implode(" OR ", $updatedoptions);

			// send off the query to refill the options
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "vbplaza_item
				SET
					quantity = defquantity,
					refilldateline = " . (TIMENOW + $vbulletin->options['vbplaza_defaultrefillrate']) . "
				WHERE
					" . $wherestr . "
			");

			// update the datastore
			vbplaza_update_datastore(true);
		}
	}
}

// function to auto fix the gift postbits
function vbplaza_rebuild_gift_postbit($userid)
{
	global $vbulletin, $vbphrase;

	// need to update this user's gift postbit
	$curgiftcount = 0;
	$curgifts = array();
	if ($gifts = $vbulletin->db->query_read("
		SELECT * FROM " . TABLE_PREFIX . "vbplaza_gift
		WHERE touserid = '" . $userid . "'
		ORDER BY giftid DESC
	"))
	{
		// start caching the gifts
		while ($gift = $vbulletin->db->fetch_array($gifts))
		{
			// check if it can still add this to the count
			if (($gift['visible'] == 1) && ($curgiftcount < $vbulletin->options['vbplaza_maxgiftsdisplayed']))
			{
				// trim the message
				$gift['message'] = trim($gift['message']);

				// check if the message is empty
				if (empty($gift['message']))
				{
					// set the message to no message
					$gift['message'] = $vbphrase['vbplaza_no_message'];
				}

				// add this gift into the array
				$curgifts[$gift['giftid']] = array(
					'giftid'	=>	$gift['giftid'],
					'giftname'	=>	$gift['giftname'],
					'userid'	=>	$gift['fromuserid'],
					'username'	=>	$gift['fromusername'],
					'message'	=>	$gift['message']
				);

				// increase $curgiftcount
				$curgiftcount++;
			}
		}

		// lastly sort the array
		ksort($curgifts);
	}

	// free the gifts
	$vbulletin->db->free_result($gifts);

	// serialize the gifts
	$curgifts = serialize($curgifts);

	// send off the query to update the vbp_gifts
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
		SET
			vbp_gifts = '" . $vbulletin->db->escape_string($curgifts) . "'
		WHERE userid = '" . $userid . "'
	");
}

// function to auto fix the ribbon postbits
function vbplaza_rebuild_ribbon_postbit($userid)
{
	global $vbulletin, $vbphrase;

	// need to update this user's ribbon postbit
	$curribboncount = 0;
	$curribbons = array();
	if ($ribbons = $vbulletin->db->query_read("
		SELECT * FROM " . TABLE_PREFIX . "vbplaza_ribbon
		WHERE touserid = '" . $userid . "'
		ORDER BY ribbonid DESC
	"))
	{
		// start caching the ribbons
		while ($ribbon = $vbulletin->db->fetch_array($ribbons))
		{
			// check if it can still add this to the count
			if (($ribbon['visible'] == 1) && ($curribboncount < $vbulletin->options['vbplaza_maxribbonsdisplayed']))
			{
				// trim the cause
				$ribbon['cause'] = trim($ribbon['cause']);

				// check if the cause is empty
				if (empty($ribbon['cause']))
				{
					// set the cause to no cause
					$ribbon['cause'] = $vbphrase['vbplaza_no_cause'];
				}

				// add this ribbon into the array
				$curribbons[$ribbon['ribbonid']] = array(
					'ribbonid'	=>	$ribbon['ribbonid'],
					'ribbonname'	=>	$ribbon['ribbonname'],
					'userid'	=>	$ribbon['fromuserid'],
					'username'	=>	$ribbon['fromusername'],
					'cause'		=>	$ribbon['cause'],
					'message'	=>	$ribbon['message']
				);

				// increase $curribboncount
				$curribboncount++;
			}
		}

		// lastly sort the array
		ksort($curribbons);
	}

	// free the ribbons
	$vbulletin->db->free_result($ribbons);

	// serialize the ribbons
	$curribbons = serialize($curribbons);

	// send off the query to update the vbp_ribbon
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
		SET
			vbp_ribbons = '" . $vbulletin->db->escape_string($curribbons) . "'
		WHERE userid = '" . $userid . "'
	");
}

// function to verify the usergroupid is proper
function vbplaza_verify_usergroupid($action)
{
	global $vbulletin;

	// verify that the usergroupid exists
	if (!is_numeric($action['usergroupid']))
	{
		// display error, invalid usergroupid
		eval(standard_error(fetch_error('vbplaza_invalid_usergroupid')));
	}

	// check the cache for this usergroup
	if (empty($vbulletin->usergroupcache[$action['usergroupid']]))
	{
		// display error, invalid usergroupid
		eval(standard_error(fetch_error('vbplaza_invalid_usergroupid')));
	}

	// return this usergroupinfo
	return $vbulletin->usergroupcache[$action['usergroupid']];
}

// function to verify the forumid is proper
function vbplaza_verify_forumid($action)
{
	global $vbulletin;

	// verify that the forumid exists
	if (!is_numeric($action['forumid']))
	{
		// display error, invalid forumid
		eval(standard_error(fetch_error('vbplaza_invalid_forumid')));
	}

	// check the cache for this forum
	if (empty($vbulletin->forumcache[$action['forumid']]))
	{
		// display error, invalid forumid
		eval(standard_error(fetch_error('vbplaza_invalid_forumid')));
	}

	// return this foruminfo
	return $vbulletin->forumcache[$action['forumid']];
}

// function to build the inputfields
function vbplaza_build_inputfields($action)
{
	global $vbulletin, $vbphrase, $tabledata, $extra_fields;

	// process all of the $action['inputfields']
	if (!empty($action['inputfields']) && is_array($action['inputfields']))
	{
		// start processing the fields
		foreach($action['inputfields'] AS $inputfield)
		{
			// verify this is a valid field
			if (!empty($inputfield['inputname']))
			{
				// check if inputvalue has a comma in it (if it does, it's a select instead of input)
				if (strchr($inputfield['inputvalue'], ','))
				{
					// build the $action['options']
					$action['options'] = '';
					$options = explode(",", $inputfield['inputvalue']);
					foreach($options AS $option)
					{
						// check if its set for this user
						if ($tabledata[$action['setname']] == $option)
						{
							// add this option selected
							$action['options'] .= "<option value=\"" . $option . "\" selected=\"selected\">" . $option . "</option>";
						}
						else
						{
							// add this option unselected
							$action['options'] .= "<option value=\"" . $option . "\">" . $option . "</option>";
						}
					}

					// build the $extra_fields
					$action['phrasename'] = $vbphrase[$inputfield['phrasename']];
					$action['fieldname'] = $inputfield['inputname'];
					eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_select') . '";');
				}
				else
				{
					// try to autofill the inputvalue if its empty
					if (empty($inputfield['inputvalue']) && !empty($tabledata[$action['setname']]))
					{
						// set the fieldvalue to this tabledata value
						$action['fieldvalue'] = $tabledata[$action['setname']];
					}
					else
					{
						// set the fieldvalue to the inputvalue
						$action['fieldvalue'] = $inputfield['inputvalue'];
					}

					// build the $extra_fields
					$action['phrasename'] = $vbphrase[$inputfield['phrasename']];
					$action['fieldname'] = $inputfield['inputname'];
					eval('$extra_fields .= "' . fetch_template('vbplaza_item_extra_input') . '";');
				}
			}
		}
	}

	// return the $action
	return $action;
}

// function to fixup the extraname
function vbplaza_fixup_extraname($history)
{
	global $vbulletin, $vbphrase;

	// check if the 'userid' field is set
	if (!empty($history['touserid']))
	{
		// check if the touserid is you
		if ($vbulletin->userinfo['userid'] != $history['touserid'])
		{
			// update the itemname to indicate it was sent to someone else
			$history['extraname'] = " " . $vbphrase['vbplaza_to'] . " <a href=\"member.php?u=" . $history['touserid'] . "\">" . $history['tousername'] . "</a>";
		}
	}
	else if (!empty($history['fromuserid']))
	{
		// check if the fromuserid is you
		if ($vbulletin->userinfo['userid'] != $history['fromuserid'])
		{
			// update the itemname to indicate it was sent to you
			$history['extraname'] = " " . $vbphrase['vbplaza_from'] . " <a href=\"member.php?u=" . $history['fromuserid'] . "\">" . $history['fromusername'] . "</a>";
		}
	}
	else if (!empty($history['threadid']))
	{
		// add the threadid to the itemname
		$history['extraname'] = " (" . $vbphrase['vbplaza_threadid'] . ": <a href=\"showthread.php?t=" . $history['threadid'] . "\">" . $history['threadid'] . "</a>)";
	}
	else if (!empty($history['forumid']))
	{
		// add the threadid to the itemname
		$history['extraname'] = " (" . $vbphrase['vbplaza_forumid'] . ": " . $history['forumid'] . ")";
	}
	else if (!empty($history['usergroupid']))
	{
		// add the threadid to the itemname
		$history['extraname'] = " (" . $vbphrase['vbplaza_usergroupid'] . ": " . $history['usergroupid'] . ")";
	}

	// return the $history
	return $history;
}

// function to draw a lottery winner
function vbplaza_draw_lottery_winner($lotteryid = 0)
{
	global $vbulletin, $vbphrase, $winners;

	// check if it is drawing a particular lottery
	if ($lotteryid > 0)
	{
		// check if it has found any lotteries that should be over
		$endlotteries = array();
		$lotteries = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "vbplaza_lottery
			WHERE lotteryid = '" . $lotteryid . "'
		");
		while ($lottery = $vbulletin->db->fetch_array($lotteries))
		{
			// add this lottery to the ones that should end
			$endlotteries[] = $lottery;
		}
	}
	else
	{
		// check if it has found any lotteries that should be over
		$endlotteries = array();
		$lotteries = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "vbplaza_lottery
			WHERE (active = 1)
				AND
				(
					((enddateline > 0) AND (enddateline < " . TIMENOW . "))
					OR
					((mintickets > 0) AND (ticketssold >= mintickets))
				)
		");
		while ($lottery = $vbulletin->db->fetch_array($lotteries))
		{
			// add this lottery to the ones that should end
			$endlotteries[] = $lottery;
		}
	}

	// check if it has found any lotteries that are over
	$lotteries_processed = 0;
	if (is_array($endlotteries) && !empty($endlotteries))
	{
		// process each of the lotteries to end
		$winners = '';
		foreach($endlotteries AS $lottery)
		{
			// verify this lotteryid is valid
			if (is_numeric($lottery['lotteryid']))
			{
				// get the total amount of tickets found in this lottery
				$tickets = $vbulletin->db->query_first("
					SELECT COUNT(*) AS count
					FROM " . TABLE_PREFIX . "vbplaza_lotteryticket
					WHERE lotteryid = '" . $lottery['lotteryid'] . "'
				");

				// check that it found some tickets
				if (is_numeric($tickets['count']) && ($tickets['count'] > 0))
				{
					// try to find a winner
					$winner = $vbulletin->db->query_first("
						SELECT *
						FROM " . TABLE_PREFIX . "vbplaza_lotteryticket
						WHERE lotteryid = '" . $lottery['lotteryid'] . "'
						LIMIT " . rand(0, $tickets['count']) . ", 1
					");

					// verify that it has found a winner
					if (!is_numeric($winner['userid']))
					{
						// try once more to find a winner
						$winner = $vbulletin->db->query_first("
							SELECT *
							FROM " . TABLE_PREFIX . "vbplaza_lotteryticket
							WHERE lotteryid = '" . $lottery['lotteryid'] . "'
							LIMIT " . rand(0, $tickets['count'] - 1) . ", 1
						");
					}

					// check that it has found a winner
					if (is_numeric($winner['userid']))
					{
						// calculate the totalwinnings
						$lottery['totalwinnings'] = $lottery['jackpot'] * ((100 - $lottery['winningtax']) / 100);

						// fetch the userinfo about this user
						$userinfo = fetch_userinfo($winner['userid']);

						// get the permissions for the user found
						$userinfo['permissions'] = cache_permissions($userinfo);

						// format the winnings properly
						$lottery['totalwon'] = vb_number_format($lottery['totalwinnings'], $vbulletin->options['vbbux_decimalplaces']);

						// build the title/message for the lottery winner now
						$title = $vbphrase['vbplaza_you_have_won_the_lottery'];
						$message = construct_phrase($vbphrase['vbplaza_you_have_hit_the_jackpot'], $lottery['totalwon'], $vbphrase['vbbux_points']);

						// send a private message to the user that they have won the lottery
						vbplaza_send_pm(0, $userinfo, $title, $message);

						// add this user to the list of winners found
						if (!empty($winners)) { $winners .= ", "; }
						else { $winners .= "Winners: "; }
						$winners .= $userinfo['username'];

						// give the points to the winner
						$vbulletin->db->query_write("
							UPDATE " . TABLE_PREFIX . $vbulletin->options['vbbux_pointstable'] . "
							SET " . $vbulletin->options['vbbux_pointsfield'] . " = " . $vbulletin->options['vbbux_pointsfield'] . " + " . $lottery['totalwinnings'] . "
							WHERE userid = '" . $winner['userid'] . "'
						");

						// insert the winner into the winners table
						$vbulletin->db->query_write("
							INSERT INTO " . TABLE_PREFIX . "vbplaza_lotterywinner (winnerid, lotteryname, userid, username, dateline, jackpot, amountwon, ipaddress)
							VALUES
							(
								0,
								'" . $vbulletin->db->escape_string($lottery['name']) . "',
								'" . $winner['userid'] . "',
								'" . $vbulletin->db->escape_string($winner['username']) . "',
								" . TIMENOW . ",
								" . $lottery['jackpot'] . ",
								" . $lottery['totalwinnings'] . ",
								'" . $vbulletin->db->escape_string($winner['ipaddress']) . "'
							)
						");

						// increase $lotteries_processed
						$lotteries_processed++;
					}

					// delete all of the tickets for this lottery
					$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "vbplaza_lotteryticket WHERE lotteryid = '" . $lottery['lotteryid'] . "'");
				}

				// check if this lottery is recurring
				if ($lottery['recurring'])
				{
					// send the lottery's new enddateline
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "vbplaza_lottery SET ticketssold = 0, jackpot = startingjackpot, enddateline = enddateline + " . $lottery['timeactive'] . " WHERE lotteryid = '" . $lottery['lotteryid'] . "'");
				}
				else
				{
					// set the lottery to not be active anymore
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "vbplaza_lottery SET active = 0, ticketssold = 0, jackpot = startingjackpot, enddateline = 0 WHERE lotteryid = '" . $lottery['lotteryid'] . "'");
				}
			}
		}
	}

	// return the amount of lotteries processed
	return $lotteries_processed;
}

// function to handle specific cases for expired items
function vbplaza_expire_item($userinfo, $history, $vbplazaoptions)
{
	global $vbulletin;

	// setup some easier to access variables
	$tablename = $vbplazaoptions[$history['itemid']]['tablename'];
	$settype = $vbplazaoptions[$history['itemid']]['settype'];
	$setname = $vbplazaoptions[$history['itemid']]['setname'];
	$setvalue = $vbplazaoptions[$history['itemid']]['setvalue'];
	$wherename = $vbplazaoptions[$history['itemid']]['wherename'];
	$wherevalue = $vbplazaoptions[$history['itemid']]['wherevalue'];
	$scriptlocation = $vbplazaoptions[$history['itemid']]['scriptlocation'];

	// clear out the query variables
	$queryfields = array();
	$wherefields = array();

	// try to process this action
	if (empty($scriptlocation))
	{
		// verify the setname
		$setname = vbplaza_verify_set_name($action, $setname);

		// verify the setvalue
		$setvalue = vbplaza_verify_set_value($action, $setvalue);

		// verify the wherename
		$wherename = vbplaza_verify_where_name($action, $wherename);

		// verify the wherevalue
		$wherevalue = vbplaza_verify_where_value($action, $wherevalue);

		// verify that all fields are entered
		if (!empty($tablename) && !empty($setname) && !empty($setvalue) && !empty($wherename) && !empty($wherevalue))
		{
			// setup the $wherefields
			$wherefields[] = $wherename . " = '" . $wherevalue . "'";

			// process the settype
			switch($settype)
			{
				// process an input field
				case(1):
				{
					// build the query field to set
					$queryfields[] = $setname . " = ''";
					break;
				}
				// process a flags field
				case(2):
				{
					// build the query field to set
					$queryfields[] = $setname . " = (" . $setname . " & " . (-1 ^ $setvalue) . ")";
					break;
				}
				// process an add integer field
				case(3):
				{
					// build the query field to set
					$queryfields[] = $setname . " = (" . $setname . " - " . $setvalue . ")";
					break;
				}
			}
		}
	}
	else
	{
		// here is where to expire any custom options
		switch($history['itemid'])
		{
			// expire custom user title
			case(14):
			{
				// setup the fields to expire
				$queryfields[] = "usertitle = '" . addslashes($userinfo['displayusertitle']) . "'";
				$wherefields[] = "userid = '" . $userinfo['userid'] . "'";
				break;
			}
			// expire change others custom user title
			case(15):
			{
				// check if this is the right user to remove the option from
				if (is_numeric($history['fromuserid']))
				{
					// setup the fields to expire
					$queryfields[] = "usertitle = '" . addslashes($userinfo['displayusertitle']) . "'";
					$wherefields[] = "userid = '" . $userinfo['userid'] . "'";
				}
				break;
			}
			// expire sticky thread option
			case(19):
			{
				// verify it has a threadid
				if (is_numeric($history['threadid']))
				{
					// setup the fields to expire
					$queryfields[] = "sticky = '0'";
					$wherefields[] = "threadid = '" . $history['threadid'] . "'";
				}
				break;
			}
			// expire unsticky thread option
			case(20):
			{
				// verify it has a threadid
				if (is_numeric($history['threadid']))
				{
					// setup the fields to expire
					$queryfields[] = "sticky = '1'";
					$wherefields[] = "threadid = '" . $history['threadid'] . "'";
				}
				break;
			}
			// expire close thread option
			case(22):
			{
				// verify it has a threadid
				if (is_numeric($history['threadid']))
				{
					// setup the fields to expire
					$queryfields[] = "open = '1'";
					$wherefields[] = "threadid = '" . $history['threadid'] . "'";
				}
				break;
			}
			// expire open thread option
			case(23):
			{
				// verify it has a threadid
				if (is_numeric($history['threadid']))
				{
					// setup the fields to expire
					$queryfields[] = "open = '0'";
					$wherefields[] = "threadid = '" . $history['threadid'] . "'";
				}
				break;
			}
			// expire forum access
			case(24):
			{
				break;
			}
			// expire deny forum access
			case(25):
			{
				break;
			}
			// expire give forum access
			case(26):
			{
				break;
			}
			// expire give gifts
			case(27):
			{
				// verify it has a giftid
				if ($history['giftid'] > 0)
				{
					// delete this gift from the vbplaza_gift table
					$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "vbplaza_gift WHERE giftid = '" . $history['giftid'] . "'");

					// now rebuild the user's gift postbits
					vbplaza_rebuild_gift_postbit($userinfo['userid']);
				} 
				break;
			}
			// expire secondary usergroup
			case(32):
			{
				// verify it has an usergroupid
				if ($history['usergroupid'] > 0)
				{
					// check if there are any membergroupids
					$usermembergroups = array();
					if (!empty($userinfo['membergroupids']))
					{
						// expand the membergroupids
						$usermembergroups = explode(",", $userinfo['membergroupids']);
					}

					// verify its an array
					if (is_array($usermembergroups))
					{
						// process all of the usergroups
						foreach($usermembergroups AS $index => $usergroup)
						{
							// check if this is the usergroup to delete
							if ($history['usergroupid'] == $usergroup)
							{
								// remove this from the $usermembergroups
								unset($usermembergroups[$index]);								
							}
						}

						// check if there are any $usermembergroups left
						$newmembergroups = '';
						if (!empty($usermembergroups))
						{
							// implode the membergroupids
							$newmembergroups = implode(",", $usermembergroups);
						}

						// setup the fields to expire
						$queryfields[] = "membergroupids = '" . $newmembergroups . "'";
						$wherefields[] = "userid = '" . $userinfo['userid'] . "'";
					}
				}
				break;
			}
			// expire primary usegroup
			case(34):
			{
				// verify some things
				if (!empty($userinfo['vbp_oldgroups']) && ($history['usergroupid'] > 0))
				{
					// unserialize the data
					$oldgroups = unserialize($userinfo['vbp_oldgroups']);
					if (is_array($oldgroups))
					{
						// sort the array in reverse
						krsort($oldgroups);

						// verify that $oldgroup is valid
						if (is_array($oldgroups))
						{
							// process all of the $oldgroups
							foreach($oldgroups AS $oldgroupid => $oldgroup)
							{
								// check if this is the one we want
								if ($oldgroup['dateline'] == $history['dateline'])
								{
									// setup the field to set
									$queryfields[] = "usergroupid = '" . $oldgroup['usergroupid'] . "'";
									$wherefields[] = "userid = '" . $userinfo['userid'] . "'";
									break;
								}
							}
						}
					}
				}
				break;
			}
			// expire default avatar
			case(37):
			{
				// setup the fields to expire
				$queryfields[] = "avatarid = '0'";
				$wherefields[] = "userid = '" . $userinfo['userid'] . "'";
				break;
			}
			// expire change others default avatar
			case(38):
			{
				// check if this is the right user to remove the option from
				if (is_numeric($history['fromuserid']))
				{
					// setup the fields to expire
					$queryfields[] = "avatarid = '0'";
					$wherefields[] = "userid = '" . $userinfo['userid'] . "'";
				}
				break;
			}
			// expire awareness ribbons
			case(118):
			{
				// verify it has a ribbonid
				if ($history['ribbonid'] > 0)
				{
					// delete this ribbon from the vbplaza_ribbon table
					$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "vbplaza_ribbon WHERE ribbonid = '" . $history['ribbonid'] . "'");

					// now rebuild the user's ribbon postbits
					vbplaza_rebuild_ribbon_postbit($userinfo['userid']);
				} 
				break;
			}
			// expire arcade pass
			case(123):
			{
				// setup the fields to expire
				$queryfields[] = "vbp_arcadepass = '0'";
				$wherefields[] = "userid = '" . $userinfo['userid'] . "'";
				break;
			}
			// expire arcade access
			case(124):
			{
				// setup the fields to expire
				$queryfields[] = "vbp_otherflags = (vbp_otherflags & " . (-1 ^ $vbulletin->bf_misc_vbpotherflags['arcadeaccess']) . ")";
				$wherefields[] = "userid = '" . $userinfo['userid'] . "'";
				break;
			}
			// expire bold thread title
			case(129):
			{
				// setup the fields to expire
				$queryfields[] = "vbp_titledisplayflags = (vbp_titledisplayflags & " . (-1 ^ $vbulletin->bf_misc_vbptitledisplayflags['boldthreadtitle']) . ")";
				$wherefields[] = "threadid = '" . $history['threadid'] . "'";
				break;
			}
			// expire italic thread title
			case(130):
			{
				// setup the fields to expire
				$queryfields[] = "vbp_titledisplayflags = (vbp_titledisplayflags & " . (-1 ^ $vbulletin->bf_misc_vbptitledisplayflags['italicthreadtitle']) . ")";
				$wherefields[] = "threadid = '" . $history['threadid'] . "'";
				break;
			}
			// expire underline thread title
			case(131):
			{
				// setup the fields to expire
				$queryfields[] = "vbp_titledisplayflags = (vbp_titledisplayflags & " . (-1 ^ $vbulletin->bf_misc_vbptitledisplayflags['underlinethreadtitle']) . ")";
				$wherefields[] = "threadid = '" . $history['threadid'] . "'";
				break;
			}
			// expire colored thread title
			case(132):
			{
				// setup the fields to expire
				$queryfields[] = "vbp_titletextcolor = ''";
				$wherefields[] = "threadid = '" . $history['threadid'] . "'";
				break;
			}
			// expire glow thread title
			case(133):
			{
				// setup the fields to expire
				$queryfields[] = "vbp_titleglowcolor = ''";
				$wherefields[] = "threadid = '" . $history['threadid'] . "'";
				break;
			}
			// expire shadow thread title
			case(134):
			{
				// setup the fields to expire
				$queryfields[] = "vbp_titleshadowcolor = ''";
				$wherefields[] = "threadid = '" . $history['threadid'] . "'";
				break;
			}
			// expire thread title font type
			case(135):
			{
				// setup the fields to expire
				$queryfields[] = "vbp_titlefonttype = ''";
				$wherefields[] = "threadid = '" . $history['threadid'] . "'";
				break;
			}
			// default case for not handled actions
			default:
			{
				($hook = vBulletinHook::fetch_hook('vbplaza_expire_item_not_found')) ? eval($hook) : false;
				break;
			}
		}
	}

	// check if it can send off the query
	if (!empty($tablename) && !empty($queryfields) && !empty($wherefields))
	{
		// build the $querystr
		$querystr = implode(", ", $queryfields);

		// build the $wherestr
		$wherestr = implode(" OR ", $wherefields);

		// send off the query
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . $tablename . "
			SET " . $querystr . "
			WHERE " . $wherestr . "			
		");

		// return that the item was expired successfully
		return 1;
	}

	// return that the item was not expired successfully
	return 0;
}
?>