<?php
/*======================================================================*\
|| #################################################################### ||
|| # vbPlaza Integrated Store System for vBulletin 3.5+               # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2006 GSCCC, Inc.                   # ||
|| # http://www.cmgsccc.com                                           # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'vbplaza_lottery');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('vbplaza', 'forum', 'cpuser', 'cpoption');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_vbplaza.php');

// ############################# LOG ACTION ###############################
log_admin_action();

// check if the admin requires super administrator access for 'lottery'
// NOTE: To enable this enter the below line into your config.php
// $config['vbPlaza']['lottery']['requiresuperadmin'] = true;
if ($vbulletin->config['vbPlaza']['lottery']['requiresuperadmin'])
{
	// check if the user is a super administrator
	$userids = explode(',', str_replace(' ', '', $vbulletin->config['SpecialUsers']['superadministrators']));
	if (!in_array($vbulletin->userinfo['userid'], $userids))
	{
		print_stop_message('vbplaza_no_permission_admin_lottery');
	}
}

// cache the vbplazalotteries
$vbplazalotteries = array();
if ($lotteries = $vbulletin->db->query_read("
	SELECT *
	FROM " . TABLE_PREFIX . "vbplaza_lottery
	ORDER BY lotteryid
"))
{
	// start processing the items
	while ($lottery = $vbulletin->db->fetch_array($lotteries))
	{
		// cache this item
		$vbplazalotteries[$lottery[lotteryid]] = $lottery;
	}
}

// free the $lotteries
$vbulletin->db->free_result($lotteries);

// display the header
print_cp_header('vbPlaza Lottery v' . $vbulletin->options['vbplaza_version'] . ' Admin');

// check if an action is set
if (!isset($_REQUEST['do']))
{
	// force it to list the lotterys
	$_REQUEST['do'] = 'lotterylist';
}

// try to insert a new lottery
if ($_POST['do'] == 'insertlottery')
{
	// look for a valid lotteryid to use for insertion
	for ($lotteryid = 11; $lotteryid < 10000; $lotteryid++)
	{
		// check if this lottery exists already
		if (empty($vbplazalotteries[$lotteryid]))
		{
			// break out of this for loop
			break;
		}
	}

	// verify that some fields were given for sure
	if (empty($_POST['lottery']['name']))
	{
		// display message that you did not enter an lottery name
		print_form_header('vbplaza_lottery', 'addlottery');
		print_table_header("<font size=3>" . construct_phrase($vbphrase['vbplaza_add_new_x'], $vbphrase['vbplaza_lottery']) . "</font>", 2);
		print_description_row(construct_phrase($vbphrase['vbplaza_add_no_x_name'], $vbphrase['vbplaza_lottery']));
		print_table_footer(2, "");
	}
	else if (empty($_POST['lottery']['description']))
	{
		// display message that you did not enter an lottery name
		print_form_header('vbplaza_lottery', 'addlottery');
		print_table_header("<font size=3>" . construct_phrase($vbphrase['vbplaza_add_new_x'], $vbphrase['vbplaza_lottery']) . "</font>", 2);
		print_description_row(construct_phrase($vbphrase['vbplaza_add_no_x_description'], $vbphrase['vbplaza_lottery']));
		print_table_footer(2, "");
	}
	else
	{
		// fixup the proper enddateline
		$_POST['lottery']['enddateline'] = TIMENOW + $_POST['lottery']['timeactive'];

		// start building the querystr
		$querystr = '';
		foreach($_POST['lottery'] AS $key => $field)
		{
			// check if it needs to add a comma
			if (!empty($querystr)) { $querystr .= ", "; }

			// check if this key is the allowedgroups
			if (($key == 'allowedgroups') || ($key == 'deniedgroups'))
			{
				// check if $field is an array
				$usergroups = '';
				if (is_array($field))
				{
					// process all of the groups
					foreach($field AS $usergroupid)
					{
						// check if $usergroups is not empty
						if (!empty($usergroups)) { $usergroups .= ","; }
						$usergroups .= $usergroupid;
					}
				}

				// reset the $field
				$field = $usergroups;
			}

			// add this field to the query
			$querystr .= $key . " = '" . addslashes($field) . "'";
		}

		// first insert the new lottery into the database
		$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "vbplaza_lottery (lotteryid) VALUES ('" . $lotteryid . "')");

		// now send the query to update the fields properly
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "vbplaza_lottery
			SET
				" . $querystr . "
			WHERE lotteryid = '" . $lotteryid . "'
		");

		// do the redirect now
		define('CP_REDIRECT', 'vbplaza_lottery.php?do=lotterylist');
		print_stop_message('saved_settings_successfully');
	}
}

// check if its updating a lottery
if ($_POST['do'] == 'updatelottery')
{
	// check if its deleting an option
	if (isset($_POST['delete']))
	{
		// verify the lottery is deletable
		if (is_numeric($_POST['lotteryid']) && ($_POST['lotteryid'] >= 11))
		{
			// delete all of the tickets purchased for this lottery
			$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "vbplaza_lotteryticket WHERE lotteryid = '" . $_POST['lotteryid'] . "'");

			// delete this lottery from the vbp_lottery table
			$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "vbplaza_lottery WHERE lotteryid = '" . $_POST['lotteryid'] . "'");
		}
	}
	else
	{
		// update the lottery's settings
		require_once(DIR . '/includes/functions_misc.php');
		if (is_numeric($_POST['lotteryid']) && is_array($_POST['lottery']))
		{
			// build the querystr
			$querstr = '';
			foreach($_POST['lottery'] AS $key => $field)
			{
				// check if it should add a comma
				if (isset($querystr)) { $querystr .= ", "; }

				// check if this key is the enddateline
				if ($key == 'enddateline')
				{
					// rebuild the unix time stamp
					$field = vbmktime($field['hour'], $field['minute'], $field['second'], $field['month'], $field['day'], $field['year']);

					// verify that the $field is valid
					if ($field < 0)
					{
						// force it to the current time
						$field = TIMENOW;
					}
				}

				// check if this key is the allowedgroups
				if (($key == 'allowedgroups') || ($key == 'deniedgroups'))
				{
					// check if $field is an array
					$usergroups = '';
					if (is_array($field))
					{
						// process all of the groups
						foreach($field AS $usergroupid)
						{
							// check if $usergroups is not empty
							if (!empty($usergroups)) { $usergroups .= ","; }
							$usergroups .= $usergroupid;
						}
					}

					// reset the $field
					$field = $usergroups;
				}

				// add this field
				$querystr .= "$key = '" . addslashes($field) . "'";
			}

			// if there is a querystr, run it
			if (isset($querystr))
			{
				// send the query to update
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "vbplaza_lottery
					SET
						" . $querystr . "
					WHERE lotteryid = '" . $_POST['lotteryid'] . "'
				");
			}
		}
	}

	// do the redirect now
	define('CP_REDIRECT', 'vbplaza_lottery.php?do=lotterylist');
	print_stop_message('saved_settings_successfully');
}

// check if its doing a quick update
if ($_POST['do'] == 'quickupdate')
{
	// check that order is an array
	if (is_array($_POST['ticketcost']) && is_array($_POST['jackpot']) && is_array($_POST['winningtax']) && is_array($_POST['ticketssold']))
	{
		// process all of the vbplazalotteries
		$lotteries = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbplaza_lottery");
		while ($lottery = $vbulletin->db->fetch_array($lotteries))
		{
			// check if this data is true
			if (!isset($_POST['ticketcost']["$lottery[lotteryid]"]))
			{
				continue;
			}

			// send the query to update
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "vbplaza_lottery
				SET
					ticketcost = '" . $_POST['ticketcost']["$lottery[lotteryid]"] . "',
					jackpot = '" . $_POST['jackpot'][$lottery[lotteryid]] . "',
					winningtax = '" . $_POST['winningtax'][$lottery[lotteryid]] . "',
					ticketssold = '" . $_POST['ticketssold']["$lottery[lotteryid]"] . "',
					active = '" . $_POST['active']["$lottery[lotteryid]"] . "'
				WHERE lotteryid = '" . $lottery['lotteryid'] . "'
			");
		}

		// free the $lotteries
		$vbulletin->db->free_result($lotteries);
	}

	// do the redirect now
	define('CP_REDIRECT', 'vbplaza_lottery.php?do=lotterylist');
	print_stop_message('saved_settings_successfully');
}

// check if its searching the lottery winners
if ($_REQUEST['do'] == 'searchlotterywinners')
{
	// build the search terms if any
	$searchterms = array();
	if (is_numeric($_REQUEST['userid']))
	{
		// add this to the search terms
		$searchterms[] = "userid = '" . $_REQUEST['userid'] . "'";
	}
	if (!empty($_REQUEST['username']))
	{
		// add this to the search terms
		$searchterms[] = "username LIKE '%" . $vbulletin->db->escape_string($_REQUEST['username']) . "%'";
	}

	// check if there are any searchterms
	if (!empty($searchterms))
	{
		// implode the string
		$wherestr = "WHERE " . implode(" OR ", $searchterms);
	}

	// verify that $_REQUEST['page'] is set
	$perpage = 50;
	if (!is_numeric($_REQUEST['page'])) { $_REQUEST['page'] = 1; }

	// setup the $limitstr
	if ($_REQUEST['page'] > 1)
	{
		// setup the $skip start
		$skip = $perpage * ($_REQUEST['page'] - 1);

		// update the $limitstr properly
		$limitstr = "LIMIT $skip, $perpage";
	}
	else
	{
		// set $skip to be 1
		$skip = 1;

		// update the $limitstr properly
		$limitstr = "LIMIT 0, $perpage";
	}

	// check out how many items are found like this
	$itemhistory = $vbulletin->db->query_first("
		SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "vbplaza_lotterywinner
		" . $wherestr . "
	");

	// check if any rows were found
	if ($itemhistory['count'] > 0)
	{
		// build the total page
		$totalpages = ceil($itemhistory['count'] / $perpage);

		// select the rows from the database
		$winners = $vbulletin->db->query_read("
			SELECT * FROM " . TABLE_PREFIX . "vbplaza_lotterywinner
			" . $wherestr . "
			ORDER BY dateline DESC
			" . $limitstr . "
		");

		// process each winner
		$winnercache = array();
		while ($winner = $vbulletin->db->fetch_array($winners))
		{
			// cache this winner
			$winnercache["$winner[winnerid]"] = $winner;
		}

		// free the $winners
		$vbulletin->db->free_result($winners);

		// check if its not the first page
		if ($_REQUEST['page'] != 1)
		{
			$prv = $_REQUEST['page'] - 1;
			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['first_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbplaza_lottery.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchlotterywinners&itemid=" . $_REQUEST['itemid'] . "&itemname=" . $_REQUEST['itemname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=1'\">";
			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['prev_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbplaza_lottery.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchlotterywinners&itemid=" . $_REQUEST['itemid'] . "&itemname=" . $_REQUEST['itemname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$prv'\">";
		}
		if ($_REQUEST['page'] != $totalpages)
		{
			$nxt = $_REQUEST['page'] + 1;
			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['next_page'] . " &gt;\" tabindex=\"1\" onclick=\"window.location='vbplaza_lottery.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchlotterywinners&itemid=" . $_REQUEST['itemid'] . "&itemname=" . $_REQUEST['itemname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$nxt'\">";
			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['last_page'] . " &raquo;\" tabindex=\"1\" onclick=\"window.location='vbplaza_lottery.php?" . $vbulletin->session->vars['sessionurl'] . "do=searchlotterywinners&itemid=" . $_REQUEST['itemid'] . "&itemname=" . $_REQUEST['itemname'] . "&userid=" . $_REQUEST['userid'] . "&username=" . $_REQUEST['username'] . "&page=$totalpages'\">";
		}

		// display message that the refill was successful
		print_form_header('vbplaza_lottery', 'searchlotterywinners');
		print_description_row(construct_link_code($vbphrase['restart'], "vbplaza_lottery.php?do=lotterywinners"), 0, 5, 'thead', $stylevar['right']);
		print_table_header("<font size=3>" . $vbphrase['vbplaza_search_lottery_winners'] . "</font>", 5);
		print_cells_row(array($vbphrase['vbplaza_winner_id'], $vbphrase['vbplaza_lottery_name'], $vbphrase['vbplaza_lottery_winner'], $vbphrase['vbplaza_jackpot'], $vbphrase['vbplaza_lottery_date_won']), 1, 'tcat');

		// process each winnercache
		foreach($winnercache AS $winnerid => $winner)
		{
			// clear out the cells
			$cell = array();

			// setup and display the cells
			$cell[] = $winner['winnerid'];
			$cell[] = $winner['lotteryname'];
			$cell[] = $winner['username'];
			$cell[] = $winner['jackpot'];
			$cell[] = vbdate($vbulletin->options['dateformat'] . ', ' . $vbulletin->options['timeformat'], $winner['dateline']);
			print_cells_row($cell);
		}

		// finish off the footer
		print_table_footer(5, "$firstpage $prevpage &nbsp; $nextpage $lastpage");
	}
	else
	{
		// display message that nothing was found
		print_form_header('vbplaza_lottery', 'searchlotterywinners');
		print_table_header("<font size=3>" . $vbphrase['vbplaza_search_lottery_winners'] . "</font>", 2);
		print_description_row($vbphrase['vbplaza_no_lottery_winners_found']);
		print_table_footer(2, "");
	}
}

// check if its adding a lottery
if ($_REQUEST['do'] == 'addlottery')
{
	// cache the lottery
	$lottery = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_lottery WHERE lotteryid = '" . $_REQUEST['lotteryid'] . "'");
	print_form_header('vbplaza_lottery', 'insertlottery');
	print_table_header("<font size=3>" . construct_phrase($vbphrase['vbplaza_add_new_x'], $vbphrase['vbplaza_lottery']) . "</font>", 2);
	print_yes_no_row($vbphrase['vbplaza_active'], 'lottery[active]', '1');
	print_yes_no_row($vbphrase['vbplaza_lottery_recurring'], 'lottery[recurring]', '1');
	print_yes_no_row($vbphrase['vbplaza_lottery_ticket_builds_jackpot'], 'lottery[ticketbuild]', '0');
	print_input_row($vbphrase['vbplaza_time_active'], 'lottery[timeactive]', '604800');
	print_input_row($vbphrase['vbplaza_ticket_price'], 'lottery[ticketcost]', '1000');
	print_input_row($vbphrase['vbplaza_starting_jackpot_amount'], 'lottery[startingjackpot]', '10000');
	print_input_row($vbphrase['vbplaza_jackpot_amount'], 'lottery[jackpot]', '10000');
	print_input_row($vbphrase['vbplaza_winning_tax'], 'lottery[winningtax]', '2.5');
	print_input_row($vbphrase['vbplaza_max_tickets_per_user'], 'lottery[maxticketperuser]', '5');
	print_input_row($vbphrase['vbplaza_maximum_tickets'], 'lottery[maxtickets]', 0);
	print_input_row($vbphrase['vbplaza_minimum_tickets'], 'lottery[mintickets]', 0);
	print_input_row($vbphrase['vbplaza_tickets_sold'], 'lottery[ticketssold]', '0');
	print_input_row($vbphrase['vbplaza_lottery_name'], 'lottery[name]', '');
	print_textarea_row(construct_phrase($vbphrase['vbplaza_x_description'], $vbphrase['vbplaza_lottery']), 'lottery[description]', '');
	print_membergroup_row($vbphrase['vbplaza_allowed_groups'], 'lottery[allowedgroups]', 2);
	print_membergroup_row($vbphrase['vbplaza_denied_groups'], 'lottery[deniedgroups]', 2);
	print_input_row($vbphrase['vbplaza_lottery_image_location'], 'lottery[imagelocation]', '');
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . construct_phrase($vbphrase['vbplaza_add_new_x'], $vbphrase['vbplaza_lottery']) . "\" accesskey=\"s\" />");
}

// check if its editing a lottery
if ($_REQUEST['do'] == 'editlottery')
{
	// build delete button if possible
	$deleteoption = '';
	if ($_REQUEST['lotteryid'] >= 11)
	{
		// setup up the $deleteoption
		$deleteoption = "<input type=\"submit\" name=\"delete\" class=\"button\" tabindex=\"1\" value=\"" . construct_phrase($vbphrase['vbplaza_delete_x'], $vbphrase['vbplaza_lottery']) . "\" accesskey=\"s\" /> &nbsp; ";
	}

	// cache the lottery
	$lottery = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbplaza_lottery WHERE lotteryid = '" . $_REQUEST['lotteryid'] . "'");
	$allowedarray = array('usergroupid' => 0, 'membergroupids' => $lottery['allowedgroups']);
	$deniedarray = array('usergroupid' => 0, 'membergroupids' => $lottery['deniedgroups']);
	print_form_header('vbplaza_lottery', 'updatelottery');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_edit'] . " " . $lottery['name'] . "</font>", 2);
	construct_hidden_code('lotteryid', $_REQUEST['lotteryid']);
	print_yes_no_row($vbphrase['vbplaza_active'], 'lottery[active]', $lottery['active']);
	print_yes_no_row($vbphrase['vbplaza_lottery_recurring'], 'lottery[recurring]', $lottery['recurring']);
	print_yes_no_row($vbphrase['vbplaza_lottery_ticket_builds_jackpot'], 'lottery[ticketbuild]', $lottery['ticketbuild']);
	print_input_row($vbphrase['vbplaza_time_active'], 'lottery[timeactive]', $lottery['timeactive']);
	print_time_row($vbphrase['vbplaza_ending_time'], 'lottery[enddateline]', $lottery['enddateline']);
	print_input_row($vbphrase['vbplaza_ticket_price'], 'lottery[ticketcost]', $lottery['ticketcost']);
	print_input_row($vbphrase['vbplaza_starting_jackpot_amount'], 'lottery[startingjackpot]', $lottery['startingjackpot']);
	print_input_row($vbphrase['vbplaza_jackpot_amount'], 'lottery[jackpot]', $lottery['jackpot']);
	print_input_row($vbphrase['vbplaza_winning_tax'], 'lottery[winningtax]', $lottery['winningtax']);
	print_input_row($vbphrase['vbplaza_max_tickets_per_user'], 'lottery[maxticketperuser]', $lottery['maxticketperuser']);
	print_input_row($vbphrase['vbplaza_maximum_tickets'], 'lottery[maxtickets]', $lottery['maxtickets']);
	print_input_row($vbphrase['vbplaza_minimum_tickets'], 'lottery[mintickets]', $lottery['mintickets']);
	print_input_row($vbphrase['vbplaza_tickets_sold'], 'lottery[ticketssold]', $lottery['ticketssold']);
	print_input_row($vbphrase['vbplaza_lottery_name'], 'lottery[name]', $lottery['name']);
	print_textarea_row(construct_phrase($vbphrase['vbplaza_x_description'], $vbphrase['vbplaza_lottery']), 'lottery[description]', $lottery['description']);
	print_membergroup_row($vbphrase['vbplaza_allowed_groups'], 'lottery[allowedgroups]', 2, $allowedarray);
	print_membergroup_row($vbphrase['vbplaza_denied_groups'], 'lottery[deniedgroups]', 2, $deniedarray);
	print_input_row($vbphrase['vbplaza_lottery_image_location'], 'lottery[imagelocation]', $lottery['imagelocation']);
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" /> &nbsp; " . $deleteoption);
}

// check if it is searching the lottery winners
if ($_REQUEST['do'] == 'lotterywinners')
{
	// display that there are no categories found
	print_form_header('vbplaza_lottery', 'searchlotterywinners');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_search_lottery_winners'] . "</font>", 2);
	print_description_row($vbphrase['vbplaza_search_criteria']);
	print_input_row($vbphrase['username'], 'username', '');
	print_input_row($vbphrase['userid'], 'userid', '');
	print_table_footer(2, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['vbplaza_search_lottery_winners'] . "\" accesskey=\"s\" />");
}

// check if it is listing the options
if ($_REQUEST['do'] == 'lotterylist')
{
	// start the output
	print_form_header('vbplaza_lottery', 'quickupdate');
	print_table_header("<font size=3>" . $vbphrase['vbplaza_vblottery_list'] . "</font>", 7);
	print_cells_row(array($vbphrase['vbplaza_id'], $vbphrase['vbplaza_lottery_name'], $vbphrase['vbplaza_ticket_price'], $vbphrase['vbplaza_jackpot_amount'], $vbphrase['vbplaza_winning_tax'], $vbphrase['vbplaza_tickets_sold'], $vbphrase['vbplaza_active']), 1, 'tcat');

	// process all cached lotterys
	foreach($vbplazalotteries AS $lottery)
	{
		// verify the lottery is valid
		if (is_numeric($lottery['lotteryid']))
		{
			// clear out the cells
			$cell = array();

			// setup and display the cells
			$cell[] = "<a href=\"vbplaza_lottery.php?do=editlottery&amp;lotteryid=" . $lottery['lotteryid'] . "\">" . $lottery['lotteryid'] . "</a>";
			$cell[] = "<a href=\"vbplaza_lottery.php?do=editlottery&amp;lotteryid=" . $lottery['lotteryid'] . "\">" . $lottery['name'] . "</a>";
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"ticketcost[$lottery[lotteryid]]\" value=\"$lottery[ticketcost]\" size=\"10\" title=\"" . $vbphrase['vbplaza_lottery_cost'] . "\" />";
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"jackpot[$lottery[lotteryid]]\" value=\"$lottery[jackpot]\" size=\"10\" title=\"" . $vbphrase['vbplaza_lottery_tax'] . "\" />";
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"winningtax[$lottery[lotteryid]]\" value=\"$lottery[winningtax]\" size=\"10\" title=\"" . $vbphrase['vbplaza_lottery_tax'] . "\" />";
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"ticketssold[$lottery[lotteryid]]\" value=\"$lottery[ticketssold]\" size=\"6\" title=\"" . $vbphrase['vbplaza_lotterys_sold'] . "\" />";
			$activemods = array('1' => $vbphrase['yes'], '0' => $vbphrase['no']);
			$cell[] = "<select name=\"active[$lottery[lotteryid]]\" class=\"bginput\">\n" . construct_select_options($activemods, $lottery['active']) . "\t</select>";
			print_cells_row($cell);
		}
	}

	// finish off the table
	print_table_footer(7, "<input type=\"submit\" class=\"button\" tabindex=\"1\" value=\"" . $vbphrase['save_settings'] . "\" accesskey=\"s\" />");
}

// display the footer
print_cp_footer();
?>