<?php if (!defined('IDIR')) { die; }
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2010 Jelsoft Enterprises Ltd. # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbsupport.org/forum/index.php | http://www.vbsupport.org/forum/index.php # ||
|| #################################################################### ||
\*======================================================================*/
/**
* OT_001
*
* @package 		ImpEx.OT
* @version		$Revision: 1541 $
* @author		Jerry Hutchings <jerry.hutchings@vbulletin.com>
* @checkedout	$Name$
* @date 		$Date: 2006-09-12 16:11:27 -0500 (Tue, 12 Sep 2006) $
* @copyright 	http://www.vbsupport.org/forum/index.php
*
*/
class OT_001 extends OT_000
{
	var $_version = "0.0.1";
	var $_modulestring 	= 'Check and update database';

	function OT_001()
	{
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$displayobject->update_basic('title','Get database information');
		$displayobject->update_html($displayobject->do_form_header('index','001'));
		$displayobject->update_html($displayobject->make_table_header('Get database information'));
		$displayobject->update_html($displayobject->make_hidden_code('database','working'));

		$displayobject->update_html($displayobject->make_description('This module will check the tables in the database as well as the connection.'));
		$displayobject->update_html($displayobject->make_description('Also, please enter the complete path and file name of the members file below and the path to the forums XML file(s).'));
		$displayobject->update_html($displayobject->make_description('( Don\'t worry if the memebers file is in the same folder)'));
		$displayobject->update_html($displayobject->make_input_code('Full Path and filename of OT <b>members XML file</ b>','membersxmlfile',$sessionobject->get_session_var('membersxmlfile'),1,60));
		$displayobject->update_html($displayobject->make_input_code('Full Path and filename of OT <b>forum XML files</ b>','forumsxmlfile',$sessionobject->get_session_var('forumsxmlfile'),1,60));
		#$displayobject->update_html($displayobject->make_input_code('Full Path and filename of OT <b>settings XML files</ b>','settingsxmlfile',$sessionobject->get_session_var('forumsxmlfile'),1,60));

		$displayobject->update_html($displayobject->do_form_footer('Check database and files',''));
		$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_done', '0');
		$sessionobject->add_session_var(substr(get_class($this) , -3) . '_objects_failed', '0');
	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		// Setup some working variables
		$displayobject->update_basic('displaymodules','FALSE');
		$target_db_type 		= $sessionobject->get_session_var('targetdatabasetype');
		$target_table_prefix 	= $sessionobject->get_session_var('targettableprefix');
		$source_db_type            = $sessionobject->get_session_var('sourcedatabasetype');
		$source_table_prefix 	= $sessionobject->get_session_var('sourcetableprefix');

		$class_num        = substr(get_class($this) , -3);
		$databasedone     = true;

		if(!$sessionobject->get_session_var($class_num . '_start'))
		{
			$sessionobject->timing($class_num, 'start' ,$sessionobject->get_session_var('autosubmit'));
		}


		$displayobject->update_basic('title','Modifying database');
		$displayobject->display_now("<h4>Altering tables</h4>");
		$displayobject->display_now("<p>ImpEx will now Alter the tables in the vB database to include <i>import id numbers</i>.</p>");
		$displayobject->display_now("This is needed during the import process for maintaining refrences between the tables during an import.");
		$displayobject->display_now("If you have large tables (i.e. lots of posts) this can take some time.</p>");
		$displayobject->display_now("<p> They will also be left after the import if you need to link back to the origional OT userid.</p>");



		// Add an importids now
		foreach ($this->_import_ids as $id => $table_array)
		{
			foreach ($table_array as $tablename => $column)
			{
				if ($this->add_import_id($Db_target, $target_db_type, $target_table_prefix, $tablename, $column))
				{
					$displayobject->display_now("\n<br /><b>$tablename</b> - $column <i>OK</i>");
				}
				else
				{
					$sessionobject->add_error('fatal',
								$this->_modulestring,
								get_class($this) . "::resume failed trying to modify table poll to add importpollid",
								'Check database permissions and forum table');
					$databasedone = false;
				}
			}
		}

		$this->add_index($Db_target, $target_db_type, $target_table_prefix, 'post');
		$this->add_index($Db_target, $target_db_type, $target_table_prefix, 'user');

		// Check the path and the memebers file

		$databasedone =	$this->check_file($displayobject, $sessionobject, $sessionobject->get_session_var('membersxmlfile'));
		$databasedone =	$this->check_file($displayobject, $sessionobject, $sessionobject->get_session_var('forumsxmlfile'));
		#$databasedone =	$this->check_file($displayobject, $sessionobject, $sessionobject->get_session_var('settingsxmlfile'));


		if ($databasedone)
		{
			$sessionobject->timing($class_num,'stop', $sessionobject->get_session_var('autosubmit'));
			$sessionobject->remove_session_var($class_num . '_start');

			$displayobject->update_html($displayobject->module_finished($this->_modulestring,
				$sessionobject->return_stats($class_num,'_time_taken'),
				$sessionobject->return_stats($class_num,'_objects_done'),
				$sessionobject->return_stats($class_num,'_objects_failed')
			));

			$sessionobject->add_session_var($class_num . '_objects_done',intval($sessionobject->get_session_var($class_num . '_objects_done')) + 1 );
			$sessionobject->set_session_var(substr(get_class($this), -3), 'FINISHED');
			$sessionobject->set_session_var('module','000');
			$displayobject->update_basic('displaymodules','FALSE');
			$displayobject->update_html($displayobject->print_redirect_001('index.php',$sessionobject->get_session_var('pagespeed')));
		}
		else
		{
			$displayobject->update_html($displayobject->make_description("{$displayobject->phrases['failed']} {$displayobject->phrases['check_db_permissions']}"));
			$displayobject->update_html($displayobject->make_hidden_code('pathdata','done'));
			$sessionobject->set_session_var('001','FAILED');
			$sessionobject->set_session_var('module','000');
			$displayobject->update_html($displayobject->print_redirect_001('index.php',$sessionobject->get_session_var('pagespeed')));
		}
	}
}
/*======================================================================*\
|| ####################################################################
|| # NulleD By - FintMax
|| # CVS: $RCSfile$ - $Revision: 1541 $
|| ####################################################################
\*======================================================================*/
?>
