	
	$j = jQuery.noConflict();
	
	$j(document).ready(function(){
		
		$j('#sa_domain').blur(function(){
			if( '' == this.value )
				this.value = 'введите адрес сайта';
		});	
		
		$j('#sa_domain').focus(function(){
			if( 'введите адрес сайта' == this.value )
				this.value = '';
		});	

		$j('#sa_domain').keypress(function(evt){
		
			if (evt.which == 13){
				$j('#sa_check').click();
			}
		});
		
		$j('#sa_check').click(function(){
			
			// Загружаем
			$j.ajax({
				type: 'POST',
				dataType: 'json',
				url: $j('#sa_ajaxpath').val(),
				data: {
					domain:$j('#sa_domain').val()
				},
				beforeSend:
					function(){
						$j('#sa_loader').fadeIn(1000);
						$j('#sa_results').hide();
						$j('#sa_form').hide();
					},
				complete: 
					function(){
				        $j('#sa_loader').hide();
						
						$j('#sa_results').fadeIn(1000);
						$j('#sa_form').fadeIn(1000);
					},
				success:
					function(json,textStatus){
						
						// Если произошла ошибка
						if( 1 == json.error_code){
							alert(json.error_description);
						}
						else{
							$j('#sa_loader').hide();
							$j('#sa_results').html( json.resp );
							$j('#sa_form').fadeIn(1000);
						}
					},
				error:
					function(){
				        $j('#sa_loader').hide();
						
						$j('#sa_results').fadeOut(1000);
						$j('#sa_form').fadeIn(1000);
						
						alert('Ошибка передачи данных.');
					}
			});
			
		});
		
	});