<?php
    
	class sa_kernel{
		
		var $settings;		
		var $domain;
		var $cache;
		
		function __construct(){
			global $sa_settings;
			
			$this->settings = array(
			
				// Яндекс.ТИЦ
				1 => array(
					'name' => 'yandex_cy',
					'icon' => 'yandex.gif',
					'active' => true,
					'title' => 'тИЦ',
					'category' => 'Основное',
					'cat_order' => 0,
					'class' => 'yandex',
					'func' => 'cy'
				),
				
				// Яндекс.Тематика
				2 => array(
					'name' => 'yandex_thematic',
					'icon' => 'yandex.gif',
					'active' => true,
					'title' => 'Тема',
					'category' => 'Основное',
					'cat_order' => 0,
					'class' => 'yandex',
					'func' => 'thematic'
				),			
				
				// Каталог Яндекса
				3 => array(
					'name' => 'yandex_cat',
					'icon' => 'yandex.gif',
					'active' => true,
					'title' => 'Яндекс',
					'category' => 'Каталоги',
					'cat_order' => '2',
					'class' => 'yandex',
					'func' => 'cat'
				),
				
				// DMOZ
				4 => array(
					'name' => 'dmoz_cat',
					'icon' => 'dmoz.gif',
					'active' => true,
					'title' => 'DMOZ',
					'category' => 'Каталоги',
					'cat_order' => '2',
					'class' => 'dmoz',
					'func' => 'cat'
				),
				
				// Индекс в гугле
				5 => array(
					'name' => 'google_index',
					'icon' => 'google.gif',
					'active' => true,
					'title' => 'Google',
					'category' => 'Проиндексировано',
					'cat_order' => '3',
					'class' => 'google',
					'func' => 'index'
				),
				
				// Индекс в Яндексе
				6 => array(
					'name' => 'yandex_index',
					'icon' => 'yandex.gif',
					'active' => true,
					'title' => 'Яндекс',
					'category' => 'Проиндексировано',
					'cat_order' => '3',
					'class' => 'yandex',
					'func' => 'index'
				),
				
				// Индекс в Рамблере
				7 => array(
					'name' => 'rambler_index',
					'icon' => 'rambler.gif',
					'active' => true,
					'title' => 'Рамблер',
					'category' => 'Проиндексировано',
					'cat_order' => '3',
					'class' => 'rambler',
					'func' => 'index'
				),
				
				// Alexa.com rank
				8 => array(
					'name' => 'alexa_rank',
					'icon' => 'alexa.gif',
					'active' => true,
					'title' => 'Alexa',
					'category' => 'Основное',
					'cat_order' => 0,
					'class' => 'alexa',
					'func' => 'rank'
				),
				
				// Каталог mail.ru
				9 => array(
					'name' => 'mail_cat',
					'icon' => 'mail.gif',
					'active' => true,
					'title' => 'Mail.ru',
					'category' => 'Каталоги',
					'cat_order' => '2',
					'class' => 'mail',
					'func' => 'cat'
				),			
				
				// Каталог Рамблера
				10 => array(
					'name' => 'rambler_cat',
					'icon' => 'rambler.gif',
					'active' => true,
					'title' => 'Top-100',
					'category' => 'Каталоги',
					'cat_order' => '2',
					'class' => 'rambler',
					'func' => 'cat'
				),
				
				// Google PR
				11 => array(
					'name' => 'google_pr',
					'icon' => 'google.gif',
					'active' => true,
					'title' => 'PR',
					'category' => 'Основное',
					'cat_order' => 0,
					'class' => 'google',
					'func' => 'pr'
				),						

				// дата регистрации домена
				12 => array(
					'name' => 'centralops_creation_date',
					'icon' => 'centralops.gif',
					'active' => true,
					'title' => 'Зареган',
					'category' => 'Домен',
					'cat_order' => 4,
					'class' => 'other',
					'func' => 'creation_date'
				),						

				// дата экспайра домена
				13 => array(
					'name' => 'centralops_expire_date',
					'icon' => 'centralops.gif',
					'active' => true,
					'title' => 'Истекает',
					'category' => 'Домен',
					'cat_order' => 4,
					'class' => 'other',
					'func' => 'expire_date'
				),						

				// Статистика: скорость загрузки
				14 => array(
					'name' => 'speed',
					'icon' => '',
					'active' => true,
					'title' => 'Скорость',
					'category' => 'Статистика',
					'cat_order' => 6,
					'class' => 'other',
					'func' => 'speed'
				),						

				// Статистика: Скачано
				15 => array(
					'name' => 'size',
					'icon' => '',
					'active' => true,
					'title' => 'Размер',
					'category' => 'Статистика',
					'cat_order' => 6,
					'class' => 'other',
					'func' => 'size'
				),				
				
				// Яндекс.Регион
				16 => array(
					'name' => 'yandex_region',
					'icon' => 'yandex.gif',
					'active' => true,
					'title' => 'Регион',
					'category' => 'Основное',
					'cat_order' => 0,
					'class' => 'yandex',
					'func' => 'region'
				),					

				// Яндекс.Источник
				17 => array(
					'name' => 'yandex_source',
					'icon' => 'yandex.gif',
					'active' => true,
					'title' => 'Источник',
					'category' => 'Основное',
					'cat_order' => 0,
					'class' => 'yandex',
					'func' => 'source'
				),					
			);

			if( !empty($sa_settings) ){
				
				if( !empty($sa_settings->settings) ){
					
					$sa_settings->settings = unserialize($sa_settings->settings);
					
					foreach( $this->settings as $idx => $a ){
						$this->settings[$idx]['active']	= $sa_settings->settings[$idx]['active'];
					}
				}
			}
			
			uasort($this->settings,'s_cmp');
		}
		
		function save_settings(){
			global $sa_settings;
			
			if( !empty($sa_settings) ){
				$sa_settings->update('settings',serialize($this->settings));
			}
		}
		
		/***
		 * Возвращает результат
		 * @return 
		 */
		function get_data(){
			global $sa_settings;
			
			$this->domain = strtolower($this->domain);
			
			// Проверяем когда последний раз была проверка домена
			$this->get_cache();
			
			if( !empty($this->cache) ){
				
				return $this->cache;
			}
			
			$classes['google'] = 	new s_google($this->domain); $classes['google']->init();
			$classes['yandex'] = 	new s_yandex($this->domain); $classes['yandex']->init();
			$classes['rambler'] = 	new s_rambler($this->domain); $classes['rambler']->init();
			$classes['dmoz'] = 		new s_dmoz($this->domain); $classes['dmoz']->init();
			$classes['alexa'] = 	new s_alexa($this->domain); $classes['alexa']->init();
			$classes['mail'] = 		new s_mail($this->domain); $classes['mail']->init();
			$classes['other'] = 	new s_other($this->domain); $classes['other']->init();

			$domain_ip = @gethostbyname($this->domain);
			if( empty($domain_ip) ){
				$domain_ip = 'Не определился';
			}
						
			$this->cache = '<table cellspacing="3" border="0" style="border-left: 3px solid red; margin: 0;"><tr><td colspan="3"><strong>Сайт</strong>:&nbsp;<a href="http://'.$this->domain.'" target="_blank">'.$this->domain.'</a>, '.$domain_ip.'</td>';
			
			$cat_title = '';
			foreach( $this->settings as $settings ){
				
				if( $settings['active'] ){
					
					if( $cat_title != $settings['category'] ){
						$this->cache .= "<tr><td colspan='3'><br /><strong>$settings[category]</strong></td></tr>";
						$cat_title = $settings['category'];
					}
					
					$class = $classes[ $settings['class'] ];
					$func = $settings['func'];
					
					if( !empty($sa_settings) ){
						if( empty($settings['icon']) ){
							$img = '&nbsp;';
						}
						else{
							$img = "<img src='" . $sa_settings->url('img/' . $settings['icon']) . "' border='0' />";
						}						
					}
					else{
						if( empty($settings['icon']) ){
							$img = '&nbsp;';
						}
						else{
							$img = "<img src=img/" . $settings['icon'] . " border='0' />";
						}
					}
					
					$this->cache .= '<tr>';
						$this->cache .= "<td width='16'>$img</td>";
						$this->cache .= "<td>$settings[title]</td>";
						$this->cache .= "<td><nobr>".$class->$func()."</nobr></td>";
					$this->cache .= '</tr>';
				}
			}
			
			$this->cache .= 
				'<tr>
					<td colspan="3"><br /><br />
						<small style="margin: 7px 0 7px 0;">
							Спонсор: студия интернет-маркетинга AD|LABS – предлагаем услуги по созданию сайтов,<br />
							поисковому продвижению, интернет-рекламе; приглашаем площадки для участия в наших партнерских сетях.<br /> 
							Подробности на <a href="http://www.adlabs.ru/?from=samborsky">www.adlabs.ru</a>
						</small>
					</td>
				</tr>
				<tr>
					<td colspan="3">
						<br />
						<small style="margin-top: 3px">
							Разработка: <a href="http://www.samborsky.com/">Евгений Самборский</a>
						</small>
					</td>
				</tr>
			</table>';
			
			// записываем кеш
			$this->set_cache();
			
			return $this->cache;
		}
		
		function get_cache(){
			global $wpdb,$sa_settings;
			
			if( !empty($sa_settings) ){
				$row = $wpdb->get_row("select * from `{$sa_settings->table}` where `domain`='$this->domain' limit 1");
				if( !empty($row) ){
					
					// Если кеш не просрочен (проверять можно не чаще раз в 12 часов) 3600*12
					if( gmmktime() - $row->dt < 3600*12 ){
						
						$this->cache = htmlspecialchars_decode( stripslashes($row->data) );
					}				
				}
			}
		}	
		
		function set_cache(){
			global $wpdb,$sa_settings;
			
			if( !empty($sa_settings) ){
				if( !empty($this->cache) ){
					
					$a = array(
						'data' => addslashes( htmlspecialchars($this->cache) ),
						'dt' => gmmktime(),
						'domain' => $this->domain
					);
					
					// Получаем ID домена
					$row = $wpdb->get_row("select * from `{$sa_settings->table}` where `domain`='$this->domain' limit 1");
					if( !empty($row) ){
						// Домен проверялся, обновляем
						$wpdb->query("update `{$sa_settings->table}` set `data`='$a[data]',`dt`='$a[dt]',`domain`='$a[domain]' where `id`='$row->id'");
					}
					else{
						// Домен новый, вставляем
						$wpdb->query("insert into `{$sa_settings->table}` (`data`,`dt`,`domain`) values ('$a[data]','$a[dt]','$a[domain]')");
					}	
				}
			}
		}
		
	}
	
	class s_other extends s_http{
		
		var $domain;
		var $creation_date;
		var $last_url;
		var $domain_expire;
		
		var $loaded = false;
		var $domain_source = ''; 
		
		function __construct($domain = ''){
			$this->domain = $domain;
		}
		
		function load(){
			
			if( !$this->loaded ){
				
				if( $this->get($this->domain) ){
					$this->domain_source = $this->data;
					$this->loaded = true;
				}
			}
		}
		
		function speed(){
			
			$this->load();
			
			if( $this->loaded ){
				
				if( $this->get_info(CURLINFO_SIZE_DOWNLOAD) ){
					
					$bytes = $this->info;
					
					if( $this->get_info(CURLINFO_SPEED_DOWNLOAD) ){
						
						return round($bytes/$this->info,2) . '&nbsp;сек.';
					}
				}
			}
			
			return 'n/a';
		}
		
		function size(){
			
			$this->load();
			
			if( $this->loaded ){
			
				if( $this->get_info(CURLINFO_SIZE_DOWNLOAD) ){
					
					return round($this->info/1024,2) . '&nbsp;Кб.';
				}
			}
			
			return 'n/a';
		}
		
		function expire_date(){
			
			if( empty($this->domain_expire) ){
				
				$this->centralops_check();
			}
		
			return empty($this->domain_expire) ? '<a target="_blank" href="'.$this->last_url.'">n/a</a>' : '<a target="_blank" href="'.$this->last_url.'">'.$this->domain_expire.'</a>';	
		}

		function creation_date(){
			
			if( empty($this->creation_date) ){
				
				$this->centralops_check();
			}
		
			return empty($this->creation_date) ? '<a target="_blank" href="'.$this->last_url.'">n/a</a>' : '<a target="_blank" href="'.$this->last_url.'">'.$this->creation_date.'</a>';	
		}
		
		function centralops_check(){
			
			$this->last_url = 'http://networking.ringofsaturn.com/Tools/whois.php';
			if( $this->post($this->last_url,'domain='.$this->domain) ){
				
				$this->data = str_replace('&nbsp;','',$this->data);
				
				if( preg_match('/(?>Creation Date|created|Domain Create Date|Created On)\s*:\s*([a-z0-9\.\-]+)/i',$this->data,$a) ){
					
					$this->creation_date = $a[1];	
				}

				if( preg_match('/(?>paid-till|Expiration Date|Domain Expiration Date|Expiration on)\s*:\s*([a-z0-9\.\-]+)/i',$this->data,$a) ){
					
					$this->domain_expire = $a[1];	
				}
			}
			
			//$this->to_file('/test/adlabs.txt');
		}
	}
	
	class s_google extends s_http{
		
		var $domain;
		
		function __construct($domain = ''){
			$this->domain = $domain;
		}

		function index(){
			
			$url = 'http://www.google.com/search?q=site%3A' . $this->domain;
			if( $this->get($url) ){
				if( preg_match('/<b>.+?<\/b>\s*-\s*<b>.+?<\/b>.+?<b>(.+?)<\/b>/',$this->data,$a) ){
					
					$count = str_replace(',','',htmlspecialchars_decode($a[1]));
					return "<a href='$url' target='_blank'>$count</a>";
				}
			}
			return "<a href='$url' target='_blank'>0</a>";
		}
		
		function pr(){
			
			$url = 'info:' . $this->domain;
			$ch = GoogleCH(strord($url));
			$url = "http://toolbarqueries.google.com/search?client=navclient-auto&ch=6$ch&features=Rank&q=$url";
			if( $this->get($url) ){
				
				if( preg_match('/Rank_1:1:(.+)\n/i',$this->data,$a) ){
					
					return $a[1];					
				}
			}
			
			return 'n/a';
		}
		
	}
	
	class s_yandex extends s_http{
		
		var $domain;
		var $cy;
		var $thematic;
		var $source;
		var $region;
		
		function __construct($domain = ''){
			$this->domain = $domain;
		}
		
		private function bar(){
			
			$url = 'http://bar-navig.yandex.ru/u?ver=2&url=http://'. urlencode($this->domain) .'&show=1&post=0';
			
			$this->cy = $this->thematic = $this->source = $this->region = '<a target="_blank" href="'.$url.'">n/a</a>';
			
			if( $this->get($url) ){

				$this->data = iconv('windows-1251','utf-8',$this->data);

				// Получаем тематику
				if( preg_match('/\<topic title="Тема: ([^"]+)"/i',$this->data,$a) ){					
					$this->thematic = $a[1]; 
				}
				else{
					$this->thematic = 'n/a';
				}
				
				// Получаем ТИЦ
				if( preg_match('/value="(\d+)"/i',$this->data,$a) ){					
					$this->cy = $a[1]; 
				}
				else{
					$this->cy = 'n/a';
				}
				
				// Получаем Регион
				if( preg_match('/Регион:\s*([^\n]+)/i',$this->data,$a) ){					
					$this->region = $a[1]; 
				}
				else{
					$this->region = 'n/a';
				}
				
				// Получаем Источник
				if( preg_match('/Источник:\s*([^\n]+)/i',$this->data,$a) ){					
					$this->source = $a[1]; 
				}
				else{
					$this->source = 'n/a';
				}

				$this->cy = '<a target="_blank" href="'.$url.'">'.$this->cy.'</a>';
				$this->thematic = '<a target="_blank" href="'.$url.'">'.$this->thematic.'</a>';
				$this->region = '<a target="_blank" href="'.$url.'">'.$this->region.'</a>';
				$this->source = '<a target="_blank" href="'.$url.'">'.$this->source.'</a>';
			}
		}
		
		/***
		 * Яндекс.Источник
		 * @return 
		 */		
		function source(){
			
			if( empty($this->source) ){
				
				$this->bar();
			}
			
			return empty($this->source) ? 'n/a' : $this->source;
		}
		
		/***
		 * Яндекс.Регион
		 * @return 
		 */		
		function region(){
			
			if( empty($this->region) ){
				
				$this->bar();
			}
			
			return empty($this->region) ? 'n/a' : $this->region;
		}		
		
		/***
		 * Яндекс.ТИЦ
		 * @return 
		 */		
		function cy(){
			
			if( empty($this->cy) ){
				
				$this->bar();
			}
			
			return empty($this->cy) ? 'n/a' : $this->cy;
		}
		
		/***
		 * Тематика
		 * @return 
		 */
		function thematic(){
			
			if( empty($this->thematic) ){
				
				$this->bar();
			}
			
			return empty($this->thematic) ? 'n/a' : $this->thematic;
		}
		
		/***
		 * Количество страниц в Яндексе
		 * @return 
		 */
		function index(){
			
			$url = "http://yandex.ru/yandsearch?text=&site={$this->domain}&ras=1&site_manually=true&lr=0";
			if( $this->get($url) ){
				
				if( preg_match('/(нашлось|Нашёлся|Нашлась)\s*(.+)\s*стран/i',$this->data,$a) ){
					$count = strip_tags(trim($a[2]));
					return "<a href='$url' target='_blank'>$count</a>";
				}
				else{
					return "<a href='$url' target='_blank'>0</a>";
				}
			}
			return 'n/a';
		}
		
		/***
		 * Определяет находится ли сайт в каталоге Яндекс
		 * @return 
		 */
		function cat(){
			
			$url = 'http://search.yaca.yandex.ru/yca/cy/ch/' . $this->domain;
			if( $this->get($url) ){
				
				if( preg_match('/ресурс не описан в Яндекс.Каталоге/i',$this->data) ){
					return "<a href='$url' target='_blank'>Нет</a>";
				}
				else{
					return "<a href='$url' target='_blank'>Да</a>";
				}
			}
			
			return 'n/a';
		}
	}

	class s_rambler extends s_http{
		
		var $domain;
		
		function __construct($domain = ''){
			$this->domain = $domain;
		}
		
		function index(){
			
			$url = "http://nova.rambler.ru/srch?query=+&sort=0&filter=http://{$this->domain}";
			if( $this->get($url) ){
				
				if( preg_match('/Результаты\s*<b>[\d\–]+<\/b>\s*из\s*<b>(.+)<\/b><\/span>/i',$this->data,$a) ){
					return "<a href='$url' target='_blank'>$a[1]</a>";
				}
				else{
					return "<a href='$url' target='_blank'>0</a>";
				}
			}
			
			return 'n/a';
		}
		
		function cat(){
			
			$domain = str_replace('www.','',$this->domain);
			$url = "http://www.rambler.ru/srch?set=top100&query=%22http%3A%2F%2Fwww.{$domain}%22+%7C+%22http%3A%2F%2F{$domain}%22&btnG=%CD%E0%E9%F2%E8%21";
			if( $this->get($url) ){
				
				$this->data = iconv('windows-1251','utf-8',$this->data);
				
				if( preg_match('/Не найдено ни одного документа, полностью соответствующего запросу/i',$this->data) ){
					return "<a href='$url' target='_blank'>Нет</a>";
				}
				else{
					return "<a href='$url' target='_blank'>Да</a>";
				}
			}
			
			return 'n/a';
		}
				
	}
	
	class s_alexa extends s_http{
		
		var $domain;
		
		function __construct($domain = ''){
			$this->domain = $domain;
		}
		
		function rank(){
			
			$url = 'http://alexa.com/siteinfo/'. $this->domain;
			if( $this->get($url) ){
				if( preg_match('/<div class="data (?>\w+)">([\d\,]+)<\/a><\/div>/i',$this->data,$a) ){
					
					return "<a href='$url' target='_blank'>$a[1]</a>";
				}				
			}
			
			return 'n/a';
		}
	}
	
	class s_mail extends s_http{
		
		var $domain;
		
		function __construct($domain = ''){
			$this->domain = $domain;
		}
		
		function cat(){
			
			$url = 'http://search.list.mail.ru/?q='. $this->domain;
			if( $this->get($url) ){
				
				$this->data = iconv('windows-1251','utf-8',$this->data);
				
				if( preg_match('/Не найдено ни одного сайта по Вашему запросу/i',$this->data) ){
					
					return "<a href='$url' target='_blank'>Нет</a>";
				}
				else{
					return "<a href='$url' target='_blank'>Да</a>";
				}			
			}
			
			return 'n/a';
		}
	}	

	class s_dmoz extends s_http{
		
		var $domain;
		
		function __construct($domain = ''){
			$this->domain = $domain;
		}		
		
		function cat(){
			
			$url = 'http://search.dmoz.org/cgi-bin/search?search=u:' . $this->domain;
			if( $this->get($url)) {
				if( preg_match('/<b>Open Directory Sites<\/b><\/font>\s*\(\d+\-\d+\s*of\s*(\d+)\)/i',$this->data,$a) ){
					return "<a href='$url' target='_blank'>Да, $a[1]</a>";
				}
				else{
					return "<a href='$url' target='_blank'>Нет</a>";
				}
			}
			
			return 'n/a';
		}
	}

	function s_cmp($a,$b){
		
	    if( $a['cat_order'] == $b['cat_order']) {
	        return 0;
	    }
	    return ($a['cat_order'] < $b['cat_order']) ? -1 : 1;
	}
	
	define('GOOGLE_MAGIC', 0xE6359A60);
	function zeroFill($a, $b){
	    $z = hexdec(80000000);
	        if ($z & $a)
	        {
	            $a = ($a>>1);
	            $a &= (~$z);
	            $a |= 0x40000000;
	            $a = (($a&0xffffffff)>>($b-1));
	        }
	        else
	        {
	            $a = (($a&0xffffffff)>>$b);
	        }
	        return $a;
	}

	function mix($a,$b,$c) {
		$a -= $b; $a -= $c; $a ^= (zeroFill($c,13)); $a=(((0xffffffff-$a)&0xffffffff)+1)*(-1);
		$b -= $c; $b -= $a; $b ^= ($a<<8)&0xffffffff;
		$c -= $a; $c -= $b; $c ^= (zeroFill($b,13)); $c=(((0xffffffff-$c)&0xffffffff)+1)*(-1);
		$a -= $b; $a -= $c; $a ^= (zeroFill($c,12)); $a=(((0xffffffff-$a)&0xffffffff)+1)*(-1);
		$b -= $c; $b -= $a; $b ^= ($a<<16)&0xffffffff;
		$c -= $a; $c -= $b; $c ^= (zeroFill($b,5)); $c=(((0xffffffff-$c)&0xffffffff)+1)*(-1);
		$a -= $b; $a -= $c; $a ^= (zeroFill($c,3)); $a=(((0xffffffff-$a)&0xffffffff)+1)*(-1);
		$b -= $c; $b -= $a; $b ^= ($a<<10)&0xffffffff;
		$c -= $a; $c -= $b; $c ^= (zeroFill($b,15)); $c=(((0xffffffff-$c)&0xffffffff)+1)*(-1);
		
		return array($a,$b,$c);
	}

	function strord($string) {
	    for($i=0;$i<strlen($string);$i++) {
	        $result[$i] = ord($string{$i});
	    }
	    return $result;
	}

	function GoogleCH($url, $length=null, $init=GOOGLE_MAGIC) {
		
	    if(is_null($length)) {$length = sizeof($url);}
	    $a = $b = 0x9E3779B9;
	    $c = $init;
	    $k = 0;
	    $len = $length;
	    while($len >= 12) {
	        $a += ($url[$k+0] +($url[$k+1]<<8) +($url[$k+2]<<16) +($url[$k+3]<<24));
	        $b += ($url[$k+4] +($url[$k+5]<<8) +($url[$k+6]<<16) +($url[$k+7]<<24));
	        $c += ($url[$k+8] +($url[$k+9]<<8) +($url[$k+10]<<16)+($url[$k+11]<<24));
	        $mix = mix($a,$b,$c);
	        $a = $mix[0]; $b = $mix[1]; $c = $mix[2];
	        $k += 12;
	        $len -= 12;
	    }
		
	    $c += $length;
	    switch($len)
	    {
	        case 11: $c+=($url[$k+10]<<24);
	        case 10: $c+=($url[$k+9]<<16);
	        case 9 : $c+=($url[$k+8]<<8);
	        case 8 : $b+=($url[$k+7]<<24);
	        case 7 : $b+=($url[$k+6]<<16);
	        case 6 : $b+=($url[$k+5]<<8);
	        case 5 : $b+=($url[$k+4]);
	        case 4 : $a+=($url[$k+3]<<24);
	        case 3 : $a+=($url[$k+2]<<16);
	        case 2 : $a+=($url[$k+1]<<8);
	        case 1 : $a+=($url[$k+0]);
	    }
	    $mix = mix($a,$b,$c);
	    return $mix[2];
	}		
?>