<?php

	/************************************************
	 * s_http - samborsky_http
	 * 
	 * Упрощенный класс для работы с http протоколом на базе 
	 * библиотеки curl
	 *  
	 * Версия: 1.02
	 * Начало работ: 06.05.2009
	 * 
	 *************************************************/
    
	class s_http{
		
		// Хендл
		private $curl = NULL;
		
		// Последний урл
		var $url;
		
		// Последняя POST DATA
		var $post_data;
		
		// Скачанные данные
		var $data;
		
		// User Agent
		var $user_agent = 'Mozilla/5.0 (Windows; U; Windows NT 5.1; ru; rv:1.9.0.8) Gecko/2009032609 Firefox/3.0.8';
		
		// String: Последняя ошибка
		var $error;
		
		var $referer;
		
		var $info;
		
		// Конструктор
		function init(){
			
			$this->curl = curl_init();
			
			if( !$this->curl ){
				$this->error = curl_error($this->curl);
				return;
			}
			
			$this->set_opt(CURLOPT_RETURNTRANSFER,true);
			$this->set_opt(CURLOPT_CONNECTTIMEOUT,30);
			$this->set_opt(CURLOPT_USERAGENT,$this->user_agent);
			$this->set_opt(CURLOPT_HEADER,false);
			$this->set_opt(CURLOPT_ENCODING,'gzip,deflate');
			$this->set_opt(CURLOPT_FOLLOWLOCATION,true);

			// Кукисы
			$this->set_opt(CURLOPT_COOKIESESSION,true);
			$this->set_opt(CURLOPT_COOKIEFILE,'cookiefile');
			
			if( !empty($this->referer) ){
				$this->set_opt(CURLOPT_REFERER,$this->referer);
			}
		}
		
		// Деструктор
	    function __destruct() {
	    	if( $this->curl ){
				curl_close($this->curl);
				$this->curl = NULL;
			}
	    }		
		
		function set_opt($opt,$val){
			if( !curl_setopt($this->curl,$opt,$val) ){
				
				$this->error = curl_error($this->curl);
				return false;
			}
			return true;
		}
		
		// Сохраняет скачанные данные в файл
		function to_file($name){
			
			if( $f = fopen($name,'w') ){
				
				fwrite($f,$this->data);
				fclose($f);
			}
		}
		
		function get_info($opt){
			
			if( $this->curl ){				
				if( $this->info = curl_getinfo($this->curl,$opt) ){
					return true;
				}	
			}
			return false;
		}
		
		function get($url){
			$this->url = $url;
			
			if( empty($this->url) ){
				$this->error = 'Не указан URL';
				return false;
			}
			
			$this->set_opt(CURLOPT_URL,$this->url);
			$this->set_opt(CURLOPT_POST,false);

			return $this->exec();			
		}
		
		function https_get($url){
			
			$this->url = $url;
			
			if( empty($this->url) ){
				$this->error = 'Не указан URL';
				return false;
			}
			
			$this->set_opt(CURLOPT_URL,$this->url);
			$this->set_opt(CURLOPT_SSL_VERIFYHOST,0);
			$this->set_opt(CURLOPT_SSL_VERIFYPEER,false);
			
			return $this->exec();			
		}
		
		private function exec(){
			
			if( false == ($this->data = curl_exec($this->curl)) ){
				
				$this->error = curl_error($this->curl);
				return false;
			} 
			
			return true;
		}
		
		function post($url,$post_data){
			$this->url = $url;
			$this->post_data = $post_data;
			
			if( empty($this->url) ){
				$this->error = 'Не указан URL либо POST DATA';
				return false;
			}
			
			$this->set_opt(CURLOPT_URL,$this->url);

			// POST
			$this->set_opt(CURLOPT_POST,true);
			$this->set_opt(CURLOPT_POSTFIELDS,$this->post_data);
			
			return $this->exec();
		}
	}	
	
?>