<?php
/****
 * vB Optimise
 * Copyright 2008; Deceptor
 * All Rights Reserved
 * Code may not be copied, in whole or part without written permission
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

if (!is_object($vbulletin))
{
	die('Cannot access directly.');
}

require_once(DIR . '/includes/class_activecache_methods.php');
require_once(DIR . '/includes/class_activecache_vbadvanced.php');

class vb_activecache
{
	static $class = __CLASS__;
	static $instance;
	var $cached = array();
	var $prefix = 'vbactivecache_';
	var $integrity = true;

	function get_instance($method = '')
	{
		if ($method && class_exists('vb_activecache_' . $method))
		{
			eval('$instance =& vb_activecache_' . $method . '::get_instance();');

			return $instance;
		}

		return (self::$instance) ? self::$instance : (self::$instance =& new self::$class());
	}

	function suicide()
	{
		if (self::$instance)
		{
			self::$instance = null;
		}
	}

	function fetch(){}
	function set(){}

	function connect()
	{
		return true;
	}

	function custom_datastore_cache()
	{
		global $vbulletin, $datastore_fetch, $datastore_class;

		if ($vbulletin->options['_vboptimise_datastore'] && !empty($datastore_fetch) && $datastore_class != 'vB_Datastore' && $vbulletin->options['_vboptimise_active'])
		{
			$datastore_default = $vbulletin->datastore->defaultitems;
			$vbulletin->datastore->defaultitems = array();

			foreach ($datastore_fetch as $key => $item)
			{
				$datastore_fetch[$key] = str_replace(array("'", '"'), '', $item);
			}

			$vbulletin->datastore->fetch($datastore_fetch);
			$vbulletin->datastore->defaultitems = $default_datastore;

			devdebug('vB Optimise:  ' . count($datastore_fetch) . '      vBulletin.');

			$datastore_fetch = array();
		}
		else if ($vbulletin->options['_vboptimise_datastore'] && $datastore_class != 'vB_Datastore' && $vbulletin->options['_vboptimise_active'])
		{
			devdebug('vB Optimise:   ,    .');
		}
	}

	function integrity_check($cacheditem)
	{
		// Ensure the data returned from our cache controllers is valid (array or serialized array)

		if (!$this->integrity)
		{
			return $cacheditem;
		}

		return is_array($cacheditem) || @is_array(unserialize($cacheditem)) ? $cacheditem : false;
	}

	function check_cache($what, $userid = 0)
	{
		global $vbulletin;

		if ($this->prefix == 'vbactivecache_' && $vbulletin->options['_vboptimise_prefix'] != '')
		{
			$this->prefix = $vbulletin->options['_vboptimise_prefix'];
		}

		if (!$vbulletin->options['_vboptimise_active'] || $this->cached[$what] || !$vbulletin->options['_vboptimise_' . $what])
		{
			return false;
		}

		// We can't cache phrases for guests simply because vB will still run the query to fetch languages/phrases
		if ((THIS_SCRIPT == 'login' || ($userid < 1) || (isset($vbulletin->userinfo['userid']) && $vbulletin->userinfo['userid'] < 1) || (VB_AREA == 'AdminCP' && !$vbulletin->options['_vboptimise_active_acp'])) && $what == 'phrases')
		{
			return false;
		}

		return true;
	}

	function done_cache($what)
	{
		$this->cached[$what] = true;
	}

	function handle_blank(&$item)
	{
		if (trim($item) == '{_______VB_ACTIVE_CACHE_BLANK_______}')
		{
			$item = '';
		}
	}

	function cache_forumhome_wol()
	{
		global $vbulletin;

		if ($vbulletin->options['_vboptimise_forumwol'] && $vbulletin->options['_vboptimise_active'])
		{
			$vbulletin->options['displayloggedin_old'] = $vbulletin->options['displayloggedin'];
			$vbulletin->options['displayloggedin'] = 0;

			// Handle inforum here
			$inforum = array();

			$wol = $this->fetch('forumhome_wol');

			if (!($wol == false && !$wol = $this->fetch('forumhome_wol')))
			{
				$wol = unserialize($wol);

				foreach ($wol['data'] as $loggedin)
				{
					if ((!$loggedin['userid'] || $loggedin['userid'] != $vbulletin->userinfo['userid']) && !$loggedin['badlocation'])
					{
						$inforum["$loggedin[inforum]"]++;
					}
				}
			}

			unset($wol);

			$this->inforum = $inforum;
		}
	}

	function cache_forumhome_wol_inforum()
	{
		global $inforum, $vbulletin;

		if ($vbulletin->options['_vboptimise_forumwol'] && $vbulletin->options['_vboptimise_active'] && is_array($this->inforum))
		{
			$vbulletin->options['displayloggedin'] = $vbulletin->options['displayloggedin_old'];

			$inforum = $this->inforum;
		}
	}

	function cache_forumhome_wol_finalise()
	{
		global $vbulletin, $activeusers, $db, $show, $stylevar, $vbphrase, $numbervisible, $numberregistered, $numberguest;
		global $totalonline, $numberinvisible, $recordusers, $recorddate, $recordtime;

		if ($vbulletin->options['_vboptimise_forumwol'] && $vbulletin->options['_vboptimise_active'])
		{
			if (($vbulletin->options['displayloggedin'] == 1 OR $vbulletin->options['displayloggedin'] == 2 OR ($vbulletin->options['displayloggedin'] > 2 AND $vbulletin->userinfo['userid'])) AND !$show['search_engine'])
			{
				$numbervisible = 0;
				$numberregistered = 0;
				$numberguest = 0;

				$db_wol = false;
				$wol = $this->fetch('forumhome_wol');

				if ($wol == false && !$wol = $this->fetch('forumhome_wol'))
				{
					$db_wol = true;
				}
				else
				{
					$wol = unserialize($wol);

					if (($wol['time'] + $vbulletin->options['_vboptimise_forumwol']) < TIMENOW)
					{
						$db_wol = true;
					}
					else
					{
						devdebug('vB Optimise:  WOL (  )  .');
					}
				}

				if ($db_wol)
				{
					$wol = array(
						'data'	=> array(),
						'time'	=> TIMENOW,
					);

					$datecut = TIMENOW - $vbulletin->options['cookietimeout'];

					$hook_query_fields = $hook_query_joins = $hook_query_where = '';
					($hook = vBulletinHook::fetch_hook('forumhome_loggedinuser_query')) ? eval($hook) : false;

					$forumusers = $db->query_read_slave("
						SELECT
							user.username, (user.options & " . $vbulletin->bf_misc_useroptions['invisible'] . ") AS invisible, user.usergroupid,
							session.userid, session.inforum, session.lastactivity, session.badlocation,
							IF(displaygroupid=0, user.usergroupid, displaygroupid) AS displaygroupid, infractiongroupid
							$hook_query_fields
						FROM " . TABLE_PREFIX . "session AS session
						LEFT JOIN " . TABLE_PREFIX . "user AS user ON(user.userid = session.userid)
						$hook_query_joins
						WHERE session.lastactivity > $datecut
							$hook_query_where
						" . iif($vbulletin->options['displayloggedin'] == 1 OR $vbulletin->options['displayloggedin'] == 3, "ORDER BY username ASC") . "
					");

					while ($loggedin = $db->fetch_array($forumusers))
					{
						$wol['data'][] = $loggedin;
					}

					$wol = serialize($wol);

					$this->set('forumhome_wol', $wol);

					$wol = unserialize($wol);

					devdebug('vB Optimise: WOL (  )      ' . $vbulletin->options['_vboptimise_forumwol'] . ' ().');
				}

				if ($vbulletin->userinfo['userid'])
				{
					// fakes the user being online for an initial page view of index.php
					$vbulletin->userinfo['joingroupid'] = iif($vbulletin->userinfo['displaygroupid'], $vbulletin->userinfo['displaygroupid'], $vbulletin->userinfo['usergroupid']);
					$userinfos = array
					(
						$vbulletin->userinfo['userid'] => array
						(
							'userid'            =>& $vbulletin->userinfo['userid'],
							'username'          =>& $vbulletin->userinfo['username'],
							'invisible'         =>& $vbulletin->userinfo['invisible'],
							'inforum'           => 0,
							'lastactivity'      => TIMENOW,
							'usergroupid'       =>& $vbulletin->userinfo['usergroupid'],
							'displaygroupid'    =>& $vbulletin->userinfo['displaygroupid'],
							'infractiongroupid' =>& $vbulletin->userinfo['infractiongroupid'],
						)
					);
				}
				else
				{
					$userinfos = array();
				}

				foreach ($wol['data'] as $loggedin)
				{
					$userid = $loggedin['userid'];
					if (!$userid)
					{	// Guest
						$numberguest++;
					}
					else if (empty($userinfos["$userid"]) OR ($userinfos["$userid"]['lastactivity'] < $loggedin['lastactivity']))
					{
						$userinfos["$userid"] = $loggedin;
					}
				}

				if (!$vbulletin->userinfo['userid'] AND $numberguest == 0)
				{
					$numberguest++;
				}

				foreach ($userinfos AS $userid => $loggedin)
				{
					$numberregistered++;
					fetch_musername($loggedin);

					($hook = vBulletinHook::fetch_hook('forumhome_loggedinuser')) ? eval($hook) : false;

					if (fetch_online_status($loggedin))
					{
						$numbervisible++;
						$show['comma_leader'] = ($activeusers != '');
						eval('$activeusers .= "' . fetch_template('forumhome_loggedinuser') . '";');
					}
				}

				// memory saving
				unset($userinfos, $loggedin, $wol);

				$db->free_result($forumusers);

				$totalonline = $numberregistered + $numberguest;
				$numberinvisible = $numberregistered - $numbervisible;

				// ### MAX LOGGEDIN USERS ################################
				if (intval($vbulletin->maxloggedin['maxonline']) <= $totalonline)
				{
					$vbulletin->maxloggedin['maxonline'] = $totalonline;
					$vbulletin->maxloggedin['maxonlinedate'] = TIMENOW;
					build_datastore('maxloggedin', serialize($vbulletin->maxloggedin), 1);
				}

				$recordusers = vb_number_format($vbulletin->maxloggedin['maxonline']);
				$recorddate = vbdate($vbulletin->options['dateformat'], $vbulletin->maxloggedin['maxonlinedate'], true);
				$recordtime = vbdate($vbulletin->options['timeformat'], $vbulletin->maxloggedin['maxonlinedate']);

				$show['loggedinusers'] = true;
			}
		}
	}

	function cache_style()
	{
		global $vbulletin, $style, $styleid, $userselect;

		if (!$this->check_cache('styles'))
		{
			return false;
		}

		$style = $this->fetch('style_' . $styleid);

		if ($style == false && !$style = $this->fetch('style_' . $styleid))
		{
			devdebug('vB Optimise:   (: ' . $styleid . ')  .');

			$style = $vbulletin->db->query_first_slave("select * from " . TABLE_PREFIX . "style where styleid = $styleid or styleid = " . $vbulletin->options['styleid'] . " ORDER BY styleid " . iif($styleid > $vbulletin->options['styleid'], 'DESC', 'ASC') . "");

			$styleid = $style['styleid'];

			if (!$style['styleid']) // should never occur, this is purely "just incase"
			{
				devdebug('vB Optimise:    (: ' . $styleid . '),      .');

				$styleid = $vbulletin->options['styleid'];

				$this->cache_style();

				return false;
			}

			$this->set('style_' . $style['styleid'], $style);

			devdebug('vB Optimise:   (: ' . $styleid . ').');

			if ((!($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']) AND !$userselect) && $style['userselect'] != 1)
			{
				devdebug('vB Optimise: Style cannot be selected (insufficient perms), forcing default style.');
				$styleid = $vbulletin->options['styleid'];

				$this->cache_style();
			}
		}
		else
		{
			devdebug('vB Optimise:   (: ' . $styleid . ')  .');
		}

		$this->done_cache('styles');
	}

	function cache_phrases($userid = 0)
	{
		global $vbulletin, $phrasegroups, $vbphrase, $phrase_userinfo, $languageid;

		if (!$this->check_cache('phrases', $userid))
		{
			return false;
		}

		if (!@in_array('global', $phrasegroups))
		{
			$phrasegroups[] = 'global';
		}

		$norm_phrasegroups = array(
			'options'			=> 'lang_options',
			'languagecode'			=> 'lang_code',
			'charset'			=> 'lang_charset',
			'locale'			=> 'lang_locale',
			'imagesoverride'		=> 'lang_imagesoverride',
			'dateoverride'			=> 'lang_dateoverride',
			'timeoverride'			=> 'lang_timeoverride',
			'registereddateoverride'	=> 'lang_registereddateoverride',
			'calformat1override'		=> 'lang_calformat1override',
			'calformat2override'		=> 'lang_calformat2override',
			'logdateoverride'		=> 'lang_logdateoverride',
			'decimalsep'			=> 'lang_decimalsep',
			'thousandsep'			=> 'lang_thousandsep',
		);

		$phrase_userinfo = array(); 
		$pg_count = 0;
		$ap_count = 0;
		$languageid = $languageid ? $languageid : (empty($vbulletin->userinfo['languageid']) ? $vbulletin->options['languageid'] : $vbulletin->userinfo['languageid']);

		foreach ($phrasegroups as $phrasegroup)
		{
			$thephrasegroup = $this->fetch('phrasegroup_' . $phrasegroup . '_' . $languageid);

			if ($thephrasegroup == false && !$thephrasegroup = $this->fetch('phrasegroup_' . $phrasegroup . '_' . $languageid))
			{
				$fetch_phrasegroup = $vbulletin->db->query_first("select phrasegroup_{$phrasegroup} from " . TABLE_PREFIX . "language where languageid = $languageid");

				$phrase_userinfo['phrasegroup_' . $phrasegroup] = $fetch_phrasegroup['phrasegroup_' . $phrasegroup];

				$this->set('phrasegroup_' . $phrasegroup . '_' . $languageid, $fetch_phrasegroup['phrasegroup_' . $phrasegroup]);

				devdebug('vB Optimise:    ' . $phrasegroup . '   ,  .');
			}
			else
			{
				$this->handle_blank($thephrasegroup);

				$phrase_userinfo['phrasegroup_' . $phrasegroup] = $thephrasegroup;
				$pg_count++;
			}
		}

		$this->integrity = false;

		foreach ($norm_phrasegroups as $key => $userkey)
		{
			$thephrase = $this->fetch('phrase_' . $key . '_' . $languageid);

			if ($thephrase == false && !$thephrase = $this->fetch('phrase_' . $key . '_' . $languageid))
			{
				$fetch_phrase = $vbulletin->db->query_first("select {$key} from " . TABLE_PREFIX . "language where languageid = $languageid");

				$phrase_userinfo[$userkey] = $fetch_phrase[$key];

				$this->set('phrase_' . $key . '_' . $languageid, $fetch_phrase[$key]);

				devdebug('vB Optimise:   ' . $key . '   ,  .');
			}
			else
			{
				$this->handle_blank($thephrase);

				$phrase_userinfo[$userkey] = $thephrase;
				$ap_count++;
			}
		}

		$this->integrity = true;

		devdebug('vB Optimise:  ' . $pg_count . '    .');
		devdebug('vB Optimise:  ' . $ap_count . '   .');

		$vbphrase = '__VB__ACTIVE__CACHE__';
	}

	function cache_phrases_finalise(&$user)
	{
		global $vbulletin, $vbphrase, $phrase_userinfo;

		if (!$this->check_cache('phrases', $user['userid']))
		{
			return false;
		}

		if ($vbphrase == '__VB__ACTIVE__CACHE__')
		{
			if (is_array($phrase_userinfo))
			{
				foreach ($phrase_userinfo as $key => $data)
				{
					$user[$key] = $data;
				}

				unset($phrase_userinfo);
			}
		}

		$this->done_cache('phrases');
	}

	function cache_templates()
	{
		global $vbulletin, $templateids, $globaltemplates, $templateassoc, $style;

		if (!$this->check_cache('templates'))
		{
			return false;
		}

		if (empty($templateassoc))
		{
			$templateassoc = unserialize($style['templatelist']);
		}

		if ($vbulletin->options['legacypostbit'] AND in_array('postbit', $globaltemplates))
		{
			$templateassoc['postbit'] = $templateassoc['postbit_legacy'];
		}

		if (!is_array($globaltemplates))
		{
			$globaltemplates = array();
		}

		foreach ($globaltemplates AS $template)
		{
			$templateids[] = intval($templateassoc["$template"]);
		}

		if (!empty($templateids) && is_array($templateids))
		{
			$templates_database = array();
			$templates_cache = array();

			foreach ($templateids as $templateid)
			{
				$templates_cache[$templateid] = $this->fetch('template_' . $templateid);

				if ($templates_cache[$templateid] == false && !$templates_cache[$templateid] = $this->fetch('template_' . $templateid))
				{
					$templates_database[] = $templateid;
					unset($templates_cache[$templateid]);
				}
				else
				{
					$this->handle_blank($templates_cache[$templateid]);
				}
			}

			foreach ($templates_database as $tkey => $tdb)
			{
				if ($tdb == '0' || $tdb == 0)
				{
					unset($templates_database[$tkey]);
				}
			}

			devdebug('vB Optimise:  ' . count($templates_cache) . '   , ' . count($templates_database) . '     ');

			if (!empty($templates_database) && trim(implode(',', $templates_database)) != '')
			{
				devdebug('vB Optimise:    : ' . implode(',', $templates_database) . '.');

				$templates = $vbulletin->db->query_read("
					SELECT templateid, title, template AS content
					FROM " . TABLE_PREFIX . "template
					WHERE templateid IN (" . implode(',', $templates_database) . ")
				");
				while ($template = $vbulletin->db->fetch_array($templates))
				{
					$templates_cache[$template['templateid']] = $template;
					$this->set('template_' . $template['templateid'], $template);
				}
			}

			if (is_array($templates_cache))
			{
				foreach ($templates_cache as $cache_tempid => $cache_temp)
				{
					$vbulletin->templatecache[$cache_temp['title']] = $cache_temp['content'];
				}
			}

			$globaltemplates = array();
		}

		$this->done_cache('templates');
	}
}
?>