<?php
/**
* MosJoomBBCodes
* @version $Id: 0.0.1 $
* @package Joomla_1.0.x
* @copyright (C) 2008 by PHAM Ngoc Hai
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* Website: http://www.phamngochai.net
*/

defined( '_JEXEC' ) or die( 'Restricted access' );

class MosJoomBBCodes {

	
	var $bbcodes_start = array(	                        0 => '[b]',
								1 => '[i]',
								2 => '[u]',
								3 => '[quote]',
								4 => '[quote=',
								5 => '[url]',
								6 => '[url=',
								7 => '[img]',
								8 => '[color=',
								9 => '[size=',
								10 => '[code]',
								11 => '[s]',
								12 => '[spoiler]',13 => '[img size=',14 => '[file name=',15 => '[B]',
								16 => '[I]',
								17 => '[U]',
								18 => '[QUOTE]',
								19 => '[QUOTE=',
								20 => '[URL]',
								21 => '[URL=',
								22 => '[IMG]',
								23 => '[COLOR=',
								24 => '[SIZE=',
								25 => '[CODE]',
								26 => '[S]',
								27 => '[SPOILER]',28 => '[IMG SIZE=',29 => '[FILE NAME=');

	var $bbcodes_end = array(	                        0 => '[/b]',
								1 => '[/i]',
								2 => '[/u]',
								3 => '[/quote]',
								4 => '[/quote]',
								5 => '[/url]',
								6 => '[/url]',
								7 => '[/img]',
								8 => '[/color]',
								9 => '[/size]',
								10 => '[/code]',
								11 => '[/s]',
								12 => '[/spoiler]',13 => '[/img]',14 => '[/file]',15 => '[/b]',
								16 => '[/I]',
								17 => '[/U]',
								18 => '[/QUOTE]',
								19 => '[/QUOTE]',
								20 => '[/URL]',
								21 => '[/URL]',
								22 => '[/IMG]',
								23 => '[/COLOR]',
								24 => '[/SIZE]',
								25 => '[/CODE]',
								26 => '[/S]',
								27 => '[/SPOILER]',28 => '[/IMG]',29 => '[/FILE]');

	var $bbcode_regex = array(	                        0 => '/\[b\](.+?)\[\/b\]/s',
								1 => '/\[i\](.+?)\[\/i\]/s',
								2 => '/\[u\](.+?)\[\/u\]/s',
								3 => '/\[quote\](.+?)\[\/quote\]/s',
								4 => '/\[quote\=(.+?)\](.+?)\[\/quote\]/s',
								5 => '/\[url\](.+?)\[\/url\]/s',
								6 => '/\[url\=(.+?)\](.+?)\[\/url\]/s',
								7 => '/\[img\](.+?)\[\/img\]/s',
								8 => '/\[color\=(.+?)\](.+?)\[\/color\]/s',
								9 => '/\[size\=(.+?)\](.+?)\[\/size\]/s',
								10 => '/\[code\](.+?)\[\/code\]/s',
								11 => '/\[s\](.+?)\[\/s\]/s',
								12 => '/\[spoiler\](.+?)\[\/spoiler\]/s',13 => '/\[img size\=(.+?)\](.+?)\[\/img\]/s',14 => '/\[file name\=(.+?)\](.+?)\[\/file\]/s', 15=> '/\[B\](.+?)\[\/B\]/s',
								16 => '/\[I\](.+?)\[\/I\]/s',
								17 => '/\[U\](.+?)\[\/U\]/s',
								18 => '/\[QUOTE\](.+?)\[\/QUOTE\]/s',
								19 => '/\[QUOTE\=(.+?)\](.+?)\[\/QUOTE\]/s',
								20 => '/\[URL\](.+?)\[\/URL\]/s',
								21 => '/\[URL\=(.+?)\](.+?)\[\/URL\]/s',
								22 => '/\[IMG\](.+?)\[\/IMG\]/s',
								23 => '/\[COLOR\=(.+?)\](.+?)\[\/COLOR\]/s',
								24 => '/\[SIZE\=(.+?)\](.+?)\[\/SIZE\]/s',
								25 => '/\[CODE\](.+?)\[\/CODE\]/s',
								26 => '/\[S\](.+?)\[\/S\]/s',
								27 => '/\[SPOILER\](.+?)\[\/SPOILER\]/s',28 => '/\[IMG SIZE\=(.+?)\](.+?)\[\/IMG\]/s',29 => '/\[FILE NAME\=(.+?)\](.+?)\[\/FILE\]/s');
	
	var $bbcode_replace = array(                            0 => '<span class="mosjoombbcodes_bold">$1</span>',
								1 => '<i>$1</i>',
								2 => '<u>$1</u>',
								3 => '<blockquote>$1</blockquote>',
								4 => '<blockquote>$1 said:<br />$2</blockquote>',
								5 => '<a href="$1">here</a>',
								6 => '<a href="$1">$2</a>',
								7 => '<img style="display: block; src="$1" alt="PSP Slim Homebrew" title="PSP Slim Homebrew"/>',
								8 => '<font color="$1">$2</font>',
								9 => '<font size="$1">$2</font>',
								10 => '<pre>$1</pre>',
								11 => '<strike>$1</strike>',
								12 => '<div class="mosjoombbcodes_spoiler_outer">Spoiler: (Click here and drag downwards to view)<div class="mosjoombbcodes_spoiler_inner">$1</div></div>',13 =>'<img style="display:block;" src="$2" alt="$2" title="User submitted image"/>',14 =>'<div class="fb_file_attachment"><span class="contentheading">File Attachment:</span><br>File name:<br /> <a href="$2" alt="Download $1" title="Download $1">here</a></div>',15 => '<span class="mosjoombbcodes_bold">$1</span>',
								16 => '<i>$1</i>',
								17 => '<u>$1</u>',
								18 => '<blockquote>$1</blockquote>',
								19 => '<blockquote>$1 said:<br />$2</blockquote>',
								20 => '<a href="$1">here</a>',
								21 => '<a href="$1">$2</a>',
								22 => '<img style="display: block; src="$1" alt="PSP Slim Homebrew" title="PSP Slim Homebrew"/>',
								23 => '<font color="$1">$2</font>',
								24 => '<font size="$1">$2</font>',
								25 => '<pre>$1</pre>',
								26 => '<strike>$1</strike>',
								27 => '<div class="mosjoombbcodes_spoiler_outer">Spoiler: (Click here and drag downwards to view)<div class="mosjoombbcodes_spoiler_inner">$1</div></div>',28 =>'<img style="display:block;" src="$2" alt="$2" title="User submitted image"/>',29 =>'<div class="fb_file_attachment"><span class="contentheading">File Attachment:</span><br>File name:<br /> <a href="$2" alt="Download $1" title="Download $1">here</a></div>');

	function myBBcodesRep($aText) {
		
		$myText = $aText;
		$i = $this->findFirstBBCode($myText);
		if ($i === false) return $myText;
		$bTag = $this->bbcodes_start[$i];
		$eTag = $this->bbcodes_end[$i];
		$bPos = strpos($myText, $bTag);	
		$ePos = strpos($myText, $eTag);
		if ($ePos === false) return $myText;
		$bText = substr($myText, 0, $bPos);
		$tmpText = substr($myText, $bPos, $ePos + strlen($this->bbcodes_end[$i]) - $bPos);
		$mText = preg_replace($this->bbcode_regex[$i], $this->bbcode_replace[$i], $tmpText);
		$eText = subStr($myText, $ePos + strlen($this->bbcodes_end[$i]));
		$text1 = $this->myBBcodesRep($mText);
		$text2 = $this->myBBcodesRep($eText);
		return $bText.$text1.$text2;
	}
	
	
	function findFirstBBCode($aText) {

		$bPos = strpos($aText, '[');
		if ($bPos === false) return false;
		$ePos = strpos($aText, ']', $bPos);
		if ($ePos === false) return false;
		$tag = substr($aText, $bPos, $ePos - $bPos + 1);
		$equalSignPos = strpos($tag, '=');
		if ($equalSignPos !== false) $tag = substr($tag, 0, $equalSignPos + 1);
		$result = array_search($tag, $this->bbcodes_start);
		if ($result !== false) return $result;
		if (strlen($aText) - 1 > $ePos) {
			$tmpStr = substr($aText, $ePos);
			return $this->findFirstBBCode($tmpStr);
		} else {
			return false;
		}
	}
}
?>