<?php
/**
* @version $Id: class..php 1079 2008-10-27 05:50:14Z fxstein $
* Fireboard Component
* @package Fireboard
* @Copyright (C) 2006 - 2007 Best Of Joomla All rights reserved
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* @link http://www.bestofjoomla.com
*/

// Dont allow direct linking
defined( '_JEXEC' ) or die('Restricted access');
// class Cache
class Cache{
            var $database;  // instance of MySQL object
            var $result; // instance of Result object
            var $expiry; // cache expire time in seconds
            var $cacheFile; // cache file
            var $data; // result set array
            // constructor
            function Cache(&$database,$expiry=86400,$cacheFile){
						
                        $this->database=&$database;
                        (is_int($expiry)&&$expiry>0)?$this->expiry=$expiry:$this->database->stderr('Expire time must be a positive integer');
                        $this->cacheFile=$cacheFile;
                        $this->data=array();
            }
            // if cache is valid, perform query and return a result set. Otherwise, get results from cache file
            function query($query){
			
                        // check if query starts with SELECT
                        if(!preg_match("/^SELECT/",$query)){
                                   echo 'Invalid query. Must start with SELECT';
                        }
                        if(!$this->isValid()){
                                   // read from MySQL
								   $this->database->setQuery($query);
								 //  echo $query;
								 
								 if(sizeof($this->database->loadObjectList()) == 0){
								 $this->result=$this->database->loadObjectList();
								// print_r($this->result);
								  $this->data=$this->write();
								 return $this->result;
								 }
								 else{
								 $this->result=$this->database->loadObjectList();
								 $this->data=$this->write();
								 //only write to file if there is a result
								// echo 'mysql';
								 }
                                   
								   
								// print_r($this->result);
								
							

                                  
                        }
                        else {
                                   // read from cache file
								//  echo 'reading from cache' . $this->cacheFile;
                                  $this->data=$this->read();
								  
                        }
            }
            // write cache file
            function write(){
			
			
                        if(!$fp=fopen($this->cacheFile,'w')){
                                echo    'Error opening cache file';
                        }
						
                        if(!flock($fp,LOCK_EX)){
                               echo   'Unable to lock cache file';
                        }
						//print_r($this);die;
                        foreach($this as $row){
                                   $content[]=$row;
								
                        }
						if (is_writable($this->cacheFile)) {
						
						
                        if(!fwrite($fp,serialize($content[1]))){
                                 echo   'Error writing to cache file';
                        }
                        flock($fp,LOCK_UN);
                        fclose($fp);
                        unset($fp,$row);
						//print_r($content);
						return $content[1];
            }}
            // read cache file
            function read(){
                        if(!$content=unserialize (file_get_contents($this->cacheFile))){
                                 
								 
								 echo 'Error reading from cache file';
								$this->write();
                        }
																		

                        return $content;
            }
            // determine cache validity based on a time expiry trigger
            function isValid(){
                        if(file_exists($this->cacheFile) && filemtime($this->cacheFile)>(time()-$this->expiry) ){
					
						$content= unserialize(file_get_contents($this->cacheFile));
						
						if(isset($content[0])){						
								
						if(array_key_exists('id', (array)$content[0])){
						//(array) is needed so it does not thow second arg needs to be arra warning
						
						return true;
                        }}
						
						else{
						   // echo "$this->cacheFile was last modified: " . date ("F d Y H:i:s.", filemtime($this->cacheFile));
						//echo 'not  valid file';

                        return false;
						}
						return false;
						}
						
						
						
            }
            // fetch cache row
            function fetchRow(){
                        if(!$row=current($this->data)){
                                   return false;
                        }
                        next($this->data);
                        return $row;
            }
            // fetch all cache rows
            function fetchAll(){
                        if(count($this->data)<1){
                                // echo   $this->database->stderr('Error accessing cache data');
                        }
                        return $this->data;
            }
            // count cache rows
            function countRows(){
                        if(!$rows=count($this->data)){
                                // echo $this->database->stderr('Error counting cache rows');
                        }
                        return $rows;
            }
}
  



?>