<?php
/**
* @version $Id: fb_link.class.php 1082 2008-10-27 06:44:15Z fxstein $
* Fireboard Component
* @package Fireboard
* @Copyright (C) 2006 - 2007 Best Of Joomla All rights reserved
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* @link http://www.f-bb.co.uk
**/

// Dont allow direct linking
defined( '_JEXEC' ) or die('Restricted access');

class fb_link
{
    //
    // Basic universal href link
    //
    function GetSefHrefLink($link, $name, $title, $rel, $class ='', $anker='', $attr='',$closeAtag='')
    {
    	// For Joomla 1.0.x SEF compatibility we must add the anker after the SEF translation or it gets stripped
		if($closeAtag==''){		
        return '<a '.($class ? 'class="'.$class.'" ' : '').'href="'.JRoute::_($link.($anker?('#'.$anker):'')).'" title="'.$title.'"'.($rel ? ' rel="'.$rel.'"' : '').($attr ? ' '.$attr : '').'>'.$name.'</a>';
    }
	else{
	return '<a '.($class ? 'class="'.$class.'" ' : '').'href="'.JRoute::_($link.($anker?('#'.$anker):'')).'" title="'.$title.'"'.($rel ? ' rel="'.$rel.'"' : '').($attr ? ' '.$attr : '').'>'.$name.'';
	}
	
	
	}

    // Simple link is a barebones href link used for e.g. Jscript links
    function GetSimpleLink($id, $name='')
    {
        return'<a href="'.$id.'">'.$name.'</a>';
    }

    //
    // Central Consolidation of all internal href links
    //

    function GetCreditsLink()
    {
        return fb_link::GetSefHrefLink('http://www.f-bb.co.uk', 'F!BB', 'Frenzy! Bulletin Board', 'follow');
    }

    function GetTeamCreditsLink($catid, $name='')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func=credits&amp;catid='.$catid, $name, '', 'follow');
    }

    function GetFireBoardLink($name , $rel='follow')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL, $name, '', $rel);
    }

    function GetRSSLink($name , $title,$rel='follow')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func=fb_rss&amp;no_html=1', $name, $title, $rel, '', '', 'target="_blank"');
    }
	
	
	    function GetRSSLinkMsg($name , $thread,$title,$rel='follow')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func=fb_rss&amp;do=msgrss&amp;thread='.$thread.'&amp;no_html=1', $name, $title, $rel, 'rss', '', 'target="_blank"');
    }
	
	    function GetRSSLinkCat($name , $catid,$title,$rel='follow')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func=fb_rss&amp;do=catrss&amp;catid='.$catid.'&amp;no_html=1', $name, $title, $rel, 'rss', '', 'target="_blank"');
    }
	
	    function GetRSSLinkUser($name ,$userid ,$title,$rel='follow')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func=fb_rss&amp;do=userrss&amp;userid='.$userid.'&amp;no_html=1', $name, $title, $rel, 'rss', '', 'target="_blank"');
    }
	

    function GetCategoryLink($func, $catid, $catname, $rel='follow', $class='',$redirect='')
    {
	if($redirect!=''){return fb_link::GetSefHrefLink($redirect, $catname, '', $rel, $class);
	       


	}
	else{
		
 return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func='.$func.'&amp;catid='.$catid, $catname, '', $rel, $class);
		}
    }

    function GetCategoryListLink($name, $rel='follow', $class='')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func=listcat', $name, '', $rel, $class);
    }

    function GetCategoryPageLink($func, $catid, $page, $pagename, $rel='follow', $class='')
    {
        if ($page == 1 || !is_numeric($page))
        {
            // page 1 is identical to a link to the regular category link
            $pagelink  = fb_link::GetCategoryLink($func, $catid, $pagename, $rel, $class);
        }
        else
        {
            $pagelink  = fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func='.$func.'&amp;catid='.$catid.'&amp;page='.$page, $pagename, '', $rel, $class);
        }

        return $pagelink;
    }
	
	    function GetSearchURL($fbConfig, $func, $searchword, $limitstart, $limit, $params='')
    {
	$limitstr = "&amp;limitstart=$limitstart";
	if ($limit != $fbConfig->messages_per_page_search) $limitstr .= "&amp;limit=$limit";
        return JRoute::_(JB_LIVEURLREL."&amp;func={$func}&amp;q={$searchword}{$params}{$limitstr}");
    }

    function GetSearchLink(&$fbConfig, $func, $searchword, $limitstart, $limit, $name, $params='', $rel='nofollow')
    {
	$limitstr = "&amp;limitstart=$limitstart";
	if ($limit != $fbConfig->messages_per_page_search) $limitstr .= "&amp;limit=$limit";
        return fb_link::GetSefHrefLink(JB_LIVEURLREL."&amp;func={$func}&amp;q={$searchword}{$params}{$limitstr}", $name, '', $rel);
    }
	
	    function GetCategoryPageLinkURL($func, $catid,  $rel='follow', $class='')
    {

            $pagelink  = JRoute::_(JB_LIVEURLREL.'&amp;func='.$func.'&amp;catid='.$catid);
      

        return $pagelink;
    }
	
	
	

    function GetCategoryReviewListLink($catid, $catname, $rel='nofollow', $class='')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func=review&amp;action=list&amp;catid='.$catid, $catname, '', $rel, $class);
    }

    function GetThreadLink($func, $catid, $threadid, $threadname, $title, $rel='follow', $class='',$close='')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func='.$func.'&amp;catid='.$catid.'&amp;id='.$threadid, $threadname, $title, $rel, $class,'','',$close);
    }
	
	
	    function GetSinglePostLink($func,$catid, $threadid,$threadname, $postcount, $title, $rel='follow', $class='')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func='.$func.'&amp;catid='.$catid.'&amp;id='.$threadid.'&amp;postcount='.$postcount.'&amp;do=showpost', $threadname, $title, $rel, $class);
    }
	

    function GetRecentThreadLink($func, $catid, $threadid, $threadname, $title, $rel='follow', $class='',$id='')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func='.$func.'&amp;catid='.$catid.'&amp;id='.$id, $threadname, $title, $rel, $class,$threadid);
    }
	
	
	    function KarmaLink($func, $catid, $threadid, $threadname, $title, $rel='follow', $class='',$anker = null)
    {	$anker =$threadid;
        return JRoute::_(JB_LIVEURLREL.'&amp;func='.$func.'&amp;catid='.$catid.'&amp;id='.$threadid).($anker?('#'.$anker):'');
    }
	

    function GetThreadPageLink($func, $catid, $threadid, $page, $limit, $name, $anker='', $rel='follow', $class='',$title='')
    {
        if ($page == 1 || !is_numeric($page) || !is_numeric($limit))
        {
            // page 1 is identical to a link to the top of the thread
            $pagelink  = fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func='.$func.'&amp;catid='.$catid.'&amp;id='.$threadid,
            										$name, $title, $rel, $class, $anker);
        }
        else
        {
            $pagelink  = fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func='.$func.'&amp;catid='.$catid.'&amp;id='.$threadid
                          .'&amp;limit='.$limit.'&amp;limitstart='.(($page-1)*$limit), $name, $title, $rel, $class, $anker);
        }

        return $pagelink;
    }

    // GetThreadPageURL is basically identically to the prior function except that it returns a clear text
    // non-encoded URL. This functions is used by the email function to notify users about new posts.
    function GetThreadPageURL($func, $catid, $threadid, $page, $limit, $anker='')
    {
        if ($page == 1 || !is_numeric($page) || !is_numeric($limit))
        {
            // page 1 is identical to a link to the top of the thread
            $pageURL = str_replace('&amp;', '&', JB_LIVEURLREL).'&func='.$func.'&catid='.$catid.'&id='.$threadid;
			
			
        }
        else
        {
            $pageURL = str_replace('&amp;', '&', JB_LIVEURLREL).'&func='.$func.'&catid='.$catid.'&id='.$threadid
                          .'&limit='.$limit.'&limitstart='.(($page-1)*$limit);
        }

        return JRoute::_($pageURL).($anker?('#'.$anker):'');
    }
	
	
	    function GetRSSPageURL($func, $catid, $threadid, $page, $limit, $anker='')
    {
        if ($page == 1 || !is_numeric($page) || !is_numeric($limit))
        {
            // page 1 is identical to a link to the top of the thread
            $pageURL = JURI::root().'index.php?option=com_fbb&func='.$func.'&catid='.$catid.'&id='.$threadid;
			
			
        }
        else
        {
            $pageURL = JURI::root().'index.php?option=com_fbb&func='.$func.'&catid='.$catid.'&id='.$threadid
                          .'&limit='.$limit.'&limitstart='.(($page-1)*$limit);
        }
		 $pageURL = str_replace('&', '&amp;', $pageURL);
        return JRoute::_($pageURL.($anker?('#'.$anker):''));
    }
	
	function replyTo($func, $catid, $do,$id, $name, $anker='', $rel='follow', $class='',$title=''){

	
	
	//$replylink  = fb_link::GetSefHrefLink(JURI::root() .'&amp;func='.$func.'&amp;do='.$do.'&amp;catid='.$catid.'&amp;replyto='.$id
    //, $name, $title, $rel, $class, $anker);
		$replylink  = '[url=' . JURI::root() .'index.php?option=com_fbb&amp;func='.$func.'&amp;do='.$do.'&amp;catid='.$catid.'&amp;replyto='.$id.']Reply[/url]';

	return $replylink;
	}

    function GetSamePageAnkerLink($anker, $name, $rel='nofollow')
    {
        return fb_link::GetSefHrefLink(JRoute::_('index.php?'.$_SERVER['QUERY_STRING']), $name, '', $rel, '', $anker);
    }

    function GetReportMessageLink($catid, $msg_id, $name, $rel='nofollow')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func=report&amp;catid='.$catid.'&amp;msg_id='.$msg_id, $name, '', $rel);
    }

    function GetMessageIPLink($msg_ip, $rel='nofollow')
    {
        if ($msg_ip)
        {
            $iplink = '<a href="http://openrbl.org/dnsbl?i='.$msg_ip.'&amp;f=2" target="_blank">';
            $iplink .= 'IP: '.$msg_ip.'</a>';
        }
        else
        {
            $iplink = '&nbsp;';
        }

        return $iplink;
    }

    function GetMyProfileLink($fbConfig, $cbitemid, $name, $rel='nofollow')
    { 	
	$fbbprofile = $fbConfig->userprofile;	
	switch ($fbbprofile):
	case 'fb':
	$profilelink = JB_LIVEURLREL.'&amp;func=myprofile&amp;do=show';

	break;
    
	case 'cb':
	$profilelink ='index.php?option=com_comprofiler&amp;Itemid='.$cbitemid.'&amp;task=userDetails';
	break;
	
	case 'clexus':
	$profilelink = '';
	break;
	
	case 'joomunity':
	$profilelink = '';
	break;
	
	case 'jomsocial':
	$jspath = JPATH_BASE.DS.'components'.DS.'com_community';
	include_once($jspath.DS.'libraries'.DS.'core.php'); 
	// Get CUser object
	$profilelink = CRoute::_('index.php?option=com_community&view=profile&task=edit');
 	break;
	
    default:
	$profilelink = JB_LIVEURLREL.'&amp;func=myprofile&amp;do=show';
	endswitch;
											
	return fb_link::GetSefHrefLink($profilelink, $name, '', $rel);
    }
	
	function GetMyAvatarLink($fbConfig, $cbitemid, $name, $rel='nofollow')
    { 	
	$fbbprofile = $fbConfig->userprofile;	
	switch ($fbbprofile):
	case 'fb':
	$profilelink = JB_LIVEURLREL.'&amp;func=uploadavatar';

	break;
    
	case 'cb':
	$profilelink ='index.php?option=com_comprofiler&amp;task=userAvatar&amp;Itemid='.$cbitemid.'';
	break;
	
	case 'clexus':
	$profilelink = '';
	break;
	
	case 'joomunity':
	$profilelink = '';
	break;
	
	case 'jomsocial':
	$jspath = JPATH_BASE.DS.'components'.DS.'com_community';
	include_once($jspath.DS.'libraries'.DS.'core.php'); 
	// Get CUser object
	$profilelink = CRoute::_('index.php?option=com_community&view=profile&task=uploadAvatar');
 	break;
	
    default:
	$profilelink = JB_LIVEURLREL.'&amp;func=myprofile&amp;do=show';
	endswitch;
											
	return fb_link::GetSefHrefLink($profilelink, $name, '', $rel);
    }
	
	
   function GetProfileLink2(&$fbConfig, $userid,$cbitemid,$name, $rel='nofollow',$mode='')
    {
	
	$fbbprofile = $fbConfig->userprofile;
	
	switch ($fbbprofile):
	case 'fb':
	$profilelink = FB_PROFILE_LINK_SUFFIX.$userid;
	break;
    
	case 'cb':
	$profilelink ='index.php?option=com_comprofiler&amp;Itemid='.$cbitemid.'&amp;task=userProfile&amp;user='.$userid.'';
	break;
	
	case 'clexus':
	$profilelink = '';
	break;
	
	case 'joomunity':
	$profilelink = '';
	break;
	
	case 'jomsocial':
	$jspath = JPATH_BASE.DS.'components'.DS.'com_community';
	include_once($jspath.DS.'libraries'.DS.'core.php'); 
	// Get CUser object
	$profilelink = CRoute::_('index.php?option=com_community&view=profile&userid='.$userid);
 	break;
	
    default:
	$profilelink = JB_LIVEURLREL.'&amp;func=myprofile&amp;do=show';
	endswitch;
	
    return fb_link::GetSefHrefLink($profilelink, $name, '', $rel);
    }
	
	
	

    function GetProfileLink($fbConfig,$userid,$cbitemid, $name, $rel='nofollow', $class='')
    {
    	// Only create links for valid users
    	if ($userid > 0)
    	{
    		return fb_link::GetProfileLink2($fbConfig,$userid,$cbitemid, $name, $rel='nofollow');
    	}
    	else // supress links for guests
    	{
    		return $name;
    	}
    }
	
	
	

		    function GetProfileBoxLinks(&$fbConfig,$Itemid='',$cbitemid='', $rel='nofollow',$mode='')
    {
	
	$fbbprofile = $fbConfig->userprofile;
	$links = array();
	switch ($fbbprofile):
	case 'fb':
	  $link['login'] = JRoute::_('index.php?option=com_user&amp;view=login');
      $link['logout'] = JRoute::_('index.php?option=com_user&amp;view=login');
      $link['register'] = JRoute::_('index.php?option=com_user&amp;task=register&amp;Itemid=' . $Itemid);
      $link['reset'] = JRoute::_('index.php?option=com_user&amp;view=reset&amp;Itemid=' . $Itemid);
	break;
    
	case 'cb':
	$link['register'] = JRoute::_('index.php?option=com_comprofiler&amp;task=registers&amp;Itemid=' .$cbitemid);//.FB_CB_ITEMID_SUFFIX);
    $link['reset'] = JRoute::_('index.php?option=com_comprofiler&amp;task=lostPassword&amp;Itemid=' .$cbitemid);//.FB_CB_ITEMID_SUFFIX);
    $link['login'] = JRoute::_('index.php?option=com_comprofiler&task=login&amp;Itemid=' .$cbitemid);
     $link['logout'] =  JRoute::_('index.php?option=com_comprofiler&task=login&amp;Itemid=' .$cbitemid);
	break;
	
	case 'clexus':
	$link = '';
	break;
	
	case 'joomunity':
	$link = '';
	break;
	
	case 'jomsocial':
	$jspath = JPATH_BASE.DS.'components'.DS.'com_community';
	include_once($jspath.DS.'libraries'.DS.'core.php'); 
	// Get CUser object
		$link['register'] = CRoute::_('index.php?option=com_community&view=register');
		$link['reset'] = CRoute::_('index.php?option=com_user&view=reset');
		$link['logout'] = CRoute::_('index.php?option=com_user&amp;view=login');
		$link['login'] = CRoute::_('index.php?option=com_community&view=frontpage');
 	break;
	
    default:
	$link = JB_LIVEURLREL.'&amp;func=myprofile&amp;do=show';
	endswitch;
	
    return $link;
    }
	

///////////////////////////// 
///new get next buton


    function GetNextLink($func, $id, $catid,$name, $rel='nofollow',$title)
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func='.$func.'&amp;id='.$id.'&amp;catid='.$catid, $name,'Subject: '.$title, $rel);
    }



 function GetPrevLink($func, $id, $catid,$name, $rel='nofollow',$title)
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func='.$func.'&amp;id='.$id.'&amp;catid='.$catid, $name,'Subject: '. $title, $rel);
    }


//end
///////////////////// 






    function GetViewLink($func, $id, $catid, $view, $name, $rel='nofollow')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func='.$func.'&amp;id='.$id.'&amp;view='.$view.'&amp;catid='.$catid, $name, '', $rel);
    }

    function GetPendingMessagesLink($catid, $name, $rel='nofollow')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func=review&action=list&amp;catid='.$catid, $name, '', $rel);
    }

    function GetShowLatestLink($name, $rel='follow')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func=latest', $name, '', $rel);
    }

    function GetShowMyLatestLink($name, $rel='nofollow')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func=mylatest', $name, '', $rel);
    }

    function GetShowLatestThreadsLink($period, $name, $rel='nofollow')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func=latest&amp;do=show&amp;sel='.$period, $name, '', $rel ,'latestx-links');
    }

    // Function required to support default_ex template
    function GetLatestPageLink($func, $page, $rel='follow', $class='', $sel='')
    {
    	// if ($func=='') $func = 'latest';
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func='.$func.'&amp;page='.$page.(($sel)?'&amp;sel='.$sel:''), $page, '', $rel, $class);
    }

    function GetPostNewTopicLink($catid, $name, $rel='nofollow')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func=post&amp;do=reply&amp;catid='.$catid, $name, '', $rel);
    }


    function GetPostNewTopicLink2($catid, $name, $rel='nofollow')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func=post&amp;do=reply&amp;catid='.$catid.'&amp;recent=1', $name, '', $rel);
    }



    function GetTopicPostLink($do, $catid, $id, $name, $rel='nofollow')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func=post&amp;do='.$do.'&amp;catid='.$catid.'&amp;id='.$id, $name, '', $rel);
    }

    function GetTopicPostReplyLink($do, $catid, $id, $name, $rel='nofollow')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func=post&amp;do='.$do.'&amp;catid='.$catid.'&amp;replyto='.$id, $name, '', $rel);
    }

    function GetEmailLink($email, $name)
    {
        return fb_link::GetSimpleLink('mailto:'.stripslashes($email), stripslashes($name));
    }

    function GetKarmaLink($do, $catid, $pid, $userid, $name, $rel='nofollow',$tid='')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func=karma&amp;do='.$do.'&amp;userid='.$userid.'&amp;pid='.$pid.'&amp;tid='.$tid.'&amp;catid='.$catid, $name, '', $rel);
    }

    function GetRulesLink($fbConfig, $name, $rel='nofollow')
    {
        $ruleslink = $fbConfig->rules_infb ? JB_LIVEURLREL.'&amp;func=rules' : $fbConfig->rules_link;
        return fb_link::GetSefHrefLink($ruleslink, $name, '', $rel);
    }

    function GetHelpLink($fbConfig, $name, $rel='nofollow')
    {
        $helplink = $fbConfig->help_infb ? JB_LIVEURLREL.'&amp;func=faq' : $fbConfig->help_link;
        return fb_link::GetSefHrefLink($helplink, $name, '', $rel);
    }
	
	
	    function GetBanLink($do,$userid ,$ip,$name, $catid,$rel='nofollow')
    {
        return fb_link::GetSefHrefLink(JB_LIVEURLREL.'&amp;func=post&amp;catid='.$catid.'&amp;do='.$do.'&amp;ip='.$ip.'&amp;userid='.$userid, $name, '', $rel);
    }



    //
    // Macro functions that build more complex html output with embedded links
    //

    //
    // This function builds the auto redirect block to go back to the latest post of a particular thread
    // It is used for various operations. Input parameter is any post id. It will determine the thread,
    // latest post of that thread and number of pages based on the supplied page limit.
    //
    function GetLatestPostAutoRedirectHTML($pid, $limit,$forumReview='')
    {
        $database = &JFactory::getDBO();
        // First determine the thread, latest post and number of posts for the post supplied

		
		if($forumReview){
		
		
		        $database->setQuery('SELECT a.thread AS thread, max(a.id) AS latest_id, max(a.catid) AS catid, count(*) AS totalmessages
                             FROM #__fb_messages AS a,
                                (SELECT max(thread) AS thread FROM #__fb_messages WHERE id='.$pid.') AS b
                             WHERE a.thread = b.thread AND a.hold = 1
                             GROUP BY a.thread');
        $result = $database->loadObject();
		
		$func = 'showcat';
		
		
		        $Output  = '<div align="center">';
       // $Output .= fb_link::GetThreadPageLink('view', $result->catid, $result->thread, $threadPages, $limit, _POST_SUCCESS_VIEW, $result->latest_id,'','','') .'<br />';
        $Output .= fb_link::GetCategoryLink('showcat', $result->catid, _POST_SUCCESS_FORUM).'<br />';
        $Output .= '</div>';
        $Output .= '<script language = "javascript">';
        $Output .= 'setTimeout("location=\''. str_replace('&amp;', '&', fb_link::GetCategoryPageLinkURL('showcat', $result->catid) ) .'\'", 3500);';
        $Output .= '</script>';

        return $Output;
		
		
		}
		else{
	
		        $database->setQuery('SELECT a.thread AS thread, max(a.id) AS latest_id, max(a.catid) AS catid, count(*) AS totalmessages
                             FROM #__fb_messages AS a,
                                (SELECT max(thread) AS thread FROM #__fb_messages WHERE id='.$pid.') AS b
                             WHERE a.thread = b.thread AND a.hold = 0
                             GROUP BY a.thread');
        $result = $database->loadObject();
        check_dberror("Unable to retrieve latest post.");
        // Now Calculate the number of pages for this particular thread
        $threadPages = ceil($result->totalmessages / $limit);

        // Finally build output block

        $Output  = '<div align="center">';
        $Output .= fb_link::GetThreadPageLink('view', $result->catid, $result->thread, $threadPages, $limit, _POST_SUCCESS_VIEW, $result->latest_id,'','','') .'<br />';
        $Output .= fb_link::GetCategoryLink('showcat', $result->catid, _POST_SUCCESS_FORUM).'<br />';
        $Output .= '</div>';
        $Output .= '<script language = "javascript">';
        $Output .= 'setTimeout("location=\''. str_replace('&amp;', '&', fb_link::GetThreadPageURL('view', $result->catid, $result->thread, $threadPages, $limit, $result->latest_id,'','','','') ) .'\'", 3500);';
        $Output .= '</script>';

        return $Output;
		
		}
    }

    function GetLatestCategoryAutoRedirectHTML($catid)
    {
        $Output  = '<div align="center">';
        $Output .= fb_link::GetCategoryLink('showcat', $catid, _POST_SUCCESS_FORUM).'<br />';
        $Output .= '</div>';
        $Output .= '<script language = "javascript">';
        $Output .= 'setTimeout("location=\''. JRoute::_(str_replace('&amp;', '&', JB_LIVEURLREL) . '&func=showcat&catid=' . $catid) .'\'", 3500);';
        $Output .= '</script>';

        return $Output;
    }
}
?>