<?php
/**********************************************************************************
 * ObjectClarity Fireboard Discussbot
 * @version 1.0.8
 * @package Fireboard
 * @copyright (C) 2000 - 2006 Two Shoes M-Factory, (C) 2007 - 2008 ObjectClarity.com
 * @license GNU GPL (http://www.gnu.org/licenses/gpl.txt)
 * @author http://www.objectclarity.com
 **********************************************************************************/

/**********************************************************************************
 * Usage:
 * {mos_fb_discuss:<fireboard category id>}
 *
 **********************************************************************************/


// ################################################################
// Intruder Alerts
defined( '_JEXEC' ) or die( 'Restricted access' );


// ################################################################

// Used to test for various Errors, Warnings and Notices.
 error_reporting(E_ERROR | E_WARNING | E_PARSE | E_NOTICE);
error_reporting(E_ERROR | E_WARNING | E_PARSE);


/******************************************************************************
 * Bot globals used for parameters
 *****************************************************************************/
//error_reporting(E_ALL);
//include_once (JPATH_BASE . '/administrator/components/com_fbb/fireboard_config.php');

// get fireboards configuration params in
global $fbConfig;
global $database;
require_once (JPATH_ROOT . "/components/com_fbb/class.fbb.php");

if(isset($fbConfig)){

}
else{
require(JPATH_ROOT . '/administrator/components/com_fbb/models/fbgetmodels.php');
$fbConfig = new FbGetModel();
$fbConfig->setId(1);
$fbConfig = $fbConfig->getData($tables='',$query='','fb_config.txt',$cacheSetting =1);

$fbConfig = is_array($fbConfig)?$fbConfig[0]:$fbConfig;

}


$result = $fbConfig->discussbot;
$database = JFactory::getDBO();

$botPostLimit = 0;  // Limits the number of posts
$botFirstPosts = 0;  // Show the first X posts, versus the last X posts
$botLastPostTop = 0; // Show the last post at the top
$botShowForm = 0;  // Show a simple for to allow posting to forum from the bot
$botAllowPublicPost = 0;  // Show a simple for to allow posting to forum from the bot
$botUseButton = 0;  // Show a button instead of textual link
$botShowOnFrontPage = 0;  // Show a link after the "Read More..." link on the Front Page
$botEnableAutoPost = 0;  // Automatically add the Discuss link
$botAutoCategoryPairs = '';  // Cat Id pairs in the format 5,6;7,10;  where first Id is a Joomla! category Id and the second number is a FB category Id.
$botAutoCategoryId = 0;  // The Id of the FB category to put new posts into.
$botOnlySections = ''; // Limit bot to the following content sections
$botIgnoreSections = ''; // Exclude the bot from the following sections
$botOnlyCategories = ''; // Limit bot to the following content catgeories
$botIgnoreCategories = ''; // Exclude the bot from the following categories
$botCopyContent = 0; // Copy content item to the first Post in the forums
$botAllowManualOverride = 0; // Allow user to override any auto options by adding a discussbot tag directly to full text of any article.
$botDebug = 0; // Print debug info
$botDebugUserids = '';  // Only users in this comma delimited list can see debug info
$botFallbackToSubject = 0; // Fallback to Subject matching if not found in the xref
$botFirstPostOwnerId = 0;  // The Id of the Joomla user to own posts created by the bot.
$botSmilies = 0;  // Show smilies with the Quick Post form.  1 = Hide, 1 = Show on Left, 2 = Show on Right
$botQuickPostOpen = 0;  // Leave QuickPost Open by default
$botQuickPostOnTop = 0;  // QuickPost at the bottom of all posts by default
$botShowOnBlogPages = 0;  // Show a link on sec/cat blog pages after Read More... 
$botDisplay = array(); // Associative array holder for the results of the bot...



$configLoaded = 0;

// Load the parameter values before the events get a chance to fire!
fbdbLoadBotParameters();
	//	$mainframe->registerEvent( 'onPrepareContent', 'botfbDiscuss' );

/******************************************************************************
 * 
 *****************************************************************************/

// Include any integrations that are valid for this request.
fbdbIncludeIntegrationFile();

// Register the event functions for this plugin
if (function_exists("fbdbIntegrationRegisterEvents")) {
	fbdbIntegrationRegisterEvents();
} else {
global $mainframe;
	// Registration is different for J! versions

		$mainframe->registerEvent( 'onPrepareContent', 'botfbDiscuss' );
		$mainframe->registerEvent( 'onAfterDisplayContent', 'botfbReadMore' );
		
}


/******************************************************************************
 * Added for older PHP versions
 *****************************************************************************/
if (!function_exists("htmlspecialchars_decode")) {
    function htmlspecialchars_decode($string, $quote_style = ENT_COMPAT) {
        return strtr($string, array_flip(get_html_translation_table(HTML_SPECIALCHARS, $quote_style)));
    }
}


/******************************************************************************
 *  Include the integration file that matches the "option" URL parameter
 *****************************************************************************/
function fbdbIncludeIntegrationFile() {
	global  $botCopyContent;
	
	$path = JPATH_ROOT.'/plugins/content/fbdiscussbot/integration/';
	$option = fbdbCheck($_REQUEST['option']);
	if ($option && $option != "com_content" && $option != "com_frontpage") {
		$integrationFile = $path . $option . '.php';
		if (file_exists($integrationFile)) {
			// echo $integrationFile;
			include_once $integrationFile;
			
			// If we're using the Legacy bot integration method, upgrade to a better one 
			// where we have some control over how the bot behaves for new threads.
			// The Legacy bot integration method quite simply doesn't work here.
			if ($botCopyContent === 0) {
				// 1 = Copy content to the first post prefixed by a link to the original item
				// 2 = First post is simply a link back to the original item
				$botCopyContent = 2;
			}
		}
	}
}

/******************************************************************************
 * Validate that POSTed variables are set before using them - used to avoid PHP notices.
 *****************************************************************************/
function fbdbCheck(&$var) {
	return (isset($var) ? $var : "");
}

/******************************************************************************
 * Cross-version way to check if we;re in the front page or not.
 *****************************************************************************/
function fbdbIsFrontPage($params) {
$isFrontPage = 0;
		$menu = & JSite::getMenu();
		if ($menu->getActive() == $menu->getDefault()) {
			$isFrontPage = 1;
		}else{
	}
	fbdbDebug("Article is" . ($isFrontPage ? " " : " not ") . "being displayed on the Front Page");
	return $isFrontPage;
}

/******************************************************************************
 *
 *****************************************************************************/
function fbdbInsertContentAsFirstPost( &$row, $catid, $subject, $prefix, &$insertTime, $ipAddy, $botCopyContent) {
	global $database, $botFirstPostOwnerId;

	// Lookup name and email address for the content author 
	$author = (int)$botFirstPostOwnerId;
	if (!$author) {
		$author = $row->created_by;
	}
	
	$query = "SELECT name, email FROM #__users WHERE id = '{$author}'";
	$database->setQuery($query);
	$rows = $database->loadObjectlist();
	if ($database->getErrorNum()) {
		fbdbDebug("Failed to load author info:" . $database->stderr(), 1);
		return $database->stderr();
	}
	
	$email = $rows[0]->email; 
	$name = $rows[0]->name;
	$thread = ""; // Leave blank 'cause they're ALL new!
		
	$query = "INSERT INTO #__fb_messages (id, parent, thread, catid, name, userid, email, subject, time, ip)"
				. " VALUES ('', '', '{$thread}', '{$catid}', '{$name}', '{$author}', '{$email}', '{$subject}', '{$insertTime}', '{$ipAddy}')";
	$database->setQuery($query);
	$database->query();
	if ($database->getErrorNum()) {
		fbdbDebug("Failed to insert new post:" . $database->stderr(), 1);
		echo $database->stderr();
		return 0;
	}		

	// Reselect the new ID using the value for timestamp
	$query = "SELECT min(id) FROM #__fb_messages WHERE time='{$insertTime}'";
	$database->setQuery($query);
	$newMessageId = $database->loadResult();
	if ($database->getErrorNum()) {
		fbdbDebug("Failed to load id for new post:" . $database->stderr(), 1);
		echo $database->stderr();
		return 0;
	}		
	// We need to Update new Threads with the thread ID
	if ($thread == "" || $thread == 0) {
		$database->setQuery("UPDATE #__fb_messages set thread = id"
					. " WHERE id = '{$newMessageId}'");
		$database->query();
		if ($database->getErrorNum()) {
			fbdbDebug("Failed to set threadId on new post:" . $database->stderr(), 1);
			echo $database->stderr();
			return 0;
		}
		
		// Keep a cross reference of Threads we create through this bot!
		$query = "INSERT INTO #__fb_discussbot (content_id, section_id, catid, thread_id)"
					. " VALUES ('{$row->id}', '{$row->sectionid}', '{$row->catid}', '{$newMessageId}')";
		$database->setQuery($query);
		$database->query();
		if ($database->getErrorNum()) {
			fbdbDebug("Failed to insert cross reference record:" . $database->stderr(), 1);
			echo $database->stderr();
			return 0;
		}
	}
	
	// Copy content item to the first post.   $botCopyContent:  0 = Nothing, 1 = Link & Full Text, 2 = Link Only
	$posttext = "";
	if ($botCopyContent == 1) {
		// Append the "This thread discusses..." link to the front of the article text
		if ($row->fulltext) {
			$fulltext = $row->fulltext;
		} else {
			$query = "SELECT a.fulltext FROM #__content AS a WHERE a.id = " . (int)$row->id;
			$database->setQuery( $query );
			$fulltext = $database->loadResult();
			if ($database->getErrorNum()) {
				fbdbDebug("Failed to select article full text:" . $database->stderr(), 1);
				echo $database->stderr();
				return 0;
			}
		}
		$posttext = $row->introtext . "\n\n" . $fulltext;
		$posttext = preg_replace("/{mos_fb_discuss:".$catid."}/", "", $posttext, 1);
		$posttext = preg_replace("/{mosimage}/", "", $posttext);
	}
	
	// Assemble and cleanup the thread message text
	$posttext = htmlspecialchars_decode($posttext, ENT_QUOTES);
	$posttext = addslashes($posttext);
	
	include_once (JPATH_ROOT .'/components/com_fbb/template/default/smile.class.php');
	if (file_exists(JPATH_ROOT .'/components/com_fbb/sources/fb_debug.php')) {
		// Only exists in version FB 1.0.5+
		include_once (JPATH_ROOT .'/components/com_fbb/sources/fb_debug.php');
	}

	// Convert headings to bold or italic text and a line break
    $posttext = preg_replace("%<h1>%si", "<b>", $posttext);
    $posttext = preg_replace("%</h1>%si", "</b>\n", $posttext);
    $posttext = preg_replace("%<h2>%si", "<i>", $posttext);
    $posttext = preg_replace("%</h2>%si", "</i>\n", $posttext);
    $posttext = preg_replace("%<h3>%si", "<i>", $posttext);
    $posttext = preg_replace("%</h3>%si", "</i>\n", $posttext);
	// Any others?
	
	// Add an extra linebreak after the end of a paragraph.
    $posttext = preg_replace("%</p>%si", "</p>\n", $posttext);
	$posttext = smile::fbStripHtmlTags($posttext);

	// mosMakeHtmlSafe($posttext);	
	$message = $prefix . "\n\n" . $posttext;
		
	$query = "INSERT INTO #__fb_messages_text(mesid, message)"
				. " VALUES ('{$newMessageId}', '{$message}')";
	$database->setQuery($query);
	$database->query();
	if ($database->getErrorNum()) {
		fbdbDebug("Failed to insert message text on new post:" . $database->stderr(), 1);
		echo $database->stderr();
		return 0;
	}
	
	// Update the category with the new topic / last post info
	$query = "UPDATE #__fb_categories"
				. " SET time_last_msg='{$insertTime}',"
				. " id_last_msg='{$newMessageId}',"
				. " numTopics = numTopics+1,"
				. " numPosts = numPosts+1"
				. " WHERE id = '{$catid}'";
				
	$database->setQuery($query);
	$database->query();
	if ($database->getErrorNum()) {
		fbdbDebug("Failed to update category info on new post:" . $database->stderr(), 1);
		echo $database->stderr();
		return 0;
	}
	
	$insertTime++;
	// We'll need to know about the new Thread id later...
	return $newMessageId;
}

/******************************************************************************
 *
 *****************************************************************************/
function botfbReadMore( &$row, &$params, $page=0 ) {
	global $botDisplay, $botShowOnFrontPage;

	 fbdbDebug("fbReadMore Called with row->id=" . $row->id . ".");
	 
	 // echo "<fieldset><legend>botfbReadMore-row</legend>";
	 // print_r($row);
	 // echo "</fieldset>";
	 // echo "<fieldset><legend>botfbReadMore-params</legend>";
	// print_r($params);
	 // echo "</fieldset>";
	 // echo "<fieldset><legend>botfbReadMore-page</legend>";
	 // print_r($page);
	 // echo "</fieldset>";
	 
	$display = "";
	if (fbdbIsFrontPage($params)) {
		fbdbDebug("ShowOnFrontPage is set to <b>" . ($botShowOnFrontPage?"True":"False")."</b>.");
		if ($botShowOnFrontPage && $botDisplay[strval($row->id)]) {
			$display = '<span class="fbdb-front-page">' . $botDisplay[strval($row->id)] . '</span><br /><br />';
		} else {
			fbdbDebug("Nothing to display!");
			$display = ""; // '??' . strval($row->id);
		}
	} else {
	
		$display = $botDisplay[strval($row->id)];
	}
	return $display;
}

/******************************************************************************
 *
 *****************************************************************************/
function botfbDiscuss ( &$row, &$params, $page=0 ) {
	return botfbDiscussJ10X( intval($row->state), $row , $params, 0);
}

/******************************************************************************
 *
 *****************************************************************************/
function fbdbLoadBotParameters() {
	global $database;	
	global $botPostLimit, $botFirstPosts, $botLastPostTop, $botShowForm, $botAllowPublicPost, 
			$botUseButton, $botShowOnFrontPage, $botEnableAutoPost, $botAutoCategoryId, 
			$botOnlySections, $botIgnoreSections, $botOnlyCategories, $botIgnoreCategories,
			$botCopyContent, $botAutoCategoryPairs, $botAllowManualOverride, $botDisplay, $botDebug, $botDebugUserids,
			$botFallbackToSubject, $botFirstPostOwnerId, $botSmilies, $botQuickPostOpen, 
			$botQuickPostOnTop, $botShowOnBlogPages;

	//$query = "SELECT id FROM #__plugins WHERE element = 'fbdiscussbot' AND folder = 'content'";
	//$database = JFactory::getDBO();
	//$database->setQuery( $query );
	//$id = $database->loadResult();
	//$database->getQuery();
	
	
	//if ($database->getErrorNum()) {
		//echo "Failed to get discussbot plugin" . $database->stderr();
		//echo $database->stderr();
		//die;
	//}
	
	
	    // Get plugin info
		$plg_name					= "fbdiscussbot";
    $plugin =& JPluginHelper::getPlugin('content', $plg_name);
		
	// Parameters
	$pluginParams = new JParameter( $plugin->params );
	
	//$mambot = new mosMambot( $database );
	//$mambot->load( $id );
	//$pluginParams =& new mosParameters( $mambot->params );
	
	// Load params here
	$botPostLimit = (int)$pluginParams->get('fb_post_limit', 20);  // Limits the number of posts
	$botFirstPosts = $pluginParams->get('first_posts', 1);  // Show the first X posts, versus the last X posts
	$botLastPostTop = $pluginParams->get('last_post_top', 0); // Show the last post at the top
	$botShowForm = $pluginParams->get('form', 0);  // Show a simple form to allow posting to forum from the bot
	$botAllowPublicPost = $pluginParams->get('allow_public', 0);  // Allow non-registered users to post from the bot
	$botUseButton = $pluginParams->get('use_button', 0);  // Show a button instead of text link
	$botShowOnFrontPage = $pluginParams->get('show_front_page', 0);  // Show a link on the Front Page after Read More...
	$botAllowManualOverride = $pluginParams->get('allow_manual_override', 0);  // 
	$botEnableAutoPost = $pluginParams->get('enable_auto_post', 0);  // Automatically add the Discuss link without requiring {fb...} tag
	$botAutoCategoryPairs = $pluginParams->get('auto_catg_pairs', ''); 
	$botAutoCategoryId = (int)$pluginParams->get('auto_catg_id', 0);  // The Id of the FB category to put new posts into
	$botOnlySections = $pluginParams->get('only_sections', '');  // Limit bot to the following content sections
	$botIgnoreSections = $pluginParams->get('ignore_sections', '');  // Exclude the bot from the following sections
	$botOnlyCategories = $pluginParams->get('only_catgs', '');  // Limit bot to the following content catgeories
	$botIgnoreCategories = $pluginParams->get('ignore_catgs', '');  // Exclude the bot from the following categories
	$botCopyContent = (int)$pluginParams->get('copy_content', '0');  // Copy content item to the first post.  0 = Nothing, 1 = Link & Full Text, 2 = Link Only
	$botFallbackToSubject = (int)$pluginParams->get('fallback_subject', '0');  // Fallback to Subject matching if not found in the xref
	$botFirstPostOwnerId = (int)$pluginParams->get('first_post_owner', '0');  // Joomla UserId of first posts created by the bot
	$botSmilies = (int)$pluginParams->get('show_smilies', '0');  // Show Smilies with Quick Post.  0 = Don't show, 1 = Show on Left, 2 = Show on right
	$botQuickPostOpen = (int)$pluginParams->get('quickpost_open', '0');  // Default state for the QuickPost Form.  0 = Collapsed, 1 = Open 
	$botQuickPostOnTop = (int)$pluginParams->get('quickpost_on_top', '0');  // Default is to put QuickPost at the very bottom.
	$botShowOnBlogPages = (int)$pluginParams->get('show_blog_pages', '0');  // Show a link on sec/cat blog pages after Read More... 
	
	$botDebug = (int)$pluginParams->get('show_debug', '0');  // Print out debug info!
	$botDebugUserids = $pluginParams->get('show_debug_userids', '');  // Joomla Id's of Users who can see debug info
}

/******************************************************************************
 *
 *****************************************************************************/
function botfbDiscussJ10X( $published, &$row, &$params, $page=0 ) {
	global $database;	
	global $botCopyContent, $botFallbackToSubject, $botShowOnFrontPage, $botAllowManualOverride,
			$botDisplay, $botEnableAutoPost, $botAutoCategoryPairs, $botAutoCategoryId, $botShowOnBlogPages;
	
	// The following is useful when using this bot with components other than the Joomla Content and JEvents components.
	// echo "<fieldset><legend>params</legend>";
	// print_r($params);
	// echo "</fieldset>";
	// echo "<fieldset><legend>row</legend>";
	// print_r($row);
	// echo "</fieldset>";
	
	
	if (!fbdbCheck($row->id)) {
		// This check is required for use with Jevents as onPrepareContent seems to be called more than once, sometimes without a row->id
		// Shouldn't hurt for others as the row->id is required everywhere else anyways.
		fbdbDebug("Discussbot called without a row Id. Call is being ignored.");
		return;
	} else {
		fbdbDebug("Discussbot called with row->id=" . $row->id . ".");
	}

	if (function_exists("fbdbIntegrationModifyRowForDisplay")) {
		fbdbIntegrationModifyRowForDisplay($row);
	}

	// Override config setting when using FB to add the link back to the article in first posts
	if ($botCopyContent === 0) {
		$botFallbackToSubject = 1;
	}
	
	$rowItemid = JRequest::getVar( 'Itemid' );

	// echo "<br>botOnlySections:" . $botOnlySections;
	// echo "<br>botIgnoreSections:" . $botIgnoreSections;
	// echo "<br>botCopyContent:" . $botCopyContent;
	$isFrontPage = fbdbIsFrontPage($params);
	if (!$isFrontPage
			&& $botShowOnFrontPage == 0 
			&& $botAllowManualOverride == 0) {
		// Since there's no way there's a tag in the article, skip all the processing!
		fbdbDebug("Showing the article intro-text.  
				ShowOnFrontPage is False, Manual Override is False.
				There should be no tags in the content - skip the overhead and return nothing.");
		$botDisplay[strval($row->id)] = "";
		return;
	}	

    // Inserted to hide in section/category/blogs for J! 1.5.x
$database = JFactory::getDBO();


	    $layout = JRequest::getVar('layout', null);
	    $view = JRequest::getVar('view', null);
	    if ( ($layout == "blog") && (($view == "category") || ($view == "section"))) {
	        fbdbDebug("Showing the article in Blog layout.  Discussbot output should be " . ($botShowOnBlogPages?"displayed":"hidden" . ".")); 
			if (!$botShowOnBlogPages ) {
				// Don't forget to remove any discussbot tags!!
				$regex = "#{mos_fb_discuss:(.*?)}#s";
				$row->text = preg_replace($regex, "", $row->text);
		        $botDisplay[strval($row->id)] = ""; 
		        return;
			}
	    }
   
	
	// If the Discussbot is not published remove any tags and return nothing!
	if (!$published) {
		// define the regular expression for the bot
		$regex = "#{mos_fb_discuss:(.*?)}#s";
		$row->text = preg_replace($regex, "", $row->text);
		$botDisplay[strval($row->id)] = "";
		return;
	}
	
	// Is this a static Content Item?
	$isStaticContent = 0;
	if (((int)fbdbCheck($row->sectionid)) == 0 && ((int)fbdbCheck($row->catid)) == 0) {
		$isStaticContent = 1;
		fbdbDebug("Content item appears to be a Static Content item.");
	}
	
	// If sectionId and catId are not valid - it's not a proper content item and therefore should NOT qualify for Auto-Discuss links!
	// Debug info is in the function...
	if (!fbdbContentItemIsValid(fbdbCheck($row->sectionid), fbdbCheck($row->catid))) {
		// If item is not valid and does not appear to be a static content item, return empty!
		if (!$isStaticContent) {
			$botDisplay[strval($row->id)] = "";
			return;
		}
	}
	
	$mos_fb_discuss_entrytext = $row->text;
	
	if ($isFrontPage) {
		$query = "SELECT a.fulltext FROM #__content AS a WHERE a.id = " . (int)$row->id;
		$database->setQuery( $query );
		$fulltext = $database->loadResult();
		if ($database->getErrorNum()) {
			fbdbDebug("Failed to get full text of content item:" . $database->stderr(), 1);
			$botDisplay[strval($row->id)] = $database->stderr();
			return;
		}
		$mos_fb_discuss_entrytext = $row->introtext . "\n\n" . $fulltext;
	}
	
	// **********************************
	// Intentionally select no rows from the x-ref table, just to be sure it's there.
	$query = "SELECT count(*) FROM #__fb_discussbot WHERE 1 = 2";
	$database->setQuery($query);
	$dontCare = $database->loadResult();
	$err = $database->getErrorNum();  
	// 1146 is "DB function failed with error number 1146 Table '<your_db>.#__fb_discussbot' doesn't exist")
	if ($err == 1146) {
		$query = "CREATE TABLE IF NOT EXISTS `#__fb_discussbot` 
					(`content_id` int(11) NOT NULL default '0', 
					 `section_id` int(11) NOT NULL default '0', 
					 `catid` int(11) NOT NULL default '0', 
					 `thread_id` int(11) NOT NULL default '0',  
					 PRIMARY KEY  (`content_id`,`section_id`,`catid`) 
					)";  // ENGINE=MyISAM   (removed "ENGINE=MyISAM" as it was failing on older MySql versions)
		$database->setQuery($query);
		$database->query();
		$err = $database->getErrorNum();
		if ($err) {
			fbdbDebug("Failed to create cross reference table:" . $database->stderr());
			fbdbDebug("You may want to try creating it manually: " . $query , 1);
			$database->stderr();
			return;
		}			
		fbdbDebug("Created #__fb_discussbot cross reference table.");
	}			
	// **********************************
	
	$mos_fb_discuss_matches = array();
		
	$x = 0;
 	if ($isStaticContent == 1 || $botEnableAutoPost == 0 || ($botAllowManualOverride == 1 && $botEnableAutoPost == 1)) {
		// This way it can be overridden by manually adding the mambot tag to an article...  or not.
		$x = preg_match_all("/{mos_fb_discuss:.+?}/", $mos_fb_discuss_entrytext, $mos_fb_discuss_matches, PREG_PATTERN_ORDER);
		fbdbDebug("Searching for {mos_fb_discuss:#} tag in article text...  " . ($x?"Found one!":"None found."));
	}

	// Allowing Auto-Mode for everything that's NOT static content - Static content items must be discussed manually.
	if ($x < 1 && $botEnableAutoPost && !$isStaticContent) {
		$matchedFBCatId = 0;
		$matched = 0;
		// If at least one pair...
		if (strstr($botAutoCategoryPairs, ',')) {
			$pairs = explode(';', $botAutoCategoryPairs);
			foreach ($pairs as $pair) {
				$tmp = explode(',', $pair);
				if ($tmp[0] == $row->catid) {
					$matchedFBCatId = (int)$tmp[1];
					$matched = 1;
					break;
				}
			}
		}
		if ($matched) {
			// Try again using a paired Automatic discuss link
			$mos_fb_discuss_entrytext = "{mos_fb_discuss:" . $matchedFBCatId . "}";
			fbdbDebug("Using J!-FB Category pair to discuss article.  J!/FB:" . $row->catid . "/" . $matchedFBCatId);
		} else {
			// Try again adding in the Automatic discuss link
			$mos_fb_discuss_entrytext = "{mos_fb_discuss:" . $botAutoCategoryId . "}";
			fbdbDebug("Using Auto-Mode to discuss article in FB CategoryId:" . $botAutoCategoryId);
		}
		$mos_fb_discuss_matches = array();		
		$x = preg_match_all("/{mos_fb_discuss:.+?}/", $mos_fb_discuss_entrytext, $mos_fb_discuss_matches, PREG_PATTERN_ORDER);
	}

	if ($x > 0) {
		// Only replace tags that exist in the original row->text
		$mos_fb_discuss_entrytext = $row->text;
		$showbottext = "";
		foreach ($mos_fb_discuss_matches[0] as $mos_fb_discuss_match) {
			$mos_fb_discuss_match = str_replace("{mos_fb_discuss:", "", $mos_fb_discuss_match);
			$mos_fb_discuss_match = str_replace("}", "", $mos_fb_discuss_match);
			
			// Updated to work with J!1.5 as well
			if (strpos($_SERVER['SCRIPT_NAME'], 'index2.php') || fbdbCheck($_REQUEST['print']) == 1 || fbdbCheck($_REQUEST['format']) == 'pdf') {
				// Don't show any fbdiscussbot output if we're in a Print or PDF view mode.
				fbdbDebug("We're in Print or PDF mode, don't show the bot.");
				$showbottext = "";
			} else {
				$linkOnly = 0;
				if ($isFrontPage) {
					$linkOnly = 1;
				}
				// Don't bother if $showbottext is already populated or if the tag contains a non-numeric value.  E.g. : None or Hide
				if ($showbottext == "") {
					if (intval($mos_fb_discuss_match)) {
						fbdbDebug("Rendering the bot...");
						$showbottext = make_fbforumlink( $mos_fb_discuss_match, $row, $rowItemid, $linkOnly);
						fbdbDebug("Done rendering the bot...");
					} else {
						fbdbDebug("Hiding the bot with: {mos_fb_discuss:". htmlspecialchars($mos_fb_discuss_match, ENT_QUOTES) . "}");
					}
				} else {
					fbdbDebug("The bot can only be rendered for one tag.  Hiding bot for: {mos_fb_discuss:". htmlspecialchars($mos_fb_discuss_match, ENT_QUOTES) . "}");
				}
			}
			$mos_fb_discuss_entrytext = preg_replace("/{mos_fb_discuss:".$mos_fb_discuss_match."}/", "", $mos_fb_discuss_entrytext, 1);
			fbdbDebug("Removed the tag...");
		}//chaerof
		$botDisplay[strval($row->id)] = $showbottext;
		$row->text = $mos_fb_discuss_entrytext;
	}
}

/******************************************************************************
 *
 *****************************************************************************/
function make_fbforumlink($catid, &$row, $rowItemid, $linkOnly=0) {
	global  $mainframe;
	global $botPostLimit, $botFirstPosts, $botLastPostTop, $botShowForm, $botAllowPublicPost, 
			$botUseButton, $botCopyContent, $botFallbackToSubject, $botDebug, $botDebugUserids, 
			$botSmilies, $botQuickPostOpen, $botQuickPostOnTop;
//	global $my;
$database = JFactory::getDBO();
	
	if (! fbdbGetConfigValue('discussBot')) {
		 fbdbDebug("Fireboard Config has the bot disabled!");
		return '';
	}
	
	$frontend_lang = null;
$language = JLanguage::getInstance($frontend_lang);
$mosConfig_lang = $language->getBackwardLang();
	
	// Include the fireboard language file
   	
   	if (file_exists(JPATH_ROOT.'/administrator/components/com_fbb/language/'.$mosConfig_lang.'.php')) {
		include_once(JPATH_ROOT.'/administrator/components/com_fbb/language/'.$mosConfig_lang.'.php');
   	} else {
		include_once(JPATH_ROOT.'/administrator/components/com_fbb/language/english.phpv');
	}
  	
	// Include a language file for the Bot!

	if (file_exists(JPATH_ROOT.'/plugins/content/fbdiscussbot/languages/' . $mosConfig_lang . '.php')) {
		include_once JPATH_ROOT.'/plugins/content/fbdiscussbot/languages/' . $mosConfig_lang . '.php';
	} else {
		include_once JPATH_ROOT.'/plugins/content/fbdiscussbot/languages/english.php';
	}
	
	// Don't repeat the CSS for each instance of this bot in a page!
	static $includedCss;
	
	$document =& JFactory::getDocument();
   
	 
	
	if (!$includedCss) {
		// Pull in the forum CSS
		if (fbdbGetConfigValue('joomlaStyle') < 1) {
			$document->addStyleSheet (JURI::root().'components/com_fbb/template/' . fbdbGetConfigValue("template") . '/forum.css','text/css');
		} else {
			 $document->addStyleSheet (JURI::root().'components/com_fbb/template/default/joomla.css','text/css');
		}
		// Add CSS for the bot
		$document->addStyleSheet (JURI::root().'plugins/content/fbdiscussbot/images/fbdiscussbot.css','text/css');
		
		$includedCss = 1;
	}
	
   	$database->setQuery("select id from #__menu where link='index.php?option=com_fbb'");
   	$Itemid = $database->loadResult();
	
	if ($database->getErrorNum()) {
		fbdbDebug("Failed to select ItemId for Fireboard:" . $database->stderr(), 1);
		return $database->stderr();
	}

	$subject = "";
	if (function_exists("fbdbIntegrationCreateSubject")) {
		$subject = fbdbIntegrationCreateSubject($row); 
	} else {
		$subject = trim(htmlspecialchars(addslashes(addslashes($row->title)))); 
	}
	
	$ipAddy = $_SERVER['REMOTE_ADDR'];
	$insertTime = time() + (fbdbGetConfigValue('board_ofset') * 3600);	// Use the same offset as the forum
	

	$query = "SELECT min(thread_id) FROM #__fb_discussbot"
				. " WHERE catid ='{$row->catid}' AND section_id = '{$row->sectionid}' and content_id = '{$row->id}' ";
	$database->setQuery($query);
	
	// This is also the thread id!
	$resultid = $database->loadResult();
	
	if ($database->getErrorNum()) {
		fbdbDebug("Failed to select threadid from cross reference:" . $database->stderr(), 1);
		return $database->stderr();
	}
	if ($resultid) {
		// Does this thread still exist in the forum or has it been deleted?
		fbdbDebug("Found the FB threadId in the cross reference table(#__fb_discussbot).");	
		$query = "SELECT count(*) FROM #__fb_messages"
				. " WHERE id = '{$resultid}'";
		$database->setQuery($query);
		$foundId = $database->loadResult();
		if (!$foundId) {
			// It's been deleted from the forum.  Delete the bad x-reference record!!
			$query = "DELETE FROM #__fb_discussbot"
						. " WHERE thread_id = '{$resultid}' ";
			$database->setQuery($query);
			$database->query();
			if ($database->getErrorNum()) {
				fbdbDebug("Failed to delete stale cross reference record:" . $database->stderr(), 1);
				return $database->stderr();
			}
			if (function_exists("fbdbIntegrationRemovedStaleXRef")) {
				fbdbIntegrationRemovedStaleXRef($row); 
			}
			fbdbDebug("Removed cross reference record pointing to a non-existent FB threadId.");
			$resultid = "";
		}
	} else {
		// Fallback to the old method for existing threads!
		if ($botFallbackToSubject) {
			$query = "SELECT min(id) FROM #__fb_messages"
					. " WHERE catid ='{$catid}' AND subject = '{$subject}'";
			$database->setQuery($query);
			$resultid = $database->loadResult();
		

			if ($database->getErrorNum()) {
				fbdbDebug("Failed to select thread by subject match:" . $database->stderr(), 1);
				return $database->stderr();
			}			
			if ($resultid) {
				// Keep a cross reference of Threads we find through this bot!
				$query = "INSERT INTO #__fb_discussbot (content_id, section_id, catid, thread_id)"
							. " VALUES ('{$row->id}', '{$row->sectionid}', '{$row->catid}', '{$resultid}')";
				$database->setQuery($query);
				$database->query();
				if ($database->getErrorNum()) {
					fbdbDebug("Failed to insert cross reference record for subject match:" . $database->stderr(), 1);
					echo $database->stderr();
					return 0;
				}
				fbdbDebug("Updated cross reference table with the FB threadId found by subject matching.");
			} else {
				fbdbDebug("Did not locate an existing thread by Subject match.");
			}
		}
	}

	$prefix = "";
	if (function_exists("fbdbIntegrationCreatePrefix")) {
		$prefix = fbdbIntegrationCreatePrefix($row, $rowItemid);
	} else {

			// $prefix = JRoute::_('index.php?option=com_content&view=article&id=' . $row->id . '&catid=' . $row->catid . '&Itemid=' . ($rowItemid?$rowItemid:1));
			$prefix = JURI::root() . 'index.php?option=com_content&view=article&id=' . $row->id . '&catid=' . $row->catid . '&Itemid=' . ($rowItemid?$rowItemid:1);
		
		// Only slightly different from the tag that's inserted by the default forum bot link so I can tell them apart!  ( Included **'s )
		$prefix = sprintf(_FBDB_THIS_THREAD_DISCUSSES, _POST_DISCUSS, $prefix, $row->title);
	}
	
	$prefix = trim(addslashes($prefix));
	 
	// ************************************************************************	
	// Process New posts where we're putting the content into the first forum post
	// ************************************************************************
	// fbdbDebug("fb_firstpost=" . fbdbCheck($_POST['fb_firstpost']) . ", resultid=" . $resultid . ", row->id=" . $row->id);

	if ((int)fbdbCheck($_POST['fb_firstpost']) == $row->id) {
		if ($resultid = "" || $resultid == 0) {
			$resultid = fbdbInsertContentAsFirstPost( $row, $catid, $subject, $prefix, $insertTime, $ipAddy, $botCopyContent);
			if ($resultid) {
				$url = "index.php?option=com_fbb&Itemid=" . $Itemid
										. "&func=view&id=" . $resultid
										. "&catid=" . $catid;
				// $url = "index.php?option=com_fbb&Itemid=" . $Itemid
										// . "&func=post&do=reply&replyto=" . $resultid
										// . "&catid=" . $catid;
				$redirectUrl = JRoute::_($url);
				// die($redirectUrl);
				
				global $mainframe;
$mainframe->redirect( JURI::base() .$redirectUrl);
				return;
			}
			return "Error:  Failed to insert first post!";
		} else {
			fbdbDebug("It appears there's already a first-post for this content item.");
		}
	}
	
	// ************************************************************************	
	$captchaSuccess = 1;  // Future use...

	// Process the QuickPost form 
	$userid = 0;
	$isMod = 0;
	$postPerms = 0;

	// fbdbDebug("Public " . ($botAllowPublicPost ? "has" : "does NOT have") . " permissions to post in FB category " . $catid . ".");
	$my = &JFactory::getUser();
	if ($my->id) {
		// If user is logged in - do they have permission to post to this FB category?
		$userid = $my->id;
		$isMod = fbdbIsModerator($userid, $catid);
		$postPerms = fbdbHasPostPerms($catid, $resultid, $userid, $isMod);
		// fbdbDebug("User " . ($postPerms ? "has" : "does NOT have") . " permissions to post in FB category " . $catid . ".");
	}

	$quickPost = "";
	if($botAllowPublicPost == 0 && intval($my->id) == 0) {
		if ("blog" == fbdbCheck($_REQUEST['layout']) && "com_content" == fbdbCheck($_REQUEST['option'])) {
			fbdbDebug("Hiding Login or Register message in Blog layout.");
		} else {
			$quickPost = sprintf(_FBDB_LOGIN_OR_REGISTER_TO_COMMENT, JURI::root());
			$quickPost .= "<br />";
			fbdbDebug("User is not logged in and public posting is not permitted.");
		}	
	} else {
		fbdbDebug("User is". ($my->id ? " " : " not ") ."logged in.");
		fbdbDebug("Article Id is ".$row->id);

		// User *is* logged in or Public Posting is allowed!
		if($botShowForm == '1' && ($botAllowPublicPost == 1 || $postPerms == 1)) {
			
			if($captchaSuccess 
					&& ((int)fbdbCheck($_POST['fbdbContentId']) == $row->id) 
					&& (fbdbCheck($_POST['message']) || fbdbCheck($_POST['name']))) {
			
				fbdbDebug("Handling Form Post from QuickPost.  resultid=" . $resultid . ", Id=" . $row->id);
				$quickPost .= fbdbHandlePostFromQuickPost($row, $postPerms, $resultid, $prefix, $isMod, $catid, $subject, $insertTime, $ipAddy);
				
				if (function_exists("fbdbIntegrationInsertedFromQuickPost") && $postPerms) {
					fbdbIntegrationInsertedFromQuickPost($row);
				}
			} else {
				if ("blog" == fbdbCheck($_REQUEST['layout']) && "com_content" == fbdbCheck($_REQUEST['option'])) {
					fbdbDebug("Hiding QuickPost in Blog layout.");
				} else {
					fbdbDebug("Building QuickPost form for Id " . $row->id);
					$quickPost .= fbdbBuildQuickPostForm($row);
				}
			}
			$quickPost .= '<br />';
		}
	}
		
	$actualPostCount = 0;

	// If there is no result from the first query let the link open a new reply possibility
	$showlink = "";
    if ($resultid == ""){
		$showlink = JRoute::_("index.php?option=com_fbb&Itemid=" . $Itemid
								. "&func=post&do=newFromBot&resubject=".strtr(base64_encode($row->title), "+/", "()")."&catid=".$catid
								. "&rowid=".$row->id."&rowItemid=".$rowItemid );
	} else {
		// Find out how many posts are actually in the thread 
		$sql = "SELECT count(id) from #__fb_messages where thread=$resultid";
		$database->setQuery($sql);
		$actualPostCount = $database->loadResult();
		if ($database->getErrorNum()) {
			fbdbDebug("Failed to count posts in thread:" . $database->stderr(), 1);
			return $database->stderr();
		}			
		fbdbDebug("Counted {$actualPostCount} actual post(s) in this thread #{$resultid}.");
		// Create a link to the FB thread and hang on to it until we need it
		$showlink = JRoute::_("index.php?option=com_fbb&Itemid=" . $Itemid
								. "&func=view&id=" . $resultid
								. "&catid=" . $catid);
	}
	
	// This will be used all the way through to tell users how many posts are in the forum.
	$displayedPostCount = 0;
	$content = "";
	if ($linkOnly) {
		fbdbDebug("Displaying Intro, link to the forum only.");
		
		$quickPost = "";  // Dump it.
		
		// Updated to match the same number that would be seen when displaying all the posts.
		// E.g. Remove the holds and remove the first thread where creating a separate post with the bot.
		if ($actualPostCount > 0) {
			// Remove the holds and remove the first thread where creating a separate post with the bot.
			if ($botCopyContent > 0) {
				$sql = "SELECT count(id) from #__fb_messages where hold=0 AND thread!=id AND thread=$resultid";
			} else {
				$sql = "SELECT count(id) from #__fb_messages where hold=0 AND thread=$resultid";
			}
			fbdbDebug("Counting posts with:" . $sql);
			fbdbDebug("botCopyContent:" . $botCopyContent);
			$database->setQuery($sql);
			$displayedPostCount = $database->loadResult();
			if ($database->getErrorNum()) {
				fbdbDebug("Failed to count displayed posts in thread for front page:" . $database->stderr(), 1);
				return $database->stderr();
			}			
			fbdbDebug("Counted {$displayedPostCount} displayed posts in this thread with holds and the copied content removed.");
		} else {
			fbdbDebug("There are zero actual posts in this thread, there are by default zero displayed posts.");
		}
	} else {
		fbdbDebug("Rendering Comments with $actualPostCount actual posts.");
		$content = fbdbRenderComments($actualPostCount, $resultid);
		// Update the $displayedPostCount as it's used to print a link indicating the number of posts eligible for display.
		$displayedPostCount = $actualPostCount;
	}
 
	$link = "";
	if ($botCopyContent && $resultid == "") {
		fbdbDebug("Building a link to create first post when not delegating it to Fireboard.");
		// Build the form used to create the first post when we're not delegating it to FB
		$link .= '<span class="fbdb-full-page">';
		if ($botUseButton) {
			$link .= '<a href="javascript:document.getElementById(\'first'.$row->id.'\').submit();"><img src="'.JURI::root().'plugins/content/fbdiscussbot/images/discuss.png" border="0" alt="'. _FBDB_DISCUSS_DOTDOTDOT .'" title="'.sprintf(_FBDB_DISCUSS_ON_FORUMS_X_POSTS, $displayedPostCount).'"></a>';
		} else {
			$link .= '<a href="javascript:document.getElementById(\'first'.$row->id.'\').submit();">'.sprintf(_FBDB_DISCUSS_ON_FORUMS_X_POSTS, $displayedPostCount).'</a>';
		}
		$link .= '</span>';
		$link .= '<form method="post" id="first'.$row->id.'" name="first'.$row->id.'">
						<input type="hidden" name="fb_firstpost" value="'.$row->id.'" /></form>';
	} else {
		// Build a simple link to create the new posts
		fbdbDebug("Building a simple link to create new posts.");
		$link .= '<span class="fbdb-full-page">';
		if ($botUseButton) {
			$link .= '<a href="'.$showlink.'"><img src="'.JURI::root().'plugins/content/fbdiscussbot/images/discuss.png" border="0" alt="'. _FBDB_DISCUSS_DOTDOTDOT .'" title="'.sprintf(_FBDB_DISCUSS_ON_FORUMS_X_POSTS, $displayedPostCount).'"></a>';
		} else {
			$link .= '<a href="'.$showlink.'">'.sprintf(_FBDB_DISCUSS_ON_FORUMS_X_POSTS, $displayedPostCount).'</a>';
		}	
		$link .= '</span>';
	}

 	// Apend the results of QuickPost
	fbdbDebug("Showing QuickPost " . ($botQuickPostOnTop?"above":"below") . " the article comments.");
	if ($botQuickPostOnTop) {
		$content = "<br />" . $quickPost . $link . "<br />" . $content;
	} else {
		$content = $content . "<br />" . $quickPost . $link;
	}
	
	return $content;
   }

/******************************************************************************
 *  
 *****************************************************************************/
 function fbdbRenderComments(&$countPosts, $resultid) {
	global $my,  $botPostLimit, 
			$botFirstPosts, $database, $botCopyContent, $botLastPostTop;
 
	$content = "";
	
	if ((int)$botPostLimit > 0) {
		// Start building a list of the posts for this content item
		if($countPosts > 0) {
		
			$postContent = "";
			$skipCounter = 0;
			$displayNum = 0;
			
			fbdbDebug("Limiting rendered comments to ".(int)$botPostLimit." posts.");
			
				// Updated to include message text and User info in one query!!
				$query = "  SELECT m.id, m.thread, m.hold, m.userid, m.name, m.time, m.catid, m.subject, u.avatar, mt.message";
				$query .=  "    FROM `#__fb_messages` AS m";
				if (fbdbGetConfigValue('avatar_src') == "cb") {
					// Option to use the CB avatar!
					$query .= "    LEFT JOIN `#__comprofiler` AS u ON (m.userid = u.user_id)";
				} else {
					$query .= "    LEFT JOIN `#__fb_users` AS u ON (m.userid = u.userid)";
				}
				$query .= "    LEFT JOIN `#__fb_messages_text` AS mt ON (mt.mesid = m.id)";
				$query .= "   WHERE m.thread={$resultid} ORDER BY m.id " . ($botFirstPosts?"ASC":"DESC") . " LIMIT " . (int)$botPostLimit;

				$database->setQuery($query);
				$rows = $database->loadObjectlist();
				if ($database->getErrorNum()) {
					fbdbDebug("Failed to select list of posts to be displayed:" . $database->stderr(), 1);
					return $database->stderr();
				}			
				
				fbdbDebug("Showing ".($botFirstPosts?"First":"Last")
								." posts in the thread in "
								.($botLastPostTop?"Decending":"Ascending")
								." order.");

				foreach($rows as $post) {

					include_once (JPATH_ROOT .'/components/com_fbb/template/default/smile.class.php');
					if (file_exists(JPATH_ROOT .'/components/com_fbb/sources/fb_debug.php')) {
						// Only exists in version FB 1.0.5+
						include_once (JPATH_ROOT .'/components/com_fbb/sources/fb_debug.php');
					}
					
					$showThisPost = 1;
					if ($post->id == $post->thread && $botCopyContent > 0) {
						// For "First Thread Handling" option 2 (value=1), don't show the copied content post.
						// For "First Thread Handling" option 3 (value=2), don't show the link-only post.
						$showThisPost = 0;
						$skipCounter++;  // Only count skipped first-posts, hold will be excluded in the query after this loop.
						fbdbDebug("Hiding first post with method #".($botCopyContent+1)." of first-thread-handling.");
					}
					if ($post->hold) {
						// This post is not yet approved by moderators.
						$showThisPost = 0;
						fbdbDebug("Hiding post #{$post->id} as it's pending moderator approval.");
					}
								
					if ($showThisPost) {
						fbdbDebug("Rendering post #{$post->id}.");
						
						// Do we have any modules in this position?
						$modPos = "";
						if ($displayNum == 1 || $displayNum == 2) {
							// After the first post or after the second post but only if there's another post to follow it.
					//		if (mosCountModules("discuss_{$displayNum}")) { 
							//	ob_start();
							//	mosLoadModules("discuss_{$displayNum}", -2);
							//	$modPos = "<div class=\"fbdb-disc-item fbdb-item" . (($displayNum%2)+1) . " discuss_{$displayNum}\">";
							//	// $modPos .= "<div class=\"fb_discussbot_{$displayNum}\">" . ob_get_contents() . "</div>";
							//	$modPos .= ob_get_contents();
							//	$modPos .= "</div>";
							//	ob_end_clean();
							//	$displayNum++;
						//	}
						}
					
						$id = $post->id;
						$smileArray =  FBTools::getEmoticons();
						$post->message = stripslashes(smile::smileReplace($post->message, 0, fbdbGetConfigValue('disemoticons'),$smileArray ));
						$post->message = preg_replace('/\n/', "<br />\n", $post->message);
						
						$postContent .= '<div class="fbdb-disc-item fbdb-item'.(($displayNum%2)+1).'">
								<a name="' . $id . '" id="' . $id . '" > </a>
								<table width="100%" border="0" cellspacing="0" cellpadding="0"><tbody><tr>
								<td valign="top" style="width:20%;text-align:center;">';
								
						// Determine if we should use an avatar and where to get it from
						if (fbdbGetConfigValue('allowAvatar')) {
							$postContent .= '<div class="fbdb-avatar">';

							if (fbdbGetConfigValue('avatar_src') == "clexuspm") {
								// Fireboard Profile and Clexus avatars - I don't *have* it so I can't *test* it...  Anyone?
								$postContent .= '<a class="fbdb-dsc-avatar" href="'.JURI::root().'index.php?option=com_fbb&func=fbprofile&task=showprf&userid='.$post->userid.'" >';
								$postContent .= '<span><img src="' . MyPMSTools::getAvatarLinkWithID($post->userid) . '" alt=" " /></span>';
								$postContent .= '</a><br />';
								$postContent .= '<span class="fbdb-view-username"><a href="'.JURI::root().'index.php?option=com_fbb&func=fbprofile&task=showprf&userid='.$post->userid.'" >'.$post->name.'</a></span>';
							} elseif (fbdbGetConfigValue('avatar_src') == "cb") {
								// Community Builder Profile and avatars
								// http://localhost/index.php?option=com_comprofiler&task=userProfile&user=123
								if ($post->avatar != "") {
									$imgpath = JURI::root() . 'images/comprofiler/';
									if (eregi("gallery/", $post->avatar)) {
										$imgpath .= $post->avatar;
									} else {
										$imgpath .= "tn" . $post->avatar;
									}
								} else {
									$imgpath = JURI::root() . "components/com_comprofiler/plugin/language/default_language/images/tnnophoto.jpg";
								}
								$postContent .= '<a class="fbdb-dsc-avatar" href="'.JURI::root().'index.php?option=com_comprofiler&task=userProfile&user='.$post->userid.'" >';
								$postContent .= '<span><img src="' . $imgpath . '" alt=" " /></span>';
								$postContent .= '</a><br />';
								$postContent .= '<span class="fbdb-view-username"><a href="'.JURI::root().'index.php?option=com_comprofiler&task=userProfile&user='.$post->userid.'" >'.$post->name.'</a></span>';
							} else {
								// Fireboard Profile and avatars
								if ($post->avatar) {
									$postContent .= '<a class="fbdb-dsc-avatar" href="'.JURI::root().'index.php?option=com_fbb&func=fbprofile&task=showprf&userid='.$post->userid.'" >';
									if (eregi("1.0.0", fbdbGetConfigValue('version')) || eregi("1.0.1", fbdbGetConfigValue('version'))) {
										// For FB version 1.0.0 or 1.0.1
										$postContent .= '<span><img src="'.JURI::root().'components/com_fbb/avatars/' . $post->avatar . '" alt=" "  border="0"/></span>';
									} else {
										// For FB 1.0.2+
										$postContent .= '<span><img src="'.JURI::root().'images/fbfiles/avatars/' . $post->avatar . '" alt=" "  border="0"/></span>';
									}
									$postContent .= '</a>';
								}
								$postContent .= '<br /><span class="fbdb-view-username"><a href="'.JURI::root().'index.php?option=com_fbb&func=fbprofile&task=showprf&userid='.$post->userid.'" >'.$post->name.'</a></span>';
							}
							$postContent .= '<br />';
							$postContent .= '</div>';
						} else {
							$postContent .= '<span class="fbdb-view-username"><a href="'.JURI::root().'index.php?option=com_fbb&func=fbprofile&task=showprf&userid='.$post->userid.'" >'.$post->name.'</a></span>';
						}
						// print_r($post);
						$postContent .= '</td>
										<td valign="top">
											<div class="fbdb-disc-item-cover" ><span class="fbdb-dsc-subject"> '.stripslashes($post->subject).'</span><br />
												<span class="fbdb-dsc-date">'.gmdate("M d Y H:i:s",$post->time).'</span>
												<div class="fbdb-dsc-text" >'.$post->message.'</div>
											</div>
										</td>
										<td valign="top" style="width:5%;text-align:right;">';
									// Ok, this didn't work out because of forum thread pagination from long topics...  
									// Would have been cool but too much effort required to build the URL.
									// $postContent .= '<a href="' 
									// // .  JRoute::_("index.php?option=com_fbb&Itemid=" . $Itemid . "&func=view&catid=" . $post->catid . "&id=" . $id) 
									// .  JRoute::_("index.php?option=com_fbb&func=view&id=" . $id . "&catid=" . $post->catid) 
									// . "#" . $id . '" title="Jump to this post in the forums">#' . $id 
									// . '</a>';
						$postContent .= _FBDB_HASH . "$id";
						$postContent .= "</td></tr></tbody></table></div>";
						
						
						// ************************************
						if ($botLastPostTop) {
							$content .= $modPos . $postContent;  // Append to the end
						} else {
							$content = $postContent . $modPos . $content; // Prepend to the front!
						}
						$postContent = "";
						$displayNum++;
					}
				}
			
				// Make sure we count all the posts
				$query = "SELECT count(*) FROM `#__fb_messages` WHERE hold = 0 AND thread = {$resultid}";
				$database->setQuery($query);
				$counter = $database->loadResult();
				if ($database->getErrorNum()) {
					fbdbDebug("Failed to do a final post count in thread:" . $database->stderr(), 1);
					return $database->stderr();
				}			
				$counter = $counter - $skipCounter;
				
				// Put the title back on the front
				$postTitle = '<div class="fbdb-dsc-title">' . sprintf(_FBDB_DISCUSS_POSTS, $counter) . '</div>';
				$content = $postTitle . $content;
				// ************************************
				if ($countPosts > $botPostLimit) {
					$content .= '<span class="fbdb-dsc-too-many">' . _FBDB_TOO_MANY_TO_LIST . '</span>';
				}
				// Update with the the number of displayed posts
				$countPosts = $counter;
		} else {
			$content = '<span class="fbdb-dsc-no-comments-a">' . _FBDB_NO_COMMENTS . '</span>';
		}
	} else {
		$content = '<span class="fbdb-dsc-no-comments-b"></span>';
	}

	return $content;
 }
/******************************************************************************
 *  
 *****************************************************************************/
	function fbdbHandlePostFromQuickPost($row, $postPerms, &$resultid, $prefix, $isMod, $catid, $subject, $insertTime, $ipAddy) {
		global  $database;
		global $botCopyContent, $botAllowPublicPost;
		$my = &JFactory::getUser();
		$result = "";
		$userid = '0';
		if($my->username != '') {
			$_POST['name'] = fbdbCheck($my->username);
			$_POST['email'] = fbdbCheck($my->email);
			$userid = $my->id;
		}

		$reject = 0;
		if ($my->username == '') {
			if ($botAllowPublicPost == 0) {
				$reject = 1; // Public posting disallowed
			}
		} else {
			if ($postPerms == 0) {
				$reject = 1; // User is not permitted to post
			}
		}
		
		if ($reject) {
			$quickPost .= _FBDB_YOU_DONT_HAVE_PERMISSION_TO_POST;
		} elseif(fbdbCheck($_POST['message']) == '') {
			$quickPost .= _FBDB_YOU_NEED_A_MESSAGE;
		} elseif(fbdbCheck($_POST['showing']) != '1') {
			$quickPost .= _FBDB_INVALID_SUBMISSION;
		} elseif(fbdbCheck($_POST['name']) == '' AND $my->username == '') {
			$quickPost .= _FBDB_YOU_NEED_A_NICKNAME;
		} else {
			
			// Cleanup values for the Insert SQL
			// $catid = // We already have the cat Id!!!
			$username = trim(addslashes(fbdbCheck($_POST['name'])));
			$email = trim(addslashes(fbdbCheck($_POST['email'])));
			$thread = $resultid; 
			$contentURL = "";
			// Only build a link back to the content for NEW threads.
			if ($thread == "" || $thread == 0) {
				$contentURL = $prefix;
				// If inserting content as the first post, we should do it here then set the threadid to the Id of the new post
				if ($botCopyContent > 0) {
					$thread = fbdbInsertContentAsFirstPost( $row, $catid, $subject, $contentURL, $insertTime, $ipAddy, $botCopyContent);
					// Since we've added records, we need the new ThreadId after processing QuickPost
					$resultid = $thread;
					$contentURL = "";
				}
			}
			$parent = $thread;
			
			$message = "";
			if ($contentURL) {
				$message = $contentURL . "\n\n" . $message;
			}
			// Changed in version 1.0.8
			// $message .= trim(htmlspecialchars(addslashes(fbdbCheck($_POST['message']))));
			// For some reason we were putting messages into the DB like this:
			// &quot;Show me the money!&quot;
			// instead of this:
			// I\'ll \"Show you *my* money\"...
			$message .= trim(addslashes(fbdbCheck($_POST['message'])));
			
			$holdPost = 0;
			// If user is not a moderator we may want to hold this post
			if (!$isMod) {
				$database->setQuery("SELECT review FROM #__fb_categories WHERE id={$catid}");
				$holdPost = $database->loadResult();
			}
			
			$query = "INSERT INTO #__fb_messages (id, parent, thread, catid, name, userid, email, subject, time, ip, hold)"
						. " VALUES ('', '{$parent}', '{$thread}', '{$catid}', '{$username}', '{$userid}', '{$email}', '{$subject}', '{$insertTime}', '{$ipAddy}', '{$holdPost}')";
			$database->setQuery($query);
			$database->query();
			if ($database->getErrorNum()) {
				fbdbDebug("Failed to insert new quickpost:" . $database->stderr(), 1);
				return $database->stderr();
			}		
			// Reselect the new ID using the value for timestamp
			$query = "SELECT min(id) FROM #__fb_messages WHERE time='{$insertTime}'";
			$database->setQuery($query);
			$newMessageId = $database->loadResult();
			if ($database->getErrorNum()) {
				fbdbDebug("Failed to select new quickpost threadId:" . $database->stderr(), 1);
				return $database->stderr();
			}		
			// We need to Update new Threads with the thread ID
			if ($thread == "" || $thread == 0) {
				$database->setQuery("UPDATE #__fb_messages set thread = id"
							. " WHERE id = '{$newMessageId}'");
				$database->query();
				if ($database->getErrorNum()) {
				fbdbDebug("Failed to update quickpost with the threadId:" . $database->stderr(), 1);
					return $database->stderr();
				}
				// We'll need to know about the new Thread id later...
				$resultid = $newMessageId;
			}			
			
			$query = "INSERT INTO #__fb_messages_text(mesid, message)"
						. " VALUES ('{$newMessageId}', '{$message}')";
			$database->setQuery($query);
			$database->query();
			if ($database->getErrorNum()) {
				fbdbDebug("Failed to insert new quickpost message text:" . $database->stderr(), 1);
				return $database->stderr();
			}
			// Update the user posts count because that's very important to people!!!  ;)
			if ($my->username != '') {
				$database->setQuery("UPDATE #__fb_users SET posts=posts+1"
										. " WHERE userid='".$my->id."'");
				$database->query();
				if ($database->getErrorNum()) {
					fbdbDebug("Failed to update users post count by quickpost:" . $database->stderr(), 1);
					return $database->stderr();
				}
			}
			
			// Update the category with the last post info
			$query = "UPDATE #__fb_categories"
						. " SET time_last_msg='{$insertTime}',"
						. " id_last_msg='{$newMessageId}',"
						. " numPosts = numPosts+1"
						. " WHERE id = '{$catid}'";
						
			$database->setQuery($query);
			$database->query();
			if ($database->getErrorNum()) {
				fbdbDebug("Failed to update category thread count by quickpost:" . $database->stderr(), 1);
				return $database->stderr();
			}
			
			 // Handle User subscrtiptiona and Moderator notifications.
			fbdbDoSubscriptions($thread, $newMessageId, $message, $subject, $catid);
			
			$result = _FBDB_YOUR_MESSAGE_HAS_BEEN_POSTED;
			if ($holdPost) {
				$result = _FBDB_PENDING_MODERATOR_APPROVAL;
			}
		}
		return $result;
	}
	
/******************************************************************************
 *  
 *****************************************************************************/
function fbdbBuildQuickPostForm($row) {
	global $my, $botSmilies, $botQuickPostOpen;

	$quickPost = '<script language="javascript" type="text/javascript">
function validate(form){
if (form != null) {

// do field validation
	if ( form.name.type == "text"  && form.name.value == "" ) {
		alert ( "'._FBDB_PLEASE_ENTER_YOUR_NAME.'" );
		return false;
	} else if ( form.email.type == "text"  && (( form.email.value == "" ) || ( form.email.value.search("@") == -1 ) || ( form.email.value.search("[.*]" ) == -1 ))) {
		alert ( "'._FBDB_PLEASE_ENTER_A_VALID_EMAIL_ADDRESS.'" );
		return false;
	} else if (form.captcha && form.captcha.value == "" ) {
		alert ( "'._FBDB_CAPTCHA_MISSING.'" );
		return false;
	} else if ( form.message.value == "" ) {
		alert ( "'._FBDB_PLESE_ENTER_SOME_TEXT.'" );
		return false;
	}
} else {
	alert("'._FBDB_UNABLE_TO_VALIDATE_FORM.'");
	return false;
}
return true;
}

function toggleQuickPost() {

	var showing = document.getElementById("showing");
	var quickPostDiv = document.getElementById("quickPost");
	showing.value = (showing.value == 1) ? 0 : 1;
	quickPostDiv.style.display = (showing.value == 1) ? "block" : "none";
}


// Insert emoticons
function emo($e) {
    var textfield = document.postform.message;
    if (document.selection) {
	    // Support for IE
        textfield.focus();
        var sel = document.selection.createRange();
        sel.text = $e;
    } else if (textfield.selectionStart || textfield.selectionStart == "0") {
		// Support for Mozilla
        var start = textfield.selectionStart;
        var end = textfield.selectionEnd;
        textfield.value = textfield.value.substring(0, start) + $e + textfield.value.substring(end, textfield.value.length);
    } else {
        textfield.value = textfield.value + $e;
    }
    textfield.focus();
}
</script>';





	$smilies = "";
	if ($botSmilies) {
		// Output buffering 'cause the generate_smilies() function 
		// echos it's output instead of returning it in a variable.  Grrr!!
		ob_start();
		generate_smilies();
		$smilies = "<table class='fbdb-quick-post-smilies' cellspacing=0 cellpadding=0>" . ob_get_contents() . "</table>";
		ob_end_clean();
		fbdbDebug("Smilies displayed " . ($botSmilies == 1?"Left":"Right") . " of the QuickPost form.");
	}
	
	$name = "";
	$email = "";
	$message = "";
require_once( JB_ABSSOURCESPATH . '/fb_bb1.js.php' );
	//. Set the state of the QuickPost form adding option to toggle if it's closed.
	if ($botQuickPostOpen) {
		$quickPost .= '<span class="fbdb-quick-post-title">' . _FBDB_QUICK_POST . '</span>';
		$quickPost .= '<div id="quickPost">';
	} else {
		$quickPost .= '<a href="#" class="fbdb-quick-post-toggle" onclick="toggleQuickPost(); return false;">'._FBDB_QUICK_POST.'</a>';
		$quickPost .= '<div id="quickPost" style="display:none;">';
	}
	$quickPost .= '<br /><form method="post" name="postform" onSubmit="return validate(this);">';
	$quickPost .= "<table cellspacing=0 cellpadding=0><tr>";
	// 1 == Smilies on the Left
	if ($botSmilies == 1) {
		$quickPost .= "<td valign='bottom'>" . $smilies . "</td>";
	}
	$quickPost .= "<td valign='top'>";

	// fbdbDebug("Logged in as:" . $my->username);
	// print_r($my);
	// fbdbDebug("Logged in as:" . $my->id);
	
	$quickPost .= "<table border=0 cellpadding=0>";  // Open a field layout table
	$my = &JFactory::getUser();
	if($my->username != '') {
		$quickPost .='<tr><td style="width:10%;"><span class="fbdb-quick-post-label">'._FBDB_NICKNAME.'&nbsp;</span></td>';
		$quickPost .=  '<td>' . $my->username;
		$quickPost .=  '<input type="hidden" name="name" value="">';
		$quickPost .=  '<input type="hidden" name="email" value=""></td></tr>' . "\n";
	} else {
		$quickPost .='<tr><td style="width:10%;"><span class="fbdb-quick-post-label">'._FBDB_NICKNAME.'&nbsp;</span></td>';
		$quickPost .=  '<td><input type="text" name="name" value="'.$name.'"></td></tr>' . "\n";
		
		$quickPost .='<tr><td style="width:10%;"><span class="fbdb-quick-post-label">'._FBDB_EMAIL.'&nbsp;</span></td>';
		$quickPost .=  '<td><input type="text" name="email" value="'.$email.'"></td></tr>' . "\n";
	}

	$quickPost .= '<tr><td style="width:10%;"><span class="fbdb-quick-post-label">'._FBDB_MESSAGE.'</span><input type="hidden" name="showing" id="showing" value="'.$botQuickPostOpen.'"></td></tr>' . "\n";  // Simple test to know a user clicked the link first
	$quickPost .= '<tr><td colspan="2"><textarea name="message" id="message" rows="5" cols="70">'.$message.'</textarea></td></tr>' . "\n";
	
	$quickPost .= "</table>\n"; // Close field layout table
	$quickPost .= '</td>' . "\n";
	// 2 == Smilies on the Right
	if ($botSmilies == 2) {
		$quickPost .= "<td valign='bottom'>" . $smilies . "</td>";
	}
	$quickPost .= "</tr></table>";
	// Include the Id of the item to be discussed.
	$quickPost .=  '<input type="hidden" name="fbdbContentId" value="' . $row->id . '">';
	
	
$quickPost .= '<input type = \'button\' class = \'fb_button\' accesskey = \'b\' name = \'addbbcode0\' value = \' B \' style = \'font-weight:bold; width: 30px\' onClick = "bbstyle(0)" />';
$quickPost .= ' <input type = \'button\' class = \'fb_button\' accesskey = \'i\' name = \'addbbcode2\' value = \' i \' style = \'font-style:italic; width: 30px\' onClick = "bbstyle(2)"/>';
$quickPost .= '<input type = \'button\' class = \'fb_button\' accesskey = \'q\' name = \'addbbcode5\' value = \'"Quote"\' style = \'width: 48px\' onClick = "bbstyle(5)"/>';
$quickPost .= '<input type = \'button\' class = \'fb_button\' accesskey = \'u\' name = \'addbbcode4\' value = \' u \' style = \'text-decoration: underline; width: 30px\' onClick = "bbstyle(4)"/>';

$quickPost .= '<input type = \'button\' class = \'fb_button\' accesskey = \'u\' name = \'addbbcode20\' value = \' Hide \' style = \'text-decoration: underline; width: 30px\' onClick = "bbstyle(20)"/>';

$quickPost .= '<input type = \'button\' class = \'fb_button\' accesskey = \'u\' name = \'addbbcode20\' value = \' Spoiler \' style = \'text-decoration: underline; width: 30px\' onClick = "bbstyle(22)"/>';

$quickPost .= '<input type = \'button\' class = \'fb_button\' accesskey = \'p\' name = \'addbbcode14\' value = \'Img\' style = \'width: 40px\' onClick = "bbstyle(14)"/>';
$quickPost .= '<input type = \'button\' class = \'fb_button\' accesskey = w\' name = \'addbbcode16\' value = \'URL\' style = \'text-decoration: underline; width: 40px\' onClick = "bbstyle(16)"/>';

$quickPost .= '<select class= \'fb_button\' name = \'addbbcode20\'';
$quickPost .= 'onchange = "bbfontstyle(\'[color=\' + this.form.addbbcode20.options[this.form.addbbcode20.selectedIndex].value + \']\',\'[/color]\');this.selectedIndex=0;" >';
$quickPost .= '<option style = \'color:black; background-color: #FAFAFA\' value = \'\'>Standard</option>';
$quickPost .= '<option style = \'color:#FF0000; background-color: #FAFAFA\' value = \'#FF0000\'>Red</option>';
$quickPost .= '<option style = \'color:#800080; background-color: #FAFAFA\' value = \'#800080\'>Purple</option>';
$quickPost .= '<option style = \'color:#0000FF; background-color: #FAFAFA\' value = \'#0000FF\'>Blue</option>';
$quickPost .= ' <option style = \'color:#008000; background-color: #FAFAFA\' value = \'#008000\'>Green</option>';
$quickPost .= '<option style = \'color:#FFFF00; background-color: #FAFAFA\' value = \'#FFFF00\'>Yellow</option>';
$quickPost .= ' <option style = \'color:#FF6600; background-color: #FAFAFA\' value = \'#FF6600\'>Orange</option>';
$quickPost .= '<option style = \'color:#000080; background-color: #FAFAFA\' value = \'#000080\'>Darkblue</option>';
$quickPost .= '<option style = \'color:#825900; background-color: #FAFAFA\' value = \'#825900\'>Brown</option>';
$quickPost .= '<option style = \'color:#9A9C02; background-color: #FAFAFA\' value = \'#9A9C02\'>Gold</option>';
$quickPost .= ' <option style = \'color:#A7A7A7; background-color: #FAFAFA\' value = \'#A7A7A7\'>Silver</option>';
$quickPost .= '<input type = \'button\' class = \'fb_button\' name=\'toggle\' value=\'toggle\'  />';
$quickPost .= '</select>';
$quickPost .= '<input type = \'reset\' onclick\'toggleQuickPost()\' class = \'fb_button\' name=\'Clear\' />
<input type = \'button\' class = \'fb_button\' onClick=\'message.select()\' name=\'Highlight All Text\' value=\'Highlight All Text\' />';
	
	
	$quickPost .= '<tr><td style="width:10%;"><input type="submit" class="button" value="'._FBDB_SUBMIT_BUTTON.'"/></td></tr>' . "\n";
	
	
	$quickPost .= '</form>';
	$quickPost .= '</div>';
			
	return $quickPost;
}
 
   
/******************************************************************************
 *  Return False (0) if the content item doesn't need a Discuss Link
 *****************************************************************************/
function fbdbContentItemIsValid( $sectionId, $catId ) {
	global $botOnlySections, $botIgnoreSections, $botOnlyCategories, $botIgnoreCategories;

	$m = "SectionId=$sectionId, CategoryId=$catId <br />";
	
	$counter = 0;
	// If sectionId and catId are not on the row - it's not a proper content item and therefore should NOT show the Discuss links!
	if (((int)$sectionId) && ((int)$catId)) {
		// Check the Include and Exclude lists
	  	if($botOnlySections && !in_array($sectionId, explode(',', $botOnlySections))) {
			fbdbDebug("$m SectionId not in the include list({$botOnlySections}).");
			$counter++;
		}
	  	if($botIgnoreSections && in_array($sectionId, explode(',', $botIgnoreSections))) {
			fbdbDebug("$m SectionId is in the ignore list({$botIgnoreSections}).");
			$counter++;
		}
	  	if($botOnlyCategories && !in_array($catId, explode(',', $botOnlyCategories))) {
			fbdbDebug("$m CategoryId not in the include list({$botOnlyCategories}).");
			$counter++;
		}
	  	if($botIgnoreCategories && in_array($catId, explode(',', $botIgnoreCategories))) {
			fbdbDebug("$m CategoryId is in the ignore list({$botIgnoreCategories}).");
			$counter++;
		}
	} else {
		// Static Content items end up here as they have no Section or Category Id's.
		fbdbDebug("$m Item does not qualify for the include/exclude lists.");
		$counter++;
	}
	// Return 1 for a valid Section Id and a valid category Id
	return $counter ? 0 : 1;
}

/******************************************************************************
 *  Print debug info if the bot is configured to print it.
 *****************************************************************************/
function fbdbDebug( $msg, $fatal=0 ) {
	global $botDebug, $botDebugUserids, $my;
	// Always displayed
	/*
	if ($fatal){
		echo "<br /><span class=\"fbdb-fatal\">[FBDISCUSSBOT FATAL: {$msg} ]</span>";
		die;
	}
	*/
	
	if ($botDebug) {
		$printIt = 0;
		if($botDebugUserids) {
			if (in_array($my->id, explode(',', $botDebugUserids))) {
				$printIt = 1;
			}
		} else {
			$printIt = 1;
		}
		if ($printIt) {
			if ($fatal){
				// Only displayed for Debug users
				echo "<br /><span class=\"fbdb-fatal\">[FBDISCUSSBOT FATAL: {$msg} ]</span>";
				//die;
			} else {
				echo "<br />[FBDISCUSSBOT DEBUG: {$msg} ]";
			}
		}
	}
}


/******************************************************************************
 *  Determine if the user has Post permission on this thread
 *  @param database object
 *  @param int
 *  @param int
 *  @param boolean
 *  @param boolean
 *****************************************************************************/
function fbdbHasPostPerms($catid, $replyto, $userid, $ismod) {
    global $database;
	
	$pubwrite = fbdbGetConfigValue('pubwrite'); // Can public post?
	
	// Skip the extra database lookups if we know this is a Logged in Moderator!
	if ($userid != 0 && $ismod) {
        $retVal = 1;
    } else {
		$topicLock = 0; 
	    if ($replyto != 0) {
			$database->setQuery("select thread from #__fb_messages where id='{$replyto}'");
			$topicID = $database->loadResult();

			$sql = 'select locked from #__fb_messages where id=' . ($topicID != 0 ? $topicID : $replyto);
	        $database->setQuery($sql);
	        $topicLock = $database->loadResult();
	    }
		// If the Thread isn't locked, check to see if the forum Category is locked.
	    if ($topicLock == 0) { 
			//topic not locked; check if forum is locked
	        $database->setQuery("select locked from #__fb_categories where id={$catid}");
	        $topicLock = $database->loadResult();
	    }
	    if (($userid != 0 || $pubwrite) && ($topicLock == 0 || $ismod)) {
	        $retVal = 1;  // Has permission
	    } else {
	        $retVal = 0;  // Does not have permission
	    }
    }
	fbdbDebug("User ". ($retVal ? "has" : "does not have") . " permission to post in FB category " . $catid . ".");
	
	return $retVal;
}

/******************************************************************************
 *  Determine if the user is a Moderator on this forum.
 *****************************************************************************/
function fbdbIsModerator($myId, $catId) {
	global $database, $acl;

	$permsFile = JPATH_ROOT.'/components/com_fbb/sources/fb_permissions.php';
	if (file_exists($permsFile)) {
		include_once($permsFile);
	} else {
		fbdbDebug ('Error, missing fb_permissions file: ' . $permsFile);
		return 0;
	}
	
	$categoryFile = JPATH_ROOT.'/components/com_fbb/sources/fb_category.class.php';
	if (file_exists($categoryFile)) {
		include_once($categoryFile);
	} else {
		fbdbDebug ('Error, missing fb_category class file: ' . $categoryFile);
		return 0;
	}
	
	// Default to Not a Moderator.
	$is_moderator = 0;
	
	if ($myId != 0) {
		// User is logged on - we have to check if they're a Moderator.
		
		$acl = &JFactory::getACL();
//$aro_group = $acl->getAroGroup($my->id);
		
	    $aro_group = $acl->getAroGroup($myId);
	    $is_admin = (strtolower($aro_group->name) == 'super administrator' || strtolower($aro_group->name) == 'administrator');
		
	    $obj_fb_cat = new jbCategory($database, $catId);
		$is_moderator = fb_has_moderator_permission($database, $obj_fb_cat, $myId, $is_admin);
	}	
	
	fbdbDebug("User is ". ($is_moderator?"":"NOT ") . "a moderator.");
	
	return $is_moderator;
}

/******************************************************************************
 *  Process subscriptions and whatnot...
 *****************************************************************************/
function fbdbDoSubscriptions ($thread, $pid, $message, $messagesubject, $catid) {

	global $mainframe;

	// Include the fireboard language file
$frontend_lang = null;
$language = JLanguage::getInstance($frontend_lang);
$mosConfig_lang = $language->getBackwardLang();
$database = JFactory::getDBO();
$my = &JFactory::getUser();

	fbdbDebug("Using language:{$mosConfig_lang}");
	
   	if (file_exists(JPATH_ROOT.'/administrator/components/com_fbb/language/'.$mosConfig_lang.'.php')) {
		include_once(JPATH_ROOT.'/administrator/components/com_fbb/language/'.$mosConfig_lang.'.php');
   	} else {
		include_once(JPATH_ROOT.'/administrator/components/com_fbb/language/english.php');
	}

	include_once (JPATH_ROOT . '/components/com_fbb/template/default/smile.class.php');
	if (file_exists(JPATH_ROOT .'/components/com_fbb/sources/fb_debug.php')) {
		// Only exists in version FB 1.0.5+
		include_once (JPATH_ROOT .'/components/com_fbb/sources/fb_debug.php');
	}
	include_once (JPATH_ROOT . '/components/com_fbb/sources/fb_mail.php'); // include fbMail class for mailing

	$database->setQuery("SELECT name FROM #__fb_categories WHERE id={$catid}");
	$catName = $database->loadResult();
	if ($database->getErrorNum()) {
		fbdbDebug("Failed to select category name:" . $database->stderr(), 1);
		echo $database->stderr();
		return;
	}

	//Now manage the subscriptions (only if subscriptions are allowed)
	if (fbdbGetConfigValue('allowsubscriptions') == 1) {
		//they're allowed
		
		// Get the Board title from the fb config
		$board_title = fbdbGetConfigValue('board_title');

		// Get info about the user who is posting
		$fb_authorname = $my->name;
		$ip = $_SERVER["REMOTE_ADDR"];
		
		// get the proper user credentials for each subscription to this topic
		if ($thread == 0) {
			$querythread = $pid;
		} else {
			$querythread = $thread;
		}

		fbdbDebug("Processing subscriptions for thread #{$querythread}.");

		//clean up the message
		$mailmessage = smile::purify($message);
		$database->setQuery("SELECT u.id, u.name, u.email FROM #__fb_subscriptions AS a"
							. "\n LEFT JOIN #__users as u ON a.userid=u.id "
							. "\n WHERE a.thread= {$querythread}");

		$subsList = $database->loadObjectList();
		//construct a useable URL (for plaintext - so no &amp; encoding!)
		$messageUrl = JRoute::_("index.php?option=com_fbb&func=view&catid=$catid&id=$pid") . "#$pid";

		
		if (count($subsList) > 0) { 
			//we got more than 0 subscriptions
			
			foreach ($subsList as $subs) {
				$mailsubject = sprintf(_FBDB_NEW_POST_NOTIFICATION, _GEN_SUBJECT, stripslashes($messagesubject), _FB_IN_FORUM, stripslashes($catName));
				$msg = $subs->name . ",\n";
				$msg .= sprintf(_FBDB_NEW_POST_TO_TOPIC, $board_title, _FB_FORUM);
				$msg .= $mailsubject . "\n";
				$msg .= _VIEW_POSTED.": " . stripslashes($fb_authorname) . "\n\n";
				$msg .= _FBDB_ADMIN_YOUR_SUBS . "\n";
				$msg .= "URL: {$messageUrl}\n\n";
				if (fbdbGetConfigValue('mailfull') == 1) {
					$msg .= _GEN_MESSAGE.":\n";
					$msg .= stripslashes($mailmessage);
				}
				$msg .= "\n\n" . _FBDB_GENERATED_MAIL . "\n\n\n\n\n\n";
				$msg .= "** Powered by Fireboard Discussbot **\n";
				$msg .= "** ObjectClarity.com - http://www.objectclarity.com **";

				if ($ip != "127.0.0.1" && $my->id != $subs->id) { //don't mail yourself
					fbdbDebug("Sending subscription notice ({$mailsubject}) to {$subs->email}.");
					mosmail(fbdbGetConfigValue('email'), _FB_FORUM_AT." " . $_SERVER['SERVER_NAME'], $subs->email, $mailsubject, $msg);
				} else {
					fbdbDebug("Skipped sending subscription notice ({$mailsubject}) to {$subs->email}.");
				}
			}
		}
	}

	//Now manage the mail for moderator or admins (only if configured)
	if(fbdbGetConfigValue('mailmod')=='1' || fbdbGetConfigValue('mailadmin')=='1') {
		//they're configured
		//get the proper user credentials for each moderator for this forum
		$sql = "SELECT u.id, u.name, u.email FROM #__users AS u";
		if(fbdbGetConfigValue('mailmod')==1) {
			$sql .= "\n LEFT JOIN #__fb_moderation AS a";
			$sql .= "\n ON a.userid=u.id";
			$sql .= "\n  AND a.catid=$catid";
		}
		$sql .= "\n WHERE 1=1";
		$sql .= "\n AND (";
		// helper for OR condition
		$sql2 = '';
		if(fbdbGetConfigValue('mailmod')==1) {
			$sql2 .= " a.userid IS NOT NULL";
		}
		if(fbdbGetConfigValue('mailadmin')==1) {
			if(strlen($sql2)) { 
				$sql2 .= "\n  OR "; 
			}
			$sql2 .= " u.sendEmail=1";
		}
		$sql .= "\n" . $sql2;
		$sql .= "\n)";

		$database->setQuery($sql);
		$modsList = $database->loadObjectList();

		if (count($modsList) > 0) {
			//we got more than 0 moderators eligible for email
			foreach ($modsList as $mods) {
				$mailsubject = sprintf(_FBDB_NEW_POST_NOTIFICATION, _GEN_SUBJECT, stripslashes($messagesubject), _FB_IN_FORUM, stripslashes($catName));
				$msg = $mods->name . ",\n";
				$msg .= sprintf(_FBDB_NEW_POST_TO_MODERATE, $board_title, _FB_FORUM) . "\n";
				$msg .= $mailsubject . "\n";
				$msg .= _VIEW_POSTED.": " . stripslashes($fb_authorname) . "\n\n";
				$msg .= _FBDB_MODERATOR_PLEASE_REVIEW . "\n";
				$msg .= "URL: {$messageUrl}\n\n";
				if (fbdbGetConfigValue('mailfull') == 1) {
					$msg .= _GEN_MESSAGE . ":\n";
					$msg .= stripslashes($mailmessage);
				}
				$msg .= "\n\n" . _FBDB_GENERATED_MAIL . "\n\n\n\n\n\n";
				$msg .= "** Powered by Fireboard Discussbot **\n";
				$msg .= "** ObjectClarity.com - http://www.objectclarity.com **";

				if ($ip != "127.0.0.1" && $my->id != $mods->id) { //don't mail yourself
					//Send away
					fbdbDebug("Sending moderator notice ({$mailsubject}) to {$mods->email}.");
					mosmail(fbdbGetConfigValue('email'), "Forum at " . $_SERVER['SERVER_NAME'], $mods->email, $mailsubject, $msg);
				} else {
					fbdbDebug("Skipped sending moderator notice ({$mailsubject}) to {$mods->email}.");
				}
			}
		}
	}
	// TODO: Add ability to subscribe new posters
	$subscribeMe = 0;
	
	//now try adding any new subscriptions if asked for by the poster
	if ($subscribeMe == 1) {
		if ($thread == 0) {
			$fb_thread = $pid;
		} else {
			$fb_thread = $thread;
		}

		$database->setQuery("INSERT INTO #__fb_subscriptions (thread,userid) VALUES ('$fb_thread','{$my->id}')");
		if ($database->query()) {
			echo _POST_SUBSCRIBED_TOPIC . "<br /><br />";
		} else {
			echo _POST_NO_SUBSCRIBED_TOPIC . "<br /><br />";
		}
	}
}

function fbdbGetConfigValue($key) {
	global  $database, $mainframe;
	global $fbConfig, $configLoaded;
	$key = strtolower($key);
	// Include the fireboard config - once!
	/*if (file_exists(JPATH_ROOT."/components/com_fbb/sources/fb_config.class.php")) {
		require_once (JPATH_ROOT."/components/com_fbb/sources/fb_config.class.php");
		
		if (!$configLoaded) {
			$fbConfig = new fb_config();
			$fbConfig->load();	
			$configLoaded = 1;
			fbdbDebug("FB Config loaded from the DB.");
		}
		$key = strtolower($key);
	} else {
		if (file_exists( JPATH_ROOT.'/administrator/components/com_fbb/fireboard_config.php' )) {
			include_once( JPATH_ROOT.'/administrator/components/com_fbb/fireboard_config.php' );
			// fbdbDebug("FB Config loaded from the config file");
		} else {
			die("Error, missing fireboard config file!");
		}
	}
	
   	if (file_exists( JPATH_ROOT.'/components/com_fbb/class.fbb.php' )) {
		require_once( JPATH_ROOT.'/components/com_fbb/class.fbb.php' );
	} else {
		die('Error, missing fireboard class file!');
	}
	
	$result = "";
	$debugInfo = get_class($fbConfig);
	if (strtolower(get_class($fbConfig)) == "fb_config") {
		// FB config from the DBprint
		$tmp = get_object_vars($fbConfig);
		
		$debugInfo .= ",DB";
	} else {
		// FB Config from a file
		$result = $fbConfig[$key];
		$debugInfo .= ",File";
	}
	
	*/
	//print_r($fbConfig);
	$result = $fbConfig->$key;
	$debugInfo = '';
	fbdbDebug("FB Config($debugInfo): $result");
	return $result;
}

?>