<?php
/*=======================================================================*\
|| ##################################################################### ||
|| # vBCredits 1.4 - `credits_admin.php`							   # ||
|| # ------------------------------------------------------------------# ||
|| # Author: John Jakubowski "Darkwaltz4" {blackwaltz4@msn.com}		   # ||
|| # Copyright 2007-2008 PixelFX Studios Ltd. All Rights Reserved.	   # ||
|| # This file may not be redistributed in whole or significant part.  # ||
|| # -----------------vBulletin IS NOT FREE SOFTWARE!------------------# ||
|| #                Support: http://www.vbcredits.com/				   # ||
|| ##################################################################### ||
\*=======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
@set_time_limit(0);
ignore_user_abort(1);

// #################### DEFINE IMPORTANT CONSTANTS #######################

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array(
	'cprofilefield',
	'cpuser',
	'cpusergroup',
	'credits_admin',
	'maintenance',
	'subscription',
	'user'
);
// get special data templates from the datastore
$specialtemplates = array('credits_central');
// pre-cache templates used by all actions
$globaltemplates = array();
// pre-cache templates used by specific actions
$actiontemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_profilefield.php');
require_once(DIR . '/includes/adminfunctions_user.php');

// ######################## CHECK ADMIN PERMISSIONS #######################

// ############################# LOG ACTION ###############################
log_admin_action();

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

$usergroups = array();
print_cp_header('vBCredits');

foreach ($vbulletin->usergroupcache AS $ugid => $ugcache)
{
	$usergroups[$ugid] = $ugcache['title'];
}

$creditawards = array(
	'credit_induction' => $vbphrase['credit_induction_label'],
	'credit_referral' => $vbphrase['credit_referral_label'],
	'credit_paycheck' => $vbphrase['credit_paycheck_label'],
	'credit_birthday' => $vbphrase['credit_birthday_label'],
	'credit_repgive' => $vbphrase['credit_repgive_label'],
	'credit_reputation' => $vbphrase['credit_reputation_label'],
	'credit_infraction' => $vbphrase['credit_infraction_label'],
	'credit_thread' => $vbphrase['credit_thread_label'],
	'credit_threadrate' => $vbphrase['credit_threadrate_label'],
	'credit_post' => $vbphrase['credit_post_label'],
	'credit_ownthreadpost' => $vbphrase['credit_ownthreadpost_label'],
	'credit_postsize' => $vbphrase['credit_postsize_label'],
	'credit_ownthreadview' => $vbphrase['credit_ownthreadview_label'],
	'credit_ownthreadrate' => $vbphrase['credit_ownthreadrate_label'],
	'credit_ownthreadreply' => $vbphrase['credit_ownthreadreply_label'],
	'credit_pollmake' => $vbphrase['credit_pollmake_label'],
	'credit_pollvote' => $vbphrase['credit_pollvote_label'],
	'credit_attachment' => $vbphrase['credit_attachment_label'],
	'credit_sendpm' => $vbphrase['credit_sendpm_label'],
	'credit_addevent' => $vbphrase['credit_addevent_label'],
	'credit_addprofpic' => $vbphrase['credit_addprofpic_label'],
	'credit_profile' => $vbphrase['credit_profile_label']
);

($hook = vBulletinHook::fetch_hook('credits_admin_start')) ? eval($hook) : false;

// ###################### Start apply formulas #######################
if ($_REQUEST['do'] == 'applyusers')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'checking_formula'	=> TYPE_NOHTML,
		'savings_formula'	=> TYPE_NOHTML,
		'credits'			=> TYPE_ARRAY_NUM,
		'credits_saved'		=> TYPE_ARRAY_NUM
	));

	$invalid = false;
	$parens = array(array(0, 0), array(0, 0));
	$strip_regex = '/[^\dDPRICS\.\+\-\*\/\(\)]/';

	($hook = vBulletinHook::fetch_hook('credits_admin_massusers_prep')) ? eval($hook) : false;

	$cform = preg_replace($strip_regex, '', trim(strtoupper($vbulletin->GPC['checking_formula'])));
	$sform = preg_replace($strip_regex, '', trim(strtoupper($vbulletin->GPC['savings_formula'])));

	for ($which = 0; $which < 2; $which++)
	{
		if (!$which)
		{
			$form =& $cform;
		}
		else
		{
			$form =& $sform;
		}
		for ($x = 0; $x < strlen($form); $x++)
		{
			$bef = ( $x == 0 ? '?' : $form{$x - 1} );
			$aft = ( $x == strlen($form) - 1 ? '?' : $form{$x + 1} );

			$checks = array(
				array('DPRICS(', $bef, true, '*'),
				array('DPRICS)', $aft, true, '*'),
				array('+-', $bef, false, '0'),
				array('+-', $aft, false, '0'),
				array('*/', $bef, false, '1'),
				array('*/', $aft, false, '1')
			);

			($hook = vBulletinHook::fetch_hook('credits_admin_massusers_check')) ? eval($hook) : false;

			if ($form{$x} == '.' AND (string) intval($bef) != $bef AND (string) intval($aft) != $aft)
			{
				$form{$x} = '0';
			}
			if ($form{$x} == '(' AND $aft == ')')
			{
				$invalid = true;
			}
			if ($form{$x} == '(')
			{
				$parens[0][0]++;
			}
			if ($form{$x} == ')')
			{
				$parens[0][1]++;
			}
			foreach ($checks AS $check)
			{
				if (strpos($check[0], $form{$x}) !== false AND (strpos('+-/*?', $check[1]) === false) == $check[2])
				{
					$after = ($check[1] == $aft);
					$form = substr($form, 0, $x + intval($after)) . $check[3] . substr($form, $x + intval($after));
					$x -= intval(!$after);
					break;
				}
			}
			if (strpos('*/', $form{0}) !== false)
			{
				$invalid = true;
			}
		}
	}
	if ($invalid OR in_array('', array($cform, $sform)) OR $parens[0][0] != $parens[0][1] OR $parens[1][0] != $parens[1][1])
	{
		print_stop_message('credits_badfomula');
	}

	$users = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "user WHERE userid IN (" . implode(', ', array_keys($vbulletin->GPC['credits'])) . ")");

	while ($user = $db->fetch_array($users))
	{
		$vars = array('D', 'P', 'R', 'I', 'C', 'S');
		$maths = array(
			floor((TIMENOW - $user['joindate']) / 86400),
			$user['posts'],
			'(' . $user['reputation'] . ')',
			$user['ipoints'],
			'(' . $vbulletin->GPC['credits'][$user['userid']] . ')',
			'(' . $vbulletin->GPC['credits_saved'][$user['userid']] . ')'
		);

		($hook = vBulletinHook::fetch_hook('credits_admin_massusers_save')) ? eval($hook) : false;

		eval('$credits = ' . str_replace($vars, $maths, $cform) . ';');
		eval('$saved = ' . str_replace($vars, $maths, $sform) . ';');
		$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = $credits, credits_saved = $saved WHERE userid = " . $user['userid']);
	}

	$db->free_result($users);
	print_cp_message($vbphrase['credits_acp_usersdone'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=users');
}

// ###################### Start user results #######################
if ($_REQUEST['do'] == 'findusers')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'user'		=> TYPE_ARRAY,
		'profile'	=> TYPE_ARRAY
	));

	$user = $vbulletin->GPC['user'];
	$condition = fetch_user_search_sql($vbulletin->GPC['user'], $vbulletin->GPC['profile']);
	$condition .= iif($user['creditsupper'] != '', " AND {$prefix}credits < " . doubleval($user['creditsupper']));
	$condition .= iif($user['creditslower'] != '', " AND {$prefix}credits >= " . doubleval($user['creditslower']));
	$condition .= iif($user['savingupper'] != '', " AND {$prefix}credits_saved < " . doubleval($user['savingupper']));
	$condition .= iif($user['savinglower'] != '', " AND {$prefix}credits_saved >= " . doubleval($user['savinglower']));

	($hook = vBulletinHook::fetch_hook('credits_admin_massusers_find')) ? eval($hook) : false;

	$searchquery = "
		SELECT
		user.*, (options & " . $vbulletin->bf_misc_useroptions['coppauser'] . ") AS coppauser, userfield.*
		FROM " . TABLE_PREFIX . "user AS user
		LEFT JOIN " . TABLE_PREFIX . "userfield AS userfield ON(userfield.userid = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON(usertextfield.userid = user.userid)
		WHERE $condition
		ORDER BY username ASC";

	$countusers = $db->query_first("
		SELECT COUNT(*) AS users
		FROM " . TABLE_PREFIX . "user AS user
		LEFT JOIN " . TABLE_PREFIX . "userfield AS userfield ON(userfield.userid = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON(usertextfield.userid = user.userid)
		WHERE $condition
	");

	$users = $db->query_read($searchquery);

	if ($countusers['users'] == 1)
	{
		$user = $db->fetch_array($users);
		print_cp_message(construct_phrase($vbphrase['only_x_matched_your_query'], $user['username']), 'user.php?' . $vbulletin->session->vars['sessionurl'] . 'do=edit&amp;u=' . $user['userid']);
	}
	else if ($countusers['users'] == 0)
	{
		print_stop_message('no_users_matched_your_query');
	}

	print_form_header('credits_admin', 'applyusers');
	print_column_style_code(array('width: 70%', 'width: 30%'));
	print_table_header($vbphrase['credits_acp_editusers']);
	print_description_row($vbphrase['credits_acp_userswarning']);
	print_description_row($vbphrase['credits_acp_usersexplain']);
	print_input_row($vbphrase['credits_acp_cformula'], 'checking_formula', 'C');
	print_input_row($vbphrase['credits_acp_sformula'], 'savings_formula', 'S');
	print_table_break();

	print_table_header($vbphrase['credits_acp_eligibleusers'], 9);
	print_cells_row(array(
		$vbphrase['username'],
		$vbphrase['usergroup'],
		$vbphrase['credits_days_registered'],
		$vbphrase['post_count'],
		$vbphrase['reputation'],
		$vbphrase['infraction_points'],
		$vbphrase['credits_checking'],
		$vbphrase['credits_savings']
	), 1);

	while ($user = $db->fetch_array($users))
	{
		print_cells_row(array(
			"<a href=\"user.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&amp;u=$user[userid]\"><b>$user[username]</b></a>&nbsp;",
			$vbulletin->usergroupcache[$user['usergroupid']]['title'],
			floor((TIMENOW - $user['joindate']) / 86400),
			vb_number_format($user['posts']),
			vb_number_format($user['reputation']),
			vb_number_format($user['ipoints']),
			'<input type="text" name="credits[' . $user['userid'] . ']" value="' . $user['credits'] . '" size="10" />',
			'<input type="text" name="credits_saved[' . $user['userid'] . ']" value="' . $user['credits_saved'] . '" size="10" />'
		));
	}

	print_submit_row($vbphrase['save'], $vbphrase['reset'], 9);
}

// ###################### Start user search #######################
if ($_REQUEST['do'] == 'users')
{
	print_form_header('credits_admin', 'findusers');
	print_table_header($vbphrase['credits_acp_editusers']);
	print_description_row($vbphrase['credits_acp_userinfo']);
	print_table_break();

	($hook = vBulletinHook::fetch_hook('credits_admin_massusers')) ? eval($hook) : false;

	print_table_header($vbphrase['advanced_search']);
	print_description_row($vbphrase['if_you_leave_a_field_blank_it_will_be_ignored']);
	print_description_row('<img src="../' . $vbulletin->options['cleargifurl'] . '" alt="" width="1" height="2" />', 0, 2, 'thead');
	print_input_row($vbphrase['credits_acp_checkinggt'], 'user[creditslower]');
	print_input_row($vbphrase['credits_acp_checkinglt'], 'user[creditsupper]');
	print_input_row($vbphrase['credits_acp_savinggt'], 'user[savinglower]');
	print_input_row($vbphrase['credits_acp_savinglt'], 'user[savingupper]');
	print_description_row('<img src="../' . $vbulletin->options['cleargifurl'] . '" alt="" width="1" height="2" />', 0, 2, 'thead');
	print_user_search_rows();
	print_submit_row($vbphrase['find'], $vbphrase['reset'], 2, '', '<input type="submit" class="button" value="' . $vbphrase['exact_match'] . '" tabindex="1" name="user[exact]" />');
}

// ###################### Start update usergroups #######################
if ($_REQUEST['do'] == 'save_ugs')
{
	$updatestring = $perms = array();
	$groups = $vbulletin->input->clean_gpc('r', 'applygroups', TYPE_ARRAY_UINT);

	($hook = vBulletinHook::fetch_hook('credits_admin_massgroups_save')) ? eval($hook) : false;

	if (sizeof($groups))
	{
		foreach ($_POST AS $key => $val)
		{
			if (in_array($key, array('credit_locked', 'credit_hidden', 'credit_special', 'credit_hidetop', 'credit_cananon', 'credit_cansee', 'credit_canview', 'credit_moddonate', 'credit_modawards', 'credit_pasneg', 'credit_moddeposit', 'credit_modloan')))
			{
				$perms[$key] = $vbulletin->input->clean_gpc('r', $key, TYPE_BOOL);
			}
			else if (substr($key, 0, 7) == 'credit_')
			{
				$updatestring[] = $key . ' = ' . $vbulletin->input->clean_gpc('r', $key, TYPE_NUM);
			}
		}

		require_once(DIR . '/includes/functions_misc.php');
		$db->query_write("UPDATE " . TABLE_PREFIX . "usergroup SET creditpermissions = " . convert_array_to_bits($perms, $vbulletin->bf_ugp['creditpermissions']) . ", " . implode(', ', $updatestring) . " WHERE usergroupid IN (" . implode(', ', $groups) . ")");
		build_forum_permissions();
		print_cp_message($vbphrase['credits_acp_ugupdate'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=usergroups');
	}
	else
	{
		print_cp_message($vbphrase['credits_acp_nogroups'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=usergroups');
	}
}

// ###################### Start edit usergroups #######################
if ($_REQUEST['do'] == 'usergroups')
{
	$baseid = $vbulletin->input->clean_gpc('r', 'baseid', TYPE_UINT);
	echo '<form action="credits_admin.php?do=usergroups" method="post"><div align="center">' . $vbphrase['credits_tempgroup'] . ': <select name="baseid" onchange="this.form.submit();">' . construct_select_options(array('') + $usergroups, $baseid) . '</select> <input type="submit" value="' . $vbphrase['reload'] . '"></div></form>';

	print_form_header('credits_admin', 'save_ugs');
	print_column_style_code(array('width: 70%', 'width: 30%'));
	print_table_header($vbphrase['credits_acp_multug']);
	print_select_row($vbphrase['credits_acp_pickgroups'], 'applygroups[]', $usergroups, '', false, 7, true);
	print_table_break();

	$vbulletin->usergroupcache[0] = array();
	$groupinfo = $vbulletin->usergroupcache[$baseid];
	$groupperms = convert_bits_to_array($groupinfo['creditpermissions'], $vbulletin->bf_ugp['creditpermissions']);

	print_column_style_code(array('width: 70%', 'width: 30%'));
	print_table_header($vbphrase['credit_set_awards']);
	print_yes_no_row($vbphrase['credit_locked'], 'credit_locked', $groupperms['credit_locked']);
	print_yes_no_row($vbphrase['credit_hidden'], 'credit_hidden', $groupperms['credit_hidden']);
	print_input_row($vbphrase['credit_induction'], 'credit_induction', $groupinfo['credit_induction']);
	print_input_row($vbphrase['credit_referral'], 'credit_referral', $groupinfo['credit_referral']);
	print_input_row($vbphrase['credit_refbonus'], 'credit_refbonus', $groupinfo['credit_refbonus']);
	print_input_row($vbphrase['credit_paycheck'], 'credit_paycheck', $groupinfo['credit_paycheck']);
	print_input_row($vbphrase['credit_active'], 'credit_active', $groupinfo['credit_active']);
	print_input_row($vbphrase['credit_birthday'], 'credit_birthday', $groupinfo['credit_birthday']);
	print_input_row($vbphrase['credit_repgive'], 'credit_repgive', $groupinfo['credit_repgive']);
	print_input_row($vbphrase['credit_reputation'], 'credit_reputation', $groupinfo['credit_reputation']);
	print_input_row($vbphrase['credit_infraction'], 'credit_infraction', $groupinfo['credit_infraction']);
	print_input_row($vbphrase['credit_thread'], 'credit_thread', $groupinfo['credit_thread']);
	print_input_row($vbphrase['credit_threadrate'], 'credit_threadrate', $groupinfo['credit_threadrate']);
	print_input_row($vbphrase['credit_post'], 'credit_post', $groupinfo['credit_post']);
	print_input_row($vbphrase['credit_ownthreadpost'], 'credit_ownthreadpost', $groupinfo['credit_ownthreadpost']);
	print_input_row($vbphrase['credit_postsize'], 'credit_postsize', $groupinfo['credit_postsize']);
	print_input_row($vbphrase['credit_ownthreadview'], 'credit_ownthreadview', $groupinfo['credit_ownthreadview']);
	print_input_row($vbphrase['credit_ownthreadrate'], 'credit_ownthreadrate', $groupinfo['credit_ownthreadrate']);
	print_input_row($vbphrase['credit_ownthreadreply'], 'credit_ownthreadreply', $groupinfo['credit_ownthreadreply']);
	print_input_row($vbphrase['credit_ownprofileview'], 'credit_ownprofileview', $groupinfo['credit_ownprofileview']);
	print_input_row($vbphrase['credit_pollmake'], 'credit_pollmake', $groupinfo['credit_pollmake']);
	print_input_row($vbphrase['credit_pollvote'], 'credit_pollvote', $groupinfo['credit_pollvote']);
	print_input_row($vbphrase['credit_attachment'], 'credit_attachment', $groupinfo['credit_attachment']);
	print_input_row($vbphrase['credit_sendpm'], 'credit_sendpm', $groupinfo['credit_sendpm']);
	print_input_row($vbphrase['credit_addevent'], 'credit_addevent', $groupinfo['credit_addevent']);
	print_input_row($vbphrase['credit_addprofpic'], 'credit_addprofpic', $groupinfo['credit_addprofpic']);
	print_input_row($vbphrase['credit_profile'], 'credit_profile', $groupinfo['credit_profile']);
	print_table_break();

	print_column_style_code(array('width: 70%', 'width: 30%'));
	print_table_header($vbphrase['credit_set_perms']);
	print_yes_no_row($vbphrase['credit_special'], 'credit_special', $groupperms['credit_special']);
	print_yes_no_row($vbphrase['credit_hidetop'], 'credit_hidetop', $groupperms['credit_hidetop']);
	print_yes_no_row($vbphrase['credit_cananon'], 'credit_cananon', $groupperms['credit_cananon']);
	print_yes_no_row($vbphrase['credit_cansee'], 'credit_cansee', $groupperms['credit_cansee']);
	print_yes_no_row($vbphrase['credit_canview'], 'credit_canview', $groupperms['credit_canview']);
	print_table_break();

	print_column_style_code(array('width: 70%', 'width: 30%'));
	print_table_header($vbphrase['credit_set_donpas']);
	print_yes_no_row($vbphrase['credit_moddonate'], 'credit_moddonate', $groupperms['credit_moddonate']);
	print_input_row($vbphrase['credit_donmaxuser'], 'credit_donmaxuser', $groupinfo['credit_donmaxuser']);
	print_yes_no_row($vbphrase['credit_modawards'], 'credit_modawards', $groupperms['credit_modawards']);
	print_yes_no_row($vbphrase['credit_pasneg'], 'credit_pasneg', $groupperms['credit_pasneg']);
	print_input_row($vbphrase['credit_pastotpost'], 'credit_pastotpost', $groupinfo['credit_pastotpost']);
	print_input_row($vbphrase['credit_pastotuser'], 'credit_pastotuser', $groupinfo['credit_pastotuser']);
	print_input_row($vbphrase['credit_pasawuser'], 'credit_pasawuser', $groupinfo['credit_pasawuser']);
	print_input_row($vbphrase['credit_pasawthread'], 'credit_pasawthread', $groupinfo['credit_pasawthread']);
	print_table_break();

	print_column_style_code(array('width: 70%', 'width: 30%'));
	print_table_header($vbphrase['credit_set_banklot']);
	print_yes_no_row($vbphrase['credit_moddeposit'], 'credit_moddeposit', $groupperms['credit_moddeposit']);
	print_input_row($vbphrase['credit_saveint'], 'credit_saveint', $groupinfo['credit_saveint']);
	print_input_row($vbphrase['credit_maxsave'], 'credit_maxsave', $groupinfo['credit_maxsave']);
	print_yes_no_row($vbphrase['credit_modloan'], 'credit_modloan', $groupperms['credit_modloan']);
	print_input_row($vbphrase['credit_loanint'], 'credit_loanint', $groupinfo['credit_loanint']);
	print_input_row($vbphrase['credit_maxloan'], 'credit_maxloan', $groupinfo['credit_maxloan']);
	print_input_row($vbphrase['credit_totloan'], 'credit_totloan', $groupinfo['credit_totloan']);
	print_input_row($vbphrase['credit_goodgroup'], 'credit_goodgroup', $groupinfo['credit_goodgroup']);
	print_input_row($vbphrase['credit_midgroup'], 'credit_midgroup', $groupinfo['credit_midgroup']);
	print_input_row($vbphrase['credit_badgroup'], 'credit_badgroup', $groupinfo['credit_badgroup']);
	print_input_row($vbphrase['credit_maxtickets'], 'credit_maxtickets', $groupinfo['credit_maxtickets']);
	print_input_row($vbphrase['credit_lotdiscount'], 'credit_lotdiscount', $groupinfo['credit_lotdiscount']);
	print_table_break();

	($hook = vBulletinHook::fetch_hook('credits_admin_massgroups')) ? eval($hook) : false;

	print_submit_row();
}

// ###################### Start save overrides #######################
if ($_REQUEST['do'] == 'save_forums')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'applyforums'		=> TYPE_ARRAY_UINT,
		'applygroups'		=> TYPE_ARRAY_UINT,
		'applyawards'		=> TYPE_ARRAY_NOHTML,
		'forum_override'	=> TYPE_NUM
	));

	($hook = vBulletinHook::fetch_hook('credits_admin_forumor_save')) ? eval($hook) : false;

	if (sizeof($vbulletin->GPC['applyforums']) AND sizeof($vbulletin->GPC['applygroups']) AND sizeof($vbulletin->GPC['applyawards']))
	{
		foreach ($vbulletin->GPC['applyforums'] AS $forum)
		{
			foreach ($vbulletin->GPC['applygroups'] AS $group)
			{
				foreach ($vbulletin->GPC['applyawards'] AS $award)
				{
					$vbulletin->credits_forum_overrides[$forum][$group][$award] = $vbulletin->GPC['forum_override'];
				}
			}
		}

		build_datastore('credits_forum_overrides', serialize($vbulletin->credits_forum_overrides), 1);
		print_cp_message($vbphrase['credits_acp_forumorsuc'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=forums');
	}
	else
	{
		print_cp_message($vbphrase['credits_acp_forumorbad'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=forums');
	}
}

// ###################### Start delete overrides #######################
if ($_REQUEST['do'] == 'del_forums')
{
	$delstr = $vbulletin->input->clean_gpc('r', 'delstr', TYPE_NOHTML);
	$delfor = explode('_', $delstr, 3);

	($hook = vBulletinHook::fetch_hook('credits_admin_forumor_delete')) ? eval($hook) : false;

	if (sizeof($delfor) == 3)
	{
		unset($vbulletin->credits_forum_overrides[$delfor[0]][$delfor[1]][$delfor[2]]);

		if (empty($vbulletin->credits_forum_overrides[$delfor[0]][$delfor[1]]))
		{
			unset($vbulletin->credits_forum_overrides[$delfor[0]][$delfor[1]]);
		}
		if (empty($vbulletin->credits_forum_overrides[$delfor[0]]))
		{
			unset($vbulletin->credits_forum_overrides[$delfor[0]]);
		}

		build_datastore('credits_forum_overrides', serialize($vbulletin->credits_forum_overrides), 1);
		print_cp_message($vbphrase['credits_acp_delforor'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=forums');
	}
	else
	{
		$_REQUEST['do'] = 'forums';
	}
}

// ###################### Start forum overrides #######################
if ($_REQUEST['do'] == 'forums')
{
	print_form_header('credits_admin', 'save_forums');
	print_table_header($vbphrase['credits_acp_forumor'], 5);
	print_cells_row(array(
		$vbphrase['forum'],
		$vbphrase['usergroup'],
		$vbphrase['award'],
		$vbphrase['credits_amount'],
		$vbphrase['controls']
	), 1);

	if (sizeof($vbulletin->credits_forum_overrides))
	{	
		foreach ($vbulletin->credits_forum_overrides AS $forumid => $ugs)
		{
			if (sizeof($ugs))
			{
				print_description_row("$vbphrase[forum] : " . $vbulletin->forumcache[$forumid]['title'], 0, 5, 'tfoot');

				foreach ($ugs AS $ugid => $awards)
				{
					if (sizeof($awards))
					{
						foreach ($awards AS $award => $value)
						{
							print_cells_row(array(
								$vbulletin->forumcache[$forumid]['title'],
								$vbulletin->usergroupcache[$ugid]['title'],
								$vbphrase[$award . '_label'],
								$value,
								construct_link_code($vbphrase['delete'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=del_forums&amp;delstr=' . $forumid . '_' . $ugid . '_' . $award)
							));
						}
					}
				}
			}
		}
	}
	else
	{
		print_description_row($vbphrase['credits_acp_nothingdisplay'], false, 5, '', 'center');
	}

	unset($creditawards['credit_induction'], $creditawards['credit_referral'], $creditawards['credit_paycheck'], $creditawards['credit_birthday'], $creditawards['credit_repgive'], $creditawards['credit_reputation'], $creditawards['credit_sendpm'], $creditawards['credit_addevent'], $creditawards['credit_addprofpic'], $creditawards['credit_profile']);

	($hook = vBulletinHook::fetch_hook('credits_admin_forumor')) ? eval($hook) : false;

	print_table_break();
	print_column_style_code(array('width: 70%', 'width: 30%'));
	print_table_header($vbphrase['credits_acp_forumoradd']);
	print_forum_chooser($vbphrase['credits_acp_forumorforums'], 'applyforums[]', 0, null, false, true);
	print_select_row($vbphrase['credits_acp_forumorgroups'], 'applygroups[]', $usergroups, '', false, 7, true);
	print_select_row($vbphrase['credits_acp_forumorawards'], 'applyawards[]', $creditawards, '', false, 7, true);
	print_input_row($vbphrase['credits_acp_forumorval'], 'forum_override', 0);
	print_submit_row();
}

$tickettypes = array('raffle' => $vbphrase['raffle'], 'lottery' => $vbphrase['lottery']);
$jackpottypes = array('raise' => $vbphrase['raising'], 'static' => $vbphrase['static']);
$lotteryid = $vbulletin->input->clean_gpc('r', 'lotteryid', TYPE_UINT);

// ###################### Start remove lottery #######################
if ($_REQUEST['do'] == 'lottery_kill')
{
	if ($lotteryid)
	{
		($hook = vBulletinHook::fetch_hook('credits_admin_drawing_delete')) ? eval($hook) : false;

		$db->query_write("DELETE FROM " . TABLE_PREFIX . "credits_lottery WHERE lotteryid = $lotteryid");
		print_cp_message($vbphrase['credits_acp_lotterydel'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=lottery');
	}
	else
	{
		$_REQUEST['do'] = 'lottery';
	}
}

// ###################### Start delete lottery #######################
if ($_REQUEST['do'] == 'lottery_delete')
{
	if ($lotteryid)
	{
		print_delete_confirmation('credits_lottery', $lotteryid, 'credits_admin', 'lottery_kill');
	}
	else
	{
		$_REQUEST['do'] = 'lottery';
	}
}

// ###################### Start update lottery #######################
if ($_REQUEST['do'] == 'lottery_save')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'lotteryid'		=> TYPE_UINT,
		'title'			=> TYPE_STR,
		'drawtime'		=> TYPE_ARRAY_UINT,
		'recurdays'		=> TYPE_UINT,
		'tickets'		=> TYPE_NOHTML,
		'wintype'		=> TYPE_NOHTML,
		'jackpot'		=> TYPE_UNUM,
		'excluded'		=> TYPE_ARRAY_UINT,
		'ticketcost'	=> TYPE_UNUM,
		'mintickets'	=> TYPE_UINT,
		'winnerphp'		=> TYPE_NOCLEAN
	));

	if (!empty($vbulletin->GPC['title']) AND $vbulletin->GPC['ticketcost'])
	{
		require_once(DIR . '/includes/functions_misc.php');
		$vbulletin->GPC['drawtime'] = vbmktime(0, 0, 0, $vbulletin->GPC['drawtime']['month'], $vbulletin->GPC['drawtime']['day'], $vbulletin->GPC['drawtime']['year']);

		if (empty($vbulletin->GPC['mintickets']))
		{
			$vbulletin->GPC['mintickets'] = 1;
		}
		if ($vbulletin->GPC['lotteryid'])
		{
			$lottery = $db->query_first("SELECT tickets, heldtickets FROM " . TABLE_PREFIX . "credits_lottery WHERE lotteryid = " . $vbulletin->GPC['lotteryid']);
			$lottery['heldtickets'] = unserialize($lottery['heldtickets']);

			if ($lottery['tickets'] != $vbulletin->GPC['tickets'])
			{
				$newtickets = array();

				if ($vbulletin->GPC['tickets'] == 'raffle')
				{
					foreach ($lottery['heldtickets'] AS $userid => $tickets)
					{
						$newtickets[$userid] = sizeof($tickets);
					}
				}
				else
				{
					foreach ($lottery['heldtickets'] AS $userid => $tickets)
					{
						for ($x = 0; $x < $tickets; $x++)
						{
							$newtickets[$userid][] = vbrand(1, $vbulletin->options['credits_lotteryrange']);
						}
					}
				}

				$lottery['heldtickets'] = $newtickets;
			}

			$db->query_write("
				UPDATE " . TABLE_PREFIX . "credits_lottery SET
					title = '" . $db->escape_string($vbulletin->GPC['title']) . "',
					drawtime = " . $vbulletin->GPC['drawtime'] . ",
					recurdays = " . $vbulletin->GPC['recurdays'] . ",
					active = " . intval($vbulletin->GPC['drawtime'] > TIMENOW) . ",
					tickets = '" . $db->escape_string($vbulletin->GPC['tickets']) . "',
					wintype = '" . $db->escape_string($vbulletin->GPC['wintype']) . "',
					jackpot = " . $vbulletin->GPC['jackpot'] . ",
					excluded = '" . $db->escape_string(serialize($vbulletin->GPC['excluded'])) . "',
					ticketcost = " . $vbulletin->GPC['ticketcost'] . ",
					mintickets = " . $vbulletin->GPC['mintickets'] . ",
					heldtickets = '" . $db->escape_string(serialize($lottery['heldtickets'])) . "',
					winnerphp = '" . $db->escape_string($vbulletin->GPC['winnerphp']) . "'
				WHERE lotteryid = " . $vbulletin->GPC['lotteryid']
			);
		}
		else
		{
			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "credits_lottery
					(title, winner, drawtime, recurdays, active, tickets, wintype, jackpot, excluded, ticketcost, mintickets, winnerphp, heldtickets)
				VALUES
					(
						'" . $db->escape_string($vbulletin->GPC['title']) . "',
						'" . $db->escape_string(serialize(array())) . "',
						" . $vbulletin->GPC['drawtime'] . ",
						" . $vbulletin->GPC['recurdays'] . ",
						" . intval($vbulletin->GPC['drawtime'] > TIMENOW) . ",
						'" . $db->escape_string($vbulletin->GPC['tickets']) . "',
						'" . $db->escape_string($vbulletin->GPC['wintype']) . "',
						" . $vbulletin->GPC['jackpot'] . ",
						'" . $db->escape_string(serialize($vbulletin->GPC['excluded'])) . "',
						" . $vbulletin->GPC['ticketcost'] . ",
						" . $vbulletin->GPC['mintickets'] . ",
						'" . $db->escape_string($vbulletin->GPC['winnerphp']) . "',
						'" . $db->escape_string(serialize(array())) . "'
					)
			");
		}

		($hook = vBulletinHook::fetch_hook('credits_admin_drawing_save')) ? eval($hook) : false;

		print_cp_message($vbphrase['credits_acp_lotteryok'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=lottery');
	}
	else
	{
		print_cp_message($vbphrase['credits_acp_lotterybad'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=lottery');
	}
}

// ###################### Start edit lotteries #######################
if ($_REQUEST['do'] == 'lottery_manage')
{
	if ($lotteryid)
	{
		$lottery = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "credits_lottery WHERE lotteryid = $lotteryid");

		if ($lottery['lotteryid'])
		{
			$lottery['excluded'] = unserialize($lottery['excluded']);
		}
	}
	if (empty($lottery))
	{
		$lottery = array('drawtime' => TIMENOW + 86400, 'recurdays' => 0, 'jackpot' => 0, 'ticketcost' => 0, 'mintickets' => 1);
	}

	print_form_header('credits_admin', 'lottery_save');
	construct_hidden_code('lotteryid', $lottery['lotteryid']);
	print_column_style_code(array('width: 70%', 'width: 30%'));
	print_table_header(( $lotteryid ? $vbphrase['credits_acp_editlottery'] : $vbphrase['credits_acp_addlottery'] ));
	print_input_row($vbphrase['credits_acp_lotterytitle'], 'title', $lottery['title']);
	print_time_row($vbphrase['credits_acp_lotterytime'], 'drawtime', $lottery['drawtime'], false);
	print_input_row($vbphrase['credits_acp_lotteryrecur'], 'recurdays', $lottery['recurdays']);
	print_select_row($vbphrase['credits_acp_lotterytype'], 'tickets', $tickettypes, $lottery['tickets']);
	print_select_row($vbphrase['credits_acp_lotteryjtype'], 'wintype', $jackpottypes, $lottery['wintype']);
	print_input_row($vbphrase['credits_acp_lotteryjackpot'], 'jackpot', $lottery['jackpot']);
	print_select_row($vbphrase['credits_acp_lotterygroups'], 'excluded[]', $usergroups, $lottery['excluded'], false, 7, true);
	print_input_row($vbphrase['credits_acp_lotterycost'], 'ticketcost', $lottery['ticketcost']);
	print_input_row($vbphrase['credits_acp_lotterymin'], 'mintickets', $lottery['mintickets']);
	print_textarea_row($vbphrase['credits_acp_lotteryphp'], 'winnerphp', $lottery['winnerphp']);

	($hook = vBulletinHook::fetch_hook('credits_admin_drawing_edit')) ? eval($hook) : false;

	print_submit_row();
}

// ###################### Start view lotteries #######################
if ($_REQUEST['do'] == 'lottery')
{
	$lotteries = $names = $usernames = array();
	$lot = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "credits_lottery ORDER BY drawtime ASC");

	while ($loty = $db->fetch_array($lot))
	{
		if ($loty['active'])
		{
			$holders = unserialize($loty['heldtickets']);
			$loty['heldtickets'] = 0;

			foreach ($holders AS $user)
			{
				$loty['heldtickets'] += ( $loty['tickets'] == 'raffle' ? $user : sizeof($user) );
			}
		}
		else
		{
			$loty['winner'] = unserialize($loty['winner']);

			foreach ($loty['winner'] AS $user)
			{
				$names[] = $user;
			}
		}

		$lotteries[$loty['active']][] = $loty;
	}
	if (sizeof($names))
	{
		$names = $db->query_read("SELECT username, userid FROM " . TABLE_PREFIX . "user WHERE userid IN (" . implode(', ', $names) . ")");

		while ($name = $db->fetch_array($names))
		{
			$usernames[$name['userid']] = $name['username'];
		}

		$db->free_result($names);
	}

	$db->free_result($lot);

	($hook = vBulletinHook::fetch_hook('credits_admin_drawing_list')) ? eval($hook) : false;

	print_table_start();
	print_table_header($vbphrase['credits_acp_activelotteries'], 6);
	print_cells_row(array(
		$vbphrase['title'],
		$vbphrase['credits_drawtime'],
		$vbphrase['credits_type'],
		$vbphrase['jackpot'],
		$vbphrase['tickets'],
		$vbphrase['controls']
	), 1);

	if (is_array($lotteries[1]))
	{
		foreach ($lotteries[1] AS $lottery)
		{
			print_cells_row(array(
				$lottery['title'],
				vbdate($vbulletin->options['dateformat'], $lottery['drawtime']),
				$jackpottypes[$lottery['wintype']] . ' ' . $tickettypes[$lottery['tickets']],
				vb_number_format($lottery['jackpot'], $vbulletin->options['credits_decimals']),
				$lottery['heldtickets'],
				construct_link_code($vbphrase['edit'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=lottery_manage&amp;lotteryid=' . $lottery['lotteryid']) . construct_link_code($vbphrase['delete'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=lottery_delete&amp;lotteryid=' . $lottery['lotteryid'])
			));
		}
	}
	else
	{
		print_description_row($vbphrase['credits_acp_nothingdisplay'], false, 6, '', 'center');
	}

	print_table_break();
	print_table_header($vbphrase['credits_acp_completedlotteries'], 6);
	print_cells_row(array(
		$vbphrase['title'],
		$vbphrase['credits_drawtime'],
		$vbphrase['credits_type'],
		$vbphrase['jackpot'],
		$vbphrase['winner'],
		$vbphrase['controls']
	), 1);

	if (is_array($lotteries[0]))
	{
		foreach (array_reverse($lotteries[0]) AS $lottery)
		{
			$winstr = array();

			foreach ($lottery['winner'] AS $user)
			{
				if (!in_array($usernames[$user], $winstr))
				{
					$winstr[] = $usernames[$user];
				}
			}

			print_cells_row(array(
				$lottery['title'],
				vbdate($vbulletin->options['dateformat'], $lottery['drawtime']),
				$jackpottypes[$lottery['wintype']] . ' ' . $tickettypes[$lottery['tickets']],
				vb_number_format($lottery['jackpot'], $vbulletin->options['credits_decimals']),
				implode('<br />', $winstr),
				construct_link_code($vbphrase['edit'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=lottery_manage&amp;lotteryid=' . $lottery['lotteryid']) . construct_link_code($vbphrase['delete'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=lottery_delete&amp;lotteryid=' . $lottery['lotteryid'])
			));
		}
	}
	else
	{
		print_description_row($vbphrase['credits_acp_nothingdisplay'], false, 6, '', 'center');
	}

	print_table_footer();
	echo '<p align="center">' . construct_link_code($vbphrase['credits_acp_addlottery'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=lottery_manage') . '</p>';
}

$awardid = $vbulletin->input->clean_gpc('r', 'awardid', TYPE_UINT);

// ###################### Start accept award #######################
if ($_REQUEST['do'] == 'accept_award')
{
	$award = $db->query_first("SELECT award.*, user.* FROM " . TABLE_PREFIX . "credits_transactions AS award LEFT JOIN " . TABLE_PREFIX . "user AS user ON(award.touserid = user.userid) WHERE award.action IN('donate', 'award', 'post') AND award.completed = 0 AND award.transactionid = " . $awardid);

	if ($award['transactionid'])
	{
		$fromuser = fetch_userinfo($award['fromuserid']);
		$touser = fetch_userinfo($award['touserid']);
		$fromperms = $vbulletin->usergroupcache[$fromuser['usergroupid']];
		$toperms = $vbulletin->usergroupcache[$touser['usergroupid']];
		$title = $vbphrase['credits_pm_post_subject'];

		($hook = vBulletinHook::fetch_hook('credits_admin_award_accept')) ? eval($hook) : false;

		if ($award['action'] == 'donate')
		{
			$donatefee = $award['amount'] * $vbulletin->options['credits_donatefee'];

			if ($vbulletin->options['credits_feetype'] == 'neg')
			{
				$award['amount'] -= $donatefee;
			}

			build_datastore('credits_central', $vbulletin->credits_central + $donatefee, false);
			$title = construct_phrase($vbphrase['credits_pm_subject'], $vbphrase['credits']);
		}

		$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits + " . $award['amount'] . " WHERE userid = " . $award['touserid']);
		$db->query_write("UPDATE " . TABLE_PREFIX . "credits_transactions SET completed = 1 WHERE transactionid = " . $award['transactionid']);

		if ($vbulletin->options['credits_pmid'])
		{
			$dsender = fetch_userinfo($vbulletin->options['credits_pmid']);
			$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_SILENT);
			$pmdm->overridequota = true;
			$pmdm->set('fromuserid', $dsender['userid']);
			$pmdm->set('fromusername', $dsender['username']);
			$pmdm->set_recipients($award['username'], $pmperms);
			$pmdm->set('dateline', TIMENOW);
			$pmdm->set('allowsmilie', 1);
			$pmdm->setr('title', $title);
			$pmdm->setr('message', construct_phrase($vbphrase['credits_pm' . ( $award['action'] != 'donate' ? '_post' : '' ) . '_body'], $award['username'], vb_number_format($award['amount'], $vbulletin->options['credits_decimals']), $vbphrase['credits'], ( ($award['anonymous'] AND $vbulletin->bf_ugp['creditpermissions']['credit_cananon'] & $fromperms['creditpermissions'] AND !($vbulletin->bf_ugp['creditpermissions']['credit_cansee'] & $toperms['creditpermissions'])) ? $vbphrase['anonymous'] : $fromuser['username'] ), fetch_censored_text($award['comment']), $vbphrase['transaction_log']));
			$pmdm->set_info('receipt', 0);
			$pmdm->set_info('savecopy', 0);
			$pmdm->save();
		}

		print_cp_message($vbphrase['credits_acp_award_allow'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=mod_donpas');
	}
	else
	{
		$_REQUEST['do'] == 'mod_donpas';
	}
}

// ###################### Start delete award #######################
if ($_REQUEST['do'] == 'deny_award')
{
	$award = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "credits_transactions WHERE action IN('donate', 'award', 'post') AND completed = 0 AND transactionid = " . $awardid);

	if ($award['transactionid'])
	{
		($hook = vBulletinHook::fetch_hook('credits_admin_award_deny')) ? eval($hook) : false;

		if ($award['action'] == 'donate')
		{
			if ($vbulletin->options['credits_feetype'] == 'pos')
			{
				$award['amount'] *= (1 + $vbulletin->options['credits_donatefee']);
			}

			$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits + " . $award['amount'] . " WHERE userid = " . $award['fromuserid']);
		}
		else if ($vbulletin->options['credits_usecentral'])
		{
			build_datastore('credits_central', $vbulletin->credits_central + $award['amount'], false);
		}

		$db->query_write("DELETE FROM " . TABLE_PREFIX . "credits_transactions WHERE transactionid = " . $award['transactionid']);
		print_cp_message($vbphrase['credits_acp_award_deny'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=mod_donpas');
	}
	else
	{
		$_REQUEST['do'] == 'mod_donpas';
	}
}

// ###################### Start cancel award #######################
if ($_REQUEST['do'] == 'cancel_award')
{
	$award = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "credits_transactions WHERE action IN('donate', 'award', 'post') AND completed = 1 AND transactionid = " . $awardid);

	if ($award['transactionid'])
	{
		($hook = vBulletinHook::fetch_hook('credits_admin_award_cancel')) ? eval($hook) : false;

		if ($award['action'] == 'donate')
		{
			$donatefee = $award['amount'] * $vbulletin->options['credits_donatefee'];

			if ($vbulletin->options['credits_feetype'] == 'neg')
			{
				$award['amount'] -= $donatefee;
			}

			build_datastore('credits_central', $vbulletin->credits_central - $donatefee, false);
		}

		$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits - " . $award['amount'] . " WHERE userid = " . $award['touserid']);
		$db->query_write("UPDATE " . TABLE_PREFIX . "credits_transactions SET completed = 0 WHERE transactionid = " . $award['transactionid']);
		print_cp_message($vbphrase['credits_acp_award_cancel'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=mod_donpas');
	}
	else
	{
		$_REQUEST['do'] == 'mod_donpas';
	}
}

// ###################### Start list awards #######################
if ($_REQUEST['do'] == 'mod_donpas')
{
	$awards = $names = $usernames = array();
	$awds = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "credits_transactions WHERE action IN('donate', 'award', 'post') ORDER BY timestamp ASC");

	while ($award = $db->fetch_array($awds))
	{
		if (!in_array($award['touserid'], $names))
		{
			$names[] = $award['touserid'];
		}
		if (!in_array($award['fromuserid'], $names))
		{
			$names[] = $award['fromuserid'];
		}

		$awards[$award['completed']][] = $award;
	}
	if (sizeof($names))
	{
		$names = $db->query_read("SELECT username, userid FROM " . TABLE_PREFIX . "user WHERE userid IN (" . implode(', ', $names) . ")");

		while ($name = $db->fetch_array($names))
		{
			$usernames[$name['userid']] = $name['username'];
		}

		$db->free_result($names);
	}

	$db->free_result($awds);

	($hook = vBulletinHook::fetch_hook('credits_admin_award_list')) ? eval($hook) : false;

	print_table_start();
	print_table_header($vbphrase['credits_acp_modawards'], 7);
	print_cells_row(array(
		$vbphrase['date'],
		$vbphrase['credits_method'],
		$vbphrase['credits_from_user'],
		$vbphrase['credits_to_user'],
		$vbphrase['credits_comment'],
		$vbphrase['credits_amount'],
		$vbphrase['controls']
	), 1);

	$methods = array('donate' => $vbphrase['donate'], 'award' => $vbphrase['profile'], 'post' => $vbphrase['post']);

	if (is_array($awards[0]))
	{
		foreach ($awards[0] AS $award)
		{
			print_cells_row(array(
				vbdate($vbulletin->options['dateformat'], $award['timestamp'], true),
				( $award['action'] == 'post' ? '<a href="../showpost.php?' . $vbulletin->session->vars['sessionurl'] . 'p=' . $award['postid'] . '">' . $methods[$award['action']] . '</a>' : $methods[$award['action']] ),
				'<a href="user.php?' . $vbulletin->session->vars['sessionurl'] . 'do=edit&amp;u=' . $award['fromuserid'] . '">' . $usernames[$award['fromuserid']] . '</a>',
				'<a href="user.php?' . $vbulletin->session->vars['sessionurl'] . 'do=edit&amp;u=' . $award['touserid'] . '">' . $usernames[$award['touserid']] . '</a>',
				strip_bbcode($award['comment'], true),
				vb_number_format($award['amount'], $vbulletin->options['credits_decimals']),
				construct_link_code($vbphrase['accept'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=accept_award&amp;awardid=' . $award['transactionid']) . construct_link_code($vbphrase['deny'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=deny_award&amp;awardid=' . $award['transactionid'])
			));
		}
	}
	else
	{
		print_description_row($vbphrase['credits_acp_nothingdisplay'], false, 7, '', 'center');
	}

	print_table_break();
	print_table_header($vbphrase['credits_acp_comawards'], 7);
	print_cells_row(array(
		$vbphrase['date'],
		$vbphrase['credits_method'],
		$vbphrase['credits_from_user'],
		$vbphrase['credits_to_user'],
		$vbphrase['credits_comment'],
		$vbphrase['credits_amount'],
		$vbphrase['controls']
	), 1);

	if (is_array($awards[1]))
	{
		foreach (array_reverse($awards[1]) AS $award)
		{
			print_cells_row(array(
				vbdate($vbulletin->options['dateformat'], $award['timestamp'], true),
				( $award['action'] == 'post' ? '<a href="../showpost.php?' . $vbulletin->session->vars['sessionurl'] . 'p=' . $award['postid'] . '">' . $methods[$award['action']] . '</a>' : $methods[$award['action']] ),
				'<a href="user.php?' . $vbulletin->session->vars['sessionurl'] . 'do=edit&amp;u=' . $award['fromuserid'] . '">' . $usernames[$award['fromuserid']] . '</a>',
				'<a href="user.php?' . $vbulletin->session->vars['sessionurl'] . 'do=edit&amp;u=' . $award['touserid'] . '">' . $usernames[$award['touserid']] . '</a>',
				strip_bbcode($award['comment'], true),
				vb_number_format($award['amount'], $vbulletin->options['credits_decimals']),
				construct_link_code($vbphrase['cancel'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=cancel_award&amp;awardid=' . $award['transactionid'])
			));
		}
	}
	else
	{
		print_description_row($vbphrase['credits_acp_nothingdisplay'], false, 7, '', 'center');
	}

	print_table_footer();
}

$bankid = $vbulletin->input->clean_gpc('r', 'bankid', TYPE_UINT);

// ###################### Start accept bank #######################
if ($_REQUEST['do'] == 'accept_bank')
{
	$bank = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "credits_bank WHERE status = 0 AND bankid = " . $bankid);

	if ($bank['bankid'])
	{
		($hook = vBulletinHook::fetch_hook('credits_admin_bank_accept')) ? eval($hook) : false;

		if ($bank['type'] == 'loan')
		{
			$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits + " . $bank['current'] . " WHERE userid = " . $bank['userid']);
		}

		$db->query_write("INSERT INTO " . TABLE_PREFIX . "credits_transactions (fromuserid, touserid, action, comment, amount, timestamp, completed) VALUES (" . ( $bank['type'] == 'loan' ? "0, " . $bank['userid'] : $bank['userid'] . ", 0" ) . ", '" . ( $bank['type'] == 'loan' ? 'loan' : 'save' ) . "', '" . $db->escape_string($bank['reason']) . "', " . $bank['amount'] . ", " . TIMENOW . ", 1)");
		$db->query_write("UPDATE " . TABLE_PREFIX . "credits_bank SET status = 1 WHERE bankid = " . $bank['bankid']);
		print_cp_message($vbphrase['credits_acp_award_allow'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=mod_banking');
	}
	else
	{
		$_REQUEST['do'] == 'mod_banking';
	}
}

// ###################### Start delete bank #######################
if ($_REQUEST['do'] == 'deny_bank')
{
	$bank = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "credits_bank WHERE status = 0 AND bankid = " . $bankid);

	if ($bank['bankid'])
	{
		($hook = vBulletinHook::fetch_hook('credits_admin_bank_deny')) ? eval($hook) : false;

		if ($bank['type'] == 'save')
		{
			$bankfee = $bank['amount'] * $vbulletin->options['credits_bankfee'];
			$bank['amount'] += $bankfee;
			$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits + " . $bank['amount'] . " WHERE userid = " . $bank['userid']);
			build_datastore('credits_central', $vbulletin->credits_central - $bankfee, false);
		}

		$db->query_write("DELETE FROM " . TABLE_PREFIX . "credits_bank WHERE bankid = " . $bank['bankid']);
		print_cp_message($vbphrase['credits_acp_award_deny'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=mod_banking');
	}
	else
	{
		$_REQUEST['do'] == 'mod_banking';
	}
}

// ###################### Start cancel bank #######################
if ($_REQUEST['do'] == 'cancel_bank')
{
	$bank = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "credits_bank WHERE status = 1 AND bankid = " . $bankid);

	if ($bank['bankid'])
	{
		($hook = vBulletinHook::fetch_hook('credits_admin_bank_cancel')) ? eval($hook) : false;

		if ($bank['type'] == 'loan')
		{
			$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits - " . $bank['current'] . " WHERE userid = " . $bank['userid']);
		}

		$db->query_write("INSERT INTO " . TABLE_PREFIX . "credits_transactions (fromuserid, touserid, action, comment, amount, timestamp, completed) VALUES (" . ( $bank['type'] == 'loan' ? $bank['userid'] . ", 0" : "0, " . $bank['userid'] ) . ", '" . ( $bank['type'] == 'loan' ? 'loan' : 'save' ) . "', '" . $db->escape_string($bank['reason']) . "', " . $bank['amount'] . ", " . TIMENOW . ", 1)");
		$db->query_write("UPDATE " . TABLE_PREFIX . "credits_bank SET status = 0 WHERE bankid = " . $bank['bankid']);
		print_cp_message($vbphrase['credits_acp_award_cancel'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=mod_banking');
	}
	else
	{
		$_REQUEST['do'] == 'mod_banking';
	}
}

// ###################### Start list bank #######################
if ($_REQUEST['do'] == 'mod_banking')
{
	$banks = array();
	$bnks = $db->query_read("SELECT bank.*, user.* FROM " . TABLE_PREFIX . "credits_bank AS bank LEFT JOIN " . TABLE_PREFIX . "user AS user ON(bank.userid = user.userid) WHERE status < 2 ORDER BY timestamp ASC");

	while ($bank = $db->fetch_array($bnks))
	{
		$banks[$bank['status']][] = $bank;
	}

	$db->free_result($bnks);

	($hook = vBulletinHook::fetch_hook('credits_admin_bank_list')) ? eval($hook) : false;

	print_table_start();
	print_table_header($vbphrase['credits_acp_pendbank'], 6);
	print_cells_row(array(
		$vbphrase['date'],
		$vbphrase['credits_type'],
		$vbphrase['user'],
		$vbphrase['reason'],
		$vbphrase['credits_amount'],
		$vbphrase['controls']
	), 1);

	$types = array('save' => $vbphrase['credits_deposit'], 'loan' => $vbphrase['credits_loan']);

	if (is_array($banks[0]))
	{
		foreach ($banks[0] AS $bank)
		{
			print_cells_row(array(
				vbdate($vbulletin->options['dateformat'], $bank['timestamp'], true),
				$types[$bank['type']],
				'<a href="user.php?' . $vbulletin->session->vars['sessionurl'] . 'do=edit&amp;u=' . $bank['userid'] . '">' . $bank['username'] . '</a>',
				strip_bbcode($bank['reason'], true),
				vb_number_format($bank['amount'], $vbulletin->options['credits_decimals']),
				construct_link_code($vbphrase['accept'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=accept_bank&amp;bankid=' . $bank['bankid']) . construct_link_code($vbphrase['deny'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=deny_bank&amp;bankid=' . $bank['bankid'])
			));
		}
	}
	else
	{
		print_description_row($vbphrase['credits_acp_nothingdisplay'], false, 6, '', 'center');
	}

	print_table_break();
	print_table_header($vbphrase['credits_acp_actbank'], 6);
	print_cells_row(array(
		$vbphrase['date'],
		$vbphrase['credits_type'],
		$vbphrase['user'],
		$vbphrase['reason'],
		$vbphrase['credits_amount'],
		$vbphrase['controls']
	), 1);

	if (is_array($banks[1]))
	{
		foreach (array_reverse($banks[1]) AS $bank)
		{
			print_cells_row(array(
				vbdate($vbulletin->options['dateformat'], $bank['timestamp'], true),
				$types[$bank['type']],
				'<a href="user.php?' . $vbulletin->session->vars['sessionurl'] . 'do=edit&amp;u=' . $bank['userid'] . '">' . $bank['username'] . '</a>',
				strip_bbcode($bank['reason'], true),
				vb_number_format($bank['amount'], $vbulletin->options['credits_decimals']),
				construct_link_code($vbphrase['cancel'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=cancel_bank&amp;bankid=' . $bank['bankid'])
			));
		}
	}
	else
	{
		print_description_row($vbphrase['credits_acp_nothingdisplay'], false, 6, '', 'center');
	}

	print_table_footer();
}

// ###################### Start process updater #######################
if ($_REQUEST['do'] == 'process')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'types'			=> TYPE_ARRAY_NOHTML,
		'usergroups'	=> TYPE_ARRAY_UINT,
		's_types'		=> TYPE_NOHTML,
		's_groups'		=> TYPE_NOHTML,
		'base'			=> TYPE_NUM,
		'startover'		=> TYPE_UINT,
		'uselog'		=> TYPE_UINT,
		'perpage'		=> TYPE_UINT,
		'startat'		=> TYPE_UINT
	));

	if (!empty($vbulletin->GPC['s_types']))
	{
		$vbulletin->GPC['types'] = explode('-', $vbulletin->GPC['s_types']);
	}
	if (!empty($vbulletin->GPC['s_groups']))
	{
		$vbulletin->GPC['usergroups'] = explode('-', $vbulletin->GPC['s_groups']);
	}
	if (empty($vbulletin->GPC['perpage']))
	{
		$vbulletin->GPC['perpage'] = 35;
	}
	if (sizeof($vbulletin->GPC['usergroups']))
	{
		echo '<p>' . $vbphrase['credits_updating'] . '</p>';
		$inforums = '';
		$openforums = array();

		if (!$vbulletin->options['credits_override'])//why is this still here?
		{
			$forums = $db->query_read("
				SELECT forumid
				FROM " . TABLE_PREFIX . "forum AS forum
				WHERE (forum.options & " . $vbulletin->bf_misc_forumoptions['countposts'] . ")
			");//should be counts credits, not posts

			while ($forum = $db->fetch_array($forums))
			{
				$openforums[] = $forum['forumid'];
			}

			$db->free_result($forums);
			$inforums = ' AND thread.forumid IN (' . implode(', ', $openforums) . ')';
		}

		$users = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "user WHERE usergroupid IN (" . implode(', ', $vbulletin->GPC['usergroups']) . ") ORDER BY userid ASC LIMIT " . $vbulletin->GPC['startat'] . ", " . $vbulletin->GPC['perpage']);

		while ($user = $db->fetch_array($users))
		{
			$usercreditperms = $vbulletin->usergroupcache[$user['usergroupid']];
			$birthdays = $profields = $countsize = $madeposts = $ownposts  = 0;
			$newcredits = $vbulletin->GPC['base'] + $vbulletin->GPC['startover'] * $user['credits'];
			$referrals = $db->query_first("SELECT COUNT(*) AS total FROM " . TABLE_PREFIX . "user WHERE posts >= " . $vbulletin->options['credits_refposts'] . " AND reputation >= " . $vbulletin->options['credits_refrep'] . " AND FLOOR((" . TIMENOW . " - joindate) / 86400) >= " . $vbulletin->options['credits_reftime'] . " AND referrerid = $user[userid]");
			$referrals = intval($referrals['total']) + ( $user['referrerid'] ? $vbulletin->options['credits_referee'] / $usercreditperms['credit_referral'] : 0 );
			$userrefpoints = floor(intval($referrals['total']) / $vbulletin->options['credits_refpoints']);
			$usercreditperms['creditbonus'] = (1 + ( ($vbulletin->options['credits_maxrefpoints'] > -1 AND $userrefpoints > $vbulletin->options['credits_maxrefpoints']) ? $vbulletin->options['credits_maxrefpoints'] : $userrefpoints ) * $usercreditperms['credit_refbonus']);

			$profilepic = $db->query_first("SELECT userid FROM " . TABLE_PREFIX . "customprofilepic WHERE userid = " . $user['userid']);
			$calevents = $db->query_first("SELECT COUNT(*) AS total FROM " . TABLE_PREFIX . "event WHERE userid = " . $user['userid']);
			$sentpms = $db->query_first("SELECT COUNT(*) AS total FROM " . TABLE_PREFIX . "pm AS pm LEFT JOIN " . TABLE_PREFIX . "pmtext AS text ON(pm.pmtextid = text.pmtextid) WHERE pm.folderid != -1 AND text.fromuserid = " . $user['userid']);
			$attachments = $db->query_first("SELECT COUNT(*) AS total FROM " . TABLE_PREFIX . "attachment WHERE userid = " . $user['userid']);
			$pollvotes = $db->query_first("SELECT COUNT(*) AS total FROM " . TABLE_PREFIX . "pollvote WHERE userid = " . $user['userid']);
			$infractions = $db->query_first("SELECT COUNT(*) AS total, SUM(points) AS allpoints FROM " . TABLE_PREFIX . "infraction WHERE action < 2 AND userid = " . $user['userid']);
			$reputation = $db->query_first("SELECT SUM(userid = " . $user['userid'] . ") AS gotreps, SUM((userid = " . $user['userid'] . ") * reputation) AS totalgot, SUM(whoadded = " . $user['userid'] . ") AS gavereps, SUM((whoadded = " . $user['userid'] . ") * reputation) AS totalgave FROM " . TABLE_PREFIX . "reputation");
			$ratings = $db->query_first("SELECT SUM(thread.postuserid = " . $user['userid'] . " AND userid != " . $user['userid'] . ") AS mythreadvotes, SUM(thread.postuserid != " . $user['userid'] . " AND userid = " . $user['userid'] . ") AS myvotes FROM " . TABLE_PREFIX . "threadrate AS rate LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON(rate.threadid = thread.threadid)");
			$userfields = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "userfield WHERE userid = " . $user['userid']);
			$posts = $db->query_read("SELECT post.pagetext, thread.firstpostid, (thread.postuserid = $user[userid]) AS ownthreadpost FROM " . TABLE_PREFIX . "post AS post LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON (post.threadid = thread.threadid) WHERE post.userid = $user[userid] AND post.visible = 1 AND thread.visible = 1");

			$threads = $db->query_first("
				SELECT COUNT(*) AS total, SUM(thread.pollid > 0) AS polls, SUM(thread.views) AS viewings, SUM(thread.replycount) AS replies FROM " . TABLE_PREFIX . "thread AS thread
				LEFT JOIN " . TABLE_PREFIX . "deletionlog AS deletionlog ON (deletionlog.primaryid = thread.threadid AND deletionlog.type = 'thread')
				WHERE thread.postuserid = $user[userid] AND
					deletionlog.primaryid IS NULL
			");

			if (!empty($userfields))
			{
				foreach ($userfields AS $field => $data)
				{
					if (!in_array($field, array('userid', 'temp')))
					{
						$profields += intval(!empty($data));
					}
				}
			}
			if (!empty($user['birthday']))
			{
				$bits = explode('-', $user['birthday']);
				$bdate = mktime(0, 0, 0, intval($bits[0]), intval($bits[1]));
				$bits = explode('-', date('n-j', $user['joindate']));
				$birthdays = floor((TIMENOW - $user['joindate']) / 31536000) + intval(mktime(0, 0, 0, $bits[0], $bits[1]) <= $bdate AND $bdate <= TIMENOW);
			}
			while ($post = $db->fetch_array($posts))
			{
				$oldtext = $post['pagetext'];

				if (!$vbulletin->options['credits_countcode'])
				{
					$oldtext = strip_bbcode($oldtext, true);

					if ($vbulletin->options['credits_sizetype'] == 'char')
					{
						$oldtext = str_replace(' ', '', trim($oldtext));
					}
				}

				$temp = explode(' ', trim($oldtext));
				$postsize = ( $vbulletin->options['credits_sizetype'] == 'char' ? vbstrlen($oldtext) : sizeof($temp) );
				$countsize += ( ($vbulletin->options['credits_maxpostsize'] > -1 AND $postsize > $vbulletin->options['credits_maxpostsize']) ? $vbulletin->options['credits_maxpostsize'] : $postsize );

				if (!$post['ownthreadpost'])
				{
					$madeposts++;
				}
				else
				{
					$threads['replies']--;
					$ownposts++;
				}
			}

			$db->free_result($posts);

			$mults = array(
				'credit_induction' => 1,
				'credit_referral' => $referrals,
				'credit_paycheck' => floor((TIMENOW - $user['joindate']) / (86400 * $vbulletin->options['credits_timedays'])),
				'credit_birthday' => $birthdays,
				'credit_repgive' => abs(intval($reputation[( $vbulletin->options['credits_multrep'] ? 'totalgave' : 'gavereps' )])) * ( $reputation['gavereps'] < 0 ? intval($vbulletin->options['credits_negations'] & 8) * $vbulletin->options['credits_return'] : 1 ),
				'credit_reputation' => abs(intval($reputation[( $vbulletin->options['credits_multrep'] ? 'totalgot' : 'gotreps' )])) * ( $reputation['gotreps'] < 0 ? intval($vbulletin->options['credits_negations'] & 16) * $vbulletin->options['credits_return'] : 1 ),
				'credit_infraction' => intval($infractions[( $vbulletin->options['credits_multinfrac'] ? 'allpoints' : 'total' )]),
				'credit_thread' => intval($threads['total']),
				'credit_threadrate' => intval($ratings['myvotes']),
				'credit_post' => $madeposts,
				'credit_ownthreadpost' => $ownposts,
				'credit_postsize' => $countsize,
				'credit_ownthreadview' => intval($threads['viewings']),//author might have viewed
				'credit_ownthreadrate' => intval($ratings['mythreadvotes']),
				'credit_ownthreadreply' => intval($threads['replies']),
				'credit_pollmake' => intval($threads['polls']),//someone else might have posted poll
				'credit_pollvote' => intval($pollvotes['total']),
				'credit_attachment' => intval($attachments['total']),
				'credit_sendpm' => intval($sentpms['total']),
				'credit_addevent' => intval($calevents['total']),
				'credit_addprofpic' => intval($profilepic['userid'] == $user['userid']),
				'credit_profile' => ( $profields >= $vbulletin->options['credits_profields'] ? ( $vbulletin->options['credits_profmult'] ? $profields : 1 ) : 0 )
			);

			foreach ($vbulletin->GPC['types'] AS $type)
			{
				$newcredits += $usercreditperms['creditbonus'] * $usercreditperms[$type] * $mults[$type];
			}
			if ($vbulletin->GPC['uselog'])
			{
				$logs = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "credits_transactions WHERE touserid = $user[userid] OR fromuserid = $user[userid]");

				while ($log = $db->fetch_array($logs))
				{
					switch ($log['action'])
					{
						case 'donate':
							if ($log['fromuserid'] == $userinfo['userid'])
							{
								if ($vbulletin->options['credits_feetype'] == 'pos')
								{
									$log['amount'] *= (1 + $vbulletin->options['credits_donatefee']);
								}

								$newcredits -= $log['amount'];
							}
							else
							{
								if ($vbulletin->options['credits_feetype'] == 'neg')
								{
									$log['amount'] *= (1 - $vbulletin->options['credits_donatefee']);
								}

								$newcredits += $log['amount'];
							}
							break;
						case 'award':
							if ($log['touserid'] == $userinfo['userid'])
							{
								$newcredits += $log['amount'];
							}
							break;
					}
				}

				$db->free_result($logs);
			}

			($hook = vBulletinHook::fetch_hook('credits_admin_processuser')) ? eval($hook) : false;

			$db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = " . $newcredits . ", credits_numrefs = " . $referrals . " WHERE userid = " . $user['userid']);

			echo construct_phrase($vbphrase['processing_x'], $user['userid']) . "<br />\n";
			vbflush();
		}

		$db->free_result($users);
		$finishat = $vbulletin->GPC['startat'] + $vbulletin->GPC['perpage'];
		$more = $db->query_first("SELECT COUNT(*) AS total FROM " . TABLE_PREFIX . "user WHERE usergroupid IN (" . implode(', ', $vbulletin->GPC['usergroups']) . ")");

		if ($finishat < ($more['total'] - 1))
		{
			print_cp_redirect("credits_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=process&s_types=" . implode('-', $vbulletin->GPC['types']) . "&s_groups=" . implode('-', $vbulletin->GPC['usergroups']) . "&base=" . $vbulletin->GPC['base'] . "&startover=" . $vbulletin->GPC['startover'] . "&uselog=" . $vbulletin->GPC['uselog'] . "&startat=$finishat&pp=" . $vbulletin->GPC['perpage']);
			echo "<p><a href=\"credits_admin.php?" . $vbulletin->session->vars['sessionurl'] . "do=process&amp;s_types=" . implode('-', $vbulletin->GPC['types']) . "&amp;s_groups=" . implode('-', $vbulletin->GPC['usergroups']) . "&amp;base=" . $vbulletin->GPC['base'] . "&amp;startover=" . $vbulletin->GPC['startover'] . "&amp;uselog=" . $vbulletin->GPC['uselog'] . "&amp;startat=$finishat&amp;pp=" . $vbulletin->GPC['perpage'] . "\">" . $vbphrase['click_here_to_continue_processing'] . "</a></p>";
			print_cp_footer();
		}
		else
		{
			print_cp_message($vbphrase['updated_credits_successfully'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=updater');
		}
	}
	else
	{
		print_cp_message($vbphrase['credits_acp_nogroups'], 'credits_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=updater');
	}
}

// ###################### Start begin updater #######################
if ($_REQUEST['do'] == 'updater')
{
	print_form_header('credits_admin', 'process');
	print_column_style_code(array('width: 70%', 'width: 30%'));
	print_table_header($vbphrase['credits_acp_masstools']);
	print_description_row($vbphrase['credits_updatedesc']);
	print_select_row($vbphrase['credits_mcugps'], 'usergroups[]', $usergroups, '', false, 7, true);
	print_select_row($vbphrase['credits_mcuawards'], 'types[]', $creditawards, '', false, 7, true);
	print_input_row($vbphrase['credits_base'], 'base', 0);
	print_yes_no_row($vbphrase['credits_startover'], 'startover', 0);
	print_yes_no_row($vbphrase['credits_uselog'], 'uselog', 1);
	print_input_row($vbphrase['credits_mcusers'], 'perpage', 35);
	print_submit_row($vbphrase['process_users']);
}

($hook = vBulletinHook::fetch_hook('credits_admin_end')) ? eval($hook) : false;

print_cp_footer();

?>