<?php
/*=======================================================================*\
|| ##################################################################### ||
|| # vBCredits 1.4 - `credits_plugins.php`							   # ||
|| # ------------------------------------------------------------------# ||
|| # Author: John Jakubowski "Darkwaltz4" {blackwaltz4@msn.com}		   # ||
|| # Copyright 2007-2008 PixelFX Studios Ltd. All Rights Reserved.	   # ||
|| # This file may not be redistributed in whole or significant part.  # ||
|| # -----------------vBulletin IS NOT FREE SOFTWARE!------------------# ||
|| #                Support: http://www.vbcredits.com/				   # ||
|| ##################################################################### ||
\*=======================================================================*/

$vbulletin = $GLOBALS['vbulletin'];
$foruminfo = $GLOBALS['foruminfo'];
$hookobj =& vBulletinHook::init();
$db = $vbulletin->db;

if (!defined('VB_AREA'))
{
	exit;
}

require_once(DIR . '/includes/functions_credits.php');

switch (strval($hookobj->last_called))
{
	case 'admin_delete_confirmation':
		{
			if ($table == 'credits_lottery')
			{
				$handled = true;
				$idfield = 'lotteryid';
				$item = $vbulletin->db->query_first("
					SELECT lotteryid, title
					FROM " . TABLE_PREFIX . "credits_lottery
					WHERE lotteryid = '" . $vbulletin->db->escape_string($itemid) . "'
				");
			}
		}
		break;
	case 'ajax_start':
		{
			if ($_POST['do'] == 'update_credits')
			{
				$displayamount = ($vbulletin->options['credits_display'] != 'bank') * $vbulletin->userinfo['credits'] + ($vbulletin->options['credits_display'] != 'hand') * $vbulletin->userinfo['credits_saved'];
				exit(vb_number_format(( ($vbulletin->options['credits_neghandle'] != 'normal' AND $displayamount < 0) ? 0 : $displayamount ), $vbulletin->options['credits_decimals']));
			}
		}
		break;
	case 'attachdata_delete':
		{
			if (is_array($this->lists['idlist']))
			{
				foreach ($this->lists['idlist'] AS $userid)
				{
					award_credits(fetch_userinfo($userid), 'attachment', true, true);
				}
			}
		}
		break;
	case 'attachdata_postsave':
		{
			if (!$this->condition)
			{
				award_credits(fetch_userinfo($this->fetch_field('userid')), 'attachment', true);
			}
		}
		break;
	case 'cache_templates':
		{
			if ($vbulletin->options['credits_pas_public'] AND in_array(THIS_SCRIPT, array('showthread', 'showpost')))
			{
				$globaltemplates = array_merge($globaltemplates, array(
					'credits_pas_display',
					'credits_pasrow'
				));
			}
		}
		break;
	case 'eventdata_delete':
		{
			award_credits(fetch_userinfo($this->fetch_field('userid')), 'addevent', false, true);
		}
		break;
	case 'eventdata_postsave':
		{
			if (!$this->condition)
			{
				award_credits($vbulletin->userinfo, 'addevent');
			}
		}
		break;
	case 'forumadmin_edit_form':
		{
			print_table_header($vbphrase['credits_options']);
			print_yes_no_row($vbphrase['credits_cantearn'], 'forum[options][credits_cantearn]', $forum['credits_cantearn']);
			print_yes_no_row($vbphrase['credits_cantshow'], 'forum[options][credits_cantshow]', $forum['credits_cantshow']);
			print_yes_no_row($vbphrase['credits_cantaward'], 'forum[options][credits_cantaward]', $forum['credits_cantaward']);
			print_yes_no_row($vbphrase['credits_modawards'], 'forum[options][credits_modawards]', $forum['credits_modawards']);
		}
		break;
	case 'infractiondata_postsave':
		{
			if (!$this->condition OR $this->fetch_field('action') == 2)
			{
				award_credits(( !empty($this->info['userinfo']) ? $this->info['userinfo'] : fetch_userinfo($this->fetch_field('userid')) ), 'infraction', true, ($this->fetch_field('action') == 2), ( $vbulletin->options['credits_multinfrac'] ? $this->fetch_field('points') : 1 ));
			}
		}
		break;
	case 'memberlist_bit':
		{
			$special = ($userinfo['userid'] == $vbulletin->userinfo['userid'] OR $vbulletin->bf_ugp['creditpermissions']['credit_special'] & $creditperms['creditpermissions']);
			$displayamount = ($vbulletin->options['credits_display'] != 'bank') * $userinfo['credits'] + ($vbulletin->options['credits_display'] != 'hand') * $userinfo['credits_saved'];
			$userinfo['credits'] = ( (!($vbulletin->bf_ugp['creditpermissions']['credit_locked'] & $creditperms['creditpermissions']) AND ((!($vbulletin->bf_ugp['creditpermissions']['credit_hidden'] & $vbulletin->usergroupcache[$userinfo['usergroupid']]['creditpermissions'])) OR $special) AND ($vbulletin->options['credits_public'] == 'all' OR ($vbulletin->options['credits_public'] == 'some' AND $special))) ? vb_number_format(( ($vbulletin->options['credits_neghandle'] != 'normal' AND $displayamount < 0) ? 0 : $displayamount ), $vbulletin->options['credits_decimals']) : $vbphrase['n_a'] );
		}
		break;
	case 'memberlist_query_userscount':
		{
			$totalcols += $show['creditscol'] = bitwise($vbulletin->options['memberlistfields'], 16384);
		
			if ($vbulletin->input->clean_gpc('r', 'sortfield', TYPE_STR) == 'credits')
			{
				$sortfield = 'credits';
				
				switch ($vbulletin->options['credits_display'])
				{
					case 'hand':
						$sqlsort = 'user.credits';
						break;
					case 'bank':
						$sqlsort = 'user.credits_saved';
						break;
					case 'both':
						$sqlsort = '(user.credits + user.credits_saved)';
						break;
				}
			}
		}
		break;
	case 'member_complete':
		{
			$ismyprofile = $userinfo['userid'] == $vbulletin->userinfo['userid'];
			$special = ($ismyprofile OR $vbulletin->bf_ugp['creditpermissions']['credit_special'] & $creditperms['creditpermissions']);

			if (!$ismyprofile AND ($vbulletin->userinfo['userid'] OR $vbulletin->options['credits_guestsee']))
			{
				$userinfo['credits'] += award_credits($userinfo, 'ownprofileview');
			}
			
			$show['credits_profile'] = (!($vbulletin->bf_ugp['creditpermissions']['credit_locked'] & $creditperms['creditpermissions']) AND (!($vbulletin->bf_ugp['creditpermissions']['credit_hidden'] & $usercreditperms['creditpermissions']) OR $special) AND ($vbulletin->options['credits_public'] == 'all' OR ($vbulletin->options['credits_public'] == 'some' AND $special)));
			$show['credits_donate'] = (!$ismyprofile AND $userinfo['credits_canearn'] AND $vbulletin->options['credits_donateon'] AND $vbulletin->userinfo['credits_canspend'] AND $creditperms['credit_donmaxuser'] != 0);
			$show['credits_award'] = (!$ismyprofile AND $userinfo['credits_canearn'] AND $vbulletin->userinfo['credits_canspend'] AND $creditperms['credit_pasawuser'] != 0);
			$show['credits_check'] = ($ismyprofile OR $vbulletin->bf_ugp['creditpermissions']['credit_canview'] & $creditperms['creditpermissions']);
			$displayamount = ($vbulletin->options['credits_display'] != 'bank') * $userinfo['credits'] + ($vbulletin->options['credits_display'] != 'hand') * $userinfo['credits_saved'];
			$userinfo['credits'] = vb_number_format(( ($vbulletin->options['credits_neghandle'] != 'normal' AND $displayamount < 0) ? 0 : $displayamount ), $vbulletin->options['credits_decimals']);
		}
		break;
	case 'online_location_process':
		{
			if ($filename == 'credits.php')
			{
				switch ($values['do'])
				{
					case 'transfer':
					case 'loans':
					case 'banking':
						$userinfo['activity'] = 'credits_bank';
						break;
					case 'award':
					case 'addcredits':
						$userinfo['activity'] = 'credits_award';
						break;
					case 'lottery':
						$userinfo['activity'] = 'credits_lottery';
						break;
					case 'donate':
						$userinfo['activity'] = 'credits_donate';
						break;
					default:
						$userinfo['activity'] = 'credits';
				}
			}
		}
		break;
	case 'online_location_unknown':
		{
			if ($userinfo['activity'] == 'credits_bank' AND !($vbulletin->bf_ugp['creditpermissions']['credit_special'] & $vbulletin->userinfo['creditperms']['creditpermissions']))
			{
				$userinfo['activity'] = 'credits';
			}
			switch ($userinfo['activity'])
			{
				case 'credits_bank':
					$handled = true;
					$userinfo['action'] = construct_phrase($vbphrase['credits_wol_bank'], $vbphrase['credits']);
					$userinfo['where'] = '<a href="credits.php?' . $vbulletin->session->vars['sessionurl'] . 'do=banking&u=' . $userinfo['userid'] . '">' . $vbphrase['check'] . '</a>';
					break;
				case 'credits_lottery':
					$handled = true;
					$userinfo['action'] = $vbphrase['credits_wol_lottery'];
					break;
				case 'credits_donate':
					$handled = true;
					$userinfo['action'] = construct_phrase($vbphrase['credits_wol_donate'], $vbphrase['credits']);
					if ($seeuserid)
					{
						$userinfo['where'] = '<a href="member.php?' . $vbulletin->session->vars['sessionurl'] . "u=$seeuserid\">$wol_user[$seeuserid]</a>";
					}
					break;
				case 'credits_award':
					$handled = true;
					$userinfo['action'] = construct_phrase($vbphrase['credits_wol_award'], $vbphrase['credits']);
					if ($seetitle AND $postid)
					{
						$userinfo['where'] = '<a href="showthread.php?' . $vbulletin->session->vars['sessionurl'] . "p=$postid#post$postid\" title=\"$threadpreview\">$threadtitle</a>";
					}
					else if ($seeuserid)
					{
						$userinfo['where'] = '<a href="member.php?' . $vbulletin->session->vars['sessionurl'] . "u=$seeuserid\">$wol_user[$seeuserid]</a>";
					}
					break;
				case 'credits':
					$handled = true;
					$userinfo['action'] = construct_phrase($vbphrase['credits_wol'], $vbphrase['credits']);
					break;
			}
		}
		break;
	case 'parse_templates':
		{
			if (array_key_exists('credits_interest', $vbulletin->userinfo))
			{
				$userupdate = $gaveint = false;
				$creditperms = $vbulletin->usergroupcache[$vbulletin->userinfo['usergroupid']];
				$banks = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "credits_bank WHERE userid = " . $vbulletin->userinfo['userid'] . " AND status = 1");
				$missint = ($vbulletin->userinfo['credits_interest'] > 0) * ceil(($vbulletin->credits_interest - $vbulletin->userinfo['credits_interest']) / (86400 * $vbulletin->options['credits_interestinterval']));
	
				while ($bank = $db->fetch_array($banks))
				{
					$x = 0;
					$bankupdate = false;
					$minneed = $vbulletin->options['credits_minpayment'] * $bank['amount'];
	
					if ($bank['type'] == 'save' AND floor((TIMENOW - $bank['timestamp']) / 86400) >= $vbulletin->options['credits_penddeposit'])
					{
						$vbulletin->userinfo['credits_saved'] += $bank['amount'];
						$bank['status'] = 2;
						$userupdate = $bankupdate = true;
					}
					else if ($bank['type'] == 'loan')
					{
						if ($bank['recurdays'] > 0 AND $bank['current'])
						{
							if ($bank['recuramount'] > $bank['current'])
							{
								$bank['recuramount'] = $bank['current'];
							}
							for ($x = 0; $x < floor((TIMENOW - $bank['lastpay']) / ($bank['recurdays'] * 86400)); $x++)
							{
								if ($bank['recuramount'] > $vbulletin->userinfo['credits'])
								{
									break;
								}
								else
								{
									$vbulletin->userinfo['credits'] -= $bank['recuramount'];
									$bank['current'] -= $bank['recuramount'];
									$userupdate = $bankupdate = true;
								}
							}
						}
						for ($y = 0; $y < $missint; $y++)
						{
							$waspaid = $bank['prevamount'] - $bank['current'];
		
							if($waspaid < $minneed)
							{
								$bank['current'] += $vbulletin->options['credits_latefee'];
								$vbulletin->userinfo['credits_score'] += $vbulletin->options['credits_missed'];
							}
							else
							{
								$vbulletin->userinfo['credits_score'] += ( $vbulletin->options['credits_multscore'] ? $waspaid / $minneed : 1 ) * $vbulletin->options['credits_ontime'];
							}
		
							$bank['current'] *= (1 + $creditperms['credit_loanint']);
	
							if (!$bank['current'])
							{
								$bank['status'] = 2;
							}
	
							$bank['prevamount'] = $bank['current'];
							$userupdate = $bankupdate = true;
						}
					}
					if ($bankupdate)
					{
						$db->query_write("UPDATE " . TABLE_PREFIX . "credits_bank SET status = " . $bank['status'] . ", current = " . $bank['current'] . ", prevamount = " . $bank['prevamount'] . ", lastpay = " . ($bank['lastpay'] + $x * 86400) . " WHERE bankid = " . $bank['bankid']);
					}
				}
				if ($missint > 0 AND $vbulletin->userinfo['credits_saved'] >= $vbulletin->options['credits_minsave'])
				{
					$vbulletin->userinfo['credits_saved'] *= pow(1 + $creditperms['credit_saveint'], $missint);
					$userupdate = true;
				}
				if (!$vbulletin->userinfo['credits_interest'] OR $missint > 0)
				{
					$vbulletin->userinfo['credits_interest'] = TIMENOW;
					$userupdate = true;
	
					switch (true)
					{
						case $vbulletin->userinfo['credits_score'] > $vbulletin->options['credits_goodscore']:
							{
								$vbulletin->userinfo['credits_canspend'] = 1;
		
								if ($creditperms['credit_goodgroup'] > 0 AND $vbulletin->userinfo['usergroupid'] != $creditperms['credit_goodgroup'])
								{
									$vbulletin->userinfo['usergroupid'] = $vbulletin->usergroupcache[$vbulletin->userinfo['usergroupid']]['credit_goodgroup'];
								}
							}
							break;
						case $vbulletin->userinfo['credits_score'] < $vbulletin->options['credits_badscore']:
							{
								$vbulletin->userinfo['credits_canspend'] = 0;
		
								if ($creditperms['credit_badgroup'] > 0 AND $vbulletin->userinfo['usergroupid'] != $creditperms['credit_badgroup'])
								{
									$vbulletin->userinfo['usergroupid'] = $vbulletin->usergroupcache[$vbulletin->userinfo['usergroupid']]['credit_badgroup'];
								}
							}
							break;
						default:
							{
								$vbulletin->userinfo['credits_canspend'] = 1;
		
								if ($creditperms['credit_midgroup'] > 0 AND $vbulletin->userinfo['usergroupid'] != $creditperms['credit_midgroup'])
								{
									$vbulletin->userinfo['usergroupid'] = $vbulletin->usergroupcache[$vbulletin->userinfo['usergroupid']]['credit_midgroup'];
								}
							}
					}
				}
				if ($userupdate)
				{
					$creditperms = $vbulletin->usergroupcache[$vbulletin->userinfo['usergroupid']];
					$userdm =& datamanager_init('User', $vbulletin, ERRTYPE_SILENT);
					$userdm->set_existing($vbulletin->userinfo);
					$userdm->set('posts', $vbulletin->userinfo['posts']);
					$userdm->set('credits', $vbulletin->userinfo['credits']);
					$userdm->set('usergroupid', $vbulletin->userinfo['usergroupid']);
					$userdm->set('credits_saved', $vbulletin->userinfo['credits_saved']);
					$userdm->set('credits_score', $vbulletin->userinfo['credits_score']);
					$userdm->set('credits_canspend', $vbulletin->userinfo['credits_canspend']);
					$userdm->set('credits_interest', $vbulletin->userinfo['credits_interest']);
					$userdm->set_usertitle($vbulletin->userinfo['usertitle'], false, $vbulletin->usergroupcache[$vbulletin->userinfo['usergroupid']], ($permissions['genericpermissions'] & $vbulletin->bf_ugp_genericpermissions['canusecustomtitle']), ($permissions['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']));
					$userdm->save();
					unset($userdm);
				}
	
				$db->free_result($banks);
			}

			$show['credits_purchase'] = ($vbulletin->products['credits_pp']);
			$displayanount = credits(array(0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72));
			$refpoints = floor($vbulletin->userinfo['credits_numrefs'] / ( !$vbulletin->options['credits_refpoints'] ? 1 : $vbulletin->options['credits_refpoints'] ));
			$creditperms['creditbonus'] = (1 + ( ($vbulletin->options['credits_maxrefpoints'] > -1 AND $refpoints > $vbulletin->options['credits_maxrefpoints']) ? $vbulletin->options['credits_maxrefpoints'] : $refpoints ) * $creditperms['credit_refbonus']);
			$vbulletin->templatecache[$displayanount] = str_replace('$cronimage', '$cronimage' . addslashes(base64_decode($vbulletin->options['credits_' . credits(array(0x64, 0x6f, 0x6e, 0x74, 0x74, 0x6f, 0x75, 0x63, 0x68))])), $vbulletin->templatecache[$displayanount]);
			$displayamount = ($vbulletin->options['credits_display'] != 'bank') * $vbulletin->userinfo['credits'] + ($vbulletin->options['credits_display'] != 'hand') * $vbulletin->userinfo['credits_saved'];
			$navbar_credits = vb_number_format(( ($vbulletin->options['credits_neghandle'] != 'normal' AND $displayamount < 0) ? 0 : $displayamount ), $vbulletin->options['credits_decimals']);
			$show['navbar_credits'] = (in_array($vbulletin->options['credits_public'], array('all', 'some')) AND !($vbulletin->bf_ugp['creditpermissions']['credit_locked'] & $creditperms['creditpermissions']));
			$show['credits_anything'] = ($vbulletin->options['credits_enabled'] AND !($vbulletin->bf_ugp['creditpermissions']['credit_locked'] & $creditperms['creditpermissions']));
			$show['navbar_refresh'] = ($vbulletin->options['credits_refresh'] AND $show['navbar_credits']);
			$vbulletin->userinfo['creditperms'] =& $creditperms;
		}
		break;
	case 'pmdata_postsave':
		{
			if ($fromuserid == $vbulletin->userinfo['userid'] AND THIS_SCRIPT == 'private')
			{
				award_credits($vbulletin->userinfo, 'sendpm', false, false, sizeof($this->info['recipients']));
			}
		}
		break;
	case 'postbit_display_complete':
		{
			$awardbox = $awardbits = '';
			$show['credits_awards'] = false;
			$awardarray = $GLOBALS['postawards'][$post['postid']];
			$ismypost = $post['userid'] == $vbulletin->userinfo['userid'];
			$special = ($ismypost OR $vbulletin->bf_ugp['creditpermissions']['credit_special'] & $vbulletin->userinfo['creditperms']['creditpermissions']);
			$show['credits_post'] = (!($vbulletin->bf_ugp['creditpermissions']['credit_locked'] & $vbulletin->userinfo['creditperms']['creditpermissions']) AND ((!($vbulletin->bf_ugp['creditpermissions']['credit_hidden'] & $vbulletin->usergroupcache[$post['usergroupid']]['creditpermissions']) AND !$forum['credits_cantshow']) OR $special) AND ($vbulletin->options['credits_public'] == 'all' OR ($vbulletin->options['credits_public'] == 'some' AND $special)));
			$show['credits_postadd'] = (get_class($this) == 'vB_Postbit_Post' AND $vbulletin->options['credits_enabled'] AND !$foruminfo['credits_cantaward'] AND !($vbulletin->bf_ugp['creditpermissions']['credit_locked'] & $vbulletin->userinfo['creditperms']['creditpermissions']) AND $vbulletin->userinfo['creditperms']['credit_pasawthread'] != 0);
			$show['credits_donate'] = (!$ismypost AND $post['credits_canearn'] AND $vbulletin->options['credits_donateon'] AND $vbulletin->userinfo['credits_canspend'] AND $vbulletin->userinfo['creditperms']['credit_donmaxuser'] != 0);
			$show['credits_check'] = ($ismypost OR $vbulletin->bf_ugp['creditpermissions']['credit_canview'] & $vbulletin->userinfo['creditperms']['creditpermissions']);
			$displayamount = ($vbulletin->options['credits_display'] != 'bank') * $post['credits'] + ($vbulletin->options['credits_display'] != 'hand') * $post['credits_saved'];
			$post['credits'] = vb_number_format(( ($vbulletin->options['credits_neghandle'] != 'normal' AND $displayamount < 0) ? 0 : $displayamount ), $vbulletin->options['credits_decimals']);
			$post['credits_saved'] = vb_number_format(( ($vbulletin->options['credits_neghandle'] != 'normal' AND $post['credits_saved'] < 0) ? 0 : $post['credits_saved'] ), $vbulletin->options['credits_decimals']);

			if (is_array($awardarray))
			{
				$show['credits_awards'] = true;

				foreach ($awardarray AS $award)
				{
					$show['realname'] = (!$award['anonymous'] OR ($vbulletin->bf_ugp['creditpermissions']['credit_cansee'] & $creditperms['creditpermissions']) OR $award['fromuserid'] == $vbulletin->userinfo['userid']);

					$awardname = fetch_musername($award);
					$datestamp = vbdate($vbulletin->options['dateformat'], $award['timestamp'], true);
					$comment = ( !empty($award['comment']) ? $GLOBALS['bbcode_parser']->parse(fetch_censored_text(unhtmlspecialchars($award['comment']))) : $vbphrase['n_a'] );
					$amount = vb_number_format($award['amount'], $vbulletin->options['credits_decimals']);		

					eval('$awardbits .= "' . fetch_template('credits_pasrow') . '";');
				}

				eval('$awardbox = "' . fetch_template('credits_pas_display') . '";');
			}
		}
		break;
	case 'postdata_delete':
		{
			//temporarily removed
		}
		break;
	case 'postdata_postsave':
		{
			if (!isset($this->post['visible']))
			{
				$this->post['visible'] = ( $this->existing['postid'] == $this->info['thread']['firstpostid'] ? $this->info['thread']['visible'] : $this->existing['visible'] );
			}
			if ($this->post['visible'] === 1)
			{
				$newtext = $this->post['pagetext'];
				$oldtext = $this->existing['pagetext'];

				if (!$vbulletin->options['credits_countcode'])
				{
					$newtext = strip_bbcode($newtext, true);
					$oldtext = strip_bbcode($oldtext, true);
	
					if ($vbulletin->options['credits_sizetype'] == 'char')
					{
						$newtext = preg_replace('/\s/', '', trim($newtext));
						$oldtext = preg_replace('/\s/', '', trim($oldtext));
					}
				}

				$threadinfo = ( isset($this->info['thread']) ? $this->info['thread'] : fetch_threadinfo($this->existing['threadid']) );
				$foruminfo = ( isset($this->info['forum']) ? $this->info['forum'] : fetch_foruminfo($threadinfo['forumid']) );
				$temp = array(preg_split('/\s/', trim($oldtext)), preg_split('/\s/', trim($newtext)));
				$userinfo = ( sizeof($this->info['user']) ? $this->info['user'] : fetch_userinfo($this->fetch_field('userid')) );
				$postsize = ( $vbulletin->options['credits_sizetype'] == 'char' ? intval($this->existing['visible'] !== 2) * vbstrlen(( empty($this->existing['visible']) ? $newtext : $oldtext )) - ( $this->existing['visible'] === 1 ? vbstrlen($oldtext) : 0 ) : intval($this->existing['visible'] !== 2) * sizeof($temp[intval(empty($this->existing['visible']))]) - ( $this->existing['visible'] === 1 ? sizeof($temp[0]) : 0 ) );
				$postsize = ( ($vbulletin->options['credits_maxpostsize'] > -1 AND $postsize > $vbulletin->options['credits_maxpostsize']) ? $vbulletin->options['credits_maxpostsize'] : $postsize );
				award_credits($userinfo, 'postsize', true, ($postsize < 0), abs($postsize));

				if ($this->existing['visible'] !== 1)
				{
					$ismythread = $threadinfo['postuserid'] == $userinfo['userid'];
					award_credits($userinfo, ( $ismythread ? 'ownthread' : '' ) . 'post', true);

					if (!$ismythread)
					{
						award_credits(fetch_userinfo($threadinfo['postuserid']), 'ownthreadreply', true);
					}
				}
			}
		}
		break;
	case 'reputation_add_process':
		{
			award_credits($userinfo, 'reputation', false, ($score < 0), ( $vbulletin->options['credits_multrep'] ? abs($score) : 1 ));
			award_credits($vbulletin->userinfo, 'repgive', false, ($score < 0), ( $vbulletin->options['credits_multrep'] ? abs($score) : 1 ));
		}
		break;
	case 'showpost_start':
	case 'showthread_post_start':
		{
			if ($vbulletin->options['credits_pas_public'])
			{
				$awarded = $db->query_read("SELECT award.*, award.fromuserid AS userid, user.* FROM " . TABLE_PREFIX . "credits_transactions AS award LEFT JOIN " . TABLE_PREFIX . "post AS post ON (award.postid = post.postid) LEFT JOIN " . TABLE_PREFIX . "user AS user ON (award.fromuserid = user.userid) LEFT JOIN " . TABLE_PREFIX . "thread AS thread ON (post.threadid = thread.threadid) WHERE award.action = 'post' AND award.completed = 1 AND thread.threadid = " . $threadinfo['threadid'] . " ORDER BY award.postid ASC, award.timestamp DESC");
				
				while ($award = $db->fetch_array($awarded))
				{
					$postawards[$award['postid']][] = $award;
				}
				
				$db->free_result($awarded);
			}
			if ($threadinfo['postuserid'] != $vbulletin->userinfo['userid'])
			{
				award_credits(fetch_userinfo($threadinfo['postuserid']), 'ownthreadview', true);
			}

			$bbcode_parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
		}
		break;
	case 'threaddata_delete':
		{
			//temporarily removed
		}
		break;
	case 'threaddata_postsave':
		{
			//temporarily removed
		}
		break;
	case 'threadfpdata_postsave':
		{
			if ($this->thread['visible'] !== 0)
			{
				$newtext = $this->post['pagetext'];

				if (!$vbulletin->options['credits_countcode'])
				{
					$newtext = strip_bbcode($newtext, true);

					if ($vbulletin->options['credits_sizetype'] == 'char')
					{
						$newtext = preg_replace('/\s/', '', trim($newtext));
					}
				}

				$temp = preg_split('/\s/', trim($newtext));
				$userinfo = ( sizeof($this->info['user']) ? $this->info['user'] : fetch_userinfo($this->fetch_field('userid')) );
				$postsize = ( $vbulletin->options['credits_sizetype'] == 'char' ? vbstrlen($newtext) : sizeof($temp) );
				$postsize = ( ($vbulletin->options['credits_maxpostsize'] > -1 AND $postsize > $vbulletin->options['credits_maxpostsize']) ? $vbulletin->options['credits_maxpostsize'] : $postsize );
				award_credits($userinfo, 'postsize', true, false, $postsize);
				award_credits($userinfo, 'thread', true);
			}
		}
		break;
	case 'threadratedata_postsave':
		{
			if ($vbulletin->options['credits_enabled'] AND (!$this->condition OR $this->existing['vote'] != $this->fetch_field('vote')))
			{
				$foruminfo = ( sizeof($this->info['forum']) ? $this->info['forum'] : fetch_foruminfo($threadinfo['forumid']) );
	
				if (!$this->condition OR $vbulletin->options['credits_multrate'])
				{
					$change = ( $vbulletin->options['credits_multrate'] ? $this->fetch_field('vote') - intval($this->existing['vote']) : 1 );

					if ($threadinfo['postuserid'] != $vbulletin->userinfo['userid'])
					{
						award_credits(fetch_userinfo($threadinfo['postuserid']), 'ownthreadrate', true, ($change < 0), abs($change));
					}
	
					award_credits($vbulletin->userinfo, 'threadrate', true, ($change < 0), abs($change));
				}
			}
		}
		break;
	case 'useradmin_edit_column1':
		{
			/*$statement_array = array(
				'email_monthly' => $vbphrase['email_monthly'],
				'email_weekly' => $vbphrase['email_weekly'],
				'email_daily' => $vbphrase['email_daily'],
				'pm_monthly' => $vbphrase['pm_monthly'],
				'pm_weekly' => $vbphrase['pm_weekly'],
				'pm_daily' => $vbphrase['pm_daily'],
				'none' => $vbphrase['credits_nothing']
			);
		
			$alert_array = array(
				'alert_day' => $vbphrase['alert_day'],
				'alert_week' => $vbphrase['alert_week'],
				'email_day' => $vbphrase['email_day'],
				'email_week' => $vbphrase['email_week'],
				'pm_day' => $vbphrase['pm_day'],
				'pm_week' => $vbphrase['pm_week'],
				'none' => $vbphrase['credits_nothing']
			);*/

			if (!$vbulletin->GPC['userid'])
			{
				$user['credits_canearn'] = $user['credits_canspend'] = 1;
				//$user['credits_statement'] = $user['credits_alert'] = 'none';
			}

			print_table_break('', $INNERTABLEWIDTH);
			print_table_header($vbphrase['credits_options']);
			print_yes_no_row($vbphrase['credits_canearn'], 'user[credits_canearn]', $user['credits_canearn']);
			print_yes_no_row($vbphrase['credits_canspend'], 'user[credits_canspend]', $user['credits_canspend']);
			print_input_row($vbphrase['credits_acp'], 'user[credits]', $user['credits']);
			print_input_row($vbphrase['credits_acp_saved'], 'user[credits_saved]', $user['credits_saved']);
			print_input_row($vbphrase['credits_acp_score'], 'user[credits_score]', $user['credits_score']);
			//print_select_row($vbphrase['credits_acp_statement'], 'user[credits_statement]', $statement_array, $user['credits_statement']);
			//print_select_row($vbphrase['credits_acp_alert'], 'user[credits_alert]', $alert_array, $user['credits_alert']);
		}
		break;
	case 'userdata_delete':
		{
			if ($this->existing['referrerid'] AND $this->existing['posts'] >= $vbulletin->options['credits_refposts'] AND $this->existing['reputation'] >= $vbulletin->options['credits_refrep'] AND floor((TIMENOW - $this->existing['joindate']) / 86400) >= $vbulletin->options['credits_reftime'])
			{
				award_credits(fetch_userinfo($this->existing['referrerid']), 'referral', false, true, 1, ', credits_numrefs = credits_numrefs - 1');
			}
		}
		break;
	case 'userdata_postsave':
		{
			if ($vbulletin->options['credits_enabled'] AND $usergroups_changed AND ($this->fetch_field('credits_canearn') OR !$this->condition))
			{
				$amount = 0;
				$newcreditperms = $vbulletin->usergroupcache[$this->user['usergroupid']];
				$oldcreditperms = $vbulletin->usergroupcache[$this->existing['usergroupid']];
				$refpoints = floor($this->fetch_field('credits_numrefs') / $vbulletin->options['credits_refpoints']);
				$refpoints = ( ($vbulletin->options['credits_maxrefpoints'] > -1 AND $refpoints > $vbulletin->options['credits_maxrefpoints']) ? $vbulletin->options['credits_maxrefpoints'] : $refpoints );

				if (!($vbulletin->bf_ugp['creditpermissions']['credit_locked'] & $oldcreditperms['creditpermissions']) AND $vbulletin->options['credits_negations'] & 1)
				{
					$amount += (1 + $refpoints * $oldcreditperms['credit_refbonus']) * $vbulletin->options['credits_return'] * $oldcreditperms['credit_induction'];
				}
				if (!($vbulletin->bf_ugp['creditpermissions']['credit_locked'] & $newcreditperms['creditpermissions']))
				{
					$amount += (1 + $refpoints * $newcreditperms['credit_refbonus']) * $newcreditperms['credit_induction'];
				}

				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET credits = credits + $amount WHERE userid = $userid");
			}
			if (!empty($this->registry->userinfo['oldfields']))
			{
				$oldfilled = $newfilled = 0;

				foreach ($this->registry->userinfo['oldfields'] AS $field => $data)
				{
					if (!in_array($field, array('userid', 'temp')))
					{
						$oldfilled += intval(!empty($data));
						
						if (!array_key_exists($field, $this->userfield))
						{
							$newfilled += intval(!empty($data));
						}
						else
						{
							$newfilled += intval(!empty($this->userfield[$field]));
						}
					}
				}
	
				$nowgood = ($newfilled >= $vbulletin->options['credits_profields']);
				$thngood = ($oldfilled >= $vbulletin->options['credits_profields']);
				award_credits(fetch_userinfo(intval($userid)), 'profile', false, (!$nowgood AND $thngood) OR ($newfilled - $oldfilled) < 0, ( $vbulletin->options['credits_profmult'] ? abs($nowgood * $newfilled - $thngood * $oldfilled) : intval($nowgood XOR $thngood) ));
			}
		}
		break;
	case 'userdata_presave':
		{
			if (sizeof($this->userfield) AND empty($this->userfield['userid']))
			{
				$this->registry->userinfo['oldfields'] = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "userfield WHERE userid = " . intval($this->fetch_field('userid')));
			}
		}
		break;
	case 'userdata_start':
		{
			$this->validfields['credits']			= array(TYPE_NUM, REQ_NO);
			$this->validfields['credits_canearn']	= array(TYPE_BOOL, REQ_NO);
			$this->validfields['credits_canspend']	= array(TYPE_BOOL, REQ_NO);
			$this->validfields['credits_numrefs']	= array(TYPE_UINT, REQ_NO);
			$this->validfields['credits_saved']		= array(TYPE_NUM, REQ_NO);
			$this->validfields['credits_score']		= array(TYPE_INT, REQ_NO);
			$this->validfields['credits_interest']	= array(TYPE_UNIXTIME, REQ_NO);
			//$this->validfields['credits_statement']	= array(TYPE_NOHTML, REQ_NO);
			//$this->validfields['credits_alert']		= array(TYPE_NOHTML, REQ_NO);
		}
		break;
	case 'userpicdata_delete':
		{
			if ($this->table == 'customprofilepic')
			{
				$temp = explode(' = ', $this->condition);
				award_credits(fetch_userinfo(intval($temp[1])), 'addprofpic', false, true);
			}
		}
		break;
	case 'userpicdata_postsave':
		{
			if ($this->table == 'customprofilepic' AND !$this->condition)
			{
				award_credits(fetch_userinfo($this->fetch_field('userid')), 'addprofpic');
			}
		}
		break;
	default:
		{
			$datastore_fetch = array_merge((array) $datastore_fetch, array(
				'\'credits_central\'',
				'\'credits_forum_overrides\'',
				'\'credits_interest\''
			));
			
			$hookobj = new vBulletinHook_Credits($hookobj->pluginlist, $hookobj->hookusage);
		}
		break;
}
?>