<?php
require_once('casino/texasholdem_handlepost.php');

function getcommoncards()
{
	global $db;
	global $round;
	global $vbphrase;

	if ($round > 1)
	{
		$n = $round + 1;

		if ($n > 5) $n = 5;
		
		$query = "SELECT * FROM casino_texasholdem_dealt WHERE playerid = 0 ORDER BY dealtid LIMIT $n";
		$result = $db->query($query);
		$hand = "";
		$f = array();
		$s = array();
		while($row = $db->fetch_array($result)) {
			$f[$i] = $row['card'] % 13;
			$s[$i] = floor($row['card']/13);
			$f2 = $f[$i];
			$s2 = $s[$i];
			if($s2==0){$cardfile = "casino/cards/spades-"; $cardname = $vbphrase[casino_spades]; }
			else if($s2==1){$cardfile = "casino/cards/diamonds-";$cardname = $vbphrase[casino_diamonds]; }
			else if($s2==2){$cardfile = "casino/cards/hearts-";$cardname = $vbphrase[casino_hearts]; }
			else if($s2==3){$cardfile = "casino/cards/clubs-";$cardname = $vbphrase[casino_clubs]; }
	
			if($f2+2<11){$cardfile .= ($f2+2) . "-150.png";$cardname = ($f2+2) . " of " . $cardname; }
			else if($f2+2==11){$cardfile .= "j-150.png"; $cardname = $vbphrase[casino_jack] . " of " . $cardname; }
			else if($f2+2==12){$cardfile .= "q-150.png"; $cardname = $vbphrase[casino_queen] . " of " . $cardname; }
			else if($f2+2==13){$cardfile .= "k-150.png"; $cardname = $vbphrase[casino_king] . " of " . $cardname; }
			else if($f2+2==14){$cardfile .= "a-150.png"; $cardname = $vbphrase[casino_ace] . " of " . $cardname; }
		
			$hand .= "&lt;img src = '$cardfile' alt='$cardname' /&gt;";
		}
		$common = "<common>$hand</common>";
	
	}
	else 	
		$common = "<common>&lt;img src='casino/cards/back-blue-150-1.png' alt=''/&gt;&lt;img src='casino/cards/back-blue-150-1.png' alt=''/&gt;&lt;img src='casino/cards/back-blue-150-1.png' alt=''/&gt;&lt;img src='casino/cards/back-blue-150-1.png' alt=''/&gt;&lt;img src='casino/cards/back-blue-150-1.png' alt=''/&gt;</common>";

	return $common;
}

// Returns the players two pocket cards 
function getplayercards($p)
{
	global $db;
	global $vbphrase;
	$query = "SELECT * FROM casino_texasholdem_dealt WHERE playerid = $p LIMIT 2";
	$result = $db->query($query);
	$hand = "";
	$f = array();
	$s = array();
	while($row = $db->fetch_array($result)) {
		$f[$i] = $row['card'] % 13;
		$s[$i] = floor($row['card']/13);
		$f2 = $f[$i];
		$s2 = $s[$i];

		if($s2==0){$cardfile = "casino/cards/spades-"; $cardname = $vbphrase[casino_spades]; }
		else if($s2==1){$cardfile = "casino/cards/diamonds-";$cardname = $vbphrase[casino_diamonds]; }
		else if($s2==2){$cardfile = "casino/cards/hearts-";$cardname = $vbphrase[casino_hearts]; }
		else if($s2==3){$cardfile = "casino/cards/clubs-";$cardname = $vbphrase[casino_clubs]; }
	
		if($f2+2<11){$cardfile .= ($f2+2) . "-50.png";$cardname = ($f2+2) . " of " . $cardname; }
		else if($f2+2==11){$cardfile .= "j-50.png"; $cardname = $vbphrase[casino_jack] . " of " . $cardname; }
		else if($f2+2==12){$cardfile .= "q-50.png"; $cardname = $vbphrase[casino_queen] . " of " . $cardname; }
		else if($f2+2==13){$cardfile .= "k-50.png"; $cardname = $vbphrase[casino_king] . " of " . $cardname; }
		else if($f2+2==14){$cardfile .= "a-50.png"; $cardname = $vbphrase[casino_ace] . " of " . $cardname; }
		
		$hand .= "&lt;img src = '$cardfile' alt='$cardname' /&gt;";
	}
	return $hand;

}

// Setup & deal the deck 
function deal()
{
	global $gameid;
	global $cashtype;
	global $db;
	global $time;
	global $playerarray;
	global $numplayers;
	global $playeruid;
	global $playernames;
	global $cash;

	$query = "SELECT * FROM casino_settings WHERE settingname='texasholdem_bigblind'";
	$settings = $db->query_read($query);
	$setting = $db->fetch_array($settings);
	$bigblind = $setting['switch2'];

	$query = "SELECT * FROM casino_settings WHERE settingname='texasholdem_smallblind'";
	$settings = $db->query_read($query);
	$setting = $db->fetch_array($settings);
	$smallblind = $setting['switch2'];

	$query = "SELECT user.userid AS userid, casino_texasholdem_whoisin.status, casino_texasholdem_whoisin.seat, username 
		FROM casino_texasholdem_whoisin, " . TABLE_PREFIX . "user AS user
		WHERE casino_texasholdem_whoisin.userid = user.userid
		AND casino_texasholdem_whoisin.status = 1
		ORDER BY casino_texasholdem_whoisin.seat
	";
	$result = $db->query_read($query);
		
	$numplayers = 0; 
	$playerarray = array();
	$playeruid = array();
	$playernames = array();
	while($row = $db->fetch_array($result))
	{
	// If the game has started, only players that are in it.
		$playerarray[$numplayers] = $row['seat'];
		$playeruid[$numplayers] = $row['userid'];
		$playernames[$numplayers] = addslashes(htmlspecialchars(strip_tags(trim(addslashes($row['username']))),ENT_QUOTES));
		$numplayers++;
	} 
	
		$query = "SELECT * FROM casino_settings WHERE settingname='texasholdem_dealer'";
		$settings = $db->query_read($query);
		$setting = $db->fetch_array($settings);
		$dealerpos = $setting['switch2'];
		$dealerpos = array_search($dealerpos, $playerarray);

		if (! $dealerpos) $dealerpos = 0;
		$dealerpos++;
		if($dealerpos >= $numplayers) $dealerpos = 0;

		$dealerid = $playerarray[$dealerpos]; 

		//Dealer is first seat...  needs to rotate.  
		$db->query("UPDATE casino_settings SET switch2='$dealerid' WHERE settingname='texasholdem_dealer'");
		
		// Add blinds in here
		
		if($numplayers == 2)
		{
			if($dealerpos == 0)
			{
				$np = 0;
				$sb = 1;
				$bb = 0;
			}
			else
			{
				$np = 1;
				$sb = 0;
				$bb = 1;
			}
		}
		else 
		{
			$sb = $dealerpos + 1;
			if($sb >= $numplayers) $sb -= $numplayers;
			$bb = $dealerpos + 2;
			if($bb >= $numplayers) $bb -= $numplayers;
			$np = $dealerpos + 3;
			if($np >= $numplayers) $np -= $numplayers;
		}
		
		$pot = 0;

		$db->query("UPDATE casino_texasholdem_whoisin SET bet = 0");

		$msg = "&lt;b style=\'color:#000000\'&gt;$playernames[$dealerpos] $vbphrase[casino_deals]&lt;/b&gt;";
		$db->query("INSERT INTO casino_texasholdem_chatlog (msg, msgtime) VALUES ('$msg', $time)");

		$result = $db->query("SELECT $cashtype FROM " . TABLE_PREFIX . "user AS usera WHERE userid = $playeruid[$sb]");
		$row = $db->fetch_array($result);
		$pcash = $row[$cashtype];
		

		if($pcash > $smallblind)
		{
			$raise = $smallblind;
			$pcash = $pcash - $smallblind;
		}
		else 
		{
			$raise = $pcash;
			$pcash = 0; 
		}
		$pot += $raise;
		$msg = "&lt;i  style=\'color:#000000\'&gt;$playernames[$sb] $vbphrase[casino_bets] $raise&lt;/i&gt;";
		$db->query("INSERT INTO casino_texasholdem_chatlog (msg, msgtime) VALUES ('$msg', $time)");
		$db->query("UPDATE casino_texasholdem_whoisin SET bet = $raise WHERE userid = $playeruid[$sb]");
		$db->query("UPDATE " . TABLE_PREFIX . "user SET $cashtype = $pcash WHERE userid = $playeruid[$sb]");

			$db->query ("
				UPDATE casino_bet_stats
				SET bet = bet + $raise
				WHERE userid = $playeruid[$sb]
				AND gameid = $gameid 
			");

		$result = $db->query("SELECT $cashtype FROM " . TABLE_PREFIX . "user AS userb WHERE userid = $playeruid[$bb]");
		$row = $db->fetch_array($result);
		$pcash = $row[$cashtype];
		

		if($pcash > $bigblind)
		{
			$raise = $bigblind;
			$pcash = $pcash - $bigblind;
		}
		else 
		{
			$raise = $pcash;
			$pcash = 0; 
		}
		$pot += $raise;

		$msg = "&lt;i style=\'color:#000000\'&gt;$playernames[$bb] $vbphrase[casino_bets] $raise&lt;/i&gt;";
		$db->query("INSERT INTO casino_texasholdem_chatlog (msg, msgtime) VALUES ('$msg', $time)");
		$db->query("UPDATE casino_texasholdem_whoisin SET bet = $raise WHERE userid = $playeruid[$bb]");
		$db->query("UPDATE " . TABLE_PREFIX . "user SET $cashtype = $pcash WHERE userid = $playeruid[$bb]");

			$db->query ("
				UPDATE casino_bet_stats
				SET bet = bet + $raise
				WHERE userid = $playeruid[$bb]
				AND gameid = $gameid 
			");


		$nextplayer = $playerarray[$np]; 
		$db->query("UPDATE casino_settings SET switch2='$nextplayer' WHERE settingname='texasholdem_whosturn'");
		$db->query("UPDATE casino_settings SET switch2='$nextplayer' WHERE settingname='texasholdem_lastraise'");

		$db->query("UPDATE casino_settings SET switch2='1' WHERE settingname='texasholdem_round'");
		$db->query("UPDATE casino_settings SET switch2='$pot' WHERE settingname='texasholdem_pot'");
		$db->query("UPDATE casino_settings SET switch2='$time' WHERE settingname='texasholdem_lasttime'");


		$card = array();
		for($i = 0; $i < 52; $i++) {
			$card[$i]=$i;
		}
		srand((float)microtime() * 1000000);
		shuffle($card);

 		
		$query = "DELETE FROM casino_texasholdem_dealt";
		$db->query($query);

		// 2 each 
	$y = 0;
	for($i=1;$i<11;$i++)
	{
			for($x = 0; $x < 2; $x++) {
				$query = "INSERT INTO casino_texasholdem_dealt (playerid, card) values ($i, $card[$y])";  
				$db->query($query);
				$y++;
			}
	}	

	// Store the rest
		for($x = $y; $x < 52; $x++) {
			$query = "INSERT INTO casino_texasholdem_dealt (playerid, card) values (0, $card[$x])";  
			$db->query($query);
		}

}

// Clean up people that have left
function dumpdeadplayers($t)
{
	global $db;
	global $playerarray;
	global $cashtype;
	global $pot;
	global $gameid;
	global $vbphrase;	
	
	$time = time();
	$timeout = $time - $t;
	$result = $db->query("SELECT * FROM casino_texasholdem_whoisin WHERE lastcheck < $timeout");
	while ($row = $db->fetch_array($result))
	{
		$seat = $row['seat'];
		$userid = $row['userid'];
		$result2 = $db->query("SELECT username FROM " . TABLE_PREFIX . "user WHERE userid = $userid");
		while ($row2 = $db->fetch_array($result2))
		{
			$username = $row2['username'];

			$username = addslashes(htmlspecialchars(strip_tags(trim(addslashes($username))),ENT_QUOTES));
			
			$msg = "&lt;b style=\'color:#000000\'&gt;$username $vbphrase[casino_has_left_game]&lt;/b&gt;"; 
			$db->query("INSERT INTO casino_texasholdem_chatlog (msg, msgtime) VALUES ('$msg', $time)");

			// If it was there turn, move to next person 
			$result3 = $db->query_read("SELECT * FROM casino_settings WHERE settingname='texasholdem_whosturn' AND switch2 ='$seat'");
			if($row3 = $db->fetch_row($result3))
			{ 
				$position = array_search ($seat, $playerarray )+1;
		
				if($playerarray[$position])
					$nextplayer = $playerarray[$position]; 
				else 
					$nextplayer = $playerarray[0];

				$db->query("UPDATE casino_settings SET switch2='$nextplayer' WHERE settingname='texasholdem_whosturn'");
				// End move to next person
		
			} 

			$db->query("UPDATE casino_settings SET switch2='$time' WHERE settingname='texasholdem_lasttime'");
			$db->query("DELETE FROM casino_texasholdem_whoisin WHERE userid = $userid");
		// start winner check

			$query = "SELECT count(seat) AS seats FROM casino_texasholdem_whoisin WHERE status = 1";
			$result = $db->query_read($query);
			$row = $db->fetch_array($result);
			$seats = $row['seats'];
			
			if($seats == 1)
			{
				// Only one left, they win.
			
				$query = "
					SELECT casino_texasholdem_whoisin.userid AS userid, username, casino_texasholdem_whoisin.bet 
					FROM casino_texasholdem_whoisin, " . TABLE_PREFIX ."user AS user
					WHERE casino_texasholdem_whoisin.status = 1
					AND casino_texasholdem_whoisin.userid = user.userid
				";
				$result = $db->query_read($query);
				$row = $db->fetch_array($result);
				$wuname = addslashes(htmlspecialchars(strip_tags(trim(addslashes($row['username']))),ENT_QUOTES));
				$wuid = $row['userid'];
				$bet = $row['bet'];
				
				if( $bet < $amounttocall)
				{
					$query = "SELECT * FROM casino_texasholdem_whoisin";
					$result = $db->query_read($query);
						while ($row = $db->fetch_array($result))
					{
						$whoisinid = $row['whoisinid'];
						$bet2 = $row['bet'];
						$userid2 = $row['userid'];
						if($bet2 > $bet)
						{
							$refund = $bet2 - $bet;
							$db->query("UPDATE " . TABLE_PREFIX . "user SET $cashtype = $cashtype + $refund WHERE userid = $userid2");
							$db->query ("
								UPDATE casino_bet_stats
								SET won = won + $refund
								WHERE userid = $userid2
								AND gameid = $gameid 
							");

							$pot = $pot - $refund;
						}
					}	
				}
				
				$msg = "&lt;b style=\'color:#000000\'&gt;$wuname $vbphrase[casino_wins_the_hand] ($vbphrase[casino_currency_marker]$pot)&lt;/b&gt;";
				$db->query("UPDATE " . TABLE_PREFIX . "user SET $cashtype = $cashtype + $pot WHERE userid = $wuid");
				$db->query ("
					UPDATE casino_bet_stats
					SET won = won + $pot
					WHERE userid = $wuid
					AND gameid = $gameid 
				");
				
				$db->query("INSERT INTO casino_texasholdem_chatlog (msg, msgtime) VALUES ('$msg', $time)");

				cleargame(); 

				$round = 0;
				return 0;
			}
			else if ($seats == 0)
			{
				// Everyone left, clean up old game
				cleargame(); 

			}
		// End winner check

		}
	} 

}

function cleargame()
{
	global $db;
	$db->query("UPDATE casino_settings SET switch2='0' WHERE settingname='texasholdem_pot'");
	$db->query("UPDATE casino_settings SET switch2='0' WHERE settingname='texasholdem_round'");
	$db->query("UPDATE casino_settings SET switch2='0' WHERE settingname='texasholdem_lasttime'");
	$db->query("UPDATE casino_settings SET switch2='0' WHERE settingname='texasholdem_whosturn'");
	$db->query("UPDATE casino_texasholdem_whoisin SET status = 0, bet = 0 ");
	$db->query("UPDATE casino_settings SET switch1=0 WHERE settingname='texasholdem_maxraises'");
	
}

function getlasttime($t)
{
	global $db;
	global $round;
	$time = time();
	// Players all in?
	$query = "SELECT * FROM casino_settings WHERE settingname = 'texasholdem_lasttime'";
	$result = $db->query_read($query);
	$row = $db->fetch_array($result);
	$lasttime = $row[switch2];

	if (($lasttime > 0) && ($lasttime < $time - $t))
	{
		// Looks like it died...
		cleargame(); 
		$lasttime = 0;
		$round = 0;
		
	}
	return $lasttime;
}

function getchatlog()
{
	global $db;
	
	$lastmsg = 0;
	if($_POST['lastmsg'])
	{
		if (!get_magic_quotes_gpc()) {
			$lastmsg = addslashes(htmlspecialchars(strip_tags(trim($_POST['lastmsg'])),ENT_QUOTES));
		} else {
			$lastmsg = htmlspecialchars(strip_tags(trim($_POST['lastmsg'])),ENT_QUOTES);
		}
	}
	else 
	{
		$query = "SELECT max(chatlogid) AS chatlogid FROM casino_texasholdem_chatlog"; 
		$result = $db->query_read($query);
		if($row = $db->fetch_array($result))
			$lastmsg = $row['chatlogid'];
	}

	if(! $lastmsg) $lastmsg = 0;
	
	$query = "SELECT * FROM casino_texasholdem_chatlog WHERE chatlogid > $lastmsg ORDER BY msgtime ASC, chatlogid ASC LIMIT 15"; 
	$result = $db->query_read($query);
	while($row = $db->fetch_array($result))
	{
		if($row['chatlogid'] > $lastmsg)
			$lastmsg = $row['chatlogid'];
		$msg = $row['msg'];
		$chatlog .= "$msg&lt;br/&gt;";
	}
	if($chatlog=="") $chatlog = "|";
	if($lastmsg=="") $lastmsg = 0;

	$chatlog = "<chat>$chatlog</chat>";
	$chatlog .= "<lastmsg>$lastmsg</lastmsg>";

	return $chatlog;
}
?>
