<?php
	// $hand = 2 card
	// $card = common cards

function findwinner()
{
	global $db;
	global $playerarray;
	global $numplayers;
	
	$query = "SELECT * FROM casino_texasholdem_dealt WHERE playerid = 0 ORDER BY dealtid LIMIT 5";
	$result = $db->query($query);
	$common = array();
	$i = 0;
	while($row = $db->fetch_array($result)) {
		$common[$i] = $row['card'];
		$i++;
	}
	$winner = 0;
	$besthand = array();
	foreach ($playerarray as $p)
	{
		$query = "SELECT * FROM casino_texasholdem_dealt WHERE playerid = $p ORDER BY dealtid LIMIT 2";
		$result = $db->query($query);
		$hand = array();
		$i = 0;
		while($row = $db->fetch_array($result)) {
			$hand[$i] = $row['card']; 
			$i++;
		}
		$th = array();
		$th = findbesthand($hand, $common);
		$thishand = explode(",", $th);
		
		if($winner == 0)
		{
			$winner = $p;
			$besthand = $thishand;
		}
		else 
		{
			if($thishand[5] > $besthand[5])
			{
				// Stronger hand 
				$winner = $p;
				$besthand = $thishand;
				$drawid = "";
			}
			else if ($thishand[5] == $besthand[5])
			{
				// Same basic type, do deeper comparisson 
			

				if ($thishand[5] == 9)
				{
					// Straight flush 
					if ($thishand[6] > $besthand[6])
					{
						$winner = $p;
						$besthand = $thishand;
						$drawid = "";
					}
				}
				else if ($thishand[5] == 8)
				{
					// Four of a KInd
					if ($thishand[6] > $besthand[6])
					{
						$winner = $p;
						$besthand = $thishand;
						$drawid = "";
					}
				}
				else if ($thishand[5] == 7)
				{
					// Full House 
					if ($thishand[6] > $besthand[6])
					{
						$winner = $p;
						$besthand = $thishand;
						$drawid = "";
					}
					else if ($thishand[6] == $besthand[6])
					{
						if ($thishand[7] > $besthand[7])
						{
							$winner = $p;
							$besthand = $thishand;
							$drawid = "";
						}
						else if ($thishand[7] == $besthand[7])
						{
							$a = array();
							$b = array();
							for($x = 0; $x < 5 ; $x++)
							{
								$a[$x] = $thishand[$x] % 13;
								$b[$x] = $besthand[$x] % 13;
							}
							rsort($a);
							rsort($b);
							$x = 0;
							while($x < 5)
							{
								if($a[$x] > $b[$x])
								{
									$winner = $p;
									$besthand = $thishand;
									$x = 5;
								}
								else if($a[$x] < $b[$x])
								{
									$x = 5;
								}
								$x++;
								if ($x == 5) $drawid = ", $p";
							}
						}
					}
				}
				else if ($thishand[5] == 6)
				{
					// Flush 
					if ($thishand[6] > $besthand[6])
					{
						$winner = $p;
						$besthand = $thishand;
						$drawid = "";
					}
					else if ($thishand[6] == $besthand[6])
					{
						$a = array();
						$b = array();
						for($x = 0; $x < 5 ; $x++)
						{
							$a[$x] = $thishand[$x] % 13;
							$b[$x] = $besthand[$x] % 13;
						}
						rsort($a);
						rsort($b);
						$x = 0;
						while($x < 5)
						{
							if($a[$x] > $b[$x])
							{
								$winner = $p;
								$besthand = $thishand;
								$drawid = "";
								$x = 5;
							}
							else if($a[$x] < $b[$x])
							{
								$x = 5;
							}
							$x++;
							if ($x == 5) $drawid = ", $p";
						}
					}

				}
				else if ($thishand[5] == 5)
				{
					// Straight 
					if ($thishand[6] > $besthand[6])
					{
						$winner = $p;
						$besthand = $thishand;
						$drawid = "";
					}
					else if ($thishand[6] == $besthand[6])
					{
						$drawid = ", $p";
					}

				}
				else if ($thishand[5] == 4)
				{
					// Three of a Kind 
					if ($thishand[6] > $besthand[6])
					{
						$winner = $p;
						$besthand = $thishand;
						$drawid = "";
					}
					else if ($thishand[6] == $besthand[6])
					{
						$a = array();
						$b = array();
						for($x = 0; $x < 5 ; $x++)
						{
							$a[$x] = $thishand[$x] % 13;
							$b[$x] = $besthand[$x] % 13;
						}
						rsort($a);
						rsort($b);
						$x = 0;
						while($x < 5)
						{
							if($a[$x] > $b[$x])
							{
								$winner = $p;
								$besthand = $thishand;
								$drawid = "";
								$x = 5;
							}
							else if($a[$x] < $b[$x])
							{
								$x = 5;
							}
							$x++;
							if ($x == 5) $drawid = ", $p";
						}
					}
					
				}
				else if ($thishand[5] == 3)
				{
					// Two Pair 
					if ($thishand[6] > $besthand[6])
					{
						$winner = $p;
						$besthand = $thishand;
						$drawid = "";

					}
					else if (($thishand[6] == $besthand[6]) && ($thishand[7] > $besthand[7]))
					{
						$winner = $p;
						$besthand = $thishand;
						$drawid = "";
						
					}
					else if (($thishand[6] == $besthand[6]) && ($thishand[7] == $besthand[7]))
					{
						$a = array();
						$b = array();
						for($x = 0; $x < 5 ; $x++)
						{
							$a[$x] = $thishand[$x] % 13;
							$b[$x] = $besthand[$x] % 13;
						}
						rsort($a);
						rsort($b);
						$x = 0;
						while($x < 5)
						{
							if($a[$x] > $b[$x])
							{
								$winner = $p;
								$besthand = $thishand;
								$x = 5;
							}
							else if($a[$x] < $b[$x])
							{
								$x = 5;
							}
							$x++;
							if ($x == 5) $drawid = ", $p";
						}
					}
					
				}
				else if ($thishand[5] == 2)
				{
					// Pair 
					if ($thishand[6] > $besthand[6])
					{
						$winner = $p;
						$besthand = $thishand;
						$drawid = "";
						
					}
					else if ($thishand[6] == $besthand[6])
					{
						$a = array();
						$b = array();
						for($x = 0; $x < 5 ; $x++)
						{
							$a[$x] = $thishand[$x] % 13;
							$b[$x] = $besthand[$x] % 13;
						}
						rsort($a);
						rsort($b);
						$x = 0;
						while($x < 5)
						{
							if($a[$x] > $b[$x])
							{
								$winner = $p;
								$besthand = $thishand;
								$drawid = "";
								
								$x = 5;
							}
							else if($a[$x] < $b[$x])
							{
								$x = 5;
							}
							$x++;
							if ($x == 5) $drawid = ", $p";
						}
					}
					
				}
				else if ($thishand[5] == 1)
				{
					// High card 
						$a = array();
						$b = array();
						for($x = 0; $x < 5 ; $x++)
						{
							$a[$x] = $thishand[$x] % 13;
							$b[$x] = $besthand[$x] % 13;
						}
						rsort($a);
						rsort($b);
						$x = 0;
						while($x < 5)
						{
							if($a[$x] > $b[$x])
							{
								$winner = $p;
								$besthand = $thishand;
								$drawid = "";
								$x = 5;
							}
							else if($a[$x] < $b[$x])
							{
								$x = 5;
							}
							$x++;
							if ($x == 5) $drawid = ", $p";
						}
					}
		
			}
		}
	}
	if ($drawid) $winner = "$winner$drawid";
	return $winner;

}



function findbesthand($hand, $card)
{
	$f = array();
	$s = array();
	$besthand = array();
	// 0 - 4 = cards
	// 5 = hand type
	// 6 = value of cards in hand. 
	
	// Find values of 2 card hand.
	
	$card[5] = $hand[0];
	$card[6] = $hand[1];
	
	// Choose the best 5 of 5 to make a hand. 

	for($x=0;$x<7;$x++)
	{
	for($y=$x+1;$y<7;$y++)
	{
	for($a=$y+1;$a<7;$a++)
	{
		for($b=$a+1;$b<7;$b++)
		{
			for($c=$b+1;$c<7;$c++)
			{
				// Get the values 
				$f[0] = $card[$x] % 13;
				$s[0] = floor($card[$x]/13);

				$f[1] = $card[$y] % 13;
				$s[1] = floor($card[$y]/13);

				$f[2] = $card[$a] % 13;
				$s[2] = floor($card[$a]/13);
				$f[3] = $card[$b] % 13;
				$s[3] = floor($card[$b]/13);
				$f[4] = $card[$c] % 13;
				$s[4] = floor($card[$c]/13);

				// Reset counters
				$fcount = array();
				$scount = array();
				$pair = array();
				$flush = 0;
				$straight = 0;
				$paircount = $three = $four = 0;
				$handvalue = 0;
				
				// Check the hand compared to the best one so far. 
				
				// Flush
				if(($s[0] == $s[1])&&($s[0] == $s[2])&&($s[0] == $s[3])&&($s[0] == $s[4]))
					$flush = 1;;
				// count matching cards
				for($i = 0; $i < 5; $i++) {
					$f1 = $f[$i];
					$fcount[$f1]++;
				}
				// Count pairs
				for($i = 0; $i < 13; $i++) {
					if($fcount[$i]==2){
						$pair[$paircount] = $i+1;
						$paircount+=1; 
					}
				// Three or Four of a kind?
					else if($fcount[$i]==3)$three = $i+1;
					else if($fcount[$i]==4)$four = $i+1;;
				}
				// Straight
				if (($paircount==0) && ($three==0) && ($four==0))
				{
					if ((max($f) - min($f)) == 4) 
					{
						$straight = max($f)+1;
					}
					else if(max($f) == 12)
					{
						if($f[0] + $f[1] + $f[2] + $f[3] + $f[4] == 18)
						{
							$straight = 5;
						}
					}
				}

				$trigger = 0;
				if(($straight)&&($flush))
				{
					//echo "Straight Flush";
					if($besthand[5] < 9){
						$trigger = 9;
						$besthand[6] = $straight;
					}
					if(($besthand[5] == 9)&&($besthand[6] < $straight)) {
						$trigger = 9;
						$besthand[6] = $straight;
					}

				}	
				else if($four)
				{
					//echo "Four of a kind";
					if($besthand[5] < 8){
						$besthand[6] = $four;
						$trigger = 8;
					}
					else if(($besthand[5] == 8)&&($besthand[6] < $four)) {
						$trigger = 8; 
						$besthand[6] = $four;
					}
					else if(($besthand[5] == 8)&&($besthand[6] == $four)) {

						// match, take high card
						$f2 = array();
						$b2 = array();
						for ($i=0;$i<5;$i++)
						{
							$b2[$i] = $besthand[$i]  % 13;
							$f2[$i] = $f[$i];
						}
							// Sort Duplicates from high to low values
						rsort($f2);
						rsort($b2);
						// Find first higher value
						$i = 0; 
						while ($i<5)
						{
							if($b2[$i] > $f2[$i]) {
								// do nothing, new one is lower. 
								$i = 5; 
							}
							else if($f2[$i] > $b2[$i]) {
								// new one is higher
								$trigger = 8;
								$besthand[6] = $four;
								$i = 5;
							}
							$i++;
						}
					}
				}	
				else if(($three)&&($paircount))
				{
					//echo "Full House";
					if($besthand[5] < 7){
						$trigger = 7;
						$besthand[6] = $three;
					}
					if(($besthand[5] == 7)&&($besthand[6] < $three)) {
						$trigger = 7; 
						$besthand[6] = $three;
					}
				}	
				else if($flush)
				{
					//echo "Flush";
					if($besthand[5] < 6){
						$trigger = 6;
						$besthand[6] = max($f);
					}
					if(($besthand[5] == 6)&&($besthand[6] < max($f))) {
						$trigger = 6;
						$besthand[6] = max($f);
					}
					else if(($besthand[5] == 6)&&($besthand[6] == max($f))) {
						// Duplicate the face values of the best & current
							$f2 = array();
							$b2 = array();
							for ($i=0;$i<5;$i++)
							{
								$b2[$i] = $besthand[$i]  % 13;
								$f2[$i] = $f[$i];
							}

						// Sort Duplicates from high to low values
						rsort($f2);
						rsort($b2);
						// Find first higher value
						$i = 0; 
						while ($i<5)
						{
							if($b2[$i] > $f2[$i]) {
								// do nothing, new one is lower. 
								$i = 5; 
							}
							else if($f2[$i] > $b2[$i]) {
								// new one is higher
								$trigger = 6;
								$i = 5;
							}
							$i++;
						}
						
					}

				}	
				else if($straight)
				{
					//echo "Straight";
					if($besthand[5] < 5){
						$trigger = 5;
						$besthand[6] = $straight;
					}
					else if(($besthand[5] == 5)&&($besthand[6] < $straight)) {
						$trigger = 5;
						$besthand[6] = $straight;
					}
					
				}	
				else if($three)
				{
					//echo "Three of a Kind";
					if($besthand[5] < 4){
						$trigger = 4;
						$besthand[6] = $three;
					}
					else if(($besthand[5] == 4) && ($besthand[6] < $three)) {
						$trigger = 4; 
						$besthand[6] = $three;
					}
					else if(($besthand[5] == 4) && ($besthand[6] == $three)) {

						// match, take high card
						$f2 = array();
						$b2 = array();
						for ($i=0;$i<5;$i++)
						{
							$b2[$i] = $besthand[$i]  % 13;
							$f2[$i] = $f[$i];
						}
							// Sort Duplicates from high to low values
						rsort($f2);
						rsort($b2);
						// Find first higher value
						$i = 0; 
						while ($i<5)
						{
							if($b2[$i] > $f2[$i]) {
								// do nothing, new one is lower. 
								$i = 5; 
							}
							else if($f2[$i] > $b2[$i]) {
								// new one is higher
								$trigger = 4;
								$besthand[6] = $three;
								$i = 5;
							}
							$i++;
						}

					}
				}
				else if($paircount==2)
				{
					//echo "Two Pair";
					if($besthand[5] < 3)
					{
						$trigger = 3;
						$besthand[6] = max($pair);
						$besthand[7] = min($pair);
					}
					if($besthand[5] == 3)
					{
						if($besthand[6] < max($pair)) {
							// Use it, higher pair is higher
							$trigger = 3;
							$besthand[6] = max($pair);
							$besthand[7] = min($pair);
						}
						else if(($besthand[6] == max($pair))&&($besthand[7] < min($pair))) {
							// Use it, high pairs match, lower is higher 
							$trigger = 3;
							$besthand[6] = max($pair);
							$besthand[7] = min($pair);
						}
						else if(($besthand[6] == max($pair))&&($besthand[7] == min($pair))) {
							// Both pairs match, take high card
							$f2 = array();
							$b2 = array();
							for ($i=0;$i<5;$i++)
							{
								$b2[$i] = $besthand[$i]  % 13;
								$f2[$i] = $f[$i];
							}

							// Sort Duplicates from high to low values
							rsort($f2);
							rsort($b2);
							// Find first higher value
							$i = 0; 
							while ($i<5)
							{
								if($b2[$i] > $f2[$i]) {
									// do nothing, new one is lower. 
									$i = 5; 
								}
								else if($f2[$i] > $b2[$i]) {
									// new one is higher
									$trigger = 3;
									$besthand[6] = max($pair);
									$besthand[7] = min($pair);
									$i = 5;
								}
								$i++;
							}
							
						}
					}

				}	
				else if($paircount==1)
				{
					//echo "Pair";
					if($besthand[5] < 2) {
						$trigger = 2;
						$besthand[6] = max($pair);
					}
					else if ($besthand[5] == 2)
					{
						if($besthand[6] < $pair[0]) {
							// Use it, it's higher
							$trigger = 2;
							$besthand[6] = max($pair);
						}
						else if($besthand[6] == $pair[0]) {
							// pairs match, take highest different card
							$f2 = array();
							$b2 = array();
							for ($i=0;$i<5;$i++)
							{
								$b2[$i] = $besthand[$i]  % 13;
								$f2[$i] = $f[$i];
							}
							// Sort Duplicates from high to low values
							rsort($f2);
							rsort($b2);
							// Find first higher value
							$i = 0; 
							while ($i<5)
							{
								if($b2[$i] > $f2[$i]) {
									// do nothing, new one is lower. 
									$i = 5; 
								}
								else if($f2[$i] > $b2[$i]) {
									// new one is higher
									$trigger = 2;
									$besthand[6] = max($pair);
									$i = 5;
								}
								$i++;
							}
							
						}						
					}
				}	
				else 
				{
					// Nothing / High card. 
					if ($besthand[5] < 1)
						$trigger = 1;
					else if ($besthand[5] == 1)
					{
						// High card on both, find the best set 
						$f2 = array();
						$b2 = array();
						for ($i=0;$i<5;$i++)
						{
							$b2[$i] = $besthand[$i]  % 13;
							$f2[$i] = $f[$i];
						}
						// Sort Duplicates from high to low values
						rsort($f2);
						rsort($b2);
						// Find first higher value
						$i = 0; 
						while ($i<5)
						{
							if($b2[$i] > $f2[$i]) {
								// do nothing, new one is lower. 
								$i = 5; 
							}
							else if($f2[$i] > $b2[$i]) {
								// new one is higher
								$trigger = 1;
								$i = 5;
							}
							$i++;
						}
					}

				}	
				
				if($trigger)
				{ 
					$besthand[5] = $trigger;
					for($i=0;$i<5;$i++)
						$besthand[$i] = $f[$i] + ($s[$i] * 13);
				}

			}
		}
	}
}
}

	ksort($besthand);
	return implode(",", $besthand);
}

?>