<?php
if (!defined('IDIR')) { die; }

class xenforo_011 extends xenforo_000
{
	var $_dependent = '010';

	function xenforo_011(&$displayobject)
	{
		$this->_modulestring = 'Process inline attachments';
	}

	function init(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		$class_num = substr(get_class($this) , -3);

		if ($this->check_order($sessionobject,$this->_dependent))
		{
			if ($this->_restart)
			{
				$sessionobject->add_error($Db_target, 'fatal', $class_num, 0, 'Restarting "Process inline attachments" failed', 'This module cannot be executed twice!');
			}

			// Start up the table
			$displayobject->update_basic('title',$displayobject->phrases['import_moderator']);
			$displayobject->update_html($displayobject->do_form_header('index', $class_num));
			$displayobject->update_html($displayobject->make_hidden_code($class_num, 'WORKING'));
			$displayobject->update_html($displayobject->make_table_header($this->_modulestring));

			// Ask some questions
			$displayobject->update_html($displayobject->make_input_code($displayobject->phrases['units_per_page'], 'perpage', 1000));

			// End the table
			$displayobject->update_html($displayobject->do_form_footer($displayobject->phrases['continue'],$displayobject->phrases['reset']));

			// Reset/Setup counters for this
			$sessionobject->add_session_var("011_objects_done", '0');
			$sessionobject->add_session_var("011_objects_failed", '0');
			$sessionobject->add_session_var('startat','0');
		}
		else
		{
			// Dependant has not been run
			$displayobject->update_html($displayobject->do_form_header('index', ''));
			$displayobject->update_html($displayobject->make_description("<p>{$displayobject->phrases['dependant_on']}<i><b> " . $sessionobject->get_module_title($this->_dependent) . "</b> {$displayobject->phrases['cant_run']}</i> ."));
			$displayobject->update_html($displayobject->do_form_footer($displayobject->phrases['continue'],''));
			$sessionobject->set_session_var($class_num, 'FALSE');
			$sessionobject->set_session_var('module','000');
		}
	}

	function resume(&$sessionobject, &$displayobject, &$Db_target, &$Db_source)
	{
		// Set up working variables.
		$displayobject->update_basic('displaymodules','FALSE');
		$t_db_type		= $sessionobject->get_session_var('targetdatabasetype');
		$t_tb_prefix	= $sessionobject->get_session_var('targettableprefix');
		$s_db_type		= $sessionobject->get_session_var('sourcedatabasetype');
		$s_tb_prefix	= $sessionobject->get_session_var('sourcetableprefix');

		// Per page vars
		$start_at		= $sessionobject->get_session_var('startat');
		$per_page		= $sessionobject->get_session_var('perpage');
		$class_num		= substr(get_class($this) , -3);
		$idcache 		= new ImpExCache($Db_target, $t_db_type, $t_tb_prefix);
		$ImpExData		= new ImpExData($Db_target, $sessionobject, 'moderator');

		// Start the timing
		if(!$sessionobject->get_session_var("{$class_num}_start"))
		{
			$sessionobject->timing($class_num , 'start' ,$sessionobject->get_session_var('autosubmit'));
		}

		// Get an array data
		$attachments = $Db_target->query("
			SELECT attachmentid
			FROM {$t_tb_prefix}attachment
			WHERE importattachmentid != 0
			ORDER BY attachmentid ASC
			LIMIT $start_at, $per_page
		");
		while ($attachment = $Db_target->fetch_array($attachments))
		{
			$Db_target->query("
				UPDATE {$t_tb_prefix}post
				SET
					pagetext = REPLACE(pagetext, '[ATTACH]$attachment[importattachmentid][/ATTACH]', '[ATTACH]$attachment[attachmentid][/ATTACH]'),
					pagetext = REPLACE(pagetext, '[ATTACH=full]$attachment[importattachmentid][/ATTACH]', '[ATTACH]$attachment[attachmentid][/ATTACH]')
				WHERE importpostid != 0
				AND pagetext LIKE '%[ATTTACH%'
			");
		
			$displayobject->display_now('<br />' . $displayobject->phrases['attachment'] . ' -> ' . $attachment['attachmentid']);
			$sessionobject->add_session_var("{$class_num}_objects_done",intval($sessionobject->get_session_var("{$class_num}_objects_done")) + 1 );
		}
		
		// Check for page end
		if ($Db_target->num_rows($attachments) < $per_page)
		{
			$sessionobject->timing($class_num, 'stop', $sessionobject->get_session_var('autosubmit'));
			$sessionobject->remove_session_var("{$class_num}_start");

			$displayobject->update_html($displayobject->module_finished($this->_modulestring,
				$sessionobject->return_stats($class_num, '_time_taken'),
				$sessionobject->return_stats($class_num, '_objects_done'),
				$sessionobject->return_stats($class_num, '_objects_failed')
			));

			$sessionobject->set_session_var($class_num , 'FINISHED');
			$sessionobject->set_session_var('module', '000');
			$sessionobject->set_session_var('autosubmit', '0');
		}

		$sessionobject->set_session_var('startat', $data_array['lastid']);
		$displayobject->update_html($displayobject->print_redirect('index.php',$sessionobject->get_session_var('pagespeed')));
	}// End resume
}//End Class
?>
