/*!
 * froala_editor v2.6.5 (https://www.froala.com/wysiwyg-editor)
 * License https://froala.com/wysiwyg-editor/terms/
 * Copyright 2014-2017 Froala Labs
 */

(function (factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(['jquery'], factory);
    } else if (typeof module === 'object' && module.exports) {
        // Node/CommonJS
        module.exports = function( root, jQuery ) {
            if ( jQuery === undefined ) {
                // require('jQuery') returns a factory that requires window to
                // build a jQuery instance, we normalize how we use modules
                // that require this pattern but the window provided is a noop
                // if it's defined (how jquery works)
                if ( typeof window !== 'undefined' ) {
                    jQuery = require('jquery');
                }
                else {
                    jQuery = require('jquery')(root);
                }
            }
            return factory(jQuery);
        };
    } else {
        // Browser globals
        factory(window.jQuery);
    }
}(function ($) {
/**
 * Turkish
 */

$.FE.LANGUAGE['tr'] = {
  translation: {
    // Place holder
    "Type something": "Bir \u015fey yaz\u0131n",

    // Basic formatting
    "Bold": "Kal\u0131n",
    "Italic": "\u0130talik",
    "Underline": "Alt\u0131 \u00e7izili",
    "Strikethrough": "\u00dcst\u00fc \u00e7izili",

    // Main buttons
    "Insert": "Ekle",
    "Delete": "Silmek",
    "Cancel": "\u0130ptal",
    "OK": "Tamam",
    "Back": "Geri",
    "Remove": "Kald\u0131r",
    "More": "Daha",
    "Update": "G\u00fcncelle\u015ftirme",
    "Style": "Stil",

    // Font
    "Font Family": "Yaz\u0131tipi Ailesi",
    "Font Size": "Yaz\u0131tipi B\u00fcy\u00fckl\u00fc\u011f\u00fc",

    // Colors
    "Colors": "Renkler",
    "Background": "Arkaplan",
    "Text": "Metin",

    // Paragraphs
    "Paragraph Format": "Bi\u00e7imler",
    "Normal": "Normal",
    "Code": "Kod",
    "Heading 1": "Ba\u015fl\u0131k 1",
    "Heading 2": "Ba\u015fl\u0131k 2",
    "Heading 3": "Ba\u015fl\u0131k 3",
    "Heading 4": "Ba\u015fl\u0131k 4",

    // Style
    "Paragraph Style": "Paragraf stili",
    "Inline Style": "\u00c7izgide stili",

    // Alignment
    "Align": "Hizalama",
    "Align Left": "Sola hizala",
    "Align Center": "Ortala",
    "Align Right": "Sa\u011fa hizala",
    "Align Justify": "\u0130ki yana yasla",
    "None": "Hi\u00e7biri",

    // Lists
    "Ordered List": "S\u0131ral\u0131 liste",
    "Unordered List": "S\u0131ras\u0131z liste",

    // Indent
    "Decrease Indent": "Girintiyi azalt",
    "Increase Indent": "Girintiyi art\u0131r",

    // Links
    "Insert Link": "Ba\u011flant\u0131 ekle",
    "Open in new tab": "Yeni sekmede a\u00e7",
    "Open Link": "Linki a\u00e7",
    "Edit Link": "D\u00fczenleme ba\u011flant\u0131s\u0131",
    "Unlink": "Ba\u011flant\u0131y\u0131 kald\u0131r",
    "Choose Link": "Ba\u011flant\u0131y\u0131 se\u00e7in",

    // Images
    "Insert Image": "Resim ekle",
    "Upload Image": "Y\u00fckleme g\u00f6r\u00fcnt\u00fcs\u00fc",
    "By URL": "URL'ye g\u00f6re",
    "Browse": "G\u00f6zat",
    "Drop image": "B\u0131rak resim",
    "or click": "ya da t\u0131klay\u0131n",
    "Manage Images": "G\u00f6r\u00fcnt\u00fcleri y\u00f6netin",
    "Loading": "Y\u00fckleniyor",
    "Deleting": "Silme",
    "Tags": "Etiketler",
    "Are you sure? Image will be deleted.": "Emin misin? Resim silinecektir.",
    "Replace": "De\u011fi\u015ftirmek",
    "Uploading": "Y\u00fckleme",
    "Loading image": "Y\u00fckleme g\u00f6r\u00fcnt\u00fcs\u00fc",
    "Display": "G\u00f6stermek",
    "Inline": "\u00c7izgide",
    "Break Text": "K\u0131r\u0131lma metni",
    "Alternate Text": "Alternatif metin",
    "Change Size": "De\u011fi\u015fim boyutu",
    "Width": "Geni\u015flik",
    "Height": "Y\u00fckseklik",
    "Something went wrong. Please try again.": "Bir \u015feyler yanl\u0131\u015f gitti. L\u00fctfen tekrar deneyin.",

    // Video
    "Insert Video": "Video ekle",
    "Embedded Code": "G\u00f6m\u00fcl\u00fc kod",

    // Tables
    "Insert Table": "Tablo ekle",
    "Table Header": "Tablo \u00fcstbilgisi",
    "Remove Table": "Tablo kald\u0131rma",
    "Table Style": "Tablo stili",
    "Horizontal Align": "Yatay hizalama",
    "Row": "Sat\u0131r",
    "Insert row above": "\u00d6ncesine yeni sat\u0131r ekle",
    "Insert row below": "Sonras\u0131na yeni sat\u0131r ekle",
    "Delete row": "Sat\u0131r\u0131 sil",
    "Column": "S\u00fctun",
    "Insert column before": "\u00d6ncesine yeni s\u00fctun ekle",
    "Insert column after": "Sonras\u0131na yeni s\u00fctun ekle",
    "Delete column": "S\u00fctunu sil",
    "Cell": "H\u00fccre",
    "Merge cells": "H\u00fccreleri birle\u015ftir",
    "Horizontal split": "Yatay b\u00f6l\u00fcnm\u00fc\u015f",
    "Vertical split": "Dikey  b\u00f6l\u00fcnm\u00fc\u015f",
    "Cell Background": "H\u00fccre arka plan\u0131",
    "Vertical Align": "Dikey hizalama",
    "Top": "\u00dcst",
    "Middle": "Orta",
    "Bottom": "Alt",
    "Align Top": "\u00dcst hizalama",
    "Align Middle": "Orta hizalama",
    "Align Bottom": "Dibe hizalama",
    "Cell Style": "H\u00fccre stili",

    // Files
    "Upload File": "Dosya Y\u00fckle",
    "Drop file": "B\u0131rak dosya",

    // Emoticons
    "Emoticons": "\u0130fadeler",
    "Grinning face": "S\u0131r\u0131tan y\u00fcz",
    "Grinning face with smiling eyes": "G\u00fclen g\u00f6zlerle y\u00fcz s\u0131r\u0131tarak",
    "Face with tears of joy": "Sevin\u00e7 g\u00f6zya\u015flar\u0131yla Y\u00fcz",
    "Smiling face with open mouth": "A\u00e7\u0131k a\u011fz\u0131 ile g\u00fcl\u00fcmseyen y\u00fcz\u00fc",
    "Smiling face with open mouth and smiling eyes": "A\u00e7\u0131k a\u011fzı ve g\u00fcl\u00fcmseyen g\u00f6zlerle g\u00fcler y\u00fcz",
    "Smiling face with open mouth and cold sweat": "A\u00e7\u0131k a\u011fz\u0131 ve so\u011fuk ter ile g\u00fclen y\u00fcz\u00fc",
    "Smiling face with open mouth and tightly-closed eyes": "A\u00e7\u0131k a\u011fz\u0131 s\u0131k\u0131ca kapal\u0131 g\u00f6zlerle g\u00fclen y\u00fcz\u00fc",
    "Smiling face with halo": "Halo ile y\u00fcz g\u00fclen",
    "Smiling face with horns": "Boynuzlar\u0131 ile g\u00fcler y\u00fcz",
    "Winking face": "G\u00f6z a\u00e7\u0131p kapay\u0131ncaya y\u00fcz\u00fc",
    "Smiling face with smiling eyes": "G\u00fclen g\u00f6zlerle g\u00fcler Y\u00fcz",
    "Face savoring delicious food": "Lezzetli yemekler tad\u0131n\u0131 Y\u00fcz",
    "Relieved face": "Rahatlad\u0131m y\u00fcz\u00fc",
    "Smiling face with heart-shaped eyes": "Kalp \u015feklinde g\u00f6zlerle g\u00fcler y\u00fcz",
    "Smiling face with sunglasses": "Kalp \u015feklinde g\u00f6zlerle g\u00fcler y\u00fcz",
    "Smirking face": "S\u0131r\u0131tan y\u00fcz",
    "Neutral face": "N\u00f6tr y\u00fcz",
    "Expressionless face": "Ifadesiz y\u00fcz\u00fc",
    "Unamused face": "Kay\u0131ts\u0131z y\u00fcz\u00fc",
    "Face with cold sweat": "So\u011fuk terler Y\u00fcz",
    "Pensive face": "dalg\u0131n bir y\u00fcz",
    "Confused face": "\u015fa\u015fk\u0131n bir y\u00fcz",
    "Confounded face": "Ele\u015ftirilmi\u015ftir y\u00fcz\u00fc",
    "Kissing face": "\u00f6p\u00fc\u015fme y\u00fcz\u00fc",
    "Face throwing a kiss": "Bir \u00f6p\u00fcc\u00fck atma Y\u00fcz",
    "Kissing face with smiling eyes": "G\u00fclen g\u00f6zlerle y\u00fcz \u00f6p\u00fc\u015fme",
    "Kissing face with closed eyes": "Kapal\u0131 g\u00f6zlerle \u00f6p\u00f6\u015fme y\u00fcz",
    "Face with stuck out tongue": "Dilini y\u00fcz ile s\u0131k\u0131\u015fm\u0131\u015f",
    "Face with stuck out tongue and winking eye": "\u015ea\u015f\u0131r\u0131p kalm\u0131\u015f d\u0131\u015far\u0131 dil ve g\u00f6z k\u0131rpan y\u00fcz",
    "Face with stuck out tongue and tightly-closed eyes": "Y\u00fcz ile dil ve s\u0131k\u0131ca kapal\u0131 g\u00f6zleri s\u0131k\u0131\u015fm\u0131\u015f",
    "Disappointed face": "Hayal k\u0131r\u0131kl\u0131\u011f\u0131na y\u00fcz\u00fc",
    "Worried face": "Endi\u015feli bir y\u00fcz",
    "Angry face": "K\u0131zg\u0131n y\u00fcz",
    "Pouting face": "Somurtarak y\u00fcz\u00fc",
    "Crying face": "A\u011flayan y\u00fcz",
    "Persevering face": "Azmeden y\u00fcz\u00fc",
    "Face with look of triumph": "Zafer bak\u0131\u015fla Y\u00fcz",
    "Disappointed but relieved face": "Hayal k\u0131r\u0131kl\u0131\u011f\u0131 ama rahatlad\u0131m y\u00fcz",
    "Frowning face with open mouth": "A\u00e7\u0131k a\u011fz\u0131 ile \u00e7at\u0131k y\u00fcz\u00fc",
    "Anguished face": "Kederli y\u00fcz",
    "Fearful face": "Korkulu y\u00fcz\u00fc",
    "Weary face": "Yorgun y\u00fcz\u00fc",
    "Sleepy face": "Uykulu y\u00fcz\u00fc",
    "Tired face": "Yorgun y\u00fcz\u00fc",
    "Grimacing face": "Y\u00fcz\u00fcn\u00fc buru\u015fturarak y\u00fcz\u00fc",
    "Loudly crying face": "Y\u00fcksek sesle y\u00fcz\u00fc a\u011fl\u0131yor",
    "Face with open mouth": "A\u00e7\u0131k a\u011fz\u0131 ile Y\u00fcz",
    "Hushed face": "Dingin y\u00fcz\u00fc",
    "Face with open mouth and cold sweat": "A\u00e7\u0131k a\u011fz\u0131 ve so\u011fuk ter ile Y\u00fcz",
    "Face screaming in fear": "Korku i\u00e7inde \u00e7ı\u011fl\u0131k Y\u00fcz",
    "Astonished face": "\u015fa\u015fk\u0131n bir y\u00fcz",
    "Flushed face": "K\u0131zarm\u0131\u015f y\u00fcz\u00fc",
    "Sleeping face": "Uyuyan y\u00fcz\u00fc",
    "Dizzy face": "Ba\u015f\u0131m d\u00f6nd\u00fc y\u00fcz",
    "Face without mouth": "A\u011f\u0131z olmadan Y\u00fcz",
    "Face with medical mask": "T\u0131bbi maske ile y\u00fcz",

    // Line breaker
    "Break": "K\u0131r\u0131lma",

    // Math
    "Subscript": "Alt simge",
    "Superscript": "\u00dcst simge",

    // Full screen
    "Fullscreen": "Tam ekran",

    // Horizontal line
    "Insert Horizontal Line": "Yatay \u00e7izgi ekleme",

    // Clear formatting
    "Clear Formatting": "Bi\u00e7imlendirme kald\u0131r",

    // Undo, redo
    "Undo": "Geri Al",
    "Redo": "Yinele",

    // Select all
    "Select All": "T\u00fcm\u00fcn\u00fc se\u00e7",

    // Code view
    "Code View": "Kod g\u00f6r\u00fcn\u00fcm\u00fc",

    // Quote
    "Quote": "Al\u0131nt\u0131",
    "Increase": "Art\u0131rmak",
    "Decrease": "Azal\u0131\u015f",

    // Quick Insert
    "Quick Insert": "H\u0131zl\u0131 insert"
  },
  direction: "ltr"
};

}));
