<?php
/*======================================================================*\
|| #################################################################### ||
|| # vB3 Advanced Warning System (AWS) By John Caradimas SV1CEC         ||
|| AWS Version 3.4.12
|| vBulletin 3.5.x 3.6.x support Delphiprogrammi
|| #################################################################### ||
\*======================================================================*/

error_reporting(E_ALL & ~E_NOTICE);

// #############################################################################
// run the warning options query

$warnopts = array();
global $vbulletin;

// ###################### Start chooseicons #######################

function build_aws_language($userid)
{
	global $vbulletin;
	$session_langid = $vbulletin->db->query_first("SELECT languageid FROM " . TABLE_PREFIX . "session WHERE userid='{$userid}'");
	$session_langid = $session_langid['languageid'];

	if ($session_langid == 0)
	{
		$langid = $vbulletin->db->query_first("SELECT languageid FROM " . TABLE_PREFIX . "user WHERE userid='{$userid}'");
		$langid = $langid['languageid'];
		if ($langid == 0)
		{
			$langid = $vbulletin->db->query_first("SELECT value FROM " . TABLE_PREFIX . "setting WHERE varname = 'languageid'");
			$langid = $langid['value'];
		}
	}
	else
	{
		$langid = $session_langid;
	}

	$phr_arr = $vbulletin->db->query_first("SELECT phrasegroup_aws FROM " . TABLE_PREFIX . "language WHERE languageid='{$langid}'");
	$phr_arr = $phr_arr['phrasegroup_aws'];
	$aws_phrase = array();
	$tmp = unserialize($phr_arr);
	if (is_array($tmp))
	{
		$aws_phrase = array_merge($aws_phrase, $tmp);
	}
	return $aws_phrase;
}
//######################################################################################################################################
function SendPmAws($fromuserid, $fromusername, $title, $message, $recipients)
{
	global $vbulletin, $botpermissions;
	$botpermissions['adminpermissions'] = 2;
	$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_SILENT);
	$pmdm->set('fromuserid', $fromuserid);
	$pmdm->set('fromusername', $fromusername);
	$pmdm->set('title', $title);
	$pmdm->set('message', $message);
	$pmdm->set_recipients($recipients,$botpermissions);
	$pmdm->set('dateline', TIMENOW);
	$pmdm->set('showsignature',1);
	$pmdm->set('allowsmilie',1);
    $pmdm->save();
	
}
//######################################################################################################################################
// FUNCTION PARSEINPUT : Parses inputs
// **************************************************
function ParseInput($val)
{
	global $vbulletin;
	if(is_int($val))
	{
		return $val;
	} 
	else
	{
		$val = str_replace( "&", "&amp;", $val);
		$val = str_replace( "<!--", "&#60;&#33;--", $val);
		$val = str_replace( "-->", "--&#62;", $val);
		$val = str_replace( ">", "&gt;", $val);
		$val = str_replace( "<", "&lt;", $val);
		$val = str_replace( "\"", "&quot;", $val);
		$val = preg_replace( "/\n/", "<br>", $val);
		$val = preg_replace( "/\\\$/", "&#036;", $val);
		$val = preg_replace( "/\r/", "", $val);
		$val = str_replace( "!", "&#33;", $val);
		$val = str_replace( "'", "&#39;", $val);
		$val = stripslashes($val);
		$val = preg_replace( "/\\\(?!&amp;#|\?#)/", "&#092;", $val);
		return $val;
	}
}
//#######################################################################################################################################
// FUNCTION RunErrorAws : Shows error messages
// ****************************************
function RunErrorAws($message)
{
	global $vbulletin, $session, $stylevar, $_POST, $vbphrase, $navbits, $show, $header;
	global $templatecache,$style,$headinclude,$footer;
	global $tempusagecache, $templateassoc, $pmbox, $pmtext;
	eval('$warn_page .= "' . fetch_template('warn_error') . '";');
	$navbits = construct_navbits($navbits);
	eval('$navbar = "' . fetch_template('navbar') . '";');
	eval('print_output("' . fetch_template('WARN') . '");');
	exit;
}
//######################################################################################################################################
// FUNCTION CHECK_USER : Does checks for the user
// **********************************************
function check_user($id,$pgroups)
{
	global $vbphrase, $user, $vbulletin;
	
	if($id == "" || !$id || $id < 1)
	{
		RunErrorAws($vbphrase['aws_invuserid']);
	}
	
	if($id == "1")
	{
		RunErrorAws($vbphrase['aws_func_phr1']);
	}
	if(!$user = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "user WHERE userid = '{$id}'"))
	{
		RunErrorAws($vbphrase['aws_func_phr2']);
	}
	
	$Protected_Usergroups = explode("|", $pgroups);
	
	if($Protected_Usergroups[0])
	{
		foreach($Protected_Usergroups as $pro)
		{
			if($pro == $user['usergroupid'])
			{
				RunErrorAws($vbphrase['aws_func_phr3']);
			}
		}
	}
	return $user;
}
//######################################################################################################################################
// FUNCTION CHECK_POST : Does checks for the post
// **********************************************
function check_post($post, $multi)
{
	global $vbulletin, $vbphrase;
	
	if($post == "" || !$post || $post < 1)
	{
		RunErrorAws($vbphrase['aws_func_phr4']);
	}
	
	if($postwarnedalready=$vbulletin->db->query_first("SELECT warned_post FROM " . TABLE_PREFIX . "warnings WHERE warned_post = '{$post}'") AND $multi == 0)
	{
		RunErrorAws($vbphrase['aws_func_phr5']);
	}
}
//######################################################################################################################################
function check_bans($userid)
{
	global $vbulletin,$vbphrase;

	$binfo = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "ban_dates WHERE banned_user='{$userid}'");
	while($bansinfo = $vbulletin->db->fetch_array($binfo))
	{
		if($bansinfo['banned_user'] == $userid AND $bansinfo['banned_status'] == 'A')
		{
			RunErrorAws($vbphrase['aws_no_issue_banned']);
		}
		elseif($bansinfo['banned_user'] == $userid AND $bansinfo['banned_status'] == 'P')
		{
			RunErrorAws($vbphrase['aws_no_issue_permbanned']);
		}
	}
}
//######################################################################################################################################
// FUNCTION WARN_CALCULATIONS : Calculates points and registers info
// *****************************************************************
function warn_calculations($wid, $wcomment, $wpost, $user, $bbuser, $alert)
{
	global $vbulletin, $warn_type, $force_email_temp, $force_email_perm, $level, $message_left, $vbphrase;

	$force_email_temp = '';
	$force_email_perm = '';
	
	if(!$warn_type = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "warningtype WHERE warningtypeid = '{$wid}'"))
	{
		RunErrorAws($vbphrase['aws_func_phr6']);
	}

	if ($alert == 'No' OR $alert == '')	
	{		
		if ($wcomment == '' AND $vbulletin->options['warn_autocomments'] == 1)
		{
			$wcomment = $warn_type['warn_desc'];
		}
		$wcomment = addslashes($wcomment);
		
		$warnings = $user['warns'] + 1;
		$level = $user['warning_level'] + $warn_type['warn_points'];
		$ban_condition = '';
		if($warn_type['caused_ban'] == 'Y')
		{
			RunErrorAws('hmmmz....');
		}
		if ($warnings >= $vbulletin->options['warn_warnings_before_banned'] AND $vbulletin->options['warn_warnings_before_banned'] > 0)
		{
			$ban_condition = '2';
		}
		if ($level >= $vbulletin->options['warn_points_before_banned'])
		{
			$ban_condition = '1';
		}
		
		if ($warn_type['warn_permban'] == 1 OR (!$ban_condition == '' AND !$check = $vbulletin->db->query_first("SELECT userid FROM " . TABLE_PREFIX . "userban WHERE userid = $user[userid]")))
		{
			if ($vbulletin->options['warn_incr_ban_days'] == 1)
			{
				$number_of_bans = $user['warning_bans'] + 1;
			}
			else
			{
				$number_of_bans = 1;
			}
			
			$userdm=& datamanager_init('User',$vbulletin,ERRTYPE_ARRAY);
			$userdm->set_existing($user);
			$userdm->set('usergroupid',$vbulletin->options['warn_banned_usergroup_id']);
			$userdm->set('warning_level',$level);
			$userdm->set('warns',$warnings);
			$userdm->save();
			unset($userdm);
			$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "warnings (wid, warned_user, warned_by, warned_time, warned_reason, warned_post, warned_warning_id, caused_ban, warned_status, removed_by, removed_date) VALUES('', '{$user['userid']}', '{$bbuser}', '" . time() . "', '{$wcomment}', '{$wpost}', '{$warn_type['warningtypeid']}', 'Y', 'A', '', '')");
			$warn_no = $vbulletin->db->insert_id();
			
			if (!$wpost == '')
			{	
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "post SET warn_flag = warn_flag + 1 WHERE postid = '{$wpost}'");
			}
			
			$time_unban = $vbulletin->options['warn_banned_limit'] * 86400;
			$time_unban = (time() + $time_unban * $number_of_bans);
			$time_unban = (int)$time_unban;
			//############################################################################################################
			//Usergroup bug
			// if you set $warn_type['warn_permban'] to yes you must assign the warningtype the same number of points
			//members should reach to get banned
			//#############################################################################################################
			if($warn_type['warn_permban'] == 1 OR ($vbulletin->options['warn_incr_ban_days'] == 1 AND ($vbulletin->options['warn_max_no_bans'] != 0 AND $number_of_bans >= $vbulletin->options['warn_max_no_bans'])))
			{
				$liftdate = 0;
			 	$usergroupid = $vbulletin->options['warn_troll_usergroup_id'];
			 	$title = $vbphrase['aws_func_phr7'];
			 	$force_email_perm = 'Yes';
			 	if($warn_type['warn_permban'] == 1)
			 	{
	 				$reason = $vbphrase['aws_func_phr8'];
				}
				else
				{
	 				$reason = $vbphrase['aws_func_phr9'];
				}
	 			$bstatus = "P";
			}
			else
			{
				$liftdate = $time_unban;
			 	$usergroupid = $vbulletin->options['warn_banned_usergroup_id'];
			 	$title = $vbphrase['aws_func_phr10'];
			 	$force_email_temp = 'Yes';
			 	if ($ban_condition == '2')
	 			{
	 				$reason = $vbphrase['aws_func_phr13'];
				}
	 			if ($ban_condition == '1')
	 			{
				 	$reason = $vbphrase['aws_func_phr11'];
				}
			 	$bstatus = "A";
			 }
			if ($check = $vbulletin->db->query_first("SELECT userid, liftdate FROM " . TABLE_PREFIX . "userban WHERE userid = $user[userid]"))
			{
				$vbulletin->db->query_write("
				    UPDATE " . TABLE_PREFIX . "userban SET
					adminid='$bbuser',
					usergroupid='$usergroupid',
					displaygroupid='$usergroupid',
					usertitle='$title',
					bandate = " . TIMENOW . ",
					liftdate='$liftdate',
					reason = '" . addslashes($reason) . "'
					WHERE userid = $user[userid]
				");
			}
			else
			{
				if ($vbulletin->options['warn_restore_groupid'] == 0)
				{
					$group = $user['usergroupid'];
				}
				else
				{
					$group = $vbulletin->options['warn_restore_groupid'];
				}
				$vbulletin->db->query_write("
					INSERT INTO " . TABLE_PREFIX . "userban
					(userid, usergroupid, displaygroupid, customtitle, usertitle, adminid, bandate, liftdate, reason)
					VALUES
					($user[userid], $group, $user[displaygroupid], $user[customtitle], '" . addslashes($user['usertitle']) . "', $bbuser, " . TIMENOW . ", $liftdate, '" . addslashes($reason) . "')
				");
			}
			$vbulletin->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "ban_dates
				VALUES ('', $user[userid], $number_of_bans, $warn_no, $bbuser, " . TIMENOW . ", '$bstatus', '" . addslashes($reason) . "')
			");
			$userdm=& datamanager_init('User',$vbulletin,ERRTYPE_ARRAY);
			$userdm->set_existing($user);
			$userdm->set('usergroupid',$usergroupid);
			$userdm->set('displaygroupid',$usergroupid);
			$userdm->set('warns',$warnings);
			$userdm->set('warning_bans',$number_of_bans);
			$userdm->set('usertitle',$title);
			$userdm->save();
			unset($userdm);
		} 
		else
		{
			if ($warn_type['warn_permban'] == 1 OR (!$ban_condition == '' AND $check = $vbulletin->db->query_first("SELECT userid FROM " . TABLE_PREFIX . "userban WHERE userid = $user[userid]")))
			{
				$number_of_bans = $user['warning_bans'];
			
				$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "warnings (wid, warned_user, warned_by, warned_time, warned_reason, warned_post, warned_warning_id, caused_ban, warned_status, removed_by, removed_date) VALUES('', '{$user['userid']}', '{$bbuser}', '" . time() . "', '{$wcomment}', '{$wpost}', '{$warn_type['warningtypeid']}', 'N', 'A', '', '')");
				$warn_no = $vbulletin->db->insert_id();
				
				if (!$wpost == '')
				{	
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "post SET warn_flag = warn_flag + 1 WHERE postid = '{$wpost}'");
				}
				
				$time_unban = $vbulletin->options['warn_banned_limit'] * 86400;
				$time_unban = (time() + $time_unban * $number_of_bans);
				$time_unban = (int)$time_unban;
	
				if($warn_type['warn_permban'] == 1)
				{
					$liftdate = 0;
				 	$usergroupid = $vbulletin->options['warn_troll_usergroup_id'];
				 	$title = $vbphrase['aws_func_phr7'];
				 	$force_email_perm = 'Yes';
				 	$reason = $vbphrase['aws_func_phr12'];
				 	$vbulletin->db->query_write("
						INSERT INTO " . TABLE_PREFIX . "ban_dates
						VALUES ('', $user[userid], $number_of_bans, $warn_no, $bbuser, " . TIMENOW . ", 'P', '" . addslashes($reason) . "')
					"); 
				}
				else
				{
					$liftdate = $time_unban;
				 	$usergroupid = $vbulletin->options['warn_banned_usergroup_id'];
				 	$title = $vbphrase['aws_func_phr10'];
	 				if ($ban_condition == '2')
	 				{
	 					$reason = $vbphrase['aws_func_phr13'];
					}
	 				if ($ban_condition == '1')
	 				{
					 	$reason = $vbphrase['aws_func_phr11'];
				 	}
				}
				$vbulletin->db->query_write("
				    UPDATE " . TABLE_PREFIX . "userban SET
					adminid='$bbuser',
					usergroupid='$usergroupid',
					displaygroupid='$usergroupid',
					usertitle='$title',
					bandate = " . TIMENOW . ",
					liftdate='$liftdate',
					reason = '" . addslashes($reason) . "'
					WHERE userid = $user[userid]
				");
				$userdm=& datamanager_init('User',$vbulletin,ERRTYPE_ARRAY);
			    $userdm->set_existing($user);
			    $userdm->set('usergroupid',$usergroupid);
				$userdm->set('displaygroupid',$usergroupid);
			    $userdm->set('warns',$warnings);
			    $userdm->set('warning_level',$level);
				$userdm->set('warning_bans',$number_of_bans);
				$userdm->set('usertitle',$title);
			    $userdm->save();
			    unset($userdm);
			}
			
			if ($level < $vbulletin->options['warn_points_before_banned'] AND $ban_condition == '' AND $warn_type['warn_permban'] != 1)
			{
				$userdm =& datamanager_init('User',$vbulletin,ERRTYPE_ARRAY);
				$userdm->set_existing($user);
				$userdm->set('warning_level',$level);
				$userdm->set('warns',$warnings);
				$userdm->save();
				unset($userdm);
				$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "warnings (wid, warned_user, warned_by, warned_time, warned_reason, warned_post, warned_warning_id, caused_ban, warned_status, removed_by, removed_date) VALUES('', '{$user['userid']}', '{$bbuser}', '" . time() . "', '{$wcomment}', '{$wpost}', '{$warn_type['warningtypeid']}', 'N', 'A', '', '')");
				
				if (!$wpost == '')
				{	
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "post SET warn_flag = warn_flag + 1 WHERE postid = '{$wpost}'");
				}
			}
		}
		
		if ($vbulletin->options['warn_email_on_ban'] == 1 AND ($force_email_temp != '' OR $force_email_perm != ''))
		{
			$aws_phrase = build_aws_language($user['userid']);

			$ban_kind = '';
			if ($force_email_temp == 1) # $force_email_temp == 'Yes';
			{
				$ban_kind = $aws_phrase['aws_message_temporary'];
			}
			if ($force_email_perm == 1)
			{
				$ban_kind = $aws_phrase['aws_message_permanent'];
			}
			$messageb = "";
			$name = $user['username'];
			if ($ban_kind == $aws_phrase['aws_message_temporary'])
			{
				if ($vbulletin->options['warn_incr_ban_days'] == 1)
				{
					$peruserbanlimit = ($user['warning_bans'] + 1) * $vbulletin->options['warn_banned_limit'];
				}
				else
				{
					$peruserbanlimit = $vbulletin->options['warn_banned_limit'];
				}
				$peruserbanlimit2 = ' ';
				if ($peruserbanlimit == 1)
				{
					$peruserbanlimit2 .= $aws_phrase['aws_day1'];
				}
				else
				{
					$peruserbanlimit2 .= $aws_phrase['aws_day3'];
				}
				$peruserbanlimit2 .= '.';
			}
			if ($ban_kind == $vbphrase['aws_permanent'])
			{
				$peruserbanlimit = 'ever';
				$peruserbanlimit2 = '.';
			}

			eval('$messageb .= "' . fetch_template('warn_banemail') . '";');

			$title = "{$vbulletin->options['messagetag']} - " . $aws_phrase['aws_message_banned'];
			$to = $user['username']; # $to = $user['userid'];
			if($vbulletin->options['warn_warner'] == 0)
			{
				$fromemail = $vbulletin->userinfo['email'];
				$fromname = $vbulletin->userinfo['username'];
			}
			else
			{
				$warnerdata = $vbulletin->db->query_first("SELECT username, email FROM " . TABLE_PREFIX . "user WHERE userid = '{$vbulletin->options['warn_warner']}'");
				$fromemail = $warnerdata['email'];
				$fromname = $warnerdata['username'];
			}
			vbmail($user['email'], $title, $messageb, false, $fromemail, '', $fromname);
		}
	}
	else
	{
		if ($warn_type['warn_alert'] != 1)
		{
			$message_left = $vbphrase['aws_func_phr14'] . " " . $vbphrase['aws_takingyouback'];
		}
		else
		{
			if ($wcomment == '' AND $vbulletin->options['warn_allowalertscomment'] == 1 AND $warn_type['warn_alertcomment'] != '')
			{
				$wcomment = $warn_type['warn_alertcomment'];
				$wcomment = addslashes($wcomment);
				$acomment = $vbphrase['aws_standartslertcomm'];
			}
			else
			{
				$wcomment = addslashes($wcomment);
				$acomment = $wcomment;
			}
			$alerts = $user['alerts'] + 1;
			$userdm=& datamanager_init('User',$vbulletin,ERRTYPE_ARRAY);
			$userdm->set_existing($user);
			$userdm->set('alerts',$alerts);
			$userdm->save();
			unset($userdm);
			$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "warnings (wid, warned_user, warned_by, warned_time, warned_reason, warned_post, warned_warning_id, caused_ban, warned_status, removed_by, removed_date) VALUES('', '{$user['userid']}', '{$bbuser}', '" . time() . "', '{$acomment}', '{$wpost}', '{$warn_type['warningtypeid']}', 'N', 'L', '', '')");
		}
	}
	return $warn_type;
	return $level;
	return $message_left;
	return $wmessage;
}
//######################################################################################################################################
// FUNCTION WARN_NOTIFY : Notifies a user when warned
// **************************************************
function warn_notify($thread1, $thread2, $thread3, $user, $bbuseremail, $bbusername, $bbuserid, $warn_type, $level, $wcomment, $alert)
{
	global $message_left, $warn_type, $vbulletin, $vbphrase;
	
	if ($vbulletin->options['warn_incr_ban_days'] == 1)
	{
		$peruserbanlimit = ($user['warning_bans'] + 1) * $vbulletin->options['warn_banned_limit'];
	}
	else
	{
		$peruserbanlimit = $vbulletin->options['warn_banned_limit'];
	}
	$user = array_merge($user , convert_bits_to_array($user['options'] , $vbulletin->bf_misc_useroptions));
	$perms = fetch_permissions(0, $user['userid'], $user);
	if($user['options'] & $vbulletin->bf_misc_useroptions['receivepm'])
	{
		$donotpmhim=0;
	}
	else
	{
		$donotpmhim=1;
	}
	if (($vbulletin->options['warn_send_pm_warning'] == 1 AND $vbulletin->options['warn_pmcutoff'] == 0) OR ($vbulletin->options['warn_send_pm_warning'] == 1 AND $vbulletin->options['warn_pmcutoff'] != 0 AND $level < $vbulletin->options['warn_pmcutoff'] AND $donotpmhim==0))
	{
		$messageb = "";
		$name = $user['username'];
		if ($wcomment == '' AND $vbulletin->options['warn_autocomments'] == 1)
		{
			$wcomment = $warn_type['warn_desc'];
		}
		
		if ($wcomment == '' AND $vbulletin->options['warn_allowalertscomment'] == 1 AND $alert ==1)
		{
			$wcomment = $warn_type['warn_alertcomment'];
		}

		$aws_phrase = build_aws_language($user['userid']);

		if ($alert == 'No' OR $alert == '')
		{
			eval('$messageb .= "' . fetch_template('warn_pm') . '";');
			$title = $aws_phrase['aws_message_title_warned'];
		}
		else
		{
			eval('$messageb .= "' . fetch_template('warn_pm_alert') . '";');
			$title = $aws_phrase['aws_message_title_alerted'];
		}
		$messagecopy = $messageb;
		$recipients = $user['username'];
		if($vbulletin->options['warn_warner'] == 0 OR $warn_type['warn_type'] == 2)
		{
			$fromuserid = $bbuserid;
			$fromusername= $bbusername;
		}
		else
		{
			$fromuserid = $vbulletin->options['warn_warner'];
			$fromusername = $bbusername;
		}
		
		SendPMAws($fromuserid,$fromusername,$title,$messageb,$recipients); # $fromuserid, $fromusername, $title, $message, $recipients
		if ($alert == 'No' OR $alert == '')
		{
			$message_left = "{$user['username']} " . $vbphrase['aws_func_phr16'] . " " . $vbphrase['aws_tackingtopost'];
		}
		else
		{
			$message_left = "{$user['username']} " . $vbphrase['aws_func_phr17'] . " " . $vbphrase['aws_tackingtopost'];
		}
		
	}

	if($vbulletin->options['warn_send_em_warning'] == 1 OR ($level >= $vbulletin->options['warn_pmcutoff'] AND $vbulletin->options['warn_pmcutoff'] > 0 AND $donotpmhim==1))
	{
		$messageb = "";
		$name = $user['username'];
		$aws_phrase = build_aws_language($user['userid']);
		if ($alert == 'No' OR $alert == '')
		{
			eval('$messageb .= "' . fetch_template('warn_em') . '";');
			eval('$messagecopy = "' . fetch_template('warn_pm') . '";');
			
			$title = "{$vbulletin->options['messagetag']} - " . $aws_phrase['aws_message_title_warned'];
		}
		else
		{
			eval('$messageb .= "' . fetch_template('warn_em_alert') . '";');
			eval('$messagecopy = "' . fetch_template('warn_pm_alert') . '";');
			
			$title = "{$vbulletin->options['messagetag']} - " . $aws_phrase['aws_message_title_alerted'];
		}
		$to = $user['username']; #to = $user['userid'];
		
		if ($level >= $vbulletin->options['warn_pmcutoff'] AND $vbulletin->options['warn_pmcutoff'] != 0)
		{
			$messageb .= '

' . $vbphrase['aws_func_phr18'] . '
			
			';
			$messagecopy .= '

' . $vbphrase['aws_func_phr18'] . '
			
			';
		}
		if($vbulletin->options['warn_warner'] == 0)
		{
			$fromemail = $bbuseremail;
			$fromname = $bbusername;
		}
		else
		{
			$warnerdata = $vbulletin->db->query_first("SELECT username, email FROM " . TABLE_PREFIX . "user WHERE userid = '{$vbulletin->options['warn_warner']}'");
			$fromemail = $warnerdata['email'];
			$fromname = $warnerdata['username'];
		}
		vbmail($user['email'], $title, $messageb, false, $fromemail, '', $fromname);
		if ($alert == 'No' OR $alert == '')
		{
			$message_left = "{$user['username']} " . $vbphrase['aws_func_phr19'] . " " . $vbphrase['aws_tackingtopost'];
		}
		else
		{
			$message_left = "{$user['username']} " . $vbphrase['aws_func_phr20'] . " " . $vbphrase['aws_tackingtopost'];

		}
	}
	
	if ((($vbulletin->options['warn_savecopy'] == '1' AND ($alert == 'No' OR $alert == '')) OR ($vbulletin->options['warn_savecopyalert'] == '1' AND $alert == 'Yes')) AND $vbulletin->options['warn_savecopyforum'] != '')
	{
		require_once('./includes/functions_databuild.php');
		
		$destforum = verify_id('forum', intval($vbulletin->options['warn_savecopyforum']));
		$newforuminfo = fetch_foruminfo($destforum);
		if (!$newforuminfo['cancontainthreads'] OR $newforuminfo['link'])
		{
			eval(standard_error(fetch_error('aws_error_moveillegalforum')));
		}
		
		$timenow = TIMENOW;
		$t = vbdate($vbulletin->options['timeformat'], $timenow);
		$d = vbdate($vbulletin->options['dateformat'], $timenow);

		if ($alert == 'Yes')
		{
			$newnotes = sprintf($vbphrase['aws_alert'] . ': ' . $vbphrase['aws_user'] . ': %2$s - ' . $vbphrase['aws_warner'] . ': %1$s - ' . $vbphrase['aws_date'] . ': %3$s ' . $vbphrase['aws_at'] . ' %4$s', $bbusername, $name, $d, $t);
		}
		else
		{
			$newnotes = sprintf($vbphrase['aws_warning'] . ': ' . $vbphrase['aws_user'] . ': %2$s - ' . $vbphrase['aws_warner'] . ': %1$s - ' . $vbphrase['aws_date'] . ': %3$s ' . $vbphrase['aws_at'] . ' %4$s', $bbusername, $name, $d, $t);
		}
		$messagecopy = str_replace("Warn.php?do=ViewMyWarnings", "Warn.php?do=ViewWarnings&id=$user[userid]", $messagecopy);
		$threaddm =& datamanager_init('Thread_FirstPost',$vbulletin,ERRTYPE_ARRAY,'threadpost');
		$threaddm->setr('forumid',$destforum);
		$threaddm->setr('title',$newnotes);
		$threaddm->setr('pagetext',$messagecopy);
		$threaddm->strip_empty_bbcode($messagecopy);
		$threaddm->set('userid',$bbuserid);
		$threaddm->set('open',1);
		$threaddm->set('visible',1);
		$threaddm->set('allowsmilie',1);
		$threaddm->set_info('forum',$newforuminfo);
		$threaddm->set_info('thread',array());
		$threaddm->pre_save();
		if(!empty($threaddm->errors))
		{
			print_r($threaddm->errors);
			exit;
		}
		else
		{
			$newthreadid = $threaddm->save();
		}
		build_thread_counters($newthreadid);
		build_forum_counters($destforum);
	}
	return $message_left;
}
//######################################################################################################################################
// ###################### Underline censored words #######################
// function to underline censored words in original message
//########################################################################
function underline_censored_text($text)
{
	global $vbphrase, $vbulletin;
	static $censorwords;

	if ($vbulletin->options['enablecensor'] AND !empty($vbulletin->options['censorwords']))
	{
		if (empty($censorwords))
		{
			$vbulletin->options['censorwords'] = preg_quote($vbulletin->options['censorwords'], '#');
			$censorwords = preg_split('#\s+#', $vbulletin->options['censorwords'], -1, PREG_SPLIT_NO_EMPTY);
		}

		foreach ($censorwords AS $censorword)
		{
			$censorword = str_replace('\+', ' ', $censorword);
			$censorword = str_replace('\\\{', '', $censorword);
			$censorword = str_replace('\\\}', '', $censorword);
			$censorword = str_replace('\\', '', $censorword);
			$ucensorword = "<b>" . $censorword . "</b>";
			$text = preg_replace('#(?<=[^a-z]|^)(' . $censorword . ')(?=[^a-z]|$)#si', "<i><u>$censorword</u></i>", $text);
		}
	}
	$text = strip_blank_ascii($text, $vbulletin->options['censorchar']);

	return $text;
}
//#######################################################################################################################################
function fetch_touserstring($pm)
{
	global $vbulletin;
	$cclist = array();
	$bcclist = array();
	$ccrecipients = '';
	$touser = unserialize($pm['touserarray']);
	foreach($touser AS $key => $item)
	{
		if (is_array($item))
		{
			foreach($item AS $subkey => $subitem)
			{
				$username = $subitem;
				$userid = $subkey;
				if ($key == 'bcc')
				{
					$bcclist[] = $username;
				}
				else
				{
					$cclist[] = $username;
				}
			}
		}
		else
		{
			$username = $item;
			$userid = $key;
			$cclist[] = $username;
		}
	}
	if (!empty($cclist))
	{
		$ccrecipients = implode(', ', $cclist);
	}
	if ($pm['folder'] == -1)
	{
		if (!empty($bcclist))
		{
			$ccrecipients = implode(', ', array_unique(array_merge($cclist, $bcclist)));
		}
	}
	else
	{
		$ccrecipients = implode(', ', array_unique(array_merge($cclist, array("{$vbulletin->userinfo['username']}"))));
	}
	return $ccrecipients;
}
//#######################################################################################################################################
/*======================================================================*\
|| #################################################################### ||
|| # vB3 Advanced Warning System (AWS) By John Caradimas SV1CEC         ||
|| AWS Version 3.4.12
|| vBulletin 3.5.x 3.6.x support Delphiprogrammi
|| #################################################################### ||
\*======================================================================*/
?>