<?php
/*======================================================================*\
|| #################################################################### ||
|| # vB3 Advanced Warning System (AWS) By John Caradimas SV1CEC         ||
|| AWS Version 3.4.12
|| vBulletin 3.5.x 3.6.x support Delphiprogrammi
|| #################################################################### ||
\*======================================================================*/

// ######################### ERROR REPORTING #############################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS',1);
define('GET_EDIT_TEMPLATES',true);
define('THIS_SCRIPT','admin_warn');

$phrasegroups = array('banning', 'cpuser');

require_once('./global.php');
require_once('./includes/functions_misc.php');
require_once('./includes/functions_warning.php');

$admincpdir = $vbulletin->config['Misc']['admincpdir'];

function ParseInputs($val)
{
	if(is_int($val))
	{
		return $val;
	}
	else
	{
		$val = str_replace( "&", "&amp;", $val);
		$val = str_replace( "<!--", "&#60;&#33;--", $val);
		$val = str_replace( "-->", "--&#62;", $val);
		$val = str_replace( ">", "&gt;", $val);
		$val = str_replace( "<", "&lt;", $val);
		$val = str_replace( "\"", "&quot;", $val);
		$val = preg_replace( "/\n/", "<br>", $val);
		$val = preg_replace( "/\\\$/", "&#036;", $val);
		$val = preg_replace( "/\r/", "", $val);
		$val = str_replace( "!", "&#33;", $val);
		$val = str_replace( "'", "&#39;", $val);
		$val = stripslashes($val);
		$val = preg_replace( "/\\\(?!&amp;#|\?#)/", "&#092;", $val);
		return $val;
	}
}
//#####################################################################################################################################
function SendPmAwsAdmincp($fromuserid, $fromusername, $title, $message, $recipients)
{
	global $vbulletin, $botpermissions;
	$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_SILENT);
	$pmdm->set('fromuserid', $fromuserid);
	$pmdm->set('fromusername', $fromusername);
	$pmdm->set('title', $title);
	$pmdm->set('message', $message);
	$pmdm->set_recipients($recipients, $botpermissions);
	$pmdm->set('dateline', TIMENOW);
	$pmdm->set('showsignature',1);
	$pmdm->set('allowsmilie',1);
    $pmdm->save();
}
//#####################################################################################################################################
$AWS_VERSION = $vbulletin->options['warn_version'];

if($_GET['do'] == "manageoptions")
{
	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
	//#########################################################################
	// Warning Options
	//#########################################################################
	print_form_header('admin_warn', 'do_update_warnopt');
	print_table_header($vbphrase['aws_options_o1']);
	print_table_header($vbphrase['aws_options_o2']);
	print_yes_no_row($vbphrase['aws_options_o3'],'hierarchical',$vbulletin->options['warn_hierarchical']);
	print_yes_no_row($vbphrase['aws_options_o4'],'historical',$vbulletin->options['warn_historical']);
	print_yes_no_row($vbphrase['aws_options_o5'],'allowoffpost',$vbulletin->options['warn_allowoffpost']);
	print_yes_no_row($vbphrase['aws_options_o6'],'multiple_per_post',$vbulletin->options['warn_multiple_per_post']);
	print_yes_no_row($vbphrase['aws_options_o7'],'allowalerts',$vbulletin->options['warn_allowalerts']);
	print_yes_no_row($vbphrase['aws_options_o8'],'allowalertscomment',$vbulletin->options['warn_allowalertscomment']);
	print_input_row($vbphrase['aws_options_o9'],'alertslifetime', $vbulletin->options['warn_alertslifetime']);
	print_yes_no_row($vbphrase['aws_options_o52'],'allownotes',$vbulletin->options['warn_allownotes']);
	print_input_row($vbphrase['aws_options_o56'],'min_comment_length', $vbulletin->options['warn_min_comment_length']);
	//#####################################################################################################################
	// Automation Options
	//#####################################################################################################################
	print_table_header($vbphrase['aws_options_o10']);
	print_yes_no_row($vbphrase['aws_options_o11'],'automatic',$vbulletin->options['warn_automatic']);
	print_yes_no_row($vbphrase['aws_options_o12'],'automaticpm',$vbulletin->options['warn_automaticpm']);	
	print_yes_no_row($vbphrase['aws_options_o13'],'autocomments',$vbulletin->options['warn_autocomments']);	
	//#######################################################################################################################
	// Viewing options
	//#######################################################################################################################

	print_table_header($vbphrase['aws_options_o14']);
	print_select_row($vbphrase['aws_options_o15'],'viewoption',array(0 => 'Mgm',1 => 'All'),$vbulletin->options['warn_viewoption']);
	print_select_row($vbphrase['aws_options_o16'],'modoption',array(0 => 'Own',1 => 'All'),$vbulletin->options['warn_modoption']);
	//#################################################################################################################################
	//Warners 
	//#################################################################################################################################
	print_table_header($vbphrase['aws_options_o17']);
	print_input_row($vbphrase['aws_options_o18'], 'automatic_warner', $vbulletin->options['warn_automatic_warner']);
	print_input_row($vbphrase['aws_options_o19'], 'warner', $vbulletin->options['warn_warner']);
	print_input_row($vbphrase['aws_options_o20'], 'collector', $vbulletin->options['warn_collector']);
	print_input_row($vbphrase['aws_options_username'],'username',$vbulletin->options['warn_username']);
	print_yes_no_row($vbphrase['aws_mailfrom_option'],'mailfrom',$vbulletin->options['warn_mailfrom']);
	print_input_row($vbphrase['aws_mailfrom_address'],'mailfromaddress',$vbulletin->options['warn_mailfromaddress']);
	//#################################################################################################################################
	// Banning options
	//#################################################################################################################################
	print_table_header($vbphrase['aws_options_o21']);
	print_input_row($vbphrase['aws_options_o22'], 'banned_limit', $vbulletin->options['warn_banned_limit']);
	print_input_row($vbphrase['aws_options_o23'], 'points_before_banned', $vbulletin->options['warn_points_before_banned']);
	print_input_row($vbphrase['aws_options_o24'], 'warnings_before_banned', $vbulletin->options['warn_warnings_before_banned']);
	print_yes_no_row($vbphrase['aws_options_o25'], 'incr_ban_days',$vbulletin->options['warn_incr_ban_days']);
	print_input_row($vbphrase['aws_options_o26'], 'max_no_bans', $vbulletin->options['warn_max_no_bans']);
	print_input_row($vbphrase['aws_options_o27'], 'bans_mature', $vbulletin->options['warn_bans_mature']);
	//#################################################################################################################################
	// Usergroup options
	//#################################################################################################################################
	print_table_header($vbphrase['aws_options_o28']);
	print_input_row($vbphrase['aws_options_o29'], 'admingroups', $vbulletin->options['warn_admingroups']);
	print_input_row($vbphrase['aws_options_o30'], 'smodgroups', $vbulletin->options['warn_smodgroups']);
	print_input_row($vbphrase['aws_options_o31'], 'modgroups', $vbulletin->options['warn_modgroups']);
	print_input_row($vbphrase['aws_options_o32'], 'aprotected_usergroups',$vbulletin->options['warn_aprotected_usergroups']);
    print_chooser_row($vbphrase['aws_options_o33'],'banned_usergroup_id','usergroup',$vbulletin->options['warn_banned_usergroup_id']);
	print_chooser_row($vbphrase['aws_options_o34'],'troll_usergroup_id','usergroup',$vbulletin->options['warn_troll_usergroup_id']);
	print_chooser_row($vbphrase['aws_options_o35'],'restore_groupid','usergroup',$vbulletin->options['warn_restore_groupid']);
	//#################################################################################################################################
	// Additional restrictions
	print_table_header($vbphrase['aws_options_o36']);
	print_input_row($vbphrase['aws_options_o37'], 'sig_thresshold', $vbulletin->options['warn_sig_thresshold']);
	print_input_row($vbphrase['aws_options_o38'], 'avatar_thresshold', $vbulletin->options['warn_avatar_thresshold']);
	print_input_row($vbphrase['aws_options_o39'], 'pmcutoff', $vbulletin->options['warn_pmcutoff']);
	print_input_row($vbphrase['aws_options_o53'], 'sigpic_thresshold', $vbulletin->options['warn_sigpic_thresshold']);
	print_input_row($vbphrase['aws_options_o55'], 'pic_thresshold', $vbulletin->options['warn_pic_thresshold']);
	//#################################################################################################################################
	// Member notification options
	//#################################################################################################################################
	print_table_header($vbphrase['aws_options_o40']);	
	print_yes_no_row($vbphrase['aws_options_o41'], 'send_pm_warning',$vbulletin->options['warn_send_pm_warning']);
	print_yes_no_row($vbphrase['aws_options_o42'], 'send_em_warning',$vbulletin->options['warn_send_em_warning']);
	print_yes_no_row($vbphrase['aws_options_o43'], 'email_on_ban',$vbulletin->options['warn_email_on_ban']);
	print_yes_no_row($vbphrase['aws_options_o44'], 'includepost',$vbulletin->options['warn_includepost']);
	print_yes_no_row($vbphrase['aws_options_o45'], 'savecopy',$vbulletin->options['warn_savecopy']);
	print_yes_no_row($vbphrase['aws_options_o46'], 'savecopyalert',$vbulletin->options['warn_savecopyalert']);
	print_forum_chooser($vbphrase['aws_options_o47'],'savecopyforum',$vbulletin->options['warn_savecopyforum'],'',false,'');
	//#################################################################################################################################
	// Formatting options
	//#################################################################################################################################
	print_table_header($vbphrase['aws_options_o48']);	
	print_select_row($vbphrase['aws_options_o49'],'textbutoption',array(0 => 'Buttons',1 => 'Text'),$vbulletin->options['warn_textbutoption']);
	print_input_row($vbphrase['aws_options_o50'], 'warnings_per_page', $vbulletin->options['warn_warnings_per_page']);
	print_submit_row($vbphrase['aws_options_o51'], 0);

	exit;
}
//#####################################################################################################################################
if($_GET['do'] == "view")
{
	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
	print_form_header('admin_warn', '');
	if ($vbulletin->options['warn_allowalerts'] == 1)
	{
		print_table_header($vbphrase['aws_admin_curwarnstypes'], 9);
		print_cells_row(array(
		"<b>" . $vbphrase['aws_admin_warnname'] . "</b>",
		"<b>" . $vbphrase['aws_admin_description'] . "</b>",
		"<b>" . $vbphrase['aws_admin_warnpoints'] . "</b>",
		"<b>" . $vbphrase['aws_warnmaturity'] . "</b>",
		"<b>" . $vbphrase['aws_permanentban'] . "</b>",
		"<b>" . $vbphrase['aws_postrelated'] . "</b>",
		"<b>" . $vbphrase['aws_admin_allowalerts'] . "</b>",
		"<b>" . $vbphrase['aws_admin_edit'] . "</b>",
		"<b>" . $vbphrase['aws_admin_delete'] . "</b>",), 'thead', '', '', 1);
	}
	else
	{
		print_table_header($vbphrase['aws_admin_curwarnstypes'],8);
		print_cells_row(array(
		"<b>" . $vbphrase['aws_admin_warnname'] . "</b>",
		"<b>" . $vbphrase['aws_admin_description'] . "</b>",
		"<b>" . $vbphrase['aws_admin_warnpoints'] . "</b>",
		"<b>" . $vbphrase['aws_warnmaturity'] . "</b>",
		"<b>" . $vbphrase['aws_permanentban'] . "</b>",
		"<b>" . $vbphrase['aws_postrelated'] . "</b>",
		"<b>" . $vbphrase['aws_admin_edit'] . "</b>",
		"<b>" . $vbphrase['aws_admin_delete'] . "</b>",), 'thead', '', '', 1);
	}
	$get_warns = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "warningtype ORDER BY warn_points, warn_maturity,title");
	while($warning = $db->fetch_array($get_warns))
	{
		if($warning['warn_permban'] == 0)
		{
			$warning['warn_permban'] = $vbphrase['aws_no'];
		}
		else
		{
			$warning['warn_permban'] = $vbphrase['aws_yes'];
		}
		if($warning['warn_type'] == 1)
		{
			$warning['warn_type'] = $vbphrase['aws_no'];
		}
		else
		{
			if ($warning['warn_type'] ==0)
			{
				$warning['warn_type'] = $vbphrase['aws_yes'];
			}
			else
			{
				$warning['warn_type'] = $vbphrase['aws_auto'];
			}
		}
		
		if ($vbulletin->options['warn_allowalerts'] == 1)
		{
			if($warning['warn_alert'] == 0)
			{
				$warning['warn_alert'] = $vbphrase['aws_no'];
			}
			else
			{
				$warning['warn_alert'] = $vbphrase['aws_yes'];
			}
			
			print_cells_row(array(
			"<b>{$warning['title']}</b>",
			"{$warning['warn_desc']}",
			"{$warning['warn_points']}",
			"{$warning['warn_maturity']}",
			"{$warning['warn_permban']}",
			"{$warning['warn_type']}",
			"{$warning['warn_alert']}",		
			"<a href='?do=edit&warningtypeid={$warning['warningtypeid']}'>" . $vbphrase['aws_admin_edit'] . "</a>",
			"<a href='?do=delete&warningtypeid={$warning['warningtypeid']}'>" . $vbphrase['aws_admin_delete'] . "</a>"),
			 '','','',1);
		}
		else
		{
			print_cells_row(array(
			"<b>{$warning['title']}</b>",
			"{$warning['warn_desc']}",
			"{$warning['warn_points']}",
			"{$warning['warn_maturity']}",
			"{$warning['warn_permban']}",
			"{$warning['warn_type']}",
			"<a href='?do=edit&warningtypeid={$warning['warningtypeid']}'>" . $vbphrase['aws_admin_edit'] . "</a>",
			"<a href='?do=delete&warningtypeid={$warning['warningtypeid']}'>" . $vbphrase['aws_admin_delete'] . "</a>"),
			 '','','',1);
		}
	}
	print_form_header('admin_warn', 'do_add_warn');
	echo "<br />";
	print_table_header($vbphrase['aws_admin_addnewwarntype']);
	print_input_row($vbphrase['aws_admin_name'], 'title', '');
	print_input_row($vbphrase['aws_admin_description'], 'warn_desc', '');
	print_input_row($vbphrase['aws_admin_warningpointsgivien'], 'warn_points', '');
	print_input_row($vbphrase['aws_admin_warningmaturity'], 'warn_maturity', '');
	print_yes_no_row($vbphrase['aws_admin_permanentban'],'warn_permban','');
	print_select_row($vbphrase['aws_admin_postrelatedwarning'],'warn_type',array(0 => $vbphrase['aws_yes'] , 1 => $vbphrase['aws_no'] , 2 => $vbphrase['aws_auto']),'');
	
	if ($vbulletin->options['warn_allowalerts'] == 1)
	{
		print_yes_no_row($vbphrase['aws_admin_canwarntypehaveal'],'warn_alert','');
	}
	if ($vbulletin->options['warn_allowalertscomment'] == 1)
	{
		print_textarea_row($vbphrase['aws_admin_entercommentforalert'], 'warn_alertcomment','');
	}
	print_submit_row($vbphrase['aws_admin_addnewwarntype'], 0);
	print_cp_footer();
	exit;
}
//#####################################################################################################################################
if($_POST['do'] == "do_add_warn")
{
	$vbulletin->input->clean_array_gpc('p',array(
		'title'              => TYPE_STR,
		'warn_desc'          => TYPE_STR,
		'warn_points'        => TYPE_INT,
		'warn_maturity'      => TYPE_INT,
		'warn_permban'       => TYPE_BOOL,
		'warn_type'          => TYPE_INT,
		'warn_alert'         => TYPE_BOOL,
		'warn_alertcomment'  => TYPE_STR,
	));
	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
	
	$vbulletin->GPC['title'] = ParseInputs($vbulletin->GPC['title']);
	$vbulletin->GPC['warn_desc'] = ParseInputs($vbulletin->GPC['warn_desc']);
	
	if ($vbulletin->options['warn_allowoffpost'] == 0 AND $vbulletin->GPC['warn_type'] == 1)
	{
		define('CP_REDIRECT', 'admin_warn.php?do=view');
		print_stop_message('aws_warning_warn_typeconflict');
	}
	
	if(empty($vbulletin->GPC['title']) OR trim($vbulletin->GPC['title']) == '')
	{
		print_stop_message('aws_warning_warn_emptywarntype');
	}
	if(empty($vbulletin->GPC['warn_desc']) OR trim($vbulletin->GPC['warn_desc']) == '')
	{
		 print_stop_message('aws_warning_warn_emptydesc');
	}
	if(empty($vbulletin->GPC['warn_points']) OR $vbulletin->GPC['warn_points'] == '' OR $vbulletin->GPC['warn_points'] < 1 OR $vbulletin->GPC['warn_points'] > 99999)
	{
		 print_stop_message('aws_warning_warn_emptypoints');
	}
	if(empty($vbulletin->GPC['warn_maturity']) OR $vbulletin->GPC['warn_maturity'] == '' OR $vbulletin->GPC['warn_maturity'] < 1 OR $vbulletin->GPC['warn_maturity'] > 99999)
	{
		 print_stop_message('aws_warning_warn_maturity');
	}
	if($vbulletin->GPC['warn_alert'] == '')
	{
		$vbulletin->GPC['warn_alert'] = 0;
	}
	$warn_alertcomment = addslashes($vbulletin->GPC['warn_alertcomment']);
	//##############
	//new 
	//#############
	if($vbulletin->GPC['warn_permban'] == 1 AND $vbulletin->GPC['warn_points'] != $vbulletin->options['warn_points_before_banned'])
	{
		print_stop_message('aws_warning_warn_invalid_permban');
	}
	$db->query_write("INSERT INTO " . TABLE_PREFIX . "warningtype VALUES(
	'',
	'{$vbulletin->GPC['title']}',
	'{$vbulletin->GPC['warn_points']}',
	'{$vbulletin->GPC['warn_desc']}',
	'{$vbulletin->GPC['warn_maturity']}',
	'{$vbulletin->GPC['warn_permban']}',
	'{$vbulletin->GPC['warn_type']}',
	'{$vbulletin->GPC['warn_alert']}',
	'{$warn_alertcomment}'
	)");
	define('CP_REDIRECT', 'admin_warn.php?do=view');
	print_stop_message('aws_warning_warn_added');
}
//#####################################################################################################################################
if($_GET['do'] == "edit")
{
	$vbulletin->input->clean_gpc('g','warningtypeid',TYPE_INT);
	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
	
	if(!$warn = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "warningtype WHERE warningtypeid = '{$vbulletin->GPC['warningtypeid']}'"))
	{
		echo $vbphrase['aws_admin_unablefindwarntype'] . " [ <a href='javascript:history.go(-1);'>" . $vbphrase['aws_admin_goback'] . "</a> ]";
		exit;
	}
	print_form_header('admin_warn', 'do_edit_warn');
	construct_hidden_code('warningtypeid', $warn['warningtypeid']);
	print_table_header($vbphrase['aws_admin_updatewarntype']);
	print_input_row($vbphrase['aws_admin_name'], 'title', $warn['title']);
	print_input_row($vbphrase['aws_admin_description'], 'warn_desc', $warn['warn_desc']);
	print_input_row($vbphrase['aws_admin_warningpointsgivien'], 'warn_points', $warn['warn_points']);
	print_input_row($vbphrase['aws_admin_warningmaturity'], 'warn_maturity', $warn['warn_maturity']);
	print_yes_no_row($vbphrase['aws_admin_permanentban'],'warn_permban',$warn['warn_permban']);
	print_select_row($vbphrase['aws_admin_postrelatedwarning'],'warn_type',array(0 => $vbphrase['aws_yes'] , 1 => $vbphrase['aws_no'] , 2 => $vbphrase['aws_auto']),$warn['warn_type']);
	if ($vbulletin->options['warn_allowalerts'] == 1)
	{
		print_yes_no_row($vbphrase['aws_admin_canwarntypehaveal'], 'warn_alert',$warn['warn_alert']);
	
		if ($vbulletin->options['warn_allowalertscomment'] == 1)
		{
			print_textarea_row($vbphrase['aws_admin_entercommentforalert'], 'warn_alertcomment', $warn['warn_alertcomment']);
		}
	}
	print_submit_row($vbphrase['aws_admin_update'], 0);
	print_cp_footer();
	exit;
}
//#####################################################################################################################################
if($_GET['do'] == "viewlogs")
{
	global $vbulletin;
	
	$vbulletin->input->clean_array_gpc('r',array(
		'wid' => TYPE_INT,
		'perpage' => TYPE_INT,
		'page' => TYPE_INT,
		'orderby' => TYPE_STR,
		'order' => TYPE_STR,
		'script' => TYPE_STR,
	));
	global $vbulletin;
	$admincpdir=$vbulletin->config['Misc']['admincpdir'];
	$script = $vbulletin->GPC['script'];
	$s1t='w.warned_user ASC';
	$s2t='w.warned_user DESC';
	$s3t='u.username ASC';
	$s4t='u.username DESC';
	$s5t='w.warned_post ASC';
	$s6t='w.warned_post DESC';
	$s7t='wt.title ASC';
	$s8t='wt.title DESC';
	$s9t='wt.warn_points ASC';
	$s10t='wt.warn_points DESC';
	$s11t='w.warned_time ASC';
	$s12t='w.warned_time DESC';
	$s13t='maturitydate ASC ';
	$s14t='maturitydate DESC';
	$s15t='w.removed_date ASC';
	$s16t='w.removed_date DESC';
	$perpage=$vbulletin->options['warn_warnings_per_page'];
	if ($perpage=='' OR $perpage==0)
	{
		$perpage=15;
	}
	$page=$vbulletin->GPC['page'];
	if ($page < 1)
	{
		$page = 1;
	}
	$startat = ($page - 1) * $perpage;
	$counter=$db->query_first("SELECT COUNT(*) AS warnings FROM " . TABLE_PREFIX . "warnings AS warning");
	$totalpages = ceil($counter['warnings'] / $perpage);
	if ($orderby=='')
	{
		if ($orderby == '')
		{	
			$orderby=$s12t;
		}
		else
		{
			$orderby=$vbulletin->GPC['order'];
		}
	}
	switch($orderby)
	{
		case $s1t:
		   $orderbycom='Warned User ID, Ascending';
		   $order=$s1t;
		   break;
		case $s2t:
		   $orderbycom='Warned User ID, Descending';
		   $order=$s2t;
		   break;
		case $s3t:
		   $orderbycom='Warner Name, Ascending';
		   $order=$s3t;
		   break;
		case $s4t:
		   $orderbycom='Warner Name, Descending';
		   $order=$s4t;
		   break;
		case $s5t:
		   $orderbycom='Warned Post, Ascending';
		   $order=$s5t;
		   break;
		case $s6t:
		   $orderbycom='Warned Post, Descending';
		   $order=$s6t;
		   break;
		case $s7t:
		   $orderbycom='Warning Type, Ascending';
		   $order=$s7t;
		   break;
		case $s8t:
		   $orderbycom='Warning Type, Descending';
		   $order=$s8t;
		   break;
		case $s9t:
		   $orderbycom='Warned Points, Ascending';
		   $order=$s9t;
		   break;
		case $s10t:
		   $orderbycom='Warned Points, Descending';
		   $order=$s10t;
		   break;
		case $s11t:
		   $orderbycom='Warned Date, Ascending';
		   $order=$s11t;
		   break;
		case $s12t:
		   $orderbycom='Warned Date, Desccending';
		   $order=$s12t;
		   break;
		case $s13t:
		   $orderbycom='Maturity Date, Ascending';
		   $order=$s13t;
		   break;
		case $s14t:
		   $orderbycom='Maturity Date, Descending';
		   $order=$s14t;
		   break;
		case $s15t:
		   $orderbycom='Removal Date, Ascending';
		   $order=$s15t;
		   break;
		case $s16t:
		   $orderbycom='Removal Date, Descending';
		   $order=$s16t;
		   break;
	}
	$get_warns=$db->query_read("SELECT w.*,u.username AS wusername,u.userid AS wuserid,wt.*,wuser.username AS warned_username_v,wuser.userid AS warned_userid_v, ruser.username AS removed_by_v, (w.warned_time+wt.warn_maturity*24*60*60) AS maturitydate FROM
	".TABLE_PREFIX."warnings w
	LEFT JOIN ".TABLE_PREFIX."user wuser ON(wuser.userid=w.warned_user)
	LEFT JOIN ".TABLE_PREFIX."user u ON(u.userid=w.warned_by)
	LEFT JOIN ".TABLE_PREFIX."user ruser ON(ruser.userid=w.removed_by)
	LEFT JOIN ".TABLE_PREFIX."warningtype wt ON(wt.warningtypeid=w.warned_warning_id) ORDER BY $orderby LIMIT $startat, $perpage");
	if($db->num_rows($get_warns))
	{
		if ($vbulletin->GPC['page'] != 1)
		{
			$prv = $page - 1;
			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['aws_first_page'] .
							"\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?" . $vbulletin->session->vars['sessionurl'] .
							"do=viewlogs&script=" . $vbulletin->GPC['script'] .
							"&perpage=" . $vbulletin->GPC['perpage'] .
							"&orderby=" . $vbulletin->GPC['orderby'] .
							"&page=1'\">";
			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['aws_prev_page'] .
						"\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?" . $vbulletin->session->vars['sessionurl'] .
						"do=viewlogs&script=" . $vbulletin->GPC['script'] . 
						"&perpage=" . $vbulletin->GPC['perpage'] .
						"&orderby=" . $vbulletin->GPC['orderby'] .
						"&page=$prv'\">";
		}
		if ($vbulletin->GPC['page'] != $totalpages)
		{
			$nxt = $page + 1;
			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_next_page'] .
						" &gt;\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?" .
						$vbulletin->session->vars['sessionurl'] .
						"do=viewlogs&script=" . $vbulletin->GPC['script'] .
						"&perpage=" . $vbulletin->GPC['perpage'] .
						"&orderby=" . $vbulletin->GPC['orderby'] .
						"&page=$nxt'\">";
			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_last_page'] .
						" &raquo;\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?" . $vbulletin->session->vars['sessionurl'] .
						"do=viewlogs&script=" . $vbulletin->GPC['script'] .
						"&perpage=" . $vbulletin->GPC['perpage'] .
						"&orderby=" . $vbulletin->GPC['orderby'] .
						"&page=$totalpages'\">";
			
			
		}
		$delbutton = "<input type='hidden' name=\"order\" value=\"$orderby\" /><input type='submit' class='button' value='" . $vbphrase['aws_remove'] . "' />";
		$s1 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_asce'] . "\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s1t&page=1'\">";
		$s2 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_desc'] . "\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s2t&page=1'\">";
		$s3 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_asce'] . "\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s3t&page=1'\">";
		$s4 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_desc'] . "\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s4t&page=1'\">";
		$s5 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_asce'] . "\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s5t&page=1'\">";
		$s6 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_desc'] . "\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s6t&page=1'\">";
		$s7 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_asce'] . "\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s7t&page=1'\">";
		$s8 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_desc'] . "\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s8t&page=1'\">";
		$s9 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_asce'] . "\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s9t&page=1'\">";
		$s10 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_desc'] . "\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s10t&page=1'\">";
		$s11 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_asce'] . "\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s11t&page=1'\">";
		$s12 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_desc'] . "\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s12t&page=1'\">";
		$s13 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_asce'] . "\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s13t&page=1'\">";
		$s14 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_desc'] . "\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s14t&page=1'\">";
		$s15 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_asce'] . "\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s15t&page=1'\">";
		$s16 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_desc'] . "\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s16t&page=1'\">";
		$aa=($page-1)*$perpage+1;
		if ($page<$totalpages)
		{
			$bb=$page*$perpage;
		}
		else
		{
			$bb=$counter['warnings'];
		}
		$cc=$counter['warnings'];		
		
		print_cp_header("Advanced Warning System Version {$AWS_VERSION}");
		print_form_header('admin_warn', 'deletemarkwarn');
		print_table_header("Warnings Log<br> Page $page of $totalpages<br>Warnings $aa to $bb of $cc<br>Order by: $orderbycom",15);
		
		$header = array();
		
		$header[] = "<b>" . $vbphrase['aws_warneduseridname'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_warnedby'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_warnedpost'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_warningtype'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_warnpoints'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_warndate'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_maturitydate'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_comment'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_causedban'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_remove'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_status'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_removedby'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_removaldate'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_completeremoval'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_select'] . "</b>";
		print_cells_row($header, 1);
		$sort_cell = array();
		$sort_cell[] = "<font size='-1'><center>$s1<br>$s2</center></font>";
		$sort_cell[] = "<font size='-1'><center>$s3<br>$s4</center></font>";
		$sort_cell[] = "<font size='-1'><center>$s5<br>$s6</center></font>";
		$sort_cell[] = "<font size='-1'><center>$s7<br>$s8</center></font>";
		$sort_cell[] = "<font size='-1'><center>$s9<br>$s10</center></font>";
		$sort_cell[] = "<font size='-1'><center>$s11<br>$s12</center></font>";;
		$sort_cell[] = "<font size='-1'><center>$s13<br>$s14</center></font>";
		$sort_cell[] = "<font size='-1'><center>&nbsp;<br>&nbsp;</center></font>";
		$sort_cell[] = "<font size='-1'><center>&nbsp;<br>&nbsp;</center></font>";
		$sort_cell[] = "<font size='-1'><center>&nbsp;<br>&nbsp;</center></font>";
		$sort_cell[] = "<font size='-1'><center>&nbsp;<br>&nbsp;</center></font>";
		$sort_cell[] = "<font size='-1'><center>&nbsp;<br>&nbsp;</center></font>";
		$sort_cell[] = "<font size='-1'><center>$s15<br>$s16</center></font>";
		$sort_cell[] = "<font size='-1'><center>&nbsp;<br>&nbsp;</center></font>";
		$sort_cell[] = "<font size='-1'><center>Comp<br>Rem</center></font>";
		print_cells_row($sort_cell,15,'thead');
		while($warn=$db->fetch_array($get_warns))
		{
			$cell = array();
			
			$warn['date'] = vbdate ($vbulletin->options['dateformat'],$warn['warned_time']);
			$warn['time'] = vbdate ($vbulletin->options['timeformat'],$warn['warned_time']);
			if($warn['warn_permban']==1)
			{
				$rdate="Never";
			}
			else
			{
				$rdate = $warn['maturitydate'];
				$rdate = vbdate($vbulletin->options['dateformat'],$rdate);
			}
			if($warn['warned_userid_v']=="")
			{
				$x="<i>Deleted User</i>";
			} 
			else 
			{
				$x="<a href=\"{$vbulletin->options[bburl]}/$admincpdir/user.php?$session[sessionurl]do=edit&amp;userid={$warn[warned_userid_v]}\"  onclick=\"window.open('{$vbulletin->options[bburl]}/$admincpdir/user.php?$session[sessionurl]do=edit&amp;userid={$warn[warned_userid_v]}','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">{$warn[warned_userid_v]}<br><b>{$warn['warned_username_v']}</a></font>";
			}
			if($warn['warn_permban']==1 OR $warn['warned_status']=="I")
			{
				$y="<i>Not removable</i>";
			} 
			else 
			{
				$y="<a href='{$vbulletin->options[bburl]}/$admincpdir/admin_warn.php?do=remove&id={$warn[wid]}&userid={$warn[warned_userid_v]}&uname={$warn[warned_username_v]}&wname={$warn[title]}&postid={$warn[warned_post]}&ban=$warn[caused_ban]&orderstring={$order}'>Remove</a>";
			}
			
			$cy="<a href='{$vbulletin->options[bburl]}/$admincpdir/admin_warn.php?do=completeremove&id={$warn[wid]}&userid={$warn[warned_userid_v]}&uname={$warn[warned_username_v]}&wname={$warn[title]}&postid={$warn[warned_post]}&ban=$warn[caused_ban]&orderstring={$order}'>Complete Removal</a>";
			
			if($warn['warned_status']=="I")
			{
				$k="<i>Warning<br />Inactive</i>";
			} 
			if($warn['warned_status']=="A")
			{
				$k="Warning<br />Active";
			}
			if($warn['warned_status']=="L")
			{
				$k="Alert";
			}
			$a=$warn[title];
			$p=$warn[warn_points];
			$b=$warn['date'];
			$c=$warn['time'];
			if ($a=="ObsceneWords" OR $a=="ObsceneWordsinChat")
			{
				$vbvb='See Uncensored Message';
			}
			else
			{
				$vbvb='See Comment';
			}
			if ($a=="ObsceneWordsinChat")
			{
				$d="<A HREF=\"{$vbulletin->options[bburl]}/admincp/admin_warn.php?do=showcomment&id=$warn[wid]&name=$a&
				&reason=$warn[warned_reason]\"  onclick=\"window.open('{$vbulletin->options[bburl]}/admincp/admin_warn.php?do=showcomment&id=$warn[wid]&name=$a&reason=$warn[warned_reason]','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">$vbvb</a></font>";
			}
			else
			{
				
				$d="<A HREF=\"{$vbulletin->options[bburl]}/$admincpdir/admin_warn.php?do=showcomment&id=$warn[wid]\"  onclick=\"window.open('{$vbulletin->options[bburl]}/$admincpdir/admin_warn.php?do=showcomment&id=$warn[wid]','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">$vbvb</a></font>";
			}			
			if ($warn['warned_status']=="I")
			{
				if ($warn['removed_by'] == '0')
				{
					$r='cron';
					$r2=$r;
				}
				else
				{
					$r=$warn[removed_by_v];
					$r2="<a href=\"{$vbulletin->options[bburl]}/admincp/user.php?$session[sessionurl]do=edit&amp;userid={$warn['removed_by']}\"  onclick=\"window.open('{$vbulletin->options[bburl]}/admincp/user.php?$session[sessionurl]do=edit&amp;userid={$warn['removed_by']}','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">{$r}</a>";
				}
			}
			else
			{
				$r2='';
			}
			if ($warn['removed_date'] == '' OR $warn['removed_date'] == '0')
			{
				$t1='';
				$t2='';
			
			}
			else
			{
				$t1=vbdate($vbulletin->options['dateformat'],$warn['removed_date']);
				$t2=vbdate($vbulletin->options['timeformat'],$warn['removed_date']);
			
			}
			if ($warn['warned_post'] == '' OR $warn['warned_post'] == '0')
			{
				$w='NPR';
			}
			else
			{
				$w="<a href=\"{$vbulletin->options[bburl]}/showthread.php?p=$warn[warned_post]#post$warn[warned_post]\"  onclick=\"window.open('{$vbulletin->options[bburl]}/showthread.php?p=$warn[warned_post]#post$warn[warned_post]','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">$warn[warned_post]</a></font>";
			}
			
			if ($warn['caused_ban']=='Y')
			{
				$cb='Yes';
			}
			else
			{
				$cb='No';
			}
			if($warn['warned_status']=="L")
			{
				$k='Alert';
				$p='';
				$rdate='';
				$cb='';
				$y='';
			}
			else
			{
				$p=$warn['warn_points'];
			}
			$mark = "<input type=\"checkbox\" name=\"markwarn[]\" value=\"$warn[wid]\" id=\"markwarn_$warn[wid]\" />";
			
			$cell[] = "<font size='-1'>{$x}</font>";
			$cell[] = "<b><font size='-1'><a href=\"{$vbulletin->options[bburl]}/$admincpdir/user.php?$session[sessionurl]do=edit&amp;userid={$warn['wuserid']}\"  onclick=\"window.open('{$vbulletin->options[bburl]}/$admincpdir/user.php?$session[sessionurl]do=edit&amp;userid={$warn['wuserid']}','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">{$warn['wusername']}</a></font>";
			$cell[] = "<font size='-1'>{$w}</font>";
			$cell[] = "<font size='-1'>{$a}</font>";
			$cell[] = "<font size='-1'>{$p}</font>";
			$cell[] = "<font size='-1'>{$b}<br>{$c}</font>";
			$cell[] = "<font size='-1'>$rdate</font>";
			$cell[] = "<font size='-1'>{$d}</font>";
			$cell[] = "<font size='-1'>{$cb}</font>";
			$cell[] = "<font size='-1'>{$y}</font>";
			$cell[] = "<font size='-1'>{$k}</font>";
			$cell[] = "<font size='-1'>{$r2}</font>";
			$cell[] = "<font size='-1'>{$t1}<br>{$t2}</font>";
			$cell[] = "<font size='-1'>{$cy}</font>";
			$cell[] = "{$mark}";
			
			print_cells_row($cell);
		}
		print_description_row("<span style=\"float:$stylevar[right]\">$delbutton</span>Mark the warnings you want to completely remove and click the button at right.<br /><u>Attention:</u> This is not reversible. You will not be asked to confirm your selection.</form>",0,15,'thead');
		print_description_row("<u>Remove :</u> will only remove the associated points from the user's account, without removing any associated bans. The warning is still included in the user's account warnings (sort of manual maturing).<br><u>Complete Removal :</u> will remove the warning from the warnings table and the user's account, the warning points from the user's account, and any associated ban from the user's account. This action will NOT unban the user. If the user is still banned, you have to unban him manually, using the Unban User function, in the View Banned Users menu selection of the AWS menu.<br>Use Remove, to simply remove a warning before it matures. Use Complete Removal, if for example you warned someone by mistake, or if you want to completely  remove any effects of a warning (as if it was never done).",0,15,'thead');
		print_description_row("<div class=\"smallfont\" align=\"center\">$vbphrase[all_times_are_gmt_x_time_now_is_y]</div>", 0, 15, 'thead');
		print_table_footer(15, "$firstpage $prevpage &nbsp; $nextpage $lastpage");
	}
	else
	{
		
		print_stop_message('no_warnings_found');
	}
	print_cp_footer();
	exit;
}
//#####################################################################################################################################
if($_GET['do'] == "viewwarnedusers")
{
	$vbulletin->input->clean_array_gpc('r',array(
		'wid'		=> TYPE_INT,
		'perpage'	=> TYPE_INT,
		'page'		=> TYPE_INT,
		'orderby'	=> TYPE_STR,
		'script'    => TYPE_STR,
	));
	
	$perpage = $vbulletin->GPC['perpage'];
	$page = $vbulletin->GPC['page'];
	
	$perpage = $vbulletin->options['warn_warnings_per_page'];
	
	if($perpage == '' OR $perpage == 0)
	{
		$perpage = 15;
	}
	
	if($page < 1)
	{
		$page = 1;
	}
	$startat = ($page - 1) * $perpage;

	$counter = $db->query_first("SELECT COUNT(*) AS users FROM " . TABLE_PREFIX . "user WHERE warns > 0 OR alerts > 0 OR warning_bans > 0");
	
	$totalpages = ceil($counter['users'] / $perpage);
	$orderby = 'userid ASC';

	$get_users = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "user WHERE warns > 0 OR alerts > 0 OR warning_bans > 0 ORDER BY $orderby LIMIT $startat, $perpage");

	if ($db->num_rows($get_users))
	{
		if ($page != 1)
		{
			$prv = $page - 1;
			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['aws_first_page'] .
							"\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?" . $vbulletin->session->vars['sessionurl'] .
							"do=viewwarnedusers&script=" . $vbulletin->GPC['script'] .
							"&perpage=" . $vbulletin->GPC['perpage'] .
							"&orderby=" . $vbulletin->GPC['orderby'] .
							"&page=1'\">";
			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['aws_prev_page'] .
						"\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?" . $vbulletin->session->vars['sessionurl'] .
						"do=viewwarnedusers&script=" . $vbulletin->GPC['script'] . 
						"&perpage=" . $vbulletin->GPC['perpage'] .
						"&orderby=" . $vbulletin->GPC['orderby'] .
						"&page=$prv'\">";
		}
		if ($page != $totalpages)
		{
			$nxt = $page + 1;
			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_next_page'] .
						" &gt;\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?" .
						$vbulletin->session->vars['sessionurl'] .
						"do=viewwarnedusers&script=" . $vbulletin->GPC['script'] .
						"&perpage=" . $vbulletin->GPC['perpage'] .
						"&orderby=" . $vbulletin->GPC['orderby'] .
						"&page=$nxt'\">";
			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_last_last_page'] .
						" &raquo;\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?" . $vbulletin->session->vars['sessionurl'] .
						"do=viewwarnedusers&script=" . $vbulletin->GPC['script'] .
						"&perpage=" . $vbulletin->GPC['perpage'] .
						"&orderby=" . $vbulletin->GPC['orderby'] .
						"&page=$totalpages'\">";
		}
		print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
		print_form_header('admin_warn', '');
		$aa = ($page - 1) * $perpage + 1;
		$cc = $counter['users'];
		if ($page < $totalpages)
		{
			$bb = $page * $perpage;
		}
		else
		{
			$bb = $counter['users'];
		}

		print_table_header($vbphrase['aws_admin_warnedalertedusers'] . "<br>" . $vbphrase['aws_page'] . " $page " . $vbphrase['aws_of'] . " $totalpages<br>" . $vbphrase['aws_admin_users'] . " " .$vbphrase['aws_to1'] . "$aa " . $vbphrase['aws_to'] . " $bb " . $vbphrase['aws_of'] . " $cc",10);
		
		$header = array();
		
		$header[] = "<b>" . $vbphrase['aws_userid'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_username'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_usertitle'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_join_date'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_viewuserwarns'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_ip_address'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_alerts_acp'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_warnings_acp'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_warninglevel'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_warningbans'] . "</b>";
					
		print_cells_row($header, 1);
		
		
		while($user = $db->fetch_array($get_users))
		{
			
			$cell = array();
			
			$user['date'] = vbdate($vbulletin->options['dateformat'],$user['joindate']);
			$user['time'] = vbdate($vbulletin->options['timeformat'],$user['joindate']);
			$cell[] = "<font size='-1'>$user[userid]</font>";
			$cell[] = "<font size='-1'><a href=\"user.php?s=$session[sessionhash]&do=edit&userid=$user[userid]\" onclick=\"window.open('user.php?s=$session[sessionhash]&do=edit&userid=$user[userid]','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">{$user['username']}</a></font>";
			$cell[] = "<font size='-1'>$user[usertitle]</font>";
			$cell[] = "<font size='-1'>$user[date]<br>$user[time]</font>";
			$cell[] = "<font size='-1'><a href=\"admin_warn.php?do=do_finduserwarnings&type=warnings&userid=$user[userid]\" onclick=\"window.open('admin_warn.php?do=do_finduserwarnings&userid=$user[userid]','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">" . $vbphrase['aws_admin_userwarnings'] . "</a></font>";
			$cell[] = "<font size='-1'><a href=\"usertools.php?s=$session[sessionurl_q]&do=gethost&ip=$user[ipaddress]\" onclick=\"window.open('usertools.php?s=$session[sessionhash]&do=gethost&ip=$user[ipaddress]','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">$user[ipaddress]</a></font>";
			$cell[] = "<font size='-1'>$user[alerts]</font>";
			$cell[] = "<font size='-1'>$user[warns]</font>";
			$cell[] = "<font size='-1'>$user[warning_level]</font>";
			$cell[] = "<font size='-1'>$user[warning_bans]</font>";
				
			print_cells_row($cell);
		}
		print_description_row("<div class=\"smallfont\" align=\"center\">$vbphrase[all_times_are_gmt_x_time_now_is_y]</div>", 0, 11, 'thead');
		print_table_footer(10, "$firstpage $prevpage &nbsp; $nextpage $lastpage");
	}
	else
	{
		print_stop_message('no_users_matched_your_query');
	}
	exit;
}
//#####################################################################################################################################
if($_GET['do'] == "viewwarnedpms")
{
	$vbulletin->input->clean_array_gpc('r',array(
		'pmtextid' => TYPE_INT,
		'perpage' => TYPE_INT,
		'page' => TYPE_INT,
		'orderby' => TYPE_STR,
	));
	
	if ($vbulletin->options['warn_automaticpm'] != 1)
	{
		print_stop_message('aws_warning_warn_noautomaticpm');
	}
				
	$perpage = $vbulletin->options['warn_warnings_per_page'];
	
	if ($perpage == '' OR $perpage == 0)
	{
		$perpage = 15;
	}

	$page = $vbulletin->GPC['page'];
	if ($page < 1)
	{
		$page = 1;
	}
	$startat = ($page - 1) * $perpage;
	
	$counter = $db->query_first("SELECT COUNT(*) AS pms FROM " . TABLE_PREFIX . "pmtext_warned AS pm");
	$totalpages = ceil($counter['pms'] / $perpage);
	$orderby = 'dateline DESC';
	
	$get_pms = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "pmtext_warned p ORDER BY $orderby LIMIT $startat, $perpage");
	
	if ($db->num_rows($get_pms))
	{
		if ($page != 1)
		{
			$prv = $page - 1;
			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['aws_first_page'] .
							"\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?" . $vbulletin->session->vars['sessionurl'] .
							"do=viewwarnedpms&script=" . $vbulletin->GPC['script'] .
							"&perpage=" . $vbulletin->GPC['perpage'] .
							"&orderby=" . $vbulletin->GPC['orderby'] .
							"&page=1'\">";
			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['aws_prev_page'] .
						"\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?" . $vbulletin->session->vars['sessionurl'] .
						"do=viewwarnedpms&script=" . $vbulletin->GPC['script'] . 
						"&perpage=" . $vbulletin->GPC['perpage'] .
						"&orderby=" . $vbulletin->GPC['orderby'] .
						"&page=$prv'\">";
		}
		if ($page != $totalpages)
		{
			$nxt = $page + 1;
			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_next_page'] .
						" &gt;\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?" .
						$vbulletin->session->vars['sessionurl'] .
						"do=viewwarnedpms&script=" . $vbulletin->GPC['script'] .
						"&perpage=" . $vbulletin->GPC['perpage'] .
						"&orderby=" . $vbulletin->GPC['orderby'] .
						"&page=$nxt'\">";
			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_last_page'] .
						" &raquo;\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?" . $vbulletin->session->vars['sessionurl'] .
						"do=viewwarnedpms&script=" . $vbulletin->GPC['script'] .
						"&perpage=" . $vbulletin->GPC['perpage'] .
						"&orderby=" . $vbulletin->GPC['orderby'] .
						"&page=$totalpages'\">";
		}
		print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
		print_form_header('admin_warn', '');
		$aa = ($page - 1) * $perpage + 1;
		$cc = $counter['pms'];
		if ($page < $totalpages)
		{
			$bb = $page * $perpage;
		}
		else
		{
			$bb = $counter['pms'];
		}
		print_table_header($vbphrase['aws_admin_autowarnedpm'] . "<br>" . $vbphrase['aws_page'] . " $page " . $vbphrase['aws_of'] . " $totalpages<br>" . $vbphrase['aws_admin_records'] . " " .$vbphrase['aws_to1'] . "$aa " . $vbphrase['aws_to'] . " $bb " . $vbphrase['aws_of'] . " $cc",7);
		
		$header = array();
		
		$header[] = "<b>" . $vbphrase['aws_admin_internalcode'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_sender'] . "<br>" . $vbphrase['aws_userid'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_sender'] . "<br>" . $vbphrase['aws_admin_username'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_recipients'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_titlebefore'] . "<br>" . $vbphrase['aws_admin_censoring'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_messagebefore'] . "<br>" . $vbphrase['aws_admin_censoring'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_messages_datetime'] . "</b>";
			
		print_cells_row($header, 1);

		while($pm = $db->fetch_array($get_pms))
		{
			$cell = array();
			$pm['date'] = vbdate ($vbulletin->options['dateformat'], $pm['dateline']);
			$pm['time'] = vbdate ($vbulletin->options['timeformat'], $pm['dateline']);
			$tousersstring = '';
			
			$users = unserialize($pm['touserarray']);
			$tousers = array();
			$tousers = fetch_touserstring($pm);
			if (!empty($users))
			{
				foreach ($users AS $user)
				{
					if ($tousersstring != '')
					{
						$tousersstring .= ', ';
					}
					$tousersstring .= $user;
				}
			}
			
			$cell[] = "<font size='-1'>$pm[pmtextid]</font>";
			$cell[] = "<font size='-1'>$pm[fromuserid]</font>";
			$cell[] = "<font size='-1'><a href='user.php?s=$session[sessionhash]&do=edit&userid=$pm[fromuserid]' target='_blank'>{$pm['fromusername']}</a></font>";
			$cell[] = "<font size='-1'>$tousersstring</font>";
			$cell[] = "<font size='-1'>$pm[before_title]</font>";
			$cell[] = "<font size='-1'>$pm[before_message]</font>";
			$cell[] = "<font size='-1'>$pm[date]<br>$pm[time]</font>";
						
			print_cells_row($cell);
		}
		print_description_row("<div class=\"smallfont\" align=\"center\">$vbphrase[all_times_are_gmt_x_time_now_is_y]</div>", 0, 8, 'thead');
		print_table_footer(7, "$firstpage $prevpage &nbsp; $nextpage $lastpage");
	}
	else
	{
		print_stop_message('no_users_matched_your_query');
	}
	exit;
}
//#####################################################################################################################################
if($_POST['do'] == "do_edit_warn")
{
	$vbulletin->input->clean_array_gpc('p',array(
		'warningtypeid'                => TYPE_INT,
		'title'                        => TYPE_STR,
		'warn_desc'                    => TYPE_STR,
		'warn_points'                  => TYPE_INT,
		'warn_maturity'                => TYPE_INT,
		'warn_permban'                 => TYPE_BOOL,
		'warn_type'                    => TYPE_INT,
		'warn_alert'                   => TYPE_BOOL,
		'warn_alertcomment'            => TYPE_STR,
	));
	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
	if(!$warn = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "warningtype WHERE warningtypeid = '{$vbulletin->GPC['warningtypeid']}'"))
	{
		echo $vbphrase['aws_admin_unablefindwarntype'] . " [ <a href='javascript:history.go(-1);'>" . $vbphrase['aws_admin_goback'] . "</a> ]";
		exit;
	}
	$vbulletin->GPC['title'] = ParseInputs($vbulletin->GPC['title']);
	$vbulletin->GPC['warn_desc'] = ParseInputs($vbulletin->GPC['warn_desc']);
	
	if ($vbulletin->options['warn_allowoffpost'] == 0 AND $vbulletin->GPC['warn_type'] == 1)
	{
		define('CP_REDIRECT', 'admin_warn.php?do=view');
		print_stop_message('aws_warning_warn_typeconflict');
	}
	
	$warn_alertcomment = addslashes($vbulletin->GPC['warn_alertcomment']);
	if ($vbulletin->GPC['warn_alert'] == '')
	{
		$vbulletin->GPC['warn_alert'] = 0;
	}
	if($vbulletin->GPC['warn_permban'] == 1 AND $vbulletin->GPC['warn_points'] != $vbulletin->options['warn_points_before_banned'])
	{
		print_stop_message('aws_warning_warn_invalid_permban');
	}
	$db->query_write("UPDATE " . TABLE_PREFIX . "warningtype SET
		title = '{$vbulletin->GPC['title']}',
		warn_desc = '{$vbulletin->GPC['warn_desc']}',
		warn_points = '{$vbulletin->GPC['warn_points']}',
		warn_maturity = '{$vbulletin->GPC['warn_maturity']}',
		warn_permban = '{$vbulletin->GPC['warn_permban']}',
		warn_type = '{$vbulletin->GPC['warn_type']}',
		warn_alert = '{$vbulletin->GPC['warn_alert']}',
		warn_alertcomment = '{$warn_alertcomment}'
		WHERE warningtypeid = '{$vbulletin->GPC['warningtypeid']}'
	");
	define('CP_REDIRECT', 'admin_warn.php?do=view');
	print_stop_message('aws_warning_warn_edited');
}
//#####################################################################################################################################
if($_GET['do'] == "delete")
{
	$vbulletin->input->clean_array_gpc('g',array(
		'warningtypeid'      => TYPE_INT,
		'verify'             => TYPE_INT,
	));
	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
	if(!$warn = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "warningtype WHERE warningtypeid = '{$vbulletin->GPC['warningtypeid']}'"))
	{
		echo $vbphrase['aws_admin_unablefindwarntype'] . " [ <a href='javascript:history.go(-1);'>" . $vbphrase['aws_admin_goback'] . "</a> ]";
		exit;
	}
	print_delete_confirmation('warningtype', $vbulletin->GPC['warningtypeid'], 'admin_warn', 'do_delete_warn', 'warningtype');
	print_cp_footer();
}
//#####################################################################################################################################
if($_POST['do'] == "do_delete_warn")
{
	$vbulletin->input->clean_gpc('p','warningtypeid',TYPE_INT);

	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
	
	if(!$warn = $db->query_read("SELECT * FROM " . TABLE_PREFIX ."warningtype WHERE warningtypeid = '{$vbulletin->GPC['warningtypeid']}'"))
	{
		echo $vbphrase['aws_admin_unablefindwarntype'] . " [ <a href='javascript:history.go(-1);'>" . $vbphrase['aws_admin_goback'] . "</a> ]";
		exit;
	}
	
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "warningtype WHERE warningtypeid = '" .$vbulletin->GPC['warningtypeid']."'");
	define('CP_REDIRECT', 'admin_warn.php?do=view');
	print_stop_message('aws_warning_warn_deleted');
}
//#####################################################################################################################################
if($_POST['do'] == "do_update_warnopt")
{
	//############################################
	// Clean used variables
	//############################################
	$vbulletin->input->clean_array_gpc('p',array(
		'hierarchical'           => TYPE_BOOL,
		'aprotected_usergroups'  => TYPE_STR,
		'admingroups'            => TYPE_STR,
		'smodgroups'             => TYPE_STR,
		'modgroups'              => TYPE_STR,
		'historical'             => TYPE_BOOL,
		'allowoffpost'           => TYPE_BOOL,
		'allownotes'             => TYPE_BOOL,
		'multiple_per_post'      => TYPE_INT,
		'automatic'              => TYPE_BOOL,
		'automaticpm'            => TYPE_BOOL,
		'autocomments'           => TYPE_BOOL,
		'viewoption'             => TYPE_STR,
	    'modoption'              => TYPE_STR,
		'automatic_warner'       => TYPE_INT,
		'warner'                 => TYPE_INT,
		'username'               => TYPE_STR,
		'mailfrom'               => TYPE_BOOL,
		'mailfromaddress'        => TYPE_STR,
		'collector'              => TYPE_INT,
		'banned_limit'           => TYPE_INT,
		'points_before_banned'   => TYPE_INT,
		'warnings_before_banned' => TYPE_INT,
		'banned_usergroup_id'    => TYPE_INT,
		'troll_usergroup_id'     => TYPE_INT,
		'restore_groupid'        => TYPE_INT,
		'incr_ban_days'          => TYPE_INT,
		'max_no_bans'            => TYPE_INT,
		'bans_mature'            => TYPE_INT,
		'sig_thresshold'         => TYPE_INT,
		'avatar_thresshold'      => TYPE_INT,
		'pic_thresshold'         => TYPE_INT,
		'sigpic_thresshold'      => TYPE_INT,
		'pmcutoff'               => TYPE_INT,
		'send_pm_warning'        => TYPE_BOOL,
		'send_em_warning'        => TYPE_BOOL,
		'email_on_ban'           => TYPE_BOOL,
		'includepost'            => TYPE_BOOL,
		'textbutoption'          => TYPE_STR, 
		'warnings_per_page'      => TYPE_INT,
		'savecopy'               => TYPE_BOOL,
		'savecopyalert'          => TYPE_BOOL,
		'savecopyforum'          => TYPE_INT,
		'allowalerts'            => TYPE_BOOL,
		'allowalertscomment'     => TYPE_BOOL,
		'alertslifetime'         => TYPE_INT,
		'min_comment_length'     => TYPE_INT,
		'do'                     => TYPE_STR,
	));
	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
	if ($vbulletin->GPC['sig_thresshold'] > $vbulletin->GPC['points_before_banned'])
	{
		$mess .= "<br>" . $vbphrase['aws_admin_signaturelimit'];
		$url = "admin_warn.php?do=manageoptions";
		$wait = 8;
		print_cp_message($mess, $url, $wait);
	}
	if ($vbulletin->GPC['avatar_thresshold'] > $vbulletin->GPC['points_before_banned'])
	{
		$mess .= "<br>" . $vbphrase['aws_admin_avatarlimit'];
		$url = "admin_warn.php?do=manageoptions";
		$wait = 8;
		print_cp_message($mess, $url, $wait);
	}
	if ($vbulletin->GPC['admingroups'] == '')
	{
		$admingroups = '6';
	}
	else
	{
		$admingroups = $vbulletin->GPC['admingroups'];
	}
	
	if ($vbulletin->GPC['smodgroups'] == '')
	{
		$smodgroups = '5';
	}
	else
	{
		$smodgroups = $vbulletin->GPC['smodgroups'];
	}
	
	if ($vbulletin->GPC['modgroups'] == '')
	{
		$modgroups = '7';
	}
	else
	{
		$modgroups = $vbulletin->GPC['modgroups'];
	}
	
	if ($vbulletin->GPC['aprotected_usergroups'] != '')
	{
		$aprotected_usergroups = $vbulletin->GPC['aprotected_usergroups'];
	}
	
	if ($vbulletin->GPC['aprotected_usergroups'] != '')
	{
		if ($vbulletin->GPC['hierarchical'] == 1)
			{
				$protected_usergroups = "$admingroups" . "|" . "$aprotected_usergroups" ;
			}
			else
			{
				$protected_usergroups = "$admingroups" . "|" . "$smodgroups" . "|" . "$modgroups" . "|" . "$aprotected_usergroups" ;
			}
	}
	else
	{
		if ($vbulletin->GPC['hierarchical'] == 1)
			{
				$protected_usergroups = "$admingroups";
			}
			else
			{
				$protected_usergroups = "$admingroups" . "|" . "$smodgroups" . "|" . "$modgroups";
			}
	}
	if ($vbulletin->GPC['automatic'] == 1 AND ($vbulletin->GPC['automatic_warner'] == '' OR $vbulletin->GPC['automatic_warner'] == 0))
	{
		$vbulletin->GPC['automatic_warner'] = 1;
	}
	
	if ($vbulletin->GPC['warner'] == '')
	{
		$vbulletin->GPC['warner'] = 0;
	}
	
	if ($vbulletin->GPC['allowalerts'] == '0' AND $vbulletin->options['warn_allowalerts'] == '1')
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "warningtype
			SET warn_alert = '0'
			");
	}
	if ($vbulletin->GPC['alertslifetime'] == '' OR $vbulletin->GPC['alertslifetime'] < 0)
	{
		$vbulletin->GPC['alertslifetime'] = 0;
	}

	if ($vbulletin->GPC['min_comment_length'] == '' OR $vbulletin->GPC['min_comment_length'] < 0)
	{
		$vbulletin->GPC['min_comment_length'] = 0;
	}
	$options = array(
		'warn_hierarchical'                 => $vbulletin->GPC['hierarchical'],
		'warn_protected_usergroups'         => $protected_usergroups,
		'warn_admingroups'                  => $admingroups,
		'warn_smodgroups'                   => $smodgroups,
		'warn_modgroups'                    => $modgroups,
		'warn_historical'                   => $vbulletin->GPC['historical'],
		'warn_allowoffpost'                 => $vbulletin->GPC['allowoffpost'],
		'warn_multiple_per_post'            => $vbulletin->GPC['multiple_per_post'],
		'warn_automatic'                    => $vbulletin->GPC['automatic'],
		'warn_automaticpm'                  => $vbulletin->GPC['automaticpm'],
		'warn_autocomments'                 => $vbulletin->GPC['autocomments'],
		'warn_viewoption'                   => $vbulletin->GPC['viewoption'],
		'warn_modoption'                    => $vbulletin->GPC['modoption'],
		'warn_automatic_warner'             => $vbulletin->GPC['automatic_warner'],
		'warn_warner'                       => $vbulletin->GPC['warner'],
		'warn_collector'                    => $vbulletin->GPC['collector'],
		'warn_username'                     => $vbulletin->GPC['username'],
		'warn_mailfrom'                     => $vbulletin->GPC['mailfrom'],
		'warn_mailfromaddress'              => $vbulletin->GPC['mailfromaddress'],
		'warn_banned_limit'                 => $vbulletin->GPC['banned_limit'],
		'warn_points_before_banned'         => $vbulletin->GPC['points_before_banned'],
		'warn_warnings_before_banned'       => $vbulletin->GPC['warnings_before_banned'],
		'warn_banned_usergroup_id'          => $vbulletin->GPC['banned_usergroup_id'],
		'warn_troll_usergroup_id'           => $vbulletin->GPC['troll_usergroup_id'],
		'warn_restore_groupid'              => $vbulletin->GPC['restore_groupid'],
		'warn_incr_ban_days'                => $vbulletin->GPC['incr_ban_days'],
		'warn_max_no_bans'                  => $vbulletin->GPC['max_no_bans'],
		'warn_bans_mature'                  => $vbulletin->GPC['bans_mature'],
		'warn_sig_thresshold'               => $vbulletin->GPC['sig_thresshold'],
		'warn_avatar_thresshold'            => $vbulletin->GPC['avatar_thresshold'],
		'warn_pmcutoff'                     => $vbulletin->GPC['pmcutoff'],
		'warn_sigpic_thresshold'            => $vbulletin->GPC['sigpic_thresshold'],
		'warn_pic_thresshold'               => $vbulletin->GPC['pic_thresshold'],
		'warn_send_pm_warning'              => $vbulletin->GPC['send_pm_warning'],
		'warn_send_em_warning'              => $vbulletin->GPC['send_em_warning'],
		'warn_email_on_ban'                 => $vbulletin->GPC['email_on_ban'],
		'warn_includepost'                  => $vbulletin->GPC['includepost'],
		'warn_textbutoption'                => $vbulletin->GPC['textbutoption'],
		'warn_warnings_per_page'            => $vbulletin->GPC['warnings_per_page'],
		'warn_savecopy'                     => $vbulletin->GPC['savecopy'],
		'warn_savecopyalert'                => $vbulletin->GPC['savecopyalert'],
		'warn_savecopyforum'                => $vbulletin->GPC['savecopyforum'],
		'warn_allowalerts'                  => $vbulletin->GPC['allowalerts'],
		'warn_allowalertscomment'           => $vbulletin->GPC['allowalertscomment'],
		'warn_allownotes'                   => $vbulletin->GPC['allownotes'],
		'warn_alertslifetime'               => $vbulletin->GPC['alertslifetime'],
		'warn_min_comment_length'           => $vbulletin->GPC['min_comment_length']
	);
	foreach($options AS $opt => $value)
	{
		$db->query_write("
				UPDATE " . TABLE_PREFIX . "setting
				SET value = '$value'
				WHERE varname = '" . addslashes($opt) . "'
			");
	}
	build_options();
	if($vbulletin->options['warn_historical'] == 0 AND $vbulletin->GPC['historical'] == 0)
	{
		print_form_header('admin_warn', 'do_confirm');
		print_table_header($vbphrase['aws_admin_historicalrecsrem']);
		print_yes_no_row($vbphrase['aws_admin_selectednotusehistrecs'], 'verify', '');
		print_submit_row($vbphrase['aws_admin_proceed'], 0);
	}
	else
	{
		$mess = $vbphrase['aws_admin_awsoptsbeenupdated'];
		$url = "admin_warn.php?do=manageoptions";
		$wait = 5;
		print_cp_message($mess, $url, $wait);
	}

}
//#####################################################################################################################################
if($_POST['do'] == "do_confirm")
{
	$vbulletin->input->clean_array_gpc('r',array(
		'verify' => TYPE_INT,
	));
	if(($vbulletin->GPC['verify'] == '' OR $vbulletin->GPC['verify'] == 0))
	{
		$mess = $vbphrase['aws_admin_histoptno1'];
		$mess .= "<br>" . $vbphrase['aws_admin_awsoptsbeenupdated'];
	}
	if($vbulletin->GPC['verify'] == 1)
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "warnings WHERE warned_status = 'I'");
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "ban_dates WHERE banned_status = 'I'");
		$mess = $vbphrase['aws_admin_histoptno2'];
		$mess .= "<br>" . $vbphrase['aws_admin_awsoptsbeenupdated'];
	}
	$url = "admin_warn.php?do=manageoptions";
	$wait = 5;
	print_cp_message($mess, $url, $wait);
}
//#####################################################################################################################################
if($_GET['do'] == "prune")
{
	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");

	if ($vbulletin->options['warn_historical'] == 1)
	{
		print_form_header('admin_warn', 'do_noprune');
		print_table_header($vbphrase['aws_admin_prunewarns']);
		print_yes_no_row($vbphrase['aws_admin_askedpruneoldwarns'], 'ack', '');
		print_submit_row($vbphrase['aws_admin_proceed'], 0);
	}
	print_form_header('admin_warn', 'do_prune_warnings');
	print_table_header($vbphrase['aws_admin_prunewarns']);
	print_input_row($vbphrase['aws_admin_numberdayskeepwarns'] . $vbphrase['aws_admin_itcannotbeundone'] . "</dfn>", 'days', 30);
	print_submit_row($vbphrase['aws_admin_prunewarns_button'], 0);
	exit;
}
//#####################################################################################################################################
$vbulletin->input->clean_gpc('r', 'days', TYPE_INT);
$days = $vbulletin->GPC['days'];

if($_POST['do'] == "do_prune_warnings")
{
	if ($days == 1)
	{
		$TempStringDays = $vbphrase['aws_day1'];
	}
	else
	{
		$TempStringDays = $vbphrase['aws_day3'];
	}

	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
	print_form_header('admin_warn', 'do_prune_confirm');
	print_table_header($vbphrase['aws_admin_deleteoldwarns']);
	construct_hidden_code('form', '');
	construct_hidden_code('days', $days);
	print_yes_no_row($vbphrase['aws_admin_suretodeleteoldwarns1'] . $days . " " . $TempStringDays . " " . $vbphrase['aws_admin_suretodeleteoldwarns2'] . $vbphrase['aws_admin_itcannotbeundone'] . "</dfn>", 'verify','');
	print_submit_row($vbphrase['aws_admin_proceed'], 0);
	exit;
}
//#####################################################################################################################################
if($_POST['do'] == "do_noprune")
{
	$vbulletin->input->clean_array_gpc('r', array(
		'ack' => TYPE_INT,
		'verify' => TYPE_INT
	));
	if($vbulletin->GPC['ack'] != 1)
	{
		define('CP_REDIRECT', 'admin_warn.php?do=viewlogs');
		print_stop_message('aws_warnings_npruned');
	} 
	if ($vbulletin->GPC['ack'] == 1)
	{
		define('CP_REDIRECT', 'admin_warn.php?do=manageoptions');
		print_stop_message('aws_warnings_npruned');
	}
}
//#####################################################################################################################################
if($_POST['do'] == "do_prune_confirm")
{
	$vbulletin->input->clean_array_gpc('r', array(
		'verify' => TYPE_INT
	));
	if($vbulletin->GPC['verify'] == '')
	{
		define('CP_REDIRECT', 'admin_warn.php?do=viewlogs');
		print_stop_message('aws_warnings_npruned');
	}
	if($vbulletin->GPC['verify'] == '1')
	{
		$vbulletin->input->clean_gpc('r', 'days', TYPE_INT);
		$days = $vbulletin->GPC['days'];
		$limit = time() - $days * 24 * 60 * 60;

		$warns = $db->query("SELECT w.warned_post, w.warned_user, u.warns FROM " . TABLE_PREFIX . "warnings w 
			LEFT JOIN " . TABLE_PREFIX . "user u ON(u.userid = w.warned_user) 
			WHERE w.warned_status = 'I' AND w.warned_time <= $limit
		");
		while ($warn = $db->fetch_array($warns))
		{
			if($warn['warned_post'] != 0)
			{
				$wf = $db->query_first("SELECT warn_flag FROM " . TABLE_PREFIX . "post WHERE postid = '{$warn[warned_post]}'");
				$wflag = $wf['warn_flag'] - 1;
				if($wflag < 0)
				{
					$wflag = 0;
				}
				$db->query_write("UPDATE " . TABLE_PREFIX . "post SET warn_flag = '{$wflag}' WHERE postid = '{$warn[warned_post]}'");
			}
			$warnings = $warn['warns'] - 1;
			if($warnings < 0)
			{
				$warnings = 0;
			}
			$userdm=& datamanager_init('User',$vbulletin,ERRTYPE_CP);
			$userdm->set_existing($warn);
			$userdm->set('warns',$warnings);
			$userdm->save();
			unset($userdm);
		}
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "warnings WHERE warned_status = 'I' AND warned_time <= $limit");
		define('CP_REDIRECT', 'admin_warn.php?do=viewlogs');
		print_stop_message('aws_warnings_pruned');
	}
}
//#####################################################################################################################################
if($_GET['do'] == "remove")
{
	$vbulletin->input->clean_array_gpc('g',array(
		'id' => TYPE_INT,
		'wname' => TYPE_STR,
		'userid' => TYPE_INT,
		'uname' => TYPE_STR,
		'postid' => TYPE_INT,
		'orderstring' => TYPE_STR,
		'ban' => TYPE_STR,
	));
	
	$temp_wid = $vbulletin->GPC['id'];
	$temp_wname = $vbulletin->GPC['wname'];
	$temp_uid = $vbulletin->GPC['userid'];
	$temp_uname = $vbulletin->GPC['uname'];
	$temp_postid = $vbulletin->GPC['postid'];
	$temp_order = $vbulletin->GPC['orderstring'];
	$temp_ban = $vbulletin->GPC['ban'];
	
	if ($temp_ban == 'Y')
	{
		$string_ban = "<br>" . $vbphrase['aws_admin_thiswarnshascausedban'];
		$string_ban2 = $vbphrase['aws_yes'];
	}
	else
	{
		$string_ban = '';
		$string_ban2 = $vbphrase['aws_no'];
	}
	
	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
	print_form_header('admin_warn', 'do_delete');
	print_table_header($vbphrase['aws_admin_removalofawanr']);
	construct_hidden_code('form', '');
	construct_hidden_code('temp_wid', $temp_wid);
	construct_hidden_code('temp_uid', $temp_uid);
	construct_hidden_code('temp_postid', $temp_postid);
	construct_hidden_code('temp_order', $temp_order);
	construct_hidden_code('temp_ban', $temp_ban);
	print_yes_no_row($vbphrase['aws_admin_areyousuretoremwarn'] . "<p><table>
		<tr><td>" . $vbphrase['aws_warneduserid'] . "</td><td>:</td><td>$temp_uid</td></tr>
		<tr><td>" . $vbphrase['aws_admin_warnedusername'] . "</td><td>:</td><td>$temp_uname</td></tr>
		<tr><td>" . $vbphrase['aws_warningtype'] . "</td><td>:</td><td>$temp_wname</td></tr>
		<tr><td>" . $vbphrase['aws_admin_postid'] . "</td><td>:</td><td>$temp_postid</td></tr>
		<tr><td>" . $vbphrase['aws_caused_ban'] . "</td><td>:</td><td>$string_ban2</td></tr>
		<tr><td colspan='3'>$string_ban</td></tr>
		</table><P><U><b>" . $vbphrase['aws_admin_caution'] . ":</b></U> " . $vbphrase['aws_admin_thiscannotbeundone'], 'verify','');
	print_submit_row($vbphrase['aws_admin_proceed'], 0);
}
//#####################################################################################################################################
if($_POST['do'] == "do_delete")
{
	$vbulletin->input->clean_array_gpc('p', array(
		'temp_wid' => TYPE_INT,
		'temp_wname' => TYPE_STR,
		'temp_uid' => TYPE_INT,
		'temp_uname' => TYPE_STR,
		'temp_postid' => TYPE_INT,
		'temp_order' => TYPE_STR,
		'ban' => TYPE_STR,
		'verify' => TYPE_INT,
	));
	
	if(($vbulletin->GPC['verify'] == '' OR $vbulletin->GPC['verify'] == 0))
	{
		$order = $vbulletin->GPC['temp_order'];
		if (!$order == '')
		{
			$rstring = "admin_warn.php?do=viewlogs&order=$order";
		}
		else
		{
			$rstring = "admin_warn.php?do=do_finduserwarnings&userid=$vbulletin->GPC[temp_uid]";
		}
		
		define('CP_REDIRECT',$rstring);
		print_stop_message('aws_warning_nremoved');
	}
	if($vbulletin->GPC['verify'] == 1)
	{
		if(!$warn = $db->query_first("SELECT w.*, wt.*, u.* FROM " . TABLE_PREFIX . "warnings w 
		LEFT JOIN " . TABLE_PREFIX . "warningtype wt ON(wt.warningtypeid = w.warned_warning_id) 
		LEFT JOIN " . TABLE_PREFIX . "user u ON(u.userid = w.warned_user) WHERE w.wid = '{$vbulletin->GPC['temp_wid']}'"))
		{
			echo ($vbphrase['aws_warnnotfoundinbd']);
			$order = $vbulletin->GPC['temp_order'];
			$rstring = "admin_warn.php?do=viewlogs&order=$order";
			define('CP_REDIRECT', $rstring);
			print_stop_message('aws_warnings_npruned');
		}

		$level = $warn['warning_level'] - $warn['warn_points'];
		if ($level < 1)
		{
			$level = 0;
		}

		$warnings = $warn['warns'] - 1;
		if ($warnings < 1)
		{
			$warnings = 0;
		}

		if ($warn['warned_status'] != 'L')
		{
			$userdm=& datamanager_init('User',$vbulletin,ERRTYPE_CP);
			$userdm->set_existing($warn);
			$userdm->set('warns',$warnings);
			$userdm->set('warning_level',$level);
			$userdm->save();
			unset($userdm);
		}

		if ($vbulletin->options['warn_historical'] == 0)
		{
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "warnings WHERE wid = $warn[wid]");
		}
		else
		{
			$r = $vbulletin->userinfo['userid'];
			$t = time();
			$db->query_write("UPDATE " . TABLE_PREFIX . "warnings SET warned_status = 'I', removed_by = '{$r}', removed_date = '{$t}' WHERE wid = $warn[wid]");
		}

		$aws_phrase = build_aws_language($warn['userid']);

		if ($warn['warned_post'] != 0)
		{
			$wf = $db->query_read("SELECT warn_flag FROM " . TABLE_PREFIX . "post WHERE postid = $warn[warned_post]");
			$wflag = $wf['warn_flag'] - 1;
			if ($wflag < 0)
			{
				$wflag = 0;
			}
			$db->query_write("UPDATE " . TABLE_PREFIX . "post SET warn_flag = '{$wflag}' WHERE postid = '{$warn['warned_post']}'");
			$thread1 = "[URL='{$vbulletin->options['bburl']}/showthread.php?p={$warn['warned_post']}']" . $aws_phrase['aws_message_warnedpost'] . "[/URL]";
			$thread2 = "{$vbulletin->options['bburl']}/showthread.php?p={$warn['warned_post']}";
		}
		else
		{
			$thread1 = $aws_phrase['aws_message_nopostrelated'];
			$thread2 = $aws_phrase['aws_message_nopostrelated'];
		}
		$user = array_merge((array)$user,convert_bits_to_array($user['options'],$vbulletin->bf_misc_useroptions));
		$perms = fetch_permissions(0,$user['userid'],$user);
		if($user['options'] & $vbulletin->bf_misc_useroptions['receivepm'])
		{
			$donotpmhim = 0;
		}
		else
		{
			$donotpmhim = 1;
		}
		if ($vbulletin->options['warn_send_pm_warning'] == 1 OR $vbulletin->options['warn_send_em_warning'] == 1 AND $donotpmhim = 0)
		{
			if ($warn['warn_points'] == 1)
			{
				$tempWarnPoints = $aws_phrase['aws_message_point1'];
			}
			else
			{
				$tempWarnPoints = $aws_phrase['aws_message_point2'];
			}
			if ($level == 1)
			{
				$tempWarnLevel = $aws_phrase['aws_message_point1'];
			}
			else
			{
				$tempWarnLevel = $aws_phrase['aws_message_point2'];
			}
		}

		if ($vbulletin->options['warn_send_pm_warning'] == 1 AND $donotpmhim = 1)
		{
			$messageb = $aws_phrase['aws_message_dear'] . ' ' . $warn['username'] . ',
			
			' . construct_phrase($aws_phrase['aws_message_warn_you_recived_was_removed'], $vbulletin->options['bbtitle']) . ' ' . $aws_phrase['aws_message_removed_warning_concerned'] . '

			[b][i] ' . $warn['warn_desc'] . ' [/i][/b]
			(' . $aws_phrase['aws_message_warningtype'] . ' - "' . $warn['title'] . '") 
			
			' . $aws_phrase['aws_message_post_for_which_you_were_warned'] . '
			
			' . $thread1 . '
			
			' . $aws_phrase['aws_message_with_warning_removing'] . ' [b] ' . $warn['warn_points'] . ' ' . $tempWarnPoints . ' [/b] ' . $aws_phrase['aws_message_have_been_removed_from_you_total'] . '
			
			' . $aws_phrase['aws_message_your_warning_level_now'] . ' [b] ' . $level . ' ' . $tempWarnLevel . ' [/b].
			
			' . $aws_phrase['aws_message_please_reply_back'] . '

			----------------

			' . construct_phrase($aws_phrase['aws_message_administration'], $vbulletin->options['bbtitle']);

			$title = $aws_phrase['aws_message_warnhasbeenrem'];

			$recipients = $warn['username'];
			if($vbulletin->options['warn_warner'] == 0)
			{
				$fromuserid = $vbulletin->userinfo['userid'];
				$fromusername = $vbulletin->userinfo['username'];
			}
			else
			{
				$fromuserid = $vbulletin->options['warn_warner'];
				$fromusername = $vbulletin->options['warn_username'];
			}
			SendPMAwsAdmincp($fromuserid, $fromusername, $title,$messageb, $recipients);
			$message = $vbphrase['aws_warnremovedsecc'] . " {$warn['username']} " . $vbphrase['aws_haspm'] . $vbphrase['aws_takingyouback'];
		}
		if($vbulletin->options['warn_send_em_warning'] == 1)
		{
			$messageb = $aws_phrase['aws_message_dear'] . ' ' . $warn['username'] . ',
			
			' . construct_phrase($aws_phrase['aws_message_warn_you_recived_was_removed'], $vbulletin->options['bbtitle']) . ' ' . $aws_phrase['aws_message_removed_warning_concerned'] . '
			
			' . $warn['warn_desc'] . '
			(' . $aws_phrase['aws_message_warningtype'] . ' - "' . $warn['title'] . '") 
			
			' . $aws_phrase['aws_message_post_for_which_you_were_warned'] . '
			
			' . $thread2 . '
			
			' . $aws_phrase['aws_message_with_warning_removing'] . ' ' . $warn['warn_points'] . ' ' . $tempWarnPoints . ' ' . $aws_phrase['aws_message_have_been_removed_from_you_total'] . '
			
			' . $aws_phrase['aws_message_your_warning_level_now'] . ' ' . $level . ' ' . $tempWarnLevel . '.
			
			' . $aws_phrase['aws_message_please_reply_back'] . '
			
			----------------
			
			' . construct_phrase($aws_phrase['aws_message_administration'], $vbulletin->options['bbtitle']);
			
			$title = "{$vbulletin->options['messagetag']} - " . $aws_phrase['aws_message_warnhasbeenrem'];

			$to = $warn['userid'];
			if($vbulletin->options['warn_warner'] == 0)
			{
				$fromemail = $vbulletin->userinfo['email'];
				$fromname = $vbulletin->userinfo['username'];
			}elseif($vbulletin->options['warn_mailfrom'] == 1 AND $vbulletin->options['warn_mailfromaddress'] !='')
			{
				$fromemail = $vbulletin->options['warn_mailfromaddress'];
			}
			else
			{
				$warnerdata = $db->query_read("SELECT username, email FROM " . TABLE_PREFIX . "user WHERE userid = '{$vbulletin->options['warn_warner']}'");
				$fromemail = $warnerdata['email'];
				$fromname = $warnerdata['username'];
			}
			vbmail($warn['email'], $title, $messageb, false, $fromemail, '', $fromname);
			$message = $vbphrase['aws_warnremovedsecc'] . " {$warn['username']} " . $vbphrase['aws_hasemail'] . $vbphrase['aws_takingyouback'];
		}
		if($vbulletin->options['warn_send_em_warning'] == 0 AND $vbulletin->options['warn_send_pm_warning'] == 0)
		{
			$message = $vbphrase['aws_admin_warnalertremsecc'] . ", {$warn['username']} " . $vbphrase['aws_hasnotpmoremail'] . $vbphrase['aws_takingyouback'];
		}
		if($vbulletin->options['warn_send_em_warning'] == 1 AND $vbulletin->options['warn_send_pm_warning'] == 1)
		{
			$message = $vbphrase['aws_admin_warnalertremsecc'] . ", {$warn['username']} " . $vbphrase['aws_haspmandemail'] . $vbphrase['aws_takingyouback'];
		}
		$order = $vbulletin->GPC['temp_order'];
		if (!$order == '')
		{
			$rstring = "admin_warn.php?do=viewlogs&order=$order";
		}
		else
		{
			$rstring = "admin_warn.php?do=do_finduserwarnings&userid=$vbulletin->GPC[temp_uid]";
		}
		
		define('CP_REDIRECT',$rstring);
		print_stop_message('aws_warning_premoved');
	}
}
//#####################################################################################################################################
if($_GET['do'] == "completeremove")
{
	$vbulletin->input->clean_array_gpc('g', array(
		'id' => TYPE_INT,
		'wname' => TYPE_STR,
		'userid' => TYPE_INT,
		'uname' => TYPE_STR,
		'postid' => TYPE_INT,
		'ban' => TYPE_STR,
		'orderstring' => TYPE_STR,
	));
	
	$temp_wid = $vbulletin->GPC['id'];
	$temp_wname = $vbulletin->GPC['wname'];
	$temp_uid = $vbulletin->GPC['userid'];
	$temp_uname = $vbulletin->GPC['uname'];
	$temp_postid = $vbulletin->GPC['postid'];
	$temp_ban = $vbulletin->GPC['ban'];
	$temp_order = $vbulletin->GPC['orderstring'];

	if ($temp_ban == 'Y')
	{
		$string_ban = "<br>" . $vbphrase['aws_admin_thiswarncausedban'];
		$string_ban2 = $vbphrase['aws_yes'];
	}
	else
	{
		$string_ban = '';
		$string_ban2 = $vbphrase['aws_no'];
	}
	
	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
	print_form_header('admin_warn', 'do_completedelete');
	print_table_header($vbphrase['aws_admin_compremwarn']);
	construct_hidden_code('form','');
	construct_hidden_code('temp_wid', $temp_wid);
	construct_hidden_code('temp_uid', $temp_uid);
	construct_hidden_code('temp_postid', $temp_postid);
	construct_hidden_code('temp_order', $temp_order);
	construct_hidden_code('temp_ban', $temp_ban);
	print_yes_no_row($vbphrase['aws_admin_areyousuretocomplremwarn'] . "<p><table>
		<tr><td>" . $vbphrase['aws_warneduserid'] . "</td><td>:</td><td>$temp_uid</td></tr>
		<tr><td>" . $vbphrase['aws_admin_warnedusername'] . "</td><td>:</td><td>$temp_uname</td></tr>
		<tr><td>" . $vbphrase['aws_warningtype'] . "</td><td>:</td><td>$temp_wname</td></tr>
		<tr><td>" . $vbphrase['aws_admin_postid'] . "</td><td>:</td><td>$temp_postid</td></tr>
		<tr><td>" . $vbphrase['aws_caused_ban'] . "</td><td>:</td><td>$string_ban2</td></tr>
		<tr><td colspan='3'>$string_ban</td></tr>
		</table><P><U><b>" . $vbphrase['aws_admin_caution'] . ":</b></U> " . $vbphrase['aws_admin_thiscannotbeundone'], 'verify','');
	print_submit_row($vbphrase['aws_admin_proceed'], 0);
}
//#####################################################################################################################################
if($_POST['do'] == "do_completedelete")
{
	$vbulletin->input->clean_array_gpc('p', array(
		'temp_wid' => TYPE_INT,
		'temp_wname' => TYPE_STR,
		'temp_uid' => TYPE_INT,
		'temp_uname' => TYPE_STR,
		'temp_postid' => TYPE_INT,
		'temp_order' => TYPE_STR,
		'ban' => TYPE_STR,
		'verify' => TYPE_INT,
	));
	
	if(($vbulletin->GPC['verify'] == '' OR $vbulletin->GPC['verify'] == 0))
	{
		$order = $vbulletin->GPC['temp_order'];
	
		if(!$order == '')
		{
			$rstring = "admin_warn.php?do=viewlogs&order=$order";
		}
		else
		{
			$rstring = "admin_warn.php?do=do_finduserwarnings&userid=$vbulletin->GPC[temp_uid]";
		}
		
		define('CP_REDIRECT', $rstring);
	
		print_stop_message('aws_warning_nremoved');
	}
	if($vbulletin->GPC['verify'] == 1)
	{
		$order = $vbulletin->GPC['temp_order'];
		if (!$warn = $db->query_first("SELECT w.*, wt.*, u.* FROM " . TABLE_PREFIX . "warnings w 
			LEFT JOIN " . TABLE_PREFIX . "warningtype wt ON(wt.warningtypeid = w.warned_warning_id) 
			LEFT JOIN " . TABLE_PREFIX . "user u ON(u.userid = w.warned_user) WHERE w.wid = '{$vbulletin->GPC['temp_wid']}'"))
		{
			echo ($vbphrase['aws_warnnotfoundinbd']);
			$rstring = "admin_warn.php?do=viewlogs&order=$order";
			define('CP_REDIRECT', $rstring);
			print_stop_message('aws_warnings_npruned');
		}

		$aws_phrase = build_aws_language($warn['userid']);

		if ($warn['warned_status'] != 'L')
		{
			if ($warn['warns'] <= 0)
			{
				$warnings = 0;
			}
			else
			{
				$warnings = $warn['warns'] - 1;
			}
		
			if ($warn['caused_ban'] == "Y")
			{
				$bans = $warn['warning_bans'] - 1;
				if ($bans < 0)
				{
					$bans = 0;
				}
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "ban_dates WHERE banned_warning = $warn[wid]");
			}
			else
			{
				$bans = $warn['warning_bans'];
			}

			if($warn['warned_status'] == 'A')
			{
				$level = $warn['warning_level'] - $warn['warn_points'];
			}
			elseif($warn['warned_status'] == 'I')
			{
				$level = $warn['warning_level'];
			}

			$level = (int)$level;
			if($level < 1){$level = 0;}
			$userdm=& datamanager_init('User',$vbulletin,ERRTYPE_CP);
			$userdm->set_existing($warn);
			$userdm->set('warns',$warnings);
			$userdm->set('warning_level',$level);
			$userdm->set('warning_bans',$bans);
			$userdm->save();
			unset($userdm);
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "warnings WHERE wid = $warn[wid]");

			if ($warn['title'] == $vbphrase['aws_obscenewordsinchat'])
			{
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "vbchat_store_warned WHERE sid = '{$warn['warned_reason']}'");
			}
			
			if ($warn['title'] == $vbphrase['aws_obscenewords'] AND $warn['warned_post'] == 0)
			{
				$intcode = str_replace($vbphrase['aws_automaticwarning'] . " " . $vbphrase['aws_itc'] . " ", "", $warn['warned_reason']);
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "pmtext_warned WHERE pmtextid = '{$intcode}'");
			}

			if ($warn['warned_post'] != 0)
			{
				$wf = $db->query_first("SELECT warn_flag FROM " . TABLE_PREFIX . "post WHERE postid = '{$warn[warned_post]}'");
				$wflag = $wf['warn_flag'] - 1;
				if ($wflag < 0)
				{
					$wflag = 0;
				}
				$db->query_write("UPDATE " . TABLE_PREFIX . "post SET warn_flag = '{$wflag}' WHERE postid = '{$warn[warned_post]}'");
				$thread1 = "[URL='{$vbulletin->options['bburl']}/showthread.php?p={$warn['warned_post']}']" . $aws_phrase['aws_message_warnedpost'] . "[/URL]";
				$thread2 = "{$vbulletin->options['bburl']}/showthread.php?p={$warn['warned_post']}";
			}
			else
			{
				$thread1 = $aws_phrase['aws_message_nopostrelated'];
				$thread2 = $aws_phrase['aws_message_nopostrelated'];
			}
		}
		else
		{
			if ($warn['alerts'] <= 0)
			{
				$alerts = 0;
			}
			else
			{
				$alerts = $warn['alerts'] - 1;
			}
			if ($warn['warned_post'] != 0)
			{
				$thread1 = "[URL='{$vbulletin->options['bburl']}/showthread.php?p={$warn['warned_post']}']" . $aws_phrase['aws_message_warnedpost'] . "[/URL]";
				$thread2 = "{$vbulletin->options['bburl']}/showthread.php?p={$warn['warned_post']}";
			}
			else
			{
				$thread1 = $aws_phrase['aws_message_nopostrelated'];
				$thread2 = $aws_phrase['aws_message_nopostrelated'];
			}
			$userdm=& datamanager_init('User',$vbulletin,ERRTYPE_CP);
			$userdm->set_existing($warn);
			$userdm->set('alerts',$alerts);
			$userdm->save();
			unset($userdm);
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "warnings WHERE wid = $warn[wid]");
		}
		$user = array_merge((array)$user,convert_bits_to_array($user['options'],$vbulletin->bf_misc_useroptions));
		$perms = fetch_permissions(0,$user['userid'],$user);
		if($user['options'] & $vbulletin->bf_misc_useroptions['receivepm'])
		{
			$donotpmhim = 0;
		}
		else
		{
			$donotpmhim = 1;
		}
		if ($vbulletin->options['warn_send_pm_warning'] == 1 OR $vbulletin->options['warn_send_em_warning'] == 1 OR $donotpmhim = 0)
		{
			if ($warn['warned_status'] != 'L')
			{
				if ($warn['warn_points'] == 1)
				{
					$tempWarnPoints = $aws_phrase['aws_message_point1'];
				}
				else
				{
					$tempWarnPoints = $aws_phrase['aws_message_point2'];
				}
				if ($level == 1)
				{
					$tempWarnLevel = $aws_phrase['aws_message_point1'];
				}
				else
				{
					$tempWarnLevel = $aws_phrase['aws_message_point2'];
				}
			}
		}
		if ($vbulletin->options['warn_send_pm_warning'] == 1 AND $donotpmhim = 1)
		{
			if ($warn['warned_status'] != 'L')
			{
				$messageb = $aws_phrase['aws_message_dear'] . ' ' . $warn['username'] . ',
				
				' . construct_phrase($aws_phrase['aws_message_warn_you_recived_was_removed'], $vbulletin->options['bbtitle']) . ' ' . $aws_phrase['aws_message_removed_warning_concerned'] . '
				
				[b][i] ' . $warn['warn_desc'] . ' [/i][/b]
				(' . $aws_phrase['aws_message_warningtype'] . ' - "' . $warn['title'] . '") 
				
				' . $aws_phrase['aws_message_post_for_which_you_were_warned'] . '
				
				' . $thread1 . '
				
				' . $aws_phrase['aws_message_with_warning_removing'] . ' [b] ' . $warn['warn_points'] . ' ' . $tempWarnPoints . ' [/b] ' . $aws_phrase['aws_message_have_been_removed_from_you_total'] . '
				
				' . $aws_phrase['aws_message_your_warning_level_now'] . ' [b] ' . $level . ' ' . $tempWarnLevel . ' [/b].
				
				' . $aws_phrase['aws_message_please_reply_back'] . '

				----------------

				' . construct_phrase($aws_phrase['aws_message_administration'], $vbulletin->options['bbtitle']);

				$title = $aws_phrase['aws_message_warnhasbeenrem'];
			}
			else
			{
				$messageb = $aws_phrase['aws_message_dear'] . ' ' . $warn['username'] . ',

				' . construct_phrase($aws_phrase['aws_message_alert_you_recived_was_removed'], $vbulletin->options['bbtitle']) . ' ' . $aws_phrase['aws_message_removed_alert_concerned'] . '
				
				[b][i] ' . $warn['warn_desc'] . ' [/i][/b]
				(' . $aws_phrase['aws_message_warningtype'] . ' - "' . $warn['title'] . '") 
				
				' . $aws_phrase['aws_message_post_for_which_you_were_alerted'] . '

				' . $thread1 . '

				' . $aws_phrase['aws_message_kind_regards'] . '

				----------------

				' . construct_phrase($aws_phrase['aws_message_administration'], $vbulletin->options['bbtitle']);

				$title = $aws_phrase['aws_message_alerthasbeenrem'];
			}

			$recipients = $warn['username'];
			if($vbulletin->options['warn_warner'] == 0)
			{
				$fromuserid = $vbulletin->userinfo['userid'];
				$fromusername = $vbulletin->userinfo['username'];
			}
			else
			{
				$fromuserid = $vbulletin->options['warn_warner'];
				$fromusername = $vbulletin->options['warn_username'];
			}
			SendPMAwsAdmincp($fromuserid, $fromusername, $title,$messageb,$recipients);
			$message = $vbphrase['aws_warnremovedsecc'] . " {$warn['username']} " . $vbphrase['aws_haspm'] . " " . $vbphrase['aws_takingyouback'];
		}

		if($vbulletin->options['warn_send_em_warning'] == 1)
		{
			if ($warn['warned_status'] != 'L')
			{
				$messageb = $aws_phrase['aws_message_dear'] . ' ' . $warn['username'] . ',

				' . construct_phrase($aws_phrase['aws_message_warn_you_recived_was_removed'], $vbulletin->options['bbtitle']) . ' ' . $aws_phrase['aws_message_removed_warning_concerned'] . '

				' . $warn['warn_desc'] . '
				(' . $aws_phrase['aws_message_warningtype'] . ' - "' . $warn['title'] . '") 

				 ' . $aws_phrase['aws_message_post_for_which_you_were_warned'] . '

				' . $thread2 . '

				' . $aws_phrase['aws_message_with_warning_removing'] . ' ' . $warn['warn_points'] . ' ' . $tempWarnPoints . ' ' . $aws_phrase['aws_message_have_been_removed_from_you_total'] . '

				' . $aws_phrase['aws_message_your_warning_level_now'] . ' ' . $level . ' ' . $tempWarnLevel . '.

				' . $aws_phrase['aws_message_please_reply_back'] . '

				----------------

				' . construct_phrase($aws_phrase['aws_message_administration'], $vbulletin->options['bbtitle']);

				$title = "{$vbulletin->options['messagetag']} - " . $aws_phrase['aws_message_warnhasbeenrem'];
			}
			else
			{
				$messageb = $aws_phrase['aws_message_dear'] . ' ' . $warn['username'] . ',

				' . construct_phrase($aws_phrase['aws_message_alert_you_recived_was_removed'], $vbulletin->options['bbtitle']) . ' ' . $aws_phrase['aws_message_removed_alert_concerned'] . ' 

				' . $warn['warn_desc'] . '
				(' . $aws_phrase['aws_message_warningtype'] . ' - "' . $warn['title'] . '") 

				' . $aws_phrase['aws_message_post_for_which_you_were_alerted'] . '

				' . $thread2 . '

				' . $aws_phrase['aws_message_kind_regards'] . '

				----------------

				' . construct_phrase($aws_phrase['aws_message_administration'], $vbulletin->options['bbtitle']);

				$title = "{$vbulletin->options['messagetag']} - " . $aws_phrase['aws_message_alerthasbeenrem'];
			}
			$to = $warn['userid'];
			if($vbulletin->options['warn_warner'] == 0)
			{
				$fromemail = $vbulletin->userinfo['email'];
				$fromname = $vbulletin->userinfo['username'];
			}elseif($vbulletin->options['warn_mailfrom'] == 1 AND $vbulletin->options['warn_mailfromaddress'] !='')
			{
				$fromemail = $vbulletin->options['warn_mailfromaddress'];
			}
			else
			{
				$warnerdata = $db->query_first("SELECT username, email FROM " . TABLE_PREFIX . "user WHERE userid = '{$vbulletin->options['warn_warner']}'");
				$fromemail = $warnerdata['email'];
				$fromname = $warnerdata['username'];
			}
			vbmail($warn['email'], $title, $messageb, false, $fromemail, '', $fromname);
			$message = $vbphrase['aws_warnremovedsecc'] . " {$warn['username']} " . $vbphrase['aws_hasemail'] . " " . $vbphrase['aws_takingyouback'];
		}
		if($vbulletin->options['warn_send_em_warning'] == 0 AND $vbulletin->options['warn_send_pm_warning'] == 0)
		{
			$message = $vbphrase['aws_warnremovedsecc'] . " {$warn['username']} " . $vbphrase['aws_hasnotpmoremail'] . " " . $vbphrase['aws_takingyouback'];
		}
		if($vbulletin->options['warn_send_em_warning'] == 1 AND $vbulletin->options['warn_send_pm_warning'] == 1)
		{
			$message = $vbphrase['aws_warnremovedsecc'] . " {$warn['username']} " . $vbphrase['aws_haspmandemail'] . " " . $vbphrase['aws_takingyouback'];
		}
		$order = $vbulletin->GPC['temp_order'];
		if (!$order == '')
		{
			$rstring = "admin_warn.php?do=viewlogs&order=$order";
		}
		else
		{
			$rstring = "admin_warn.php?do=do_finduserwarnings&userid=$vbulletin->GPC[temp_uid]";
		}
	
		define('CP_REDIRECT', $rstring);
		print_stop_message('aws_warning_removed');

	}
}
//#####################################################################################################################################
if($_GET['do'] == "viewbannedusers")
{
	function construct_banned_user_row($user)
	{
		global $vbulletin, $vbphrase, $admincpdir;

		if ($user['liftdate'] == 0)
		{
			$user['banperiod'] = $vbphrase['aws_permanent'];
			$user['banlift'] = $vbphrase['aws_never'];
			$user['banremaining'] = $vbphrase['aws_forever'];
		}
		else
		{
			$user['banlift'] = vbdate($vbulletin->options['dateformat'] . ', ~' . $vbulletin->options['timeformat'], $user['liftdate']);
			$user['banperiod'] = ceil(($user['liftdate'] - $user['bandate']) / 86400);
			
			if ($user['banperiod'] == 1)
			{
				$banperiod_word = $vbphrase['aws_day1'];
			}
			else
			{
				$banperiod_word = $vbphrase['aws_day3'];
			}

			$user['banperiod'] .= " " . $banperiod_word;

			$remain = $user['liftdate'] - TIMENOW;

			$remain_days = floor($remain / 86400);
			$remain_hours = ceil(($remain - ($remain_days * 86400)) / 3600);

			if ($remain_hours == 24)
			{
				$remain_days += 1;
				$remain_hours = 0;
			}

			if ($remain < 0)
			{
				$user['banremaining'] = "<i>$vbphrase[aws_lifted]</i>";
			}
			else
			{
				if ($remain_days < 0)
				{
					$user['banremaining'] = "<i>$vbphrase[aws_will_be_lifted_soon]</i>";
				}
				else
				{
					if ($remain_days == 1)
					{
						$day_word = $vbphrase['aws_day1'];
					}
					else
					{
						$day_word = $vbphrase['aws_day2'];
					}
					if ($remain_hours == 1)
					{
						$hour_word = $vbphrase['aws_hour1'];
					}
					else
					{
						$hour_word = $vbphrase['aws_hour2'];
					}
					$user['banremaining'] = "$remain_days $day_word, $remain_hours $hour_word";
				}
			}
		}
		$cell = array("<a href=\"" . iif(($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']), '../' . $admincpdir . '/') . "user.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&amp;u=$user[userid]\"><b>$user[username]</b></a>");
		if ($user['bandate'])
		{
			$cell[] = iif($user['adminid'], "<a href=\"" . iif(($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']), '../' . $admincpdir . '/') . "user.php?" . $vbulletin->session->vars['sessionurl'] . "do=edit&amp;u=$user[adminid]\">$user[adminname]</a>", $vbphrase['aws_n_a']);
			$cell[] = vbdate($vbulletin->options['dateformat'], $user['bandate']);
		}
		else
		{
			$cell[] = $vbphrase['aws_n_a'];
			$cell[] = $vbphrase['aws_n_a'];
		}
		$cell[] = $user['banperiod'];
		$cell[] = $user['banlift'];
		$cell[] = $user['banremaining'];
		$cell[] = $user['reason'];
		if (($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']) OR can_moderate(0, 'canunbanusers'))
		{
			$cell[] = construct_link_code($vbphrase['aws_admin_unbanuser_do'], "admin_warn.php?$session[sessionurl]do=liftban&amp;userid=$user[userid]");
		}
		return $cell;
	}

	$phrasegroups = array('banning', 'cpuser');
	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");

	$querygroups = array();

	foreach ($vbulletin->usergroupcache AS $usergroupid => $usergroup)
	{
		if (!($usergroup['genericoptions'] & $vbulletin->bf_ugp_genericoptions['isnotbannedgroup']))
		{
			$querygroups["$usergroupid"] = $usergroup['title'];
		}
	}
	if (empty($querygroups))
	{
		print_stop_message('no_groups_defined_as_banned');
	}

	$getusers = $db->query_read("
		SELECT user.userid, user.username, user.usergroupid AS busergroupid,
		userban.usergroupid AS ousergroupid, userban.reason AS reason,
		IF(userban.displaygroupid = 0, userban.usergroupid, userban.displaygroupid) AS odisplaygroupid,
		bandate, liftdate,
		adminuser.userid AS adminid, adminuser.username AS adminname
		FROM " . TABLE_PREFIX . "user AS user
		LEFT JOIN " . TABLE_PREFIX . "userban AS userban ON(userban.userid = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS adminuser ON(adminuser.userid = userban.adminid)
		WHERE user.usergroupid IN(" . implode(',', array_keys($querygroups)) . ")
		ORDER BY userban.liftdate ASC, user.username
	");
	if ($db->num_rows($getusers))
	{
		$users = array();
		while ($user = $db->fetch_array($getusers))
		{
			$temporary = iif($user['liftdate'], 1, 0);
			$users["$temporary"][] = $user;
		}
	}
	if (empty($users))
	{
		print_stop_message('no_users_matched_your_query');
	}

	$db->free_result($getusers);

	$headercell = array(
		$vbphrase['aws_admin_username'],
		$vbphrase['aws_admin_bannedby'],
		$vbphrase['aws_admin_banneddate'],
		$vbphrase['aws_admin_banperiod'],
		$vbphrase['aws_admin_banlifton'],
		$vbphrase['aws_admin_bantimeremain'],
		$vbphrase['aws_admin_banreason']
	);
	if (($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']) OR can_moderate(0, 'canunbanusers'))
	{
		$headercell[] = $vbphrase['aws_admin_unbanuser'];
	}

	print_form_header('banning', 'banuser');

	if (!empty($users[1]))
	{
		print_table_header("$vbphrase[aws_banned_users]: " . $vbphrase['aws_admin_temporary_banned'] . "<br><span class=\"normal\">$vbphrase[aws_usergroups]: " . implode(', ', $querygroups) . "</span>", 8);
		print_cells_row($headercell, 1);
		foreach ($users[1] AS $user)
		{
			print_cells_row(construct_banned_user_row($user));
		}
	}
	else
	{
		print_description_row($vbphrase['aws_admin_notempbannedusers'], 0, 8);
	}
	print_description_row($vbphrase['aws_admin_unbanuserdescr'], 0, 8, 'thead');
	
	print_description_row("<div class=\"smallfont\" align=\"center\">  </div>", 0, 8, 'thead');
		
	print_table_header("$vbphrase[aws_banned_users]: " . $vbphrase['aws_admin_permanently_banned'] . "<br><span class=\"normal\">$vbphrase[aws_usergroup]: " . implode(', ', $querygroups) . "</span>", 8);

	if (!empty($users[0]))
	{
		construct_hidden_code('period', 'PERMANENT');
		print_cells_row($headercell, 1);
		foreach ($users[0] AS $user)
		{
			print_cells_row(construct_banned_user_row($user));
		}
	}
	else
	{
		print_description_row($vbphrase['aws_admin_nopermbannedusers'], 0, 8);
	}
	print_description_row($vbphrase['aws_admin_unbanuserdescr'], 0, 8, 'thead');
	print_description_row("<div class=\"smallfont\" align=\"center\">$vbphrase[all_times_are_gmt_x_time_now_is_y]</div>", 0, 8, 'thead');
}
//#####################################################################################################################################
if($_REQUEST['do'] == "liftban")
{
	$vbulletin->input->clean_gpc('r', 'userid', TYPE_INT);
	
	if (!($vbulletin->userinfo['permissions']['adminpermissions'] & $vbulletin->bf_ugp_adminpermissions['cancontrolpanel']) AND (!can_moderate(0, 'canunbanusers')))
	{
		print_stop_message('no_permission_un_ban_users');
	}
	$userid = $vbulletin->GPC['userid'];
	
	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
	print_form_header('admin_warn', 'do_liftban');
	print_table_header($vbphrase['aws_admin_liftselectedban']);
	construct_hidden_code('usid', $userid);
	print_yes_no_row($vbphrase['aws_admin_suretounbanuser'], 'verify', '');
	print_submit_row($vbphrase['aws_admin_proceed'], 0);
}
//#####################################################################################################################################
if ($_POST['do'] == "do_liftban")
{
	$vbulletin->input->clean_gpc('r', 'verify', TYPE_INT);
	$vbulletin->input->clean_gpc('p', 'usid', TYPE_STR);
	if(($vbulletin->GPC['verify'] == '' OR $vbulletin->GPC['verify'] == 0))
	{
		define('CP_REDIRECT', "admin_warn.php?do=viewbannedusers");
		print_stop_message('aws_warning_banliftcancelled');
	}
	if($vbulletin->GPC['verify'] == '1')
	{
		$user = $db->query_first("
			SELECT user.*,
			userban.usergroupid, userban.displaygroupid, userban.customtitle, userban.usertitle,
			IF(userban.userid, 1, 0) AS banrecord,
			IF(usergroup.genericoptions & " . $vbulletin->bf_ugp_genericoptions['isnotbannedgroup'] . ", 0, 1) AS isnotbannedgroup
			FROM " . TABLE_PREFIX . "user AS user
			INNER JOIN " . TABLE_PREFIX . "usergroup AS usergroup ON(usergroup.usergroupid = user.usergroupid)
			LEFT JOIN " . TABLE_PREFIX . "userban AS userban ON(userban.userid = user.userid)
			WHERE user.userid = " . $vbulletin->GPC['usid'] . "
		");
	
		if(!$user OR !$user['isnotbannedgroup'])
		{
			print_stop_message('aws_invalid_user_specified');
		}
			
		$getusergroupid = iif($user['displaygroupid'], $user['displaygroupid'], $user['usergroupid']);
		if (!$getusergroupid)
		{
			$getusergroupid = 2;
		}
	
		$usergroup = $usergroupcache["$getusergroupid"];
		if ($user['customtitle'])
		{
			$usertitle = $user['usertitle'];
		}
		elseif (!$usergroup['usertitle'])
		{
			$gettitle = $db->query_first("
				SELECT title
				FROM " . TABLE_PREFIX . "usertitle
				WHERE minposts <= $user[posts]
				ORDER BY minposts DESC
			");
			$usertitle = $gettitle['title'];
		}
		else
		{
			$usertitle = $usergroup['usertitle'];
		}
	
		$dotitle = 'usertitle = \'' . addslashes($usertitle) . '\',';
	
		if ($user['banrecord'])
		{
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "user
				SET	$dotitle
					usergroupid = $user[usergroupid],
					displaygroupid = $user[displaygroupid],
					customtitle = $user[customtitle]
				WHERE userid = $user[userid]
			");
			$db->query_write("
				DELETE FROM " . TABLE_PREFIX . "userban
				WHERE userid = $user[userid]
			");
		}
		else
		{
			if ($vbulletin->options['warn_restore_groupid'] == '' OR $vbulletin->options['warn_restore_groupid'] == 0)
			{
				$ugid = 2;
			}
			else
			{
				$ugid = $vbulletin->options['warn_restore_groupid'];
			}
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "user SET
				$dotitle
				usergroupid = $ugid,
				displaygroupid = 0
				WHERE userid = $user[userid]
			");
		}
		define('CP_REDIRECT', "admin_warn.php?do=viewbannedusers");
		print_stop_message('lifted_ban_on_user_x_successfully', "<b>$user[username]</b>");
	}
}
//#####################################################################################################################################
if($_GET['do'] == "viewbans")
{
	$vbulletin->input->clean_array_gpc('r',array(
		'script'     => TYPE_STR,
		'page'       => TYPE_INT,
		'perpage'    => TYPE_INT,
		'orderby'    => TYPE_INT,
		'do'         => TYPE_STR
	));
	$perpage = $vbulletin->options['warn_warnings_per_page'];
	if ($perpage=='' OR $perpage==0)
	{
		$perpage = 15;
	}
	if ($page < 1)
	{
		$page = 1;
	}
	$startat = ($page - 1) * $perpage;
	$counter=$db->query_first("SELECT COUNT(*) AS bans FROM " . TABLE_PREFIX . "ban_dates AS ban");
	$totalpages = ceil($counter['bans'] / $perpage);
	$orderby='b.banned_user, b.banned_ban';
	$get_bans=$db->query_read("SELECT b.*, u.*, a.username AS warner, w.*, wt.*  from ".TABLE_PREFIX."ban_dates as b
	LEFT JOIN " . TABLE_PREFIX . "user AS u ON(u.userid = b.banned_user) 
	LEFT JOIN " . TABLE_PREFIX . "user AS a ON(a.userid = b.banned_by) 
	LEFT JOIN " . TABLE_PREFIX . "warnings AS w ON(w.wid = b.banned_warning)
	LEFT JOIN " . TABLE_PREFIX . "warningtype AS wt ON(wt.warningtypeid = w.warned_warning_id)
	ORDER BY $orderby LIMIT $startat, $perpage");
	if ($db->num_rows($get_bans))
	{
		if ($page != 1)
		{
			$prv = $page - 1;
			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['aws_first_page'] .
							"\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?" . $vbulletin->session->vars['sessionurl'] .
							"do=viewbans&script=" . $vbulletin->GPC['script'] .
							"&perpage=" . $vbulletin->GPC['perpage'] .
							"&orderby=" . $vbulletin->GPC['orderby'] .
							"&page=1'\">";

			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['aws_prev_page'] .
						"\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?" . $vbulletin->session->vars['sessionurl'] .
						"do=viewbans&script=" . $vbulletin->GPC['script'] .
						"&perpage=" . $vbulletin->GPC['perpage'] .
						"&orderby=" . $vbulletin->GPC['orderby'] .
						"&page=$prv'\">";
		}

		if ($page != $totalpages)
		{
			$nxt = $page + 1;
			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_next_page'] .
						" &gt;\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?" .
						$vbulletin->session->vars['sessionurl'] .
						"do=viewbans&script=" . $vbulletin->GPC['script'] .
						"&perpage=" . $vbulletin->GPC['perpage'] .
						"&orderby=" . $vbulletin->GPC['orderby'] .
						"&page=$nxt'\">";
			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_last_page'] .
						" &raquo;\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?" . $vbulletin->session->vars['sessionurl'] .
						"do=view&script=" . $vbulletin->GPC['script'] .
						"&perpage=" . $vbulletin->GPC['perpage'] .
						"&orderby=" . $vbulletin->GPC['orderby'] .
						"&page=$totalpages'\">";
		}

		print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
		print_form_header('admin_warn', '');
		$aa=($page-1)*$perpage+1;
		$cc=$counter['bans'];
		if ($page<$totalpages)
		{
			$bb=$page*$perpage;
		}
		else
		{
			$bb=$counter['bans'];
		}
		print_table_header("Bans per User<br> Page $page of $totalpages<br>Records $aa to $bb of $cc",9);
		$header = array();
		$header[] = "<b>" . $vbphrase['aws_admin_banrank'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_username'] . "<br>" . $vbphrase['aws_userid'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_bannedby'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_banneddate'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_banstatus'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_warnedpost'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_warningtype'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_warningcomment'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_banreason'] . "</b>";
		print_cells_row($header, 1);
				
		while($ban=$db->fetch_array($get_bans))
		{
			$cell = array();
			
			$ban['date'] =vbdate($vbulletin->options['dateformat'],$ban['banned_dateline']);
			$ban['time'] = vbdate($vbulletin->options['timeformat'],$ban['banned_dateline']);
			$tousersstring='';
			
			$users = unserialize($pm['touserarray']);
			$tousers = array();
			if (!empty($users))
			{
				foreach ($users AS $user)
				{
					if ($tousersstring != '')
					{
						$tousersstring .= ', ';
					}
					$tousersstring .= $user;
				}
			}
			
			if ($ban['warned_post']==0 OR $ban['warned_post']=='')
			{
				$b='NPR';
			}
			else
			{
				$b="<a href='{$vbulletin->options['bburl']}/showthread.php?p=$ban[warned_post]#post$ban[warned_post]' target='_blank'>$ban[warned_post]</a>";
			}
				
			if ($ban[banned_status]=='A')
			{
				$bs="IUA (*)";
			}
			else if ($ban[banned_status]=='I')
			{
				$bs="NAUA (*)";
			}
			else if ($ban[banned_status]=='P')
			{
				$bs="Perm (*)";
			}
			
			if ($ban['banned_warning']=='999999999')
			{
				$b="N.A.";
				$bwn="N.A.";
				$bwr="N.A.";
			}
			else
			{
				$bwn=$ban['title'];
				$bwr=$ban[warned_reason];
			}
			
			
			$cell[] = "<font size='-1'>$ban[banned_ban]</font>";
			$cell[] = "<font size='-1'><a href='user.php?s=$session[sessionhash]&do=edit&userid=$ban[banned_user]' target='_blank'>$ban[username]<br>$ban[banned_user]</a></font>";
			$cell[] = "<font size='-1'>$ban[warner]</font>";
			$cell[] = "<font size='-1'>$ban[date]<br>$ban[time]</font>";
			$cell[] = "<font size='-1'>$bs</font>";
			$cell[] = "<font size='-1'>$b</font>";
			$cell[] = "<font size='-1'>$bwn</font>";
			$cell[] = "<font size='-1'>$bwr</font>";
			$cell[] = "<font size='-1'>$ban[banned_reason]</font>";

			
			print_cells_row($cell);
		}
		print_description_row("<b>Ban Status Explanation :   IUA= The ban counters in the User Account  -  NAUA= Not affecting User Account (matured ban)  -  Perm= Permanent Ban<br> N.A. : Not Available. Information retrieved in batch, from the userban table, where this columns are not available.</b>", 0,9, 'thead');
		print_description_row("<div class=\"smallfont\" align=\"center\">$vbphrase[all_times_are_gmt_x_time_now_is_y]</div>", 0, 9, 'thead');
	}
	else
	{
		print_stop_message('no_users_matched_your_query');
	}
	exit;
}
//#####################################################################################################################################
if($_GET['do'] == "viewstats1")
{
	$get_warns = $db->query_read("SELECT wt.* FROM " . TABLE_PREFIX . "warningtype wt ORDER BY wt.warningtypeid");
	
	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
	
	if ($db->num_rows($get_warns))
	{
		print_form_header('', '');
		print_table_header($vbphrase['aws_admin_warningstatistics'], 4);
		
		$header = array();
		
		$header[] = "<b>" . $vbphrase['aws_admin_warningtypeid'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_warningtype'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_warningdescription'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_numberwarnsissued'] . "</b>";
			
		print_cells_row($header, 1);
		
		while($warn=$db->fetch_array($get_warns))
		{
			$cell = array();
			$id = $warn['warningtypeid'];
			$a1 = $db->query_first("SELECT COUNT(*) AS warns FROM " . TABLE_PREFIX . "warnings WHERE warned_warning_id = $id");
			$cell[] = $warn['warningtypeid'];
			$cell[] = $warn['title'];
			$cell[] = $warn['warn_desc'];
			$cell[] = $a1['warns'];
			
			print_cells_row($cell);
			$totals = $totals + $a1['warns'];
		
		}
		print_table_footer(4, $vbphrase['aws_totalwarnsissued'] . ": $totals");
	}	
	else
	{
		print_stop_message('aws_no_warnings_found');
	}	
}	
//######################################################################################################################################
if($_GET['do'] == "viewstats2")
{
	$get_warns = $db->query_read("SELECT wt.userid, wt.username, wt.usergroupid FROM " . TABLE_PREFIX . "user wt WHERE (usergroupid = 5 OR usergroupid = 6 OR usergroupid = 7) ORDER BY userid");
	
	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
	
	if ($db->num_rows($get_warns))
	{
		print_form_header('', '');
		print_table_header($vbphrase['aws_warnstatwarnsperwarner'], 4);
		
		$header = array();
		
		$header[] = "<b>" . $vbphrase['aws_warneruserid'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_warnername'] . "</b>";
		$header[] = "<b>" . $vbphrase['usergroup'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_numberwarnsissued'] . "</b>";
			
		print_cells_row($header, 1);
		
		while($warn=$db->fetch_array($get_warns))
		{
			$cell = array();
			$id = $warn['userid'];
			if ($warn['usergroupid'] == 5)
			{
				$usergrp = $vbphrase['aws_admin_supermoder'];
			}
			elseif ($warn['usergroupid'] == 6)
			{
				$usergrp = $vbphrase['aws_admin_admin'];
			}
			elseif ($warn['usergroupid'] == 7)
			{
				$usergrp = $vbphrase['aws_admin_moder'];
			}
			
			$a1 = $db->query_first("SELECT COUNT(*) AS warns FROM " . TABLE_PREFIX . "warnings WHERE warned_by = $id");
			$cell[] = $warn['userid'];
			$cell[] = $warn['username'];
			$cell[] = $usergrp;
			$cell[] = $a1['warns'];
			
			print_cells_row($cell);
			$totals = $totals + $a1['warns'];
		}
			print_table_footer(4, $vbphrase['aws_totalwarnsissued'] . ": $totals");
	}
	else
	{
		print_stop_message('aws_no_warnings_found');
	}
}
//#####################################################################################################################################
if($_GET['do'] == "warnuser")
{
	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
	if(can_administer('canadminusers'))
	{
		print_form_header('user', 'find');
		print_table_header($vbphrase['aws_admin_warnuser']);
		print_description_row($vbphrase['aws_admin_enteruseridtowarn']);

		print_label_row($vbphrase['aws_admin_username'], '
			<form action="user.php" method="post" style="display:inline">
			<input type="hidden" name="adminhash" value="' . ADMINHASH . '" />
			<input type="hidden" name="do" value="find" />
			<input type="text" class="bginput" name="user[username]" size="30" tabindex="1" />
			<input type="submit" value="' . $vbphrase['aws_find'] . '" class="button" tabindex="1" />
			<input type="submit" class="button" value="' . $vbphrase['aws_exact_match'] . '" tabindex="1" name="user[exact]" />
			</form>
			', '', 'top', NULL, false);
		
		print_label_row($vbphrase['aws_email'], '
			<form action="user.php" method="post" style="display:inline">
			<input type="hidden" name="adminhash" value="' . ADMINHASH . '" />
			<input type="hidden" name="do" value="find" />
			<input type="text" class="bginput" name="user[email]" size="30" tabindex="1" />
			<input type="submit" value="' . $vbphrase['aws_find'] . '" class="button" tabindex="1" />
			</form>
			', '', 'top', NULL, false);
			
		print_label_row($vbphrase['aws_registration_ip_address'], '
			<form action="user.php" method="post" style="display:inline">
			<input type="hidden" name="adminhash" value="' . ADMINHASH . '" />
			<input type="hidden" name="do" value="find" />
			<input type="text" class="bginput" name="user[ipaddress]" size="30" tabindex="1" />
			<input type="submit" value="' . $vbphrase['aws_find'] . '" class="button" tabindex="1" />
			</form>
			', '', 'top', NULL, false);
	}
}
//#####################################################################################################################################
if($_GET['do'] == "warnsperuser")
{
	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
	
	if (can_administer('canadminusers'))
	{
		print_form_header('admin_warn', 'do_finduserwarnings');
		print_table_header($vbphrase['aws_admin_viewuserwarns']);
		print_description_row($vbphrase['aws_admin_venteruseridornametoseewarns']);

		print_input_row($vbphrase['aws_userid'], 'userid');
		print_input_row($vbphrase['aws_admin_username'], 'username');

		print_submit_row($vbphrase['aws_admin_finduserwarns'], 0);
		
		exit;
	}
}
//#####################################################################################################################################
if ($_POST['do'] == "do_finduserwarnings" OR $_GET['do'] == "do_finduserwarnings")
{
	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
	
	$url = "admin_warn.php?do=warnsperuser";
	$wait = 5;

	$vbulletin->input->clean_array_gpc('r', array(
		'userid' => TYPE_INT,
		'username' => TYPE_STR,
		'guserid' => TYPE_INT,
		'perpage' => TYPE_INT,
		'orderby'=> TYPE_STR,
		'order' => TYPE_STR,
		'page' => TYPE_INT,
	));

	$orderby = $vbulletin->GPC['orderby'];

	if (($vbulletin->GPC['userid'] == '' || !$vbulletin->GPC['userid'] || $vbulletin->GPC['userid'] < 1) AND ($vbulletin->GPC['username'] == '' || !$vbulletin->GPC['username']))
	{
		print_cp_message($vbphrase['aws_admin_invaliduserinput'], $url, $wait);
	}
	if (!$vbulletin->GPC['userid'] == '' AND !$vbulletin->GPC['username'] == '')
	{
		print_cp_message($vbphrase['aws_admin_speceitheruseridorname'], $url, $wait);
	}
	
	if (!$vbulletin->GPC['userid'] == '')
	{
		if(!$user = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "user WHERE userid = '{$vbulletin->GPC['userid']}'"))
		{
			print_cp_message($vbphrase['aws_admin_useridnotexistant'], $url, $wait);
		}
	}
	if (!$vbulletin->GPC['username'] == '')
	{
		if(!$user = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "user WHERE username = '{$vbulletin->GPC['username']}'"))
		{
			print_cp_message($vbphrase['aws_admin_usernamenotexistant'], $url, $wait);
		}
	}

	$s1t = 'w.warned_user ASC';
	$s2t = 'w.warned_user DESC';
	$s3t = 'u.username ASC';
	$s4t = 'u.username DESC';
	$s5t = 'w.warned_post ASC';
	$s6t = 'w.warned_post DESC';
	$s7t = 'wt.title ASC';
	$s8t = 'wt.title DESC';
	$s9t = 'wt.warn_points ASC';
	$s10t = 'wt.warn_points DESC';
	$s11t = 'w.warned_time ASC';
	$s12t = 'w.warned_time DESC';
	$s13t = 'maturitydate ASC ';
	$s14t = 'maturitydate DESC';
	$s15t = 'w.removed_date ASC';
	$s16t = 'w.removed_date DESC';
	
	$perpage = $vbulletin->options['warn_warnings_per_page'];
	
	if ($perpage == '' OR $perpage == 0)
	{
		$perpage = 15;
	}

	$page = $vbulletin->GPC['page'];
	if ($page < 1)
	{
		$page = 1;
	}
	$startat = ($page - 1) * $perpage;
	
	$counter = $db->query_first("SELECT COUNT(*) AS warnings FROM " . TABLE_PREFIX . "warnings AS warning");
	$totalpages = ceil($counter['warnings'] / $perpage);
	
	if ($orderby == '')
	{
		if ($vbulletin->GPC['order'] == '')
		{	
			$orderby = $s12t;
		}
		else
		{
			$orderby = $vbulletin->GPC['order'];
		}
	}
	
	switch ($orderby) 
	{
		case $s1t:
			$orderbycom = $vbphrase['aws_warneduserid'] . ', ' . $vbphrase['aws_ascending'];
			break;
		case $s2t:
			$orderbycom = $vbphrase['aws_warneduserid'] . ', ' . $vbphrase['aws_descending'];
			break;
		case $s3t:
			$orderbycom = $vbphrase['aws_warnername'] . ', ' . $vbphrase['aws_ascending'];
			break;
		case $s4t:
			$orderbycom = $vbphrase['aws_warnername'] . ', ' . $vbphrase['aws_descending'];
			break;
		case $s5t:
			$orderbycom = $vbphrase['aws_warnedpost'] . ', ' . $vbphrase['aws_ascending'];
			break;
		case $s6t:
			$orderbycom = $vbphrase['aws_warnedpost'] . ', ' . $vbphrase['aws_descending'];
			break;
		case $s7t:
			$orderbycom = $vbphrase['aws_warningtype'] . ', ' . $vbphrase['aws_ascending'];
			break;
		case $s8t:
			$orderbycom = $vbphrase['aws_warningtype'] . ', ' . $vbphrase['aws_descending'];
			break;
		case $s9t:
			$orderbycom = $vbphrase['aws_warnedpoints'] . ', ' . $vbphrase['aws_ascending'];
			break;
		case $s10t:
			$orderbycom = $vbphrase['aws_warnedpoints'] . ', ' . $vbphrase['aws_descending'];
			break;
		case $s11t:
			$orderbycom = $vbphrase['aws_warningdate'] . ', ' . $vbphrase['aws_ascending'];
			break;
		case $s12t:
			$orderbycom = $vbphrase['aws_warningdate'] . ', ' . $vbphrase['aws_descending'];
			break;
		case $s13t:
			$orderbycom = $vbphrase['aws_maturitydate'] . ', ' . $vbphrase['aws_ascending'];
			break;
		case $s14t:
			$orderbycom = $vbphrase['aws_maturitydate'] . ', ' . $vbphrase['aws_descending'];
			break;
		case $s15t:
			$orderbycom = $vbphrase['aws_removaldate'] . ', ' . $vbphrase['aws_ascending'];
			break;
		case $s16t:
			$orderbycom = $vbphrase['aws_removaldate'] . ', ' . $vbphrase['aws_descending'];
			break;
	}
	$order = $orderby;
	
	$counter = $db->query_first("SELECT COUNT(*) AS warnings FROM " . TABLE_PREFIX . "warnings AS warning WHERE warned_user = {$user[userid]}");
	
	if ($counter['warnings'] == 0 or $counter['warnings'] == '')
	{
		print_cp_message($vbphrase['aws_admin_userhasnowarns'], $url, $wait);
	}
	
	$totalpages = ceil($counter['warnings'] / $perpage);

	$get_warns = $db->query("SELECT w.*, u.username AS wusername, u.userid AS wuserid, wt.*, wrn.username AS warnername, wrn.userid AS warnerid, ruser.username AS removed_by_v, (w.warned_time + wt.warn_maturity * 24 * 60 * 60) AS maturitydate FROM
		" . TABLE_PREFIX . "warnings w
		LEFT JOIN " . TABLE_PREFIX . "user u ON(u.userid = $user[userid])
		LEFT JOIN " . TABLE_PREFIX . "user wrn ON(wrn.userid = w.warned_by)
		LEFT JOIN " . TABLE_PREFIX . "user ruser ON(ruser.userid = w.removed_by)
		LEFT JOIN " . TABLE_PREFIX . "warningtype wt ON(wt.warningtypeid = w.warned_warning_id)
		WHERE w.warned_user = '{$user[userid]}' ORDER BY $orderby LIMIT $startat, $perpage");

	if ($db->num_rows($get_warns))
	{
		if ($page != 1)
		{
			$prv = $page - 1;
			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['aws_first_page'] .
							"\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?" . $vbulletin->session->vars['sessionurl'] .
							"do=do_finduserwarnings&type=" . $vbulletin->GPC['type'] .
				            "userid=" . $vbulletin->GPC['userid'] .
				            "script=" . $vbulletin->GPC['script'] .
							"&perpage=" . $vbulletin->GPC['perpage'] .
							"&orderby=" . $vbulletin->GPC['orderby'] .
							"&page=1'\">";
			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['aws_prev_page'] .
						"\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?" . $vbulletin->session->vars['sessionurl'] .
						"do=do_finduserwarnings&type=" . $vbulletin->GPC['type'] .
				        "&userid=" . $vbulletin->GPC['userid'] . 
				        "&script=" . $vbulletin->GPC['script'] .
						"&perpage=" . $vbulletin->GPC['perpage'] .
						"&orderby=" . $vbulletin->GPC['orderby'] .
						"&page=$prv'\">";
		}
	
		if ($page != $totalpages)
		{
			$nxt = $page + 1;
			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_next_page'] .
						" &gt;\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?" .
						$vbulletin->session->vars['sessionurl'] .
						"do=do_finduserwarnings&type=" . $vbulletin->GPC['type'] .
				        "&userid=" . $vbulletin->GPC['userid'] .
				        "&script=" . $vbulletin->GPC['script'] . 
						"&perpage=" . $vbulletin->GPC['perpage'] .
						"&orderby=" . $vbulletin->GPC['orderby'] .
						"&page=$nxt'\">";
			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_last_page'] .
						" &raquo;\" tabindex=\"1\" onclick=\"window.location='admin_warn.php?" . $vbulletin->session->vars['sessionurl'] .
						"do=do_finduserwarnings&type=" . $vbulletin->GPC['type'] .
				        "&userid=" . $vbulletin->GPC['userid'] . 
				        "&script=" . $vbulletin->GPC['script'] . 
						"&perpage=" . $vbulletin->GPC['perpage'] .
						"&orderby=" . $vbulletin->GPC['orderby'] .
						"&page=$totalpages'\">";
		}
		$aa = ($page - 1) * $perpage + 1;
		if ($page < $totalpages)
		{
			$bb = $page * $perpage;
		}
		else
		{
			$bb = $counter['warnings'];
		}
		$cc = $counter['warnings'];		
		
		print_form_header('admin_warn', '');
		print_table_header($vbphrase['aws_admin_viewuserwarns'] . "<br>" . $vbphrase['aws_userid'] . ": $user[userid] - " . $vbphrase['aws_admin_username'] . ": $user[username]<br>" . $vbphrase['aws_warnings'] . ": $user[warns] - " . $vbphrase['aws_warnedpoints'] . ": $user[warning_level] - " . $vbphrase['aws_bans'] . ": $user[warning_bans]<br>" . $vbphrase['aws_page'] . " $page " . $vbphrase['aws_of'] . " $totalpages<br>" . $vbphrase['aws_warnings'] . " " .$vbphrase['aws_to1'] . "$aa " . $vbphrase['aws_to'] . " $bb " . $vbphrase['aws_of'] . " $cc",14);
		
		$header = array();
		
		$header[] = "<b>" . $vbphrase['aws_warneduseridname'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_warnedby'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_warnedpost'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_warningtype'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_warnpoints'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_warndate'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_maturitydate'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_comment'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_causedban'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_remove'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_status'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_removedby'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_removaldate'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_admin_completeremoval'] . "</b>";
			
		print_cells_row($header, 1);
		
		while($warn = $db->fetch_array($get_warns))
		{
			$cell = array();
			
			$warn['date'] = vbdate ($vbulletin->options['dateformat'],$warn['warned_time']);
			$warn['time'] = vbdate ($vbulletin->options['timeformat'],$warn['warned_time']);
			if($warn['warn_permban'] == "Yes")
			{
				$rdate = $vbphrase['aws_never'];
			}
			else
			{
				$rdate = $warn['maturitydate'];
				$rdate = vbdate ($vbulletin->options['dateformat'], $rdate);
			}
			if($warn['wuserid'] == "")
			{
				$x = "<i>" . $vbphrase['aws_deleteduser'] . "</i>";
			} 
			else 
			{
				$x = "<a href=\"{$vbulletin->options[bburl]}/$admincpdir/user.php?$session[sessionurl]do=edit&amp;userid={$warn[wuserid]}\" onclick=\"window.open('{$vbulletin->options[bburl]}/$admincpdir/user.php?$session[sessionurl]do=edit&amp;userid={$warn[wuserid]}','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">{$warn[wuserid]}<br><b>{$warn['wusername']}</a>";
			}
			if($warn['warn_permban'] == "Yes" OR $warn['warned_status'] == "I")
			{
				$y = "<i>" . $vbphrase['aws_notremovale'] . "</i>";
			} 
			else 
			{
				$y = "<a href='{$vbulletin->options['bburl']}/$admincpdir/admin_warn.php?do=remove&id={$warn[wid]}&userid={$warn[wuserid]}&uname={$warn[wusername]}&wname={$warn[title]}&postid={$warn[warned_post]}&ban=$warn[caused_ban]&orderstring={$order}'>" . $vbphrase['aws_remove'] . "</a>";
			}
			$cy = "<a href='{$vbulletin->options['bburl']}/$admincpdir/admin_warn.php?do=completeremove&id={$warn[wid]}&userid={$warn[wuserid]}&uname={$warn[wusername]}&wname={$warn[title]}&postid={$warn[warned_post]}&ban=$warn[caused_ban]&orderstring={$order}'>" . $vbphrase['aws_remove'] . "</a>";
			$a = $warn['title'];
			$p = $warn['warn_points'];
			$b = $warn['date'];
			$c = $warn['time'];
			if ($a == $vbphrase['aws_obscenewords'] OR $a == $vbphrase['aws_obscenewordsinchat'])
			{
				$vbvb = $vbphrase['aws_admin_seeuncensortedmes'];
				$d = "<A HREF=\"{$vbulletin->options[bburl]}/{$admincpdir}/admin_warn.php?do=showcomment&id=$warn[wid]&name=$a&
				&reason = $warn[warned_reason]\" onclick=\"window.open('{$vbulletin->options[bburl]}/{$admincpdir}/admin_warn.php?do=showcomment&id=$warn[wid]&name=$a&reason=$warn[warned_reason]','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">$vbvb</a></font>";
			}
			else
			{
				$vbvb = $vbphrase['aws_seecomment'];
				$d = "<A HREF=\"{$vbulletin->options[bburl]}/{$admincpdir}/admin_warn.php?do=showcomment&id=$warn[wid]\" onclick=\"window.open('{$vbulletin->options[bburl]}/{$admincpdir}/admin_warn.php?do=showcomment&id=$warn[wid]','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">$vbvb</a></font>";
			}
			if ($warn['warned_status'] == "I")
			{
				if ($warn['removed_by'] == '0')
				{
					$r = $vbphrase['aws_cron'];
					$r2 = $r;
				}
				else
				{
					$r = $warn[removed_by_v];
					$r2 = "<a href=\"{$vbulletin->options[bburl]}/{$admincpdir}/user.php?$session[sessionurl]do=edit&amp;userid={$warn['removed_by']}\" onclick=\"window.open('{$vbulletin->options[bburl]}/{$admincpdir}/user.php?$session[sessionurl]do=edit&amp;userid={$warn['removed_by']}','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">{$r}</a>";
				}
			}
			else
			{
				$r2 = '';
			}
			if ($warn['removed_date'] == '' OR $warn['removed_date'] == '0')
			{
				$t1 = '';
				$t2 = '';
			}
			else
			{
				$t1 = vbdate ($vbulletin->options['dateformat'], $warn['removed_date']);
				$t2 = vbdate ($vbulletin->options['timeformat'], $warn['removed_date']);
			}
			if ($warn['warned_post'] == '' OR $warn['warned_post'] == '0')
			{
				$w = $vbphrase['aws_admin_npr'];
			}
			else
			{
				$w = "<a href=\"{$vbulletin->options[bburl]}/showthread.php?p=$warn[warned_post]#post$warn[warned_post]\" onclick=\"window.open('{$vbulletin->options[bburl]}/showthread.php?p=$warn[warned_post]#post$warn[warned_post]','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false\">$warn[warned_post]</a>";
			}
			$p = $warn['warn_points'];
			if ($warn['caused_ban'] == 'Y')
			{
				$cb = $vbphrase['aws_yes'];
			}
			else
			{
				$cb = $vbphrase['aws_no'];
			}

			if($warn['warned_status'] == "I")
			{
				$k = "<i>" . $vbphrase['aws_inactive'] . "</i>";
			} 
			if($warn['warned_status'] == "A")
			{
				$k = $vbphrase['aws_active'];
			}
			if($warn['warned_status'] == "L")
			{
				$k = $vbphrase['aws_alert'];
			}

			if($warn['warned_status'] == "L")
			{
				$p = '';
				$rdate = '';
				$cb = '';
				$y = '';
			}
			else
			{
				$p = $warn['warn_points'];
			}
						
			$cell[] = "<font size='-1'>{$x}</font>";
			$cell[] = "<font size='-1'><a href=\"{$vbulletin->options[bburl]}/$admincpdir/user.php?$session[sessionurl]do=edit&amp;userid={$warn['warnerid']}\" onclick=\"window.open('{$vbulletin->options[bburl]}/$admincpdir/user.php?$session[sessionurl]do=edit&amp;userid={$warn['warnerid']}','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">{$warn['warnername']}</a></font>";
			$cell[] = "<font size='-1'>{$w}</font>";
			$cell[] = "<font size='-1'>{$a}</font>";
			$cell[] = "<font size='-1'>{$p}</font>";
			$cell[] = "<font size='-1'>{$b}<br>{$c}</font>";
			$cell[] = "<font size='-1'>$rdate</font>";
			$cell[] = "<font size='-1'>{$d}</font>";
			$cell[] = "<font size='-1'>{$cb}</font>";
			$cell[] = "<font size='-1'>{$y}</font>";
			$cell[] = "<font size='-1'>{$k}</font>";
			$cell[] = "<font size='-1'>{$r2}</font>";
			$cell[] = "<font size='-1'>{$t1}<br>{$t2}</font>";
			$cell[] = "<font size='-1'>{$cy}</font>";
			
			print_cells_row($cell);
		}
		print_table_footer(15, "$firstpage $prevpage &nbsp; $nextpage $lastpage");
	}
}
//#####################################################################################################################################
if($_GET['do'] == "showcomment")
{
	$vbulletin->input->clean_array_gpc('g',array(
		'id'		=> TYPE_INT,
		'name'		=> TYPE_STR,
		'reason'	=> TYPE_STR
	));
			
	$name = $vbulletin->GPC['name'];
	$reason = $vbulletin->GPC['reason'];
	
	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");

	if ($vbulletin->GPC['id'] == '')
	{
		$url = "{$admincpdir}/admin_warn.php?do=viewlogs";
		$wait = 5;
		print_cp_message($vbphrase['aws_wrongwarningid'], $url, $wait);
	}
	
	$tmpwarntype = $db->query_first("SELECT wt.warn_type, wt.warningtypeid, w.warned_warning_id, w.wid FROM " . TABLE_PREFIX . "warnings w 
	LEFT JOIN " . TABLE_PREFIX . "warningtype wt on(wt.warningtypeid = w.warned_warning_id) WHERE w.wid = " . $vbulletin->GPC['id']);
	if ($name == $vbphrase['aws_obscenewords'] and $tmpwarntype['warn_type'] == 2)
	{
		$intcode = str_replace($vbphrase['aws_automaticwarning'] . " " . $vbphrase['aws_itc'] . ": ", "", $reason);
		$original = $db->query_first("SELECT before_message from " . TABLE_PREFIX . "pmtext_warned WHERE pmtextid = '$intcode'");
		$display = $original['before_message'];

		print_form_header('', '');
		print_table_header($vbphrase['aws_admin_seeuncensortedmes'], 1);		
		$header = array();

		$header[] = "<b>" . $vbphrase['aws_admin_uncensoredmes'] . "</b>";
		print_cells_row($header, 1);
	}
	else
	{
		print_form_header('', '');
		print_table_header($vbphrase['aws_viewwarningcomment'], 1);
			
		$header = array();
		
		$header[] = "<b>" . $vbphrase['aws_comment'] . "</b>";
		print_cells_row($header, 1);

		if ($name == $vbphrase['aws_obscenewordsinchat'])
		{
			$original = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "vbchat_store_warned WHERE sid = $reason");
			$display = stripslashes($original['s_message']);
		}
		else
		{
			$original = $db->query_first("SELECT warned_reason, warned_warning_id FROM " . TABLE_PREFIX . "warnings WHERE wid = {$vbulletin->GPC['id']}");
			if ($original['warned_reason'] == $vbphrase['aws_standartslertcomm'])
			{
				$acomment = $db->query_first("SELECT warn_alertcomment FROM " . TABLE_PREFIX . "warningtype WHERE warningtypeid = $original[warned_warning_id]");
				$display = $original['warned_reason'] . "<br><br><i>$acomment[warn_alertcomment]</i>";
			}
			else
			{
				$display = stripslashes($original['warned_reason']);
			}
		}
	}
	$cell[] = $display;
	print_cells_row($cell);
}
//#####################################################################################################################################
if($_POST['do'] == "deletemarkwarn")
{
	$vbulletin->input->clean_array_gpc('p',array(
		'markwarn'      => TYPE_ARRAY_INT,
		'order'         => TYPE_STR,
		'reason'        => TYPE_INT,
	));
	$pm = $vbulletin->GPC['markwarn'];
	$order = $vbulletin->GPC['order'];

	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");

	if (!is_array($pm))
	{
		$url = "admin_warn.php?do=viewlogs&order=$order";
		$wait = 5;
		print_cp_message($vbphrase['aws_youdidntspecwarntocomprem'], $url, $wait);
	}

	$markedwarns =& $vbulletin->GPC['markwarn'];
	foreach ($markedwarns AS $key => $val)
	{
		$markedwarns["$key"] = intval($val);
		if(!$warn = $db->query_first("SELECT w.*, wt.*, u.* FROM " . TABLE_PREFIX . "warnings w 
			LEFT JOIN " . TABLE_PREFIX . "warningtype wt ON(wt.warningtypeid = w.warned_warning_id) 
			LEFT JOIN " . TABLE_PREFIX . "user u ON(u.userid = w.warned_user) WHERE w.wid = '{$markedwarns["$key"]}'"))
		{
			echo ($vbphrase['aws_warnnotfoundinbd']);
			$rstring = "admin_warn.php?do=viewlogs&order=$order";
			define('CP_REDIRECT', $rstring);
			print_stop_message('aws_warnings_npruned');
		}

		$aws_phrase = build_aws_language($warn['userid']);

		if ($warn['warned_status'] != 'L')
		{
			if ($warn['warns'] <= 0)
			{
				$warnings = 0;
			}
			else
			{
				$warnings = $warn['warns'] - 1;
			}
			
			if ($warn['caused_ban'] == "Y")
			{
				$bans = $warn['warning_bans'] - 1;
				if ($bans < 0)
				{
						$bans = 0;
				}
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "ban_dates WHERE banned_warning = $warn[wid]");
			}
			else
			{
				$bans = $warn['warning_bans'];
			}

			if($warn['warned_status'] == 'A')
			{
				$level = $warn['warning_level'] - $warn['warn_points'];
			}
			elseif($warn['warned_status'] == 'I')
			{
				$level = $warn['warning_level'];
			}

			$level = (int)$level;
			if($level < 1)
			{
				$level = 0;
			}
			$userdm=& datamanager_init('User',$vbulletin,ERRTYPE_CP);
			$userdm->set_existing($warn);
			$userdm->set('warning_level',$level);
			$userdm->set('warns',$warnings);
			$userdm->set('warning_bans',$bans);
			$userdm->save();
			unset($userdm);
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "warnings WHERE wid = '{$warn['wid']}'");

			if ($warn['title'] == $vbphrase['aws_obscenewordsinchat'])
			{
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "vbchat_store_warned WHERE sid = '{$warn['warned_reason']}'");
			}

			if ($warn['title'] == $vbphrase['aws_obscenewords'] AND $warn['warned_post'] == 0)
			{
				$intcode = str_replace($vbphrase['aws_automaticwarning'] . " " . $vbphrase['aws_itc'] . ": ", "", $warn['warned_reason']);
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "pmtext_warned WHERE pmtextid = '{$intcode}'");
			}

			if ($warn['warned_post'] != 0)
			{
				$wf = $db->query_first("SELECT warn_flag FROM " . TABLE_PREFIX . "post WHERE postid = '{$warn[warned_post]}'");
				$wflag = $wf['warn_flag'] - 1;
				if ($wflag < 0)
				{
					$wflag = 0;
				}
				$db->query_write("UPDATE " . TABLE_PREFIX . "post SET warn_flag = '{$wflag}' WHERE postid = '{$warn[warned_post]}'");
				$thread1 = "[URL='{$vbulletin->options['bburl']}/showthread.php?p={$warn['warned_post']}']" . $aws_phrase['aws_message_warnedpost'] . "[/URL]";
				$thread2 = "{$vbulletin->options['bburl']}/showthread.php?p={$warn['warned_post']}";
			}
			else
			{
				$thread1 = $aws_phrase['aws_message_nopostrelated'];
				$thread2 = $aws_phrase['aws_message_nopostrelated'];
			}
		}
		else
		{
			if ($warn['alerts'] <= 0)
			{
				$alerts = 0;
			}
			else
			{
				$alerts = $warn['alerts'] - 1;
			}
			if ($warn['warned_post'] != 0)
			{
				$thread1 = "[URL='{$vbulletin->options['bburl']}/showthread.php?p={$warn['warned_post']}']" . $aws_phrase['aws_message_warnedpost'] . "[/URL]";
				$thread2 = "{$vbulletin->options['bburl']}/showthread.php?p={$warn['warned_post']}";
			}
			else
			{
				$thread1 = $aws_phrase['aws_message_nopostrelated'];
				$thread2 = $aws_phrase['aws_message_nopostrelated'];
			}
			$userdm=& datamanager_init('User',$vbulletin,ERRTYPE_CP);
			$userdm->set_existing($warn);
			$userdm->set('alerts',$alerts);
			$userdm->save();
			unset($userdm);

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "warnings WHERE wid = '{$warn['wid']}'");
		}

		if($vbulletin->options['warn_send_pm_warning'] == 1 OR $vbulletin->options['warn_send_em_warning'] == 1)
		{
			if ($warn['warned_status'] != 'L')
			{
				if ($warn['warn_points'] == 1)
				{
					$tempWarnPoints = $aws_phrase['aws_message_point1'];
				}
				else
				{
					$tempWarnPoints = $aws_phrase['aws_message_point2'];
				}
				if ($level == 1)
				{
					$tempWarnLevel = $aws_phrase['aws_message_point1'];
				}
				else
				{
					$tempWarnLevel = $aws_phrase['aws_message_point2'];
				}
			}
		}
		$user = array_merge((array)$user,convert_bits_to_array($user['options'],$vbulletin->bf_misc_useroptions));
	    $perms = fetch_permissions(0, $user['userid'], $user);
	    if($user['options'] & $vbulletin->bf_misc_useroptions['receivepm'])
		{
			$donotpmhim=0;
		}
		else
		{
			$donotpmhim=1;
		}
		if($vbulletin->options['warn_send_pm_warning'] == 1 AND $donotpmhim=0)
		{
			if ($warn['warned_status'] != 'L')
			{
				$messageb = $aws_phrase['aws_message_dear'] . ' ' . $warn['username'] . ',

				' . construct_phrase($aws_phrase['aws_message_warn_you_recived_was_removed'], $vbulletin->options['bbtitle']) . ' ' . $aws_phrase['aws_message_removed_warning_concerned'] . ' 

				[b][i] ' . $warn['warn_desc'] . ' [/i][/b]
				(' . $aws_phrase['aws_message_warningtype'] . ' - "' . $warn['title'] . '") 

				' . $aws_phrase['aws_message_post_for_which_you_were_warned'] . '

				' . $thread1 . '

				' . $aws_phrase['aws_message_with_warning_removing'] . ' [b] ' . $warn['warn_points'] . ' ' . $tempWarnPoints . '[/b] ' . $aws_phrase['aws_message_have_been_removed_from_you_total'] . '

				' . $aws_phrase['aws_message_your_warning_level_now'] . ' [b] ' . $level . ' ' . $tempWarnLevel . '[/b]

				' . $aws_phrase['aws_message_please_reply_back'] . '

				----------------

				' . construct_phrase($aws_phrase['aws_message_administration'], $vbulletin->options['bbtitle']);				

				$title = $aws_phrase['aws_message_warnhasbeenrem'];
			}
			else
			{
				$messageb = $aws_phrase['aws_message_dear'] . ' ' . $warn['username'] . ',

				' . construct_phrase($aws_phrase['aws_message_alert_you_recived_was_removed'], $vbulletin->options['bbtitle']) . ' ' . $aws_phrase['aws_message_removed_alert_concerned'] . ' 

				[b][i] ' . $warn['warn_desc'] . ' [/i][/b]
				(' . $aws_phrase['aws_message_warningtype'] . ' - "' . $warn['title'] . '") 

				' . $aws_phrase['aws_message_post_for_which_you_were_alerted'] . '

				' . $thread1 . '

				' . $aws_phrase['aws_message_kind_regards'] . '

				----------------

				' . construct_phrase($aws_phrase['aws_message_administration'], $vbulletin->options['bbtitle']);

				$title = $aws_phrase['aws_message_alerthasbeenrem'];
			}

			$recipients = $warn['username'];
			if($vbulletin->options['warn_warner'] == 0)
			{
				$fromuserid = $vbulletin->userinfo['userid'];
				$fromusername = $vbulletin->userinfo['username'];
			}
			else
			{
				$fromuserid = $vbulletin->options['warn_warner'];
				$fromusername = $vbulletin->options['warn_username'];
			}
			SendPMAwsAdmincp($fromuserid, $fromusername, $title,$messageb, $recipients);
		}

		if($vbulletin->options['warn_send_em_warning'] == 1 AND $donotpmhim = 1)
		{
			if ($warn['warned_status'] != 'L')
			{
				$messageb = $aws_phrase['aws_message_dear'] . ' ' . $warn['username'] . ',

				' . construct_phrase($aws_phrase['aws_message_warn_you_recived_was_removed'], $vbulletin->options['bbtitle']) . ' ' . $aws_phrase['aws_message_removed_warning_concerned'] . '

				' . $warn['warn_desc'] . '
				(' . $aws_phrase['aws_message_warningtype'] . ' - "' . $warn['title'] . '") 

				' . $aws_phrase['aws_message_post_for_which_you_were_warned'] . '

				' . $thread2 . '

				' . $aws_phrase['aws_message_with_warning_removing'] . ' ' . $warn['warn_points'] . ' ' . $tempWarnPoints . ' ' . $aws_phrase['aws_message_have_been_removed_from_you_total'] . '

				' . $aws_phrase['aws_message_your_warning_level_now'] . ' ' . $level . ' ' . $tempWarnLevel . '.

				' . $aws_phrase['aws_message_please_reply_back'] . '

				----------------

				' . construct_phrase($aws_phrase['aws_message_administration'], $vbulletin->options['bbtitle']);

				$title = "{$vbulletin->options['messagetag']} - " . $aws_phrase['aws_message_warnhasbeenrem'];
			}
			else
			{
				$messageb = $aws_phrase['aws_message_dear'] . ' ' . $warn['username'] . ',

				' . construct_phrase($aws_phrase['aws_message_alert_you_recived_was_removed'], $vbulletin->options['bbtitle']) . ' ' . $aws_phrase['aws_message_removed_alert_concerned'] . ' 

				' . $warn['warn_desc'] . '
				(' . $aws_phrase['aws_message_warningtype'] . ' - "' . $warn['title'] . '") 

				' . $aws_phrase['aws_message_post_for_which_you_were_alerted'] . '

				' . $thread2 . '

				' . $aws_phrase['aws_message_kind_regards'] . '

				----------------

				' . construct_phrase($aws_phrase['aws_message_administration'], $vbulletin->options['bbtitle']);

				$title = "{$vbulletin->options['messagetag']} - " . $aws_phrase['aws_message_alerthasbeenrem'];
			}
			$to = $warn['userid'];
			if($vbulletin->options['warn_warner'] == 0)
			{
				$fromemail = $vbulletin->userinfo['email'];
				$fromname = $vbulletin->userinfo['username'];
			}elseif($vbulletin->options['warn_mailfrom'] == 1 AND $vbulletin->options['warn_mailfromaddress'] !='')
			{
				$fromemail = $vbulletin->options['warn_mailfromaddress'];
			}
			else
			{
				$warnerdata = $db->query_first("SELECT username, email FROM " . TABLE_PREFIX . "user WHERE userid = '{$vbulletin->options['warn_warner']}'");
				$fromemail = $warnerdata['email'];
				$fromname = $warnerdata['username'];
			}
			vbmail($warn['email'], $title, $messageb, false, $fromemail, '', $fromname);
		}
	}
	if (!$order == '')
	{
		$rstring = "admin_warn.php?do=viewlogs&order=$order";
	}

	define('CP_REDIRECT', $rstring);
	print_stop_message('aws_warnings_removed');
}
/*======================================================================*\
|| #################################################################### ||
|| # vB3 Advanced Warning System (AWS) By John Caradimas SV1CEC         ||
|| AWS Version 3.4.12
|| vBulletin 3.5.x 3.6.x support Delphiprogrammi
|| #################################################################### ||
\*======================================================================*/
?>