<?php
/*======================================================================*\
|| #################################################################### ||
|| # vB3 Advanced Warning System V3.6.0 By John Caradimas SV1CEC
|| # vBulletin 3.5.x 3.6.x Support Delphiprogrammi
|| #################################################################### ||
\*======================================================================*/
// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'Warn');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by specific actions O_O
$actiontemplates = array(

'ViewMyWarnings' => array(
	'warn_view_end',
	'warn_view_row',
	'warn_view_top',
	'warn_viewtype_end',
	'warn_viewtype_row',
	'warn_viewtype_top',
),
'WarnUser' => array(
	'warn_addwarn',
	'warn_pm',
	'warn_em',
	'warn_viewtype_end',
	'warn_viewtype_row',
	'warn_viewtype_top',
),
'ViewWarnings' => array(
	'warn_viewb_end',
	'warn_viewb_row',
	'warn_viewb_top',
	'warn_viewtype_end',
	'warn_viewtype_row',
	'warn_viewtype_top',
),
'ViewPostWarnings' => array(
	'warn_viewc_end',
	'warn_viewc_row',
	'warn_viewc_top',
	'warn_viewtype_end',
	'warn_viewtype_row',
	'warn_viewtype_top',
)
);

// pre-cache templates used by all actions O_O
$globaltemplates = array(
	'WARN',
	'warn_redirect',
	'warn_error',
	'warn_showcomment',
	'warn_navbar_link'
);

global $message_left;

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// Global Requirements & Functions
require_once('./global.php');
require_once('./includes/functions.php');
require_once('./includes/functions_user.php');
require_once('./includes/functions_warning.php');
	
$warn_page = "";

if($_GET['do'] != 'ViewMyWarnings')
{
	if(!can_moderate())
	{
		print_no_permission();
	}
}
// ############################ NO ACTION ###############################################################################################
if ((!$_GET['do'] || $_GET['do'] == "") && !$_POST['do'])
{
	$_GET['do'] = "ViewMyWarnings";
}
//#######################################################################################################################################
if($_GET['do'] == "WarnUser")
{
	$vbulletin->input->clean_array_gpc('g', array(
		'id'       => TYPE_INT,
		'post'     => TYPE_INT,
		'do'       => TYPE_STR,
		'return'   => TYPE_STR,
	));
	$userinfo = verify_id('user', $vbulletin->GPC['id'], 0, 1);
	$joindate = vbdate($vbulletin->options['dateformat'],$userinfo['joindate']);
	$lastactivity = vbdate($vbulletin->options['dateformat'],$userinfo['lastactivity'],true);
	$lastactivitytime = vbdate($vbulletin->options['timeformat'],$userinfo['lastactivity'],true);
	$navbits['Warn.php?' . $vbulletin->session->vars['sessionurl'] . "do=WarnUser&id={$vbulletin->GPC['id']}&post={$vbulletin->GPC['post']}"] = $vbphrase['aws_warnuser'];
    $navbits[""]= $vbphrase['aws_warninguser'];
	$pagetitle = $vbphrase['aws_warninguser'];
	if (!($vbulletin->userinfo['permissions']['awspermissions'] & $vbulletin->bf_ugp_awspermissions['canwarn']))
	{
		RunErrorAws($vbphrase['aws_you_have_no_perm_to_issue_warns']);
	}
    check_user($vbulletin->GPC['id'], $vbulletin->options['warn_protected_usergroups']);
    check_post($vbulletin->GPC['post'], $vbulletin->options['warn_multiple_per_post']);
	check_bans($vbulletin->GPC['id']);
	$warnopts = "";
    $alert = "";
    $get_tps = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "warningtype WHERE warn_type = '0' ORDER BY warn_points, warn_maturity");
    while($warn = $db->fetch_array($get_tps))
	{
		if ($warn['warn_alert'] == '1')
		{
			$alertcommenttext = '- ' . $vbphrase['aws_alert'] . ': ' . $vbphrase['aws_yes'];
			if ($warn['warn_alertcomment'] != '')
			{
				$alertcommenttext = $alertcommenttext . ' - ' . $vbphrase['aws_alertcomment'] . ': ' . $vbphrase['aws_yes'];
			}
		}
		else
		{
			$alertcommenttext = '';
		}
		if ($warn['warn_maturity'] == 1)
		{
			$DaysName = $vbphrase['aws_day1'];
		}
		else
		{
			$DaysName = $vbphrase['aws_day3'];
		}
		$warnopts .= "<option value='{$warn['warningtypeid']}'>{$warn['title']} - " . $vbphrase['aws_increasewarnpoint'] . ": {$warn['warn_points']} - " . $vbphrase['aws_warnmaturity'] . ": {$warn['warn_maturity']} " . $DaysName . " $alertcommenttext</option>";
	}

	if($postwarnedalready = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "warnings WHERE warned_post = '{$vbulletin->GPC['post']}' AND warned_status = 'A'") AND $vbulletin->options['warn_multiple_per_post'] == 1)
	{
		$warning_multiwarns1 = $vbphrase['aws_thisposthsarecived'];
		$warning_multiwarns2 = $vbphrase['aws_checkthemoutbefore'];
	}
	else
	{
		$warning_multiwarns1 = "";
        $warning_multiwarns2 = "";
	}
	$autocomments = $vbulletin->options['warn_autocomments'];
	eval('$warn_page .= "' . fetch_template('warn_addwarn') . '";');
	eval('$warn_page .= "' . fetch_template('warn_viewtype_top') . '";');
	$get_tps = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "warningtype WHERE warn_type = '0' ORDER BY warn_points, warn_maturity");
	while($warn = $db->fetch_array($get_tps))
	{
		if ($warn[warn_alertcomment] != '')
		{
			if (can_moderate())
			{
				$warntypecomment = "<a href=\"showcomment.php?warningtypeid=" . $warn['warningtypeidid'] . "\"  onclick=\"window.open('showcomment.php?warningtypeid=" . $warn['warningtypeidid'] . "','','width=500, height=300, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">" . $vbphrase['aws_yes'] . "</a>";
			}
			else
			{
				$warntypecomment = $vbphrase['aws_yes'];
			}
		}
		else
		{
			$warntypecomment = $vbphrase['aws_no'];
		}
		eval('$warn_page .= "' . fetch_template('warn_viewtype_row') . '";');
	}
	eval('$warn_page .= "' . fetch_template('warn_viewtype_end') . '";');
}
//######################################################################################################################################
if($_POST['do'] == "DoWarnUser")
{
	$vbulletin->input->clean_array_gpc('p',array(
		'id'            => TYPE_INT,
		'post'          => TYPE_INT,
		'do'            => TYPE_STR,
		'return'        => TYPE_STR,
		'warningid'     => TYPE_INT,
		'comment'       => TYPE_STR,
		'alert'         => TYPE_STR,
	));
	if ((!($vbulletin->GPC['comment']) OR vbstrlen($vbulletin->GPC['comment']) < $vbulletin->options['warn_min_comment_length']) AND $vbulletin->options['warn_min_comment_length'] > 0)
	{
		RunErrorAws($vbphrase['aws_you_must_enter_minimum_x_symbols_in_comment']);
	}
	$alert = $vbulletin->GPC['alert'];
	$post = $vbulletin->GPC['post'];
	$slcomment = $vbulletin->GPC['comment'];
	$navbits['Warn.php?' . $vbulletin->session->vars['sessionurl'] . "do=WarnUser&id={$vbulletin->GPC['id']}&post={$vbulletin->GPC['post']}"] = $vbphrase['aws_warnuser'];
	$navbits[""]= $vbphrase['aws_warninguser'];
	$pagetitle = $vbphrase['aws_warninguser'];
	check_user($vbulletin->GPC['id'], $vbulletin->options['warn_protected_usergroups']);
	check_post($vbulletin->GPC['post'], $vbulletin->options['warn_multiple_per_post']);
	check_bans($vbulltin->GPC['id']);
	if ($alert == '')
	{
		$alert = 0;
	}
	warn_calculations($vbulletin->GPC['warningid'], $slcomment, $vbulletin->GPC['post'], $user, $vbulletin->userinfo['userid'], $alert);

	if ($level == '')
	{
		$level = $user['warning_level'];
	}
	if ($message_left != $vbphrase['aws_typenotallow'] . " " . $vbphrase['aws_takingyouback'])
	{
		$thread1 = "[URL='{$vbulletin->options['bburl']}/showthread.php?p={$vbulletin->GPC['post']}']" . $vbphrase['aws_warnedpost'] . "[/URL]";
		$thread2 = "{$vbulletin->options['bburl']}/showthread.php?p={$vbulletin->GPC['post']}";
		if ($vbulletin->options['warn_includepost'] == 1)
		{
			$text = $db->query_first("SELECT pagetext FROM " . TABLE_PREFIX . "post WHERE postid = {$vbulletin->GPC['post']}");
			$thread3 = $text['pagetext'];
		}
		else
		{
			$thread3 = '';
		}
		warn_notify($thread1, $thread2, $thread3, $user, $vbulletin->userinfo['email'], $vbulletin->userinfo['username'], $vbulletin->userinfo['userid'], $warn_type, $level, $slcomment, $alert);
		if($vbulletin->options['warn_send_em_warning'] == 0 AND $vbulletin->options['warn_send_pm_warning'] == 0)
		{
			$message_left = "{$user['username']} " . $vbphrase['aws_warnedalerted2'] . " " . $vbphrase['aws_tackingtopost'];
		}
		if($vbulletin->options['warn_send_em_warning'] == 1 AND $vbulletin->options['warn_send_pm_warning'] == 1)
		{
			$message_left = "{$user['username']} " . $vbphrase['aws_warnedalerted1'] . " " . $vbphrase['aws_tackingtopost'];
		}
	}
	$url = "showthread.php?p={$post}";
    eval('$warn_page .= "' . fetch_template('warn_redirect') . '";');
}
//######################################################################################################################################
if($_GET['do'] == "WarnUserNoPost")
{
	$vbulletin->input->clean_array_gpc('g',array(
		'post'        => TYPE_INT,
		'do'          => TYPE_STR,
		'return'      => TYPE_STR,
		'alert'       => TYPE_STR,
		'id'          => TYPE_INT,
	));
	$userinfo = verify_id('user', $vbulletin->GPC['id'], 0, 1);
	$joindate = vbdate($vbulletin->options['dateformat'],$userinfo['joindate']);
	$lastactivity = vbdate($vbulletin->options['dateformat'],$userinfo['lastactivity'],true);
	$lastactivitytime = vbdate($vbulletin->options['timeformat'],$userinfo['lastactivity'],true);
	$navbits['Warn.php?' . $vbulletin->session->vars['sessionurl'] . "do=WarnUserNoPost&id={$vbulletin->GPC['id']}"] = $vbphrase['aws_warnuser'];
    $navbits[""]= $vbphrase['aws_warninguser'];
	$pagetitle = $vbphrase['aws_warninguser'];
	if (!($vbulletin->userinfo['permissions']['awspermissions'] & $vbulletin->bf_ugp_awspermissions['canwarnnopost']))
	{
		RunErrorAws($vbphrase['aws_you_have_no_perm_to_issue_nonpost_warns']);
	}
	if ($vbulletin->options['warn_allowoffpost'] == 0)
	{
		RunErrorAws($vbphrase['aws_youmaynotissuewanral']);
	}
	$return = $vbulletin->GPC['return'];
	check_user($vbulletin->GPC['id'], $vbulletin->options['warn_protected_usergroups']);
	check_bans($vbulletin->GPC['id']);
	$warnopts = "";
    $alert = "";
    $get_tps = $db->query("SELECT * FROM " . TABLE_PREFIX . "warningtype WHERE warn_type = 1 ORDER BY warn_points, warn_maturity");
	while($warn = $db->fetch_array($get_tps))
	{
		if ($warn['warn_alertcomment'] != '' AND $warn['warn_alert'] == 1)
		{
			$alertcommenttext = '- ' . $vbphrase['aws_alertcomment'] . ': ' . $vbphrase['aws_yes'];
		}
		else
		{
			$alertcommenttext = '';
		}
		
		if ($warn['warn_maturity'] == 1)
		{
			$DaysName = $vbphrase['aws_day1'];
		}
		else
		{
			$DaysName = $vbphrase['aws_day3'];
		}
		
		if ($warn['warn_alert'] == 1)
		{
			$WarnAlert = $vbphrase['aws_yes'];
		}
		else
		{
			$WarnAlert = $vbphrase['aws_no'];
		}
		if($warn['warn_type'] == 0)
		{
			$warn['warn_type'] = $vbphrase['aws_yes'];
		}
		elseif($warn['warn_type'] == 1)
		{
			$warn['warn_type'] = $vbphrase['aws_no'];
		}
		else
		{
			$warn['warn_type'] = $vbphrase['aws_auto'];
		}
		$warnopts .= "<option value='{$warn['warningtypeid']}'>{$warn['title']} - " . $vbphrase['aws_increasewarnpoint'] . ": {$warn['warn_points']} - " . $vbphrase['aws_warnmaturity'] . ": {$warn['warn_maturity']} " . $DaysName . " - " . $vbphrase['aws_alert'] . ": $WarnAlert $alertcommenttext</option>";
	}
	eval('$warn_page .= "' . fetch_template('warn_addwarn_nopost') . '";');
	eval('$warn_page .= "' . fetch_template('warn_viewtype_top') . '";');
	$get_tps = $db->query("SELECT * FROM " . TABLE_PREFIX . "warningtype WHERE warn_type = 1 ORDER BY warn_points, warn_maturity");
	$management = "$vbulletin->options[warn_admingroups]" . "|" . "$vbulletin->options[warn_smodgroups]" . "|" . "$vbulletin->options[warn_modgroups]";
	$management = preg_match("/(\||\A)".$vbulletin->userinfo['usergroupid']."(\||\z)/",$management);
	while($warn = $db->fetch_array($get_tps))
	{
		if ($warn[warn_alertcomment] != '')
		{
			if ($management == 1)
			{
				$warntypecomment = "<a href=\"showcomment.php?warningtypeid=" . $warn['warningtypeid'] . "\"  onclick=\"window.open('showcomment.php?warningtypeid=" . $warn['warningtypeid'] . "','','width=500, height=300, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">" . $vbphrase['aws_yes'] . "</a>";
			}
			else
			{
				$warntypecomment = $vbphrase['aws_yes'];
			}
		}
		else
		{
			$warntypecomment = $vbphrase['aws_no'];
		}
		eval('$warn_page .= "' . fetch_template('warn_viewtype_row') . '";');
	}
	eval('$warn_page .= "' . fetch_template('warn_viewtype_end') . '";');
}
//######################################################################################################################################
if($_POST['do'] == "DoWarnUserNoPost")
{
	$vbulletin->input->clean_array_gpc('p',array(
		'id'            => TYPE_INT,
		'post'          => TYPE_INT,
		'do'            => TYPE_STR,
		'return'        => TYPE_STR,
		'warningid'     => TYPE_INT,
		'comment'       => TYPE_STR,
		'alert'         => TYPE_STR,
	));
	if ((!($vbulletin->GPC['comment']) OR vbstrlen($vbulletin->GPC['comment']) < $vbulletin->options['warn_min_comment_length']) AND $vbulletin->options['warn_min_comment_length'] > 0)
	{
		RunErrorAws($vbphrase['aws_you_must_enter_minimum_x_symbols_in_comment']);
	}
	$navbits['Warn.php?' . $vbulletin->session->vars['sessionurl'] . "do=WarnUser&id={$vbulletin->GPC['id']}"] = $vbphrase['aws_warnuser'];
    $navbits[""] = $vbphrase['aws_warninguser'];
	$pagetitle = $vbphrase['aws_warninguser'];
	$return = addslashes($vbulletin->GPC['return']);
    $alert = $vbulletin->GPC['alert'];
	check_user($vbulletin->GPC['id'], $vbulletin->options['warn_protected_usergroups']);
	check_bans($vbulletin->GPC['id']);
	$slcomment = $vbulletin->GPC['comment'];
	if ($alert == '')
	{
		$alert = '0';
	}
	warn_calculations($vbulletin->GPC['warningid'], $slcomment, $vbulletin->GPC['post'], $user, $vbulletin->userinfo['userid'], $alert);
	if ($level == '')
	{
		$level = $user['warning_level'];
	}
	if ($message_left != $vbphrase['aws_typenotallow'] . " " . $vbphrase['aws_takingyouback'])
	{
		$thread1 = $vbphrase['aws_nopostrelated'];
		$thread2 = $vbphrase['aws_nopostrelated'];
		$thread3 = '';
		warn_notify($thread1, $thread2, $thread3, $user, $vbulletin->userinfo['email'], $vbulletin->userinfo['username'], $vbulletin->userinfo['userid'], $warn_type, $level, $slcomment, $alert);
		if($vbulletin->options['warn_send_em_warning'] == 0 AND $vbulletin->options['warn_send_pm_warning'] == 0)
		{
			$message_left = "{$user['username']} " . $vbphrase['aws_warnedandnotpmemail'] . " " . $vbphrase['aws_tackingtopost'];
		}
		if($vbulletin->options['warn_send_em_warning'] == 1 AND $vbulletin->options['warn_send_pm_warning'] == 1)
		{
			$message_left = "{$user['username']} " . $vbphrase['aws_warnedandpmemail'] . " " . $vbphrase['aws_tackingtopost'];
		}
	}
	$return = $vbulletin->GPC['return'];
	if ($return == 'user')
	{
		$admincpdir = $vbulletin->config['Misc']['admincpdir'];
		$url = "{$vbulletin->options['bburl']}/$admincpdir/user.php?do=edit&userid={$vbulletin->GPC['id']}";
	}
	else
	{
		$url = "{$vbulletin->options['bburl']}/member.php?u={$vbulletin->GPC['id']}";
	}
	eval('$warn_page .= "' . fetch_template('warn_redirect') . '";');
}
//######################################################################################################################################
if($_GET['do'] == "ViewMyWarnings")
{
	$vbulletin->input->clean_array_gpc('g',array(
		'id'      => TYPE_INT,
		'post'    => TYPE_INT,
		'do'     => TYPE_STR,
		'return' => TYPE_STR,
	));
	$navbits['Warn.php?' . $vbulletin->session->vars['sessionurl'] . "do=ViewMyWarnings"] = $vbphrase['aws_yourwarns'];
    $navbits[""] = $vbphrase['aws_viewyourwarns'];
	$pagetitle = $vbphrase['aws_viewyourwarns'];
   
	if (!($vbulletin->userinfo['permissions']['awspermissions'] & $vbulletin->bf_ugp_awspermissions['canviewwarnings']))
	{
		RunErrorAws($vbphrase['aws_you_have_no_perm_to_view_warninfo']);
	}
    $user = $vbulletin->userinfo;
    eval('$warn_page .= "' . fetch_template('warn_view_top') . '";');
	$get_warns=$db->query_read("SELECT w.*, u.username AS wusername, u.userid AS wuserid, wt.* FROM
    	" . TABLE_PREFIX . "warnings w
    	LEFT JOIN " . TABLE_PREFIX . "user u ON(u.userid = w.warned_by)
    	LEFT JOIN " . TABLE_PREFIX . "warningtype wt ON(wt.warningtypeid = w.warned_warning_id)
    	WHERE w.warned_user = '{$user['userid']}' ORDER BY w.warned_time DESC");
	while($warn = $db->fetch_array($get_warns))
	{
		$warn[date] = vbdate ($vbulletin->options['dateformat'], $warn[warned_time]);
        $warn[time] = vbdate ($vbulletin->options['timeformat'], $warn[warned_time]);
        $wmessage = stripslashes($warn['warned_reason']);

		eval('$warn_page .= "' . fetch_template('warn_view_row') . '";');
	}
	eval('$warn_page .= "' . fetch_template('warn_view_end') . '";');
	eval('$warn_page .= "' . fetch_template('warn_viewtype_top') . '";');
	$get_tps = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "warningtype ORDER BY warn_points");

	while($warn = $db->fetch_array($get_tps))
	{
		if ($warn[warn_alertcomment] != '')
		{
			if (can_moderate())
			{
				$warntypecomment = "<a href=\"showcomment.php?warningtypeid=" . $warn['warningtypeid'] . "\"  onclick=\"window.open('showcomment.php?warningtypeid=" . $warn['warningtypeid'] . "','','width=500, height=300, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">" . $vbphrase['aws_yes'] . "</a>";
			}
			else
			{
				$warntypecomment = $vbphrase['aws_yes'];
			}
		}
		else
		{
			$warntypecomment = $vbphrase['aws_no'];
		}
		eval('$warn_page .="' . fetch_template('warn_viewtype_row') . '";');
	}
	eval('$warn_page .= "' . fetch_template('warn_viewtype_end') . '";');
}
//######################################################################################################################################
if($_GET['do'] == "ViewWarnings")
{
	$vbulletin->input->clean_array_gpc('g',array(
		'id'       => TYPE_INT,
		'post'     => TYPE_INT,
		'do'       => TYPE_STR,
		'return'  => TYPE_STR,
	));
	$navbits['Warn.php?' . $vbulletin->session->vars['sessionurl'] . "do=ViewWarnings&id={$vbulletin->GPC['id']}"] = $vbphrase['aws_viewwarns'];
    $navbits[""] = $vbphrase['aws_viewvingwarns'];
	$pagetitle = $vbphrase['aws_viewvingwarns'];
	if($vbulletin->GPC['id'] == "" || !$vbulletin->GPC['id'] || $vbulletin->GPC['id'] <= 1)
	{
		RunErrorAws($vbphrase['aws_invuserid']);
	}
	if(!$user = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "user WHERE userid = '{$vbulletin->GPC['id']}'"))
	{
		RunErrorAws($vbphrase['aws_usernotexist']);
	}
	eval('$warn_page .= "' . fetch_template('warn_viewb_top') . '";');

	$get_warns = $db->query("SELECT w.*, u.username AS wusername, u.userid AS wuserid, wt.* FROM
		" . TABLE_PREFIX . "warnings w
		LEFT JOIN " . TABLE_PREFIX . "user u ON(u.userid = w.warned_by)
		LEFT JOIN " . TABLE_PREFIX . "warningtype wt ON(wt.warningtypeid = w.warned_warning_id)
		WHERE w.warned_user = '{$user['userid']}' ORDER BY w.warned_time DESC");

	while($warn = $db->fetch_array($get_warns))
	{
		$warn[date] = vbdate ($vbulletin->options['dateformat'], $warn[warned_time]);
	    $warn[time] = vbdate ($vbulletin->options['timeformat'], $warn[warned_time]);
	    $wmessage = stripslashes($warn['warned_reason']);

		eval('$warn_page .= "' . fetch_template('warn_viewb_row') . '";');
	}
	eval('$warn_page .= "' . fetch_template('warn_viewb_end') . '";');
	eval('$warn_page .= "' . fetch_template('warn_viewtype_top') . '";');
	$get_tps = $db->query("SELECT * FROM " . TABLE_PREFIX . "warningtype ORDER BY warn_points, warn_maturity");
	while($warn = $db->fetch_array($get_tps))
	{
		if ($warn[warn_alertcomment] != '')
		{
			if (can_moderate())
			{
				$warntypecomment = "<a href=\"showcomment.php?warningtypeid=" . $warn['warningtypeid'] . "\"  onclick=\"window.open('showcomment.php?warningtypeid=" . $warn['warningtypeid'] . "','','width=500, height=300, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">" . $vbphrase['aws_yes'] . "</a>";
			}
			else
			{
				$warntypecomment = $vbphrase['aws_yes'];
			}
		}
		else
		{
			$warntypecomment = $vbphrase['aws_no'];
		}
		eval('$warn_page .= "' . fetch_template('warn_viewtype_row') . '";');
	}

	eval('$warn_page .= "' . fetch_template('warn_viewtype_end') . '";');
}
//######################################################################################################################################
if($_GET['do'] == "ViewPostWarnings")
{
	$vbulletin->input->clean_array_gpc('g',array(
		'id'      => TYPE_INT,
		'post'    => TYPE_INT,
		'do'      => TYPE_STR,
		'return'  => TYPE_STR,
	));
	$navbits['Warn.php?' . $vbulletin->session->vars['sessionurl'] . "do=ViewPostWarnings&post={$vbulletin->GPC['post']}"] =  $vbphrase['aws_viewwarns'];
    $navbits[""] =  $vbphrase['aws_viewvingwarns'];
	$pagetitle = $vbphrase['aws_viewvingwarns'];
	if($vbulletin->GPC['post'] == "" || !$vbulletin->GPC['post'] || $vbulletin->GPC['post'] < 1)
	{
		RunErrorAws($vbphrase['aws_invpost']);
	}
	eval('$warn_page .= "' . fetch_template('warn_viewc_top') . '";');
	$get_warns = $db->query("SELECT w.*, u.username AS wusername, u.userid AS wuserid, wt.* FROM
		" . TABLE_PREFIX . "warnings w
		LEFT JOIN " . TABLE_PREFIX . "user u ON(u.userid = w.warned_by)
		LEFT JOIN " . TABLE_PREFIX . "warningtype wt ON(wt.warningtypeid = w.warned_warning_id)
		WHERE w.warned_post = '{$vbulletin->GPC['post']}' ORDER BY w.warned_time DESC");
	while($warn = $db->fetch_array($get_warns))
	{
		$warn[date] = vbdate ($vbulletin->options['dateformat'], $warn[warned_time]);
        $warn[time] = vbdate ($vbulletin->options['timeformat'], $warn[warned_time]);
        
        eval('$warn_page .= "' . fetch_template('warn_viewc_row') . '";');
	}
	eval('$warn_page .= "' . fetch_template('warn_viewc_end') . '";');
}
//#######################################################################################################################################
if($_GET['do'] == "RemoveWarning")
{
	$vbulletin->input->clean_array_gpc('g',array(
		'id'      => TYPE_INT,
		'post'    => TYPE_INT,
		'do'      => TYPE_STR,
		'return'  => TYPE_STR,
	));
	$navbits['Warn.php?' . $vbulletin->session->vars['sessionurl'] . "do=RemoveWarning&id=$warn[userid]"] = $vbphrase['aws_removewarns'];
	$navbits[""]= $vbphrase['aws_removewarns'];
	$pagetitle = $vbphrase['aws_removewarns'];
	if(!$warn = $db->query_first("SELECT w.*, wt.*, u.* FROM " . TABLE_PREFIX . "warnings w 
    	LEFT JOIN " . TABLE_PREFIX . "warningtype wt ON(wt.warningtypeid = w.warned_warning_id) 
    	LEFT JOIN " . TABLE_PREFIX . "user u ON(u.userid = w.warned_user) WHERE w.wid = '{$vbulletin->GPC['id']}'"))
	{
		RunErrorAws($vbphrase['aws_warnnotfoundinbd']);
	}

	$level = ($warn['warning_level'] - $warn['warn_points']);

    $level = (int)$level;
    if($level < 1)
    {
		$level = 0;
	}
	$userdm=& datamanager_init('User',$vbulletin,ERRTYPE_ARRAY);
	$userdm->set_existing($warn);
	$userdm->set('warning_level',$level);
	$userdm->save();
	unset($userdm);
	$warnings = $warn['warns'] - 1;
	if ($warnings < 1)
	{
		$warnings = 0;
	}
	$userdm=& datamanager_init('User',$vbulletin,ERRTYPE_ARRAY);
	$userdm->set_existing($warn);
	$userdm->set('warns',$warnings);
	$userdm->save();
	unset($userdm);
	if($vbulletin->options['warn_historical'] == 0)
	{
		$db->query("DELETE FROM " . TABLE_PREFIX . "warnings WHERE wid = '{$warn['wid']}'");
		$db->query_write("UPDATE " . TABLE_PREFIX . "post SET warn_flag = 0 WHERE postid = '$warn[warned_post]'");
	}
	else
	{
		$r = $vbulletin->userinfo['userid'];
	    $t = time();
	    $db->query_write("UPDATE " . TABLE_PREFIX . "warnings SET warned_status = 'I', removed_by = '{$r}', removed_date = '{$t}' WHERE wid = '{$warn['wid']}'");
	}

	if ($warn['warned_post'] != 0)
	{
		$wf = $db->query_read("SELECT warn_flag FROM " . TABLE_PREFIX . "post WHERE postid = '{$warn['warned_post']}'");
	    $wflag = $wf['warn_flag'] - 1;
	    if ($wflag < 0)
		{
			$wflag = 0;
		}
		$db->query_write("UPDATE " . TABLE_PREFIX . "post SET warn_flag = '{$wflag}' WHERE postid = '{$warn['warned_post']}'");
	    $thread1 = "[URL='{$vbulletin->options['bburl']}/showthread.php?p={$warn['warned_post']}']" . $vbphrase['aws_warnedpost'] . "[/URL]";
	    $thread2 = "{$vbulletin->options['bburl']}/showthread.php?p={$warn['warned_post']}";
	}
	else
	{
		$thread1 = $vbphrase['aws_nopostrelated'];
		$thread2 = $vbphrase['aws_nopostrelated'];
	}
	$user = array_merge((array)$user,convert_bits_to_array($user['options'],$vbulletin->bf_misc_useroptions));
	$perms = fetch_permissions(0, $user['userid'], $user);
	if($user['options'] & $vbulletin->bf_misc_useroptions['receivepm'])
	{
		$donotpmhim=0;
	}
	else
	{
		$donotpmhim=1;
	}
	if($vbulletin->options['warn_send_pm_warning'] == 1 AND $donotpmhim==0)
	{
		$messageb = "";
		$aws_phrase = build_aws_language($warn['userid']);
        eval('$messageb .= "' . fetch_template('warn_pm_remove') . '";');

		$title = $aws_phrase['aws_message_warnhasbeenrem'];

		$recipients = $warn['username'];
		if ($vbulletin->options['warn_warner'] == "0")
		{
			$fromuserid = $vbulletin->userinfo['userid'];
			$fromusername = $vbulletin->userinfo['username'];
		}
		else
		{
			$fromuserid = $vbulletin->options['warn_warner'];
			$fromusername = $warn['warned_by'];
		}

		SendPMAws($fromuserid,$fromusername,$title,$messageb,$recipients);
		$message_left = $vbphrase['aws_warnremovedsecc'] . " {$warn['username']} " . $vbphrase['aws_haspm'] . " " . $vbphrase['aws_takingyouback'];
	}

	if($vbulletin->options['warn_send_em_warning'] == 1 AND $donotpmhim==1)
	{
		$messageb = "";

		$aws_phrase = build_aws_language($warn['userid']);

        eval('$messageb .= "' . fetch_template('warn_em_remove') . '";');

		$title = "{$vbulletin->options['messagetag']} - " . $aws_phrase['aws_message_warnhasbeenrem'];

		$to = $warn['userid'];
		if ($vbulletin->options['warn_warner'] == 0)
		{
			$fromemail = $vbulletin->userinfo['email'];
			$fromname = $vbulletin->userinfo['username'];
		}else if($vbulletin->options['warn_mailfrom'] == 1 AND $vbulletin->options['warn_mailfromaddress'] !='')
		{
			$fromemail = $vbulletin->options['warn_mailfromaddress'];
		}
		else
		{
			$warnerdata = $db->query_first("SELECT username, email FROM " . TABLE_PREFIX . "user where userid = '{$vbulletin->options['warn_warner']}'");
		    $fromemail = $warnerdata['email'];
		    $fromname = $warnerdata['username'];
		}
		
		vbmail($warn['email'], $title, $messageb, false, $fromemail, '', $fromname);
        $message_left = $vbphrase['aws_warnremovedsecc'] . " {$warn['username']} " . $vbphrase['aws_hasemail'] . " " . $vbphrase['aws_takingyouback'];
	}

	if ($vbulletin->options['warn_send_em_warning'] == 0 AND $vbulletin->options['warn_send_pm_warning'] == 0)
	{
		$message_left = $vbphrase['aws_warnremovedsecc'] . " {$warn['username']} " . $vbphrase['aws_hasnotpmoremail'] . " " . $vbphrase['aws_takingyouback'];
	}

	if ($vbulletin->options['warn_send_em_warning'] == 1 AND $vbulletin->options['warn_send_pm_warning'] == 1)
	{
		$message_left = $vbphrase['aws_warnremovedsecc'] . " {$warn['username']} " . $vbphrase['aws_haspmandemail'] . " " . $vbphrase['aws_takingyouback'];
	}
	$navbits['Warn.php?' . $vbulletin->session->vars['sessionurl'] . "do=ViewWarnings&id=$warn[userid]"] = $vbphrase['aws_viewwarns'];
	$navbits[""]= $vbphrase['aws_viewyourwarns'];
	$pagetitle = $vbphrase['aws_viewyourwarns'];

	$url = "Warn.php?$session[sessionurl]&do=ViewWarnings&id=$warn[userid]";

    eval('$warn_page .= "' . fetch_template('warn_redirect') . '";');
}
//######################################################################################################################################
if($_GET['do'] == "NoteUser")
{
	$vbulletin->input->clean_array_gpc('g',array(
		'id'      => TYPE_INT,
		'post'    => TYPE_INT,
		'do'      => TYPE_STR,
		'return'  => TYPE_STR,
	));
	$userinfo = verify_id('user', $vbulletin->GPC['id'], 0, 1);
	$joindate = vbdate($vbulletin->options['dateformat'],$userinfo['joindate']);
	$lastactivity = vbdate($vbulletin->options['dateformat'],$userinfo['lastactivity'],true);
	$lastactivitytime = vbdate($vbulletin->options['timeformat'],$userinfo['lastactivity'],true);
	$navbits['Warn.php?' . $vbulletin->session->vars['sessionurl'] . "do=NoteUser&id={$vbulletin->GPC['id']}&post={$vbulletin->GPC['post']}"] = $vbphrase['aws_warnuser'];
    $navbits[""] = $vbphrase['aws_addingnoteforuser'];
	$pagetitle = $vbphrase['aws_addingnoteforuser'];
	if (!($vbulletin->userinfo['permissions']['awspermissions'] & $vbulletin->bf_ugp_awspermissions['cannote']))
	{
		RunErrorAws($vbphrase['aws_you_have_no_perm_to_enter_notes']);
	}
    check_user($vbulletin->GPC['id'], $vbulletin->options['warn_protected_usergroups']);
	$post = $vbulletin->GPC['post'];
	eval('$warn_page .= "' . fetch_template('warn_addnote') . '";');
}
//######################################################################################################################################
if($_POST['do'] == "DoNoteUser")
{
	$vbulletin->input->clean_array_gpc('p',array(
		'id' => TYPE_INT,
		'post' => TYPE_INT,
		'postspec' => TYPE_INT,
		'do' => TYPE_STR,
		'return' => TYPE_STR,
		'note' => TYPE_STR,
		'type' => TYPE_INT,

	));
	$navbits['Warn.php?' . $vbulletin->session->vars['sessionurl'] . "do=NoteUser&id={$vbulletin->GPC['id']}&post={$vbulletin->GPC['post']}"] = $vbphrase['aws_warnuser'];
    $navbits[""] = $vbphrase['aws_addingnoteforuser'];
	$pagetitle = $vbphrase['aws_addingnoteforuser'];
	check_user($vbulletin->GPC['id'], $vbulletin->options['warn_protected_usergroups']);
	$note = $vbulletin->GPC['note'];
    $bbuser = $vbulletin->userinfo['userid'];
    $return_post = $vbulletin->GPC['post'];
	if ($vbulletin->GPC['postspec'] == 1)
	{
		$spost = $vbulletin->GPC['post'];
	}
	else
	{
		$spost = '0';
	}
	$note = addslashes($note);
	$db->query_write("INSERT INTO " . TABLE_PREFIX . "warn_notes (wid, warned_user, warned_by, warned_time, warned_note, warned_post, warned_type) VALUES ('','{$vbulletin->GPC['id']}','{$bbuser}','" . time() . "','{$note}','{$spost}','{$vbulletin->GPC['type']}')");
	$db->query_write("UPDATE " . TABLE_PREFIX . "user SET warn_notes = '1' WHERE userid = '{$vbulletin->GPC['id']}'");
	if ($return_post != '0')
	{
		$message_left = $vbphrase['aws_noteadded'] . " " . $vbphrase['aws_tackingtopost'];
	    $url = "showthread.php?p={$vbulletin->GPC['post']}";
	}
	else
	{
		$message_left = $vbphrase['aws_noteadded'] . " " . $vbphrase['aws_tackingbacktouserprof'];
	    $url = "member.php?userid={$vbulletin->GPC['id']}";

	}
	eval('$warn_page .= "' . fetch_template('warn_redirect') . '";');
}
//######################################################################################################################################
if($_GET['do'] == "RemoveNote")
{
	$vbulletin->input->clean_array_gpc('g',array(
		'noteid' => TYPE_INT,
		'postid' => TYPE_INT,
	));
	$navbits['Warn.php?' . $vbulletin->session->vars['sessionurl'] . "do=NoteUser&id={$vbulletin->GPC['id']}&post={$vbulletin->GPC['post']}"] = $vbphrase['aws_warnuser'];
   $navbits[""] = $vbphrase['aws_deletingusernote'];
   $pagetitle = $vbphrase['aws_deletingusernote'];

	if (!$note = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "warn_notes WHERE wid = '{$vbulletin->GPC['noteid']}'"))
	{
	    $message_left = $vbphrase['aws_notenotfound'] . " " . $vbphrase['aws_tackingtopost'];
		$url = "showthread.php?p={$vbulletin->GPC['postid']}";
		
		eval('$warn_page .= "' . fetch_template('warn_redirect') . '";');
	}
	else
	{
		$tuser = $note['warned_user'];
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "warn_notes WHERE wid = '{$vbulletin->GPC['noteid']}'");
		if (!$others = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "warn_notes WHERE warned_user = '{$tuser}'"))
		{
			$db->query_write("UPDATE " . TABLE_PREFIX . "user SET warn_notes = '0' WHERE userid = '{$tuser}'");
		}
		if ($vbulletin->GPC['postid'] != '')
		{
			$message_left = $vbphrase['aws_notedeleted'] . " " . $vbphrase['aws_tackingtopost'];
			$url = "showthread.php?p={$vbulletin->GPC['postid']}";
		}
		else
		{
			$message_left = $vbphrase['aws_notedeleted'] . " " . $vbphrase['aws_tackingbacktouserprof'];
			$url = "member.php?userid={$tuser}";
		}
		eval('$warn_page .= "' . fetch_template('warn_redirect') . '";');
	}
}
$navbits = construct_navbits($navbits);
eval('$navbar = "' . fetch_template('navbar') . '";');
eval('print_output("' . fetch_template('WARN') . '");');
/*======================================================================*\
|| #################################################################### ||
|| # vB3 Advanced Warning System V3.6.0 By John Caradimas SV1CEC
|| # vBulletin 3.5.x 3.6.x Support Delphiprogrammi
|| #################################################################### ||
\*======================================================================*/
?>
