<?php
/*======================================================================*\
|| #################################################################### ||
|| # vB3 Advanced Warning System (AWS) By John Caradimas SV1CEC         ||
|| AWS Version 3.4.12
|| vBulletin 3.5.x 3.6.x support Delphiprogrammi
|| #################################################################### ||
\*======================================================================*/

// ######################### ERROR REPORTING #############################

error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('GET_EDIT_TEMPLATES', true);
define('THIS_SCRIPT', 'mod_warn');

$modcpdir = "{$vbulletin->config['Misc']['modcpdir']}";

require_once('./global.php');
require_once(DIR . '/includes/functions_misc.php');
require_once(DIR . '/includes/functions_warning.php');

$AWS_VERSION = $vbulletin->options['warn_version'];

// ###################### View Warning Logs ########################
// ###################### View Warn Options ########################

if($_GET['do'] != "showcomment")
{
	$vbulletin->input->clean_array_gpc('r',array(
		'wid'       => TYPE_INT,
		'perpage'   => TYPE_INT,
		'page'      => TYPE_INT,
		'orderby'   => TYPE_STR,
		'order'     => TYPE_STR,
		'script'    => TYPE_STR,
	));

	$s1t = 'w.warned_user ASC';
    $s2t = 'w.warned_user DESC';
    $s3t = 'u.username ASC';
    $s4t = 'u.username DESC';
    $s5t = 'w.warned_post ASC';
    $s6t = 'w.warned_post DESC';
    $s7t = 'wt.title ASC';
    $s8t = 'wt.title DESC';
    $s9t = 'wt.warn_points ASC';
    $s10t = 'wt.warn_points DESC';
    $s11t = 'w.warned_time ASC';
    $s12t = 'w.warned_time DESC';
    $s13t = 'maturitydate ASC ';
    $s14t = 'maturitydate DESC';
    $s15t = 'w.removed_date ASC';
    $s16t = 'w.removed_date DESC';

	$perpage = $vbulletin->options['warn_warnings_per_page'];

	if ($perpage == '' OR $perpage == 0)
	{
		$perpage = 15;
	}

	$page = $vbulletin->GPC['page'];
	if ($page < 1)
	{
		$page = 1;
	}
	$startat = ($page - 1) * $perpage;

	if ($vbulletin->options['warn_modoption'] == 0)
	{
		$counter = $db->query_first("SELECT COUNT(*) AS warnings FROM " . TABLE_PREFIX . "warnings AS warning WHERE warned_by = {$vbulletin->userinfo['userid']}");
	}
	else
	{
		$counter = $db->query_first("SELECT COUNT(*) AS warnings FROM " . TABLE_PREFIX . "warnings AS warning WHERE warned_by = {$vbulletin->userinfo['userid']}");
	}

	$totalpages = ceil($counter['warnings'] / $perpage);

	if ($orderby == '')
	{
		if($vbulletin->GPC['order'] == '')
		{
			$orderby = $s12t;
		}
		else
		{
			$orderby = $vbulletin->GPC['order'];
		}
	}
	switch($orderby)
	{
		case $s1t:
			$orderbycom = $vbphrase['aws_warneduserid'] . ', ' . $vbphrase['aws_ascending'];
			break;
		 case $s2t:
			$orderbycom = $vbphrase['aws_warneduserid'] . ', ' . $vbphrase['aws_descending'];
			break;
		case $s3t:
			$orderbycom = $vbphrase['aws_warnername'] . ', ' . $vbphrase['aws_ascending'];
			break;
		case $s4t:
			$orderbycom = $vbphrase['aws_warnername'] . ', ' . $vbphrase['aws_descending'];
			break;
		case $s5t:
			$orderbycom = $vbphrase['aws_warnedpost'] . ', ' . $vbphrase['aws_ascending'];
			break;
		case $s6t:
			$orderbycom = $vbphrase['aws_warnedpost'] . ', ' . $vbphrase['aws_descending'];
			break;
		case $s7t:
			$orderbycom = $vbphrase['aws_warningtype'] . ', ' . $vbphrase['aws_ascending'];
			break;
		case $s8t:
			$orderbycom = $vbphrase['aws_warningtype'] . ', ' . $vbphrase['aws_descending'];
			break;
		case $s9t:
			$orderbycom = $vbphrase['aws_warnedpoints'] . ', ' . $vbphrase['aws_ascending'];
			break;
		case $s10t:
			$orderbycom = $vbphrase['aws_warnedpoints'] . ', ' . $vbphrase['aws_descending'];
			break;
		case $s11t:
			$orderbycom = $vbphrase['aws_warningdate'] . ', ' . $vbphrase['aws_ascending'];
			break;
		case $s12t:
			$orderbycom = $vbphrase['aws_warningdate'] . ', ' . $vbphrase['aws_descending'];
			break;
		case $s13t:
			$orderbycom = $vbphrase['aws_maturitydate'] . ', ' . $vbphrase['aws_ascending'];
			break;
		case $s14t:
			$orderbycom = $vbphrase['aws_maturitydate'] . ', ' . $vbphrase['aws_descending'];
			break;
		case $s15t:
			$orderbycom = $vbphrase['aws_removaldate'] . ', ' . $vbphrase['aws_ascending'];
			break;
		case $s16t:
			$orderbycom = $vbphrase['aws_removaldate'] . ', ' . $vbphrase['aws_descending'];
			break;
	}
	$order = $orderby;
	
	if ($vbulletin->options['warn_modoption'] == 0)
	{
		$get_warns = $db->query_read("SELECT w.*, u.username AS wusername, u.userid AS wuserid, wt.*, wuser.username AS warned_username_v, wuser.userid AS warned_userid_v, ruser.username AS removed_by_v, (w.warned_time + wt.warn_maturity * 24 * 60 * 60) AS maturitydate FROM
			" . TABLE_PREFIX . "warnings w
			LEFT JOIN " . TABLE_PREFIX . "user wuser ON(wuser.userid = w.warned_user)
			LEFT JOIN " . TABLE_PREFIX . "user u ON(u.userid = w.warned_by)
			LEFT JOIN " . TABLE_PREFIX . "user ruser ON(ruser.userid = w.removed_by)
			LEFT JOIN " . TABLE_PREFIX . "warningtype wt ON(wt.warningtypeid = w.warned_warning_id) 
			WHERE warned_by = " . $vbulletin->userinfo['userid'] . " ORDER BY $orderby LIMIT $startat, $perpage");
	}
	else
	{
		$get_warns = $db->query_read("SELECT w.*, u.username AS wusername, u.userid AS wuserid, wt.*, wuser.username AS warned_username_v, wuser.userid AS warned_userid_v, ruser.username AS removed_by_v, (w.warned_time + wt.warn_maturity * 24 * 60 * 60) AS maturitydate FROM " . TABLE_PREFIX . "warnings w 
			LEFT JOIN " . TABLE_PREFIX . "user wuser ON(wuser.userid = w.warned_user) 
			LEFT JOIN " . TABLE_PREFIX . "user u ON(u.userid = w.warned_by) 
	    	LEFT JOIN " . TABLE_PREFIX . "user ruser ON(ruser.userid = w.removed_by)
	    	LEFT JOIN " . TABLE_PREFIX . "warningtype wt ON(wt.warningtypeid = w.warned_warning_id) ORDER BY $orderby LIMIT $startat, $perpage");
	}

	if ($db->num_rows($get_warns))
	{
		if ($page != 1)
		{
			$prv = $page - 1;
			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['aws_first_page'] . "\" tabindex=\"1\" onclick=\"window.location='mod_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$orderby&page=1'\">";
			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['aws_prev_page'] . "\" tabindex=\"1\" onclick=\"window.location='mod_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$orderby&page=$prv'\">";
		}

		if ($vbulletin->GPC['page'] != $totalpages)
		{
			$nxt = $page + 1;
			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_next_page'] . " &gt;\" tabindex=\"1\" onclick=\"window.location='mod_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$orderby&page=$nxt'\">";
			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_last_page'] . " &raquo;\" tabindex=\"1\" onclick=\"window.location='mod_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$orderby&page=$totalpages'\">";
		}
		$s1 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_asce'] . "\" tabindex=\"1\" onclick=\"window.location='mod_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s1t&page=1'\">";
		$s2 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_desc'] . "\" tabindex=\"1\" onclick=\"window.location='mod_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s2t&page=1'\">";
		$s3 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_asce'] . "\" tabindex=\"1\" onclick=\"window.location='mod_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s3t&page=1'\">";
		$s4 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_desc'] . "\" tabindex=\"1\" onclick=\"window.location='mod_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s4t&page=1'\">";
		$s5 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_asce'] . "\" tabindex=\"1\" onclick=\"window.location='mod_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s5t&page=1'\">";
		$s6 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_desc'] . "\" tabindex=\"1\" onclick=\"window.location='mod_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s6t&page=1'\">";
		$s7 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_asce'] . "\" tabindex=\"1\" onclick=\"window.location='mod_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s7t&page=1'\">";
		$s8 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_desc'] . "\" tabindex=\"1\" onclick=\"window.location='mod_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s8t&page=1'\">";
		$s9 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_asce'] . "\" tabindex=\"1\" onclick=\"window.location='mod_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s9t&page=1'\">";
		$s10 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_desc'] . "\" tabindex=\"1\" onclick=\"window.location='mod_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s10t&page=1'\">";
		$s11 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_asce'] . "\" tabindex=\"1\" onclick=\"window.location='mod_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s11t&page=1'\">";
		$s12 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_desc'] . "\" tabindex=\"1\" onclick=\"window.location='mod_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s12t&page=1'\">";
		$s13 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_asce'] . "\" tabindex=\"1\" onclick=\"window.location='mod_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s13t&page=1'\">";
		$s14 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_desc'] . "\" tabindex=\"1\" onclick=\"window.location='mod_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s14t&page=1'\">";
		$s15 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_asce'] . "\" tabindex=\"1\" onclick=\"window.location='mod_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s15t&page=1'\">";
		$s16 = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['aws_desc'] . "\" tabindex=\"1\" onclick=\"window.location='mod_warn.php?$session[sessionurl]do=viewlogs&script=$script&perpage=$perpage&orderby=$s16t&page=1'\">";
		
		$aa = ($page - 1) * $perpage + 1;
		if ($page < $totalpages)
		{
			$bb = $page * $perpage;
		}
		else
		{
			$bb = $counter['warnings'];
		}
		$cc = $counter['warnings'];

		print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");

		print_form_header('', '');
		if ($vbulletin->options['warn_modoption'] == 0)
		{
			$dd = $vbphrase['aws_viewingyourwarnings'];
		}
		else
		{
			$dd = $vbphrase['aws_viewingcompletewarnings'];
		}
		print_table_header($vbphrase['aws_warninglog'] . "<br>" . $vbphrase['aws_page'] . " $page " . $vbphrase['aws_of'] . " $totalpages<br>" . $vbphrase['aws_mod_warnings'] . " " .$vbphrase['aws_to1'] . " $aa " . $vbphrase['aws_to'] . " $bb " . $vbphrase['aws_of'] . " $cc<br>" . $vbphrase['aws_orderby'] . ": $orderbycom<br>$dd",12);

		$header = array();

		$header[] = "<b>" . $vbphrase['aws_warneduseridname'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_warnedby'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_warnedpost'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_warningtype'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_warnedpoints'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_warndate'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_maturitydate'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_comment'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_mod_remove'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_status'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_removedby'] . "</b>";
		$header[] = "<b>" . $vbphrase['aws_removaldate'] . "</b>";

		print_cells_row($header, 1);

		$sort_cell = array();

		$sort_cell[] = "<font size='-1'><center>$s1<br>$s2</center></font>";
        $sort_cell[] = "<font size='-1'><center>$s3<br>$s4</center></font>";
        $sort_cell[] = "<font size='-1'><center>$s5<br>$s6</center></font>";
        $sort_cell[] = "<font size='-1'><center>$s7<br>$s8</center></font>";
        $sort_cell[] = "<font size='-1'><center>$s9<br>$s10</center></font>";
        $sort_cell[] = "<font size='-1'><center>$s11<br>$s12</center></font>";;
        $sort_cell[] = "<font size='-1'><center>$s13<br>$s14</center></font>";
        $sort_cell[] = "<font size='-1'><center>&nbsp;<br>&nbsp;</center></font>";
        $sort_cell[] = "<font size='-1'><center>&nbsp;<br>&nbsp;</center></font>";
        $sort_cell[] = "<font size='-1'><center>&nbsp;<br>&nbsp;</center></font>";
        $sort_cell[] = "<font size='-1'><center>&nbsp;<br>&nbsp;</center></font>";
        $sort_cell[] = "<font size='-1'><center>$s15<br>$s16</center></font>";

		print_cells_row($sort_cell, 14, 'thead');

		while($warn = $db->fetch_array($get_warns))
		{
			$cell = array();

			$warn['date'] = vbdate($vbulletin->options['dateformat'],$warn['warned_time']);
			$warn['time'] = vbdate ($vbulletin->options['timeformat'],$warn['warned_time']);
			
			if($warn['warn_permban'] ==1)
			{
				$rdate = $vbphrase['aws_never'];
			}
			else
			{
				$rdate = $warn['maturitydate'];
				$rdate = vbdate ($vbulletin->options['dateformat'], $rdate);
			}
			if($warn['warned_userid_v'] == "")
			{
				$x = "<i>" . $vbphrase['aws_deleteduser'] . "</i>";
			}
			else
			{
				$x = "<a href=\"{$vbulletin->options[bburl]}/member.php?u={$warn[warned_userid_v]}\"  onclick=\"window.open('{$vbulletin->options[bburl]}/member.php?u={$warn[warned_userid_v]}','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">{$warn[warned_userid_v]}<br><b>{$warn['warned_username_v']}</a>";
			}
			if($warn['warn_permban'] == 1 OR $warn['warned_status'] == "I")
			{
				$y = "<i>" . $vbphrase['aws_notremovale'] . "</i>";
			}
			else
			{
				$y = "<a href='{$vbulletin->options[bburl]}/Warn.php?do=RemoveWarning&id={$warn[wid]}'>" . $vbphrase['aws_remove'] . "</a>";
			}
			if($warn['warned_status'] == "I")
			{
				$k = "<i>" . $vbphrase['aws_inactive'] . "</i>";
			}
			else
			{
				$k = $vbphrase['aws_active'];
			}
			$a = $warn[title];
			$p = $warn[warn_points];
            $b = $warn[date];
			$c = $warn[time];
			
			if ($a == $vbphrase['aws_obscenewordsinchat'])
			{
				$d = "<A HREF=\"{$vbulletin->options[bburl]}/$vbulletin->config['Misc']['admincpdir']/admin_warn.php?do=showcomment&id=$warn[wid]&name=$a&
				&reason = $warn[warned_reason]\"  onclick=\"window.open('{$vbulletin->options[bburl]}/$vbulletin->config['Misc']['admincpdir']/admin_warn.php?do=showcomment&id=$warn[wid]&name=$a&reason=$warn[warned_reason]','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">" . $vbphrase['aws_seecomment'] . "</a></font>";
			}
			else
			{
				$d = "<A HREF=\"{$vbulletin->options[bburl]}/{$modcpdir}/mod_warn.php?do=showcomment&id=$warn[wid]\"  onclick=\"window.open('{$vbulletin->options[bburl]}/{$modcpdir}/mod_warn.php?do=showcomment&id=$warn[wid]','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">" . $vbphrase['aws_seecomment'] . "</a></font>";
			}
			if ($warn['warned_status'] == "I")
			{
				if ($warn['removed_by'] == '0')
				{
					$r = $vbphrase['aws_cron'];
					$r2 = $r;
				}
				else
				{
					$r = $warn[removed_by_v];
					$r2 = "<a href=\"{$vbulletin->options[bburl]}/member.php?u={$warn['removed_by']}\"  onclick=\"window.open('{$vbulletin->options[bburl]}/member.php?u={$warn['removed_by']}','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">{$r}</a>";
				}
			}
			else
			{
				$r2 = '';
			}
			if ($warn['removed_date'] == '' OR $warn['removed_date'] == '0')
			{
				$t1 = '';
				$t2 = '';
			}
			else
			{
				$t1 = vbdate ( $vbulletin->options['dateformat'], $warn[removed_date] ) ;
	            $t2 = vbdate ( $vbulletin->options['timeformat'], $warn[removed_date] ) ;

			}
			if ($warn['warned_post'] == '' OR $warn['warned_post'] == '0')
			{
				$w = 'NPR';
			}
			else
			{
				$w = "<a href=\"{$vbulletin->options[bburl]}/showthread.php?p=$warn[warned_post]#post$warn[warned_post]\"  onclick=\"window.open('{$vbulletin->options[bburl]}/showthread.php?p=$warn[warned_post]#post$warn[warned_post]','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">{$warn[warned_post]}</a>";
			}
			if($warn['warned_status'] == "L")
			{
				$k = 'Alert';
		        $p = '';
		        $rdate = '';
		        $cb = '';
		        $y = '';
			}
			else
			{
				$p = $warn['warn_points'];
			}

			$cell[] = "<font size='-1'>{$x}</font>";
            $cell[] = "<font size='-1'><a href=\"{$vbulletin->options[bburl]}/member.php?u={$warn['wuserid']}\"  onclick=\"window.open('{$vbulletin->options[bburl]}/member.php?u={$warn['wuserid']}','','width=1024, height=500, resizable=yes, scrollbars=yes'); return false;\" target=\"_blank\">{$warn['wusername']}</a></font>";
            $cell[] = "<font size='-1'>{$w}</font>";
            $cell[] = "<font size='-1'>{$a}</font>";
            $cell[] = "<font size='-1'>{$p}</font>";
            $cell[] = "<font size='-1'>{$b}<br>{$c}</font>";
            $cell[] = "<font size='-1'>$rdate</font>";
            $cell[] = "<font size='-1'>{$d}</font>";
            $cell[] = "<font size='-1'>{$y}</font>";
            $cell[] = "<font size='-1'>{$k}</font>";
            $cell[] = "<font size='-1'>{$r2}</font>";
            $cell[] = "<font size='-1'>{$t1}<br>{$t2}</font>";

			print_cells_row($cell);
		}
		print_table_footer(12, "$firstpage $prevpage &nbsp; $nextpage $lastpage");
	}
	else
	{
		print_stop_message('aws_no_warnings_found');
	}
}
//######################################################################################################################################
if ($_GET['do'] == "showcomment")
{
	$vbulletin->input->clean_array_gpc('r', array(
	    'id'      => TYPE_INT,
	    'name'    => TYPE_STR,
	    'reason'  => TYPE_INT,
		'do'      => TYPE_STR,
	));
	$id = $vbulletin->GPC['id'];
	$name = $vbulletin->GPC['name'];
	$reason = $vbulletin->GPC['reason'];	

	print_cp_header($vbphrase['awsystem'] . " " . $vbphrase['aws_version'] . " {$AWS_VERSION}");
	
	if ($id == '')
	{
		$url = "{$modcpdir}/mod_warn.php?do=viewlogs";
		$wait = 5;
		print_cp_message($vbphrase['aws_wrongwarningid'], $url, $wait);
	}
	print_form_header('', '');
	print_table_header($vbphrase['aws_viewwarningcomment'], 1);

	$header = array();

	$header[] = "<b>" . $vbphrase['aws_comment'] . "</b>";
	print_cells_row($header, 1);

	if ($name == $vbphrase['aws_obscenewordsinchat'])
	{
		$original = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "vbchat_store_warned WHERE sid = $reason");
		$display = stripslashes($original['s_message']);
	}
	else
	{
		$original = $db->query_first("SELECT warned_reason FROM " . TABLE_PREFIX . "warnings WHERE wid = $id");
		$display = stripslashes($original['warned_reason']);
	}
	
	if ($display == '')
	{
		$cell[] = $vbphrase['aws_warnernotsendcomm'];
	}
	else
	{
		$cell[] = $display;
	}
	print_cells_row($cell);
}
//######################################################################################################################################
/*======================================================================*\
|| #################################################################### ||
|| # vB3 Advanced Warning System (AWS) By John Caradimas SV1CEC         ||
|| AWS Version 3.4.12
|| vBulletin 3.5.x 3.6.x support Delphiprogrammi
|| #################################################################### ||
\*======================================================================*/
?>