<?php
/*======================================================================*\
|| #################################################################### ||
|| # vB3 Advanced Warning System V3.6.0 By John Caradimas SV1CEC
|| # vBulletin 3.5.x 3.6.x Support Delphiprogrammi
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~ E_NOTICE);
if(!is_object($vbulletin->db))
{
	exit;
}

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// Global Requirements & Functions
require_once(DIR . '/includes/functions_user.php');
require_once(DIR . '/includes/functions_newpost.php');
require_once(DIR . '/includes/functions_warning.php');

// Cache templates
$globaltemplates = array(
	'warn_pm_remove',
	'warn_em_remove'
);

$style = $vbulletin->db->query_first_slave("
	SELECT templatelist
	FROM " . TABLE_PREFIX . "style
	LIMIT 1
");

cache_templates($globaltemplates, $style['templatelist']);


$warn_page = "";

$today = time();

$warns = $vbulletin->db->query_read("SELECT w.*, wt.*, u.* FROM " . TABLE_PREFIX . "warnings w 
	LEFT JOIN " . TABLE_PREFIX . "warningype wt ON(wt.warningtypeid = w.warned_warning_id) 
	LEFT JOIN " . TABLE_PREFIX . "user u ON(u.userid = w.warned_user) WHERE w.warned_status = 'A'
");

$pmedusers = '';
$tempids = '';
$logentry = 0;

while($warn = $vbulletin->db->fetch_array($warns))
{
	$date = $warn['warned_time'] + $warn['warn_maturity'] * 24 * 60 * 60;
	if ($today >= $date AND $warn['warn_permban'] != 1)
	{
		if ($logentry >= 1)
		{
			$pmedusers .= ', ';
		}

		$level = $warn['warning_level'] - $warn['warn_points'];
		if ($level < 1)
		{
			$level = 0;
		}

		$warnings = $warn['warns'] - 1;
		if ($warnings < 1)
		{
			$warnings = 0;
		}
		$userdm=& datamanager_init('User',$vbulletin,ERRTYPE_ARRAY);
		$userdm->set_existing($warn);
		$userdm->set('warning_level',$level);
		$userdm->set('warns',$warnings);
		$userdm->pre_save();
		if(!empty($userdm->errors))
		{
			die(print_r($userdm->errors));
		}
		else
		{
			$userdm->save();
		}
		unset($userdm);
		if ($vbulletin->options['warn_historical'] == 0)
		{
			$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "warnings WHERE wid = $warn[wid]");
			if (!($post_is_warned = $vbulletin->db->fetch_array($vbulletin->db->query_read("SELECT warned_post FROM " . TABLE_PREFIX . "warnings WHERE warned_post = " . $warn['warned_post']))))
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "post SET warn_flag = 0 WHERE postid = '$warn[warned_post]'");
			}
		}
		else
		{
			$t = time();
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "warnings SET warned_status = 'I', removed_by = '0', removed_date = '{$t}' WHERE wid = $warn[wid]");
		}

		$aws_phrase = build_aws_language($warn['userid']);

		if ($warn['warned_post'] != 0)
		{
			$thread1 = "[URL='{$vbulletin->options['bburl']}/showthread.php?p={$warn['warned_post']}']" . $aws_phrase['aws_message_warnedpost'] . "[/URL]";
			$thread2 = "{$vbulletin->options['bburl']}/showthread.php?p=$warn[warned_post]";
		}
		else
		{
			$thread1 = $aws_phrase['aws_nonpostrelwarn'];
			$thread2 = $aws_phrase['aws_nonpostrelwarn'];
		}
		$user = array_merge($user,convert_array_to_bits($user['options'],$vbulletin->bf_misc_useroptions));
		$perms = fetch_permissions(0,$user['userid'],$user);
		if($user['options'] & $vbulletin->bf_misc_useroptions['receivepm'])
		{
			$donotpmhim=0;
		}
		else
		{
			$donotpmhim=1;
		}
		if ($vbulletin->options['warn_send_pm_warning'] == 1 AND $donotpmhim=0)
		{
			$messageb = "";

			eval('$messageb .= "' . fetch_template('warn_pm_remove') . '";');

			$title = $aws_phrase['aws_message_warnhasbeenrem'];
			$recipients = $warn['warned_user'];
			if($vbulletin->options['warn_warner'] == "0")
			{
				$fromuserid = $vbulletin->userinfo['userid'];
				$fromusername = $vbulletin->userinfo['username'];
			}
			else
			{
				$fromuserid = $vbulletin->options['warn_warner'];
				$fromusername = $warn['warned_by'];
			}

			SendPMAws($fromuserid,$fromusername,$title,$messageb,$recipients);
		}
		if($vbulletin->options['warn_send_em_warning'] == 1 AND $donotpmhim=1)
		{
			$messageb = "";

			eval('$messageb .= "' . fetch_template('warn_em_remove') . '";');
		    
			$title = "{$vbulletin->options['messagetag']} - " . $aws_phrase['aws_message_warnhasbeenrem'];
			$to = $warn['warned_user'];
			if($vbulletin->options['warn_warner'] == "0")
			{
				$fromemail = $vbulletin->userinfo['email'];
				$fromname = $vbulletin->userinfo['username'];
			}else if($vbulletin->options['warn_mailfrom'] == 1 AND $vbulletin->options['warn_mailfromaddress'] !='')
			{
				$fromemail = $vbulletin->options['warn_mailfromaddress'];
			}
			else
			{
				$warnerdata = $vbulletin->db->query_read("SELECT username, email FROM " . TABLE_PREFIX . "user WHERE userid = $vbulletin->options[warn_warner]");
				$fromemail = $warnerdata['email'];
				$fromname = $warnerdata['username'];
			}
			vbmail($warn['email'], $title, $messageb, false, $fromemail, '', $fromname);
		}
		$pmedusers .= "$warn[username]";
		$logentry = $logentry + 1;
	}
}
log_cron_action($logentry, $nextitem, 1);
/*======================================================================*\
|| #################################################################### ||
|| # vB3 Advanced Warning System V3.6.0 By John Caradimas SV1CEC
|| # vBulletin 3.5.x 3.6.x Support Delphiprogrammi
|| #################################################################### ||
\*======================================================================*/
?>