<?php

/**
 * Route prefix handler for thread prefixes in the admin control panel.
 */
class XenForo_Route_PrefixAdmin_ThreadPrefixes implements XenForo_Route_Interface
{
	/**
	 * Match a specific route for an already matched prefix.
	 *
	 * @see XenForo_Route_Interface::match()
	 */
	public function match($routePath, Zend_Controller_Request_Http $request, XenForo_Router $router)
	{
		$action = $router->resolveActionWithIntegerParam($routePath, $request, 'prefix_id');
		return $router->getRouteMatch('XenForo_ControllerAdmin_ThreadPrefix', $action, 'threadPrefixes');
	}

	/**
	 * Method to build a link to the specified page/action with the provided
	 * data and params.
	 *
	 * @see XenForo_Route_BuilderInterface
	 */
	public function buildLink($originalPrefix, $outputPrefix, $action, $extension, $data, array &$extraParams)
	{
		return XenForo_Link::buildBasicLinkWithIntegerParam($outputPrefix, $action, $extension, $data, 'prefix_id', 'title');
	}
}