function insertnick(PostUserName, PostUserLink, ctrlPress, TaggSymbol)
{
    var insertString, editor = vB_Editor[QR_EditorID];
    if(editor == undefined)
    {
        return false;
    }
    if(ctrlPress)
    {
        insertString = editor.wysiwyg_mode ? '<a href="' + PostUserLink + '"><b>' + TaggSymbol + PostUserName + '</b></a>, ' : '[url="' + PostUserLink + '"][b]' + TaggSymbol + PostUserName + '[/b][/url], ';
    }
    else
    {
        insertString = editor.wysiwyg_mode ? '<b>' + TaggSymbol + PostUserName + '</b>, ' : '[b]' + TaggSymbol + PostUserName + '[/b], ';
    }
    editor.insert_text(insertString);
    editor.collapse_selection_end();
    editor.check_focus();
    if(typeof vBmenu != undefined)
    {
        setTimeout("vBmenu.hide()", 0);
    }
    return false;
}

var is_valid_tag = function(e)
{
    var targ = YAHOO.util.Event.getTarget(e);
    return (targ && targ.tagName != 'A' && targ.tagName != 'IMG' && targ.tagName != 'INPUT' && targ.tagName != 'TEXTAREA') ? true : false;
}

function QQPostDataEvents()
{
    this.Posts = new Array();
    this.currentUserID = (krquoteit['bbuserid'] > 0) ? krquoteit['bbuserid'] : 0;
    this.currentPost = null;
    this.isButtonHover = false;
    this.selectext = '';
    
    this.QQButton = new QQButtonEvents();
}

QQPostDataEvents.prototype.initPost = function(PostObject, PostID)
{
    if(PostObject && PostObject.id || PostID)
    {
        PostID = PostID || (PostObject.id != 'post' ? parseInt(PostObject.id.substr(4), 10) : '');
        var Post = fetch_object('td_post_' + PostID);
        if(Post)
        {
            Post.PostID = (PostID != '' ? PostID : 0);
            var PostUser = PostUserLink = PostUserName = PostUserID = TaggObj = null;
            if((PostUser = fetch_object('postmenu_' + PostID)) && (PostUserLink = fetch_tags(PostUser, 'a')))
            {
                for(var i = 0; i < PostUserLink.length; i++)
                {
                    if(PostUserLink[i].className == 'bigusername')
                    {
                        tmpHref = PostUserLink[i].href.split("=");
                        PostUserID = tmpHref[1];
                        // User tagging hack start
                        TaggObj = fetch_object('tagg_' + PostUserID);
                        if(TaggObj)
                        {
                            Post.TaggSymbol = '@';
                            TaggObj.outerHTML = '';
                            TaggObj = null;
                        }
                        else
                        {
                            Post.TaggSymbol = '';
                        }
                        // User tagging hack end
                        this.Posts[Post.PostID] = new QQPostUser(Post, PostUserID, PostUserLink[i], PostID);
                        break;
                    }
                }
            }
        }
    }
}

QQPostDataEvents.prototype.catchSelection = function()
{
    if(window.getSelection)
    {
        return window.getSelection().toString();
    }
    else if(document.getSelection)
    {
        return document.getSelection();
    }
    else if(document.selection)
    {
        return document.selection.createRange().text;
    }
}

function QQButtonEvents()
{
    this.isVisible = false;
    this.QQButton = document.createElement('div');
    this.QQButton.id = 'krqqdiv';
    this.QQButton.className = 'krqq_popupbutton';
    this.QQButton.style.display = 'none';
    this.QQButton.title = krquoteit['title'];
    this.QQButton.innerHTML = krquoteit['quoteit'];
    this.QQButton.PostID = 0;
    this.QQButton.PostUserName = '';
    this.QQButton.unselectable = 'on';
    
    this.HB = document.createElement('a');
    this.HB.href = '#';
    this.HB.style.padding = '0 3px';
    this.HB.innerHTML = 'x';
    this.HB.className = 'tborder alt1';
    this.HB.style.position = 'relative';
    this.HB.style.top = '-5px';
    this.HB.style.right = '-6px';
    this.HB.style.textDecoration = 'none';
    this.HB.style.opacity = 0.3;
    this.HB.style.zIndex = 101;
    this.HB.title = 'Hide this fucking button!';
    this.HB.onmouseover = function(){this.style.opacity = 1;}
    this.HB.onmouseout = function(){this.style.opacity = 0.3;}
    this.HB.onclick = function(e)
    {
        if(confirm('Are you sure?'))
        {
            expires = new Date();
            expires.setTime(expires.getTime() + 31536000000);
            set_cookie('QQDisabled', 1, expires);
            YAHOO.util.Event.stopEvent(e);
            QQpostData.QQButton.hideButton();
            return false;
        }
        else
        {
            alert('Okay, Okay...');
            return false;
        }
    }
    
    this.QQButton.onmouseover = function()
    {
        QQpostData.mouseOverOut(true, this);
    }
    this.QQButton.onmouseout = function()
    {
        QQpostData.mouseOverOut(false, this);
    }
    this.QQButton.onclick = function()
    {
        QQpostData.buttonClick(this);
    }
    this.QQButton.oncontextmenu = function()
    {
        return false;
    }
    this.QQButton.appendChild(this.HB);
    document.body.appendChild(this.QQButton);
}

QQButtonEvents.prototype.showButton = function(e)
{
    var coords = YAHOO.util.Event.getXY(e);
    if(!this.isVisible)
    {
        this.isVisible = true;
        this.QQButton.style.left = (coords[0] - 80) + 'px';
        this.QQButton.style.top = (coords[1] + 10) + 'px';
        this.QQButton.style.display = '';
    }
    this.setTimeOut = setTimeout("QQpostData.QQButton.hideButton()", krquoteit['displaytime']);
}
QQButtonEvents.prototype.hideButton = function()
{
    clearTimeout(this.setTimeOut);
    this.isVisible = false;
    this.QQButton.style.left = -100 + 'px';
    this.QQButton.style.top = -100 + 'px';
    this.QQButton.style.display = 'none';
}
QQPostDataEvents.prototype.buttonClick = function(e)
{
    e = YAHOO.util.Event.getEvent(e);
    if(QQpostData.pasteText(this, e) && typeof do_an_e == 'function')
    {
        do_an_e(e);
    }
}
function QQPostUser(Post, PostUserID, PostUserLink, PostID)
{
    this.Post = Post;
    this.PostUserID = PostUserID;
    this.PostID = PostID;
    this.TaggSymbol = Post.TaggSymbol;
    if(PostUserLink.textContent)
    {
        this.PostUserName = PostUserLink.textContent;
    }
    else if(is_ie && PostUserLink.innerText)
    {
        this.PostUserName = PostUserLink.innerText;
    }
    else
    {
        this.PostUserName = 'John Doe'; // :-)
    }
    
    if(!QQpostData.currentUserID)
    {
        QQpostData.currentUserID = (krquoteit['bbuserid'] > 0) ? krquoteit['bbuserid'] : 0;
    }
    
    if(QQpostData.currentUserID != PostUserID && PostUserID > 0)
    {
        if(!fetch_object('imgopen_' + PostID))
        {
            var menuOpenImage = new Image();
            menuOpenImage.src = IMGDIR_MISC + "/menu_open.gif";
            menuOpenImage.id = 'imgopen_' + PostID;
            menuOpenImage.className = 'inlineimg';
            menuOpenImage.style.paddingLeft = '2px';
            menuOpenImage.alt = '';
            menuOpenImage.title = krquoteit['usermenu'];
            menuOpenImage.border = '0';
            menuOpenImage.style.cursor = pointer_cursor;

            UserObj = document.createElement('a');
            UserObj.innerHTML = PostUserLink.innerHTML;
            UserObj.className = 'bigusername';
            UserObj.href = PostUserLink.href;
            UserObj.id = 'user_' + PostUserID + '_' + PostID;
            UserObj.title = krquoteit['insertnick_title'];

            PostUserLink.parentNode.insertBefore(UserObj, PostUserLink);
            PostUserLink.style.display = 'none';
            PostUserLink.outerHTML = '';

            UserObj.parentNode.appendChild(menuOpenImage);

            YAHOO.util.Event.on(UserObj, "click", function(e)
            {
                e = YAHOO.util.Event.getEvent(e), ctrlPress = (e.ctrlKey && !e.shiftKey) ? true : false;
                YAHOO.util.Event.preventDefault(e);
                insertnick(this.PostUserName, UserObj.href, ctrlPress, this.TaggSymbol);
                return false;
            }, this, true);
        }
    }
    this.Post.onmouseup = QQpostData.PostMouseUp;
}

QQPostDataEvents.prototype.pasteText = function(Obj, e)
{
    QQpostData.QQButton.hideButton();
    var Post = null;
    for(var PostID in this.Posts)
	{
        if(PostID == Obj.currentPost.PostID)
        {
            Post = this.Posts[PostID];
            break;
        }
    }
    var editor = vB_Editor[QR_EditorID],
    wysMode = editor.wysiwyg_mode,
    retCarret = '\n',
    editorContent = editor.get_editor_contents(),
    quoteString = '',
    prepend,
    selectxt = PHP.trim(this.currentPost.selectext.toString().replace(/(\r?\n\s*){2,}/gi,'\r\n').replace(/^\s+|\s+$/gi,'').replace(/(\ |\t)+/gi,' '));
    if(wysMode)
    {
        if(PHP.in_array(editorContent, ['', '<br />', '<br>', '<P>&nbsp;</P>', '&nbsp;', '<b></b>', '<b></b><br>', '<P></P>']) != -1)
        {
            editorContent = '';
        }
        selectxt = PHP.htmlspecialchars(selectxt);
        selectxt = selectxt.replace(/\n/g, '<br />');
        retCarret = '<br />';
        prepend = (editorContent.replace(/\<br\>/g, '') !== '') ? retCarret : '';
    }
    else
    {
        prepend = (editorContent !== '') ? retCarret : '';
    }
    if(selectxt != '' && Post !== null)
    {
        quoteString = prepend + '[quote' + (Post.PostUserName != '' ? '="' + Post.PostUserName + (Post.PostID > 0 ? ';' + Post.PostID : '') + '"' : '') + ']' + selectxt + '[/quote]' + retCarret;
        editor.insert_text(quoteString);
        editor.collapse_selection_end();
        wysMode ? editor.check_focus() : document.vbform.message.focus();
    }
    Obj.currentPost = null;
}
QQPostDataEvents.prototype.PostMouseUp = function(e)
{
    e = YAHOO.util.Event.getEvent(e);
    if(fetch_cookie('QQDisabled'))
    {
        return;
    }
    this.selectext = QQpostData.catchSelection();
    var clickedButton = (e.which !== undefined) ? e.which : e.button;
    if(this.selectext != '' && clickedButton == 1 && is_valid_tag(e) && typeof(document.forms.vbform) != 'undefined' && typeof(document.forms.vbform.message) != 'undefined')
    {
        QQpostData.currentPost = this;
        QQpostData.QQButton.PostID = this.PostID;
        QQpostData.QQButton.showButton(e);
    }
}
QQPostDataEvents.prototype.mouseOverOut = function(mode, Obj)
{
    this.isButtonHover = mode;
    if(mode)
    {
        clearTimeout(QQpostData.QQButton.setTimeOut);
        QQpostData.QQButton.PostID = this.currentPost.PostID;
    }
    else
    {
        QQpostData.QQButton.setTimeOut = setTimeout("QQpostData.QQButton.hideButton()", krquoteit['displaytime']);
    }
}

function quick_quote_init()
{
    var pPosts = fetch_tags(fetch_object('posts'), 'table');
    if(pPosts.length)
    {
        for(var i = 0; i < pPosts.length; i++)
        {
            if(pPosts[i] && pPosts[i].id)
            {
                var PostID = pPosts[i].id.substr(4);
                QQpostData.initPost(pPosts[i], PostID);
            }
        }
    }
    // Override vBulletin PostBit_Init function, by MDM
    QQPostBit_Init = PostBit_Init;
    PostBit_Init = function(obj, postid)
    {
        QQPostBit_Init(obj, postid);
        QQpostData.initPost(obj, postid);
    }
    YAHOO.util.Event.on(window, "mousedown", function()
    {
        if(QQpostData.QQButton.isVisible && !QQpostData.isButtonHover)
	    {
            QQpostData.QQButton.hideButton();
            QQpostData.currentPost.selectext = '';
	    }
    }, this, true);
}
var QQpostData = new QQPostDataEvents();
quick_quote_init();
