<?php
/*======================================================================*\
|| #################################################################### ||
|| # Mass Private Message 4.0.1										  # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2008-2011 Forums Mods. All Rights Reserved.           # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('user', 'cpuser', 'messaging', 'cprofilefield', 'profilefield');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_profilefield.php');
require_once(DIR . '/includes/adminfunctions_user.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminusers'))
{
	print_cp_no_permission();
}

// ############################# LOG ACTION ###############################
log_admin_action();

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['pm_manager']);

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'start';
}

// *************************** Send a page of private messages **********************
if ($_REQUEST['do'] == 'dosendpm')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'user'              => TYPE_ARRAY,
		'profile'           => TYPE_ARRAY,
		'serializeduser'    => TYPE_STR,
		'serializedprofile' => TYPE_STR,
		'perpage'           => TYPE_UINT,
		'startat'           => TYPE_UINT,
		'delay'				=> TYPE_UINT,
		'test'              => TYPE_BOOL,
		'from'              => TYPE_STR,
		'subject'           => TYPE_STR,
		'message'           => TYPE_STR,
		'overridereceivepm'	=> TYPE_BOOL,
	));
	
	if ($vbulletin->GPC['subject'] == '' OR $vbulletin->GPC['message'] == '')
	{
		print_stop_message('please_complete_required_fields');
	}

	if (!empty($vbulletin->GPC['serializeduser']))
	{
		$vbulletin->GPC['user'] = @unserialize(verify_client_string($vbulletin->GPC['serializeduser']));
		$vbulletin->GPC['profile'] = @unserialize(verify_client_string($vbulletin->GPC['serializedprofile']));
	}

	$condition = fetch_user_search_sql($vbulletin->GPC['user'], $vbulletin->GPC['profile']);
	if (!$condition)
	{
		$condition = ' 1=1 ';
	}

	$finalcondition = "
		$condition
		" . iif(!$vbulletin->GPC['user']['adminemail'], " AND (options & " . $vbulletin->bf_misc_useroptions['receivepm'] . ")");

	$fromuser = fetch_userinfo($vbulletin->GPC['from']);

	if (!$fromuser)
	{
		$fromuser['userid'] = $vbulletin->userinfo['userid'];
		$fromuser['username'] = $vbulletin->userinfo['username'];
	}

	if (empty($vbulletin->GPC['perpage']))
	{
		$vbulletin->GPC['perpage'] = 500;
	}

	@set_time_limit(0);

	$counter = $db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "user AS user
		LEFT JOIN " . TABLE_PREFIX . "userfield AS userfield ON (userfield.userid = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (usertextfield.userid = user.userid)
		WHERE $finalcondition
	");

	if ($counter['total'] == 0)
	{
		print_stop_message('no_users_matched_your_query');
	}
	else
	{
		$users = $db->query_read("
			SELECT user.userid, user.usergroupid, user.username, user.email, user.joindate,
				useractivation.activationid
			FROM " . TABLE_PREFIX . "user AS user
			LEFT JOIN " . TABLE_PREFIX . "userfield AS userfield ON (userfield.userid = user.userid)
			LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (usertextfield.userid = user.userid)
			LEFT JOIN " . TABLE_PREFIX . "useractivation AS useractivation ON (useractivation.userid = user.userid AND useractivation.type = 0)
			WHERE $finalcondition
			ORDER BY userid
			LIMIT " . $vbulletin->GPC['startat'] . ", " . $vbulletin->GPC['perpage'] . "
		");
		if ($db->num_rows($users))
		{
			$page = $vbulletin->GPC['startat'] / $vbulletin->GPC['perpage'] + 1;
			$totalpages = ceil($counter['total'] / $vbulletin->GPC['perpage']);

			echo '<p><b>' . $vbphrase['sending_pm'] . '<br />' . construct_phrase($vbphrase['showing_users_x_to_y_of_z'], vb_number_format($vbulletin->GPC['startat'] + 1), iif ($vbulletin->GPC['startat'] + $vbulletin->GPC['perpage'] > $counter['total'], vb_number_format($counter['total']), vb_number_format($vbulletin->GPC['startat'] + $vbulletin->GPC['perpage'])), vb_number_format($counter['total'])) . '</b></p>';
	
			$recipients = array();
			while ($user = $db->fetch_array($users))
			{
				echo "$user[userid] - $user[username] .... \n";
				vbflush();
				
				$sendmessage = $vbulletin->GPC['message'];
				$sendmessage = str_replace(
					array('$email', '$username', '$userid', '$bburl', '$bbtitle'),
					array($user['email'], $user['username'], $user['userid'], $vbulletin->options['bburl'], $vbulletin->options['bbtitle']),
					$vbulletin->GPC['message']
				);

				$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_SILENT);
				$pmdm->overridequota = true;
				$pmdm->set('fromuserid', $fromuser['userid']);
				$pmdm->set('fromusername', $fromuser['username']);
				$pmdm->set_info('receipt', false);
				$pmdm->set_info('savecopy', false);
				$pmdm->set('title', $vbulletin->GPC['subject']);
				$pmdm->set('message', $sendmessage);
				$pmdm->set_recipients($user['username'], $fromuser['permissions']);
				$pmdm->set('dateline', TIMENOW);
				$pmdm->set('allowsmilie', true);
				$pmdm->pre_save();
				if (empty($pmdm->errors))
				{
					if (!$vbulletin->GPC['test'])
					{
						echo $vbphrase['sending_pm'] . " \n";
						$pmdm->save();
					}
					else
					{
						echo $vbphrase['test'] . " ... \n";
					}
				}
				unset($pmdm);
				
				echo $vbphrase['okay'] . "<br />\n";
				vbflush();
			}
	
			$_REQUEST['do'] = 'donext';
		}
		else
		{
			define('CP_REDIRECT', 'pm.php?' . $vbulletin->session->vars['sessionurl']);
			print_stop_message('pms_sent_successfully');
		}
	}
}

// *************************** Link to next page of provate messages to send **********************
if ($_REQUEST['do'] == 'donext')
{
	$vbulletin->GPC['startat'] += $vbulletin->GPC['perpage'];

	print_form_header('pm', 'dosendpm', false, true, 'cpform_dosendpm');
	construct_hidden_code('test', $vbulletin->GPC['test']);
	construct_hidden_code('delay', $vbulletin->GPC['delay']);
	construct_hidden_code('serializeduser', sign_client_string(serialize($vbulletin->GPC['user'])));
	construct_hidden_code('serializedprofile', sign_client_string(serialize($vbulletin->GPC['profile'])));
	construct_hidden_code('from', $vbulletin->GPC['from']);
	construct_hidden_code('subject', $vbulletin->GPC['subject']);
	construct_hidden_code('message', $vbulletin->GPC['message']);
	construct_hidden_code('startat', $vbulletin->GPC['startat']);
	construct_hidden_code('perpage', $vbulletin->GPC['perpage']);

	print_submit_row($vbphrase['next_page'], 0);

	?>
	<script type="text/javascript">
	<!--
	if (document.cpform_dosendpm)
	{
		function send_submit()
		{
			var submits = YAHOO.util.Dom.getElementsBy(
				function(element) { return (element.type == "submit") },
				"input", this
			);
			var submit_button;

			for (var i = 0; i < submits.length; i++)
			{
				submit_button = submits[i];
				submit_button.disabled = true;
				setTimeout(function() { submit_button.disabled = false; }, 10000);
			}

			return false;
		}

		setTimeout(function() { YAHOO.util.Event.on(document.cpform_dosendpm, 'submit', send_submit); send_submit.call(document.cpform_dosendpm); document.cpform_dosendpm.submit();}, <?php echo $vbulletin->GPC['delay'] * 1000 ?>);
	}
	// -->
	</script>
	<?php
	vbflush();
}

// *************************** Main private message form **********************
if ($_REQUEST['do'] == 'start')
{
?>
<script type="text/javascript">
function check_all_usergroups(formobj, toggle_status)
{
	for (var i = 0; i < formobj.elements.length; i++)
	{
		var elm = formobj.elements[i];
		if (elm.type == "checkbox" && elm.name == 'user[usergroupid][]')
		{
			elm.checked = toggle_status;
		}
	}
}
</script>
<?php
	print_form_header('pm', 'dosendpm');
	print_table_header($vbphrase['pm_manager']);
	print_yes_no_row($vbphrase['test_pm_only'], 'test', 0);
	print_input_row($vbphrase['pm_to_send_at_once'], 'perpage', 500);
	print_input_row($vbphrase['pm_delay'], 'delay', 0);
	print_input_row($vbphrase['from'], 'from', $vbulletin->userinfo['userid']);
	print_input_row($vbphrase['subject'], 'subject');
	print_textarea_row($vbphrase['message_pm'], 'message', '', 10, 50);

	print_table_break();
	print_table_header($vbphrase['search_criteria']);
	$vbphrase['include_users_that_have_declined_email'] = $vbphrase['include_users_that_have_declined_pm'];
	print_user_search_rows(true);

	print_table_break();
	print_submit_row($vbphrase['send']);
}

print_cp_footer();

?>