<?php
/*======================================================================*\
|| #################################################################### ||
|| # Copyright  BananaLive Scripts. All Rights Reserved. ############# ||
|| #################################################################### ||
\*======================================================================*/

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT', 'ladders');
if ($_REQUEST['do'] && in_array($_REQUEST['do'], array('add', 'edit')))
{
define('GET_EDIT_TEMPLATES', true);
}
$phrasegroups = array('posting', 'postbit', 'user', 'timezone', 'global', 'pm', 'reputationlevel', 'search', 'calendar');
$specialtemplates = array(
	'bbcodecache',
	'smiliecache',
	'tll_catcache',
);
$globaltemplates = array(
	'editor_clientscript',
	'editor_css',
	'editor_jsoptions_font',
	'editor_jsoptions_size',
	'editor_smilie',
	'editor_smiliebox',
	'tmnt_ladder_chalpm',
	'tmnt_organise_league',
	'tmnt_date_time',
	'tmnt_ladder_tmnts',
	'tmnt_ladder_rearrange',
	'tmnt_ladder_noladders',
	'editor_smiliebox_row',
	'editor_smiliebox_straggler',
	'editor_toolbar_off',
	'editor_toolbar_on',
	'memberinfo_block_visitormessaging',
	'memberinfo_css',
	'memberinfo_usercss',
	'tmnt_ladder_editpt',
	'newpost_disablesmiliesoption',
	'tmnt_ladder_mf',
	'tmnt_ladder_mfpm',
	'tmnt_bracket',
	'tmnt_cmptlms',
	'tmnt_ladder_cpi',
	'tmnt_ladder_adminsubmitscore',
	'tmnt_cmptlms',
	'tmnt_ladder_all_chll_top',
	'tmnt_cmptlms',
	'tmnt_random_torp',
	'memberaction_dropdown',
	'tmnt_memberaction_dropdown',
	'tmnt_ladder_edit',
	'tmnt_ladder_newplayer',
	'tmnt_ladder_list',
	'tmnt_ladder_list_rm',
	'tmnt_ladder_list_bot',
	'tmnt_ladder_list_top',
	'tmnt_ladder_cmpt_ddms',
	'tmnt_ladder_new',
	'tmnt_cmptlms_top',
	'tmnt_cmptlms_bot',
	'tmnt_editplayer',
	'tmnt_ladder_chll',
	'tmnt_ladder_allchll',
	'tmnt_ladder_allchll_rm',
	'tmnt_ladder_allchll_bot',
	'tmnt_ladder_allchll_none',
	'tmnt_ladder_allchll_top',
	'tmnt_cat',
	'tmnt_ladder_tlchll',
	'tmnt_ladder_tlchll_bot',
	'tmnt_ladder_tlchll_none',
	'tmnt_ladder_tlchll_top',
	'tmnt_ladder_chllpm',
	'tmnt_ladder_chll_bot',
	'tmnt_ladder_chll_top',
	'tmnt_ladder_cmpt',
	'tmnt_ladder_cmpt_bot',
	'tmnt_ladder_cmpt_none',
	'tmnt_ladder_cmpt_top',
	'tmnt_ladder_display',
	'tmnt_ladder_elorating',
	'tmnt_ladder_join',
	'tmnt_ladder_insertmatch',
	'tmnt_ladder_repmatch',
	'tmnt_ladder_submitscore',
	'tmnt_letter',
	'tmnt_newplayer',
	'tmnt_shell',
	'tmnt_swapplayer',
	'tmnt_ladder_chal',
	'tmnt_ladder_yourteams',
	'pm_newpm',
	'facebook_likebutton'
	);
$actiontemplates = array(
);

require_once('./global.php');
require_once(DIR . '/includes/functions.php');
require_once(DIR . '/includes/functions_tal.php');

($hook = vBulletinHook::fetch_hook('tll_ladders_start')) ? eval($hook) : false;

$navbits = construct_navbits(array(
	'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
	'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase[ladders],
	'' => construct_phrase('Error')
));
$navbar = render_navbar_template($navbits);

// #############################################################################

if ($_REQUEST['do'] == 'ladder_player_image')
{
	$iwidth = $vbulletin->input->clean_gpc('g', 'w', TYPE_UINT);
	if (!$iwidth)
	{
		$iwidth = 250;
	}
	$iheight = $vbulletin->input->clean_gpc('g', 'h', TYPE_UINT);
	if (!$iheight)
	{
		$iheight = 90;
	}
	$userid = $vbulletin->input->clean_gpc('g', 'u', TYPE_UINT);
	$f = $vbulletin->input->clean_gpc('g', 'f', TYPE_UINT);
	$lid = $vbulletin->input->clean_gpc('g', 'l', TYPE_UINT);
	$noavatar = $vbulletin->input->clean_gpc('g', 'noavatar', TYPE_UINT);
	$player = $vbulletin->db->query_first("
		SELECT players.*, users.*, ladders.title AS laddertitle, users.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight, teams.teamname, teams.teamlogo
		FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
		LEFT JOIN " . TABLE_PREFIX . "user AS users
			ON (users.userid = players.userid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teams
			ON (teams.teamid = players.userid)	
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (players.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar
			ON (avatar.avatarid = users.avatarid)
		LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar
			ON (customavatar.userid = users.userid)
		WHERE players.userid = '$userid'
			AND players.lid = '$lid'
			AND players.active = 1
	");
	if ($player['pot'])
	{
		$player['username'] = $player['teamname'];
	}
	$countp = $vbulletin->db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE rank > '".$player['rank']."' AND active = 1 AND lid = '".$lid."'");
	$player['position'] = $countp['count'] + 1;
	$player['position'] = process_position($player['position']);
	if (!$noavatar)
	{
		if (!$player['pot'])
		{
			if (!empty($player['avatarpath']))
			{
				$player['avatarurl'] = $player['avatarpath'];
			}
			elseif ($player['hascustom'])
			{
				$avatarurl = array('hascustom' => 1);
				if ($vbulletin->options['usefileavatar'])
				{
					$player['avatarurl'] = $vbulletin->options['avatarurl'] . ($thumb ? '/thumbs' : '') . "/avatar{$player['userid']}_{$player['avatarrevision']}.gif";
				}
				else
				{
					$player['avatarurl'] = $vbulletin->options['bburl']."/image.php?u=$player[userid]&amp;dateline=$player[avatardateline]" . ($thumb ? '&type=thumb' : '') ;
				}
			}
		}
		else
		{
			$player['avatarurl'] = $player['teamlogo'];
		}
		if (empty($player['avatarurl']))
		{
			$player['avatarurl'] = vB_Template_Runtime::fetchStyleVar('imgdir_misc') . '/unknown.gif';
		}
		$player['image'] = $player['avatarurl'];
		$size = getimagesize($player['image']);
		$my_img = imagecreate($iwidth, $iheight);
		list($width, $height) = $size;
		if($size[2]==3)
		{
			$av = imagecreatefrompng($player['image']);
		}
		elseif ($size[2]==2)
		{
			$av = imagecreatefromjpeg($player['image']);
		}
		elseif ($size[2]==1)
		{
			$av = imagecreatefromgif($player['image']);
		}
		$minus = 0;
		$minus2 = 0;
	}
	else
	{
		$minus = -10;
		$minus2 = -30;
		$my_img = imagecreate($iwidth, $iheight);
	}
	$max = 45;
	$newwidth = $width;
	$newheight = $height;
	if ($newwidth > $max)
	{
		$ratio = $max / $newwidth;
		$newwidth = $newwidth * $ratio;
		$newheight = $newheight * $ratio;
	}
	if ($newheight > $max)
	{
		$ratio = $max / $newheight;
		$newwidth = $newwidth * $ratio;
		$newheight = $newheight * $ratio;
	}
	/*image*/
	function html2rgb($color)
	{
		if ($color[0] == '#')
			$color = substr($color, 1);

		if (strlen($color) == 6)
			list($r, $g, $b) = array($color[0].$color[1],
									 $color[2].$color[3],
									 $color[4].$color[5]);
		elseif (strlen($color) == 3)
			list($r, $g, $b) = array($color[0].$color[0], $color[1].$color[1], $color[2].$color[2]);
		else
			return false;

		$r = hexdec($r); $g = hexdec($g); $b = hexdec($b);

		return array($r, $g, $b);
	}
	$bg = $vbulletin->input->clean_gpc('g', 'bg', TYPE_NOHTML);
	$c = $vbulletin->input->clean_gpc('g', 'c', TYPE_NOHTML);
	
	if (!$bg)
	{
		$bg = 'FFFFFF';
	}
	if (!$c)
	{
		$c = '000000';
	}
	$border = $vbulletin->input->clean_gpc('g', 'b', TYPE_NOHTML);
	if (!$border)
	{
		$border = $bg;
	}
	$bg = html2rgb($bg);
	$c = html2rgb($c);
	$background = imagecolorallocate($my_img, $bg['0'], $bg['1'], $bg['2']);
	//$text_colour = imagecolorallocate($my_img, 199, 199, 199);
	$text_colour = imagecolorallocate($my_img, $c['0'], $c['1'], $c['2']);
	$line_colour = imagecolorallocate($my_img, 233, 233, 233);
	
	$border = html2rgb($border);
	$border_colour = imagecolorallocate($my_img, $border['0'], $border['1'], $border['2']);
	$bw = $vbulletin->input->clean_gpc('g', 'bw', TYPE_UINT);
	if (!$bw)
	{
		$bw = 1;
	}
	imagesetthickness($my_img, $bw);
	imagerectangle($my_img, 0, 0, $iwidth-1, $iheight-1, $border_colour);
	//imagestring(resource $image , int $font , int $x , int $y , string $string , int $color)
	//imageline(resource $image , int $x1 , int $y1 , int $x2 , int $y2 , int $color)
	//imageline($my_img, 30, 45, 165, 45, $line_colour);
	
	//imageline($my_img, $newwidth+20, 0, 300, 0, $line_colour);
	//imagestring($my_img, 5, 10, 10, $player['position'], $text_colour);
	if ($player['username'])
	{
		
		imagestring($my_img, 5, 10, 10, $player['username']."", $text_colour);
		imagestring($my_img, 4, $minus2+130, 30, $player['laddertitle'], $text_colour);
		imagestring($my_img, 4, $minus+$newwidth+20, 30, 'Ladder:', $text_colour);
		imagestring($my_img, 4, $minus+$newwidth+20, 50, 'Rank:', $text_colour);
		imagestring($my_img, 4, $minus2+130, 50, $player['position'], $text_colour);
		//imagestring($my_img, 4, 15, 70, 'Elo Rating:', $text_colour);
		//imagestring($my_img, 4, 120, 70, $player['rank'], $text_colour);
		imagestring($my_img, 4, $minus+$newwidth+20, 70, 'XP:', $text_colour);
		imagestring($my_img, 4, $minus2+130, 70, $player['xp'], $text_colour);
		if ($av)
		{
			//imagecopyresized($my_img, $av, $iwidth-$max-10, 10, 0, 0, $newwidth, $newheight, $width, $height);//top right
			imagecopyresized($my_img, $av, 10, 35, 0, 0, $newwidth, $newheight, $width, $height);//bottom left
		}
	}
	else
	{
		imagestring( $my_img, 5, 10, 10, "null", $text_colour );
		//debug
		//imagestring( $my_img, 4, 20, 30, 'lid='.$lid, $text_colour );
		//imagestring( $my_img, 4, 20, 50, 'userid='.$userid, $text_colour );
	}
	header("Content-Disposition: inline; filename=\"image.png\";");
	header('Cache-control: max-age=31536000');
	header('Expires: ' . gmdate('D, d M Y H:i:s', (TIMENOW + 31536000)) . ' GMT');
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s', $player['latime']) . ' GMT');
	header('Content-transfer-encoding: binary');
	header('ETag: "' . $player['latime'] . '-' . $u . '"');
	header("Content-type: image/png");
	imagepng($my_img);
	imagecolordeallocate($line_color);
	imagecolordeallocate($text_color);
	imagecolordeallocate($background);
	imagedestroy($my_img);
	exit;
}

// #############################################################################

if ($_POST['do'] == 'admin_updatept')
{
	if (!$tmntp['ladder_superuser'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'lid' => TYPE_UINT,
		'pid' => TYPE_UINT,
		'rank' => TYPE_UINT,
		'wins' => TYPE_UINT,
		'draws' => TYPE_UINT,
		'loses' => TYPE_UINT,
		'streak' => TYPE_INT,
		'xp' => TYPE_UINT,
		'challenges' => TYPE_UINT,
		'totalpoints' => TYPE_UINT,
		'pointsagainst' => TYPE_UINT,
		'longeststreak' => TYPE_UINT,
		'active' => TYPE_BOOL
	));
	if ($vbulletin->GPC['pid'] && $vbulletin->GPC['lid'])
	{
		$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders");
		$player = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '".$vbulletin->GPC['lid']."'");
		if (!$player || !$ladder)
		{
			print_no_permission();
		}
		if ($vbulletin->GPC['streak'] > 0)
		{
			$vbulletin->GPC['lstreak'] = 0;
			$vbulletin->GPC['wstreak'] = $vbulletin->GPC['streak'];
		}
		else
		{
			$vbulletin->GPC['lstreak'] = 0-$vbulletin->GPC['streak'];
			$vbulletin->GPC['wstreak'] = 0;
		}
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
			SET
				rank = '".$vbulletin->db->escape_string($vbulletin->GPC['rank'])."',
				wins = '".$vbulletin->db->escape_string($vbulletin->GPC['wins'])."',
				draws = '".$vbulletin->db->escape_string($vbulletin->GPC['draws'])."',
				loses = '".$vbulletin->db->escape_string($vbulletin->GPC['loses'])."',
				wstreak = '".$vbulletin->db->escape_string($vbulletin->GPC['wstreak'])."',
				lstreak = '".$vbulletin->db->escape_string($vbulletin->GPC['lstreak'])."',
				xp = '".$vbulletin->db->escape_string($vbulletin->GPC['xp'])."',
				challenges = '".$vbulletin->db->escape_string($vbulletin->GPC['challenges'])."',
				totalpoints = '".$vbulletin->db->escape_string($vbulletin->GPC['totalpoints'])."',
				pointsagainst = '".$vbulletin->db->escape_string($vbulletin->GPC['pointsagainst'])."',
				longeststreak = '".$vbulletin->db->escape_string($vbulletin->GPC['longeststreak'])."',
				active = '".$vbulletin->db->escape_string($vbulletin->GPC['active'])."'
			WHERE lid='".$vbulletin->GPC['lid']."'
				AND id='".$vbulletin->GPC['pid']."'
		");
		$vbulletin->url = "ladders.php?do=admin_editpt&lid=".$vbulletin->GPC['lid']."&pid=".$vbulletin->GPC['pid']."";	
		eval(print_standard_redirect('redirect_updatedladderpt', true, true));
	}
	else
	{
		$_REQUEST['do'] = 'admin_editpt';
	}
}

// #############################################################################

if ($_REQUEST['do'] == 'admin_editpt')
{
	if (!$tmntp['ladder_superuser'])
	{
		print_no_permission();
	}
	if ($lid < 1)
	{
		$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	}
	$ladderarray = array();
	$ladders = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladders
		ORDER BY title ASC
	");
	while($ladder = $vbulletin->db->fetch_array($ladders))
	{
		if ($ladder['id'] == $lid)
		{
			$ladder['selected'] = ' selected="selected"';
			$thisladder = $ladder;
		}
		$ladderarray[] = $ladder;
	}
	if ($thisladder)
	{
		if ($pid < 1)
		{
			$pid = $vbulletin->input->clean_gpc('g', 'pid', TYPE_UINT);
		}
		$playerarray = array();
		$players = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladder_players
			WHERE lid = '$lid'
			ORDER BY username ASC
		");
		while($player = $vbulletin->db->fetch_array($players))
		{
			$player['streak'] = $player['wstreak']-$player['lstreak'];
			if ($player['id'] == $pid)
			{
				$player['selected'] = ' selected="selected"';
				$thisplayer = $player;
			}
			$playerarray[] = $player;
		}
	}
	$templater = vB_Template::create('tmnt_ladder_editpt');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladders', $ladderarray);
		$templater->register('players', $playerarray);
		$templater->register('lid', $lid);
		$templater->register('pid', $pid);
		$templater->register('thisladder', $thisladder);
		$templater->register('thisplayer', $thisplayer);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders']
	);
	if ($thisladder)
	{
		$navbits['ladders.php?do=view&id='.$lid.''] = $thisladder['title'];
	}
	$navbits[''] = $vbphrase['ladder_editpt'];
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'add')
{
	if (!$tmntp['cancreateladder'])
	{
		print_no_permission();
	}
	$select_catid = $vbulletin->input->clean_gpc('g', 'catid', TYPE_UINT);
	$select_pot = $vbulletin->input->clean_gpc('g', 'pot', TYPE_BOOL);
	$select_league = $vbulletin->input->clean_gpc('g', 'league', TYPE_UINT);
	$select_groups = $vbulletin->input->clean_gpc('g', 'groups', TYPE_UINT);
	$carray = array();
	$categories = '<select name="catid" id="catid"><option value="0"></option>';
	/*$cats = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_categories
		WHERE tol IN (2,3)
		ORDER BY parentid DESC, displayorder ASC, title ASC
	");
	while($cat = $vbulletin->db->fetch_array($cats))
	{*/
	if ($vbulletin->tll_catcache)
	{
		foreach ($vbulletin->tll_catcache AS $cindex => $cat)
		{
			if ($cat['tol'] == 1)
			{
				continue;
			}
			if ($cat['parentid'])
			{
				$carray["$cat[parentid]"] .= '<option value="'.$cat['catid'].'"';
				if ($cat['catid'] == $select_catid)
				{
					$carray["$cat[parentid]"] .= ' selected="selected"';
				}
				$carray["$cat[parentid]"] .= '> - '.$cat[title].'</option>';
			}
			else
			{
				$categories .= '<option value="'.$cat[catid].'"';
				if ($cat['catid'] == $select_catid)
				{
					$categories .= ' selected="selected"';
				}
				$categories .= '>'.$cat[title].'</option>';
				$categories .= $carray["$cat[catid]"];
			}
		}
	}
	$categories .= '</select>';
	$squery = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladders
		WHERE groupid != 0
		ORDER BY groupid ASC
	");
	$select_season = $vbulletin->input->clean_gpc('g', 'season', TYPE_UINT);
	$seasons = array();
	$lastseason = array();
	while($season = $vbulletin->db->fetch_array($squery))
	{
		if ($season['groupid'] != $lastseason['groupid'])
		{
			$season['optgroup'] = true;
			$season['optgroupid'] = ++$optgroup;
		}
		if ($season['groupid'] == $select_season && !$selectedseason)
		{
			$selectedseason = true;
			$season['selected'] = ' selected="selected"';
		}
		$season['lastseason'] = $lastseason['groupid'];
		$seasons[] = $season;
		$lastseason = $season;
	}
	$season = array(
		'optgroupid' => ($optgroup+1),
		'optgroup' => true,
		'title' => $vbphrase['ladder_new_seasons_group'],
		'groupid' => ($lastseason['groupid']+1)
	);
	$seasons[] = $season;
	if (!$dateline_from)
	{
		$dateline_from = TIMENOW;
	}
	if (!$dateline_to)
	{
		$dateline_to = TIMENOW + 2592000;
	}
	$utc = 0.00;
	$dst = 1;
	list ($timezoneoptions, $from_day, $from_monthselected, $from_yearbits, $user_from_time, $dstchecked, $show) = tmnt_dateline_to_fields($dateline_from, $utc, $dst, $show);
	list ($timezoneoptions, $to_day, $to_monthselected, $to_yearbits, $user_to_time, $dstchecked, $show) = tmnt_dateline_to_fields($dateline_to, $utc, $dst, $show);
	$templater = vB_Template::create('tmnt_date_time');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('time', $user_from_time);
		$templater->register('day', $from_day);
		$templater->register('monthselected', $from_monthselected);
		$templater->register('yearbits', $from_yearbits);
		$templater->register('rangeid', 0);
		$templater->register('prefix', 'from');
	$startdatehtml = $templater->render();
	$templater = vB_Template::create('tmnt_date_time');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('time', $user_to_time);
		$templater->register('day', $to_day);
		$templater->register('monthselected', $to_monthselected);
		$templater->register('yearbits', $to_yearbits);
		$templater->register('rangeid', 1);
		$templater->register('prefix', 'to');
	$enddatehtml = $templater->render();
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar('', 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar('');
	}
	if ($select_league)
	{
		$vbphrase['ladder_create'] = $vbphrase['ladder_create_league'];
		$vbphrase['ladder_date'] = $vbphrase['league_date'];
	}
	$templater = vB_Template::create('tmnt_ladder_new');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
		$templater->register('categories', $categories);
		$templater->register('seasons', $seasons);
		$templater->register('pot', $select_pot);
		$templater->register('league', $select_league);
		$templater->register('groups', $select_groups);
		$templater->register('startdatehtml', $startdatehtml);
		$templater->register('enddatehtml', $enddatehtml);
		$templater->register('utc', $utc);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('timezoneoptions', $timezoneoptions);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => construct_phrase($vbphrase['ladder_create'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'insert')
{
	if (!$tmntp['cancreateladder'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'message' => TYPE_STR,
		'title' => TYPE_NOHTML,
		'icon' => TYPE_NOHTML,
		'wysiwyg' => TYPE_BOOL,
		'pot' => TYPE_UINT,
		'catid' => TYPE_UINT,
		'league' => TYPE_BOOL,
		'homeaway' => TYPE_UINT,
		'groups' => TYPE_UINT,
		'groupid' => TYPE_UINT,
		'timezoneoffset' => TYPE_ARRAY_NUM,
		'dst' => TYPE_ARRAY_UINT,
		'fromdate' => TYPE_ARRAY_ARRAY,
		'todate' => TYPE_ARRAY_ARRAY,
		'totime' => TYPE_ARRAY_NOHTML,
		'fromtime' => TYPE_ARRAY_NOHTML
	));
	if (!$vbulletin->GPC['title'])
	{
		$errormessage = $vbphrase[error_invalid_title];
		eval(standard_error($errormessage));
	}
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$description = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$description = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$description = $vbulletin->GPC['message'];
	}
	if (!$description)
	{
		$errormessage = $vbphrase[error_invalid_description];
		eval(standard_error($errormessage));
	}
	$chal_options = serialize(
		array(
			/*'Best Of' => '',
			'Map' => ''*/
		)
	);
	//start date
	$type = 'range';
	$fromtime = $vbulletin->GPC['fromtime']["$type"];
	$totime = $vbulletin->GPC['totime']["$type"];
	$fromdate = $vbulletin->input->clean($vbulletin->GPC['fromdate']["$type"], TYPE_ARRAY_UINT);
	$todate = $vbulletin->input->clean($vbulletin->GPC['todate']["$type"], TYPE_ARRAY_UINT);
	$utc = $timezoneoffset = $vbulletin->GPC['timezoneoffset']["$type"];
	$dst = $vbulletin->GPC['dst']["$type"];
	require_once(DIR . '/includes/functions_misc.php');
	if (!fetch_timezone($timezoneoffset))
	{
		$errormessage = 'Error: invalid timezone specified';
		eval(standard_error($errormessage));
	}	
	$dateline_to = tmnt_fields_to_dateline($totime, $todate, $utc, $dst, $type);
	if (!is_numeric($dateline_to))
	{
		$errormessage = $dateline_to;
		eval(standard_error($errormessage));
	}
	$dateline_from = tmnt_fields_to_dateline($fromtime, $fromdate, $utc, $dst, $type);
	if (!is_numeric($dateline_from))
	{
		$errormessage = $dateline_from;
		eval(standard_error($errormessage));
	}
	if ($dateline_to < $dateline_from)
	{
		$errormessage = 'Error: End date must be after start date.';
		eval(standard_error($errormessage));
	}
	//end date
	if ($vbulletin->options['tmnt_createthread'])
	{
		require_once('./includes/functions_databuild.php');
        $forumid = $vbulletin->options['tmnt_createthread'];
		$templater = vB_Template::create('tmnt_ladder_threadtemplate');
			$templater->register('ladder', $ladder);
			$templater->register('description', $description);
			$templater->register('id', $id);
			$templater->register('title', $vbulletin->GPC['title']);
			$templater->register('catid', $vbulletin->GPC['catid']);
			$templater->register('pot', $vbulletin->GPC['pot']);
			$templater->register('userid', $thisuserid);
			$templater->register('forumid', $forumid);
			$templater->register('username', $thisusername);
		$pagetext = $templater->render();
		$pagetext = preg_replace('/<!--(.|\s)*?-->/', '', $pagetext);
        $open = 1;
        $allow_smilie = 1;
        $visible = 1;
		$threadid = new_thread($thisuserid, $forumid, $vbulletin->GPC['title'], $pagetext, $open, $allow_smilie, $visible);
	}
	else
	{
		$threadid = 0;
	}
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_ladders
		(title, description, noplayers, cr_userid, cr_username, cr_time, cr_ip, threadid, pot, catid, icon, chal_options, league, homeaway, groups, groupid, dateline_from, dateline_to, dst, utc)
		VALUES (
			'".$vbulletin->db->escape_string($vbulletin->GPC['title'])."', 
			'".$vbulletin->db->escape_string($description)."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['noplayers'])."',
			'".$vbulletin->db->escape_string($thisuserid)."', 
			'".$vbulletin->db->escape_string($thisusername)."', 
			".TIMENOW.",
			'".$vbulletin->db->escape_string($thisip)."',
			'".$vbulletin->db->escape_string($threadid)."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['pot'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['catid'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['icon'])."',
			'".$vbulletin->db->escape_string($chal_options)."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['league'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['homeaway'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['groups'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['groupid'])."',
			'".$vbulletin->db->escape_string($dateline_from)."',
			'".$vbulletin->db->escape_string($dateline_to)."',
			'".$vbulletin->db->escape_string($dst)."',
			'".$vbulletin->db->escape_string($utc)."'
		)
		");
	$id = $vbulletin->db->insert_id();
	build_tll_catcache();
	$vbulletin->url = "ladders.php?do=view&id=$id";	
	eval(print_standard_redirect('redirect_insertladder'));
}

// #############################################################################

if ($_POST['do'] == 'insertchal')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('p', 'lid', TYPE_UINT);
		if (!$lid) {
			$errormessage = $vbphrase[error_invalid_ladder];
			eval(standard_error($errormessage));
		}	
	$u2 = $vbulletin->input->clean_gpc('p', 'u2', TYPE_UINT);
	$mf = 0;
	if (!$u2)
	{
		$mf = 1;
	}
		/*if (!$u2)
		{
			$errormessage = $vbphrase[error_invalid_challenger];
			eval(standard_error($errormessage));
		}*/
	$bestof = $vbulletin->input->clean_gpc('p', 'bestof', TYPE_UINT);
	$map = $vbulletin->input->clean_gpc('p', 'map', TYPE_NOHTML);
	$u1message = $vbulletin->input->clean_gpc('p', 'u1message', TYPE_NOHTML);
	$u2message = $vbulletin->input->clean_gpc('p', 'u2message', TYPE_NOHTML);
	$userid = $thisuserid;
	$u = $vbulletin->input->clean_gpc('p', 'u', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id=$lid ");
	$co_array = unserialize($ladder['chal_options']);
	$chal_options = array();
	if (is_array($co_array))
	{
		foreach ($co_array AS $key => $value)
		{
			$key = str_replace(' ','_',$key);
			$key = preg_replace("/[^a-zA-Z0-9_\s]/", "", unhtmlspecialchars($key));
			$chal_options["$key"] = $vbulletin->input->clean_gpc('p', "$key", TYPE_NOHTML);
		}
		$chal_options = serialize($chal_options);
	}
	if ($ladder['archive'] == '1')
	{
		$errormessage = $vbphrase[error_ladder_closed];
		eval(standard_error($errormessage));
	}
	if ($u == $u2)
	{
		$errormessage = $vbphrase[error_invalid_challenged];
		eval(standard_error($errormessage));
	}
	$time_limit = TIMENOW - ($vbulletin->options['tmnt_ladder_limitrematch'] * 60 * 60);
	$countlimit = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND dateline_finished > '" . $time_limit . "' ");
	if ($countlimit['countrows'])
	{
		$errormessage = "Please wait 24 hours between challenging the same player/team.";
		eval(standard_error($errormessage));
	}
	/* challenge time/date */
	$vbulletin->input->clean_array_gpc('p', array(
		'timezoneoffset' => TYPE_ARRAY_NUM,
		'dst'            => TYPE_ARRAY_UINT,
		'date'       => TYPE_ARRAY_ARRAY,
		'time'       => TYPE_ARRAY_NOHTML
	));
	$type = 'range';
	$time = $vbulletin->GPC['time']["$type"];
	$date = $vbulletin->input->clean($vbulletin->GPC['date']["$type"], TYPE_ARRAY_UINT);
	$utc = $timezoneoffset = $vbulletin->GPC['timezoneoffset']["$type"];
	$dst = $vbulletin->GPC['dst']["$type"] = 1;
	require_once(DIR . '/includes/functions_misc.php');
	if (!fetch_timezone($timezoneoffset))
	{
		$errormessage = "Error: invalid timezone specified";
		eval(standard_error($errormessage));
	}
	if (!checkdate($date['month'], $date['day'], $date['year']))
	{
		$errormessage = "Error: Bad Date";
		eval(standard_error($errormessage));
	}
	$time_re = '#^(0?[1-9]|1[012])\s*[:.]\s*([0-5]\d)(\s*[AP]M)?|([01]\d|2[0-3])\s*[:.]\s*([0-5]\d)$#i';

	// match text in field for a valid time
	if (preg_match($time_re, $time, $matches))
	{
		if (count($matches) == 3)
		{
			$hour = intval($matches[1]);
			$minute = intval($matches[2]);
			$ampm = $matches[1] == '12' ? 'PM' : 'AM';
		}
		else if (count($matches) == 4)
		{
			$hour = intval($matches[1]);
			$minute = intval($matches[2]);
			$ampm = strtoupper(trim($matches[3]));
		}
		else // 24hr time
		{
			$hour = intval($matches[4]);
			$minute = intval($matches[5]);
			$ampm = ($hour <= 11) ? 'AM' : 'PM';
		}
	}
	if (($pos = strpos($vbulletin->options['timeformat'], 'H')) === false)
	{
		if ($ampm == 'PM')
		{
			if ($hour >= 1 AND $hour <= 11)
			{
				$hour += 12;
			}
		}
		else
		{
			if ($hour == 12)
			{
				$hour = 0;
			}
		}
	}
	$min_offset = $utc - intval($utc);
	$hour   -= intval($utc);
	$minute -= intval($min_offset * 60);
	$dateline = gmmktime($hour, $minute, 0, $date['month'], $date['day'], $date['year']);
	/* end challenge time/date */
	if ($ladder['pot'] != '1')
	{
		// start singles
		if ($u != $vbulletin->userinfo['userid'])
		{
			$errormessage = "Unexpected Error: Error in template 'tmnt_ladder_chal'";
			eval(standard_error($errormessage));
		}
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND finished=0 ");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer >= $vbulletin->options['tmnt_ladder_maxc'] && $u2 > 0)
		{
			$errormessage = $vbphrase['error_already_challenged'];
			eval(standard_error($errormessage));
		}
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u2 AND active=1");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer != 1 && $u2 > 0)
		{
			$errormessage = $vbphrase[error_player_not_ladder];
			eval(standard_error($errormessage));
		}
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u AND active=1");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer != 1) {
			$errormessage = $vbphrase['error_you_not_ladder'];
			eval(standard_error($errormessage));
		}
		$username_u = $thisusername;
		$u2info = fetch_userinfo($u2);
		$username_u2 = $u2info['username'];
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_games
				(u, u2, lid, time, pot, bestof, matchdate, map, u1message, u2message, chal_options, dateline, mf)
			VALUES (
				'".$vbulletin->db->escape_string($u)."',
				'".$vbulletin->db->escape_string($u2)."',
				'".$vbulletin->db->escape_string($lid)."',
				'".TIMENOW."',
				'0',
				'".$vbulletin->db->escape_string($bestof)."',
				'".$vbulletin->db->escape_string($matchdate)."',
				'".$vbulletin->db->escape_string($map)."',
				'".$vbulletin->db->escape_string($u1message)."',
				'".$vbulletin->db->escape_string($u2message)."',
				'".$vbulletin->db->escape_string($chal_options)."',
				'".$vbulletin->db->escape_string($dateline)."',
				'".$vbulletin->db->escape_string($mf)."'
			)
		");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET challenges = challenges + 1 WHERE lid=$lid AND userid=$u");
		/* adding notification for u2 */
		if (!is_array($u2info['tmnt_notifications']) && $u2info['tmnt_notifications'])
		{
			$u2info['tmnt_notifications'] = unserialize($u2info['tmnt_notifications']);
		}
		else if (!$u2info['tmnt_notifications'])
		{
			$u2info['tmnt_notifications'] = array();
		}
		$u2info['tmnt_notifications']['ladder_chals']++;
		$u2info['tmnt_notifications'] = serialize($u2info['tmnt_notifications']);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($u2info['tmnt_notifications'])."' WHERE userid = '".$u2info['userid']."'");
		/* end */
		require_once('./includes/functions_databuild.php');
		$fromuserid = $thisuserid;
		$fromusername = $thisusername;
		$title = $thisusername." has challenged you"; 
		$recipients = $username_u2;
		$templater = vB_Template::create('tmnt_ladder_chalpm');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('title', $title);
		$templater->register('fromusername', $fromusername);
		$templater->register('fromuserid', $fromuserid);
		$message = $templater->render();
		$message = preg_replace('/<!--(.|\s)*?-->/', '', $message);
			$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
			$pmdm->set('fromuserid', $fromuserid);
			$pmdm->set('fromusername', $fromusername);
			$pmdm->set('title', $title);
			$pmdm->set('message', $message);
			$pmdm->set_recipients($recipients, $botpermissions);
			$pmdm->set('dateline', TIMENOW); 
			$pmdm->overridequota = true;
			$errors = $pmdm->errors;
			if ($errors) {
				foreach ($errors as $error) {
					$errorss .= $error. "<br />";
				}
				$errormessage = $vbphrase[error_success_chal_error_pm].$errorss;
				eval(standard_error($errormessage));
			}
			$pmdm->save();
			unset($pmdm);
		// end singles
	}
	else
	{
		// start team
		$countteam = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND finished = '0' " . ($u2 == 0 ? " AND dateline > ".TIMENOW." " : "") . " ");
		if ($countteam['countrows'] > $vbulletin->options['tmnt_ladder_maxc'])
		{
			$errormessage = $vbphrase['error_already_challenged'];
			eval(standard_error($errormessage));
		}
		$countteam = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u2 ");
		if ($countteam['countrows'] != 1 && $u2 > 0)
		{
			$errormessage = $vbphrase['error_invalid_challenged'];
			eval(standard_error($errormessage));
		}
		$countteam = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u ");
		if ($countteam['countrows'] != 1 && $u2 > 0)
		{
			$errormessage = $vbphrase[error_you_not_ladder];
			eval(standard_error($errormessage));
		}
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_games
				(u, u2, lid, time, pot, bestof, matchdate, map, u1message, u2message, chal_options, dateline, mf)
			VALUES (
				'".$vbulletin->db->escape_string($u)."',
				'".$vbulletin->db->escape_string($u2)."',
				'".$vbulletin->db->escape_string($lid)."',
				'".TIMENOW."',
				'1',
				'".$vbulletin->db->escape_string($bestof)."',
				'".$vbulletin->db->escape_string($matchdate)."',
				'".$vbulletin->db->escape_string($map)."',
				'".$vbulletin->db->escape_string($u1message)."',
				'".$vbulletin->db->escape_string($u2message)."',
				'".$vbulletin->db->escape_string($chal_options)."',
				'".$vbulletin->db->escape_string($dateline)."',
				'".$vbulletin->db->escape_string($mf)."'
			)
		");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET challenges = challenges + 1 WHERE lid='$lid' AND userid='$u' ");
		/* adding notification for u2 */
		$u2_leader = $vbulletin->db->query_first("SELECT userid FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid = '$u2' AND leader = 1");
		$u2info = fetch_userinfo($u2_leader['userid']);
		if (!is_array($u2info['tmnt_notifications']) && $u2info['tmnt_notifications'])
		{
			$u2info['tmnt_notifications'] = unserialize($u2info['tmnt_notifications']);
		}
		else if (!$u2info['tmnt_notifications'])
		{
			$u2info['tmnt_notifications'] = array();
		}
		$u2info['tmnt_notifications']['ladder_chals']++;
		$u2info['tmnt_notifications'] = serialize($u2info['tmnt_notifications']);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($u2info['tmnt_notifications'])."' WHERE userid = '".$u2info['userid']."'");
		/* end */
		require_once('./includes/functions_databuild.php');
		$fromuserid = $thisuserid;
		$fromusername = $thisusername;
		$title = $thisusername." has challenged your team"; 
		$recipients = $u2info['username'];
		$templater = vB_Template::create('tmnt_ladder_chalpm');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('title', $title);
		$templater->register('fromusername', $fromusername);
		$templater->register('fromuserid', $fromuserid);
		$message = $templater->render();
		$message = preg_replace('/<!--(.|\s)*?-->/', '', $message);
			$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
			$pmdm->set('fromuserid', $fromuserid);
			$pmdm->set('fromusername', $fromusername);
			$pmdm->set('title', $title);
			$pmdm->set('message', $message);
			$pmdm->set_recipients($recipients, $botpermissions);
			$pmdm->set('dateline', TIMENOW); 
			$pmdm->overridequota = true;
			$errors = $pmdm->errors;
			if ($errors) {
				foreach ($errors as $error) {
					$errorss .= $error. "<br />";
				}
				$errormessage = $vbphrase[error_success_chal_error_pm].$errorss;
				eval(standard_error($errormessage));
			}
			$pmdm->save();
			unset($pmdm);
		// end team
	}
	if ($mf)
	{
		$vbulletin->url = "ladders.php?do=view&id=".$lid."&sh=5";
	}
	else
	{
		$vbulletin->url = "ladders.php?do=view&id=".$lid;
	}
	eval(print_standard_redirect('redirect_insertchalladder'));
}

// #############################################################################

if ($_REQUEST['do'] == 'view')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
        eval(standard_error($errormessage));
	}
	$lid = $id;
	$ladder = $vbulletin->db->query_first("
		SELECT ladders.*, cats.title AS categorytitle, cats.parentid, cats2.title AS parenttitle, ladders.cr_userid AS userid, ladders.cr_username AS username
		FROM " . TABLE_PREFIX . "tmnt_ladders AS ladders
		LEFT JOIN " . TABLE_PREFIX . "tmnt_categories AS cats 
			ON (cats.catid = ladders.catid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_categories AS cats2 
			ON (cats.parentid = cats2.catid)
		WHERE ladders.id = '$id'
	");
	($hook = vBulletinHook::fetch_hook('tll_ladder_view_post_query')) ? eval($hook) : false;
	if (!$ladder)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
        eval(standard_error($errormessage));
	}
	if ($ladder['league'] > 0)
	{
		$vbulletin->options['tmnt_ladder_ranking'] = 'xp';
		$vbulletin->options['tmnt_elorating'] = 0;
		if ($ladder['pot'])
		{
			$ladder['typetext'] = $vbphrase['ladder_teams_league'];
		}
		else
		{
			$ladder['typetext'] = $vbphrase['ladder_singles_league'];
		}
		$vbphrase['ladder_join'] = $vbphrase['ladder_league_join'];
		$vbphrase['ladder_leave'] = $vbphrase['ladder_league_leave'];
		$vbphrase['ladder_delete'] = $vbphrase['ladder_league_delete'];
		$vbphrase['ladder_details'] = $vbphrase['ladder_league_details'];
		$vbphrase['ladder_closing_on'] = $vbphrase['league_closing_on'];
		$vbphrase['ladder_starting_on'] = $vbphrase['league_starting_on'];
		$vbphrase['ladder_finished_on'] = $vbphrase['league_finished_on'];
	}
	else
	{
		if ($ladder['pot'])
		{
			$ladder['typetext'] = $vbphrase['ladder_teams_ladder'];
		}
		else
		{
			$ladder['typetext'] = $vbphrase['ladder_singles'];
		}
	}
	$ladder['groupnames'] = explode(',', $ladder['groupnames']);
	$ladder['urlencoded'] = urlencode($vbulletin->options['bburl']."/ladders.php?do=view&id=".$ladder['id']);
	if ($ladder['archive'] == 1 && $ladder['dateline_to'] && $ladder['dateline_from'] && $ladder['dateline_from'] <= TIMENOW && TIMENOW <= $ladder['dateline_to'])
	{
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tmnt_ladders SET archive = 0 WHERE id = '$id'
		");
		$ladder['archive'] = 0;
	}
	elseif ($ladder['archive'] == 0 && $ladder['dateline_to'] && $ladder['dateline_from'] && ($ladder['dateline_to'] < TIMENOW OR $ladder['dateline_from'] > TIMENOW))
	{
		if ($ladder['league'] != 1)
		{
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladders SET archive = 1 WHERE id = '$id'
			");
		}
		$ladder['archive'] = 1;
	}
	switch ($ladder['archive'])
	{
		case 0:
			$ladder['status'] = $vbphrase['ladder_open'];
			break;
		case 1:
			$ladder['status'] = $vbphrase['ladder_closed'];
			break;
	}
	if ($ladder['archive'] == 1 && $ladder['dateline_from'] && $ladder['dateline_from'] > TIMENOW)
	{
		$ladder['status'] = $vbphrase['ladder_startingsoon'];
	}
	if ($ladder['league'] == 1)
	{
		$ladder['archive'] = 0;
		$ladder['status'] = $vbphrase['ladder_signups'];
	}
	if ($ladder['groupid'])
	{
		$gladders = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladders
			WHERE groupid = '" . $ladder['groupid'] . "'
		");
		$sarray = array();
		while($gl = $vbulletin->db->fetch_array($gladders))
		{
			if ($gl['id'] == $ladder['id'])
			{
				$gl['selected'] = ' selected="selected"';
			}
			$sarray[] = $gl;
		}
		$gltitle = $vbphrase['tmnt_newladder'];
		if ($ladder['league'])
		{
			$gltitle = $vbphrase['tmnt_newleague'];
		}
		$sarray[] = array('id' => '999','title' => $gltitle);
	}
	$ladder['dateline'] = vbdate($vbulletin->options['dateformat'],$ladder['cr_time']);
	$ladder['ed_time'] = vbdate($vbulletin->options['timeformat'],$ladder['ed_time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$ladder['ed_time']);
	$title = $ladder['title'];
	$title2 = addslashes($ladder['title']);
	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
	$ladder['description'] = $bbcode_parser->do_parse($ladder['description']);
	list($ladder['description'], $ladder['rules']) = preg_split('/\[rules\]/', $ladder['description']);
	$ladder['rules'] = trim($ladder['rules']);
	if (substr($ladder['rules'],0,6)=='<br />')
	{
		$ladder['rules'] = substr($ladder['rules'],6);
	}
	$team = false;
	if ($ladder['pot'])
	{
		$team = true;
	}
	$ladder['hide'] = $hide = $vbulletin->input->clean_gpc('g', 'hide', TYPE_NOHTML);
	if (!in_array($_REQUEST['sh'], array(1,2,3,4,5,6,7)) || ($team && in_array($_REQUEST['sh'], array(3,5))))
	{
		$cpp = $vbulletin->input->clean($vbulletin->options['tmnt_lcpp'], TYPE_UINT);
		$countcomps = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players WHERE lid=$lid AND active=1" . ($hide == 'unranked' ? " AND (players.wins > 0 OR players.draws >0 OR players.loses > 0) " : "") . "");
		$noofcomps = $countcomps['countrows'];
		if (!$hide && $noofcomps != $ladder['noplayers'])
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET noplayers = '".$noofcomps."' WHERE id = '$lid'");
			$ladder['noplayers'] = $noofcomps;
		}
		$lastpage = ceil($noofcomps/$cpp);
		$page = $vbulletin->input->clean_gpc('g', 'page', TYPE_UINT);
		if ($page == 0)
		{
			$page = 1;
		}
		elseif ($page > $lastpage)
		{
			$page = $lastpage;
		}
		$offset = ($page - 1) * $cpp;
		if ($offset < 0)
		{
			$offset = 0;
		}
	}
	if (!in_array($_REQUEST['sh'], array(1,2,3,4,5,6,7)) || ($team && in_array($_REQUEST['sh'], array(3))) || (!$vbulletin->options['tmnt_showrules'] && $_REQUEST['sh'] == 6))
	{
		$_REQUEST['sh'] = 0;
		$sh = 0;
		if ($lastpage > 1)
		{
			$showpaging = true;
		}
		else
		{
			$showpaging = false;
		}
		if ($noofcomps > 0)
		{
			$from = $offset + 1;
			if ($lastpage == $page) {
				$to = $noofcomps;
			} else {
				$to = $page * $cpp;
			}
		} else {
			$from = 0;
			$to = 0;
		}
		$ladder['colspan'] = 9;
		if ($tmntp['ladder_superuser'])
		{
			$ladder['colspan']++;
		}
		if (!$vbulletin->options['tmnt_elorating'])
		{
			$ladder['colspan']--;
		}
		$array = array();
		$winnerlist = array();
		$rowno = $offset;
		$toprank = 1;
		$myteams = fetch_myteams();
vB_Template::preRegister('memberaction_dropdown',array('tmntp' => $tmntp));  
		$cmpts = $vbulletin->db->query_read("
			SELECT " . (!$team ? "user.*, " : "") . " players.*, players.userid AS userid
			" . (!$team ? ", user.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight, user.username AS username" : ", team.teamlogo AS avatarurl") . "
			" . (($vbulletin->options['tmnt_joinuf'] && !$team) ? ", userfield.*, usertextfield.* " : "") . ", players.rank AS rank
		FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
		" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (players.userid = user.userid) LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = user.avatarid) LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = user.userid) " : " LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS team ON (players.userid = team.teamid)") . "
		" . (($vbulletin->options['tmnt_joinuf'] && !$team) ? " LEFT JOIN " . TABLE_PREFIX . "userfield AS userfield ON (user.userid = userfield.userid) LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (usertextfield.userid = user.userid) " : "") . "
		WHERE players.lid=$id 
			AND players.active=1
			" . ($hide == 'unranked' ? " AND (players.wins > 0 OR players.draws >0 OR players.loses > 0) " : "") . "
		ORDER BY 
			players.group ASC,
			" . ($vbulletin->options['tmnt_ladder_ranking'] == 'elo' ? "players.rank DESC," : "")
			. ($vbulletin->options['tmnt_ladder_ranking'] == 'xp' ? "players.xp DESC," : "") . "
			players.wins DESC,
			players.draws DESC,
			players.loses ASC,
			" . ($vbulletin->options['tmnt_ladder_ranking'] == 'elo' ? "players.xp DESC, " : "") . "
			players.totalpoints DESC,
			players.pointsagainst ASC
		". (!$ladder['league'] ? "LIMIT $offset, $cpp" : "") . "
		");
		$ti = 0;
		while($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			if ($cmpt['group'] > 1 && $cmpt['group'] > $lastcmpt['group'])
			{
				$c_idx = $cmpt['group'] - 1;
				$ladder['thisgroup'] = $cmpt['group'];
				//$ccompetitors .= "</tr></table><h3 class=\"blocksubhead\" colspan=\"".$ladder['colspan']."\"><a name=\"group".$cmpt['group']."\"></a>" . ($ladder['groupnames']["$c_idx"] ? $ladder['groupnames']["$c_idx"] : construct_phrase($vbphrase['ladder_league_group_x'], $cmpt['group'])) . "</h3><table class=\"blockbody\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\"><tbody><tr>";
				$ccompetitors .= "</tbody></table></div>";
				$ladder['thisgroupname'] = $ladder['groupnames']["$c_idx"];
				$templater = vB_Template::create('tmnt_ladder_cmpt_top');
					$templater->register('tmntp', $tmntp);
					$templater->register('ladder', $ladder);
					$templater->register('id', $id);
					$templater->register('lid', $lid);
					$templater->register('from', $from);
					$templater->register('to', $to);
					$templater->register('ti', $ti);
					$templater->register('c_idx', $c_idx);
					$templater->register('noofcomps', $noofcomps);
					$templater->register('sh', $sh);
				$ccompetitors .= $templater->render();
				$cmpt['row'] = 1;
				$rowno = 0;
			}
			if ($team && in_array($cmpt['userid'], $myteams))
			{
				$cmpt['myteam'] = true;
			}
			$cmpt = process_tl_avatar($cmpt);
			$avatarlp = $cmpt['avatarlp'];
			$cmpt['time2'] = "<span class=\"smallfont\">".vbdate($vbulletin->options['dateformat'],$cmpt['time'])." <span class=\"time\"> ".vbdate($vbulletin->options['timeformat'],$cmpt['time'])."</span></span>";
			$cmpt['time'] = " ".vbdate($vbulletin->options['dateformat'],$cmpt['time'])." ".vbdate($vbulletin->options['timeformat'],$cmpt['time'])." ";
			$var = $cmpt['userid'];
			$array = array_merge((array)$var, $array);
			$rank = $cmpt['rank'];
			if ($cmpt['lstreak'] > 0) {
				$streak = -$cmpt['lstreak'];
			} else {
				$streak = $cmpt['wstreak'];
			}
			if ($cmpt['latime'] == 0)
			{
				$cmpt['latime'] = "-";
			} 
			else
			{
				$cmpt['latime'] = " ".vbdate($vbulletin->options['dateformat'],$cmpt['latime'], 1);
			}
			if ($rowno == $offset)
			{
				$toprank = $rank;
				$lastrank_rank = $toprank;
				$lastrank_row = $offset+1;
			}
			if ($toprank == $rank)
			{
				$var2 = $cmpt['userid'];
				$winnerlist = array_merge((array)$var2, $winnerlist);
			}
			$rowno++;
			$cmpt['rowno'] = $rowno;
			if ($rank == $lastrank_rank && $rowno != ($offset+1) && $cmpt['xp'] == $lastrank_xp)
			{
				$cmpt['row'] = $lastrank_row ."=";
			}
			else
			{
				$lastrank_row = $rowno;
				$lastrank_rank = $rank;
				$lastrank_xp = $cmpt['xp'];
				$cmpt['row'] = $rowno;
			}
			$ddms = "cmpt".$rowno;
			$cmpt['col'] = "cmpt_". $cmpt['userid'];
			$cmpt['obj'] = "collapseobj_cmpt_". $cmpt['userid'];
			$cmpt['matches'] = $cmpt['wins'] + $cmpt['draws'] + $cmpt['loses'];
			if ($cmpt['wins']>0 AND $cmpt['matches']>0) $cmpt['winp'] = $cmpt['wins'] / $cmpt['matches'] * 100;
			$cmpt['winp'] = (int)$cmpt['winp'];
			if ($cmpt['matches'] > 0)//dom
			{
				$cmpt['pointsaverage'] = vb_number_format(($cmpt['totalpoints'] / $cmpt['matches']), 2);
				$cmpt['pointsaverage'] = str_replace(".00", "", $cmpt['pointsaverage']);
			}
			$cmpt['lid'] = $lid;
			$cmpt['userhtml'] = tll_userhtml($cmpt, $team, 1);
			vB_Template::preRegister('memberaction_dropdown',array('team' => $team));
			vB_Template::preRegister('memberaction_dropdown',array('lid' => $lid)); 
			vB_Template::preRegister('memberaction_dropdown',array('ladder' => $ladder));
			$vbulletin->templatecache['memberaction_dropdown'] = $vbulletin->templatecache['tmnt_memberaction_dropdown'];
			$memberaction_dropdown = construct_memberaction_dropdown($cmpt, $template_hook);
			$memberaction_dropdown = str_replace('</strong></a>', '</strong></a>'.$cmpt['userhtml'], $memberaction_dropdown);
			if ($ladder['league'] != '1')
			{
				$c_idx = 0;
				$ladder['thisgroup'] = 1;
				$templater = vB_Template::create('tmnt_ladder_cmpt');
					$templater->register('tmntp', $tmntp);
					$templater->register('ladder', $ladder);
					$templater->register('id', $id);
					$templater->register('lid', $lid);
					$templater->register('cmpt', $cmpt);
					$templater->register('ddms', $ddms);
					$templater->register('rank', $rank);
					$templater->register('rowno', $rowno);
					$templater->register('avatarlp', $avatarlp);
					$templater->register('c_idx', $c_idx);
					$templater->register('team', $team);
					$templater->register('streak', $streak);
					$templater->register('memberaction_dropdown', $memberaction_dropdown);
				$ccompetitors .= $templater->render();
			}
			else
			{
				$competitors[] = $cmpt;
			}
			$ddms_id = "cmpt".$rowno."_menu";
			$ti++;
			$lastcmpt = $cmpt;
		}
		$ladder['ti'] = $ti;
		if ($ladder['league'] != '1')
		{
			$ladder['thisgroupname'] = $ladder['groupnames']["0"];
			$templater = vB_Template::create('tmnt_ladder_cmpt_top');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('id', $id);
				$templater->register('lid', $lid);
				$templater->register('from', $from);
				$templater->register('to', $to);
				$templater->register('ti', $ti);
				$templater->register('noofcomps', $noofcomps);
				$templater->register('sh', $sh);
			$competitors .= $templater->render();
			$competitors .= $ccompetitors;
		}
		if ($rowno == $offset)
		{
			$templater = vB_Template::create('tmnt_ladder_cmpt_none');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('id', $id);
				$templater->register('lid', $lid);
				$templater->register('cmpt', $cmpt);
				$templater->register('ddms', $ddms);
				$templater->register('rank', $rank);
				$templater->register('rowno', $rowno);
			$competitors .= $templater->render();
		}
		if (!$ladder['league'])
		{
			$pagenav = construct_page_nav($page, $cpp, $noofcomps, "ladders.php?" . $vbulletin->session->vars['sessionurl'] . "do=view&amp;id=$lid", "". ($hide ? "&amp;hide=$hide" : "") . "", "content");
		}
		if ($ladder['league'] != '1')
		{
			$templater = vB_Template::create('tmnt_ladder_cmpt_bot');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('id', $id);
				$templater->register('lid', $lid);
			$competitors .= $templater->render();
		}
		if ((in_array($thisuserid, $array) OR $team) AND $show['member']) {
			$comper = true;
		} else {
			$userid = $thisuserid;
			$username = $thisusername;
			$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid='$id' AND (userid='$userid' OR username='".$vbulletin->db->escape_string($username)."') AND active=1 ");
			$countplayer = $countplayer['countrows'];  
			if ($countplayer != 0) {
				$comper = true;
			} else {
				$comper = false;
				$competitorddms = str_replace("{comper}", "display: none;", $competitorddms);
			}
		}
	}
	else 
	{
		$userid = $thisuserid;
		$username = $thisusername;
		if (!$team) {
			$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid='$id' AND (userid='$userid' OR username='".$vbulletin->db->escape_string($username)."') AND active=1 ");
			$countplayer = $countplayer['countrows'];  
			if ($countplayer != 0) {
				$comper = true;
			} else {
				$comper = false;
			}
		}
	}
	if ($_REQUEST['sh'] == 1)
	{
		$sh = 1;
		if ($ladder['league'])
		{
			$maxrounds = $vbulletin->db->query_first("SELECT g.round FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g WHERE g.lid = '$ladder[id]' AND g.group = 1 ORDER BY g.round DESC");
			$ladder['rounds'] = $maxrounds['round'];
		}
		$ladder['filter_round'] = $vbulletin->input->clean_gpc('g', 'round', TYPE_UINT);
		$ladder['filter_group'] = $vbulletin->input->clean_gpc('g', 'group', TYPE_UINT);
		$ladder['selected']['group_'.$ladder['filter_group']] = ' selected="selected"';
		$ladder['selected']['round_'.$ladder['filter_round']] = ' selected="selected"';
		$templater = vB_Template::create('tmnt_ladder_allchll_top');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
		$competitors .= $templater->render();
		$chlls = $vbulletin->db->query_read("
			SELECT games.*, games.u AS uid, games.u2 AS u2id,
			" . (!$team ? "user.username AS u, userb.username AS u2" : "user.teamname AS u, userb.teamname AS u2") . "
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (games.u = user.userid) LEFT JOIN " . TABLE_PREFIX . "user AS userb ON (games.u2 = userb.userid)" : "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user ON (games.u = user.teamid) LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS userb ON (games.u2 = userb.teamid)") . "
			WHERE games.lid = '$id'
				AND games.finished = '1'
				" . ($ladder['filter_round'] ? " AND games.round = '" . $ladder['filter_round']."'" : "")
				. ($ladder['filter_group'] ? " AND games.group = '" . $ladder['filter_group']."'" : "") . "
			ORDER BY games.dateline_finished DESC, games.id DESC
			LIMIT 0, 11
		");
		$rowno = 0;
		$chllarray = array();
		$mc_ids_array = array();
		while($chll = $vbulletin->db->fetch_array($chlls))
		{
			$rowno ++;
			if ($rowno != 11)
			{
				$chll['display'] = 'none';
				$chllarray["$chll[id]"] = $chll;
				if ($chll['comments'] > 0)
				{
					$mc_ids_array[] = $chll['id'];
				}
			}
			else
			{
				$show['morechll'] = true;
			}
		}
		if ($rowno == 0)
		{
			$templater = vB_Template::create('tmnt_ladder_allchll_none');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('id', $id);
				$templater->register('lid', $lid);
				$templater->register('sh', $sh);
				$templater->register('chll', $chll);
				$templater->register('team', $team);
				$templater->register('rowno', $rowno);
			$competitors .= $templater->render();
		}
		else if (!empty($mc_ids_array))
		{
			$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
		}
		$templater = vB_Template::create('tmnt_ladder_allchll_bot');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('chll', $chll);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
		$competitors .= $templater->render();
	}
	elseif ($_REQUEST['sh'] == 2)
	{
		$sh = 2;
		if ($ladder['league'])
		{
			$maxrounds = $vbulletin->db->query_first("SELECT g.round FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g WHERE g.lid = '$ladder[id]' AND g.group = 1 ORDER BY g.round DESC");
			$ladder['rounds'] = $maxrounds['round'];
		}
		$ladder['filter_round'] = $vbulletin->input->clean_gpc('g', 'round', TYPE_UINT);
		$ladder['filter_group'] = $vbulletin->input->clean_gpc('g', 'group', TYPE_UINT);
		$ladder['selected']['group_'.$ladder['filter_group']] = ' selected="selected"';
		$ladder['selected']['round_'.$ladder['filter_round']] = ' selected="selected"';
		$templater = vB_Template::create('tmnt_ladder_allchll_top');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('chll', $chll);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
		$competitors .= $templater->render();
		$chlls = $vbulletin->db->query_read("SELECT games.*, games.u AS uid, games.u2 AS u2id, " . (!$team ? "user.username AS u, userb.username AS u2" : "user.teamname AS u, userb.teamname AS u2") . " FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games " . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (games.u = user.userid) LEFT JOIN " . TABLE_PREFIX . "user AS userb ON (games.u2 = userb.userid)" : "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user ON (games.u = user.teamid) LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS userb ON (games.u2 = userb.teamid)") . " WHERE games.lid = '$id' AND games.finished = '0' AND games.accepted = '1' " . ($ladder['filter_round'] ? " AND games.round = '" . $ladder['filter_round']."'" : "") . ($ladder['filter_group'] ? " AND games.group = '" . $ladder['filter_group']."'" : "") . " ORDER BY games.id ASC LIMIT 0, 11");
		$rowno = 0;
		while($chll = $vbulletin->db->fetch_array($chlls))
		{
			$rowno ++;
			$chll = process_chal_options($chll);
			if ($rowno == 11)
			{
				$show['morechll'] = true;
			}
			else
			{
				if ($chll['comments'] > 0)
				{
					$mc_ids_array[] = $chll['id'];
				}
				$chll['display'] = 'none';
				$chllarray["$chll[id]"] = $chll;
			}
		}
		if ($rowno == 0)
		{
			$templater = vB_Template::create('tmnt_ladder_allchll_none');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('chll', $chll);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
			$competitors .= $templater->render();
		}
		else
		{
			if (!empty($mc_ids_array))
			{
				$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
			}
			$templater = vB_Template::create('tmnt_ladder_allchll');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('id', $id);
				$templater->register('lid', $lid);
				$templater->register('sh', $sh);
				$templater->register('chll', $chll);
				$templater->register('team', $team);
				$templater->register('rowno', $rowno);
				$templater->register('chllarray', $chllarray);
			$competitors .= $templater->render();
		}
		$templater = vB_Template::create('tmnt_ladder_allchll_bot');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('show', $show);
			$templater->register('chll', $chll);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
		$competitors .= $templater->render();
	}
	elseif ($_REQUEST['sh'] == 3)
	{
		$sh = 3;
		$u = $thisuserid;
		$templater = vB_Template::create('tmnt_ladder_tlchll_top');//tlchll
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('team', $team);
			$templater->register('u', $u);
		$competitors .= $templater->render();
		$games = $vbulletin->db->query_read("
			SELECT games.*, games.u AS uid, games.u2 AS u2id, user.username AS u, user2.username AS u2
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			LEFT JOIN " . TABLE_PREFIX . "user AS user
				ON (games.u = user.userid)
			LEFT JOIN " . TABLE_PREFIX . "user AS user2
				ON (games.u2 = user2.userid)
			WHERE (games.u = $thisuserid OR games.u2 = $thisuserid)
				AND games.finished = 0
				AND games.accepted != -1
				AND games.pot = 0
				AND games.lid = $id	
		"); 
		while($game = $vbulletin->db->fetch_array($games))
		{
			if ($game['u2id'] == 0 && $game['dateline'] < TIMENOW)
			{//remove old match finder challenges which were not accepted
				continue;
			}
			$game = process_chal_options($game);
			$is_u = is_u($game, $thisuserid);
			$is_u2 = is_u2($game, $thisuserid);
			$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
			$game = switch_match_status($game, $is_u, $is_u2);
			$rowno++ ;
			$game['display'] = 'none';
			if ($game['comments'] > 0)
			{
				$mc_ids_array[] = $game['id'];
			}
			$chllarray["$game[id]"] = $game;
		}
		if (!empty($mc_ids_array))
		{
			$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
		}
		$templater = vB_Template::create('tmnt_ladder_chll');//tlchll
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
			$templater->register('u', $u);
			$templater->register('game', $game);
			$templater->register('chllarray', $chllarray);
		$competitors .= $templater->render();
		$templater = vB_Template::create('tmnt_ladder_chll_bot');//tlchll
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
			$templater->register('u', $u);
		$competitors .= $templater->render();
	}
	elseif ($_REQUEST['sh'] == '4')
	{
		$sh = 4;
		$tcount = 0;
		$tmntarray = array();
		$tmnts = $vbulletin->db->query_read("
			SELECT tmnts.id, tmnts.title, winner.username AS username, winner.userid AS userid
			FROM " . TABLE_PREFIX . "tmnt_tmnts AS tmnts
			LEFT JOIN " . TABLE_PREFIX . "tmnt_players AS winner
				ON (winner.tid = tmnts.id)
			WHERE tmnts.ladderid = '$lid'
				
		"); /*AND winner.winner = 1*/
		while($tmnt = $vbulletin->db->fetch_array($tmnts))
		{
			$tmntarray[] = $tmnt;
			$tcount++;
		}
		$templater = vB_Template::create('tmnt_ladder_tmnts');
			$templater->register('tmntp', $tmntp);
			$templater->register('tmntarray', $tmntarray);
			$templater->register('tcount', $tcount);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
			$templater->register('u', $u);
		$competitors .= $templater->render();
	}
	elseif ($_REQUEST['sh'] == 5)
	{
		$sh = 5;
		//paginate this
		$ladder['yourteams'] = array();
		$ladder['teamcount'] = 0;
		$teams = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_members
			RIGHT JOIN " . TABLE_PREFIX . "tmnt_teams
				ON " . TABLE_PREFIX . "tmnt_members.teamid = " . TABLE_PREFIX . "tmnt_teams.teamid
			RIGHT JOIN " . TABLE_PREFIX . "tmnt_ladder_players
				ON " . TABLE_PREFIX . "tmnt_members.teamid = " . TABLE_PREFIX . "tmnt_ladder_players.userid
			WHERE " . TABLE_PREFIX . "tmnt_members.leader=1
				AND " . TABLE_PREFIX . "tmnt_members.userid=$thisuserid
				AND " . TABLE_PREFIX . "tmnt_ladder_players.lid=$lid
		");
		while($teamm = $vbulletin->db->fetch_array($teams))
		{
			$ladder['yourteams'][] = $teamm;
			$ladder['teamcount']++;
		}
		$matches = array();
		$games = $vbulletin->db->query_read("
			SELECT games.*, ".($ladder['pot'] ? " t.teamname AS username" : " u.username AS username")."
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (games.pot = 0 AND games.u = u.userid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
				ON (games.pot = 1 AND games.u = t.teamid)
			WHERE
				games.u2 = 0
				AND games.finished = 0
				AND games.accepted = 0
				AND games.pot = ".$ladder['pot']."
				AND games.lid = $id
				AND games.dateline > ".TIMENOW."
			ORDER BY games.dateline ASC
			LIMIT 0, 20
		");
		while($game = $vbulletin->db->fetch_array($games))
		{
			$game['time'] = vbdate($vbulletin->options['timeformat'], $game['dateline']);
			$game['date'] = vbdate($vbulletin->options['dateformat'], $game['dateline'], true);
			$game = process_chal_options($game);
			$matches[] = $game;
		}
	}
	elseif ($_REQUEST['sh'] == 6)
	{
		$sh = 6;
		$query_rules = $vbulletin->db->query_first("
			SELECT rules
			FROM " . TABLE_PREFIX . "tmnt_rules
		");
		$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list()); 
		$ladder['genrules'] = $bbcode_parser->do_parse($query_rules['rules']);
	}
	elseif ($_REQUEST['sh'] == 7)
	{
		$sh = 7;
	}
	$offset = $ladder['dst'] ? $vbulletin->userinfo['timezoneoffset'] : $vbulletin->userinfo['tzoffset'];
	$ladder['dateline_from_user'] = $ladder['dateline_from'] + $offset * 3600;
	$ladder['dateline_to_user'] = $ladder['dateline_to'] + $offset * 3600;
	require_once(DIR . '/includes/functions_calendar.php');
	$ladder = fetch_event_date_time($ladder);
	if (TIMENOW < $ladder['dateline_from'])
	{
		$ladder['status2'] = $vbphrase['ladder_starting_on']." $date1 $time1";
	}
	elseif ($ladder['dateline_from'] < TIMENOW && TIMENOW < $ladder['dateline_to'])
	{
		$ladder['status2'] = $vbphrase['ladder_closing_on']." $date2 $time2";
	}
	else
	{
		$ladder['status2'] = $vbphrase['ladder_finished_on']." $date2 $time2";
	}
	// facebook options
	if (is_facebookenabled())
	{
		// display the like button for this ladder?
		$templater = vB_Template::create('facebook_likebutton');
		$fb_url = $vbulletin->options['bburl'].'/ladders.php?do=view&amp;id='.$id;
		if(is_browser('ie') || is_browser('opera'))
		{
			$templater->register('href', urlencode($fb_url));
		}
		else 
		{
			$templater->register('href', $fb_url);
		}
		$fblikebutton = $templater->render();
		$show['fb_likebutton'] = true;
	}
	$templater = vB_Template::create('tmnt_ladder_display');
		$templater->register('pagenav', $pagenav);
		$templater->register('tmntp', $tmntp);
		$templater->register('team', $team);
		$templater->register('ladder', $ladder);
		$templater->register('sarray', $sarray);
		$templater->register('TIMENOW', $TIMENOW);
		$templater->register('id', $id);
		$templater->register('sh', $sh);
		$templater->register('lid', $lid);
		$templater->register('comper', $comper);
		$templater->register('rowno', $rowno);
		$templater->register('show', $show);
		$templater->register('competitors', $competitors);
		$templater->register('matches', $matches);
		$templater->register('chllarray', $chllarray);
		$templater->register('competitorddms', $competitorddms);
		$templater->register('time1', $time1);
		$templater->register('time2', $time2);
		$templater->register('date1', $date1);
		$templater->register('date2', $date2);
		$templater->register('fblikebutton', $fblikebutton);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname
	);
	if (!$ladder['league'])
	{
		$navbits['ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'showonly=ladders'] = $vbphrase['ladders'];
	}
	else
	{
		$navbits['ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'showonly=leagues'] = $vbphrase['ladder_leagues'];
	}
	if ($ladder['parenttitle'])
	{
		$navbits['ladders.php?c=' . $ladder['parentid'] . $vbulletin->session->vars['sessionurl_q']] = $ladder['parenttitle'];
	}
	$navbits['ladders.php?c=' . $ladder['catid'] . $vbulletin->session->vars['sessionurl_q']] = $ladder['categorytitle'];
	$navbits[''] = construct_phrase($title);
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladders SET views = views + 1 WHERE id = '$id'
	");
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'matchfinder')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	$inladders = array();
	$globalg = array();
	$globalg['yourteams'] = array();
	$globalg['teamcount'] = 0;
	$teamids = "0";
	$teams = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_members AS members
		RIGHT JOIN " . TABLE_PREFIX . "tmnt_teams AS teams
			ON (members.teamid = teams.teamid)
		WHERE members.leader = '1'
			AND members.userid = '$thisuserid'
	");
	while($teamm = $vbulletin->db->fetch_array($teams))
	{
		$globalg['yourteams'][] = $teamm;
		$globalg['teamcount']++;
		$teamids .= ",".$teamm['teamid'];
	}
	$qinladders = $vbulletin->db->query_read("SELECT lid FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE (userid=$thisuserid AND pot = 0) OR (userid IN (".$teamids.") AND pot = 1) AND active=1");
	while($ladder = $vbulletin->db->fetch_array($qinladders))
	{
		$inladders[] = $ladder['lid'];
	}
	$matches = array();
	$ladders = array();
	$games = $vbulletin->db->query_read("
		SELECT games.*, ladders.title AS laddertitle, IF (games.pot>0,t.teamname,u.username) AS username
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (ladders.id = games.lid)
		LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (games.pot = 0 AND games.u = u.userid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
			ON (games.pot = 1 AND games.u = t.teamid)
		WHERE
			games.u2 = 0
			AND games.finished = 0
			AND games.accepted = 0
			AND games.dateline > ".TIMENOW."
		ORDER BY games.lid ASC, games.dateline ASC
		LIMIT 0, 20
	");
	while($game = $vbulletin->db->fetch_array($games))
	{
		$game['time'] = vbdate($vbulletin->options['timeformat'], $game['dateline']);
		$game['date'] = vbdate($vbulletin->options['dateformat'], $game['dateline'], true);
		$game['showlt'] = true;
		if ($lastgame['lid'] == $game['lid'])
		{
			$game['showlt'] = false;
		}
		$game['notinladder'] = false;
		if (!in_array($game['lid'], $inladders))
		{
			$game['notinladder'] = true;
		}
		$game = process_chal_options($game);
		$matches[] = $game;
		$ladders[] = $game['lid'];
		$lastgame = $game;
	}
	$templater = vB_Template::create('tmnt_ladder_mf');
		$templater->register('pagenav', $pagenav);
		$templater->register('tmntp', $tmntp);
		$templater->register('team', $team);
		$templater->register('globalg', $globalg);
		$templater->register('matches', $matches);
		$templater->register('inladders', $inladders);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => construct_phrase($vbphrase[ladders])
	);
	$navbits[''] = construct_phrase($vbphrase['ladder_match_finder']);
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladders SET views = views + 1 WHERE id = '$id'
	");
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'join')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$userid = $thisuserid;
	$username = $thisusername;
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id' ");
	if (!$id OR !$ladder)
	{
		$errormessage = $vbphrase['error_invalid_ladder'];
		eval(standard_error($errormessage));
	}
	if ($ladder['league'] > 1)
	{
		$errormessage = "Sorry this league has already started, you will next to wait until next season to compete in this league.";
		eval(standard_error($errormessage));
	}
	if ($ladder['pot'] == 0)
	{
		$team = false;
	}
	else
	{
		$team = true;
	}
	if ($ladder['archive'] == 1)
	{
		$errormessage = $vbphrase['error_ladder_closed'];
		eval(standard_error($errormessage));
	}
	$tmax = $ladder['tmax'];
	$tmin = $ladder['tmin'];
	if (!$team)
	{
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid='$id' AND (userid='$userid' OR username='".$vbulletin->db->escape_string($username)."')");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer != 0) {
			$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$id AND (userid=$userid OR username='".$vbulletin->db->escape_string($username)."') AND active=0");
			$countplayer = $countplayer['countrows'];  
			if ($countplayer == 1)
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET active=1 WHERE lid=$id AND (userid=$userid OR username='".$vbulletin->db->escape_string($username)."') AND active=0");
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET noplayers = noplayers + 1 WHERE id=$id");
				$tmnt_ladders = array_merge((array)$vbulletin->userinfo['tmnt_ladders'], (array)$id);
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_ladders = '" . implode(',' , $tmnt_ladders) . "' WHERE userid=$userid");
				$vbulletin->url = "ladders.php?do=view&id=$id";
				eval(print_standard_redirect('redirect_rejoinedladder'));
			}
			$errormessage = $vbphrase['error_already_joined_ladder'];
			eval(standard_error($errormessage));
		}
	}
	if ($team)
	{
		$userteams .= '<select name="teamid" id="teamid">';
		$teams = $vbulletin->db->query_read("
			SELECT m.*, t.*
			FROM " . TABLE_PREFIX . "tmnt_members AS m
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
				ON (m.teamid = t.teamid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladder_players AS p
				ON (p.userid = t.teamid AND p.lid = $id)
			WHERE m.leader = 1
				AND m.userid = $userid
				AND t.noplayers <= $tmax
				AND t.noplayers >= $tmin
				AND p.id IS NULL
		");
		while($teamm = $vbulletin->db->fetch_array($teams))
		{
			$userteams .= "<option value=\"".$teamm['teamid']."\">".$teamm['teamname']."</option>";
			$countuserteams++ ;
		}
		$userteams .= '</select>';
		if ($countuserteams == 0)
		{
			$errormessage = construct_phrase($vbphrase['error_not_leader_ladder'], $id);
			eval(standard_error($errormessage));
		} 
	}
	$templater = vB_Template::create('tmnt_ladder_join');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('team', $team);
		$templater->register('userteams', $userteams);
		$templater->register('ladder', $ladder);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id=' . $id => $ladder['title'],
		'' => construct_phrase($vbphrase['ladder_joining'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'leaveladder')
{
	$lid = $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase['error_invalid_ladder'];
		eval(standard_error($errormessage));
	}
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id=$id ");
	if ($ladder['archive'])
	{
		$errormessage = $vbphrase['error_ladder_closed'];
		eval(standard_error($errormessage));
	}
	$u = $vbulletin->input->clean_gpc('g', 'u', TYPE_UINT);
	if (!$ladder['pot'])
	{
		$team = false;
		if ($u == $thisuserid OR !$u)
		{
			$userid = $thisuserid;
			$username = $thisusername;
		}
		elseif ($tmntp['caneditladder'])
		{
			$userid = $u;
			$userinfo = fetch_userinfo($u);
			$username = $userinfo['username'];
		} 
		else 
		{
			print_no_permission();
		}
	}
	else 
	{
		$team = true;
		//dominic
		if (!$teaminfo = fetch_teaminfo($u))
		{
			$errormessage = $vbphrase['error_invalid_team'];
			eval(standard_error($errormessage));
		}
		$isleader = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid = '$u' AND leader = '1' AND userid = '$thisuserid'");
		if (!$isleader && !$tmntp['caneditladder'])
		{
			print_no_permission();
		}
		$username = $teaminfo['teamname'];
		$userid = $teaminfo['teamid'];
	}
	$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$id' AND userid = '$userid' AND active = 1 ");
	$countplayer = $countplayer['countrows'];  
	if ($countplayer == 1)
	{
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET active = 0
				WHERE lid = '$id'
					AND userid = '$userid'
					AND active = '1'
		");
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tmnt_ladders
			SET noplayers = noplayers - 1
			WHERE id = '$id'
		");
		if (!$team)
		{
			$userinfo = fetch_userinfo($u);
			$tmnt_ladders = array_delete(explode(',',$userinfo['tmnt_ladders']), $id);
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "user
				SET tmnt_ladders = '" . implode(',', $tmnt_ladders) . "'
				WHERE userid = '$userid'
			");
		}
	}
	$vbulletin->url = "ladders.php?do=view&id=$id";
	eval(print_standard_redirect('redirect_leaveladder'));
}

// #############################################################################

if ($_POST['do'] == 'insertjoin')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$id' ");
	if (!$ladder)
	{
		$errormessage = $vbphrase['error_invalid_ladder'];
		eval(standard_error($errormessage));
	}
	if ($ladder['archive'])
	{
		$errormessage = $vbphrase['error_ladder_closed'];
		eval(standard_error($errormessage));
	}
	$team = false;
	if ($ladder['pot'])
	{
		$team = true;
	}
	if (!$team)
	{
		$userid = $vbulletin->input->clean_gpc('p', 'userid', TYPE_UINT);
		if (!$userid) {
			$userid = $thisuserid;
		}
		$username = $vbulletin->input->clean_gpc('p', 'username', TYPE_STR);
		if (!$username)
		{
			$username = $thisusername;
		}
		$userinfo = fetch_userinfo($userid);
		$tmnt_ladders = array_merge((array)$userinfo['tmnt_ladders'], (array)$id);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_ladders = '" . implode(',' , $tmnt_ladders) . "' WHERE userid=$userid");
	}
	if ($team)
	{
		$userid = $vbulletin->input->clean_gpc('p', 'teamid', TYPE_UINT);
			if (!$userid)
			{
				$errormessage = $vbphrase['error_invalid_team'];
				eval(standard_error($errormessage));
			}
		$team = fetch_teaminfo($userid);
		$username = $team['teamname'];
		if (!$username)
		{
			$errormessage = $vbphrase['error_invalid_team'];
			eval(standard_error($errormessage));
		}
	}
	$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$id' AND (userid = '$userid' OR username = '".$vbulletin->db->escape_string($username)."') ");
	$countplayer = $countplayer['countrows'];  
	if ($countplayer != 0)
	{
		if ($countplayer == 1)
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET active=1 WHERE lid=$id AND (userid=$userid OR username='".$vbulletin->db->escape_string($username)."') AND active=0");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET noplayers = noplayers + 1 WHERE id=$id");
			$vbulletin->url = "ladders.php?do=view&id=$id";
			eval(print_standard_redirect('redirect_rejoinedladder'));
		}
		$errormessage = $vbphrase['error_already_joined_ladder'];
		eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_players
		(userid, username, lid, time, ip, pot, rank)
		VALUES (
			'".$userid."',
			'".$vbulletin->db->escape_string($username)."',
			'".$ladder['id']."',
			".TIMENOW.",
			'".$vbulletin->db->escape_string($thisip)."',
			'".$ladder['pot']."',
			'".$ladder['startingelo']."'
		)
	");
	$vbulletin->url = "ladders.php?do=view&id=$id";
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET noplayers = noplayers + 1 WHERE id=$id");
	eval(print_standard_redirect('redirect_insertjoinladder'));
}

// #############################################################################

if ($_REQUEST['do'] == 'teamchal')
{
	$_REQUEST['do'] = 'insertchal';
}

// #############################################################################

if ($_REQUEST['do'] == 'insertchal')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	if (!$lid)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}	
	$u2 = $vbulletin->input->clean_gpc('g', 'u2', TYPE_INT);
		if (!$u2 || $u2 < -1)
		{
			$errormessage = $vbphrase['error_invalid_challenger'];
			eval(standard_error($errormessage));
		}
	$u = $thisuserid;
	$userid = $thisuserid;
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = $lid ");
	if ($ladder['archive'])
	{
		$errormessage = $vbphrase['error_ladder_closed'];
		eval(standard_error($errormessage));
	}
	if ($ladder['league'])
	{
		$errormessage = 'Error, this is a league';
		eval(standard_error($errormessage));
	}
	$co_array2 = unserialize($ladder['chal_options']);
	if (is_array($co_array2))
	{
		$co_array = array();
		foreach($co_array2 AS $key => $value)
		{
			$key2 = str_replace(' ','_',$key);
			$key2 = preg_replace("/[^a-zA-Z0-9_\s]/", "", unhtmlspecialchars($key2));
			if ($value)
			{
				$co_array["$key2"] = 
				array(
					'value' => explode("\r\n",$value),
					'key' => $key
				);
			}
			else
			{
				$co_array["$key2"] = 
				array(
					'value' => $value,
					'key' => $key
				);
			}
		}
	}
	$time_limit = TIMENOW - ($vbulletin->options['tmnt_ladder_limitrematch'] * 60 * 60);
	$countlimit = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND dateline_finished > '" . $time_limit . "' ");
	if ($countlimit['countrows'])
	{
		$days = floor($vbulletin->options['tmnt_ladder_limitrematch']/24);
		$hours = $vbulletin->options['tmnt_ladder_limitrematch'] - $days * 24;
		$errormessage = "Please wait " . ($days ? "$days days " : "") . ($hours ? "$hours hours " : "") . "between challenging the same player/team.";
		eval(standard_error($errormessage));
	}
	if (!$ladder['pot'])
	{
		if ($u == $u2)
		{
			$errormessage = $vbphrase['error_invalid_challenger'];
			eval(standard_error($errormessage));
		}
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND finished=0 ");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer >= $vbulletin->options['tmnt_ladder_maxc'])
		{
			$errormessage = $vbphrase['error_already_challenged'];
			eval(standard_error($errormessage));
		}
		if ($u2 != -1)
		{
			$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u2 AND active=1");
			$countplayer = $countplayer['countrows'];  
			if ($countplayer != 1)
			{
				$errormessage = $vbphrase['error_player_not_ladder'];
				eval(standard_error($errormessage));
			}
		}
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u AND active=1");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer != 1) {
			$errormessage = $vbphrase['error_you_not_ladder'];
			eval(standard_error($errormessage));
		}
		$username_u = $thisusername;
		$username_u2 = fetch_userinfo($u2);
		$username_u2 = $username_u2['username'];
		// end single bit
	}
	else
	{
		// start team bit
		if ($u2 != -1)
		{
			$countteam = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u2 AND pot=1");
			$countteam = $countteam['countrows'];  
			if ($countteam != 1)
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET pot = 1 WHERE lid=$lid");
				$errormessage = $vbphrase['error_team_not_ladder'];
				eval(standard_error($errormessage));
			}
		}
		$userteams .= '<select name="u" id="u">';
		$teams = $vbulletin->db->query_read("SELECT *
			FROM " . TABLE_PREFIX . "tmnt_members
			RIGHT JOIN " . TABLE_PREFIX . "tmnt_teams
			on " . TABLE_PREFIX . "tmnt_members.teamid = " . TABLE_PREFIX . "tmnt_teams.teamid
			RIGHT JOIN " . TABLE_PREFIX . "tmnt_ladder_players
			on " . TABLE_PREFIX . "tmnt_members.teamid = " . TABLE_PREFIX . "tmnt_ladder_players.userid
			WHERE " . TABLE_PREFIX . "tmnt_members.leader=1
			AND " . TABLE_PREFIX . "tmnt_members.userid=$userid
			AND " . TABLE_PREFIX . "tmnt_ladder_players.lid=$lid
			AND " . TABLE_PREFIX . "tmnt_ladder_players.userid!=$u2");
		while($teamm = $vbulletin->db->fetch_array($teams))
		{
			$userteams .= "<option value=\"".$teamm['teamid']."\">".$teamm['teamname']."</option>";
			$countuserteams++ ;
		}
		$userteams .= '</select>';
		if ($countuserteams == 0)
		{
			$errormessage = $vbphrase['error_not_teamleader'];
			eval(standard_error($errormessage));
		}
		$challenged = fetch_teaminfo($u2);
		// end  team bit
	}
	$day = vbdate("j", TIMENOW);
	$month = vbdate("n", TIMENOW);
	$year = vbdate("Y", TIMENOW);
	$monthselected = array();
	$yearselected = array();
	$monthselected["$month"] = 'selected="selected"';
	$yearselected["$year"] = 'selected="selected"';
	$yearbits = '';
	for ($gyear = 2005; $gyear <= 2015; $gyear++)
	{
		$yearbits .= "\t\t<option value=\"$gyear\" $yearselected[$gyear]>$gyear</option>";
	}
	if (strpos($vbulletin->options['timeformat'], 'H') !== false)
	{
		$show['24hour'] = true;
	}
	else
	{
		$show['24hour'] = false;
	}
	$time = vbdate($vbulletin->options['timeformat'], TIMENOW);
	require_once(DIR . '/includes/functions_misc.php');
	$timezoneoptions = '';
	foreach (fetch_timezone() AS $optionvalue => $timezonephrase)
	{
		$optiontitle = $vbphrase["$timezonephrase"];
		$optionselected = ($optionvalue == $vbulletin->userinfo['timezoneoffset'] ? 'selected="selected"' : '');
		$timezoneoptions .= render_option_template($optiontitle, $optionvalue, $optionselected, $optionclass);
	}
	//dominic2
	$templater = vB_Template::create('tmnt_ladder_chal');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('challenged', $challenged);
		$templater->register('userteams', $userteams);
		$templater->register('username_u2', $username_u2);
		$templater->register('username_u', $username_u);
		$templater->register('u2', $u2);
		$templater->register('co_array', $co_array);
		$templater->register('time', $time);
		$templater->register('day', $day);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('monthselected', $monthselected);
		$templater->register('yearbits', $yearbits);
		$templater->register('dstchecked', $dstchecked);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id=' . $lid => $ladder['title'],
		'' => construct_phrase($vbphrase['ladder_chal'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'insertmatch')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
		if (!$lid) {
			$errormessage = $vbphrase[error_invalid_ladder];
			eval(standard_error($errormessage));
		}
	$pot = $vbulletin->input->clean_gpc('p', 'pot', TYPE_UINT);
	$u = $vbulletin->input->clean_gpc('p', 'u', TYPE_UINT);
		if (!$u) {
			$errormessage = $vbphrase[error_invalid_challenger];
			eval(standard_error($errormessage));
		}
	$u2 = $vbulletin->input->clean_gpc('p', 'u2', TYPE_UINT);
		if (!$u2)
		{
			$errormessage = $vbphrase[error_invalid_challenged];
			eval(standard_error($errormessage));
		}
	if ($u == $u2)
	{
		$errormessage = $vbphrase[error_invalid_challenger];
		eval(standard_error($errormessage));
	}
	$bestof = $vbulletin->input->clean_gpc('p', 'bestof', TYPE_UINT);
	$map = $vbulletin->input->clean_gpc('p', 'map', TYPE_NOHTML);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id=$lid ");
	$co_array = unserialize($ladder['chal_options']);
	$chal_options = array();
	if (is_array($co_array))
	{
		foreach ($co_array AS $key => $value)
		{
			$key = str_replace(' ','_',$key);
			$key = preg_replace("/[^a-zA-Z0-9_\s]/", "", unhtmlspecialchars($key));
			$chal_options["$key"] = $vbulletin->input->clean_gpc('p', "$key", TYPE_NOHTML);
		}
		$chal_options = serialize($chal_options);
	}
	if ($ladder['archive'] == '1')
	{
		$errormessage = $vbphrase[error_ladder_closed];
		eval(standard_error($errormessage));
	}
	$countchal = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND finished=0 ");
	$countchal = $countchal['countrows'];  
	if ($countchal != 0) {
		$errormessage = $vbphrase[error_already_challenged];
		eval(standard_error($errormessage));
	}
	$countu = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u ");
	$countu = $countu['countrows'];  
	if ($countu != 1) {
		$errormessage = $vbphrase[error_invalid_challenger];
		eval(standard_error($errormessage));
	}
	$countu2 = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u2 ");
	$countu2 = $countu2['countrows'];  
	if ($countu2 != 1)
	{
		$errormessage = $vbphrase[error_invalid_challenged];
		eval(standard_error($errormessage));
	}
	/* challenge time/date */
	$vbulletin->input->clean_array_gpc('p', array(
		'timezoneoffset' => TYPE_ARRAY_NUM,
		'dst'            => TYPE_ARRAY_UINT,
		'date'       => TYPE_ARRAY_ARRAY,
		'time'       => TYPE_ARRAY_NOHTML
	));
	$type = 'range';
	$time = $vbulletin->GPC['time']["$type"];
	$date = $vbulletin->input->clean($vbulletin->GPC['date']["$type"], TYPE_ARRAY_UINT);
	$utc = $timezoneoffset = $vbulletin->GPC['timezoneoffset']["$type"];
	$dst = $vbulletin->GPC['dst']["$type"] = 1;
	require_once(DIR . '/includes/functions_misc.php');
	if (!fetch_timezone($timezoneoffset))
	{
		$errormessage = "Error: invalid timezone specified";
		eval(standard_error($errormessage));
	}
	if (!checkdate($date['month'], $date['day'], $date['year']))
	{
		$errormessage = "Error: Bad Date";
		eval(standard_error($errormessage));
	}
	$time_re = '#^(0?[1-9]|1[012])\s*[:.]\s*([0-5]\d)(\s*[AP]M)?|([01]\d|2[0-3])\s*[:.]\s*([0-5]\d)$#i';

	// match text in field for a valid time
	if (preg_match($time_re, $time, $matches))
	{
		if (count($matches) == 3)
		{
			$hour = intval($matches[1]);
			$minute = intval($matches[2]);
			$ampm = $matches[1] == '12' ? 'PM' : 'AM';
		}
		else if (count($matches) == 4)
		{
			$hour = intval($matches[1]);
			$minute = intval($matches[2]);
			$ampm = strtoupper(trim($matches[3]));
		}
		else // 24hr time
		{
			$hour = intval($matches[4]);
			$minute = intval($matches[5]);
			$ampm = ($hour <= 11) ? 'AM' : 'PM';
		}
	}
	if (($pos = strpos($vbulletin->options['timeformat'], 'H')) === false)
	{
		if ($ampm == 'PM')
		{
			if ($hour >= 1 AND $hour <= 11)
			{
				$hour += 12;
			}
		}
		else
		{
			if ($hour == 12)
			{
				$hour = 0;
			}
		}
	}
	$min_offset = $utc - intval($utc);
	$hour   -= intval($utc);
	$minute -= intval($min_offset * 60);
	$dateline = gmmktime($hour, $minute, 0, $date['month'], $date['day'], $date['year']);
	/* end challenge time/date */
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_games
		(u, u2, lid, time, pot, accepted, bestof, matchdate, map, u1message, u2message, chal_options, dateline)
		VALUES (
			'".$vbulletin->db->escape_string($u)."',
			'".$vbulletin->db->escape_string($u2)."',
			'".$vbulletin->db->escape_string($lid)."',
			".TIMENOW.",
			'".$vbulletin->db->escape_string($pot)."',
			'1',
			'".$vbulletin->db->escape_string($bestof)."',
			'".$vbulletin->db->escape_string($matchdate)."',
			'".$vbulletin->db->escape_string($map)."',
			'".$vbulletin->db->escape_string($u1message)."',
			'".$vbulletin->db->escape_string($u2message)."',
			'".$vbulletin->db->escape_string($chal_options)."',
			'".$vbulletin->db->escape_string($dateline)."'
		)
	");
	$vbulletin->url = "ladders.php?do=view&id=$lid&sh=2";
	eval(print_standard_redirect('redirect_insertchalladder'));
}

// #############################################################################

if ($_REQUEST['do'] == 'insertmatch')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id) {
			$errormessage = $vbphrase[error_invalid_ladder];
			eval(standard_error($errormessage));
		}
	$lid = $id;
	$ladders = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id'");
	if (!$ladders)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$co_array2 = unserialize($ladders['chal_options']);
	if (is_array($co_array2))
	{
		$co_array = array();
		foreach($co_array2 AS $key => $value)
		{
			$key2 = str_replace(' ','_',$key);
			$key2 = preg_replace("/[^a-zA-Z0-9_\s]/", "", unhtmlspecialchars($key2));//dom101
			if ($value)
			{
				$co_array["$key2"] = 
				array(
					'value' => explode("\r\n",$value),
					'key' => $key
				);
			}
			else
			{
				$co_array["$key2"] = 
				array(
					'value' => $value,
					'key' => $key
				);
			}
		}
	}
	$title = $ladders['title'];
	if ($ladders['pot'] == 1) {
		$team = true;
	} else {
		$team = false;
	}
	$cmpts = $vbulletin->db->query_read("SELECT players.*, players.userid AS userid" . (!$team ? ", user.username AS username" : ", user.teamname AS username") . "
		FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
		" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (players.userid = user.userid) " : "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user ON (players.userid = user.teamid) ") . "
		WHERE players.lid=$id AND players.active=1 ORDER BY " . (!$team ? "user.username" : "user.teamname") . " ASC");
	while($cmpt = $vbulletin->db->fetch_array($cmpts))
	{
		$competitors .= '<option value="'. $cmpt[userid] .'">'. $cmpt[username] .'</option>';
	}
	$day = vbdate("j", TIMENOW);
	$month = vbdate("n", TIMENOW);
	$year = vbdate("Y", TIMENOW);
	$monthselected = array();
	$yearselected = array();
	$monthselected["$month"] = 'selected="selected"';
	$yearselected["$year"] = 'selected="selected"';
	$yearbits = '';
	for ($gyear = 2005; $gyear <= 2015; $gyear++)
	{
		$yearbits .= "\t\t<option value=\"$gyear\" $yearselected[$gyear]>$gyear</option>";
	}
	if (strpos($vbulletin->options['timeformat'], 'H') !== false)
	{
		$show['24hour'] = true;
	}
	else
	{
		$show['24hour'] = false;
	}
	$time = vbdate($vbulletin->options['timeformat'], TIMENOW);
	require_once(DIR . '/includes/functions_misc.php');
	$timezoneoptions = '';
	foreach (fetch_timezone() AS $optionvalue => $timezonephrase)
	{
		$optiontitle = $vbphrase["$timezonephrase"];
		$optionselected = ($optionvalue == $vbulletin->userinfo['timezoneoffset'] ? 'selected="selected"' : '');
		$timezoneoptions .= render_option_template($optiontitle, $optionvalue, $optionselected, $optionclass);
	}
	$templater = vB_Template::create('tmnt_ladder_insertmatch');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('competitors', $competitors);
		$templater->register('team', $team);
		$templater->register('title', $title);
		$templater->register('co_array', $co_array);
		$templater->register('time', $time);
		$templater->register('day', $day);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('monthselected', $monthselected);
		$templater->register('yearbits', $yearbits);
		$templater->register('dstchecked', $dstchecked);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?do=view&id='.$lid . $vbulletin->session->vars['sessionurl_q'] => $title,
		'' => construct_phrase($vbphrase['ladder_insertmatch'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'challenges')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$from = 'challenges';
	$rowcount = 0;
	$team = false;
	if ($vbulletin->userinfo['tmnt_notifications'])
	{
		if (!is_array($vbulletin->userinfo['tmnt_notifications']))
		{
			$vbulletin->userinfo['tmnt_notifications'] = unserialize($vbulletin->userinfo['tmnt_notifications']);
		}
		if (($vbulletin->userinfo['tmnt_notifications']['ladder_chals']+$vbulletin->userinfo['tmnt_notifications']['ladder_accepts']) > 0)
		{
			$vbulletin->userinfo['tmnt_notifications']['ladder_chals'] = 0;
			$vbulletin->userinfo['tmnt_notifications']['ladder_accepts'] = 0;
			$vbulletin->userinfo['tmnt_notifications'] = serialize($vbulletin->userinfo['tmnt_notifications']);
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($vbulletin->userinfo['tmnt_notifications'])."' WHERE userid = '".$vbulletin->userinfo['userid']."'");
		}
		//$vbulletin->userinfo['tmnt_notifications'] = unserialize($vbulletin->userinfo['tmnt_notifications']);
	}
	$templater = vB_Template::create('tmnt_ladder_chll_top');
	$templater->register('tmntp', $tmntp);
	$templater->register('rowno', $rowno);
	$templater->register('team', $team);
	$tlhtml .= $templater->render();
	$games = $vbulletin->db->query_read("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.username AS u, user2.username AS u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (games.u = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2
			ON (games.u2 = user2.userid)
		WHERE (games.u = $thisuserid OR games.u2 = $thisuserid)
			AND games.finished = 0
			AND games.accepted != -1
			AND games.pot = 0
			AND games.u2 != 0
		ORDER BY lid
		");
	$mc_ids_array = array();
	$lastltitle = '';
	$chllarray = array();
	while($game = $vbulletin->db->fetch_array($games))
	{
		$game['display'] = 'none';
		if ($game['comments'] > 0)
		{
			$mc_ids_array[] = $game['id'];
		}
		$game = process_chal_options($game);
		$game['showltitle'] = false;
		if ($lastltitle != $game['ltitle'])
		{
			$game['showltitle'] = true;
		}
		$lastltitle = $game['ltitle'];
		if ($game['uid'] == $thisuserid)
		{
			$is_u = true;
		}
		else
		{
			$is_u = false;
		}
		if ($game['u2id'] == $thisuserid)
		{
			$is_u2 = true;
		}
		else
		{
			$is_u2 = false;
		}
		$lid = $game['lid'];
		$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
		$game['showflags'] = true;
		//start match status
		if ($game['accepted'] == 0)
		{
			$game['status'] = $vbphrase[tmnt_awaiting_acceptance];
			if ($is_u2)
			{
				$game['status'] = $game['status'].'. <br /> <a href="ladders.php?do=accept&amp;id='.$game['id'].'&amp;u='.$game['uid'].'">'.$vbphrase[tmnt_accept_now].'</a>! <br /> <a href="ladders.php?do=reject&amp;id='.$game['id'].'">'.$vbphrase[tmnt_reject_now].'</a>!';
			}
			$game['showflags'] = false;
		}
		elseif ($game['agree_u'] == 0 && $game['agree_u2'] == 0)
		{
			$game['status'] = $vbphrase['tmnt_awaiting_scores'] . ' <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase['tmnt_submit_score_now'].'</a>!';
		}
		elseif ($game['agree_u'] == 0)
		{
			if ($is_u)
			{
				$game['status'] = $vbphrase['tmnt_awaiting_your_score'] . '. <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase['tmnt_submit_score_now'] . '</a>!';
			}
			else
			{
				$game['status'] = $vbphrase['tmnt_awaiting_opponents_score'];
			}
		}
		elseif ($game['agree_u2'] == 0)
		{
			if ($is_u2)
			{
				$game['status'] = $vbphrase['tmnt_awaiting_your_score'] . '. <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase['tmnt_submit_score_now'] . '</a>!';
			}
			else
			{
				$game['status'] = $vbphrase['tmnt_awaiting_opponents_score'];
			}
		}
		//end match status
		$rowno++ ;
		if ($game['comments'] > 0)
		{
			$mc_ids_array[] = $game['id'];
		}
		$chllarray["$game[id]"] = $game;
	}
	if (!empty($mc_ids_array))
	{
		$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
	}
	$templater = vB_Template::create('tmnt_ladder_chll');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('show', $show);
		$templater->register('from', $from);
		$templater->register('chllarray', $chllarray);
	$tlhtml .= $templater->render();
	$team = true;
	$templater = vB_Template::create('tmnt_ladder_chll_bot');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('team', $team);
	$tlhtml .= $templater->render();
	$userid = $thisuserid;
	$teamids = array();
	$teamnames = array();
	$teamarray = array();
	$teamcount = 0;
	$teams = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_members AS members
		JOIN " . TABLE_PREFIX . "tmnt_teams AS teams
			on members.teamid = teams.teamid
		WHERE members.leader=1
			AND members.userid='$userid'");
	while($teamm = $vbulletin->db->fetch_array($teams))
	{
		$teamid = $teamm['teamid'];
		$teamname = $teamm['teamname'];
		$teamids = array_merge((array)$teamid, $teamids);
		$teamnames = array_merge((array)$teamname, $teamnames);
		$teamarray[] = $teamm;
		$teamcount++;
	}
	$eteamids = $teamids;
	$teamids = implode(",", $teamids);
	$yourteams = implode(", ", $teamnames);
	if ($teamcount > 0)
	{
		$rowcount = 0;
		$team = true;
		$templater = vB_Template::create('tmnt_ladder_yourteams');
		$templater->register('teamarray', $teamarray);
		$tlhtml .= $templater->render();
		$templater = vB_Template::create('tmnt_ladder_chll_top');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('team', $team);
		$tlhtml .= $templater->render();
		$games = $vbulletin->db->query_read("
			SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.teamname AS u, user2.teamname AS u2
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
				ON (games.lid = ladders.id)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user
				ON (games.u = user.teamid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user2
				ON (games.u2 = user2.teamid)
			WHERE (games.u IN (".$teamids.") OR games.u2 IN (".$teamids."))
				AND games.finished = 0
				AND games.accepted != -1
				AND games.pot = 1
		");
		$lastltitle = '';
		$chllarray = array();
		$mc_ids_array = array();
		while($game = $vbulletin->db->fetch_array($games))
		{
			$game['display'] = 'none';
			$game = process_chal_options($game);
			$lid = $game['lid']; 
			$game['showltitle'] = false;
			if ($lastltitle != $game['ltitle'])
			{
				$game['showltitle'] = true;
			}
			$lastltitle = $game['ltitle'];
			$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
			if (in_array($game['uid'], $eteamids))
			{
				$is_u = true;
			}
			else
			{
				$is_u = false;
			}
			if (in_array($game['u2id'], $eteamids))
			{
				$is_u2 = true;
			}
			else
			{
				$is_u2 = false;
			}
			$game['showflags'] = true;
			//start match status
			if ($game['accepted'] == 0)
			{
				$game['status'] = $vbphrase[tmnt_awaiting_acceptance];
				if ($is_u2)
				{
					$game['status'] = $game['status'].'. <br /> <a href="ladders.php?do=teamaccept&amp;id='.$game['id'].'">'.$vbphrase[tmnt_accept_now].'</a>! <br /> <a href="ladders.php?do=teamreject&amp;id='.$game['id'].'">'.$vbphrase[tmnt_reject_now].'</a>!';
				}
				$game['showflags'] = false;
			}
			elseif ($game['agree_u'] == 0 && $game['agree_u2'] == 0)
			{
				$game['status'] = $vbphrase[tmnt_awaiting_scores] . ' <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now].'</a>!';
			}
			elseif ($game['agree_u'] == 0)
			{
				if ($is_u)
				{
					$game['status'] = $vbphrase[tmnt_awaiting_your_score] . '. <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now] . '</a>!';
				}
				else
				{
					$game['status'] = $vbphrase[tmnt_awaiting_opponents_score];
				}
			}
			elseif ($game['agree_u2'] == 0)
			{
				if ($is_u2)
				{
					$game['status'] = $vbphrase[tmnt_awaiting_your_score] . '. <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now] . '</a>!';
				}
				else
				{
					$game['status'] = $vbphrase[tmnt_awaiting_opponents_score];
				}
			}
			//end match status
			/*if ($game['accepted'] == 0) {
				if (in_array($game['u2id'], $eteamids)) {
					$game['accepted'] = $vbphrase[tmnt_no].'. <br /> <a href="competitions.php?do=ladderteamaccept&amp;id='.$game['id'].'">'.$vbphrase[tmnt_accept_now].'</a>! <br /> <a href="competitions.php?do=ladderteamreject&amp;id='.$game['id'].'">'.$vbphrase[tmnt_reject_now].'</a>!';
				} else {
					$game['accepted'] = $vbphrase[tmnt_no].'.';
				}
			} elseif ($game['accepted'] == 1) {
				$game['accepted'] = $vbphrase[yes];
			}
			if ($game['agree_u'] == 0) {
				if (in_array($game['uid'], $eteamids) AND $game['accepted'] == 'Yes') {
					$game['agree_u'] = $vbphrase[tmnt_no].'. <a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">'.$vbphrase[tmnt_submit_score_now].'</a>!';
				} else {
					$game['agree_u'] = $vbphrase[tmnt_no];
				}
			} elseif ($game['agree_u'] == 1) {
				$game['agree_u'] = $vbphrase[yes];
			}
			if ($game['agree_u2'] == 0) {
				if (in_array($game['u2id'], $eteamids) AND $game['accepted'] == 'Yes') {
					$game['agree_u2'] = $vbphrase[tmnt_no].'. <a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">'.$vbphrase[tmnt_submit_score_now].'</a>!';
				} else {
					$game['agree_u2'] = $vbphrase[tmnt_no];
				}
			} elseif ($game['agree_u2'] == 1) {
				$game['agree_u2'] = $vbphrase[yes];
			}*/
			$rowno++ ;
			if ($game['comments'] > 0)
			{
				$mc_ids_array[] = $game['id'];
			}
			$chllarray["$game[id]"] = $game;
		}
		if (!empty($mc_ids_array))
		{
			$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
		}
		$templater = vB_Template::create('tmnt_ladder_chll');
			$templater->register('tmntp', $tmntp);
			$templater->register('rowno', $rowno);
			$templater->register('team', $team);
			$templater->register('from', $from);
			$templater->register('chllarray', $chllarray);
		$tlhtml .= $templater->render();
		$templater = vB_Template::create('tmnt_ladder_chll_bot');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('team', $team);
		$tlhtml .= $templater->render();
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => $vbphrase['ladder'] . " " . $vbphrase['ladder_chlls']
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'acceptmatchdate')
{
	$vbulletin->input->clean_array_gpc('g', array(
		'mid' => TYPE_UINT,
		'dateline' => TYPE_UINT
	));
	$game = $vbulletin->db->query_first("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.username AS u, user2.username AS u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (games.u = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2
			ON (games.u2 = user2.userid)
		WHERE games.finished = 0
			AND games.accepted != -1
			AND games.id = '".$vbulletin->GPC['mid']."'
	");
	if (!$game OR !$vbulletin->GPC['dateline'])
	{
		print_no_permission();
	}
	if ($game['uid'] == $vbulletin->userinfo['userid'])
	{
		$is = 'u';
		$ois = 'u2';
	}
	elseif ($game['u2id'] == $vbulletin->userinfo['userid'])
	{
		$is = 'u2';
		$ois = 'u';
	}
	else
	{
		print_no_permission();
	}
	if ($game['ram'])
	{
		$game['ram'] = unserialize($game['ram']);
	}
	if (is_array($game['ram']) && $game['ram']["$ois"])
	{
		$game['opp_sd'] = array();
		for ($i = 1; $i <= 3; $i++)
		{
			if ($game['ram']["$ois"]["dateline$i"])
			{
				$game['opp_sd'][] = $game['ram']["$ois"]["dateline$i"];
			}
		}
	}
	if (!in_array($vbulletin->GPC['dateline'], $game['opp_sd']))
	{
		print_no_permission();
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
		SET ram = '', dateline = '".$vbulletin->GPC['dateline']."'
		WHERE id = '".$vbulletin->GPC['mid']."'
	");
	$vbulletin->url = "ladders.php?do=view&amp;id=".$game['lid']."&amp;sh=2&amp;mid=".$vbulletin->GPC['mid']."#match".$vbulletin->GPC['mid'];
	eval(print_standard_redirect('redirect_updatechal'));
}

// #############################################################################

if ($_POST['do'] == 'rearrange_match')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'timezoneoffset' => TYPE_ARRAY_NUM,
		'dst'            => TYPE_ARRAY_UINT,
		'mid'            => TYPE_UINT,
		'd1date'         => TYPE_ARRAY_ARRAY,
		'd1time'       => TYPE_ARRAY_NOHTML,
		'd2date'         => TYPE_ARRAY_ARRAY,
		'd2time'       => TYPE_ARRAY_NOHTML,
		'd3date'         => TYPE_ARRAY_ARRAY,
		'd3time'       => TYPE_ARRAY_NOHTML
	));
	$type = 'range';
	$timezoneoffset = $vbulletin->userinfo['timezoneoffset'];
	$d1time = $vbulletin->GPC['d1time']["$type"];
	$d1date = $vbulletin->input->clean($vbulletin->GPC['d1date']["$type"], TYPE_ARRAY_UINT);
	$d2time = $vbulletin->GPC['d2time']["$type"];
	$d2date = $vbulletin->input->clean($vbulletin->GPC['d2date']["$type"], TYPE_ARRAY_UINT);
	$d3time = $vbulletin->GPC['d3time']["$type"];
	$d3date = $vbulletin->input->clean($vbulletin->GPC['d3date']["$type"], TYPE_ARRAY_UINT);
	$utc = $timezoneoffset = $vbulletin->GPC['timezoneoffset']["$type"];
	$dst = $vbulletin->GPC['dst']["$type"];
	$mid = $vbulletin->GPC['mid'];
	require_once(DIR . '/includes/functions_misc.php');
	if (!fetch_timezone($timezoneoffset))
	{
		$errormessage = 'Error: invalid timezone specified';
		eval(standard_error($errormessage));
	}	
	$dateline1 = tmnt_fields_to_dateline($d1time, $d1date, $utc, $dst, $type);
	$dateline2 = tmnt_fields_to_dateline($d2time, $d2date, $utc, $dst, $type);
	$dateline3 = tmnt_fields_to_dateline($d3time, $d3date, $utc, $dst, $type);
	$game = $vbulletin->db->query_first("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.username AS u, user2.username AS u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (games.u = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2
			ON (games.u2 = user2.userid)
		WHERE games.finished = 0
			AND games.accepted != -1
			AND games.id = '$mid'
	");
	if (!$game)
	{
		print_no_permission();
	}
	if ($game['uid'] == $vbulletin->userinfo['userid'])
	{
		$is = 'u';
		$ois = 'u2';
	}
	elseif ($game['u2id'] == $vbulletin->userinfo['userid'])
	{
		$is = 'u2';
		$ois = 'u';
	}
	else
	{
		print_no_permission();
	}
	if ($game['ram'])
	{
		$game['ram'] = unserialize($game['ram']);
	}
	if (is_array($game['ram']))
	{
		$ram = serialize(array(
			"$ois" => $game['ram']["$ois"],
			"$is" => array('userid' => $vbulletin->userinfo['userid'], 'dateline' => TIMENOW, 'dateline1' => $dateline1, 'dateline2' => $dateline2, 'dateline3' => $dateline3)
		));
	}
	else
	{
		$ram = serialize(array(
			"$ois" => array(),
			"$is" => array('userid' => $vbulletin->userinfo['userid'], 'dateline' => TIMENOW, 'dateline1' => $dateline1, 'dateline2' => $dateline2, 'dateline3' => $dateline3)
		));
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
		SET ram = '".$vbulletin->db->escape_string($ram)."'
		WHERE id = '".$vbulletin->GPC['mid']."'
	");
	$vbulletin->url = "ladders.php?do=rearrange_match&amp;mid=".$mid;
	eval(print_standard_redirect('redirect_updatechal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'rearrange_match')
{
	$mid = $vbulletin->input->clean_gpc('g', 'mid', TYPE_UINT);
	$game = $vbulletin->db->query_first("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.username AS u, user2.username AS u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (games.u = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2
			ON (games.u2 = user2.userid)
		WHERE games.finished = 0
			AND games.accepted != -1
			AND games.id = '$mid'
	");
	if (!$game)
	{
		print_no_permission();
	}
	if ($game['uid'] == $vbulletin->userinfo['userid'])
	{
		$is = 'u';
		$ois = 'u2';
	}
	elseif ($game['u2id'] == $vbulletin->userinfo['userid'])
	{
		$is = 'u2';
		$ois = 'u';
	}
	else
	{
		print_no_permission();
	}
	if ($game['ram'])
	{
		$game['ram'] = unserialize($game['ram']);
	}
	if (!$game['dateline'])
	{
		$game['nodateline'] = true;
		$game['dateline'] = TIMENOW + 86400;
	}
	$utc = $vbulletin->userinfo['timezoneoffset'];
	$dst = 1;
	for ($i = 1; $i <= 3; $i++)
	{
		if (!is_array($game['ram']) OR !$game['ram']["$is"]["dateline$i"])
		{
			$dateline = $game['dateline'] + (($i - 1) * 86400);
		}
		else
		{
			$dateline = $game['ram']["$is"]["dateline$i"];
		}
		list ($timezoneoptions, $day, $monthselected, $yearbits, $time, $dstchecked, $show) = tmnt_dateline_to_fields($dateline, $utc, $dst, $show);
		$templater = vB_Template::create('tmnt_date_time');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('timezoneoptions', $timezoneoptions);
			$templater->register('dstchecked', $dstchecked);
			$templater->register('time', $time);
			$templater->register('day', $day);
			$templater->register('monthselected', $monthselected);
			$templater->register('yearbits', $yearbits);
			$templater->register('rangeid', 0);
			$templater->register('prefix', 'd'.$i);
		if ($i == 1)
		{
			$dh = "datehtml"; 
		}
		else
		{
			$dh = "datehtml$i"; 
		}
		$$dh = $templater->render();
	}
	if (is_array($game['ram']) && $game['ram']["$ois"])
	{
		$game['opp_sd'] = array();
		for ($i = 1; $i <= 3; $i++)
		{
			if ($game['ram']["$ois"]["dateline$i"])
			{
				$game['opp_sd'][] = $game['ram']["$ois"]["dateline$i"];
				$show['opponent_suggestions'] = true;
			}
		}
	}
	$templater = vB_Template::create('tmnt_ladder_rearrange');
		$templater->register('tmntp', $tmntp);
		$templater->register('game', $game);
		$templater->register('datehtml', $datehtml);
		$templater->register('datehtml2', $datehtml2);
		$templater->register('datehtml3', $datehtml3);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('show', $show);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id=' . $game['lid'] => $game['ltitle'],
		'' => $vbphrase['ladder_rearrange_md']
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'allchallenges')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$from = 'allchallenges';
	$rowcount = 0;
	$team = false;
	$show['delete'] = true;
	$templater = vB_Template::create('tmnt_ladder_all_chll_top');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('team', $team);
	$tlhtml .= $templater->render();
	$games = $vbulletin->db->query_read("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.username AS u, user2.username AS u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (games.u = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2
			ON (games.u2 = user2.userid)
		WHERE games.finished = 0
			AND games.accepted != -1
			AND games.pot = 0
		ORDER BY lid
		LIMIT 0, 100
		");
	$chllarray = array();
	$mc_ids_array = array();
	$lastltitle = '';
	while($game = $vbulletin->db->fetch_array($games))
	{
		$game['script'] = 'allchallenges';
		$game['display'] = 'none';
		if ($game['comments'] > 0)
		{
			$mc_ids_array[] = $game['id'];
		}
		$game = process_chal_options($game);
		$game['showltitle'] = false;
		if ($lastltitle != $game['ltitle'])
		{
			$game['showltitle'] = true;
		}
		$lastltitle = $game['ltitle'];
		if ($game['uid'] == $thisuserid)
		{
			$is_u = true;
		}
		else
		{
			$is_u = false;
		}
		if ($game['u2id'] == $thisuserid)
		{
			$is_u2 = true;
		}
		else
		{
			$is_u2 = false;
		}
		$lid = $game['lid'];
		$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
		//$show['flags'] = true;//commented out for time being
		//start match status
		if ($game['accepted'] == 0)
		{
			$game['status'] = $vbphrase[tmnt_awaiting_acceptance];
			if ($is_u2)
			{
				$game['status'] = $game['status'].'. <br /> <a href="ladders.php?do=accept&amp;id='.$game['id'].'&amp;u='.$game['uid'].'">'.$vbphrase[tmnt_accept_now].'</a>! <br /> <a href="ladders.php?do=reject&amp;id='.$game['id'].'">'.$vbphrase[tmnt_reject_now].'</a>!';
			}
			$game['showflags'] = false;
		}
		elseif ($game['agree_u'] == 0 && $game['agree_u2'] == 0)
		{
			if ($is_u OR $is_u2)
			{
				$game['status'] = $vbphrase[tmnt_awaiting_scores] . ' <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now].'</a>!';
			}
			else
			{
				$game['status'] = 'Awaiting scores from both players.';
			}
		}
		elseif ($game['agree_u'] == 0)
		{
			if ($is_u)
			{
				$game['status'] = $vbphrase[tmnt_awaiting_your_score] . '. <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now] . '</a>!';
			}
			else
			{
				$game['status'] = $vbphrase[tmnt_awaiting_opponents_score];
			}
		}
		elseif ($game['agree_u2'] == 0)
		{
			if ($is_u2)
			{
				$game['status'] = $vbphrase[tmnt_awaiting_your_score] . '. <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now] . '</a>!';
			}
			else
			{
				$game['status'] = $vbphrase[tmnt_awaiting_opponents_score];
			}
		}
		//end match status
		$rowno++;
		if ($game['comments'] > 0)
		{
			$mc_ids_array[] = $game['id'];
		}
		$chllarray["$game[id]"] = $game;
	}
	if (!empty($mc_ids_array))
	{
		$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
	}
	$templater = vB_Template::create('tmnt_ladder_chll');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('show', $show);
		$templater->register('from', $from);
		$templater->register('chllarray', $chllarray);
	$tlhtml .= $templater->render();
	$team = true;
	$templater = vB_Template::create('tmnt_ladder_chll_bot');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('team', $team);
	$tlhtml .= $templater->render();
	$tlhtml .= "<br />";
	$userid = $thisuserid;
		$rowcount = 0;
		$team = true;
		$templater = vB_Template::create('tmnt_ladder_all_chll_top');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('team', $team);
		$tlhtml .= $templater->render();
		$games = $vbulletin->db->query_read("
			SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.teamname AS u, user2.teamname AS u2
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
				ON (games.lid = ladders.id)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user
				ON (games.u = user.teamid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user2
				ON (games.u2 = user2.teamid)
			WHERE games.finished = 0
				AND games.accepted != -1
				AND games.pot = 1
			LIMIT 0, 100
		");
		$lastltitle = '';
		$chllarray = array();
		$mc_ids_array = array();
		while($game = $vbulletin->db->fetch_array($games))
		{
			$game['script'] = 'allchallenges';
			$game['display'] = 'none';
			$game = process_chal_options($game);
			$lid = $game['lid']; 
			$game['showltitle'] = false;
			if ($lastltitle != $game['ltitle'])
			{
				$game['showltitle'] = true;
			}
			$lastltitle = $game['ltitle'];
			$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
			$is_u = false;
			$is_u2 = false;
			//start match status
			if ($game['accepted'] == 0)
			{
				$game['status'] = $vbphrase[tmnt_awaiting_acceptance];
				if ($is_u2)
				{
					$game['status'] = $game['status'].'. <br /> <a href="ladders.php?do=teamaccept&amp;id='.$game['id'].'">'.$vbphrase[tmnt_accept_now].'</a>! <br /> <a href="ladders.php?do=teamreject&amp;id='.$game['id'].'">'.$vbphrase[tmnt_reject_now].'</a>!';
				}
			}
			elseif ($game['agree_u'] == 0 && $game['agree_u2'] == 0)
			{
				if ($is_u OR $is_u2)
				{
					$game['status'] = $vbphrase[tmnt_awaiting_scores] . ' <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now].'</a>!';
				}
				else
				{
					$game['status'] = 'Awaiting scores from both teams.';
				}
			}
			elseif ($game['agree_u'] == 0)
			{
				if ($is_u)
				{
					$game['status'] = $vbphrase[tmnt_awaiting_your_score] . '. <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now] . '</a>!';
				}
				else
				{
					$game['status'] = $vbphrase[tmnt_awaiting_opponents_score];
				}
			}
			elseif ($game['agree_u2'] == 0)
			{
				if ($is_u2)
				{
					$game['status'] = $vbphrase[tmnt_awaiting_your_score] . '. <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now] . '</a>!';
				}
				else
				{
					$game['status'] = $vbphrase[tmnt_awaiting_opponents_score];
				}
			}
			//end match status
			$rowno++;
			if ($game['comments'] > 0)
			{
				$mc_ids_array[] = $game['id'];
			}
			$chllarray["$game[id]"] = $game;
		}
		if (!empty($mc_ids_array))
		{
			$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
		}
		$templater = vB_Template::create('tmnt_ladder_chll');
			$templater->register('tmntp', $tmntp);
			$templater->register('team', $team);
			$templater->register('from', $from);
			$templater->register('chllarray', $chllarray);
		$tlhtml .= $templater->render();
		$templater = vB_Template::create('tmnt_ladder_chll_bot');
			$templater->register('tmntp', $tmntp);
			$templater->register('rowno', $rowno);
			$templater->register('team', $team);
		$tlhtml .= $templater->render();
	
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => construct_phrase($vbphrase['ladder_all_chlls'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'reportedmatches')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$rowcount = 0;
	$rowno = 0;
	$mc_ids_array = array();
	$chllarray = array();
	$games = $vbulletin->db->query_read("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS laddertitle, user.username AS u, user2.username AS u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (games.u = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2
			ON (games.u2 = user2.userid)
		WHERE games.finished = 0
			AND games.accepted = 1
			AND games.pot = 0
			AND games.flag != 0
		");
	while($game = $vbulletin->db->fetch_array($games))
	{
		//query comments dispute == 1
		$lid = $game['lid'];
		if ($game['flag'] == $game['uid'])
		{
			$game['flag'] = $game['u'];
		}
		elseif ($game['flag'] == $game['u2id'])
		{
			$game['flag'] = $game['u2'];
		}
		$game['display'] = 'none';
		$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
		$rowno++ ;
		if ($game['comments'] > 0)
		{
			$mc_ids_array[] = $game['id'];
		}
		$chllarray["$game[id]"] = $game;
	}
	$games = $vbulletin->db->query_read("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS laddertitle, t.teamname AS u, t2.teamname AS u2, f.username AS flag
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
			ON (games.u = t.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t2
			ON (games.u2 = t2.teamid)
		LEFT JOIN " . TABLE_PREFIX . "user AS f
			ON (games.flag = f.userid)
		WHERE games.finished = 0
			AND games.accepted = 1
			AND games.pot = 1
			AND games.flag != 0
		");
	while($game = $vbulletin->db->fetch_array($games))
	{
		$lid = $game['lid'];
		$game['display'] = 'none';
		$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
		$rowno++ ;
		if ($game['comments'] > 0)
		{
			$mc_ids_array[] = $game['id'];
		}
		$chllarray["$game[id]"] = $game;
	}
	if (!empty($mc_ids_array))
	{
		$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
	}
	$templater = vB_Template::create('tmnt_ladder_repmatch');
		$templater->register('tmntp', $tmntp);
		$templater->register('lid', $lid);
		$templater->register('rowno', $rowno);
		$templater->register('chllarray', $chllarray);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => construct_phrase($vbphrase['ladder_reported_matches'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'acceptmf')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase['error_invalid_challenge'];
		eval(standard_error($errormessage));
	}
	$u2 = $thisuserid;
	//query match info
	$match = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladder_games 
		WHERE id = $id AND u2 = 0 AND accepted = 0 AND finished = 0
	");
	if (!$match)
	{
		$errormessage = $vbphrase['error_invalid_match'];
		eval(standard_error($errormessage));
	}
	$lid = $match['lid'];
	$u = $match['u'];
	if ($match['pot'])
	{
		$u2 = $vbulletin->input->clean_gpc('g', 'u2', TYPE_UINT);
		//check thisuserid is leader of u2
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_members WHERE (teamid = '$u2' AND leader = '1' AND userid = '$thisuserid') ");
		if ($countplayer['countrows'] != 1)
		{
			$errormessage = $vbphrase['error_not_leader'];
			eval(standard_error($errormessage));
		}
		$sh = 2;
	}
	else
	{
		$sh = 3;
	}
	if ($match['u'] == $u2)
	{
		$errormessage = "You cannot accept your own games in the match finder.";
		eval(standard_error($errormessage));
	}
	if ($match['dateline'] < TIMENOW)
	{
		$errormessage = $vbphrase['error_match_inpast'];
		eval(standard_error($errormessage));
	}
	//check accepting player in ladder
	$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = ".$lid." AND userid = $u2 AND active = 1");
	$countplayer = $countplayer['countrows'];  
	if ($countplayer != 1)
	{
		$errormessage = $vbphrase['error_player_not_ladder'];
		eval(standard_error($errormessage));
	}
	$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND finished=0 ");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer >= $vbulletin->options['tmnt_ladder_maxc'] && $u2 > 0)
		{
			$errormessage = $vbphrase['error_already_challenged'];
			eval(standard_error($errormessage));
		}
	$time_limit = TIMENOW - ($vbulletin->options['tmnt_ladder_limitrematch'] * 60 * 60);
	$countlimit = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND dateline_finished > '" . $time_limit . "' ");
	if ($countlimit['countrows'])
	{
		$days = floor($vbulletin->options['tmnt_ladder_limitrematch']/24);
		$hours = $vbulletin->options['tmnt_ladder_limitrematch'] - $days * 24;
		$errormessage = "Please wait " . ($days ? "$days days " : "") . ($hours ? "$hours hours " : "") . "between challenging the same player/team.";
		eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
		SET accepted = '1', u2 = '$u2'
		WHERE id='$id' AND accepted = '0' AND finished = '0' AND pot = '".$match['pot']."'
	");
	$u = $match['u'];
	if ($u && !$match['pot'])
	{
		$uinfo = fetch_userinfo($u);
		if ($uinfo)
		{
			if (!is_array($uinfo['tmnt_notifications']) && $uinfo['tmnt_notifications'])
			{
				$uinfo['tmnt_notifications'] = unserialize($uinfo['tmnt_notifications']);
			}
			else if (!$uinfo['tmnt_notifications'])
			{
				$uinfo['tmnt_notifications'] = array();
			}
			$uinfo['tmnt_notifications']['ladder_accepts']++;
			$uinfo['tmnt_notifications'] = serialize($uinfo['tmnt_notifications']);
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($uinfo['tmnt_notifications'])."' WHERE userid = '".$uinfo['userid']."'");
			require_once('./includes/functions_databuild.php');
			$fromuserid = $thisuserid;
			$fromusername = $thisusername;
			$title = "Someone has accepted your challenge from the match finder";
			$recipients = $uinfo['username'];
			$templater = vB_Template::create('tmnt_ladder_mfpm');
			$templater->register('tmntp', $tmntp);
			$templater->register('match', $match);
			$templater->register('title', $title);
			$templater->register('fromusername', $fromusername);
			$templater->register('fromuserid', $fromuserid);
			$message = $templater->render();
			$message = preg_replace('/<!--(.|\s)*?-->/', '', $message);
				$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
				$pmdm->set('fromuserid', $fromuserid);
				$pmdm->set('fromusername', $fromusername);
				$pmdm->set('title', $title);
				$pmdm->set('message', $message);
				$pmdm->set_recipients($recipients, $botpermissions);
				$pmdm->set('dateline', TIMENOW); 
				$pmdm->overridequota = true;
				$errors = $pmdm->errors;
				if ($errors)
				{
					foreach ($errors as $error) {
						$errorss .= $error. "<br />";
					}
					$errormessage = $vbphrase[error_success_chal_error_pm].$errorss;
					eval(standard_error($errormessage));
				}
				$pmdm->save();
				unset($pmdm);
		}
	}
	$vbulletin->url = "ladders.php?do=view&id=".$lid."&sh=$sh#match".$match['id'];
	eval(print_standard_redirect('redirect_acceptchal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'accept')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id) {
			$errormessage = $vbphrase[error_invalid_challenge];
			eval(standard_error($errormessage));
		}
	$u2 = $thisuserid;
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET accepted = '1' WHERE id='$id' AND u2='$u2' AND accepted = '0' AND finished = '0' AND pot = '0'");
	$u = $vbulletin->input->clean_gpc('g', 'u', TYPE_UINT);
	if ($u)
	{
		$uinfo = fetch_userinfo($u);
		if ($uinfo)
		{
			if (!is_array($uinfo['tmnt_notifications']) && $uinfo['tmnt_notifications'])
			{
				$uinfo['tmnt_notifications'] = unserialize($uinfo['tmnt_notifications']);
			}
			else if (!$uinfo['tmnt_notifications'])
			{
				$uinfo['tmnt_notifications'] = array();
			}
			$uinfo['tmnt_notifications']['ladder_accepts']++;
			$uinfo['tmnt_notifications'] = serialize($uinfo['tmnt_notifications']);
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($uinfo['tmnt_notifications'])."' WHERE userid = '".$uinfo['userid']."'");
		}
	}
	$vbulletin->url = "ladders.php?do=challenges";
	eval(print_standard_redirect('redirect_acceptchal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'teamaccept')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id) {
			$errormessage = $vbphrase[error_invalid_challenge];
			eval(standard_error($errormessage));
		}
	$userid = $thisuserid;
	$teamids = array();
	$teams = $vbulletin->db->query_read("
		SELECT * FROM " . TABLE_PREFIX . "tmnt_members AS members
		JOIN " . TABLE_PREFIX . "tmnt_teams AS teams
			ON members.teamid = teams.teamid
		WHERE members.leader = '1'
			AND members.userid = '$userid'
	");
	while ($teamm = $vbulletin->db->fetch_array($teams)) 
	{
		$teamid = $teamm['teamid'];
		$teamids = array_merge((array)$teamid, $teamids);
	}
	$teamids = implode(",", $teamids);
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
		SET accepted = '1'
		WHERE id = '$id'
			AND u2 IN ($teamids)
	");
	$vbulletin->url = "ladders.php?do=challenges";
	eval(print_standard_redirect('redirect_acceptchal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'reject')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id) {
			$errormessage = $vbphrase[error_invalid_challenge];
			eval(standard_error($errormessage));
		}
	$u2 = $thisuserid;
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET accepted = -1, finished = 1 WHERE id=$id AND u2=$u2 AND finished = 0 AND accepted = 0");
	$vbulletin->url = "ladders.php?do=challenges";
	eval(print_standard_redirect('redirect_rejectchal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'teamreject')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_challenge];
		eval(standard_error($errormessage));
	}
	$userid = $thisuserid;
	$teamids = array();
	$teams = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_members JOIN " . TABLE_PREFIX . "tmnt_teams on " . TABLE_PREFIX . "tmnt_members.teamid = " . TABLE_PREFIX . "tmnt_teams.teamid WHERE " . TABLE_PREFIX . "tmnt_members.leader=1 AND " . TABLE_PREFIX . "tmnt_members.userid=$userid");
		while($teamm = $vbulletin->db->fetch_array($teams)){
			$teamid = $teamm['teamid'];
			$teamids = array_merge((array)$teamid, $teamids);
	}
	$teamids = implode(",", $teamids);
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET accepted = -1, finished = 1 WHERE id=$id AND agree_u = 0 AND agree_u2 = 0 AND score_u = 0 AND score_u2 = 0 AND u2 IN ($teamids)");
	$vbulletin->url = "ladders.php?do=challenges";
	eval(print_standard_redirect('redirect_rejectchal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'submitscore')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id)
		{
			$errormessage = $vbphrase[error_invalid_challenge];
			eval(standard_error($errormessage));
		}
	$teamids_array = array();
	$userid = $thisuserid;
	$games = $vbulletin->db->query_first("SELECT ladders.pot AS pot FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders ON(games.lid=ladders.id) WHERE games.id=$id");
	if ($games['pot'] == 1)
	{
		$team = true;
		$teamids = array();
		$teams = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_members AS members JOIN " . TABLE_PREFIX . "tmnt_teams AS teams ON(members.teamid = teams.teamid) WHERE members.leader=1 AND members.userid=$userid");
		while($teamm = $vbulletin->db->fetch_array($teams))
		{
			$teamid = $teamm['teamid'];
			$teamids = array_merge((array)$teamid, $teamids);
		}
		$teamids_array = $teamids;
		$teamids = implode(",", $teamids);
	}
	else
	{
		$team = false;
		$teamids_array = array();
	}
	$rowno = 0;
	$game = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE " . (!$team ? "(u=$userid OR u2=$userid)" : "(u IN (".$teamids.") OR u2 IN (".$teamids.") )" ) . " AND id=$id AND finished=0 AND accepted=1");
	
	if ($game['u'] == $thisuserid OR in_array($game['u'], $teamids_array))
	{
		$game['screen'] = $game['screen_u'];
	}
	elseif ($game['u2'] == $thisuserid OR in_array($game['u2'], $teamids_array))
	{
		$game['screen'] = $game['screen_u2'];
	}
	if (!$game['pot'])
	{
		$game['uinfo'] = fetch_userinfo($game['u']);
		$game['u2info'] = fetch_userinfo($game['u2']);
	}
	else 
	{
		$game['uinfo'] = fetch_teaminfo($game['u']);
		$game['u2info'] = fetch_teaminfo($game['u2']);
	}
	$rowno++;
	
	if (!$game)
	{
		print_no_permission();
	}
	$templater = vB_Template::create('tmnt_ladder_submitscore');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('team', $team);
		$templater->register('rowno', $rowno);
		$templater->register('game', $game);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?do=challenges' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladder_chlls'],
		'' => construct_phrase($vbphrase['ladder_submittingscore'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'adminsubmitscore')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$from = $vbulletin->input->clean_gpc('g', 'from', TYPE_NOHTML);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_challenge];
		eval(standard_error($errormessage));
	}
	$games = $vbulletin->db->query_first("
		SELECT ladders.pot AS pot, ladders.title
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders 
			ON(games.lid=ladders.id)
		WHERE games.id = '$id'
	");
	$team = false;
	if ($games['pot'])
	{
		$team = true;
	}
	$userid = $thisuserid;
	$game = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id='$id' AND finished='0' AND accepted='1'");
	if (!$game)
	{
		$errormessage = $vbphrase['error_invalid_challenge'];
		eval(standard_error($errormessage));
	}
	if ($game['pot'])
	{
		$game['uinfo'] = fetch_teaminfo($game['u']);
		$game['u2info'] = fetch_teaminfo($game['u2']);
	}
	else 
	{
		$game['uinfo'] = fetch_userinfo($game['u']);
		$game['u2info'] = fetch_userinfo($game['u2']);
	}
	$templater = vB_Template::create('tmnt_ladder_adminsubmitscore');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('from', $from);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('team', $team);
		$templater->register('games', $games);
		$templater->register('game', $game);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders']
	);
	if ($from == 'ladder')
	{
		$navbits["ladders.php?do=view&amp;id=$game[lid]&amp;sh=2"] = $games['title'];
	}
	else
	{
		$navbits['ladders.php?do=reportedchallenges'] = $vbphrase['ladder_reported_matches'];
	}
	$navbits[''] = construct_phrase($vbphrase['ladder_submittingscore']);
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'killmatch')
{
	if (!$tmntp['ladder_superuser'])
	{
		print_no_permission();
	}
	$mid = $vbulletin->input->clean_gpc('g', 'mid', TYPE_UINT);
	if (!$mid)
	{
		$errormessage = $vbphrase['error_invalid_match'];
        eval(standard_error($errormessage));
	}
	$matchinfo = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id = '$mid'");
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '".$matchinfo['lid']."' ");
	if ($matchinfo['finished'])
	{
		if ($matchinfo['score_u'] > $matchinfo['score_u2'])
		{//u won
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET wins = wins - 1, totalpoints = totalpoints - ".$matchinfo['score_u'].", pointsagainst = pointsagainst - ".$matchinfo['score_u2'].", xp = xp - ".$ladder['xp_win']." WHERE id = '$mid' AND userid = '".$matchinfo['u']."'");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET loses = loses - 1, totalpoints = totalpoints - ".$matchinfo['score_u2'].", pointsagainst = pointsagainst - ".$matchinfo['score_u'].", xp = xp - ".$ladder['xp_lose']." WHERE id = '$mid' AND userid = '".$matchinfo['u2']."'");
		}
		elseif ($matchinfo['score_u'] < $matchinfo['score_u2'])
		{//u2 won
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET loses = loses - 1, totalpoints = totalpoints - ".$matchinfo['score_u'].", pointsagainst = pointsagainst - ".$matchinfo['score_u2'].", xp = xp - ".$ladder['xp_lose']." WHERE id = '$mid' AND userid = '".$matchinfo['u']."' ");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET wins = wins - 1, totalpoints = totalpoints - ".$matchinfo['score_u2'].", pointsagainst = pointsagainst - ".$matchinfo['score_u'].", xp = xp - ".$ladder['xp_win']." WHERE id = '$mid' AND userid = '".$matchinfo['u2']."' ");
		}
		else
		{//draw
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET draws = draws - 1, totalpoints = totalpoints - ".$matchinfo['score_u'].", pointsagainst = pointsagainst - ".$matchinfo['score_u2'].", xp = xp - ".$ladder['xp_draw']." WHERE id = '$mid' AND userid = '".$matchinfo['u']."'");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET draws = draws - 1, totalpoints = totalpoints - ".$matchinfo['score_u2'].", pointsagainst = pointsagainst - ".$matchinfo['score_u'].", xp = xp - ".$ladder['xp_draw']." WHERE id = '$mid' AND userid = '".$matchinfo['u2']."'");
		}
	}
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_mcs WHERE mid=$mid");
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id=$mid");
	$from = $vbulletin->input->clean_gpc('g', 'from', TYPE_STR);
	if (!$sh)
	{
		$sh = 1;
	}
	$vbulletin->url = "ladders.php?do=view&id=".$matchinfo['lid']."&sh=$sh";
	eval(print_standard_redirect('redirect_killmatch'));
}

// #############################################################################

if ($_REQUEST['do'] == 'killmc')
{
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase['error_invalid_comment'];
        eval(standard_error($errormessage));
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$mid = $vbulletin->input->clean_gpc('g', 'mid', TYPE_UINT);
	if (!$mid)
	{
		$errormessage = $vbphrase['error_invalid_match'];
        eval(standard_error($errormessage));
	}
	$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_UINT);
	$from = $vbulletin->input->clean_gpc('g', 'from', TYPE_NOHTML);
	if ($tmntp['candelmcomments'])
	{
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_mcs WHERE id=$id");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET comments = comments - 1 WHERE id=$mid");
	}
	else
	{
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_mcs WHERE id=$id AND userid=$thisuserid");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET comments = comments - 1 WHERE id = $mid");
	}
	if ($from)
	{
		$vbulletin->url = "ladders.php?do=".$from."&mid=$mid#match$mid";
	}
	else
	{
		$vbulletin->url = "ladders.php?do=view&id=$lid&sh=$sh&mid=$mid#match$mid";
	}
	eval(print_standard_redirect('redirect_killcomment'));
}

// #############################################################################

if ($_POST['do'] == 'insertmc')
{
	if (!$tmntp['canmcomment'])
	{
		print_no_permission();
	}
	if ($vbulletin->userinfo['userid'] == 0)
	{
		print_no_permission();
	}
	$mid = $vbulletin->input->clean_gpc('p', 'mid', TYPE_UINT);
	$dispute = $vbulletin->input->clean_gpc('p', 'dispute', TYPE_BOOL);
		if (!$mid)
		{
			$errormessage = $vbphrase['error_invalid_match'];
        	eval(standard_error($errormessage));
		}
	$lid = $vbulletin->input->clean_gpc('p', 'lid', TYPE_UINT);
		if (!$lid)
		{
			$errormessage = $vbphrase['error_invalid_ladder'];
        	eval(standard_error($errormessage));
		}
	$sh = $vbulletin->input->clean_gpc('p', 'sh', TYPE_UINT);
	$from = $vbulletin->input->clean_gpc('p', 'from', TYPE_NOHTML);
	$userid = $thisuserid;
	$username = $thisusername;
	$comment = $vbulletin->input->clean_gpc('p', 'comment', TYPE_NOHTML);
	if (!$comment)
	{
		$errormessage = $vbphrase['error_invalid_message'];
		eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_mcs
		(mid, comment, userid, username, dateline, dispute)
		VALUES ('".$mid."', '".$vbulletin->db->escape_string($comment)."', '".$userid."',  '".$vbulletin->db->escape_string($username)."', ".TIMENOW.",  '".$vbulletin->db->escape_string($dispute)."' )
		");
	$id = $vbulletin->db->insert_id();
	if ($dispute)
	{
		$vbulletin->url = "ladders.php?do=reportedmatches&mid=$mid#match$mid";
	}
	elseif ($from)
	{
		$vbulletin->url = "ladders.php?do=".$from."&mid=$mid#match$mid";
	}
	elseif ($sh)
	{
		$vbulletin->url = "ladders.php?do=view&id=$lid&sh=$sh&mid=$mid#match$mid";
	}
	else
	{
		$vbulletin->url = "ladders.php?do=view&id=$lid&sh=1&mid=$mid#match$mid";
	}
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET comments = comments + 1 WHERE id = $mid");
	eval(print_standard_redirect('redirect_tmntcomment'));
}

// #############################################################################

if ($_POST['do'] == 'insertscore')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'u'             => TYPE_UINT,
		'u2'            => TYPE_UINT,
		'lid'           => TYPE_UINT,
		'id'            => TYPE_UINT,
		'orig_score_u'  => TYPE_UINT,
		'orig_score_u2' => TYPE_UINT,
		'score_u'       => TYPE_UINT,
		'score_u2'      => TYPE_UINT,
		'agree_u'       => TYPE_UINT,
		'agree_u2'      => TYPE_UINT,
		'pot'           => TYPE_UINT,
		'screen'        => TYPE_NOHTML
	));
	$id            = $vbulletin->GPC['id'];
	$u             = $vbulletin->GPC['u'];
	$u2            = $vbulletin->GPC['u2'];
	$agree_u       = $vbulletin->GPC['agree_u'];
	$agree_u2      = $vbulletin->GPC['agree_u2'];
	$userid        = $thisuserid;
	$score_u       = $vbulletin->GPC['score_u'];
	$score_u2      = $vbulletin->GPC['score_u2'];
	$origscore_u   = $vbulletin->GPC['orig_score_u'];
	$origscore_u2  = $vbulletin->GPC['orig_score_u2'];
	$lid           = $vbulletin->GPC['lid'];
	$pot           = $vbulletin->GPC['pot'];
	$screen        = $vbulletin->GPC['screen'];
	$games = $vbulletin->db->query_first("
		SELECT ladders.pot, ladders.xp_win, ladders.xp_draw, ladders.xp_lose
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON(games.lid=ladders.id)
		WHERE games.id = '$id'
	");
	if ($games['pot'])
	{
		$team = true;
		$teamids = array();
		$teams = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_members JOIN " . TABLE_PREFIX . "tmnt_teams on " . TABLE_PREFIX . "tmnt_members.teamid = " . TABLE_PREFIX . "tmnt_teams.teamid WHERE " . TABLE_PREFIX . "tmnt_members.leader=1 AND " . TABLE_PREFIX . "tmnt_members.userid=$userid");
		while($teamm = $vbulletin->db->fetch_array($teams))
		{
			$teamid = $teamm['teamid'];
			$teamids = array_merge((array)$teamid, $teamids);
		}
		$eteamids = $teamids;
		$teamids = implode(",", $teamids);
		if (!in_array($u, $eteamids) AND !in_array($u2, $eteamids))
		{
			print_no_permission();
		}
		if ($origscore_u == $score_u AND $origscore_u2 == $score_u2)
		{
			if (in_array($u, $eteamids))
			{
				if ($agree_u2 == 1) {
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, finished = 1, screen_u = '".$vbulletin->db->escape_string($screen)."' WHERE id=$id ");
					$finished = true;
				} elseif ($agree_u2 == 0) {
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, screen_u = '".$vbulletin->db->escape_string($screen)."' WHERE id=$id ");
					$finished = false;
				}
			} 
			if (in_array($u2, $eteamids) AND !$finished)
			{
				if ($agree_u == 1) {
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u2 = 1, finished = 1, screen_u2 = '".$vbulletin->db->escape_string($screen)."' WHERE id=$id ");
					$finished = true;
				} elseif ($agree_u == 0) {
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u2 = 1, screen_u2 = '".$vbulletin->db->escape_string($screen)."' WHERE id=$id ");
					$finished = false;
				}
			}
		}
		elseif ($origscore_u != $score_u OR $origscore_u2 != $score_u2)
		{
			if (in_array($u, $eteamids)) {
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, agree_u2 = 0, score_u = $score_u, score_u2 = $score_u2, screen_u2 = '".$vbulletin->db->escape_string($screen)."' WHERE id=$id ");
					$finished = false;
			} 
			if (in_array($u2, $eteamids)) {
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 0, agree_u2 = 1, score_u = $score_u, score_u2 = $score_u2, screen_u2 = '".$vbulletin->db->escape_string($screen)."' WHERE id=$id ");
					$finished = false;
			}
		}
	}
	else 
	{
		$team = false;
		if ($userid != $u AND $userid != $u2)
		{
			print_no_permission();
		}
		if ($origscore_u == $score_u AND $origscore_u2 == $score_u2) {
			if ($userid == $u)
			{
				if ($agree_u2 == 1)
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, finished = 1, screen_u = '".$vbulletin->db->escape_string($screen)."', dateline_finished = ".TIMENOW." WHERE id=$id ");
					$finished = true;
				}
				elseif ($agree_u2 == 0)
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, screen_u = '".$vbulletin->db->escape_string($screen)."' WHERE id=$id ");
					$finished = false;
				}
			} 
			elseif ($userid == $u2) 
			{
				if ($agree_u == 1)
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u2 = 1, finished = 1, screen_u2 = '".$vbulletin->db->escape_string($screen)."', dateline_finished = ".TIMENOW." WHERE id=$id ");
					$finished = true;
				}
				elseif ($agree_u == 0)
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u2 = 1, screen_u2 = '".$vbulletin->db->escape_string($screen)."' WHERE id=$id ");
					$finished = false;
				}
			}
		}
		elseif ($origscore_u != $score_u OR $origscore_u2 != $score_u2)
		{
			if ($userid == $u) 
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, agree_u2 = 0, score_u = $score_u, score_u2 = $score_u2, screen_u2 = '".$vbulletin->db->escape_string($screen)."' WHERE id=$id ");
				$finished = false;
			} 
			elseif ($userid == $u2) 
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 0, agree_u2 = 1, score_u = $score_u, score_u2 = $score_u2, screen_u2 = '".$vbulletin->db->escape_string($screen)."' WHERE id=$id ");
				$finished = false;
		}
		}
	}
	$comment = $vbulletin->input->clean_gpc('p', 'comment', TYPE_NOHTML);
	if ($comment)
	{
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_mcs
				(mid, comment, userid, username, dateline, dispute)
			VALUES ('".$id."', '".$vbulletin->db->escape_string($comment)."', '".$thisuserid."',  '".$vbulletin->db->escape_string($thisusername)."', ".TIMENOW.",  '0')
		");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET comments = comments + 1 WHERE id = $id");
	}
	if ($finished)
	{
		list($newrank_u, $newrank_u2, $uod_u, $uod_u2, $player_u, $player_u2) = calc_elo($rank_u, $rank_u2, $score_u, $score_u2, $player_u, $player_u2, $lid, $u, $u2);
		if ($score_u > $score_u2)
		{
			$player_u['wstreak']++;
			if ($player_u['wstreak'] >= $player_u['longeststreak']) $player_u['longeststreak'] = $player_u['wstreak'];
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET wins = wins + 1, wstreak = wstreak + 1, lstreak = 0, latime =".TIMENOW.", rank = '$newrank_u', uod = '$uod_u', totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, longeststreak = '$player_u[longeststreak]', xp = xp + " . $games['xp_win'] . "
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET loses = loses + 1, wstreak = 0, lstreak = lstreak + 1, latime =".TIMENOW.", rank = $newrank_u2, uod = $uod_u2, totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, xp = xp + " . $games['xp_lose'] . "
				WHERE lid = $lid AND userid = $u2
			");
		}
		elseif ($score_u == $score_u2)
		{
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET draws = draws + 1, wstreak = 0, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, longeststreak = '$player_u[longeststreak]', xp = xp + " . $games['xp_draw'] . "
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET draws = draws + 1, wstreak = 0, lstreak = 0, latime =".TIMENOW.", rank = '$newrank_u2', uod = '$uod_u2', totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, xp = xp + " . $games['xp_draw'] . "
				WHERE lid = $lid AND userid = $u2
			");
		} 
		elseif ($score_u < $score_u2) 
		{
			$player_u2['wstreak']++;
			if ($player_u2['wstreak'] >= $player_u2['longeststreak']) $player_u2['longeststreak'] = $player_u2['wstreak'];
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET loses = loses + 1, wstreak = 0, lstreak = lstreak + 1, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, xp = xp + " . $games['xp_lose'] . "
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET wins = wins + 1, wstreak = wstreak + 1, lstreak = 0, latime =".TIMENOW.", rank = '$newrank_u2', uod = '$uod_u2', totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, longeststreak = '$player_u2[longeststreak]', xp = xp + " . $games['xp_win'] . "
				WHERE lid = $lid AND userid = $u2
			");
		}
		else
		{
			$errormessage = $vbphrase['error_fatal_error']." error id: 3928";
			eval(standard_error($errormessage));
		}
	}
	$vbulletin->url = "ladders.php?do=challenges&mid=$id#match$id";
	eval(print_standard_redirect('redirect_updatedscore'));
}

// #############################################################################

if ($_REQUEST['do'] == 'admindeletematch')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('g', array(
		'id' => TYPE_UINT,
		'lid' => TYPE_UINT,
		'sh' => TYPE_UINT,
		'from' => TYPE_NOHTML
	));
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id = '" . $vbulletin->GPC['id'] . "'");
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_mcs WHERE mid = '" . $vbulletin->GPC['id'] . "'");
	if ($vbulletin->GPC['from'] == 'ladder')
	{
		$vbulletin->url = "ladders.php?do=view&id=" . $vbulletin->GPC['lid'] . "&sh=" . $vbulletin->GPC['sh'];
	}
	else
	{
		$vbulletin->url = "ladders.php?do=reportedmatches";
	}
	eval(print_standard_redirect('redirect_deletedmatch'));
}

// #############################################################################

if ($_POST['do'] == 'admininsertscore')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'u'             => TYPE_UINT,
		'u2'            => TYPE_UINT,
		'lid'           => TYPE_UINT,
		'id'            => TYPE_UINT,
		'orig_score_u'  => TYPE_UINT,
		'orig_score_u2' => TYPE_UINT,
		'score_u'       => TYPE_UINT,
		'score_u2'      => TYPE_UINT,
		'agree_u'       => TYPE_UINT,
		'agree_u2'      => TYPE_UINT,
		'from'          => TYPE_NOHTML
	));
	$id            = $vbulletin->GPC['id'];
	$u             = $vbulletin->GPC['u'];
	$u2            = $vbulletin->GPC['u2'];
	$userid        = $thisuserid;
	$score_u       = $vbulletin->GPC['score_u'];
	$score_u2      = $vbulletin->GPC['score_u2'];
	$lid           = $vbulletin->GPC['lid'];
	$countgames = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id=$id AND finished=0 AND accepted=1");
	if ($countgames['countrows'] != 1) 
	{
		print_no_permission();
	}
	$games = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = $lid");
	list($newrank_u, $newrank_u2, $uod_u, $uod_u2, $player_u, $player_u2) = calc_elo($rank_u, $rank_u2, $score_u, $score_u2, $player_u, $player_u2, $lid, $u, $u2);
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, agree_u2 = 1, score_u = $score_u, score_u2 = $score_u2, finished = 1, dateline_finished = ".TIMENOW." WHERE id=$id ");
		if ($score_u > $score_u2) 
		{
			$player_u['wstreak']++;
			if ($player_u['wstreak'] >= $player_u['longeststreak']) $player_u['longeststreak'] = $player_u['wstreak'];
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET wins = wins + 1, wstreak = wstreak + 1, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, longeststreak = $player_u[longeststreak], xp = xp + " . $games['xp_win'] . "
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET loses = loses + 1, wstreak = 0, lstreak = lstreak + 1, latime =".TIMENOW.", rank = $newrank_u2, uod = $uod_u2, totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, xp = xp + " . $games['xp_lose'] . "
				WHERE lid = $lid AND userid = $u2
			");
		} elseif ($score_u == $score_u2) {
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET draws = draws + 1, wstreak = 0, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, longeststreak = $player_u[longeststreak], xp = xp + " . $games['xp_draw'] . "
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET draws = draws + 1, wstreak = 0, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u2, uod = $uod_u2, totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, xp = xp + " . $games['xp_draw'] . "
				WHERE lid = $lid AND userid = $u2
			");
		} elseif ($score_u < $score_u2) {
			$player_u2['wstreak']++;
			if ($player_u2['wstreak'] >= $player_u2['longeststreak']) $player_u2['longeststreak'] = $player_u2['wstreak'];
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET loses = loses + 1, wstreak = 0, lstreak = lstreak + 1, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, xp = xp + " . $games['xp_lose'] . "
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET wins = wins + 1, wstreak = wstreak + 1, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u2, uod = $uod_u2, totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, longeststreak = $player_u2[longeststreak], xp = xp + " . $games['xp_win'] . "
				WHERE lid = $lid AND userid = $u2
			");
		} else {
			$errormessage = $vbphrase[error_fatal_error];
			eval(standard_error($errormessage));
		}
	if ($vbulletin->GPC['from'] == 'ladder')
	{
		$vbulletin->url = "ladders.php?do=view&id=$lid&sh=2";
	}
	else
	{
		$vbulletin->url = "ladders.php?do=reportedmatches";
	}
	eval(print_standard_redirect('redirect_updatedscore'));
}

// #############################################################################

if ($_REQUEST['do'] == 'elorating') 
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	$rank_u = $vbulletin->input->clean_gpc('g', 'rank_u', TYPE_UINT);
	$rank_u2 = $vbulletin->input->clean_gpc('g', 'rank_u2', TYPE_UINT);
	if ($rank_u == 0 && $rank_u2 == 0)
	{
		$rank_u = $rank_u2 = 1000;
	}
	$score_u = $vbulletin->input->clean_gpc('g', 'score_u', TYPE_UINT);
	$score_u2 = $vbulletin->input->clean_gpc('g', 'score_u2', TYPE_UINT);
	list($newrank_u, $newrank_u2, $uod_u, $uod_u2, $player_u, $player_u2) = calc_elo($rank_u, $rank_u2, $score_u, $score_u2, 1, 1, 0, 0, 0);
	$e = array();
	$e['e_u'] = $newrank_u - $rank_u;
	if ($e['e_u']<0)
	{
		$e['e_u'] = "<span style=\"color: #FF0000; font-weight: bold;\">" . $e['e_u'] . "</span>";
	}
	else
	{
		$e['e_u'] = "<span style=\"color:  #00611C; font-weight: bold;\">+" . $e['e_u'] . "</span>";
	}
	$e['e_u2'] = $newrank_u2 - $rank_u2;
	if ($e['e_u2']<0)
	{
		$e['e_u2'] = "<span style=\"color: #FF0000; font-weight: bold;\">" . $e['e_u2'] . "</span>";
	}
	else
	{
		$e['e_u2'] = "<span style=\"color:  #00611C; font-weight: bold;\">+" . $e['e_u2'] . "</span>";
	}
	$templater = vB_Template::create('tmnt_ladder_elorating');
		$templater->register('tmntp', $tmntp);
		$templater->register('score_u', $score_u);
		$templater->register('score_u2', $score_u2);
		$templater->register('rank_u', $rank_u);
		$templater->register('rank_u2', $rank_u2);
		$templater->register('newrank_u', $newrank_u);
		$templater->register('newrank_u2', $newrank_u2);
		$templater->register('e', $e);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => construct_phrase($vbphrase['ladder_elorating_calc'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'edit')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$ladders = $ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id'");
	if (!$ladder)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$title = $ladder['title'];
	$description = $ladder['description'];
	if ($ladder['pot'])
	{
		$team = true;
	} 
	else 
	{
		$team = false;
	}
	if ($ladder['league'])
	{
		$vbphrase['ladder_title'] = $vbphrase['league_title'];
		$vbphrase['ladder_date'] = $vbphrase['league_date'];
		$vbphrase['ladder_editing'] = $vbphrase['league_editing'];
	}
	$co_array = unserialize($ladder['chal_options']);
	$co_array[''] = ''; // blank row
	$sticky   = $ladder['sticky'];
	$archive  = $ladder['archive'];
	$catid    = $ladder['catid'];
	if (!$ladder['startingelo'])
	{
		$ladder['startingelo'] = 1000;
	}
	$categories = '<select name="catid" id="catid"><option value="0"></option>';
	/*$cats = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_categories
		WHERE tol IN (2,3)
		ORDER BY parentid DESC, displayorder ASC, title ASC
	");
	$carray = array();
	while($cat = $vbulletin->db->fetch_array($cats))
	{*/
	if ($vbulletin->tll_catcache)
	{
		foreach ($vbulletin->tll_catcache AS $cindex => $cat)
		{
			if ($cat['tol'] == 1)
			{
				continue;
			}
			if ($cat['parentid'])
			{
				$carray["$cat[parentid]"] .= '<option value="'.$cat['catid'].'"';
				if ($catid == $cat['catid'])
				{
					$carray["$cat[parentid]"] .= ' selected="selected" ';
				}
				$carray["$cat[parentid]"] .= '> - '.$cat['title'].'</option>';
			}
			else 
			{
				$categories .= '<option value="'.$cat['catid'].'"';
				if ($catid == $cat['catid'])
				{
					$categories .= ' selected="selected" ';
				}
				$categories .= '>'.$cat['title'].'</option>';
				$categories .= $carray["$cat[catid]"];
			}
		}
	}
	$categories .= '</select>';
	$squery = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladders
		WHERE groupid != 0
		ORDER BY groupid ASC
	");
	$seasons = array();
	$lastseason = array();
	while($season = $vbulletin->db->fetch_array($squery))
	{
		if ($season['groupid'] != $lastseason['groupid'])
		{
			$season['optgroup'] = true;
			$season['optgroupid'] = ++$optgroup;
		}
		if ($season['groupid'] == $ladder['groupid'] && !$selectedseason)
		{
			$selectedseason = true;
			$season['selected'] = ' selected="selected"';
		}
		$season['lastseason'] = $lastseason['groupid'];
		$seasons[] = $season;
		$lastseason = $season;
	}
	$season = array(
		'optgroupid' => ($optgroup+1),
		'optgroup' => true,
		'title' => $vbphrase['ladder_new_seasons_group'],
		'groupid' => ($lastseason['groupid']+1)
	);
	$seasons[] = $season;
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar($description, 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar($description);
	}
	if (!$ladder['dateline_from'])
	{
		$ladder['dateline_from'] = $ladder['cr_time'];
	}
	if (!$ladder['dateline_to'])
	{
		$ladder['dateline_to'] = TIMENOW + 2592000;
	}
	list ($timezoneoptions, $from_day, $from_monthselected, $from_yearbits, $user_from_time, $dstchecked, $show) = tmnt_dateline_to_fields($ladder['dateline_from'], $ladder['utc'], $ladder['dst'], $show);
	list ($timezoneoptions, $to_day, $to_monthselected, $to_yearbits, $user_to_time, $dstchecked, $show) = tmnt_dateline_to_fields($ladder['dateline_to'], $ladder['utc'], $ladder['dst'], $show);
	$templater = vB_Template::create('tmnt_date_time');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('time', $user_from_time);
		$templater->register('day', $from_day);
		$templater->register('monthselected', $from_monthselected);
		$templater->register('yearbits', $from_yearbits);
		$templater->register('rangeid', 0);
		$templater->register('prefix', 'from');
	$ladder['startdatehtml'] = $templater->render();
	$templater = vB_Template::create('tmnt_date_time');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('time', $user_to_time);
		$templater->register('day', $to_day);
		$templater->register('monthselected', $to_monthselected);
		$templater->register('yearbits', $to_yearbits);
		$templater->register('rangeid', 1);
		$templater->register('prefix', 'to');
	$ladder['enddatehtml'] = $templater->render();
	
	if ($ladder['league'])
	{
		//work out round datelines
		$lrquery = $vbulletin->db->query_read("
			SELECT round, dateline
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
			WHERE g.lid = '$ladder[id]'
			GROUP BY g.round
			ORDER BY round ASC
		");
		$qqq = array();//round=>dateline
		while($qq = $vbulletin->db->fetch_array($lrquery))
		{
			$qqq[$qq[round]] = $qq['dateline'];
		}
		$g_i = 1;
		$maxrounds = $vbulletin->db->query_first("
			SELECT g.round
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
			WHERE g.lid = '$ladder[id]'
				AND g.group = '$g_i'
			ORDER BY g.round DESC
		");
		$ladder['rounds'] = $maxrounds['round'];
		//need to get dateline
		$ri = 1;
		while ($ri <= $ladder['rounds'])
		{
			$s = $ri+1;
			$s_dateline = $qqq["$ri"];
			if (!$s_dateline)
			{
				$s_dateline = TIMENOW + $ri * 86400;
			}
			list ($timezoneoptions, $s_day, $s_monthselected, $s_yearbits, $user_s_time, $dstchecked, $show) = tmnt_dateline_to_fields($s_dateline, $ladder['utc'], $ladder['dst'], $show);
			$templater = vB_Template::create('tmnt_date_time');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('timezoneoptions', $timezoneoptions);
				$templater->register('dstchecked', $dstchecked);
				$templater->register('time', $user_s_time);
				$templater->register('day', $s_day);
				$templater->register('monthselected', $s_monthselected);
				$templater->register('yearbits', $s_yearbits);
				$templater->register('rangeid', $s);
				$templater->register('prefix', "round$ri");
			$rhtml = $templater->render();
			$ladder['league_rounds'] .= "<div style=\"clear: both; " . ($ri > 1 ? "border: inherit; " : "") . "padding: inherit;\"><label for=\"range_mm$s\" class=\"label\" style=\"float: left; \">" . construct_phrase($vbphrase['ladder_league_round_x_date'], $ri) . " </label>\r\n<div class=\"rightcol\">" . $rhtml . "</div></div>\r\n";
			$ri++;
		}
		$ladder['groupnames'] = explode(',', $ladder['groupnames']);
		for ($rtg = 1; $rtg <= $ladder['groups']; $rtg++)
		{
			$rtgm = $rtg - 1;
			$ladder['league_groups'] .= "<div style=\"clear: both; border: inherit; padding: inherit;\"><p class=\"label\" style=\"float: left;\">" . construct_phrase($vbphrase['ladder_league_group_x_name'], $rtg) . " </p>\r\n<div class=\"rightcol\"><input type=\"text\" class=\"textbox\" name=\"groupname[$rtg]\" value=\"" . ($ladder['groupnames']["$rtgm"] ? $ladder['groupnames']["$rtgm"] : construct_phrase($vbphrase['ladder_league_group_x'], $rtg)) . "\" /></div></div>\r\n";
		}
	}
	$templater = vB_Template::create('tmnt_ladder_edit');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
		$templater->register('seasons', $seasons);
		$templater->register('categories', $categories);
		$templater->register('catid', $catid);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('to_day', $to_day);
		$templater->register('to_monthselected', $to_monthselected);
		$templater->register('to_yearbits', $to_yearbits);
		$templater->register('totime', $user_to_time);
		$templater->register('fromtime', $user_from_time);
		$templater->register('from_day', $from_day);
		$templater->register('from_monthselected', $from_monthselected);
		$templater->register('from_yearbits', $from_yearbits);
		$templater->register('co_array', $co_array);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id='.$id . '' => $title,
		'' => construct_phrase($vbphrase['ladder_editing'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'insertplayer')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase['error_invalid_ladder'];
		eval(standard_error($errormessage));
	}
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id' ");
	if ($ladder['pot'] == 1)
	{
		$errormessage = "Cannot add users to team ladder";
		eval(standard_error($errormessage));
	}
	$ladderid = $vbulletin->input->clean_gpc('p', 'ladderid', TYPE_UINT);
	if ($ladderid)
	{
		$usernames = array();
		$cmpts_query = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '".$ladderid."' ");
		while ($cmpt = $vbulletin->db->fetch_array($cmpts_query))
		{
			$usernames[] = $cmpt['username'];
		}
	}
	else
	{
		$usernames = $vbulletin->input->clean_gpc('p', 'username', TYPE_STR);
		if (!$usernames)
		{
			$errormessage = $vbphrase['error_no_username'];
			eval(standard_error($errormessage));
		}
		$usernames = explode(';',$usernames);
	}
	foreach ($usernames AS $hash => $username)
	{
		$username = trim($username);
		$user = $vbulletin->db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '".$vbulletin->db->escape_string($username)."' ");
		if (!$user['userid'])
		{
			continue;
		}
		else
		{
			$userid = $user['userid'];
		}
		$checkuserid = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "user WHERE userid='$userid' ");
		$checkuserid = $checkuserid['countrows'];  
		if ($checkuserid != 1)
		{
			continue;
		}
		$player = $vbulletin->db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladder_players
			WHERE lid='$id'
				AND (userid='$userid' OR username='".$vbulletin->db->escape_string($username)."') 
		");
		if ($player && $player['active'])
		{
			continue;
		}
		if ($player)
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET active = '1' WHERE lid = '$id' AND (userid = '$userid' OR username = '".$vbulletin->db->escape_string($username)."') AND active = '0'");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET noplayers = noplayers + 1 WHERE id = '$id'");
			$userinfo = fetch_userinfo($userid);
			$tmnt_ladders = array_merge((array)$userinfo['tmnt_ladders'], (array)$id);
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_ladders = '" . implode(',' , $tmnt_ladders) . "' WHERE userid = '$userid'");
			continue;
		}
		
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_players
				(userid, username, lid, time, ip, pot, rank)
			VALUES (
				'".$vbulletin->db->escape_string($userid)."',
				'".$vbulletin->db->escape_string($username)."',
				'".$vbulletin->db->escape_string($id)."', 
				".TIMENOW.", 
				'".$vbulletin->db->escape_string($thisip)."', 
				'".$vbulletin->db->escape_string($ladder['pot'])."',
				'".$vbulletin->db->escape_string($ladder['startingelo'])."'
			)
		");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET noplayers = noplayers + 1 WHERE id=$id");
	}
	$vbulletin->url = "ladders.php?do=view&id=".$ladder['id'];
	eval(print_standard_redirect('redirect_insertplayer'));
}

// #############################################################################

if ($_REQUEST['do'] == 'addplayer')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id'");
	if (!$ladder)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	if ($ladder['pot'])
	{
		$team = true;
	} 
	else 
	{
		$team = false;
	}
	if (isset($_REQUEST['added']))
	{
		$added_success = true;
	}
	if ($ladder['groupid'])
	{
		$ladder_array = array();
		$ladders_query = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE groupid = '".$ladder['groupid']."' ");
		while ($l = $vbulletin->db->fetch_array($ladders_query))
		{
			$ladder_array["$l[id]"] = $l;
		}
	}
	$templater = vB_Template::create('tmnt_ladder_newplayer');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('ladder_array', $ladder_array);
		$templater->register('added_success', $added_success);
		$templater->register('id', $id);
		$templater->register('team', $team);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id='.$id . '' => $ladder['title'],
		'' => construct_phrase($vbphrase['ladder_addingplayer'])
	));
	$navbar = render_navbar_template($navbits);
	$show['usernameajax'] = true;
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('show', $show);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'create_player_image')
{
	$vbulletin->input->clean_array_gpc('g', array(
		'l' => TYPE_UINT,
		'w' => TYPE_UINT,
		'h' => TYPE_UINT,
		'u' => TYPE_UINT,
		'bw' => TYPE_UINT,
		'noavatar' => TYPE_UINT,
		'f' => TYPE_UINT,
		'bg' => TYPE_NOHTML,
		'b' => TYPE_NOHTML,
		'c' => TYPE_NOHTML,
	));
	$var = array(
		'l' => $vbulletin->GPC['l'],
		'w' => ($vbulletin->GPC['w'] ? $vbulletin->GPC['w'] : 250),
		'h' => ($vbulletin->GPC['h'] ? $vbulletin->GPC['h'] : 90),
		'u' => $vbulletin->GPC['u'],
		'bw' => ($vbulletin->GPC['bw'] ? $vbulletin->GPC['bw'] : 1),
		'noavatar' => $vbulletin->GPC['noavatar'],
		'f' => $vbulletin->GPC['f'],
		'bg' => ($vbulletin->GPC['bg'] ? $vbulletin->GPC['bg'] : 'FFFFFF'),
		'b' => ($vbulletin->GPC['b'] ? $vbulletin->GPC['b'] : '000000'),
		'c' => ($vbulletin->GPC['c'] ? $vbulletin->GPC['c'] : '000000'),
	);
	$ladder_array = array();
	$ladders_query = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders ORDER BY title ASC");
	while ($l = $vbulletin->db->fetch_array($ladders_query))
	{
		if ($l['id'] == $vbulletin->GPC['l'])
		{
			$l['selected'] = ' selected="selected"';
			}
		$ladder_array["$l[id]"] = $l;
	}
	if ($vbulletin->GPC['l'])
	{//fetch ladder players, if l is valid
		$player_array = array();
		$players_query = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '".$var['l']."' AND active = 1 ORDER BY username ASC");
		while ($p = $vbulletin->db->fetch_array($players_query))
		{
			if ($p['userid']==$vbulletin->GPC['u'])
			{
				$p['selected'] = ' selected="selected"';
				$srt = true;
			}
			$player_array["$p[userid]"] = $p;
		}
		if (!$srt)
		{
			$vbulletin->GPC['u'] = $var['u'] = 0;
		}
	}
	$templater = vB_Template::create('tmnt_ladder_cpi');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladders', $ladder_array);
		$templater->register('players', $player_array);
		$templater->register('var', $var);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => $vbphrase['ladder_create_player_image']
	));
	$navbar = render_navbar_template($navbits);
	$show['usernameajax'] = true;
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('show', $show);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'startleague')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$lid' AND league = 1");
	if (!$ladder)
	{
		print_no_permission();
	}
	$groups = $ladder['groups'];
	if ($pergroup > $tmnt_maxrr)
	{//check groups aren't too big
		$errormessage = "Maximum of $tmnt_maxrr per group; Increase number of groups.";
		eval(standard_error($errormessage));
	}
	if ($ladder['groupid'])
	{
		$basedonladder = $vbulletin->db->query_first("SELECT id, title FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id != '$lid' AND league = 2 AND groupid = '$ladder[groupid]' AND noplayers > 0 ORDER BY id DESC");
	}
	if ($_POST['do'] == 'startleague')
	{//post data
		$count = 0;
		$group_count = array();
		$xuser = array();
		$cmpts = $vbulletin->db->query_read("
			SELECT players.*, IF (players.pot=0, 'u.username', '')
			FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (u.userid = players.userid)
			WHERE lid = '$lid' AND active = 1
			ORDER BY rand()
		");
		while ($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			$count++;
			$cmpt['group'] = $vbulletin->input->clean_gpc('p', 'userid_'.$cmpt['userid'], TYPE_UINT);
			if ($cmpt['group'])
			{
				$group_count["$cmpt[group]"]++;
			}
			$c_array[] = $cmpt;
			$xuser["$cmpt[userid]"] = $cmpt;
			$g_array["$cmpt[group]"][] = $cmpt['userid'];
		}
	}
	elseif (!$ladder['groupid'] OR !$basedonladder)
	{ //new league - place players randomly into groups
		$count = 0;
		$xuser = array();
		$cmpts = $vbulletin->db->query_read("
			SELECT players.*, IF (players.pot=0, 'u.username', '')
			FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (u.userid = players.userid)
			WHERE lid = '$lid' AND active = 1
			ORDER BY rand()
		");
		while ($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			$count++;
			$c_array[] = $cmpt;
			$xuser["$cmpt[userid]"] = $cmpt;
		}
		$pergroup = ceil($count / $groups);
		if ($count == 0)
		{
			$errormessage = 'This league has no competitors yet.';
			eval(standard_error($errormessage));
		}
		//split into X groups as per $ladder
		$g_array = array();
		$this_group = 0;
		for ($i = 0; $i < $count; $i++)
		{
			$this_user = $c_array[$i]['username'];
			if ($i % $pergroup)
			{
			}
			else
			{
				$this_group++;
			}
			$g_array["$this_group"][] = $c_array[$i]['userid'];
		}
	}
	else
	{//based on last league		
		$lastcmpts = $vbulletin->db->query_read("
			SELECT players.*
			FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
			WHERE players.lid = '".$basedonladder['id']."' AND active = 1
		");
		while ($lastcmpt = $vbulletin->db->fetch_array($lastcmpts))
		{
			$last_c_array["$lastcmpt[userid]"] = $lastcmpt;
			$last_group["$lastcmpt[group]"][] = $lastcmpt['userid'];
		}
		$last_greatestround = count($last_group);
		foreach($last_group AS $thisgroup => $userids_array)
		{
			$this_count = count($userids_array);
			if ($thisgroup != 1)
			{//set first two as higher group
				$last_c_array["$userids_array[0]"]['group']--;
				if ($vbulletin->options['tmnt_league_pd'] > 1)
				{
					$last_c_array["$userids_array[1]"]['group']--;
				}
				if ($vbulletin->options['tmnt_league_pd'] > 2)
				{
					$last_c_array["$userids_array[2]"]['group']--;
				}
				if ($vbulletin->options['tmnt_league_pd'] > 3)
				{
					$last_c_array["$userids_array[3]"]['group']--;
				}
			}
			if ($last_greatestround != $thisgroup)
			{//set last two as lower group
				$j = $this_count - 1;
				$k = $this_count - 2;
				$l = $this_count - 3;
				$m = $this_count - 4;
				$last_c_array["$userids_array[$j]"]['group']++;
				if ($vbulletin->options['tmnt_league_pd'] > 1)
				{
					$last_c_array["$userids_array[$k]"]['group']++;
				}
				if ($vbulletin->options['tmnt_league_pd'] > 2)
				{
					$last_c_array["$userids_array[$l]"]['group']++;
				}
				if ($vbulletin->options['tmnt_league_pd'] > 3)
				{
					$last_c_array["$userids_array[$m]"]['group']++;
				}
			}
		}
		$count = 0;
		$group_count = array();
		$xuser = array();
		$cmpts = $vbulletin->db->query_read("
			SELECT players.*, IF (players.pot=0, 'u.username', '')
			FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (u.userid = players.userid)
			WHERE lid = '$lid' AND active = 1
			ORDER BY rand()
		");
		while ($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			$count++;
			//lastrank
			$cmpt['group'] = $last_c_array["$cmpt[userid]"]['group'];
			if ($cmpt['group'])
			{
				$group_count["$cmpt[group]"]++;
			}
			$c_array[] = $cmpt;
			$xuser["$cmpt[userid]"] = $cmpt;
		}
		$pergroup = ceil($count / $groups);
		if ($count == 0)
		{
			$errormessage = 'This league has no competitors yet.';
			eval(standard_error($errormessage));
		}
		$tg = 1;
		$g = 1;
		//print_r("pergroup = $pergroup;");
		$g_array = array();
		foreach ($c_array AS $chash => $cmpt)
		{
			if ($cmpt['group'])
			{
				$g_array["$cmpt[group]"][] = $cmpt['userid'];
				continue;
			}
			while ($group_count["$g"] >= $pergroup)
			{
				//print_r();
				$g++;
				if ($g > 8)
				{
					break;
				}
			}
			$cmpt['group'] = $g;
			$group_count["$cmpt[group]"]++;
			$g_array["$cmpt[group]"][] = $cmpt['userid'];
			$c_array["$chash"] = $cmpt;
		}
	}
	if (!$_REQUEST['auto'] && $_POST['do'] != 'startleague')
	{//not automatic display, print out
		//print_r($g_array);
		$s = count($g_array);
		$xo = 1;
		while ($xo <= $s)
		{
			$gdd .= '<option value="'.$xo.'">'.construct_phrase($vbphrase['ladder_league_group_x'], $xo).'</option>';
			$xo++;
		}
		function create_dropdown_groups($userid, $groupid)
		{
			global $gdd;
			//
			//alert(this.parentNode.parentNode.id)
			$return = '<select name="userid_'.$userid.'" onchange="tll_icm(this);" id="sel_u_'.$userid.'">'.str_replace('value="'.$groupid.'"','value="'.$groupid.'" selected="selected"',$gdd).'</select>';
			return $return;
		}
		arsort($g_array);
		$aarray = array();
		foreach ($g_array AS $groupid => $ids)
		{
			//print_r("<br />Group $groupid <br />");
			//print_r($ids);
			//print_r("<br />");
			if ($groupid != 1)
			{
				$first = true;
			}
			foreach($ids AS $xnull => $xuserid)
			{
				if (!$xuser["$xuserid"]['username'])
				{//sort out $teams!!!
					$xuser["$xuserid"] = fetch_userinfo($xuserid);
				}
				$aarray[] = array(
					'username' => $xuser["$xuserid"]['username'],
					'dd' => create_dropdown_groups($xuserid, $groupid),
					'userid' => $xuserid,
					'groupid' => $groupid,
					'first' => $first
				);
				$first = false;
			}
		}
		$templater = vB_Template::create('tmnt_organise_league');
			$templater->register('tmntp', $tmntp);
			$templater->register('aarray', $aarray);
			$templater->register('ladder', $ladder);
			$templater->register('basedonladder', $basedonladder);
			$templater->register('lstyle', '');
		$tlhtml .= $templater->render();
		$navbits = array(
			'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
			'ladders.php?showonly=leagues' => $vbphrase['ladder_leagues'],
			'ladders.php?do=view&amp;id='.$ladder['id'] => $ladder['title'],
			'' => 'Organise League Groups'
		);
		$navbits = construct_navbits($navbits);
		$navbar = render_navbar_template($navbits);
		$templater = vB_Template::create('tmnt_shell');
			$templater->register_page_templates();
			$templater->register('navbar', $navbar);
			$templater->register('headinclude', $headinclude);
			$templater->register('pagetitle', $pagetitle);
			$templater->register('tlhtml', $tlhtml);
			$templater->register('modname', $modname);
			$templater->register('header', $header);
			$templater->register('footer', $footer);
			$templater->register('tmntp', $tmntp);
			$templater->register('tmnt_version', $tmnt_version);
		print_output($templater->render());
	}
	foreach ($g_array AS $groupid => $ids)
	{
		//implode then update players group
		//print_r("<br>$xxx<br>");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players AS players SET players.group = '$groupid' WHERE lid = '$lid' AND ( userid = '" . implode("' OR userid = '", $ids) . "' ) ");
		$ingroup = count($ids);
		//print_r("ingroup = $ingroup; <br>");
		//print_r($ids);
		//print_r($ingroup);
		$database = fetch_rr_database($ingroup);
		//print_r($database);
		foreach ($database AS $r => $rvalue)
		{
			$r = substr($r, 1);
			$s = '';
			$xxx = '';
			//array('02v01','03v08','04v07','05v06')
			foreach ($rvalue AS $nh => $ndata)
			{
				list($pla, $plb) = explode('v', $ndata);
				$pla = (int)$pla - 1;
				$plb = (int)$plb - 1;
				if ($ids[$pla] && $ids[$plb])
				{
					/*
					$vbulletin->db->query_write("
						INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_games
							(u, u2, lid, time, pot, bestof, matchdate, map, u1message, u2message, chal_options, dateline, mf)
						VALUES (
							'".$vbulletin->db->escape_string($u)."',
							'".$vbulletin->db->escape_string($u2)."',
							'".$vbulletin->db->escape_string($lid)."',
							'".TIMENOW."',
							'0',
							'".$vbulletin->db->escape_string($bestof)."',
							'".$vbulletin->db->escape_string($matchdate)."',
							'".$vbulletin->db->escape_string($map)."',
							'".$vbulletin->db->escape_string($u1message)."',
							'".$vbulletin->db->escape_string($u2message)."',
							'".$vbulletin->db->escape_string($chal_options)."',
							'".$vbulletin->db->escape_string($dateline)."',
							'".$vbulletin->db->escape_string($mf)."'
						)
					");*/
					if (!$ladder['homeaway'])
					{
						$xxx .= "\r\n"."($ids[$pla], $ids[$plb], $lid, ".TIMENOW.", $ladder[pot], 0, 0, $groupid, $r, 1, 0), ";
					}
					else
					{
						$s = $r * 2;
						//player 1 home
						$xxx .= "\r\n"."($ids[$pla], $ids[$plb], $lid, ".TIMENOW.", $ladder[pot], 0, 0, $groupid, $s, 1, 0), ";
						$s--;
						//player 2 home
						$xxx .= "\r\n"."($ids[$plb], $ids[$pla], $lid, ".TIMENOW.", $ladder[pot], 0, 0, $groupid, $s, 1, 0), ";
					}
				}
			}
			if ($xxx)
			{
				$xxx = "INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_games (`u`, `u2`, `lid`, `time`, `pot`, `dateline`, `mf`, `group`, `round`, `accepted`, `bestof`) VALUES  " . substr($xxx, 0, -2) . " ";
				$vbulletin->db->query_write("$xxx");
			}
			//print_r("<br>$xxx<br>");
		}
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladders
		SET
			league = 2
		WHERE id = '$lid' AND league = '1'
	");
	$vbulletin->url = "ladders.php?do=view&id=$lid";	
	eval(print_standard_redirect('redirect_updatedladder'));
}

// #############################################################################

if ($_POST['do'] == 'updateladder')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
		if (!$id)
		{
			$errormessage = $vbphrase[error_invalid_ladder];
			eval(standard_error($errormessage));
		}
    $userid = $thisuserid;
	$username = $thisusername;
	$co_a = $vbulletin->input->clean_gpc('p', 'co_a', TYPE_ARRAY_NOHTML);
	$co_b = $vbulletin->input->clean_gpc('p', 'co_b', TYPE_ARRAY_NOHTML);
	$co = array();
	if (is_array($co_a))
	{
		//$key = preg_replace("/[^a-zA-Z0-9_\s]/", "", unhtmlspecialchars($key));
		foreach($co_a AS $key_a => $a)
		{
			if (!$a)
			{
				continue;
			}
			$a = preg_replace("/[^a-zA-Z0-9\s]/", "", unhtmlspecialchars($a));
			$co["$a"] = $co_b["$key_a"];
		}
		$co = serialize($co);
	}
	$icon = $vbulletin->input->clean_gpc('p', 'icon', TYPE_NOHTML);
	$title = $vbulletin->input->clean_gpc('p', 'title', TYPE_STR);
		if (!$title)
		{
			$errormessage = $vbphrase['error_invalid_title'];
			eval(standard_error($errormessage));
		}
	$tmin = $vbulletin->input->clean_gpc('p', 'tmin', TYPE_INT);
	$tmax = $vbulletin->input->clean_gpc('p', 'tmax', TYPE_INT);
	$xp_win = $vbulletin->input->clean_gpc('p', 'xp_win', TYPE_INT);
	$xp_draw = $vbulletin->input->clean_gpc('p', 'xp_draw', TYPE_INT);
	$xp_lose = $vbulletin->input->clean_gpc('p', 'xp_lose', TYPE_INT);
	$catid = $vbulletin->input->clean_gpc('p', 'catid', TYPE_UINT);
	$groupid = $vbulletin->input->clean_gpc('p', 'groupid', TYPE_UINT);
	$groups = $vbulletin->input->clean_gpc('p', 'groups', TYPE_UINT);
	$groupnames = implode(',', $vbulletin->input->clean_gpc('p', 'groupname', TYPE_ARRAY_NOHTML));
	if ($tmin > $tmax)
	{
		$tmin = $tmax;
		$tmax = $vbulletin->input->clean_gpc('p', 'tmin', TYPE_INT);
	}
	$league = $vbulletin->input->clean_gpc('p', 'league', TYPE_UINT);
	$startingelo = $vbulletin->input->clean_gpc('p', 'startingelo', TYPE_UINT);
	if (!$startingelo)
	{
		$startingelo = 1000;
	}
	$sticky = $vbulletin->input->clean_gpc('p', 'sticky', TYPE_INT);
	$archive = $vbulletin->input->clean_gpc('p', 'archive', TYPE_INT);
	$vbulletin->input->clean_array_gpc('p', array(
		'message'      => TYPE_STR,
		'wysiwyg'			 => TYPE_BOOL,
	));
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$description = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$description = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$description = $vbulletin->GPC['message'];
	}
		if (!$description)
		{
			$errormessage = $vbphrase['error_invalid_description'];
			eval(standard_error($errormessage));
		}
	//start date
	$vbulletin->input->clean_array_gpc('p', array(
		'timezoneoffset' => TYPE_ARRAY_NUM,
		'dst'            => TYPE_ARRAY_UINT,
		'fromdate'       => TYPE_ARRAY_ARRAY,
		'todate'         => TYPE_ARRAY_ARRAY,
		'totime'         => TYPE_ARRAY_NOHTML,
		'fromtime'       => TYPE_ARRAY_NOHTML
	));
	$type = 'range';
	$fromtime = $vbulletin->GPC['fromtime']["$type"];
	$totime = $vbulletin->GPC['totime']["$type"];
	$fromdate = $vbulletin->input->clean($vbulletin->GPC['fromdate']["$type"], TYPE_ARRAY_UINT);
	$todate = $vbulletin->input->clean($vbulletin->GPC['todate']["$type"], TYPE_ARRAY_UINT);
	$utc = $timezoneoffset = $vbulletin->GPC['timezoneoffset']["$type"];
	$dst = $vbulletin->GPC['dst']["$type"];
	require_once(DIR . '/includes/functions_misc.php');
	if (!fetch_timezone($timezoneoffset))
	{
		$errormessage = 'Error: invalid timezone specified';
		eval(standard_error($errormessage));
	}	
	$dateline_to = tmnt_fields_to_dateline($totime, $todate, $utc, $dst, $type);
	if (!is_numeric($dateline_to))
	{
		$errormessage = $dateline_to;
		eval(standard_error($errormessage));
	}
	$dateline_from = tmnt_fields_to_dateline($fromtime, $fromdate, $utc, $dst, $type);
	if (!is_numeric($dateline_from))
	{
		$errormessage = $dateline_from;
		eval(standard_error($errormessage));
	}
	if ($dateline_to < $dateline_from)
	{
		$errormessage = 'Error: End date must be after start date.';
		eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladders
		SET
			title = '".$vbulletin->db->escape_string($title)."',
			description = '".$vbulletin->db->escape_string($description)."', 
			ed_userid = '$userid', 
			ed_username = '".$vbulletin->db->escape_string($username)."',
			ed_time ='".TIMENOW."', 
			ed_ip ='".$vbulletin->db->escape_string($thisip)."',
			tmin = '".$vbulletin->db->escape_string($tmin)."', 
			tmax = '".$vbulletin->db->escape_string($tmax)."',
			sticky = '".$vbulletin->db->escape_string($sticky)."',
			archive = '".$vbulletin->db->escape_string($archive)."', 
			catid = '".$vbulletin->db->escape_string($catid)."', 
			startingelo = '".$vbulletin->db->escape_string($startingelo)."',
			icon = '".$vbulletin->db->escape_string($icon)."',
			dateline_from = '".$vbulletin->db->escape_string($dateline_from)."',
			dateline_to = '".$vbulletin->db->escape_string($dateline_to)."',
			dst = '".$vbulletin->db->escape_string($dst)."',
			utc = '".$vbulletin->db->escape_string($utc)."',
			groupid = '".$vbulletin->db->escape_string($groupid)."',
			chal_options = '".$vbulletin->db->escape_string($co)."',
			xp_win = '".$vbulletin->db->escape_string($xp_win)."',
			xp_draw = '".$vbulletin->db->escape_string($xp_draw)."',
			xp_lose = '".$vbulletin->db->escape_string($xp_lose)."',
			groupnames = '".$vbulletin->db->escape_string($groupnames)."',
			groups = '".$vbulletin->db->escape_string($groups)."'
		WHERE id = '$id'
	");
	if ($league)
	{
		for ($i=1;$i<=$tmnt_maxrr;$i++)
		{//for each round update dateline for all games upto 14
			$vbulletin->input->clean_array_gpc('p', array(
				"round".$i."date" => TYPE_ARRAY_ARRAY,
				"round".$i."time" => TYPE_ARRAY_NOHTML,
			));
			$time = $vbulletin->GPC["round".$i.'time']["$type"];
			$date = $vbulletin->input->clean($vbulletin->GPC["round".$i.'date']["$type"], TYPE_ARRAY_UINT);
			if (!$time && !$date)
			{
				break;
			}
			$dateline = tmnt_fields_to_dateline($time, $date, $utc, $dst, $type);
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
				SET
					dateline = '".$vbulletin->db->escape_string($dateline)."'
				WHERE lid = '$id' AND round = '$i'
			");
		}
	}
	build_tll_catcache();
	$vbulletin->url = "ladders.php?do=view&id=$id";	
	eval(print_standard_redirect('redirect_updatedladder'));
}

// #############################################################################

if ($_REQUEST['do'] == 'delete')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
    $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id=$id");
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$id");
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$id");
	build_tll_catcache();
	$vbulletin->url = "ladders.php";
	eval(print_standard_redirect('redirect_deletedladder'));
}

// #############################################################################

if ($_REQUEST['do'] == 'deletechallenge')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase['error_invalid_challenge'];
		eval(standard_error($errormessage));
	}
    $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id=$id");
	$vbulletin->url = "ladders.php?do=allchallenges";
	eval(print_standard_redirect('redirect_deletedchallenge'));
}

// #############################################################################

if ($_REQUEST['do'] == 'reportchallenge')
{
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$games = $vbulletin->db->query_first("
		SELECT ladders.*, games.*
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON(games.lid=ladders.id)
		WHERE games.id = '$id'
	");
	if ($games['pot'])
	{
		$teamids = array();
		$teams = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_members AS members
			JOIN " . TABLE_PREFIX . "tmnt_teams AS teams
				on members.teamid = teams.teamid
			WHERE members.leader=1
				AND members.userid='$thisuserid'");
		while($team = $vbulletin->db->fetch_array($teams))
		{
			$teamids = array_merge((array)$team['teamid'], $teamids);
		}
	}
	if (
		!$games['flag'] &&
		( (($vbulletin->userinfo['userid'] == $games['u'] OR $vbulletin->userinfo['userid'] == $games['u2']) && !$games['pot'])
		OR
		( (in_array($games['u'], $teamids) OR in_array($games['u2'], $teamids)) && $games['pot']) )
		)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET flag = '" . $vbulletin->userinfo['userid'] . "' WHERE id = '$id' ");
	}
	$vbulletin->url = "ladders.php?do=challenges&mid=".$id."#match".$id;
	eval(print_standard_redirect('redirect_matchreported'));
}

// #############################################################################

if ($_REQUEST['do'])
{
	$_REQUEST['do'] = '';
}

// #############################################################################

if (empty($_REQUEST['do']))
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	$c = $vbulletin->input->clean_gpc('g', 'c', TYPE_UINT);
	$filename = 'ladders';
	/*$cats = $vbulletin->db->query_read("
		SELECT cats.*, COUNT(DISTINCT ladders.id) AS countladders
		FROM " . TABLE_PREFIX . "tmnt_categories AS cats
		LEFT OUTER JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (cats.catid = ladders.catid)
		WHERE cats.tol IN (2, 3)
		" . ($c ? " AND parentid = '$c' " : "") . "
		GROUP BY cats.catid
		ORDER BY cats.parentid DESC, cats.displayorder ASC, cats.title ASC
	");
	$carray = array();
	$ctarray  = array();
	while($cat = $vbulletin->db->fetch_array($cats))
	{
		$cat['counttmnts'] = -1;
		$cat['countladders'] += (int)$ctarray["$cat[catid]"]['lcount'];
		$ctarray["$cat[parentid]"]['lcount'] += $cat['countladders'];
		$templater = vB_Template::create('tmnt_cat');
			$templater->register('tmntp', $tmntp);
			$templater->register('cat', $cat);
			$templater->register('c', $c);
			$templater->register('filename', $filename);
		if (!$c && $cat['parentid'])
		{
			
			$carray["$cat[parentid]"] .= $templater->render();
		}
		else
		{
			$templater->register('subcs', $carray["$cat[catid]"]);
			$categories .= $templater->render();
		}
	}*/
	$showonly = $vbulletin->input->clean_gpc('g', 'showonly', TYPE_NOHTML);
	if ($vbulletin->tll_catcache)
	{
		foreach ($vbulletin->tll_catcache AS $cindex => $cat)
		{
			if (($cat['tol']==1) OR ($c && $cat['parentid'] != $c))
			{
				continue;
			}
			$cat['counttmnts'] = -1;
			$templater = vB_Template::create('tmnt_cat');
				$templater->register('tmntp', $tmntp);
				$templater->register('cat', $cat);
				$templater->register('c', $c);
				$templater->register('showonly', $showonly);
				$templater->register('filename', $filename);
			if (!$c && $cat['parentid'])
			{
				
				$carray["$cat[parentid]"] .= $templater->render();
			}
			else
			{
				$templater->register('subcs', $carray["$cat[catid]"]);
				$categories .= $templater->render();
			}
		}
	}
	$recentmatches = array('1' => array('id' => '2', 'title' => 'xxx'));
	$rowcount = 0;
	require_once(DIR . '/includes/class_bbcode.php');
	$ladders = $vbulletin->db->query_read("
		SELECT ladders.*, cats.title AS categorytitle, cats2.title AS categorytitle2, cats2.title AS parenttitle, cats.parentid AS parentid
		FROM " . TABLE_PREFIX . "tmnt_ladders AS ladders
		LEFT JOIN " . TABLE_PREFIX . "tmnt_categories AS cats
			ON ladders.catid = cats.catid
		LEFT JOIN " . TABLE_PREFIX . "tmnt_categories AS cats2
			ON cats.parentid = cats2.catid
		WHERE ladders.catid = '$c'
			" . ($showonly == 'ladders' ? " AND ladders.league = 0" : "") . "
			" . ($showonly == 'leagues' ? " AND ladders.league > 0" : "") . "
		ORDER BY ladders.sticky DESC, ladders.title ASC
	");
	while($ladder = $vbulletin->db->fetch_array($ladders))
	{
		if ($rowcount == 0)
		{
			$categorytitle = $ladder['categorytitle'];
			$parentcategorytitle = $ladder['parenttitle'];
			$parentcategoryid = $ladder['parentid'];
			if (!$categorytitle && !$c)
			{
				if ($showonly == 'ladders')
				{
					$categorytitle = $vbphrase['tmnt_uncat_ladders'];
				}
				elseif ($showonly == 'leagues')
				{
					$categorytitle = $vbphrase['tmnt_uncat_leagues'];
				}
				else
				{
					$categorytitle = $vbphrase['tmnt_uncat_ldslgs'];
				}
			}
			elseif (!$categorytitle)
			{
				if ($showonly == 'ladders')
				{
					$categorytitle = $vbphrase['ladders'];
				}
				elseif ($showonly == 'leagues')
				{
					$categorytitle = $vbphrase['ladder_leagues'];
				}
				else
				{
					$categorytitle = $vbphrase['ladders_and_leagues'];
				}
			}
			$cinfo = $vbulletin->tll_catcache["$c"];
			if ($cinfo['parsed_banner'])
			{
				$cinfo['banner'] = $cinfo['parsed_banner'];
			}
			elseif ($cinfo['banner'])
			{
				require_once(DIR . '/includes/class_bbcode.php');
				$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
				$cinfo['banner'] = $bbcode_parser->do_parse($cinfo['banner']);
			}
			$templater = vB_Template::create('tmnt_ladder_list_top');
				$templater->register('tmntp', $tmntp);
				$templater->register('rowcount', $rowcount);
				$templater->register('categorytitle', $categorytitle);
				$templater->register('categories', $categories);
				$templater->register('ladder', $ladder);
				$templater->register('cinfo', $cinfo);
				$templater->register('showonly', $showonly);
			$tlhtml .= $templater->render();
		}
		$sticky = $ladder['sticky'];
        $description = preg_replace ('/\[(.*?)\]/is', '', $ladder['description']);
		$descriptionlength = strlen($description);
		if ($descriptionlength > $vbulletin->options['tmnt_desclength'])
		{
			$description = substr($description, 0, $vbulletin->options['tmnt_desclength']);
			$description = $description . '...';
		}
		$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), false); 
		$description = $bbcode_parser->do_parse($description,false,false,true,false,false,false);
		$templater = vB_Template::create('tmnt_ladder_list');
			$templater->register('tmntp', $tmntp);
			$templater->register('rowcount', $rowcount);
			$templater->register('categorytitle', $categorytitle);
			$templater->register('ladder', $ladder);
			$templater->register('description', $description);
			$templater->register('sticky', $sticky);
			$templater->register('rowcount', $rowcount);
		$tlhtml .= $templater->render();
		$rowcount ++;
	}
	if ($rowcount == 0)
	{
		if ($c)
		{
			$tol = "2,3";
			$titles = fetch_category_titles($c, $tol);
			$categorytitle = $titles['title'];
			$parentcategorytitle = $titles['parenttitle'];
			$parentcategoryid = $titles['parentid'];
			if (!$categorytitle)
			{
				$errormessage = $vbphrase[error_invalid_category];
				eval(standard_error($errormessage));
			}
			$cinfo = $vbulletin->tll_catcache["$c"];
			if ($cinfo['parsed_banner'])
			{
				$cinfo['banner'] = $cinfo['parsed_banner'];
			}
			elseif ($cinfo['banner'])
			{
				require_once(DIR . '/includes/class_bbcode.php');
				$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
				$cinfo['banner'] = $bbcode_parser->do_parse($cinfo['banner']);
			}
		}
		else
		{
			if ($showonly == 'leagues')
			{
				$categorytitle = $vbphrase['tmnt_uncat_leagues'];
			}
			elseif ($showonly == 'ladders')
			{
				$categorytitle = $vbphrase['tmnt_uncat_ladders'];
			}
			else
			{
				$categorytitle = $vbphrase['tmnt_uncat_ldslgs'];
			}
		}
		$templater = vB_Template::create('tmnt_ladder_list_top');
			$templater->register('tmntp', $tmntp);
			$templater->register('rowcount', $rowcount);
			$templater->register('categorytitle', $categorytitle);
			$templater->register('categories', $categories);
			$templater->register('ladder', $ladder);
			$templater->register('showonly', $showonly);
			$templater->register('cinfo', $cinfo);
		$tlhtml .= $templater->render();
		if (!$categories)
		{
			$templater = vB_Template::create('tmnt_ladder_noladders');
				$templater->register('tmntp', $tmntp);
				$templater->register('rowcount', $rowcount);
				$templater->register('categorytitle', $categorytitle);
				$templater->register('ladder', $ladder);
				$templater->register('league', ($showonly == 'leagues' ? "1" : "0"));
			$tlhtml .= $templater->render();
		}
	}
	$templater = vB_Template::create('tmnt_ladder_list_bot');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowcount', $rowcount);
		$templater->register('categorytitle', $categorytitle);
		$templater->register('categories', $categories);
		$templater->register('ladder', $ladder);
		$templater->register('showonly', $showonly);
		$templater->register('c', $c);
	$tlhtml .= $templater->render();
	if ($rowcount)
	{
		list($count, $recentmatches, $upcomingmatches) = get_rg_ug($c);
		$random = get_random_l_torp($c);
		$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_NOHTML);
		if (!$sh)
		{
			$sh = 'rg';
		}
		$templater = vB_Template::create('tmnt_ladder_list_rm');
			$templater->register('tmntp', $tmntp);
			$templater->register('rowcount', $rowcount);
			$templater->register('categorytitle', $categorytitle);
			$templater->register('categories', $categories);
			$templater->register('ladder', $ladder);
			$templater->register('recentmatches', $recentmatches);
			$templater->register('upcomingmatches', $upcomingmatches);
			$templater->register('random', $random);
			$templater->register('count', $count);
			$templater->register('sh', $sh);
			$templater->register('c', $c);
		$recentmatches = $templater->render();
		$tlhtml = str_replace('{recentmatches}', $recentmatches, $tlhtml);
	}
	$tlhtml = str_replace('{recentmatches}', '', $tlhtml);
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname
	);
	$x = 'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . ($showonly ? "showonly=$showonly" : "");
	if ($showonly == 'leagues')
	{
		$navbits["$x"] = $vbphrase['ladder_leagues'];
	}
	elseif ($showonly == 'ladders')
	{
		$navbits["$x"] = $vbphrase['ladders'];
	}
	else
	{
		$navbits["$x"] = $vbphrase['ladders_and_leagues'];
	}
	if ($parentcategoryid)
	{
		$x = 'ladders.php' . $vbulletin->session->vars['sessionurl_q'] . "?c=$parentcategoryid";
		$navbits["$x"] = $parentcategorytitle;
	}
	$navbits[''] = $categorytitle;
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################
	
?>