<?php
if (!in_array(THIS_SCRIPT, array('ladders', 'competitors', 'tournaments')) && !$vbulletin)
{
	global $vbulletin;
	print_r("<!-- Non-standard page, trying global vbulletin variable -->\r\n");
}
if (!$vbulletin->options['tmnt_active'] && $vbulletin->userinfo['usergroupid'] != 6)
{
	print_r("<!-- vBulletin Tournaments &amp; Ladders disabled in AdminCP -->\r\n");
	print_no_permission();
}

$modname = $vbulletin->options['tmnt_modname'];
$tmnt_version = "v"."4.5.0";
$tmnt_maxrr = 18;
$tmnt_maxde = 8;

if (($permissions['tournamentpermissions'] & $vbulletin->bf_ugp['tournamentpermissions']['canview'])) {
	$tmntp['canviewtmnt'] = true;
} else {
	$tmntp['canviewtmnt'] = false;
}
if (($permissions['tournamentpermissions'] & $vbulletin->bf_ugp['tournamentpermissions']['canedit'])) {
	$tmntp['canedittmnt'] = true;
} else {
	$tmntp['canedittmnt'] = false;
}
if (($permissions['tournamentpermissions'] & $vbulletin->bf_ugp['tournamentpermissions']['canjoin'])) {
	$tmntp['canjointmnt'] = true;
} else {
	$tmntp['canjointmnt'] = false;
}
if (($permissions['tournamentpermissions'] & $vbulletin->bf_ugp['tournamentpermissions']['cancreate'])) {
	$tmntp['cancreatetmnt'] = true;
} else {
	$tmntp['cancreatetmnt'] = false;
}
if (($permissions['tournamentpermissions'] & $vbulletin->bf_ugp['tournamentpermissions']['cancreateteam'])) {
	$tmntp['cancreateteam'] = true;
} else {
	$tmntp['cancreateteam'] = false;
}
if (($permissions['tournamentpermissions'] & $vbulletin->bf_ugp['tournamentpermissions']['canjointeam'])) {
	$tmntp['canjointeam'] = true;
} else {
	$tmntp['canjointeam'] = false;
}
if (($permissions['tournamentpermissions'] & $vbulletin->bf_ugp['tournamentpermissions']['caneditteams'])) {
	$tmntp['caneditteams'] = true;
} else {
	$tmntp['caneditteams'] = false;
}
if (($permissions['ladderpermissions'] & $vbulletin->bf_ugp['ladderpermissions']['canview'])) {
	$tmntp['canviewladder'] = true;
} else {
	$tmntp['canviewladder'] = false;
}
if (($permissions['ladderpermissions'] & $vbulletin->bf_ugp['ladderpermissions']['canedit'])) {
	$tmntp['caneditladder'] = true;
} else {
	$tmntp['caneditladder'] = false;
}
if (($permissions['ladderpermissions'] & $vbulletin->bf_ugp['ladderpermissions']['cancreate'])) {
	$tmntp['cancreateladder'] = true;
} else {
	$tmntp['cancreateladder'] = false;
}
if (($permissions['ladderpermissions'] & $vbulletin->bf_ugp['ladderpermissions']['canjoin'])) {
	$tmntp['canjoinladder'] = true;
} else {
	$tmntp['canjoinladder'] = false;
}
if (($permissions['ladderpermissions'] & $vbulletin->bf_ugp['ladderpermissions']['canmanageteams'])) {
	$tmntp['canmanageteams'] = true;
} else {
	$tmntp['canmanageteams'] = false;
}
if (($permissions['tournamentpermissions'] & $vbulletin->bf_ugp['tournamentpermissions']['candelcomment'])) {
	$tmntp['candelcomment'] = true;
} else {
	$tmntp['candelcomment'] = false;
}
if (($permissions['tournamentpermissions'] & $vbulletin->bf_ugp['tournamentpermissions']['candelowncomment'])) {
	$tmntp['candelowncomment'] = true;
} else {
	$tmntp['candelowncomment'] = false;
}
if (($permissions['tournamentpermissions'] & $vbulletin->bf_ugp['tournamentpermissions']['cancomment'])) {
	$tmntp['cancomment'] = true;
} else {
	$tmntp['cancomment'] = false;
}
if (($permissions['ladderpermissions'] & $vbulletin->bf_ugp['ladderpermissions']['cancomment'])) {
	$tmntp['canmcomment'] = true;
} else {
	$tmntp['canmcomment'] = false;
}
if (($permissions['ladderpermissions'] & $vbulletin->bf_ugp['ladderpermissions']['candeletecomments'])) {
	$tmntp['candelmcomments'] = true;
} else {
	$tmntp['candelmcomments'] = false;
}
if (($permissions['ladderpermissions'] & $vbulletin->bf_ugp['ladderpermissions']['superuser'])) {
	$tmntp['ladder_superuser'] = true;
} else {
	$tmntp['ladder_superuser'] = false;
}

($hook = vBulletinHook::fetch_hook('tll_tmntp_end')) ? eval($hook) : false;

if (!$tmntp['canviewtmnt'] && !$tmntp['canviewladder'])
{
	print_r("<!-- No Permission to view either Tournaments or Ladders -->\r\n");
	print_no_permission();
}

vB_Template::preRegister('tmnt_navbar', array('tmntp' => $tmntp));
vB_Template::preRegister('navbar', array('tmntp' => $tmntp));

$thisuserid = $vbulletin->userinfo['userid'];
$thisusername = $vbulletin->userinfo['username'];
$thisip = $vbulletin->input->clean($_SERVER['REMOTE_ADDR'], TYPE_NOHTML);;

$banneduserids = $vbulletin->options['tmnt_banneduserids'];
$banneduserids = explode(",", $banneduserids);
if (in_array($thisuserid, (array)$banneduserids) AND $show['member'])
{
	print_r("<!-- Userid in Banned Userids array!! -->\r\n");
	print_no_permission();
}
if (!$vbulletin->tll_catcache)
{
	build_tll_catcache();
}
else
{
foreach ($vbulletin->tll_catcache AS $x => $y)
{
	$xpo = $x+1;
	if (!$y['parentid'])
	{
		$template_hook['tmnt_navtop_left'] .= '<li class="popupmenu nohovermenu" id="popuptmnt_cat'.$y['catid'].'"><h6><a href="javascript://" class="popupctrl" rel="nofollow" id="yui-gen'.$y['catid'].'19">'.$y['title'].'</a></h6><ul class="popupbody" id="yui-gen'.$y['catid'].'18" style="left: 5px; top: 17px; display: none;">';
		$template_hook['tmnt_navtop_left'] .= '<li><a href="competitions.php?c='.$y['catid'].'">'.$y['title'].'</a></li>';
		$template_hook['tmnt_navtop_left'] .= $y_{$y[catid]} . '</ul></li>';
		$y_open = true;
	}
	else
	{
		$y_{$y[parentid]} .= '<li><a href="competitions.php?c='.$y['catid'].'"><img src="'.vB_Template_Runtime::fetchStyleVar('imgdir_misc').'/child_icon.png" alt="" /> '.$y['title'].'</a></li>';
		if ($y_open && !$vbulletin->tll_catcache["$xpo"]['parentid'])
		{
			
			$y_open = false;
		}
	}
}
}
vB_Template::preRegister('tmnt_shell', array('template_hook' => $template_hook));

$vbulletin->options['tmnt_ladder_columns'] = explode(',', $vbulletin->options['tmnt_ladder_columns']);

($hook = vBulletinHook::fetch_hook('tll_functions_start')) ? eval($hook) : false;

// #############################################################################

function fetch_ladderinfo(&$ladderid)
{
	global $vbulletin;
	$ladderid = intval($ladderid);
	$ladder = $vbulletin->db->query_first_slave("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$ladderid' ");
	if (!$ladder)
	{
		return false;
	}
	return $ladder;
}

// #############################################################################

function get_rg_ug($c)
{
	global $vbulletin;
	$count = array();
	$recentmatches = array();
	$matches = $vbulletin->db->query_read("
		SELECT games.*, games.u AS uid, games.u2 AS u2id,
		user.username AS username, userb.username AS username2, team.teamname AS teamname, teamb.teamname AS teamname2,
		ladders.title AS laddertitle
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (games.u = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS userb
			ON (games.u2 = userb.userid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS team
			ON (games.u = team.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teamb
			ON (games.u2 = teamb.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		WHERE ladders.catid = '$c'
			AND games.finished = '1'
		ORDER BY games.dateline_finished DESC, games.id DESC
		LIMIT 0, 15
	");
	while($match = $vbulletin->db->fetch_array($matches))
	{
		if ($vbulletin->options['tmnt_colour_scores'])
		{
			if ($match['score_u'] > $match['score_u2'])
			{
				$match['score_u_css'] = 'color: #009900;';
				$match['score_u2_css'] = 'color: #FF0000;';
			}
			elseif($match['score_u'] < $match['score_u2'])
			{
				$match['score_u_css'] = 'color: #FF0000;';
				$match['score_u2_css'] = 'color: #009900;';
			}
		}
		$recentmatches[] = $match;
		$count['rm']++;
	}
	$upcomingmatches = array();
	$matches = $vbulletin->db->query_read("
		SELECT games.*, games.u AS uid, games.u2 AS u2id,
		user.username AS username, userb.username AS username2, team.teamname AS teamname, teamb.teamname AS teamname2,
		ladders.title AS laddertitle
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (games.u = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS userb
			ON (games.u2 = userb.userid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS team
			ON (games.u = team.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teamb
			ON (games.u2 = teamb.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		WHERE ladders.catid = '$c'
			AND games.finished = '0'
			AND games.accepted = '1'
		ORDER BY games.dateline DESC, games.id DESC
		LIMIT 0, 15
	");
	while($match = $vbulletin->db->fetch_array($matches))
	{
		$upcomingmatches[] = $match;
		$count['um']++;
	}
	return(array($count, $recentmatches, $upcomingmatches));
}

// #############################################################################

function get_random_l_torp($c)
{
	global $vbulletin, $tmntp;
	if (TIMENOW % 2)
	{
		$random = $vbulletin->db->query_first("
			SELECT teams.*, players.*, ladders.title AS laddertitle
			FROM " . TABLE_PREFIX . "tmnt_teams AS teams
			RIGHT JOIN " . TABLE_PREFIX . "tmnt_ladder_players AS players
				ON (teams.teamid = players.userid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
				ON (players.lid = ladders.id)
			WHERE players.pot = 1
				AND ladders.catid = '".$vbulletin->db->escape_string($c)."'
				AND ladders.league != 1
			ORDER BY rand()
		");
	}
	if (!$random)
	{
		$random = $vbulletin->db->query_first("
			SELECT users.*, players.*, ladders.title AS laddertitle, users.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight
			FROM " . TABLE_PREFIX . "user AS users
			RIGHT JOIN " . TABLE_PREFIX . "tmnt_ladder_players AS players
				ON (users.userid = players.userid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
				ON (players.lid = ladders.id)
			LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar
				ON (avatar.avatarid = users.avatarid)
			LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar
				ON (customavatar.userid = users.userid)
			WHERE players.pot = 0
				AND ladders.catid = '".$vbulletin->db->escape_string($c)."'
				AND ladders.league != 1
			ORDER BY rand()
		");
		if (!empty($random['avatarpath']))
		{
			$random['avatarurl'] = $random['avatarpath'];
		}
		elseif ($random['hascustom'])
		{
			$avatarurl = array('hascustom' => 1);
			if ($vbulletin->options['usefileavatar'])
			{
				$random['avatarurl'] = $vbulletin->options['avatarurl'] . ($thumb ? '/thumbs' : '') . "/avatar{$random['userid']}_{$random['avatarrevision']}.gif";
			}
			else
			{
				$random['avatarurl'] = "image.php?u=$random[userid]&amp;dateline=$random[avatardateline]" . ($thumb ? '&type=thumb' : '') ;
			}
		}
		if (empty($random['avatarurl']))
		{
			$random['avatarurl'] = vB_Template_Runtime::fetchStyleVar('imgdir_misc') . '/unknown.gif';
		}
		$random['teamlogo'] = $random['avatarurl'];
	}
	if (!$random)
	{
		return false;
	}
	$countp = $vbulletin->db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players WHERE rank > '".$random['rank']."' AND lid = '".$random['lid']."' AND players.group = '".$vbulletin->db->escape_string($random['group'])."' ");
	$random['position'] = $countp['count'] + 1;
	$random['position'] = process_position($random['position']);
	$templater = vB_Template::create('tmnt_random_torp');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('random', $random);
		$templater->register('sh', $sh);
		$templater->register('c', $c);
	$random = $templater->render();
	return $random;
}

// #############################################################################

function process_position($pos, $sup = false)
{
	$ld = substr($pos, -1);
	switch ($ld)
	{
		case 1:
			$end = 'st';
			break;
		case 2:
			$end = 'nd';
			break;
		case 3:
			$end = 'rd';
			break;
		default:
			$end = 'th';
			break;
	}
	$l2d = substr($pos, -2);
	switch ($l2d)
	{
		case 11:
		case 12:
		case 13:
			$end = 'th';
			break;
	}
	if ($sup)
	{
		return ($pos."<sup>".$end."</sup>");
	}
	else
	{
		return ($pos."".$end."");
	}
}

// #############################################################################

function fetch_teaminfo(&$teamid)
{
	global $vbulletin;
	$teamid = intval($teamid);
	$team = $vbulletin->db->query_first_slave("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid = '$teamid' ");
	if (!$team)
	{
		return false;
	}
	return $team;
}

// #############################################################################

function process_full_tmnt($id, $forceplayercheck = 0)
{
	global $vbulletin, $vbphrase;
	$tmnt = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id = '$id' ");
	$freeslots = $tmnt['freeslots'];
	$noplayers = $tmnt['noplayers'];
	$tmnt = switch_tmnt_status($tmnt);
	if ($tmnt['checkin'] && TIMENOW > $tmnt['date'])
	{
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_players WHERE tid=$id AND checkedin = 0");
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_players WHERE tid = '$id' ");
		$noplayers = $countplayer['countrows'];
		$freeslots = 0;
		$forceplayercheck = 1;
	}
	if ($freeslots == 0)
	{
		if ($tmnt['status'] == $vbphrase['tmnt_waiting'] OR $forceplayercheck)
		{
			if (in_array($tmnt['type'], array('1v1', 'de')))
			{/*check right amount of slots*/
				if ($noplayers >= 2)
				{
					if ($noplayers <= 4)
					{
						$byes = 4 - $noplayers;
						$noplayers = 4;
					}
					elseif ($noplayers <= 8)
					{
						$byes = 8 - $noplayers;
						$noplayers = 8;
					}
					elseif ($noplayers <= 16)
					{
						$byes = 16 - $noplayers;
						$noplayers = 16;
					}
					elseif ($noplayers <= 32)
					{
						$byes = 32 - $noplayers;
						$noplayers = 32;
					}
					elseif ($noplayers <= 64)
					{
						$byes = 64 - $noplayers;
						$noplayers = 64;
					}
					elseif ($noplayers <= 128)
					{
						$byes = 128 - $noplayers;
						$noplayers = 128;
					}
					elseif ($noplayers <= 256)
					{
						$byes = 256 - $noplayers;
						$noplayers = 256;
					}
					elseif ($noplayers <= 512)
					{
						$byes = 512 - $noplayers;
						$noplayers = 512;
					}
					$cmpts = $vbulletin->db->query_read("SELECT userid, username, slot FROM " . TABLE_PREFIX . "tmnt_players WHERE tid='$id' ORDER BY slot ASC");
					while ($cmpt = $vbulletin->db->fetch_array($cmpts))
					{
						if ($cmpt['userid'] == 0)
						{
							continue;
						}
						if ($byes <= 0)
						{
							break;
						}
						$slot = $cmpt['slot'] + 1;
						$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_players
						(userid, username, tid, time, slot, pot, checkedin)
						VALUES ('0', 'Bye', '".$id."', ".TIMENOW.", '".$slot."', '".$tmnt['pot']."', '1')
						");
						$byes--;
					}
				}
			}
			/*end check*/
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET status = 2, noplayers = '".$noplayers."', freeslots = 0 WHERE id='$id'");
		}
		return true;
	}
	return false;
}

// #############################################################################

function fetch_category_title(&$catid, $tol)
{
	global $vbulletin;
	$catid = intval($catid);
	if ($tol)
	{
		$query = "AND tol IN ($tol)";
	}
	$cat = $vbulletin->db->query_first_slave("SELECT title FROM " . TABLE_PREFIX . "tmnt_categories WHERE catid = '$catid' $query ");
	if (!$cat)
	{
		return false;
	}
	return $cat[title];
}

// #############################################################################

function fetch_category_titles(&$catid, $tol)
{
	global $vbulletin;
	$catid = intval($catid);
	if ($tol)
	{
		$query = "AND cats.tol IN ($tol)";
	}
	$cat = $vbulletin->db->query_first_slave("
		SELECT cats.title, cats.parentid, cats2.title AS parenttitle
		FROM " . TABLE_PREFIX . "tmnt_categories AS cats
		LEFT JOIN  " . TABLE_PREFIX . "tmnt_categories AS cats2
			ON cats2.catid = cats.parentid
		WHERE cats.catid = '$catid'
		$query
	");
	if (!$cat)
	{
		return false;
	}
	return $cat;
}

// #############################################################################

function array_delete($array, $delete)
{
	$newarray = array();
	if (!$array || $array == $delete)
	{
		return array('0');
	}
	if (!is_array($array))
	{
		return $array;
	}
	foreach($array as $value)
	{
		if(stristr($value, $delete)===false && strlen($value)>0)
		{
			$newarray[] = $value;
		}
	}
	return $newarray;
}

// #############################################################################

function new_thread($userid, $forumid, $title, $pagetext, $open, $allowsmilie, $visible)
{
	global $vbulletin;
	if (!$userinfo = fetch_userinfo($userid))
	{
		return false;
	}
	require_once('./includes/class_dm.php');
	require_once('./includes/class_dm_threadpost.php');
	$threaddm = new vB_DataManager_Thread_FirstPost($vbulletin, ERRTYPE_STANDARD);
	$foruminfo = fetch_foruminfo($forumid);
	$threaddm->set_info('forum',$foruminfo);
	$threaddm->set_info('user',$userinfo);
	$threaddm->set('forumid', $forumid);
	$threaddm->set('userid',$userinfo['userid']);
	$threaddm->set('title', $title);
	$threaddm->set('pagetext', $pagetext); 
	$threaddm->set('open', $open);
	$threaddm->set('allowsmilie', $allowsmilie);
	$threaddm->set('visible', $visible);
	$threaddm->pre_save();
	if (!empty($threaddm->errors))
	{
		//echo ($threaddm->errors);
		return false;
	}
	$threadid = $threaddm->save();
	return $threadid;
	unset($threaddm);
	build_thread_counters($threadid);
	build_forum_counters($forumid);
}

// #############################################################################

function remove_bbcode($string)
{
	$string = preg_replace('/\[(.*?)\]/is', '', $string);
	return $string;
}

// #############################################################################

function is_u($game, $thisuserid)
{
	if ($game['uid'] == $thisuserid)
	{
		return true;
	}
	else
	{
		return false;
	}
}

// #############################################################################

function is_u2($game, $thisuserid)
{
	if ($game['u2id'] == $thisuserid)
	{
		return true;
	}
	else
	{
		return false;
	}
}

// #############################################################################

function switch_tmnt_type($tmnt)
{
	global $vbphrase;
	if (in_array($tmnt['type'], array('LMS', '1v1', 'de', 'rr', 'drr')))
	{
		$tmnt['type'] = $vbphrase['tmnt_'.strtolower($tmnt[type]).''];
	}
	return $tmnt;
}

// #############################################################################

function switch_tmnt_status($tmnt)
{
	global $vbphrase;
	switch ($tmnt['status'])
	{
		case 1:
			$tmnt['status'] = $vbphrase['tmnt_waiting'];
			break;
		case 2:
			$tmnt['status'] = $vbphrase['tmnt_inprogress'];
			break;
		case 3:
			$tmnt['status'] = $vbphrase['tmnt_finished'];
			break;
	}
	return $tmnt;
}

// #############################################################################

function switch_match_status($game, $is_u, $is_u2)
{
	global $vbphrase;
	if ($game['accepted'] == 0)
	{
		$game['status'] = $vbphrase[tmnt_awaiting_acceptance];
		if ($is_u2)
		{
			$game['status'] = $game['status'].'. <br /> <a href="ladders.php?do=accept&amp;id='.$game['id'].'&amp;u='.$game['uid'].'">'.$vbphrase['tmnt_accept_now'].'</a>! <br /> <a href="ladders.php?do=reject&amp;id='.$game['id'].'">'.$vbphrase['tmnt_reject_now'].'</a>!';
		}
		else if ($game['u2id'] == 0)
		{
			$game['status'] = $vbphrase['ladder_status_mf'];
			$game['u2'] = 'Unknown';
		}
	}
	elseif ($game['agree_u'] == 0 && $game['agree_u2'] == 0)
	{
		$game['status'] = $vbphrase[tmnt_awaiting_scores] . ' <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now].'</a>!';
	}
	elseif ($game['agree_u'] == 0)
	{
		if ($is_u)
		{
			$game['status'] = $vbphrase['tmnt_awaiting_your_score'] . '. <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now] . '</a>!';
		}
		else
		{
			$game['status'] = $vbphrase['tmnt_awaiting_opponents_score'];
		}
	}
	elseif ($game['agree_u2'] == 0)
	{
		if ($is_u2)
		{
			$game['status'] = $vbphrase['tmnt_awaiting_your_score'] . '. <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now] . '</a>!';
		}
		else
		{
			$game['status'] = $vbphrase['tmnt_awaiting_opponents_score'];
		}
	}
	return $game;
}

// #############################################################################

function tmntrevurl($c, $order, $sort, $rawfilter, $type)
{
	global $vbphrase;
	$order = strtoupper($order);
	switch ($order)
	{
		case "ASC": 
			$order = "DESC";
			break;
		case "DESC": 
			$order = "ASC";
			break;
	}
	$url = '<a href="tournaments.php?' . ($c != 0 ? "c=$c&amp;" : "") . ($type ? "type=$type&amp;" : "") . 'order='.$order.'&amp;sort='.$sort . ($rawfilter ? "&amp;filter=$rawfilter" : "") . '"><img title="'.$vbphrase[reverse_sort_order].'" class="inlineimg" src="'.vB_Template_Runtime::fetchStyleVar('imgdir_button').'/sortarrow-'.strtolower($order).'.png" alt="'.$vbphrase[reverse_sort_order].'" border="0" /></a>';
	return $url;
}

// #############################################################################

function calc_winp($rating_diff)
{
	switch ($rating_diff)
	{
		case ($rating_diff <= 0):
			$winp = 0.5;
			return $winp;
			break;
		case ($rating_diff <= 25):
			$winp = 0.53;
			return $winp;
			break;
		case ($rating_diff <= 50):
			$winp = 0.57;
			return $winp;
			break;
		case ($rating_diff <= 100):
			$winp = 0.64;
			return $winp;
			break;
		case ($rating_diff <= 150):
			$winp = 0.70;
			return $winp;
			break;
		case ($rating_diff <= 200):
			$winp = 0.76;
			return $winp;
			break;
		case ($rating_diff <= 250):
			$winp = 0.81;
			return $winp;
			break;
		case ($rating_diff <= 300):
			$winp = 0.85;
			return $winp;
			break;
		case ($rating_diff <= 350):
			$winp = 0.89;
			return $winp;
			break;
		default:
			$winp = 0.92;
			return $winp;
			break;
	}
}

// #############################################################################

function get_se_ftt($p_array, $return_array = false, $query = false, $tid = 0)
{
	if ($query && $tid)
	{
		global $vbulletin;
		$cmpts = $vbulletin->db->query_read("
			SELECT players.*
			FROM " . TABLE_PREFIX . "tmnt_players AS players 
			WHERE tid = '$tid'
			ORDER BY slot ASC
		");
		while ($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			$p_array["$cmpt_count"] = $cmpt;
			$cmpt_count++;
		}
	}
	$trarray = array();
	$sthhash = 0;
	foreach ($p_array AS $nhash => $pinfo)
	{
		for ($i = 12; $i > 1; $i--)
		{
			if ($pinfo["round$i"]>0)
			{
				$trarray["$i"][] = $pinfo;
				if ($i > $sthhash)
				{
					$sthhash = $i;
				}
				break;
			}
		}
	}
	if (!$return_array)
	{
		$winners = array($trarray["$sthhash"]['0']['userid']);
		$sthhash--;
		$winners2nd = array($trarray["$sthhash"]['0']['userid']);
		$sthhash--;
		if ($trarray["$sthhash"]['0']['userid'])
		{
			$winners3rd = array($trarray["$sthhash"]['0']['userid']);
			if ($trarray["$sthhash"]['1']['userid'])
			{
				$winners3rd[] = $trarray["$sthhash"]['1']['userid'];
			}
		}
		else
		{
			$sthhash--;
			$winners3rd = array($trarray["$sthhash"]['0']['userid']);
		}
	}
	else
	{
		$winners = array($trarray["$sthhash"]['0']);
		$sthhash--;
		$winners2nd = array($trarray["$sthhash"]['0']);
		$sthhash--;
		if ($trarray["$sthhash"]['0'])
		{
			$winners3rd = array($trarray["$sthhash"]['0'],$trarray["$sthhash"]['1']);
		}
		else
		{
			$sthhash--;
			$winners3rd = array($trarray["$sthhash"]['0']);
		}
	}
	return(array($winners, $winners2nd, $winners3rd, null));
	
}

// #############################################################################

function tll_userhtml($userinfo, $team = 0, $ladder = 0)
{
	global $vbulletin, $vbphrase;
	($hook = vBulletinHook::fetch_hook('tll_userhtml_start')) ? eval($hook) : false;
	if ($ladder)
	{
		$vbulletin->options['tmnt_userhtml'] = $vbulletin->options['tmnt_ladder_userhtml'];
	}
	if (!$userinfo OR !is_array($userinfo))
	{
		return false;
	}
	if ($team)
	{
		if (!$userinfo['userid'])
		{
			$userinfo['userid'] = $userinfo['teamid'];
		}
		if (!$userinfo['username'])
		{
			$userinfo['username'] = $userinfo['teamname'];
		}
		$userinfo['usertext'] = '<a href="competitions.php?do=viewteam&amp;id='.$userinfo['userid'].'">' . $userinfo['username'] . '</a>';
	}
	else
	{
		$userinfo['usertext'] = '<a href="' . fetch_seo_url('member', $userinfo) . '">' . $userinfo['username'] . '</a>';
	}
	if ($vbulletin->options['tmnt_userhtml'])
	{
		$userhtml = preg_replace('|\{([a-zA-Z0-9_-]*)\}|e', ' $userinfo["$1"] ', $vbulletin->options['tmnt_userhtml']);
	}
	elseif (!$ladder)
	{
		$userhtml = $userinfo['usertext'];
	}
	$userhtml = '<span>'.$userhtml .'</span>';
	($hook = vBulletinHook::fetch_hook('tll_userhtml_end')) ? eval($hook) : false;
	return ($userhtml);
}

// #############################################################################

function process_tl_avatar($cmpt)
{
	global $vbulletin;
	if (!empty($cmpt['avatarpath']))
	{
		$cmpt['avatarurl'] = $cmpt['avatarpath'];
		$cmpt['avwidth'] = getimagesize($cmpt['avatarurl']);
		$cmpt['avwidth'] = $cmpt['avwidth']['0'];
		$avatarlp = $cmpt['avwidth'] + 30;
	}
	elseif ($cmpt['hascustom'])
	{
		$avatarurl = array('hascustom' => 1);
		if ($vbulletin->options['usefileavatar'])
		{
			$cmpt['avatarurl'] = $vbulletin->options['avatarurl'] . ($thumb ? '/thumbs' : '') . "/avatar{$cmpt['userid']}_{$cmpt['avatarrevision']}.gif";
			$avatarlp = $cmpt['avwidth'] + 30;
		}
		else
		{
			$cmpt['avatarurl'] = "image.php?u=$cmpt[userid]&amp;dateline=$cmpt[avatardateline]" . ($thumb ? '&type=thumb' : '') ;
			$avatarlp = $cmpt['avwidth'] + 30;
		}
	}
	if (empty($cmpt['avatarurl']))
	{
		$cmpt['avatarurl'] = vB_Template_Runtime::fetchStyleVar('imgdir_misc') . '/unknown.gif';
		if (file_exists($cmpt['avatarurl']))
		{
			$cmpt['avwidth'] = getimagesize($cmpt['avatarurl']);
			$cmpt['avwidth'] = $cmpt['avwidth']['0'];
		}
		else
		{
			$cmpt['avwidth'] = 60;
		}
		$avatarlp = $cmpt['avwidth'] + 30;
	}
	$cmpt['avatarlp'] = $avatarlp."px";
	return $cmpt;
}

// #############################################################################

function tmnt_dateline_to_fields($dateline, $utc, $dst)
{
	global $vbulletin, $vbphrase, $show;
	$serveroffset = date('Z', TIMENOW) / 3600;
	$dateline_user = $dateline + $offset * 3600;
	require_once(DIR . '/includes/functions_calendar.php');
	$date = explode('-', gmdate('n-j-Y', $dateline + $utc * 3600));
	$time = gmdate('g_i_A_H', $dateline + $utc * 3600);
	$time = explode('_', $time);
	if (strpos($vbulletin->options['timeformat'], 'H') !== false)
	{
		$show['24hour'] = true;
	}
	else
	{
		$show['24hour'] = false;
	}
	$user_time = fetch_time_options($time, $show['24hour']);
	if ($utc < 0)
	{
		$timezonesel['n' . (-$utc * 10)] = 'selected="selected"';
	}
	else
	{
		$index = $utc * 10;
		$timezonesel["$index"] = 'selected="selected"';
	}
	require_once(DIR . '/includes/functions_misc.php');
	$timezoneoptions = '';
	foreach (fetch_timezone() AS $optionvalue => $timezonephrase)
	{
		$optiontitle = $vbphrase["$timezonephrase"];
		$optionselected = ($optionvalue == $utc ? 'selected="selected"' : '');
		$timezoneoptions .= render_option_template($optiontitle, $optionvalue, $optionselected, $optionclass);
	}
	if (($pos = strpos($vbulletin->options['timeformat'], 'H')) !== false)
	{
		$show['24hour'] = true;
		$time[3] = intval($time[3]);
		$hourselected["$time[3]"] = 'selected="selected"';
		$minuteselected["$time[1]"] = 'selected="selected"';
	}
	else
	{
		$show['24hour'] = false;
		$hourselected["$time[0]"] = 'selected="selected"';
		$minuteselected["$time[1]"] = 'selected="selected"';
		$ampmselected["$time[2]"] = 'selected="selected"';
	}
	$day = $date[1];
	$monthselected["$date[0]"] = 'selected="selected"';
	$yearselected["$date[2]"] = 'selected="selected"';
	$yearbits = '';
	for ($gyear = 2005; $gyear <= 2015; $gyear++)
	{
		$yearbits .= "\t\t<option value=\"$gyear\" $yearselected[$gyear]>$gyear</option>";
	}
	$dstchecked = $dst ? 'checked="checked"' : '';
	return array($timezoneoptions, $day, $monthselected, $yearbits, $user_time, $dstchecked, $show);
}

// #############################################################################

function tmnt_fields_to_dateline($time, $date, $utc, $dst, $type = range)
{
	global $vbulletin;
	if (!checkdate($date['month'], $date['day'], $date['year'])
				OR ($type != 'single' AND !checkdate($date['month'], $date['day'], $date['year'])))
	{
		return('Error: Bad Date');
	}
	// extract the relevant info from time
	$time_re = '#^(0?[1-9]|1[012])\s*[:.]\s*([0-5]\d)(\s*[AP]M)?|([01]\d|2[0-3])\s*[:.]\s*([0-5]\d)$#i';
	// preg match text in field for a valid time
	if (preg_match($time_re, $time, $matches))
	{
		if (count($matches) == 3)
		{
			$hour = intval($matches[1]);
			$minute = intval($matches[2]);
			$ampm = $matches[1] == '12' ? 'PM' : 'AM';
		}
		else if (count($matches) == 4)
		{
			$hour = intval($matches[1]);
			$minute = intval($matches[2]);
			$ampm = strtoupper(trim($matches[3]));
		}
		else // 24hr time
		{
			$hour = intval($matches[4]);
			$minute = intval($matches[5]);
			$ampm = ($hour <= 11) ? 'AM' : 'PM';
		}
	}
	if (($pos = strpos($vbulletin->options['timeformat'], 'H')) === false)
	{
		if ($ampm == 'PM')
		{
			if ($hour >= 1 AND $to_hour <= 11)
			{
				$hour += 12;
			}
		}
		else
		{
			if ($hour == 12)
			{
				$hour = 0;
			}
		}
	}
	$min_offset = $utc - intval($utc);
	$to_hour   -= intval($utc);
	$to_minute -= intval($min_offset * 60);
	$dateline = gmmktime($hour, $minute, 0, $date['month'], $date['day'], $date['year']);
	return $dateline;
}

// #############################################################################

function rr_get_rounds($tmnt)
{
	global $vbphrase;
	switch ($tmnt['noplayers'])
	{
		case 1:
		case 2:
		case 3:
		case 4:
			$tmnt['rounds'] = 3;
			break;
		case 5:
		case 6:
			$tmnt['rounds'] = 5;
			break;
		case 7:
		case 8:
			$tmnt['rounds'] = 7;
			break;
		case 9:
		case 10:
			$tmnt['rounds'] = 9;
			break;
		case 11:
		case 12:
			$tmnt['rounds'] = 11;
			break;
		case 13:
		case 14:
			$tmnt['rounds'] = 13;
			break;
		case 15:
		case 16:
			$tmnt['rounds'] = 15;
			break;
		case 17:
		case 18:
			$tmnt['rounds'] = 17;
			break;
	}
	if ($tmnt['type'] == 'drr' OR $tmnt['type'] == $vbphrase['tmnt_drr'])
	{
		$tmnt['rounds'] = $tmnt['rounds'] * 2;
	}
	return $tmnt;
}

// #############################################################################

function fetch_drr_database($noplayers)
{
	$database = $rr_database = fetch_rr_database($noplayers);
	$rr_count = count($rr_database);
	foreach ($rr_database AS $r => $sarray)
	{
		$n_r  = substr($r, 1) + $rr_count;
		$n_sarray = array();
		foreach ($sarray AS $ni => $d)
		{
			$d = explode('v', $d);
			$n_sarray[] = $d[1].'v'.$d[0];
		}
		$database['r'.$n_r] = $n_sarray;
	}
	return $database;
}

// #############################################################################

function fetch_rr_database($noplayers)
{
	if ($noplayers <= 4)
	{
		$database = array(
			'r1' => array('02v01','03v04'),
			'r2' => array('04v02','01v03'),
			'r3' => array('04v01','02v03')
		);
	}
	else if ($noplayers <= 6)
	{
		$database = array(
			'r1' => array('02v01','03v06','04v05'),
			'r2' => array('03v04','06v01','02v05'),
			'r3' => array('06v04','02v03','01v05'),
			'r4' => array('04v01','05v03','06v02'),
			'r5' => array('01v03','04v02','05v06')
		);
	}
	else if ($noplayers <= 8)
	{
		$database = array(
			'r1' => array('02v01','03v08','04v07','05v06'),
			'r2' => array('03v04','01v07','08v06','02v05'),
			'r3' => array('06v02','07v08','04v01','05v03'),
			'r4' => array('07v05','08v04','02v03','06v01'),
			'r5' => array('01v03','04v02','05v08','06v07'),
			'r6' => array('04v05','08v01','02v07','03v06'),
			'r7' => array('07v03','08v02','01v05','06v04')
		);
	}
	else if ($noplayers <= 10)
	{
		$database = array(
			'r1' => array('02v01','03v10','04v09','05v08', '06v07'),
			'r2' => array('02v03','01v07','08v06','09v05', '10v04'),
			'r3' => array('06v09','07v08','03v01','04v02', '05v10'),
			'r4' => array('10v06','02v05','03v04','01v08', '09v07'),
			'r5' => array('05v03','06v02','07v10','08v09', '04v01'),
			'r6' => array('01v09','10v08','02v07','03v06', '04v05'),
			'r7' => array('05v01','06v04','07v03','08v02', '09v10'),
			'r8' => array('05v06','01v10','02v09','03v08', '04v07'),
			'r9' => array('09v03','10v02','06v01','07v05', '08v04')
		);
	}
	else if ($noplayers <= 12)
	{
		$database = array(
			'r1' => array('02v01','03v12','04v11','05v10', '06v09', '07v08'),
			'r2' => array('12v02','01v07','08v06','09v05', '10v04', '11v03'),
			'r3' => array('05v08','06v07','12v01','02v11', '03v10', '04v09'),
			'r4' => array('08v02','09v12','10v11','01v05', '06v04', '07v03'),
			'r5' => array('12v08','02v07','03v06','04v05', '10v01', '11v09'),
			'r6' => array('04v02','05v12','06v11','07v10', '08v09', '01v03'),
			'r7' => array('08v01','09v07','10v06','11v05', '12v04', '02v03'),
			'r8' => array('11v12','06v01','07v05','08v01', '09v03', '10v02'),
			'r9' => array('04v07','05v06','01v11','12v10', '02v09', '03v08'),
			'r10' => array('07v12','08v11','09v10','04v01', '05v03', '06v02'),
			'r11' => array('11v07','12v06','02v05','03v04', '01v09', '10v08')
		);
	}
	else if ($noplayers <= 14)
	{
		$database = array(
			'r1' => array('01v02','07v09','08v14','06v10', '03v13', '05v11', '04v12'),
			'r2' => array('08v09','01v03','07v10','02v14', '06v11', '04v13', '05v12'),
			'r3' => array('02v03','08v10','01v04','07v11', '09v14', '06v12', '05v13'),
			'r4' => array('09v10','02v04','08v11','01v05', '07v12', '03v14', '06v13'),
			'r5' => array('03v04','09v11','02v05','08v12', '01v06', '07v13', '10v14'),
			'r6' => array('10v11','03v05','09v12','02v06', '08v13', '01v07', '04v14'),
			'r7' => array('04v05','10v12','03v06','09v13', '02v07', '11v14', '01v08'),
			'r8' => array('11v12','04v06','10v13','03v07', '05v14', '02v08', '01v09'),
			'r9' => array('05v06','11v13','04v07','12v14', '03v08', '01v10', '02v09'),
			'r10' => array('12v13','05v07','06v14','04v08', '01v11', '03v09', '02v10'),
			'r11' => array('06v07','13v14','05v08','01v12', '04v09', '02v11', '03v10'),
			'r12' => array('07v14','06v08','01v13','05v09', '02v12', '04v10', '03v11'),
			'r13' => array('07v08','01v14','06v09','02v13', '05v10', '03v12', '04v11')
		);
	}
	else if ($noplayers <= 16)
	{
		$database = array(
			'r1' => array('01v02','08v10','09v16','07v11', '03v15', '06v12', '04v14', '05v13'),
			'r2' => array('09v10','01v03','08v11','02v16', '07v12', '04v15', '06v13', '05v14'),
			'r3' => array('02v03','09v13','01v04','08v12', '10v16', '07v13', '05v15', '06v14'),
			'r4' => array('10v11','02v04','09v12','01v05', '08v13', '03v16', '07v14', '06v15'),
			'r5' => array('03v04','10v12','02v05','09v13', '01v06', '08v14', '11v16', '07v15'),
			'r6' => array('11v12','03v05','10v13','02v06', '09v14', '01v07', '08v15', '04v16'),
			'r7' => array('04v05','11v13','03v06','10v14', '02v07', '09v15', '01v08', '12v16'),
			'r8' => array('12v13','04v06','11v14','03v07', '10v15', '02v08', '05v16', '01v09'),
			'r9' => array('05v06','12v14','04v07','11v15', '03v08', '13v16', '02v09', '01v10'),
			'r10' => array('13v14','05v07','12v15','04v08', '06v16', '03v09', '01v11', '02v10'),
			'r11' => array('06v07','13v15','05v08','14v16', '04v09', '01v12', '03v10', '02v11'),
			'r12' => array('14v15','06v08','07v16','05v09', '01v13', '04v10', '02v12', '03v11'),
			'r13' => array('07v08','15v16','06v09','01v14', '05v10', '02v13', '04v11', '03v12'),
			'r14' => array('08v16','07v09','01v15','06v10', '02v14', '05v11', '03v13', '04v12'),
			'r15' => array('08v09','01v16','07v10','02v15', '06v11', '03v14', '05v12', '04v13')
		);
	}
	else if ($noplayers <= 18)
	{
		$database = array(
			'r1' => array('01v02','09v11','10v18','08v12', '03v17', '07v13', '04v16', '06v14', '05v15'),
			'r2' => array('10v11','01v03','09v12','02v18', '08v13', '04v17', '07v14', '05v16', '06v15'),
			'r3' => array('02v03','10v12','01v04','09v13', '11v18', '08v14', '05v17', '07v15', '06v16'),
			'r4' => array('11v12','02v04','10v13','01v05', '09v14', '03v18', '08v15', '06v17', '07v16'),
			'r5' => array('03v04','11v13','02v05','10v14', '01v06', '09v15', '12v18', '08v16', '07v17'),
			'r6' => array('12v13','03v05','11v14','02v06', '10v15', '01v07', '09v16', '04v18', '08v17'),
			'r7' => array('04v05','12v14','03v06','11v15', '02v07', '10v16', '01v08', '09v17', '13v08'),
			'r8' => array('13v14','04v06','12v15','03v07', '11v16', '02v08', '10v17', '01v09', '05v18'),
			'r9' => array('05v06','13v15','04v07','12v16', '03v08', '11v17', '02v09', '14v18', '01v10'),
			'r10' => array('14v15','05v07','13v16','04v08', '12v17', '03v09', '06v18', '02v10', '01v11'),
			'r11' => array('06v07','14v16','05v08','13v17', '04v09', '15v18', '03v10', '01v12', '02v11'),
			'r12' => array('15v16','06v08','14v17','05v09', '07v18', '04v10', '01v13', '03v11', '02v12'),
			'r13' => array('07v08','15v17','06v09','16v18', '05v10', '01v14', '04v11', '02v13', '03v12'),
			'r14' => array('16v17','07v09','08v18','06v10', '01v15', '05v11', '02v14', '04v12', '03v13'),
			'r15' => array('08v09','17v18','07v10','01v16', '06v11', '02v15', '05v12', '03v14', '04v13'),
			'r16' => array('09v18','08v10','01v17','07v11', '02v16', '06v12', '03v15', '05v13', '04v14'),
			'r17' => array('09v10','01v18','08v11','02v17', '07v12', '03v16', '06v13', '04v15', '05v14')
		);
	}
	else if ($noplayers <= 20)
	{
		//http://www.printyourbrackets.com/images/18teamroundrobinthumb%20copy.jpg
	}
	return $database;
}

// #############################################################################

function check_array_rr($number, $array, $noplayers)
{
	if (!in_array($number, $array))
	{//not in array
		return $number;
	}
	else
	{
		$x = 0;
		while ($x < 100)
		{
			$number++;
			if ($number > $noplayers)
			{ //too high
				$number = 1;
			}
			if (!in_array($number, $array))
			{
				return $number;
			}
			$x++;
		}
		return false;
	}
}

// #############################################################################

function calc_elo($rank_u, $rank_u2, $score_u, $score_u2, $player_u, $player_u2, $lid, $u, $u2)
{
	global $vbulletin;
	if (!$player_u)
	{
		$player_u = $vbulletin->db->query_first("SELECT rank, wstreak, longeststreak FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$lid' AND userid = '$u'");
	}
	if (!$rank_u)
	{
		$rank_u = $player_u['rank'];
	}
	if (!$player_u2)
	{
		$player_u2 = $vbulletin->db->query_first("SELECT rank, wstreak, longeststreak FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$lid' AND userid = '$u2'");
	}
	if (!$rank_u2)
	{
		$rank_u2 = $player_u2['rank'];
	}
	$k_value = $vbulletin->options['tmnt_kvalue']; //k-value
	$rating_diff = abs($rank_u - $rank_u2); //difference in scores
	if ($rank_u > $rank_u2)
	{//player u stronger
		$winp_u = calc_winp($rating_diff);
		$winp_u2 = 1 - $winp_u;
	}
	elseif ($rank_u2 > $rank_u)
	{//player u2 stronger
		$winp_u2 = calc_winp($rating_diff);
		$winp_u = 1 - $winp_u2;
	}
	else
	{
		$winp_u = $winp_u2 = 0.5;
	}
	//$rc = $k * ($r -);//rate change
	if ($score_u > $score_u2)
	{ 
		$r_u = 1;//player u wins
	}
	elseif ($score_u < $score_u2)
	{
		$r_u = 0;//player u loses
	}
	else
	{
		$r_u = 0.5;//draw
	}
	$r_u2 = 1 - $r_u;
	$newrank_u = max(round(($rank_u + ($k_value * ($r_u - $winp_u)))),1);
	$newrank_u2 = max(round(($rank_u2 + ($k_value * ($r_u2 - $winp_u2)))),1);
	if ($rank_u > $newrank_u)
	{
		$uod_u = -1;
	}
	else
	{
		$uod_u = 1;
	}
	if ($rank_u2 > $newrank_u2)
	{
		$uod_u2 = -1;
	}
	else
	{
		$uod_u2 = 1;
	}
	//$return = "new rank	$newrank_u, $newrank_u2, old rank $rank_u, $rank_u2, k $k_value, scores $score_u, $score_u2, r_u $r_u, $r_u2, winp $winp_u, $winp_u2, rating_diff $rating_diff";//debug
	$return = array($newrank_u, $newrank_u2, $uod_u, $uod_u2, $player_u, $player_u2);
	return($return);
}

// #############################################################################

function process_chal_options($this)
{
	$this['chal_options2'] = unserialize($this['chal_options']);
	if (!is_array($this['chal_options2']))
	{
		$this['chal_options2'] = array();
	}
	$this['chal_options'] = array();
	foreach ($this['chal_options2'] AS $key => $value)
	{
		$key = str_replace('_', ' ', $key);
		$this['chal_options']["$key"] = $value;
	}
	return $this;
}

// #############################################################################

function switch_agent($agent)
{
	switch ($agent['available_day'])
	{
		case 'everyday':
			$agent['available_day'] = "Everyday";
			break;
		case 'weekdays':
			$agent['available_day'] = "Weekdays";
			break;
		case 'weekends':
			$agent['available_day'] = "Weekends";
			break;
		case 'various':
			$agent['available_day'] = "Various Days";
			break;
	}
	switch ($agent['available_time'])
	{
		case 'anytime':
			$agent['available_time'] = "Anytime";
			break;
		case 'morning':
			$agent['available_time'] = "Mornings (8am-Noon)";
			break;
		case 'afternoon':
			$agent['available_time'] = "Afternoons (Noon-6pm)";
			break;
		case 'evening':
			$agent['available_time'] = "Evenings (6pm-11pm)";
			break;
		case 'allnight':
			$agent['available_time'] = "All Night (6pm-3am)";
			break;
		case 'latenight':
			$agent['available_time'] = "Late Night (11pm-5am)";
			break;
		case 'various':
			$agent['available_time'] = "Various Times";
			break;
	}
	switch($agent['reason'])
	{
		case 'social';
			$agent['reason'] = "Friends &amp; Fun";
			break;
		case 'compete';
			$agent['reason'] = "Competition &amp; Prestige";
			break;
		case 'money';
			$agent['reason'] = "Win Money";
			break;
	}
	return $agent;
}

// #############################################################################

function build_tll_catcache()
{
	global $vbulletin;
	$variable_array = $ctarray  = array();
	require_once(DIR . '/includes/class_bbcode.php');
	$query = $vbulletin->db->query_read(" 
		SELECT cats.*, COUNT(DISTINCT tmnts.id) AS counttmnts, COUNT(DISTINCT ladders.id) AS countladders, COUNT(DISTINCT leagues.id) AS countleagues, pcat.title AS categorytitle2, pcat.title AS parenttitle
		FROM " . TABLE_PREFIX . "tmnt_categories AS cats
		LEFT JOIN " . TABLE_PREFIX . "tmnt_categories AS pcat
			ON (cats.parentid = pcat.catid)
		LEFT OUTER JOIN " . TABLE_PREFIX . "tmnt_tmnts AS tmnts
			ON (cats.catid = tmnts.catid)
		LEFT OUTER JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (cats.catid = ladders.catid AND ladders.league = 0)
		LEFT OUTER JOIN " . TABLE_PREFIX . "tmnt_ladders AS leagues
			ON (cats.catid = leagues.catid AND leagues.league > 0)
		GROUP BY cats.catid
		ORDER BY cats.parentid DESC, cats.displayorder ASC, cats.title ASC
	"); 
	while ($variable = $vbulletin->db->fetch_array($query)) 
	{
		if ($variable['banner'])
		{
			$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
			$variable['parsed_banner'] = $bbcode_parser->do_parse($variable['banner']);
		}
		$variable['countladders'] += (int)$ctarray["$variable[catid]"]['lcount'];
		$variable['countleagues'] += (int)$ctarray["$variable[catid]"]['lgcount'];
		$variable['counttmnts'] += (int)$ctarray["$variable[catid]"]['tcount'];
		$variable_array["$variable[catid]"] = $variable; 
		$ctarray["$variable[parentid]"]['lcount'] += $variable['countladders'];
		$ctarray["$variable[parentid]"]['lgcount'] += $variable['countleagues'];
		$ctarray["$variable[parentid]"]['tcount'] += $variable['counttmnts'];
	}
	build_datastore('tll_catcache', serialize($variable_array), 1);  
}

// #############################################################################

if ($_REQUEST['do'] != 'addplayer')
{
	$a = 0;
	$annarray = array();
	$maxl = $vbulletin->options['tmnt_fp_ann_dml'];
	$anns = $vbulletin->db->query_read("SELECT id, title, announcement FROM " . TABLE_PREFIX . "tmnt_announcements ORDER BY id DESC LIMIT 0, 5");
	while($ann = $vbulletin->db->fetch_array($anns))
	{
		if ($a == 0)
		{
			$show['ann_id'] = $ann['id'];
			$show['ann_title'] = addslashes($ann['title']);
		}
		$a++;
		$show['linearr'] .= "line[$a]='" . addslashes($ann['title']) . "'\r\n";
		$show['linearr'] .= "id[$a]='" . $ann['id'] . "'\r\n";
		if (THIS_SCRIPT === 'competitions')
		{
			$ann['ann_short'] = remove_bbcode($ann['announcement']);
			if (strlen($ann['ann_short']) > $maxl)
			{
				$ann['url'] = "<a href=\"competitions.php?do=viewannouncement&amp;id=".$ann['id']."\">...</a>";
			}
			$ann['ann_short'] = substr($ann['ann_short'], 0, $maxl);
		}
		$annarray[] = $ann;
	}
	if ($a>0)
	{
		$show['scrolling_announcements'] = true;
	}
}

// #############################################################################

function fetch_ladder_mcs($mc_ids_array, $chllarray)
{
	global $vbulletin;
	if (!$mc_ids_array)
	{
		return($chllarray);
	}
	$mid = $vbulletin->input->clean_gpc('g', 'mid', TYPE_UINT);
	$mc_ids = implode(',', $mc_ids_array);
	// query match comments...
	$comments = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladder_mcs
		WHERE mid IN (".$mc_ids.")
		ORDER BY dateline ASC
	");
	while($comment = $vbulletin->db->fetch_array($comments))
	{
		if (!$comment['mid'])
		{
			continue;
		}
		if (!is_array($chllarray["$comment[mid]"]['mcs']))
		{
			$chllarray["$comment[mid]"]['mcs'] = array();
		}
		if ($comment['mid'] == $mid)
		{
			$chllarray["$comment[mid]"]['display'] = 'table-row';
		}
		// add match comments into chll array
		$chllarray["$comment[mid]"]['mcs'][] = $comment;
	}
	return($chllarray);
}

// #############################################################################

function fetch_myteams()
{
	global $vbulletin;
	$array = array();
	$query = $vbulletin->db->query_read("SELECT teamid FROM " . TABLE_PREFIX . "tmnt_members WHERE userid = '".$vbulletin->userinfo['userid']."' AND leader = 1");
	while($team = $vbulletin->db->fetch_array($query))
	{
		$array[] = $team['teamid'];
	}
	return $array;
}

// #############################################################################

?>