<?php
/*======================================================================*\
|| #################################################################### ||
|| # Copyright  BananaLive Scripts. All Rights Reserved. ############# ||
|| #################################################################### ||
\*======================================================================*/

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT', 'competitions');
if ($_REQUEST['do'] && in_array($_REQUEST['do'], array('addannouncement', 'editannouncement', 'editrules', 'addteam', 'editteam')))
{
define('GET_EDIT_TEMPLATES', true);
}
$phrasegroups = array('posting', 'postbit', 'user', 'timezone', 'global', 'pm', 'reputationlevel', 'search');
$specialtemplates = array(
	'bbcodecache',
	'smiliecache',
	'tll_catcache',
);
$globaltemplates = array(
	'editor_clientscript',
	'editor_css',
	'editor_jsoptions_font',
	'editor_jsoptions_size',
	'editor_smilie',
	'editor_smiliebox',
	'tmnt_editrules',
	'tmnt_freeagents',
	'tmnt_help',
	'tmnt_newfreeagent',
	'tmnt_freeagent',
	'tmnt_myteams',
	'editor_smiliebox_row',
	'tmnt_notmnts',
	'tmnt_ladder_noladders',
	'editor_smiliebox_straggler',
	'editor_toolbar_off',
	'tmnt_noteams',
	'editor_toolbar_on',
	'tmnt_ladder_list_rm',
	'tmnt_block_tmnts',
	'memberinfo_block_visitormessaging',
	'memberinfo_css',
	'memberinfo_usercss',
	'newpost_disablesmiliesoption',
	'tmnt_block_aboutteam',
	'tmnt_block_challenges',
	'tmnt_block_members',
	'tmnt_random_torp',
	'tmnt_bracket',
	'tmnt_cat',
	'tmnt_block_ladders',
	'tmnt_index_c',
	'tmnt_block_roster',
	'tmnt_index',
	'tmnt_teamlist',
	'tmnt_teamlist_bot',
	'tmnt_teamlist_top',
	'tmnt_team_won',
	'tmnt_ladder_edit',
	'tmnt_fpblock_anns',
	'tmnt_fpblock_comments',
	'tmnt_fpblock_twins',
	'im_aim',
	'im_msn',
	'im_skype',
	'im_yahoo',
	'postbit_onlinestatus',
	'tmnt_index_lbit',
	'tmnt_index_tbit',
	'tmnt_ladder_new',
	'tmnt_newteam',
	'tmnt_createteam',
	'tmnt_displayannouncement',
	'tmnt_displayrules',
	'tmnt_displayteam',
	'tmnt_team_join',
	'tmnt_editann',
	'tmnt_editplayer',
	'tmnt_editteam',
	'tmnt_letter',
	'tmnt_listann',
	'tmnt_listann_bot',
	'tmnt_listann_top',
	'tmnt_newannouncement',
	'tmnt_editcat',
	'tmnt_newplayer',
	'tmnt_noannouncements',
	'tmnt_playerstats',
	'tmnt_rules',
	'tmnt_shell',
	'tmnt_swapplayer',
	'tmnt_teammember',
	'tmnt_teammember_ddm',
	'tmnt_threadtemplate',
	'tmnt_nocategories',
	'tmnt_listcat_con',
	'tmnt_listcat',
	'tmnt_newcategory',
	'pm_newpm'
	);
$actiontemplates = array(
);

require_once('./global.php');
require_once(DIR . '/includes/functions.php');
require_once(DIR . '/includes/functions_tal.php');

$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'' => construct_phrase('Error')
	));
	$navbar = render_navbar_template($navbits);
	
// #############################################################################

if ($_REQUEST['do'] == 'killann')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_announcement];
        eval(standard_error($errormessage));
	}
    $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_announcements WHERE id=$id");
	$vbulletin->url = "competitions.php?do=announcements";
	eval(print_standard_redirect('redirect_killann'));
}

// #############################################################################

if ($_REQUEST['do'] == 'killcategory')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
    $catid = $vbulletin->input->clean_gpc('g', 'catid', TYPE_UINT);
	if (!$catid)
	{
		$errormessage = $vbphrase[error_invalid_category];
        eval(standard_error($errormessage));
	}
    $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_categories WHERE catid = '$catid' ");
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET catid = 0 WHERE catid = '$catid' ");
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET catid = 0 WHERE catid = '$catid' ");
	build_tll_catcache();
	$vbulletin->url = "competitions.php?do=categories";
	eval(print_standard_redirect('redirect_killcategory'));
}

// #############################################################################

if ($_REQUEST['do'] == 'killteam')
{
	if (!$tmntp['caneditteams'])
	{
		print_no_permission();
	}
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_team];
        eval(standard_error($errormessage));
	}
    $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid=$id");
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid=$id");
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET active = 0 WHERE userid=$id AND pot = 1");
	$vbulletin->url = "competitions.php?do=teams";
	eval(print_standard_redirect('redirect_killteam'));
}

// #############################################################################

if ($_REQUEST['do'] == 'killteamplayer')
{
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_player];
        eval(standard_error($errormessage));
	}
	$player = $vbulletin->db->query_first("SELECT teamid FROM " . TABLE_PREFIX . "tmnt_members WHERE id=$id ");
	$teamid = $player['teamid'];
	$userid = $thisuserid;
	$isleader = false;
	$member = $vbulletin->db->query_first("SELECT leader FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid='".$teamid."' AND userid='".$userid."'");
	if ($member['leader'] == 1)
	{
		$isleader = true;
	}
	if (!$tmntp['caneditteams'] AND !$isleader)
	{
		print_no_permission();
	}
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_members WHERE id=$id");
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_teams SET noplayers = noplayers-1 WHERE teamid=$teamid");
	$userinfo = fetch_userinfo($id);
	$tmnt_teams = array_delete(explode(",", $userinfo['tmnt_teams']), $teamid);
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_teams = '" . implode(',' , $tmnt_teams) . "' WHERE userid=$id");
	$vbulletin->url = "competitions.php?do=viewteam&id=".$teamid."&tab=members";
	eval(print_standard_redirect('redirect_killteamplayer'));
}

// #############################################################################

if ($_REQUEST['do'] == 'leaveteam')
{
    $id = $vbulletin->input->clean_gpc('g', 'teamid', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_team];
        eval(standard_error($errormessage));
	}
	$player = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE userid = '$thisuserid' AND teamid = '$id' ");
	if (!$player)
	{
		$errormessage = $vbphrase[error_invalid_team];
        eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_members WHERE id = '$player[id]' ");
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_teams SET noplayers = noplayers-1 WHERE teamid = '$player[teamid]' ");
	$tmnt_teams = array_delete($vbulletin->userinfo['tmnt_teams'], $teamid);
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_teams = '" . implode(',' , $tmnt_teams) . "' WHERE userid = '$thisuserid' ");
	$vbulletin->url = "competitions.php?do=viewteam&id=".$id;
	eval(print_standard_redirect('redirect_leaveteam'));
}

// #############################################################################

if ($_REQUEST['do'] == 'makeleader')
{
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id) 
	{
		$errormessage = $vbphrase[error_invalid_player];
        eval(standard_error($errormessage));
	}
	$player = $vbulletin->db->query_first("SELECT teamid FROM ". TABLE_PREFIX ."tmnt_members WHERE id=$id AND leader=0 ");
	$teamid = $player['teamid'];
	$userid = $thisuserid;
	$isleader = false;
	$member = $vbulletin->db->query_first("SELECT leader FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid=$teamid AND userid=$userid");
	if ($member['leader'] == 1)
	{
			$isleader = true;
	}
	if (!$tmntp['caneditteams'] AND !$isleader)
	{
		print_no_permission();
	}
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_members SET leader = 1 WHERE id=$id");
	$vbulletin->url = "competitions.php?do=viewteam&id=$teamid&tab=members";
	eval(print_standard_redirect('redirect_makeleader'));
}

// #############################################################################

if ($_REQUEST['do'] == 'makecoleader')
{
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_player];
        eval(standard_error($errormessage));
	}
	$player = $vbulletin->db->query_first("SELECT teamid FROM ". TABLE_PREFIX ."tmnt_members WHERE id=$id AND leader=0");
	$teamid = $player['teamid'];
	$userid = $thisuserid;
	$isleader = false;
	$member = $vbulletin->db->query_first("SELECT leader FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid=$teamid AND userid=$userid");
	if ($member['leader'] == 1)
	{
			$isleader = true;
	}
	if (!$tmntp['caneditteams'] AND !$isleader)
	{
		print_no_permission();
	}
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_members SET coleader = 1 WHERE id=$id");
	$vbulletin->url = "competitions.php?do=viewteam&id=$teamid&tab=members";
	eval(print_standard_redirect('redirect_makecoleader'));
}



// #############################################################################

if ($_POST['do'] == 'insertannouncement')
{
	if (!$tmntp['canedittmnt']) {
		print_no_permission();
	}
	$userid = $vbulletin->input->clean_gpc('p', 'userid', TYPE_UINT);
		if (!$userid) {
			$userid = $thisuserid;
		}
	$title = $vbulletin->input->clean_gpc('p', 'title', TYPE_STR);
		if (!$title) {
			$errormessage = $vbphrase[error_invalid_title];
			eval(standard_error($errormessage));
		}
	$vbulletin->input->clean_array_gpc('p', array(
		'message'      => TYPE_STR,
		'wysiwyg'			 => TYPE_BOOL,
	));
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$description = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$description = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$description = $vbulletin->GPC['message'];
	}
		if (!$description) {
			$errormessage = $vbphrase[error_invalid_message];
			eval(standard_error($errormessage));
		}
	$ip = $_SERVER['REMOTE_ADDR'];
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_announcements
		(title, announcement, userid, time, ip)
		VALUES ('".$vbulletin->db->escape_string($title)."', '".$vbulletin->db->escape_string($description)."', '".$vbulletin->db->escape_string($userid)."', ".TIMENOW.", '".$vbulletin->db->escape_string($ip)."')
		");
	$id = $vbulletin->db->insert_id();
	$vbulletin->url = "competitions.php?do=viewannouncement&id=".$id;	
	eval(print_standard_redirect('redirect_inserteann'));
}

// #############################################################################

if ($_REQUEST['do'] == 'addannouncement')
{
	if (!$tmntp['canedittmnt']) {
		print_no_permission();
	}
	require_once(DIR . '/includes/functions_editor.php');
	if  ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar('', 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar('');
	}
	$templater = vB_Template::create('tmnt_newannouncement');
	$templater->register('editorid', $editorid);
	$templater->register('messagearea', $messagearea);
	$templater->register('id', $id);
	$templater->register('tmntp', $tmntp);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'' => construct_phrase($vbphrase['tmnt_newannouncement'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'updateannouncement')
{
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
		if (!$id)
		{
			$errormessage = $vbphrase[error_invalid_announcement];
        	eval(standard_error($errormessage));
		}
	$tmnt = $vbulletin->db->query_first("SELECT userid FROM " . TABLE_PREFIX . "tmnt_tmnts WHERE id=$id ");
	if ($tmnt['userid'] != $thisuserid) {
	if (!$tmntp['canedittmnt']) {
		print_no_permission();
	} }
    $userid = $vbulletin->input->clean_gpc('p', 'userid', TYPE_UINT);
		if (!$userid) {
			$userid = $thisuserid;
		}
	$title = $vbulletin->input->clean_gpc('p', 'title', TYPE_STR);
		if (!$title) {
			$errormessage = $vbphrase[error_invalid_title];
        	eval(standard_error($errormessage));
		}
	$vbulletin->input->clean_array_gpc('p', array(
		'message'      => TYPE_STR,
		'wysiwyg'			 => TYPE_BOOL,
	));
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$description = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$description = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$description = $vbulletin->GPC['message'];
	}
	if (!$description) 
	{
		$errormessage = $vbphrase[error_invalid_message];
		eval(standard_error($errormessage));
	}
	$ip = $_SERVER['REMOTE_ADDR'];
	$show['edit'] = false;
	if (($permissions['genericoptions'] & $vbulletin->bf_ugp['genericoptions']['showeditedby']))
	{
		$show['edit'] = true;
	}
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_announcements SET title = '".$vbulletin->db->escape_string($title)."', announcement = '".$vbulletin->db->escape_string($description)."'" . ($show['edit'] ? ", le_userid = '".$userid."', le_time =".TIMENOW."" : "") . ", le_ip = '".$vbulletin->db->escape_string($ip)."' WHERE id=$id ");
	$vbulletin->url = "competitions.php?do=viewannouncement&id=".$id;	
	eval(print_standard_redirect('redirect_updateann'));
}

// #############################################################################

if ($_POST['do'] == 'updaterules')
{
	if (!$tmntp['canedittmnt']) {
		print_no_permission();
	}
    $userid = $vbulletin->input->clean_gpc('p', 'userid', TYPE_UINT);
		if (!$userid) {
			$userid = $thisuserid;
		}
	$vbulletin->input->clean_array_gpc('p', array(
		'message'      => TYPE_STR,
		'wysiwyg'			 => TYPE_BOOL,
	));
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414) 
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$description = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$description = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else 
	{
		$description = $vbulletin->GPC['message'];
	}
	$show['edit'] = false;
	if (($permissions['genericoptions'] & $vbulletin->bf_ugp['genericoptions']['showeditedby']))
	{
		$show['edit'] = true;
	}
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_rules SET rules = '".$vbulletin->db->escape_string($description)."'". ($show['edit'] ? ", le_userid = $userid, le_time =".TIMENOW."" : "") . " WHERE id=1 ");
	$vbulletin->url = "competitions.php?do=rules";	
	eval(print_standard_redirect('redirect_updaterules'));
}



// #############################################################################

if ($_REQUEST['do'] == 'editannouncement')
{
    if (!$tmntp['canedittmnt']) {
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id) {
		$errormessage = $vbphrase[error_invalid_announcement];
        eval(standard_error($errormessage));
	}
	$ann = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_announcements WHERE id=$id");
	$title       = $ann['title'];
	$description = $ann['announcement'];
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar($description, 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar($description);
	}
	$templater = vB_Template::create('tmnt_editann');
	$templater->register('editorid', $editorid);
	$templater->register('messagearea', $messagearea);
	$templater->register('ann', $ann);
	$templater->register('title', $title);
	$templater->register('description', $description);
	$templater->register('id', $id);
	$templater->register('tmntp', $tmntp);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'competitions.php?do=announcements' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['announcements'],
		'competitions.php?do=viewannouncement&amp;id=' . $id . $vbulletin->session->vars['sessionurl_q'] => $title,
		'' => construct_phrase($vbphrase[tmnt_editann])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'editrules')
{
    if (!$tmntp['canedittmnt']) {
		print_no_permission();
	}
	$query_rules = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_rules WHERE id=1");
	$rules = $query_rules['rules'];
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar($rules, 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar($rules);
	}
	$templater = vB_Template::create('tmnt_editrules');
	$templater->register('rules', $rules);
	$templater->register('editorid', $editorid);
	$templater->register('messagearea', $messagearea);
	$templater->register('tmntp', $tmntp);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'competitions.php?do=rules' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tmnt_rules'],
		'' => construct_phrase($vbphrase[tmnt_editrules])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}



// #############################################################################

if ($_REQUEST['do'] == 'announcements') 
{
	$templater = vB_Template::create('tmnt_listann_top');
	$tlhtml .= $templater->render();
	$anns = $vbulletin->db->query_read("
		SELECT ann.*, user.username, user.usertitle
		FROM " . TABLE_PREFIX . "tmnt_announcements AS ann
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON ann.userid = user.userid
		ORDER BY ann.id DESC
	");
	$user_lastvisit = $vbulletin->userinfo['lastvisit'];
	$rowcount = 0;
	while($ann = $vbulletin->db->fetch_array($anns))
	{
		$new = false;
		if ($ann['time'] >= $user_lastvisit) {
			$new = true;
		}
		$ann['date']      = vbdate($vbulletin->options['dateformat'], $ann['time'], 1);
		$ann['time']      = vbdate($vbulletin->options['timeformat'], $ann['time']);
		$templater = vB_Template::create('tmnt_listann');
		$templater->register('ann', $ann);
		$templater->register('new', $new);
		$templater->register('tmntp', $tmntp);
		$tlhtml .= $templater->render();
		$rowcount++;
	}
	if ($rowcount == 0) {
		$templater = vB_Template::create('tmnt_noannouncements');
		$tlhtml .= $templater->render();
	}
	$templater = vB_Template::create('tmnt_listann_bot');
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'' => construct_phrase($vbphrase['announcements'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'rebuildcaches')
{
	build_tll_catcache();
	$errormessage = 'Rebuilt Competitions Caches';
	eval(standard_error($errormessage));
}

// #############################################################################

if ($_REQUEST['do'] == 'playerstats')
{	
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$u = $vbulletin->input->clean_gpc('g', 'u', TYPE_UINT);
	$userid = $vbulletin->input->clean_gpc('g', 'userid', TYPE_UINT);
	if (!$id AND $u) {
		$id = $u;
	} elseif (!$id AND $userid) {
		$id = $userid;
	} if (!$id) {
		$errormessage = $vbphrase[error_no_userid];
		eval(standard_error($errormessage));
	}
	$counttmnt = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_players WHERE userid='$id'");
	$counttmnt = $counttmnt['countrows'];  
	$countwins = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_players WHERE userid=$id AND winner='1'");
	$countwins = $countwins['countrows'];
	$userdetail = $vbulletin->db->query_first("SELECT usergroupid, username, usertitle FROM " . TABLE_PREFIX . "user WHERE userid=$id");
		$username  = $userdetail['username'];
		$usertitle = $userdetail['usertitle'];
		$usergroup = $userdetail['usergroupid'];
	if (!$username)
	{
		$errormessage = $vbphrase[error_no_userid];
		eval(standard_error($errormessage));
	}
	$templater = vB_Template::create('tmnt_playerstats');
	$templater->register('username', $username);
	$templater->register('usertitle', $usertitle);
	$templater->register('usergroup', $usergroup);
	$templater->register('counttmnt', $counttmnt);
	$templater->register('countwins', $countwins);
	$templater->register('userdetail', $userdetail);
	$templater->register('id', $id);
	$templater->register('userid', $userid);
	$templater->register('tmntp', $tmntp);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'' => construct_phrase($vbphrase['tmnt_xs_stats'], $username)
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'rules')
{
	require_once(DIR . '/includes/class_bbcode.php');
	$query_rules = $vbulletin->db->query_first("
		SELECT rules.*, user.username AS le_username
		FROM " . TABLE_PREFIX . "tmnt_rules AS rules
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON rules.le_userid = user.userid
	");
	$rules       = $query_rules['rules'];
	$le_userid   = $query_rules['le_userid'];
	$le_username = $query_rules['le_username'];
	$le_time     = vbdate($vbulletin->options['dateformat'],$query_rules['le_time'], 1).$vbphrase['tmnt_at'].vbdate($vbulletin->options['timeformat'],$query_rules['le_time']);
	$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
	$rules = $bbcode_parser->do_parse($rules,false,true,true,true,true,false);
	$templater = vB_Template::create('tmnt_displayrules');
	$templater->register('rules', $rules);
	$templater->register('tmntp', $tmntp);
	$templater->register('le_userid', $le_userid);
	$templater->register('le_username', $le_username);
	$templater->register('le_time', $le_time);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'' => construct_phrase($vbphrase['tmnt_rules'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'help')
{
	require_once(DIR . '/includes/class_bbcode.php');
	if (!in_array($_REQUEST['sh'], array(1,2,3)))
	{
		$sh = 1;
	}
	else
	{
		$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_UINT);
	}
	$templater = vB_Template::create('tmnt_help');
		$templater->register('tmntp', $tmntp);
		$templater->register('sh', $sh);
		$templater->register('show', $show);
	$tlhtml = $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'' => construct_phrase($vbphrase['tmnt_help'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}


// #############################################################################

if ($_REQUEST['do'] == 'addteam')
{
	if (!$tmntp['cancreateteam'])
	{
		print_no_permission();
	}
	$count = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_teams WHERE userid='".$thisuserid."' ");
	$counts = $count['countrows'];
	if ($counts < $permissions['maxteams'])
	{
		require_once(DIR . '/includes/functions_editor.php');
		if ($vbulletin->options['simpleversion'] < 414)
		{
			$editorid = construct_edit_toolbar('', 0, 'nonforum', $vbulletin->options['privallowsmilies'], 1, 0, 'qr');
		}
		else
		{
			$editorid = construct_edit_toolbar('');
		}
		$templater = vB_Template::create('tmnt_newteam');
		$templater->register('rules', $rules);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
		$templater->register('tmntp', $tmntp);
		$tlhtml .= $templater->render();
		$navbits = construct_navbits(array(
			'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
			'competitions.php?do=teams' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tmnt_teamlist'],
			'' => construct_phrase($vbphrase['tmnt_createteam'])
		));
		$navbar = render_navbar_template($navbits);
		$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
		print_output($templater->render());
	} else {
		$errormessage = construct_phrase($vbphrase['error_team_limit'], $permissions['maxteams']);
		eval(standard_error($errormessage));
	}
}

// #############################################################################

if ($_POST['do'] == 'insertteam')
{
	if (!$tmntp['cancreateteam']) {
		print_no_permission();
	}
	$userinfo = $vbulletin->userinfo;
	$userid = $vbulletin->input->clean_gpc('p', 'userid', TYPE_UINT);
		if (!$userid) {
			$userid = $thisuserid;
		}
	$title = $vbulletin->input->clean_gpc('p', 'title', TYPE_NOHTML);
		if (!$title)
		{
			$errormessage = $vbphrase['error_invalid_teamname'];
       		eval(standard_error($errormessage));
		}
		$counttitle = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamname = '".$vbulletin->db->escape_string($title)."'");
		$counttitle = $counttitle['countrows'];
		if ($counttitle != 0)
		{
			$errormessage = $vbphrase[error_teamname_already_used];
       		eval(standard_error($errormessage));
		}
	if (strlen($title) < 4)
	{
		$errormessage = $vbphrase['error_teamname_short'];
       	eval(standard_error($errormessage));
	}
	$tag = $vbulletin->input->clean_gpc('p', 'tag', TYPE_NOHTML);
	$slogan = $vbulletin->input->clean_gpc('p', 'slogan', TYPE_NOHTML);
	$vbulletin->input->clean_array_gpc('p', array(
		'message'      => TYPE_STR,
		'wysiwyg'	   => TYPE_BOOL,
	));
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$description = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$description = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$description = $vbulletin->GPC['message'];
	}
	$ip = $_SERVER['REMOTE_ADDR'];
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_teams
		(teamname, description, userid, time, ip, noplayers, slogan, tag)
		VALUES ('".$vbulletin->db->escape_string($title)."', '".$vbulletin->db->escape_string($description)."', '".$userid."', ".TIMENOW.", '".$vbulletin->db->escape_string($ip)."', '1', '".$vbulletin->db->escape_string($slogan)."', '".$vbulletin->db->escape_string($tag)."')
		");
	$id = $vbulletin->db->insert_id();
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_members
		(userid, teamid, time, ip, leader, accepted)
		VALUES ('".$userid."', '".$id."', ".TIMENOW.", '".$vbulletin->db->escape_string($ip)."', '1', '1')
		");
	$vbulletin->url = "competitions.php?do=viewteam&id=".$id;	
	eval(print_standard_redirect('redirect_insertteam'));
}

// #############################################################################

if ($_REQUEST['do'] == 'teams')
{
	require_once(DIR . '/includes/functions_misc.php');
	$show['myteams'] = $vbulletin->input->clean_gpc('g', 'myteams', TYPE_UINT);
	$searchstart = microtime();
	$sort = $vbulletin->input->clean_gpc('g', 'sort', TYPE_STR);
	$allsorts = array('teamname', 'members', 'wins', 'joins', 'views');
	if (in_array($sort, $allsorts)) {
		if ($sort == 'teamname') {
			$sorts = "ORDER BY teamname";
		} elseif ($sort == 'members') {
			$sorts = "ORDER BY noplayers";
		} elseif ($sort == 'wins') {
			$sorts = "ORDER BY wins";
		} elseif ($sort == 'joins') {
			$sorts = "ORDER BY joins";
		} elseif ($sort == 'views') {
			$sorts = "ORDER BY views";
		}
	} else {
		$sort = 'teamname';
		$sorts = "ORDER BY teamname";
	}
	$order = $vbulletin->input->clean_gpc('g', 'order', TYPE_STR);
	$allorders = array('ASC', 'DESC');
	function teamrevurl($order, $sort)
	{
		global $vbphrase;
		switch ($order)
		{
			case "ASC": 
				$order = "DESC";
				break;
			case "DESC": 
				$order = "ASC";
				break;
		}
		$url = '<a href="competitions.php?do=teams&amp;order='.$order.'&amp;sort='.$sort.'"><img title="'.$vbphrase[reverse_sort_order].'" class="inlineimg" src="'.vB_Template_Runtime::fetchStyleVar('imgdir_button').'/sortarrow-'.strtolower($order).'.png" alt="'.$vbphrase[reverse_sort_order].'" border="0" /></a>';
		return $url;
	}
	if (!in_array($order, $allorders))
	{
		$order = 'ASC';
	}
	$reverse = teamrevurl($order, $sort);
	$ltr = $vbulletin->input->clean_gpc('g', 'ltr', TYPE_NOHTML);
	if ($ltr) {
		if ($ltr == '#') {
			$condition = "WHERE teamname NOT REGEXP(\"^[a-zA-Z]\")";
		} else {
			$ltr = chr(intval(ord($ltr)));
			$condition = "WHERE teamname LIKE(\"" . $vbulletin->db->escape_string_like($ltr) . "%\")";
		}
	}
	if ($show['myteams'])
	{
		$condition .= ($condition ? " AND " : " WHERE ") . " userid = '" . $vbulletin->userinfo['userid'] . "'";
	}
	$perpage = $vbulletin->input->clean_gpc('g', 'pp', TYPE_UINT);
	if ($perpage == 0) {
		$perpage = 30;
	}
	$countteams = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_teams $condition");
	$noofteams = $countteams['countrows'];
	$lastpage = ceil($noofteams/$perpage);
	$page = $vbulletin->input->clean_gpc('g', 'page', TYPE_UINT);
	if ($page > $lastpage) {
		$page = $lastpage;
	}
	if (!$page OR $page == 0) {
		$page = 1;
	}
	$offset = ($page - 1) * $perpage;
	$from = $offset + 1;
	if ($lastpage == $page) {
		$to = $noofteams;
	} else {
		$to = $page * $perpage;
	}
	if ($noofteams == 0) {
		$from = 0;
		$to = 0;
	}
	$selectedletter =& $ltr;
	$currentletter = '#';
	$linkletter = urlencode('#');
	$show['selectedletter'] = $selectedletter == '#' ? true : false;
	$templater = vB_Template::create('tmnt_letter');
		$templater->register('linkletter', $linkletter);
		$templater->register('currentletter', $currentletter);
		$templater->register('selectedletter', $selectedletter);
		$templater->register('perpage', $perpage);
		$templater->register('sort', $sort);
		$templater->register('order', $order);
	$letterbits = $templater->render();
	for ($i=65; $i < 91; $i++)
	{
		$currentletter = chr($i);
		$linkletter =& $currentletter;
		$show['selectedletter'] = $selectedletter == $currentletter ? true : false;
		$templater = vB_Template::create('tmnt_letter');
		$templater->register('linkletter', $linkletter);
		$templater->register('currentletter', $currentletter);
		$templater->register('selectedletter', $selectedletter);
		$templater->register('perpage', $perpage);
		$templater->register('sort', $sort);
		$templater->register('order', $order);
		$letterbits .= $templater->render();
	}
	
	$rowcount = 0;
	$teams = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams $condition $sorts $order LIMIT $offset, $perpage");
	while($team = $vbulletin->db->fetch_array($teams))
	{
        $description = preg_replace('/\[(.*?)\]/is', '', $team['description']);
		$descriptionlength = strlen($description);
		if ($descriptionlength > $vbulletin->options['tmnt_desclength'])
		{
			$description = substr($description, 0, $vbulletin->options['tmnt_desclength']);
			$description = $description . '...';
		}
		$templater = vB_Template::create('tmnt_teamlist');
			$templater->register('tmntp', $tmntp);
			$templater->register('description', $description);
			$templater->register('team', $team);
		$teamlist .= $templater->render();
		$rowcount ++;
	}
	$pagenav = construct_page_nav($page, $perpage, $noofteams, "competitions.php?" . $vbulletin->session->vars['sessionurl'] . "do=teams", "" . ($perpage ? "&amp;pp=$perpage" : ""));
	$searchtime = vb_number_format(fetch_microtime_difference($searchstart), 2);
	$headinclude .= "\r\n<link rel=\"stylesheet\" type=\"text/css\" href=\"css.php?d=" . TIMENOW . "&amp;td=" . vB_Template_Runtime::fetchStyleVar('textdirection') . "&amp;styleid=" . $vbulletin->userinfo['styleid'] . "&amp;sheet=memberlist.css\" />";
	$templater = vB_Template::create('tmnt_teamlist_top');
		$templater->register('from', $from);
		$templater->register('to', $to);
		$templater->register('pagenav', $pagenav);
		$templater->register('noofteams', $noofteams);
		$templater->register('reverse', $reverse);
		$templater->register('sort', $sort);
		$templater->register('searchtime', $searchtime);
		$templater->register('letterbits', $letterbits);
	$tlhtml .= $templater->render();
	$tlhtml = $tlhtml . $teamlist;
	if ($rowcount == 0)
	{
		$templater = vB_Template::create('tmnt_noteams');
		$templater->register('ltr', $ltr);
		$tlhtml .= $templater->render();
	}
	$templater = vB_Template::create('tmnt_teamlist_bot');
	$templater->register('from', $from);
	$templater->register('to', $to);
	$templater->register('noofteams', $noofteams);
	$templater->register('pagenav', $pagenav);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname
	);
	if ($show['myteams'])
	{
		$navbits[''] = construct_phrase($vbphrase['tmnt_myteamlist']);
	}
	else
	{
		$navbits[''] = construct_phrase($vbphrase['tmnt_teamlist']);
	}
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'myteams')
{
	$t_array = array();
	$teams = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_teams AS t
		LEFT JOIN " . TABLE_PREFIX . "tmnt_members AS m
			ON (t.teamid = m.teamid)
		WHERE m.userid = '$thisuserid'
	");
	while($team = $vbulletin->db->fetch_array($teams))
	{
		$t_array[] = $team;
	}
	$templater = vB_Template::create('tmnt_myteams');
		$templater->register('tmntp', $tmntp);
		$templater->register('t_array', $t_array);
	$tlhtml .= $templater->render();	
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname
	);
	$navbits[''] = construct_phrase($vbphrase['tmnt_myteamlist']);
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'freeagents')
{
	$count = $vbulletin->db->query_first("
		SELECT COUNT(*) AS countrows
		FROM " . TABLE_PREFIX . "tmnt_members
		WHERE userid = '".$vbulletin->userinfo['userid']."'
	");
	$rowcount = 0;
	$agent_array = array();
	$agents = $vbulletin->db->query_read("
		SELECT members.*, user.username, user.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight, user.username AS username
		FROM " . TABLE_PREFIX . "tmnt_members AS members
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (members.userid = user.userid) 
		LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar
			ON (avatar.avatarid = user.avatarid)
		LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar 
			ON (customavatar.userid = user.userid) 
		WHERE teamid = '0'
	");
	while($agent = $vbulletin->db->fetch_array($agents))
	{
		if (!empty($agent['avatarpath']))
		{
			$agent['avatarurl'] = $agent['avatarpath'];
			$agent['avwidth'] = getimagesize($agent['avatarurl']);
			$agent['avwidth'] = $agent['avwidth']['0'];
			$avatarlp = $agent['avwidth'] + 30;
		}
		elseif ($agent['hascustom'])
		{
			$avatarurl = array('hascustom' => 1);
			if ($vbulletin->options['usefileavatar'])
			{
				$agent['avatarurl'] = $vbulletin->options['avatarurl'] . ($thumb ? '/thumbs' : '') . "/avatar{$agent['userid']}_{$agent['avatarrevision']}.gif";
				$avatarlp = $agent['avwidth'] + 30;
			}
			else
			{
				$agent['avatarurl'] = "image.php?u=$agent[userid]&amp;dateline=$agent[avatardateline]" . ($thumb ? '&type=thumb' : '') ;
				$avatarlp = $agent['avwidth'] + 30;
			}
		}
		if (empty($agent['avatarurl']))
		{
				$agent['avatarurl'] = vB_Template_Runtime::fetchStyleVar('imgdir_misc') . '/unknown.gif';
				if (file_exists($agent['avatarurl']))
				{
					$agent['avwidth'] = getimagesize($agent['avatarurl']);
					$agent['avwidth'] = $agent['avwidth']['0'];
				}
				else
				{
					$agent['avwidth'] = 60;
				}
				$avatarlp = $agent['avwidth'] + 30;
		}
		$avatarlp = $avatarlp."px";
		$agent = switch_agent($agent);
		$agent_array[] = $agent;
		$rowcount++;
	}
	$templater = vB_Template::create('tmnt_freeagents');
		$templater->register('tmntp', $tmntp);
		$templater->register('agents', $agent_array);
		$templater->register('rowcount', $rowcount);
		$templater->register('count', $count);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'' => construct_phrase($vbphrase['tmnt_freeagents'])
	);
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'freeagent')
{
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$rowcount = 0;
	$agent_array = array();
	$agent = $vbulletin->db->query_first("
		SELECT members.*, user.username AS username, members.userid AS userid
		FROM " . TABLE_PREFIX . "tmnt_members AS members
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (members.userid = user.userid) 
		WHERE teamid = '0' AND id = '$id'
	");
	if (!$agent)
	{
		print_no_permission();
	}
	$agent = switch_agent($agent);
	$agent['invites'] = explode(",", $agent['invites']);
	if ($vbulletin->userinfo['userid'] == $agent['userid'] && $agent['invites'])
	{
		$agent['invites'] = implode(",", $agent['invites']);
		if (substr(trim($agent['invites']), 0, 1) == ',')
		{
			$agent['invites'] = trim(substr($agent['invites'], 1));
		}
		if ($agent['invites'])
		{
			$teams = $vbulletin->db->query_read("
				SELECT *
				FROM " . TABLE_PREFIX . "tmnt_teams
				WHERE teamid IN (" . $agent['invites'] . ")
			");
			while($teamm = $vbulletin->db->fetch_array($teams))
			{
				$userteams[] = $teamm;
			}
		}
		$agent['invites'] = explode(",", $agent['invites']);
	}
	else if ($vbulletin->userinfo['userid'] != $agent['userid'])
	{
		// start free agents current teams
		$teamids = array();
		$teams = $vbulletin->db->query_read("
			SELECT teamid
			FROM " . TABLE_PREFIX . "tmnt_members
			WHERE userid = '".$agent['userid']."'
		");
		while($team = $vbulletin->db->fetch_array($teams))
		{
			$teamids[] = $team['teamid'];
		}
		// end free agents current teams
		// start check for bbuserinfo teams
		$countteams = 0;
		$userteams = array();
		$teams = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_members AS members
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teams
				ON members.teamid = teams.teamid
			WHERE members.leader = '1'
				AND members.userid = '".$vbulletin->userinfo['userid']."'
		");
		while($teamm = $vbulletin->db->fetch_array($teams))
		{
			if ((!$teamm['teamid'] OR !in_array($teamm['teamid'], $teamids)) && (!$agent['invites'] OR !in_array($teamm['teamid'], $agent['invites'])))
			{
				$userteams[] = $teamm;
				$countteams++;
			}
		}
		// end check for bbuserinfo teams
	}
	$templater = vB_Template::create('tmnt_freeagent');
	$templater->register('tmntp', $tmntp);
	$templater->register('agent', $agent);
	$templater->register('teams', $userteams);
	$templater->register('countteams', $countteams);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] . '?do=freeagents' => construct_phrase($vbphrase['tmnt_freeagents']),
		'' => construct_phrase($vbphrase['tmnt_freeagent'])
	);
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'requestfreeagent')
{
	$userid = $vbulletin->userinfo['userid'];
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	$teamid = $vbulletin->input->clean_gpc('p', 'teamid', TYPE_UINT);
	$team = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_members AS members
		JOIN " . TABLE_PREFIX . "tmnt_teams AS teams
			ON members.teamid = teams.teamid
		WHERE members.leader = '1'
			AND members.userid = '$userid' 
			AND teams.teamid = '$teamid'
	");
	if (!$team)
	{
		$errormessage = "You are not leader of this team";
        eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_members SET invites = CONCAT(invites, ',$teamid') WHERE id = '$id' AND teamid = '0'");
	$vbulletin->url = "competitions.php?do=freeagent&id=$id&request=success";	
	eval(print_standard_redirect('redirect_insertteam'));
}

// #############################################################################

if ($_POST['do'] == 'acceptteam')
{
	$userid = $vbulletin->userinfo['userid'];
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	$teamid = $vbulletin->input->clean_gpc('p', 'teamid', TYPE_UINT);
	$agent = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_members
		WHERE teamid = '0' AND id = '$id' AND userid = '$userid'
	");
	$team = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_teams
		WHERE teamid = '$teamid'
	");
	if (!$agent OR !$team)
	{
		print_no_permission();
	}
	$agent['invites'] = explode(",", $agent['invites']);
	if (!in_array($teamid, $agent['invites']))
	{
		print_no_permission();
	}
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_members SET teamid = $teamid, accepted = 1 WHERE id = $id");
	$vbulletin->url = "competitions.php?do=viewteam&id=$teamid";	
	eval(print_standard_redirect('redirect_acceptteam'));
}

// #############################################################################

if ($_POST['do'] == 'insertfreeagent')
{
	if (!$tmntp['canjointeam'])
	{
		print_no_permission();
	}
	$count = $vbulletin->db->query_first("
		SELECT COUNT(*) AS countrows
		FROM " . TABLE_PREFIX . "tmnt_members
		WHERE userid = '".$vbulletin->userinfo['userid']."'
	");
	if ($count['countrows'] != 0)
	{
		print_no_permission();
	}
	$userid = $vbulletin->userinfo['userid'];
	$available_day = $vbulletin->input->clean_gpc('p', 'available_day', TYPE_NOHTML);
	$available_time = $vbulletin->input->clean_gpc('p', 'available_time', TYPE_NOHTML);
	$reason = $vbulletin->input->clean_gpc('p', 'reason', TYPE_NOHTML);
	$description = $vbulletin->input->clean_gpc('p', 'description', TYPE_NOHTML);
	if (!$description || !$available_day || !$available_time || !$reason)
	{
		$_REQUEST['do'] = 'addfreeagent';
	}
	else
	{
		$ip = $_SERVER['REMOTE_ADDR'];
		$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_members
			(userid, teamid, time, ip, available_day, available_time, reason, description)
			VALUES (
				'".$vbulletin->db->escape_string($userid)."',
				'0',
				".TIMENOW.", 
				'".$vbulletin->db->escape_string($ip)."',
				'".$vbulletin->db->escape_string($available_day)."',
				'".$vbulletin->db->escape_string($available_time)."',
				'".$vbulletin->db->escape_string($reason)."',
				'".$vbulletin->db->escape_string($description)."'
			)
		");
		$vbulletin->url = "competitions.php?do=freeagents";	
		eval(print_standard_redirect('redirect_insertfreeagent'));
	}
}

// #############################################################################

if ($_REQUEST['do'] == 'addfreeagent')
{
	$count = $vbulletin->db->query_first("
		SELECT COUNT(*) AS countrows
		FROM " . TABLE_PREFIX . "tmnt_members
		WHERE userid = '".$vbulletin->userinfo['userid']."'
	");
	if ($count['countrows'] != 0 OR !$vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}
	$selectedd = array();
	$selectedt = array();
	$selectedr = array();
	$selectedd["$available_day"] = ' selected="selected"';
	$selectedt["$available_time"] = ' selected="selected"';
	$selectedr["$reason"] = ' selected="selected"';
	$templater = vB_Template::create('tmnt_newfreeagent');
	$templater->register('tmntp', $tmntp);
	$templater->register('description', $description);
	$templater->register('selectedd', $selectedd);
	$templater->register('selectedt', $selectedt);
	$templater->register('selectedr', $selectedr);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] . '?do=freeagents' => construct_phrase($vbphrase['tmnt_freeagents']),
		'' => construct_phrase($vbphrase['tmnt_become_freeagent'])
	);
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'deletefreeagent')
{
	if (!$tmntp['canjointeam'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_members WHERE id = '$id' AND userid = '" . $vbulletin->userinfo['userid'] . "' ");
	$vbulletin->url = "competitions.php?do=freeagents";	
	eval(print_standard_redirect('redirect_deletefreeagent'));
}

// #############################################################################

if ($_REQUEST['do'] == 'viewannouncement')
{	
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_announcement];
        eval(standard_error($errormessage));
	}
	require_once(DIR . '/includes/class_bbcode.php');
	$ann = $vbulletin->db->query_first("
		SELECT ann.*, user.username, user.usertitle
		FROM " . TABLE_PREFIX . "tmnt_announcements AS ann
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON user.userid = ann.userid
		WHERE ann.id = $id
	");
	if (!$ann)
	{
		$errormessage = $vbphrase[error_invalid_announcement];
        eval(standard_error($errormessage));
	}
	$title       = $ann['title'];
	$userid      = $ann['userid'];
	$username    = $ann['username'];
	$usertitle   = $ann['usertitle'];
	$ip          = $ann['ip'];
	$time        = vbdate($vbulletin->options['dateformat'],$ann['time'], 1)." ".vbdate($vbulletin->options['timeformat'],$ann['time']);
	if ($ann['le_userid'] != 0)
	{
		$le_ip       = $ann['le_ip'];
		$le_userid   = $ann['le_userid'];
		$le_userinfo = fetch_userinfo($le_userid);
		$le_username = $le_userinfo[username];
		$le_time     = vbdate($vbulletin->options['dateformat'],$ann['le_time'], 1).$vbphrase['tmnt_at'].vbdate($vbulletin->options['timeformat'],$ann['le_time']);
	}
	$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
	$announcement = $bbcode_parser->do_parse($ann['announcement'],false,true,true,true,true,false);
	$templater = vB_Template::create('tmnt_displayannouncement');
	$templater->register('le_ip', $le_ip);
	$templater->register('le_userid', $le_userid);
	$templater->register('le_userinfo', $le_userinfo);
	$templater->register('le_username', $le_username);
	$templater->register('le_time', $le_time);
	$templater->register('ip', $ip);
	$templater->register('id', $id);
	$templater->register('userid', $userid);
	$templater->register('userinfo', $userinfo);
	$templater->register('username', $username);
	$templater->register('time', $time);
	$templater->register('tmntp', $tmntp);
	$templater->register('round', $round);
	$templater->register('announcement', $announcement);
	$templater->register('title', $title);
	$templater->register('ann', $ann);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'competitions.php?do=announcements' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['announcements'],
		'' => construct_phrase($title)
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('memberinfo_css');
	$memberinfo_css = $templater->render();
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'viewteamwins')
{
	require_once(DIR . '/includes/class_bbcode.php');
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase['error_invalid_team'];
        eval(standard_error($errormessage));
	}
	$teamid = $id;
	$wins = $vbulletin->db->query_read("
		SELECT tmnts.id, tmnts.title
		FROM " . TABLE_PREFIX . "tmnt_players AS players
		LEFT JOIN " . TABLE_PREFIX . "tmnt_tmnts AS tmnts
			ON tmnts.id = players.tid
		WHERE players.winner = 1
			AND tmnts.pot = 1
			AND players.pot = 1
			AND players.userid = $id
	");
	$tarray = array();
	while($tmnt = $vbulletin->db->fetch_array($wins))
	{
		$tarray[] = $tmnt;
		$totaltmnts++;
	}
	if ($totaltmnts == 0)
	{
		$errormessage = $vbphrase[error_invalid_team];
        eval(standard_error($errormessage));
	}
	$templater = vB_Template::create('tmnt_team_won');
		$templater->register_page_templates();
		$templater->register('totaltmnts', $totaltmnts);
		$templater->register('wins', $wins);
		$templater->register('teamid', $teamid);
		$templater->register('id', $id);
		$templater->register('tarray', $tarray);
		$templater->register('tmntp', $tmntp);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'viewteamjoins')
{
	require_once(DIR . '/includes/class_bbcode.php');
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_team];
        eval(standard_error($errormessage));
	}
	$teamid = $id;
	$joins = $vbulletin->db->query_read("
		SELECT tmnts.id, tmnts.title
		FROM " . TABLE_PREFIX . "tmnt_players AS players
		LEFT JOIN " . TABLE_PREFIX . "tmnt_tmnts AS tmnts
			ON tmnts.id = players.tid
		WHERE tmnts.pot = 1
			AND players.pot = 1
			AND players.userid = $id
	");
	$tarray = array();
	while($tmnt = $vbulletin->db->fetch_array($joins))
	{
		$tarray[] = $tmnt;
		$totaltmnts++;
	}
	if ($totaltmnts == 0)
	{
		$errormessage = $vbphrase['error_invalid_team'];
        eval(standard_error($errormessage));
	}
	$templater = vB_Template::create('tmnt_team_join');
		$templater->register_page_templates();
		$templater->register('totaltmnts', $totaltmnts);
		$templater->register('joins', $joins);
		$templater->register('teamid', $teamid);
		$templater->register('id', $id);
		$templater->register('tarray', $tarray);
		$templater->register('tmntp', $tmntp);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'viewteam')
{
	require_once(DIR . '/includes/class_bbcode.php');
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id) {
		$errormessage = $vbphrase['error_invalid_team'];
        eval(standard_error($errormessage));
	}
	$teamid = $id;
	$team = $vbulletin->db->query_first("
		SELECT teams.*, user.username
		FROM " . TABLE_PREFIX . "tmnt_teams AS teams
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON user.userid = teams.userid
		WHERE teams.teamid = $id
	");
	if (empty($team))
	{
		$errormessage = $vbphrase[error_invalid_team];
        eval(standard_error($errormessage));
	}
	$userid      = $team['userid'];
	$username    = $team['username'];
	$ip          = $team['ip'];
	$teamname    = $team['teamname'];
	$noplayers   = $team['noplayers'];
	$joins       = $team['joins'];
	$wins        = $team['wins'];
	$views       = $team['views'];
	$tag         = $team['tag'];
	$slogan      = $team['slogan'];
	$teamlogo    = $team['teamlogo'];
	$website     = $team['website'];
	if ($website && (strlen($website) < 7 OR substr($website, 0, 7) != 'http://'))
	{
		$website = "http://" . $website;
	}
	$gamertag    = $team['gamertag'];
	if ($teamlogo)
	{
		$size = getimagesize($teamlogo);
		//set in vbulletin options
		$max_height_width = $vbulletin->options['tmnt_teamlogo_maxsize'];//dominic
		if ($size[1] > $max_height_width OR $size[0] > $max_height_width)
		{
			if ($size[1] > $size[0])
			{
				$ratio = $size[1]/$max_height_width;
				if ($ratio != 0)
				{
					$size[1] = $size[1]/$ratio;
					$size[0] = $size[0]/$ratio;
				}
			}
			else
			{
				$ratio = $size[0]/$max_height_width;
				if ($ratio != 0)
				{
					$size[1] = $size[1]/$ratio;
					$size[0] = $size[0]/$ratio;
				}
			}
		}
	}
	$time = vbdate($vbulletin->options['dateformat'], $team['time'], 1);
	if ($team['le_userid'] != 0) {
		$le_ip       = $team['le_ip'];
		$le_userid   = $team['le_userid'];
		$le_userinfo = fetch_userinfo($le_userid);
		$le_username = $le_userinfo[username];
		$le_time     = vbdate($vbulletin->options['timeformat'],$team['le_time'])." on ".vbdate($vbulletin->options['dateformat'],$team['le_time'], 1);
	}
	$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
	$description = $bbcode_parser->do_parse($team['description'],false,true,true,true,true,false);
	$tag = $bbcode_parser->do_parse(unhtmlspecialchars($tag),false,true,true,true,true,false);
	$m_row = 1;
	$r_row = 1;
	$array = array();
	$isleader = false;
	$iscoleader = false;
	$userid = $thisuserid;
	require_once(DIR . '/includes/functions_user.php');
	require_once(DIR . '/includes/class_postbit.php'); //function construct_im_icons
	require_once(DIR . '/includes/functions_bigthree.php');//function fetch_online_status
	$members = $vbulletin->db->query_read("
		SELECT members.*, user.*, user.username AS username, members.id AS id "
		. ($vbulletin->options['avatarenabled'] ?
						", avatar.avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.filedata_thumb, customavatar.height AS avheight, customavatar.width AS avwidth, customavatar.width_thumb AS avwidth_thumb, customavatar.height_thumb AS avheight_thumb" : "") . "
		FROM " . TABLE_PREFIX . "tmnt_members AS members
		LEFT JOIN " . TABLE_PREFIX . "user AS user
		ON(members.userid = user.userid) "
				. ($vbulletin->options['avatarenabled'] ? "
		LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON (avatar.avatarid = user.avatarid)
		LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON (customavatar.userid = user.userid) " : '') . "
		WHERE members.teamid = '$id'
		ORDER BY members.leader DESC, members.coleader DESC, members.time ASC
	");
	while($member = $vbulletin->db->fetch_array($members))
	{
		fetch_avatar_from_userinfo($member, true);
		fetch_musername($member);
		construct_im_icons($member);
		$member['online_status_code'] = fetch_online_status($member, true);
		$m_id         = $member['id'];
		$m_userid     = $member['userid'];
		$m_username   = $member['username'];
		$array = array_merge((array)$m_userid, $array);
		if ($member['leader'] == 1)
		{
			$m_rank = $vbphrase['tmnt_leader'];
			if ($m_userid == $thisuserid)
			{
				$isleader = true;
				$ismember = true;
			}
		} 
		elseif ($member['coleader'] == 1) 
		{
			$m_rank = $vbphrase['tmnt_coleader'];
			if ($m_userid == $thisuserid)
			{
				$iscoleader = true;
				$ismember = true;
			}
		}
		else 
		{
			$m_rank = $vbphrase['tmnt_member'];
			if ($m_userid == $thisuserid)
			{
				$ismember = true;
			}
		}
		$m_time = vbdate($vbulletin->options['dateformat'],$member['time'], 1);
		if ($member['accepted'] == 1) {
			$m_row++;
		} else {
			$m_rank = $vbphrase['tmnt_recruit'];
			$r_row++;
		}
		$templater = vB_Template::create('tmnt_teammember');
			$templater->register('member', $member);
			$templater->register('isleader', $isleader);
			$templater->register('ddms', $ddms);
			$templater->register('tag', $tag);
			$templater->register('m_username', $m_username);
			$templater->register('m_rank', $m_rank);
			$templater->register('m_userid', $m_userid);
			$templater->register('m_id', $m_id);
			$templater->register('ddms_id', $ddms_id);
			$templater->register('m_row', $m_row);
			$templater->register('m_time', $m_time);
		if ($member['accepted'] == 1)
		{
			$teammembers .= $templater->render();
		}
		else
		{
			$teamrecruits .= $templater->render();
		}
	}
	if (in_array($userid, $array)) {
		$notinteam = false;
	} else {
		$notinteam = true;
	}
	if (($m_row-1)!=$noplayers) {
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_teams SET noplayers = '".($m_row-1)."' WHERE teamid='$id'");
	}
	$norecruits = $r_row-1;
	$blocks = array();
	$vbulletin->input->clean_array_gpc('r', array(
		'tab'         => TYPE_NOHTML,
		'simple'      => TYPE_BOOL,
	));
	$templater = vB_Template::create('tmnt_block_aboutteam');
		$templater->register('tmntp', $tmntp);
		$templater->register('description', $description);
		$templater->register('notinteam', $notinteam);
		$templater->register('id', $id);
		$templater->register('noplayers', $noplayers);
		$templater->register('teamrecruits', $teamrecruits);
		$templater->register('teammembers', $teammembers);
		$templater->register('isleader', $isleader);
		$templater->register('ismember', $ismember);
		$templater->register('tag', $tag);
		$templater->register('gamertag', $gamertag);
		$templater->register('team', $team);
		$templater->register('teamid', $teamid);
		$templater->register('teamname', $teamname);
		$templater->register('slogan', $slogan);
		$templater->register('joins', $joins);
		$templater->register('wins', $wins);
		$templater->register('website', $website);
		$templater->register('views', $views);
		$templater->register('teamlogo', $teamlogo);
		$templater->register('size', $size);
		$templater->register('time', $time);
	$blocks['aboutteam'] = $templater->render();
	$templater = vB_Template::create('tmnt_block_members');
		$templater->register('notinteam', $notinteam);
		$templater->register('id', $id);
		$templater->register('r_row', $r_row);
		$templater->register('noplayers', $noplayers);
		$templater->register('norecruits', $norecruits);//
		$templater->register('teamrecruits', $teamrecruits);
		$templater->register('teammembers', $teammembers);
		$templater->register('isleader', $isleader);//
		$templater->register('ismember', $ismember);
	$blocks['members'] = $templater->render();
	$games = $vbulletin->db->query_read("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.teamname AS u, user2.teamname AS u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user
			ON (games.u = user.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user2
			ON (games.u2 = user2.teamid)
		WHERE (games.u = '$teamid' OR games.u2 = '$teamid')
			AND games.finished = 1
			AND games.accepted != -1
			AND games.pot = 1
		LIMIT 0, 20
	");
	$gamearray = array();
	$show['roster'] = false;
	while($game = $vbulletin->db->fetch_array($games))
	{
		$gamearray[] = $game;
		$show['roster'] = true;
	}
	if ($show['roster'])
	{
		$templater = vB_Template::create('tmnt_block_roster');
			$templater->register('gamearray', $gamearray);
		$blocks['roster'] = $templater->render();
	}
	$chlls = $vbulletin->db->query_read("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.teamname AS u, user2.teamname AS u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user
			ON (games.u = user.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user2
			ON (games.u2 = user2.teamid)
		WHERE (games.u = '$teamid' OR games.u2  = '$teamids')
			AND games.finished = 0
			AND games.accepted = 1
			AND games.pot = 1
		ORDER BY games.lid ASC,
			games.id ASC
	");
	$chllarray = array();
	$show['challenges'] = false;
	while($chll = $vbulletin->db->fetch_array($chlls))
	{
		$chllarray[] = $chll;
		$show['challenges'] = true;
	}
	if ($show['challenges'])
	{
		$templater = vB_Template::create('tmnt_block_challenges');
			$templater->register('chllarray', $chllarray);
		$blocks['challenges'] = $templater->render();
	}
	$tmnts = $vbulletin->db->query_read("
		SELECT tmnts.id AS tid, tmnts.title AS title
		FROM " . TABLE_PREFIX . "tmnt_players AS players
		LEFT JOIN " . TABLE_PREFIX . "tmnt_tmnts AS tmnts
			ON (players.tid = tmnts.id)
		WHERE players.userid = '$teamid'
			AND players.pot = 1
	");
	$tmntarray = array();
	$show['tmnts'] = false;
	while($tmnt = $vbulletin->db->fetch_array($tmnts))
	{
		$tmntarray[] = $tmnt;
		$show['tmnts'] = true;
	}
	if ($show['tmnts'])
	{
		$templater = vB_Template::create('tmnt_block_tmnts');
			$templater->register('tmntarray', $tmntarray);
		$blocks['tmnts'] = $templater->render();
	}
	$ladders = $vbulletin->db->query_read("
		SELECT ladders.id AS lid, ladders.title AS title, COUNT(r.id) + 1  AS rank
		FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (players.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladder_players AS r
			ON (r.lid = players.lid AND r.rank > players.rank)
		WHERE players.userid = '$teamid'
			AND players.pot = 1
			AND players.active = 1
		GROUP BY ladders.id
	");
	$ladderarray = array();
	$show['ladders'] = false;
	while($ladder = $vbulletin->db->fetch_array($ladders))
	{
		$ladder['rank'] = process_position($ladder['rank'], 1);
		$ladderarray[] = $ladder;
		$show['ladders'] = true;
	}
	if ($show['ladders'])
	{
		$templater = vB_Template::create('tmnt_block_ladders');
			$templater->register('ladderarray', $ladderarray);
		$blocks['ladders'] = $templater->render();
	}
	$selected_tab = '';
	switch ($vbulletin->GPC['tab'])
	{
		case 'members':
			$selected_tab = 'members';
			break;
		case 'roster':
			$selected_tab = 'roster';
			break;
		case 'challenges':
			$selected_tab = 'challenges';
			break;
		case 'aboutteam':
			$selected_tab = 'aboutteam';
			break;
		case 'tmnts':
			$selected_tab = 'tmnts';
			break;
		case 'ladders':
			$selected_tab = 'ladders';
			break;
	}
	$templater = vB_Template::create('tmnt_displayteam');
		$templater->register('tmntp', $tmntp);
		$templater->register('description', $description);
		$templater->register('notinteam', $notinteam);
		$templater->register('id', $id);
		$templater->register('noplayers', $noplayers);
		$templater->register('teamrecruits', $teamrecruits);
		$templater->register('teammembers', $teammembers);
		$templater->register('isleader', $isleader);
		$templater->register('ismember', $ismember);
		$templater->register('tag', $tag);
		$templater->register('team', $team);
		$templater->register('teamid', $teamid);
		$templater->register('teamname', $teamname);
		$templater->register('selected_tab', $selected_tab);
		$templater->register('slogan', $slogan);
		$templater->register('selected', $selected);
		$templater->register('blocks', $blocks);
		$templater->register('joins', $joins);
		$templater->register('wins', $wins);
		$templater->register('website', $website);
		$templater->register('views', $views);
		$templater->register('teamlogo', $teamlogo);
		$templater->register('size', $size);
		$templater->register('time', $time);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'competitions.php?do=teams' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tmnt_teamlist'],
		'' => construct_phrase($teamname)
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('memberinfo_css');
	$memberinfo_css = $templater->render();
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_teams SET views = views + 1 WHERE teamid=$id");
	if ($tmntp['canmanageteams'])
	{
		$show['usernameajax'] = true;
	}
	$headinclude .= "\r\n<link rel=\"stylesheet\" type=\"text/css\" href=\"css.php?userid=0" . "&amp;d=" . TIMENOW . "&amp;td=" . vB_Template_Runtime::fetchStyleVar('textdirection') . "&amp;styleid=" . $vbulletin->userinfo['styleid'] . "&amp;sheet=member.css,user\" />";
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'reqjointeam')
{
	if (!$tmntp['canjointeam'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id)
		{
			$errormessage = $vbphrase[error_invalid_team];
			eval(standard_error($errormessage));
		}	
	$userid = $thisuserid;
	$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid=$id AND userid=$userid ");
	$countplayer = $countplayer['countrows'];  
	if ($countplayer != 0) {
		$errormessage = $vbphrase[error_already_joined_team];
		eval(standard_error($errormessage));
	}
	$countteam = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid=$id ");
	$countteam = $countteam['countrows'];  
	if ($countteam != 1)
	{
		$errormessage = $vbphrase[error_invalid_team];
		eval(standard_error($errormessage));
	}
	$ip = $_SERVER['REMOTE_ADDR'];
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_members
		(userid, teamid, time, ip)
		VALUES ('".$userid."', '".$id."', ".TIMENOW.", '".$ip."')
	");
	$leaders = $vbulletin->db->query_read("
		SELECT user.username
		FROM " . TABLE_PREFIX . "tmnt_members AS members
		LEFT JOIN " . TABLE_PREFIX . "user
			AS user
			ON (members.userid = user.userid)
		WHERE members.teamid='$id'
			AND members.leader = '1'
	");
	$recipients = array();
	while ($leader = $vbulletin->db->fetch_array($leaders))
	{
		$recipients[] = $leader['username'];
	}
	$title = $vbphrase['tmnt_new_team_request'];
	$message = construct_phrase($vbphrase['tmnt_new_team_request_pm'], $vbulletin->userinfo['username'], $id, $vbulletin->options['bburl']);
	$recipients = implode(";", $recipients);
	$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
		$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
		$pmdm->set('fromusername', $vbulletin->userinfo['username']);
		$pmdm->set('title', $title);
		$pmdm->set('message', $message);
		$pmdm->set_recipients($recipients, $botpermissions);
		$pmdm->set('dateline', TIMENOW); 
		$pmdm->overridequota = true;
		$errors = $pmdm->errors;
		if ($errors) {
			foreach ($errors as $error) {
				$errorss .= $error. "<br />";
			}
			$errormessage = $errorss;
			eval(standard_error($errormessage));
		}
		$pmdm->save();
		unset($pmdm);
	//dominic
	$vbulletin->url = "competitions.php?do=viewteam&id=".$id;	
	eval(print_standard_redirect('redirect_reqjointeam'));
}

// #############################################################################

if ($_POST['do'] == 'forcejointeam')
{
	if (!$tmntp['canmanageteams']) {
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
		if (!$id) {
			$errormessage = $vbphrase[error_invalid_team];
			eval(standard_error($errormessage));
		}	
	$username = $vbulletin->input->clean_gpc('p', 'username', TYPE_STR);
	if ($username == '')
	{
		$errormessage = $vbphrase['error_no_username'];
		eval(standard_error($errormessage));
	}
	$result = $vbulletin->db->query_first("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '".$vbulletin->db->escape_string($username)."' ");
	$u = $result['userid'];
	if ($u == '') {
		$errormessage = $username." is not a forum member, please check your spelling. Click <a href=\"competitions.php?do=viewteam&amp;id=".$id."\">here</a> to go back to the team page.";
		eval(standard_error($errormessage));
	}
	$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid=$id AND userid=$u");
	$countplayer = $countplayer['countrows'];  
	if ($countplayer != 0) {
		$errormessage = $username." is already in this team. Click <a href=\"competitions.php?do=viewteam&amp;id=".$id."\">here</a> to go back to the team page.";
		eval(standard_error($errormessage));
	}
	$countteam = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid='$id'");
	$countteam = $countteam['countrows'];  
	if ($countteam != 1)
	{
		$errormessage = $vbphrase[error_invalid_team];
		eval(standard_error($errormessage));
	}
	$ip = $_SERVER['REMOTE_ADDR'];
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_members
		(userid, teamid, time, ip, accepted)
		VALUES ('".$u."', '".$id."', ".TIMENOW.", '".$ip."', '1')
	");
	$userinfo = fetch_userinfo($u);
	$tmnt_teams = array_merge((array)$userinfo['tmnt_teams'], (array)$id);
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_teams = '" . implode(',' , $tmnt_teams) . "' WHERE userid=$u");
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_teams SET noplayers=noplayers+1 WHERE teamid=$id");
	$vbulletin->url = "competitions.php?do=viewteam&id=".$id."&tab=members";	
	eval(print_standard_redirect('redirect_forcejointeam'));
}

// #############################################################################

if ($_REQUEST['do'] == 'confirmrecruit')
{
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id)
		{
			$errormessage = $vbphrase[error_invalid_recruit];
			eval(standard_error($errormessage));
		}
	$recruit_row = 1;
	$recruits = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE id=$id AND accepted=0");
	while($recruit = $vbulletin->db->fetch_array($recruits)){
		$teamid = $recruit['teamid'];
		$recruit_row++ ;
	}
	if ($recruit_row != 2) {
		$errormessage = $vbphrase[error_invalid_recruit];
		eval(standard_error($errormessage));
	}
	$userid = $thisuserid;
	$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid=$teamid AND userid=$userid AND leader=1");
	$countplayer = $countplayer['countrows'];  
	if ($countplayer != 1)
	{
		print_no_permission();
	}
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_members SET accepted=1 WHERE id=$id");
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_teams SET noplayers=noplayers+1 WHERE teamid=$teamid");
	$userinfo = fetch_userinfo($id);
	$tmnt_teams = array_merge((array)$userinfo['tmnt_teams'], (array)$teamid);
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_teams = '" . implode(',' , $tmnt_teams) . "' WHERE userid=$userid");
	$vbulletin->url = "competitions.php?do=viewteam&id=".$teamid."&tab=members";	
	eval(print_standard_redirect('redirect_acceptrecruit'));
}

// #############################################################################

if ($_REQUEST['do'] == 'rejectrecruit')
{
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id)
		{
			$errormessage = $vbphrase[error_invalid_recruit];
			eval(standard_error($errormessage));
		}
	$recruit_row = 1;
	$recruits = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE id=$id AND accepted=0");
	while($recruit = $vbulletin->db->fetch_array($recruits)){
		$teamid = $recruit['teamid'];
		$recruit_row++ ;
	}
	if ($recruit_row != 2)
	{
		$errormessage = $vbphrase[error_invalid_recruit];
		eval(standard_error($errormessage));
	}
	$userid = $thisuserid;
	$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid=$teamid AND userid=$userid AND leader=1");
	$countplayer = $countplayer['countrows'];  
	if ($countplayer != 1)
	{
		print_no_permission();
	}
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_members WHERE id=$id");
	$vbulletin->url = "competitions.php?do=viewteam&id=".$teamid."&tab=members";	
	eval(print_standard_redirect('redirect_rejectrecruit'));
}

// #############################################################################

if ($_REQUEST['do'] == 'editteam')
{
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_team];
		eval(standard_error($errormessage));
	}
	if (!$tmntp['caneditteams']) {
	$userid = $thisuserid;
	$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid=$id AND userid=$userid AND leader=1");
	$countplayer = $countplayer['countrows'];  
	if ($countplayer != 1) {
		print_no_permission();
	} }
	$team = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid=$id");
	$description = $team['description'];
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar($description, 0, 'nonforum', 1); 
	}
	else
	{
		$editorid = construct_edit_toolbar($description);
	}
	$team['marray'] = array();
	$members = $vbulletin->db->query_read("
		SELECT members.*, user.*, user.username AS username, members.id AS id
		FROM " . TABLE_PREFIX . "tmnt_members AS members
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON(members.userid = user.userid)
		WHERE members.teamid = '$id'
			AND members.accepted = 1
		ORDER BY user.username ASC
	");
	while($member = $vbulletin->db->fetch_array($members))
	{
		$team['marray']["$member[id]"] = $member;
	}
	$templater = vB_Template::create('tmnt_editteam');
		$templater->register('tmntp', $tmntp);
		$templater->register('team', $team);
		$templater->register('id', $id);
		$templater->register('description', $description);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
		$templater->register('time', $time);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'competitions.php?do=teams' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tmnt_teamlist'],
		'competitions.php?do=viewteam&amp;id='.$id . $vbulletin->session->vars['sessionurl_q'] => $team['teamname'],
		'' => construct_phrase($vbphrase['tmnt_editingteam'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'updateteam')
{
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_team];
		eval(standard_error($errormessage));
	}
    $userid = $vbulletin->input->clean_gpc('p', 'userid', TYPE_UINT);
	if (!$userid)
	{
		$userid = $thisuserid;
	}
	$title = $vbulletin->input->clean_gpc('p', 'title', TYPE_NOHTML);
	$website = $vbulletin->input->clean_gpc('p', 'website', TYPE_NOHTML);
	$gamertag = $vbulletin->input->clean_gpc('p', 'gamertag', TYPE_NOHTML);
	if (!$title)
	{
		$errormessage = $vbphrase[error_invalid_teamname];
		eval(standard_error($errormessage));
	}
	$counttitle = $vbulletin->db->query_first("
		SELECT COUNT(*) AS countrows
		FROM " . TABLE_PREFIX . "tmnt_teams
		WHERE teamname = '".$vbulletin->db->escape_string($title)."'
			AND teamid != $id
	");
	$counttitle = $counttitle['countrows'];
	if ($counttitle != 0)
	{
		$errormessage = $vbphrase[error_teamname_already_used];
		eval(standard_error($errormessage));
	}
	$slogan = $vbulletin->input->clean_gpc('p', 'slogan', TYPE_NOHTML);
	$oldteamlogo = $vbulletin->input->clean_gpc('p', 'oldteamlogo', TYPE_STR);
	$teamlogo = $vbulletin->input->clean_gpc('f', 'teamlogo', TYPE_FILE);
		$uploadDir = 'images/teamlogos/';
		$fileName = $teamlogo['name'];
		$tmpName  = $teamlogo['tmp_name'];
	function img_resize($tmpname, $width, $height, $save_dir, $save_name)
	{
		$save_dir .= ( substr($save_dir,-1) != "/") ? "/" : "";
		$gis       = GetImageSize($tmpname);
		$type       = $gis[2];
		switch($type)
		{
			case "1": $imorig = imagecreatefromgif($tmpname); break;
			case "2": $imorig = imagecreatefromjpeg($tmpname);break;
			case "3": $imorig = imagecreatefrompng($tmpname); break;
			default:  $imorig = imagecreatefromjpeg($tmpname);
		}
        $x = imageSX($imorig);
        $y = imageSY($imorig);
		$c = $x;
		$d = $y;
		if (($d > $height) OR ($c > $width))
		{
			$a = $d/$height;
			$b = $c/$width;
			if ($a > $b)
			{
				$r  = $d/$height;
				$d = $d/$r;
				$c  = $c/$r;
			}
			else
			{
				$r  = $c/$width;
				$d = $d/$r;
				$c  = $c/$r;
			}
		}
        $im = imagecreate($c, $d);
        $im = imagecreatetruecolor($c,$d);
		if (imagecopyresampled($im,$imorig,0,0,0,0,$c,$d,$x,$y))
		{
			if (imagejpeg($im, $save_dir.$save_name))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
    }
	if ($tmpName != '')
	{
		if ($teamlogo['error'])
		{
			$errormessage = $vbphrase['error_uploading_team_logo'].$teamlogo['error'];
			eval(standard_error($errormessage));
		}
		$randName = md5(rand() * time());
		$ext      = substr(strrchr($fileName, "."), 1);
		$imgexts  = array('jpg', 'jpeg', 'png', 'gif');
		if (!in_array(strtolower($ext), $imgexts)) {
			$errormessage = $vbphrase[error_invalid_teamlogo_extension];
			eval(standard_error($errormessage));
		}
		@img_resize($tmpName, $vbulletin->options['tmnt_maxteamwidth'], $vbulletin->options['tmnt_maxteamheight'], $uploadDir, $randName.".jpg");
		$filePath = $uploadDir.$randName.".jpg";
		if (!file_exists($filePath))
		{
			$filePath = $oldteamlogo;
		}
	}
	else
	{
		$filePath = $oldteamlogo;
	}
	$tag = $vbulletin->input->clean_gpc('p', 'tag', TYPE_NOHTML);
	$vbulletin->input->clean_array_gpc('p', array(
		'message'      => TYPE_STR,
		'wysiwyg'	   => TYPE_BOOL,
	));
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$description = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$description = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else 
	{
		$description = $vbulletin->GPC['message'];
	}
	$ip = $_SERVER['REMOTE_ADDR'];
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_teams
		SET 
			teamname = '".$vbulletin->db->escape_string($title)."',
			description = '".$vbulletin->db->escape_string($description)."',
			le_userid = '".$vbulletin->db->escape_string($userid)."',
			le_time = ".TIMENOW.", 
			le_ip = '".$vbulletin->db->escape_string($ip)."', 
			slogan = '".$vbulletin->db->escape_string($slogan)."', 
			tag = '".$vbulletin->db->escape_string($tag)."', 
			teamlogo = '".$vbulletin->db->escape_string($filePath)."',
			website = '".$vbulletin->db->escape_string($website)."',
			gamertag = '".$vbulletin->db->escape_string($gamertag)."',
			width = '".$vbulletin->db->escape_string($width)."',
			height = '".$vbulletin->db->escape_string($height)."',
			width_thumb = '".$vbulletin->db->escape_string($width_thumb)."',
			height_thumb = '".$vbulletin->db->escape_string($height_thumb)."'
		WHERE teamid = '$id'
	");
	if ($oldteamlogo != $filePath AND file_exists($oldteamlogo))
	{
		unlink($oldteamlogo);
	}
	$mref = array();
	$members = $vbulletin->db->query_read("SELECT nickname, id FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid = '$id' AND accepted = 1");
	while($member = $vbulletin->db->fetch_array($members))
	{
		$mref["$member[id]"] = $member['nickname'];
	}
	$nicknames = $vbulletin->input->clean_gpc('p', 'memberarray', TYPE_ARRAY_NOHTML);
	if ($nicknames)
	{
		foreach ($nicknames AS $memberid => $nickname)
		{
			if ($nickname != $mref["$memberid"])
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_members SET nickname = '".$vbulletin->db->escape_string($nickname)."' WHERE id = '$memberid' AND teamid = '$id'");
			}
		}
	}
	$vbulletin->url = "competitions.php?do=viewteam&id=".$id;	
	eval(print_standard_redirect('redirect_updatedteam'));
}

// #############################################################################

if ($_POST['do'] == 'updatecategory')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$catid = $vbulletin->input->clean_gpc('p', 'catid', TYPE_UINT);
		if (!$catid)
		{
			$errormessage = $vbphrase[error_invalid_category];
        	eval(standard_error($errormessage));
		}
	$title = $vbulletin->input->clean_gpc('p', 'title', TYPE_NOHTML);
		if (!$title)
		{
			$errormessage = $vbphrase[error_invalid_title];
			eval(standard_error($errormessage));
		}
	$description = $vbulletin->input->clean_gpc('p', 'description', TYPE_NOHTML);
	$banner = $vbulletin->input->clean_gpc('p', 'banner', TYPE_NOHTML);
	$displayorder = $vbulletin->input->clean_gpc('p', 'displayorder', TYPE_UINT);
	$tol = $vbulletin->input->clean_gpc('p', 'tol', TYPE_UINT);
	$parentid = $vbulletin->input->clean_gpc('p', 'parentid', TYPE_UINT);
	$icon = $vbulletin->input->clean_gpc('p', 'icon', TYPE_NOHTML);
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_categories
		SET
			title = '".$vbulletin->db->escape_string($title)."',
			description = '".$vbulletin->db->escape_string($description)."',
			displayorder = '".$vbulletin->db->escape_string($displayorder)."',
			tol = '".$vbulletin->db->escape_string($tol)."',
			parentid = '".$vbulletin->db->escape_string($parentid)."',
			icon = '".$vbulletin->db->escape_string($icon)."',
			banner = '".$vbulletin->db->escape_string($banner)."'
		WHERE catid = '$catid'
	");
	if ($tol == 1)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET catid = 0 WHERE catid = '$catid' ");
	}
	elseif ($tol == 2)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_tmnts SET catid = 0 WHERE catid = '$catid' ");
	}
	build_tll_catcache();
	$vbulletin->url = "competitions.php?do=categories";	
	eval(print_standard_redirect('redirect_updatecat'));
}

// #############################################################################

if ($_REQUEST['do'] == 'editcategory')
{
    if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$catid = $vbulletin->input->clean_gpc('g', 'catid', TYPE_UINT);
	if (!$catid)
	{
		$errormessage = $vbphrase[error_invalid_category];
        eval(standard_error($errormessage));
	}
	$cats = array();
	$cat = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_categories WHERE catid='$catid'");
	if (!$cat)
	{
		$errormessage = $vbphrase[error_invalid_category];
        eval(standard_error($errormessage));
	}
	$categories = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_categories WHERE parentid = 0 AND catid != '$catid'");
	while($category = $vbulletin->db->fetch_array($categories))
	{
		if ($category['catid'] == $cat['parentid'])
		{
			$category['selected'] = ' selected="selected"';
		}
		$cats[] = $category;
	}
	$tol = $cat['tol'];
	$templater = vB_Template::create('tmnt_editcat');
	$templater->register('tmntp', $tmntp);
	$templater->register('tol', $tol);
	$templater->register('cat', $cat);
	$templater->register('cats', $cats);
	$templater->register('catid', $catid);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'competitions.php?do=categories' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tmnt_categories'],
		'' => construct_phrase($vbphrase[tmnt_editcategory])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'insertcategory')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$title = $vbulletin->input->clean_gpc('p', 'title', TYPE_NOHTML);
	if (!$title)
	{
		$errormessage = $vbphrase['error_invalid_title'];
		eval(standard_error($errormessage));
	}
	$description = $vbulletin->input->clean_gpc('p', 'description', TYPE_NOHTML);
	$banner = $vbulletin->input->clean_gpc('p', 'banner', TYPE_NOHTML);
	$displayorder = $vbulletin->input->clean_gpc('p', 'displayorder', TYPE_UINT);
	$tol = $vbulletin->input->clean_gpc('p', 'tol', TYPE_UINT);
	$parentid = $vbulletin->input->clean_gpc('p', 'parentid', TYPE_UINT);
	$icon = $vbulletin->input->clean_gpc('p', 'icon', TYPE_NOHTML);
	$vbulletin->db->query_write("
		INSERT INTO " . TABLE_PREFIX . "tmnt_categories
			(title, description, displayorder, tol, parentid, icon, banner)
		VALUES (
			'".$vbulletin->db->escape_string($title)."',
			'".$vbulletin->db->escape_string($description)."',
			'".$vbulletin->db->escape_string($displayorder)."',
			'".$vbulletin->db->escape_string($tol)."',
			'".$vbulletin->db->escape_string($parentid)."',
			'".$vbulletin->db->escape_string($icon)."',
			'".$vbulletin->db->escape_string($banner)."'
		)
	");
	$catid = $vbulletin->db->insert_id();
	build_tll_catcache();
	$vbulletin->url = "competitions.php?do=categories";	
	eval(print_standard_redirect('redirect_insertcat'));
}

// #############################################################################

if ($_REQUEST['do'] == 'addcategory')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$cats = array();
	$categories = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_categories WHERE parentid = 0");
	$countrows = 0;
	while($category = $vbulletin->db->fetch_array($categories))
	{
		$cats[] = $category;
		$countrows++;
	}
	$displayorder = $countrows * 10 + 10;
	$templater = vB_Template::create('tmnt_newcategory');
	$templater->register('tmntp', $tmntp);
	$templater->register('cats', $cats);
	$templater->register('displayorder', $displayorder);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'competitions.php?do=categories' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase[tmnt_categories],
		'' => construct_phrase($vbphrase['tmnt_newcategory'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'categories') 
{
	$rowcount = 0;
	$marray = array();
	$narray = array();
	/*$cats = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_categories
		ORDER BY parentid DESC, displayorder ASC, title ASC
	");
	while($cat = $vbulletin->db->fetch_array($cats))*/
	if ($vbulletin->tll_catcache)
	{
		foreach ($vbulletin->tll_catcache AS $cindex => $cat)
		{
			if (!$vbulletin->options['tmnt_disable_leagues'])
			{
				switch ($cat['tol'])
				{
					case 1:
						$cat['toltext'] = $vbphrase['tmnts'];
						break;
					case 2:
						$cat['toltext'] = $vbphrase['ladders_and_leagues'];
						break;
					case 3:
						$cat['toltext'] = $vbphrase['tmnts_and_ladders_and_leagues'];
						break;	
				}
			}
			else
			{
				switch ($cat['tol'])
				{
					case 1:
						$cat['toltext'] = $vbphrase['tmnts'];
						break;
					case 2:
						$cat['toltext'] = $vbphrase['ladders'];
						break;
					case 3:
						$cat['toltext'] = $vbphrase['tmnts_and_ladders'];
						break;	
				}
			}
			$templater = vB_Template::create('tmnt_listcat');
				$templater->register('cat', $cat);
			if ($cat['parentid'])
			{
				$marray["$cat[parentid]"] .= $templater->render();
			}
			else
			{
				$cats .= $templater->render();
				$cats .= $marray["$cat[catid]"];
			}
			$rowcount++;
		}
	}
	if ($rowcount == 0)
	{
		$templater = vB_Template::create('tmnt_nocategories');
		$nocats .= $templater->render();
	}
	$templater = vB_Template::create('tmnt_listcat_con');
		$templater->register('nocats', $nocats);
		$templater->register('rowcount', $rowcount);
		$templater->register('cats', $cats);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'' => construct_phrase($vbphrase['tmnt_categories'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'latest')
{
	$noanns = $vbulletin->options['tmnt_fp_anns'];
	$anns = $vbulletin->db->query_read("
		SELECT ann.userid, ann.id, ann.time, ann.title, user.username
		FROM " . TABLE_PREFIX . "tmnt_announcements AS ann
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON ann.userid = user.userid
		ORDER BY ann.id DESC
		LIMIT 0, $noanns
	");
	$user_lastvisit = $vbulletin->userinfo['lastvisit'];
	$rowcount = 0;
	while($ann = $vbulletin->db->fetch_array($anns))
	{
		//$ann[userinfo]  = fetch_userinfo($ann['userid']);
		//$ann[username]  = $ann[userinfo][username];
		$new = false;
		if ($ann['time'] >= $user_lastvisit)
		{
			$new = true;
		}
		$ann['date'] = vbdate($vbulletin->options['dateformat'],$ann['time'], 1);
		$ann['time'] = vbdate($vbulletin->options['timeformat'],$ann['time']);
		$templater = vB_Template::create('tmnt_listann');
			$templater->register('ann', $ann);
		$announcements .= $templater->render();
		$rowcount ++;
	}
	if ($rowcount == 0)
	{
		$templater = vB_Template::create('tmnt_noannouncements');
		$announcements .= $templater->render();
	}
	if ($tmntp['canviewtmnt'])
	{
		$notmnts = $vbulletin->options['tmnt_fp_tmnts'];
		$rowcount = 0;
		$tmnts = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_tmnts ORDER BY id DESC LIMIT 0, $notmnts");
		while($tmnt = $vbulletin->db->fetch_array($tmnts))
		{
			$tmnt['players'] = $tmnt['noplayers'] - $tmnt['freeslots'];
	        $description = preg_replace('/\[(.*?)\]/is', '', $tmnt['description']);
			$descriptionlength = strlen($description);
			if ($descriptionlength > $vbulletin->options['tmnt_desclength'])
			{
				$description = substr($description, 0, $vbulletin->options['tmnt_desclength']);
				$description = $description . '...';
			}
			if ($tmnt['status'] == '1')
			{
				$tmnt['status'] = $vbphrase['tmnt_waiting'];
			} elseif ($tmnt['status'] == '2')
			{
				$tmnt['status'] = $vbphrase['tmnt_inprogress'];
			} elseif ($tmnt['status'] == '3')
			{
				$tmnt['status'] = $vbphrase['tmnt_finished'];
			}
			if ($tmnt['pot'] == '0')
			{
				$tmnt['pot'] = "";
			} elseif ($tmnt['pot'] == '1')
			{
				$tmnt['pot'] = $vbphrase['tmnt_team'];
			}
			if ($tmnt['type'] == 'LMS')
			{
				$tmnt['type'] = $vbphrase['tmnt_lms'];
			}
			elseif ($tmnt['type'] == '1v1')
			{
				$tmnt['type'] = $vbphrase['tmnt_1v1'];
			}
			elseif ($tmnt['type'] == 'de')
			{
				$tmnt['type'] = $vbphrase['tmnt_de'];
			}
			if ($tmnt['status'] == '1')
			{
				$tmnt['status'] = $vbphrase['tmnt_waiting'];
			} 
			elseif ($tmnt['status'] == '2')
			{
				$tmnt['status'] = $vbphrase['tmnt_inprogress'];
			} 
			elseif ($tmnt['status'] == '3')
			{
				$tmnt['status'] = $vbphrase['tmnt_finished'];
			}
			$rowcount++;
			$templater = vB_Template::create('tmnt_index_tbit');
				$templater->register('tmnt', $tmnt);
			$latesttmnts .= $templater->render();
		}
		if ($rowcount == 0)
		{
			$templater = vB_Template::create('tmnt_notmnts');
			$latesttmnts .= $templater->render();
		}
	}
	if ($tmntp['canviewladder'])
	{
		$noladders = $vbulletin->options['tmnt_fp_ladders'];
		$rowcount = 0;
		$ladders = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders ORDER BY id DESC LIMIT 0, $noladders");
		while($ladder = $vbulletin->db->fetch_array($ladders))
		{
	        $description = preg_replace('/\[(.*?)\]/is', '', $ladder['description']);
			$descriptionlength = strlen($description);
			if ($descriptionlength > $vbulletin->options['tmnt_desclength'])
			{
				$description = substr($description, 0, $vbulletin->options['tmnt_desclength']);
				$description = $description . '...';
			}
			$templater = vB_Template::create('tmnt_index_lbit');
				$templater->register('description', $description);
				$templater->register('ladder', $ladder);
			$latestladders .= $templater->render();
			$rowcount ++;
		}
		if ($rowcount == 0)
		{
			$templater = vB_Template::create('tmnt_ladder_noladders');
			$latestladders .= $templater->render();
		}
	}
	$templater = vB_Template::create('tmnt_index');
		$templater->register('latesttmnts', $latesttmnts);
		$templater->register('announcements', $announcements);
		$templater->register('latestladders', $latestladders);
		$templater->register('tmntp', $tmntp);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'' => $modname,
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'updatebanners')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'title' => TYPE_ARRAY_NOHTML,
		'desc' => TYPE_ARRAY_NOHTML,
		'image' => TYPE_ARRAY_NOHTML,
		'url' => TYPE_ARRAY_NOHTML,
		'delete' => TYPE_ARRAY_BOOL,
		'id' => TYPE_ARRAY_UINT,
	));
	$tmnt_car_array = array();
	$query_banners = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_banners");
	while ($banner = $vbulletin->db->fetch_array($query_banners))
	{
		$bannerid = $banner['id'];
		$tmnt_car_array["$bannerid"] = $banner;
	}
	//print_r($vbulletin->GPC);
	foreach ($vbulletin->GPC['id'] AS $xh => $id)
	{
		$check = $tmnt_car_array["$id"];
		if (!$check)
		{
			continue;
		}
		if ($vbulletin->GPC['delete']["$id"] == 1)
		{//delete
			$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_banners WHERE id=$id");
		}
		elseif (
			$check['title'] != $vbulletin->GPC['title']["$xh"] OR
			$check['desc'] != $vbulletin->GPC['desc']["$xh"] OR
			$check['imageurl'] != $vbulletin->GPC['image']["$xh"] OR
			$check['linkurl'] != $vbulletin->GPC['url']["$xh"] 
		)
		{//update changes
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_banners
				SET
					title = '".$vbulletin->db->escape_string($vbulletin->GPC['title']["$xh"])."',
					" . TABLE_PREFIX . "tmnt_banners.desc = '".$vbulletin->db->escape_string($vbulletin->GPC['desc']["$xh"])."', 
					imageurl = '".$vbulletin->db->escape_string($vbulletin->GPC['image']["$xh"])."', 
					linkurl = '".$vbulletin->db->escape_string($vbulletin->GPC['url']["$xh"])."'
				WHERE id='$id' 
			");
		}
	}
	$vbulletin->url = "competitions.php?do=editbanners";	
	eval(print_standard_redirect('redirect_tmntbanner'));
}

// #############################################################################

if ($_POST['do'] == 'insertbanner')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'title'      => TYPE_NOHTML,
		'desc'      => TYPE_NOHTML,
		'image'      => TYPE_NOHTML,
		'url'      => TYPE_NOHTML,
	));
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_banners
		(title, " . TABLE_PREFIX . "tmnt_banners.desc, linkurl, imageurl, userid, dateline )
		VALUES ('".$vbulletin->db->escape_string($vbulletin->GPC['title'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['desc'])."', 
			'".$vbulletin->db->escape_string($vbulletin->GPC['url'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['image'])."',
			'".$vbulletin->userinfo['userid']."', 
			".TIMENOW."
		)
	");
	$vbulletin->url = "competitions.php?do=editbanners";	
	eval(print_standard_redirect('redirect_tmntbanner'));
}

// #############################################################################

if ($_REQUEST['do'] == 'editbanners')
{
	if (!$tmntp['canedittmnt'])
	{
		print_no_permission();
	}
	$tmnt_car_array = array();
	$query_banners = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_banners");
	while ($banner = $vbulletin->db->fetch_array($query_banners))
	{
		$tmnt_car_array[] = $banner;
	}
	$templater = vB_Template::create('tmnt_editbanners');
		$templater->register('tmntp', $tmntp);
		$templater->register('array', $tmnt_car_array);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' => $modname,
		'' => $vbphrase['tmnt_banners'],
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'])
{
	$_REQUEST['do'] = '';
}

// #############################################################################

if (empty($_REQUEST['do']))
{
	$c = $vbulletin->input->clean_gpc('g', 'c', TYPE_UINT);
	/*$cinfo = $vbulletin->db->query_first("
		SELECT cats.tol, ***cats.title AS categorytitle****, cats2.title AS categorytitle2, cats2.title AS parenttitle, cats.parentid AS parentid, ***cats.icon AS caticon****, cats.description, cats.banner
		FROM " . TABLE_PREFIX . "tmnt_categories AS cats
		LEFT JOIN " . TABLE_PREFIX . "tmnt_categories AS cats2
			ON cats.parentid = cats2.catid
		WHERE cats.catid = '$c'
	");*/
	$cinfo = $vbulletin->tll_catcache["$c"];
	if ($cinfo['tol'] == 0)
	{
		$cinfo['tol'] = 3;
	}
	$categorytitle = $cinfo['title'];
	$parentcategorytitle = $cinfo['parenttitle'];
	$parentcategoryid = $cinfo['parentid'];
	if($c == -1)
	{
		$c = 0;
	}
	if ($cinfo['parsed_banner'])
	{
		$cinfo['banner'] = $cinfo['parsed_banner'];
	}
	elseif ($cinfo['banner'])
	{
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
		$cinfo['banner'] = $bbcode_parser->do_parse($cinfo['banner']);
	}
	/*$carray = array();
	$cats = $vbulletin->db->query_read("
		SELECT cats.*, COUNT(DISTINCT tmnts.id) AS counttmnts, COUNT(DISTINCT ladders.id) AS countladders
		FROM " . TABLE_PREFIX . "tmnt_categories AS cats
		LEFT OUTER JOIN " . TABLE_PREFIX . "tmnt_tmnts AS tmnts
			ON (cats.catid = tmnts.catid)
		LEFT OUTER JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (cats.catid = ladders.catid)
		" . ($c ? " WHERE parentid = '$c' " : "") . "
		GROUP BY cats.catid
		ORDER BY cats.parentid DESC, cats.displayorder ASC, cats.title ASC
	");
	$ctarray  = array();
	while($cat = $vbulletin->db->fetch_array($cats))
	{
		$cat['countladders'] += (int)$ctarray["$cat[catid]"]['lcount'];
		$cat['counttmnts'] += (int)$ctarray["$cat[catid]"]['tcount'];
		$templater = vB_Template::create('tmnt_cat');
			$templater->register('cat', $cat);
			$templater->register('tmntp', $tmntp);
			$templater->register('rawfilter', $rawfilter);
			$templater->register('c', $c);
			$templater->register('filename', $filename);
		$ctarray["$cat[parentid]"]['lcount'] += $cat['countladders'];
		$ctarray["$cat[parentid]"]['tcount'] += $cat['counttmnts'];
		if (!$c && $cat['parentid'])
		{
			$carray["$cat[parentid]"] .= $templater->render();
		}
		else
		{
			$templater->register('subcs', $carray["$cat[catid]"]);
			$categories .= $templater->render();
		}
	}*/
	$filename = 'competitions';
	if ($vbulletin->tll_catcache)
	{
		foreach ($vbulletin->tll_catcache AS $cindex => $cat)
		{
			if ($c && $cat['parentid'] != $c)
			{
				continue;
			}
			$templater = vB_Template::create('tmnt_cat');
				$templater->register('cat', $cat);
				$templater->register('tmntp', $tmntp);
				$templater->register('rawfilter', $rawfilter);
				$templater->register('c', $c);
				$templater->register('filename', $filename);
			if (!$c && $cat['parentid'])
			{
				$carray["$cat[parentid]"] .= $templater->render();
			}
			else
			{
				$templater->register('subcs', $carray["$cat[catid]"]);
				$categories .= $templater->render();
			}
		}
	}
	$hide = array(
		'created' => true
	);
	if ($tmntp['canviewtmnt'])
	{
		$rowcount = 0;
		$tmnts = $vbulletin->db->query_read("
			SELECT tmnts.*
			FROM " . TABLE_PREFIX . "tmnt_tmnts AS tmnts
			WHERE tmnts.catid = '$c'
			ORDER BY tmnts.id DESC
			LIMIT 0, 6
		");
		while($tmnt = $vbulletin->db->fetch_array($tmnts))
		{
			if ($rowcount > 4)
			{
				$show['moretmnts'] = true;
				break;
			}
			$tmnt['players'] = $tmnt['noplayers'] - $tmnt['freeslots'];
	        $description = preg_replace('/\[(.*?)\]/is', '', $tmnt['description']);
			$descriptionlength = strlen($description);
			if ($descriptionlength > $vbulletin->options['tmnt_desclength'])
			{
				$description = substr($description, 0, $vbulletin->options['tmnt_desclength']);
				$description = $description . '...';
			}
			if ($tmnt['pot'])
			{
				$tmnt['pot'] = $vbphrase['tmnt_team'];
			}
			else
			{
				$tmnt['pot'] = '';
			}
			$tmnt = switch_tmnt_type($tmnt);
			$tmnt = switch_tmnt_status($tmnt);
			$rowcount++;
			$templater = vB_Template::create('tmnt_index_tbit');
				$templater->register('tmnt', $tmnt);
				$templater->register('hide', $hide);
			$latesttmnts .= $templater->render();
		}
		if ($rowcount == 0)
		{
			$templater = vB_Template::create('tmnt_notmnts');
			$latesttmnts .= $templater->render();
		}
		else if ($vbulletin->options['tmnt_fp_nv'])
		{
			//get latest tmnt winners
			if ($vbulletin->options['tmnt_fp_twins_loc'])
			{
				$parray = array();
				$players = $vbulletin->db->query_read("
					SELECT p.*, t.title AS ttitle
					FROM " . TABLE_PREFIX . "tmnt_players AS p
					LEFT JOIN " . TABLE_PREFIX . "tmnt_tmnts AS t
						ON (t.id = p.tid)
					WHERE p.winner = 1
					ORDER BY p.id DESC
					LIMIT 0, 5
				");
				while($player = $vbulletin->db->fetch_array($players))
				{
					$parray[] = $player;
				}
			}
			if ($vbulletin->options['tmnt_fp_com_loc'])
			{
				$tcarray = array();
				$comments = $vbulletin->db->query_read("
					SELECT c.*, t.title AS tmnttitle
					FROM " . TABLE_PREFIX . "tmnt_comments AS c
					LEFT JOIN " . TABLE_PREFIX . "tmnt_tmnts AS t
						ON (t.id = c.tid)
					WHERE t.catid = '$c'
					ORDER BY c.time DESC
					LIMIT 0, 15
				");
				$maxl = $vbulletin->options['tmnt_fp_com_cml'];
				while($comment = $vbulletin->db->fetch_array($comments))
				{
					$comment['comment'] = remove_bbcode($comment['comment']);
					if (strlen($comment['comment']) > $maxl)
					{
						$comment['comment'] = substr($comment['comment'], 0, $maxl)."<a href=\"tournaments.php?do=view&amp;id=".$comment['tid']."&amp;sh=4#vmessage".$comment['id']."\">...</a>";
					}
					$tcarray["$comment[id]"] = $comment;
					$show['comments'] = true;
					$show['comments_tc']++;
				}
			}
		}
	}
	if ($tmntp['canviewladder'])
	{
		$lrowcount = 0;
		$ladders = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladders
			WHERE catid = '$c' AND league = 0
			ORDER BY id DESC
			LIMIT 0, 6
		");
		while($ladder = $vbulletin->db->fetch_array($ladders))
		{
			if ($lrowcount > 4)
			{
				$show['moreladders'] = true;
				break;
			}
	        $description = preg_replace('/\[(.*?)\]/is', '', $ladder['description']);
			if (strlen($description) > $vbulletin->options['tmnt_desclength'])
			{
				$description = substr($description, 0, $vbulletin->options['tmnt_desclength']);
				$description = $description . '...';
			}
			$templater = vB_Template::create('tmnt_index_lbit');
				$templater->register('description', $description);
				$templater->register('hide', $hide);
				$templater->register('ladder', $ladder);
			$latestladders .= $templater->render();
			$lrowcount++;
		}
		if ($lrowcount == 0)
		{
			$templater = vB_Template::create('tmnt_ladder_noladders');
			$latestladders .= $templater->render();
		}
		$lgrowcount = 0;
		$leagues = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladders
			WHERE catid = '$c' AND league > 0
			ORDER BY id DESC
			LIMIT 0, 6
		");
		while($league = $vbulletin->db->fetch_array($leagues))
		{
			if ($lgrowcount > 4)
			{
				$show['moreleagues'] = true;
				break;
			}
	        $description = preg_replace('/\[(.*?)\]/is', '', $league['description']);
			if (strlen($description) > $vbulletin->options['tmnt_desclength'])
			{
				$description = substr($description, 0, $vbulletin->options['tmnt_desclength']);
				$description = $description . '...';
			}
			$templater = vB_Template::create('tmnt_index_lbit');
				$templater->register('description', $description);
				$templater->register('hide', $hide);
				$templater->register('ladder', $league);
			$latestleagues .= $templater->render();
			$lgrowcount++;
		}
		if ($lgrowcount == 0)
		{
			$templater = vB_Template::create('tmnt_ladder_noladders');
				$templater->register('league', 1);
			$latestleagues .= $templater->render();
		}
		if ($lrowcount > 0 || $lgrowcount > 0)
		{
			if ($vbulletin->options['tmnt_fp_com_loc'])
			{
				$mcarray = array();
				$comments = $vbulletin->db->query_read("
					SELECT mcs.*, games.*, usera.username AS username_u, userb.username AS username_u2, teama.teamname AS teamname_u, teamb.teamname AS teamname_u2, ladders.title AS laddertitle, mcs.dateline
					FROM " . TABLE_PREFIX . "tmnt_ladder_mcs AS mcs
					LEFT JOIN " . TABLE_PREFIX . "tmnt_ladder_games AS games
						ON (mcs.mid = games.id)
					LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
						ON (games.lid = ladders.id)
					LEFT JOIN " . TABLE_PREFIX . "user AS usera
						ON (games.u = usera.userid)
					LEFT JOIN " . TABLE_PREFIX . "user AS userb
						ON (games.u2 = userb.userid)
					LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teama
						ON (games.u = teama.teamid)
					LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teamb
						ON (games.u2 = teamb.teamid)
					WHERE ladders.catid = '$c'
						AND games.accepted = 1
					ORDER BY mcs.dateline DESC
					LIMIT 0, 15
				");
				$maxl = $vbulletin->options['tmnt_fp_com_cml'];
				while($comment = $vbulletin->db->fetch_array($comments))
				{
					$comment['comment'] = remove_bbcode($comment['comment']);
					if (strlen($comment['comment']) > $maxl)
					{
						$comment['comment'] = substr($comment['comment'], 0, $maxl)."<a href=\"ladders.php?do=view&amp;id=".$comment['lid'].($comment['finished'] ? "&amp;sh=1" : "&amp;sh=2")."&amp;mid=".$comment['mid']."#".$comment['mid']."\">...</a>";
					}
					$mcarray["$comment[mid]"] = $comment;
					$show['comments'] = true;
					$show['comments_mc']++;
				}
			}
			if ($vbulletin->options['tmnt_fp_mat_loc'])
			{
				list($count, $recentmatches, $upcomingmatches) = get_rg_ug($c);
			}
		}
	}
	$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_NOHTML);
	if (!in_array($sh, array('rg','ug')))
	{
		$sh = 'rg';
	}
	$show['fp'] = 1;
	$templater = vB_Template::create('tmnt_ladder_list_rm');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowcount', $rowcount);
		$templater->register('categorytitle', $categorytitle);
		$templater->register('categories', $categories);
		$templater->register('ladder', $ladder);
		$templater->register('template_hook', $template_hook);
		$templater->register('recentmatches', $recentmatches);
		$templater->register('upcomingmatches', $upcomingmatches);
		$templater->register('random', $random);
		$templater->register('count', $count);
		$templater->register('sh', $sh);
		$templater->register('show', $show);
		$templater->register('c', $c);
	$recentmatches = $templater->render();
	$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_NOHTML);
	if (!in_array($sh, array('l','t','lg')))
	{
		switch ($cinfo['tol'])
		{
			case 1:
				$sh = 't';
				break;
			default:
				$sh = 'l';
				break;
		}
		if (!$lrowcount)
		{
			$sh = 't';
		}
	}
	$csh = $vbulletin->input->clean_gpc('g', 'csh', TYPE_NOHTML);
	if ($csh == 'tc' OR !$show['comments_mc'] OR $cinfo['tol'] == 1)
	{
		$csh = 'tc';
	}
	else
	{
		$csh = 'mc';
	}
	if ($vbulletin->options['tmnt_fp_hof_loc'])
	{
		$show['marginbottom'] = true;
		$show['asblock'] = true;
		$rowcount = 1;
		$rowno = 0;
		$array = array();
		$hofs = $vbulletin->db->query_read("
			SELECT userid, username, tmnt_wins, tmnt_joins
			FROM " . TABLE_PREFIX . "user
			WHERE tmnt_wins != 0
				OR tmnt_joins != 0
			ORDER BY tmnt_wins DESC,
				tmnt_joins ASC
			LIMIT 0, 5
		");
		while($hof = $vbulletin->db->fetch_array($hofs))
		{
			$rowcount ++;
			$score = $hof['tmnt_wins'];
			if ($rowno == 0)
			{
				$topscore = $score;
				$lastscore_score = $topscore;
				$lastscore_row = 1;
			}
			$rowno ++;
			if ($score == $lastscore_score AND $rowno != 1)
			{
				$hof['rowno'] = $lastscore_row ."=";
			}
			else
			{
				$lastscore_row = $rowno;
				$lastscore_score = $score;
				$hof['rowno'] = $rowno;
			}
			$array[] = $hof;
		}
		$templater = vB_Template::create('tmnt_hof');
			$templater->register('array', $array);
			$templater->register('show', $show);
		$hofb .= $templater->render();
	}
	if (($x = $vbulletin->options['tmnt_fp_hof_loc']) && $hofb)
	{
		$template_hook['tmnt_fp_'.$x] .= $hofb;
	}
	if (($x = $vbulletin->options['tmnt_fp_anns_loc']) && $annarray)
	{
		$templater = vB_Template::create('tmnt_fpblock_anns');
			$templater->register('tmntp', $tmntp);
			$templater->register('annarray', $annarray);
		$template_hook['tmnt_fp_'.$x] .= $templater->render();
	}
	if (($x = $vbulletin->options['tmnt_fp_com_loc']) && ($mcarray || $tcarray))
	{
		$templater = vB_Template::create('tmnt_fpblock_comments');
			$templater->register('tmntp', $tmntp);
			$templater->register('mcarray', $mcarray);
			$templater->register('tcarray', $tcarray);
			$templater->register('show', $show);
			$templater->register('cinfo', $cinfo);
			$templater->register('csh', $csh);
		$template_hook['tmnt_fp_'.$x] .= $templater->render();
	}
	if (($x = $vbulletin->options['tmnt_fp_twins_loc']) && $parray)
	{
		$templater = vB_Template::create('tmnt_fpblock_twins');
			$templater->register('tmntp', $tmntp);
			$templater->register('parray', $parray);
		$template_hook['tmnt_fp_'.$x] .= $templater->render();
	}
	if ($x = $vbulletin->options['tmnt_fp_random_loc'])
	{
		$template_hook['tmnt_fp_'.$x] .= get_random_l_torp($c);
	}
	if (($x = $vbulletin->options['tmnt_fp_mat_loc']) && $recentmatches)
	{
		$css = '';
		$template_hook['tmnt_fp_'.$x] .= $recentmatches;
	}
	//$random2 = get_random_t_torp($c);
	$tlhtml = str_replace('{recentmatches}', $recentmatches, $tlhtml);
	if ($vbulletin->options['tmnt_fp_carousel'])
	{
		$tmnt_car_array = array();
		$query_banners = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_banners");
		while ($banner = $vbulletin->db->fetch_array($query_banners))
		{
			$tmnt_car_array[] = $banner;
		}
	}
	($hook = vBulletinHook::fetch_hook('tll_prepare_index')) ? eval($hook) : false;
	$templater = vB_Template::create('tmnt_index_c');
		$templater->register('latesttmnts', $latesttmnts);
		$templater->register('categories', $categories);
		$templater->register('c', $c);
		$templater->register('cinfo', $cinfo);
		$templater->register('show', $show);
		$templater->register('sh', $sh);
		$templater->register('csh', $csh);
		$templater->register('latestladders', $latestladders);
		$templater->register('latestleagues', $latestleagues);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_car_array', $tmnt_car_array);
		$templater->register('template_hook', $template_hook);
		$templater->register('recentmatches', $recentmatches);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname
	);
	if ($parentcategoryid)
	{
		$x = 'competitions.php' . $vbulletin->session->vars['sessionurl_q'] . "?c=$parentcategoryid";
		$navbits["$x"] = $parentcategorytitle;
	}
	if ($categorytitle)
	{
		$navbits[''] = $categorytitle;
	}
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
		$templater->register('show', $show);
	print_output($templater->render());
}

// #############################################################################

?>