<?php

/*======================================================================*\
|| #################################################################### ||
|| # Copyright  BananaLive Scripts. All Rights Reserved. ############# ||
|| #################################################################### ||
\*======================================================================*/

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT', 'tll_tickets');
$phrasegroups = array('posting', 'postbit', 'user', 'timezone', 'global', 'pm', 'reputationlevel', 'search');
$specialtemplates = array(
	'bbcodecache',
	'smiliecache',
	'tll_catcache',
);
$globaltemplates = array(
	'tmnt_shell',
	'tmnt_new_ticket',
	'tmnt_view_ticket',
	'tmnt_tickets',
	);
$actiontemplates = array(
);

require_once('./global.php');
require_once(DIR . '/includes/functions.php');
require_once(DIR . '/includes/functions_tal.php');
require_once(DIR . '/includes/functions_tll_premium.php');

$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'' => construct_phrase('Error')
	));
	$navbar = render_navbar_template($navbits);
	
	if (!$tmntp['canusetickets'] && !$tmntp['admintickets'])
	{
		print_no_permission();
	}
	
// #############################################################################

if ($_POST['do'] == 'insert_reply')
{
	if (!$tmntp['admintickets'] && !$tmntp['canusetickets'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'reply' => TYPE_NOHTML,
		'closed' => TYPE_UINT,
		'ticketid' => TYPE_UINT,
	));
	if (!$vbulletin->GPC['reply'])
	{
		$errormessage = 'Error, no reply.';
		eval(standard_error($errormessage));
	}
	if (!$vbulletin->GPC['ticketid'])
	{
		$errormessage = 'Error, invalid ticket.';
		eval(standard_error($errormessage));
	}
	$ticketid = $id = $vbulletin->GPC['ticketid'];
	$ticket = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tickets WHERE ticketid=$id");
	if (!$ticket)
	{
		$errormessage = 'Error, invalid ticket.';
		eval(standard_error($errormessage));
	}
	if (!$tmntp['admintickets'] && $ticket['userid'] != $vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}
	$vbulletin->db->query_write("
		INSERT INTO " . TABLE_PREFIX . "tmnt_ticketreply
			(dateline, ticketid, userid, response)
		VALUES (
			".TIMENOW.", 
			'".$vbulletin->db->escape_string($ticketid)."',
			'".$vbulletin->db->escape_string($vbulletin->userinfo['userid'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['reply'])."'
		)
	");
	if (!$vbulletin->GPC['closed'])
	{
		$vbulletin->GPC['closedby_dateline'] = $vbulletin->GPC['closedby_userid'] = 0;
	}
	else
	{
		$vbulletin->GPC['closedby_dateline'] = TIMENOW;
		$vbulletin->GPC['closedby_userid'] = $vbulletin->userinfo['userid'];
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_tickets
		SET replies = replies + 1,
			closed = '".$vbulletin->db->escape_string($vbulletin->GPC['closed'])."',
			closedby_dateline = '".$vbulletin->db->escape_string($vbulletin->GPC['closedby_dateline'])."',
			closedby_userid = '".$vbulletin->db->escape_string($vbulletin->GPC['closedby_userid'])."',
			lastreply_userid = '".$vbulletin->userinfo['userid']."',
			lastreply_dateline = '".TIMENOW."'
		WHERE ticketid=$id
	");
	if ($ticket['userid']!=$vbulletin->userinfo['userid'])
	{
		/* adding notification for u2 */
		$uinfo = fetch_userinfo($ticket['userid']);
		if (!is_array($uinfo['tmnt_notifications']) && $uinfo['tmnt_notifications'])
		{
			$uinfo['tmnt_notifications'] = unserialize($uinfo['tmnt_notifications']);
		}
		else if (!$uinfo['tmnt_notifications'])
		{
			$uinfo['tmnt_notifications'] = array();
		}
		$uinfo['tmnt_notifications']['support_tickets']++;
		$uinfo['tmnt_notifications'] = serialize($uinfo['tmnt_notifications']);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($uinfo['tmnt_notifications'])."' WHERE userid = '".$uinfo['userid']."'");
		/* end */
		/*PM*/
		$title = 'New Support Ticket Reply';
		$recipients = $uinfo['username'];
		$message = $thisusername." has replied to your support ticket. \r\n\r\n [url=".$vbulletin->options['bburl']."/tll_tickets.php?do=view&id=".$ticketid."]Click here to view the ticket.[/url]";
		$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
		$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
		$pmdm->set('fromusername', $vbulletin->userinfo['username']);
		$pmdm->set('title', $title);
		$pmdm->set('message', $message);
		$pmdm->set_recipients($recipients, $botpermissions);
		$pmdm->set('dateline', TIMENOW); 
		$pmdm->overridequota = true;
		$errors = $pmdm->errors;
		if ($errors) {
			foreach ($errors as $error) {
				$errorss .= $error. "<br />";
			}
			$errormessage = $errorss;
			eval(standard_error($errormessage));
		}
		$pmdm->save();
		unset($pmdm);
		/*PM*/
	}
	$userquery = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "user
		WHERE userid != '$thisuserid'
			AND tll_tickets_sub = 1
	");
	while($user = $vbulletin->db->fetch_array($userquery))
	{
		$uinfo = fetch_userinfo($user['userid']);
		if (!is_array($uinfo['tmnt_notifications']) && $uinfo['tmnt_notifications'])
		{
			$uinfo['tmnt_notifications'] = unserialize($uinfo['tmnt_notifications']);
		}
		else if (!$uinfo['tmnt_notifications'])
		{
			$uinfo['tmnt_notifications'] = array();
		}
		$uinfo['tmnt_notifications']['support_tickets']++;
		$uinfo['tmnt_notifications'] = serialize($uinfo['tmnt_notifications']);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($uinfo['tmnt_notifications'])."' WHERE userid = '".$uinfo['userid']."'");
		/* end */
		/*PM*/
		$title = 'New Support Ticket Response';
		$recipients = $uinfo['username'];
		$message = $thisusername." has replied to a support ticket. \r\n\r\n [url=".$vbulletin->options['bburl']."/tll_tickets.php?do=view&id=".$ticketid."]Click here to view the ticket.[/url]";
		$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
		$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
		$pmdm->set('fromusername', $vbulletin->userinfo['username']);
		$pmdm->set('title', $title);
		$pmdm->set('message', $message);
		$pmdm->set_recipients($recipients, $botpermissions);
		$pmdm->set('dateline', TIMENOW); 
		$pmdm->overridequota = true;
		$errors = $pmdm->errors;
		if ($errors) {
			foreach ($errors as $error) {
				$errorss .= $error. "<br />";
			}
			$errormessage = $errorss;
			eval(standard_error($errormessage));
		}
		$pmdm->save();
		unset($pmdm);
	}
	$vbulletin->url = "tll_tickets.php?do=view&id=".$id;
	eval(print_standard_redirect('redirect_ticketreply'));
}

// #############################################################################

if ($_POST['do'] == 'insert_ticket')
{
	if (!$tmntp['canusetickets'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'details' => TYPE_NOHTML,
		'paypal_ref' => TYPE_NOHTML,
		'issue' => TYPE_NOHTML,
		'teamid' => TYPE_UINT,
		'tmntid' => TYPE_UINT,
		'ladderid' => TYPE_UINT,
		'kingid' => TYPE_UINT,
		'challengeid' => TYPE_UINT,
		'priority' => TYPE_UINT,
	));
	if (!$vbulletin->GPC['details'])
	{
		$errormessage = 'Please fill out the details box.';
		eval(standard_error($errormessage));
	}
	if (!$vbulletin->GPC['issue'])
	{
		$errormessage = 'Please select the issue type.';
		eval(standard_error($errormessage));
	}
	if (!in_array($vbulletin->GPC['priority'], array(1,2,3)))
	{
		$errormessage = 'Priority level must be low, medium or high.';
		eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("
		INSERT INTO " . TABLE_PREFIX . "tmnt_tickets
			(dateline, userid, details, issue, teamid, ladderid, challengeid, tmntid, kingid, replies, closed, priority, paypal_ref)
		VALUES (
			".TIMENOW.", 
			'".$vbulletin->db->escape_string($vbulletin->userinfo['userid'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['details'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['issue'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['teamid'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['ladderid'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['challengeid'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['tmntid'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['kingid'])."',
			'0',
			'0',
			'".$vbulletin->db->escape_string($vbulletin->GPC['priority'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['paypal_ref'])."'
		)
	");
	$ticketid = $id = $vbulletin->db->insert_id();
	$userquery = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "user
		WHERE userid != '$thisuserid'
			AND tll_tickets_sub = 1
	");
	while($user = $vbulletin->db->fetch_array($userquery))
	{
		$uinfo = fetch_userinfo($user['userid']);
		if (!is_array($uinfo['tmnt_notifications']) && $uinfo['tmnt_notifications'])
		{
			$uinfo['tmnt_notifications'] = unserialize($uinfo['tmnt_notifications']);
		}
		else if (!$uinfo['tmnt_notifications'])
		{
			$uinfo['tmnt_notifications'] = array();
		}
		$uinfo['tmnt_notifications']['support_tickets']++;
		$uinfo['tmnt_notifications'] = serialize($uinfo['tmnt_notifications']);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($uinfo['tmnt_notifications'])."' WHERE userid = '".$uinfo['userid']."'");
		/* end */
		/*PM*/
		$title = 'New Support Ticket';
		$recipients = $uinfo['username'];
		$message = $thisusername." has created a support ticket. \r\n\r\n [url=".$vbulletin->options['bburl']."/tll_tickets.php?do=view&id=".$ticketid."]Click here to view the ticket.[/url]";
		$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
		$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
		$pmdm->set('fromusername', $vbulletin->userinfo['username']);
		$pmdm->set('title', $title);
		$pmdm->set('message', $message);
		$pmdm->set_recipients($recipients, $botpermissions);
		$pmdm->set('dateline', TIMENOW); 
		$pmdm->overridequota = true;
		$errors = $pmdm->errors;
		if ($errors) {
			foreach ($errors as $error) {
				$errorss .= $error. "<br />";
			}
			$errormessage = $errorss;
			eval(standard_error($errormessage));
		}
		$pmdm->save();
		unset($pmdm);
	}
	$vbulletin->url = "tll_tickets.php?do=view&id=".$id;
	eval(print_standard_redirect('redirect_insertticket'));
}

// #############################################################################

if ($_REQUEST['do'] == 'openclose')
{
	$vbulletin->input->clean_array_gpc('g', array(
		'closed' => TYPE_UINT,
		'ticketid' => TYPE_UINT,
	));
	$ticket = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tickets WHERE ticketid = '".$vbulletin->db->escape_string($vbulletin->GPC['ticketid'])."' ");
	if (!$ticket)
	{
		print_no_permission();
	}
	if (!($ticket['userid'] == $vbulletin->userinfo['userid'] && $tmntp['canusetickets']) && !$tmntp['admintickets'])
	{
		print_no_permission();
	}
	if (!$vbulletin->GPC['closed'])
	{
		$vbulletin->GPC['closedby_dateline'] = $vbulletin->GPC['closedby_userid'] = 0;
	}
	else
	{
		$vbulletin->GPC['closedby_dateline'] = TIMENOW;
		$vbulletin->GPC['closedby_userid'] = $vbulletin->userinfo['userid'];
	}
	if (!$vbulletin->GPC['closed'] && $ticket['closedby_dateline'] > 0 && $ticket['closedby_dateline'] + 604800 < TIMENOW)
	{
		$errormessage = 'You cannot re-open a support ticket once it has been closed for more than 7 days.';
		eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_tickets
		SET closed = '".$vbulletin->db->escape_string($vbulletin->GPC['closed'])."',
			closedby_dateline = '".$vbulletin->db->escape_string($vbulletin->GPC['closedby_dateline'])."',
			closedby_userid = '".$vbulletin->db->escape_string($vbulletin->GPC['closedby_userid'])."'
		WHERE ticketid='".$vbulletin->db->escape_string($vbulletin->GPC['ticketid'])."'
	");
	$vbulletin->url = "tll_tickets.php?do=view&id=".$vbulletin->GPC['ticketid'];
	eval(print_standard_redirect('redirect_ticketreply'));
}

// #############################################################################

if ($_REQUEST['do'] == 'subscribe')
{
	if (!$tmntp['admintickets'])
	{
		print_no_permission();
	}
	if ($vbulletin->userinfo['tll_tickets_sub'])
	{
		$sub = 0;
	}
	else
	{
		$sub = 1;
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "user
		SET tll_tickets_sub = '" . $sub . "'
		WHERE userid='".$vbulletin->userinfo['userid']."'
	");
	$vbulletin->url = "tll_tickets.php";
	eval(print_standard_redirect('redirect_subscibred_tickets'));
}

// #############################################################################

if ($_REQUEST['do'] == 'delete')
{
	if (!$tmntp['admintickets'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('g', array(
		'ticketid' => TYPE_UINT,
	));
	$ticket = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_tickets WHERE ticketid = '".$vbulletin->db->escape_string($vbulletin->GPC['ticketid'])."' ");
	if (!$ticket)
	{
		print_no_permission();
	}
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_tickets WHERE ticketid = '".$vbulletin->db->escape_string($vbulletin->GPC['ticketid'])."' ");
	$vbulletin->url = "tll_tickets.php";
	eval(print_standard_redirect('redirect_deletedticket'));
}

// #############################################################################

if ($_REQUEST['do'] == 'view')
{
	$ticketid = $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$ticket = $vbulletin->db->query_first("
		SELECT t.*, u.username, l.title AS ladder_title, tm.title AS tmnt_title, team.teamname, lr.username AS closedby_username, k.title AS king_title
		FROM " . TABLE_PREFIX . "tmnt_tickets AS t
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (u.userid = t.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS lr
			ON (lr.userid = t.closedby_userid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
			ON (t.ladderid = l.id)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_kings AS k
			ON (t.kingid = k.id)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_tmnts AS tm
			ON (t.tmntid = tm.id)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladder_games AS lg
			ON (t.challengeid = lg.id)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS team
			ON (t.teamid = team.teamid)
		WHERE t.ticketid=$id
	");
	if (!$ticket)
	{
		print_no_permission();
	}
	if (!($ticket['userid'] == $vbulletin->userinfo['userid'] && $tmntp['canusetickets']) && !$tmntp['admintickets'])
	{
		print_no_permission();
	}
	$ticket['date'] = vbdate($vbulletin->options['dateformat'], $ticket['dateline'], 0);
	$ticket['closedby_date'] = vbdate($vbulletin->options['dateformat'], $ticket['closedby_dateline'], 0);
	switch ($ticket['priority'])
	{
		case 3:
			$ticket['priority_text'] = 'High Priority';
			break;
		case 2:
			$ticket['priority_text'] = 'Medium Priority';
			break;
		case 1:
		default:
			$ticket['priority_text'] = 'Low Priority';
			break;
	}
	$array = array();
	$query_replies = $vbulletin->db->query_read("
		SELECT r.*, u.username
		FROM " . TABLE_PREFIX . "tmnt_ticketreply AS r
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (r.userid = u.userid)
		WHERE r.ticketid = '" . $ticketid . "'
		ORDER BY r.id ASC
	");
	while($row = $vbulletin->db->fetch_array($query_replies))
	{
		$row['date'] = vbdate($vbulletin->options['dateformat'], $row['dateline'], 0);
		$array[] = $row;
	}	
	$templater = vB_Template::create('tmnt_view_ticket');
		$templater->register('tmntp', $tmntp);
		$templater->register('ticket', $ticket);
		$templater->register('array', $array);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tll_tickets.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tmnt_ticket_system'],
		'' => construct_phrase($vbphrase['tmnt_ticket'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'new')
{
	if (!$tmntp['canusetickets'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('g', array(
		'details' => TYPE_NOHTML,
		'paypal_ref' => TYPE_NOHTML,
		'issue' => TYPE_NOHTML,
		'teamid' => TYPE_UINT,
		'tmntid' => TYPE_UINT,
		'ladderid' => TYPE_UINT,
		'challengeid' => TYPE_UINT,
		'priority' => TYPE_UINT,
	));
	$data = $vbulletin->GPC;
	$tmnts = $vbulletin->db->query_read("
		SELECT c.parentid AS pid, c.title AS categorytitle, t.*
		FROM " . TABLE_PREFIX . "tmnt_categories AS c
		RIGHT JOIN " . TABLE_PREFIX . "tmnt_tmnts AS t
			ON (t.catid = c.catid)
		ORDER BY c.displayorder DESC, t.title ASC
	");
	while($tmnt = $vbulletin->db->fetch_array($tmnts))
	{
		if (!$last_t || $last_t['catid'] != $tmnt['catid'])
		{
			if ($last_t)
			{
				$data['tmnt_sel_options'] .= '</optgroup>';
			}
			if (!$tmnt['catid'])
			{
				$tmnt['categorytitle'] = 'Uncategorised';
			}
			$data['tmnt_sel_options'] .= '<optgroup label="'.($tmnt['pid'] > 0 ? $vbulletin->tll_catcache["$tmnt[pid]"]['title'].": " : "").$tmnt['categorytitle'].'">';
		}
		$data['tmnt_sel_options'] .= '<option value="'.$tmnt['id'].'"'.($data['tmntid']==$tmnt['id'] ? ' selected="selected"' : "").'>'.$tmnt['title'].'</option>';
		$last_t = $tmnt;
	}
	$data['tmnt_sel_options'] .= '</optgroup>';
	$ladders = $vbulletin->db->query_read("
		SELECT c.parentid AS pid, c.title AS categorytitle, l.*
		FROM " . TABLE_PREFIX . "tmnt_categories AS c
		RIGHT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
			ON (l.catid = c.catid)
		ORDER BY c.displayorder DESC, l.title ASC
	");
	while($ladder = $vbulletin->db->fetch_array($ladders))
	{
		if (!$last_l || $last_l['catid'] != $ladder['catid'])
		{
			if ($last_l)
			{
				$data['ladder_sel_options'] .= '</optgroup>';
			}
			if (!$ladder['catid'])
			{
				$ladder['categorytitle'] = 'Uncategorised';
			}
			$data['ladder_sel_options'] .= '<optgroup label="'.($ladder['pid'] > 0 ? $vbulletin->tll_catcache["$ladder[pid]"]['title'].": " : "").$ladder['categorytitle'].'">';
		}
		$data['ladder_sel_options'] .= '<option value="'.$ladder['id'].'"'.($data['ladderid']==$ladder['id'] ? ' selected="selected"' : "").'>'.$ladder['title'].'</option>';
		$last_l = $ladder;
	}
	$data['ladder_sel_options'] .= '</optgroup>';
	$kings = $vbulletin->db->query_read("
		SELECT c.parentid AS pid, c.title AS categorytitle, k.*
		FROM " . TABLE_PREFIX . "tmnt_categories AS c
		RIGHT JOIN " . TABLE_PREFIX . "tmnt_kings AS k
			ON (k.catid = c.catid)
		ORDER BY c.displayorder DESC, k.title ASC
	");
	while($king = $vbulletin->db->fetch_array($kings))
	{
		if (!$last_k || $last_k['catid'] != $king['catid'])
		{
			if ($last_k)
			{
				$data['king_sel_options'] .= '</optgroup>';
			}
			if (!$king['catid'])
			{
				$king['categorytitle'] = 'Uncategorised';
			}
			$data['king_sel_options'] .= '<optgroup label="'.($king['pid'] > 0 ? $vbulletin->tll_catcache["$king[pid]"]['title'].": " : "").$king['categorytitle'].'">';
		}
		$data['king_sel_options'] .= '<option value="'.$king['id'].'"'.($data['kingid']==$king['id'] ? ' selected="selected"' : "").'>'.$king['title'].'</option>';
		$last_k = $king;
	}
	$data['ladder_sel_options'] .= '</optgroup>';
	$teams = $vbulletin->db->query_read("
		SELECT IF (m.id > 0, 1, 0) AS do, t.*
		FROM " . TABLE_PREFIX . "tmnt_teams AS t
		LEFT JOIN " . TABLE_PREFIX . "tmnt_members AS m
			ON (t.teamid = m.teamid AND m.userid = '$thisuserid')
		ORDER BY do DESC, t.teamname ASC
	");
	while($team = $vbulletin->db->fetch_array($teams))
	{
		if (!$tp && $team['do'])
		{
			$data['team_sel_options'] .= '<optgroup label="Your Teams">';
			$tp = true;
		}
		if (!$tt && !$team['do'])
		{
			if ($tp)
			{
				$data['team_sel_options'] .= '</optgroup>';
			}
			$data['team_sel_options'] .= '<optgroup label="Other Teams">';
			$tt = true;
		}
		$data['team_sel_options'] .= '<option value="'.$team['teamid'].'"'.($data['teamid']==$team['teamid'] ? ' selected="selected"' : "").'>'.$team['teamname'].'</option>';
		$last_t = $team;
	}
	$data['team_sel_options'] .= '</optgroup>';
	$templater = vB_Template::create('tmnt_new_ticket');
		$templater->register('tmntp', $tmntp);
		$templater->register('data', $data);
	$tlhtml .= $templater->render();
	if ($vbulletin->GPC['issue'])
	{
		$tlhtml = str_replace('<option>'.$vbulletin->GPC['issue'].'</option>', '<option selected="selected">'.$vbulletin->GPC['issue'].'</option>', $tlhtml);
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tll_tickets.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['tmnt_ticket_system'],
		'' => construct_phrase($vbphrase['tmnt_new_ticket'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

	if ($vbulletin->userinfo['tmnt_notifications'])
	{
		if (!is_array($vbulletin->userinfo['tmnt_notifications']))
		{
			$vbulletin->userinfo['tmnt_notifications'] = unserialize($vbulletin->userinfo['tmnt_notifications']);
		}
		if ($vbulletin->userinfo['tmnt_notifications']['support_tickets'] > 0)
		{
			$vbulletin->userinfo['tmnt_notifications']['support_tickets'] = 0;
			$vbulletin->userinfo['tmnt_notifications'] = serialize($vbulletin->userinfo['tmnt_notifications']);
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($vbulletin->userinfo['tmnt_notifications'])."' WHERE userid = '".$vbulletin->userinfo['userid']."'");
		}
	}
	$vbulletin->input->clean_array_gpc('g', array(
		'page' => TYPE_UINT,
		'ladderid' => TYPE_UINT,
		'tmntid' => TYPE_UINT,
		'pp' => TYPE_UINT,
		'status' => TYPE_NOHTML,
		'priority' => TYPE_UINT,
		'username' => TYPE_NOHTML,
		'issue' => TYPE_NOHTML,
	));
	$filter = array(
		'status' => $vbulletin->GPC['status'],
		'priority' => $vbulletin->GPC['priority'],
		'username' => $vbulletin->GPC['username'],
		'issue' => $vbulletin->GPC['issue'],
		'ladderid' => $vbulletin->GPC['ladderid'],
		'tmntid' => $vbulletin->GPC['tmntid'],
	);
	//pagenav
	$where_cond = '';
	if (!$tmntp['admintickets'])
	{
		$where_cond .= ' WHERE t.userid = '.$vbulletin->userinfo['userid'] .' ';
	}
	if (in_array($filter['status'], array($vbphrase['tmnt_ticket_open'], $vbphrase['tmnt_ticket_closed'])))
	{
		switch ($filter['status'])
		{
			case $vbphrase['tmnt_ticket_open']:
				$where_cond .= ($where_cond ? " AND " : " WHERE ") . ' t.closed = 0 ';
				break;
			case $vbphrase['tmnt_ticket_closed']:
				$where_cond .= ($where_cond ? " AND " : " WHERE ") . ' t.closed = 1 ';
				break;
		}
	}
	if (in_array($filter['priority'], array(1,2,3)))
	{
		$where_cond .= ($where_cond ? " AND " : " WHERE ") . ' t.priority = ' . $filter['priority'] . ' ';
	}
	if ($filter['username'])
	{
		$where_cond .= ($where_cond ? " AND " : " WHERE ") . " u.username LIKE '%" . $filter['username'] . "%' ";
	}
	if ($filter['issue'])
	{
		$where_cond .= ($where_cond ? " AND " : " WHERE ") . " t.issue = '" . $filter['issue'] . "' ";
	}
	if ($filter['ladderid'])
	{
		$where_cond .= ($where_cond ? " AND " : " WHERE ") . " t.ladderid = '" . $filter['ladderid'] . "' ";
	}
	if ($filter['tmntid'])
	{
		$where_cond .= ($where_cond ? " AND " : " WHERE ") . " t.tmntid = '" . $filter['tmntid'] . "' ";
	}
	$count = $vbulletin->db->query_first("
		SELECT COUNT(*) AS countrows 
		FROM " . TABLE_PREFIX . "tmnt_tickets AS t
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (u.userid = t.userid)
		$where_cond 
	");
	if (!$vbulletin->GPC['page'])
	{
		$vbulletin->GPC['page'] = 1;
	}
	if (!$vbulletin->GPC['pp'])
	{
		$vbulletin->GPC['pp'] = 10;
	}
	$pagenav = construct_page_nav($vbulletin->GPC['page'], $vbulletin->GPC['pp'], $count['countrows'], "tll_tickets.php?" . $vbulletin->session->vars['sessionurl'] . "pp=".$vbulletin->GPC['pp']);
	$limit = ($vbulletin->GPC['page']-1)*$vbulletin->GPC['pp'];
	$array = array();
	$tickets = $vbulletin->db->query_read("
		SELECT t.*, u.username, l.title AS ladder_title, tm.title AS tmnt_title, team.teamname, lr.username AS lastreply_username
		FROM " . TABLE_PREFIX . "tmnt_tickets AS t
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (u.userid = t.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS lr
			ON (lr.userid = t.lastreply_userid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
			ON (t.ladderid = l.id)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_tmnts AS tm
			ON (t.tmntid = tm.id)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladder_games AS lg
			ON (t.challengeid = lg.id)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS team
			ON (t.teamid = team.teamid)
		$where_cond
		ORDER BY closed ASC, lastreply_dateline DESC, ticketid DESC
		LIMIT $limit, ".$vbulletin->GPC['pp']."
	");
	while($ticket = $vbulletin->db->fetch_array($tickets))
	{
		switch ($ticket['priority'])
		{
			case 3:
				$ticket['priority_text'] = $vbphrase['tmnt_high_priority'];
				break;
			case 2:
				$ticket['priority_text'] = $vbphrase['tmnt_medium_priority'];
				break;
			case 1:
			default:
				$ticket['priority_text'] = $vbphrase['tmnt_low_priority'];
				break;
		}
		switch ($ticket['closed'])
		{
			case 1:
				$ticket['status_text'] = $vbphrase['tmnt_ticket_closed'];
				$ticket['class'] = ' shade';
				break;
			case 0:
			default:
				$ticket['status_text'] = $vbphrase['tmnt_ticket_open'];
				$ticket['class'] = '';
				break;
		}
		$ticket['date'] = vbdate($vbulletin->options['dateformat'], $ticket['dateline'], 0);
		$ticket['lastreply_date'] = vbdate($vbulletin->options['dateformat'], $ticket['lastreply_dateline'], 0);
		$array[] = $ticket;
	}
	$templater = vB_Template::create('tmnt_tickets');
		$templater->register('tmntp', $tmntp);
		$templater->register('array', $array);
		$templater->register('pagenav', $pagenav);
		$templater->register('filter', $filter);
	$tlhtml .= $templater->render();
	if ($filter['issue'])
	{
		$tlhtml = str_replace('<option>'.$filter['issue'].'</option>','<option selected="selected">'.$filter['issue'].'</option>',$tlhtml);
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'' => construct_phrase($vbphrase['tmnt_ticket_system'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
	
// #############################################################################

?>