<?php

/*======================================================================*\
|| #################################################################### ||
|| # Copyright  BananaLive Scripts. All Rights Reserved. ############# ||
|| #################################################################### ||
\*======================================================================*/

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT', 'tll_credits');
$phrasegroups = array('posting', 'postbit', 'user', 'timezone', 'global', 'pm', 'reputationlevel', 'search');
$specialtemplates = array(
	'bbcodecache',
	'smiliecache',
	'tll_catcache',
);
$globaltemplates = array(
	'tmnt_shell',
	'tmnt_credits_nav',
);
$actiontemplates = array(
	'admin_give_credits' => array(
		'tmnt_credits_adminuser'
	),
	'cashout' => array(
		'tmnt_credits_cashout'
	),
	'cashout_requests' => array(
		'tmnt_cashout_requests'
	),
	'give_credits' => array(
		'tmnt_give_credits'
	),
	'give_team_credits' => array(
		'tmnt_give_credits'
	),
	'user_credits' => array(
		'tmnt_credits_users'
	),
	'hist_paypal_transactions' => array(
		'tmnt_credits_histpp'
	),
	'hist_credits_transactions' => array(
		'tmnt_credits_histcr'
	),
	'divide_team_credits' => array (
		'tmnt_divide_team_credits'
	),
	'profits' => array(
		'tmnt_credits_profits'
	),
	'credits' => array(
		'tmnt_credits'
	)
);
$actiontemplates['none'] =& $actiontemplates['credits'];

require_once('./global.php');
require_once(DIR . '/includes/functions.php');
require_once(DIR . '/includes/functions_tal.php');
require_once(DIR . '/includes/functions_tll_premium.php');

$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'' => construct_phrase('Error')
	));
	$navbar = render_navbar_template($navbits);
	
$templater = vB_Template::create('tmnt_credits_nav');
	$templater->register('tmntp', $tmntp);
$credits_nav .= $templater->render();
	
// #############################################################################

if (!$vbulletin->options['tmnt_premium'] OR !$vbulletin->options['tmnt_credit_system'] OR !$vbulletin->userinfo['userid'] OR !$tmntp['canusecredits'])
{
	print_no_permission();
}

// #############################################################################

if ($_REQUEST['do'] == 'kill_pp_trans')
{
	if (!$tmntp['admincredits'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('g', array(
		'id' => TYPE_UINT,
		'userid' => TYPE_UINT,
		'dateline' => TYPE_UINT,
		'hash' => TYPE_NOHTML,
		'page' => TYPE_UINT,
		'pp' => TYPE_UINT,
	));
	$vbulletin->db->query_write("
		DELETE FROM " . TABLE_PREFIX . "tmnt_credits
		WHERE id = '".$vbulletin->db->escape_string($vbulletin->GPC['id'])."'
			AND userid = '".$vbulletin->db->escape_string($vbulletin->GPC['userid'])."'
			AND dateline = '".$vbulletin->db->escape_string($vbulletin->GPC['dateline'])."'
			AND hash = '".$vbulletin->db->escape_string($vbulletin->GPC['hash'])."'
	");
	$vbulletin->url = "tll_credits.php?do=hist_paypal_transactions&pp=".$vbulletin->GPC['pp']."&page=".$vbulletin->GPC['page'];
	eval(print_standard_redirect('redirect_killhistpptrans'));
}

// #############################################################################

if ($_POST['do'] == 'give_credits')
{
	if (!$tmntp['cangivecredits'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'userid' => TYPE_UINT,
		'credits' => TYPE_NUM,
	));
	$user = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "user WHERE userid = '".$vbulletin->GPC['userid']."' ");
	if (!$user)
	{
		$errormessage = 'Invalid user selected.';
		eval(standard_error($errormessage));
	}
	if ($vbulletin->GPC['credits'] == 0)
	{
		$errormessage = 'Please enter some credits to transfer.';
		eval(standard_error($errormessage));
	}
	if ($vbulletin->userinfo['tmnt_credits'] < $vbulletin->GPC['credits'])
	{
		$errormessage = 'Insufficient credits for transaction.';
		eval(standard_error($errormessage));
	}
	if ($vbulletin->userinfo['userid'] == $vbulletin->GPC['userid'])
	{
		$errormessage = 'Cannot gift to yourself.';
		eval(standard_error($errormessage));
	}
	process_credits_transaction($user['userid'], $vbulletin->GPC['credits'], 'Gift from another user', $vbulletin->userinfo['userid'], $user['userid']);
	process_credits_transaction($vbulletin->userinfo['userid'], -$vbulletin->GPC['credits'], 'Gift to another user', $vbulletin->userinfo['userid'], $user['userid']);
	/*PM*/
	require_once('./includes/functions_databuild.php');
	$title = 'You have received credits';
	$recipients = $user['username'];
	$message = $thisusername." has sent you " . $vbulletin->GPC['credits'] . " credits. \r\n\r\n [url=" . $vbulletin->options['bburl'] . "/tll_credits.php?do=credits]View your credits[/url]";
	$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
	$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
	$pmdm->set('fromusername', $vbulletin->userinfo['username']);
	$pmdm->set('title', $title);
	$pmdm->set('message', $message);
	$pmdm->set_recipients($recipients, $botpermissions);
	$pmdm->set('dateline', TIMENOW); 
	$pmdm->overridequota = true;
	$errors = $pmdm->errors;
	if ($errors) {
		foreach ($errors as $error) {
			$errorss .= $error. "<br />";
		}
		$errormessage = $errorss;
		eval(standard_error($errormessage));
	}
	$pmdm->save();
	unset($pmdm);
	/*PM*/
	$vbulletin->url = "tll_credits.php?do=credits";
	eval(print_standard_redirect('redirect_giftedcredits'));
}

// #############################################################################

if ($_POST['do'] == 'give_team_credits')
{
	if (!$tmntp['cangivecredits'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'teamid' => TYPE_UINT,
		'credits' => TYPE_NUM,
	));
	$team = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid = '".$vbulletin->GPC['teamid']."' ");
	if (!$team)
	{
		$errormessage = 'Invalid team selected.';
		eval(standard_error($errormessage));
	}
	if ($vbulletin->GPC['credits'] == 0)
	{
		$errormessage = 'Please enter some credits to transfer.';
		eval(standard_error($errormessage));
	}
	if ($vbulletin->userinfo['tmnt_credits'] < $vbulletin->GPC['credits'])
	{
		$errormessage = 'Insufficient credits for transaction.';
		eval(standard_error($errormessage));
	}
	process_credits_transaction($team['teamid'], $vbulletin->GPC['credits'], 'Received from user', $vbulletin->userinfo['userid'], 0, $team['teamid'], 1);
	process_credits_transaction($vbulletin->userinfo['userid'], -$vbulletin->GPC['credits'], 'Paid to team', $vbulletin->userinfo['userid'], 0, $team['teamid']);
	$vbulletin->url = "teams.php?do=viewteam&id=".$team['teamid']."&tab=credits";
	eval(print_standard_redirect('redirect_giftedcredits'));
}

// #############################################################################

if ($_POST['do'] == 'divide_team_credits')
{
	if (!$tmntp['cangivecredits'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'teamid' => TYPE_UINT,
		'credits' => TYPE_NUM,
		'tm' => TYPE_ARRAY_UINT,
	));
	$teamid = $vbulletin->GPC['teamid'];
	$team = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid = '".$teamid."' ");
	if (!$team)
	{
		$errormessage = 'Invalid team selected.';
		eval(standard_error($errormessage));
	}
	$parray = array();
	$isleader = false;
	$p_query = $vbulletin->db->query_read("
		SELECT p.*, u.username
		FROM " . TABLE_PREFIX . "tmnt_members AS p
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (p.userid = u.userid)
		WHERE p.teamid = '$teamid'
			AND p.accepted = 1
		ORDER BY u.username ASC
	");
	while($row = $vbulletin->db->fetch_array($p_query))
	{
		if ($row['leader'] && $row['userid'] == $vbulletin->userinfo['userid'])
		{
			$isleader = true;
		}
		$parray[] = $row['userid'];
	}
	if (!$isleader)
	{
		print_no_permission();
	}
	if ($vbulletin->GPC['credits'] == 0)
	{
		$errormessage = 'Please enter some credits to transfer.';
		eval(standard_error($errormessage));
	}
	if ($team['tmnt_credits'] < $vbulletin->GPC['credits'])
	{
		$errormessage = 'Insufficient credits for transaction.';
		eval(standard_error($errormessage));
	}
	$count = count($vbulletin->GPC['tm']);
	if ($count==0)
	{
		$errormessage = 'Please select some team members.';
		eval(standard_error($errormessage));
	}
	foreach ($vbulletin->GPC['tm'] AS $i => $tm_userid)
	{
		if (!in_array($tm_userid,$parray))
		{
			print_no_permission();
		}
	}
	if ($vbulletin->options['tmnt_credits_teamcomm'])
	{
		$profits = $vbulletin->options['tmnt_credits_teamcomm'] * $vbulletin->GPC['credits'];
		$vbulletin->GPC['credits'] = (1-$vbulletin->options['tmnt_credits_teamcomm']) * $vbulletin->GPC['credits'];
		process_credits_transaction($vbulletin->userinfo['userid'], -$profits, 'Forum charge', 0, 0, $team['teamid'], 1);
		update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), $profits, TIMENOW);
	}
	$share =  floor(($vbulletin->GPC['credits']*100) / $count)/100;
	foreach ($vbulletin->GPC['tm'] AS $i => $tm_userid)
	{
		process_credits_transaction($tm_userid, $share, 'Received from team', 0, $tm_userid, $team['teamid']);
		process_credits_transaction($vbulletin->userinfo['userid'], -$share, 'Paid user', 0, $tm_userid, $team['teamid'], 1);
	}
	$vbulletin->url = "teams.php?do=viewteam&id=".$team['teamid']."&tab=credits";
	eval(print_standard_redirect('redirect_giftedcredits'));
}

// #############################################################################

if ($_POST['do'] == 'divide_team_credits')
{
	if (!$tmntp['cangivecredits'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'teamid' => TYPE_UINT,
		'credits' => TYPE_NUM,
	));
	$team = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid = '".$vbulletin->GPC['teamid']."' ");
	if (!$team)
	{
		$errormessage = 'Invalid team selected.';
		eval(standard_error($errormessage));
	}
	if ($vbulletin->GPC['credits'] == 0)
	{
		$errormessage = 'Please enter some credits to transfer.';
		eval(standard_error($errormessage));
	}
	if ($vbulletin->userinfo['tmnt_credits'] < $vbulletin->GPC['credits'])
	{
		$errormessage = 'Insufficient credits for transaction.';
		eval(standard_error($errormessage));
	}
	process_credits_transaction($team['teamid'], $vbulletin->GPC['credits'], 'Received from user', $vbulletin->userinfo['userid'], 0, $team['teamid'], 1);
	process_credits_transaction($vbulletin->userinfo['userid'], -$vbulletin->GPC['credits'], 'Paid to team', $vbulletin->userinfo['userid'], 0, $team['teamid']);
	$vbulletin->url = "teams.php?do=viewteam&id=".$team['teamid']."&tab=credits";
	eval(print_standard_redirect('redirect_giftedcredits'));
}

// #############################################################################

if ($_POST['do'] == 'cashout')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'credits' => TYPE_UNUM,
		'confirm' => TYPE_BOOL,
		'paypal_email' => TYPE_NOHTML,
	));
	if ($vbulletin->GPC['credits'] == 0)
	{
		$errormessage = 'Please enter the amount of credits you wish to sell.';
		eval(standard_error($errormessage));
	}
	if ($vbulletin->GPC['credits'] > $vbulletin->options['tmnt_max_cashout'])
	{
		$errormessage = 'Error, the maximum number of credits you can sell in one request is '.$vbulletin->options['tmnt_max_cashout'].'.';
		eval(standard_error($errormessage));
	}
	if ($vbulletin->GPC['credits'] < $vbulletin->options['tmnt_min_cashout'])
	{
		$errormessage = 'Error, the minimum number of credits you can sell is '.$vbulletin->options['tmnt_min_cashout'].'.';
		eval(standard_error($errormessage));
	}
	$amount = $vbulletin->GPC['credits'] * $vbulletin->options['tmnt_credit_value'] - $vbulletin->options['tmnt_cashout_fee'];
	if ($amount <= 0)
	{
		$errormessage = 'Error, your cash out value is less than the cash out fee.';
		eval(standard_error($errormessage));
	}
	if ($vbulletin->GPC['credits'] > $vbulletin->userinfo['tmnt_credits'])
	{
		$errormessage = 'Error, you only have '.$vbulletin->userinfo['tmnt_credits'].'.';
		eval(standard_error($errormessage));
	}
	if (!$vbulletin->GPC['confirm'])
	{
		$post = array(
			'credits' => $vbulletin->GPC['credits'],
			'paypal_email' => $vbulletin->GPC['paypal_email'],
			'amount' => number_format($amount, 2)
		);
		$info = array(
			'currency_symbol' => fetch_currency_symbol($vbulletin->options['tmnt_credits_currency'])
		);
		$vbulletin->options['tmnt_cashout_fee'] = number_format($vbulletin->options['tmnt_cashout_fee'], 2);
		$templater = vB_Template::create('tmnt_credits_cashout');
			$templater->register('tmntp', $tmntp);
			$templater->register('credits_nav', $credits_nav);
			$templater->register('post', $post);
			$templater->register('info', $info);
		$tlhtml .= $templater->render();
		$navbits = construct_navbits(array(
			'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
			'tll_credits.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=credits' => $vbphrase['tmnt_credits'],
			'' => 'Sell Credits'
		));
		$navbar = render_navbar_template($navbits);
		$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
		print_output($templater->render());
		
	}
	else
	{
		$credits_profit = $vbulletin->options['tmnt_cashout_fee'] / $vbulletin->options['tmnt_credit_value'];
		update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), $credits_profit, TIMENOW);
		process_credits_transaction($vbulletin->userinfo['userid'], -$vbulletin->GPC['credits'], 'Sell back credits');
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "tmnt_credits_cashout
				(dateline, userid, credits, amount, hash, paypal_email)
			VALUES (".TIMENOW.", '".$vbulletin->userinfo['userid']."', '".$vbulletin->db->escape_string($vbulletin->GPC['credits'])."', '".$vbulletin->db->escape_string($amount)."', '".tll_generate_hash(10)."', '".$vbulletin->db->escape_string($vbulletin->GPC['paypal_email'])."')
		");
		$vbulletin->url = "tll_credits.php?do=credits";
		eval(print_standard_redirect('redirect_sellcredits'));
	}
}

// #############################################################################

if ($_REQUEST['do'] == 'admin_give_credits')
{
	if (!$tmntp['admincredits'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('g', array(
		'post' => TYPE_UINT,
		'userid' => TYPE_UINT,
		'credits' => TYPE_NUM,
		'reason' => TYPE_NOHTML,
	));
	$user = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "user WHERE userid = '".$vbulletin->GPC['userid']."' ");
	if ($vbulletin->GPC['credits'] == 0 OR !$user OR !$vbulletin->GPC['post'])
	{
		$templater = vB_Template::create('tmnt_credits_adminuser');
			$templater->register('tmntp', $tmntp);
			$templater->register('user', $user);
			$templater->register('reason', $vbulletin->GPC['reason']);
			$templater->register('credits', $vbulletin->GPC['credits']);
			$templater->register('credits_nav', $credits_nav);
		$tlhtml .= $templater->render();
		$navbits = construct_navbits(array(
			'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
			'tll_credits.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=credits' => $vbphrase['tmnt_credits'],
			'' => 'Admin Give/Take Credits'
		));
		$navbar = render_navbar_template($navbits);
		$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
		print_output($templater->render());
	}
	if ($vbulletin->GPC['credits'] < 0 && -$vbulletin->GPC['credits'] > $user['tmnt_credits'])
	{
		$errormessage = 'Error, user only has '.$user['tmnt_credits'].' credits.';
		eval(standard_error($errormessage));
	}
	$reason = 'Admin';
	if ($vbulletin->GPC['reason'])
	{
		$reason .= ': '.$vbulletin->GPC['reason'];
	}
	process_credits_transaction($user['userid'], $vbulletin->GPC['credits'], $reason, 0, $user['userid']);
	/*PM*/
	require_once('./includes/functions_databuild.php');
	$title = 'You have received credits';
	$recipients = $user['username'];
	$message = "Admin has sent you " . $vbulletin->GPC['credits'] . " credits. " . ($vbulletin->GPC['reason'] ? "\r\n\r\n Reason: ".$vbulletin->GPC['reason'] : "") . "\r\n\r\n [url=" . $vbulletin->options['bburl'] . "/tll_credits.php?do=credits]View your credits[/url]";
	$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
	$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
	$pmdm->set('fromusername', $vbulletin->userinfo['username']);
	$pmdm->set('title', $title);
	$pmdm->set('message', $message);
	$pmdm->set_recipients($recipients, $botpermissions);
	$pmdm->set('dateline', TIMENOW); 
	$pmdm->overridequota = true;
	$errors = $pmdm->errors;
	if ($errors) {
		foreach ($errors as $error) {
			$errorss .= $error. "<br />";
		}
		$errormessage = $errorss;
		eval(standard_error($errormessage));
	}
	$pmdm->save();
	unset($pmdm);
	/*PM*/
	$vbulletin->url = "tll_credits.php?do=user_credits";
	eval(print_standard_redirect('redirect_giftedcredits'));
}

// #############################################################################

if ($_REQUEST['do'] == 'markpaid')
{
	if (!$tmntp['processpayments'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('g', array(
		'id' => TYPE_UINT,
		'hash' => TYPE_NOHTML,
	));
	$query = $vbulletin->db->query_first("
		SELECT c.*, u.username
		FROM " . TABLE_PREFIX . "tmnt_credits_cashout AS c
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (u.userid = c.userid)
		WHERE c.id='".$vbulletin->db->escape_string($vbulletin->GPC['id'])."' AND c.hash='".$vbulletin->db->escape_string($vbulletin->GPC['hash'])."'
	");
	if (!$query)
	{
		print_no_permission();
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_credits_cashout
		SET paid = 1, paid_dateline = '".TIMENOW."'
		WHERE id = '".$vbulletin->db->escape_string($vbulletin->GPC['id'])."'
			AND hash = '".$vbulletin->db->escape_string($vbulletin->GPC['hash'])."'
	");
	$recipients = $query['username'];
	$fromuserid = $thisuserid;
	$fromusername = $thisusername;
	$title = 'Credits - You have been paid';
	$message = 'Your credits sale has just been processed and marked as paid by an admin. It will appear in your paypal account shortly.';
	require_once('./includes/functions_databuild.php');
	$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
		$pmdm->set('fromuserid', $fromuserid);
		$pmdm->set('fromusername', $fromusername);
		$pmdm->set('title', $title);
		$pmdm->set('message', $message);
		$pmdm->set_recipients($recipients, $botpermissions);
		$pmdm->set('dateline', TIMENOW); 
		$pmdm->overridequota = true;
		$errors = $pmdm->errors;
		if ($errors) {
			foreach ($errors as $error) {
				$errorss .= $error. "<br />";
			}
			$errormessage = $errorss;
			eval(standard_error($errormessage));
		}
	$pmdm->save();
	unset($pmdm);
	$vbulletin->url = "tll_credits.php?do=cashout_requests";
	eval(print_standard_redirect('redirect_credits_paid'));
}

// #############################################################################

if ($_REQUEST['do'] == 'cashout_requests')
{
	if (!$tmntp['processpayments'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('g', array(
		'page' => TYPE_UINT,
		'pp' => TYPE_UINT,
		'unpaid' => TYPE_BOOL,
		'export' => TYPE_NOHTML,
	));
	$where_cond = '';
	if ($vbulletin->GPC['unpaid'])
	{
		$where_cond .= ' WHERE c.paid = 0 ';
	}
	$count = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_credits_cashout AS c $where_cond");
	if (!$vbulletin->GPC['page'])
	{
		$vbulletin->GPC['page'] = 1;
	}
	if (!$vbulletin->GPC['pp'])
	{
		$vbulletin->GPC['pp'] = 10;
	}
	$array = array();
	$pagenav = construct_page_nav($vbulletin->GPC['page'], $vbulletin->GPC['pp'], $count['countrows'], "tll_credits.php?" . $vbulletin->session->vars['sessionurl'] . "do=cashout_requests&amp;pp=".$vbulletin->GPC['pp']);
	$limit = ($vbulletin->GPC['page']-1)*$vbulletin->GPC['pp'];
	$query = $vbulletin->db->query_read("
		SELECT c.*, u.username
		FROM " . TABLE_PREFIX . "tmnt_credits_cashout AS c
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (u.userid = c.userid)
		$where_cond
		ORDER BY c.id DESC
		LIMIT $limit, ".$vbulletin->GPC['pp']."
	");
	while($row = $vbulletin->db->fetch_array($query))
	{
		$row['date'] = vbdate($vbulletin->options['dateformat'], $row['dateline'], 0);
		$row['paid_date'] = vbdate($vbulletin->options['dateformat'], $row['paid_dateline'], 0);
		$array[] = $row;
	}
	$currency_symbol = fetch_currency_symbol($vbulletin->options['tmnt_credits_currency']);
	if ($vbulletin->GPC['export'])
	{
		if ($vbulletin->GPC['export']=='csv')
		{
			$delimiter = ",";
			$fileext = $vbulletin->GPC['export'];
		}
		else
		{
			$delimiter = "\t";
			$fileext = 'txt';
		}
		$filename="paypal_masspay.$fileext";
		header("Content-type: application/octet-stream");
		header("Content-Disposition: attachment; filename=$filename");
		header("Pragma: no-cache");
		header("Expires: 0");
		foreach ($array as $subArrayKey => $subArray)
		{
			//Separate each datapoint in the row with the delimiter
			//$dataRowString = implode($delimiter, $subArray);
			$dataRowString = $subArray['paypal_email'].$delimiter.$subArray['amount'].$delimiter.$vbulletin->options['tmnt_credits_currency'].$delimiter.$subArray['hash'].$delimiter.'You sold ' . $subArray['credits'] .' credits';
			print $dataRowString . "\r\n";
		}
		exit;
	}
	$templater = vB_Template::create('tmnt_cashout_requests');
		$templater->register('tmntp', $tmntp);
		$templater->register('credits_nav', $credits_nav);
		$templater->register('array', $array);
		$templater->register('currency_symbol', $currency_symbol);
		$templater->register('timenow', TIMENOW);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tll_credits.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=credits' => $vbphrase['tmnt_credits'],
		'' => 'Credit Sales Requests'
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'give_credits')
{
	if (!$tmntp['cangivecredits'])
	{
		print_no_permission();
	}
	if ($vbulletin->userinfo['tmnt_credits']==0)
	{
		$errormessage = 'Error, you have no credits to give to other users.';
		eval(standard_error($errormessage));
	}
	$vbulletin->input->clean_array_gpc('g', array(
		'userid' => TYPE_UINT,
	));
	$userinfo = fetch_userinfo($vbulletin->GPC['userid']);
	$templater = vB_Template::create('tmnt_give_credits');
		$templater->register('tmntp', $tmntp);
		$templater->register('credits_nav', $credits_nav);
		$templater->register('userid', $vbulletin->GPC['userid']);
		$templater->register('userinfo', $userinfo);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tll_credits.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=credits' => $vbphrase['tmnt_credits'],
		'' => construct_phrase($vbphrase['tmnt_give_credits'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'give_team_credits')
{
	if (!$tmntp['cangivecredits'])
	{
		print_no_permission();
	}
	if ($vbulletin->userinfo['tmnt_credits']==0)
	{
		$errormessage = 'Error, you have no credits to give to teams.';
		eval(standard_error($errormessage));
	}
	$vbulletin->input->clean_array_gpc('g', array(
		'teamid' => TYPE_UINT
	));
	$teamid = $vbulletin->GPC['teamid'];
	$teamm = $vbulletin->db->query_first("SELECT teamname FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid = '$teamid' ");
	if (!$teamm)
	{
		$teamid = '';
	}
	else
	{
		$teamm['url'] = tll_seo('team', $teamid, $teamm['teamname']);
	}
	$team = true;
	$templater = vB_Template::create('tmnt_give_credits');
		$templater->register('tmntp', $tmntp);
		$templater->register('credits_nav', $credits_nav);
		$templater->register('team', $team);
		$templater->register('teamid', $teamid);
		$templater->register('teamm', $teamm);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tll_credits.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=credits' => $vbphrase['tmnt_credits'],
		'' => construct_phrase($vbphrase['tmnt_give_credits'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'divide_team_credits')
{
	if (!$tmntp['cangivecredits'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('g', array(
		'teamid' => TYPE_UINT
	));
	$teamid = $vbulletin->GPC['teamid'];
	$team = $vbulletin->db->query_first("
		SELECT * 
		FROM " . TABLE_PREFIX . "tmnt_teams 
		WHERE teamid = '$teamid' 
	");
	if (!$team)
	{
		print_no_permission();
	}
	$team['url'] = tll_seo('team', $teamid, $team['teamname']);
	$array = array();
	$isleader = false;
	$p_query = $vbulletin->db->query_read("
		SELECT p.*, u.username
		FROM " . TABLE_PREFIX . "tmnt_members AS p
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (p.userid = u.userid)
		WHERE p.teamid = '$teamid'
			AND p.accepted = 1
		ORDER BY u.username ASC
	");
	while($row = $vbulletin->db->fetch_array($p_query))
	{
		if ($row['leader'] && $row['userid'] == $vbulletin->userinfo['userid'])
		{
			$isleader = true;
		}
		$array[] = $row;
	}
	if (!$isleader)
	{
		print_no_permission();
	}
	if ($team['tmnt_credits']==0)
	{
		$errormessage = 'Error, you have no credits to give to teams.';
		eval(standard_error($errormessage));
	}
	$templater = vB_Template::create('tmnt_divide_team_credits');
		$templater->register('tmntp', $tmntp);
		$templater->register('credits_nav', $credits_nav);
		$templater->register('team', $team);
		$templater->register('teamid', $teamid);
		$templater->register('array', $array);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tll_credits.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=credits' => $vbphrase['tmnt_credits'],
		'' => construct_phrase($vbphrase['tmnt_divide_credits'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'user_credits')
{
	if (!$tmntp['admincredits'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('g', array(
		'page' => TYPE_UINT,
		'pp' => TYPE_UINT,
	));
	$count = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "user WHERE tmnt_credits > 0");
	if (!$vbulletin->GPC['page'])
	{
		$vbulletin->GPC['page'] = 1;
	}
	if (!$vbulletin->GPC['pp'])
	{
		$vbulletin->GPC['pp'] = 10;
	}
	$pagenav = construct_page_nav($vbulletin->GPC['page'], $vbulletin->GPC['pp'], $count['countrows'], "tll_credits.php?" . $vbulletin->session->vars['sessionurl'] . "do=user_credits&amp;pp=".$vbulletin->GPC['pp']);
	$limit = ($vbulletin->GPC['page']-1)*$vbulletin->GPC['pp'];
	$tc_query = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "user
		WHERE tmnt_credits > 0
		ORDER BY tmnt_credits DESC
		LIMIT $limit, ".$vbulletin->GPC['pp']."
	");
	while($user = $vbulletin->db->fetch_array($tc_query))
	{
		$ht_array[] = $user;
	}
	$templater = vB_Template::create('tmnt_credits_users');
		$templater->register('tmntp', $tmntp);
		$templater->register('info', $info);
		$templater->register('ht_array', $ht_array);
		$templater->register('timenow', TIMENOW);
		$templater->register('pagenav', $pagenav);
		$templater->register('page', $vbulletin->GPC['page']);
		$templater->register('pp', $vbulletin->GPC['pp']);
		$templater->register('currency_symbol', $currency_symbol);
		$templater->register('credits_nav', $credits_nav);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tll_credits.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=credits' => $vbphrase['tmnt_credits'],
		'' => construct_phrase($vbphrase['tmnt_other_users_credits'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'hist_paypal_transactions')
{
	if (!$tmntp['admincredits'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('g', array(
		'page' => TYPE_UINT,
		'pp' => TYPE_UINT,
		'username' => TYPE_NOHTML,
		'paypal_ref' => TYPE_NOHTML,
		'invoice' => TYPE_NOHTML,
		'payment_status' => TYPE_NOHTML,
		'credits' => TYPE_UINT,
	));
	$data = $vbulletin->GPC;
	if ($vbulletin->GPC['username'])
	{
		$where_sql .= ($where_sql ? " AND ":"") . " u.username LIKE '%".$vbulletin->db->escape_string($vbulletin->GPC['username'])."%' ";
	}
	if ($vbulletin->GPC['credits']>0)
	{
		$where_sql .= ($where_sql ? " AND ":"") . " c.credits = '".$vbulletin->db->escape_string($vbulletin->GPC['credits'])."' ";
	}
	if ($vbulletin->GPC['paypal_ref'])
	{
		//s:6:"txn_id";s:17:"4WD05530S25178447"
		$where_sql .= ($where_sql ? " AND ":"") . " c.raw_post LIKE '%".'s:6:"txn_id";s:'.strlen($vbulletin->GPC['paypal_ref']).':"'.$vbulletin->db->escape_string($vbulletin->GPC['paypal_ref']).'"'."%' ";
	}
	if ($vbulletin->GPC['invoice'])
	{
		//s:7:"invoice";s:12:"1327761908_1";
		$where_sql .= ($where_sql ? " AND ":"") . " c.raw_post LIKE '%".'s:7:"invoice";s:'.strlen($vbulletin->GPC['invoice']).':"'.$vbulletin->db->escape_string($vbulletin->GPC['invoice']).'"'."%' ";
	}
	if ($vbulletin->GPC['payment_status'])
	{
		//s:14:"payment_status";s:12:"1327761908_1";
		$where_sql .= ($where_sql ? " AND ":"") . " c.raw_post LIKE '%".'s:14:"payment_status";s:'.strlen($vbulletin->GPC['payment_status']).':"'.$vbulletin->db->escape_string($vbulletin->GPC['payment_status']).'"'."%' ";
	}
	$count = $vbulletin->db->query_first("
		SELECT COUNT(*) AS countrows
		FROM " . TABLE_PREFIX . "tmnt_credits AS c
		".($where_sql ? " WHERE $where_sql " : "")." 
	");
	if (!$vbulletin->GPC['page'])
	{
		$vbulletin->GPC['page'] = 1;
	}
	if (!$vbulletin->GPC['pp'])
	{
		$vbulletin->GPC['pp'] = 10;
	}
	$pagenav = construct_page_nav($vbulletin->GPC['page'], $vbulletin->GPC['pp'], $count['countrows'], "tll_credits.php?" . $vbulletin->session->vars['sessionurl'] . "do=hist_paypal_transactions&amp;pp=".$vbulletin->GPC['pp']);
	$limit = ($vbulletin->GPC['page']-1)*$vbulletin->GPC['pp'];
	$tc_query = $vbulletin->db->query_read("
		SELECT c.*, u.username
		FROM " . TABLE_PREFIX . "tmnt_credits AS c
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (c.userid = u.userid)
		".($where_sql ? " WHERE $where_sql " : "")."
		ORDER BY c.id DESC
		LIMIT $limit, ".$vbulletin->GPC['pp']."
	");
	while($row = $vbulletin->db->fetch_array($tc_query))
	{
		$row['raw_post'] = unserialize($row['raw_post']);
		if (is_array($row['raw_post']))
		{
			foreach ($row['raw_post'] AS $x => $y)
			{
				$row['rawinfo'] .= "$x: $y <br />\n";
			}
		}
		$row['date'] = vbdate($vbulletin->options['dateformat'], $row['dateline'], 0);
		$row['currency_symbol'] = fetch_currency_symbol($row['raw_post']['mc_currency']);
		$ht_array[] = $row;
	}
	$templater = vB_Template::create('tmnt_credits_histpp');
		$templater->register('tmntp', $tmntp);
		$templater->register('info', $info);
		$templater->register('ht_array', $ht_array);
		$templater->register('timenow', TIMENOW);
		$templater->register('pagenav', $pagenav);
		$templater->register('page', $vbulletin->GPC['page']);
		$templater->register('pp', $vbulletin->GPC['pp']);
		$templater->register('currency_symbol', $currency_symbol);
		$templater->register('credits_nav', $credits_nav);
		$templater->register('data', $data);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tll_credits.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=credits' => $vbphrase['tmnt_credits'],
		'' => construct_phrase($vbphrase['tmnt_historic_paypal_trans'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'hist_credits_transactions')
{
	if (!$tmntp['admincredits'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('g', array(
		'page' => TYPE_UINT,
		'pp' => TYPE_UINT,
	));
	$count = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_credithistory");
	if (!$vbulletin->GPC['page'])
	{
		$vbulletin->GPC['page'] = 1;
	}
	if (!$vbulletin->GPC['pp'])
	{
		$vbulletin->GPC['pp'] = 15;
	}
	$pagenav = construct_page_nav($vbulletin->GPC['page'], $vbulletin->GPC['pp'], $count['countrows'], "tll_credits.php?" . $vbulletin->session->vars['sessionurl'] . "do=hist_credits_transactions&amp;pp=".$vbulletin->GPC['pp']);
	$limit = ($vbulletin->GPC['page']-1)*$vbulletin->GPC['pp'];
	$tc_query = $vbulletin->db->query_read("
		SELECT c.*, u.username, IF (c.pot=0, v.username, z.teamname) AS from_username, IF (c.pot=0, w.username, a.teamname) AS to_username, t.teamname
		FROM " . TABLE_PREFIX . "tmnt_credithistory AS c
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (c.userid = u.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS v
			ON (c.from_userid = v.userid AND c.pot = 0)
		LEFT JOIN " . TABLE_PREFIX . "user AS w
			ON (c.to_userid = w.userid AND c.pot = 0)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
			ON (t.teamid = c.teamid AND c.pot = 1)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS z
			ON (z.teamid = c.from_userid AND c.pot = 1)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS a
			ON (a.teamid = c.to_userid AND c.pot = 1)
		ORDER BY c.id DESC
		LIMIT $limit, ".$vbulletin->GPC['pp']."
	");
	while($row = $vbulletin->db->fetch_array($tc_query))
	{
		$row['date'] = vbdate($vbulletin->options['dateformat'], $row['dateline'], 0);
		if ($row['pot'])
		{
			$row['teamurl'] = tll_seo('team', $row['teamid'], $row['teamname']);
			$row['username'] = '';
		}
		if ($row['teamname'] && !$row['pot'])
		{
			$row['description'] .= ": ".$row['teamname'];
		}
		elseif (!$row['pot'])
		{//
			if ($row['from_username'] && $row['from_username']!=$row['username'])
			{
				$row['description'] .= ": ".$row['from_username'];
			}
			if ($row['to_username'] && $row['to_username']!=$row['username'])
			{
				$row['description'] .= ": ".$row['to_username'];
			}
		}
		else
		{
			if ($row['from_username'] && $row['from_username']!=$row['teamname'])
			{
				$row['description'] .= ": ".$row['from_username'];
			}
			if ($row['to_username'] && $row['to_username']!=$row['teamname'])
			{
				$row['description'] .= ": ".$row['to_username'];
			}
		}
		$row['opp_credits']  = -$row['credits'];
		$ht_array[] = $row;
	}
	$templater = vB_Template::create('tmnt_credits_histcr');
		$templater->register('tmntp', $tmntp);
		$templater->register('info', $info);
		$templater->register('ht_array', $ht_array);
		$templater->register('timenow', TIMENOW);
		$templater->register('pagenav', $pagenav);
		$templater->register('page', $vbulletin->GPC['page']);
		$templater->register('pp', $vbulletin->GPC['pp']);
		$templater->register('credits_nav', $credits_nav);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tll_credits.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=credits' => $vbphrase['tmnt_credits'],
		'' => construct_phrase($vbphrase['tmnt_historic_credits_trans'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}
// #############################################################################

if ($_REQUEST['do'] == 'profits')
{
	if (!$tmntp['admincredits'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('g', array(
		'page' => TYPE_UINT,
		'pp' => TYPE_UINT,
	));
	$count = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_creditprofit");
	if (!$vbulletin->GPC['page'])
	{
		$vbulletin->GPC['page'] = 1;
	}
	if (!$vbulletin->GPC['pp'])
	{
		$vbulletin->GPC['pp'] = 10;
	}
	$pagenav = construct_page_nav($vbulletin->GPC['page'], $vbulletin->GPC['pp'], $count['countrows'], "tll_credits.php?" . $vbulletin->session->vars['sessionurl'] . "do=profits&amp;pp=".$vbulletin->GPC['pp']);
	$limit = ($vbulletin->GPC['page']-1)*$vbulletin->GPC['pp'];
	$tc_query = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_creditprofit
		ORDER BY year DESC, week DESC
		LIMIT $limit, ".$vbulletin->GPC['pp']."
	");
	while($row = $vbulletin->db->fetch_array($tc_query))
	{
		if ($row['dateline']>0)
			$row['date'] = vbdate($vbulletin->options['dateformat'], $row['dateline'], 0);
		$ht_array[] = $row;
		$max_credits = ($row['credits'] > $max_credits ? $row['credits'] : $max_credits);
		if ($row['year']==2012)
			$y2012["$row[week]"] = $row['credits'];
	}
	
	$thisyear = 2012;
	$max_credits = ceil($max_credits * 1.1);
	function go_num($val)
	{
		return (int)$val;
	}
	for ($i = 1; $i <= 52; $i++)
	{
		$sty .= ','.go_num($y2012["$i"]);
	}
	$sty = substr($sty,1);
	//print_r($sty);
	//print_r('');
	$gimg = '<img src="http://chart.apis.google.com/chart?chxl=0:|Week+1|Week+52|Week+13|Week+26|Week+39&chxp=0,0,52,13,26,39&chxr=0,0,52|1,0,'.$max_credits.'&chxt=x,y&chs=500x225&cht=lc&chds=0,'.$max_credits.'&chd=t:'.$sty.'&chdl=2012&chg=14.3,-1,1,1&chls=1&chma=|5" />';
	$templater = vB_Template::create('tmnt_credits_profits');
		$templater->register('tmntp', $tmntp);
		$templater->register('info', $info);
		$templater->register('ht_array', $ht_array);
		$templater->register('timenow', TIMENOW);
		$templater->register('pagenav', $pagenav);
		$templater->register('page', $vbulletin->GPC['page']);
		$templater->register('pp', $vbulletin->GPC['pp']);
		$templater->register('credits_nav', $credits_nav);
		$templater->register('gimg', $gimg);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'tll_credits.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=credits' => $vbphrase['tmnt_credits'],
		'' => construct_phrase($vbphrase['tmnt_credits_profits'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if (!$_REQUEST['do'])
{
	$_REQUEST['do'] = 'credits';
}

// #############################################################################

if ($_REQUEST['do'] == 'credits')
{
	$ch_query = $vbulletin->db->query_read("
		SELECT c.*, u.username AS from_username, v.username AS to_username, t.teamname
		FROM " . TABLE_PREFIX . "tmnt_credithistory AS c
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (u.userid = c.from_userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS v
			ON (v.userid = c.to_userid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
			ON (t.teamid = c.teamid)
		WHERE (c.from_userid = '".$vbulletin->userinfo['userid']."' OR c.to_userid = '".$vbulletin->userinfo['userid']."')
			AND c.pot = 0
		ORDER BY c.id DESC 
		LIMIT 0, 5
	");
	while($row = $vbulletin->db->fetch_array($ch_query))
	{
		$row['date'] = vbdate($vbulletin->options['dateformat'], $row['dateline'], 0);
		$ch_array[] = $row;
	}
	$tc_query = $vbulletin->db->query_read("
		SELECT * 
		FROM " . TABLE_PREFIX . "tmnt_credits
		WHERE userid = '".$vbulletin->userinfo['userid']."' 
		ORDER BY id DESC 
		LIMIT 0, 5
	");
	while($row = $vbulletin->db->fetch_array($tc_query))
	{
		$row['raw_post'] = unserialize($row['raw_post']);
		if (is_array($row['raw_post']))
		{
			foreach ($row['raw_post'] AS $x => $y)
			{
				$row['rawinfo'] .= "$x: $y \n<br />";
			}
		}
		$row['date'] = vbdate($vbulletin->options['dateformat'], $row['dateline'], 0);
		$row['currency_symbol'] = fetch_currency_symbol($row['raw_post']['mc_currency']);
		$ht_array[] = $row;
	}
	//print_r($tc);
	$info = array();
	$info['currency_symbol'] = fetch_currency_symbol($vbulletin->options['tmnt_credits_currency']);
	$info['currency'] = $vbulletin->options['tmnt_credits_currency'];
	$info['credit_value'] = $vbulletin->options['tmnt_credit_value'];
	$info['paypalemail'] = $vbulletin->options['tmnt_credits_paypalemail'];
	if ($_REQUEST['paymentthanks'])
	{
		$info['paymentthanks'] = 1;
	}
	for ($i = 1; $i <= 10; $i++)
	{
		$val = $i * 5;
		$cos = $val * $vbulletin->options['tmnt_credit_value'];
		$info['amounts'] .= '<option value="'.$cos.'">'.construct_phrase($vbphrase['tmnt_x_credits'],$val).' = '.$info['currency_symbol'].number_format($cos,2).'</option>';
	}
	$vbulletin->options['tmnt_cashout_fee'] = number_format($vbulletin->options['tmnt_cashout_fee'], 2);
	$templater = vB_Template::create('tmnt_credits');
		$templater->register('tmntp', $tmntp);
		$templater->register('info', $info);
		$templater->register('ht_array', $ht_array);
		$templater->register('ch_array', $ch_array);
		$templater->register('timenow', TIMENOW);
		$templater->register('credits_nav', $credits_nav);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'' => construct_phrase($vbphrase['tmnt_credits'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

?>