<?php
error_reporting(E_ALL & ~E_NOTICE);
define('SKIP_SESSIONCREATE', 1);
$phrasegroups = array();
$specialtemplates = array();
$globaltemplates = array();
$actiontemplates = array();
define('VB_AREA', 'paypal_ipn');
define('CWD', (($getcwd = getcwd()) ? $getcwd : '.'));
require_once(CWD . '/includes/init.php');
$vbphrase = init_language();
$vbulletin->nozip = true;
$errors = true;
$ipn_post_data = $_POST;

/****************************************/

	function tll_is_int($int)
	{
		if (is_numeric($int) === TRUE)
		{
			if((int)$int == $int)
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		else
		{
			 return false;
		}
	}
	function tll_generate_hash($length = 10)
	{
		$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$string = '';    
		for ($p = 0; $p < $length; $p++)
		{
			$string .= $characters[mt_rand(0, strlen($characters))];
		}
		return $string;
	}

/****************************************/

// Choose url
if(array_key_exists('test_ipn', $ipn_post_data) && 1 === (int) $ipn_post_data['test_ipn'])
{
    $url = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
}
else
{
    $url = 'https://www.paypal.com/cgi-bin/webscr';
}

// Set up request to PayPal
$request = curl_init();
curl_setopt_array($request, array
(
    CURLOPT_URL => $url,
    CURLOPT_POST => TRUE,
    CURLOPT_POSTFIELDS => http_build_query(array('cmd' => '_notify-validate') + $ipn_post_data),
    CURLOPT_RETURNTRANSFER => TRUE,
    CURLOPT_HEADER => FALSE,
    CURLOPT_SSL_VERIFYPEER => TRUE,
));

// Execute request and get response and status code
$response = curl_exec($request);
$status   = curl_getinfo($request, CURLINFO_HTTP_CODE);

// Close connection
curl_close($request);

if($status == 200 && $response == 'VERIFIED')
{
	if ($ipn_post_data['receiver_email'] != $vbulletin->options['tmnt_credits_paypalemail'])
	{//check receiver email
		$errors_log .= 'Receiver Email not matched; ';
		$fail = true;
	}
	if (strtolower($ipn_post_data['mc_currency']) != strtolower($vbulletin->options['tmnt_credits_currency']))
	{//check currency
		$errors_log .= 'Currency not matched; ';
		$fail = true;
	}
	if ($ipn_post_data['mc_gross'] <= 0)
	{
		$errors_log .= 'mc_gross is nil; ';
		$fail = true;
	}
	else
	{
		$mc_gross = number_format(doubleval($ipn_post_data['mc_gross']), 2);
		$credits = $mc_gross / $vbulletin->options['tmnt_credit_value'];
		if (!tll_is_int($credits))
		{/*Check credits is integer*/
			$errors_log .= 'Credits not integer, mc_gross not divisible; ';
			$fail = true;
		}
	}
	$userid = $ipn_post_data['custom'];
	if (!tll_is_int($userid))
	{/*Check userid is integer*/
		$errors_log .= 'Userid not integer; ';
		$fail = true;
	}
	if ($ipn_post_data['payment_status'] != 'Completed')
	{
		$errors_log .= 'Not completed transaction; ';
		$fail = true;
	}
	if ($ipn_post_data['test_ipn'])
	{/*Ignore test sandbox transactions*/
		$errors_log .= 'PayPal test sandbox transaction; ';
		$fail = true;
	}
	if (!in_array(strtolower($ipn_post_data['item_name']), array('credits',$vbphrase['tmnt_credits'])))
	{//check item_name = Credits
		$errors_log .= 'Item name not recognised; ';
		$fail = true;
	}
	//check not already processed - auth_id
	foreach ($ipn_post_data as $key => $value)
	{
		$msg .= "$key: $value \r\n";
	}
	if (!$fail)
	{
		//do_query update user
		$x = $db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_credits = tmnt_credits + ".$credits." WHERE userid = '".$userid."'");
		if (!$x)
		{
			$errors_log .= 'Update user + credits failed; ';
			$fail = true;
		}
		else
		{
			$paid = 1;
			$vbulletin->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "tmnt_credithistory
					(description, userid, dateline, credits, from_userid, to_userid)
				VALUES ('".$vbulletin->db->escape_string('Bought credits using PayPal')."',
				'".$userid."',
				'".TIMENOW."',
				'".$vbulletin->db->escape_string($credits)."', 
				'".$vbulletin->db->escape_string(0)."',
				'".$vbulletin->db->escape_string($userid)."'
				)
			");
		}
	}
	$desc = '';
	$raw_post = serialize($ipn_post_data);
	$vbulletin->db->query_write("
		INSERT INTO " . TABLE_PREFIX . "tmnt_credits
			(description, hash, userid, dateline, cost, paid, raw_post, errors, credits)
		VALUES ('".$vbulletin->db->escape_string($desc)."', '".$vbulletin->db->escape_string(tll_generate_hash())."', '".$vbulletin->db->escape_string($userid)."', '".TIMENOW."', '".$vbulletin->db->escape_string($mc_gross)."', '".$vbulletin->db->escape_string($paid)."', '".$vbulletin->db->escape_string($raw_post)."', '".$vbulletin->db->escape_string($errors_log)."', '".$vbulletin->db->escape_string($credits)."')
	");
	//log query
	//mail('', 'Works', $msg."--".$credits);
}
else
{
    // IPN not from Paypal
	//mail('', 'Fails', '');
	exit;
}
/*
if(array_key_exists('charset', $ipn_data) && ($charset = $ipn_data['charset']))
{
    // Ignore if same as our default
    if($charset == 'utf-8')
        return;

    // Otherwise convert all the values
    foreach($ipn_data as $key => &$value)
    {
        $value = mb_convert_encoding($value, 'utf-8', $charset);
    }

    // And store the charset values for future reference
    $ipn_data['charset'] = 'utf-8';
    $ipn_data['charset_original'] = $charset;
}*/