<?php
/*======================================================================*\
|| #################################################################### ||
|| # Copyright  BananaLive Scripts. All Rights Reserved. ############# ||
|| #################################################################### ||
\*======================================================================*/

error_reporting(E_ALL & ~E_NOTICE);
define('THIS_SCRIPT', 'ladders');
if ($_REQUEST['do'] && in_array($_REQUEST['do'], array('pmcmpt', 'add', 'edit', 'editrules')))
{
define('GET_EDIT_TEMPLATES', true);
}
$phrasegroups = array('posting', 'postbit', 'user', 'timezone', 'global', 'pm', 'reputationlevel', 'search', 'calendar');
$specialtemplates = array(
	'bbcodecache',
	'smiliecache',
	'tll_catcache',
);
$globaltemplates = array(
	'tmnt_shell'
);
$actiontemplates = array(
	'admin_swap' => array(
		'tmnt_ladder_swap'
	),
	'admin_editpt' => array(
		'tmnt_ladder_editpt'
	),
	'add' => array(
		'tmnt_date_time',
		'tmnt_ladder_new'
	),
	'leaveladder' => array(
		'tmnt_ladder_teamleave'
	),
	'insertchal' => array(
		'tmnt_ladder_chalpm'
	),
	'warlights' => array(
		'tmnt_warlights'
	),
	'matchfinder' => array(
		'tmnt_warlights',
		'tmnt_ladder_mf'
	),
	'pm' => array(
		'tmnt_ladder_threadtemplate2'
	),
	'join' => array(
		'tmnt_ladder_join'
	),
	'editavatar' => array(
		'tmnt_ladder_editavatar'
	),
	'editbadge' => array(
		'tmnt_ladder_editbadge'
	),
	'insertchal' => array(
		'tmnt_ladder_chal'
	),
	'insertmatch' => array(
		'tmnt_ladder_insertmatch'
	),
	'player_popup' => array(
		'tmnt_ladder_player_popup'
	),
	'pmcmpt' => array(
		'tmnt_ladder_threadtemplate2',
		'tmnt_newpm'
	),
	'editcolors' => array(
		'tmnt_ladder_editcolors'
	),
	'challenges' => array(
		'tmnt_ladder_chll_top',
		'tmnt_ladder_chll',
		'tmnt_ladder_chll_bot',
		'tmnt_ladder_yourteams'
	),
	'rearrange_match' => array(
		'tmnt_date_time',
		'tmnt_ladder_rearrange'
	),
	'enable_warlight' => array(
		'tmnt_enablelivematch_chooseteam'
	),
	'allchallenges' => array(
		'tmnt_ladder_all_chll_top',
		'tmnt_ladder_chll',
		'tmnt_ladder_chll_bot'
	),
	'reportedmatches' => array(
		'tmnt_ladder_repmatch'
	),
	'acceptmf' => array(
		'tmnt_ladder_mfpm'
	),
	'submitscore' => array(
		'tmnt_ladder_submitscore'
	),
	'create_player_image' => array(
		'tmnt_ladder_cpi'
	),
	'adminsubmitscore' => array(
		'tmnt_ladder_adminsubmitscore'
	),
	'adminsubmitscores' => array(
		'tmnt_ladder_adminsubmitscores'
	),
	'elorating' => array(
		'tmnt_ladder_elorating'
	),
	'editrules' => array(
		'tmnt_ladder_editrules'
	),
	'edit' => array(
		'tmnt_ladder_edit',
		'tmnt_date_time'
	),
	'addplayer' => array(
		'tmnt_ladder_newplayer'
	),
	'startleague' => array(
		'tmnt_organise_league'
	),
	'editsquad' => array(
		'tmnt_ladder_editsquad'
	),
	'viewmatch' => array(
		'tmnt_ladder_viewmatch'
	),
	'search_matches' => array(
		'tmnt_ladder_searchmatches'
	),
	'view' => array(
		'tmnt_ladder_cmpt_top',
		'tmnt_ladder_cmpt',
		'tmnt_ladder_cmpt_none',
		'tmnt_ladder_cmpt_bot',
		'tmnt_ladder_allchll_none',
		'tmnt_ladder_allchll_bot',
		'tmnt_ladder_allchll_top',
		'tmnt_ladder_allchll',
		'tmnt_ladder_tlchll_top',
		'tmnt_ladder_chll',
		'tmnt_ladder_chll_bot',
		'tmnt_ladder_tmnts',
		'facebook_likebutton',
		'memberaction_dropdown',
		'tmnt_ladder_allchll2',
		'tmnt_memberaction_dropdown',
		'tmnt_ladder_display'
	),
	'none' => array(
		'tmnt_ladder_cmpt_top',
		'tmnt_ladder_cmpt',
		'tmnt_ladder_cmpt_none',
		'tmnt_ladder_cmpt_bot',
		'tmnt_ladder_allchll_none',
		'tmnt_ladder_allchll_bot',
		'tmnt_ladder_allchll_top',
		'tmnt_ladder_allchll',
		'tmnt_ladder_tlchll_top',
		'memberaction_dropdown',
		'tmnt_memberaction_dropdown',
		'tmnt_ladder_chll',
		'tmnt_ladder_chll_bot',
		'tmnt_ladder_tmnts',
		'facebook_likebutton',
		'tmnt_ladder_display',
		'tmnt_ladder_list_top',
		'tmnt_ladder_list_bot',
		'tmnt_ladder_list',
		'tmnt_ladder_noladders',
		'tmnt_ladder_list_rm',
		'tmnt_cat',
		'tmnt_ladder_allchll2',
		'tmnt_random_torp'
	)
);

require_once('./global.php');
require_once(DIR . '/includes/functions.php');
require_once(DIR . '/includes/functions_tal.php');

($hook = vBulletinHook::fetch_hook('tll_ladders_start')) ? eval($hook) : false;

$navbits = construct_navbits(array(
	'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
	'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase[ladders],
	'' => construct_phrase('Error')
));
$navbar = render_navbar_template($navbits);

// #############################################################################

if ($_REQUEST['do'] == 'ladder_player_image')
{
	$iwidth = $vbulletin->input->clean_gpc('g', 'w', TYPE_UINT);
	if (!$iwidth)
	{
		$iwidth = 250;
	}
	$iheight = $vbulletin->input->clean_gpc('g', 'h', TYPE_UINT);
	if (!$iheight)
	{
		$iheight = 90;
	}
	$userid = $vbulletin->input->clean_gpc('g', 'u', TYPE_UINT);
	$f = $vbulletin->input->clean_gpc('g', 'f', TYPE_UINT);
	$lid = $vbulletin->input->clean_gpc('g', 'l', TYPE_UINT);
	$noavatar = $vbulletin->input->clean_gpc('g', 'noavatar', TYPE_UINT);
	$player = $vbulletin->db->query_first("
		SELECT players.*, users.*, ladders.title AS laddertitle, users.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight, teams.teamname, teams.teamlogo
		FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
		LEFT JOIN " . TABLE_PREFIX . "user AS users
			ON (users.userid = players.userid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teams
			ON (teams.teamid = players.userid)	
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (players.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar
			ON (avatar.avatarid = users.avatarid)
		LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar
			ON (customavatar.userid = users.userid)
		WHERE players.userid = '$userid'
			AND players.lid = '$lid'
			AND players.active = 1
	");
	if ($player['pot'])
	{
		$player['username'] = $player['teamname'];
	}
	$countp = $vbulletin->db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE rank > '".$player['rank']."' AND active = 1 AND lid = '".$lid."'");
	$player['position'] = $countp['count'] + 1;
	$player['position'] = process_position($player['position']);
	if (!$noavatar)
	{
		if (!$player['pot'])
		{
			if (!empty($player['avatarpath']))
			{
				$player['avatarurl'] = $player['avatarpath'];
			}
			elseif ($player['hascustom'])
			{
				$avatarurl = array('hascustom' => 1);
				if ($vbulletin->options['usefileavatar'])
				{
					$player['avatarurl'] = $vbulletin->options['avatarurl'] . ($thumb ? '/thumbs' : '') . "/avatar{$player['userid']}_{$player['avatarrevision']}.gif";
				}
				else
				{
					$player['avatarurl'] = $vbulletin->options['bburl']."/image.php?u=$player[userid]&amp;dateline=$player[avatardateline]" . ($thumb ? '&type=thumb' : '') ;
				}
			}
		}
		else
		{
			$player['avatarurl'] = $player['teamlogo'];
		}
		if (empty($player['avatarurl']))
		{
			$player['avatarurl'] = vB_Template_Runtime::fetchStyleVar('imgdir_misc') . '/unknown.gif';
		}
		$player['image'] = $player['avatarurl'];
		$size = getimagesize($player['image']);
		$my_img = imagecreate($iwidth, $iheight);
		list($width, $height) = $size;
		if($size[2]==3)
		{
			$av = imagecreatefrompng($player['image']);
		}
		elseif ($size[2]==2)
		{
			$av = imagecreatefromjpeg($player['image']);
		}
		elseif ($size[2]==1)
		{
			$av = imagecreatefromgif($player['image']);
		}
		$minus = 0;
		$minus2 = 0;
	}
	else
	{
		$minus = -10;
		$minus2 = -30;
		$my_img = imagecreate($iwidth, $iheight);
	}
	$bgurl = $vbulletin->input->clean_gpc('g', 'bgurl', TYPE_NOHTML);
	if ($bgurl)
	{
		$imgattb = getimagesize($bgurl);
	}
	if (is_array($imgattb))
	{
		imagedestroy($my_img);
		list($bwidth, $bheight) = $imgattb;
		$type = $imgattb['mime'];
		if ($type == 'image/png')
		{
			$my_img = @imagecreatefrompng($bgurl);
		}
		elseif ($type == 'image/jpeg')
		{
			$my_img = @imagecreatefromjpeg($bgurl);
		}
		elseif ($type == 'image/gif')
		{
			$my_img = @imagecreatefromgif($bgurl);
		}
		if ($my_img && ($bwidth != $iwidth OR $bheight != $iheight))
		{
			$im20 = imagecreatetruecolor($iwidth, $iheight);
			imagecopyresampled($im20,$my_img,0,0,0,0,$iwidth,$iheight,$bwidth,$bheight); 
			imagedestroy($my_img);
			$my_img = $im20;
		}
	}
	$max = 45;
	$newwidth = $width;
	$newheight = $height;
	if ($newwidth > $max)
	{
		$ratio = $max / $newwidth;
		$newwidth = $newwidth * $ratio;
		$newheight = $newheight * $ratio;
	}
	if ($newheight > $max)
	{
		$ratio = $max / $newheight;
		$newwidth = $newwidth * $ratio;
		$newheight = $newheight * $ratio;
	}
	/*image*/
	function html2rgb($color)
	{
		if ($color[0] == '#')
			$color = substr($color, 1);

		if (strlen($color) == 6)
			list($r, $g, $b) = array($color[0].$color[1],
									 $color[2].$color[3],
									 $color[4].$color[5]);
		elseif (strlen($color) == 3)
			list($r, $g, $b) = array($color[0].$color[0], $color[1].$color[1], $color[2].$color[2]);
		else
			return false;

		$r = hexdec($r); $g = hexdec($g); $b = hexdec($b);

		return array($r, $g, $b);
	}
	$bg = $vbulletin->input->clean_gpc('g', 'bg', TYPE_NOHTML);
	$c = $vbulletin->input->clean_gpc('g', 'c', TYPE_NOHTML);
	
	if (!$bg)
	{
		$bg = 'FFFFFF';
	}
	if (!$c)
	{
		$c = '000000';
	}
	$border = $vbulletin->input->clean_gpc('g', 'b', TYPE_NOHTML);
	if (!$border)
	{
		$border = $bg;
	}
	$bg = html2rgb($bg);
	$c = html2rgb($c);
	$background = imagecolorallocate($my_img, $bg['0'], $bg['1'], $bg['2']);
	//$text_colour = imagecolorallocate($my_img, 199, 199, 199);
	$text_colour = imagecolorallocate($my_img, $c['0'], $c['1'], $c['2']);
	$line_colour = imagecolorallocate($my_img, 233, 233, 233);
	
	$border = html2rgb($border);
	$border_colour = imagecolorallocate($my_img, $border['0'], $border['1'], $border['2']);
	$bw = $vbulletin->input->clean_gpc('g', 'bw', TYPE_UINT);
	if (!$bw)
	{
		$bw = 1;
	}
	imagesetthickness($my_img, $bw);
	imagerectangle($my_img, 0, 0, $iwidth-1, $iheight-1, $border_colour);
	//imagestring(resource $image , int $font , int $x , int $y , string $string , int $color)
	//imageline(resource $image , int $x1 , int $y1 , int $x2 , int $y2 , int $color)
	//imageline($my_img, 30, 45, 165, 45, $line_colour);
	
	//imageline($my_img, $newwidth+20, 0, 300, 0, $line_colour);
	//imagestring($my_img, 5, 10, 10, $player['position'], $text_colour);
	if ($player['username'])
	{
		if (!$_REQUEST['simple'])
		{
			imagestring($my_img, 5, 10, 10, $player['username']."", $text_colour);
			imagestring($my_img, 4, $minus2+130, 30, html_entity_decode($player['laddertitle'],ENT_COMPAT,"UTF-8"), $text_colour);
			imagestring($my_img, 4, $minus+$newwidth+20, 30, 'Ladder:', $text_colour);
			imagestring($my_img, 4, $minus+$newwidth+20, 50, 'Rank:', $text_colour);
			imagestring($my_img, 4, $minus2+130, 50, $player['position'], $text_colour);
			//imagestring($my_img, 4, 15, 70, 'Elo Rating:', $text_colour);
			//imagestring($my_img, 4, 120, 70, $player['rank'], $text_colour);
			imagestring($my_img, 4, $minus+$newwidth+20, 70, 'XP:', $text_colour);
			imagestring($my_img, 4, $minus2+130, 70, $player['xp'], $text_colour);
			if ($av)
			{
				//imagecopyresized($my_img, $av, $iwidth-$max-10, 10, 0, 0, $newwidth, $newheight, $width, $height);//top right
				imagecopyresized($my_img, $av, 10, 35, 0, 0, $newwidth, $newheight, $width, $height);//bottom left
			}
		}
		else
		{
			imagestring($my_img, 4, 5, 5, $player['wins']."/".$player['draws']."/".$player['loses'], $text_colour);
		}		
	}
	else
	{
		imagestring( $my_img, 5, 10, 10, "null", $text_colour );
		//debug
		//imagestring( $my_img, 4, 20, 30, 'lid='.$lid, $text_colour );
		//imagestring( $my_img, 4, 20, 50, 'userid='.$userid, $text_colour );
	}
	header("Content-Disposition: inline; filename=\"image.png\";");
	header('Cache-control: max-age=31536000');
	header('Expires: ' . gmdate('D, d M Y H:i:s', (TIMENOW + 31536000)) . ' GMT');
	header('Last-Modified: ' . gmdate('D, d M Y H:i:s', $player['latime']) . ' GMT');
	header('Content-transfer-encoding: binary');
	header('ETag: "' . $player['latime'] . '-' . $u . '"');
	header("Content-type: image/png");
	imagepng($my_img);
	imagecolordeallocate($line_color);
	imagecolordeallocate($text_color);
	imagecolordeallocate($background);
	imagedestroy($my_img);
	exit;
}

// #############################################################################

if ($_POST['do'] == 'admin_updatept')
{
	if (!$tmntp['ladder_superuser'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'lid' => TYPE_UINT,
		'pid' => TYPE_UINT,
		'rank' => TYPE_UINT,
		'wins' => TYPE_UINT,
		'draws' => TYPE_UINT,
		'loses' => TYPE_UINT,
		'streak' => TYPE_INT,
		'xp' => TYPE_UINT,
		'challenges' => TYPE_UINT,
		'totalpoints' => TYPE_UINT,
		'pointsagainst' => TYPE_UINT,
		'longeststreak' => TYPE_UINT,
		'crown' => TYPE_BOOL,
		'active' => TYPE_BOOL
	));
	if ($vbulletin->GPC['pid'] && $vbulletin->GPC['lid'])
	{
		$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders");
		$player = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '".$vbulletin->GPC['lid']."'");
		if (!$player || !$ladder)
		{
			print_no_permission();
		}
		if ($vbulletin->GPC['streak'] > 0)
		{
			$vbulletin->GPC['lstreak'] = 0;
			$vbulletin->GPC['wstreak'] = $vbulletin->GPC['streak'];
		}
		else
		{
			$vbulletin->GPC['lstreak'] = 0-$vbulletin->GPC['streak'];
			$vbulletin->GPC['wstreak'] = 0;
		}
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
			SET
				rank = '".$vbulletin->db->escape_string($vbulletin->GPC['rank'])."',
				wins = '".$vbulletin->db->escape_string($vbulletin->GPC['wins'])."',
				draws = '".$vbulletin->db->escape_string($vbulletin->GPC['draws'])."',
				loses = '".$vbulletin->db->escape_string($vbulletin->GPC['loses'])."',
				wstreak = '".$vbulletin->db->escape_string($vbulletin->GPC['wstreak'])."',
				lstreak = '".$vbulletin->db->escape_string($vbulletin->GPC['lstreak'])."',
				xp = '".$vbulletin->db->escape_string($vbulletin->GPC['xp'])."',
				challenges = '".$vbulletin->db->escape_string($vbulletin->GPC['challenges'])."',
				totalpoints = '".$vbulletin->db->escape_string($vbulletin->GPC['totalpoints'])."',
				pointsagainst = '".$vbulletin->db->escape_string($vbulletin->GPC['pointsagainst'])."',
				longeststreak = '".$vbulletin->db->escape_string($vbulletin->GPC['longeststreak'])."',
				crown = '".$vbulletin->db->escape_string($vbulletin->GPC['crown'])."',
				active = '".$vbulletin->db->escape_string($vbulletin->GPC['active'])."'
			WHERE lid='".$vbulletin->GPC['lid']."'
				AND id='".$vbulletin->GPC['pid']."'
		");
		$vbulletin->url = "ladders.php?do=admin_editpt&lid=".$vbulletin->GPC['lid']."&pid=".$vbulletin->GPC['pid']."";	
		eval(print_standard_redirect('redirect_updatedladderpt', true, true));
	}
	else
	{
		$_REQUEST['do'] = 'admin_editpt';
	}
}

// #############################################################################

if ($_POST['do'] == 'admin_swap')
{
	if (!$tmntp['ladder_superuser'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('p', 'lid', TYPE_UINT);
	$pid = $vbulletin->input->clean_gpc('p', 'pid', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladders
		WHERE id = '$lid'
	");
	if (!$ladder)
	{
		print_no_permission();
	}
	$player = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladder_players
		WHERE lid = '$lid' AND id = '$pid'
	");
	if (!$player)
	{
		print_no_permission();
	}
	if ($ladder['pot'])
	{
		$teamid = $vbulletin->input->clean_gpc('p', 'teamid', TYPE_UINT);
		$user = $vbulletin->db->query_first("
			SELECT teamid AS userid, teamname AS username
			FROM " . TABLE_PREFIX . "tmnt_teams
			WHERE teamid = '".$vbulletin->db->escape_string($teamid)."'
		");
		if (!$user)
		{
			$errormessage = 'Error, that team does not exist.';
			eval(standard_error($errormessage));
		}
	}
	else
	{
		$username = $vbulletin->input->clean_gpc('p', 'username', TYPE_STR);
		$user = $vbulletin->db->query_first("
			SELECT userid, username
			FROM " . TABLE_PREFIX . "user
			WHERE username = '".$vbulletin->db->escape_string($username)."'
		");
		if (!$user)
		{
			$errormessage = 'Error, no user exists with username: '.$username.'.';
			eval(standard_error($errormessage));
		}
	}
	$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid='$lid' AND userid='".$user['userid']."' ");
	$countplayer = $countplayer['countrows'];  
	if ($countplayer != 0)
	{
		$errormessage = 'Error, player already in ladder.';
		eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
		SET userid = '".$user['userid']."', username = '".$vbulletin->db->escape_string($user['username'])."'
		WHERE lid = '$lid' AND id = '$pid'
	");
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
		SET u = '".$user['userid']."'
		WHERE lid = '$lid' AND u = '".$player['userid']."' 
	");
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
		SET u2 = '".$user['userid']."'
		WHERE lid = '$lid' AND u2 = '".$player['userid']."' 
	");
	$vbulletin->url = "ladders.php?do=view&id=".$lid;	
	eval(print_standard_redirect('redirect_updateladder'));
}

// #############################################################################

if ($_REQUEST['do'] == 'admin_swap')
{
	if (!$tmntp['ladder_superuser'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladders
		WHERE id = '$lid'
	");
	if (!$ladder)
	{
		print_no_permission();
	}
	$pid = $vbulletin->input->clean_gpc('g', 'pid', TYPE_UINT);
	$playerarray = array();
	$player = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladder_players
		WHERE lid = '$lid' AND id = '$pid'
	");
	if (!$player)
	{
		print_no_permission();
	}
	if ($ladder['pot'])
	{
		$player['teamurl'] = tll_seo('team',$player['userid'],$player['username']);
		$teamarray = array();
		$teamsquery = $vbulletin->db->query_read("
			SELECT t.*
			FROM  " . TABLE_PREFIX . "tmnt_teams AS t
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladder_players AS p
				ON (p.userid = t.teamid AND p.lid = $lid AND active = 1)
			WHERE t.noplayers <= $ladder[tmax]
				AND t.noplayers >= $ladder[tmin]
				AND p.id IS NULL
		");
		while($teamrow = $vbulletin->db->fetch_array($teamsquery))
		{
			$teamarray[] = $teamrow;
		}
	}
	$player['streak'] = $player['wstreak']-$player['lstreak'];
	$show['single'] = $show['usernameajax'] = true;
	$templater = vB_Template::create('tmnt_ladder_swap');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('player', $player);
		$templater->register('lid', $lid);
		$templater->register('pid', $pid);
		$templater->register('thisladder', $thisladder);
		$templater->register('thisplayer', $thisplayer);
		$templater->register('teamarray', $teamarray);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders']
	);
	$navbits['ladders.php?do=view&id='.$lid.''] = $ladder['title'];
	$navbits[''] = $vbphrase['ladder_swapplayer'];
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'admin_editpt')
{
	if (!$tmntp['ladder_superuser'])
	{
		print_no_permission();
	}
	if ($lid < 1)
	{
		$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	}
	$ladderarray = array();
	$ladders = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladders
		ORDER BY title ASC
	");
	while($ladder = $vbulletin->db->fetch_array($ladders))
	{
		if ($ladder['id'] == $lid)
		{
			$ladder['selected'] = ' selected="selected"';
			$thisladder = $ladder;
		}
		$ladderarray[] = $ladder;
	}
	if ($thisladder)
	{
		if ($pid < 1)
		{
			$pid = $vbulletin->input->clean_gpc('g', 'pid', TYPE_UINT);
		}
		$playerarray = array();
		$players = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladder_players
			WHERE lid = '$lid'
			ORDER BY username ASC
		");
		while($player = $vbulletin->db->fetch_array($players))
		{
			$player['streak'] = $player['wstreak']-$player['lstreak'];
			if ($player['id'] == $pid)
			{
				$player['selected'] = ' selected="selected"';
				$thisplayer = $player;
			}
			$playerarray[] = $player;
		}
	}
	$templater = vB_Template::create('tmnt_ladder_editpt');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladders', $ladderarray);
		$templater->register('players', $playerarray);
		$templater->register('lid', $lid);
		$templater->register('pid', $pid);
		$templater->register('thisladder', $thisladder);
		$templater->register('thisplayer', $thisplayer);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders']
	);
	if ($thisladder)
	{
		$navbits['ladders.php?do=view&id='.$lid.''] = $thisladder['title'];
	}
	$navbits[''] = $vbphrase['ladder_editpt'];
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'disable_warlight')
{
	if (!$vbulletin->userinfo['userid'] OR !$vbulletin->options['tmnt_premium'] OR !$vbulletin->options['tmnt_warlights'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_UINT);
	if ($lid <= 0)
	{
		print_no_permission();
	}
	$time = TIMENOW-60;
	//check ladder exists and is open...
	require_once(DIR . '/includes/functions_tll_premium.php');
	tll_update_warlight($vbulletin->userinfo['userid'],$lid,$time);
	$vbulletin->url = "ladders.php?do=matchfinder";
	if ($sh)
	{
		$vbulletin->url = "ladders.php?do=view&amp;id=".$lid."&amp;sh=".$sh;
	}
	eval(print_standard_redirect('redirect_disabledwarlight'));
}

// #############################################################################

if ($_REQUEST['do'] == 'enable_warlight')
{
	if (!$vbulletin->userinfo['userid'] OR !$vbulletin->options['tmnt_premium'] OR !$vbulletin->options['tmnt_warlights'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$from = $vbulletin->input->clean_gpc('g', 'from', TYPE_NOHTML);
	if ($lid <= 0)
	{
		print_no_permission();
	}
	$time = TIMENOW + 3600;
	$ladderinfo = fetch_ladderinfo($lid);
	if (!$ladderinfo)
	{
		print_no_permission();
	}
	if ($ladderinfo['pot'])
	{
		$teamid = $vbulletin->input->clean_gpc('g', 'teamid', TYPE_UINT);
		if ($teamid)
		{
			require_once(DIR . '/includes/functions_tll_premium.php');
			tll_update_warlight($teamid, $lid, $time, 1);
		}
		else
		{
			$array = array();
			$team_query = $vbulletin->db->query_read("
				SELECT p.*, t.teamname, m.leader, t.teamid
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
				LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
					ON (p.userid = t.teamid)
				LEFT JOIN " . TABLE_PREFIX . "tmnt_members AS m
					ON (t.teamid = m.teamid AND m.userid = '$thisuserid')
				WHERE p.pot = 1
					AND m.leader = 1
					AND p.lid = '$lid'
					AND m.userid = '$thisuserid'
			");
			while($row = $vbulletin->db->fetch_array($team_query))
			{
				$array[] = $row;
			}
			if (empty($array))
			{
				$errormessage = 'You do not have any teams in this ladder.';
				eval(standard_error($errormessage));
			}
			$templater = vB_Template::create('tmnt_enablelivematch_chooseteam');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladderinfo);
				$templater->register('from', $from);
				$templater->register('array', $array);
			$tlhtml = $templater->render();
			$navbits = array(
				'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
				'ladders.php' . $vbulletin->session->vars['sessionurl_q'] . '?do=view' . "&amp;id=$lid" => $ladderinfo['title'],
				'' => construct_phrase('Enable Live Match')
			);
			$navbar = render_navbar_template(construct_navbits($navbits));
			$templater = vB_Template::create('tmnt_shell');
			$templater->register_page_templates();
			$templater->register('navbar', $navbar);
			$templater->register('headinclude', $headinclude);
			$templater->register('pagetitle', $pagetitle);
			$templater->register('tlhtml', $tlhtml);
			$templater->register('modname', $modname);
			$templater->register('header', $header);
			$templater->register('footer', $footer);
			$templater->register('tmntp', $tmntp);
			$templater->register('tmnt_version', $tmnt_version);
			print_output($templater->render());	
		}
	}
	else
	{
		require_once(DIR . '/includes/functions_tll_premium.php');
		tll_update_warlight($vbulletin->userinfo['userid'],$lid,$time);
	}
	if ($_REQUEST['from'] == 'competitions_frontpage')
	{
		$vbulletin->url = "competitions.php";
	}
	elseif ($_REQUEST['from'] == 'ladders_warlights')
	{
		$vbulletin->url = "ladders.php?do=warlights";
	}
	elseif ($_REQUEST['from'] == 'ladders_matchfinder')
	{
		$vbulletin->url = "ladders.php?do=matchfinder";
	}
	elseif ($_REQUEST['from'] == 'ladders_view5')
	{
		$vbulletin->url = "ladders.php?do=view&amp;id=".$lid."&amp;sh=5";
	}
	else
	{
		$vbulletin->url = "ladders.php?do=view&amp;id=".$lid;
	}
	eval(print_standard_redirect('redirect_enabledwarlight'));
}

// #############################################################################

if ($_REQUEST['do'] == 'add')
{
	if (!$tmntp['cancreateladder'])
	{
		print_no_permission();
	}
	$select_catid = $vbulletin->input->clean_gpc('g', 'c', TYPE_UINT);
	$select_pot = $vbulletin->input->clean_gpc('g', 'pot', TYPE_BOOL);
	$select_league = $vbulletin->input->clean_gpc('g', 'league', TYPE_UINT);
	$select_groups = $vbulletin->input->clean_gpc('g', 'groups', TYPE_UINT);
	$carray = array();
	$categories = '<select name="catid" id="catid">';
	if ($vbulletin->options['tmnt_allow_uncat'])
	{
		$categories .= '<option value="0"></option>';
	}
	/*$cats = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_categories
		WHERE tol IN (2,3)
		ORDER BY parentid DESC, displayorder ASC, title ASC
	");
	while($cat = $vbulletin->db->fetch_array($cats))
	{*/
	if ($vbulletin->tll_catcache)
	{
		foreach ($vbulletin->tll_catcache AS $cindex => $cat)
		{
			if (!in_array('ladders',$cat['tol']) && !in_array('leagues',$cat['tol']) && !$carray["$cat[catid]"])
			{
				continue;
			}
			if ($cat['parentid'])
			{
				$carray["$cat[parentid]"] .= '<option value="'.$cat['catid'].'"';
				if ($cat['catid'] == $select_catid)
				{
					$carray["$cat[parentid]"] .= ' selected="selected"';
				}
				$carray["$cat[parentid]"] .= '> - '.$cat[title].'</option>';
			}
			else
			{
				$categories .= '<option value="'.$cat[catid].'"';
				if ($cat['catid'] == $select_catid)
				{
					$categories .= ' selected="selected"';
				}
				$categories .= '>'.$cat[title].'</option>';
				$categories .= $carray["$cat[catid]"];
			}
		}
	}
	$categories .= '</select>';
	$squery = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladders
		WHERE groupid != 0
		ORDER BY groupid ASC
	");
	$select_season = $vbulletin->input->clean_gpc('g', 'season', TYPE_UINT);
	$seasons = array();
	$lastseason = array();
	while($season = $vbulletin->db->fetch_array($squery))
	{
		if ($season['groupid'] != $lastseason['groupid'])
		{
			$season['optgroup'] = true;
			$season['optgroupid'] = ++$optgroup;
		}
		if ($season['groupid'] == $select_season && !$selectedseason)
		{
			$selectedseason = true;
			$season['selected'] = ' selected="selected"';
		}
		$season['lastseason'] = $lastseason['groupid'];
		$seasons[] = $season;
		$lastseason = $season;
	}
	$season = array(
		'optgroupid' => ($optgroup+1),
		'optgroup' => true,
		'title' => $vbphrase['ladder_new_seasons_group'],
		'groupid' => ($lastseason['groupid']+1)
	);
	$seasons[] = $season;
	if (!$dateline_from)
	{
		$dateline_from = TIMENOW;
	}
	if (!$dateline_to)
	{
		$dateline_to = TIMENOW + 2592000;
	}
	$utc = 0.00;
	$dst = 1;
	list ($timezoneoptions, $from_day, $from_monthselected, $from_yearbits, $user_from_time, $dstchecked, $show) = tmnt_dateline_to_fields($dateline_from, $utc, $dst, $show);
	list ($timezoneoptions, $to_day, $to_monthselected, $to_yearbits, $user_to_time, $dstchecked, $show) = tmnt_dateline_to_fields($dateline_to, $utc, $dst, $show);
	$templater = vB_Template::create('tmnt_date_time');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('time', $user_from_time);
		$templater->register('day', $from_day);
		$templater->register('monthselected', $from_monthselected);
		$templater->register('yearbits', $from_yearbits);
		$templater->register('rangeid', 0);
		$templater->register('prefix', 'from');
	$startdatehtml = $templater->render();
	$templater = vB_Template::create('tmnt_date_time');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('time', $user_to_time);
		$templater->register('day', $to_day);
		$templater->register('monthselected', $to_monthselected);
		$templater->register('yearbits', $to_yearbits);
		$templater->register('rangeid', 1);
		$templater->register('prefix', 'to');
	$enddatehtml = $templater->render();
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar('', 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar('');
	}
	if ($select_league)
	{
		$vbphrase['ladder_create'] = $vbphrase['ladder_create_league'];
		$vbphrase['ladder_date'] = $vbphrase['league_date'];
	}
	$templater = vB_Template::create('tmnt_ladder_new');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
		$templater->register('categories', $categories);
		$templater->register('seasons', $seasons);
		$templater->register('pot', $select_pot);
		$templater->register('league', $select_league);
		$templater->register('groups', $select_groups);
		$templater->register('startdatehtml', $startdatehtml);
		$templater->register('enddatehtml', $enddatehtml);
		$templater->register('utc', $utc);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('timezoneoptions', $timezoneoptions);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => construct_phrase($vbphrase['ladder_create'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'insert')
{
	if (!$tmntp['cancreateladder'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'message' => TYPE_STR,
		'title' => TYPE_NOHTML,
		'icon' => TYPE_NOHTML,
		'wysiwyg' => TYPE_BOOL,
		'pot' => TYPE_UINT,
		'catid' => TYPE_UINT,
		'league' => TYPE_BOOL,
		'homeaway' => TYPE_UINT,
		'groups' => TYPE_UINT,
		'groupid' => TYPE_UINT,
		'timezoneoffset' => TYPE_ARRAY_NUM,
		'dst' => TYPE_ARRAY_UINT,
		'fromdate' => TYPE_ARRAY_ARRAY,
		'todate' => TYPE_ARRAY_ARRAY,
		'totime' => TYPE_ARRAY_NOHTML,
		'fromtime' => TYPE_ARRAY_NOHTML,
		'chal_cost' => TYPE_NUM,
		'join_cost' => TYPE_NUM,
		'chal_cost_xtra' => TYPE_BOOL,
		'racemode' => TYPE_UINT,
	));
	if (!$vbulletin->GPC['title'])
	{
		$errormessage = $vbphrase[error_invalid_title];
		eval(standard_error($errormessage));
	}
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$description = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$description = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$description = $vbulletin->GPC['message'];
	}
	if (!$description)
	{
		$errormessage = $vbphrase[error_invalid_description];
		eval(standard_error($errormessage));
	}
	$chal_options = serialize(
		array(
			/*'Best Of' => '',
			'Map' => ''*/
		)
	);
	//start date
	$type = 'range';
	$fromtime = $vbulletin->GPC['fromtime']["$type"];
	$totime = $vbulletin->GPC['totime']["$type"];
	$fromdate = $vbulletin->input->clean($vbulletin->GPC['fromdate']["$type"], TYPE_ARRAY_UINT);
	$todate = $vbulletin->input->clean($vbulletin->GPC['todate']["$type"], TYPE_ARRAY_UINT);
	$utc = $timezoneoffset = $vbulletin->GPC['timezoneoffset']["$type"];
	$dst = $vbulletin->GPC['dst']["$type"];
	require_once(DIR . '/includes/functions_misc.php');
	if (!fetch_timezone($timezoneoffset))
	{
		$errormessage = 'Error: invalid timezone specified';
		eval(standard_error($errormessage));
	}	
	$dateline_to = tmnt_fields_to_dateline($totime, $todate, $utc, $dst, $type);
	if (!is_numeric($dateline_to))
	{
		$errormessage = $dateline_to;
		eval(standard_error($errormessage));
	}
	$dateline_from = tmnt_fields_to_dateline($fromtime, $fromdate, $utc, $dst, $type);
	if (!is_numeric($dateline_from))
	{
		$errormessage = $dateline_from;
		eval(standard_error($errormessage));
	}
	if ($dateline_to < $dateline_from)
	{
		$errormessage = 'Error: End date must be after start date.';
		eval(standard_error($errormessage));
	}
	//end date
	if (!$vbulletin->options['tmnt_premium'] OR !$vbulletin->options['tmnt_credit_system'])
	{
		$vbulletin->GPC['chal_cost'] = $vbulletin->GPC['join_cost'] = $vbulletin->GPC['chal_cost_xtra'] = 0;
	}
	if ($vbulletin->options['tmnt_createthread'])
	{
		require_once('./includes/functions_databuild.php');
        $forumid = $vbulletin->options['tmnt_createthread'];
		$templater = vB_Template::create('tmnt_ladder_threadtemplate');
			$templater->register('ladder', $ladder);
			$templater->register('description', $description);
			$templater->register('id', $id);
			$templater->register('title', $vbulletin->GPC['title']);
			$templater->register('catid', $vbulletin->GPC['catid']);
			$templater->register('pot', $vbulletin->GPC['pot']);
			$templater->register('userid', $thisuserid);
			$templater->register('forumid', $forumid);
			$templater->register('username', $thisusername);
		$pagetext = $templater->render();
		$pagetext = preg_replace('/<!--(.|\s)*?-->/', '', $pagetext);
        $open = 1;
        $allow_smilie = 1;
        $visible = 1;
		$threadid = new_thread($thisuserid, $forumid, $vbulletin->GPC['title'], $pagetext, $open, $allow_smilie, $visible);
	}
	else
	{
		$threadid = 0;
	}
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_ladders
		(title, description, noplayers, cr_userid, cr_username, cr_time, cr_ip, threadid, pot, catid, icon, chal_options, league, homeaway, groups, groupid, dateline_from, dateline_to, dst, utc, chal_cost, join_cost, chal_cost_xtra, xp_win, xp_draw, xp_lose, racemode)
		VALUES (
			'".$vbulletin->db->escape_string($vbulletin->GPC['title'])."', 
			'".$vbulletin->db->escape_string($description)."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['noplayers'])."',
			'".$vbulletin->db->escape_string($thisuserid)."', 
			'".$vbulletin->db->escape_string($thisusername)."', 
			".TIMENOW.",
			'".$vbulletin->db->escape_string($thisip)."',
			'".$vbulletin->db->escape_string($threadid)."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['pot'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['catid'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['icon'])."',
			'".$vbulletin->db->escape_string($chal_options)."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['league'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['homeaway'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['groups'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['groupid'])."',
			'".$vbulletin->db->escape_string($dateline_from)."',
			'".$vbulletin->db->escape_string($dateline_to)."',
			'".$vbulletin->db->escape_string($dst)."',
			'".$vbulletin->db->escape_string($utc)."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['chal_cost'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['join_cost'])."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['chal_cost_xtra'])."',
			'".$vbulletin->db->escape_string(3)."',
			'".$vbulletin->db->escape_string(1)."',
			'".$vbulletin->db->escape_string(0)."',
			'".$vbulletin->db->escape_string($vbulletin->GPC['racemode'])."'
		)
		");
	$id = $vbulletin->db->insert_id();
	build_tll_catcache();
	$vbulletin->url = "ladders.php?do=view&id=$id";	
	eval(print_standard_redirect('redirect_insertladder'));
}

// #############################################################################

if ($_POST['do'] == 'insertchal')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('p', 'lid', TYPE_UINT);
	if (!$lid)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}	
	$u2 = $vbulletin->input->clean_gpc('p', 'u2', TYPE_UINT);
	$mf = 0;
	if (!$u2)
	{
		$mf = 1;
	}
		/*if (!$u2)
		{
			$errormessage = $vbphrase[error_invalid_challenger];
			eval(standard_error($errormessage));
		}*/
	$bestof = $vbulletin->input->clean_gpc('p', 'bestof', TYPE_UINT);
	$map = $vbulletin->input->clean_gpc('p', 'map', TYPE_NOHTML);
	$u1message = $vbulletin->input->clean_gpc('p', 'u1message', TYPE_NOHTML);
	$u2message = $vbulletin->input->clean_gpc('p', 'u2message', TYPE_NOHTML);
	$userid = $thisuserid;
	$u = $vbulletin->input->clean_gpc('p', 'u', TYPE_UINT);
	$squadsize = $vbulletin->input->clean_gpc('p', 'squadsize', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id=$lid ");
	if (!$ladder)
	{
		print_no_permission();
	}
	if ($ladder['status'] > 0)
	{
		print_no_permission();
	}
	$co_array = unserialize($ladder['chal_options']);
	$chal_options = array();
	if (is_array($co_array))
	{
		foreach ($co_array AS $key => $value)
		{
			$key = str_replace(' ','_',$key);
			$key = preg_replace("/[^a-zA-Z0-9_\s]/", "", unhtmlspecialchars($key));
			$chal_options["$key"] = $vbulletin->input->clean_gpc('p', "$key", TYPE_NOHTML);
		}
		$chal_options = serialize($chal_options);
	}
	if ($ladder['archive'] == '1')
	{
		$errormessage = $vbphrase[error_ladder_closed];
		eval(standard_error($errormessage));
	}
	if ($u == $u2)
	{
		$errormessage = $vbphrase[error_invalid_challenged];
		eval(standard_error($errormessage));
	}
	$time_limit = TIMENOW - ($vbulletin->options['tmnt_ladder_limitrematch'] * 60 * 60);
	$countlimit = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND dateline_finished > '" . $time_limit . "' ");
	if ($countlimit['countrows'])
	{
		$errormessage = "Please wait 24 hours between challenging the same player/team.";
		eval(standard_error($errormessage));
	}
	/* challenge time/date */
	$vbulletin->input->clean_array_gpc('p', array(
		'timezoneoffset' => TYPE_ARRAY_NUM,
		'dst'            => TYPE_ARRAY_UINT,
		'date'       => TYPE_ARRAY_ARRAY,
		'time'       => TYPE_ARRAY_NOHTML
	));
	$type = 'range';
	$time = $vbulletin->GPC['time']["$type"];
	$date = $vbulletin->input->clean($vbulletin->GPC['date']["$type"], TYPE_ARRAY_UINT);
	$utc = $timezoneoffset = $vbulletin->GPC['timezoneoffset']["$type"];
	$dst = $vbulletin->GPC['dst']["$type"] = 1;
	require_once(DIR . '/includes/functions_misc.php');
	if (!fetch_timezone($timezoneoffset))
	{
		$errormessage = "Error: invalid timezone specified";
		eval(standard_error($errormessage));
	}
	if (!checkdate($date['month'], $date['day'], $date['year']))
	{
		$errormessage = "Error: Bad Date";
		eval(standard_error($errormessage));
	}
	$time_re = '#^(0?[1-9]|1[012])\s*[:.]\s*([0-5]\d)(\s*[AP]M)?|([01]\d|2[0-3])\s*[:.]\s*([0-5]\d)$#i';

	// match text in field for a valid time
	if (preg_match($time_re, $time, $matches))
	{
		if (count($matches) == 3)
		{
			$hour = intval($matches[1]);
			$minute = intval($matches[2]);
			$ampm = $matches[1] == '12' ? 'PM' : 'AM';
		}
		else if (count($matches) == 4)
		{
			$hour = intval($matches[1]);
			$minute = intval($matches[2]);
			$ampm = strtoupper(trim($matches[3]));
		}
		else // 24hr time
		{
			$hour = intval($matches[4]);
			$minute = intval($matches[5]);
			$ampm = ($hour <= 11) ? 'AM' : 'PM';
		}
	}
	if (($pos = strpos($vbulletin->options['timeformat'], 'H')) === false)
	{
		if ($ampm == 'PM')
		{
			if ($hour >= 1 AND $hour <= 11)
			{
				$hour += 12;
			}
		}
		else
		{
			if ($hour == 12)
			{
				$hour = 0;
			}
		}
	}
	$min_offset = $utc - intval($utc);
	$hour   -= intval($utc);
	$minute -= intval($min_offset * 60);
	$dateline = gmmktime($hour, $minute, 0, $date['month'], $date['day'], $date['year']);
	if ($_POST['now'])
	{
		$dateline = TIMENOW;
	}
	/* end challenge time/date */
	if ($ladder['pot'] != '1')
	{
		// start singles
		if ($u != $vbulletin->userinfo['userid'])
		{
			$errormessage = "Unexpected Error: Error in template 'tmnt_ladder_chal'";
			eval(standard_error($errormessage));
		}
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND finished=0 ");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer >= $vbulletin->options['tmnt_ladder_maxc'] && $u2 > 0)
		{
			$errormessage = $vbphrase['error_already_challenged'];
			eval(standard_error($errormessage));
		}
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u2 AND active=1");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer != 1 && $u2 > 0)
		{
			$errormessage = $vbphrase['error_player_not_ladder'];
			eval(standard_error($errormessage));
		}
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u AND active=1");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer != 1)
		{
			$errormessage = construct_phrase($vbphrase['error_not_in_ladder'],$lid);
			eval(standard_error($errormessage));
		}
		$username_u = $thisusername;
		$u2info = fetch_userinfo($u2);
		$username_u2 = $u2info['username'];
		if ($ladder['chal_cost'] > 0 && $vbulletin->options['tmnt_credit_system'] && $vbulletin->userinfo['tmnt_credits'] < $ladder['chal_cost'])
		{
			$errormessage = 'Error, insufficient credits. Once accepted a challenge will cost you '.$match['chal_cost'].'credits, you only have '.$vbulletin->userinfo['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
		if ($ladder['chal_cost'] > 0 OR $ladder['chal_cost_xtra'])
		{
			$chal_cost = $ladder['chal_cost'];
			if ($ladder['chal_cost_xtra'])
			{
				$chal_cost = $vbulletin->input->clean_gpc('p', 'chal_cost', TYPE_UNUM);
				if ($chal_cost < $ladder['chal_cost'])
				{
					$chal_cost = $ladder['chal_cost'];
				}
			}
			$ladder['win_credits'] = (1-$vbulletin->options['tmnt_credits_comm'])*2*$chal_cost;
		}
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_games
				(u, u2, lid, time, pot, bestof, matchdate, map, u1message, u2message, chal_options, dateline, mf, chal_cost, win_credits, squadsize)
			VALUES (
				'".$vbulletin->db->escape_string($u)."',
				'".$vbulletin->db->escape_string($u2)."',
				'".$vbulletin->db->escape_string($lid)."',
				'".TIMENOW."',
				'0',
				'".$vbulletin->db->escape_string($bestof)."',
				'".$vbulletin->db->escape_string($matchdate)."',
				'".$vbulletin->db->escape_string($map)."',
				'".$vbulletin->db->escape_string($u1message)."',
				'".$vbulletin->db->escape_string($u2message)."',
				'".$vbulletin->db->escape_string($chal_options)."',
				'".$vbulletin->db->escape_string($dateline)."',
				'".$vbulletin->db->escape_string($mf)."',
				'".$vbulletin->db->escape_string($chal_cost)."',
				'".$vbulletin->db->escape_string($ladder['win_credits'])."',
				'0'
			)
		");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET challenges = challenges + 1 WHERE lid=$lid AND userid=$u");
		/* adding notification for u2 */
		if (!is_array($u2info['tmnt_notifications']) && $u2info['tmnt_notifications'])
		{
			$u2info['tmnt_notifications'] = unserialize($u2info['tmnt_notifications']);
		}
		else if (!$u2info['tmnt_notifications'])
		{
			$u2info['tmnt_notifications'] = array();
		}
		$u2info['tmnt_notifications']['ladder_chals']++;
		$u2info['tmnt_notifications'] = serialize($u2info['tmnt_notifications']);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($u2info['tmnt_notifications'])."' WHERE userid = '".$u2info['userid']."'");
		/* end */
		require_once('./includes/functions_databuild.php');
		$fromuserid = $thisuserid;
		$fromusername = $thisusername;
		//$title = $thisusername." has challenged you"; 
		$title = construct_phrase($vbphrase['ladder_x_challenged_you'], $thisusername);
		$recipients = $username_u2;
		$templater = vB_Template::create('tmnt_ladder_chalpm');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('title', $title);
		$templater->register('fromusername', $fromusername);
		$templater->register('fromuserid', $fromuserid);
		$message = $templater->render();
		$message = preg_replace('/<!--(.|\s)*?-->/', '', $message);
			$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
			$pmdm->set('fromuserid', $fromuserid);
			$pmdm->set('fromusername', $fromusername);
			$pmdm->set('title', $title);
			$pmdm->set('message', $message);
			$pmdm->set_recipients($recipients, $botpermissions);
			$pmdm->set('dateline', TIMENOW); 
			$pmdm->overridequota = true;
			$errors = $pmdm->errors;
			if ($errors) {
				foreach ($errors as $error) {
					$errorss .= $error. "<br />";
				}
				$errormessage = $vbphrase[error_success_chal_error_pm].$errorss;
				eval(standard_error($errormessage));
			}
			$pmdm->save();
			unset($pmdm);
		// end singles
	}
	else
	{
		// start team
		$countteam = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND finished = '0' " . ($u2 == 0 ? " AND dateline > ".TIMENOW." " : "") . " ");
		if ($countteam['countrows'] > $vbulletin->options['tmnt_ladder_maxc'])
		{
			$errormessage = $vbphrase['error_already_challenged'];
			eval(standard_error($errormessage));
		}
		$countteam = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u2 ");
		if ($countteam['countrows'] != 1 && $u2 > 0)
		{
			$errormessage = $vbphrase['error_invalid_challenged'];
			eval(standard_error($errormessage));
		}
		$countteam = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u ");
		if ($countteam['countrows'] != 1 && $u2 > 0)
		{
			$errormessage = $vbphrase[error_you_not_ladder];
			eval(standard_error($errormessage));
		}
		$team = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid=$u ");
		if ($ladder['chal_cost'] > 0 && $vbulletin->options['tmnt_credit_system'] && $team['tmnt_credits'] < $ladder['chal_cost'])
		{
			$errormessage = 'Error, insufficient credits. Once accepted a challenge will cost your team '.$match['chal_cost'].'credits, you only have '.$team['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
		if ($ladder['chal_cost'] > 0 OR $ladder['chal_cost_xtra'])
		{
			$chal_cost = $ladder['chal_cost'];
			if ($ladder['chal_cost_xtra'])
			{
				$chal_cost = $vbulletin->input->clean_gpc('p', 'chal_cost', TYPE_UNUM);
				if ($chal_cost < $ladder['chal_cost'])
				{
					$chal_cost = $ladder['chal_cost'];
				}
			}
			$ladder['win_credits'] = (1-$vbulletin->options['tmnt_credits_comm'])*2*$chal_cost;
		}
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_games
				(u, u2, lid, time, pot, bestof, matchdate, map, u1message, u2message, chal_options, dateline, mf, chal_cost, win_credits, squadsize)
			VALUES (
				'".$vbulletin->db->escape_string($u)."',
				'".$vbulletin->db->escape_string($u2)."',
				'".$vbulletin->db->escape_string($lid)."',
				'".TIMENOW."',
				'1',
				'".$vbulletin->db->escape_string($bestof)."',
				'".$vbulletin->db->escape_string($matchdate)."',
				'".$vbulletin->db->escape_string($map)."',
				'".$vbulletin->db->escape_string($u1message)."',
				'".$vbulletin->db->escape_string($u2message)."',
				'".$vbulletin->db->escape_string($chal_options)."',
				'".$vbulletin->db->escape_string($dateline)."',
				'".$vbulletin->db->escape_string($mf)."',
				'".$vbulletin->db->escape_string($chal_cost)."',
				'".$vbulletin->db->escape_string($ladder['win_credits'])."',
				'".$vbulletin->db->escape_string($squadsize)."'
			)
		");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET challenges = challenges + 1 WHERE lid='$lid' AND userid='$u' ");
		/* adding notification for u2 */
		$u2_leader = $vbulletin->db->query_first("SELECT userid FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid = '$u2' AND leader = 1");
		$u2info = fetch_userinfo($u2_leader['userid']);
		if (!is_array($u2info['tmnt_notifications']) && $u2info['tmnt_notifications'])
		{
			$u2info['tmnt_notifications'] = unserialize($u2info['tmnt_notifications']);
		}
		else if (!$u2info['tmnt_notifications'])
		{
			$u2info['tmnt_notifications'] = array();
		}
		$u2info['tmnt_notifications']['ladder_chals']++;
		$u2info['tmnt_notifications'] = serialize($u2info['tmnt_notifications']);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($u2info['tmnt_notifications'])."' WHERE userid = '".$u2info['userid']."'");
		/* end */
		require_once('./includes/functions_databuild.php');
		$fromuserid = $thisuserid;
		$fromusername = $thisusername;
		$title = construct_phrase($vbphrase['ladder_x_challenged_your_team'], $thisusername); 
		$recipients = $u2info['username'];
		$templater = vB_Template::create('tmnt_ladder_chalpm');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('title', $title);
		$templater->register('fromusername', $fromusername);
		$templater->register('fromuserid', $fromuserid);
		$message = $templater->render();
		$message = preg_replace('/<!--(.|\s)*?-->/', '', $message);
			$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
			$pmdm->set('fromuserid', $fromuserid);
			$pmdm->set('fromusername', $fromusername);
			$pmdm->set('title', $title);
			$pmdm->set('message', $message);
			$pmdm->set_recipients($recipients, $botpermissions);
			$pmdm->set('dateline', TIMENOW); 
			$pmdm->overridequota = true;
			$errors = $pmdm->errors;
			if ($errors) {
				foreach ($errors as $error) {
					$errorss .= $error. "<br />";
				}
				$errormessage = $vbphrase[error_success_chal_error_pm].$errorss;
				eval(standard_error($errormessage));
			}
			$pmdm->save();
			unset($pmdm);
		// end team
	}
	if ($mf)
	{
		$vbulletin->url = "ladders.php?do=view&id=".$lid."&sh=5";
	}
	else
	{
		$vbulletin->url = "ladders.php?do=view&id=".$lid;
	}
	eval(print_standard_redirect('redirect_insertchalladder'));
}

// #############################################################################

if ($_REQUEST['do'] == 'warlights')
{
	if (!$tmntp['canviewladder'] OR !$vbulletin->userinfo['userid'] OR !$vbulletin->options['tmnt_warlights'])
	{
		print_no_permission();
	}
	$array3 = $array2 = $array = array();
	$players_query = $vbulletin->db->query_read("
		SELECT p.*, l.title AS laddertitle, u.username
		FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
			ON (p.lid = l.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (p.userid = u.userid)
		WHERE p.warlight > '".TIMENOW."'
			AND p.pot = 0
			AND p.userid != '".$vbulletin->userinfo['userid']."'
		LIMIT 0, 10
	");
	while($player = $vbulletin->db->fetch_array($players_query))
	{
		$player['ladderurl'] = tll_seo('ladder', $player['lid'], $player['laddertitle']);
		$array[] = $player;
	}
	if ($vbulletin->userinfo['userid'])
	{
		$players_query = $vbulletin->db->query_read("
			SELECT p.*, l.title AS laddertitle
			FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
				ON (p.lid = l.id)
			WHERE p.userid = '".$vbulletin->userinfo['userid']."'
				AND p.pot = 0
				AND l.league = 0
				AND l.archive = 0
				AND p.active = 1
		");
		while($player = $vbulletin->db->fetch_array($players_query))
		{
			$player['ladderurl'] = tll_seo('ladder', $player['lid'], $player['laddertitle']);
			if ($player['warlight'] < TIMENOW)
			{
				$array2[] = $player;
			}
			else
			{
				$array3[] = $player;
			}
		}
	}
	$templater = vB_Template::create('tmnt_warlights');
		$templater->register('hide', $hide);
		$templater->register('array', $array);
		$templater->register('array2', $array2);
		$templater->register('array3', $array3);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => construct_phrase($vbphrase[ladders])
	);
	$navbits[''] = construct_phrase($vbphrase['tmnt_war_lights']);
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}


// #############################################################################

if ($_REQUEST['do'] == 'pm')
{
	if (!$show['member'] || !$tmntp['canviewladder']) {
		print_no_permission();
	}
    $lid = $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase['error_invalid_ladder'];
        eval(standard_error($errormessage));
	}
	require_once('./includes/functions_databuild.php');
	require_once(DIR . '/includes/functions_tll_pms.php');
	list($ladder, $message) = tll_default_ladder_pm($lid);
	$fromuserid = $vbulletin->userinfo['userid'];
	$fromusername = $vbulletin->userinfo['username'];
	$recipients = $vbulletin->userinfo['username'];
	$title = $ladder['title'];
	//global $vbulletin, $botpermissions;
	$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
		$pmdm->set('fromuserid', $fromuserid);
		$pmdm->set('fromusername', $fromusername);
		$pmdm->set('title', $title);
		$pmdm->set('message', $message);
		$pmdm->set_recipients($recipients, $botpermissions);
		$pmdm->set('dateline', TIMENOW); 
		$pmdm->overridequota = true;
		$errors = $pmdm->errors;
		if ($errors) {
			foreach ($errors as $error) {
				$errorss .= $error. "<br />";
			}
			$errormessage = $errorss;
			eval(standard_error($errormessage));
		}
		$pmdm->save();
		unset($pmdm);
	$vbulletin->url = "ladders.php?do=view&id=$id";
	eval(print_standard_redirect('redirect_ladderpm'));
}

// #############################################################################

if ($_POST['do'] == 'insertpmcmpt')
{
    $id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT cr_userid FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id=$id ");
	if ($ladder['userid'] != $thisuserid) {
	if (!$tmntp['caneditladder']) {
		print_no_permission();
	} }
	$title = $vbulletin->input->clean_gpc('p', 'title', TYPE_NOHTML);
	$title = addslashes($title);
		if (!$title)
		{
			$errormessage = $vbphrase[error_invalid_title];
        	eval(standard_error($errormessage));
		}
	$vbulletin->input->clean_array_gpc('p', array(
		'message'      => TYPE_STR,
		'wysiwyg'			 => TYPE_BOOL,
		'recipients'     => TYPE_STR,
	));
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$description = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$description = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$description = $vbulletin->GPC['message'];
	}
	if (!$description)
	{
		$errormessage = $vbphrase[error_invalid_message];
		eval(standard_error($errormessage));
	}
	$message = $description;
	$recipients = $vbulletin->GPC['recipients'];
	$fromuserid = $thisuserid;
	$fromusername = $thisusername;
	require_once('./includes/functions_databuild.php');
	global $vbulletin, $botpermissions;
	$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
		$pmdm->set('fromuserid', $fromuserid);
		$pmdm->set('fromusername', $fromusername);
		$pmdm->set('title', $title);
		$pmdm->set('message', $message);
		$pmdm->set_recipients($recipients, $botpermissions);
		$pmdm->set('dateline', TIMENOW);
		$pmdm->overridequota = true;
		$errors = $pmdm->errors;
		if ($errors) {
			foreach ($errors as $error) {
				$errorss .= $error. "<br />";
			}
			$errormessage = $errorss;
			eval(standard_error($errormessage));
		}
		$pmdm->save();
		unset($pmdm);
	$vbulletin->url = "ladders.php?do=view&id=$id";
	eval(print_standard_redirect('redirect_pmcmpt'));
}

// #############################################################################

if ($_REQUEST['do'] == 'pmcmpt')
{
    if (!$show['member'] || !$tmntp['canviewladder']) {
		print_no_permission();
	}
    $lid = $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase['error_invalid_ladder'];
        eval(standard_error($errormessage));
	}
	require_once('./includes/functions_databuild.php');
	require_once(DIR . '/includes/functions_tll_pms.php');
	list($ladder, $message) = tll_default_ladder_pm($lid);
	$fromuserid = $vbulletin->userinfo['userid'];
	$fromusername = $vbulletin->userinfo['username'];
	$recipients = $vbulletin->userinfo['username'];
	$title = $ladder['title'];
	$user_names = $vbulletin->db->query_read("SELECT username FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$id' AND userid != 0 ");
	$pmto_users = array();
        while ($name = $vbulletin->db->fetch_array($user_names))
        {
            $pmto_users[] = $name['username'];
        }
        $vbulletin->db->free_result($user_names); 
	$recipients = implode(' ; ', $pmto_users);  
	$show['sendmultiple'] = true;
	$show['parseurl'] = $vbulletin->options['privallowbbcode'];
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar($message, 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar($message);
	}
	$templater = vB_Template::create('tmnt_newpm');
		$templater->register('ladder', $ladder);
		$templater->register('description', $ladder['description']);
		$templater->register('noplayers', $ladder['noplayers']);
		$templater->register('id', $id);
		$templater->register('fromuserid', $fromuserid);
		$templater->register('fromusername', $fromusername);
		$templater->register('title', $title);
		$templater->register('date', $date);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
		$templater->register('postpreview', $postpreview);
		$templater->register('recipients', $recipients);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' => $vbphrase['ladders'],
		'ladders.php' . $ladder['url'] => $title,
		'' => construct_phrase($vbphrase['tmnt_pmcmpt'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'matchfinder')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	if ($vbulletin->userinfo['userid'] && $vbulletin->options['tmnt_warlights'])
	{
		$array3 = $array2 = $array = array();
		$players_query = $vbulletin->db->query_read("
			SELECT p.*, l.title AS laddertitle, IF (p.pot = 1, t.teamname, u.username) AS username
			FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
				ON (p.lid = l.id)
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (p.userid = u.userid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
				ON (p.userid = t.teamid)
			WHERE p.warlight > '".TIMENOW."'
				AND (p.userid != '".$vbulletin->userinfo['userid']."'
					OR p.pot = 1)
				AND l.archive = 0
				AND p.active = 1
			LIMIT 0, 10
		");
		while($player = $vbulletin->db->fetch_array($players_query))
		{
			$player['ladderurl'] = tll_seo('ladder', $player['lid'], $player['laddertitle']);
			$array[] = $player;
		}
		if ($vbulletin->userinfo['userid'])
		{
			$players_query = $vbulletin->db->query_read("
				SELECT p.*, l.title AS laddertitle
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
				LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
					ON (p.lid = l.id)
				WHERE p.userid = '".$vbulletin->userinfo['userid']."'
					AND p.pot = 0
					AND l.league = 0
					AND l.archive = 0
					AND p.active = 1
			");
			while($player = $vbulletin->db->fetch_array($players_query))
			{
				$player['ladderurl'] = tll_seo('ladder', $player['lid'], $player['laddertitle']);
				if ($player['warlight'] < TIMENOW)
				{
					$array2[] = $player;
				}
				else
				{
					$array3[] = $player;
				}
			}
		}
		$templater = vB_Template::create('tmnt_warlights');
			$templater->register('hide', $hide);
			$templater->register('array', $array);
			$templater->register('array2', $array2);
			$templater->register('array3', $array3);
		$tlhtml .= $templater->render();
	}
	$inladders = array();
	$globalg = array();
	$globalg['yourteams'] = array();
	$globalg['teamcount'] = 0;
	$teamids = "0";
	$teams = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_members AS members
		RIGHT JOIN " . TABLE_PREFIX . "tmnt_teams AS teams
			ON (members.teamid = teams.teamid)
		WHERE members.leader = '1'
			AND members.userid = '$thisuserid'
	");
	while($teamm = $vbulletin->db->fetch_array($teams))
	{
		$globalg['yourteams'][] = $teamm;
		$globalg['teamcount']++;
		$teamids .= ",".$teamm['teamid'];
	}
	$qinladders = $vbulletin->db->query_read("SELECT lid FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE (userid=$thisuserid AND pot = 0) OR (userid IN (".$teamids.") AND pot = 1) AND active=1");
	while($ladder = $vbulletin->db->fetch_array($qinladders))
	{
		$inladders[] = $ladder['lid'];
	}
	$matches = array();
	$ladders = array();
	$games = $vbulletin->db->query_read("
		SELECT games.*, ladders.title AS laddertitle, IF (games.pot>0,t.teamname,u.username) AS username
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (ladders.id = games.lid)
		LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (games.pot = 0 AND games.u = u.userid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
			ON (games.pot = 1 AND games.u = t.teamid)
		WHERE
			games.u2 = 0
			AND games.finished = 0
			AND games.accepted = 0
			AND games.dateline > ".TIMENOW."
		ORDER BY games.lid ASC, games.dateline ASC
		LIMIT 0, 20
	");
	while($game = $vbulletin->db->fetch_array($games))
	{
		$game['time'] = vbdate($vbulletin->options['timeformat'], $game['dateline']);
		$game['date'] = vbdate($vbulletin->options['dateformat'], $game['dateline'], true);
		$game['showlt'] = true;
		if ($lastgame['lid'] == $game['lid'])
		{
			$game['showlt'] = false;
		}
		$game['notinladder'] = false;
		if (!in_array($game['lid'], $inladders))
		{
			$game['notinladder'] = true;
		}
		$game = process_chal_options($game);
		$game['ladderurl'] = tll_seo('ladder', $game['lid'], $game['laddertitle']);
		$matches[] = $game;
		$ladders[] = $game['lid'];
		$lastgame = $game;
	}
	$templater = vB_Template::create('tmnt_ladder_mf');
		$templater->register('pagenav', $pagenav);
		$templater->register('tmntp', $tmntp);
		$templater->register('team', $team);
		$templater->register('globalg', $globalg);
		$templater->register('matches', $matches);
		$templater->register('inladders', $inladders);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => construct_phrase($vbphrase[ladders])
	);
	$navbits[''] = construct_phrase($vbphrase['ladder_match_finder']);
	/*$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladders SET views = views + 1 WHERE id = '$id'
	");*/
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'updateavatar')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
require_once(DIR . '/tll_modules/tll_editavatar.php');
	$userid = $vbulletin->input->clean_gpc('p', 'userid', TYPE_UINT);
	$lid = $vbulletin->input->clean_gpc('p', 'lid', TYPE_UINT);
	$delete = $vbulletin->input->clean_gpc('p', 'delete', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$lid' ");
	$player = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$lid' AND userid = '$userid' ");
	if (!$player || !$ladder)
	{
		print_no_permission();
	}
	if ($ladder['pot'])
	{
		$team = true;
		$isleader = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid = '$userid' AND leader = '1' AND userid = '".$vbulletin->userinfo['userid']."'");
		if (!$isleader)
		{
			print_no_permission();
		}
	}
	else
	{
		$team = false;
		if ($vbulletin->userinfo['userid'] != $userid)
		{
			print_no_permission();
		}
	}
	if ($delete)
	{
		if (file_exists($player['avatar']))
		{
			unlink($player['avatar']);
		}
		$player['avatar'] = '';
	}
	$ladder['url'] = tll_seo('ladder', $lid, $ladder['title']);
	$avatar = $vbulletin->input->clean_gpc('f', 'avatar', TYPE_FILE);
	$uploadDir = 'images/ladder_avatars/';
	$fileName = $avatar['name'];
	$tmpName  = $avatar['tmp_name'];
	if ($tmpName != '')
	{
		if ($avatar['error'])
		{
			$errormessage = 'Error: '.$avatar['error'];
			eval(standard_error($errormessage));
		}
		$randName = md5(rand() * time());
		$ext      = substr(strrchr($fileName, "."), 1);
		$imgexts  = array('jpg', 'jpeg', 'png', 'gif');
		if (!in_array(strtolower($ext), $imgexts)) {
			$errormessage = 'Invalid file extension.';
			eval(standard_error($errormessage));
		}
		@img_resize($tmpName, 100, 100, $uploadDir, $randName.".jpg");
		$filePath = $uploadDir.$randName.".jpg";
		if (!file_exists($filePath))
		{
			$filePath = $player['avatar'];
		}
	}
	else
	{
		$filePath = $player['avatar'];
	}
	query_update_ladder_player_avatar($lid, $userid, $filePath);
	if ($player['avatar'] != $filePath AND file_exists($player['avatar']))
	{
		unlink($player['avatar']);
	}
	$vbulletin->url = "ladders.php".$ladder['url'];	
	eval(print_standard_redirect('redirect_updatedavatar'));
}

// #############################################################################

if ($_POST['do'] == 'updatebadge')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
require_once(DIR . '/tll_modules/tll_editbadge.php');
	$userid = $vbulletin->input->clean_gpc('p', 'userid', TYPE_UINT);
	$lid = $vbulletin->input->clean_gpc('p', 'lid', TYPE_UINT);
	$delete = $vbulletin->input->clean_gpc('p', 'delete', TYPE_UINT);
	$badge_text = $vbulletin->input->clean_gpc('p', 'badge_text', TYPE_NOHTML);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$lid' ");
	$player = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$lid' AND userid = '$userid' ");
	if (!$player || !$ladder)
	{
		print_no_permission();
	}
	if ($ladder['pot'])
	{
		$team = true;
		$isleader = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid = '$userid' AND leader = '1' AND userid = '".$vbulletin->userinfo['userid']."'");
		if (!$isleader)
		{
			print_no_permission();
		}
	}
	else
	{
		$team = false;
		if ($vbulletin->userinfo['userid'] != $userid)
		{
			print_no_permission();
		}
	}
	if ($delete)
	{
		if (file_exists($player['badge']))
		{
			unlink($player['badge']);
		}
		$player['badge'] = '';
	}
	$ladder['url'] = tll_seo('ladder', $lid, $ladder['title']);
	$badge = $vbulletin->input->clean_gpc('f', 'badge', TYPE_FILE);
	$uploadDir = 'images/ladder_badges/';
	$fileName = $badge['name'];
	$tmpName  = $badge['tmp_name'];
	if ($tmpName != '')
	{
		if ($badge['error'])
		{
			$errormessage = 'Error: '.$badge['error'];
			eval(standard_error($errormessage));
		}
		$randName = md5(rand() * time());
		$ext = substr(strrchr($fileName, "."), 1);
		$imgexts  = array('jpg', 'jpeg', 'png', 'gif');
		if (!in_array(strtolower($ext), $imgexts)) {
			$errormessage = 'Invalid file extension.';
			eval(standard_error($errormessage));
		}
		@img_resize($tmpName, 150, 150, $uploadDir, $randName.".jpg");
		$filePath = $uploadDir.$randName.".jpg";
		if (!file_exists($filePath))
		{
			$filePath = $player['badge'];
		}
	}
	else
	{
		$filePath = $player['badge'];
	}
	query_update_ladder_player_badge($lid, $userid, $filePath);
	if ($player['badge'] != $filePath AND file_exists($player['badge']))
	{
		unlink($player['badge']);
	}
	$vbulletin->url = "ladders.php".$ladder['url'];	
	eval(print_standard_redirect('redirect_updatedbadge'));
}

// #############################################################################

if ($_REQUEST['do'] == 'editavatar')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
require_once(DIR . '/tll_modules/tll_editavatar.php');
	$userid = $vbulletin->input->clean_gpc('g', 'userid', TYPE_UINT);
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$lid' ");
	$player = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$lid' AND userid = '$userid' ");
	if (!$player || !$ladder)
	{
		print_no_permission();
	}
	if ($ladder['pot'])
	{
		$team = true;
		$isleader = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid = '$userid' AND leader = '1' AND userid = '".$vbulletin->userinfo['userid']."'");
		if (!$isleader)
		{
			print_no_permission();
		}
	}
	else
	{
		$team = false;
		if ($vbulletin->userinfo['userid'] != $userid)
		{
			print_no_permission();
		}
	}
	$ladder['url'] = tll_seo('ladder', $lid, $ladder['title']);
	$templater = vB_Template::create('tmnt_ladder_editavatar');
		$templater->register('tmntp', $tmntp);
		$templater->register('player', $player);
		$templater->register('ladder', $ladder);
		$templater->register('team', $team);
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax'])
	{
		print_r($tlhtml);
		exit;
	}
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => construct_phrase($vbphrase[ladders]),
		'ladders.php' . $ladder['url']  => construct_phrase($ladder['title'])
	);
	$navbits[''] = construct_phrase($vbphrase['ladder_editavatar']);
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'editbadge')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
require_once(DIR . '/tll_modules/tll_editbadge.php');
	$userid = $vbulletin->input->clean_gpc('g', 'userid', TYPE_UINT);
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$lid' ");
	$player = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$lid' AND userid = '$userid' ");
	if (!$player || !$ladder)
	{
		print_no_permission();
	}
	if ($ladder['pot'])
	{
		$team = true;
		$isleader = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid = '$userid' AND leader = '1' AND userid = '".$vbulletin->userinfo['userid']."'");
		if (!$isleader)
		{
			print_no_permission();
		}
	}
	else
	{
		$team = false;
		if ($vbulletin->userinfo['userid'] != $userid)
		{
			print_no_permission();
		}
	}
	$ladder['url'] = tll_seo('ladder', $lid, $ladder['title']);
	$templater = vB_Template::create('tmnt_ladder_editbadge');
		$templater->register('tmntp', $tmntp);
		$templater->register('player', $player);
		$templater->register('ladder', $ladder);
		$templater->register('team', $team);
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax'])
	{
		print_r($tlhtml);
		exit;
	}
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => construct_phrase($vbphrase[ladders]),
		'ladders.php' . $ladder['url']  => construct_phrase($ladder['title'])
	);
	$navbits[''] = construct_phrase($vbphrase['ladder_editbadge']);
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'claimcrown')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	$userid = $vbulletin->input->clean_gpc('g', 'userid', TYPE_UINT);
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$lid' ");
	if ($ladder['pot'])
	{
		$team = true;
		$userinfo = fetch_teaminfo($userid);
		$userinfo['team_members'] = array();
		$members = $vbulletin->db->query_read("
			SELECT members.*, user.*, user.username AS username, members.id AS id			
			FROM " . TABLE_PREFIX . "tmnt_members AS members
			LEFT JOIN " . TABLE_PREFIX . "user AS user
				ON(members.userid = user.userid)
			WHERE members.teamid = '$userid'
			ORDER BY members.leader DESC, members.coleader DESC, members.time ASC
		");
		while($member = $vbulletin->db->fetch_array($members))
		{
			if ($member['leader'])
			{
				$member['rank'] = 'Leader';
				if ($member['userid'] == $vbulletin->userinfo['userid'])
				{
					$isleader = true;
				}
			}
			elseif ($member['coleader'])
			{
				$member['rank'] = 'Co-Leader';
			}
			else
			{
				$member['rank'] = 'Member';
			}
			if ($prevmember && $prevmember['rank'] != $member['rank'])
			{
				$member['style'] = 'clear: left;';
			}
			$userinfo['team_members'][] = $member;
			$prevmember = $member;
		}
	}
	else
	{
		$team = false;
		$userinfo = fetch_userinfo($userid);
		if ($userid==$vbulletin->userinfo['userid'])
		{
			$isleader = true;
		}
	}
	$player = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE userid='$userid' AND lid='$lid' ");
	if (!$player OR !$isleader)
	{
		print_no_permission();
	}
	$crown_query = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE crown > 0 AND lid='$lid' AND active = 1 ");
	if ($crown_query['countrows'] == 0)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET crown = 1 WHERE lid = '$lid' AND userid = '$userid' ");
	}
	$vbulletin->url = "ladders.php?do=view&id=$lid";
	eval(print_standard_redirect('redirect_claimedcrown'));
}


// #############################################################################

if ($_REQUEST['do'] == 'player_popup')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	$userid = $vbulletin->input->clean_gpc('g', 'userid', TYPE_UINT);
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$lid' ");
	if ($ladder['pot'])
	{
		$team = true;
		$userinfo = fetch_teaminfo($userid);
		$userinfo['team_members'] = array();
		$members = $vbulletin->db->query_read("
			SELECT members.*, user.*, user.username AS username, members.id AS id			
			FROM " . TABLE_PREFIX . "tmnt_members AS members
			LEFT JOIN " . TABLE_PREFIX . "user AS user
				ON(members.userid = user.userid)
			WHERE members.teamid = '$userid' AND members.accepted = 1
			ORDER BY members.leader DESC, members.coleader DESC, members.time ASC
		");
		while($member = $vbulletin->db->fetch_array($members))
		{
			if ($member['leader'])
			{
				$member['rank'] = 'Leader';
				if ($member['userid'] == $vbulletin->userinfo['userid'])
				{
					$isleader = true;
				}
			}
			elseif ($member['coleader'])
			{
				$member['rank'] = 'Co-Leader';
			}
			else
			{
				$member['rank'] = 'Member';
			}
			if ($prevmember && $prevmember['rank'] != $member['rank'])
			{
				$member['style'] = 'clear: left;';
			}
			$userinfo['team_members'][] = $member;
			$prevmember = $member;
		}
	}
	else
	{
		$team = false;
		$userinfo = fetch_userinfo($userid);
		if ($userid==$vbulletin->userinfo['userid'])
		{
			$isleader = true;
		}
	}
	$player = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE userid='$userid' AND lid='$lid' ");
	if ($team)
	{
		$player['teamurl'] = tll_seo('team', $userinfo['teamid'], $userinfo['teamname']);
	}
	if (!$player['crown'] && $isleader)
	{
		$crown_query = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE crown > 0 AND lid='$lid' AND active = 1 ");
		if ($crown_query['countrows'] == 0)
		{
			$player['claim_crown'] = true;
		}
	}
	$player['streak'] = $player['wstreak'] - $player['lstreak'];
	$player['totalmatches'] = $player['wins']+$player['draws']+$player['loses'];
	if ($player['wins']==0)
	{
		$player['winpercentage'] = 0;
	}
	else
	{
		$player['winpercentage'] = round(($player['wins']/$player['totalmatches'])*100);
	}
	$comper = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE userid='$thisuserid' AND lid='$lid' AND active = 1 ");
	if (($comper OR $team) && $tmntp['canjoinladder'])
	{
		$comper = 1;
	}
	$countp = $vbulletin->db->query_first("SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p WHERE rank > '".$player['rank']."' AND active = 1 AND lid = '".$lid."' AND p.group = '".$player['group']."' ");
	$player['position'] = $countp['count'] + 1;
	$player['position'] = process_position($player['position']);
	$matches = $vbulletin->db->query_read("
		SELECT games.*, IF(games.pot = 1, teama.teamname, usera.username) AS username_u, IF(games.pot = 1, teamb.teamname, userb.username) AS username_u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "user AS usera
			ON (games.u = usera.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS userb
			ON (games.u2 = userb.userid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teama
			ON (games.u = teama.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teamb
			ON (games.u2 = teamb.teamid)
		WHERE games.lid = '$lid'
			AND (games.u = '$userid' OR games.u2 = '$userid')
			AND games.accepted = 1
			AND games.finished = 1
		ORDER BY games.dateline DESC, games.dateline_finished DESC
		LIMIT 0, 5
	");
	$u_m = $r_m = array();
	while($match = $vbulletin->db->fetch_array($matches))
	{//recent matches
			if ($match['u']==$userid)
			{
				$match['opponent'] = $match['username_u2'];
				$match['opp_userid'] = $match['u2'];
				if ($match['score_u2']>$match['score_u'])
				{
					$match['text'] = 'Lost';
				}
				elseif ($match['score_u2']==$match['score_u'])
				{
					$match['text'] = 'Drew';
				}
				else
				{
					$match['text'] = 'Won';
				}
				$match['scoretext'] = $match['score_u'].'-'.$match['score_u2'];
			}
			else
			{
				$match['opponent'] = $match['username_u'];
				$match['opp_userid'] = $match['u'];
				if ($match['score_u']>$match['score_u2'])
				{
					$match['text'] = 'Lost';
				}
				elseif ($match['score_u2']==$match['score_u'])
				{
					$match['text'] = 'Drew';
				}
				else
				{
					$match['text'] = 'Won';
				}
				$match['scoretext'] = $match['score_u2'].'-'.$match['score_u'];
			}
		$r_m[] = $match;
	}
	$matches = $vbulletin->db->query_read("
		SELECT games.*, IF(games.pot = 1, teama.teamname, usera.username) AS username_u, IF(games.pot = 1, teamb.teamname, userb.username) AS username_u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "user AS usera
			ON (games.u = usera.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS userb
			ON (games.u2 = userb.userid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teama
			ON (games.u = teama.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS teamb
			ON (games.u2 = teamb.teamid)
		WHERE games.lid = '$lid'
			AND (games.u = '$userid' OR games.u2 = '$userid')
			AND games.accepted = 1
			AND games.finished = 0
		ORDER BY games.dateline ASC
		LIMIT 0, 5
	");
	while($match = $vbulletin->db->fetch_array($matches))
	{//upcoming matches
		if ($match['u']==$userid)
		{
			$match['opponent'] = $match['username_u2'];
			$match['opp_userid'] = $match['u2'];
		}
		else
		{
			$match['opponent'] = $match['username_u'];
			$match['opp_userid'] = $match['u'];
		}
		$u_m[] = $match;
	}
	if ((($player['userid'] != $vbulletin->userinfo['userid']) OR $team) && !$ladder['archive'] && !$ladder['league'] && $comper)
	{
		$player['canchal'] = true;
	}
	if (!$team)
	{
		$chal = $vbulletin->db->query_first("
			SELECT g.* 
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
			WHERE 
				((g.u = '$userid' AND g.u2 = '$thisuserid')
				OR (g.u2 = '$userid' AND g.u = '$thisuserid')) 
				AND g.finished = 0
				AND g.lid='$lid'
		");
	}
	if ($chal)
	{
		if ($chal['accepted']==0)
		{
			$chal['status'] = 'Awaiting match to be accepted.';
		}
		else
		{
			if (!$chal['agree_u'] && $chal['agree_u2'] && $chal['u2']==$thisuserid)
			{
				$chal['status'] = 'Awaiting opponent\'s score.';
			}
			if (!$chal['agree_u2'] && $chal['agree_u'] && $chal['u']==$thisuserid)
			{
				$chal['status'] = 'Awaiting opponent\'s score.';
			}
			if (!$chal['agree_u2'] && $chal['u2']==$thisuserid)
			{
				$chal['status'] = 'Awaiting your score. <a class="button" style="float:right;" href="ladders.php?do=submitscore&amp;id='.$chal['id'].'&amp;from=ladder" class="tllpopup" onclick="tll_popup(this.href); return false;">Submit score</a>';
			}
			if (!$chal['agree_u'] && $chal['u']==$thisuserid)
			{
				$chal['status'] = 'Awaiting your score. <a class="button" style="float:right;" href="ladders.php?do=submitscore&amp;id='.$chal['id'].'&amp;from=ladder" class="tllpopup" onclick="tll_popup(this.href); return false;">Submit score</a>';
			}
			if (!$chal['agree_u'] && !$chal['agree_u2'])
			{
				$chal['status'] = 'Awaiting match scores. <a class="button" style="float:right;" href="ladders.php?do=submitscore&amp;id='.$chal['id'].'&amp;from=ladder" class="tllpopup" onclick="tll_popup(this.href); return false;">Submit score</a>';
			}
		}
	}
	/****/
	$countlimit = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$userid AND u2=$thisuserid) OR (u=$thisuserid AND u2=$userid)) AND finished = 0 ");
	if ($countlimit['countrows']>=$vbulletin->options['tmnt_ladder_maxc'])
	{
		$player['canchal'] = false;
	}
	$time_limit = TIMENOW - ($vbulletin->options['tmnt_ladder_limitrematch'] * 60 * 60);
	$countlimit = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$userid AND u2=$thisuserid) OR (u=$thisuserid AND u2=$userid)) AND dateline_finished > '" . $time_limit . "' ");
	if ($countlimit['countrows'])
	{
		$days = floor($vbulletin->options['tmnt_ladder_limitrematch']/24);
		$hours = $vbulletin->options['tmnt_ladder_limitrematch'] - $days * 24;
		$player['canchal'] = false;
	}
	/****/
	if ($isleader && file_exists(DIR . '/tll_modules/tll_editavatar.php'))
	{
		$tmntp['caneditavatar'] = true;
	}
	if ($isleader && file_exists(DIR . '/tll_modules/tll_editbadge.php'))
	{
		$tmntp['caneditbadge'] = true;
	}
	$count1 = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid = '$lid' AND u2 = '$userid' AND accepted = '1' ");
	$count2 = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid = '$lid' AND u2 = '$userid' AND accepted = '-1' ");
	$player['acceptance_percentage'] = number_format(($count1['countrows'] / ($count1['countrows'] + $count2['countrows'])) * 100);
	$avg = $vbulletin->db->query_first("SELECT AVG(accepted_dateline-time) AS avg FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid = '$lid' AND u2 = '$userid' AND accepted_dateline > 0 ");
	switch ($avg['avg'])
	{
		case ($avg['avg'] < 3600):
			$player['average_acceptance_time'] = number_format($avg['avg']/60) . " mins";
			break;
		case ($avg['avg'] < 86400):
			$player['average_acceptance_time'] = number_format($avg['avg']/3600) . " hours";
			break;
		case ($avg['avg'] > 86400):
			$player['average_acceptance_time'] = number_format($avg['avg']/86400) . " days";
			break;
	}
	//$player['average_acceptance_time'] = number_format($player['average_acceptance_time']);
	//print_r($player);
	$templater = vB_Template::create('tmnt_ladder_player_popup');
		$templater->register('tmntp', $tmntp);
		$templater->register('team', $team);
		$templater->register('ladder', $ladder);
		$templater->register('isleader', $isleader);
		$templater->register('player', $player);
		$templater->register('userinfo', $userinfo);
		$templater->register('cmpt', $player);
		$templater->register('comper', $comper);
		$templater->register('r_m', $r_m);
		$templater->register('u_m', $u_m);
		$templater->register('chal', $chal);
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax'])
	{
		print_r($tlhtml);
		exit;
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id=' . $lid => $ladder['title'],
		'' => $player['username']
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'join')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$lid = $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$userid = $thisuserid;
	$username = $thisusername;
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id' ");
	if (!$id OR !$ladder)
	{
		$errormessage = $vbphrase['error_invalid_ladder'];
		eval(standard_error($errormessage));
	}
	if ($ladder['league'] > 1)
	{
		$errormessage = "Sorry this league has already started, you will next to wait until next season to compete in this league.";
		if ($_REQUEST['ajax']==1)
		{
			$tlhtml = tll_popup_standard_error($errormessage);
			print_r($tlhtml);
			exit;
		}
		eval(standard_error($errormessage));
	}
	if ($ladder['pot'] == 0)
	{
		$team = false;
	}
	else
	{
		$team = true;
	}
	if ($ladder['archive'] == 1)
	{
		$errormessage = $vbphrase['error_ladder_closed'];
		if ($_REQUEST['ajax']==1)
		{
			$tlhtml = tll_popup_standard_error($errormessage);
			print_r($tlhtml);
			exit;
		}
		eval(standard_error($errormessage));
	}
	$tmax = $ladder['tmax'];
	$tmin = $ladder['tmin'];
	if ($ladder['maxplayers']>0)
	{
		$count = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid='$id' AND active = 1 ");
		if ($count['countrows'] >= $ladder['maxplayers'])
		{
			$errormessage = 'Sorry, max competitors for this ladder/league is '.$ladder['maxplayers'].'.';
			if ($_REQUEST['ajax']==1)
			{
				$tlhtml = tll_popup_standard_error($errormessage);
				print_r($tlhtml);
				exit;
			}
			eval(standard_error($errormessage));
		}
	}
	if (!$team)
	{
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid='$id' AND (userid='$userid' OR username='".$vbulletin->db->escape_string($username)."')");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer != 0) {
			$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$id AND (userid=$userid OR username='".$vbulletin->db->escape_string($username)."') AND active=0");
			$countplayer = $countplayer['countrows'];  
			if ($countplayer == 1)
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET active=1, latime = ".TIMENOW." WHERE lid=$id AND (userid=$userid OR username='".$vbulletin->db->escape_string($username)."') AND active=0");
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET noplayers = noplayers + 1 WHERE id=$id");
				$tmnt_ladders = array_merge((array)$vbulletin->userinfo['tmnt_ladders'], (array)$id);
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_ladders = '" . implode(',' , $tmnt_ladders) . "' WHERE userid=$userid");
				$crown_query = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE crown > 0 AND lid='$lid' AND active = 1 ");
				if ($crown_query['countrows'] == 0)
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET crown = 1 WHERE lid = '$lid' AND userid = '$userid' ");
				}
				if ($_REQUEST['ajax'])
				{
					print_r('Reload');
					exit;
				}
				$vbulletin->url = "ladders.php?do=view&id=$id";
				eval(print_standard_redirect('redirect_rejoinedladder'));
			}
			$errormessage = $vbphrase['error_already_joined_ladder'];
			eval(standard_error($errormessage));
		}
	}
	if ($team)
	{
		$userteams .= '<select name="teamid" id="teamid">';
		$teams = $vbulletin->db->query_read("
			SELECT m.*, t.*
			FROM " . TABLE_PREFIX . "tmnt_members AS m
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
				ON (m.teamid = t.teamid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladder_players AS p
				ON (p.userid = t.teamid AND p.lid = $id AND active = 1)
			WHERE m.leader = 1
				AND m.userid = $userid
				AND t.noplayers <= $tmax
				AND t.noplayers >= $tmin
				AND p.id IS NULL
		");
		while($teamm = $vbulletin->db->fetch_array($teams))
		{
			$userteams .= "<option value=\"".$teamm['teamid']."\">".$teamm['teamname']."</option>";
			$countuserteams++ ;
		}
		$userteams .= '</select>';
		if ($countuserteams == 0)
		{
			$errormessage = construct_phrase($vbphrase['error_not_leader_ladder'], $id);
			if ($_REQUEST['ajax']==1)
			{
				$tlhtml = tll_popup_standard_error($errormessage);
				print_r($tlhtml);
				exit;
			}
			eval(standard_error($errormessage));
		} 
	}
	$templater = vB_Template::create('tmnt_ladder_join');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('team', $team);
		$templater->register('userteams', $userteams);
		$templater->register('ladder', $ladder);
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax']==1)
	{
		$tlhtml = str_replace("history.go(-1);return false;","close_tll_popup()", $tlhtml);
		print_r($tlhtml);
		exit;
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id=' . $id => $ladder['title'],
		'' => construct_phrase($vbphrase['ladder_joining'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'restartleague' && $_REQUEST['confirm'])
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$lid = $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id' AND league > 1 ");
	if (!$ladder)
	{
		$errormessage = $vbphrase['error_invalid_league'];
		eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$id");
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladders
		SET
			league = 1
		WHERE id = '$lid' AND league > 1
	");
	$vbulletin->url = "ladders.php?do=view&id=$id";
	eval(print_standard_redirect('redirect_restartleague'));
}

// #############################################################################

if ($_REQUEST['do'] == 'leaveladder')
{
	$lid = $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id' ");
	if (!$ladder)
	{
		$errormessage = $vbphrase['error_invalid_ladder'];
		eval(standard_error($errormessage));
	}
	if ($ladder['archive'])
	{
		$errormessage = $vbphrase['error_ladder_closed'];
		eval(standard_error($errormessage));
	}
	$u = $vbulletin->input->clean_gpc('g', 'u', TYPE_UINT);
	if (!$ladder['pot'])
	{
		$team = false;
		if ($u == $thisuserid OR !$u)
		{
			$userid = $thisuserid;
			$username = $thisusername;
		}
		elseif ($tmntp['caneditladder'])
		{
			$userid = $u;
			$userinfo = fetch_userinfo($u);
			$username = $userinfo['username'];
		} 
		else 
		{
			print_no_permission();
		}
	}
	else 
	{
		$team = true;
		if (!$u)
		{
			$teams_query = $vbulletin->db->query_read("
				SELECT t.teamname, t.teamid
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
				LEFT JOIN " . TABLE_PREFIX . "tmnt_members AS m
					ON (p.userid = m.teamid AND leader = 1 AND m.userid = $thisuserid)
				LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
					ON (p.userid = t.teamid)
				WHERE m.id > 0
					AND p.lid = '$lid'
					AND p.active = 1
			");
			while($teamm = $vbulletin->db->fetch_array($teams_query))
			{
				$userteams .= "<option value=\"".$teamm['teamid']."\">".$teamm['teamname']."</option>";
			}
			if (!$userteams)
			{
				print_no_permission();
			}
			$templater = vB_Template::create('tmnt_ladder_teamleave');
				$templater->register('tmntp', $tmntp);
				$templater->register('userteams', $userteams);
				$templater->register('ladder', $ladder);
			$tlhtml .= $templater->render();
			$navbits = construct_navbits(array(
				'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
				'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
				'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id=' . $id => $ladder['title'],
				'' => construct_phrase('Leave Ladder')
			));
			$navbar = render_navbar_template($navbits);
			$templater = vB_Template::create('tmnt_shell');
			$templater->register_page_templates();
			$templater->register('navbar', $navbar);
			$templater->register('headinclude', $headinclude);
			$templater->register('pagetitle', $pagetitle);
			$templater->register('tlhtml', $tlhtml);
			$templater->register('modname', $modname);
			$templater->register('header', $header);
			$templater->register('footer', $footer);
			$templater->register('tmntp', $tmntp);
			$templater->register('tmnt_version', $tmnt_version);
			print_output($templater->render());
		}
		if (!$teaminfo = fetch_teaminfo($u))
		{
			$errormessage = $vbphrase['error_invalid_team'];
			eval(standard_error($errormessage));
		}
		$isleader = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE teamid = '$u' AND leader = '1' AND userid = '$thisuserid'");
		if (!$isleader && !$tmntp['caneditladder'])
		{
			print_no_permission();
		}
		$username = $teaminfo['teamname'];
		$userid = $teaminfo['teamid'];
	}
	$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$id' AND userid = '$userid' AND active = 1 ");
	$countplayer = $countplayer['countrows'];  
	if ($countplayer == 1)
	{
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET active = 0, crown = 0
				WHERE lid = '$id'
					AND userid = '$userid'
					AND active = '1'
		");
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tmnt_ladders
			SET noplayers = noplayers - 1
			WHERE id = '$id'
		");
		if (!$team)
		{
			$userinfo = fetch_userinfo($u);
			$tmnt_ladders = array_delete(explode(',',$userinfo['tmnt_ladders']), $id);
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "user
				SET tmnt_ladders = '" . implode(',', $tmnt_ladders) . "'
				WHERE userid = '$userid'
			");
		}
	}
	$vbulletin->url = "ladders.php?do=view&id=$id";
	eval(print_standard_redirect('redirect_leaveladder'));
}

// #############################################################################

if ($_POST['do'] == 'insertjoin')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$lid = $id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$id' ");
	if (!$ladder)
	{
		$errormessage = $vbphrase['error_invalid_ladder'];
		eval(standard_error($errormessage));
	}
	if ($ladder['archive'])
	{
		$errormessage = $vbphrase['error_ladder_closed'];
		eval(standard_error($errormessage));
	}
	$team = false;
	if ($ladder['pot'])
	{
		$team = true;
	}
	if (!$team)
	{
		$userid = $vbulletin->input->clean_gpc('p', 'userid', TYPE_UINT);
		if (!$userid) {
			$userid = $thisuserid;
		}
		$username = $vbulletin->input->clean_gpc('p', 'username', TYPE_STR);
		if (!$username)
		{
			$username = $thisusername;
		}
		$userinfo = fetch_userinfo($userid);
		$tmnt_ladders = array_merge((array)$userinfo['tmnt_ladders'], (array)$id);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_ladders = '" . implode(',' , $tmnt_ladders) . "' WHERE userid=$userid");
	}
	if ($team)
	{
		$userid = $vbulletin->input->clean_gpc('p', 'teamid', TYPE_UINT);
			if (!$userid)
			{
				$errormessage = $vbphrase['error_invalid_team'];
				eval(standard_error($errormessage));
			}
		$team = fetch_teaminfo($userid);
		$username = $team['teamname'];
		if (!$username)
		{
			$errormessage = $vbphrase['error_invalid_team'];
			eval(standard_error($errormessage));
		}
	}
	$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$id' AND (userid = '$userid' OR username = '".$vbulletin->db->escape_string($username)."') ");
	$countplayer = $countplayer['countrows'];  
	if ($countplayer != 0)
	{
		if ($countplayer == 1)
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET active=1, latime=".TIMENOW." WHERE lid=$id AND (userid=$userid OR username='".$vbulletin->db->escape_string($username)."') AND active=0");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET noplayers = noplayers + 1 WHERE id=$id");
			$vbulletin->url = "ladders.php?do=view&id=$id";
			eval(print_standard_redirect('redirect_rejoinedladder'));
		}
		$errormessage = $vbphrase['error_already_joined_ladder'];
		eval(standard_error($errormessage));
	}
	$crown_query = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE crown > 0 AND lid='$lid' AND active = 1 ");
	if ($crown_query['countrows'] == 0)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET crown = 1 WHERE lid = '$lid' AND userid = '$userid' ");
	}
	if ($ladder['join_cost'] > 0 && $vbulletin->options['tmnt_credit_system'])
	{
require_once(DIR . '/includes/functions_tll_premium.php');	
		if (!$team && $vbulletin->userinfo['tmnt_credits'] < $ladder['join_cost'])
		{
			$errormessage = 'Error, insufficient credits. Joining this ladder costs '.$ladder['join_cost'].' credits, you only have '.$vbulletin->userinfo['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
		elseif ($team && $team['tmnt_credits'] < $ladder['join_cost'])
		{
			$errormessage = 'Error, insufficient credits. Joining this ladder costs '.$ladder['join_cost'].' credits, your team only has '.$team['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}	
		if ($team)
		{
			process_credits_transaction($userid, -$ladder['join_cost'], 'Joined ladder', 0, 0, $team['teamid'], 1);
		}
		else
		{
			process_credits_transaction($userid, -$ladder['join_cost'], 'Joined ladder', $userid, 0);
		}
		update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), $ladder['join_cost'], TIMENOW);
	}
	if ($team && $ladder['comp_ugid'])
	{
		$members = $vbulletin->db->query_read("
			SELECT m.*, u.username
			FROM " . TABLE_PREFIX . "tmnt_members AS m
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (u.userid = m.userid)
			WHERE m.teamid = '$userid'
				AND m.accepted = 1
		");
		while($m = $vbulletin->db->fetch_array($members))
		{
			$userinfo = fetch_userinfo($m['userid']);
			$user = $userinfo;
			$newmembergroupid = $ladder['comp_ugid'];
			$user['membergroupids']=explode(',',$user['membergroupids']);
			if (!in_array($newmembergroupid, $user['membergroupids']))
			{
				$user['membergroupids'][]=$newmembergroupid;
			}
			else
			{
				continue;
			}
			//$display_usergroup = $newmembergroupid;
			$user['membergroupids']=implode(',',$user['membergroupids']);
			$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_STANDARD);
			$userdata->set_existing($userinfo);
			$userdata->set('membergroupids', $user['membergroupids']);
			/*$userdata->set_usertitle(
					$userinfo['usertitle'],
					true,
					$vbulletin->usergroupcache["$newmembergroupid"],
					false,
					true
			);*/
			$userdata->save();
		}
	}
	elseif ($ladder['comp_ugid'])
	{
		$user = $userinfo = $vbulletin->userinfo;
		$newmembergroupid = $ladder['comp_ugid'];
		$user['membergroupids']=explode(',',$user['membergroupids']);
		$user['membergroupids'][]=$newmembergroupid;
		//$display_usergroup = $newmembergroupid;
		$user['membergroupids']=implode(',',$user['membergroupids']);
		$userdata =& datamanager_init('User', $vbulletin, ERRTYPE_STANDARD);
		$userdata->set_existing($userinfo);
		$userdata->set('membergroupids', $user['membergroupids']);
		/*$userdata->set_usertitle(
				$userinfo['usertitle'],
				true,
				$vbulletin->usergroupcache["$newmembergroupid"],
				false,
				true
		);*/
		$userdata->save();
	}
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_players
		(userid, username, lid, time, ip, pot, rank)
		VALUES (
			'".$userid."',
			'".$vbulletin->db->escape_string($username)."',
			'".$ladder['id']."',
			".TIMENOW.",
			'".$vbulletin->db->escape_string($thisip)."',
			'".$ladder['pot']."',
			'".$ladder['startingelo']."'
		)
	");
	$vbulletin->url = "ladders.php?do=view&id=$id";
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET noplayers = noplayers + 1 WHERE id=$id");
	eval(print_standard_redirect('redirect_insertjoinladder'));
}

// #############################################################################

if ($_REQUEST['do'] == 'teamchal')
{
	$_REQUEST['do'] = 'insertchal';
}

// #############################################################################

if ($_REQUEST['do'] == 'insertchal')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	if (!$lid)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}	
	$u2 = $vbulletin->input->clean_gpc('g', 'u2', TYPE_INT);
		if (!$u2 || $u2 < -1)
		{
			$errormessage = $vbphrase['error_invalid_challenger'];
			eval(standard_error($errormessage));
		}
	$u = $thisuserid;
	$userid = $thisuserid;
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = $lid ");
	//print_r($ladder);
	if ($ladder['archive'])
	{
		$errormessage = $vbphrase['error_ladder_closed'];
		eval(standard_error($errormessage));
	}
	if (!$ladder['allow_challenges'])
	{
		$errormessage = 'Challenges disabled';
		eval(standard_error($errormessage));
	}
	if ($ladder['league'])
	{
		$errormessage = 'Error, this is a league';
		eval(standard_error($errormessage));
	}
	if ($ladder['status'] > 0)
	{
		print_no_permission();
	}	
	$co_array2 = unserialize($ladder['chal_options']);
	if (is_array($co_array2))
	{
		$co_array = array();
		foreach($co_array2 AS $key => $value)
		{
			$key2 = str_replace(' ','_',$key);
			$key2 = preg_replace("/[^a-zA-Z0-9_\s]/", "", unhtmlspecialchars($key2));
			if ($value)
			{
				$co_array["$key2"] = 
				array(
					'value' => explode("\r\n",$value),
					'key' => $key
				);
			}
			else
			{
				$co_array["$key2"] = 
				array(
					'value' => $value,
					'key' => $key
				);
			}
		}
	}
	$time_limit = TIMENOW - ($vbulletin->options['tmnt_ladder_limitrematch'] * 60 * 60);
	$countlimit = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND finished = 0 ");
	if ($countlimit['countrows']>=$vbulletin->options['tmnt_ladder_maxc'])
	{
		$errormessage = "You are only allowed ".$vbulletin->options['tmnt_ladder_maxc']." open challenge(s) with a player at once.";
		if ($_REQUEST['ajax']==1)
		{
			$tlhtml = tll_popup_standard_error($errormessage);
			print_r($tlhtml);
			exit;
		}
		eval(standard_error($errormessage));
	}
	$countlimit = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND dateline_finished > '" . $time_limit . "' ");
	if ($countlimit['countrows'])
	{
		$days = floor($vbulletin->options['tmnt_ladder_limitrematch']/24);
		$hours = $vbulletin->options['tmnt_ladder_limitrematch'] - $days * 24;
		$errormessage = "Please wait " . ($days ? "$days days " : "") . ($hours ? "$hours hours " : "") . "between challenging the same player/team.";
		if ($_REQUEST['ajax']==1)
		{
			$tlhtml = tll_popup_standard_error($errormessage);
			print_r($tlhtml);
			exit;
		}
		eval(standard_error($errormessage));
	}
	if (!$ladder['pot'])
	{
		if ($u == $u2)
		{
			$errormessage = $vbphrase['error_invalid_challenger'];
			eval(standard_error($errormessage));
		}
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND finished=0 ");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer >= $vbulletin->options['tmnt_ladder_maxc'])
		{
			$errormessage = $vbphrase['error_already_challenged'];
			eval(standard_error($errormessage));
		}
		if ($u2 != -1)
		{
			$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u2 AND active=1");
			$countplayer = $countplayer['countrows'];  
			if ($countplayer != 1)
			{
				$errormessage = $vbphrase['error_player_not_ladder'];
				eval(standard_error($errormessage));
			}
		}
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u AND active=1");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer != 1)
		{
			$errormessage = construct_phrase($vbphrase['error_not_in_ladder'],$lid);
			eval(standard_error($errormessage));
		}
		$username_u = $thisusername;
		$username_u2 = fetch_userinfo($u2);
		$username_u2 = $username_u2['username'];
		/*insufficient credit check*/
		if ($vbulletin->options['tmnt_credit_system'])
		{
			if ($ladder['chal_cost'])
			{
				$ladder['win_credits'] = (1-$vbulletin->options['tmnt_credits_comm'])*2*$ladder['chal_cost'];
			}
			if ($vbulletin->userinfo['tmnt_credits']<$ladder['chal_cost'])
			{
				$errormessage = 'Error, you have insufficient credits. Challenges for this ladder cost '.$ladder['chal_cost'].' credits, you only have '.$vbulletin->userinfo['tmnt_credits'].' credits.<br /><br /><a href="tll_credits.php?do=credits">Click here to buy some more credits.</a>';
				if ($_REQUEST['ajax']==1)
				{
					$tlhtml = tll_popup_standard_error($errormessage);
					print_r($tlhtml);
					exit;
				}
				eval(standard_error($errormessage));
			}
		}
		// end single bit
	}
	else
	{
		// start team bit
		if ($u2 != -1)
		{
			$countteam = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u2 AND pot=1");
			$countteam = $countteam['countrows'];  
			if ($countteam != 1)
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET pot = 1 WHERE lid=$lid");
				$errormessage = $vbphrase['error_team_not_ladder'];
				eval(standard_error($errormessage));
			}
		}
		$userteams .= '<select name="u" id="u">';
		$teams = $vbulletin->db->query_read("SELECT *
			FROM " . TABLE_PREFIX . "tmnt_members
			RIGHT JOIN " . TABLE_PREFIX . "tmnt_teams
			on " . TABLE_PREFIX . "tmnt_members.teamid = " . TABLE_PREFIX . "tmnt_teams.teamid
			RIGHT JOIN " . TABLE_PREFIX . "tmnt_ladder_players
			on " . TABLE_PREFIX . "tmnt_members.teamid = " . TABLE_PREFIX . "tmnt_ladder_players.userid
			WHERE " . TABLE_PREFIX . "tmnt_members.leader=1
			AND " . TABLE_PREFIX . "tmnt_members.userid=$userid
			AND " . TABLE_PREFIX . "tmnt_ladder_players.lid=$lid
			AND " . TABLE_PREFIX . "tmnt_ladder_players.userid!=$u2");
		while($teamm = $vbulletin->db->fetch_array($teams))
		{
			$userteams .= "<option value=\"".$teamm['teamid']."\">".$teamm['teamname']."</option>";
			$countuserteams++ ;
		}
		$userteams .= '</select>';
		if ($countuserteams == 0)
		{
			$errormessage = $vbphrase['error_not_teamleader'];
			eval(standard_error($errormessage));
		}
		$challenged = fetch_teaminfo($u2);
		if ($vbulletin->options['tmnt_credit_system'] && $ladder['chal_cost'])
		{
			$ladder['win_credits'] = (1-$vbulletin->options['tmnt_credits_comm'])*2*$ladder['chal_cost'];
		}
		// end  team bit
	}
	
		
		
		$ladder['protected'] = array(
			'win_defending' => $ladder['protected_win_defending'], 
			'lose_defending' => $ladder['protected_lose_defending'], 
			'win_challenge' => $ladder['protected_win_challenge'], 
			'lose_challenge' => $ladder['protected_lose_challenge'], 
		);
		$r = $vbulletin->db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladder_games
			WHERE lid = '$lid'
				AND u = '$u2'
				AND dateline_finished > '".(TIMENOW-$ladder['protected']['win_challenge'])."'
				AND score_u > score_u2
		");
		if ($r)
		{//If you win a challenging match you are protected for 12h (no one will be able to challenge you).
			$errormessage = construct_phrase($vbphrase['tmnt_protected_win_challenging'], $username_u2, ($ladder['protected']['win_challenge']/3600), vbdate($vbulletin->options['dateformat']." ".$vbulletin->options['timeformat'], $r['dateline_finished']+$ladder['protected']['win_challenge']));
		}
		$s = $vbulletin->db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladder_games
			WHERE lid = '$lid'
				AND u2 = '$u2'
				AND dateline_finished > '".(TIMENOW-$ladder['protected']['win_defending'])."'
				AND score_u < score_u2
		");
		if ($s)
		{//If you win a defending match you are protected for 2 days (no one will be able to challenge you).
			$errormessage = $username_u2 . " has won their last challenging match and is protected for " . ($ladder['protected']['win_defending'] / 3600) . " hours, until " . vbdate($vbulletin->options['dateformat']." ".$vbulletin->options['timeformat'], $s['dateline_finished']+$ladder['protected']['win_defending']).".";
		}
		$t = $vbulletin->db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladder_games
			WHERE lid = '$lid'
				AND u2 = '$u'
				AND dateline_finished > '".(TIMENOW-$ladder['protected']['lose_defending'])."'
				AND score_u > score_u2
		");
		if ($t)
		{//If you lose a defending match you are vulnerable for 12h (you will be unable to challenge).
			$errormessage = "You have lost a defending match and are vulnerable for ". ($ladder['protected']['lose_defending'] / 3600)." hours (you will be unable to challenge), until " . vbdate($vbulletin->options['dateformat']." ".$vbulletin->options['timeformat'], $t['dateline_finished']+$ladder['protected']['lose_defending']).".";
		}
		$v = $vbulletin->db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladder_games
			WHERE lid = '$lid'
				AND u = '$u'
				AND dateline_finished > '".(TIMENOW-$ladder['protected']['lose_challenge'])."'
				AND score_u < score_u2
		");
		if ($v)
		{//If you lose a challenging match you are vulnerable for 2 days (you will be unable to challenge).
			$errormessage = "You have lost a challenging match and are vulnerable for ".($ladder['protected']['lose_challenge'] / 3600)." hours (you will be unable to challenge), until " . vbdate($vbulletin->options['dateformat']." ".$vbulletin->options['timeformat'], $v['dateline_finished']+$ladder['protected']['lose_challenge']).".";
		}
		/*
		You cannot play the same team twice in a row.
		Time given to accept a match: 2 days
		*/
		if ($errormessage)
		{
			if ($_REQUEST['ajax']==1)
			{
				$tlhtml = tll_popup_standard_error($errormessage);
				print_r($tlhtml);
				exit;
			}
			eval(standard_error($errormessage));
		}
		
	$day = vbdate("j", TIMENOW);
	if ($day == 'j')
	{
		$day = date("j", TIMENOW);
	}
	$month = vbdate("n", TIMENOW);
	if ($month == 'n')
	{
		$month = date("n", TIMENOW);
	}
	$year = vbdate("Y", TIMENOW);
	if ($year == 'Y')
	{
		$year = date("Y", TIMENOW);
	}
	$monthselected = array();
	$yearselected = array();
	$monthselected["$month"] = 'selected="selected"';
	$yearselected["$year"] = 'selected="selected"';
	$yearbits = '';
	for ($gyear = 2005; $gyear <= 2015; $gyear++)
	{
		$yearbits .= "\t\t<option value=\"$gyear\" $yearselected[$gyear]>$gyear</option>";
	}
	if (strpos($vbulletin->options['timeformat'], 'H') !== false)
	{
		$show['24hour'] = true;
	}
	else
	{
		$show['24hour'] = false;
	}
	$time = vbdate($vbulletin->options['timeformat'], TIMENOW);
	require_once(DIR . '/includes/functions_misc.php');
	$timezoneoptions = '';
	foreach (fetch_timezone() AS $optionvalue => $timezonephrase)
	{
		$optiontitle = $vbphrase["$timezonephrase"];
		$optionselected = ($optionvalue == $vbulletin->userinfo['timezoneoffset'] + $vbulletin->userinfo['dstonoff'] ? 'selected="selected"' : '');
		$timezoneoptions .= render_option_template($optiontitle, $optionvalue, $optionselected, $optionclass);
	}
	//dominic2
	$templater = vB_Template::create('tmnt_ladder_chal');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('challenged', $challenged);
		$templater->register('userteams', $userteams);
		$templater->register('username_u2', $username_u2);
		$templater->register('username_u', $username_u);
		$templater->register('u2', $u2);
		$templater->register('co_array', $co_array);
		$templater->register('time', $time);
		$templater->register('day', $day);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('monthselected', $monthselected);
		$templater->register('yearbits', $yearbits);
		$templater->register('dstchecked', $dstchecked);
		if ($_REQUEST['ajax'])
		{
			$templater->register('ajax', '1');
		}
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax'])
	{
		$tlhtml = str_replace('history.go(-1);return false;','close_tll_popup();', $tlhtml);
		print_r($tlhtml);
		exit;
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id=' . $lid => $ladder['title'],
		'' => construct_phrase($vbphrase['ladder_chal'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'insertmatch')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
		if (!$lid) {
			$errormessage = $vbphrase[error_invalid_ladder];
			eval(standard_error($errormessage));
		}
	$pot = $vbulletin->input->clean_gpc('p', 'pot', TYPE_UINT);
	$u = $vbulletin->input->clean_gpc('p', 'u', TYPE_UINT);
		if (!$u) {
			$errormessage = $vbphrase[error_invalid_challenger];
			eval(standard_error($errormessage));
		}
	$u2 = $vbulletin->input->clean_gpc('p', 'u2', TYPE_UINT);
		if (!$u2)
		{
			$errormessage = $vbphrase[error_invalid_challenged];
			eval(standard_error($errormessage));
		}
	if ($u == $u2)
	{
		$errormessage = $vbphrase[error_invalid_challenger];
		eval(standard_error($errormessage));
	}
	$bestof = $vbulletin->input->clean_gpc('p', 'bestof', TYPE_UINT);
	$squadsize = $vbulletin->input->clean_gpc('p', 'squadsize', TYPE_UINT);
	$map = $vbulletin->input->clean_gpc('p', 'map', TYPE_NOHTML);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id=$lid ");
	$co_array = unserialize($ladder['chal_options']);
	$chal_options = array();
	if (is_array($co_array))
	{
		foreach ($co_array AS $key => $value)
		{
			$key = str_replace(' ','_',$key);
			$key = preg_replace("/[^a-zA-Z0-9_\s]/", "", unhtmlspecialchars($key));
			$chal_options["$key"] = $vbulletin->input->clean_gpc('p', "$key", TYPE_NOHTML);
		}
		$chal_options = serialize($chal_options);
	}
	if ($ladder['archive'] == '1')
	{
		$errormessage = $vbphrase[error_ladder_closed];
		eval(standard_error($errormessage));
	}
	$countchal = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND finished=0 ");
	$countchal = $countchal['countrows'];  
	if ($countchal != 0 && !$ladder['league'])
	{
		$errormessage = $vbphrase[error_already_challenged];
		eval(standard_error($errormessage));
	}
	$countu = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u ");
	$countu = $countu['countrows'];  
	if ($countu != 1) {
		$errormessage = $vbphrase[error_invalid_challenger];
		eval(standard_error($errormessage));
	}
	$countu2 = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$lid AND userid=$u2 ");
	$countu2 = $countu2['countrows'];  
	if ($countu2 != 1)
	{
		$errormessage = $vbphrase[error_invalid_challenged];
		eval(standard_error($errormessage));
	}
	/* challenge time/date */
	$vbulletin->input->clean_array_gpc('p', array(
		'timezoneoffset' => TYPE_ARRAY_NUM,
		'dst'            => TYPE_ARRAY_UINT,
		'date'       => TYPE_ARRAY_ARRAY,
		'time'       => TYPE_ARRAY_NOHTML
	));
	$type = 'range';
	$time = $vbulletin->GPC['time']["$type"];
	$date = $vbulletin->input->clean($vbulletin->GPC['date']["$type"], TYPE_ARRAY_UINT);
	$utc = $timezoneoffset = $vbulletin->GPC['timezoneoffset']["$type"];
	$dst = $vbulletin->GPC['dst']["$type"] = 1;
	require_once(DIR . '/includes/functions_misc.php');
	if (!fetch_timezone($timezoneoffset))
	{
		$errormessage = "Error: invalid timezone specified";
		eval(standard_error($errormessage));
	}
	if (!checkdate($date['month'], $date['day'], $date['year']))
	{
		$errormessage = "Error: Bad Date";
		eval(standard_error($errormessage));
	}
	$time_re = '#^(0?[1-9]|1[012])\s*[:.]\s*([0-5]\d)(\s*[AP]M)?|([01]\d|2[0-3])\s*[:.]\s*([0-5]\d)$#i';

	// match text in field for a valid time
	if (preg_match($time_re, $time, $matches))
	{
		if (count($matches) == 3)
		{
			$hour = intval($matches[1]);
			$minute = intval($matches[2]);
			$ampm = $matches[1] == '12' ? 'PM' : 'AM';
		}
		else if (count($matches) == 4)
		{
			$hour = intval($matches[1]);
			$minute = intval($matches[2]);
			$ampm = strtoupper(trim($matches[3]));
		}
		else // 24hr time
		{
			$hour = intval($matches[4]);
			$minute = intval($matches[5]);
			$ampm = ($hour <= 11) ? 'AM' : 'PM';
		}
	}
	if (($pos = strpos($vbulletin->options['timeformat'], 'H')) === false)
	{
		if ($ampm == 'PM')
		{
			if ($hour >= 1 AND $hour <= 11)
			{
				$hour += 12;
			}
		}
		else
		{
			if ($hour == 12)
			{
				$hour = 0;
			}
		}
	}
	$min_offset = $utc - intval($utc);
	$hour   -= intval($utc);
	$minute -= intval($min_offset * 60);
	$dateline = gmmktime($hour, $minute, 0, $date['month'], $date['day'], $date['year']);
	if ($_POST['now'])
	{
		$dateline = TIMENOW;
	}
	/* end challenge time/date */
	if (!$ladder['pot'] && $ladder['chal_cost'] > 0 && $vbulletin->options['tmnt_credit_system'])
	{
		$ladder['win_credits'] = (1-$vbulletin->options['tmnt_credits_comm'])*2*$ladder['chal_cost'];
		$credits_profit = 2 * $ladder['chal_cost'] - $ladder['win_credits'];
		$query_u = $vbulletin->db->query_first("SELECT userid,username,tmnt_credits FROM " . TABLE_PREFIX . "user WHERE userid=$u ");
		if ($query_u['tmnt_credits'] < $ladder['chal_cost'])
		{
			$errormessage = 'Error, '.$query_u['username'].' has insufficient credits. This challenge costs '.$ladder['chal_cost'].' credits, but '.$query_u['username'].' only has '.$query_u['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
		$query_u2 = $vbulletin->db->query_first("SELECT userid,username,tmnt_credits FROM " . TABLE_PREFIX . "user WHERE userid=$u2 ");
		if ($query_u2['tmnt_credits'] < $ladder['chal_cost'])
		{
			$errormessage = 'Error, '.$query_u2['username'].' has insufficient credits. This challenge costs '.$ladder['chal_cost'].' credits, but '.$query_u2['username'].' only has '.$query_u2['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
require_once(DIR . '/includes/functions_tll_premium.php');		
		process_credits_transaction($u, -$ladder['chal_cost'], 'Challenged another user', $u, $u2);
		process_credits_transaction($u2, -$ladder['chal_cost'], 'Challenged another user', $u2, $u);
		update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), $credits_profit, TIMENOW);
	}
	elseif($ladder['pot'] && $ladder['chal_cost'] > 0 && $vbulletin->options['tmnt_credit_system'])
	{
		$ladder['win_credits'] = (1-$vbulletin->options['tmnt_credits_comm'])*2*$ladder['chal_cost'];
		$credits_profit = 2 * $ladder['chal_cost'] - $ladder['win_credits'];
		$query_u = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid=$u ");
		if ($query_u['tmnt_credits'] < $ladder['chal_cost'])
		{
			$errormessage = 'Error, '.$query_u['teamname'].' has insufficient credits. This challenge costs '.$ladder['chal_cost'].' credits, but '.$query_u['teamname'].' only has '.$query_u['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
		$query_u2 = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid=$u2 ");
		if ($query_u2['tmnt_credits'] < $ladder['chal_cost'])
		{
			$errormessage = 'Error, '.$query_u2['teamname'].' has insufficient credits. This challenge costs '.$ladder['chal_cost'].' credits, but '.$query_u2['username'].' only has '.$query_u2['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
require_once(DIR . '/includes/functions_tll_premium.php');		
		process_credits_transaction($u, -$ladder['chal_cost'], 'Challenged another team', $u, $u2, $u2, 1);
		process_credits_transaction($u2, -$ladder['chal_cost'], 'Challenged another team', $u2, $u, $u, 1);
		update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), $credits_profit, TIMENOW);
	}
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_games
		(u, u2, lid, time, pot, accepted, bestof, matchdate, map, u1message, u2message, chal_options, dateline, chal_cost, win_credits, squadsize)
		VALUES (
			'".$vbulletin->db->escape_string($u)."',
			'".$vbulletin->db->escape_string($u2)."',
			'".$vbulletin->db->escape_string($lid)."',
			".TIMENOW.",
			'".$vbulletin->db->escape_string($pot)."',
			'1',
			'".$vbulletin->db->escape_string($bestof)."',
			'".$vbulletin->db->escape_string($matchdate)."',
			'".$vbulletin->db->escape_string($map)."',
			'".$vbulletin->db->escape_string($u1message)."',
			'".$vbulletin->db->escape_string($u2message)."',
			'".$vbulletin->db->escape_string($chal_options)."',
			'".$vbulletin->db->escape_string($dateline)."',
			'".$vbulletin->db->escape_string($ladder['chal_cost'])."',
			'".$vbulletin->db->escape_string($ladder['win_credits'])."',
			'".$vbulletin->db->escape_string($squadsize)."'
		)
	");
	$vbulletin->url = "ladders.php?do=view&id=$lid&sh=2";
	eval(print_standard_redirect('redirect_insertchalladder'));
}

// #############################################################################

if ($_REQUEST['do'] == 'insertmatch')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$ajax = $vbulletin->input->clean_gpc('g', 'ajax', TYPE_UINT);
		if (!$id) {
			$errormessage = $vbphrase[error_invalid_ladder];
			eval(standard_error($errormessage));
		}
	$lid = $id;
	$ladder = $ladders = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id'");
	if (!$ladders)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$co_array2 = unserialize($ladders['chal_options']);
	if (is_array($co_array2))
	{
		$co_array = array();
		foreach($co_array2 AS $key => $value)
		{
			$key2 = str_replace(' ','_',$key);
			$key2 = preg_replace("/[^a-zA-Z0-9_\s]/", "", unhtmlspecialchars($key2));//dom101
			if ($value)
			{
				$co_array["$key2"] = 
				array(
					'value' => explode("\r\n",$value),
					'key' => $key
				);
			}
			else
			{
				$co_array["$key2"] = 
				array(
					'value' => $value,
					'key' => $key
				);
			}
		}
	}
	$title = $ladders['title'];
	$team = false;
	if ($ladders['pot'])
	{
		$team = true;
	}
	$cmpts = $vbulletin->db->query_read("SELECT players.*, players.userid AS userid" . (!$team ? ", user.username AS username" : ", user.teamname AS username") . "
		FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
		" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (players.userid = user.userid) " : "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user ON (players.userid = user.teamid) ") . "
		WHERE players.lid=$id AND players.active=1 ORDER BY " . (!$team ? "user.username" : "user.teamname") . " ASC");
	while($cmpt = $vbulletin->db->fetch_array($cmpts))
	{
		$competitors .= '<option value="'. $cmpt[userid] .'">'. $cmpt[username] .'</option>';
	}
	$day = vbdate("j", TIMENOW);
	if ($day == 'j')
	{
		$day = date("j", TIMENOW);
	}
	$month = vbdate("n", TIMENOW);
	if ($month == 'n')
	{
		$month = date("n", TIMENOW);
	}
	$year = vbdate("Y", TIMENOW);
	if ($year == 'Y')
	{
		$year = date("Y", TIMENOW);
	}
	$monthselected = array();
	$yearselected = array();
	$monthselected["$month"] = 'selected="selected"';
	$yearselected["$year"] = 'selected="selected"';
	$yearbits = '';
	for ($gyear = 2005; $gyear <= 2015; $gyear++)
	{
		$yearbits .= "\t\t<option value=\"$gyear\" $yearselected[$gyear]>$gyear</option>";
	}
	if (strpos($vbulletin->options['timeformat'], 'H') !== false)
	{
		$show['24hour'] = true;
	}
	else
	{
		$show['24hour'] = false;
	}
	$time = vbdate($vbulletin->options['timeformat'], TIMENOW);
	require_once(DIR . '/includes/functions_misc.php');
	$timezoneoptions = '';
	foreach (fetch_timezone() AS $optionvalue => $timezonephrase)
	{
		$optiontitle = $vbphrase["$timezonephrase"];
		$optionselected = ($optionvalue == $vbulletin->userinfo['timezoneoffset']+$vbulletin->userinfo['dstonoff'] ? 'selected="selected"' : '');
		$timezoneoptions .= render_option_template($optiontitle, $optionvalue, $optionselected, $optionclass);
	}
	$templater = vB_Template::create('tmnt_ladder_insertmatch');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('competitors', $competitors);
		$templater->register('team', $team);
		$templater->register('title', $title);
		$templater->register('co_array', $co_array);
		$templater->register('time', $time);
		$templater->register('day', $day);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('monthselected', $monthselected);
		$templater->register('yearbits', $yearbits);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('ajax', $ajax);
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax']==1)
	{
		$tlhtml = str_replace("onclick=\"window.location.href='ladders.php?do=view&amp;id=$lid'\"",'onclick="close_tll_popup();"',$tlhtml);
		print_r($tlhtml);
		exit;
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?do=view&id='.$lid . $vbulletin->session->vars['sessionurl_q'] => $title,
		'' => construct_phrase($vbphrase['ladder_insertmatch'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'challenges')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$from = 'challenges';
	$rowcount = 0;
	$team = false;
	if ($vbulletin->userinfo['tmnt_notifications'])
	{
		if (!is_array($vbulletin->userinfo['tmnt_notifications']))
		{
			$vbulletin->userinfo['tmnt_notifications'] = unserialize($vbulletin->userinfo['tmnt_notifications']);
		}
		if (($vbulletin->userinfo['tmnt_notifications']['ladder_chals']+$vbulletin->userinfo['tmnt_notifications']['ladder_accepts']) > 0)
		{
			$vbulletin->userinfo['tmnt_notifications']['ladder_chals'] = 0;
			$vbulletin->userinfo['tmnt_notifications']['ladder_accepts'] = 0;
			$vbulletin->userinfo['tmnt_notifications'] = serialize($vbulletin->userinfo['tmnt_notifications']);
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($vbulletin->userinfo['tmnt_notifications'])."' WHERE userid = '".$vbulletin->userinfo['userid']."'");
		}
		//$vbulletin->userinfo['tmnt_notifications'] = unserialize($vbulletin->userinfo['tmnt_notifications']);
	}
	$templater = vB_Template::create('tmnt_ladder_chll_top');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('team', $team);
	$tlhtml .= $templater->render();
	$games = $vbulletin->db->query_read("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.username AS u, user2.username AS u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (games.u = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2
			ON (games.u2 = user2.userid)
		WHERE (games.u = $thisuserid OR games.u2 = $thisuserid)
			AND games.finished = 0
			AND games.accepted != -1
			AND games.pot = 0
			AND games.u2 != 0
		ORDER BY lid, round ASC
		");
	$mc_ids_array = array();
	$lastltitle = '';
	$chllarray = array();
	while($game = $vbulletin->db->fetch_array($games))
	{
		$game['display'] = 'none';
		if ($game['comments'] > 0)
		{
			$mc_ids_array[] = $game['id'];
		}
		$game = process_chal_options($game);
		$game['showltitle'] = false;
		if ($lastltitle != $game['ltitle'])
		{
			$game['showltitle'] = true;
			$game['ladderurl'] = $thisurl = tll_seo('ladder', $game['lid'], $game['ltitle']);
		}
		$lastltitle = $game['ltitle'];
		if ($game['uid'] == $thisuserid)
		{
			$is_u = true;
		}
		else
		{
			$is_u = false;
		}
		if ($game['u2id'] == $thisuserid)
		{
			$is_u2 = true;
		}
		else
		{
			$is_u2 = false;
		}
		$lid = $game['lid'];
		$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
		$game['showflags'] = true;
		//start match status
		if ($game['accepted'] == 0)
		{
			$game['status'] = $vbphrase[tmnt_awaiting_acceptance];
			if ($is_u2)
			{
				if ($game['chal_cost'] > 0 && $vbulletin->options['tmnt_credit_system'])
				{
					$game['onclick'] = ' onclick="return confirm(\'Are you sure you want to accept this challenge? It will cost you '.$game['chal_cost'].' credits.\');"';
				}
				$game['status'] = $game['status'].'. <br /> <a href="ladders.php?do=accept&amp;id='.$game['id'].'&amp;u='.$game['uid'].'"'.$game['onclick'].'>'.$vbphrase[tmnt_accept_now].'</a>! <br /> <a href="ladders.php?do=reject&amp;id='.$game['id'].'">'.$vbphrase[tmnt_reject_now].'</a>!';
			}
			$game['showflags'] = false;
		}
		elseif ($game['agree_u'] == 0 && $game['agree_u2'] == 0)
		{
			$game['status'] = $vbphrase['tmnt_awaiting_scores'] . ' <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase['tmnt_submit_score_now'].'</a>!';
		}
		elseif ($game['agree_u'] == 0)
		{
			if ($is_u)
			{
				$game['status'] = $vbphrase['tmnt_awaiting_your_score'] . '. <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase['tmnt_submit_score_now'] . '</a>!';
			}
			else
			{
				$game['status'] = $vbphrase['tmnt_awaiting_opponents_score'];
			}
		}
		elseif ($game['agree_u2'] == 0)
		{
			if ($is_u2)
			{
				$game['status'] = $vbphrase['tmnt_awaiting_your_score'] . '. <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase['tmnt_submit_score_now'] . '</a>!';
			}
			else
			{
				$game['status'] = $vbphrase['tmnt_awaiting_opponents_score'];
			}
		}
		//end match status
		$rowno++ ;
		if ($game['comments'] > 0)
		{
			$mc_ids_array[] = $game['id'];
		}
		$chllarray["$game[id]"] = $game;
	}
	if (!empty($mc_ids_array))
	{
		$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
	}
	$templater = vB_Template::create('tmnt_ladder_chll');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('show', $show);
		$templater->register('from', $from);
		$templater->register('chllarray', $chllarray);
	$tlhtml .= $templater->render();
	$team = true;
	$templater = vB_Template::create('tmnt_ladder_chll_bot');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('team', $team);
	$tlhtml .= $templater->render();
	$userid = $thisuserid;
	$coteamids = $teamids = $teamnames = $co_teamarray = $teamarray = array();
	$coteamcount = $teamcount = 0;
	$teams = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_members AS members
		JOIN " . TABLE_PREFIX . "tmnt_teams AS teams
			on members.teamid = teams.teamid
		WHERE (members.leader=1 OR members.coleader=1)
			AND members.userid='$userid'");
	while($teamm = $vbulletin->db->fetch_array($teams))
	{
		$teamid = $teamm['teamid'];
		$teamname = $teamm['teamname'];
		if ($teamm['leader'])
		{
			$teamids = array_merge((array)$teamid, $teamids);
			$teamnames = array_merge((array)$teamname, $teamnames);
			$teamarray[] = $teamm;
			$teamcount++;
		}
		elseif ($teamm['coleader'])
		{
			$co_teamarray[] = $teamm;
			$coteamids = array_merge((array)$teamid, $coteamids);
			$coteamcount++;
		}
	}
	$eteamids = $teamids;
	$teamids = implode(",", $teamids);
	$coteamids = implode(",", $coteamids);
	$yourteams = implode(", ", $teamnames);
	/*co-leaders*/
	if ($teamcount+$coteamcount > 0)
	{
		$rowcount = 0;
		$team = true;
		$templater = vB_Template::create('tmnt_ladder_yourteams');
			$templater->register('teamarray', $teamarray);
			$templater->register('co_teamarray', $co_teamarray);
		$tlhtml .= $templater->render();
		$templater = vB_Template::create('tmnt_ladder_chll_top');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('team', $team);
		$tlhtml .= $templater->render();
		$cond_where = "(";
		if ($teamids)
		{
			$cond_where .= "games.u IN (".$teamids.") OR games.u2 IN (".$teamids.")";
		}
		if ($teamids && $coteamids)
		{
			$cond_where .= " OR ";
		}
		if ($coteamids)
		{
			$cond_where .= "games.u IN (".$coteamids.") OR games.u2 IN (".$coteamids.")";
		}
		$cond_where .= ")";
		$games = $vbulletin->db->query_read("
			SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.teamname AS u, user2.teamname AS u2
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
				ON (games.lid = ladders.id)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user
				ON (games.u = user.teamid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user2
				ON (games.u2 = user2.teamid)
			WHERE $cond_where
				AND games.finished = 0
				AND games.accepted != -1
				AND games.u2 != 0
				AND games.pot = 1
			ORDER BY games.lid
		");
		$lastltitle = '';
		$chllarray = array();
		$mc_ids_array = array();
		while($game = $vbulletin->db->fetch_array($games))
		{
			if (in_array($game['uid'], $eteamids) OR in_array($game['u2id'], $eteamids))
			{
				$game['leader'] = 1;
			}
			$game['display'] = 'none';
			$game = process_chal_options($game);
			$lid = $game['lid']; 
			$game['showltitle'] = false;
			if ($lastltitle != $game['ltitle'])
			{
				$game['showltitle'] = true;
				$game['ladderurl'] = $thisurl = tll_seo('ladder', $game['lid'], $game['ltitle']);
			}
			$lastltitle = $game['ltitle'];
			$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
			if (in_array($game['uid'], $eteamids))
			{
				$is_u = true;
			}
			else
			{
				$is_u = false;
			}
			if (in_array($game['u2id'], $eteamids))
			{
				$is_u2 = true;
			}
			else
			{
				$is_u2 = false;
			}
			$game['showflags'] = true;
			//start match status
			if ($game['accepted'] == 0)
			{
				$game['status'] = $vbphrase['tmnt_awaiting_acceptance'];
				if ($is_u2)
				{
					$game['status'] = $game['status'] . ($game['leader'] ? '. <br /> <a href="ladders.php?do=teamaccept&amp;id='.$game['id'].'">'.$vbphrase['tmnt_accept_now'].'</a>! <br /> <a href="ladders.php?do=teamreject&amp;id='.$game['id'].'">'.$vbphrase['tmnt_reject_now'].'</a>!' : '');
				}
				$game['showflags'] = false;
			}
			elseif ($game['agree_u'] == 0 && $game['agree_u2'] == 0)
			{
				$game['status'] = $vbphrase['tmnt_awaiting_scores'] . ($game['leader'] ? ' <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase['tmnt_submit_score_now'].'</a>!' : '');
			}
			elseif ($game['agree_u'] == 0)
			{
				if ($is_u)
				{
					$game['status'] = $vbphrase['tmnt_awaiting_your_score'] . ($game['leader'] ? '. <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase['tmnt_submit_score_now'] . '</a>!' : '');
				}
				else
				{
					$game['status'] = $vbphrase['tmnt_awaiting_opponents_score'];
				}
			}
			elseif ($game['agree_u2'] == 0)
			{
				if ($is_u2)
				{
					$game['status'] = $vbphrase['tmnt_awaiting_your_score'] . ($game['leader'] ? '. <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase['tmnt_submit_score_now'] . '</a>!' : '');
				}
				else
				{
					$game['status'] = $vbphrase['tmnt_awaiting_opponents_score'];
				}
			}
			$rowno++ ;
			if ($game['comments'] > 0)
			{
				$mc_ids_array[] = $game['id'];
			}
			$chllarray["$game[id]"] = $game;
		}
		if (!empty($mc_ids_array))
		{
			$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
		}
		$templater = vB_Template::create('tmnt_ladder_chll');
			$templater->register('tmntp', $tmntp);
			$templater->register('rowno', $rowno);
			$templater->register('team', $team);
			$templater->register('from', $from);
			$templater->register('chllarray', $chllarray);
		$tlhtml .= $templater->render();
		$templater = vB_Template::create('tmnt_ladder_chll_bot');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('team', $team);
		$tlhtml .= $templater->render();
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => $vbphrase['ladder'] . " " . $vbphrase['ladder_chlls']
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'acceptmatchdate')
{
	$vbulletin->input->clean_array_gpc('g', array(
		'mid' => TYPE_UINT,
		'dateline' => TYPE_UINT
	));
	$game = $vbulletin->db->query_first("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.username AS u, user2.username AS u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (games.u = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2
			ON (games.u2 = user2.userid)
		WHERE games.finished = 0
			AND games.accepted != -1
			AND games.id = '".$vbulletin->GPC['mid']."'
	");
	if (!$game OR !$vbulletin->GPC['dateline'])
	{
		print_no_permission();
	}
	if ($game['uid'] == $vbulletin->userinfo['userid'])
	{
		$is = 'u';
		$ois = 'u2';
	}
	elseif ($game['u2id'] == $vbulletin->userinfo['userid'])
	{
		$is = 'u2';
		$ois = 'u';
	}
	else
	{
		print_no_permission();
	}
	if ($game['ram'])
	{
		$game['ram'] = unserialize($game['ram']);
	}
	if (is_array($game['ram']) && $game['ram']["$ois"])
	{
		$game['opp_sd'] = array();
		for ($i = 1; $i <= 3; $i++)
		{
			if ($game['ram']["$ois"]["dateline$i"])
			{
				$game['opp_sd'][] = $game['ram']["$ois"]["dateline$i"];
			}
		}
	}
	if (!in_array($vbulletin->GPC['dateline'], $game['opp_sd']))
	{
		print_no_permission();
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
		SET ram = '', dateline = '".$vbulletin->GPC['dateline']."'
		WHERE id = '".$vbulletin->GPC['mid']."'
	");
	$vbulletin->url = "ladders.php?do=view&amp;id=".$game['lid']."&amp;sh=2&amp;mid=".$vbulletin->GPC['mid']."#match".$vbulletin->GPC['mid'];
	eval(print_standard_redirect('redirect_updatechal'));
}

// #############################################################################

if ($_POST['do'] == 'rearrange_match')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'timezoneoffset' => TYPE_ARRAY_NUM,
		'dst'            => TYPE_ARRAY_UINT,
		'mid'            => TYPE_UINT,
		'd1date'         => TYPE_ARRAY_ARRAY,
		'd1time'       => TYPE_ARRAY_NOHTML,
		'd2date'         => TYPE_ARRAY_ARRAY,
		'd2time'       => TYPE_ARRAY_NOHTML,
		'd3date'         => TYPE_ARRAY_ARRAY,
		'd3time'       => TYPE_ARRAY_NOHTML
	));
	$type = 'range';
	$timezoneoffset = $vbulletin->userinfo['timezoneoffset'];
	$d1time = $vbulletin->GPC['d1time']["$type"];
	$d1date = $vbulletin->input->clean($vbulletin->GPC['d1date']["$type"], TYPE_ARRAY_UINT);
	$d2time = $vbulletin->GPC['d2time']["$type"];
	$d2date = $vbulletin->input->clean($vbulletin->GPC['d2date']["$type"], TYPE_ARRAY_UINT);
	$d3time = $vbulletin->GPC['d3time']["$type"];
	$d3date = $vbulletin->input->clean($vbulletin->GPC['d3date']["$type"], TYPE_ARRAY_UINT);
	$utc = $timezoneoffset = $vbulletin->GPC['timezoneoffset']["$type"];
	$dst = $vbulletin->GPC['dst']["$type"];
	$mid = $vbulletin->GPC['mid'];
	require_once(DIR . '/includes/functions_misc.php');
	if (!fetch_timezone($timezoneoffset))
	{
		$errormessage = 'Error: invalid timezone specified';
		eval(standard_error($errormessage));
	}	
	$dateline1 = tmnt_fields_to_dateline($d1time, $d1date, $utc, $dst, $type);
	$dateline2 = tmnt_fields_to_dateline($d2time, $d2date, $utc, $dst, $type);
	$dateline3 = tmnt_fields_to_dateline($d3time, $d3date, $utc, $dst, $type);
	$game = $vbulletin->db->query_first("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.username AS u, user2.username AS u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (games.u = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2
			ON (games.u2 = user2.userid)
		WHERE games.finished = 0
			AND games.accepted != -1
			AND games.id = '$mid'
	");
	if (!$game)
	{
		print_no_permission();
	}
	if ($game['uid'] == $vbulletin->userinfo['userid'])
	{
		$is = 'u';
		$ois = 'u2';
	}
	elseif ($game['u2id'] == $vbulletin->userinfo['userid'])
	{
		$is = 'u2';
		$ois = 'u';
	}
	else
	{
		print_no_permission();
	}
	if ($game['ram'])
	{
		$game['ram'] = unserialize($game['ram']);
	}
	if (is_array($game['ram']))
	{
		$ram = serialize(array(
			"$ois" => $game['ram']["$ois"],
			"$is" => array('userid' => $vbulletin->userinfo['userid'], 'dateline' => TIMENOW, 'dateline1' => $dateline1, 'dateline2' => $dateline2, 'dateline3' => $dateline3)
		));
	}
	else
	{
		$ram = serialize(array(
			"$ois" => array(),
			"$is" => array('userid' => $vbulletin->userinfo['userid'], 'dateline' => TIMENOW, 'dateline1' => $dateline1, 'dateline2' => $dateline2, 'dateline3' => $dateline3)
		));
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
		SET ram = '".$vbulletin->db->escape_string($ram)."'
		WHERE id = '".$vbulletin->GPC['mid']."'
	");
	$vbulletin->url = "ladders.php?do=rearrange_match&amp;mid=".$mid;
	eval(print_standard_redirect('redirect_updatechal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'rearrange_match')
{
	$mid = $vbulletin->input->clean_gpc('g', 'mid', TYPE_UINT);
	$game = $vbulletin->db->query_first("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.username AS u, user2.username AS u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (games.u = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2
			ON (games.u2 = user2.userid)
		WHERE games.finished = 0
			AND games.accepted != -1
			AND games.id = '$mid'
	");
	if (!$game)
	{
		print_no_permission();
	}
	if ($game['uid'] == $vbulletin->userinfo['userid'])
	{
		$is = 'u';
		$ois = 'u2';
	}
	elseif ($game['u2id'] == $vbulletin->userinfo['userid'])
	{
		$is = 'u2';
		$ois = 'u';
	}
	else
	{
		print_no_permission();
	}
	if ($game['ram'])
	{
		$game['ram'] = unserialize($game['ram']);
	}
	if (!$game['dateline'])
	{
		$game['nodateline'] = true;
		$game['dateline'] = TIMENOW + 86400;
	}
	$utc = $vbulletin->userinfo['timezoneoffset'];
	$dst = 1;
	for ($i = 1; $i <= 3; $i++)
	{
		if (!is_array($game['ram']) OR !$game['ram']["$is"]["dateline$i"])
		{
			$dateline = $game['dateline'] + (($i - 1) * 86400);
		}
		else
		{
			$dateline = $game['ram']["$is"]["dateline$i"];
		}
		list ($timezoneoptions, $day, $monthselected, $yearbits, $time, $dstchecked, $show) = tmnt_dateline_to_fields($dateline, $utc, $dst, $show);
		$templater = vB_Template::create('tmnt_date_time');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('timezoneoptions', $timezoneoptions);
			$templater->register('dstchecked', $dstchecked);
			$templater->register('time', $time);
			$templater->register('day', $day);
			$templater->register('monthselected', $monthselected);
			$templater->register('yearbits', $yearbits);
			$templater->register('rangeid', 0);
			$templater->register('prefix', 'd'.$i);
		if ($i == 1)
		{
			$dh = "datehtml"; 
		}
		else
		{
			$dh = "datehtml$i"; 
		}
		$$dh = $templater->render();
	}
	if (is_array($game['ram']) && $game['ram']["$ois"])
	{
		$game['opp_sd'] = array();
		for ($i = 1; $i <= 3; $i++)
		{
			if ($game['ram']["$ois"]["dateline$i"])
			{
				$game['opp_sd'][] = $game['ram']["$ois"]["dateline$i"];
				$show['opponent_suggestions'] = true;
			}
		}
	}
	$templater = vB_Template::create('tmnt_ladder_rearrange');
		$templater->register('tmntp', $tmntp);
		$templater->register('game', $game);
		$templater->register('datehtml', $datehtml);
		$templater->register('datehtml2', $datehtml2);
		$templater->register('datehtml3', $datehtml3);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('show', $show);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id=' . $game['lid'] => $game['ltitle'],
		'' => $vbphrase['ladder_rearrange_md']
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'updatepositions')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('p', 'lid', TYPE_UINT);
	$sh = $vbulletin->input->clean_gpc('p', 'sh', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = $lid");
	if (!$ladder)
	{
		print_no_permission();
	}
	$ladder['filter_round'] = $vbulletin->input->clean_gpc('p', 'round', TYPE_UINT);
	if (!$ladder['filter_round'])
	{
		$ladder['filter_round'] = 1;
	}
	$ladder['filter_group'] = $vbulletin->input->clean_gpc('p', 'group', TYPE_UINT);
	if (!$ladder['filter_group'])
	{
		$ladder['filter_group'] = 1;
	}
	$ladder['selected']['group_'.$ladder['filter_group']] = ' selected="selected"';
	$ladder['selected']['round_'.$ladder['filter_round']] = ' selected="selected"';
	$rowno = 0;
	if ($ladder['filter_round']==1)
	{
		$sql_g = 'round';
	}
	else
	{
		$sql_g = 'round'.$ladder['filter_round'];
	}
	//print_r($ladder);
	$pq = $vbulletin->db->query_read("
		SELECT p.*, " . (!$team ? "u.username" : "u.teamname AS username") . " 
		FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
		" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS u ON (p.userid = u.userid)" : "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS u ON (p.userid = u.teamid)") . "
		WHERE p.lid = '$lid' 
			AND p.group = '".$ladder['filter_group']."'
	");
	while($p = $vbulletin->db->fetch_array($pq))
	{
		$p['rpos'] = $p["$sql_g"];
		$p['sel']["$sql_g"] = ' selected="selected"';
		$pcount++;
		$parray[] = $p;
		$pos = $vbulletin->input->clean_gpc('p', 'id_'.$p['id'], TYPE_UINT);
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
			SET round" . ($ladder['filter_round']>1 ? $ladder['filter_round'] : "") . " = '$pos'
			WHERE lid='$lid' AND id = '".$p['id']."'
		");
	}
	require_once(DIR . '/includes/functions_tll_racemode.php');
	tll_league_racemode_refreshxp($ladder);
	$vbulletin->url = "ladders.php?do=view&amp;id=$lid&sh=$sh&group=".$ladder['filter_group']."&round=".$ladder['filter_round'];
	eval(print_standard_redirect('redirect_updatechal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'allchallenges')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$from = 'allchallenges';
	$rowcount = 0;
	$team = false;
	$show['delete'] = true;
	$templater = vB_Template::create('tmnt_ladder_all_chll_top');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('team', $team);
	$tlhtml .= $templater->render();
	$games = $vbulletin->db->query_read("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.username AS u, user2.username AS u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (games.u = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2
			ON (games.u2 = user2.userid)
		WHERE games.finished = 0
			AND games.accepted != -1
			AND games.pot = 0
		ORDER BY lid, round ASC, games.group ASC
		LIMIT 0, 100
		");
	$chllarray = array();
	$mc_ids_array = array();
	$lastltitle = '';
	while($game = $vbulletin->db->fetch_array($games))
	{
		$game['script'] = 'allchallenges';
		$game['display'] = 'none';
		if ($game['comments'] > 0)
		{
			$mc_ids_array[] = $game['id'];
		}
		$game = process_chal_options($game);
		$game['showltitle'] = false;
		if ($lastltitle != $game['ltitle'])
		{
			$game['showltitle'] = true;
			$game['ladderurl'] = $thisurl = tll_seo('ladder', $game['lid'], $game['ltitle']);
		}
		$lastltitle = $game['ltitle'];
		if ($game['uid'] == $thisuserid)
		{
			$is_u = true;
		}
		else
		{
			$is_u = false;
		}
		if ($game['u2id'] == $thisuserid)
		{
			$is_u2 = true;
		}
		else
		{
			$is_u2 = false;
		}
		$lid = $game['lid'];
		$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
		//$show['flags'] = true;//commented out for time being
		//start match status
		if ($game['accepted'] == 0)
		{
			$game['status'] = $vbphrase[tmnt_awaiting_acceptance];
			if ($is_u2)
			{
				$game['status'] = $game['status'].'. <br /> <a href="ladders.php?do=accept&amp;id='.$game['id'].'&amp;u='.$game['uid'].'">'.$vbphrase[tmnt_accept_now].'</a>! <br /> <a href="ladders.php?do=reject&amp;id='.$game['id'].'">'.$vbphrase[tmnt_reject_now].'</a>!';
			}
			$game['showflags'] = false;
		}
		elseif ($game['agree_u'] == 0 && $game['agree_u2'] == 0)
		{
			if ($is_u OR $is_u2)
			{
				$game['status'] = $vbphrase[tmnt_awaiting_scores] . ' <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now].'</a>!';
			}
			else
			{
				$game['status'] = 'Awaiting scores from both players.';
			}
		}
		elseif ($game['agree_u'] == 0)
		{
			if ($is_u)
			{
				$game['status'] = $vbphrase[tmnt_awaiting_your_score] . '. <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now] . '</a>!';
			}
			else
			{
				$game['status'] = $vbphrase[tmnt_awaiting_opponents_score];
			}
		}
		elseif ($game['agree_u2'] == 0)
		{
			if ($is_u2)
			{
				$game['status'] = $vbphrase[tmnt_awaiting_your_score] . '. <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now] . '</a>!';
			}
			else
			{
				$game['status'] = $vbphrase[tmnt_awaiting_opponents_score];
			}
		}
		//end match status
		$rowno++;
		if ($game['comments'] > 0)
		{
			$mc_ids_array[] = $game['id'];
		}
		$chllarray["$game[id]"] = $game;
	}
	if (!empty($mc_ids_array))
	{
		$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
	}
	$templater = vB_Template::create('tmnt_ladder_chll');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('show', $show);
		$templater->register('from', $from);
		$templater->register('chllarray', $chllarray);
	$tlhtml .= $templater->render();
	$team = true;
	$templater = vB_Template::create('tmnt_ladder_chll_bot');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('team', $team);
	$tlhtml .= $templater->render();
	$tlhtml .= "<br />";
	$userid = $thisuserid;
		$rowcount = 0;
		$team = true;
		$templater = vB_Template::create('tmnt_ladder_all_chll_top');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowno', $rowno);
		$templater->register('team', $team);
		$tlhtml .= $templater->render();
		$games = $vbulletin->db->query_read("
			SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS ltitle, user.teamname AS u, user2.teamname AS u2
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
				ON (games.lid = ladders.id)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user
				ON (games.u = user.teamid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user2
				ON (games.u2 = user2.teamid)
			WHERE games.finished = 0
				AND games.accepted != -1
				AND games.pot = 1
			LIMIT 0, 100
		");
		$lastltitle = '';
		$chllarray = array();
		$mc_ids_array = array();
		while($game = $vbulletin->db->fetch_array($games))
		{
			$game['script'] = 'allchallenges';
			$game['display'] = 'none';
			$game = process_chal_options($game);
			$lid = $game['lid']; 
			$game['showltitle'] = false;
			if ($lastltitle != $game['ltitle'])
			{
				$game['showltitle'] = true;
				$game['ladderurl'] = $thisurl = tll_seo('ladder', $game['lid'], $game['ltitle']);
			}
			$lastltitle = $game['ltitle'];
			$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
			$is_u = false;
			$is_u2 = false;
			//start match status
			if ($game['accepted'] == 0)
			{
				$game['status'] = $vbphrase[tmnt_awaiting_acceptance];
				if ($is_u2)
				{
					$game['status'] = $game['status'].'. <br /> <a href="ladders.php?do=teamaccept&amp;id='.$game['id'].'">'.$vbphrase[tmnt_accept_now].'</a>! <br /> <a href="ladders.php?do=teamreject&amp;id='.$game['id'].'">'.$vbphrase[tmnt_reject_now].'</a>!';
				}
			}
			elseif ($game['agree_u'] == 0 && $game['agree_u2'] == 0)
			{
				if ($is_u OR $is_u2)
				{
					$game['status'] = $vbphrase[tmnt_awaiting_scores] . ' <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now].'</a>!';
				}
				else
				{
					$game['status'] = 'Awaiting scores from both teams.';
				}
			}
			elseif ($game['agree_u'] == 0)
			{
				if ($is_u)
				{
					$game['status'] = $vbphrase[tmnt_awaiting_your_score] . '. <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now] . '</a>!';
				}
				else
				{
					$game['status'] = $vbphrase[tmnt_awaiting_opponents_score];
				}
			}
			elseif ($game['agree_u2'] == 0)
			{
				if ($is_u2)
				{
					$game['status'] = $vbphrase[tmnt_awaiting_your_score] . '. <br /><a href="ladders.php?do=submitscore&amp;id='.$game['id'].'">' . $vbphrase[tmnt_submit_score_now] . '</a>!';
				}
				else
				{
					$game['status'] = $vbphrase[tmnt_awaiting_opponents_score];
				}
			}
			//end match status
			$rowno++;
			if ($game['comments'] > 0)
			{
				$mc_ids_array[] = $game['id'];
			}
			$chllarray["$game[id]"] = $game;
		}
		if (!empty($mc_ids_array))
		{
			$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
		}
		$templater = vB_Template::create('tmnt_ladder_chll');
			$templater->register('tmntp', $tmntp);
			$templater->register('team', $team);
			$templater->register('from', $from);
			$templater->register('chllarray', $chllarray);
		$tlhtml .= $templater->render();
		$templater = vB_Template::create('tmnt_ladder_chll_bot');
			$templater->register('tmntp', $tmntp);
			$templater->register('rowno', $rowno);
			$templater->register('team', $team);
		$tlhtml .= $templater->render();
	
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => construct_phrase($vbphrase['ladder_all_chlls'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'reportedmatches')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$rowcount = 0;
	$rowno = 0;
	$mc_ids_array = array();
	$chllarray = array();
	$games = $vbulletin->db->query_read("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS laddertitle, user.username AS u, user2.username AS u2
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS user
			ON (games.u = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user2
			ON (games.u2 = user2.userid)
		WHERE games.finished = 0
			AND games.accepted = 1
			AND games.pot = 0
			AND games.flag != 0
		");
	while($game = $vbulletin->db->fetch_array($games))
	{
		//query comments dispute == 1
		$lid = $game['lid'];
		if ($game['flag'] == $game['uid'])
		{
			$game['flag'] = $game['u'];
		}
		elseif ($game['flag'] == $game['u2id'])
		{
			$game['flag'] = $game['u2'];
		}
		$game['display'] = 'none';
		$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
		$rowno++ ;
		if ($game['comments'] > 0)
		{
			$mc_ids_array[] = $game['id'];
		}
		$chllarray["$game[id]"] = $game;
	}
	$games = $vbulletin->db->query_read("
		SELECT games.*, games.u AS uid, games.u2 AS u2id, ladders.title AS laddertitle, t.teamname AS u, t2.teamname AS u2, f.username AS flag, ladders.catid
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (games.lid = ladders.id)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
			ON (games.u = t.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t2
			ON (games.u2 = t2.teamid)
		LEFT JOIN " . TABLE_PREFIX . "user AS f
			ON (games.flag = f.userid)
		WHERE games.finished = 0
			AND games.accepted = 1
			AND games.pot = 1
			AND games.flag != 0
		");
	while($game = $vbulletin->db->fetch_array($games))
	{
		$lid = $game['lid'];
		$game['display'] = 'none';
		$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
		$rowno++ ;
		if ($game['comments'] > 0)
		{
			$mc_ids_array[] = $game['id'];
		}
		if ($game['catid'])
		{
			$game['categorytitle'] = $vbulletin->tll_catcache["$game[catid]"]['title'];
			$game['caturl'] = $vbulletin->tll_catcache["$game[catid]"]['url'];
		}
		$chllarray["$game[id]"] = $game;
	}
	if (!empty($mc_ids_array))
	{
		$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
	}
	$templater = vB_Template::create('tmnt_ladder_repmatch');
		$templater->register('tmntp', $tmntp);
		$templater->register('lid', $lid);
		$templater->register('rowno', $rowno);
		$templater->register('chllarray', $chllarray);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => construct_phrase($vbphrase['ladder_reported_matches'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'acceptmf')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase['error_invalid_challenge'];
		eval(standard_error($errormessage));
	}
	$u2 = $thisuserid;
	//query match info
	$match = $vbulletin->db->query_first("
		SELECT g.*
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
		WHERE g.id = $id AND g.u2 = 0 AND g.accepted = 0 AND g.finished = 0
	");
	if (!$match)
	{
		$errormessage = $vbphrase['error_invalid_match'];
		eval(standard_error($errormessage));
	}
	$lid = $match['lid'];
	$u = $match['u'];
	if ($match['pot'])
	{
		$u2 = $vbulletin->input->clean_gpc('g', 'u2', TYPE_UINT);
		//check thisuserid is leader of u2
		$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_members WHERE (teamid = '$u2' AND leader = '1' AND userid = '$thisuserid') ");
		if ($countplayer['countrows'] != 1)
		{
			$errormessage = $vbphrase['error_not_leader'];
			eval(standard_error($errormessage));
		}
		$sh = 2;
	}
	else
	{
		$sh = 3;
	}
	if ($match['u'] == $u2)
	{
		$errormessage = "You cannot accept your own games in the match finder.";
		eval(standard_error($errormessage));
	}
	if ($match['dateline'] < TIMENOW)
	{
		$errormessage = $vbphrase['error_match_inpast'];
		eval(standard_error($errormessage));
	}
	//check accepting player in ladder
	$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = ".$lid." AND userid = $u2 AND active = 1");
	$countplayer = $countplayer['countrows'];  
	if ($countplayer != 1)
	{
		$errormessage = $vbphrase['error_player_not_ladder'];
		eval(standard_error($errormessage));
	}
	$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND finished=0 ");
		$countplayer = $countplayer['countrows'];  
		if ($countplayer >= $vbulletin->options['tmnt_ladder_maxc'] && $u2 > 0)
		{
			$errormessage = $vbphrase['error_already_challenged'];
			eval(standard_error($errormessage));
		}
	$time_limit = TIMENOW - ($vbulletin->options['tmnt_ladder_limitrematch'] * 60 * 60);
	$countlimit = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND ((u=$u AND u2=$u2) OR (u=$u2 AND u2=$u)) AND dateline_finished > '" . $time_limit . "' ");
	if ($countlimit['countrows'])
	{
		$days = floor($vbulletin->options['tmnt_ladder_limitrematch']/24);
		$hours = $vbulletin->options['tmnt_ladder_limitrematch'] - $days * 24;
		$errormessage = "Please wait " . ($days ? "$days days " : "") . ($hours ? "$hours hours " : "") . "between challenging the same player/team.";
		eval(standard_error($errormessage));
	}
	$u = $match['u'];
	if (!$match['pot'] && $match['chal_cost'] > 0 && $vbulletin->options['tmnt_credit_system'])
	{
		if ($match['win_credits'])
		{
			$credits_profit = 2 * $match['chal_cost'] - $match['win_credits'];
		}
		if ($vbulletin->userinfo['tmnt_credits'] < $match['chal_cost'])
		{
			$errormessage = 'Error, insufficient credits. Accepting a challenge costs '.$match['chal_cost'].' credits, you only have '.$vbulletin->userinfo['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
require_once(DIR . '/includes/functions_tll_premium.php');		
		process_credits_transaction($match['u'], -$match['chal_cost'], 'Challenged another user', $match['u'], $match['u2']);
		process_credits_transaction($match['u2'], -$match['chal_cost'], 'Challenged another user', $match['u2'], $match['u']);
		update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), $credits_profit, TIMENOW);
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
		SET accepted = '1', u2 = '$u2', accepted_dateline = '".TIMENOW."'
		WHERE id='$id' AND accepted = '0' AND finished = '0' AND pot = '".$match['pot']."'
	");
	if ($u && !$match['pot'])
	{
		$uinfo = fetch_userinfo($u);
		if ($uinfo)
		{
			if (!is_array($uinfo['tmnt_notifications']) && $uinfo['tmnt_notifications'])
			{
				$uinfo['tmnt_notifications'] = unserialize($uinfo['tmnt_notifications']);
			}
			else if (!$uinfo['tmnt_notifications'])
			{
				$uinfo['tmnt_notifications'] = array();
			}
			$uinfo['tmnt_notifications']['ladder_accepts']++;
			$uinfo['tmnt_notifications'] = serialize($uinfo['tmnt_notifications']);
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($uinfo['tmnt_notifications'])."' WHERE userid = '".$uinfo['userid']."'");
			require_once('./includes/functions_databuild.php');
			$fromuserid = $thisuserid;
			$fromusername = $thisusername;
			$title = $vbphrase['ladder_someone_accepted_mf'];
			$recipients = $uinfo['username'];
			$templater = vB_Template::create('tmnt_ladder_mfpm');
			$templater->register('tmntp', $tmntp);
			$templater->register('match', $match);
			$templater->register('title', $title);
			$templater->register('fromusername', $fromusername);
			$templater->register('fromuserid', $fromuserid);
			$message = $templater->render();
			$message = preg_replace('/<!--(.|\s)*?-->/', '', $message);
				$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
				$pmdm->set('fromuserid', $fromuserid);
				$pmdm->set('fromusername', $fromusername);
				$pmdm->set('title', $title);
				$pmdm->set('message', $message);
				$pmdm->set_recipients($recipients, $botpermissions);
				$pmdm->set('dateline', TIMENOW); 
				$pmdm->overridequota = true;
				$errors = $pmdm->errors;
				if ($errors)
				{
					foreach ($errors as $error) {
						$errorss .= $error. "<br />";
					}
					$errormessage = $vbphrase[error_success_chal_error_pm].$errorss;
					eval(standard_error($errormessage));
				}
				$pmdm->save();
				unset($pmdm);
		}
	}
	$vbulletin->url = "ladders.php?do=view&id=".$lid."&sh=$sh#match".$match['id'];
	eval(print_standard_redirect('redirect_acceptchal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'accept')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id) {
			$errormessage = $vbphrase[error_invalid_challenge];
			eval(standard_error($errormessage));
		}
	$u2 = $thisuserid;
	$match = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladder_games
		WHERE id='$id' AND u2='$u2' AND accepted = '0' AND finished = '0' AND pot = '0'
	");
	if (!$match)
	{
		print_no_permission();
	}
	if (!$match['pot'] && $match['chal_cost'] > 0 && $vbulletin->options['tmnt_credit_system'])
	{
		if ($match['win_credits'])
		{
			$credits_profit = 2 * $match['chal_cost'] - $match['win_credits'];
		}
		if ($vbulletin->userinfo['tmnt_credits'] < $match['chal_cost'])
		{
			$errormessage = 'Error, insufficient credits. Accepting a challenge costs '.$match['chal_cost'].' credits, you only have '.$vbulletin->userinfo['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
require_once(DIR . '/includes/functions_tll_premium.php');		
		process_credits_transaction($match['u'], -$match['chal_cost'], 'Challenged another user', $match['u'], $match['u2']);
		process_credits_transaction($match['u2'], -$match['chal_cost'], 'Challenged another user', $match['u2'], $match['u']);
		update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), $credits_profit, TIMENOW);
	}
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET accepted = '1', accepted_dateline = '".TIMENOW."' WHERE id='$id' AND u2='$u2' AND accepted = '0' AND finished = '0' AND pot = '0'");
	$u = $vbulletin->input->clean_gpc('g', 'u', TYPE_UINT);
	if ($u)
	{
		$uinfo = fetch_userinfo($u);
		if ($uinfo)
		{
			if (!is_array($uinfo['tmnt_notifications']) && $uinfo['tmnt_notifications'])
			{
				$uinfo['tmnt_notifications'] = unserialize($uinfo['tmnt_notifications']);
			}
			else if (!$uinfo['tmnt_notifications'])
			{
				$uinfo['tmnt_notifications'] = array();
			}
			$uinfo['tmnt_notifications']['ladder_accepts']++;
			$uinfo['tmnt_notifications'] = serialize($uinfo['tmnt_notifications']);
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_notifications = '".$vbulletin->db->escape_string($uinfo['tmnt_notifications'])."' WHERE userid = '".$uinfo['userid']."'");
			/*PM*/
			$title = $vbphrase['ladder_new_chll_accepted'];
			$recipients = $uinfo['username'];
			$message = construct_phrase($vbphrase[ladder_new_chll_accepted_pm], $thisusername, $vbulletin->options['bburl'], $id);
			$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
			$pmdm->set('fromuserid', $thisuserid);
			$pmdm->set('fromusername', $thisusername);
			$pmdm->set('title', $title);
			$pmdm->set('message', $message);
			$pmdm->set_recipients($recipients, $botpermissions);
			$pmdm->set('dateline', TIMENOW); 
			$pmdm->overridequota = true;
			$errors = $pmdm->errors;
			if ($errors) {
				foreach ($errors as $error) {
					$errorss .= $error. "<br />";
				}
				$errormessage = $errorss;
				eval(standard_error($errormessage));
			}
			$pmdm->save();
			unset($pmdm);
			/*PM*/
		}
	}
	$vbulletin->url = "ladders.php?do=challenges&mid=".$id."#match".$id;
	eval(print_standard_redirect('redirect_acceptchal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'teamaccept')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id) {
			$errormessage = $vbphrase[error_invalid_challenge];
			eval(standard_error($errormessage));
		}
	$match = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id = '$id' ");
	if (!$match['pot'] OR $match['accepted'])
	{
		print_no_permission();
	}
	$userid = $thisuserid;
	$teamids = array();
	$teams = $vbulletin->db->query_read("
		SELECT * FROM " . TABLE_PREFIX . "tmnt_members AS members
		JOIN " . TABLE_PREFIX . "tmnt_teams AS teams
			ON members.teamid = teams.teamid
		WHERE members.leader = '1'
			AND members.userid = '$userid'
	");
	while ($teamm = $vbulletin->db->fetch_array($teams)) 
	{
		$teamid = $teamm['teamid'];
		$teamids = array_merge((array)$teamid, $teamids);
	}
	$team_u = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid = '".$match['u']."' ");
	$team_u2 = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid = '".$match['u2']."' ");
	if ($match['chal_cost'] > 0 && $vbulletin->options['tmnt_credit_system'])
	{
		if ($match['win_credits'])
		{
			$credits_profit = 2 * $match['chal_cost'] - $match['win_credits'];
		}
		if ($team_u['tmnt_credits'] < $match['chal_cost'])
		{
			$errormessage = 'Error, insufficient credits. Accepting a challenge costs '.$match['chal_cost'].' credits, '.$team_u['teamname'].' has '.$team_u['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
		if ($team_u2['tmnt_credits'] < $match['chal_cost'])
		{
			$errormessage = 'Error, insufficient credits. Accepting a challenge costs '.$match['chal_cost'].' credits, '.$team_u2['teamname'].' has '.$team_u2['tmnt_credits'].' credits.';
			eval(standard_error($errormessage));
		}
require_once(DIR . '/includes/functions_tll_premium.php');		
		process_credits_transaction($match['u'], -$match['chal_cost'], 'Challenged another team', $match['u'], $match['u2'], $match['u'], 1);
		process_credits_transaction($match['u2'], -$match['chal_cost'], 'Challenged another team', $match['u2'], $match['u'], $match['u2'], 1);
		update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), $credits_profit, TIMENOW);
	}	
	$teamids = implode(",", $teamids);
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
		SET accepted = '1'
		WHERE id = '$id'
			AND u2 IN ($teamids)
	");
	$vbulletin->url = "ladders.php?do=challenges&mid=".$id."#match".$id;
	eval(print_standard_redirect('redirect_acceptchal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'reject')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id) {
			$errormessage = $vbphrase[error_invalid_challenge];
			eval(standard_error($errormessage));
		}
	$u2 = $thisuserid;
	$match = $vbulletin->db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladder_games
		WHERE id='$id' AND u2='$u2' AND accepted = '0' AND finished = '0' AND pot = '0'
	");
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET accepted = -1, finished = 1 WHERE id=$id AND u2=$u2 AND finished = 0 AND accepted = 0");
	/*PM*/
	$uinfo = fetch_userinfo($match['u']);
	if ($uinfo)
	{
		$title = $vbphrase['ladder_new_chll_rejected'];
		$recipients = $uinfo['username'];
		$message = construct_phrase($vbphrase['ladder_x_rejected_challenge'], $thisusername);
		$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
		$pmdm->set('fromuserid', $thisuserid);
		$pmdm->set('fromusername', $thisusername);
		$pmdm->set('title', $title);
		$pmdm->set('message', $message);
		$pmdm->set_recipients($recipients, $botpermissions);
		$pmdm->set('dateline', TIMENOW); 
		$pmdm->overridequota = true;
		$errors = $pmdm->errors;
		if ($errors) {
			foreach ($errors as $error) {
				$errorss .= $error. "<br />";
			}
			$errormessage = $errorss;
			eval(standard_error($errormessage));
		}
		$pmdm->save();
		unset($pmdm);
	}
	/*PM*/
	$vbulletin->url = "ladders.php?do=challenges";
	eval(print_standard_redirect('redirect_rejectchal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'teamreject')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_challenge];
		eval(standard_error($errormessage));
	}
	$userid = $thisuserid;
	$teamids = array();
	$teams = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_members JOIN " . TABLE_PREFIX . "tmnt_teams on " . TABLE_PREFIX . "tmnt_members.teamid = " . TABLE_PREFIX . "tmnt_teams.teamid WHERE " . TABLE_PREFIX . "tmnt_members.leader=1 AND " . TABLE_PREFIX . "tmnt_members.userid=$userid");
		while($teamm = $vbulletin->db->fetch_array($teams)){
			$teamid = $teamm['teamid'];
			$teamids = array_merge((array)$teamid, $teamids);
	}
	$teamids = implode(",", $teamids);
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET accepted = -1, finished = 1 WHERE id=$id AND agree_u = 0 AND agree_u2 = 0 AND score_u = 0 AND score_u2 = 0 AND u2 IN ($teamids)");
	$vbulletin->url = "ladders.php?do=challenges";
	eval(print_standard_redirect('redirect_rejectchal'));
}

// #############################################################################

if ($_REQUEST['do'] == 'submitscore')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id)
		{
			$errormessage = $vbphrase[error_invalid_challenge];
			eval(standard_error($errormessage));
		}
	$teamids_array = array();
	$userid = $thisuserid;
	$games = $vbulletin->db->query_first("SELECT ladders.pot AS pot FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders ON(games.lid=ladders.id) WHERE games.id=$id");
	if ($games['pot'] == 1)
	{
		$team = true;
		$teamids = array();
		$teams = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_members AS members JOIN " . TABLE_PREFIX . "tmnt_teams AS teams ON(members.teamid = teams.teamid) WHERE members.leader=1 AND members.userid=$userid");
		while($teamm = $vbulletin->db->fetch_array($teams))
		{
			$teamid = $teamm['teamid'];
			$teamids = array_merge((array)$teamid, $teamids);
		}
		$teamids_array = $teamids;
		$teamids = implode(",", $teamids);
	}
	else
	{
		$team = false;
		$teamids_array = array();
	}
	$rowno = 0;
	$game = $vbulletin->db->query_first("
		SELECT g.*, l.title AS laddertitle, l.tmin, l.tmax
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
			ON (l.id = g.lid)
		WHERE 
			" . (!$team ? "(g.u=$userid OR u2=$userid)" : "(g.u IN (".$teamids.") OR g.u2 IN (".$teamids.") )" ) . "
			AND g.id=$id 
			AND g.finished=0 
			AND g.accepted=1
	");
	if (!$game)
	{
		print_no_permission();
	}
	if ($game['u'] == $thisuserid OR in_array($game['u'], $teamids_array))
	{
		$game['screen'] = $game['screen_u'];
	}
	elseif ($game['u2'] == $thisuserid OR in_array($game['u2'], $teamids_array))
	{
		$game['screen'] = $game['screen_u2'];
	}
	if (!$game['pot'])
	{
		$game['uinfo'] = fetch_userinfo($game['u']);
		$game['u2info'] = fetch_userinfo($game['u2']);
	}
	else 
	{
		$game['uinfo'] = fetch_teaminfo($game['u']);
		$game['u2info'] = fetch_teaminfo($game['u2']);
	}
	if ($game['pot'] && !$game['squadsize'] && !$_REQUEST['redirect'])
	{
		if ($game['tmin']==$game['tmax'] && $game['tmin'] > 0)
		{
			$game['squadsize'] = $game['tmin'];
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET squadsize = '".$game['tmin']."' WHERE id = '$id' ");
			$red = 1;
		}
		else
		{
			$game['squadsize'] = min($game['uinfo']['noplayers'], $game['u2info']['noplayers']);
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET squadsize = '".$game['squadsize']."' WHERE id = '$id' ");
				//print_r($game);
			if ($game['squadsize'] == $game['uinfo']['noplayers'])
			{
				$ma = array();
				$ms = $vbulletin->db->query_read("
					SELECT *
					FROM " . TABLE_PREFIX . "tmnt_members 
					WHERE teamid = '".$game['uinfo']['teamid']."'
				");
				while($m = $vbulletin->db->fetch_array($ms))
				{
					$ma[] = $m['userid'];
				}
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
					SET u_squad = '".$vbulletin->db->escape_string(implode(',',$ma))."'
					WHERE id = '".$id."'
				");
			}
			if ($game['squadsize'] == $game['u2info']['noplayers'])
			{
				$ma = array();
				$ms = $vbulletin->db->query_read("
					SELECT *
					FROM " . TABLE_PREFIX . "tmnt_members 
					WHERE teamid = '".$game['u2info']['teamid']."'
				");
				while($m = $vbulletin->db->fetch_array($ms))
				{
					$ma[] = $m['userid'];
				}
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
					SET u2_squad = '".$vbulletin->db->escape_string(implode(',',$ma))."'
					WHERE id = '".$id."'
				");
			}
			$red = 1;
		}
	}
	elseif (!$_REQUEST['redirect'])
	{
		if ($game['pot'] && !$game['u_squad'])
		{
			if ($game['squadsize'] == $game['uinfo']['noplayers'])
			{
				$ma = array();
				$ms = $vbulletin->db->query_read("
					SELECT *
					FROM " . TABLE_PREFIX . "tmnt_members 
					WHERE teamid = '".$game['uinfo']['teamid']."'
				");
				while($m = $vbulletin->db->fetch_array($ms))
				{
					$ma[] = $m['userid'];
				}
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
					SET u_squad = '".$vbulletin->db->escape_string(implode(',',$ma))."'
					WHERE id = '".$id."'
				");
				$red = 1;
			}
		}
		if ($game['pot'] && !$game['u2_squad'])
		{
			if ($game['squadsize'] == $game['u2info']['noplayers'])
			{
				$ma = array();
				$ms = $vbulletin->db->query_read("
					SELECT *
					FROM " . TABLE_PREFIX . "tmnt_members 
					WHERE teamid = '".$game['u2info']['teamid']."'
				");
				while($m = $vbulletin->db->fetch_array($ms))
				{
					$ma[] = $m['userid'];
				}
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
					SET u2_squad = '".$vbulletin->db->escape_string(implode(',',$ma))."'
					WHERE id = '".$id."'
				");
				$red = 1;
			}
		}
	}
	if ($red)
	{
		$vbulletin->url = "ladders.php?do=submitscore&id=".$id."&redirect=1";
		eval(print_standard_redirect('Redirecting...', 1));
	}
	$rowno++;
	$game['squad_scores'] = unserialize($game['squad_scores']);
	$squads = array();
	if (file_exists(DIR . '/tll_modules/tll_squadscores.php'))
	{
		require_once('./tll_modules/tll_squadscores.php');
		$squads = fetch_squads($game);
	}
	$templater = vB_Template::create('tmnt_ladder_submitscore');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('team', $team);
		$templater->register('rowno', $rowno);
		$templater->register('game', $game);
		$templater->register('squads', $squads);
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax']==1)
	{
		$tlhtml = str_replace('onclick="window.location.href=\'ladders.php?do=challenges\'"','onclick="close_tll_popup();"',$tlhtml);
		print_r($tlhtml);
		exit;
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?do=challenges' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladder_chlls'],
		'' => construct_phrase($vbphrase['ladder_submittingscore'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'adminsubmitscore')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$from = $vbulletin->input->clean_gpc('g', 'from', TYPE_NOHTML);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_challenge];
		eval(standard_error($errormessage));
	}
	$games = $vbulletin->db->query_first("
		SELECT ladders.pot AS pot, ladders.title
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders 
			ON(games.lid=ladders.id)
		WHERE games.id = '$id'
	");
	$team = false;
	if ($games['pot'])
	{
		$team = true;
	}
	$userid = $thisuserid;
	$game = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id='$id' AND accepted='1'");
	if (!$game)
	{
		$errormessage = $vbphrase['error_invalid_challenge'];
		eval(standard_error($errormessage));
	}
	if ($game['pot'])
	{
		$game['uinfo'] = fetch_teaminfo($game['u']);
		$game['u2info'] = fetch_teaminfo($game['u2']);
	}
	else 
	{
		$game['uinfo'] = fetch_userinfo($game['u']);
		$game['u2info'] = fetch_userinfo($game['u2']);
	}
	$templater = vB_Template::create('tmnt_ladder_adminsubmitscore');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('from', $from);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('team', $team);
		$templater->register('games', $games);
		$templater->register('game', $game);
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax']==1)
	{
		$tlhtml = str_replace("history.go(-1);",'close_tll_popup();',$tlhtml);
		print_r($tlhtml);
		exit;
	}
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders']
	);
	if ($from == 'ladder')
	{
		$navbits["ladders.php?do=view&amp;id=$game[lid]&amp;sh=2"] = $games['title'];
	}
	else
	{
		$navbits['ladders.php?do=reportedchallenges'] = $vbphrase['ladder_reported_matches'];
	}
	$navbits[''] = construct_phrase($vbphrase['ladder_submittingscore']);
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'adminsubmitscores')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$from = $vbulletin->input->clean_gpc('g', 'from', TYPE_NOHTML);
	$round = $vbulletin->input->clean_gpc('g', 'round', TYPE_UINT);
	if ($round > 0)
	{
		$where_cond .= " AND games.round = '$round' ";
	}
	$group = $vbulletin->input->clean_gpc('g', 'group', TYPE_UINT);
	if ($group > 0)
	{
		$where_cond .= " AND games.group = '$group' ";
	}
	if (!$lid)
	{
		$errormessage = $vbphrase[error_invalid_challenge];
		eval(standard_error($errormessage));
	}
	//, uu.username AS u2_username
	$games = $vbulletin->db->query_read("
		SELECT games.*, ladder.pot AS pot, ladder.title, IF (ladder.pot = 0, u.username, t.teamname) AS u_username, IF (ladder.pot = 0, uu.username, tt.teamname) AS u2_username
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladder
			ON (games.lid = ladder.id)
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (games.u = u.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS uu
			ON (games.u2 = uu.userid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
			ON (games.u = t.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS tt
			ON (games.u2 = tt.teamid)
		WHERE games.lid = '$lid' $where_cond
	");
	while($game = $vbulletin->db->fetch_array($games))
	{
		$game['uinfo'] = array('userid'=>$game['u'],'username'=>$game['u_username']);
		$game['u2info'] = array('userid'=>$game['u2'],'username'=>$game['u2_username']);
		$array[] = $game;
	}
	/*print_r($array);
	exit;
	$team = false;
	if ($games['pot'])
	{
		$team = true;
	}
	$userid = $thisuserid;
	$game = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id='$id' AND finished='0' AND accepted='1'");
	if (!$game)
	{
		$errormessage = $vbphrase['error_invalid_challenge'];
		eval(standard_error($errormessage));
	}
	if ($game['pot'])
	{
		$game['uinfo'] = fetch_teaminfo($game['u']);
		$game['u2info'] = fetch_teaminfo($game['u2']);
	}
	else 
	{
		$game['uinfo'] = fetch_userinfo($game['u']);
		$game['u2info'] = fetch_userinfo($game['u2']);
	}*/
	$templater = vB_Template::create('tmnt_ladder_adminsubmitscores');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('from', $from);
		$templater->register('id', $id);
		$templater->register('lid', $lid);
		$templater->register('team', $team);
		$templater->register('games', $games);
		$templater->register('game', $game);
		$templater->register('array', $array);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders']
	);
	if ($from == 'ladder')
	{
		$navbits["ladders.php?do=view&amp;id=$game[lid]&amp;sh=2"] = $games['title'];
	}
	else
	{
		$navbits['ladders.php?do=reportedchallenges'] = $vbphrase['ladder_reported_matches'];
	}
	$navbits[''] = construct_phrase($vbphrase['ladder_submittingscores']);
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'killmatch')
{
	if (!$tmntp['ladder_superuser'])
	{
		print_no_permission();
	}
	$mid = $vbulletin->input->clean_gpc('g', 'mid', TYPE_UINT);
	if (!$mid)
	{
		$errormessage = $vbphrase['error_invalid_match'];
        eval(standard_error($errormessage));
	}
	$matchinfo = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id = '$mid'");
	$lid = $matchinfo['lid'];
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '".$matchinfo['lid']."' ");
	function check_reset_ladder_player($lid, $userid, $ladder)
	{
		global $vbulletin;
		$player = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '".$lid."' AND userid = '".$userid."' ");
		if ($player)
		{
			$player['tm'] = $player['wins']+$player['draws']+$player['loses'];
			if ($player['tm'] == 0 && $player['rank'] > 0)
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET rank = '".$ladder['startingelo']."', wstreak = 0, lstreak = 0, longeststreak = 0 WHERE lid = '$lid' AND userid = '".$userid."' ");
			}
		}
		return true;
	}
	if ($matchinfo['finished'])
	{
		$player_u = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '".$lid."' AND userid = '".$matchinfo['u']."' ");
		$player_u2 = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '".$lid."' AND userid = '".$matchinfo['u2']."' ");
		list($oldrank_u, $oldrank_u2) = calc_reverse_elo(0, 0, $matchinfo['score_u'], $matchinfo['score_u2'], '', '', $lid, $matchinfo['u'], $matchinfo['u2']);
		if ($matchinfo['score_u'] > $matchinfo['score_u2'])
		{//u won
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET wins = wins - 1, totalpoints = totalpoints - ".$matchinfo['score_u'].", pointsagainst = pointsagainst - ".$matchinfo['score_u2'].", xp = xp - ".$ladder['xp_win'].", challenges = challenges - 1, rank = '$oldrank_u' ".($player_u['wstreak'] > 0 ? ", wstreak = wstreak - 1 " : "")." WHERE lid = '$lid' AND userid = '".$matchinfo['u']."'");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET loses = loses - 1, totalpoints = totalpoints - ".$matchinfo['score_u2'].", pointsagainst = pointsagainst - ".$matchinfo['score_u'].", xp = xp - ".$ladder['xp_lose'].", rank = '$oldrank_u2' ".($player_u2['lstreak'] > 0 ? ", lstreak = lstreak - 1 " : "")." WHERE lid = '$lid' AND userid = '".$matchinfo['u2']."'");
		}
		elseif ($matchinfo['score_u'] < $matchinfo['score_u2'])
		{//u2 won
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET loses = loses - 1, totalpoints = totalpoints - ".$matchinfo['score_u'].", pointsagainst = pointsagainst - ".$matchinfo['score_u2'].", xp = xp - ".$ladder['xp_lose'].", challenges = challenges - 1, rank = '$oldrank_u' ".($player_u['lstreak'] > 0 ? ", lstreak = lstreak - 1 " : "")." WHERE lid = '$lid' AND userid = '".$matchinfo['u']."' ");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET wins = wins - 1, totalpoints = totalpoints - ".$matchinfo['score_u2'].", pointsagainst = pointsagainst - ".$matchinfo['score_u'].", xp = xp - ".$ladder['xp_win'].", rank = '$oldrank_u2' ".($player_u2['wstreak'] > 0 ? ", wstreak = wstreak - 1 " : "")." WHERE lid = '$lid' AND userid = '".$matchinfo['u2']."' ");
		}
		else
		{//draw
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET draws = draws - 1, totalpoints = totalpoints - ".$matchinfo['score_u'].", pointsagainst = pointsagainst - ".$matchinfo['score_u2'].", xp = xp - ".$ladder['xp_draw'].", challenges = challenges - 1, rank = '$oldrank_u' WHERE lid = '$lid' AND userid = '".$matchinfo['u']."'");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET draws = draws - 1, totalpoints = totalpoints - ".$matchinfo['score_u2'].", pointsagainst = pointsagainst - ".$matchinfo['score_u'].", xp = xp - ".$ladder['xp_draw'].", rank = '$oldrank_u2' WHERE lid = '$lid' AND userid = '".$matchinfo['u2']."'");
		}
	}
	check_reset_ladder_player($lid, $matchinfo['u'], $ladder);
	check_reset_ladder_player($lid, $matchinfo['u2'], $ladder);
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_mcs WHERE mid=$mid");
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id=$mid");
	$from = $vbulletin->input->clean_gpc('g', 'from', TYPE_STR);
	if (!$sh)
	{
		$sh = 1;
	}
	$vbulletin->url = "ladders.php?do=view&id=".$matchinfo['lid']."&sh=$sh";
	eval(print_standard_redirect('redirect_killmatch'));
}

// #############################################################################

if ($_REQUEST['do'] == 'killmc')
{
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase['error_invalid_comment'];
        eval(standard_error($errormessage));
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$mid = $vbulletin->input->clean_gpc('g', 'mid', TYPE_UINT);
	if (!$mid)
	{
		$errormessage = $vbphrase['error_invalid_match'];
        eval(standard_error($errormessage));
	}
	$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_UINT);
	$u1 = $vbulletin->input->clean_gpc('g', 'u1', TYPE_UINT);
	$u2 = $vbulletin->input->clean_gpc('g', 'u2', TYPE_UINT);
	$from = $vbulletin->input->clean_gpc('g', 'from', TYPE_NOHTML);
	if ($tmntp['candelmcomments'])
	{
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_mcs WHERE id=$id");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET comments = comments - 1 WHERE id=$mid");
	}
	else
	{
		$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_mcs WHERE id=$id AND userid=$thisuserid");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET comments = comments - 1 WHERE id = $mid");
	}
	if ($from)
	{
		$vbulletin->url = "ladders.php?do=".$from.($from=='search_matches' ? "&id=$lid&u1=$u1&u2=$u2" : "")."&mid=$mid#match$mid";
	}
	else
	{
		$vbulletin->url = "ladders.php?do=view&id=$lid&sh=$sh&mid=$mid#match$mid";
	}
	eval(print_standard_redirect('redirect_killcomment'));
}

// #############################################################################

if ($_POST['do'] == 'insertmc')
{
	if (!$tmntp['canmcomment'])
	{
		print_no_permission();
	}
	if ($vbulletin->userinfo['userid'] == 0)
	{
		print_no_permission();
	}
	$mid = $vbulletin->input->clean_gpc('p', 'mid', TYPE_UINT);
	$u1 = $vbulletin->input->clean_gpc('p', 'u1', TYPE_UINT);
	$u2 = $vbulletin->input->clean_gpc('p', 'u2', TYPE_UINT);
	$dispute = $vbulletin->input->clean_gpc('p', 'dispute', TYPE_BOOL);
		if (!$mid)
		{
			$errormessage = $vbphrase['error_invalid_match'];
        	eval(standard_error($errormessage));
		}
	$lid = $vbulletin->input->clean_gpc('p', 'lid', TYPE_UINT);
		if (!$lid)
		{
			$errormessage = $vbphrase['error_invalid_ladder'];
        	eval(standard_error($errormessage));
		}
	$sh = $vbulletin->input->clean_gpc('p', 'sh', TYPE_UINT);
	$from = $vbulletin->input->clean_gpc('p', 'from', TYPE_NOHTML);
	$userid = $thisuserid;
	$username = $thisusername;
	$comment = $vbulletin->input->clean_gpc('p', 'comment', TYPE_NOHTML);
	if (!$comment)
	{
		$errormessage = $vbphrase['error_invalid_message'];
		eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_mcs
		(mid, comment, userid, username, dateline, dispute)
		VALUES ('".$mid."', '".$vbulletin->db->escape_string($comment)."', '".$userid."',  '".$vbulletin->db->escape_string($username)."', ".TIMENOW.",  '".$vbulletin->db->escape_string($dispute)."' )
		");
	$id = $vbulletin->db->insert_id();
	if ($dispute)
	{
		$vbulletin->url = "ladders.php?do=reportedmatches&mid=$mid#match$mid";
	}
	elseif ($from)
	{
		$vbulletin->url = "ladders.php?do=".$from.($from=='search_matches' ? "&id=$lid&u1=$u1&u2=$u2" : "")."&mid=$mid#match$mid";
	}
	elseif ($sh)
	{
		$vbulletin->url = "ladders.php?do=view&id=$lid&sh=$sh&mid=$mid#match$mid";
	}
	else
	{
		$vbulletin->url = "ladders.php?do=view&id=$lid&sh=1&mid=$mid#match$mid";
	}
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET comments = comments + 1 WHERE id = $mid");
	eval(print_standard_redirect('redirect_tmntcomment'));
}

// #############################################################################

if ($_POST['do'] == 'insertscore')
{
	if (!$tmntp['canjoinladder'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'u'             => TYPE_UINT,
		'u2'            => TYPE_UINT,
		'lid'           => TYPE_UINT,
		'id'            => TYPE_UINT,
		'orig_score_u'  => TYPE_UINT,
		'orig_score_u2' => TYPE_UINT,
		'score_u'       => TYPE_UINT,
		'score_u2'      => TYPE_UINT,
		'agree_u'       => TYPE_UINT,
		'agree_u2'      => TYPE_UINT,
		'pot'           => TYPE_UINT,
		'squadscore'    => TYPE_ARRAY_UINT,
		'screen'        => TYPE_NOHTML
	));
	$id            = $vbulletin->GPC['id'];
	$lid            = $vbulletin->GPC['lid'];
	$u             = $vbulletin->GPC['u'];
	$u2            = $vbulletin->GPC['u2'];
	$agree_u       = $vbulletin->GPC['agree_u'];
	$agree_u2      = $vbulletin->GPC['agree_u2'];
	$userid        = $thisuserid;
	$score_u       = $vbulletin->GPC['score_u'];
	$score_u2      = $vbulletin->GPC['score_u2'];
	$origscore_u   = $vbulletin->GPC['orig_score_u'];
	$origscore_u2  = $vbulletin->GPC['orig_score_u2'];
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$lid' ");
	/*if (file_exists('tll_modules/tll_autoscoreconfirm.php')&& $ladder['autoscoreconfirm'])
	{
		$agree_u = $agree_u2 = 1;
	}*/
	$lid           = $vbulletin->GPC['lid'];
	$pot           = $vbulletin->GPC['pot'];
	$screen        = $vbulletin->GPC['screen'];
	$upload = $vbulletin->input->clean_gpc('f', 'upload', TYPE_FILE);
	$uploadDir = 'images/ladder_images/';
	$fileName = $upload['name'];
	$tmpName  = $upload['tmp_name'];
	function img_resize($tmpname, $width, $height, $save_dir, $save_name)
	{
		$save_dir .= ( substr($save_dir,-1) != "/") ? "/" : "";
		$gis       = GetImageSize($tmpname);
		$type       = $gis[2];
		switch($type)
		{
			case "1": $imorig = imagecreatefromgif($tmpname); break;
			case "2": $imorig = imagecreatefromjpeg($tmpname);break;
			case "3": $imorig = imagecreatefrompng($tmpname); break;
			default:  $imorig = imagecreatefromjpeg($tmpname);
		}
        $x = imageSX($imorig);
        $y = imageSY($imorig);
		$c = $x;
		$d = $y;
		if (($d > $height) OR ($c > $width))
		{
			$a = $d/$height;
			$b = $c/$width;
			if ($a > $b)
			{
				$r  = $d/$height;
				$d = $d/$r;
				$c  = $c/$r;
			}
			else
			{
				$r  = $c/$width;
				$d = $d/$r;
				$c  = $c/$r;
			}
		}
        $im = imagecreate($c, $d);
        $im = imagecreatetruecolor($c,$d);
		if (imagecopyresampled($im,$imorig,0,0,0,0,$c,$d,$x,$y))
		{
			if (imagejpeg($im, $save_dir.$save_name))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
    }
	if ($tmpName != '')
	{
		if ($teamlogo['error'])
		{
			$errormessage = $vbphrase['error_uploading_team_logo'].$teamlogo['error'];
			eval(standard_error($errormessage));
		}
		else
		{
			$randName = md5(rand() * time());
			$ext      = substr(strrchr($fileName, "."), 1);
			$imgexts  = array('jpg', 'jpeg', 'png', 'gif');
			if (in_array(strtolower($ext), $imgexts)) 
			{
				@img_resize($tmpName, 800, 600, $uploadDir, $randName.".jpg");
				$filePath = $uploadDir.$randName.".jpg";
				if (file_exists($filePath))
				{
					$screen = ($screen ? "$screen;" : "").$vbulletin->options['bburl']."/".$filePath;
				}
			}
			
		}
	}
	$games = $vbulletin->db->query_first("
		SELECT games.*, ladders.pot, ladders.xp_win, ladders.xp_draw, ladders.xp_lose
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON(games.lid=ladders.id)
		WHERE games.id = '$id'
	");
	$player_u = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$lid' AND userid = '$u' ");
	$player_u2 = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$lid' AND userid = '$u2' ");
	if ($games['pot'])
	{
		$team = true;
		$pot = 1;
		$teamids = array();
		$teams = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_members JOIN " . TABLE_PREFIX . "tmnt_teams on " . TABLE_PREFIX . "tmnt_members.teamid = " . TABLE_PREFIX . "tmnt_teams.teamid WHERE " . TABLE_PREFIX . "tmnt_members.leader=1 AND " . TABLE_PREFIX . "tmnt_members.userid=$userid");
		while($teamm = $vbulletin->db->fetch_array($teams))
		{
			$teamid = $teamm['teamid'];
			$teamids = array_merge((array)$teamid, $teamids);
		}
		$eteamids = $teamids;
		$teamids = implode(",", $teamids);
		if (!in_array($u, $eteamids) AND !in_array($u2, $eteamids))
		{
			print_no_permission();
		}
		if (file_exists(DIR . '/tll_modules/tll_squadscores.php'))
		{
			$scores_hold = array();
			$vbulletin->GPC['squadscore'];
			foreach ($vbulletin->GPC['squadscore'] AS $key => $value)
			{
				list($a, $b) = explode('_',$key);
				
				if ($a == 'u')
				{
					$add_score_u += $value;
				}
				elseif ($a == 'u2')
				{
					$add_score_u2 += $value;
				}
				else
				{
					continue;
				}
				$scores_hold["$a"]["$b"] = $value;
			}
			if ($add_score_u > 0 && $add_score_u != $score_u)
			{
				$uinfo = fetch_teaminfo($u);
				$errormessage = "You have submitted team scores for ".$uinfo[teamname]." adding up to $add_score_u which does not match their score ($score_u). <br /><br /> Please press back and rectify this error.";
				eval(standard_error($errormessage));
			}
			if ($add_score_u2 > 0 && $add_score_u2 != $score_u2)
			{
				$u2info = fetch_teaminfo($u2);
				$errormessage = "You have submitted team scores for ".$u2info[teamname]." adding up to $add_score_u2 which does not match their score ($score_u2). <br /><br /> Please press back and rectify this error.";
				eval(standard_error($errormessage));
			}
			if ($add_score_u == 0 && $add_score_u2 == 0)
			{
				$squad_scores = '';
			}
			else
			{
				$squad_scores = array();
				if ($add_score_u == $score_u)
				{
					$squad_scores['u'] = $scores_hold['u'];
				}
				if ($add_score_u2 == $score_u2)
				{
					$squad_scores['u2'] = $scores_hold['u2'];
				}
				$squad_scores = serialize($squad_scores);
			}
		}
		if ($origscore_u == $score_u AND $origscore_u2 == $score_u2)
		{
			if (in_array($u, $eteamids))
			{
				if ($agree_u2 == 1) {
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, finished = 1, screen_u = '".$vbulletin->db->escape_string($screen)."', squad_scores = '".$vbulletin->db->escape_string($squad_scores)."' WHERE id=$id ");
					$finished = true;
				} elseif ($agree_u2 == 0) {
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, screen_u = '".$vbulletin->db->escape_string($screen)."', squad_scores = '".$vbulletin->db->escape_string($squad_scores)."' WHERE id=$id ");
					$finished = false;
				}
			} 
			if (in_array($u2, $eteamids) AND !$finished)
			{
				if ($agree_u == 1) {
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u2 = 1, finished = 1, screen_u2 = '".$vbulletin->db->escape_string($screen)."', squad_scores = '".$vbulletin->db->escape_string($squad_scores)."' WHERE id=$id ");
					$finished = true;
				} elseif ($agree_u == 0) {
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u2 = 1, screen_u2 = '".$vbulletin->db->escape_string($screen)."', squad_scores = '".$vbulletin->db->escape_string($squad_scores)."' WHERE id=$id ");
					$finished = false;
				}
			}
		}
		elseif ($origscore_u != $score_u OR $origscore_u2 != $score_u2)
		{
			if (in_array($u, $eteamids)) {
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, agree_u2 = 0, score_u = $score_u, score_u2 = $score_u2, screen_u2 = '".$vbulletin->db->escape_string($screen)."', squad_scores = '".$vbulletin->db->escape_string($squad_scores)."' WHERE id=$id ");
					$finished = false;
			} 
			if (in_array($u2, $eteamids)) {
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 0, agree_u2 = 1, score_u = $score_u, score_u2 = $score_u2, screen_u2 = '".$vbulletin->db->escape_string($screen)."', squad_scores = '".$vbulletin->db->escape_string($squad_scores)."' WHERE id=$id ");
					$finished = false;
			}
		}
	}
	else 
	{
		$team = false;
		if ($userid != $u AND $userid != $u2)
		{
			print_no_permission();
		}
		if ($origscore_u == $score_u AND $origscore_u2 == $score_u2) {
			if ($userid == $u)
			{
				if ($agree_u2 == 1)
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, finished = 1, screen_u = '".$vbulletin->db->escape_string($screen)."', dateline_finished = ".TIMENOW." WHERE id=$id ");
					$finished = true;
				}
				elseif ($agree_u2 == 0)
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, screen_u = '".$vbulletin->db->escape_string($screen)."' WHERE id=$id ");
					$finished = false;
				}
			} 
			elseif ($userid == $u2) 
			{
				if ($agree_u == 1)
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u2 = 1, finished = 1, screen_u2 = '".$vbulletin->db->escape_string($screen)."', dateline_finished = ".TIMENOW." WHERE id=$id ");
					$finished = true;
				}
				elseif ($agree_u == 0)
				{
					$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u2 = 1, screen_u2 = '".$vbulletin->db->escape_string($screen)."' WHERE id=$id ");
					$finished = false;
				}
			}
		}
		elseif ($origscore_u != $score_u OR $origscore_u2 != $score_u2)
		{
			if ($origscore_u > 0 || $origscore_u2 > 0)
			{
				$sql = ", flag = '$userid' ";
				$flag = true;
				//dominic90
			}
			if ($userid == $u) 
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, agree_u2 = 0, score_u = $score_u, score_u2 = $score_u2, screen_u = '".$vbulletin->db->escape_string($screen)."'$sql WHERE id=$id ");
				$finished = false;
			} 
			elseif ($userid == $u2) 
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 0, agree_u2 = 1, score_u = $score_u, score_u2 = $score_u2, screen_u2 = '".$vbulletin->db->escape_string($screen)."'$sql WHERE id=$id ");
				$finished = false;
		}
		}
	}
	$comment = $vbulletin->input->clean_gpc('p', 'comment', TYPE_NOHTML);
	if ($comment)
	{
		$vbulletin->db->query_write("
			INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_mcs
				(mid, comment, userid, username, dateline, dispute)
			VALUES ('".$id."', '".$vbulletin->db->escape_string($comment)."', '".$thisuserid."',  '".$vbulletin->db->escape_string($thisusername)."', ".TIMENOW.",  '0')
		");
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET comments = comments + 1 WHERE id = $id");
	}
	if (file_exists(DIR . '/tll_modules/tll_autoscoreconfirm.php') && $ladder['autoscoreconfirm'])
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, agree_u2 = 1, finished = 1 WHERE id=$id ");
		$finished = true;
	}
	if ($finished)
	{
		list($newrank_u, $newrank_u2, $uod_u, $uod_u2, $player_u, $player_u2) = calc_elo($rank_u, $rank_u2, $score_u, $score_u2, $player_u, $player_u2, $lid, $u, $u2);
		if ($score_u > $score_u2)
		{
			$player_u['wstreak']++;
			if ($player_u['wstreak'] >= $player_u['longeststreak']) $player_u['longeststreak'] = $player_u['wstreak'];
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET wins = wins + 1, wstreak = wstreak + 1, lstreak = 0, latime =".TIMENOW.", rank = '$newrank_u', uod = '$uod_u', totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, longeststreak = '$player_u[longeststreak]', xp = xp + " . $games['xp_win'] . ", crown = '".$player_u2['crown']."'
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET loses = loses + 1, wstreak = 0, lstreak = lstreak + 1, latime =".TIMENOW.", rank = $newrank_u2, uod = $uod_u2, totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, xp = xp + " . $games['xp_lose'] . ", crown = 0
				WHERE lid = $lid AND userid = $u2
			");
			if (!$team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_premium.php');		
				process_credits_transaction($u, $games['win_credits'], 'Won challenge against user', $u2, $u);
			}
			elseif ($team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_premium.php');		
				process_credits_transaction($u, $games['win_credits'], 'Won challenge against team', $u2, $u, $u, 1);
			}
		}
		elseif ($score_u == $score_u2)
		{
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET draws = draws + 1, wstreak = 0, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, longeststreak = '$player_u[longeststreak]', xp = xp + " . $games['xp_draw'] . "
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET draws = draws + 1, wstreak = 0, lstreak = 0, latime =".TIMENOW.", rank = '$newrank_u2', uod = '$uod_u2', totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, xp = xp + " . $games['xp_draw'] . "
				WHERE lid = $lid AND userid = $u2
			");
			if (!$team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_premium.php');
				$games['win_credits'] = $games['win_credits'] / 2;
				process_credits_transaction($u, $games['win_credits'], 'Drew challenge against user', $u2, $u);
				process_credits_transaction($u2, $games['win_credits'], 'Drew challenge against user', $u, $u2);
			}
			elseif ($team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_premium.php');
				$games['win_credits'] = $games['win_credits'] / 2;
				process_credits_transaction($u, $games['win_credits'], 'Drew challenge against team', $u2, $u, $u, 1);
				process_credits_transaction($u2, $games['win_credits'], 'Drew challenge against team', $u, $u2, $u2, 1);
			}
		} 
		elseif ($score_u < $score_u2) 
		{
			$player_u2['wstreak']++;
			if ($player_u2['wstreak'] >= $player_u2['longeststreak']) $player_u2['longeststreak'] = $player_u2['wstreak'];
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET loses = loses + 1, wstreak = 0, lstreak = lstreak + 1, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, xp = xp + " . $games['xp_lose'] . ", crown = 0
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET wins = wins + 1, wstreak = wstreak + 1, lstreak = 0, latime =".TIMENOW.", rank = '$newrank_u2', uod = '$uod_u2', totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, longeststreak = '$player_u2[longeststreak]', xp = xp + " . $games['xp_win'] . ", crown = '".$player_u['crown']."'
				WHERE lid = $lid AND userid = $u2
			");
			if (!$team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_premium.php');		
				process_credits_transaction($u2, $games['win_credits'], 'Won challenge against user', $u, $u2);
			}
			elseif ($team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_premium.php');		
				process_credits_transaction($u2, $games['win_credits'], 'Won challenge against team', $u, $u2, $u2, 1);
			}
		}
		else
		{
			$errormessage = $vbphrase['error_fatal_error']." error id: 3928";
			eval(standard_error($errormessage));
		}
			$altered_rank = abs($newrank_u - $player_u['rank']);
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET altered_rank = '$altered_rank' WHERE id=$id ");
	}
	if (!$team)
	{
		if ($u==$thisuserid)
		{
			$opp_userid = $u2;
			$opp = fetch_userinfo($opp_userid);
		}
		elseif ($u2==$thisuserid)
		{
			$opp_userid = $u;
			$opp = fetch_userinfo($opp_userid);
		}
	}
	else
	{
		$teamtext = "".$vbphrase['tmnt_team']." ";
		if (in_array($u, $eteamids))
		{//is u
			$t = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE leader='1' AND teamid = '$u2' AND userid != '$thisuserid'");
			$opp_userid = $t['userid'];
			$opp = fetch_userinfo($opp_userid);
		}
		elseif (in_array($u2, $eteamids))
		{//is u2
			$t = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_members WHERE leader='1' AND teamid = '$u' AND userid != '$thisuserid'");
			$opp_userid = $t['userid'];
			$opp = fetch_userinfo($opp_userid);
		}
	}
	if ($opp)
	{
		if (!$finished)
		{
			$title = $teamtext.$vbphrase['ladder_match_score_submitted'];
			$recipients = $opp['username'];
			$message = construct_phrase($vbphrase['ladder_match_score_submitted_pmtext'], $thisusername, $vbulletin->options['bburl'], $id, $teamtext);
		}
		else
		{
			$title = $teamtext.$vbphrase['ladder_match_score_confirmed'];
			$recipients = $opp['username'];
			$message = construct_phrase($vbphrase['ladder_match_score_confirmed_pmtext'], $thisusername, $vbulletin->options['bburl'], $id, $teamtext);
		}
		$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);
		$pmdm->set('fromuserid', $thisuserid);
		$pmdm->set('fromusername', $thisusername);
		$pmdm->set('title', $title);
		$pmdm->set('message', $message);
		$pmdm->set_recipients($recipients, $botpermissions);
		$pmdm->set('dateline', TIMENOW); 
		$pmdm->overridequota = true;
		$errors = $pmdm->errors;
		if ($errors) {
			foreach ($errors as $error) {
				$errorss .= $error. "<br />";
			}
			$errormessage = $errorss;
			eval(standard_error($errormessage));
		}
		$pmdm->save();
		unset($pmdm);
	}
	if ($flag && $tmntp['canusetickets'])
	{
		$vbulletin->url = "tll_tickets.php?do=new&challengeid=".$games['id']."&ladderid=".$games['lid'];
	}
	elseif ($_REQUEST['from']=='ladder')
	{
		$vbulletin->url = "ladders.php?do=challenges&mid=$id#match$id";
	}
	else
	{
		$vbulletin->url = "ladders.php?do=view&id=$lid&mid=$id#match$id";
	}
	eval(print_standard_redirect('redirect_updatedscore'));
}

// #############################################################################

if ($_REQUEST['do'] == 'admindeletematch')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('g', array(
		'id' => TYPE_UINT,
		'lid' => TYPE_UINT,
		'sh' => TYPE_UINT,
		'from' => TYPE_NOHTML
	));
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id = '" . $vbulletin->GPC['id'] . "'");
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_mcs WHERE mid = '" . $vbulletin->GPC['id'] . "'");
	if ($vbulletin->GPC['from'] == 'ladder')
	{
		$vbulletin->url = "ladders.php?do=view&id=" . $vbulletin->GPC['lid'] . "&sh=" . $vbulletin->GPC['sh'];
	}
	else
	{
		$vbulletin->url = "ladders.php?do=reportedmatches";
	}
	eval(print_standard_redirect('redirect_deletedmatch'));
}

// #############################################################################

if ($_POST['do'] == 'admininsertscores')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'u'             => TYPE_ARRAY_UINT,
		'u2'            => TYPE_ARRAY_UINT,
		'lid'           => TYPE_UINT,
		'pot'           => TYPE_BOOL,
		'id'            => TYPE_ARRAY_UINT,
		'orig_score_u'  => TYPE_ARRAY_UINT,
		'orig_score_u2' => TYPE_ARRAY_UINT,
		'score_u'       => TYPE_ARRAY_UINT,
		'score_u2'      => TYPE_ARRAY_UINT,
		'agree_u'       => TYPE_ARRAY_UINT,
		'agree_u2'      => TYPE_ARRAY_UINT,
		'from'          => TYPE_NOHTML
	));
	$lid = $vbulletin->GPC['lid'];
	$pot = $vbulletin->GPC['pot'];
	$userid = $thisuserid;
	foreach ($vbulletin->GPC['id'] AS $ha => $id)
	{
		$u = $vbulletin->GPC['u']["$ha"];
		$u2 = $vbulletin->GPC['u2']["$ha"];
		$score_u = $vbulletin->GPC['score_u']["$ha"];
		$score_u2 = $vbulletin->GPC['score_u2']["$ha"];
		$agree_u = $vbulletin->GPC['agree_u']["$ha"];
		$agree_u2 = $vbulletin->GPC['agree_u2']["$ha"];
		$countgames = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id=$id AND finished=0 AND accepted=1");
		if ($countgames['countrows'] != 1) 
		{
			continue;
		}
		$games = $vbulletin->db->query_first("
			SELECT games.*, ladders.*
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
				ON(games.lid=ladders.id)
			WHERE games.id = '$id'
		");
		$team = false;
		if ($games['pot'])
		{
			$team = true;
		}
		list($newrank_u, $newrank_u2, $uod_u, $uod_u2, $player_u, $player_u2) = calc_elo($rank_u, $rank_u2, $score_u, $score_u2, $player_u, $player_u2, $lid, $u, $u2);
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, agree_u2 = 1, score_u = $score_u, score_u2 = $score_u2, finished = 1, dateline_finished = ".TIMENOW." WHERE id=$id ");
		if ($score_u > $score_u2) 
		{
			$player_u['wstreak']++;
			if ($player_u['wstreak'] >= $player_u['longeststreak']) $player_u['longeststreak'] = $player_u['wstreak'];
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET wins = wins + 1, wstreak = wstreak + 1, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, longeststreak = $player_u[longeststreak], xp = xp + " . $games['xp_win'] . "
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET loses = loses + 1, wstreak = 0, lstreak = lstreak + 1, latime =".TIMENOW.", rank = $newrank_u2, uod = $uod_u2, totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, xp = xp + " . $games['xp_lose'] . "
				WHERE lid = $lid AND userid = $u2
			");
			if (!$team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_premium.php');		
				process_credits_transaction($u, $games['win_credits'], 'Won challenge against user', $u2, $u);
			}
			elseif ($team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_premium.php');		
				process_credits_transaction($u, $games['win_credits'], 'Won challenge against team', $u2, $u, $u, 1);
			}
		}
		elseif ($score_u == $score_u2) 
		{
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET draws = draws + 1, wstreak = 0, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, longeststreak = $player_u[longeststreak], xp = xp + " . $games['xp_draw'] . "
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET draws = draws + 1, wstreak = 0, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u2, uod = $uod_u2, totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, xp = xp + " . $games['xp_draw'] . "
				WHERE lid = $lid AND userid = $u2
			");
			if (!$team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_premium.php');
				$games['win_credits'] = $games['win_credits'] / 2;
				process_credits_transaction($u, $games['win_credits'], 'Drew challenge against user', $u2, $u);
				process_credits_transaction($u2, $games['win_credits'], 'Drew challenge against user', $u, $u2);
			}
			elseif ($team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_premium.php');
				$games['win_credits'] = $games['win_credits'] / 2;
				process_credits_transaction($u, $games['win_credits'], 'Drew challenge against team', $u2, $u, $u, 1);
				process_credits_transaction($u2, $games['win_credits'], 'Drew challenge against team', $u, $u2, $u2, 1);
			}
		}
		elseif ($score_u < $score_u2)
		{
			$player_u2['wstreak']++;
			if ($player_u2['wstreak'] >= $player_u2['longeststreak']) $player_u2['longeststreak'] = $player_u2['wstreak'];
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET loses = loses + 1, wstreak = 0, lstreak = lstreak + 1, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, xp = xp + " . $games['xp_lose'] . "
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET wins = wins + 1, wstreak = wstreak + 1, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u2, uod = $uod_u2, totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, longeststreak = $player_u2[longeststreak], xp = xp + " . $games['xp_win'] . "
				WHERE lid = $lid AND userid = $u2
			");
			if (!$team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_premium.php');		
				process_credits_transaction($u2, $games['win_credits'], 'Won challenge against user', $u, $u2);
			}
			elseif ($team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_premium.php');		
				process_credits_transaction($u2, $games['win_credits'], 'Won challenge against team', $u, $u2, $u2, 1);
			}
		} 
		else 
		{
			$errormessage = $vbphrase[error_fatal_error];
			eval(standard_error($errormessage));
		}
	}
	if ($vbulletin->GPC['from'] == 'ladder')
	{
		$vbulletin->url = "ladders.php?do=view&id=$lid&sh=2";
	}
	else
	{
		$vbulletin->url = "ladders.php?do=reportedmatches";
	}
	eval(print_standard_redirect('redirect_updatedscore'));
	
}

// #############################################################################

if ($_POST['do'] == 'admininsertscore')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'u'             => TYPE_UINT,
		'u2'            => TYPE_UINT,
		'lid'           => TYPE_UINT,
		'id'            => TYPE_UINT,
		'orig_score_u'  => TYPE_UINT,
		'orig_score_u2' => TYPE_UINT,
		'score_u'       => TYPE_UINT,
		'score_u2'      => TYPE_UINT,
		'agree_u'       => TYPE_UINT,
		'agree_u2'      => TYPE_UINT,
		'from'          => TYPE_NOHTML
	));
	$id            = $vbulletin->GPC['id'];
	$u             = $vbulletin->GPC['u'];
	$u2            = $vbulletin->GPC['u2'];
	$userid        = $thisuserid;
	$score_u       = $vbulletin->GPC['score_u'];
	$score_u2      = $vbulletin->GPC['score_u2'];
	$lid           = $vbulletin->GPC['lid'];
	$player_u = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$lid' AND userid = '$u' ");
	$player_u2 = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '$lid' AND userid = '$u2' ");
	$countgames = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id=$id AND finished=0 AND accepted=1");
	if ($countgames['countrows'] != 1)
	{
		print_no_permission();
	}
	$games = $vbulletin->db->query_first("
		SELECT games.*, ladders.*
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON(games.lid=ladders.id)
		WHERE games.id = '$id'
	");
	$team = false;
	if ($games['pot'])
	{
		$team = true;
	}
	//$games = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = $lid");
	list($newrank_u, $newrank_u2, $uod_u, $uod_u2, $player_u, $player_u2) = calc_elo($rank_u, $rank_u2, $score_u, $score_u2, $player_u, $player_u2, $lid, $u, $u2);
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET agree_u = 1, agree_u2 = 1, score_u = $score_u, score_u2 = $score_u2, finished = 1, dateline_finished = ".TIMENOW." WHERE id=$id ");
		if ($score_u > $score_u2) 
		{
			$player_u['wstreak']++;
			if ($player_u['wstreak'] >= $player_u['longeststreak']) $player_u['longeststreak'] = $player_u['wstreak'];
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET wins = wins + 1, wstreak = wstreak + 1, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, longeststreak = $player_u[longeststreak], xp = xp + " . $games['xp_win'] . ", crown = '".$player_u2['crown']."'
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET loses = loses + 1, wstreak = 0, lstreak = lstreak + 1, latime =".TIMENOW.", rank = $newrank_u2, uod = $uod_u2, totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, xp = xp + " . $games['xp_lose'] . ", crown = 0
				WHERE lid = $lid AND userid = $u2
			");
			if (!$team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_premium.php');		
				process_credits_transaction($u, $games['win_credits'], 'Won challenge against user', $u2, $u);
			}
			elseif ($team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_premium.php');		
				process_credits_transaction($u, $games['win_credits'], 'Won challenge against team', $u2, $u, $u, 1);
			}
		}
		elseif ($score_u == $score_u2) 
		{
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET draws = draws + 1, wstreak = 0, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, longeststreak = $player_u[longeststreak], xp = xp + " . $games['xp_draw'] . "
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET draws = draws + 1, wstreak = 0, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u2, uod = $uod_u2, totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, xp = xp + " . $games['xp_draw'] . "
				WHERE lid = $lid AND userid = $u2
			");
			if (!$team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_premium.php');
				$games['win_credits'] = $games['win_credits'] / 2;
				process_credits_transaction($u, $games['win_credits'], 'Drew challenge against user', $u2, $u);
				process_credits_transaction($u2, $games['win_credits'], 'Drew challenge against user', $u, $u2);
			}
			elseif ($team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_premium.php');
				$games['win_credits'] = $games['win_credits'] / 2;
				process_credits_transaction($u, $games['win_credits'], 'Drew challenge against team', $u2, $u, $u, 1);
				process_credits_transaction($u2, $games['win_credits'], 'Drew challenge against team', $u, $u2, $u2, 1);
			}
		}
		elseif ($score_u < $score_u2)
		{
			$player_u2['wstreak']++;
			if ($player_u2['wstreak'] >= $player_u2['longeststreak']) $player_u2['longeststreak'] = $player_u2['wstreak'];
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET loses = loses + 1, wstreak = 0, lstreak = lstreak + 1, latime =".TIMENOW.", rank = $newrank_u, uod = $uod_u, totalpoints = totalpoints + $score_u, pointsagainst = pointsagainst + $score_u2, xp = xp + " . $games['xp_lose'] . ", crown = 0
				WHERE lid = $lid AND userid = $u
			");
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET wins = wins + 1, wstreak = wstreak + 1, lstreak = 0, latime =".TIMENOW.", rank = $newrank_u2, uod = $uod_u2, totalpoints = totalpoints + $score_u2, pointsagainst = pointsagainst + $score_u, longeststreak = $player_u2[longeststreak], xp = xp + " . $games['xp_win'] . ", crown = '".$player_u['crown']."'
				WHERE lid = $lid AND userid = $u2
			");
			if (!$team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_premium.php');		
				process_credits_transaction($u2, $games['win_credits'], 'Won challenge against user', $u, $u2);
			}
			elseif ($team && $vbulletin->options['tmnt_credit_system'] && $games['win_credits'] > 0)
			{
require_once(DIR . '/includes/functions_tll_premium.php');		
				process_credits_transaction($u2, $games['win_credits'], 'Won challenge against team', $u, $u2, $u2, 1);
			}
		} 
		else 
		{
			$errormessage = $vbphrase[error_fatal_error];
			eval(standard_error($errormessage));
		}
	if ($vbulletin->GPC['from'] == 'ladder')
	{
		$vbulletin->url = "ladders.php?do=view&id=$lid&sh=2";
	}
	else
	{
		$vbulletin->url = "ladders.php?do=reportedmatches";
	}
	eval(print_standard_redirect('redirect_updatedscore'));
}

// #############################################################################

if ($_REQUEST['do'] == 'elorating') 
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	$rank_u = $vbulletin->input->clean_gpc('g', 'rank_u', TYPE_UINT);
	$rank_u2 = $vbulletin->input->clean_gpc('g', 'rank_u2', TYPE_UINT);
	if ($rank_u == 0 && $rank_u2 == 0)
	{
		$rank_u = $rank_u2 = 1000;
	}
	$score_u = $vbulletin->input->clean_gpc('g', 'score_u', TYPE_UINT);
	$score_u2 = $vbulletin->input->clean_gpc('g', 'score_u2', TYPE_UINT);
	list($newrank_u, $newrank_u2, $uod_u, $uod_u2, $player_u, $player_u2) = calc_elo($rank_u, $rank_u2, $score_u, $score_u2, 1, 1, 0, 0, 0);
	$e = array();
	$e['e_u'] = $newrank_u - $rank_u;
	if ($e['e_u']<0)
	{
		$e['e_u'] = "<span style=\"color: #FF0000; font-weight: bold;\">" . $e['e_u'] . "</span>";
	}
	else
	{
		$e['e_u'] = "<span style=\"color:  #00611C; font-weight: bold;\">+" . $e['e_u'] . "</span>";
	}
	$e['e_u2'] = $newrank_u2 - $rank_u2;
	if ($e['e_u2']<0)
	{
		$e['e_u2'] = "<span style=\"color: #FF0000; font-weight: bold;\">" . $e['e_u2'] . "</span>";
	}
	else
	{
		$e['e_u2'] = "<span style=\"color:  #00611C; font-weight: bold;\">+" . $e['e_u2'] . "</span>";
	}
	$templater = vB_Template::create('tmnt_ladder_elorating');
		$templater->register('tmntp', $tmntp);
		$templater->register('score_u', $score_u);
		$templater->register('score_u2', $score_u2);
		$templater->register('rank_u', $rank_u);
		$templater->register('rank_u2', $rank_u2);
		$templater->register('newrank_u', $newrank_u);
		$templater->register('newrank_u2', $newrank_u2);
		$templater->register('e', $e);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => construct_phrase($vbphrase['ladder_elorating_calc'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'editrules')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id'");
	if (!$ladder)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$ladder['description'] = explode('[rules]',$ladder['description']);
	$ladder['rules'] = $ladder['description']['1'];
	$ladder['description'] = $ladder['description']['0'];
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar($ladder['rules'], 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar($ladder['rules']);
	}
	$templater = vB_Template::create('tmnt_ladder_editrules');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id='.$id . '' => $title,
		'' => construct_phrase($vbphrase['tmnt_editrules'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'updatecolors')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$vbulletin->input->clean_array_gpc('p', array(
		'lid' => TYPE_UINT,
		'id' => TYPE_ARRAY_UINT,
		'from' => TYPE_ARRAY_UINT,
		'to' => TYPE_ARRAY_UINT,
		'color' => TYPE_ARRAY_NOHTML,
		'delete' => TYPE_ARRAY_BOOL,
	));
	$lid = $vbulletin->GPC['lid'];
	if (!$lid)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$ladders = $ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$lid'");
	if (!$ladder)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	foreach ($vbulletin->GPC['id'] AS $hash => $id)
	{
		$from = $vbulletin->GPC['from']["$hash"];
		$to = $vbulletin->GPC['to']["$hash"];
		$color = $vbulletin->GPC['color']["$hash"];
		$delete = $vbulletin->GPC['delete']["$hash"];
		if ($delete)
		{
			$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_leaguecolors WHERE `lid` = '$lid' AND `id` = '$id' ");
		}
		elseif ($id)
		{
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_leaguecolors
				SET `from` = '$from',
					`to` = '$to',
					`color` = '".$vbulletin->db->escape_string($color)."'
				WHERE lid = '$lid' AND id = '$id'
			");
		}
		elseif ($color)
		{
			$vbulletin->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "tmnt_leaguecolors
					(lid, " . TABLE_PREFIX . "tmnt_leaguecolors.from, " . TABLE_PREFIX . "tmnt_leaguecolors.to, color)
				VALUES ('".$lid."', '".$from."', '".$to."', '".$vbulletin->db->escape_string($color)."')
			");
		}
	}
	$vbulletin->url = "ladders.php?do=editcolors&lid=$lid";
	eval(print_standard_redirect('redirect_updateladder'));
}

// #############################################################################

if ($_REQUEST['do'] == 'editcolors')
{
	require_once('./tll_modules/tll_editcolors.php');
	if (!$tmntp['caneditladder'] && $tmntp['caneditcolors'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	if (!$lid)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$ladders = $ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$lid'");
	if (!$ladder)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$array = array();
	$lc_query = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_leaguecolors
		WHERE lid='$lid'
	");
	$i = 0;
	while($lc = $vbulletin->db->fetch_array($lc_query))
	{
		$i++;
		$lc['i'] = $i;
		$array[] = $lc;
	}
	$array[] = array(
		'id' => '',
		'from' => '',
		'to' => '',
		'color' => '',
		'delete' => '-1',
	);
	$templater = vB_Template::create('tmnt_ladder_editcolors');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('array', $array);
	$tlhtml .= $templater->render();
	if ($_REQUEST['ajax']==1)
	{
		$tlhtml = str_replace("href=\"ladders.php?do=view&amp;id=$lid\"","href=\"javascript://\" onclick=\"close_tll_popup();\"", $tlhtml);
		print_r($tlhtml);
		exit;
	}
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id='.$lid . '' => $ladder['title'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=edit&amp;id='.$lid => construct_phrase($vbphrase['ladder_editing']),
		'' => construct_phrase($vbphrase['ladder_editcolors'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
	exit;
}


// #############################################################################

if ($_REQUEST['do'] == 'edit')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$ladders = $ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id'");
	if (!$ladder)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$title = $ladder['title'];
	$description = $ladder['description'];
	if ($ladder['pot'])
	{
		$team = true;
	} 
	else 
	{
		$team = false;
	}
	if ($ladder['league'])
	{
		$vbphrase['ladder_title'] = $vbphrase['league_title'];
		$vbphrase['ladder_date'] = $vbphrase['league_date'];
		$vbphrase['ladder_editing'] = $vbphrase['league_editing'];
	}
	//print_r($ladder);
	$co_array = unserialize($ladder['chal_options']);
	$co_array[''] = ''; // blank row
	$sticky   = $ladder['sticky'];
	$archive  = $ladder['archive'];
	$catid    = $ladder['catid'];
	if (!$ladder['startingelo'])
	{
		$ladder['startingelo'] = 1000;
	}
	$categories = '<select name="catid" id="catid">';
	if ($vbulletin->options['tmnt_allow_uncat'])
	{
		$categories .= '<option value="0"></option>';
	}
	/*$cats = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_categories
		WHERE tol IN (2,3)
		ORDER BY parentid DESC, displayorder ASC, title ASC
	");
	$carray = array();
	while($cat = $vbulletin->db->fetch_array($cats))
	{*/
	if ($vbulletin->tll_catcache)
	{
		foreach ($vbulletin->tll_catcache AS $cindex => $cat)
		{
			if (!in_array('ladders',$cat['tol']) && !in_array('leagues',$cat['tol']) && !$carray["$cat[catid]"])
			{
				continue;
			}
			if ($cat['parentid'])
			{
				$carray["$cat[parentid]"] .= '<option value="'.$cat['catid'].'"';
				if ($catid == $cat['catid'])
				{
					$carray["$cat[parentid]"] .= ' selected="selected" ';
				}
				$carray["$cat[parentid]"] .= '> - '.$cat['title'].'</option>';
			}
			else 
			{
				$categories .= '<option value="'.$cat['catid'].'"';
				if ($catid == $cat['catid'])
				{
					$categories .= ' selected="selected" ';
				}
				$categories .= '>'.$cat['title'].'</option>';
				$categories .= $carray["$cat[catid]"];
			}
		}
	}
	$categories .= '</select>';
	$squery = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "tmnt_ladders
		WHERE groupid != 0
		ORDER BY groupid ASC
	");
	$seasons = array();
	$lastseason = array();
	while($season = $vbulletin->db->fetch_array($squery))
	{
		if ($season['groupid'] != $lastseason['groupid'])
		{
			$season['optgroup'] = true;
			$season['optgroupid'] = ++$optgroup;
		}
		if ($season['groupid'] == $ladder['groupid'] && !$selectedseason)
		{
			$selectedseason = true;
			$season['selected'] = ' selected="selected"';
		}
		$season['lastseason'] = $lastseason['groupid'];
		$seasons[] = $season;
		$lastseason = $season;
	}
	$season = array(
		'optgroupid' => ($optgroup+1),
		'optgroup' => true,
		'title' => $vbphrase['ladder_new_seasons_group'],
		'groupid' => ($lastseason['groupid']+1)
	);
	$seasons[] = $season;
	require_once(DIR . '/includes/functions_editor.php');
	if ($vbulletin->options['simpleversion'] < 414)
	{
		$editorid = construct_edit_toolbar($description, 0, 'nonforum', iif($vbulletin->options['privallowsmilies'], 1, 0));
	}
	else
	{
		$editorid = construct_edit_toolbar($description);
	}
	if (!$ladder['dateline_from'])
	{
		$ladder['dateline_from'] = $ladder['cr_time'];
	}
	if (!$ladder['dateline_to'])
	{
		$ladder['dateline_to'] = TIMENOW + 2592000;
	}
	list ($timezoneoptions, $from_day, $from_monthselected, $from_yearbits, $user_from_time, $dstchecked, $show) = tmnt_dateline_to_fields($ladder['dateline_from'], $ladder['utc'], $ladder['dst'], $show);
	list ($timezoneoptions, $to_day, $to_monthselected, $to_yearbits, $user_to_time, $dstchecked, $show) = tmnt_dateline_to_fields($ladder['dateline_to'], $ladder['utc'], $ladder['dst'], $show);
	$templater = vB_Template::create('tmnt_date_time');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('time', $user_from_time);
		$templater->register('day', $from_day);
		$templater->register('monthselected', $from_monthselected);
		$templater->register('yearbits', $from_yearbits);
		$templater->register('rangeid', 0);
		$templater->register('prefix', 'from');
	$ladder['startdatehtml'] = $templater->render();
	$templater = vB_Template::create('tmnt_date_time');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('time', $user_to_time);
		$templater->register('day', $to_day);
		$templater->register('monthselected', $to_monthselected);
		$templater->register('yearbits', $to_yearbits);
		$templater->register('rangeid', 1);
		$templater->register('prefix', 'to');
	$ladder['enddatehtml'] = $templater->render();
	if (file_exists(DIR . '/tll_modules/tll_autoscoreconfirm.php'))
	{
		$tmntp['autoscoreconfirm'] = true;
	}
	if ($ladder['league'])
	{
		//work out round datelines
		$lrquery = $vbulletin->db->query_read("
			SELECT round, dateline
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
			WHERE g.lid = '$ladder[id]'
			GROUP BY g.round
			ORDER BY round ASC
		");
		$qqq = array();//round=>dateline
		while($qq = $vbulletin->db->fetch_array($lrquery))
		{
			$qqq[$qq[round]] = $qq['dateline'];
		}
		$g_i = 1;
		$maxrounds = $vbulletin->db->query_first("
			SELECT g.round
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
			WHERE g.lid = '$ladder[id]'
				AND g.group = '$g_i'
			ORDER BY g.round DESC
		");
		$ladder['rounds'] = $maxrounds['round'];
		//need to get dateline
		$ri = 1;
		while ($ri <= $ladder['rounds'])
		{
			$s = $ri+1;
			$s_dateline = $qqq["$ri"];
			if (!$s_dateline)
			{
				$s_dateline = TIMENOW + $ri * 86400;
			}
			list ($timezoneoptions, $s_day, $s_monthselected, $s_yearbits, $user_s_time, $dstchecked, $show) = tmnt_dateline_to_fields($s_dateline, $ladder['utc'], $ladder['dst'], $show);
			$templater = vB_Template::create('tmnt_date_time');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('timezoneoptions', $timezoneoptions);
				$templater->register('dstchecked', $dstchecked);
				$templater->register('time', $user_s_time);
				$templater->register('day', $s_day);
				$templater->register('monthselected', $s_monthselected);
				$templater->register('yearbits', $s_yearbits);
				$templater->register('rangeid', $s);
				$templater->register('prefix', "round$ri");
			$rhtml = $templater->render();
			$ladder['league_rounds'] .= "<div style=\"clear: both; " . ($ri > 1 ? "border: inherit; " : "") . "padding: inherit;\"><label for=\"range_mm$s\" class=\"label\" style=\"float: left; \">" . construct_phrase($vbphrase['ladder_league_round_x_date'], $ri) . " </label>\r\n<div class=\"rightcol\">" . $rhtml . "</div></div>\r\n";
			$ri++;
		}
		$ladder['groupnames'] = explode(',', $ladder['groupnames']);
		for ($rtg = 1; $rtg <= $ladder['groups']; $rtg++)
		{
			$rtgm = $rtg - 1;
			$ladder['league_groups'] .= "<div style=\"clear: both; border: inherit; padding: inherit;\"><p class=\"label\" style=\"float: left;\">" . construct_phrase($vbphrase['ladder_league_group_x_name'], $rtg) . " </p>\r\n<div class=\"rightcol\"><input type=\"text\" class=\"textbox\" name=\"groupname[$rtg]\" value=\"" . ($ladder['groupnames']["$rtgm"] ? $ladder['groupnames']["$rtgm"] : construct_phrase($vbphrase['ladder_league_group_x'], $rtg)) . "\" /></div></div>\r\n";
		}
	}
	$srty = array('protected_win_defending','protected_lose_defending','protected_win_challenge','protected_lose_challenge');
	foreach($srty AS $sss)
	{
		if ($sss != 'protected_win_defending')
		{
			$ladder['rules_option'] .= "<div class=\"blockrow\">";
		}
		$ladder['rules_option'] .= "<label for=\"$sss\">".$vbphrase['tmnt_'.$sss.'_desc']."</label>";
		$ladder['rules_option'] .= "<div class=\"rightcol\"><select name=\"$sss\" id=\"$sss\">";
		for ($zad = 0; $zad <= 36000; )
		{
			$ladder['rules_option'] .= "<option value=\"$zad\"".($zad==$ladder["$sss"] ? ' selected="selected"' : "").">".($zad/3600)." Hours</option>";
			$zad += 3600;
		}
		$ladder['rules_option'] .= "</select></div>";
		if ($sss == 'protected_win_defending')
		{
			$ladder['rules_option'] .= "</fieldset>";
		}
		else
		{
			$ladder['rules_option'] .= "</div>";
		}
	}
	$templater = vB_Template::create('tmnt_ladder_edit');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
		$templater->register('seasons', $seasons);
		$templater->register('categories', $categories);
		$templater->register('catid', $catid);
		$templater->register('timezoneoptions', $timezoneoptions);
		$templater->register('dstchecked', $dstchecked);
		$templater->register('to_day', $to_day);
		$templater->register('to_monthselected', $to_monthselected);
		$templater->register('to_yearbits', $to_yearbits);
		$templater->register('totime', $user_to_time);
		$templater->register('fromtime', $user_from_time);
		$templater->register('from_day', $from_day);
		$templater->register('from_monthselected', $from_monthselected);
		$templater->register('from_yearbits', $from_yearbits);
		$templater->register('co_array', $co_array);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id='.$id . '' => $title,
		'' => construct_phrase($vbphrase['ladder_editing'])
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_POST['do'] == 'insertplayer')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$lid = $id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase['error_invalid_ladder'];
		eval(standard_error($errormessage));
	}
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id' ");
	$ladderid = $vbulletin->input->clean_gpc('p', 'ladderid', TYPE_UINT);
	$teamid = $vbulletin->input->clean_gpc('p', 'teamid', TYPE_UINT);
	$group = $vbulletin->input->clean_gpc('p', 'group', TYPE_UINT);
	if (!$ladder['pot'])
	{
		if ($ladderid)
		{
			$usernames = array();
			$cmpts_query = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '".$ladderid."' ");
			while ($cmpt = $vbulletin->db->fetch_array($cmpts_query))
			{
				$usernames[] = $cmpt['username'];
			}
		}
		else
		{
			$usernames = $vbulletin->input->clean_gpc('p', 'username', TYPE_STR);
			if (!$usernames)
			{
				$errormessage = $vbphrase['error_no_username'];
				eval(standard_error($errormessage));
			}
			$usernames = explode(';',$usernames);
		}
		foreach ($usernames AS $hash => $username)
		{
			$username = trim($username);
			$user = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "user WHERE username = '".$vbulletin->db->escape_string($username)."' ");
			if (!$user['userid'])
			{
				continue;
			}
			else
			{
				$userid = $user['userid'];
			}
			$checkuserid = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "user WHERE userid='$userid' ");
			$checkuserid = $checkuserid['countrows'];  
			if ($checkuserid != 1)
			{
				continue;
			}
			$player = $vbulletin->db->query_first("
				SELECT *
				FROM " . TABLE_PREFIX . "tmnt_ladder_players
				WHERE lid='$id'
					AND (userid='$userid' OR username='".$vbulletin->db->escape_string($username)."') 
			");
			if ($player && $player['active'])
			{
				continue;
			}
			if ($player)
			{
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET active = '1', latime = '".TIMENOW."' WHERE lid = '$id' AND (userid = '$userid' OR username = '".$vbulletin->db->escape_string($username)."') AND active = '0'");
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET noplayers = noplayers + 1 WHERE id = '$id'");
				$userinfo = fetch_userinfo($userid);
				$tmnt_ladders = array_merge((array)$userinfo['tmnt_ladders'], (array)$id);
				$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_ladders = '" . implode(',' , $tmnt_ladders) . "' WHERE userid = '$userid'");
				continue;
			}
			
			if ($ladder['join_cost'] > 0 && $vbulletin->options['tmnt_credit_system'])
			{
				if ($user['tmnt_credits'] < $ladder['join_cost'])
				{
					continue;
				}
				else
				{
	require_once(DIR . '/includes/functions_tll_premium.php');		
					process_credits_transaction($user['userid'], -$ladder['join_cost'], 'Joined ladder');
					update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), $ladder['join_cost'], TIMENOW);
				}
			}
			$vbulletin->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_players
					(userid, username, lid, time, ip, pot, rank, " . TABLE_PREFIX . "tmnt_ladder_players.group, latime)
				VALUES (
					'".$vbulletin->db->escape_string($userid)."',
					'".$vbulletin->db->escape_string($username)."',
					'".$vbulletin->db->escape_string($id)."', 
					".TIMENOW.", 
					'".$vbulletin->db->escape_string($thisip)."', 
					'".$vbulletin->db->escape_string($ladder['pot'])."',
					'".$vbulletin->db->escape_string($ladder['startingelo'])."',
					'".$vbulletin->db->escape_string($group)."',
					'".TIMENOW."'
				)
			");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET noplayers = noplayers + 1 WHERE id=$id");
			if ($ladder['league']==2)
			{
				break;
			}
		}
	}
	else
	{//teams
		$team = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_teams WHERE teamid = '".$vbulletin->db->escape_string($teamid)."' ");
		if (!$team)
		{
			$errormessage = $vbphrase['error_invalid_team'];
			eval(standard_error($errormessage));
		}
		$player = $vbulletin->db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladder_players
			WHERE lid='$id'
				AND userid='$teamid'
		");
		if ($player && $player['active'])
		{
			$errormessage = 'Error, this team has already joined this ladder/league.';
			eval(standard_error($errormessage));
		}
		if ($player)
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET active = '1' WHERE lid = '$id' AND userid = '$teamid' AND active = '0'");
		}
		else
		{
			$vbulletin->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_players
					(userid, username, lid, time, ip, pot, rank, " . TABLE_PREFIX . "tmnt_ladder_players.group)
				VALUES (
					'".$vbulletin->db->escape_string($teamid)."',
					'".$vbulletin->db->escape_string($team['teamname'])."',
					'".$vbulletin->db->escape_string($id)."', 
					".TIMENOW.", 
					'".$vbulletin->db->escape_string($thisip)."', 
					'".$vbulletin->db->escape_string($ladder['pot'])."',
					'".$vbulletin->db->escape_string($ladder['startingelo'])."',
					'".$vbulletin->db->escape_string($group)."'
				)
			");
		}
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET noplayers = noplayers + 1 WHERE id=$id");
		$userid = $teamid;
	}
	if ($ladder['league'] == 2 && $group > 0)
	{//insert league games
		$count = 0;
		$c_array = $r_array = $r_userids = $userids = array();
		$cmpts = $vbulletin->db->query_read("
			SELECT players.*, IF (players.pot=0, 'u.username', '')
			FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (u.userid = players.userid)
			WHERE lid = '$lid'
				AND active = 1
				AND players.group = '$group'
				AND players.userid != '$userid'
			ORDER BY rand()
		");
		while ($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			$count++;
			$c_array[] = $cmpt;
			$userids[] = $cmpt['userid'];
		}
		$games = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
			WHERE lid = '$lid'
				AND g.group = '$group'
			ORDER BY g.round ASC
		");
		while($game = $vbulletin->db->fetch_array($games))
		{
			$g_array[] = $game;
			$r_array["$game[round]"][] = $game;
			$r_userids["$game[round]"][] = $game['u'];
			$r_userids["$game[round]"][] = $game['u2'];
		}
		//what about home/away games???
		/*if ($count%2)
		{//odd
			//find empty
			$rounds = $count;
			for ($r = 1; $r <= $rounds; $r++)
			{
				foreach ($userids AS $u)
				{
					if (in_array($u,$r_userids["$r"]))
					{
						continue;
					}
					if (!$ladder['homeaway'])
					{
						if ($r%2)
						{
							$xxx .= "\r\n"."($userid, $u, $lid, ".TIMENOW.", $ladder[pot], 0, 0, $group, $r, 1, 0), ";
						}
						else
						{
							$xxx .= "\r\n"."($u, $userid, $lid, ".TIMENOW.", $ladder[pot], 0, 0, $group, $r, 1, 0), ";
						}
					
					}
					else
					{
						print_r("Not supported yet...");
						exit;
					}
					
					//break;
				}
			}
			//print_r($xxx);
		}
		else
		{*///even
			//rearrange completely...
			//print_r($count);
			//print_r($userids);
			//print_r($g_array);
		if (!$ladder['racemode'])
		{
			$r_hold = $count;
			$ingroup = $count+1;
			$database = fetch_rr_database($ingroup);
			//print_r($database);
			$ids = array_merge($userids, array($userid));
			//print_r($ids);
			foreach ($database AS $r => $rvalue)
			{
				$r = substr($r, 1);
				$s = '';
				//$xxx = '';
				//$xxx2 = '';
				//array('02v01','03v08','04v07','05v06')
				foreach ($rvalue AS $nh => $ndata)
				{
					list($pla, $plb) = explode('v', $ndata);
					//print_r("$pla, $plb\r\n\r\n\r\n\r\n\r\n\r\n");
					$pla = (int)$pla - 1;
					$plb = (int)$plb - 1;
					//print_r("$ids[$pla] $ids[$plb]       \ ");
					if ($ids[$pla] > 0 && $ids[$plb] > 0)
					{
						$u = $ids[$pla];
						$u2 = $ids[$plb];
						$querycheck = '';
						if (!$ladder['homeaway'])
						{
							$querycheck = $vbulletin->db->query_first("
								SELECT * 
								FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
								WHERE lid = '$lid'
									AND g.group = '$group'
									AND ((u = '$u' AND u2 = '$u2') OR (u = '$u2' AND u2 = '$u'))
							");
							if (!$querycheck)
							{
								$xxx .= "\r\n"."($ids[$pla], $ids[$plb], $lid, ".TIMENOW.", $ladder[pot], 0, 0, $group, $r, 1, 0), ";
							}
							else if ($querycheck['round'] != $r)
							{
								$vbulletin->db->query_write("
									UPDATE " . TABLE_PREFIX . "tmnt_ladder_games AS g 
									SET g.round = '$r' 
									WHERE id = '".$querycheck[id]."'
								");
							}
						}
						else
						{
							$querycheck = $vbulletin->db->query_first("
								SELECT * 
								FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
								WHERE lid = '$lid'
									AND g.group = '$group'
									AND (u = '$u' AND u2 = '$u2')
							");
							if (!$querycheck)
							{
								$xxx .= "\r\n"."($ids[$pla], $ids[$plb], $lid, ".TIMENOW.", $ladder[pot], 0, 0, $group, $r, 1, 0), ";
							}
							else if ($querycheck['round'] != $r)
							{
								$vbulletin->db->query_write("
									UPDATE " . TABLE_PREFIX . "tmnt_ladder_games AS g 
									SET g.round = '$r' 
									WHERE id = '".$querycheck[id]."'
								");
							}
							$s = $r_hold + $r;
							$querycheck = $vbulletin->db->query_first("
								SELECT * 
								FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
								WHERE lid = '$lid'
									AND g.group = '$group'
									AND (u = '$u2' AND u2 = '$u')
							");
							if (!$querycheck)
							{
								$xxx .= "\r\n"."($ids[$plb], $ids[$pla], $lid, ".TIMENOW.", $ladder[pot], 0, 0, $group, $s, 1, 0), ";
							}
							else if ($querycheck['round'] != $s)
							{
								$vbulletin->db->query_write("
									UPDATE " . TABLE_PREFIX . "tmnt_ladder_games AS g 
									SET g.round = '$s' 
									WHERE id = '".$querycheck[id]."'
								");
							}
						}
					}
				}
			}
		}
		/*}*/
	}
	if ($xxx)
	{//insert challenges
		$xxx = "INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_games (`u`, `u2`, `lid`, `time`, `pot`, `dateline`, `mf`, `group`, `round`, `accepted`, `bestof`) VALUES  " . substr($xxx, 0, -2) . " ";
		$vbulletin->db->query_write("$xxx");
	}
	$ladder['url'] = tll_seo('ladder', $ladder['id'], $ladder['title']);
	$vbulletin->url = 'ladders.php'.$ladder['url'];
	eval(print_standard_redirect('redirect_insertplayer'));
}

// #############################################################################

if ($_REQUEST['do'] == 'addplayer')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id='$id'");
	if (!$ladder)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	if ($ladder['pot'])
	{
		$team = true;
		$teamarray = array();
		$teams_query = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_teams AS t
		");
		while($teamq = $vbulletin->db->fetch_array($teams_query))
		{
			$teamarray[] = $teamq;
		}
		if (!$teamarray)
		{
			$errormessage = $vbphrase['tmnt_noteams'];
        	eval(standard_error($errormessage));
		}
	} 
	else 
	{
		$team = false;
	}
	if (isset($_REQUEST['added']))
	{
		$added_success = true;
	}
	if ($ladder['groupid'])
	{
		$ladder_array = array();
		$ladders_query = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE groupid = '".$ladder['groupid']."' ");
		while ($l = $vbulletin->db->fetch_array($ladders_query))
		{
			$ladder_array["$l[id]"] = $l;
		}
	}
	$templater = vB_Template::create('tmnt_ladder_newplayer');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladder', $ladder);
		$templater->register('ladder_array', $ladder_array);
		$templater->register('added_success', $added_success);
		$templater->register('id', $id);
		$templater->register('team', $team);
		$templater->register('teamarray', $teamarray);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'do=view&amp;id='.$id . '' => $ladder['title'],
		'' => ($ladder['pot'] ? $vbphrase['ladder_addingteam'] : $vbphrase['ladder_addingplayer'])
	));
	$navbar = render_navbar_template($navbits);
	$show['usernameajax'] = true;
	if ($ladder['league']==2)
	{
		$show['single'] = true;
	}
	if ($_REQUEST['ajax'] == 1)
	{
		$tlhtml = str_replace('onclick="window.location.href=\'ladders.php?do=view&amp;id='.$id.'\'"','onclick="close_tll_popup();"',$tlhtml);
		print_r($tlhtml);
		exit;
	}
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('show', $show);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'create_player_image')
{
	$vbulletin->input->clean_array_gpc('g', array(
		'l' => TYPE_UINT,
		'w' => TYPE_UINT,
		'h' => TYPE_UINT,
		'u' => TYPE_UINT,
		'bw' => TYPE_UINT,
		'noavatar' => TYPE_UINT,
		'f' => TYPE_UINT,
		'bg' => TYPE_NOHTML,
		'b' => TYPE_NOHTML,
		'c' => TYPE_NOHTML,
		'bgurl' => TYPE_NOHTML,
	));
	$var = array(
		'l' => $vbulletin->GPC['l'],
		'w' => ($vbulletin->GPC['w'] ? $vbulletin->GPC['w'] : 250),
		'h' => ($vbulletin->GPC['h'] ? $vbulletin->GPC['h'] : 90),
		'u' => $vbulletin->GPC['u'],
		'bw' => ($vbulletin->GPC['bw'] ? $vbulletin->GPC['bw'] : 1),
		'noavatar' => $vbulletin->GPC['noavatar'],
		'f' => $vbulletin->GPC['f'],
		'bg' => ($vbulletin->GPC['bg'] ? $vbulletin->GPC['bg'] : 'FFFFFF'),
		'b' => ($vbulletin->GPC['b'] ? $vbulletin->GPC['b'] : '000000'),
		'c' => ($vbulletin->GPC['c'] ? $vbulletin->GPC['c'] : '000000'),
		'bgurl' => ($vbulletin->GPC['bgurl'] ? $vbulletin->GPC['bgurl'] : ''),
	);
	$ladder_array = array();
	$ladders_query = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders ORDER BY title ASC");
	while ($l = $vbulletin->db->fetch_array($ladders_query))
	{
		if ($l['id'] == $vbulletin->GPC['l'])
		{
			$l['selected'] = ' selected="selected"';
			}
		$ladder_array["$l[id]"] = $l;
	}
	if ($vbulletin->GPC['l'])
	{//fetch ladder players, if l is valid
		$player_array = array();
		$players_query = $vbulletin->db->query_read("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid = '".$var['l']."' AND active = 1 ORDER BY username ASC");
		while ($p = $vbulletin->db->fetch_array($players_query))
		{
			if ($p['userid']==$vbulletin->GPC['u'])
			{
				$p['selected'] = ' selected="selected"';
				$srt = true;
			}
			$player_array["$p[userid]"] = $p;
		}
		if (!$srt)
		{
			$vbulletin->GPC['u'] = $var['u'] = 0;
		}
	}
	$templater = vB_Template::create('tmnt_ladder_cpi');
		$templater->register('tmntp', $tmntp);
		$templater->register('ladders', $ladder_array);
		$templater->register('players', $player_array);
		$templater->register('var', $var);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => $vbphrase['ladder_create_player_image']
	));
	$navbar = render_navbar_template($navbits);
	$show['usernameajax'] = true;
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('show', $show);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'startleague')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$lid' AND league = 1");
	if (!$ladder)
	{
		print_no_permission();
	}
	$groups = $ladder['groups'];
	if ($pergroup > $tmnt_maxrr)
	{//check groups aren't too big
		$errormessage = "Maximum of $tmnt_maxrr per group; Increase number of groups.";
		eval(standard_error($errormessage));
	}
	
		if ($ladder['groupid'])
		{
			$basedonladder = $vbulletin->db->query_first("SELECT id, title FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id != '$lid' AND league = 2 AND groupid = '$ladder[groupid]' AND noplayers > 0 ORDER BY id DESC");
		}
		if ($_POST['do'] == 'startleague')
		{//post data
			$count = 0;
			$group_count = array();
			$xuser = array();
			$cmpts = $vbulletin->db->query_read("
				SELECT players.*, IF (players.pot=0, 'u.username', '')
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
				LEFT JOIN " . TABLE_PREFIX . "user AS u
					ON (u.userid = players.userid)
				WHERE lid = '$lid' AND active = 1
				ORDER BY rand()
			");
			while ($cmpt = $vbulletin->db->fetch_array($cmpts))
			{
				$count++;
				$cmpt['group'] = $vbulletin->input->clean_gpc('p', 'userid_'.$cmpt['userid'], TYPE_UINT);
				if ($cmpt['group'])
				{
					$group_count["$cmpt[group]"]++;
				}
				$c_array[] = $cmpt;
				$xuser["$cmpt[userid]"] = $cmpt;
				$g_array["$cmpt[group]"][] = $cmpt['userid'];
			}
		}
		elseif (!$ladder['groupid'] OR !$basedonladder)
		{ //new league - place players randomly into groups
			$count = 0;
			$xuser = array();
			$cmpts = $vbulletin->db->query_read("
				SELECT players.*, IF (players.pot=0, 'u.username', '')
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
				LEFT JOIN " . TABLE_PREFIX . "user AS u
					ON (u.userid = players.userid)
				WHERE lid = '$lid' AND active = 1
				ORDER BY rand()
			");
			while ($cmpt = $vbulletin->db->fetch_array($cmpts))
			{
				$count++;
				$c_array[] = $cmpt;
				$xuser["$cmpt[userid]"] = $cmpt;
			}
			$pergroup = ceil($count / $groups);
			if ($count == 0)
			{
				$errormessage = 'This league has no competitors yet.';
				eval(standard_error($errormessage));
			}
			//split into X groups as per $ladder
			$g_array = array();
			$this_group = 0;
			for ($i = 0; $i < $count; $i++)
			{
				$this_user = $c_array[$i]['username'];
				if ($i % $pergroup)
				{
				}
				else
				{
					$this_group++;
				}
				$g_array["$this_group"][] = $c_array[$i]['userid'];
			}
		}
		else
		{//based on last league		
			$lastcmpts = $vbulletin->db->query_read("
				SELECT players.*
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
				WHERE players.lid = '".$basedonladder['id']."' AND active = 1
			");
			while ($lastcmpt = $vbulletin->db->fetch_array($lastcmpts))
			{
				$last_c_array["$lastcmpt[userid]"] = $lastcmpt;
				$last_group["$lastcmpt[group]"][] = $lastcmpt['userid'];
			}
			$last_greatestround = count($last_group);
			foreach($last_group AS $thisgroup => $userids_array)
			{
				$this_count = count($userids_array);
				if ($thisgroup != 1)
				{//set first two as higher group
					$last_c_array["$userids_array[0]"]['group']--;
					if ($vbulletin->options['tmnt_league_pd'] > 1)
					{
						$last_c_array["$userids_array[1]"]['group']--;
					}
					if ($vbulletin->options['tmnt_league_pd'] > 2)
					{
						$last_c_array["$userids_array[2]"]['group']--;
					}
					if ($vbulletin->options['tmnt_league_pd'] > 3)
					{
						$last_c_array["$userids_array[3]"]['group']--;
					}
				}
				if ($last_greatestround != $thisgroup)
				{//set last two as lower group
					$j = $this_count - 1;
					$k = $this_count - 2;
					$l = $this_count - 3;
					$m = $this_count - 4;
					$last_c_array["$userids_array[$j]"]['group']++;
					if ($vbulletin->options['tmnt_league_pd'] > 1)
					{
						$last_c_array["$userids_array[$k]"]['group']++;
					}
					if ($vbulletin->options['tmnt_league_pd'] > 2)
					{
						$last_c_array["$userids_array[$l]"]['group']++;
					}
					if ($vbulletin->options['tmnt_league_pd'] > 3)
					{
						$last_c_array["$userids_array[$m]"]['group']++;
					}
				}
			}
			$count = 0;
			$group_count = array();
			$xuser = array();
			$cmpts = $vbulletin->db->query_read("
				SELECT players.*, IF (players.pot=0, 'u.username', '')
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
				LEFT JOIN " . TABLE_PREFIX . "user AS u
					ON (u.userid = players.userid)
				WHERE lid = '$lid' AND active = 1
				ORDER BY rand()
			");
			while ($cmpt = $vbulletin->db->fetch_array($cmpts))
			{
				$count++;
				//lastrank
				$cmpt['group'] = $last_c_array["$cmpt[userid]"]['group'];
				if ($cmpt['group'])
				{
					$group_count["$cmpt[group]"]++;
				}
				$c_array[] = $cmpt;
				$xuser["$cmpt[userid]"] = $cmpt;
			}
			$pergroup = ceil($count / $groups);
			if ($count == 0)
			{
				$errormessage = 'This league has no competitors yet.';
				eval(standard_error($errormessage));
			}
			$tg = 1;
			$g = 1;
			//print_r("pergroup = $pergroup;");
			$g_array = array();
			foreach ($c_array AS $chash => $cmpt)
			{
				if ($cmpt['group'])
				{
					$g_array["$cmpt[group]"][] = $cmpt['userid'];
					continue;
				}
				while ($group_count["$g"] >= $pergroup)
				{
					//print_r();
					$g++;
					if ($g > 8)
					{
						break;
					}
				}
				$cmpt['group'] = $g;
				$group_count["$cmpt[group]"]++;
				$g_array["$cmpt[group]"][] = $cmpt['userid'];
				$c_array["$chash"] = $cmpt;
			}
		}
		if (!$_REQUEST['auto'] && $_POST['do'] != 'startleague')
		{//not automatic display, print out
			//print_r($g_array);
			$s = count($g_array);
			$xo = 1;
			while ($xo <= $s)
			{
				$gdd .= '<option value="'.$xo.'">'.construct_phrase($vbphrase['ladder_league_group_x'], $xo).'</option>';
				$xo++;
			}
			function create_dropdown_groups($userid, $groupid)
			{
				global $gdd;
				//
				//alert(this.parentNode.parentNode.id)
				$return = '<select name="userid_'.$userid.'" onchange="tll_icm(this);" id="sel_u_'.$userid.'">'.str_replace('value="'.$groupid.'"','value="'.$groupid.'" selected="selected"',$gdd).'</select>';
				return $return;
			}
			arsort($g_array);
			$aarray = array();
			foreach ($g_array AS $groupid => $ids)
			{
				//print_r("<br />Group $groupid <br />");
				//print_r($ids);
				//print_r("<br />");
				if ($groupid != 1)
				{
					$first = true;
				}
				foreach($ids AS $xnull => $xuserid)
				{
					if (!$xuser["$xuserid"]['username'])
					{//sort out $teams!!!
						$xuser["$xuserid"] = fetch_userinfo($xuserid);
					}
					$aarray[] = array(
						'username' => $xuser["$xuserid"]['username'],
						'dd' => create_dropdown_groups($xuserid, $groupid),
						'userid' => $xuserid,
						'groupid' => $groupid,
						'first' => $first
					);
					$first = false;
				}
			}
			$templater = vB_Template::create('tmnt_organise_league');
				$templater->register('tmntp', $tmntp);
				$templater->register('aarray', $aarray);
				$templater->register('ladder', $ladder);
				$templater->register('basedonladder', $basedonladder);
				$templater->register('lstyle', '');
			$tlhtml .= $templater->render();
			$navbits = array(
				'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
				'ladders.php?showonly=leagues' => $vbphrase['ladder_leagues'],
				'ladders.php?do=view&amp;id='.$ladder['id'] => $ladder['title'],
				'' => 'Organise League Groups'
			);
			$navbits = construct_navbits($navbits);
			$navbar = render_navbar_template($navbits);
			$templater = vB_Template::create('tmnt_shell');
				$templater->register_page_templates();
				$templater->register('navbar', $navbar);
				$templater->register('headinclude', $headinclude);
				$templater->register('pagetitle', $pagetitle);
				$templater->register('tlhtml', $tlhtml);
				$templater->register('modname', $modname);
				$templater->register('header', $header);
				$templater->register('footer', $footer);
				$templater->register('tmntp', $tmntp);
				$templater->register('tmnt_version', $tmnt_version);
			print_output($templater->render());
		}
		foreach ($g_array AS $groupid => $ids)
		{
			//implode then update players group
			//print_r("<br>$xxx<br>");
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players AS players SET players.group = '$groupid' WHERE lid = '$lid' AND ( userid = '" . implode("' OR userid = '", $ids) . "' ) ");
			$ingroup = count($ids);
			$r_hold = $ingroup-1;
			//print_r("ingroup = $ingroup; <br>");
			//print_r($ids);
			//print_r($ingroup);
			if (!$ladder['racemode'])
			{
			$database = fetch_rr_database($ingroup);
			//print_r($database);
			foreach ($database AS $r => $rvalue)
			{
				$r = substr($r, 1);
				$s = '';
				$xxx = '';
				$xxx2 = '';
				//array('02v01','03v08','04v07','05v06')
				foreach ($rvalue AS $nh => $ndata)
				{
					list($pla, $plb) = explode('v', $ndata);
					$pla = (int)$pla - 1;
					$plb = (int)$plb - 1;
					if ($ids[$pla] && $ids[$plb])
					{
						/*
						$vbulletin->db->query_write("
							INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_games
								(u, u2, lid, time, pot, bestof, matchdate, map, u1message, u2message, chal_options, dateline, mf)
							VALUES (
								'".$vbulletin->db->escape_string($u)."',
								'".$vbulletin->db->escape_string($u2)."',
								'".$vbulletin->db->escape_string($lid)."',
								'".TIMENOW."',
								'0',
								'".$vbulletin->db->escape_string($bestof)."',
								'".$vbulletin->db->escape_string($matchdate)."',
								'".$vbulletin->db->escape_string($map)."',
								'".$vbulletin->db->escape_string($u1message)."',
								'".$vbulletin->db->escape_string($u2message)."',
								'".$vbulletin->db->escape_string($chal_options)."',
								'".$vbulletin->db->escape_string($dateline)."',
								'".$vbulletin->db->escape_string($mf)."'
							)
						");*/
						if (!$ladder['homeaway'])
						{
							$xxx .= "\r\n"."($ids[$pla], $ids[$plb], $lid, ".TIMENOW.", $ladder[pot], 0, 0, $groupid, $r, 1, 0), ";
						}
						else
						{
							//$s = $r * 2;
							//player 1 home
							$xxx .= "\r\n"."($ids[$pla], $ids[$plb], $lid, ".TIMENOW.", $ladder[pot], 0, 0, $groupid, $r, 1, 0), ";
							//$s--;
							$s = $ingroup + $r;
							//player 2 home
							$xxx2 .= "\r\n"."($ids[$plb], $ids[$pla], $lid, ".TIMENOW.", $ladder[pot], 0, 0, $groupid, $s, 1, 0), ";
						}
					}
				}
				if ($xxx)
				{
					$xxx = "INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_games (`u`, `u2`, `lid`, `time`, `pot`, `dateline`, `mf`, `group`, `round`, `accepted`, `bestof`) VALUES  " . substr($xxx, 0, -2) . " ";
					$vbulletin->db->query_write("$xxx");
				}
				if ($xxx2)
				{
					$xxx2 = "INSERT INTO " . TABLE_PREFIX . "tmnt_ladder_games (`u`, `u2`, `lid`, `time`, `pot`, `dateline`, `mf`, `group`, `round`, `accepted`, `bestof`) VALUES  " . substr($xxx2, 0, -2) . " ";
					$vbulletin->db->query_write("$xxx2");
				}
				//print_r("<br>$xxx<br>");
			}
			}
		}
	
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladders
		SET
			league = 2
		WHERE id = '$lid' AND league = '1'
	");
	$vbulletin->url = "ladders.php?do=view&id=$lid";	
	eval(print_standard_redirect('redirect_updatedladder'));
}

// #############################################################################

if ($_POST['do'] == 'updaterules')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id = '$id' ");
	$vbulletin->input->clean_array_gpc('p', array(
		'message'      => TYPE_STR,
		'wysiwyg'			 => TYPE_BOOL,
	));
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$rules = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$rules = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$rules = $vbulletin->GPC['message'];
	}
	$description = explode('[rules]',$ladder['description']);
	$description = $description['0'].'[rules]'.$rules;
	
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladders
		SET
			description = '".$vbulletin->db->escape_string($description)."'
		WHERE id = '$id'
	");
	$vbulletin->url = "ladders.php?do=view&id=$id&sh=6";	
	eval(print_standard_redirect('redirect_updatedladder'));
}

// #############################################################################

if ($_POST['do'] == 'updateladder')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
	$id = $vbulletin->input->clean_gpc('p', 'id', TYPE_UINT);
		if (!$id)
		{
			$errormessage = $vbphrase[error_invalid_ladder];
			eval(standard_error($errormessage));
		}
    $userid = $thisuserid;
	$username = $thisusername;
	$co_a = $vbulletin->input->clean_gpc('p', 'co_a', TYPE_ARRAY_NOHTML);
	$co_b = $vbulletin->input->clean_gpc('p', 'co_b', TYPE_ARRAY_NOHTML);
	$co = array();
	if (is_array($co_a))
	{
		//$key = preg_replace("/[^a-zA-Z0-9_\s]/", "", unhtmlspecialchars($key));
		foreach($co_a AS $key_a => $a)
		{
			if (!$a)
			{
				continue;
			}
			$a = preg_replace("/[^a-zA-Z0-9\s]/", "", unhtmlspecialchars($a));
			$co["$a"] = $co_b["$key_a"];
		}
		$co = serialize($co);
	}
	$icon = $vbulletin->input->clean_gpc('p', 'icon', TYPE_NOHTML);
	$title = $vbulletin->input->clean_gpc('p', 'title', TYPE_NOHTML);
		if (!$title)
		{
			$errormessage = $vbphrase['error_invalid_title'];
			eval(standard_error($errormessage));
		}
	$tmin = $vbulletin->input->clean_gpc('p', 'tmin', TYPE_INT);
	$tmax = $vbulletin->input->clean_gpc('p', 'tmax', TYPE_INT);
	$xp_win = $vbulletin->input->clean_gpc('p', 'xp_win', TYPE_INT);
	$xp_draw = $vbulletin->input->clean_gpc('p', 'xp_draw', TYPE_INT);
	$xp_lose = $vbulletin->input->clean_gpc('p', 'xp_lose', TYPE_INT);
	$catid = $vbulletin->input->clean_gpc('p', 'catid', TYPE_UINT);
	$groupid = $vbulletin->input->clean_gpc('p', 'groupid', TYPE_UINT);
	$racemode = $vbulletin->input->clean_gpc('p', 'racemode', TYPE_UINT);
	$groups = $vbulletin->input->clean_gpc('p', 'groups', TYPE_UINT);
	$fielda = $vbulletin->input->clean_gpc('p', 'fielda', TYPE_NOHTML);
	$fieldb = $vbulletin->input->clean_gpc('p', 'fieldb', TYPE_NOHTML);
	$chal_cost = $vbulletin->input->clean_gpc('p', 'chal_cost', TYPE_NUM);
	$join_cost = $vbulletin->input->clean_gpc('p', 'join_cost', TYPE_NUM);
	$knockout = $vbulletin->input->clean_gpc('p', 'knockout', TYPE_UINT);
	$comp_ugid = $vbulletin->input->clean_gpc('p', 'comp_ugid', TYPE_UINT);
	$allow_challenges = $vbulletin->input->clean_gpc('p', 'allow_challenges', TYPE_UINT);
	$knockout_type = $vbulletin->input->clean_gpc('p', 'knockout_type', TYPE_NOHTML);
	$autoscoreconfirm = $vbulletin->input->clean_gpc('p', 'autoscoreconfirm', TYPE_UINT);
	$maxplayers = $vbulletin->input->clean_gpc('p', 'maxplayers', TYPE_UINT);
	$racemode_rounds = $vbulletin->input->clean_gpc('p', 'racemode_rounds', TYPE_UINT);
	$groupnames = implode(',', $vbulletin->input->clean_gpc('p', 'groupname', TYPE_ARRAY_NOHTML));
	if ($tmin > $tmax)
	{
		$tmin = $tmax;
		$tmax = $vbulletin->input->clean_gpc('p', 'tmin', TYPE_INT);
	}
	$league = $vbulletin->input->clean_gpc('p', 'league', TYPE_UINT);
	$chal_cost_xtra = $vbulletin->input->clean_gpc('p', 'chal_cost_xtra', TYPE_BOOL);
	$startingelo = $vbulletin->input->clean_gpc('p', 'startingelo', TYPE_UINT);
	if (!$startingelo)
	{
		$startingelo = 1000;
	}
	$sticky = $vbulletin->input->clean_gpc('p', 'sticky', TYPE_INT);
	$archive = $vbulletin->input->clean_gpc('p', 'archive', TYPE_INT);
	$vbulletin->input->clean_array_gpc('p', array(
		'message'      => TYPE_STR,
		'wysiwyg'			 => TYPE_BOOL,
	));
	if ($vbulletin->GPC['wysiwyg'] && $vbulletin->options['simpleversion'] < 414)
	{
		require_once(DIR . '/includes/functions_wysiwyg.php');
		$description = convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], 1);
	}
	else if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$description = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message']);
	}
	else
	{
		$description = $vbulletin->GPC['message'];
	}
		if (!$description)
		{
			$errormessage = $vbphrase['error_invalid_description'];
			eval(standard_error($errormessage));
		}
	//start date
	$vbulletin->input->clean_array_gpc('p', array(
		'timezoneoffset' => TYPE_ARRAY_NUM,
		'dst'            => TYPE_ARRAY_UINT,
		'fromdate'       => TYPE_ARRAY_ARRAY,
		'todate'         => TYPE_ARRAY_ARRAY,
		'totime'         => TYPE_ARRAY_NOHTML,
		'fromtime'       => TYPE_ARRAY_NOHTML,
		'protected_win_defending' => TYPE_UINT,
		'protected_lose_defending' => TYPE_UINT,
		'protected_win_challenge' => TYPE_UINT,
		'protected_lose_challenge' => TYPE_UINT,
	));
	$type = 'range';
	$fromtime = $vbulletin->GPC['fromtime']["$type"];
	$totime = $vbulletin->GPC['totime']["$type"];
	$fromdate = $vbulletin->input->clean($vbulletin->GPC['fromdate']["$type"], TYPE_ARRAY_UINT);
	$todate = $vbulletin->input->clean($vbulletin->GPC['todate']["$type"], TYPE_ARRAY_UINT);
	$utc = $timezoneoffset = $vbulletin->GPC['timezoneoffset']["$type"];
	$dst = $vbulletin->GPC['dst']["$type"];
	require_once(DIR . '/includes/functions_misc.php');
	if (!fetch_timezone($timezoneoffset))
	{
		$errormessage = 'Error: invalid timezone specified';
		eval(standard_error($errormessage));
	}
	$dateline_to = tmnt_fields_to_dateline($totime, $todate, $utc, $dst, $type);
	if (!is_numeric($dateline_to))
	{
		$errormessage = $dateline_to;
		eval(standard_error($errormessage));
	}
	$dateline_from = tmnt_fields_to_dateline($fromtime, $fromdate, $utc, $dst, $type);
	if (!is_numeric($dateline_from))
	{
		$errormessage = $dateline_from;
		eval(standard_error($errormessage));
	}
	if ($dateline_to < $dateline_from)
	{
		$errormessage = 'Error: End date must be after start date.';
		eval(standard_error($errormessage));
	}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladders
		SET
			title = '".$vbulletin->db->escape_string($title)."',
			description = '".$vbulletin->db->escape_string($description)."', 
			ed_userid = '$userid', 
			ed_username = '".$vbulletin->db->escape_string($username)."',
			ed_time ='".TIMENOW."', 
			ed_ip ='".$vbulletin->db->escape_string($thisip)."',
			tmin = '".$vbulletin->db->escape_string($tmin)."', 
			tmax = '".$vbulletin->db->escape_string($tmax)."',
			sticky = '".$vbulletin->db->escape_string($sticky)."',
			archive = '".$vbulletin->db->escape_string($archive)."', 
			catid = '".$vbulletin->db->escape_string($catid)."', 
			startingelo = '".$vbulletin->db->escape_string($startingelo)."',
			icon = '".$vbulletin->db->escape_string($icon)."',
			dateline_from = '".$vbulletin->db->escape_string($dateline_from)."',
			dateline_to = '".$vbulletin->db->escape_string($dateline_to)."',
			dst = '".$vbulletin->db->escape_string($dst)."',
			utc = '".$vbulletin->db->escape_string($utc)."',
			groupid = '".$vbulletin->db->escape_string($groupid)."',
			chal_options = '".$vbulletin->db->escape_string($co)."',
			xp_win = '".$vbulletin->db->escape_string($xp_win)."',
			xp_draw = '".$vbulletin->db->escape_string($xp_draw)."',
			xp_lose = '".$vbulletin->db->escape_string($xp_lose)."',
			groupnames = '".$vbulletin->db->escape_string($groupnames)."',
			groups = '".$vbulletin->db->escape_string($groups)."',
			chal_cost = '".$vbulletin->db->escape_string($chal_cost)."',
			join_cost = '".$vbulletin->db->escape_string($join_cost)."',
			chal_cost_xtra = '".$vbulletin->db->escape_string($chal_cost_xtra)."',
			knockout = '".$vbulletin->db->escape_string($knockout)."',
			comp_ugid = '".$vbulletin->db->escape_string($vbulletin->GPC['comp_ugid'])."',
			knockout_type = '".$vbulletin->db->escape_string($knockout_type)."',
			autoscoreconfirm = '".$vbulletin->db->escape_string($autoscoreconfirm)."',
			fielda = '".$vbulletin->db->escape_string($fielda)."',
			fieldb = '".$vbulletin->db->escape_string($fieldb)."',
			maxplayers = '".$vbulletin->db->escape_string($maxplayers)."',
			allow_challenges = '".$vbulletin->db->escape_string($allow_challenges)."',
			racemode = '".$vbulletin->db->escape_string($racemode)."',
			racemode_rounds = '".$vbulletin->db->escape_string($racemode_rounds)."',
			protected_win_defending = '".$vbulletin->db->escape_string($vbulletin->GPC['protected_win_defending'])."',
			protected_lose_defending = '".$vbulletin->db->escape_string($vbulletin->GPC['protected_lose_defending'])."',
			protected_win_challenge = '".$vbulletin->db->escape_string($vbulletin->GPC['protected_win_challenge'])."',
			protected_lose_challenge = '".$vbulletin->db->escape_string($vbulletin->GPC['protected_lose_challenge'])."'
		WHERE id = '$id'
	");
	if ($league)
	{
		for ($i=1;$i<=$tmnt_maxrr;$i++)
		{//for each round update dateline for all games upto 14
			$vbulletin->input->clean_array_gpc('p', array(
				"round".$i."date" => TYPE_ARRAY_ARRAY,
				"round".$i."time" => TYPE_ARRAY_NOHTML,
			));
			$time = $vbulletin->GPC["round".$i.'time']["$type"];
			$date = $vbulletin->input->clean($vbulletin->GPC["round".$i.'date']["$type"], TYPE_ARRAY_UINT);
			if (!$time && !$date)
			{
				break;
			}
			$dateline = tmnt_fields_to_dateline($time, $date, $utc, $dst, $type);
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
				SET
					dateline = '".$vbulletin->db->escape_string($dateline)."'
				WHERE lid = '$id' AND round = '$i'
			");
		}
	}
	build_tll_catcache();
	$vbulletin->url = "ladders.php?do=view&id=$id";	
	eval(print_standard_redirect('redirect_updatedladder'));
}

// #############################################################################

if ($_REQUEST['do'] == 'progress')
{
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id) {
			$errormessage = $vbphrase['error_invalid_ladder'];
			eval(standard_error($errormessage));
		}
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id=$id AND league > 0 AND knockout > 0 AND status = 1 ");
	if (($ladder['userid'] != $thisuserid && !$tmntp['caneditladder']) OR !$ladder)
	{
		print_no_permission();
	}
	$userid = $vbulletin->input->clean_gpc('g', 'userid', TYPE_UINT);
		if (!$userid) {
			$errormessage = $vbphrase[error_no_userid];
			eval(standard_error($errormessage));
		}
	$round = $vbulletin->input->clean_gpc('g', 'round', TYPE_STR);
		if (!$round) {
			$errormessage = $vbphrase[error_invalid_round];
			eval(standard_error($errormessage));
		}
	$rounds = array("round2", "round3",  "round4", "round5", "round6", "round7", "round8", "round9", "round10", "round11", "round12");
		if (!in_array($round, $rounds))
		{
			$errormessage = $vbphrase[error_invalid_round];
			eval(standard_error($errormessage));
		}
	$slot = $vbulletin->input->clean_gpc('g', 'slot', TYPE_UINT);
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET ".$round." = '".$slot."' WHERE lid='".$id."' AND userid='".$userid."' ");
	// process loser for double elimination
	if ($ladder['knockout_type'] == 'de' && $slot > 0)
	{
		$slot2 = $vbulletin->input->clean_gpc('g', 'slot2', TYPE_UINT);
		$userid2 = $vbulletin->input->clean_gpc('g', 'userid2', TYPE_UINT);
		$round2 = $vbulletin->input->clean_gpc('g', 'round2', TYPE_STR);
		if (!in_array($round2, $rounds))
		{
			$round2 = $round;
		}
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET ".$round2." = '".$slot2."' WHERE lid='".$id."' AND userid='".$userid2."' ");
	}
	$vbulletin->url = "ladders.php?do=view&id=".$id."&sh=8#".$round."_slot".($slot&1 ? $slot : ($slot-1));	
	eval(print_standard_redirect('redirect_progressedplayer'));
}


// #############################################################################

if ($_REQUEST['do'] == 'progressfinish')
{
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
		if (!$id)
		{
			$errormessage = $vbphrase['error_invalid_tournament'];
			eval(standard_error($errormessage));
		}
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id=$id AND league > 0 AND knockout > 0 AND status = 1 ");
	if (($ladder['userid'] != $thisuserid && !$tmntp['caneditladder']) OR !$ladder)
	{
		print_no_permission();
	}
	$team = false;
	if ($ladder['pot'])
	{
		$team = true;
	}
	$userid = $vbulletin->input->clean_gpc('g', 'userid', TYPE_UINT);
		if (!$userid) 
		{
			$errormessage = $vbphrase[error_invalid_userid];
			eval(standard_error($errormessage));
		}
	$round = $vbulletin->input->clean_gpc('g', 'round', TYPE_STR);
		if (!$round) 
		{
			$errormessage = $vbphrase[error_invalid_round];
			eval(standard_error($errormessage));
		}
	$rounds = array("round2", "round3",  "round4", "round5", "round6", "round7", "round8", "round9", "round10", "round11", "round12");
		if (!in_array($round, $rounds))
		{
			$errormessage = $vbphrase[error_invalid_round];
			eval(standard_error($errormessage));
		}
	$slot = $vbulletin->input->clean_gpc('g', 'slot', TYPE_UINT);
		if (!$slot)
		{
			$errormessage = $vbphrase[error_invalid_slot];
			eval(standard_error($errormessage));
		}
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
		SET $round = '$slot', winner = '1' WHERE lid = '$id' AND userid = '$userid' 
	");
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladders
		SET status = '2', dateline_to = '".TIMENOW."'  WHERE id = '$id'
	");
	
	/*if (!$tmnt['pot'] && $tmnt['win_credits'] > 0 && $vbulletin->options['tmnt_credit_system'])
	{//winner gets credits
require_once(DIR . '/includes/functions_tll_premium.php');		
		process_credits_transaction($userid, $tmnt['win_credits'], 'Won tournament');
		update_forum_creditprofit(vbdate('W',TIMENOW), vbdate('Y',TIMENOW), -$tmnt['win_credits'], TIMENOW);
	}*/
	/*if ($tmnt['ladderid'])
	{
		if ($tmnt['lwinxp'])
		{
			list($tmnt['xp_1st'], $tmnt['xp_2nd'], $tmnt['xp_3rd']) = explode(',', $tmnt['lwinxp']);
		}
		else
		{
			$tmnt['xp_1st'] = $tmnt['xp_2nd'] = $tmnt['xp_3rd'] = 0;
		}
		if ($tmnt['prize'] OR $tmnt['xp_1st'] OR $tmnt['xp_2nd'] OR $tmnt['xp_3rd'])
		{
			list($winners, $winners2nd, $winners3rd) = get_se_ftt(null, 0, 1, $id);
			$userids2nd = implode("' OR userid = '", $winners2nd);
			$userids3rd = implode("' OR userid = '", $winners3rd);
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
				SET rank = rank + " . $tmnt['prize'] . "
				" . ($tmnt['xp_1st'] ? ", xp = xp + " . $tmnt['xp_1st'] : "") . "
				WHERE (userid = '$userid')
					AND lid = '" . $tmnt['ladderid'] . "'
			");
			if ($tmnt['xp_2nd'] > 0 && $userids2nd)
			{
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
					SET xp = xp + $tmnt[xp_2nd]
					WHERE (userid = '$userids2nd')
						AND lid = '" . $tmnt['ladderid'] . "'
				");
			}
			if ($tmnt['xp_3rd'] > 0 && $userids3rd)
			{
				$vbulletin->db->query_write("
					UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
					SET xp = xp + $tmnt[xp_3rd]
					WHERE (userid = '$userids3rd')
						AND lid = '" . $tmnt['ladderid'] . "'
				");
			}
		}
	}*/
	/*if (!$team)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "user SET tmnt_wins = tmnt_wins + 1 WHERE userid=$userid");
	}
	else
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_teams SET wins = wins + 1 WHERE teamid=$userid");
	}*/
	$vbulletin->url = "ladders.php?do=view&id=" . $id . "&sh=8";	
	eval(print_standard_redirect('redirect_progressedplayer'));
}

// #############################################################################

if ($_POST['do'] == 'updatesquad')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'mid' => TYPE_UINT,
		'u_userids' => TYPE_ARRAY_UINT,
		'u2_userids' => TYPE_ARRAY_UINT,
	));
	$mid = $vbulletin->GPC['mid'];
	$game = $match = $vbulletin->db->query_first("
		SELECT g.*, u.teamname AS u_teamname, u2.teamname AS u2_teamname
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS u
			ON (g.u = u.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS u2
			ON (g.u2 = u2.teamid)
		WHERE g.id = '$mid' AND g.finished = 0");
	//print_r($game);
	if (!$game['pot'])
	{
		print_no_permission();
	}
	$controls_u = $controls_u2 = false;
	$players_u = $players_u2 = array();
	if ($game['u_squad'])
	{
		$game['u_squad'] = explode(',',$game['u_squad']);
	}
	else
	{
		$game['u_squad'] = array();
	}
	if ($game['u2_squad'])
	{
		$game['u2_squad'] = explode(',',$game['u2_squad']);
	}
	else
	{
		$game['u2_squad'] = array();
	}
	//check team perms
	$team_u_query = $vbulletin->db->query_read("
		SELECT m.*, u.username
		FROM " . TABLE_PREFIX . "tmnt_members AS m
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (u.userid = m.userid)
		WHERE m.teamid = '".$game['u']."'
			AND m.accepted = 1
	");
	while($teamplayer = $vbulletin->db->fetch_array($team_u_query))
	{
		if ($teamplayer['userid'] == $vbulletin->userinfo['userid'] && $teamplayer['leader'])
		{
			$controls_u = true;
		}
		if (in_array($teamplayer['userid'], $game['u_squad']))
		{
			$teamplayer['selected'] = ' checked="checked"';
		}
		$players_u[] = $teamplayer;
	}
	$team_u2_query = $vbulletin->db->query_read("
		SELECT m.*, u.username
		FROM " . TABLE_PREFIX . "tmnt_members AS m
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (u.userid = m.userid)
		WHERE m.teamid = '".$game['u2']."'
			AND m.accepted = 1
	");
	while($teamplayer = $vbulletin->db->fetch_array($team_u2_query))
	{
		if ($teamplayer['userid'] == $vbulletin->userinfo['userid'] && $teamplayer['leader'])
		{
			$controls_u2 = true;
		}
		if (in_array($teamplayer['userid'], $game['u2_squad']))
		{
			$teamplayer['selected'] = ' checked="checked"';
		}
		$players_u2[] = $teamplayer;
	}
	if (!$controls_u && !$controls_u2)
	{
		print_no_permission();
	}
	
	if ($controls_u)
	{
		if ($vbulletin->GPC['u_userids'] && is_array($vbulletin->GPC['u_userids']))
		{
			if (count($vbulletin->GPC['u_userids']) != $game['squadsize'])
			{
				$errormessage = 'Error: Please only select ' . $game['squadsize'] . ' players for challenger team\'s squad.';
				eval(standard_error($errormessage));
			}
			$vbulletin->GPC['u_userids'] = implode(',', $vbulletin->GPC['u_userids']);
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
				SET u_squad = '".$vbulletin->db->escape_string($vbulletin->GPC['u_userids'])."'
				WHERE id = '".$vbulletin->GPC['mid']."'
			");
		}
	}
	if ($controls_u2)
	{
		if ($vbulletin->GPC['u2_userids'] && is_array($vbulletin->GPC['u2_userids']))
		{
			if (count($vbulletin->GPC['u2_userids']) != $game['squadsize'])
			{
				$errormessage = 'Error: Please only select ' . $game['squadsize'] . ' players for challenged team\'s squad.';
				eval(standard_error($errormessage));
			}
			$vbulletin->GPC['u2_userids'] = implode(',', $vbulletin->GPC['u2_userids']);
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladder_games
				SET u2_squad = '".$vbulletin->db->escape_string($vbulletin->GPC['u2_userids'])."'
				WHERE id = '".$vbulletin->GPC['mid']."'
			");
		}
	}
	$vbulletin->url = "ladders.php?do=challenges&mid=".$mid."#match".$mid;
	eval(print_standard_redirect('redirect_updatedsquad'));
}

// #############################################################################

if ($_REQUEST['do'] == 'editsquad')
{
	$mid = $vbulletin->input->clean_gpc('g', 'mid', TYPE_UINT);
	$game = $match = $vbulletin->db->query_first("
		SELECT g.*, u.teamname AS u_teamname, u2.teamname AS u2_teamname
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS u
			ON (g.u = u.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS u2
			ON (g.u2 = u2.teamid)
		WHERE g.id = '$mid' AND g.finished = 0");
	//print_r($game);
	if (!$game['pot'])
	{
		print_no_permission();
	}
	$controls_u = $controls_u2 = false;
	$players_u = $players_u2 = array();
	if ($game['u_squad'])
	{
		$game['u_squad'] = explode(',',$game['u_squad']);
	}
	else
	{
		$game['u_squad'] = array();
	}
	if ($game['u2_squad'])
	{
		$game['u2_squad'] = explode(',',$game['u2_squad']);
	}
	else
	{
		$game['u2_squad'] = array();
	}
	//check team perms
	$team_u_query = $vbulletin->db->query_read("
		SELECT m.*, u.username
		FROM " . TABLE_PREFIX . "tmnt_members AS m
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (u.userid = m.userid)
		WHERE m.teamid = '".$game['u']."'
	");
	while($teamplayer = $vbulletin->db->fetch_array($team_u_query))
	{
		if ($teamplayer['userid'] == $vbulletin->userinfo['userid'] && $teamplayer['leader'])
		{
			$controls_u = true;
		}
		if (in_array($teamplayer['userid'], $game['u_squad']))
		{
			$teamplayer['checked'] = ' checked="checked"';
		}
		$players_u[] = $teamplayer;
	}
	$team_u2_query = $vbulletin->db->query_read("
		SELECT m.*, u.username
		FROM " . TABLE_PREFIX . "tmnt_members AS m
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (u.userid = m.userid)
		WHERE m.teamid = '".$game['u2']."'
	");
	while($teamplayer = $vbulletin->db->fetch_array($team_u2_query))
	{
		if ($teamplayer['userid'] == $vbulletin->userinfo['userid'] && $teamplayer['leader'])
		{
			$controls_u2 = true;
		}
		if (in_array($teamplayer['userid'], $game['u2_squad']))
		{
			$teamplayer['checked'] = ' checked="checked"';
		}
		$players_u2[] = $teamplayer;
	}
	if (!$controls_u && !$controls_u2)
	{
		print_no_permission();
	}
	$templater = vB_Template::create('tmnt_ladder_editsquad');
		$templater->register('tmntp', $tmntp);
		$templater->register('game', $game);
		$templater->register('controls_u', $controls_u);
		$templater->register('controls_u2', $controls_u2);
		$templater->register('players_u', $players_u);
		$templater->register('players_u2', $players_u2);
	$tlhtml .= $templater->render();
	
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => 'Edit Squad'
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'viewmatch')
{
	$mid = $vbulletin->input->clean_gpc('g', 'mid', TYPE_UINT);
	$game = $match = $vbulletin->db->query_first("
		SELECT g.*, IF (g.pot = 1, t.teamname, '') AS u_teamname, IF (g.pot = 1, t2.teamname, '') AS u2_teamname, IF (g.pot = 0, u.username, '') AS u_username, IF (g.pot = 0, u2.username, '') AS u2_username, l.title AS laddertitle, l.league
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
			ON (g.lid = l.id)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
			ON (g.u = t.teamid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t2
			ON (g.u2 = t2.teamid)
		LEFT JOIN " . TABLE_PREFIX . "user AS u
			ON (g.u = u.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS u2
			ON (g.u2 = u2.userid)
		WHERE g.id = '$mid'");
	//print_r($game);
	if (!$game)
	{
		print_no_permission();
	}
	if ($game['screen_u'])
	{
		$game['screen_u'] = explode(";", $game['screen_u']);
	}
	if ($game['screen_u2'])
	{
		$game['screen_u2'] = explode(";", $game['screen_u2']);
	}
	if ($game['pot'])
	{
		$team = true;
		$players_u = $players_u2 = array();
		$game['squad_scores'] = unserialize($game['squad_scores']);
		if ($game['u_squad'])
		{
			$game['u_squad'] = explode(',',$game['u_squad']);
		}
		else
		{
			$game['u_squad'] = array();
		}
		if ($game['u2_squad'])
		{
			$game['u2_squad'] = explode(',',$game['u2_squad']);
		}
		else
		{
			$game['u2_squad'] = array();
		}
		$team_u_query = $vbulletin->db->query_read("
			SELECT m.*, u.username
			FROM " . TABLE_PREFIX . "tmnt_members AS m
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (u.userid = m.userid)
			WHERE m.teamid = '".$game['u']."'
		");
		while($teamplayer = $vbulletin->db->fetch_array($team_u_query))
		{
			if (in_array($teamplayer['userid'], $game['u_squad']))
			{
				$teamplayer['checked'] = ' checked="checked"';
			}
			if ($game['squad_scores']['u'])
			{
				$teamplayer['showscore'] = true;
				$teamplayer['score'] = $game['squad_scores']['u']["$teamplayer[userid]"];
			}
			$players_u[] = $teamplayer;
		}
		$team_u2_query = $vbulletin->db->query_read("
			SELECT m.*, u.username
			FROM " . TABLE_PREFIX . "tmnt_members AS m
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (u.userid = m.userid)
			WHERE m.teamid = '".$game['u2']."'
		");
		while($teamplayer = $vbulletin->db->fetch_array($team_u2_query))
		{
			if (in_array($teamplayer['userid'], $game['u2_squad']))
			{
				$teamplayer['checked'] = ' checked="checked"';
			}
			if ($game['squad_scores']['u2'])
			{
				$teamplayer['showscore'] = true;
				$teamplayer['score'] = $game['squad_scores']['u2']["$teamplayer[userid]"];
			}
			$players_u2[] = $teamplayer;
		}
	}
	if ($game['comments']>0)
	{
		$comments = array();
		$comments_query = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladder_mcs
			WHERE mid = '$mid'
			ORDER BY dateline ASC
		");
		while($comment = $vbulletin->db->fetch_array($comments_query))
		{
			if (!$comment['mid'])
			{
				continue;
			}
			$comments[] = $comment;
		}
	}
	$game['timetoaccept'] = number_format(($game['accepted_dateline'] - $game['dateline'])/86400);
	//print_r($game);
	$templater = vB_Template::create('tmnt_ladder_viewmatch');
		$templater->register('tmntp', $tmntp);
		$templater->register('team', $team);
		$templater->register('game', $game);
		$templater->register('players_u', $players_u);
		$templater->register('players_u2', $players_u2);
		$templater->register('comments', $comments);
	$tlhtml .= $templater->render();
	$navbits = construct_navbits(array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname,
		'ladders.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['ladders'],
		'' => 'View Match'
	));
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'] == 'start_knockout')
{
	if (!$tmntp['caneditladder'] OR !$vbulletin->options['tmnt_premium'])
	{
		print_no_permission();
	}
	$lid = $vbulletin->input->clean_gpc('g', 'lid', TYPE_UINT);
	$ladder = $vbulletin->db->query_first("SELECT * FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id=$lid AND status = 0 AND league > 1 AND knockout > 0");
	//print_r($ladder);
	if (!$ladder)
	{
		print_no_permission();
	}
	$games = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$lid AND finished = 0");
	if ($games['countrows'] > 0)
	{
		$errormessage = 'You have ' . $games['countrows'] . ' outstanding unfinished matches.';
		eval(standard_error($errormessage));
	}
	require_once(DIR . '/includes/functions_tll_premium.php');
	//$ladder['groups']=2
	$limit = $ladder['knockout'];//top X of each group
	$total = $ladder['knockout'] * $ladder['groups'];//no of knockout players
	$noplayers = ceil($total / 4) * 4;//tmnt noplayers
	$curr_slots = array();
	if ($noplayers > $total)
	{
		$curr_slots[] = 2;
	}
	if ($ladder['league'] > 0)
	{
		$vbulletin->options['tmnt_ladder_ranking'] = 'xp';
		$vbulletin->options['tmnt_elorating'] = 0;
	}
	for ($i = 1; $i <=$ladder['groups']; $i++)
	{//get top two sorted by groups
		$c = 0;
		$cmpts = $vbulletin->db->query_read("
			SELECT players.* 
			FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
			WHERE lid = '$lid' AND players.group = '$i'
			ORDER BY 
				" . ($vbulletin->options['tmnt_ladder_ranking'] == 'elo' ? "players.rank DESC," : "")
				. ($vbulletin->options['tmnt_ladder_ranking'] == 'xp' ? "players.xp DESC," : "") . "
				players.wins DESC,
				players.draws DESC,
				players.loses ASC,
				" . ($vbulletin->options['tmnt_ladder_ranking'] == 'elo' ? "players.xp DESC, " : "") . "
				players.totalpoints DESC,
				players.pointsagainst ASC
			LIMIT 0, $limit
		");
		while($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			$c++;
			/*if ($i == 1)
			{
				if ($c == 1)
				{
					$slot = 1;
				}
				elseif ($c == 2)
				{
					
				}
			}*/
			$slot = tll_rand_slot(1, $noplayers, $curr_slots);
			$curr_slots[] =  $slot;
			$cmpt['round'] = $cmpt['slot'] = $slot;
			//print_r($cmpt);
	//give them each random slots
	//give them each round 1 position
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_players SET round = $slot, slot = $slot WHERE id='".$cmpt['id']."'");
		}
	}
	//set ladder status => 1 
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET status = 1 WHERE id='".$ladder['id']."'");
	$vbulletin->url = "ladders.php?do=view&id=".$lid."&sh=8";
	eval(print_standard_redirect('redirect_startedknockoutleague'));
}

// #############################################################################

if ($_REQUEST['do'] == 'delete')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
		eval(standard_error($errormessage));
	}
    $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladders WHERE id=$id");
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid=$id");
	$vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE lid=$id");
	build_tll_catcache();
	$vbulletin->url = "ladders.php";
	eval(print_standard_redirect('redirect_deletedladder'));
}

// #############################################################################

if ($_REQUEST['do'] == 'deletechallenge')
{
	if (!$tmntp['caneditladder'])
	{
		print_no_permission();
	}
    $id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase['error_invalid_challenge'];
		eval(standard_error($errormessage));
	}
    $vbulletin->db->query_write("DELETE FROM " . TABLE_PREFIX . "tmnt_ladder_games WHERE id=$id");
	$vbulletin->url = "ladders.php?do=allchallenges";
	eval(print_standard_redirect('redirect_deletedchallenge'));
}

// #############################################################################

if ($_REQUEST['do'] == 'reportchallenge')
{
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$games = $vbulletin->db->query_first("
		SELECT ladders.*, games.*
		FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
		LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON(games.lid=ladders.id)
		WHERE games.id = '$id'
	");
	if ($games['pot'])
	{
		$teamids = array();
		$teams = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_members AS members
			JOIN " . TABLE_PREFIX . "tmnt_teams AS teams
				on members.teamid = teams.teamid
			WHERE members.leader=1
				AND members.userid='$thisuserid'");
		while($team = $vbulletin->db->fetch_array($teams))
		{
			$teamids = array_merge((array)$team['teamid'], $teamids);
		}
	}
	if (
		!$games['flag'] &&
		( (($vbulletin->userinfo['userid'] == $games['u'] OR $vbulletin->userinfo['userid'] == $games['u2']) && !$games['pot'])
		OR
		( (in_array($games['u'], $teamids) OR in_array($games['u2'], $teamids)) && $games['pot']) )
		)
	{
		$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladder_games SET flag = '" . $vbulletin->userinfo['userid'] . "' WHERE id = '$id' ");
	}
	if ($tmntp['canusetickets'])
	{
		$vbulletin->url = "tll_tickets.php?do=new&challengeid=".$id."&ladderid=".$games['lid'];
	}
	else
	{
		$vbulletin->url = "ladders.php?do=challenges&mid=".$id."#match".$id;
	}
	eval(print_standard_redirect('redirect_matchreported'));
}

// #############################################################################

if ($_REQUEST['do'] == 'search_matches')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	$mysql_cond_and = '';
	$id = $vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);
	$u1 = $vbulletin->input->clean_gpc('g', 'u1', TYPE_UINT);
	$u2 = $vbulletin->input->clean_gpc('g', 'u2', TYPE_UINT);
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
        eval(standard_error($errormessage));
	}
	$lid = $id;
	$ladder = $vbulletin->db->query_first("
		SELECT ladders.*, cats.title AS categorytitle, cats.parentid, cats2.title AS parenttitle, ladders.cr_userid AS userid, ladders.cr_username AS username
		FROM " . TABLE_PREFIX . "tmnt_ladders AS ladders
		LEFT JOIN " . TABLE_PREFIX . "tmnt_categories AS cats 
			ON (cats.catid = ladders.catid)
		LEFT JOIN " . TABLE_PREFIX . "tmnt_categories AS cats2 
			ON (cats.parentid = cats2.catid)
		WHERE ladders.id = '$id'
	");
	if (!$ladder)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
        eval(standard_error($errormessage));
	}
	if ($ladder['pot'])
	{
		$team = true;
	}
	if ($u1 > 0)
	{
		$mysql_cond_and .= " AND (games.u = '$u1' OR games.u2 = '$u1') ";
	}
	if ($u2 > 0)
	{
		$mysql_cond_and .= " AND (games.u = '$u2' OR games.u2 = '$u2') ";
	}
		$cmpt_array = array();
		$cmpts = $vbulletin->db->query_read("
			SELECT " . (!$team ? "user.*, " : "") . " players.*, players.userid AS userid
			" . (!$team ? ", user.username AS username" : "") . "
			, players.rank AS rank
		FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
		" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (players.userid = user.userid) " : " LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS team ON (players.userid = team.teamid)") . "
		WHERE players.lid=$id 
			AND players.active=1
		ORDER BY 
			players.group ASC,
			" . ($vbulletin->options['tmnt_ladder_ranking'] == 'elo' ? "players.rank DESC," : "")
			. ($vbulletin->options['tmnt_ladder_ranking'] == 'xp' ? "players.xp DESC," : "") . "
			players.wins DESC,
			players.draws DESC,
			players.loses ASC,
			" . ($vbulletin->options['tmnt_ladder_ranking'] == 'elo' ? "players.xp DESC, " : "") . "
			players.totalpoints DESC,
			players.pointsagainst ASC
		");
		$ti = 0;
		while($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			if ($cmpt['userid'] == $u1)
			{
				$cmpt['selected_u1'] = ' selected="selected"';
			}
			if ($cmpt['userid'] == $u2)
			{
				$cmpt['selected_u2'] = ' selected="selected"';
			}
			$cmpt_array[] = $cmpt;
		}
	
	$u1_select = '<select name="u1" id="u1" onchange="this.form.submit();"><option></option>';
	$u2_select = '<select name="u2" id="u2" onchange="this.form.submit();"><option value="">All Other Players</option>';
	foreach ($cmpt_array AS $chash => $cmpt)
	{
		$u1_select .= '<option value="'.$cmpt['userid'].'" '.$cmpt['selected_u1'].'>'.$cmpt['username'].'</option>';
		$u2_select .= '<option value="'.$cmpt['userid'].'" '.$cmpt['selected_u2'].'>'.$cmpt['username'].'</option>';
	}
	$u1_select .= '</select>';
	$u2_select .= '</select>';
		$chlls = $vbulletin->db->query_read("
			SELECT games.*, games.u AS uid, games.u2 AS u2id,
			" . (!$team ? "user.username AS u, userb.username AS u2" : "user.teamname AS u, userb.teamname AS u2") . "
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (games.u = user.userid) LEFT JOIN " . TABLE_PREFIX . "user AS userb ON (games.u2 = userb.userid)" : "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user ON (games.u = user.teamid) LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS userb ON (games.u2 = userb.teamid)") . "
			WHERE games.lid = '$id'
				AND games.finished = '1'
				" . ($ladder['filter_round'] ? " AND games.round = '" . $ladder['filter_round']."'" : "")
				. ($ladder['filter_group'] ? " AND games.group = '" . $ladder['filter_group']."'" : "") . "
				$mysql_cond_and
			ORDER BY games.dateline_finished DESC, games.id DESC
			LIMIT 0, 51
		");
		$rowno = 0;
		$chllarray = array();
		$mc_ids_array = array();
		while($chll = $vbulletin->db->fetch_array($chlls))
		{
			$rowno++;
			if ($rowno != 51)
			{
				$chll['display'] = 'none';
				if (
					$vbulletin->options['tmnt_ladder_priv_mc'] &&
						(  (!$team && !in_array($vbulletin->userinfo['userid'], array($chll['uid'],$chll['u2id'])))
						OR
						($team && !in_array($chll['uid'],$tml_array) && !in_array($chll['u2id'],$tml_array))  )
				)
				{
					$chll['hide_mc'] = true;
				}
				$chllarray["$chll[id]"] = $chll;
				if ($chll['comments'] > 0 && !$chll['hide_mc'])
				{
					$mc_ids_array[] = $chll['id'];
				}
			}
			else
			{
				$show['morechll'] = true;
			}
		}
		if (!empty($mc_ids_array))
		{
			$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
			
		}
		
			$templater = vB_Template::create('tmnt_ladder_searchmatches');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('id', $id);
				$templater->register('lid', $lid);
				$templater->register('sh', $sh);
				$templater->register('chll', $chll);
				$templater->register('team', $team);
				$templater->register('rowno', $rowno);
				$templater->register('chllarray', $chllarray);
				$templater->register('u1', $u1);
				$templater->register('u2', $u2);
				$templater->register('u1_select', $u1_select);
				$templater->register('u2_select', $u2_select);
			$competitors .= $templater->render();
	$tlhtml = $competitors;
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname
	);
	if (!$ladder['league'])
	{
		$navbits['ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'showonly=ladders'] = $vbphrase['ladders'];
	}
	else
	{
		$navbits['ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'showonly=leagues'] = $vbphrase['ladder_leagues'];
	}
	if ($ladder['parenttitle'])
	{
		$navbits['ladders.php?c=' . $ladder['parentid'] . $vbulletin->session->vars['sessionurl_q']] = $ladder['parenttitle'];
	}
	$navbits['ladders.php?c=' . $ladder['catid'] . $vbulletin->session->vars['sessionurl_q']] = $ladder['categorytitle'];
	$navbits[''] = construct_phrase($ladder['title']);
	$navbar = render_navbar_template(construct_navbits($navbits));
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################

$vbulletin->input->clean_gpc('g', 'id', TYPE_UINT);

if (!$_REQUEST['do'] && $vbulletin->options['tmnt_premium'] && !$vbulletin->GPC['id'])
{
	$thisurl = end(explode('/',$vbulletin->input->clean($_SERVER['REQUEST_URI'], TYPE_NOHTML)));
	if (substr($thisurl, 0, 13)=='ladders.php?l' && strlen($thisurl)>13)
	{
		$id = $lid = $vbulletin->input->clean(substr($thisurl,13), TYPE_UINT);
		if ($lid)
		{
			$_REQUEST['do'] = 'view';
			$_REQUEST['id'] = $lid;
		}
	}
}

if ($_REQUEST['do'] == 'view')
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	if ($tmntp['caneditladder'] && file_exists(DIR . '/tll_modules/tll_editcolors.php'))
	{
		$tmntp['caneditcolors'] = true;
	}
	if (!$lid)
	{
		$lid = $id = $vbulletin->GPC['id'];
	}
	if (!$id)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
        eval(standard_error($errormessage));
	}
	$ladder = $vbulletin->db->query_first("
		SELECT ladders.*, ladders.cr_userid AS userid, ladders.cr_username AS username
		FROM " . TABLE_PREFIX . "tmnt_ladders AS ladders
		WHERE ladders.id = '$id'
	");
	($hook = vBulletinHook::fetch_hook('tll_ladder_view_post_query')) ? eval($hook) : false;
	if (!$ladder)
	{
		$errormessage = $vbphrase[error_invalid_ladder];
        eval(standard_error($errormessage));
	}
	$ladder['url'] = tll_seo('ladder', $ladder['id'], $ladder['title']);
	if ($vbulletin->options['tmnt_premium'] && $vbulletin->options['tmnt_seo'] && !$thisurl)
	{
		$thisurl = end(explode('/',$vbulletin->input->clean($_SERVER['REQUEST_URI'], TYPE_NOHTML)));
		if (substr($thisurl, 0, 27)=='ladders.php?do=view&amp;id=')
		{
			$thisurl = str_replace('&amp;','&',$ladder['url'].substr($thisurl,27+strlen($id)));
			Header( "HTTP/1.1 301 Moved Permanently" ); 
			Header( "Location: ".$vbulletin->options['bburl']."/ladders.php".$thisurl ); 
		}
	}
	if ($ladder['catid'])
	{
		$ladder['categorytitle'] = $vbulletin->tll_catcache["$ladder[catid]"]['title'];
		$ladder['categoryurl'] = $vbulletin->tll_catcache["$ladder[catid]"]['url'];
		$ladder['parentid'] = $vbulletin->tll_catcache["$ladder[catid]"]['parentid'];
		if ($ladder['parentid'])
		{
			$ladder['parenttitle'] = $ladder['categorytitle2'] = $vbulletin->tll_catcache["$ladder[parentid]"]['title'];
			$ladder['parenturl'] = $vbulletin->tll_catcache["$ladder[parentid]"]['url'];
		}
	}
	$ladder['tmnt_status'] = $ladder['status'];
	if ($ladder['knockout'] > 0)
	{
		$vbphrase['ladder_singles_league'] = $vbphrase['ladder_singles_league_knockout'];
	}
	if ($ladder['league'] > 0)
	{
		$vbulletin->options['tmnt_ladder_ranking'] = 'xp';
		$vbulletin->options['tmnt_elorating'] = 0;
		if ($ladder['pot'])
		{
			$ladder['typetext'] = $vbphrase['ladder_teams_league'];
		}
		else
		{
			$ladder['typetext'] = $vbphrase['ladder_singles_league'];
		}
		$vbphrase['ladder_join'] = $vbphrase['ladder_league_join'];
		$vbphrase['ladder_leave'] = $vbphrase['ladder_league_leave'];
		$vbphrase['ladder_delete'] = $vbphrase['ladder_league_delete'];
		$vbphrase['ladder_details'] = $vbphrase['ladder_league_details'];
		$vbphrase['ladder_closing_on'] = $vbphrase['league_closing_on'];
		$vbphrase['ladder_starting_on'] = $vbphrase['league_starting_on'];
		$vbphrase['ladder_finished_on'] = $vbphrase['league_finished_on'];
	}
	else
	{
		if ($ladder['pot'])
		{
			$ladder['typetext'] = $vbphrase['ladder_teams_ladder'];
		}
		else
		{
			$ladder['typetext'] = $vbphrase['ladder_singles'];
		}
	}
	$ladder['groupnames'] = explode(',', $ladder['groupnames']);
	$ladder['urlencoded'] = urlencode($vbulletin->options['bburl']."/ladders.php?do=view&id=".$ladder['id']);
	if ($ladder['archive'] == 1 && $ladder['dateline_to'] && $ladder['dateline_from'] && $ladder['dateline_from'] <= TIMENOW && TIMENOW <= $ladder['dateline_to'])
	{
		$vbulletin->db->query_write("
			UPDATE " . TABLE_PREFIX . "tmnt_ladders SET archive = 0 WHERE id = '$id'
		");
		$ladder['archive'] = 0;
	}
	elseif ($ladder['archive'] == 0 && $ladder['dateline_to'] && $ladder['dateline_from'] && ($ladder['dateline_to'] < TIMENOW OR $ladder['dateline_from'] > TIMENOW))
	{
		if ($ladder['league'] != 1)
		{
			$vbulletin->db->query_write("
				UPDATE " . TABLE_PREFIX . "tmnt_ladders SET archive = 1 WHERE id = '$id'
			");
		}
		$ladder['archive'] = 1;
	}
	switch ($ladder['archive'])
	{
		case 0:
			$ladder['status'] = $vbphrase['ladder_open'];
			break;
		case 1:
			$ladder['status'] = $vbphrase['ladder_closed'];
			break;
	}
	if ($ladder['archive'] == 1 && $ladder['dateline_from'] && $ladder['dateline_from'] > TIMENOW)
	{
		$ladder['status'] = $vbphrase['ladder_startingsoon'];
	}
	if ($ladder['league'] == 1)
	{
		$ladder['archive'] = 0;
		$ladder['status'] = $vbphrase['ladder_signups'];
	}
	if ($ladder['groupid'])
	{
		$gladders = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladders
			WHERE groupid = '" . $ladder['groupid'] . "'
		");
		$sarray = array();
		while($gl = $vbulletin->db->fetch_array($gladders))
		{
			if ($gl['id'] == $ladder['id'])
			{
				$gl['selected'] = ' selected="selected"';
			}
			$sarray[] = $gl;
		}
		$gltitle = $vbphrase['tmnt_newladder'];
		if ($ladder['league'])
		{
			$gltitle = $vbphrase['tmnt_newleague'];
		}
		$sarray[] = array('id' => '999','title' => $gltitle);
	}
	$ladder['dateline'] = vbdate($vbulletin->options['dateformat'],$ladder['cr_time']);
	$ladder['ed_time'] = vbdate($vbulletin->options['timeformat'],$ladder['ed_time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$ladder['ed_time']);
	$title = $ladder['title'];
	$title2 = addslashes($ladder['title']);
	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
	$ladder['description'] = $bbcode_parser->do_parse($ladder['description']);
	list($ladder['description'], $ladder['rules']) = preg_split('/\[rules\]/', $ladder['description']);
	$ladder['rules'] = trim($ladder['rules']);
	if (substr($ladder['rules'],0,6)=='<br />')
	{
		$ladder['rules'] = substr($ladder['rules'],6);
	}
	if (file_exists(DIR . '/includes/functions_tll_tabs.php'))
	{
		$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_UINT);
		require_once(DIR . '/includes/functions_tll_tabs.php');
		$template_hook = tll_tabs($template_hook, 0, $lid, 0);
		$show['addtab'] = true;
	}
	$team = false;
	if ($ladder['pot'])
	{
		$team = true;
	}
	$ladder['hide'] = $hide = $vbulletin->input->clean_gpc('g', 'hide', TYPE_NOHTML);
	
	if ($ladder['league'] > 0 && $vbulletin->options['tmnt_premium'] && $ladder['tmnt_status'] > 0)
	{
		$ladder['tmnt_act_pcount'] = $ladder['knockout'] * $ladder['groups'];//knockout-actual player count
		$ladder['tmnt_noplayers'] = ceil($ladder['tmnt_act_pcount'] / 4) * 4;//tmnt noplayers - includes dummy spaces
		$ladder['show_tmnt_h2'] = true;
		if ($_REQUEST['sh'] == 8)
		{
			$ladder['show_tmnt_div'] = true;
		}
	}
	if (!in_array($_REQUEST['sh'], array(1,2,3,4,5,6,7,8)) || ($team && in_array($_REQUEST['sh'], array(3,5))))
	{
		$cpp = $vbulletin->input->clean($vbulletin->options['tmnt_lcpp'], TYPE_UINT);
		$countcomps = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players WHERE lid=$lid AND active=1" . ($hide == 'unranked' ? " AND (players.wins > 0 OR players.draws >0 OR players.loses > 0) " : "") . "");
		$noofcomps = $countcomps['countrows'];
		if (!$hide && $noofcomps != $ladder['noplayers'])
		{
			$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "tmnt_ladders SET noplayers = '".$noofcomps."' WHERE id = '$lid'");
			$ladder['noplayers'] = $noofcomps;
		}
		$lastpage = ceil($noofcomps/$cpp);
		$page = $vbulletin->input->clean_gpc('g', 'page', TYPE_UINT);
		if ($page == 0)
		{
			$page = 1;
		}
		elseif ($page > $lastpage)
		{
			$page = $lastpage;
		}
		$offset = ($page - 1) * $cpp;
		if ($offset < 0)
		{
			$offset = 0;
		}
	}
	if (!in_array($_REQUEST['sh'], array(1,2,3,4,5,6,7,8,9,10,11,12,13,14)) || ($team && in_array($_REQUEST['sh'], array(3))) || (!$vbulletin->options['tmnt_showrules'] && $_REQUEST['sh'] == 6))
	{
		$row_css = $lc_array = array();
		$lc_query = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_leaguecolors
			WHERE lid='$lid'
		");
		$lc_i = 0;
		while($lc = $vbulletin->db->fetch_array($lc_query))
		{
			//$lc['from']
			while ($lc['from'] <= $lc['to'])
			{
				$row_css["$lc[from]"] .= 'background: #'.$lc['color'].';';
				$lc['from']++;
			}
		}
		$_REQUEST['sh'] = 0;
		$sh = 0;
		if ($lastpage > 1)
		{
			$showpaging = true;
		}
		else
		{
			$showpaging = false;
		}
		if ($noofcomps > 0)
		{
			$from = $offset + 1;
			if ($lastpage == $page) {
				$to = $noofcomps;
			} else {
				$to = $page * $cpp;
			}
		} else {
			$from = 0;
			$to = 0;
		}
		$ladder['colspan'] = 9;
		if ($tmntp['ladder_superuser'])
		{
			$ladder['colspan']++;
		}
		if (!$vbulletin->options['tmnt_elorating'])
		{
			$ladder['colspan']--;
		}	
		if ($_REQUEST['rankingsonly'] || $_REQUEST['embed'])
		{
			$embed = true;
		}
		$array = array();
		$winnerlist = array();
		$rowno = $offset;
		$toprank = 1;
		$myteams = fetch_myteams();
		if ($ladder['racemode'])
		{
			function array_remove_value($array, $del_val)
			{
				if(($key = array_search($del_val, $array)) !== false)
				{
					unset($array[$key]);
				}
				return $array;
			}
			$vbulletin->options['tmnt_ladder_columns'] = array_remove_value($vbulletin->options['tmnt_ladder_columns'], 'draws');
			$vbulletin->options['tmnt_ladder_columns'] = array_remove_value($vbulletin->options['tmnt_ladder_columns'], 'losses');
			$vbulletin->options['tmnt_ladder_columns'] = array_remove_value($vbulletin->options['tmnt_ladder_columns'], 'pointsdifference');
			$vbulletin->options['tmnt_ladder_columns'] = array_remove_value($vbulletin->options['tmnt_ladder_columns'], 'streak');
			//$vbulletin->options['tmnt_ladder_columns'] = array_remove_value($vbulletin->options['tmnt_ladder_columns'], 'xp');
			$vbulletin->options['tmnt_ladder_columns'] = array_remove_value($vbulletin->options['tmnt_ladder_columns'], 'lastresults');
			$vbulletin->options['tmnt_ladder_columns'] = array_remove_value($vbulletin->options['tmnt_ladder_columns'], 'la');
			$vbulletin->options['tmnt_ladder_columns'] = array_remove_value($vbulletin->options['tmnt_ladder_columns'], 'points');
			//print_r($vbulletin->options['tmnt_ladder_columns']);
		}
		function tll_lr_html($wld, $lr)
		{
			global $vbphrase;
			$html = '';
			$html = ' <span title="' . ($lr['round'] ? construct_phrase($vbphrase['tmnt_round_x'], $lr[round])." : " : "") . ''.$lr['u'].' '.$lr['score_u'].'-'.$lr['score_u2'].' '.$lr['u2'].'" style="'.($wld=='L'?"color:#A80000;":"").($wld=='W'?"color:#009933;":"").'">'.$wld.'</span> ';
			return $html;
		}
vB_Template::preRegister('memberaction_dropdown',array('tmntp' => $tmntp));
		if (file_exists(DIR . '/tll_modules/tll_editbadge.php'))
		{
			$tmntp['caneditbadge'] = true;
			$headinclude .= '<script src="clientscript/tll_preview_popup.js" type="text/javascript"></script>';
			$headinclude .= "\r\n\r\n".'<style> #preview{ 	position:absolute; 	border:1px solid #ccc;	background:#333;	padding:5px;	display:none; 	color:#fff;	}</style>';
		}
		$cmpts = $vbulletin->db->query_read("
			SELECT " . (!$team ? "user.*, " : "") . " players.*, players.userid AS userid
			" . (!$team ? ", user.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight, user.username AS username" : ", team.teamlogo AS avatarurl") . "
			" . (($vbulletin->options['tmnt_joinuf'] && !$team) ? ", userfield.*, usertextfield.* " : "") . ", players.rank AS rank
		FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players
		" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (players.userid = user.userid) LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = user.avatarid) LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = user.userid) " : " LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS team ON (players.userid = team.teamid)") . "
		" . (($vbulletin->options['tmnt_joinuf'] && !$team) ? " LEFT JOIN " . TABLE_PREFIX . "userfield AS userfield ON (user.userid = userfield.userid) LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (usertextfield.userid = user.userid) " : "") . "
		WHERE players.lid=$id 
			AND players.active=1
			" . ($hide == 'unranked' ? " AND (players.wins > 0 OR players.draws >0 OR players.loses > 0) " : "") . "
		ORDER BY 
			players.group ASC,
			" . ($vbulletin->options['tmnt_ladder_ranking'] == 'elo' ? "players.rank DESC," : "")
			. ($vbulletin->options['tmnt_ladder_ranking'] == 'xp' ? "players.xp DESC," : "") . "
			players.wins DESC,
			players.draws DESC,
			players.loses ASC,
			" . ($vbulletin->options['tmnt_ladder_ranking'] == 'elo' ? "players.xp DESC, " : "") . "
			players.totalpoints DESC,
			players.pointsagainst ASC
		". (!$ladder['league'] ? "LIMIT $offset, $cpp" : "") . "
		");
		$ti = 0;
		while($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			//print_r($vbulletin->options['tmnt_ladder_inactivity']);
			//print_r($cmpt);
			if ($vbulletin->options['tmnt_ladder_inactivity']>0 && $cmpt['latime']>0)
			{
				//$cmpt
				//print_r($cmpt);
				$cmpt['la_inactivity'] = TIMENOW-$cmpt['latime'];
				if ($cmpt['la_inactivity']>$vbulletin->options['tmnt_ladder_inactivity']*86400)
				{
					//print_r("\r\n $cmpt[username] $cmpt[latime] : ... ".(TIMENOW-$cmpt['latime'])."  aa  ");
					//print_r(($cmpt['la_inactivity']/86400)." <br />  ");
					//print_r("\r\n <br> ".(TIMENOW)."  ");
					//print_r("\r\n <br> ".(TIMENOW-$vbulletin->options['tmnt_ladder_inactivity']*86400)."  ");
					$aa = $vbulletin->db->query_first("
						UPDATE " . TABLE_PREFIX . "tmnt_ladder_players
						SET active = 0
						WHERE latime > 0
							AND latime < ".(TIMENOW-$vbulletin->options['tmnt_ladder_inactivity']*86400)."
							AND lid = '$lid'
							AND active = 1
						ORDER BY id DESC
					");
					$vbulletin->url = "ladders.php".$ladder['url'];	
					eval(print_standard_redirect('redirect_updateladder'));
					//$url = $vbulletin->options['bburl']."".$vbulletin->input->clean($_SERVER['REQUEST_URI'], TYPE_NOHTML);
					//header("Refresh: 0; url=$url");
					//print_r($url."  ");
					//print_r($aa);
					exit;
				}
				//$page = ;
				//header("Refresh: $sec; url=$page");
				//exit;
				//refresh page...
			}
			if ($cmpt['group'] > 1 && $cmpt['group'] > $lastcmpt['group'])
			{
				$c_idx = $cmpt['group'] - 1;
				$ladder['thisgroup'] = $cmpt['group'];
				//$ccompetitors .= "</tr></table><h3 class=\"blocksubhead\" colspan=\"".$ladder['colspan']."\"><a name=\"group".$cmpt['group']."\"></a>" . ($ladder['groupnames']["$c_idx"] ? $ladder['groupnames']["$c_idx"] : construct_phrase($vbphrase['ladder_league_group_x'], $cmpt['group'])) . "</h3><table class=\"blockbody\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" width=\"100%\"><tbody><tr>";
				$ccompetitors .= "</tbody></table></div>";
				$ladder['thisgroupname'] = $ladder['groupnames']["$c_idx"];
				$templater = vB_Template::create('tmnt_ladder_cmpt_top');
					$templater->register('tmntp', $tmntp);
					$templater->register('ladder', $ladder);
					$templater->register('id', $id);
					$templater->register('lid', $lid);
					$templater->register('from', $from);
					$templater->register('to', $to);
					$templater->register('ti', $ti);
					$templater->register('c_idx', $c_idx);
					$templater->register('noofcomps', $noofcomps);
					$templater->register('sh', $sh);
				$ccompetitors .= $templater->render();
				$cmpt['row'] = 1;
				$rowno = 0;
			}
			if ($team && in_array($cmpt['userid'], $myteams))
			{
				$cmpt['myteam'] = true;
			}
			$cmpt = process_tl_avatar($cmpt);
			$avatarlp = $cmpt['avatarlp'];
			$cmpt['time2'] = "<span class=\"smallfont\">".vbdate($vbulletin->options['dateformat'],$cmpt['time'])." <span class=\"time\"> ".vbdate($vbulletin->options['timeformat'],$cmpt['time'])."</span></span>";
			$cmpt['time3'] = " ".vbdate($vbulletin->options['dateformat'],$cmpt['time'])." ".vbdate($vbulletin->options['timeformat'],$cmpt['time'])." ";
			$cmpt['time'] = ' <span title="'.vbdate($vbulletin->options['dateformat'],$cmpt['time'])." ".vbdate($vbulletin->options['timeformat'],$cmpt['time']).'"> '.vbdate($vbulletin->options['dateformat'],$cmpt['time'])." </span> ";
			$var = $cmpt['userid'];
			$array = array_merge((array)$var, $array);
			$rank = $cmpt['rank'];
			if ($cmpt['lstreak'] > 0) {
				$streak = -$cmpt['lstreak'];
			} else {
				$streak = $cmpt['wstreak'];
			}
			if ($cmpt['latime'] == 0)
			{
				$cmpt['latime'] = "-";
			} 
			else
			{
				$cmpt['latime'] = " ".vbdate($vbulletin->options['dateformat'],$cmpt['latime'], 1);
			}
			if ($rowno == $offset)
			{
				$toprank = $rank;
				$lastrank_rank = $toprank;
				$lastrank_row = $offset+1;
			}
			if ($toprank == $rank)
			{
				$var2 = $cmpt['userid'];
				$winnerlist = array_merge((array)$var2, $winnerlist);
			}
			if ($cmpt['badge'])
			{
				$show['badges'] = true;
			}
			$rowno++;
			$cmpt['css'] = $row_css["$rowno"];
			$cmpt['rowno'] = $rowno;
			if ($rank == $lastrank_rank && $rowno != ($offset+1) && $cmpt['xp'] == $lastrank_xp)
			{
				$cmpt['row'] = $lastrank_row ."=";
			}
			else
			{
				$lastrank_row = $rowno;
				$lastrank_rank = $rank;
				$lastrank_xp = $cmpt['xp'];
				$cmpt['row'] = $rowno;
			}
			$ddms = "cmpt".$rowno;
			$cmpt['col'] = "cmpt_". $cmpt['userid'];
			$cmpt['obj'] = "collapseobj_cmpt_". $cmpt['userid'];
			$cmpt['matches'] = $cmpt['wins'] + $cmpt['draws'] + $cmpt['loses'];
			if ($cmpt['wins']>0 AND $cmpt['matches']>0) $cmpt['winp'] = $cmpt['wins'] / $cmpt['matches'] * 100;
			$cmpt['winp'] = (int)$cmpt['winp'];
			if ($cmpt['matches'] > 0)//dom
			{
				$cmpt['pointsaverage'] = vb_number_format(($cmpt['totalpoints'] / $cmpt['matches']), 2);
				$cmpt['pointsaverage'] = str_replace(".00", "", $cmpt['pointsaverage']);
			}
			$cmpt['pointsdifference'] = $cmpt['totalpoints'] - $cmpt['pointsagainst'];
			if (in_array('lastresults', $vbulletin->options['tmnt_ladder_columns']) && $ladder['league'] != '1' && $vbulletin->options['tmnt_premium'])
			{
				$lr_query = $vbulletin->db->query_read("
					SELECT games.*, games.u AS uid, games.u2 AS u2id, 
						" . (!$team ? "user.username AS u, userb.username AS u2" : "user.teamname AS u, userb.teamname AS u2") . "
					FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
					" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (games.u = user.userid) LEFT JOIN " . TABLE_PREFIX . "user AS userb ON (games.u2 = userb.userid)" : "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user ON (games.u = user.teamid) LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS userb ON (games.u2 = userb.teamid)") . "
					WHERE games.lid = '$lid'
						AND games.finished = '1'
						AND (games.u = '".$cmpt['userid']."' OR games.u2 = '".$cmpt['userid']."')
					ORDER BY games.dateline_finished DESC
					LIMIT 0, 3
				");
				while($lr = $vbulletin->db->fetch_array($lr_query))
				{
					if ($lr['uid'] == $cmpt['userid'])
					{//is_u
						if ($lr['score_u']>$lr['score_u2'])
						{
							$cmpt['lr_html'] .= tll_lr_html('W', $lr);
						}
						elseif ($lr['score_u']<$lr['score_u2'])
						{
							$cmpt['lr_html'] .= tll_lr_html('L', $lr);
						}
						elseif ($lr['score_u']==$lr['score_u2'])
						{
							$cmpt['lr_html'] .= tll_lr_html('D', $lr);
						}
					}
					elseif ($lr['u2id'] == $cmpt['userid'])
					{//is_u2
						if ($lr['score_u']<$lr['score_u2'])
						{
							$cmpt['lr_html'] .= tll_lr_html('W', $lr);
						}
						elseif ($lr['score_u']>$lr['score_u2'])
						{
							$cmpt['lr_html'] .= tll_lr_html('L', $lr);
						}
						elseif ($lr['score_u']==$lr['score_u2'])
						{
							$cmpt['lr_html'] .= tll_lr_html('D', $lr);
						}
					}
					else
					{
						continue;
					}
				}
			}
			$cmpt['lid'] = $lid;
			if ($team)
			{
				$cmpt['teamurl'] = tll_seo('team', $cmpt['userid'], $cmpt['username']);
			}
			$cmpt['userhtml'] = tll_userhtml($cmpt, $team, 1);
			vB_Template::preRegister('memberaction_dropdown',array('team' => $team));
			vB_Template::preRegister('memberaction_dropdown',array('lid' => $lid)); 
			vB_Template::preRegister('memberaction_dropdown',array('ladder' => $ladder));
			$vbulletin->templatecache['memberaction_dropdown'] = $vbulletin->templatecache['tmnt_memberaction_dropdown'];
			$memberaction_dropdown = construct_memberaction_dropdown($cmpt, $template_hook);
			$memberaction_dropdown = str_replace('</strong></a>', '</strong></a>'.$cmpt['userhtml'], $memberaction_dropdown);
			if ($cmpt['warlight']>TIMENOW && $vbulletin->options['tmnt_warlights'])
			{
				$cmpt['show_warlight_enabled'] = true;
			}
			if ($ladder['league'] != '1')
			{
				$c_idx = 0;
				$ladder['thisgroup'] = 1;
				$templater = vB_Template::create('tmnt_ladder_cmpt');
					$templater->register('tmntp', $tmntp);
					$templater->register('ladder', $ladder);
					$templater->register('id', $id);
					$templater->register('lid', $lid);
					$templater->register('cmpt', $cmpt);
					$templater->register('ddms', $ddms);
					$templater->register('rank', $rank);
					$templater->register('rowno', $rowno);
					$templater->register('avatarlp', $avatarlp);
					$templater->register('c_idx', $c_idx);
					$templater->register('team', $team);
					$templater->register('streak', $streak);
					$templater->register('memberaction_dropdown', $memberaction_dropdown);
				$ccompetitors .= $templater->render();
			}
			else
			{
				$competitors[] = $cmpt;
			}
			$ddms_id = "cmpt".$rowno."_menu";
			$ti++;
			$lastcmpt = $cmpt;
		}
		$ladder['ti'] = $ti;
		if ($ladder['league'] != '1')
		{
			$ladder['thisgroupname'] = $ladder['groupnames']["0"];
			$templater = vB_Template::create('tmnt_ladder_cmpt_top');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('id', $id);
				$templater->register('lid', $lid);
				$templater->register('from', $from);
				$templater->register('to', $to);
				$templater->register('ti', $ti);
				$templater->register('noofcomps', $noofcomps);
				$templater->register('sh', $sh);
			$competitors .= $templater->render();
			$competitors .= $ccompetitors;
		}
		if ($rowno == $offset)
		{
			$templater = vB_Template::create('tmnt_ladder_cmpt_none');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('id', $id);
				$templater->register('lid', $lid);
				$templater->register('cmpt', $cmpt);
				$templater->register('ddms', $ddms);
				$templater->register('rank', $rank);
				$templater->register('rowno', $rowno);
			$competitors .= $templater->render();
		}
		if (!$ladder['league'])
		{
			$pagenav = construct_page_nav($page, $cpp, $noofcomps, "ladders.php?" . $vbulletin->session->vars['sessionurl'] . "do=view&amp;id=$lid", "". ($hide ? "&amp;hide=$hide" : "") . ($embed ? "&amp;embed=1" : "") . "", "content");
		}
		if ($ladder['league'] != '1')
		{
			$templater = vB_Template::create('tmnt_ladder_cmpt_bot');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('id', $id);
				$templater->register('lid', $lid);
			$competitors .= $templater->render();
		}
		if ((in_array($thisuserid, $array) OR $team) AND $show['member']) {
			$comper = true;
		} else {
			$userid = $thisuserid;
			$username = $thisusername;
			$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid='$id' AND (userid='$userid' OR username='".$vbulletin->db->escape_string($username)."') AND active=1 ");
			$countplayer = $countplayer['countrows'];  
			if ($countplayer != 0) {
				$comper = true;
			} else {
				$comper = false;
				$competitorddms = str_replace("{comper}", "display: none;", $competitorddms);
			}
		}
	}
	else 
	{
		$userid = $thisuserid;
		$username = $thisusername;
		if (!$team) 
		{
			$countplayer = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_ladder_players WHERE lid='$id' AND (userid='$userid' OR username='".$vbulletin->db->escape_string($username)."') AND active=1 ");
			$countplayer = $countplayer['countrows'];  
			if ($countplayer != 0) {
				$comper = true;
			} else {
				$comper = false;
			}
		}
	}
	/***/
	if ($team && $vbulletin->options['tmnt_ladder_priv_mc'] && in_array($_REQUEST['sh'], array(1,2)))
	{//teamids array of user teams in control (leaders or co-leaders)
		$tml_array = array();
		$tml_query = $vbulletin->db->query_read("
			SELECT teamid FROM " . TABLE_PREFIX . "tmnt_members WHERE userid='".$vbulletin->userinfo['userid']."' AND (leader=1 OR coleader=1)
		");
		while($tml_data = $vbulletin->db->fetch_array($tml_query))
		{
			$tml_array[] = $tml_data['teamid'];
		}
	}
	/***/
	if ($_REQUEST['sh'] == 1 && !$ladder['racemode'])
	{
		$sh = 1;
		if ($ladder['league'])
		{
			$maxrounds = $vbulletin->db->query_first("SELECT g.round FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g WHERE g.lid = '$ladder[id]' AND g.group = 1 ORDER BY g.round DESC");
			$ladder['rounds'] = $maxrounds['round'];
		}
		$ladder['filter_round'] = $vbulletin->input->clean_gpc('g', 'round', TYPE_UINT);
		$ladder['filter_group'] = $vbulletin->input->clean_gpc('g', 'group', TYPE_UINT);
		$ladder['selected']['group_'.$ladder['filter_group']] = ' selected="selected"';
		$ladder['selected']['round_'.$ladder['filter_round']] = ' selected="selected"';
		$templater = vB_Template::create('tmnt_ladder_allchll_top');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
		$competitors .= $templater->render();
		$chlls = $vbulletin->db->query_read("
			SELECT games.*, games.u AS uid, games.u2 AS u2id,
			" . (!$team ? "user.username AS u, userb.username AS u2" : "user.teamname AS u, userb.teamname AS u2") . "
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (games.u = user.userid) LEFT JOIN " . TABLE_PREFIX . "user AS userb ON (games.u2 = userb.userid)" : "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user ON (games.u = user.teamid) LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS userb ON (games.u2 = userb.teamid)") . "
			WHERE games.lid = '$id'
				AND games.finished = '1'
				" . ($ladder['filter_round'] ? " AND games.round = '" . $ladder['filter_round']."'" : "")
				. ($ladder['filter_group'] ? " AND games.group = '" . $ladder['filter_group']."'" : "") . "
			ORDER BY games.dateline_finished DESC, games.id DESC
			LIMIT 0, 11
		");
		$rowno = 0;
		$chllarray = array();
		$mc_ids_array = array();
		while($chll = $vbulletin->db->fetch_array($chlls))
		{
			$rowno++;
			if ($rowno != 11)
			{
				$chll['display'] = 'none';
				if (
					$vbulletin->options['tmnt_ladder_priv_mc'] &&
						(  (!$team && !in_array($vbulletin->userinfo['userid'], array($chll['uid'],$chll['u2id'])))
						OR
						($team && !in_array($chll['uid'],$tml_array) && !in_array($chll['u2id'],$tml_array))  )
				)
				{
					$chll['hide_mc'] = true;
				}
				if ($team)
				{
					$chll['teamurl_u'] = tll_seo('team', $chll['uid'], $chll['u']);
					$chll['teamurl_u2'] = tll_seo('team', $chll['u2id'], $chll['u2']);
				}
				$chllarray["$chll[id]"] = $chll;
				if ($chll['comments'] > 0 && !$chll['hide_mc'])
				{
					$mc_ids_array[] = $chll['id'];
				}
			}
			else
			{
				$show['morechll'] = true;
			}
		}
		if ($rowno == 0)
		{
			$templater = vB_Template::create('tmnt_ladder_allchll_none');
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('id', $id);
				$templater->register('lid', $lid);
				$templater->register('sh', $sh);
				$templater->register('chll', $chll);
				$templater->register('team', $team);
				$templater->register('rowno', $rowno);
			$competitors .= $templater->render();
		}
		else if (!empty($mc_ids_array))
		{
			$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
		}
		$templater = vB_Template::create('tmnt_ladder_allchll_bot');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('chll', $chll);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
		$competitors .= $templater->render();
	}
	elseif ($_REQUEST['sh'] == 1 && $ladder['racemode'])
	{
		$sh = 1;
		$ladder['filter_round'] = $vbulletin->input->clean_gpc('g', 'round', TYPE_UINT);
		if (!$ladder['filter_round'])
		{
			$ladder['filter_round'] = 1;
		}
		$ladder['filter_group'] = $vbulletin->input->clean_gpc('g', 'group', TYPE_UINT);
		if (!$ladder['filter_group'])
		{
			$ladder['filter_group'] = 1;
		}
		$ladder['selected']['group_'.$ladder['filter_group']] = ' selected="selected"';
		$ladder['selected']['round_'.$ladder['filter_round']] = ' selected="selected"';
		$rowno = 0;
		if ($ladder['filter_round']==1)
		{
			$sql_g = 'round';
		}
		else
		{
			$sql_g = 'round'.$ladder['filter_round'];
		}
		$ladder['pergroup'] = ceil($ladder['noplayers']/$ladder['groups']);
		//print_r($ladder);
		$pq = $vbulletin->db->query_read("
			SELECT p.*, " . (!$team ? "u.username" : "u.teamname AS username") . " 
			FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
			" . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS u ON (p.userid = u.userid)" : "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS u ON (p.userid = u.teamid)") . "
			WHERE p.lid = '$lid' 
				AND p.group = '".$ladder['filter_group']."'
		");
		while($p = $vbulletin->db->fetch_array($pq))
		{
			$p['rpos'] = $p["$sql_g"];
			$p['sel']["$p[rpos]"] = ' selected="selected"';
			//print_r($p['sel']);
			$pcount++;
			$parray[] = $p;
		}
		//print_r($vbulletin->GPC);
		$templater = vB_Template::create('tmnt_ladder_racemode');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('team', $team);
			$templater->register('parray', $parray);
			$templater->register('pcount', $pcount);
		$competitors .= $templater->render();
		
	}
	elseif ($_REQUEST['sh'] == 2 && !$ladder['racemode'])
	{
		$sh = 2;
		if ($ladder['league'])
		{
			$maxrounds = $vbulletin->db->query_first("SELECT g.round FROM " . TABLE_PREFIX . "tmnt_ladder_games AS g WHERE g.lid = '$ladder[id]' AND g.group = 1 ORDER BY g.round DESC");
			$ladder['rounds'] = $maxrounds['round'];
		}
		$ladder['filter_round'] = $vbulletin->input->clean_gpc('g', 'round', TYPE_UINT);
		$ladder['filter_group'] = $vbulletin->input->clean_gpc('g', 'group', TYPE_UINT);
		$ladder['selected']['group_'.$ladder['filter_group']] = ' selected="selected"';
		$ladder['selected']['round_'.$ladder['filter_round']] = ' selected="selected"';
		$templater = vB_Template::create('tmnt_ladder_allchll_top');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('chll', $chll);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
		$competitors .= $templater->render();
		$chlls = $vbulletin->db->query_read("SELECT games.*, games.u AS uid, games.u2 AS u2id, " . (!$team ? "user.username AS u, userb.username AS u2" : "user.teamname AS u, userb.teamname AS u2") . " FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games " . (!$team ? "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (games.u = user.userid) LEFT JOIN " . TABLE_PREFIX . "user AS userb ON (games.u2 = userb.userid)" : "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user ON (games.u = user.teamid) LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS userb ON (games.u2 = userb.teamid)") . " WHERE games.lid = '$id' AND games.finished = '0' AND games.accepted = '1' " . ($ladder['filter_round'] ? " AND games.round = '" . $ladder['filter_round']."'" : "") . ($ladder['filter_group'] ? " AND games.group = '" . $ladder['filter_group']."'" : "") . " ORDER BY games.dateline ASC LIMIT 0, 11");
		$rowno = 0;
		while($chll = $vbulletin->db->fetch_array($chlls))
		{
			$rowno ++;
			$chll = process_chal_options($chll);
			if ($rowno == 11)
			{
				$show['morechll'] = true;
			}
			else
			{
				if (
					$vbulletin->options['tmnt_ladder_priv_mc'] &&
						(  (!$team && !in_array($vbulletin->userinfo['userid'], array($chll['uid'],$chll['u2id'])))
						OR
						($team && !in_array($chll['uid'],$tml_array) && !in_array($chll['u2id'],$tml_array))  )
				)
				{
					$chll['hide_mc'] = true;
				}
				if ($chll['comments'] > 0 && !$chll['hide_mc'])
				{
					$mc_ids_array[] = $chll['id'];
				}
				$chll['display'] = 'none';
				if ($team)
				{
					$chll['teamurl_u'] = tll_seo('team', $chll['uid'], $chll['u']);
					$chll['teamurl_u2'] = tll_seo('team', $chll['u2id'], $chll['u2']);
				}
				$chllarray["$chll[id]"] = $chll;
			}
		}
		if ($rowno == 0)
		{
			$templater = vB_Template::create('tmnt_ladder_allchll_none');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('chll', $chll);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
			$competitors .= $templater->render();
		}
		else
		{
			if (!empty($mc_ids_array))
			{
				$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
			}
			if (!$vbulletin->options['tmnt_ladder_um_alt'] OR IS_MOBILE_STYLE)
			{
				$templater = vB_Template::create('tmnt_ladder_allchll');
			}
			else
			{
				$templater = vB_Template::create('tmnt_ladder_allchll2');
			}
				$templater->register('tmntp', $tmntp);
				$templater->register('ladder', $ladder);
				$templater->register('id', $id);
				$templater->register('lid', $lid);
				$templater->register('sh', $sh);
				$templater->register('chll', $chll);
				$templater->register('team', $team);
				$templater->register('rowno', $rowno);
				$templater->register('chllarray', $chllarray);
			$competitors .= $templater->render();
		}
		$templater = vB_Template::create('tmnt_ladder_allchll_bot');
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('show', $show);
			$templater->register('chll', $chll);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
		$competitors .= $templater->render();
	}
	elseif ($_REQUEST['sh'] == 3)
	{
		$sh = 3;
		$u = $thisuserid;
		$templater = vB_Template::create('tmnt_ladder_tlchll_top');//tlchll
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('team', $team);
			$templater->register('u', $u);
		$competitors .= $templater->render();
		$games = $vbulletin->db->query_read("
			SELECT games.*, games.u AS uid, games.u2 AS u2id, user.username AS u, user2.username AS u2
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			LEFT JOIN " . TABLE_PREFIX . "user AS user
				ON (games.u = user.userid)
			LEFT JOIN " . TABLE_PREFIX . "user AS user2
				ON (games.u2 = user2.userid)
			WHERE (games.u = $thisuserid OR games.u2 = $thisuserid)
				AND games.finished = 0
				AND games.accepted != -1
				AND games.pot = 0
				AND games.lid = $id	
		"); 
		while($game = $vbulletin->db->fetch_array($games))
		{
			if ($game['u2id'] == 0 && $game['dateline'] < TIMENOW)
			{//remove old match finder challenges which were not accepted
				continue;
			}
			$game = process_chal_options($game);
			$is_u = is_u($game, $thisuserid);
			$is_u2 = is_u2($game, $thisuserid);
			$game['time'] = vbdate($vbulletin->options['timeformat'],$game['time']).$vbphrase['ladder_on'].vbdate($vbulletin->options['dateformat'],$game['time']);
			$game = switch_match_status($game, $is_u, $is_u2, 'ladder');
			$rowno++ ;
			$game['display'] = 'none';
			if ($game['comments'] > 0)
			{
				$mc_ids_array[] = $game['id'];
			}
			$chllarray["$game[id]"] = $game;
		}
		if (!empty($mc_ids_array))
		{
			$chllarray = fetch_ladder_mcs($mc_ids_array, $chllarray);
		}
		$templater = vB_Template::create('tmnt_ladder_chll');//tlchll
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
			$templater->register('u', $u);
			$templater->register('game', $game);
			$templater->register('chllarray', $chllarray);
		$competitors .= $templater->render();
		$templater = vB_Template::create('tmnt_ladder_chll_bot');//tlchll
			$templater->register('tmntp', $tmntp);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
			$templater->register('u', $u);
		$competitors .= $templater->render();
	}
	elseif ($_REQUEST['sh'] == '4')
	{
		$sh = 4;
		$tcount = 0;
		$tmntarray = array();
		$tmnts = $vbulletin->db->query_read("
			SELECT tmnts.id, tmnts.title, w.username AS username, w.userid AS userid
			FROM " . TABLE_PREFIX . "tmnt_tmnts AS tmnts
			LEFT JOIN " . TABLE_PREFIX . "tmnt_players AS w
				ON (w.tid = tmnts.id AND w.winner = 1)
			WHERE tmnts.ladderid = '$lid'
			GROUP BY tmnts.id
		"); /*AND winner.winner = 1*/
		while($tmnt = $vbulletin->db->fetch_array($tmnts))
		{
			$tmntarray[] = $tmnt;
			$tcount++;
		}
		$templater = vB_Template::create('tmnt_ladder_tmnts');
			$templater->register('tmntp', $tmntp);
			$templater->register('tmntarray', $tmntarray);
			$templater->register('tcount', $tcount);
			$templater->register('ladder', $ladder);
			$templater->register('id', $id);
			$templater->register('lid', $lid);
			$templater->register('sh', $sh);
			$templater->register('team', $team);
			$templater->register('rowno', $rowno);
			$templater->register('u', $u);
		$competitors .= $templater->render();
	}
	elseif ($_REQUEST['sh'] == 5)
	{
		$sh = 5;
		//paginate this
		$ladder['yourteams'] = array();
		$ladder['teamcount'] = 0;
		if ($ladder['pot'])
		{
			$teams = $vbulletin->db->query_read("
				SELECT *
				FROM " . TABLE_PREFIX . "tmnt_members
				RIGHT JOIN " . TABLE_PREFIX . "tmnt_teams
					ON " . TABLE_PREFIX . "tmnt_members.teamid = " . TABLE_PREFIX . "tmnt_teams.teamid
				RIGHT JOIN " . TABLE_PREFIX . "tmnt_ladder_players
					ON " . TABLE_PREFIX . "tmnt_members.teamid = " . TABLE_PREFIX . "tmnt_ladder_players.userid
				WHERE " . TABLE_PREFIX . "tmnt_members.leader=1
					AND " . TABLE_PREFIX . "tmnt_members.userid=$thisuserid
					AND " . TABLE_PREFIX . "tmnt_ladder_players.lid=$lid
			");
			while($teamm = $vbulletin->db->fetch_array($teams))
			{
				$ladder['yourteams'][] = $teamm;
				$ladder['teamcount']++;
			}
		}
		$matches = array();
		$games = $vbulletin->db->query_read("
			SELECT games.*, ".($ladder['pot'] ? " t.teamname AS username" : " u.username AS username")."
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (games.pot = 0 AND games.u = u.userid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
				ON (games.pot = 1 AND games.u = t.teamid)
			WHERE
				games.u2 = 0
				AND games.finished = 0
				AND games.accepted = 0
				AND games.pot = ".$ladder['pot']."
				AND games.lid = $id
				AND games.dateline > ".TIMENOW."
			ORDER BY games.dateline ASC
			LIMIT 0, 20
		");
		while($game = $vbulletin->db->fetch_array($games))
		{
			$game['time'] = vbdate($vbulletin->options['timeformat'], $game['dateline']);
			$game['date'] = vbdate($vbulletin->options['dateformat'], $game['dateline'], true);
			$game = process_chal_options($game);
			$matches[] = $game;
		}
		if ($vbulletin->options['tmnt_warlights'] && $vbulletin->userinfo['userid'])
		{
			$ladder['wl_array'] = array();
			$ladder['wl_enabled'] = false;
			$players_query = $vbulletin->db->query_read("
				SELECT p.*, u.username, t.teamname
				FROM " . TABLE_PREFIX . "tmnt_ladder_players AS p
				LEFT JOIN " . TABLE_PREFIX . "user AS u
					ON (p.userid = u.userid)
				LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
					ON (p.userid = t.teamid)
				WHERE p.warlight > '".TIMENOW."'
					AND p.lid = '".$ladder['id']."'
			");
			while($playerq = $vbulletin->db->fetch_array($players_query))
			{
				if ($team)
				{
					$playerq['username'] = $playerq['teamname'];
				}
				if (!$team && $playerq['userid'] == $vbulletin->userinfo['userid'])
				{
					$ladder['wl_enabled'] = true;
					$ladder['userinfo_warlight'] = $playerq['warlight'];
				}
				else
				{
					$ladder['wl_array'][] = $playerq;
				}
			}
		}
	}
	elseif ($_REQUEST['sh'] == 6)
	{
		$sh = 6;
		$query_rules = $vbulletin->db->query_first("
			SELECT rules
			FROM " . TABLE_PREFIX . "tmnt_rules
		");
		$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list()); 
		$ladder['genrules'] = $bbcode_parser->do_parse($query_rules['rules']);
	}
	elseif ($_REQUEST['sh'] == 7)
	{
		$sh = 7;
	}
	elseif ($_REQUEST['sh'] == 8)
	{//knockout stage for leagues
		$sh = 8;
		$tmnt = array(
			'noplayers' => $ladder['tmnt_noplayers'],
			'freeslots' => 0,
			'id' => $ladder['id']
		);
		if ($ladder['tmnt_status']==1)
		{
			$tmnt['status'] = $vbphrase['tmnt_inprogress'];
		}
		if ($ladder['tmnt_status']==2)
		{
			$tmnt['status'] = $vbphrase['tmnt_finished'];
		}
		$type = $vbphrase['tmnt_'.$ladder[knockout_type]];
		/** START :: ADAPTED FROM TOURNAMENTS.PHP **/
		$bracketcolor = $vbulletin->options['tmnt_bracketcolor'];
		$cmpt_count = 1;
		$winnernames = $useridlist = $array = $p_array = array();
		$cmpts = $vbulletin->db->query_read("
			SELECT
				" . (!$team ? "user.*," : "") . " players.*, players.username AS sname,
				" . (!$team ? "user.username AS username, user.userid, user.avatarrevision AS avatarrevision, avatar.avatarpath AS avatarpath, NOT ISNULL(customavatar.userid) AS hascustom, customavatar.dateline AS avatardateline, customavatar.width AS avwidth, customavatar.height AS avheight, user.username AS username" : "user.teamname AS username, user.teamid, user.teamlogo AS avatarurl") . "
				" . (($vbulletin->options['tmnt_joinuf'] && !$team) ? ", userfield.*, usertextfield.* " : "") . "
			FROM " . TABLE_PREFIX . "tmnt_ladder_players AS players 
			" . ($team ? "LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS user ON (players.userid = user.teamid)" : "LEFT JOIN " . TABLE_PREFIX . "user AS user ON (players.userid = user.userid) LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = user.avatarid) LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = user.userid) ") . "
			" . (($vbulletin->options['tmnt_joinuf'] && !$team) ? " LEFT JOIN " . TABLE_PREFIX . "userfield AS userfield ON (user.userid = userfield.userid) LEFT JOIN " . TABLE_PREFIX . "usertextfield AS usertextfield ON (usertextfield.userid = user.userid) " : "") . "
			WHERE lid = '$id' AND slot > 0
			ORDER BY slot ASC
		");
		$winnerlist = $pinfo = $rounduserinfo = array();
		$rui = 8;
		while ($rui > 0)
		{
			$ruj = 12;
			while ($ruj > 0)
			{
				$rounduserinfo["$rui"]["$ruj"] = array();
				$ruj--;
			}
			$rui--;
		}
		while ($cmpt = $vbulletin->db->fetch_array($cmpts))
		{
			$cmpt = process_tl_avatar($cmpt);
			$avatarlp = $cmpt['avatarlp'];
			$cmpt['time2'] = "<span class=\"smallfont\">".vbdate($vbulletin->options['dateformat'],$cmpt['time'], 1)." <span class=\"time\"> ".vbdate($vbulletin->options['timeformat'],$cmpt['time'])."</span></span>";
			$cmpt['time'] = " ".vbdate($vbulletin->options['dateformat'],$cmpt['time'], 1)." ".vbdate($vbulletin->options['timeformat'],$cmpt['time'])." ";
			$rowno ++;
			$cmpt['row'] = $rowno;
			$var = $cmpt['userid'];
			if (!$cmpt['username'])
			{
				$cmpt['username'] = $cmpt['sname'];
			}
			$array = array_merge((array)$var, $array);
			$var3 = $cmpt['username'];
			$useridlist = array_merge((array)$var3, $useridlist);
			if ($cmpt['winner'] == 1)
			{
				$var2 = $cmpt['userid'];
				$winnerlist = array_merge((array)$var2, $winnerlist);
				$winnernames = array_merge((array)$cmpt['username'], $winnernames);
			}
			$cmpt['userhtml'] = tll_userhtml($cmpt, $team);
			if ($type == $vbphrase['tmnt_1v1'] OR $type == $vbphrase['tmnt_de'])
			{
				$cmpt['round1'] = $rowno;
				$rounduserinfo['1']["$rowno"] = $cmpt;
				$rounduserinfo['2']["$cmpt[round2]"] = $cmpt;
				$rounduserinfo['3']["$cmpt[round3]"] = $cmpt;
				if ($cmpt['round5'] == 1 && $cmpt['round4'] == 0)
				{
					$cmpt['round4'] = 1;
				}
				$rounduserinfo['4']["$cmpt[round4]"] = $cmpt;
				$rounduserinfo['5']["$cmpt[round5]"] = $cmpt;
				$rounduserinfo['6']["$cmpt[round6]"] = $cmpt;
				$rounduserinfo['7']["$cmpt[round7]"] = $cmpt;
				$rounduserinfo['8']["$cmpt[round8]"] = $cmpt;
				if (($cmpt['round8'] & $tmnt['noplayers'] == 8) OR ($cmpt['round6'] & $tmnt['noplayers'] == 4) OR $tmnt['status'] == $vbphrase['tmnt_inprogress'])
				{
					$tmnt['show_round8'] = true;
				}
				$pinfo["$cmpt[userid]"] = $cmpt;
			}
			$p_array["$cmpt_count"] = $cmpt;
			$cmpt_count++;
		}
		$players = $tmnt['noplayers'];
		
		/** END :: ADAPTED FROM TOURNAMENTS.PHP PART 1 **/
		
		
		if ($players==4 && $ladder['knockout_type']=='de')
		{
		/** START :: ADAPTED FROM TOURNAMENTS.PHP PART 4 **/
#		if ($players == 4 && $type == $vbphrase['tmnt_de'])
#	{
		$rounds = ceil(log($tmnt['noplayers'], 2))+1;
		foreach ($rounduserinfo AS $round => $slot)
		{
			foreach ($rounduserinfo["$round"] AS $slot => $userinfo)
			{
				$loserround = 0;
				if ($userinfo['username'])
				{
					if ($userinfo['username'] == 'Bye' && $userinfo['userid'] == 0)
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= $vbphrase['tmnt_bye_player'];
					}
					else
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= tll_userhtml($userinfo, $team);
					}		
					$plusround = $round + 1;
					$minusround = $round - 1;
					if ($slot&1)
					{
						$ss = $slot + 1;
						$xx = $slot + 1;
					}
					else
					{
						$ss = $slot - 1;
						$xx = $slot;
					}
					$p = $xx / 2;
					$loserslot = (($p*2) + $players)/2;
					$loseruserid = $rounduserinfo["$round"]["$ss"]['userid'];
					if ($tmntp['canedittmnt'] AND $tmnt['status'] != $vbphrase['tmnt_finished'] AND $userinfo['userid'] != 0)
					{
						$show['progresslink'] = true;
						$show['loserplacement'] = true;
						$loserround = 0;
						if ($round == 1)
						{
							switch ($slot)
							{
								case 1:
								case 2:
									$loserslot = 5;
								break;
								case 3:
								case 4:
									$loserslot = 6;
								break;
							}
						}
						else if ($round == 2)
						{
							switch ($slot)
							{
								case 1:
								case 2:
									$p = 1;
									$loserslot = 3;
								break;
								case 5:
								case 6:
									$p = 4;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						elseif ($round == 3)
						{
							switch ($slot)
							{
								case 1:
								case 2:
									$p = 1;
									$loserslot = 2;
									$plusround = 5;
								break;
								case 3:
								case 4:
									$p = 2;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						elseif ($round == 4)
						{
							switch ($slot)
							{
								case 2:
									$p = 1;
									$loserslot = 2;
									$loseruserid = $rounduserinfo["3"]["1"]['userid'];
								break;
							}
						}
						elseif ($round == 5)
						{
							switch ($slot)
							{
								case 1:
									$p = 1;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						$plus_username = $rounduserinfo["$plusround"]["$p"]['username'];
						$plus_userinfo = $rounduserinfo["$plusround"]["$p"];
						if ($minusround && $dont)
						{
							$rounduserinfo["$round"]["$slot"]['userurl'] .= " <a href=\"javascript:ladder_regress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', '$vbphrase[minusround]');\"><img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_misc') . "/colorpicker_close.gif\" alt=\"$vbphrase[tmnt_regress]\" title=\"$vbphrase[tmnt_regress]\" class=\"inlineimg\" border=\"0\" /></a>";
						}
						if (!$plus_username)
						{
							$rounduserinfo["$round"]["$slot"]['progressfinish'] .= " <a href=\"javascript:ladder_progressfinish('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p');\" style=\"float:right; padding-top: 5px; padding-right: 2px;\"><img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_button') . "/viewpost.gif\" alt=\"$vbphrase[tmnt_progress]\" title=\"$vbphrase[tmnt_progress]\" class=\"inlineimg\" border=\"0\" /></a>";
							$rounduserinfo["$round"]["$slot"]['progress'] .= " <a href=\"javascript:ladder_progress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p'";
							if ($show['loserplacement'])
							{
								$rounduserinfo["$round"]["$slot"]['progress'] .= ", '$loseruserid', '$loserslot'" . ($loserround ? ", '$loserround'" : "");
							}
							$rounduserinfo["$round"]["$slot"]['progress'] .= ");\" style=\"float:right; padding-top: 5px; padding-right: 2px;\"><img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_button') . "/viewpost.gif\" alt=\"$vbphrase[tmnt_progress]\" title=\"$vbphrase[tmnt_progress]\" class=\"inlineimg\" border=\"0\" /></a> ";
						}
					}
					if (($slot == 1 && $round == 3) OR ($round == 5))
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] = $rounduserinfo["$round"]["$slot"]['progressfinish'].$rounduserinfo["$round"]["$slot"]['userurl'];
					}
					else
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] = $rounduserinfo["$round"]["$slot"]['progress'].$rounduserinfo["$round"]["$slot"]['userurl'];
					}
				}
				else
				{
					$rounduserinfo["$round"]["$slot"]['userurl'] .= " &nbsp; &nbsp; &nbsp; &nbsp; ";
				}
				$rounduserinfo["$round"]["$slot"]['userurl'] = '<div id="bracket_round' . $round . "_slot" . $slot . '">' . $rounduserinfo["$round"]["$slot"]['userurl'] . "</div>";
			}
		}
		require_once(DIR . '/includes/functions_tll_brackets.php');
		$headinclude .= '<script type="text/javascript" src="clientscript/jquery/jquery-1.4.4.min.js"></script>'."\n";
		$headinclude .= '<script type="text/javascript" src="clientscript/javascript_tll_brackets.js"></script>'."\n";
		$brackets = tll_create_tmnt_brackets($tmnt['noplayers'], $rounduserinfo, 1, $tmnt['show_round8']);
		$results = $brackets;
		if ($tmnt['status'] == $vbphrase['tmnt_finished'])
		{
			$dom = $rounds + 2;
			$tmnt['winners'] = array();
			$domi = 1;
			if ($rounduserinfo["$rounds"]['1']['username'])
			{
				$tmnt['winners']['1'] = $rounduserinfo["$rounds"]['1']['username'];
				$domi = 2;
			}
			while ($dom > 1)
			{
				foreach ($rounduserinfo["$dom"] AS $a => $b)
				{
					if ($b['username'] && !in_array($b['username'], $tmnt['winners']) && $a > 0)
					{
						$tmnt['winners'][$domi] = $b['username'];
						$domi++;
					}
				}
				if (count($tmnt['winners'])==3)
				{
					break;
				}
				$dom--;
			}
		}
	#}
		$ladder['results_html'] = $brackets;
		/** END :: ADAPTED FROM TOURNAMENTS.PHP PART 4 **/
		}
		elseif ($players==8 && $ladder['knockout_type']=='de')
		{
		
		/** START :: ADAPTED FROM TOURNAMENTS.PHP PART 3 **/
#		if ($type == $vbphrase['tmnt_de'] && $players == 8)
#	{
		$rounds = ceil(log($tmnt['noplayers'], 2))+1;
		foreach ($rounduserinfo AS $round => $slot)
		{
			foreach ($rounduserinfo["$round"] AS $slot => $userinfo)
			{
				$loserround = 0;
				if ($userinfo['username'])
				{
					if ($userinfo['username'] == 'Bye' && $userinfo['userid'] == 0)
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= $vbphrase['tmnt_bye_player'];
					}
					else
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= tll_userhtml($userinfo, $team);
					}		
					$plusround = $round + 1;
					$minusround = $round - 1;
					if ($slot&1)
					{
						$ss = $slot + 1;
						$xx = $slot + 1;
					}
					else
					{
						$ss = $slot - 1;
						$xx = $slot;
					}
					$p = $xx / 2;
					$loserslot = (($p*2) + $players)/2;
					$loseruserid = $rounduserinfo["$round"]["$ss"]['userid'];
					if ($tmntp['canedittmnt'] AND $tmnt['status'] != $vbphrase['tmnt_finished'] AND $userinfo['userid'] != 0)
					{
						$show['progresslink'] = true;
						$show['loserplacement'] = true;
						$loserround = 0;
						if ($round == 1)
						{
							switch ($slot)
							{
								case 1:
								case 2:
									$loserslot = 9;
								break;
								case 3:
								case 4:
									$loserslot = 10;
								break;
								case 5:
								case 6:
									$loserslot = 11;
								break;
								case 7:
								case 8:
									$loserslot = 12;
								break;
							}
						}
						else if ($round == 2)
						{
							switch ($slot)
							{
								case 1:
								case 2:
									$p = 1;
									$loserslot = 5;
								break;
								case 3:
								case 4:
									$p = 2;
									$loserslot = 7;
								break;
								case 9:
								case 10:
									$p = 6;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
								case 11:
								case 12:
									$p = 8;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						elseif ($round == 3)
						{
							switch ($slot)
							{
								case 1:
								case 2:
									$p = 1;
									$loserslot = 2;
									$loserround = "round5";//dom
								break;
								case 5:
								case 6:
									$p = 3;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
								case 7:
								case 8:
									$p = 4;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						elseif ($round == 4)
						{
							switch ($slot)
							{
								case 1:
									$p = 1;
									$loserslot = 0;
									$plusround = 7;
									$show['loserplacement'] = false;
								break;
								case 3:
								case 4:
									$p = 3;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						elseif ($round == 5)
						{
							switch ($slot)
							{
								case 2:
								case 3:
									$p = 1;
									$loserslot = 0;
									$show['loserplacement'] = false;
								break;
							}
						}
						elseif ($round == 6)
						{
							switch ($slot)
							{
								case 1:
									$p = 1;
									$loserslot = 2;
									$loseruserid = $rounduserinfo["4"]["1"]['userid'];
								break;
							}
						}
						$plus_username = $rounduserinfo["$plusround"]["$p"]['username'];
						$plus_userinfo = $rounduserinfo["$plusround"]["$p"];
						if ($minusround && $dont)
						{
							$rounduserinfo["$round"]["$slot"]['userurl'] .= " <a href=\"javascript:ladder_regress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', '$vbphrase[minusround]');\"><img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_misc') . "/colorpicker_close.gif\" alt=\"$vbphrase[tmnt_regress]\" title=\"$vbphrase[tmnt_regress]\" class=\"inlineimg\" border=\"0\" /></a>";
						}
						if (!$plus_username)
						{
							$rounduserinfo["$round"]["$slot"]['progressfinish'] .= " <a href=\"javascript:ladder_progressfinish('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p');\" style=\"float:right; padding-top: 5px; padding-right: 2px;\"><img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_button') . "/viewpost.gif\" alt=\"$vbphrase[tmnt_progress]\" title=\"$vbphrase[tmnt_progress]\" class=\"inlineimg\" border=\"0\" /></a>";
							$rounduserinfo["$round"]["$slot"]['progress'] .= " <a href=\"javascript:ladder_progress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p'";
							if ($show['loserplacement'])
							{
								$rounduserinfo["$round"]["$slot"]['progress'] .= ", '$loseruserid', '$loserslot'" . ($loserround ? ", '$loserround'" : "");
							}
							$rounduserinfo["$round"]["$slot"]['progress'] .= ");\" style=\"float:right; padding-top: 5px; padding-right: 2px;\"><img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_button') . "/viewpost.gif\" alt=\"$vbphrase[tmnt_progress]\" title=\"$vbphrase[tmnt_progress]\" class=\"inlineimg\" border=\"0\" /></a> ";
						}
					}
					if (($slot == 1 && $round == 4) OR ($round == 7))
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] = $rounduserinfo["$round"]["$slot"]['progressfinish'].$rounduserinfo["$round"]["$slot"]['userurl'];
					}
					else
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] = $rounduserinfo["$round"]["$slot"]['progress'].$rounduserinfo["$round"]["$slot"]['userurl'];
					}
				}
				else
				{
					$rounduserinfo["$round"]["$slot"]['userurl'] .= " &nbsp; &nbsp; &nbsp; &nbsp; ";
				}
				$rounduserinfo["$round"]["$slot"]['userurl'] = '<span id="bracket_round' . $round . "_slot" . $slot . '">' . $rounduserinfo["$round"]["$slot"]['userurl'] . "</span>";			
			}
		}
		require_once(DIR . '/includes/functions_tll_brackets.php');
		$headinclude .= '<script type="text/javascript" src="clientscript/jquery/jquery-1.4.4.min.js"></script>'."\n";
		$headinclude .= '<script type="text/javascript" src="clientscript/javascript_tll_brackets.js"></script>'."\n";
		$brackets = tll_create_tmnt_brackets($tmnt['noplayers'], $rounduserinfo, 1, $tmnt['show_round8']);
		$results = $brackets;
		if ($tmnt['status'] == $vbphrase['tmnt_finished'])
		{
			$dom = $rounds + 2;
			$tmnt['winners'] = array();
			$domi = 1;
			if ($rounduserinfo["$rounds"]['1']['username'])
			{
				$tmnt['winners']['1'] = $rounduserinfo["$rounds"]['1']['username'];
				$domi = 2;
			}
			while ($dom > 1)
			{
				foreach ($rounduserinfo["$dom"] AS $a => $b)
				{
					if ($b['username'] && !in_array($b['username'], $tmnt['winners']) && $a > 0)
					{
						$tmnt['winners'][$domi] = $b['username'];
						$domi++;
					}
				}
				if (count($tmnt['winners'])==3)
				{
					break;
				}
				$dom--;
			}
		}
	#}
		/** END :: ADAPTED FROM TOURNAMENTS.PHP PART 3 **/
		
		$ladder['results_html'] = $brackets;
		}
		else
		{
		/** START :: ADAPTED FROM TOURNAMENTS.PHP PART 2 **/
		
		$rounds = ceil(log($tmnt['noplayers'], 2))+1;
		foreach ($rounduserinfo AS $round => $slot)
		{
			foreach ($rounduserinfo["$round"] AS $slot => $userinfo)
			{
				if ($userinfo['username'])
				{
					if ($userinfo['username'] == 'Bye' && $userinfo['userid'] == 0)
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= $vbphrase['tmnt_bye_player'];
					}
					else
					{
						$rounduserinfo["$round"]["$slot"]['userurl'] .= tll_userhtml($userinfo, $team);
					}
					$plusround = $round + 1;
					$minusround = $round - 1;
					if ($slot&1)
					{
						$ss = $slot + 1;
						$xx = $slot + 1;
					}
					else
					{
						$ss = $slot - 1;
						$xx = $slot;
					}
					$p = $xx / 2;
					
					if ($tmntp['canedittmnt'] AND $tmnt['status'] != $vbphrase['tmnt_finished'] AND $userinfo['userid'] != 0)
					{
						$show['progresslink'] = true;
						$plus_username = $rounduserinfo["$plusround"]["$p"]['username'];
						$plus_userinfo = $rounduserinfo["$plusround"]["$p"];
						if ($minusround && !$plus_username)
						{
							$rounduserinfo["$round"]["$slot"]['userurl'] .= " <a href=\"javascript:ladder_regress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$round');\"><img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_misc') . "/colorpicker_close.gif\" alt=\"$vbphrase[tmnt_regress]\" title=\"$vbphrase[tmnt_regress]\" class=\"inlineimg\" border=\"0\" /></a>";
						}
						if (!$plus_username)
						{
							$rounduserinfo["$round"]["$slot"]['progressfinish'] .= " <a href=\"javascript:ladder_progressfinish('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p');\" style=\"float:right; padding-top: 5px; padding-right: 2px;\"><img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_button') . "/viewpost.gif\" alt=\"$vbphrase[tmnt_progress]\" title=\"$vbphrase[tmnt_progress]\" class=\"inlineimg\" border=\"0\" /></a>";
							$rounduserinfo["$round"]["$slot"]['progress'] .= " <a href=\"javascript:ladder_progress('$tmnt[id]', '$userinfo[userid]', '$userinfo[username]', 'round$plusround', '$p'";
							if ($show['loserplacement'])
							{
								$rounduserinfo["$round"]["$slot"]['progress'] .= ", '$loseruserid', '$loserslot'" . ($loserround ? ", '$loserround'" : "");
							}
							$rounduserinfo["$round"]["$slot"]['progress'] .= ");\" style=\"float:right; padding-top: 5px; padding-right: 2px;\"><img src=\"" . vB_Template_Runtime::fetchStyleVar('imgdir_button') . "/viewpost.gif\" alt=\"$vbphrase[tmnt_progress]\" title=\"$vbphrase[tmnt_progress]\" class=\"inlineimg\" border=\"0\" /></a> ";
						}
						if ($round == $rounds - 1)
						{
							$rounduserinfo["$round"]["$slot"]['userurl'] = $rounduserinfo["$round"]["$slot"]['progressfinish'] . $rounduserinfo["$round"]["$slot"]['userurl'];
						}
						else
						{
							$rounduserinfo["$round"]["$slot"]['userurl'] = $rounduserinfo["$round"]["$slot"]['progress'] . $rounduserinfo["$round"]["$slot"]['userurl'];
						}
					}
				}
				else
				{
					$rounduserinfo["$round"]["$slot"]['userurl'] .= " &nbsp; &nbsp; &nbsp; &nbsp; ";
				}
				$rounduserinfo["$round"]["$slot"]['userurl'] = '<div id="bracket_round' . $round . "_slot" . $slot . '">' . $rounduserinfo["$round"]["$slot"]['userurl'] . "</div>";
			}
		}
		if (!$team && $pinfo["$thisuserid"] && $tmnt['status'] == $vbphrase['tmnt_inprogress'])
		{
			for ($i = $rounds; $i >= 1; $i--)
			{
				if (!$pinfo["$thisuserid"]['round'.$i])
				{
					continue;
				}
				else
				{
					$th_slot = $pinfo["$thisuserid"]['round'.$i];
					if ($th_slot % 2)
					{
						$op_slot = $th_slot - 1;
					}
					else
					{
						$op_slot = $th_slot + 1;
					}
					$op_userinfo = $rounduserinfo["$i"]["$op_slot"];
					$pp_slot = ceil($th_slot / 2);
					$ip = $i + 1;
					$pp = $rounduserinfo["$ip"]["$pp_slot"];
					if ($pp)
					{
						break;
					}
					$tmnt['nextinfo'] = array(
						'round' => $i,
						'userid' => $op_userinfo['userid'],
						'username' => $op_userinfo['username'],
					);
					break;
				}
			}
		}
		require_once(DIR . '/includes/functions_tll_brackets.php');
		$headinclude .= '<script type="text/javascript" src="clientscript/jquery/jquery-1.6.4.min.js"></script>'."\n";
		$headinclude .= '<script type="text/javascript" src="clientscript/javascript_tll_brackets.js"></script>'."\n";
		$brackets = tll_create_tmnt_brackets($tmnt['noplayers'], $rounduserinfo);
		$ladder['results_html'] = $brackets;
		//$competitors .= $brackets;
		/** END :: ADAPTED FROM TOURNAMENTS.PHP **/
		}
	}
	elseif ($_REQUEST['sh'] == 9 && file_exists(DIR . '/tll_modules/tll_squadscores.php') && $team)
	{//top goal scores
		$sh = 9;
		//tmnt_ladder_players
		$aa = array();
		$games = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
				ON (games.pot = 1 AND games.u = t.teamid)
			WHERE
				games.finished = 1
				AND games.lid = $lid
			ORDER BY games.dateline ASC
		");
		while($game = $vbulletin->db->fetch_array($games))
		{
			$game['squad_scores'] = unserialize($game['squad_scores']);
			if ($game['squad_scores']['u'])
			{
				foreach ($game['squad_scores']['u'] AS $uu => $uscore)
				{
					$aa["$uu"]['userinfo'] = fetch_userinfo($uu);
					$aa["$uu"]['scores'] += $uscore;
				}
			}
			if ($game['squad_scores']['u2'])
			{
				foreach ($game['squad_scores']['u2'] AS $uu => $uscore)
				{
					$aa["$uu"]['userinfo'] = fetch_userinfo($uu);
					$aa["$uu"]['scores'] += $uscore;
				}
			}
			//print_r($game['squad_scores']);
		}
		function aasort (&$array, $key) 
		{
			$sorter=array();
			$ret=array();
			reset($array);
			foreach ($array as $ii => $va) {
				$sorter[$ii]=$va[$key];
			}
			asort($sorter);
			foreach ($sorter as $ii => $va) {
				$ret[$ii]=$array[$ii];
			}
			$array=$ret;
		}

		aasort($aa, "scores");
		$aa = array_reverse($aa, true);
		$ladder['topplayers'] = $aa;
		/*
		$games = $vbulletin->db->query_read("
			SELECT games.*, ".($ladder['pot'] ? " t.teamname AS username" : " u.username AS username")."
			FROM " . TABLE_PREFIX . "tmnt_ladder_games AS games
			LEFT JOIN " . TABLE_PREFIX . "user AS u
				ON (games.pot = 0 AND games.u = u.userid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_teams AS t
				ON (games.pot = 1 AND games.u = t.teamid)
			WHERE
				games.u2 = 0
				AND games.finished = 0
				AND games.accepted = 0
				AND games.pot = ".$ladder['pot']."
				AND games.lid = $id
				AND games.dateline > ".TIMENOW."
			ORDER BY games.dateline ASC
			LIMIT 0, 20
		");
		while($game = $vbulletin->db->fetch_array($games))
		{
		
		$querytt = $vbulletin->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "tmnt_members AS m
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladder_players AS p 
				ON (m.id = p.userid)
			LEFT JOIN " . TABLE_PREFIX . "tmnt_ladders AS l
				ON (p.lid = l.id)
			WHERE p.lid = $lid
		");
		while($row = $vbulletin->db->fetch_array($querytt))
		{
			print_r($row);
		}*/
	}
	elseif (in_array($_REQUEST['sh'], array(10,11,12,13,14,15)))
	{
		$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_UINT);
	}
	if (file_exists(DIR . '/tll_modules/tll_squadscores.php') && $team)
	{
		$ladder['show_topscores'] = true;
	}
	$offset = $ladder['dst'] ? $vbulletin->userinfo['timezoneoffset'] : $vbulletin->userinfo['tzoffset'];
	$ladder['dateline_from_user'] = $ladder['dateline_from'] + $offset * 3600;
	$ladder['dateline_to_user'] = $ladder['dateline_to'] + $offset * 3600;
	require_once(DIR . '/includes/functions_calendar.php');
	$ladder = fetch_event_date_time($ladder);
	if (TIMENOW < $ladder['dateline_from'])
	{
		$ladder['status2'] = $vbphrase['ladder_starting_on']." $date1 $time1";
	}
	elseif ($ladder['dateline_from'] < TIMENOW && TIMENOW < $ladder['dateline_to'])
	{
		$ladder['status2'] = $vbphrase['ladder_closing_on']." $date2 $time2";
	}
	else
	{
		$ladder['status2'] = $vbphrase['ladder_finished_on']." $date2 $time2";
	}
	// facebook options
	if (is_facebookenabled())
	{
		// display the like button for this ladder?
		$templater = vB_Template::create('facebook_likebutton');
		$fb_url = $vbulletin->options['bburl'].'/ladders.php?do=view&amp;id='.$id;
		if(is_browser('ie') || is_browser('opera'))
		{
			$templater->register('href', urlencode($fb_url));
		}
		else 
		{
			$templater->register('href', $fb_url);
		}
		$fblikebutton = $templater->render();
		$show['fb_likebutton'] = true;
	}
	if ($tmntp['admintickets'])
	{
		$ticket_count = $vbulletin->db->query_first("SELECT COUNT(*) AS countrows FROM " . TABLE_PREFIX . "tmnt_tickets WHERE ladderid = '$lid' AND closed = 0 ");
		if ($ticket_count['countrows'])
		{
			$ladder['open_support_tickets_link'] = '<a href="tll_tickets.php?ladderid=' . $lid . '" class="button" style="color: #FF0000; padding: 4px; border-color: #FF0000;">' . $ticket_count['countrows'] . ' Open Support Tickets</a>';
		}
	}
	$templater = vB_Template::create('tmnt_ladder_display');
		$templater->register('pagenav', $pagenav);
		$templater->register('tmntp', $tmntp);
		$templater->register('team', $team);
		$templater->register('ladder', $ladder);
		$templater->register('sarray', $sarray);
		$templater->register('TIMENOW', $TIMENOW);
		$templater->register('id', $id);
		$templater->register('sh', $sh);
		$templater->register('lid', $lid);
		$templater->register('comper', $comper);
		$templater->register('rowno', $rowno);
		$templater->register('show', $show);
		$templater->register('competitors', $competitors);
		$templater->register('matches', $matches);
		$templater->register('chllarray', $chllarray);
		$templater->register('competitorddms', $competitorddms);
		$templater->register('time1', $time1);
		$templater->register('time2', $time2);
		$templater->register('date1', $date1);
		$templater->register('date2', $date2);
		$templater->register('fblikebutton', $fblikebutton);
		$templater->register('embed', $embed);
	$tlhtml .= $templater->render();
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname
	);
	if (!$ladder['league'])
	{
		$navbits['ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'showonly=ladders'] = $vbphrase['ladders'];
	}
	else
	{
		$navbits['ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . 'showonly=leagues'] = $vbphrase['ladder_leagues'];
	}
	if ($ladder['parenttitle'])
	{
		$navbits['ladders.php' . $ladder['parenturl']] = $ladder['parenttitle'];
	}
	$navbits['ladders.php' . $ladder['categoryurl']] = $ladder['categorytitle'];
	$navbits[''] = construct_phrase($title);
	$vbulletin->db->query_write("
		UPDATE " . TABLE_PREFIX . "tmnt_ladders SET views = views + 1 WHERE id = '$id'
	");
	$navbar = render_navbar_template(construct_navbits($navbits));
	if ($_REQUEST['rankingsonly'] || $_REQUEST['embed'])
	{
		//$tlhtml = $brackets;
		$navbar = $footer = $header = '';
		$vbulletin->options['tmnt_navtop'] = $vboptions['tmnt_navtop'] = $vboptions['tmnt_navleft'] = $show['scrolling_announcements'] = $vboptions['tmnt_active'] = 0;
		$vbulletin->options['tmnt_disablecopyright'] = 1;
		$vboptions['tmnt_navleftbanner']='';
		$tmntp = 0;
		$vbulletin->options['tmnt_navleft'] = 0; 
		$vboptions['tmnt_navleft'] = 0;
	}
	$templater = vB_Template::create('tmnt_shell');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('headinclude', $headinclude);
	$templater->register('pagetitle', $pagetitle);
	$templater->register('tlhtml', $tlhtml);
	$templater->register('modname', $modname);
	$templater->register('header', $header);
	$templater->register('footer', $footer);
	$templater->register('tmntp', $tmntp);
	$templater->register('tmnt_version', $tmnt_version);
	$templater->register('template_hook', $template_hook);
	print_output($templater->render());
}

// #############################################################################

if ($_REQUEST['do'])
{
	$_REQUEST['do'] = '';
}

// #############################################################################

if (empty($_REQUEST['do']))
{
	if (!$tmntp['canviewladder'])
	{
		print_no_permission();
	}
	$c = $vbulletin->input->clean_gpc('g', 'c', TYPE_UINT);
	if (!$c && $vbulletin->options['tmnt_premium'] && $vbulletin->options['tmnt_seo'])
	{
		$thisurl = end(explode('/',$vbulletin->input->clean($_SERVER['REQUEST_URI'], TYPE_NOHTML)));
		if (substr($thisurl, 0, 12)=='ladders.php?' && strlen($thisurl)>12)
		{
			$c = $vbulletin->input->clean(substr($thisurl,12), TYPE_UINT);
		}
	}
	$filename = 'ladders';
	/*$cats = $vbulletin->db->query_read("
		SELECT cats.*, COUNT(DISTINCT ladders.id) AS countladders
		FROM " . TABLE_PREFIX . "tmnt_categories AS cats
		LEFT OUTER JOIN " . TABLE_PREFIX . "tmnt_ladders AS ladders
			ON (cats.catid = ladders.catid)
		WHERE cats.tol IN (2, 3)
		" . ($c ? " AND parentid = '$c' " : "") . "
		GROUP BY cats.catid
		ORDER BY cats.parentid DESC, cats.displayorder ASC, cats.title ASC
	");
	$carray = array();
	$ctarray  = array();
	while($cat = $vbulletin->db->fetch_array($cats))
	{
		$cat['counttmnts'] = -1;
		$cat['countladders'] += (int)$ctarray["$cat[catid]"]['lcount'];
		$ctarray["$cat[parentid]"]['lcount'] += $cat['countladders'];
		$templater = vB_Template::create('tmnt_cat');
			$templater->register('tmntp', $tmntp);
			$templater->register('cat', $cat);
			$templater->register('c', $c);
			$templater->register('filename', $filename);
		if (!$c && $cat['parentid'])
		{
			
			$carray["$cat[parentid]"] .= $templater->render();
		}
		else
		{
			$templater->register('subcs', $carray["$cat[catid]"]);
			$categories .= $templater->render();
		}
	}*/
	$showonly = $vbulletin->input->clean_gpc('g', 'showonly', TYPE_NOHTML);
	if ($vbulletin->tll_catcache)
	{
		foreach ($vbulletin->tll_catcache AS $cindex => $cat)
		{
			if ((!in_array('ladders',$cat['tol']) && !in_array('leagues',$cat['tol'])) OR ($c && $cat['parentid'] != $c))
			{
				continue;
			}
			$cat['counttmnts'] = -1;
			$templater = vB_Template::create('tmnt_cat');
				$templater->register('tmntp', $tmntp);
				$templater->register('cat', $cat);
				$templater->register('c', $c);
				$templater->register('showonly', $showonly);
				$templater->register('filename', $filename);
			if (!$c && $cat['parentid'])
			{
				
				$carray["$cat[parentid]"] .= $templater->render();
			}
			else
			{
				$templater->register('subcs', $carray["$cat[catid]"]);
				$categories .= $templater->render();
			}
		}
	}
	$recentmatches = array('1' => array('id' => '2', 'title' => 'xxx'));
	$rowcount = 0;
	require_once(DIR . '/includes/class_bbcode.php');
	$cinfo = $vbulletin->tll_catcache["$c"];
	$categorytitle = $cinfo['title'];
	$parentcategorytitle = $cinfo['parenttitle'];
	$parentcategoryid = $cinfo['parentid'];
	if (!$categorytitle && !$c)
	{
		if ($showonly == 'ladders')
		{
			$categorytitle = $vbphrase['tmnt_uncat_ladders'];
		}
		elseif ($showonly == 'leagues')
		{
			$categorytitle = $vbphrase['tmnt_uncat_leagues'];
		}
		else
		{
			$categorytitle = $vbphrase['tmnt_uncat_ldslgs'];
		}
	}
	elseif (!$categorytitle)
	{
		if ($showonly == 'ladders')
		{
			$categorytitle = $vbphrase['ladders'];
		}
		elseif ($showonly == 'leagues')
		{
			$categorytitle = $vbphrase['ladder_leagues'];
		}
		else
		{
			$categorytitle = $vbphrase['ladders_and_leagues'];
		}
	}
	if ($cinfo['parsed_banner'])
	{
		$cinfo['banner'] = $cinfo['parsed_banner'];
	}
	elseif ($cinfo['banner'])
	{
		require_once(DIR . '/includes/class_bbcode.php');
		$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
		$cinfo['banner'] = $bbcode_parser->do_parse($cinfo['banner']);
	}
	$parentcategoryurl = tll_seo('cat', $parentcategoryid, $parentcategorytitle);
	$ladders = $vbulletin->db->query_read("
		SELECT ladders.*
		FROM " . TABLE_PREFIX . "tmnt_ladders AS ladders
		WHERE ladders.catid = '$c'
			" . ($showonly == 'ladders' ? " AND ladders.league = 0" : "") . "
			" . ($showonly == 'leagues' ? " AND ladders.league > 0" : "") . "
		ORDER BY ladders.sticky DESC, ladders.title ASC
	");
	while($ladder = $vbulletin->db->fetch_array($ladders))
	{
		if ($rowcount == 0)
		{
			$templater = vB_Template::create('tmnt_ladder_list_top');
				$templater->register('tmntp', $tmntp);
				$templater->register('rowcount', $rowcount);
				$templater->register('categorytitle', $categorytitle);
				$templater->register('categories', $categories);
				$templater->register('ladder', $ladder);
				$templater->register('cinfo', $cinfo);
				$templater->register('showonly', $showonly);
			$tlhtml .= $templater->render();
		}
		$sticky = $ladder['sticky'];
        $description = preg_replace ('/\[(.*?)\]/is', '', $ladder['description']);
		$descriptionlength = strlen($description);
		if ($descriptionlength > $vbulletin->options['tmnt_desclength'])
		{
			$description = substr($description, 0, $vbulletin->options['tmnt_desclength']);
			$description = $description . '...';
		}
		$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), false); 
		$description = $bbcode_parser->do_parse($description,false,false,true,false,false,false);
		$ladder['url'] = tll_seo('ladder', $ladder['id'], $ladder['title']);
		$templater = vB_Template::create('tmnt_ladder_list');
			$templater->register('tmntp', $tmntp);
			$templater->register('rowcount', $rowcount);
			$templater->register('categorytitle', $categorytitle);
			$templater->register('ladder', $ladder);
			$templater->register('description', $description);
			$templater->register('sticky', $sticky);
			$templater->register('rowcount', $rowcount);
		$tlhtml .= $templater->render();
		$rowcount ++;
	}
	if ($rowcount == 0)
	{
		if ($c)
		{
			/*$tol = "2,3";
			$titles = fetch_category_titles($c, $tol);
			$categorytitle = $titles['title'];
			$parentcategorytitle = $titles['parenttitle'];
			$parentcategoryid = $titles['parentid'];
			$parentcategoryurl = $titles['parenturl'];*/
			if (!$categorytitle)
			{
				$errormessage = $vbphrase[error_invalid_category];
				eval(standard_error($errormessage));
			}
			$cinfo = $vbulletin->tll_catcache["$c"];
			if ($cinfo['parsed_banner'])
			{
				$cinfo['banner'] = $cinfo['parsed_banner'];
			}
			elseif ($cinfo['banner'])
			{
				require_once(DIR . '/includes/class_bbcode.php');
				$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list(), true); 
				$cinfo['banner'] = $bbcode_parser->do_parse($cinfo['banner']);
			}
		}
		else
		{
			if ($showonly == 'leagues')
			{
				$categorytitle = $vbphrase['tmnt_uncat_leagues'];
			}
			elseif ($showonly == 'ladders')
			{
				$categorytitle = $vbphrase['tmnt_uncat_ladders'];
			}
			else
			{
				$categorytitle = $vbphrase['tmnt_uncat_ldslgs'];
			}
		}
		$templater = vB_Template::create('tmnt_ladder_list_top');
			$templater->register('tmntp', $tmntp);
			$templater->register('rowcount', $rowcount);
			$templater->register('categorytitle', $categorytitle);
			$templater->register('categories', $categories);
			$templater->register('ladder', $ladder);
			$templater->register('showonly', $showonly);
			$templater->register('cinfo', $cinfo);
		$tlhtml .= $templater->render();
		if (!$categories)
		{
			$templater = vB_Template::create('tmnt_ladder_noladders');
				$templater->register('tmntp', $tmntp);
				$templater->register('rowcount', $rowcount);
				$templater->register('categorytitle', $categorytitle);
				$templater->register('ladder', $ladder);
				$templater->register('league', ($showonly == 'leagues' ? "1" : "0"));
			$tlhtml .= $templater->render();
		}
	}
	$templater = vB_Template::create('tmnt_ladder_list_bot');
		$templater->register('tmntp', $tmntp);
		$templater->register('rowcount', $rowcount);
		$templater->register('categorytitle', $categorytitle);
		$templater->register('categories', $categories);
		$templater->register('ladder', $ladder);
		$templater->register('showonly', $showonly);
		$templater->register('c', $c);
	$tlhtml .= $templater->render();
	if ($rowcount)
	{
		list($count, $recentmatches, $upcomingmatches) = get_rg_ug($c);
		$random = get_random_l_torp($c);
		$sh = $vbulletin->input->clean_gpc('g', 'sh', TYPE_NOHTML);
		if (!$sh)
		{
			$sh = 'rg';
		}
		$templater = vB_Template::create('tmnt_ladder_list_rm');
			$templater->register('tmntp', $tmntp);
			$templater->register('rowcount', $rowcount);
			$templater->register('categorytitle', $categorytitle);
			$templater->register('categories', $categories);
			$templater->register('ladder', $ladder);
			$templater->register('recentmatches', $recentmatches);
			$templater->register('upcomingmatches', $upcomingmatches);
			$templater->register('random', $random);
			$templater->register('count', $count);
			$templater->register('sh', $sh);
			$templater->register('c', $c);
		$recentmatches = $templater->render();
		$tlhtml = str_replace('{recentmatches}', $recentmatches, $tlhtml);
	}
	$tlhtml = str_replace('{recentmatches}', '', $tlhtml);
	$navbits = array(
		'competitions.php' . $vbulletin->session->vars['sessionurl_q'] => $modname
	);
	$x = 'ladders.php?' . $vbulletin->session->vars['sessionurl_q'] . ($showonly ? "showonly=$showonly" : "");
	if ($showonly == 'leagues')
	{
		$navbits["$x"] = $vbphrase['ladder_leagues'];
	}
	elseif ($showonly == 'ladders')
	{
		$navbits["$x"] = $vbphrase['ladders'];
	}
	else
	{
		$navbits["$x"] = $vbphrase['ladders_and_leagues'];
	}
	if ($parentcategoryid)
	{
		$x = 'ladders.php' . $parentcategoryurl;
		$navbits["$x"] = $parentcategorytitle;
	}
	$navbits[''] = $categorytitle;
	$navbits = construct_navbits($navbits);
	$navbar = render_navbar_template($navbits);
	$templater = vB_Template::create('tmnt_shell');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('headinclude', $headinclude);
		$templater->register('pagetitle', $pagetitle);
		$templater->register('tlhtml', $tlhtml);
		$templater->register('modname', $modname);
		$templater->register('header', $header);
		$templater->register('footer', $footer);
		$templater->register('tmntp', $tmntp);
		$templater->register('tmnt_version', $tmnt_version);
	print_output($templater->render());
}

// #############################################################################
	
?>