<?php

if (!isset($GLOBALS['vbulletin']->db))
{
	exit;
}

require_once(DIR . '/includes/solvemedialib.php');

/**
* Human Verification class for SolveMedia Verification (http://www.solvemedia.com)
*
* @package 		SolveMedia
* @version		$Revision: 1.2 $
* @date 		$Date: 2012/02/22 18:13:41 $
*
*/
class vB_HumanVerify_Solvemedia extends vB_HumanVerify_Abstract
{
	// Constructor
	function vB_HumanVerify_Solvemedia(&$registry)
	{
		parent::vB_HumanVerify_Abstract($registry);
	}

	// Verify that reponse is valid
	function verify_token($input)
	{
		$sm_keys = $this->_get_solvemedia_keys();

		$response = solvemedia_check_answer($sm_keys[1],
						$_SERVER['REMOTE_ADDR'],
						$_POST['adcopy_challenge'],
						$_POST['adcopy_response'],
						$sm_keys[2]);
		if (!$response->is_valid)
		{
			$this->error = 'humanverify_image_wronganswer';
			return false;
		}
		return true;
	}


	// Returns the HTML of the SolveMedia Widget to be displayed to the user for Human Verification
	function output_token($var_prefix = 'humanverify')
        {
		$sm_keys      = $this->_get_solvemedia_keys();
		$theme        = $this->registry->options['adcopy_theme'];
		$tabindex     = $this->registry->options['adcopy_tabindex'];
		$lang         = $this->registry->options['adcopy_lang'];
		$solve_widget = solvemedia_get_html($sm_keys[0], 0, REQ_PROTOCOL == 'https' );
		
		$templater = vB_Template::create('humanverify_solvemedia');
		
		$templater->register('theme', $theme);
		$templater->register('tabindex', $tabindex);
		$templater->register('lang', $lang);
		$templater->register('solve_widget', $solve_widget);

                $templater->register('humanverify', $this->generate_token());
                $templater->register('var_prefix', $var_prefix);
		
		return $templater->render();
	}

	// expected answer - with this class, we don't know the answer
	function fetch_answer()
	{
		return '';
	}

	// Figure out which Solve Media API keys to use
	function _get_solvemedia_keys() {
		if (file_exists(DIR . '/includes/solvemedia_keys.inc')) {
			require(DIR . '/includes/solvemedia_keys.inc');

			if ($SOLVEMEDIA_KEYS) {
				$hostname_parts = explode('.', strtolower($_SERVER['SERVER_NAME']));
				$domain         = end($hostname_parts);
				for ($i = 0; $i < 2 && !$keys; $i++) {
					if (count($hostname_parts) > ($i + 1)) {
						$domain = prev($hostname_parts) . '.' . $domain;
						$keys   = $SOLVEMEDIA_KEYS[$domain];
					}
				}

				if (!$keys) {
					$keys = $SOLVEMEDIA_KEYS['_default'];
				}
			}
		}

		if (!$keys) {
			$keys = array(
				$this->registry->options['adcopy_publickey'],
				$this->registry->options['adcopy_privatekey'],
				$this->registry->options['adcopy_hashkey']
			);
		}

		return $keys;
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 15:02, Wed Apr 7th 2010
|| # CVS: $RCSfile: class_humanverify_solvemedia.php,v $ - $Revision: 1.2 $
|| ####################################################################
\*======================================================================*/
?>
