<?php
/*======================================================================*\
|| #################################################################### ||
|| # Graphic Editor Online for vBulletin 4                            # ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright  2012 BCP Hung. All Rights Reserved.                  # ||
|| # This file will be used to access Photo Editor page.              # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'graphiceditor');
define('CSRF_PROTECTION', true);  

// ################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array(
	'graphic_MAIN'
);

// pre-cache templates used by specific actions
$actiontemplates = array(
	'photo' => array(
		'graphic_PHOTOEDITOR'
	),
	'express' => array(
		'graphic_EXPRESSEDITOR'
	),
	'o-matic' => array(
		'graphic_GRAPHIC-O-MATIC'
	)
);

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');

// ############################ PERMISSION ###############################
$usergroups = explode(',', $vbulletin->options['graphic_bangroup']);
if (is_member_of($vbulletin->userinfo, $usergroups) AND $vbulletin->options['graphic_enable'])
{
    print_no_permission();
}

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// MAIN ACTION ###########################################################
if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'photo';
}

// PHOTO EDITOR ##########################################################
if ($_REQUEST['do'] == 'photo')
{
	$templater = vB_Template::create('graphic_PHOTOEDITOR');
		$templater->register('photo', $photo);
	$photo .= $templater->render();

	$feature .= $vbphrase['photo_editor'];
	$HTML .= $photo;
	$navbits = construct_navbits(array(
		'graphiceditor.php' => $vbphrase['graphic_editor'],
		'graphiceditor.php?{session.sessionurl_q}do=photo' => $vbphrase['photo_editor']
	));
}

// EXPRESS EDITOR ########################################################
if ($_REQUEST['do'] == 'express' AND $vbulletin->options['graphic_express'])
{
	$templater = vB_Template::create('graphic_EXPRESSEDITOR');
		$templater->register('express', $express);
	$express .= $templater->render();

	$feature .= $vbphrase['express_editor'];
	$HTML .= $express;
	$navbits = construct_navbits(array(
		'graphiceditor.php' => $vbphrase['graphic_editor'],
		'graphiceditor.php?{session.sessionurl_q}do=express' => $vbphrase['express_editor']
	));
}
elseif ($_REQUEST['do'] == 'express' AND !$vbulletin->options['graphic_express'])
{
	print_no_permission();
}

// GRAPHIC-O-MATIC EDITOR ################################################
if ($_REQUEST['do'] == 'omatic' AND $vbulletin->options['graphic_omatic'])
{
	$templater = vB_Template::create('graphic_GRAPHIC-O-MATIC');
		$templater->register('omatic', $omatic);
	$omatic .= $templater->render();

	$feature .= $vbphrase['omatic_editor'];
	$HTML .= $omatic;
	$navbits = construct_navbits(array(
		'graphiceditor.php' => $vbphrase['graphic_editor'],
		'graphiceditor.php?{session.sessionurl_q}do=omatic' => $vbphrase['omatic_editor']
	));
}
elseif ($_REQUEST['do'] == 'omatic' AND !$vbulletin->options['graphic_omatic'])
{
	print_no_permission();
}

// MAIN TEMPLATE ACTION ##################################################
$year = date('Y');
$navbar = render_navbar_template($navbits);
$templater = vB_Template::create('graphic_MAIN');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('feature', $feature);
	$templater->register('HTML', $HTML);
	$templater->register('year', $year);
print_output($templater->render());

/*======================================================================*\
|| #################################################################### ||
|| # Finished : $Time$ - $Date$                                       # ||
|| # $Version: 4.00$ - $Revision: 00037 $                             # ||
|| #################################################################### ||
\*======================================================================*/
?>