<?php

/*===========================================================================================*\
|| ######################################################################################### ||
|| #                                                                                       # ||
|| # Banned Users List (for vBulletin v4.0.0 and higher)                                   # ||
|| #                                                                                       # ||
|| # Copyright (c) 2009 Eric Sizemore (http://www.vbulletin.org/forum/member.php?u=142777) # ||
|| #                                                                                       # ||
|| # For distribution in vBulletin.org only.                                               # ||
|| #                                                                                       # ||
|| ######################################################################################### ||
\*===========================================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('THIS_SCRIPT', 'banned');
define('CSRF_PROTECTION', false);
define('CSRF_SKIP_LIST', '');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array('banning', 'cpuser', 'cpglobal');

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array(
	'bannedusers',
	'bannedusers_bit'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_bannedusers_list.php');

if (empty($_REQUEST['do']) OR !in_array($_REQUEST['do'], array('perm', 'temp')))
{
	$_REQUEST['do'] = 'perm';
}

// This shouldn't happen, but just in case...
if (!isset($vbulletin->usergroupcache) OR empty($vbulletin->usergroupcache))
{
	require_once(DIR . '/includes/adminfunctions.php');
	build_forum_permissions();
}

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################
// Enabled?
if (!$vbulletin->options['bannedusers_enabled'])
{
	eval(standard_error(fetch_error('bannedusers_notenabled')));
}

// Permission to view?
if (!$vbulletin->userinfo['userid'] OR !($permissions['forumpermissions'] & $vbulletin->bf_ugp_forumpermissions['canview']))
{
	print_no_permission();
}

if (!empty($vbulletin->options['bannedusers_hidefrom']) AND is_member_of($vbulletin->userinfo, $vbulletin->options['bannedusers_hidefrom']))
{
	print_no_permission();
}

// #######################################################################
$perpage = $vbulletin->input->clean_gpc('r', 'perpage', TYPE_UINT);
$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber', TYPE_UINT);
$mode = $vbulletin->input->clean_gpc('r', 'do', TYPE_NOHTML);

$querygroups = array();

foreach ($vbulletin->usergroupcache AS $usergroupid => $usergroup)
{
	if (!($usergroup['genericoptions'] & $vbulletin->bf_ugp_genericoptions['isnotbannedgroup']))
	{
		$querygroups["$usergroupid"] = $usergroup['title'];
	}
}

// #######################################################################
// Banned member?
if (count($querygroups) > 0 AND is_member_of($vbulletin->userinfo, implode(',', array_keys($querygroups))))
{
	print_no_permission();
}

// #######################################################################
// Are we looking for temp. banned or perm. banned?
$andsql = iif($mode == 'temp', 'userban.liftdate <> 0', '(userban.liftdate = 0 OR userban.liftdate = NULL)');

$wheresql = iif(
	count($querygroups) > 0, 
	"user.usergroupid IN(" . implode(',', array_keys($querygroups)) . ") AND $andsql",
	$andsql
);

$sortby = $vbulletin->input->clean_gpc('r', 'sort', TYPE_STR);
$sortby = bannedusers_list_sort($sortby);

// #######################################################################
// Let's pull all info
$bannedcount = $db->query_first("
	SELECT COUNT(*) AS count
	FROM " . TABLE_PREFIX . "user AS user
	LEFT JOIN " . TABLE_PREFIX . "userban AS userban ON(userban.userid = user.userid)
	LEFT JOIN " . TABLE_PREFIX . "user AS adminuser ON(adminuser.userid = userban.adminid)
	WHERE $wheresql
");

if ($bannedcount['count'])
{
	// Begin pagination
	sanitize_pageresults($bannedcount['count'], $pagenumber, $perpage, 100, $vbulletin->options['bannedusers_perpage']);

	// Default lower and upper limit variables
	$limitlower = ($pagenumber - 1) * $perpage + 1;
	$limitupper = $pagenumber * $perpage;

	if ($limitupper > $bannedcount['count'])
	{
		// Too many for upper limit
		$limitupper = $bannedcount['count'];

		if ($limitlower > $bannedcount['count'])
		{
			// Too many for lower limit
			$limitlower = $bannedcount['count'] - $perpage;
		}
	}

	if ($limitlower <= 0)
	{
		// Can't have negative or null lower limit
		$limitlower = 1;
	}

	$bannedusers = $db->query_read("
		SELECT user.userid, user.username, user.usergroupid AS busergroupid,
			userban.usergroupid AS ousergroupid,
			IF(userban.displaygroupid = 0, userban.usergroupid, userban.displaygroupid) AS odisplaygroupid,
			bandate, liftdate, reason,
			adminuser.userid AS adminid, adminuser.username AS adminname
		FROM " . TABLE_PREFIX . "user AS user
		INNER JOIN " . TABLE_PREFIX . "userban AS userban ON(userban.userid = user.userid)
		LEFT JOIN " . TABLE_PREFIX . "user AS adminuser ON(adminuser.userid = userban.adminid)
		WHERE $wheresql
		ORDER BY $sortby[1]
		LIMIT " . ($limitlower - 1) . ", $perpage
	");

	$counter = 0;

	while ($banneduser = $db->fetch_array($bannedusers) AND $counter++ < $perpage)
	{
		$baninfo = bannedusers_list_row($banneduser);

		$templater = vB_Template::create('bannedusers_bit');
			$templater->register('baninfo', $baninfo);

		$bannedusers_bit .= $templater->render();
	}

	$db->free_result($bannedusers);

	$pagenav = construct_page_nav($pagenumber, $perpage, $bannedcount['count'], 'banned.php?' . $vbulletin->session->vars['sessionurl'] . "do=$mode&amp;sort=$sortby[1]");
}
else
{
	$templater = vB_Template::create("bannedusers_bit_{$mode}none");
	$bannedusers_bit .= $templater->render();
}

$groups = implode(', ', $querygroups);

unset($bannedcount, $querygroups);

// #######################################################################
// And we're done, spit out the HTML
$navbits = construct_navbits(array('' => $vbphrase['banned_users']));
$navbar = render_navbar_template($navbits);

$templater = vB_Template::create('bannedusers');
	$templater->register_page_templates();
	$templater->register('navbar', $navbar);
	$templater->register('pagetitle', $vbphrase['banned_users']);
	$templater->register('pagenav', $pagenav);
	$templater->register('pagenumber', $pagenumber);
	$templater->register('perpage', $perpage);
	$templater->register('bannedusers_bit', $bannedusers_bit);
	$templater->register('groups', $groups);
	$templater->register('viewing', ($mode == 'temp' ? $vbphrase['temporary_ban'] : $vbphrase['permanent_ban']));
	$templater->register('mode', $mode);
	$templater->register('output', $output);
print_output($templater->render());  

?>