<?php
// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('fbconnect');

$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/facebook/facebook.php');

print_cp_header($vbphrase['register_newsfeed_templates']);

if ($vbulletin->options['fbconnect_apikey'] && $vbulletin->options['fbconnect_secret'])
{
	$facebook = new Facebook($vbulletin->options['fbconnect_apikey'], $vbulletin->options['fbconnect_secret']);
	
	if ($_GET['do'] == 'registertemplates')
	{
		//news feed when the user logs in for the first time
		$title = '{*actor*} joined <a href="{*bburl*}">{*bbtitle*}</a>.';
		$bundleid = $facebook->api_client->feed_registerTemplateBundle(
			array($title),
			array(
				array(
					'template_title' => $title,
					'template_body' => ''
				)
			), null,
			array(
				array('text' => 'Visit {*bbtitle*}', 'href' => '{*bburl*}')
			));
		
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "setting
			SET `value` = '$bundleid'
			WHERE varname = 'fbconnect_firstlogintemplateid'");

		        	
		// news feed when the user creates a new thread
		$title = '{*actor*} created a new discussion thread <a href="{*threadurl*}">{*threadtitle*}</a>.';
		$bundleid = $facebook->api_client->feed_registerTemplateBundle(
			array($title),
			array(
				array(
					'template_title' => $title,
					'template_body' => ''
				)
			), null,
			array(
				array('text' => 'View Thread', 'href' => '{*threadurl*}'),
				array('text' => 'Visit {*bbtitle*}', 'href' => '{*bburl*}')		
			));
			
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "setting
			SET `value` = '$bundleid'
			WHERE varname = 'fbconnect_newthreadtemplateid'");	
		
			
		// news feed when the user replyes to a thread
		$title = '{*actor*} replied to <a href="{*threadurl*}">{*threadtitle*}</a>.';
		$bundleid = $facebook->api_client->feed_registerTemplateBundle(
			array($title),
			array(
				array(
					'template_title' => $title,
					'template_body' => ''
				)
			), null,
			array(
				array('text' => 'View Thread', 'href' => '{*threadurl*}'),
				array('text' => 'Visit {*bbtitle*}', 'href' => '{*bburl*}')		
			));
			
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "setting
			SET `value` = '$bundleid'
			WHERE varname = 'fbconnect_newreplytemplateid'");	
	}
	
	print_table_start();
	print_table_header($vbphrase['registered_templates']);
	
	$bundles = $facebook->api_client->feed_getRegisteredTemplateBundles();
	if (is_array($bundles))
	{
		foreach ($bundles as $bundle)
		{
			print_label_row("Template Bundle ID: $bundle[template_bundle_id]", str_replace('>', '&gt;', str_replace('<', '&lt;', $bundle['one_line_story_templates'][0])));  
		}
	}
	else
	{
		print_description_row($vbphrase['no_templates_registered'], 0, 2, 'thead');
	}
			
	print_table_footer(2, '', '', 0);  
	echo '<center>';
	echo '<br />';
	echo '<a href="http://developers.facebook.com/tools.php?templates" target="parent">[ ' . $vbphrase['deactivate_templates'] . ' ]</a>';
	echo '<a href="fbconnect_registertemplates.php?do=registertemplates">[ ' . $vbphrase['register_templates'] . ' ]</a>';
	echo '<a href="http://developers.facebook.com/tools.php?feed" target="parent">[ ' . $vbphrase['create_templates'] . ' ]</a>';
	echo '</center>';
	
	
}
else
{
	print_cp_message($vbphrase['no_apikey']); 
}

print_cp_footer();


?>
