<?
function generate_password($length = 9, $strength = 0) 
{
    $vowels = 'aeuy';
    $consonants = 'bdghjmnpqrstvz';
    if ($strength & 1) 
	{
        $consonants .= 'BDGHJLMNPQRSTVWXZ';
    }
    if ($strength & 2) 
	{
        $vowels .= "AEUY";
    }
    if ($strength & 4) 
	{
        $consonants .= '23456789';
    }
    if ($strength & 8) 
	{
        $consonants .= '@#$%';
    }

    $password = '';
    $alt = time() % 2;
    for ($i = 0; $i < $length; $i++) 
	{
        if ($alt == 1) 
		{
            $password .= $consonants[(rand() % strlen($consonants))];
            $alt = 0;
        } else 
		{
            $password .= $vowels[(rand() % strlen($vowels))];
            $alt = 1;
        }
    }
    return $password;
}

function get_fb_uid($userid)
{
	global $db;
	
	$user = $db->query_first("
			SELECT fbuid
			FROM " . TABLE_PREFIX . "fbuser
			WHERE userid = " . $userid . "
			LIMIT 1
		");
		
	return intval($user['fbuid']);
}

function fetch_fbuser_info($query)
{
	require_once(DIR . '/includes/facebook/facebook.php');
	
	global $vbulletin, $db;
	
	$fbusers = $db->query_read($query);			
				
	$fbuids = "";
	$vbuids = array();
	while ($fbuser = $db->fetch_array($fbusers))
	{
		if ($fbuser['fbuid'])
		{
			$fbuids .= $fbuser['fbuid'] . ",";
			$vbuids[] = $fbuser['userid'];
		}
	}	
	$fbuids = rtrim($fbuids, ',');
	
	$fbuserinfo = $vbulletin->session->vars['fbuserinfo'];
	if ($vbulletin->facebook == null)
		$vbulletin->facebook = new Facebook($vbulletin->options['fbconnect_apikey'], $vbulletin->options['fbconnect_secret']);
		
	try
	{
		$fbuser = $vbulletin->facebook->api_client->users_getInfo($fbuids, 'name, first_name, last_name, affiliations, pic, pic_small, pic_square');
		
		for ($i = 0; $i < count($fbuser); $i++)
			$fbuserinfo[$vbuids[$i]] = $fbuser[$i];
			
		$vbulletin->session->set('fbuserinfo', $fbuserinfo);
	}
	catch(FacebookRestClientException $ex)
	{
	}
	
	//print_r($vbulletin->session->vars['fbuserinfo']);
	
}

function set_fb_data(&$target, $userid = '', $profilefield = false)
{
	require_once(DIR . '/includes/facebook/facebook.php');	

	global $vbulletin, $db, $show, $vbphrase, $fb_field_map, $avatarurl;
	
	if ($userid)
		$target['userid'] = $userid;

	if ($vbulletin->options['fbconnect_importdata'] && $target['userid'] != '')
	{		
		$fbuserinfo = $vbulletin->session->vars['fbuserinfo'];
		if (!is_array($fbuserinfo[$target['userid']]))
		{
			$fbuid = get_fb_uid($target['userid']);
			if ($fbuid)
			{
				if ($vbulletin->facebook == null)
					$vbulletin->facebook = new Facebook($vbulletin->options['fbconnect_apikey'], $vbulletin->options['fbconnect_secret']);
					
				try
				{
					$fbuser = $vbulletin->facebook->api_client->users_getInfo($fbuid, 'name, first_name, last_name, affiliations, pic, pic_small, pic_square');
					$fbuserinfo[$target['userid']] = $fbuser[0];
					$vbulletin->session->set('fbuserinfo', $fbuserinfo);
				}
				catch(FacebookRestClientException $ex)
				{
				}
			}
		}
		
		if (is_array($fbuserinfo[$target['userid']]))
		{			
			if (!is_array($fb_field_map))
			{
				$fb_field_map = array();
				$profile_fields = $db->query_read("
					SELECT *
					FROM " . TABLE_PREFIX . "fbdatamap
					");

				while ($field = $db->fetch_array($profile_fields))
				{
					$fb_field_map[$field['vbfield']] = $field['fbfield'];
				}
			}
			
			$not_profile_field = array('avatarurl', 'profilepicurl');			
			foreach ($fb_field_map as $vbfield => $fbfield)
			{
				if ($profilefield && $target['value'] && $target['value'] != $vbphrase['n_a'])
					continue;
				
				
				if ($target[$vbfield] && pathinfo($target[$vbfield], PATHINFO_BASENAME) != 'unknown.gif')
					continue;
					
				
				
				if ($fbfield == 'affiliations')
				{
					if (is_array($fbuserinfo[$target['userid']][$fbfield]))
					{
						foreach ($fbuserinfo[$target['userid']][$fbfield] as $network)
						{
							if ($network['type'] == 'region')
							{
								$fbuserinfo[$target['userid']][$fbfield] = $network['name'];									
								break;
							}
						}
					}
				}

				if ($profilefield)
				{			
					if ($vbfield == ('field' . $target['profilefieldid']))
					{
						$target['value'] = $fbuserinfo[$target['userid']][$fbfield];
						break;
					}
				}
				else
					$target[$vbfield] = $fbuserinfo[$target['userid']][$fbfield];								
			}

			if ($target['avatarurl'])
			{
				$avatarurl = $target['avatarurl'];
				$show['avatar'] = true;				
			}
		}
	}
}

function print_datamap_row($vbdata, $fbdata, $vbselected = "", $fbselected = "")
{
	global $vbphrase;
	
	echo '
	<tr class="'.fetch_row_bgclass().'">
		<td>
			<select name="vbfield[]">
				'.(($vbselected) ? '' : '<option></option>');
	 
	foreach ($vbdata as $key => $val)
	{
		echo '<option value="'.$key.'" '.(($vbselected == $key) ? 'selected' : '').'>' . $val . '</option>';
	}

	echo '
			</select>
		</td>
		<td>
			<select name="fbfield[]">
				'.(($fbselected) ? '' : '<option></option>');

	foreach ($fbdata as $key => $val)
	{
		echo '<option value="'.$key.'" '.(($fbselected == $key) ? 'selected' : '').'>' . $val . '</option>';
	}

	echo '
			</select>
		</td>
		<td align="center">';
			if ($vbselected) 
				echo '<a href="fbconnect_datamap.php?do=delete&vbfield='.$vbselected.'">[ '.$vbphrase['delete'].' ]</a>';			
	echo '
		</td>
	</tr>';
}