<?php
	class_exists('XenForo_Application', false) || die('Invalid');

	$__extraData['title'] = 'Обновление системы';
?>

<?php if ($errors) { ?>
	<p class="text">При проверке сервера на возможность работы XenForo произошли следующие ошибки:</p>
	<div class="baseHtml">
		<ul>
		<?php foreach ($errors AS $error) { ?>
			<li><?php echo $error; ?></li>
		<?php } ?>
		</ul>
	</div>
	<p class="text">Пожалуйста, исправьте эти ошибки и попытайтесь снова.</p>
<?php } else { ?>
	<form action="index.php?upgrade/run" method="post" class="xenForm">
		<?php if ($fileErrors) { ?>
			<div class="errorMessage">
				Как минимум <?php echo count($fileErrors); ?> файлов содержат неожиданное содержимое.
				Перезалейте файлы XenForo и обновите эту страницу.
				Продолжайте только если Вы уверены что все файлы залиты правильно.
			</div>
		<?php } else if (!$hashesExist) { ?>
			<div class="errorMessage">
				Один или несколько файлов отсутствуют. Пожалуйста, перезалейте файлы XenForo и обновите эту страницу.
				Продолжайте только если Вы уверены что все файлы залиты правильно.
			</div>
		<?php } ?>

		<dl class="ctrlUnit fullWidth">
			<dt></dt>
			<dd>Нажмите кнопку ниже для начала обновления до <b><?php echo $targetVersion; ?></b>.</dd>
		</dl>

		<dl class="ctrlUnit submitUnit">
			<dt></dt>
			<dd><input type="submit" value="Начать обновление" accesskey="s" class="button primary" /></dd>
		</dl>

		<input type="hidden" name="_xfToken" value="<?php echo htmlspecialchars($visitor['csrf_token_page']); ?>" />
	</form>
<?php } ?>