<?php

// Add the administrator field
if (self::$db_alter->fetch_table_info('administrator'))
{
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_postbittabsadminperms',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::report('Altered Table', 'administrator');
}

if (self::$db_alter->fetch_table_info('usergroup'))
{
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_postbittabspermissions',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::report('Altered Table', 'usergroup');
}

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX  . "dbtech_postbittabs_tab` (
		`tabid` INT( 10 ) UNSIGNED NOT NULL AUTO_INCREMENT,
		`title` VARCHAR( 250 ) NOT NULL ,
		`description` MEDIUMTEXT NULL DEFAULT NULL ,
		`active` ENUM( '0', '1' ) NOT NULL DEFAULT '1',
		`displayorder` INT( 10 ) NOT NULL DEFAULT '10',
		`usergroupids` VARCHAR( 250 ) NOT NULL DEFAULT '',
		PRIMARY KEY ( `tabid` )
	) ENGINE = MYISAM ;
");
self::report('Created Table', 'dbtech_postbittabs_tab');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX  . "dbtech_postbittabs_view` (
		`viewid` VARCHAR( 50 ) NOT NULL ,
		`title` VARCHAR( 250 ) NOT NULL ,
		`description` MEDIUMTEXT NULL DEFAULT NULL ,
		`active` ENUM( '0', '1' ) NOT NULL DEFAULT '1',
		`displayorder` INT( 10 ) NOT NULL DEFAULT '10',
		`tabid` INT( 10 ) UNSIGNED NOT NULL DEFAULT '0',
		`htmlcode` MEDIUMTEXT NULL DEFAULT NULL ,
		`htmlcode_compiled` MEDIUMTEXT NULL DEFAULT NULL ,
		`automated` ENUM( '0', '1' ) NOT NULL DEFAULT '0',
		`usergroupids` VARCHAR( 250 ) NOT NULL DEFAULT '',
		PRIMARY KEY ( `viewid` )
	) ENGINE = MYISAM ;
");
self::report('Created Table', 'dbtech_postbittabs_view');