<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager', false))
{
	exit;
}

/**
* Class to do data save/delete operations for tabs
*
* @package	postbit
*/
class Postbit_DataManager_View extends vB_DataManager
{
	/**
	* Array of recognised and required fields for tabs, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'viewid' 				=> array(TYPE_STR, 		REQ_YES, 	VF_METHOD),
		'title' 				=> array(TYPE_STR, 		REQ_YES),
		'description' 			=> array(TYPE_STR, 		REQ_NO),
		'active' 				=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 'verify_onoff'),
		'displayorder' 			=> array(TYPE_UINT, 	REQ_NO),
		'tabid' 				=> array(TYPE_UINT, 	REQ_NO, 	VF_METHOD),
		'htmlcode' 				=> array(TYPE_STR, 		REQ_NO),
		'htmlcode_compiled' 	=> array(TYPE_STR, 		REQ_AUTO),
		'automated' 			=> array(TYPE_STR, 		REQ_NO),
		'usergroupids'     		=> array(TYPE_NOCLEAN, 	REQ_NO, 	VF_METHOD, 'verify_commalist'),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'dbtech_postbittabs_view';

	/**
	* Condition for update query
	*
	* @var	array
	*/
	var $condition_construct = array('viewid = \'%1$s\'', 'viewid');

	/**
	* Constructor - checks that the registry object has been passed correctly.
	*
	* @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
	* @param	integer		One of the ERRTYPE_x constants
	*/
	function Postbit_DataManager_View(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);

		($hook = vBulletinHook::fetch_hook('dbtech_postbittabs_viewdata_start')) ? eval($hook) : false;
	}

	/**
	* Verifies that the viewid is valid
	*
	* @param	string	viewid of the tab
	*
	* @return	boolean
	*/
	function verify_viewid(&$viewid)
	{
		global $vbphrase;
		
		$viewid = strval($viewid);
		if ($viewid === '')
		{
			// Invalid
			return false;
		}
		
		// Check for existing tab of this name
		if ($existing = $this->registry->db->query_first("
			SELECT `viewid`
			FROM `" . TABLE_PREFIX . "dbtech_postbittabs_view`
			WHERE `viewid` = " . $this->registry->db->sql_prepare($viewid) . "
				" . ($this->existing['viewid'] ? "AND `viewid` != " . $this->registry->db->sql_prepare($this->existing['viewid']) : '') . "			
			LIMIT 1
		"))
		{
			// Whoopsie, exists
			$this->error('dbtech_postbittabs_x_already_exists_y', $vbphrase['dbtech_postbittabs_view'], $viewid);
			return false;
		}

		return true;
	}

	/**
	* Verifies that the onoff flag is valid
	*
	* @param	string	On/Off flag
	*
	* @return	boolean
	*/
	function verify_onoff(&$onoff)
	{
		// Validate onoff
		$onoff = (!in_array($onoff, array('0', '1')) ? '1' : $onoff);
		
		return true;
	}

	/**
	* Verifies that the tabid is valid
	*
	* @param	string	tabid
	*
	* @return	boolean
	*/
	function verify_tabid(&$tabid)
	{
		// Validate tabid
		return (is_array(POSTBITTABS::$cache['tab']["$tabid"]) OR $tabid == 0);
	}

	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_postbittabs_viewdata_presave')) ? eval($hook) : false;

		
		$htmlcode = $this->fetch_field('htmlcode');
		if ($htmlcode)
		{
			// Ensure we can compile template
			require_once(DIR . '/includes/adminfunctions_template.php');

			$errors = array();
			$compiled = compile_template($htmlcode, $errors);
			$this->set('htmlcode_compiled', str_replace('$final_rendered', '$view[htmlcode]', $compiled));
			
			if (!empty($errors))
			{
				// There were errors
				$this->errors = array_merge($this->errors, $errors);
				$return_value = false;
			}
		}
		

		$this->presave_called = $return_value;
		return $return_value;
	}
	
	/**
	* Additional data to update before a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function pre_delete($doquery = true)
	{
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_postbittabs_viewdata_predelete')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_postbittabs_viewdata_postsave')) ? eval($hook) : false;

		// Rebuild the cache
		POSTBITTABS_CACHE::build_cache('view', 'LEFT JOIN ' . TABLE_PREFIX . 'dbtech_postbittabs_tab AS tab ON (tab.tabid = dbtech_postbittabs_view.tabid)
			ORDER BY tab.displayorder, dbtech_postbittabs_view.displayorder ASC');

		return true;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_postbittabs_viewdata_delete')) ? eval($hook) : false;
		
		// Rebuild the cache
		POSTBITTABS_CACHE::build_cache('view', 'LEFT JOIN ' . TABLE_PREFIX . 'dbtech_postbittabs_tab AS tab ON (tab.tabid = dbtech_postbittabs_view.tabid)
			ORDER BY tab.displayorder, dbtech_postbittabs_view.displayorder ASC');
		
		return true;
	}
}