/** @param {jQuery} $ jQuery Object */
$.noConflict(true)(function($)
{
	var tabHeaders = $('img[name=postbittabimage]'),
		ftw = $(window),
		ftd = $(document),
		numtabs = tabHeaders.length,
		okscroll = true,
		tabid = false,
		firstclick;

	ftd.on('click', 'img[name=postbittabimage]', function()
	{
		// get active tabid and current page position
		var self = $(this),
			pos = self.offset().top - ftw.scrollTop();
		tabid = self.attr('id').match(/postbittabimage_(\d+)_(\d+)/i)[1];

		//show only these tabs selected
		var imgtab = $('img[data-tabid=' + tabid + ']');
		imgtab.attr('src', imgtab.attr('data-imageselected'));
		
		$('img[data-tabid][data-tabid!=' + tabid + ']').each(function()
		{
			$(this).attr('src', $(this).attr('data-image'));
		});
		
		//show only these divs
		$('div[name=postbittab]').hide();
		$('div[data-tabid=' + tabid + ']').show();
		
		if (pbtPro)
		{
			// Set the cookie for persistent tab
			setCookie('pbtTab', tabid);
		}
		
		if (okscroll)
		{
			// maintain page position if not an autoclick
			ftw.scrollTop(self.offset().top - pos)
		}
		else
		{
			okscroll = true;
		}
	});
	
	if (pbtPro)
	{	
		var lastTab = getCookie('pbtTab');
		if (lastTab && $('div[data-tabid=' + lastTab + ']').length)
		{
			// Override tabid
			tabid = lastTab;
		}
	}
	
	(firstclick = function()
	{
		// don't jump the page for these
		okscroll = false;
		
		if (tabid)
		{
			// If we've selected some other tab, use that
			$('img[id^=postbittabimage_' + tabid + ']:first').click();
		}
		else
		{
			// or just the first one
			$(tabHeaders[0]).click();
		}
	})();

	$('#qr_submit').click(function()
	{	
		// quick reply was just submitted
		var check = setInterval(function()
		{
			// wait for change in number of tabs on page
			var newsize = $('img[name=postbittabimage]').length;

			if (newsize != numtabs)
			{
				// we must have ajax posted
				numtabs = newsize;
				
				// No need to check again
				clearInterval(check);
				
				// Execute the click function again
				firstclick();
			}
		}, 500);
	});
	
	function setCookie(name,value,days) {
		if (days) {
			var date = new Date();
			date.setTime(date.getTime()+(days*24*60*60*1000));
			var expires = "; expires="+date.toGMTString();
		}
		else var expires = "";
		document.cookie = name+"="+value+expires+"; path=/";
	}
	
	function getCookie(name) {
		var nameEQ = name + "=";
		var ca = document.cookie.split(';');
		for(var i=0;i < ca.length;i++) {
			var c = ca[i];
			while (c.charAt(0)==' ') c = c.substring(1,c.length);
			if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
		}
		return null;
	}
	
	function deleteCookie(name) {
		setCookie(name,"",-1);
	}
});