<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager', false))
{
	exit;
}

/**
* Class to do data save/delete operations for tabs
*
* @package	postbit
*/
class Postbit_DataManager_Tab extends vB_DataManager
{
	/**
	* Array of recognised and required fields for tabs, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'tabid' 			=> array(TYPE_UINT, 	REQ_INCR, 	VF_METHOD, 	'verfiy_nonzero'),
		'title' 			=> array(TYPE_STR, 		REQ_YES, 	VF_METHOD),
		'description' 		=> array(TYPE_STR, 		REQ_NO),
		'active' 			=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 'verify_onoff'),
		'displayorder' 		=> array(TYPE_UINT, 	REQ_NO),
		'usergroupids' 		=> array(TYPE_NOCLEAN, 	REQ_NO, 	VF_METHOD, 'verify_commalist'),
		'image' 			=> array(TYPE_STR, 		REQ_NO),
		'image_selected' 	=> array(TYPE_STR, 		REQ_NO),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'dbtech_postbittabs_tab';

	/**
	* Condition for update query
	*
	* @var	array
	*/
	var $condition_construct = array('tabid = %1$d', 'tabid');

	/**
	* Constructor - checks that the registry object has been passed correctly.
	*
	* @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
	* @param	integer		One of the ERRTYPE_x constants
	*/
	function Postbit_DataManager_Tab(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);

		($hook = vBulletinHook::fetch_hook('dbtech_postbittabs_tabdata_start')) ? eval($hook) : false;
	}

	/**
	* Verifies that the title is valid
	*
	* @param	string	Title of the tab
	*
	* @return	boolean
	*/
	function verify_title(&$title)
	{
		global $vbphrase;
		
		$title = strval($title);
		if ($title === '')
		{
			// Invalid
			return false;
		}
		
		// Check for existing tab of this name
		if ($existing = $this->registry->db->query_first("
			SELECT `title`
			FROM `" . TABLE_PREFIX . "dbtech_postbittabs_tab`
			WHERE `title` = " . $this->registry->db->sql_prepare($title) . "
				" . ($this->existing['tabid'] ? "AND `tabid` != " . $this->registry->db->sql_prepare($this->existing['tabid']) : '') . "			
			LIMIT 1
		"))
		{
			// Whoopsie, exists
			$this->error('dbtech_postbittabs_x_already_exists_y', $vbphrase['dbtech_postbittabs_tab'], $title);
			return false;
		}

		return true;
	}

	/**
	* Verifies that the onoff flag is valid
	*
	* @param	string	On/Off flag
	*
	* @return	boolean
	*/
	function verify_onoff(&$onoff)
	{
		// Validate onoff
		$onoff = (!in_array($onoff, array('0', '1')) ? '1' : $onoff);
		
		return true;
	}

	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}
		
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_postbittabs_tabdata_presave')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}
	
	/**
	* Additional data to update before a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function pre_delete($doquery = true)
	{
		
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_postbittabs_tabdata_predelete')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_postbittabs_tabdata_postsave')) ? eval($hook) : false;

		// Rebuild the cache
		POSTBITTABS_CACHE::build_cache('tab', 'ORDER BY `displayorder` ASC');
		POSTBITTABS_CACHE::build_cache('view', 'LEFT JOIN ' . TABLE_PREFIX . 'dbtech_postbittabs_tab AS tab ON (tab.tabid = dbtech_postbittabs_view.tabid)
			ORDER BY tab.displayorder, dbtech_postbittabs_view.displayorder ASC');

		return true;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_postbittabs_tabdata_delete')) ? eval($hook) : false;
		
		$this->registry->db->query_write("
			UPDATE " . TABLE_PREFIX . "dbtech_postbittabs_view
			SET tabid = 0
			WHERE tabid = " . $this->existing['tabid']
		);
		
		// Rebuild the cache
		POSTBITTABS_CACHE::build_cache('tab', 'ORDER BY `displayorder` ASC');
		POSTBITTABS_CACHE::build_cache('view', 'LEFT JOIN ' . TABLE_PREFIX . 'dbtech_postbittabs_tab AS tab ON (tab.tabid = dbtech_postbittabs_view.tabid)
			ORDER BY tab.displayorder, dbtech_postbittabs_view.displayorder ASC');
		
		return true;
	}
}