<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
// vBSupport functionality class

/**
* Handles everything to do with vBSupport.
*/
class POSTBITTABS
{
	/**
	* Version info
	*
	* @public	mixed
	*/	
	public static $jQueryVersion 	= '1.7.2';	
	public static $version 			= '1.1.0 Beta 1';
	public static $versionnumber	= '110b1';
	
	/**
	* The vBulletin registry object
	*
	* @private	vB_Registry
	*/	
	protected static $vbulletin 	= NULL;
	
	/**
	* The vBulletin registry object
	*
	* @private	vB_Registry
	*/	
	protected static $prefix 		= 'dbtech_';
	
	/**
	* The vBulletin registry object
	*
	* @private	vB_Registry
	*/	
	protected static $bitfieldgroup	= 'postbittabspermissions';
	
	/**
	* Array of permissions to be returned
	*
	* @public	array
	*/	
	public static $permissions 		= NULL;
	
	/**
	* Array of cached items
	*
	* @public	array
	*/		
	public static $cache			= array();
	
	/**
	* Whether we've called the DM fetcher
	*
	* @public	boolean
	*/		
	protected static $called		= false;
	
	/**
	* Array of cached items
	*
	* @public	array
	*/		
	public static $unserialize		= array();
	
	/**
	* Array of created product views
	*
	* @public	array
	*/		
	public static $created			= array();
	
	/**
	* Whether we have the pro version or not
	*
	* @public	boolean
	*/		
	public static $isPro		= false;

	
	/**
	* Does important checking before anything else should be going on
	*
	* @param	vB_Registry	Registry object
	*/
	public static function init($vbulletin)
	{
		// Check if the vBulletin Registry is an object
		if (!is_object($vbulletin))
		{
			// Something went wrong here I think
			trigger_error("Registry object is not an object", E_USER_ERROR);
		}
		
		// Set registry
		self::$vbulletin =& $vbulletin;
		
		// Set permissions shorthand
		self::get_permissions();
		
		// What permissions to override
		$override = array(
			'canview',
		);
		
		foreach ($override as $permname)
		{
			// Override various permissions
			self::$permissions[$permname] = (self::$permissions['ismanager'] ? 1 : self::$permissions[$permname]);
		}
		
		foreach (self::$unserialize as $cachetype => $keys)
		{
			foreach ((array)self::$cache[$cachetype] as $id => $arr)
			{
				foreach ($keys as $key)
				{
					// Do unserialize
					self::$cache[$cachetype][$id][$key] = @unserialize($arr[$key]);
				}
			}
		}
		
		// Set pro version
		
	}
	
	/**
	* Grabs what permissions we have got
	*/
	private static function get_permissions()
	{
		// Override bitfieldgroup variable
		$bitfieldgroup = self::$prefix . self::$bitfieldgroup;
		
		if (!is_array(self::$vbulletin->bf_ugp[$bitfieldgroup]))
		{
			// Something went wrong here I think
			require_once(DIR . '/includes/class_bitfield_builder.php');
			if (vB_Bitfield_Builder::build(false) !== false)
			{
				$myobj =& vB_Bitfield_Builder::init();
				if (sizeof($myobj->data['ugp'][$bitfieldgroup]) != sizeof(self::$vbulletin->bf_ugp[$bitfieldgroup]))
				{
					require_once(DIR . '/includes/adminfunctions.php');					
					$myobj->save(self::$vbulletin->db);
					build_forum_permissions();
					
					if (IN_CONTROL_PANEL === true)
					{
						define('CP_REDIRECT', self::$vbulletin->scriptpath);
						print_stop_message('rebuilt_bitfields_successfully');
					}
					else
					{
						self::$vbulletin->url = self::$vbulletin->scriptpath;
						eval(print_standard_redirect(array('redirect_updatethanks', self::$vbulletin->userinfo['username']), true, true));				
					}
				}
			}
			else
			{
				echo "<strong>error</strong>\n";
				print_r(vB_Bitfield_Builder::fetch_errors());
				die();
			}
		}
		
		if (!self::$vbulletin->userinfo['permissions'])
		{
			// For some reason, this is missing
			cache_permissions(self::$vbulletin->userinfo);
		}
		
		foreach ((array)self::$vbulletin->bf_ugp[$bitfieldgroup] as $permname => $bit)
		{
			// Set the permission
			self::$permissions[$permname] = (!$bit ? self::$vbulletin->userinfo['permissions'][$bitfieldgroup][$permname] : (self::$vbulletin->userinfo['permissions'][$bitfieldgroup] & $bit ? 1 : 0));
		}
	}
	
	/**
	* Quick Method of building the CPNav Template
	*
	* @param	string	The selected item in the CPNav
	*/	
	public static function construct_nav($selectedcell = 'main')
	{
		global $navclass, $vbphrase;
		global $vbulletin, $show, $template_hook;
	
		$cells = array(
			'main',
			'issuelist',
			'breakdown',
		);
	
		//($hook = vBulletinHook::fetch_hook('usercp_nav_start')) ? eval($hook) : false;
		
		// set the class for each cell/group
		$navclass = array();
		foreach ($cells AS $cellname)
		{
			$navclass[$cellname] = (intval(self::$vbulletin->versionnumber) == 3 ? 'alt2' : 'inactive');
		}
		$navclass[$selectedcell] = (intval(self::$vbulletin->versionnumber) == 3 ? 'alt1' : 'active');
		
		//($hook = vBulletinHook::fetch_hook('usercp_nav_complete')) ? eval($hook) : false;
	}
		
	/**
	* Check if we have permissions to perform an action
	*
	* @param	array		User info
	* @param	array		Permissions info
	*/		
	public static function check_permissions(&$user, $permissions)
	{
		if (!$user['usergroupid'] OR (!isset($user['membergroupids']) AND $user['userid']))
		{
			// Ensure we have this
			$user = fetch_userinfo($user['userid']);
		}
		
		if (!is_array($user['permissions']))
		{
			// Ensure we have the perms
			cache_permissions($user);
		}
		
		$ugs = fetch_membergroupids_array($user);		
		if (!$ugs[0])
		{
			// Hardcode guests
			$ugs[0] = 1;
		}
		
		//self::$vbulletin->usergroupcache
		foreach ($ugs as $usergroupid)
		{
			$value = $permissions["$usergroupid"];
			$value = (isset($value) ? $value : -1);
			
			switch ($value)
			{
				case 1:
					// Allow
					return true;
					break;
				
				case -1:
					// Usergroup Default		
					if (!($user['permissions'][self::$prefix . self::$bitfieldgroup] & 4))
					{
						// Allow by default
						return true;
					}
					break;
			}
		}
		
		// We didn't make it
		return false;
	}
	
	/**
	* Class factory. This is used for instantiating the extended classes.
	*
	* @param	string			The type of the class to be called (user, forum etc.)
	* @param	vB_Registry		An instance of the vB_Registry object.
	* @param	integer			One of the ERRTYPE_x constants
	*
	* @return	vB_DataManager	An instance of the desired class
	*/
	public static function &datamanager_init($classtype, &$registry, $errtype = ERRTYPE_STANDARD)
	{
		if (empty(self::$called))
		{
			// include the abstract base class
			require_once(DIR . '/includes/class_dm.php');
			self::$called = true;
		}
	
		if (preg_match('#^\w+$#', $classtype))
		{
			require_once(DIR . '/dbtech/postbittabs/includes/class_dm_' . strtolower($classtype) . '.php');
	
			$classname = 'Postbit_DataManager_' . $classtype;
			$object = new $classname($registry, $errtype);
	
			return $object;
		}
	}
	
	/**
	* JS class fetcher for AdminCP
	*
	* @param	string	The JS file name or the code
	* @param	boolean	Whether it's a file or actual JS code
	*/
	public static function js($js = '', $file = true, $echo = true)
	{
		global $vbulletin;

		$output = '';
		if ($file)
		{
			$output = '<script type="text/javascript" src="' . $vbulletin->options['bburl'] . '/dbtech/postbittabs/clientscript/postbittabs' . $js . '.js?v=' . self::$versionnumber . '"></script>';
		}
		else
		{
			$output = "
				<script type=\"text/javascript\">
					<!--
					$js
					// -->
				</script>
			";
		}
		
		if ($echo)
		{
			echo $output;
		}
		else
		{
			return $output;
		}
	}
	
	/**
	* Determines the path to jQuery based on browser settings
	*/
	public static function jQueryPath()
	{
		// create the path to jQuery depending on the version
		if (self::$vbulletin->options['customjquery_path'])
		{
			$path = str_replace('{version}', self::$jQueryVersion, self::$vbulletin->options['customjquery_path']);
			if (!preg_match('#^https?://#si', self::$vbulletin->options['customjquery_path']))
			{
				$path = REQ_PROTOCOL . '://' . $path;
			}
			return $path;
		}
		else
		{
			switch (self::$vbulletin->options['remotejquery'])
			{
				case 1:
				default:
					// Google CDN
					return REQ_PROTOCOL . '://ajax.googleapis.com/ajax/libs/jquery/' . self::$jQueryVersion . '/jquery.min.js';
					break;

				case 2:
					// jQuery CDN
					return REQ_PROTOCOL . '://code.jquery.com/jquery-' . self::$jQueryVersion . '.min.js';
					break;

				case 3:
					// Microsoft CDN
					return REQ_PROTOCOL . '://ajax.aspnetcdn.com/ajax/jquery/jquery-' . self::$jQueryVersion . '.min.js';
					break;
			}
		}
	}
	
	/**
	* View registration method.
	* Allows modifications to easily add their postbit code to the mod.
	*
	* @param	string	The varname of the view. Must be unique.
	* @param	string	The title of the view.
	* @param	string	The HTML Code (exactly like it would appear in the templates).
	*/
	public static function registerView($varname, $title, $htmlCode, $active = 1)
	{
		if ($existing = self::$cache['view']["$varname"])
		{
			if (!$existing['automated'] OR $existing['htmlcode'] == $htmlCode)
			{
				// We're not updating this
				return false;
			}
			
			// Insert new view
			$dm =& self::datamanager_init('View', self::$vbulletin, ERRTYPE_SILENT);
				$dm->set_existing($existing);
				$dm->set('htmlcode', 	$htmlCode);
			$dm->save();
			
			// Update was successful!
			return true;
		}
		
		// Insert new view
		$dm =& self::datamanager_init('View', self::$vbulletin, ERRTYPE_SILENT);
			$dm->set('viewid', 			$varname);
			$dm->set('title', 			$title);
			$dm->set('description', 	$title);
			$dm->set('active', 			$active);
			$dm->set('displayorder', 	10);
			$dm->set('htmlcode', 		$htmlCode);
			$dm->set('automated', 		true);
		$dm->save();
		
		// Insert was successful!
		return true;
	}
}


// #############################################################################
// filter functionality class

/**
* Class that handles filtering arrays
*/
class POSTBITTABS_FILTER
{
	/**
	* Id Field we are using
	*
	* @private	string
	*/	
	private static $idfield 	= NULL;
	
	/**
	* Id value we are looking for
	*
	* @private	mixed
	*/	
	private static $idval 		= NULL;
	
	
	
	/**
	* Sets up and begins the filtering process 
	*
	* @param	array	Array to filter
	* @param	string	What the ID Field is
	* @param	mixed	What we are looking for
	*
	* @return	array	Filtered array
	*/
	public static function filter($array, $idfield, $idval)
	{
		// Set the two things we can't pass on to the callback
		self::$idfield 	= $idfield;
		self::$idval	= $idval;
		
		// Filter this shiet
		return array_filter($array, array(__CLASS__, 'do_filter'));
	}
	
	/**
	* Checks if this element should be included
	*
	* @param	array	Array to filter
	*
	* @return	boolean	Whether we should include this or not
	*/	
	protected static function do_filter($array)
	{
		$idfield 	= self::$idfield;
		$idval		= self::$idval;
		return ($array["$idfield"] == $idval);
	}
}