<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
if ($_REQUEST['action'] == 'tab' OR empty($_REQUEST['action']))
{
	print_cp_header($vbphrase['dbtech_postbittabs_tab_management']);
	
	// Table header
	$headings = array();
	$headings[] = $vbphrase['title'];
	$headings[] = $vbphrase['description'];
	$headings[] = $vbphrase['active'];
	$headings[] = $vbphrase['display_order'];
	
	// Hook goes here
	
	$headings[] = $vbphrase['edit'];
	$headings[] = $vbphrase['delete'];
	
	if (count(POSTBITTABS::$cache['tab']))
	{
		print_form_header('postbittabs', 'tab');
		construct_hidden_code('action', 'displayorder');
		print_table_header($vbphrase['dbtech_postbittabs_tab_management'], count($headings));
		print_cells_row($headings, 0, 'thead');
		
		foreach (POSTBITTABS::$cache['tab'] as $tabid => $tab)
		{
			// Table data
			$cell = array();
			$cell[] = 	'<img src="' . ($tab['image'] ? $tab['image'] : '../dbtech/postbittabs/images/tab.png') . '" /> ' . 
						'<img src="' . ($tab['image_selected'] ? $tab['image_selected'] : '../dbtech/postbittabs/images/tab_selected.png') . '" /> ' . 
						$tab['title'];
			$cell[] = $tab['description'];
			$cell[] = ($tab['active'] ? $vbphrase['yes'] : '<span class="col-i"><strong>' . $vbphrase['no'] . '</strong></span>');
			$cell[] = "<input type=\"text\" class=\"bginput\" name=\"displayorder[$tabid]\" value=\"$tab[displayorder]\" tabindex=\"1\" size=\"3\"" . iif($vbulletin->debug, " title=\"name=&quot;order[$tabid]&quot;\"") . " />";
			
			// Hook goes here
			
			$cell[] = construct_link_code($vbphrase['edit'], 'postbittabs.php?' . $vbulletin->session->vars['sessionurl'] . 'do=tab&amp;action=modify&amp;tabid=' . $tabid);
			$cell[] = construct_link_code($vbphrase['delete'], 'postbittabs.php?' . $vbulletin->session->vars['sessionurl'] . 'do=tab&amp;action=delete&amp;tabid=' . $tabid);
			
			// Print the data
			print_cells_row($cell, 0, 0, -5, 'middle', 0, 1);
		}
		print_submit_row($vbphrase['save_display_order'], false, count($headings), false, "<input type=\"button\" id=\"addnew\" class=\"button\" value=\"" . str_pad($vbphrase['dbtech_postbittabs_add_new_tab'], 8, ' ', STR_PAD_BOTH) . "\" tabindex=\"1\" onclick=\"window.location = 'postbittabs.php?do=tab&action=modify'\" />");	
	}
	else
	{
		print_form_header('postbittabs', 'tab');
		construct_hidden_code('action', 'modify');
		print_table_header($vbphrase['dbtech_postbittabs_tab_management'], count($headings));
		print_description_row($vbphrase['dbtech_postbittabs_no_tabs'], false, count($headings));
		print_submit_row($vbphrase['dbtech_postbittabs_add_new_tab'], false, count($headings));	
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'modify')
{
	$tabid = $vbulletin->input->clean_gpc('r', 'tabid', TYPE_UINT);
	$tab = ($tabid ? POSTBITTABS::$cache['tab']["$tabid"] : false);
	
	if (!is_array($tab))
	{
		// Non-existing tab
		$tabid = 0;
	}
	
	$defaults = array(
		'title' 		=> 'Tab',
		'description' 	=> 'A tab.',
		'active' 		=> 1,
		'displayorder'	=> 10
	);
	
	if ($tabid)
	{
		// Edit
		print_cp_header(strip_tags(construct_phrase($vbphrase['dbtech_postbittabs_editing_x_y'], $vbphrase['dbtech_postbittabs_tab'], $tab['title'])));
		print_form_header('postbittabs', 'tab');
		construct_hidden_code('action', 'update');
		construct_hidden_code('tabid', $tabid);
		print_table_header(construct_phrase($vbphrase['dbtech_postbittabs_editing_x_y'], $vbphrase['dbtech_postbittabs_tab'], $tab['title']));
	}
	else
	{
		// Add
		print_cp_header($vbphrase['dbtech_postbittabs_add_new_tab']);
		print_form_header('postbittabs', 'tab');
		construct_hidden_code('action', 'update');
		print_table_header($vbphrase['dbtech_postbittabs_add_new_tab']);
		
		$tab = $defaults;
	}
	
	// Cause print_membergroup_row sucks.
	$tab['membergroupids'] = $tab['usergroupids'];
	
	print_description_row($vbphrase['dbtech_postbittabs_main_settings'], false, 2, 'optiontitle');	
	print_input_row($vbphrase['title'], 											'tab[title]', 			$tab['title']);
	print_textarea_row($vbphrase['description'],									'tab[description]',		$tab['description']);
	print_yes_no_row($vbphrase['active'],											'tab[active]',			$tab['active']);
	print_description_row($vbphrase['dbtech_postbittabs_tab_settings'], false, 2, 'optiontitle');	
	print_input_row($vbphrase['display_order'], 									'tab[displayorder]', 	$tab['displayorder']);
	if (POSTBITTABS::$isPro)
	{
		print_membergroup_row($vbphrase['dbtech_postbittabs_banned_usergroups_tab'],'tab[usergroupids]', 2, $tab['usergroupids']);
		print_input_row($vbphrase['dbtech_postbittabs_tab_image'], 					'tab[image]', 			$tab['image']);
		print_input_row($vbphrase['dbtech_postbittabs_selected_tab_image'], 		'tab[image_selected]', 	$tab['image_selected']);
	}
	print_submit_row(($tabid ? $vbphrase['save'] : $vbphrase['dbtech_postbittabs_add_new_tab']));	
}

// #############################################################################
if ($_POST['action'] == 'update')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'tabid' 	=> TYPE_UINT,
		'tab' 		=> TYPE_ARRAY,
	));
	
	// init data manager
	$dm =& POSTBITTABS::datamanager_init('Tab', $vbulletin, ERRTYPE_CP);
	
	// set existing info if this is an update
	if ($vbulletin->GPC['tabid'])
	{
		if (!$existing = POSTBITTABS::$cache['tab']["{$vbulletin->GPC[tabid]}"])
		{
			// Couldn't find the tab
			print_stop_message('dbtech_postbittabs_invalid_x', $vbphrase['dbtech_postbittabs_tab'], $vbulletin->GPC['tabid']);
		}
		
		// Set existing
		$dm->set_existing($existing);
		
		// Added
		$phrase = $vbphrase['dbtech_postbittabs_edited'];
	}
	else
	{
		// Added
		$phrase = $vbphrase['dbtech_postbittabs_added'];
	}
	
	// tab fields
	foreach ($vbulletin->GPC['tab'] AS $key => $val)
	{
		if (!$vbulletin->GPC['tabid'] OR $existing["$key"] != $val)
		{
			// Only set changed values
			$dm->set($key, $val);
		}
	}
	
	if (empty($vbulletin->GPC['tab']['usergroupids']))
	{
		$dm->set('usergroupids', '');
	}
	
	// Save! Hopefully.
	$dm->save();
	
	define('CP_REDIRECT', 'postbittabs.php?do=tab');
	print_stop_message('dbtech_postbittabs_x_y', $vbphrase['dbtech_postbittabs_tab'], $phrase);	
}

// #############################################################################
if ($_REQUEST['action'] == 'delete')
{
	$vbulletin->input->clean_gpc('r', 'tabid', TYPE_UINT);
	
	print_cp_header(construct_phrase($vbphrase['dbtech_postbittabs_delete_x'], $vbphrase['dbtech_postbittabs_tab']));
	print_delete_confirmation('dbtech_postbittabs_tab', $vbulletin->GPC['tabid'], 'postbittabs', 'tab', 'dbtech_postbittabs_tab', array('action' => 'kill'), '', 'title');
	print_cp_footer();
}

// #############################################################################
if ($_POST['action'] == 'kill')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'tabid' => TYPE_UINT,
		'kill' 		 => TYPE_BOOL
	));
	
	if (!$existing = POSTBITTABS::$cache['tab']["{$vbulletin->GPC[tabid]}"])
	{
		// Couldn't find the tab
		print_stop_message('dbtech_postbittabs_invalid_x', $vbphrase['dbtech_postbittabs_tab'], $vbulletin->GPC['tabid']);
	}
	
	// init data manager
	$dm =& POSTBITTABS::datamanager_init('Tab', $vbulletin, ERRTYPE_CP);
		$dm->set_existing($existing);
	$dm->delete();
	
	define('CP_REDIRECT', 'postbittabs.php?do=tab');
	print_stop_message('dbtech_postbittabs_x_y', $vbphrase['dbtech_postbittabs_tab'], $vbphrase['dbtech_postbittabs_deleted']);	
}

// #############################################################################
if ($_POST['action'] == 'displayorder')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'displayorder' => TYPE_ARRAY_UINT,
	));
	
	foreach ($vbulletin->GPC['displayorder'] as $tabid => $displayorder)
	{
		if (!$existing = POSTBITTABS::$cache['tab']["$tabid"])
		{
			// Didn't exist
			continue;
		}
		
		// init data manager
		$dm =& POSTBITTABS::datamanager_init('Tab', $vbulletin, ERRTYPE_CP);
			$dm->set_existing($existing);
			$dm->set('displayorder', $displayorder);
		$dm->save();
		unset($dm);
	}
	
	define('CP_REDIRECT', 'postbittabs.php?do=tab');
	print_stop_message('dbtech_postbittabs_x_y', $vbphrase['dbtech_postbittabs_tab'], $vbphrase['dbtech_postbittabs_edited']);	
}


print_cp_footer();