<?php if (!defined('VB_ENTRY')) die('Access denied.');
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin-Linklist Version 1.0.0
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2010, AddOn-Coders (http://www.addon-coders.de)  # ||
|| # ---------------------------------------------------------------- # ||
|| # Dateiname: linklistentry.php                                     # ||
|| # ---------------------------------------------------------------- # ||
|| # Support nur unter http://www.vbulletin-germany.org               # ||
|| # ---------------------------------------------------------------- # ||
|| # Dieses ist keine freie Software! Änderungen, unerlaubtes Nutzen  # ||
|| # oder unerlaubte Verbreitung sind nicht erlaubt (auch nicht in    # ||
|| # Auszügen oder Einzelteilen) - This is not free software, changes # ||
|| # in and unallowed use of (parts from) this script is not allowed! # ||
|| #################################################################### ||
\*======================================================================*/

require_once (DIR . '/vb/search/result.php');

/**
 * Restum Item Controller for linklist entries
 *
 * @package vBulletin
 * @subpackage Search
 */
class vBLinklist_Search_Result_LinklistEntry extends vB_Search_Result
{
	protected $preview_length = 200;

	public static function create($id)
	{
		$items = self::create_array(array($id));
		if (count($items))
		{
			return array_shift($items);
		}
		else
		{
			//invalid object.
			return new vBLinklist_Search_Result_LinklistEntry();
		}
	}

	public static function create_array($ids)
	{
		global $vbulletin, $usercache;

		if (
			!($vbulletin->userinfo['permissions']['vblinklist_general_permissions'] & $vbulletin->bf_ugp_vblinklist_general_permissions['can_enter_linklist'])
			OR
			!($vbulletin->userinfo['permissions']['vblinklist_general_permissions'] & $vbulletin->bf_ugp_vblinklist_general_permissions['can_view_link'])
		)
		{
			// no permission to view linklist or linklist entries
			return array();
		}

		$groupsql = array();
		foreach (fetch_membergroupids_array($vbulletin->userinfo) AS $usergroupid)
		{
			$groupsql[] = "FIND_IN_SET($usergroupid, vblinklist_category.groupshowlist)";
		}

		$set = $vbulletin->db->query_read_slave("
			SELECT entry.*, vblinklist_category.name AS categoryname
			FROM " . TABLE_PREFIX ."vblinklist_entry AS entry
			INNER JOIN " . TABLE_PREFIX . "vblinklist_category AS vblinklist_category ON (vblinklist_category.id = entry.categoryid AND (vblinklist_category.groupshow = 1 OR " . implode(' OR ', $groupsql) . "))
			WHERE entry.id IN (" . implode(',', array_map('intval', $ids)) . ")
			" . ((!($vbulletin->userinfo['permissions']['vblinklist_general_permissions'] & $vbulletin->bf_ugp_vblinklist_general_permissions['can_administrate'])) ? "AND entry.status = 1" : "") . "
		");

		$items = array();
		while ($record = $vbulletin->db->fetch_array($set))
		{
			$item = new vBLinklist_Search_Result_LinklistEntry();
			$item->record = $record;
			$items[$record['id']] = $item;
		}

		return $items;
	}

	public function create_from_record($record)
	{
		$item = new vBLinklist_Search_Result_LinklistEntry();
		$item->record = $record;
		return $item;
	}

	protected function __construct() {}

	public function get_contenttype()
	{
		return vB_Search_Core::get_instance()->get_contenttypeid('vBLinklist', 'LinklistEntry');
	}

	public function can_search($user)
	{
		//if we sucessfully loaded it, we can search on it.
		return (bool) $this->record;
	}

	public function render($current_user, $criteria, $template_name = '')
	{
		if (!$this->record)
		{
			return "";
		}

		if (!$template_name)
		{
			$template_name = 'vblinklist_search_result_entry';
		}
		
		$entry = $this->record;
		
		$entry['previewtext']  = htmlspecialchars_uni(fetch_censored_text(
			fetch_trimmed_title(strip_bbcode($entry['description'], true, true, true, true),
					$this->preview_length)
		));

		$templater = vB_Template::create($template_name);
		$templater->register('entry', $entry);
		return $templater->render();
	}

	public function get_record()
	{
		return $this->record;
	}

	/*** Returns the primary id. Allows us to cache a result item.
	 *
	 * @result	integer
	 ***/
	public function get_id()
	{
		if (isset($this->record) AND isset($this->record['id']) )
		{
			return $this->record['id'];
		}
		return false;
	}

	private $record = null;
}

?>