<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin-Linklist Version 1.0.0
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2010, AddOn-Coders (http://www.addon-coders.de)  # ||
|| # ---------------------------------------------------------------- # ||
|| # Dateiname/filename: class_vblinklist_entry.php		      # ||
|| # ---------------------------------------------------------------- # ||
|| # Support nur unter http://www.vbulletin-germany.org               # ||
|| # ---------------------------------------------------------------- # ||
|| # Dieses ist keine freie Software! nderungen, unerlaubtes Nutzen  # ||
|| # oder unerlaubte Verbreitung sind nicht erlaubt (auch nicht in    # ||
|| # Auszgen oder Einzelteilen) - This is not free software, changes # ||
|| # in and unallowed use of (parts from) this script is not allowed! # ||
|| #################################################################### ||
\*======================================================================*/

/**
* Linklist entry factory.
*
* @package 	vBulletin Linklist
*
*/
class vB_vBLinklist_EntryFactory
{
	/**
	* Registry object
	*
	* @var	vB_Registry
	*/
	var $registry = null;

	/**
	* BB code parser object
	*
	* @var	vB_BbCodeParser
	*/
	var $bbcode = null;

	/**
	* Information about the entry this response belongs to
	*
	* @var	array
	*/
	var $categories = array();

	/**
	* Permission cache for various users.
	*
	* @var	array
	*/
	var $perm_cache = array();

	/**
	* Array holding information about a specific user if we are viewing a specific user's entries
	*
	* @var	array
	*/
	var $userinfo = array();

	/**
	* Constructor, sets up the object.
	*
	* @param	vB_Registry
	* @param	vB_BbCodeParser
	* @param	array	entry info
	*/
	function vB_vBLinklist_EntryFactory(&$registry, &$bbcode, &$categories)
	{
		if (is_object($registry))
		{
			$this->registry =& $registry;
		}
		else
		{
			trigger_error("vB_Database::Registry object is not an object", E_USER_ERROR);
		}

		$this->bbcode =& $bbcode;
		$this->categories =& $categories;
	}

	/**
	* Create an entry response object for the specified response
	*
	* @param	array	Response information
	* @param 	string	Override auto detection
	*
	* @return	vB_vBLinklist_Response
	*/
	function &create($entry, $type = '', $ignored_users = array())
	{
		$class_name = 'vB_vBLinklist_Entry';

		if (class_exists($class_name, false))
		{
			return new $class_name($this->registry, $this, $this->bbcode, $this->categories, $entry, $ignored_users);
		}
		else
		{
			trigger_error('vB_vBLinklist_EntryFactory::create(): Invalid type (' . htmlspecialchars($class_name) . ')', E_USER_ERROR);
		}
	}
}

/**
* Generic linlist entry class.
*
* @package 	vBulletin Linklist
*
*/
class vB_vBLinklist_Entry
{
	/**
	* Registry object
	*
	* @var	vB_Registry
	*/
	var $registry = null;

	/**
	* Factory object that created this object. Used for permission caching.
	*
	* @var	vB_vBLinklist_EntryFactory
	*/
	var $factory = null;

	/**
	* BB code parser object (if necessary)
	*
	* @var	vB_BbCodeParser
	*/
	var $bbcode = null;

	/**
	* Cached information from the BB code parser
	*
	* @var	array
	*/
	var $parsed_cache = array();

	/**
	* Information about the possible categories we need
	*
	* @var	array
	*/
	var $categories = array();

	/**
	* Information about the entry
	*
	* @var	array
	*/
	var $entry = array();

	/**
	* Variable which identifies if the data should be cached
	*
	* @var	boolean
	*/
	var $cachable = true;

	/**
	* Constructor sets up the object.
	*
	* @param	vB_Registry
	* @param	vB_BbCodeParser
	* @param	vB_vBLinklist_EntryFactory
	* @param	array	Entry info
	* @param	array	Ignored Users
	*/
	function vB_vBLinklist_Entry(&$registry, &$factory, &$bbcode, &$categories, $entry, $ignored_users)
	{
		if (is_object($registry))
		{
			$this->registry =& $registry;
		}
		else
		{
			trigger_error("vB_vBLinklist_Entry::Registry object is not an object", E_USER_ERROR);
		}

		$this->registry =& $registry;
		$this->factory =& $factory;
		$this->bbcode =& $bbcode;
		$this->categories =& $categories;
		$this->ignored_users = $ignored_users;
		$this->entry = $entry;
	}

	/**
	* Template method that does all the work to display an issue note, including processing the template
	*
	* @return	string	Templated note output
	*/
	function construct()
	{
		global $vbulletin;

		if ($this->entry['userid'])
		{
			$this->process_registered_user();
		}
		else
		{
			$this->process_unregistered_user();
		}

		$this->process_text();

		// actual display...
		$entry =& $this->entry;

		return $output;
	}

	/**
	* Process note as if a registered user posted
	*/
	function process_registered_user()
	{
		global $show, $vbphrase;

		fetch_musername($this->entry, 'displaygroupid');

		$this->entry['onlinestatus'] = 0;

		// now decide if we can see the user or not
		if ($this->entry['lastactivity'] > (TIMENOW - $this->registry->options['cookietimeout']) AND $this->entry['lastvisit'] != $this->entry['lastactivity'])
		{
			if ($this->entry['invisible'])
			{
				if (($this->registry->userinfo['permissions']['genericpermissions'] & $this->registry->bf_ugp_genericpermissions['canseehidden']) OR $this->entry['userid'] == $this->registry->userinfo['userid'])
				{
					// user is online and invisible BUT bbuser can see them
					$this->entry['onlinestatus'] = 2;
				}
			}
			else
			{
				// user is online and visible
				$this->entry['onlinestatus'] = 1;
			}
		}

		if (!isset($this->factory->perm_cache["{$this->entry['userid']}"]))
		{
			$this->factory->perm_cache["{$this->entry['userid']}"] = cache_permissions($this->entry, false);
		}
		else
		{
			$this->entry['permissions'] =& $this->factory->perm_cache["{$this->entry['userid']}"];
		}
	}

	/**
	* Process note as if an unregistered user posted
	*/
	function process_unregistered_user()
	{
		global $show;

		$show['subscribelink'] = false;

		$this->entry['rank'] = '';
		$this->entry['notesperday'] = 0;
		$this->entry['displaygroupid'] = 1;
		fetch_musername($this->entry);
		$this->entry['usertitle'] =& $this->registry->usergroupcache["0"]['usertitle'];
		$this->entry['joindate'] = '';
		$this->entry['notes'] = 'n/a';
		$this->entry['avatar'] = '';
		$this->entry['profile'] = '';
		$this->entry['email'] = '';
		$this->entry['useremail'] = '';
		$this->entry['icqicon'] = '';
		$this->entry['aimicon'] = '';
		$this->entry['yahooicon'] = '';
		$this->entry['msnicon'] = '';
		$this->entry['skypeicon'] = '';
		$this->entry['homepage'] = '';
		$this->entry['findnotes'] = '';
		$this->entry['signature'] = '';
		$this->entry['reputationdisplay'] = '';
		$this->entry['onlinestatus'] = '';
	}

	/**
	* Prepare the text for display
	*/
	function process_text()
	{
		global $vbphrase;

		$this->bbcode->set_parse_userinfo($this->entry, $this->factory->perm_cache["{$this->entry['userid']}"]);

		$this->bbcode->containerid = $this->entry['id'];
		$this->entry['message'] = $this->bbcode->parse(
			$this->entry['description'],
			'picturecomment',
			true,
			false,
			$this->entry['pagetexthtml'],
			$this->entry['hasimages'],
			$this->cachable,
			$this->entry['htmlstate']
		);
	}
}

?>
