<?php

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('CSRF_PROTECTION', true);

// ################### PRE-CACHE TEMPLATES AND DATA ######################
$globaltemplates = array();
$phrasegroups = array();
$specialtemplates = array();

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_misc.php');
require_once(DIR . '/includes/functions_bigthree.php');
require_once(DIR . '/includes/class_bootstrap_framework.php');
vB_Bootstrap_Framework::init();

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

echo 'Leere Tabellen von vBulletin-Linkliste / truncate table of vBulletin Link Directory: <br/><br/>';

$vossi1 = $db->query_read("TRUNCATE TABLE " . TABLE_PREFIX . "vblinklist_category");
$vossi2 = $db->query_read("TRUNCATE TABLE " . TABLE_PREFIX . "vblinklist_entry");

echo 'Konvertiere Kategorien / Convert categories: <br/><br/>';

// alte cat lesen
$result = $db->query_read("
	SELECT *
	FROM " . TABLE_PREFIX . "local_linkscat 
	ORDER BY catid
");
$i = 1;
while ($row = $db->fetch_array($result))
{
	echo $row['catid'] . ': ' . $row['catname'] . '<br/>';

	// neue cat schreiben
	$db->query_write("INSERT INTO " . TABLE_PREFIX . "vblinklist_category (id, parentid, displayorder, name, description, status)
	VALUES (
		'" . intval($row['catid']) . "',
		'" . intval($row['parentid']) . "',
		'" . intval($i) . "',
		'" . $db->escape_string($row['catname']) . "',
		'" . $db->escape_string($row['catdesc']) . "',
		'1'
	)");
	$i++;
}

echo '<br/><br/>Konvertiere Links / Convert links: <br/><br/>';

// alte Eintrge lesen
$entry = $db->query_read("
	SELECT link.*, toc.*
	FROM " . TABLE_PREFIX . "local_linkslink AS link
	LEFT JOIN " . TABLE_PREFIX . "local_linksltoc AS toc ON(link.linkid = toc.linkid )
	ORDER BY link.linkid
");
while ($link = $db->fetch_array($entry))
{
	echo $link['linkid'] . ': ' . $link['linkname'] . '<br/>';

	// neue eintrge schreiben
	$db->query_write("INSERT INTO " . TABLE_PREFIX . "vblinklist_entry (name, description, userid, username, dateline, categoryid, status, views, linkurl)
	VALUES (
		'" . $db->escape_string($link['linkname']) . "',
		'" . $db->escape_string($link['linkdesc']) . "',
		'" . intval($link['linkuserid']) . "',
		'" . $db->escape_string($link['linkusername']) . "',
		'" . intval($link['linkdate']) . "',
		'" . intval($link['catid']) . "',
		'1',
		'" . intval($link['linkhits']) . "',
		'" . $db->escape_string($link['linkurl']) . "'
	)");
}

echo '<br/><br/>Erstelle Datastore / build datastore... <br/><br/>';

require_once(DIR . '/includes/adminfunctions_vblinklist.php');
build_vblinklist_datastore();

echo '<br/><br/>... beendet / finished !!!';

?>
