<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin-Linklist Version 1.0.3
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2010, AddOn-Coders (http://www.addon-coders.de)  # ||
|| # ---------------------------------------------------------------- # ||
|| # Dateiname/filename: vblinklist.php				      # ||
|| # ---------------------------------------------------------------- # ||
|| # Support nur unter http://www.vbulletin-germany.org               # ||
|| # ---------------------------------------------------------------- # ||
|| # Dieses ist keine freie Software! nderungen, unerlaubtes Nutzen  # ||
|| # oder unerlaubte Verbreitung sind nicht erlaubt (auch nicht in    # ||
|| # Auszgen oder Einzelteilen) - This is not free software, changes # ||
|| # in and unallowed use of (parts from) this script is not allowed! # ||
|| #################################################################### ||
\*======================================================================*/

// ####################### SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### DEFINE IMPORTANT CONSTANTS #######################
define('VB_PRODUCT', 'vblinklist');
define('THIS_SCRIPT', 'vblinklist');
define('CSRF_PROTECTION', true);
define('GET_EDIT_TEMPLATES', 'editentry, updateentry, showentry, commentmessage');

// ################### PRE-CACHE TEMPLATES AND DATA ######################
$globaltemplates = array(
	'vblinklist_categorylistbit',
	'vblinklist_home',
	'vblinklist_subcategorylistbit',
	'vblinklist_subcategorylistbitcomma',
	'vblinklist_subcategorymainlistbit'
);

$actiontemplates = array(
	'commentdelete' => array(
		'vblinklist_deletecomment'
	),
	'commentreport' => array(
		'vblinklist_reportcomment'
	),
	'commentmessage' => array(
		'vblinklist_editcomment'
	),
	'editentry' => array(
		'vblinklist_deleteentry',
		'vblinklist_moveentry',
		'vblinklist_newowner',
		'vblinklist_newentry',
		'vblinklist_rules'
	),
	'moderateentry' => array(
		'vblinklist_deletemodentry',
		'vblinklist_moveentries'
	),
	'report' => array(
		'vblinklist_report'
	),
	'showcat' => array(
		'vblinklist_categorylistbitsub',
		'vblinklist_catjump',
		'vblinklist_catjumpbitsmain',
		'vblinklist_catjumpbitssub',
		'vblinklist_entrylistbits',
		'vblinklist_letterbits',
		'vblinklist_readmorebit',
		'vblinklist_rules',
		'vblinklist_showcat',
		'vblinklist_sortarrow'
	),
	'showentry' => array(
		'bbcode_code',
		'bbcode_html',
		'bbcode_php',
		'bbcode_quote',
		'bbcode_video',
		'facebook_publishcheckbox',
		'facebook_likebutton',
		'showthread_quickreply',
		'vblinklist_linkcomment_commentarea',
		'vblinklist_linkcomment_message',
		'vblinklist_showentry',
		'vblinklist_thumbnail_backlink',
		'vblinklist_thumbnail_service'
	),
	'updateentry' => array(
		'vblinklist_deleteentry',
		'vblinklist_entrypreview',
		'vblinklist_blacklist',
		'vblinklist_duplicate',
		'vblinklist_error_message',
		'vblinklist_moveentry',
		'vblinklist_newentry',
		'vblinklist_rules'
	),
	'userdelete' => array(
		'vblinklist_deleteentry'
	),
);

$phrasegroups = array(
	'vblinklist'
);

$specialtemplates = array(
	'smiliecache',
	'bbcodecache',
	'vblinklist',
);

if ($_REQUEST['do'] == 'editentry' OR $_REQUEST['do'] == 'updateentry')
{
	$phrasegroups[] = 'posting';
}

if ($_REQUEST['do'] == 'showentry')
{
	$phrasegroups = array(
		'vblinklist',
		'album',
		'user',
		'posting'
	);
}

// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/functions_misc.php');
require_once(DIR . '/includes/functions_vblinklist.php');
require_once(DIR . '/includes/functions_bigthree.php');
require_once(DIR . '/includes/class_bootstrap_framework.php');
vB_Bootstrap_Framework::init();

// ######################### CHECK PERMISSIONS ############################
if (!($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_enter_linklist']))
{
	print_no_permission();
}

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'home';
}

// #######################################################################
if ($_REQUEST['do'] == 'home')
{
	$vbulletin->input->clean_array_gpc('g', array(
		'sort'	=> TYPE_NOHTML,
		'order'	=> TYPE_NOHTML
	));

	// get values
	$sortfield =& $vbulletin->GPC['sort'];
	$sortorder =& $vbulletin->GPC['order'];

	($hook = vBulletinHook::fetch_hook('vblinklist_homestart')) ? eval($hook) : false;

	if (!$vbulletin->options['vblinklist_displayorder'])
	{
		$sortfield = 'name';
	}
	else
	{
		$sortfield = 'displayorder';
	}

	if ($sortorder != 'desc')
	{
		$sortorder = 'asc';
	}

	if ($sortfield == 'name' AND $sortorder == 'desc')
	{
		// reverse cats
		$catcache = array_reverse($vbulletin->vblinklist['categories']);
	}
	else
	{
		// display cats as they are stored in the cache
		$catcache = $vbulletin->vblinklist['categories'];
	}

	$linklist = '';

	$show['catpreview'] = ($vbulletin->options['vblinklist_catpreview'] == 1 ? true : false);

	// if there are categories
	if (count($catcache))
	{
		foreach ($catcache AS $row)
		{
			// is this category a main category?
			if ($row['parentid'] == -1 AND $row['status'] > 0)
			{
				if (fetch_linkcatpermission($row['id'], false))
				{
					$subcatlist = $subcatmain = $lposter = $lposterid = '';
					$show['subcat'] = false;

					$allentries['count'] = $lentrydate = $subcatchk = 0;
					$allentries['count'] = $subcatchk = 0;

					// are there subcategories in this category?
					foreach ($catcache AS $subrow)
					{
						$stylevar['imgdir_vblinklist'] = 'images/vblinklist/subcat';

						$show['defaulticon'] = ($subrow['defaulticon'] == 1 ? true : false);

						if ($subrow['parentid'] == $row['id'] AND $subrow['status'] > 0)
						{
							if (fetch_linkcatpermission($subrow['id'], false))
							{
								construct_linklist_category_url($subrow);

								$subcatchk++;

								$templater = vB_Template::create('vblinklist_subcategorylistbit');
									$templater->register('subrow', $subrow);
									$templater->register('stylevar', $stylevar);
								$subcatmain .= $templater->render();

								$show['subcat'] = true;
								// count all entries in all categories (main + sub)
								$allentries['count'] = $allentries['count'] + $catcache["$subrow[id]"]['entriesamount'];

								// fetch last entry in all categories (main + sub)
								if ($catcache["$subrow[id]"]['lastentrydateline'] > $lentrydate)
								{
									$lentrydate = $catcache["$subrow[id]"]['lastentrydateline'];
									$linkentry['userid'] = $catcache["$subrow[id]"]['lastentryuserid'];
									$linkentry['username'] = $catcache["$subrow[id]"]['lastentryusername'];
									$linkentry['id'] = $catcache["$subrow[id]"]['lastentryid'];
									$linkentry['catid'] = $catcache["$subrow[id]"]['id'];
									$linkentry['entryname'] = $catcache["$subrow[id]"]['lastentryname'];
								}
							}
						}
					}

					// final check for last entry in all categories (main + sub)
					if ($catcache["$row[id]"]['lastentrydateline'] > $lentrydate)
					{
						$lposterid = $catcache["$row[id]"]['lastpostuserid'];
						$lentrydate = $catcache["$row[id]"]['lastentrydateline'];
						$linkentry['userid'] = $catcache["$row[id]"]['lastentryuserid'];
						$linkentry['username'] = $catcache["$row[id]"]['lastentryusername'];
						$linkentry['id'] = $catcache["$row[id]"]['lastentryid'];
						$linkentry['catid'] = $catcache["$row[id]"]['id'];
						$linkentry['entryname'] = $catcache["$row[id]"]['lastentryname'];
					}

					// final amount of all entries in each category to show for main category
					$allentries['count'] = $allentries['count'] + $catcache["$row[id]"]['entriesamount'];

					$show['entryamount'] = true;

					if ($allentries['count'] == '' OR $allentries['count'] == 0)
					{
						$allentries['count'] = $vbphrase['never'];
						$show['entryamount'] = false;
					}

					//  display last entry if exists
					if ($catcache["$row[id]"]['lastpostusername'] OR $lentrydate)
					{
						$show['lastentry'] = true;

						$linkentry['date'] = vbdate($vbulletin->options['dateformat'], $lentrydate, $vbulletin->options['yestoday']);
						$linkentry['time'] = vbdate($vbulletin->options['timeformat'], $lentrydate, $vbulletin->options['yestoday']);
					}
					else
					{
						$show['lastentry'] = false;
					}

					construct_linklist_category_url($row);

					// set image directories and fetch icons
					$stylevar['imgdir_vblinklist'] = 'images/vblinklist/cat';
					$stylevar['imgdir_vblinklist_pictures'] = 'images/vblinklist/pictures';
					$show['defaulticon'] = ($row['defaulticon'] == 1 ? true : false);

					if ($row['picturelocation'])
					{
						$show['catpicture'] = true;
					}
					else
					{
						$show['catpicture'] = false;
					}

					construct_linklist_entry_url($linkentry);

					// complete category with subcategories
					$templater = vB_Template::create('vblinklist_categorylistbit');
						$templater->register('row', $row);
						$templater->register('subcatmain', $subcatmain);
						$templater->register('allentries', $allentries);
						$templater->register('linkentry', $linkentry);
						$templater->register('stylevar', $stylevar);
					$linklist .= $templater->render();

					$show['linklist'] = true;
				}
			}
		}
	}

	// show search-option?
	$show['searchbutton'] = ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_search_linklist'] ? true : false);

	// can administrate?
	$show['canadmin'] = ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate'] ? true : false);

	if ($show['canadmin'] == false AND $show['searchbutton'] == false)
	{
		$show['generalbar'] = false;
	}
	else
	{
		$show['generalbar'] = true;
	}

	// show statistics and 'link to us'-message?
	$show['linklist_statistics'] = $show['comments'] = $show['comments_id'] = $show['entries_sum'] = false;

	if ($vbulletin->options['vblinklist_statistics'])
	{
		$show['linklist_statistics'] = true;

		$linklist_stats['categories'] = count($catcache);

		$entries_stats = $db->query_first("
			SELECT COUNT(*) AS count, MAX(dateline) AS dateline, MAX(id) AS id
			FROM " . TABLE_PREFIX . "vblinklist_entry
			WHERE status = 1
		");

		if ($entries_stats['count'] > 0)
		{
			$show['entries_sum'] = true;

			$linklist_stats['entries'] = $entries_stats['count'];

			$last_entries_entry = $db->query_first("
				SELECT *
				FROM " . TABLE_PREFIX . "vblinklist_entry
				WHERE id = '" . intval($entries_stats['id']) . "'
			");

			$linklist_stats['latest_entry'] = $last_entries_entry['name'];
			$linklist_stats['latest_entry_url'] = construct_linklist_entry_urls($last_entries_entry, 'showentry');
			$linklist_stats['latest_entry_username'] = $last_entries_entry['username'];
			$linklist_stats['latest_entry_dateline'] = $last_entries_entry['dateline'];
			$linklist_stats['latest_entry_array'] = $last_entries_entry;

			if ($vbulletin->options['vblinklist_comment'])
			{
				$show['comments'] = true;

				$comments = $db->query_first("
					SELECT COUNT(*) AS count, MAX(dateline) AS dateline, MAX(commentid) AS commentid
					FROM " . TABLE_PREFIX . "vblinklist_comment
					WHERE state = 'visible'
				");

				if ($comments['commentid'])
				{
					$show['comments_id'] = true;

					if ($comments['count'] > 0)
					{
						$show['comments_sum'] = true;
						$linklist_stats['comments'] = $comments['count'];

						$last_comments_entry = $db->query_first("
							SELECT entry.*, comment.*
							FROM " . TABLE_PREFIX . "vblinklist_entry AS entry
							LEFT JOIN " . TABLE_PREFIX . "vblinklist_comment AS comment ON (comment.entryid = entry.id)
							WHERE comment.commentid = '" . intval($comments['commentid']) . "'
						");

						$linklist_stats['latest_comment'] = $last_comments_entry['name'];
						$linklist_stats['latest_comment_url'] = construct_linklist_entry_urls($last_comments_entry, 'showentry');
						$linklist_stats['latest_comment_dateline'] = $last_comments_entry['dateline'];
						$linklist_stats['last_comment_username'] = $last_comments_entry['postusername'];

						$last_comments_entry['userid'] = $last_comments_entry['postuserid'];
						$last_comments_entry['username'] = $last_comments_entry['postusername'];

						$linklist_stats['lastcomment'] = $last_comments_entry;
					}
				}
			}
		}

	}

	// show link-us
	$show['linklist_link_us'] = ($vbulletin->options['vblinklist_link_us'] ? true : false);

	if ($vbulletin->options['vblinklist_link_us_text'])
	{
		$link_to_us_text = $vbulletin->options['vblinklist_link_us_text'];
	}
	else
	{
		$show['linklist_link_us'] = false;
	}


	// navbar and output
	$navbits = construct_navbits(array(
		'' => $vbphrase['vblinklist_navbit_headline']
	));

	$navbar = render_navbar_template($navbits);

	($hook = vBulletinHook::fetch_hook('vblinklist_homecomplete')) ? eval($hook) : false;

	$templater = vB_Template::create('vblinklist_home');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('linklist', $linklist);
		$templater->register('linklist_stats', $linklist_stats);
		$templater->register('link_to_us_text', $link_to_us_text);
	print_output($templater->render());
}

// #######################################################################
if ($_REQUEST['do'] == 'showcat')
{
	$vbulletin->input->clean_array_gpc('g', array(
		'page' => TYPE_UINT,
		'catid'	=> TYPE_INT,
		'sort'	=> TYPE_NOHTML,
		'order'	=> TYPE_NOHTML,
		'ltr'	=> TYPE_NOHTML
	));

	// get values
	$catid =& $vbulletin->GPC['catid'];
	$sortorder =& $vbulletin->GPC['order'];
	$page =& $vbulletin->GPC['page'];

	if (!($catinfo = fetch_linkcatinfo($catid)))
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_category'], $vbulletin->options['contactuslink'])));
	}

	if (!fetch_linkcatpermission($catid))
	{
		print_no_permission();
	}

	$ltr =& $vbulletin->GPC['ltr'];

	($hook = vBulletinHook::fetch_hook('vblinklist_showcatstart')) ? eval($hook) : false;

	switch ($vbulletin->GPC['sort'])
	{
		case 'name':
		case 'dateline':
		case 'username':
		case 'views':
			$sortfield = $vbulletin->GPC['sort'];
			$sqlsortfield = 'entry.' . $sortfield;
			break;
		default:
			$sortfield = 'name';
			$sqlsortfield = 'entry.name';
			break;
	}

	$sortorder = (!in_array(strtolower($sortorder), array('asc', 'desc')) ? 'ASC' : $sortorder);

	if ($ltr != '')
	{
		if ($ltr == '#')
		{
			$condition = 'AND name NOT REGEXP("^[a-zA-Z]")';
		}
		else
		{
			$ltr = chr(intval(ord($ltr)));
			$condition = 'AND name LIKE ("' . $db->escape_string_like($ltr) . '%")';
		}
	}
	else
	{
		$condition = '';
	}

	// build letter selector and start with non-alpha characters
	$currentletter = '#';
	$linkletter = urlencode('#');
	$show['selectedletter'] = $ltr == '#' ? true : false;

	$templater = vB_Template::create('vblinklist_letterbits');
		$templater->register('linkletter', $linkletter);
		$templater->register('perpage', $perpage);
		$templater->register('sortfield', $sortfield);
		$templater->register('sortorder', $sortorder);
		$templater->register('usergrouplink', $usergrouplink);
		$templater->register('ltrurl', $ltrurl);
		$templater->register('currentletter', $currentletter);
		$templater->register('catid', $catid);
	$linklistletterbits = $templater->render();

	// now do alpha-characters
	for ($i = 65; $i < 91; $i++)
	{
		$currentletter = chr($i);
		$linkletter =& $currentletter;
		$show['selectedletter'] = $ltr == $currentletter ? true : false;

		$templater = vB_Template::create('vblinklist_letterbits');
			$templater->register('linkletter', $linkletter);
			$templater->register('perpage', $perpage);
			$templater->register('sortfield', $sortfield);
			$templater->register('sortorder', $sortorder);
			$templater->register('usergrouplink', $usergrouplink);
			$templater->register('ltrurl', $ltrurl);
			$templater->register('currentletter', $currentletter);
			$templater->register('catid', $catid);
		$linklistletterbits .= $templater->render();
	}

	$show['canadmin'] = ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate'] ? true : false);

	// fetch amount of subcats if there are any
	$show['subcat'] = false;

	$show['catpreview'] = ($vbulletin->options['vblinklist_catpreview'] == 1 ? true : false);

	foreach ($vbulletin->vblinklist['categories'] AS $row)
	{
		if (!fetch_linkcatpermission($row['id'], false))
		{
			continue;
		}

		// is this category a subcategorie of choosen category?
		if ($row['parentid'] == $catid AND $row['status']== 1)
		{
			$show['subcat'] = false;

			// are there subcategories in this category?
			foreach ($vbulletin->vblinklist['categories'] AS $subrow)
			{
				$stylevar['imgdir_vblinklist'] = 'images/vblinklist/subcat';

				$show['defaulticon'] = ($subrow['defaulticon'] == 1 ? true : false);

				if ($subrow['parentid'] == $row['id'] AND $subrow['status'] > 0)
				{
					if (fetch_linkcatpermission($subrow['id'], false))
					{
						construct_linklist_category_url($subrow);

						$subcatchk++;

						$templater = vB_Template::create('vblinklist_subcategorylistbit');
							$templater->register('subrow', $subrow);
							$templater->register('stylevar', $stylevar);
						$subcatmain .= $templater->render();

						$show['subcat'] = true;
						// count all entries in all categories (main + sub)
						$allentries['count'] = $allentries['count'] + $catcache["$subrow[id]"]['entriesamount'];

						// fetch last entry in all categories (main + sub)
						if ($catcache["$subrow[id]"]['lastentrydateline'] > $lentrydate)
						{
							$lentrydate = $catcache["$subrow[id]"]['lastentrydateline'];
							$linkentry['userid'] = $catcache["$subrow[id]"]['lastpostuserid'];
							$linkentry['username'] = $catcache["$subrow[id]"]['lastpostusername'];
							$linkentry['id'] = $catcache["$subrow[id]"]['lastentryid'];
							$linkentry['catid'] = $catcache["$subrow[id]"]['id'];
							$linkentry['entryname'] = $catcache["$subrow[id]"]['lastentryname'];
						}
					}
				}
			}

			// count all entries in all categories (main + sub)
			$allentries['count'] = $vbulletin->vblinklist['categories']["$row[id]"]['entriesamount'];

			$lentrydate = $vbulletin->vblinklist['categories']["$row[id]"]['lastentrydateline'];
			$linkentry['userid'] = $vbulletin->vblinklist['categories']["$row[id]"]['lastpostuserid'];
			$linkentry['username'] = $vbulletin->vblinklist['categories']["$row[id]"]['lastpostusername'];
			$linkentry['id'] = $vbulletin->vblinklist['categories']["$row[id]"]['lastentryid'];
			$linkentry['catid'] = $vbulletin->vblinklist['categories']["$row[id]"]['lastentrycatid'];
			$linkentry['entryname'] = $vbulletin->vblinklist['categories']["$row[id]"]['lastentryname'];

			// fetch icons
			$stylevar['imgdir_vblinklist'] = 'images/vblinklist/cat';
			$stylevar['imgdir_vblinklist_pictures'] = 'images/vblinklist/pictures';
			$show['defaulticon'] = ($row['defaulticon'] == 1 ? true : false);

			if ($row['picturelocation'])
			{
				$show['catpicture'] = true;
			}
			else
			{
				$show['catpicture'] = false;
			}

			//  display last entry if exists
			if ($lentrydate)
			{
				$show['lastentry'] = true;

				$linkentry['date'] = vbdate($vbulletin->options['dateformat'], $lentrydate, $vbulletin->options['yestoday']);
				$linkentry['time'] = vbdate($vbulletin->options['timeformat'], $lentrydate, $vbulletin->options['yestoday']);
			}
			else
			{
				$show['lastentry'] = false;
			}

			$show['entryamount'] = true;

			if (!$allentries['count'])
			{
				$allentries['count'] = $vbphrase['none'];
				$show['entryamount'] = false;
			}

			$linkentry['catid'] = $catid;
			construct_linklist_entry_url($linkentry);
			construct_linklist_category_url($row);

			$templater = vB_Template::create('vblinklist_categorylistbitsub');
				$templater->register('row', $row);
				$templater->register('subcatmain', $subcatmain);
				$templater->register('allentries', $allentries);
				$templater->register('linkentry', $linkentry);
				$templater->register('stylevar', $stylevar);
			$subcatbits .= $templater->render();

			$show['subcat'] = true;
		}
	}

	$show['entrypreview'] = ($vbulletin->options['vblinklist_entry_preview'] == 1 ? true : false);
	$show['report'] = ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_report_link'] ? true : false);
	$show['changebutton'] = ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_change_own_link'] AND ($entry['userid'] == $vbulletin->userinfo['userid']) ? true : false);
	$show['deletebutton'] = ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_delete_own_link'] AND ($entry['userid'] == $vbulletin->userinfo['userid']) ? true : false);
	$show['cattoolnewentry'] = ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_add_link'] ? true : false);
	$show['entryviews'] = ($vbulletin->options['vblinklist_entryviews'] == 1 ? true : false);
	$show['directlink'] = ($vbulletin->options['vblinklist_directlink'] == 1 ? true : false);

	if ($vbulletin->options['vblinklist_thumbnail'] AND $vbulletin->options['vblinklist_thumbnail_category_view'] == 1)
	{
		$show['minithumb'] = true;
	}
	else
	{
		$show['minithumb'] = false;
	}

	if ($show['canadmin'] OR $permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_add_link'])
	{
		$show['cattools'] = true;
	}
	else
	{
		$show['cattools'] = false;
	}

	if ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate'])
	{
		$show['changebutton'] = true;
	}
	else
	{
		if ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_change_own_link'] AND ($entry['userid'] == $vbulletin->userinfo['userid']))
		{
			$show['changebutton'] = true;
		}
		else
		{
			$show['changebutton'] = false;
		}
	}

	$linkcatname = $vbulletin->vblinklist['categories']["$catid"]['name'];
	$linkcatdesc = $vbulletin->vblinklist['categories']["$catid"]['description'];

	$vblinklist_entrylistbits = '';

	// entries per page
	$perpage = $vbulletin->options['vblinklist_displaycount'];
	$show['pagenav'] = true;

	do
	{
		if (!$page)
		{
			$page = 1;
		}

		$limitlower = ($page - 1) * $perpage;

		// fetch all entries of defined category
		$hook_query_joins = $hook_query_where = '';

		($hook = vBulletinHook::fetch_hook('vblinklist_query_allentriesofcat')) ? eval($hook) : false;

		$entrylist = $db->query_read_slave("
			SELECT SQL_CALC_FOUND_ROWS *
			FROM " . TABLE_PREFIX . "vblinklist_entry AS entry
			$hook_query_joins
			WHERE categoryid = " . intval($catid) . "
				AND status IN (" . (($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']) ? "0,1" : "1") . ")
				$condition
				$hook_query_where
			ORDER BY " . $sqlsortfield . " " . $sortorder . "
			LIMIT $limitlower, $perpage
		");

		$entriestotal = $db->found_rows();
		if ($limitlower >= $entriestotal)
		{
			$page = ceil($entriestotal / $perpage);
		}
	}
	while ($limitlower >= $entriestotal AND $entriestotal);

	$allentries['count'] = $entriestotal;

	$pagenav = construct_page_nav($page, $perpage, $allentries['count'], 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showcat&amp;catid=' . $catid, ''
		. (!empty($perpage) ? '&amp;pp=' . $perpage : '')
		. ($ltr ? '&amp;ltr=' . urlencode($ltr) : '')
		. $highlightwords
	);

	if ($allentries['count'])
	{
		$show['entrylist'] = true;

		while ($row = $entry = $db->fetch_array($entrylist))
		{
			($hook = vBulletinHook::fetch_hook('vblinklist_entrylistbit')) ? eval($hook) : false;

			$linkentry_dateline = vbdate($vbulletin->options['dateformat'], $row['dateline'], true);
			$linkentry_datetime = vbdate($vbulletin->options['timeformat'], $row['dateline'], true);

			$row['description'] = strip_bbcode($row['description']);

			$lastupdaterid = $row['userid'];
			$lastupdateruser = $row['username'];

			$show['entrystatus'] = ($row['status'] == 1 ? true : false);

			if ($vbulletin->options['vblinklist_entry_preview'])
			{
				$backupmessage = $row['description'];

				$row['description'] = str_replace('&amp;', '&', $row['description']);
				$row['description'] = htmlspecialchars_uni($row['description']);

				if (strlen($row['description']) > $vbulletin->options['vblinklist_entry_previewtext'])
				{
					$row['description'] = fetch_trimmed_title($row['description'], $vbulletin->options['vblinklist_entry_previewtext']);

					$url = construct_linklist_rules($row, 'showentry');
					$url = construct_linklist_entry_url($row, 'showentry');

					$templater = vB_Template::create('vblinklist_readmorebit');
						$templater->register('url', $url);
					$vblinkmorebit = $templater->render();

					$row['description'] = $row['description'] . $vblinkmorebit;
				}
			}

			$row['catid'] = $catid;
			$row['entryname'] = $row['name'];
			construct_linklist_entry_url($row);

			// rating active?
			$show['rankings'] = ($vbulletin->options['vblinklist_entryrate'] == 1 AND $vbulletin->userinfo['userid'] ? true : false);

			if ($vbulletin->options['vblinklist_entryrate'] == 1 AND $vbulletin->userinfo['userid'])
			{
				if ($row['votenum'] > 0)
				{
					// calculate average
					$row['voteavg'] = vb_number_format($row['votetotal'] / $row['votenum'], 2);
					$row['rating'] = intval(round($row['votetotal'] / $row['votenum']));
					$show['rankings'] = true;
				}
				else
				{
					$row['voteavg'] = $row['rating'] = 0;
					$show['rankings'] = false;
				}
			}

			if ($show['minithumb'])
			{
				construct_vblinklist_thumbnail();

				$thumbnail_width = $vbulletin->options['vblinklist_thumbnail_category_view_width'] + 18;
				$thumbnail_height = $vbulletin->options['vblinklist_thumbnail_category_view_height'] + 10;
				$thumbnail_hits_height = $vbulletin->options['vblinklist_thumbnail_category_view_height'] - 23;
			}

			$show['status'] = false;
			if ($row['status'] == '0')
			{
				$show['status'] = true;
			}

			$templater = vB_Template::create('vblinklist_entrylistbits');
				$templater->register('row', $row);
				$templater->register('linkentry_lastupdate', $linkentry_lastupdate);
				$templater->register('linkentry_lastuptime', $linkentry_lastuptime);
				$templater->register('lastupdaterid', $lastupdaterid);
				$templater->register('lastupdateruser', $lastupdateruser);
				$templater->register('linkentry_dateline', $linkentry_dateline);
				$templater->register('linkentry_datetime', $linkentry_datetime);
				$templater->register('linkentry_thumbnail', $linkentry_thumbnail);
				$templater->register('thumbnail_width', $thumbnail_width);
				$templater->register('thumbnail_height', $thumbnail_height);
				$templater->register('thumbnail_hits_height', $thumbnail_hits_height);
			$vblinklist_entrylistbits .= $templater->render();
		}
	}
	else
	{
		$show['entrylist'] = false;
	}

	$sorturl = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showcat&amp;catid=' . $catid . '&amp;ltr=' . urlencode($ltr);

	$oppositesort = ($sortorder == 'asc' ? 'desc' : 'asc');

	$templater = vB_Template::create('vblinklist_sortarrow');
		$templater->register('sorturl', $sorturl);
		$templater->register('oppositesort', $oppositesort);
		$templater->register('sortfield', $sortfield);
	$sortarrow["$sortfield"] = $templater->render();

	$show['newentrybutton'] = ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_add_link'] ? true : false);
	$show['searchbutton'] = ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_search_linklist'] ? true : false);

	// create linklist rules
	construct_linklist_rules($permissions['vblinklist_general_permissions'], $catid);

	// create catjump-dropdown
	construct_linklist_catjump($catid);

	// navbar and output
	$navbits = array(
		'vblinklist.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['vblinklist_navbit_headline'],
	);

	if ($show['canadmin'] == false AND $show['cattools'] == false AND $show['searchbutton'] == false)
	{
		$show['generalbar'] = false;
	}
	else
	{
		$show['generalbar'] = true;
	}

	if ($vbulletin->vblinklist['categories']["$catid"]['parentid'] != -1)
	{
		$navbitparentid = $vbulletin->vblinklist['categories']["$catid"]['parentid'];
		$navbitparentname = $vbulletin->vblinklist['categories']["$navbitparentid"]['name'];
		$navbits['vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showcat&amp;catid=' . $navbitparentid] = $navbitparentname;
	}

	$navbits[] = $vbulletin->vblinklist['categories']["$catid"]['name'];

	$navbits = construct_navbits($navbits);

	$navbar = render_navbar_template($navbits);

	// end search timer
	$searchtime = vb_number_format(fetch_microtime_difference($searchstart), 2);

	($hook = vBulletinHook::fetch_hook('vblinklist_showcatcomplete')) ? eval($hook) : false;

	$templater = vB_Template::create('vblinklist_showcat');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('linkcatname', $linkcatname);
		$templater->register('linkcatdesc', $linkcatdesc);
		$templater->register('ltr', $ltr);
		$templater->register('pagenumber', $pagenumber);
		$templater->register('subcatbits', $subcatbits);
		$templater->register('linklistletterbits', $linklistletterbits);
		$templater->register('catid', $catid);
		$templater->register('pagenav', $pagenav);
		$templater->register('vblinklist_catjump', $vblinklist_catjump);
		$templater->register('vblinklist_rules', $vblinklist_rules);
		$templater->register('sorturl', $sorturl);
		$templater->register('vblinklist_entrylistbits', $vblinklist_entrylistbits);
	print_output($templater->render());
}

// #######################################################################
if ($_REQUEST['do'] == 'ajax')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'url' => TYPE_NOHTML
	));

	$url =& $vbulletin->GPC['url'];

	if($vbulletin->options['vblinklist_linkverify_type'] == 0)
	{
		$parts = parse_url($url);

		if(!$parts)
		{
			# url is seriously wrong
			return false;
		}

		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);

		# set the user agent in order to help while problems appear
		curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);

		# follow redirects
		if (!ini_get('open_basedir'))
		{
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
		}

		# timeout after 20 seconds
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 15);
		curl_setopt($ch, CURLOPT_TIMEOUT, 20);

		# don't download the page but the header only in order to speed-up this routine
		curl_setopt($ch, CURLOPT_NOBODY, true);
		curl_setopt($ch, CURLOPT_HEADER, true);

		# handle HTTPS links
		if($parts['scheme'] == 'https')
		{
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST,  1);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		}

		$response = curl_exec($ch);
		curl_close($ch);

		# finally fetch the status code from the HTTP header
		if(preg_match('/HTTP\/1\.\d+\s+(\d+)/', $response, $matches))
		{
			$code = intval($matches[1]);
		}

		# return true if check is successful
		if ($code != 200 AND $intReturnCode != 302 AND $intReturnCode != 304)
		{
			$templater = vB_Template::create('vblinklist_linkcheck_not_ok');
			$linkstatus = $templater->render();
			echo $linkstatus;
		}
		else
		{
			$templater = vB_Template::create('vblinklist_linkcheck_ok');
			$linkstatus = $templater->render();
			echo $linkstatus;
		}
	}
	else
	{
		$host = @parse_url($url);

		if (substr($url , 0, 4) == 'www.')
		{
			$url  = substr($url , 4, strlen($url ));
		}
		else if (substr($url, 0, 11) == 'http://www.')
		{
			$url = substr($url, 11, $urllen);
		}
		else if (substr($url, 0, 7) == 'http://')
		{
			$url = substr($url, 7, $urllen);
		}

		if (substr($url, strlen($url) - 1, strlen($url) - 1) == '/')
		{
			$url = substr($url, 0, strlen($url) - 1);
		}

		if (!@fsockopen($url , 80, $errno, $errstr, 20))
		{
			$templater = vB_Template::create('vblinklist_linkcheck_ok');
			$linkstatus = $templater->render();
			echo $linkstatus;
		}
		else
		{
			$templater = vB_Template::create('vblinklist_linkcheck_not_ok');
			$linkstatus = $templater->render();
			echo $linkstatus;
		}
	}
}

// #######################################################################
if ($_POST['do'] == 'updateentry')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'id'		=> TYPE_INT,
		'catid'		=> TYPE_INT,
		'reason'	=> TYPE_NOHTML,
		'title'		=> TYPE_STR,
		'linkurl'	=> TYPE_STR,
		'banner'	=> TYPE_STR,
		'message'	=> TYPE_STR,
		'wysiwyg'	=> TYPE_BOOL,
		'posthash'	=> TYPE_NOHTML,
		'poststarttime'	=> TYPE_UNIXTIME,
		'preview'	=> TYPE_NOHTML,
		'parseurl'	=> TYPE_BOOL,
		'deleteimage'	=> TYPE_INT,
		'imagebackup'	=> TYPE_NOHTML
	));

	$vbulletin->input->clean_array_gpc('f', array(
               'image' => TYPE_FILE
	));

	// get values
	$what =& $vbulletin->GPC['what'];
	$posthash =& $vbulletin->GPC['posthash'];
	$poststarttime =& $vbulletin->GPC['poststarttime'];
	$preview =& $vbulletin->GPC['preview'];

	$existingentry = array();
	$previewdata = array();

	define('UPDATEENTRY', true);

	// if we get an id, check if the entry exists
	if ($vbulletin->GPC['id'] AND !($existingentry = fetch_linkinfo($vbulletin->GPC['id'])))
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_entry'], $vbulletin->options['contactuslink'])));
	}

	if (
		// entry does not exist and user may not add one
		(!$existingentry AND !($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_add_link']))
		OR
		// entry exists and we can change all or we can change our own
		($entry AND !(($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['linklist_canchangeeveryentry']) OR (($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_change_own_link']))))
		)
	{
		print_no_permission();
	}

	$entry =& $existingentry;

	($hook = vBulletinHook::fetch_hook('vblinklist_updateentrystart')) ? eval($hook) : false;

	$url_duplicate = $url_blacklist = $url_meta = $vbulletin->GPC['linkurl'];

	// check if url is a duplicate
	if ($vbulletin->options['vblinklist_checkduplicates'])
	{
		$matches = substr($url_duplicate, 0, 7);

		if ($matches=='http://')
		{
			$url_duplicate = substr($url_duplicate, 7);
		}
		else
		{
			$matches = substr($url_duplicate, 0, 8);

			if ($matches=='https://')
			{
				$url_duplicate = substr($url_duplicate, 8);
			}
		}

		$duplicatelist = $db->query_read("
			SELECT linkurl, id
			FROM " . TABLE_PREFIX . "vblinklist_entry AS entry
			WHERE linkurl LIKE '%" . $db->escape_string_like($url_duplicate) . "%'
		");

		$entriestotal = $db->found_rows();

		if ($entriestotal)
		{
			while ($row = $db->fetch_array($duplicatelist))
			{
				$matches = substr($row['linkurl'], 0, 7);

				if ($matches=='http://')
				{
					$row['linkurl'] = substr($row['linkurl'], 7);
				}
				else
				{
					$matches = substr($url_duplicate, 0, 8);

					if ($matches=='https://')
					{
						$row['linkurl'] = substr($row['linkurl'], 8);
					}
				}

				if ($row['linkurl'] == $url_duplicate AND $row['id'] != $entry['id'])
				{
					$preview = true;
					define('DUPLICATE', true);
				}
			}
		}
	}

	// check if url is on blacklist
	if ($vbulletin->options['vblinklist_blacklist'])
	{
		$blacklist_array = explode(',', $vbulletin->options['vblinklist_blacklist']);  

		$matches = substr($url_blacklist, 0, 7);

		if ($matches=='http://')
		{
			$url_blacklist = substr($url_blacklist, 7);
		}
		else
		{
			$matches = substr($url_blacklist, 0, 8);

			if ($matches=='https://')
			{
				$url_blacklist = substr($url_blacklist, 8);
			}
		}

		if (in_array($url_blacklist, $blacklist_array))
		{
			$preview = true;
			define('BLACKLIST', true);
		}
	}

	// check if url is has been entered
	if ($vbulletin->GPC['linkurl'] == '')
	{
		$preview = true;
		$error = $vbphrase['vblinklist_error_message_url_missing'];
		define('ERROR', true);
	}

	// convert WYSIWYG
	if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$message = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], $catinfo['allowhtml']);
	}
	else
	{
		$message =& $vbulletin->GPC['message'];
	}

	$catinfo = fetch_linkcatinfo($vbulletin->GPC['catid']);

	$save_image = '0';
	$save_filename = '';

	// additional image to entry available?
	if ($catinfo['image'] == '1')
	{
		// image added to entry?
		if ($vbulletin->GPC['image']['name'])
		{
			// split filename
			$filesplitt = explode('.', $vbulletin->GPC['image']['name']);
			$filename = $filesplitt[0];
			$extension = $filesplitt[1];

			// extension alowed?
			$extension_array = explode(',', $vbulletin->options['vblinklist_image_extension']);  

			if (in_array($extension, $extension_array))
			{
				if (is_uploaded_file($_FILES['image']['tmp_name'])) 
				{
					$new_filename = TIMENOW;
					$save_filename = $new_filename . '.' . $extension;

					move_uploaded_file($_FILES['image']['tmp_name'], "vblinklist/images/" . $save_filename);
				}
				else
				{
					$error = $vbphrase['vblinklist_error_message_upload_failed'];
					$preview = true;
					define('ERROR', true);
				}

				$imagefile = "vblinklist/images/" . $new_filename . '.' . $extension;

				// upload successfull?
				if (file_exists($imagefile)) 
				{
					$size = getimagesize($imagefile);
					$width = $size[0];
					$height = $size[1];

					$filesize = filesize($imagefile);

					if ($width >$vbulletin->options['vblinklist_image_max_width'])
					{
						$error = $vbphrase['vblinklist_error_message_wrong_width'];
						$preview = true;
						define('ERROR', true);
					}  
					else if ($height >$vbulletin->options['vblinklist_image_max_height'])
					{
						$error = $vbphrase['vblinklist_error_message_wrong_height'];
						$preview = true;
						define('ERROR', true);
					}  
					else if ($filesize >$vbulletin->options['vblinklist_image_max_filesize'])
					{
						$error = $vbphrase['vblinklist_error_message_wrong_filesize'];
						$preview = true;
						define('ERROR', true);
					}
					else
					{
						$save_image = '1';
					} 
				}
				else
				{
					$error = $vbphrase['vblinklist_error_message_upload_failed'];
					$preview = true;
					define('ERROR', true);
				}
			}
			else
			{
				$error = $vbphrase['vblinklist_error_message_wrong_extension'];
				$preview = true;
				define('ERROR', true);
			}
		}
		else
		{
			if ($vbulletin->GPC['deleteimage'] == '1')
			{
				// delete existing image
 	   			unlink("vblinklist/images/" . $vbulletin->GPC['imagebackup']);
				$save_image = '0';
				$save_filename = '';
			}
			else
			{
				// keep existing image
				$save_image = '1';
				$save_filename = $vbulletin->GPC['imagebackup'];
			}
		}
	}

	// fetch meta informations and add them to the entry
	if ($catinfo['meta'] == '1')
	{
		$matches = substr($url_meta, 0, 7);

		if ($matches=='http://')
		{
			$url_meta = substr($url_meta, 7);
		}
		else
		{
			$matches = substr($url_meta, 0, 8);

			if ($matches=='https://')
			{
				$url_meta = substr($url_meta, 8);
			}
		}

		if ($vbulletin->options['vblinklist_linkverify_type'] == 0)
		{
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url_meta);

			# set the user agent in order to help while problems appear
			curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)');
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

			# follow redirects
			if (!ini_get('open_basedir'))
			{
				curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
			}

			// follow maximum re-directions
			curl_setopt($ch, CURLOPT_MAXREDIRS, 10);

			$meta = curl_exec($ch);

			curl_close($ch);
		}
		else
		{
			$meta = @file_get_contents($url_meta, false, null, false, 20000);
		}

		// fetch meta tags by our own to avoid leaks and fetch the needed infos only
		// thanks to http://php.net/manual/de/function.get-meta-tags.php
		if ($meta)
		{
			if (preg_match_all('|<meta[^>]+name="([^"]*)"(.*)|i', $meta, $metaresult)) 
			{ 
				if (!empty($metaresult[1]))
				{
					foreach ($metaresult[1] AS $metakey => $metatag)
					{
						if (($metatag == 'description' OR $metatag == 'keywords' OR $metatag == 'title') AND preg_match_all('|content="([^"]*)"|i', $metaresult[0][$metakey], $metacontent))
						{
							if ($metacontent[1][0])
							{
								$link[$metatag] = htmlspecialchars(trim($metacontent[1][0]));
							}
						}
					}
				}
			}

			// manually strip title of meta
			$metatag_title = stripos($meta, '<title>');

			if ($metatag_title !== false)
			{
				$metatag_title += 7;
				$link['name'] = trim(substr($meta, $metatag_title, (stripos($meta, '</title>') - $metatag_title)));
			}
			else if ($link['title'])
			{
				$link['name'] = $link['title'];
			}
		}
	}
	else
	{
		$link['name'] = $link['keywords'] = $link['description'] = '';
	}

	// initialize datamanager and set fields
	$dataman =& datamanager_init('vBlinklist_Entry', $vbulletin, ERRTYPE_STANDARD);

	// set information
	$dataman->set_info('parseurl', $vbulletin->GPC['parseurl']);
	$dataman->set_info('posthash', $posthash);
	$dataman->set_info('editreason', $vbulletin->GPC['reason']);

	// set database fields
	$dataman->setr('description', $message);
	$dataman->setr('name', $vbulletin->GPC['title']);
	$dataman->setr('linkurl', $vbulletin->GPC['linkurl']);
	$dataman->setr('banner', $vbulletin->GPC['banner']);

	// set image fields
	$dataman->setr('image', $save_image);
	$dataman->setr('imagename', $save_filename);

	// set fields for meta tags
	$dataman->setr('meta_name', $link['name']);
	$dataman->setr('meta_keywords', $link['keywords']);
	$dataman->setr('meta_description', $link['description']);

	if (!$existingentry)
	{
		// it's a new entry, so we have to set some other fields too (author, dateline, etc)
		if (($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['follow_link_moderation']) AND !($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']))
		{
			// entry has to be moderated and user may not administrate the linklisty
			$dataman->set('status', 0);
		}
		else
		{
			$dataman->set('status', 1);
		}

		$dataman->setr('categoryid', $vbulletin->GPC['catid']);

		$dataman->setr('userid', $vbulletin->userinfo['userid']);
		$dataman->setr('username', $vbulletin->userinfo['username']);
		$dataman->set('ipaddress', IPADDRESS);
	}
	else
	{
		// define constant in order to use the correct template when previewing the change of existing entry
		define('EXISTINGUPDATE', true);

		$dataman->setr('categoryid', $existingentry['categoryid']);

		// set the datamanager which entry should be updated
		$dataman->set_existing($existingentry);
	}

	$catinfo = fetch_linkcatinfo($dataman->fetch_field('categoryid'));

	($hook = vBulletinHook::fetch_hook('vblinklist_updateentry_process')) ? eval($hook) : false;

	// all fields have been set now - if there are no errors, we can continue
	$dataman->pre_save();

	// TODO
	if ($preview)
	{
		$entry['message'] = $message;

		// ### PREVIEW POST ###
		$previewdata['parsed_message'] = $entry['message'];
		$previewpost = true;

		// prepare other data for preview
		$previewdata['title'] = $dataman->fetch_field('name');
		$previewdata['wysiwyg'] = $vbulletin->GPC['wysiwyg'];
		$previewdata['url'] = $vbulletin->GPC['url'];
		$previewdata['banner'] = $vbulletin->GPC['banner'];
		$reason = $vbulletin->GPC['reason'];
		$previewposthash = $posthash;

		define('ENTRYPREVIEW', true);
		$_REQUEST['do'] = 'editentry';

		$checked['parseurl'] = ($vbulletin->GPC['parseurl'] ? 'checked="checked"' : '');
	}
	else
	{
		// save data into db, is this a new entry?
		if ($existingentry)
		{
			//Save Data to Database
			$dataman->save();
			$id = $existingentry['id'];
		}
		else
		{
			// save data to database
			$id = $dataman->save();

			// send PM to mods if there is a new entry in linklisty
			if ($vbulletin->options['vblinklist_notifynewentrymods'])
			{
				$reportinfo['userid'] = $vbulletin->userinfo['userid'];
				$reportinfo['username'] = $vbulletin->userinfo['username'];
				$reportinfo['entrytitle'] = $vbulletin->GPC['title'];
				$catid = $vbulletin->GPC['catid'];

				// fetch title and message for PM
				eval(fetch_email_phrases('vblinklist_new_entry_created', $userinfo['languageid']));

				$botpermissions = 2;

				$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);

				$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
				$pmdm->set('fromusername', $vbulletin->userinfo['username']);
				$pmdm->set('title', $subject);
				$pmdm->set('message', $message);
				$pmdm->set_recipients($vbulletin->options['vblinklist_notifynewentrymods'], $botpermissions);
				$pmdm->set('dateline', TIMENOW);

				$pmdm->pre_save();

				// process errors if there are any
				if (empty($pmdm->errors))
				{
					// everything's good!
					$pmdm->save();
				}
			}

			// create thread to notify about new entry in linklisty
			if ($vbulletin->options['vblinklist_notifynewentryforumid'] <> 0)
			{
				$reportthread = ($rpforumid = $vbulletin->options['vblinklist_notifynewentryforumid'] AND $rpforuminfo = fetch_foruminfo($rpforumid));

				// new thread
				$reportinfo = array(
					'forumtitle'  => unhtmlspecialchars($foruminfo['title_clean']),
				);

				$reportinfo['userid'] = $vbulletin->userinfo['userid'];
				$reportinfo['username'] = $vbulletin->userinfo['username'];
				$reportinfo['entrytitle'] = $vbulletin->GPC['title'];
				$catid = $vbulletin->GPC['catid'];

				eval(fetch_email_phrases('vblinklist_new_entry_createdthread', $userinfo['languageid']));

				// titel of poi/event
				$subject = $subject . $vbulletin->GPC['title'];

				// author of thread
				$userinfo =& $vbulletin->userinfo;

				// put data into datamanger
				$threadman =& datamanager_init('Thread_FirstPost', $vbulletin, ERRTYPE_STANDARD, 'threadpost');
				$threadman->set_info('forum', $rpforuminfo);
				$threadman->set_info('skip_moderator_email', true);
				$threadman->set_info('skip_floodcheck', true);
				$threadman->set_info('skip_charcount', true);
				$threadman->set_info('mark_thread_read', true);
				$threadman->set_info('skip_title_error', true);
				$threadman->set_info('parseurl', true);
				$threadman->set('allowsmilie', true);
				$threadman->set('userid', $userinfo['userid']);
				$threadman->setr_info('user', $userinfo);
				$threadman->set('title', $subject);
				$threadman->set('pagetext', $message);
				$threadman->set('forumid', $rpforuminfo['forumid']);
				$threadman->set('visible', 1);

				// blow the stuff...
				$rpthreadid = $threadman->save();

				// check for double entry, get id number
				$checkrpid = ($postinfo['reportthreadid'] ? $postinfo['reportthreadid'] : 0);
				$postman->condition = "postid = $postinfo[postid] AND reportthreadid = $checkrpid";

				// end of thread creating, clear datamanager
				unset($threadman);
				unset($postman);
			}
		}

		($hook = vBulletinHook::fetch_hook('vblinklist_updateentrycomplete')) ? eval($hook) : false;

		if (($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['follow_link_moderation']) AND !($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']))
		{
			// entry is not visible and has to be moderated -> redirect to category
			$vbulletin->url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showcat&amp;catid=' . $vbulletin->GPC['catid'];
			eval(print_standard_redirect('redirect_moderated_entry',true, true));
		}
		else
		{
			// entry visible -> redirect to category
			$vbulletin->url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showentry&amp;catid=' . $vbulletin->GPC['catid'] . '&amp;id=' . $id;
			eval(print_standard_redirect('redirect_no_moderated_entry'));
		}
	}
}

// #######################################################################
if ($_REQUEST['do'] == 'editentry')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'id'		=> TYPE_INT,
		'catid'		=> TYPE_INT,
	));

	$vbulletin->input->clean_array_gpc('p', array(
		'what'		=> TYPE_NOHTML
	));

	// get values
	$id =& $vbulletin->GPC['id'];
	$what =& $vbulletin->GPC['what'];

	// did we already verify the data?
	if (!defined('UPDATEENTRY'))
	{
		// verify Data
		if ($vbulletin->GPC['id'] AND !$existingentry)
		{
			if (!($entry = fetch_linkinfo($vbulletin->GPC['id'])))
			{
				eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_entry'], $vbulletin->options['contactuslink'])));
			}
			else
			{
				$catid = $entry['categoryid'];
			}
		}
		else
		{
			$catid = $vbulletin->GPC['catid'];
		}

		if (!$catinfo AND !($catinfo = fetch_linkcatinfo($catid)))
		{
			eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_category'], $vbulletin->options['contactuslink'])));
		}
	}

	// check Permissions
	if (
		// entry does not exist and user may not add one
		(!$entry AND !($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_add_link']))
		OR
		// entry exists and we can change all or we can change our own
		($entry AND !(($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['linklist_canchangeeveryentry']) OR (($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_change_own_link']))))
		)
	{
		print_no_permission();
	}

	($hook = vBulletinHook::fetch_hook('vblinklist_editentrystart')) ? eval($hook) : false;

	if ($what == 'admindelete')
	{
		// navbar and output
		$navbits = construct_navbits(array(
			'vblinklist.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['vblinklist_navbit_headline'],
			'' => $vbphrase['vblinklist_navbit_delete_entry']
		));
		$navbar = render_navbar_template($navbits);
	
		$templater = vB_Template::create('vblinklist_deleteentry');
			$templater->register_page_templates();
			$templater->register('navbar', $navbar);
			$templater->register('id', $id);
			$templater->register('catid', $catid);
			$templater->register('entry', $entry);
		print_output($templater->render());
	}
	else if ($what == 'adminmove')
	{
		$entryidstomove = '';
		$movecatbits = '';

		// if there are categories
		if (count($vbulletin->vblinklist['categories']))
		{
			foreach ($vbulletin->vblinklist['categories'] AS $row)
			{
				// is this category a main category?
				if ($row['parentid'] == -1)
				{
					$optionvalue =& $row['id'];
					$optiontitle =& $row['name'];
					$optionselected = ($catid == $row['id']) ? 'selected="selected"' : '';
					$optionselected = '';

					$templater = vB_Template::create('option');
						$templater->register('optionvalue', $optionvalue);
						$templater->register('optiontitle', $optiontitle);
						$templater->register('optionselected', $optionselected);
					$movecatbits .= $templater->render();

					// if there are subcats
					foreach ($vbulletin->vblinklist['categories'] AS $subrow)
					{
						if ($subrow['parentid'] == $row['id'])
						{
							$optionvalue =& $subrow['id'];
							$optiontitle = '&nbsp; &nbsp;  ' . $subrow['name'];
							$optionselected = ($catid == $subrow['id']) ? 'selected="selected"' : '';
							$optionselected = '';
		
							$templater = vB_Template::create('option');
								$templater->register('optionvalue', $optionvalue);
								$templater->register('optiontitle', $optiontitle);
								$templater->register('optionselected', $optionselected);
							$movecatbits .= $templater->render();

							foreach ($vbulletin->vblinklist['categories'] AS $subrow1)
							{
								if ($subrow1['parentid'] == $subrow['id'])
								{
									$optionvalue =& $subrow1['id'];
									$optiontitle = '&nbsp; &nbsp; &nbsp; &nbsp;  ' . $subrow1['name'];
									$optionselected = ($catid == $subrow1['id']) ? 'selected="selected"' : '';
									$optionselected = '';
				
									$templater = vB_Template::create('option');
										$templater->register('optionvalue', $optionvalue);
										$templater->register('optiontitle', $optiontitle);
										$templater->register('optionselected', $optionselected);
									$movecatbits .= $templater->render();

									foreach ($vbulletin->vblinklist['categories'] AS $subrow2)
									{
										if ($subrow2['parentid'] == $subrow1['id'])
										{
											$optionvalue =& $subrow2['id'];
											$optiontitle = '&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  ' . $subrow2['name'];
											$optionselected = ($catid == $subrow2['id']) ? 'selected="selected"' : '';
											$optionselected = '';
						
											$templater = vB_Template::create('option');
												$templater->register('optionvalue', $optionvalue);
												$templater->register('optiontitle', $optiontitle);
												$templater->register('optionselected', $optionselected);
											$movecatbits .= $templater->render();

											foreach ($vbulletin->vblinklist['categories'] AS $subrow3)
											{
												if ($subrow3['parentid'] == $subrow2['id'])
												{
													$optionvalue =& $subrow3['id'];
													$optiontitle = '&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  ' . $subrow3['name'];
													$optionselected = ($catid == $subrow3['id']) ? 'selected="selected"' : '';
													$optionselected = '';
								
													$templater = vB_Template::create('option');
														$templater->register('optionvalue', $optionvalue);
														$templater->register('optiontitle', $optiontitle);
														$templater->register('optionselected', $optionselected);
													$movecatbits .= $templater->render();

													foreach ($vbulletin->vblinklist['categories'] AS $subrow4)
													{
														if ($subrow3['parentid'] == $subrow3['id'])
														{
															$optionvalue =& $subrow4['id'];
															$optiontitle = '&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  ' . $subrow4['name'];
															$optionselected = ($catid == $subrow4['id']) ? 'selected="selected"' : '';
															$optionselected = '';
										
															$templater = vB_Template::create('option');
																$templater->register('optionvalue', $optionvalue);
																$templater->register('optiontitle', $optiontitle);
																$templater->register('optionselected', $optionselected);
															$movecatbits .= $templater->render();
														}
													}





													foreach ($vbulletin->vblinklist['categories'] AS $subrow5)
													{
														if ($subrow3['parentid'] == $subrow4['id'])
														{
															$optionvalue =& $subrow5['id'];
															$optiontitle = '&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  ' . $subrow5['name'];
															$optionselected = ($catid == $subrow5['id']) ? 'selected="selected"' : '';
															$optionselected = '';
										
															$templater = vB_Template::create('option');
																$templater->register('optionvalue', $optionvalue);
																$templater->register('optiontitle', $optiontitle);
																$templater->register('optionselected', $optionselected);
															$movecatbits .= $templater->render();
														}
													}







												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}

		// navbar and output
		$navbits = construct_navbits(array(
			'vblinklist.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['vblinklist_navbit_headline'],
			'' => $vbphrase['vblinklist_navbit_move_entry']
		));

		$navbar = render_navbar_template($navbits);
	
		$templater = vB_Template::create('vblinklist_moveentry');
			$templater->register_page_templates();
			$templater->register('navbar', $navbar);
			$templater->register('id', $id);
			$templater->register('catid', $catid);
			$templater->register('movecatbits', $movecatbits);
		print_output($templater->render());
	}
	else if ($what == 'adminactivate')
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "vblinklist_entry SET
			status = '1'
			WHERE id = '" . intval($id) . "'
		");

		// rebuild datastore
		require_once(DIR . '/includes/adminfunctions_vblinklist.php');
		build_vblinklist_datastore();

		eval(print_standard_redirect('link_activated'));
	}
	else if ($what == 'admindeactivate')
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "vblinklist_entry SET
			status = '0'
			WHERE id = '" . intval($id) . "'
		");

		// rebuild datastore
		require_once(DIR . '/includes/adminfunctions_vblinklist.php');
		build_vblinklist_datastore();

		eval(print_standard_redirect('link_deactivated'));
	}
	else if ($what == 'newowner')
	{
		require_once(DIR . '/includes/functions_editor.php');
		require_once(DIR . '/includes/functions_newpost.php');

		$editorid = construct_edit_toolbar(
			$comment['pagetext'],
			false,
			'vblinklist',
			false,
			false,
			false,
			'fe',
			'',
			''
		);

		// navbar and output
		$navbits = construct_navbits(array(
			'vblinklist.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['vblinklist_navbit_headline'],
			'' => $vbphrase['vblinklist_navbit_new_owner']
		));
		$navbar = render_navbar_template($navbits);
	
		$templater = vB_Template::create('vblinklist_newowner');
			$templater->register_page_templates();
			$templater->register('navbar', $navbar);
			$templater->register('id', $id);
			$templater->register('catid', $catid);
			$templater->register('messagearea', $messagearea);
			$templater->register('entry', $entry);
		print_output($templater->render());
	}

	if (!$posthash OR !$poststarttime)
	{
		$poststarttime = TIMENOW;
		$posthash = md5($poststarttime . $vbulletin->userinfo['userid'] . $vbulletin->userinfo['salt']);
	}

	if (defined('ENTRYPREVIEW'))
	{
		$title = $previewdata['title'];
		$linkurl = $previewdata['linkurl'];
		$banner = $previewdata['banner'];

		// parse preview message 
		require_once(DIR . '/includes/class_bbcode.php');
		$parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
		$previewmessage = $parser->parse($previewdata['parsed_message'], 'picturecomment', true);

		$templater = vB_Template::create('vblinklist_entrypreview');
			$templater->register('linkurl', $linkurl);
			$templater->register('banner', $banner);
			$templater->register('title', $title);
			$templater->register('previewmessage', $previewmessage);
		$entrypreview = $templater->render();
	}

	if (defined('BLACKLIST'))
	{
		$templater = vB_Template::create('vblinklist_blacklist');
			$templater->register('title', $title);
		$blacklist = $templater->render();
	}

	if (defined('DUPLICATE'))
	{
		$templater = vB_Template::create('vblinklist_duplicate');
			$templater->register('title', $title);
		$duplicate = $templater->render();
	}

	if (defined('ERROR'))
	{
		$templater = vB_Template::create('vblinklist_error_message');
			$templater->register('error', $error);
			$templater->register('title', $title);
		$error = $templater->render();
	}

	// check if banner option is available 
	$show['additional_banner'] = $show['additional_image'] = $show['additional_fileimage'] = $show['imagedelete'] = false;

	if ($catinfo['banner'] == '1')
	{
		$show['additional_banner'] = true;
	}

	if ($catinfo['image'] == '1')
	{
		$show['additional_image'] = true;
	}

	if ($catinfo['image'] == '1' AND $entry['image'] == '1')
	{
		$show['imagedelete'] = true;
		$imagebackup = $entry['imagename'];
	}

	if (defined('UPDATEENTRY'))
	{
		// update an entry
		$title = $vbulletin->GPC['title'];
		$linkurl = $vbulletin->GPC['linkurl'];
		$banner = $vbulletin->GPC['banner'];
		$message = ($vbulletin->GPC['wysiwyg'] ? convert_wysiwyg_html_to_bbcode($vbulletin->GPC['message'], $catinfo['allowhtml']) : htmlspecialchars_uni($vbulletin->GPC['message']));
	}
	else if ($entry)
	{
		// we now edit an entry (no preview, no save)
		$title = $entry['name'];
		$linkurl = $entry['linkurl'];
		$banner = $entry['banner'];

		$message = htmlspecialchars_uni($entry['description']);
	}
	else
	{
		$message = $title = $linkurl = $banner = '';
	}

	// legacy stuff for catinfo
	$linkcat =& $catinfo;
	$catname =& $linkcat['name'];
	$catid =& $catinfo['id'];

	require_once(DIR . '/includes/functions_editor.php');
	require_once(DIR . '/includes/functions_newpost.php');

	$contenttypeid = 0;
	$vbulletin->options['ignorequotechars'] = 0;

	$editorid = construct_edit_toolbar(
		$message,
		$catinfo['allowhtml'],
		'vblinklist',
		$catinfo['allowsmilies'],
		$catinfo['allowsmilies'],
		false,
		'fe',
		'',
		''
	);

	if (!defined('UPDATEENTRY'))
	{
		$checked = array();
		$checked['parseurl'] = 'checked="checked"';
	}

	$show['parseurl'] = $show['misc_options'] = $show['additional_options'] = true;
	$show['urlcheck'] = false;

	// create linklist rules
	construct_linklist_rules($permissions['vblinklist_general_permissions'], $catid);

	// check if url is available
	if ($vbulletin->options['vblinklist_linkverify'])
	{
		$show['urlcheck'] = true;
	}

	($hook = vBulletinHook::fetch_hook('vblinklist_editentrycomplete')) ? eval($hook) : false;

	// navbar and output
	if ($id)
	{
		$navbittemp = $vbphrase['vblinklist_navbit_change_entry'];
	}
	else
	{
		$navbittemp = $vbphrase['vblinklist_navbit_newentry'];
	}

	construct_linklist_entry_url($entry);
	construct_linklist_category_url($catinfo);

	// navbar and output
	$navbits = array(
		'vblinklist.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['vblinklist_navbit_headline'],
	);

	if ($catinfo['parentid'] != -1)
	{
		$parentcat = fetch_linkcatinfo($catinfo['parentid']);
		construct_linklist_category_url($parentcat);
		$navbits["$parentcat[url]"] = $parentcat['name'];
	}

	$navbits["$catinfo[url]"] = $catinfo['name'];
	if ($entry)
	{
		$navbits["$entry[url]"] = $entry['name'];
	}

	$navbits[''] = $navbittemp;

	$navbits = construct_navbits($navbits);

	$navbar = render_navbar_template($navbits);

	$templater = vB_Template::create('vblinklist_newentry');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('catname', $catname);
		$templater->register('catid', $catid);
		$templater->register('messagearea', $messagearea);
		$templater->register('id', $id);
		$templater->register('checked', $checked);
		$templater->register('disablesmiliesoption', $disablesmiliesoption);
		$templater->register('editorid', $editorid);
		$templater->register('emailchecked', $emailchecked);
		$templater->register('explicitchecked', $explicitchecked);
		$templater->register('newpost', $newpost);
		$templater->register('onload', $onload);
		$templater->register('pageinfo', $pageinfo);
		$templater->register('posthash', $posthash);
		$templater->register('posticons', $posticons);
		$templater->register('postid', $postid);
		$templater->register('postinfo', $postinfo);
		$templater->register('postpreview', $postpreview);
		$templater->register('poststarttime', $poststarttime);
		$templater->register('selectedicon', $selectedicon);
		$templater->register('linkurl', $linkurl);
		$templater->register('banner', $banner);
		$templater->register('title', $title);
		$templater->register('url', $url);
		$templater->register('htmloption', $htmloption);
		$templater->register('return_node', $vbulletin->GPC['return_node']);
		$templater->register('vblinklist_rules', $vblinklist_rules);
		$templater->register('entrypreview', $entrypreview);
		$templater->register('blacklist', $blacklist);
		$templater->register('duplicate', $duplicate);
		$templater->register('error', $error);
		$templater->register('reason', $reason);
		$templater->register('imagebackup', $imagebackup);
	print_output($templater->render());
}

// #######################################################################
if ($_REQUEST['do'] == 'showentry')
{
	if (!($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_view_link']))
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('g', array(
		'id'	=> TYPE_INT,
		'page'	=> TYPE_UINT
	));

	$id =& $vbulletin->GPC['id'];
	$page =& $vbulletin->GPC['page'];

	// do we have id?
	if (($vbulletin->GPC['id'] AND !$entry = fetch_linkinfo($vbulletin->GPC['id'])) OR (!$vbulletin->GPC['id']))
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_entry'], $vbulletin->options['contactuslink'])));
	}

	// verify category
	if ($entry['categoryid'])
	{
		$catinfo = fetch_linkcatinfo($entry['categoryid']);
		$catid =& $catinfo['id'];
	}

	// if we have an id, check if the entry is active
	if ($entry AND !($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']) AND !$entry['status'])
	{
		print_no_permission();
	}

	// check if we are allowed to view this group
	if ($entry AND !fetch_linkcatpermission($catid))
	{
		print_no_permission();
	}

	($hook = vBulletinHook::fetch_hook('vblinklist_showentrystart')) ? eval($hook) : false;

	$linkcat =& $catinfo;
	$catname = $catinfo['name'];

	$url = construct_linklist_category_url($catinfo);
	construct_linklist_entry_urls($entry);

	($hook = vBulletinHook::fetch_hook('vblinklist_query_showentrycomplete')) ? eval($hook) : false;

	// if we are that far we are showing a single item which has
	// already been loaded by fetch_iteminfo() or the code above
	require_once(DIR . '/includes/class_bbcode.php');
	$bbcode = new vB_BbCodeParser($vbulletin, fetch_tag_list());

	require_once(DIR . '/includes/class_vblinklist_entry.php');
	$entry_factory = new vB_vBLinklist_EntryFactory($vbulletin, $bbcode, $entry['categoryid']);
	$entry_handler =& $entry_factory->create($entry);
	$entry_handler->userinfo = $entry;
	$entry_handler->construct();
	$entry =& $entry_handler->entry;
	$status =& $entry_handler->status;

	// banner and link url available?
	$show['url'] = $show['banner'] = false;

	if ($entry['linkurl'])
	{
		$show['url'] = true;
	}

	if ($entry['banner'])
	{
		$show['banner'] = true;
	}

	$show['entrystatus'] = ($entry['status'] == 1 ? true : false);

	$entrydate = vbdate($vbulletin->options['dateformat'], $entry['dateline'], true);
	$entrytime = vbdate($vbulletin->options['timeformat'], $entry['dateline'], true);

	if ($entry['dateline'] == $entry['lastupdate'] OR $entry['lastupdate'] == '0')
	{
		$show['history'] = false;
	}
	else
	{
		$entry['lastupdaterdate'] = vbdate($vbulletin->options['dateformat'], $entry['lastupdate'], $vbulletin->options['yestoday']);
		$entry['lastupdatertime'] = vbdate($vbulletin->options['timeformat'], $entry['lastupdate'], $vbulletin->options['yestoday']);

		$show['history'] = true;
	}

	// show additional image if uploaded
	if ($catinfo['image'] == '1' AND $entry['image'] == '1' AND $entry['imagename'])
	{
		$show['additional_fileimage'] = true;
	}
	else
	{
		$show['additional_fileimage'] = false;
	}

	//show additional meta tags if available
	if ($catinfo['meta'] == '1')
	{
		if (!$entry['meta_name'])
		{
			$entry['meta_name'] = 'N/A';
		}

		if (!$entry['meta_description'])
		{
			$entry['meta_description'] = 'N/A';
		}

		if (!$entry['meta_keywords'])
		{
			$entry['meta_keywords'] = 'N/A';
		}

		$show['meta_informations'] = true;
	}
	else
	{
		$show['meta_informations'] = false;
	}

	$show['report'] = ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_report_link'] ? true : false);
	$show['changebutton'] = ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_change_own_link'] AND ($entry['userid'] == $vbulletin->userinfo['userid']) ? true : false);
	$show['deletebutton'] = ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_delete_own_link'] AND ($entry['userid'] == $vbulletin->userinfo['userid']) ? true : false);

	if ($show['report'] OR $show['print'] OR $show['friendsend'])
	{
		$show['entrytools'] = true;
	}
	else
	{
		$show['entrytools'] = false;
	}

	if ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate'])
	{
		$show['changebutton'] = true;
	}
	else
	{
		if ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_change_own_link'] AND ($entry['userid'] == $vbulletin->userinfo['userid']))
		{
			$show['changebutton'] = true;
		}
		else
		{
			$show['changebutton'] = false;
		}
	}

	$show['deletebutton'] = ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_delete_own_link'] AND $entry['userid'] == $vbulletin->userinfo['userid'] ? true : false);

	$show['adminbuttons'] = ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate'] ? true : false);

	$show['ipaddress'] = ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_view_ip_address'] ? true : false);

	$ipaddress = $entry['ipaddress'];

	// update views counter of entry
	if ($vbulletin->options['vblinklist_entryviews'] == 1 AND $vbulletin->userinfo['userid'])
	{
		$db->shutdown_query("
			UPDATE " . TABLE_PREFIX . "vblinklist_entry
			SET views = views + 1
			WHERE id = " . intval($id)
		);
	}

	// allow votings of entries for registered users
	$show['rating'] = ($vbulletin->options['vblinklist_entryrate'] == 1 AND $vbulletin->userinfo['userid'] ? true : false);

	if ($vbulletin->options['vblinklist_entryrate'] == 1 AND $vbulletin->userinfo['userid'])
	{
		if ($entry['votenum'] > 0)
		{
			// calculate average
			$entry['voteavg'] = vb_number_format($entry['votetotal'] / $entry['votenum'], 2);
			$entry['rating'] = intval(round($entry['votetotal'] / $entry['votenum']));
			$show['voted'] = true;
		}
		else
		{
			$entry['voteavg'] = $entry['rating'] = 0;
			$show['voted'] = false;
		}

		// did user vote yet?
		$hook_query_joins = $hook_query_where = $hook_query_condition = '';

		($hook = vBulletinHook::fetch_hook('vblinklist_query_checkifvotedyet')) ? eval($hook) : false;

		$uservote = $db->query_read_slave("
			SELECT *
			FROM " . TABLE_PREFIX . "vblinklist_entryrate
			$hook_query_joins
			WHERE entryid = " . intval($id) . "
			$hook_query_where
			AND userid = " . intval($vbulletin->userinfo['userid']) . "
			$hook_query_condition
		");

		if ($db->fetch_array($uservote))
		{
			$show['novote'] = false;
		}
		else
		{
			$show['novote'] = true;
		}
	}

	$show['thumbnail'] = $show['thumbnail_backlink'] = $show['additional_banner'] = false;

	// thumbnail
	if ($vbulletin->options['vblinklist_thumbnail'])
	{
		$thumbnail = construct_vblinklist_thumbnail();

		if ($catinfo['thumbnail'] == 1)
		{
			$show['thumbnail'] = true;
		}

		if ($vbulletin->options['vblinklist_thumbnail_show_backlink'])
		{
			$thumbnail_backlink = construct_vblinklist_thumbnail_backlink();
		}
	}

	// show banner
	if ($entry['banner'] AND $linkcat['banner'])
	{
		$show['additional_banner'] = true;
	}

	// show search-option?
	$show['searchbutton'] = ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_search_linklist'] ? true : false);

	// show general bar
	if ($show['adminbuttons'] == false AND $show['searchbutton'] == false AND $show['rating'] == false)
	{
		$show['generalbar'] = false;
	}
	else
	{
		$show['generalbar'] = true;
	}

	// show forced space in footer bar
	if ($show['changebutton'] == false AND $show['deletebutton'] == false AND $show['ipaddress'] == false AND $show['report'] == false AND $show['adminbuttons'] == false)
	{
		$show['linkentryfooter'] = true;
	}
	else
	{
		$show['linkentryfooter'] = false;
	}

	// facebook options
	if (is_facebookenabled())
	{
		$show['fb_likebutton'] = true;
		// display the like button for this thread?
		$fblikebutton = construct_vblinklist_fblikebutton();
	}

	// comment options
	$show['showcomments'] = false;

	if ($vbulletin->options['vblinklist_comment'])
	{
		($hook = vBulletinHook::fetch_hook('vblinklist_linkcomment_start')) ? eval($hook) : false;

		$show['cancomment'] = ($vbulletin->userinfo['userid'] AND $permissions['vblinklist_comment_permissions'] & $vbulletin->bf_ugp['vblinklist_comment_permissions']['can_link_comment'] ? true : false);

		$show['canadmin'] = ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate'] ? true : false);

		if ($vbulletin->options['vblinklist_comment'] OR $show['cancomment'])
		{
			$pagenumber = $vbulletin->GPC['pagenumber'];
			$perpage = $vbulletin->GPC['perpage'];

			$messagestats = array();

			// comments per page
			$perpage = $vbulletin->options['vblinklist_comment_per_page'];
			$show['pagenav'] = true;

			do
			{
				if (!$page)
				{
					$page = 1;
				}

				$limitlower = ($page - 1) * $perpage;

				// fetch all comments of link
				$hook_query_joins = $hook_query_where = $condition = '';

				// show comments to moderate 
				$state[] = 'visible';

				if ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate'])
				{
					$state[] = 'moderation';
				}

				$state_or[] = "comment.state IN ('" . implode("','", $state) . "')";

				($hook = vBulletinHook::fetch_hook('vblinklist_query_all_comments_of_link')) ? eval($hook) : false;

				$commentlist = $db->query_read_slave("
					SELECT SQL_CALC_FOUND_ROWS comment.*
					FROM " . TABLE_PREFIX . "vblinklist_comment AS comment
					LEFT JOIN " . TABLE_PREFIX . "user AS user ON (comment.postuserid = user.userid)
					" . ($vbulletin->options['avatarenabled'] ? "LEFT JOIN " . TABLE_PREFIX . "avatar AS avatar ON(avatar.avatarid = user.avatarid)
					LEFT JOIN " . TABLE_PREFIX . "customavatar AS customavatar ON(customavatar.userid = user.userid)" : "") . "
					$hook_query_joins
					WHERE entryid = " . intval($id) . "
						AND (" . implode(" OR ", $state_or) . ")
					$condition
					$hook_query_where
					ORDER BY comment.dateline
					LIMIT $limitlower, $perpage
				");

				$messagestats['total'] = $db->found_rows();

				if ($limitlower >= $messagestats['total'])
				{
					$page = ceil($messagestats['total'] / $perpage);
				}
			}
			while ($limitlower >= $entriestotal AND $entriestotal);

			$messagestats['start'] = $limitlower + 1;
			$messagestats['end'] = min($limitlower + $perpage, $messagestats['total']);

			$allentries['count'] = $messagestats['total'];

			if ($allentries['count'])
			{
				$show['showcomments'] = $show['entrylist'] = true;

				while ($row = $db->fetch_array($commentlist))
				{
					($hook = vBulletinHook::fetch_hook('vblinklist_linklistbit')) ? eval($hook) : false;

					$row['commentdate'] = vbdate($vbulletin->options['dateformat'], $row['dateline']);
					$row['commenttime'] = vbdate($vbulletin->options['timeformat'], $row['dateline']);
					$row['userid'] = $row['postuserid'];
					$row['username'] = $row['postusername'];

					// specific user access to comments
					$show['caneditcomment'] = $show['candeletecomment'] = $show['candeletecomment'] = $show['canreportcomment'] = $show['canipcomment'] = $show['moderation'] = false;

					if (($vbulletin->userinfo['userid'] ==  $row['userid'] AND $permissions['vblinklist_comment_permissions'] & $vbulletin->bf_ugp['vblinklist_comment_permissions']['can_edit_own_link_comment']) OR ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']))
					{
						$show['caneditcomment'] = true;
					}

					if (($vbulletin->userinfo['userid'] ==  $row['userid'] AND $permissions['vblinklist_comment_permissions'] & $vbulletin->bf_ugp['vblinklist_comment_permissions']['can_delete_own_link_comment']) OR ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']))
					{
						$show['candeletecomment'] = true;
					}

					if (($vbulletin->userinfo['userid'] ==  $row['userid'] AND $permissions['vblinklist_comment_permissions'] & $vbulletin->bf_ugp['vblinklist_comment_permissions']['can_delete_own_link_comment']) OR ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']))
					{
						$show['candeletecomment'] = true;
					}

					if ($permissions['vblinklist_comment_permissions'] & $vbulletin->bf_ugp['vblinklist_comment_permissions']['can_report_link_comment'] OR $permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate'])
					{
						$show['canreportcomment'] = true;
					}

					if ($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate'])
					{
						$show['canipcomment'] = true;
					}

					if ($row['state'] == 'moderation')
					{
						$show['moderation'] = true;
					}

					// build comment bits
					require_once(DIR . '/includes/functions_user.php');
					fetch_avatar_from_userinfo($row, true);
					fetch_musername($row);

					// parse comment message 
					require_once(DIR . '/includes/class_bbcode.php');
					$parser =& new vB_BbCodeParser($vbulletin, fetch_tag_list());
					$row['pagetext'] = $parser->parse($row['pagetext'], 'picturecomment', true);

					$templater = vB_Template::create('vblinklist_linkcomment_message');
						$templater->register('row', $row);
						$templater->register('message', $message);
					$linkcommentbits .= $templater->render();
				}
			}

			$pagenavbits = array(
				"entryid=$entry[id]"
			);

			if ($perpage != $vbulletin->options['vblinklist_comment_per_page'])
			{
				$pagenavbits[] = "pp=$perpage";
			}

			if ($vbulletin->GPC['showignored'])
			{
				$pagenavbits[] = 'showignored=1';
			}

			$pagenav = construct_page_nav($page, $perpage, $messagestats['total'], 
				'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showentry&amp;id=' . $id, '&amp;catid=' . $catid, ''
				. (!empty($perpage) ? '&amp;pp=' . $perpage : '')
				. ($ltr ? '&amp;ltr=' . urlencode($ltr) : '')
			);

			$show['pagenav'] = ($pagenav ? true : false);

			require_once(DIR . '/includes/functions_editor.php');

			$editorid = construct_edit_toolbar(
				'',
				false,
				'vblinklist',
				$vbulletin->options['allowsmilies'],
				$vbulletin->options['allowsmilies'],
				true,
				'qr_small',
				'',
				''
			);
		}
	}

	($hook = vBulletinHook::fetch_hook('vblinklist_linkcomment_complete')) ? eval($hook) : false;

	// google pagerank and alex page traffic
	$show['google_pagerank'] = $show['alexa_trafficrank'] = false;

	if ($vbulletin->options['vblinklist_alexa_trafficrank'] == 1)
	{
		$show['alexa_trafficrank'] = true;

	}

	if ($vbulletin->options['vblinklist_google_pagerank'] == 1)
	{
		$show['google_pagerank'] = true;

		$gpr = new pageRank(); 
		$gpr->printrank("$entry[linkurl]"); 
		$vblinklist_pagerank = $gpr->get_pr();

		if ($vblinklist_pagerank == '' )
		{
			$vblinklist_pagerank = '0';
		}
	}

	// navbar and output
	$navbits = array(
		'vblinklist.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['vblinklist_navbit_headline'],
	);

	if ($linkcat['parentid'] != -1)
	{
		$parentcat = fetch_linkcatinfo($linkcat['parentid']);
		construct_linklist_category_url($parentcat);
		$navbits["$parentcat[url]"] = $parentcat['name'];
	}

	$navbits["$linkcat[url]"] = $catname;
	$navbits[] = $entry['name'];

	$navbits = construct_navbits($navbits);

	$navbar = render_navbar_template($navbits);

	($hook = vBulletinHook::fetch_hook('vblinklist_showentrycomplete')) ? eval($hook) : false;

	$templater = vB_Template::create('vblinklist_showentry');
		$templater->register_page_templates();
		$templater->register('fblikebutton', $fblikebutton);
		$templater->register('navbar', $navbar);
		$templater->register('entry', $entry);
		$templater->register('catname', $catname);
		$templater->register('catid', $catid);
		$templater->register('id', $id);
		$templater->register('entrydate', $entrydate);
		$templater->register('entrytime', $entrytime);
		$templater->register('entryupdatelist', $entryupdatelist);
		$templater->register('updatedate', $updatedate);
		$templater->register('updatetime', $updatetime);
		$templater->register('updatereason', $updatereason);
		$templater->register('ipaddress', $ipaddress);
		$templater->register('thumbnail', $thumbnail);
		$templater->register('thumbnail_backlink', $thumbnail_backlink);
		$templater->register('post', $post);
		$templater->register('editorid', $editorid);
		$templater->register('messagearea', $messagearea);
		$templater->register('pagenav', $pagenav);
		$templater->register('messagestats', $messagestats);
		$templater->register('linkcommentbits', $linkcommentbits);
		$templater->register('vblinklist_pagerank', $vblinklist_pagerank);
		$templater->register('vblinklist_alexarank', $vblinklist_alexarank);
	print_output($templater->render());
}

// #######################################################################
if ($_REQUEST['do'] == 'getip')
{
	if (!($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_view_ip_address']))
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'id' => TYPE_NOHTML
	));

	if (!($entry = fetch_linkinfo($vbulletin->GPC['id'])))
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_entry'], $vbulletin->options['contactuslink'])));
	}

	$catid =& $entry['categoryid'];

	if (!($catinfo = fetch_linkcatinfo($catid)))
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_category'], $vbulletin->options['contactuslink'])));
	}

	if (!fetch_linkcatpermission($catid))
	{
		print_no_permission();
	}

	$ipaddress = $entry['ipaddress'];

	if (!empty($ipaddress) AND preg_match('#^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$#', $ipaddress))
	{
		$ipaddress =& $ipaddress;
	}
	else if (!$id)
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_name_of_entry'], $vbulletin->options['contactuslink'])));
	}

	$hostaddress = @gethostbyaddr($ipaddress);

	($hook = vBulletinHook::fetch_hook('vblinklist_getipcomplete')) ? eval($hook) : false;

	eval(standard_error(fetch_error('thread_displayip', $ipaddress, $hostaddress), '', 0));
}

// #######################################################################
if ($_REQUEST['do'] == 'report')
{
	if (!($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_report_link']))
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('g', array(
		'id'	=> TYPE_INT,
		'catid'	=> TYPE_INT,
		'what'  => TYPE_NOHTML
	));

	// get values
	$id =& $vbulletin->GPC['id'];
	$catid =& $vbulletin->GPC['catid'];
	$what =& $vbulletin->GPC['what'];

	if (!($entry = fetch_linkinfo($id)))
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_entry'], $vbulletin->options['contactuslink'])));
	}

	$catid =& $entry['categoryid'];

	if (!($catinfo = fetch_linkcatinfo($catid)))
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_category'], $vbulletin->options['contactuslink'])));
	}

	if (!fetch_linkcatpermission($catid))
	{
		print_no_permission();
	}

	($hook = vBulletinHook::fetch_hook('vblinklist_reportentrystart')) ? eval($hook) : false;

	if ($what == 'mail')
	{
		$vbulletin->input->clean_array_gpc('p', array(
			'reason' => TYPE_STR,
			'url'  => TYPE_NOHTML
		));

		$reportinfo['reason'] =& $vbulletin->GPC['reason'];
		$reportinfo['rusername'] = unhtmlspecialchars($vbulletin->userinfo['username']);
		$reportinfo['ruserid'] = $vbulletin->userinfo['userid'];

		if ($vbulletin->GPC['reason'] == '')
		{
			eval(standard_error(fetch_error('vblinklist_no_report_reason')));
		}

		// fetch title and message
		eval(fetch_email_phrases('vblinklist_mail_link_report', $userinfo['languageid']));

		// send pm
		$botpermissions = 2;
		$linklist_report_mods = $vbulletin->options['vblinklist_reportmods'];

		if ($linklist_report_mods)
		{
			// create the dm to do error checking and insert the new PM
			$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);

			$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
			$pmdm->set('fromusername', $vbulletin->userinfo['username']);
			$pmdm->set('title', $subject);
			$pmdm->set('message', $message);
			$pmdm->set_recipients($linklist_report_mods, $botpermissions);
			$pmdm->set('dateline', TIMENOW);

			$pmdm->pre_save();

			// process errors if there are any
			if (empty($pmdm->errors))
			{
				// everything's good!
				$pmdm->save();
			}
		}
		$vbulletin->url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showentry&amp;id=' . intval($vbulletin->GPC['id']) . '&amp;catid=' . intval($vbulletin->GPC['catid']);
		eval(print_standard_redirect('redirect_report_linklist_entry'));
	}
	else
	{
		$catname = $catinfo['name'];

		require_once(DIR . '/includes/class_reportitem.php');
		require_once(DIR . '/includes/functions_editor.php');

		construct_linklist_entry_url($entry);
		construct_linklist_category_url($catinfo);

		$url = $entry['url'];

		// navbar and output
		$navbits = array(
			'vblinklist.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['vblinklist_navbit_headline'],
		);

		if ($catinfo['parentid'] != -1)
		{
			$parentcat = fetch_linkcatinfo($catinfo['parentid']);
			construct_linklist_category_url($parentcat);
			$navbits["$parentcat[url]"] = $parentcat['name'];
		}

		$navbits["$catinfo[url]"] = $catinfo['name'];
		$navbits["$entry[url]"] = $entry['name'];

		$navbits[] = $vbphrase['vblinklist_navbit_report'];

		$navbits = construct_navbits($navbits);

		$navbar = render_navbar_template($navbits);

		($hook = vBulletinHook::fetch_hook('vblinklist_reportentrycomplete')) ? eval($hook) : false;

		$templater = vB_Template::create('vblinklist_report');
			$templater->register_page_templates();
			$templater->register('navbar', $navbar);
			$templater->register('id', $id);
			$templater->register('catid', $catid);
			$templater->register('entry', $entry);
		print_output($templater->render());
	}
}

// #######################################################################
if ($_REQUEST['do'] == 'userdelete')
{
	if (!($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_delete_own_link']))
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('g', array(
		'id'		=> TYPE_INT,
		'catid'		=> TYPE_INT,
	));

	// get values
	$id =& $vbulletin->GPC['id'];

	if (!($entry = fetch_linkinfo($vbulletin->GPC['id'])))
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_entry'], $vbulletin->options['contactuslink'])));
	}

	$catid =& $entry['categoryid'];

	if (!($catinfo = fetch_linkcatinfo($catid)))
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_category'], $vbulletin->options['contactuslink'])));
	}

	if (!fetch_linkcatpermission($catid))
	{
		print_no_permission();
	}

	$catid =& $entry['categoryid'];

	construct_linklist_entry_url($entry);
	construct_linklist_category_url($catinfo);

	// navbar and output
	$navbits = array(
		'vblinklist.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['vblinklist_navbit_headline'],
	);

	if ($catinfo['parentid'] != -1)
	{
		$parentcat = fetch_linkcatinfo($catinfo['parentid']);
		construct_linklist_category_url($parentcat);
		$navbits["$parentcat[url]"] = $parentcat['name'];
	}

	$navbits["$catinfo[url]"] = $catinfo['name'];
	$navbits["$entry[url]"] = $entry['name'];

	$navbits[] = $vbphrase['vblinklist_navbit_delete_entry'];

	$navbits = construct_navbits($navbits);

	$navbar = render_navbar_template($navbits);

	$templater = vB_Template::create('vblinklist_deleteentry');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('id', $id);
		$templater->register('catid', $catid);
		$templater->register('entry', $entry);
	print_output($templater->render());
}

// #######################################################################
if ($_REQUEST['do'] == 'deleteentry')
{
	if (!($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']) OR !($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_delete_own_link']))
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'id'		=> TYPE_INT,
		'catid'		=> TYPE_INT,
		'deletetype'	=> TYPE_INT
	));

	$id =& $vbulletin->GPC['id'];

	if (!($entry = fetch_linkinfo($vbulletin->GPC['id'])))
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_entry'], $vbulletin->options['contactuslink'])));
	}

	$catid =& $entry['categoryid'];

	if ($vbulletin->GPC['deletetype'])
	{
		$dataman =& datamanager_init('vBLinklist_Entry', $vbulletin, ERRTYPE_STANDARD);
		$dataman->set_existing($entry);
		$dataman->delete();

		// delete optional comments
		$deleteentry = $db->query_write("
			DELETE FROM " . TABLE_PREFIX . "vblinklist_comment
			WHERE entryid = '" . $entry['id'] . "'
		");

		$vbulletin->url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showcat&amp;catid=' . $catid;
		eval(print_standard_redirect('redirect_delete_link_entry'));
	}
	else
	{
		$vbulletin->url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showentry&amp;catid=' . $catid . '&amp;id=' . $id;
		eval(print_standard_redirect('redirect_no_delete_link_entry'));
	}
}

// #######################################################################
if ($_POST['do'] == 'moveentry')
{
	if (!($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']))
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'id'		=> TYPE_INT,
		'catid'		=> TYPE_INT,
		'destcatid'	=> TYPE_INT
	));

	$id =& $vbulletin->GPC['id'];
	$catid =& $vbulletin->GPC['catid'];
	$destcatid =& $vbulletin->GPC['destcatid'];

	if ($catid == $destcatid)
	{
		$vbulletin->url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showentry&amp;id=' . $id . '&amp;catid=' . $catid;
		eval(print_standard_redirect('redirect_no_move_link_entry'));
	}
	else
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "vblinklist_entry SET
			categoryid = '" . intval($destcatid) . "'
			WHERE id = '" . intval($id) . "'
		");

		// rebuild datastore
		require_once(DIR . '/includes/adminfunctions_vblinklist.php');
		build_vblinklist_datastore();

		$vbulletin->url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showentry&amp;id=' . $id . '&amp;catid=' . $destcatid;
		eval(print_standard_redirect('redirect_move_link_entry'));
	}
}

// #######################################################################
if ($_REQUEST['do'] == 'setnewowner')
{
	if (!($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']))
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'id'		=> TYPE_INT,
		'catid'		=> TYPE_INT,
		'newowner'	=> TYPE_NOHTML
	));

	$id =& $vbulletin->GPC['id'];

	if (!($entry = fetch_linkinfo($vbulletin->GPC['id'])))
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_entry'], $vbulletin->options['contactuslink'])));
	}

	$catid =& $entry['categoryid'];

	$vbulletin->url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showentry&amp;id=' . intval($vbulletin->GPC['id']) . '&amp;catid=' . intval($vbulletin->GPC['catid']);

	if ($newowner = $db->query_first("
		SELECT username, userid
		FROM " . TABLE_PREFIX . "user
		WHERE username = '" . $db->escape_string($vbulletin->GPC['newowner']) . "'
	"))
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "vblinklist_entry SET
				username = '" . $db->escape_string($newowner['username']) . "',
				userid = '" . intval($newowner['userid']) . "'
			WHERE id = '" . intval($vbulletin->GPC['id']) . "'
		");

		eval(print_standard_redirect('redirect_new_user_saved'));
	}
	else
	{
		eval(print_standard_redirect('redirect_no_new_user_saved'));
	}
}

// #######################################################################
if ($_POST['do'] == 'rateentry')
{
	if (!$vbulletin->options['vblinklist_entryrate'] == 1 AND $vbulletin->userinfo['userid'])
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'vote'  => TYPE_UINT,
		'catid' => TYPE_INT,
		'id'    => TYPE_INT
	));

	// valid vote?
	if ($vbulletin->GPC['vote'] < 1 OR $vbulletin->GPC['vote'] > 5)
	{
		eval(standard_error(fetch_error('vblinklist_invalidvote')));
	}

	($hook = vBulletinHook::fetch_hook('vblinklist_rateentrystart')) ? eval($hook) : false;

	// did user vote yet?
	if ($ownvote = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "vblinklist_entryrate
		WHERE userid = " . $vbulletin->userinfo['userid'] . "
			AND entryid = " . intval($vbulletin->GPC['id']) . "
	"))
	{
		eval(standard_error(fetch_error('vblinklist_entryvoted')));
	}
	else
	{
		// update vote result of entry
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "vblinklist_entry
			SET votenum = votenum + 1, votetotal = votetotal + " . intval($vbulletin->GPC['vote']) . "
			WHERE id = " . intval($vbulletin->GPC['id']) . "
		");

		// update vote of user for entry
		$db->query_write("INSERT INTO " . TABLE_PREFIX . "vblinklist_entryrate (entryid, userid, vote, ipaddress)
		VALUES (
			'" . intval($vbulletin->GPC['id']) . "',
			'" . intval($vbulletin->userinfo['userid']) . "',
			'" . intval($vbulletin->GPC['vote']) . "',
			'" . $db->escape_string(IPADDRESS) . "'
		)");
	}

	($hook = vBulletinHook::fetch_hook('vblinklist_rateentrycomplete')) ? eval($hook) : false;

	$vbulletin->url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showentry&amp;id=' . intval($vbulletin->GPC['id']) . '&amp;catid=' . intval($vbulletin->GPC['catid']);
	eval(print_standard_redirect('redirect_vote_for_entry_accepted'));

}

// #############################################################################
if ($_REQUEST['do'] == 'moderate')
{
	if (!($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']))
	{
		print_no_permission();
	}
	else
	{
		exec_header_redirect($vbulletin->config['Misc']['modcpdir'] . '/index.php?' . $vbulletin->session->vars['sessionurl_js'] . 'loc=' . urlencode('vblinklist.php?' . $vbulletin->session->vars['sessionurl_js'] . 'do=entries'));
	}
}

// #######################################################################
if ($_POST['do'] == 'moderateentry')
{
	if (!($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']))
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'elist' => TYPE_ARRAY_KEYS_INT,
		'what'  => TYPE_NOHTML,
		'catid' => TYPE_INT
	));

	// get values
	$elist =& $vbulletin->GPC['elist'];
	$catid =& $vbulletin->GPC['catid'];
	$what =& $vbulletin->GPC['what'];

	if (count($elist) == 0 OR count($elist) == '')
	{
		eval(standard_error($vbphrase['vblinklist_no_entries_selected_to_moderate']));
	}

	if ($what == 'admindelete')
	{
		$entryidstodelete = '';
		$entrycount = count($elist);
		$entryids = implode(',', $elist);

		// navbar and output
		$navbits = construct_navbits(array(
			'vblinklist.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['vblinklist_navbit_headline'],
			'' => $vbphrase['vblinklist_navbit_delete_entries']
		));
		$navbar = render_navbar_template($navbits);

		$templater = vB_Template::create('vblinklist_deletemodentry');
			$templater->register_page_templates();
			$templater->register('navbar', $navbar);
			$templater->register('catid', $catid);
			$templater->register('entrycount', $entrycount);
			$templater->register('entryids', $entryids);
		print_output($templater->render());
	}
	else if ($what == 'adminmove')
	{
		$entryidstomove = '';
		$entrycount = count($elist);
		$entryids = implode(',', $elist);

		// if there are categories
		if (count($vbulletin->vblinklist['categories']))
		{
			foreach ($vbulletin->vblinklist['categories'] AS $row)
			{
				// is this category a main category?
				if ($row['parentid'] == -1)
				{
					$optionvalue =& $row['id'];
					$optiontitle =& $row['name'];
					$optionselected = ($catid == $row['id']) ? 'selected="selected"' : '';
					$optionselected = '';

					$templater = vB_Template::create('option');
						$templater->register('optionvalue', $optionvalue);
						$templater->register('optiontitle', $optiontitle);
						$templater->register('optionselected', $optionselected);
					$movecatbits .= $templater->render();

					// if there are subcats
					foreach ($vbulletin->vblinklist['categories'] AS $subrow)
					{
						if ($subrow['parentid'] == $row['id'])
						{
							$optionvalue =& $subrow['id'];
							$optiontitle = '&nbsp; &nbsp;  ' . $subrow['name'];
							$optionselected = ($catid == $subrow['id']) ? 'selected="selected"' : '';
							$optionselected = '';
		
							$templater = vB_Template::create('option');
								$templater->register('optionvalue', $optionvalue);
								$templater->register('optiontitle', $optiontitle);
								$templater->register('optionselected', $optionselected);
							$movecatbits .= $templater->render();

							foreach ($vbulletin->vblinklist['categories'] AS $subrow1)
							{
								if ($subrow1['parentid'] == $subrow['id'])
								{
									$optionvalue =& $subrow1['id'];
									$optiontitle = '&nbsp; &nbsp; &nbsp; &nbsp;  ' . $subrow1['name'];
									$optionselected = ($catid == $subrow1['id']) ? 'selected="selected"' : '';
									$optionselected = '';
				
									$templater = vB_Template::create('option');
										$templater->register('optionvalue', $optionvalue);
										$templater->register('optiontitle', $optiontitle);
										$templater->register('optionselected', $optionselected);
									$movecatbits .= $templater->render();

									foreach ($vbulletin->vblinklist['categories'] AS $subrow2)
									{
										if ($subrow2['parentid'] == $subrow1['id'])
										{
											$optionvalue =& $subrow2['id'];
											$optiontitle = '&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  ' . $subrow2['name'];
											$optionselected = ($catid == $subrow2['id']) ? 'selected="selected"' : '';
											$optionselected = '';
						
											$templater = vB_Template::create('option');
												$templater->register('optionvalue', $optionvalue);
												$templater->register('optiontitle', $optiontitle);
												$templater->register('optionselected', $optionselected);
											$movecatbits .= $templater->render();

											foreach ($vbulletin->vblinklist['categories'] AS $subrow3)
											{
												if ($subrow3['parentid'] == $subrow2['id'])
												{
													$optionvalue =& $subrow3['id'];
													$optiontitle = '&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  ' . $subrow3['name'];
													$optionselected = ($catid == $subrow3['id']) ? 'selected="selected"' : '';
													$optionselected = '';
								
													$templater = vB_Template::create('option');
														$templater->register('optionvalue', $optionvalue);
														$templater->register('optiontitle', $optiontitle);
														$templater->register('optionselected', $optionselected);
													$movecatbits .= $templater->render();

													foreach ($vbulletin->vblinklist['categories'] AS $subrow4)
													{
														if ($subrow3['parentid'] == $subrow3['id'])
														{
															$optionvalue =& $subrow4['id'];
															$optiontitle = '&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  ' . $subrow4['name'];
															$optionselected = ($catid == $subrow4['id']) ? 'selected="selected"' : '';
															$optionselected = '';
										
															$templater = vB_Template::create('option');
																$templater->register('optionvalue', $optionvalue);
																$templater->register('optiontitle', $optiontitle);
																$templater->register('optionselected', $optionselected);
															$movecatbits .= $templater->render();
														}
													}





													foreach ($vbulletin->vblinklist['categories'] AS $subrow5)
													{
														if ($subrow3['parentid'] == $subrow4['id'])
														{
															$optionvalue =& $subrow5['id'];
															$optiontitle = '&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;  ' . $subrow5['name'];
															$optionselected = ($catid == $subrow5['id']) ? 'selected="selected"' : '';
															$optionselected = '';
										
															$templater = vB_Template::create('option');
																$templater->register('optionvalue', $optionvalue);
																$templater->register('optiontitle', $optiontitle);
																$templater->register('optionselected', $optionselected);
															$movecatbits .= $templater->render();
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}

		// navbar and output
		$navbits = construct_navbits(array(
			'vblinklist.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['vblinklist_navbit_headline'],
			'' => $vbphrase['vblinklist_navbit_move_entries']
		));
		$navbar = render_navbar_template($navbits);

		$templater = vB_Template::create('vblinklist_moveentries');
			$templater->register_page_templates();
			$templater->register('navbar', $navbar);
			$templater->register('catid', $catid);
			$templater->register('movecatbits', $movecatbits);
			$templater->register('entrycount', $entrycount);
			$templater->register('entryids', $entryids);
		print_output($templater->render());
	}
	else if ($what == 'adminactivate' OR $what == 'admindeactivate')
	{
		$db->query_write("
			UPDATE " . TABLE_PREFIX . "vblinklist_entry
			SET status = " . (($what == 'admindeactivate') ? 0 : 1) . "
			WHERE id IN (" . implode(',', $elist) . ")
		");

		// rebuild datastore
		require_once(DIR . '/includes/adminfunctions_vblinklist.php');
		build_vblinklist_datastore();

		if ($what == 'adminactivate')
		{
			eval(print_standard_redirect('redirect_link_activated'));
		}
		else
		{
			eval(print_standard_redirect('redirect_link_deactivated'));
		}
	}
}

// #######################################################################
if ($_POST['do'] == 'deleteentries')
{
	if (!($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']))
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'entryids'   => TYPE_NOHTML,
		'catid'      => TYPE_INT,
		'deletetype' => TYPE_INT
	));

	// get values
	$entryids = implode(',', array_map('intval', explode(',', $vbulletin->GPC['entryids'])));

	$catid =& $vbulletin->GPC['catid'];
	$deletetype =& $vbulletin->GPC['deletetype'];

	if ($deletetype == 1)
	{
		// delete entry itself
		$deleteentry = $db->query_write("
			DELETE FROM " . TABLE_PREFIX . "vblinklist_entry
			WHERE id IN (" . $entryids . ")
		");

		// delete optional comments
		$deleteentry = $db->query_write("
			DELETE FROM " . TABLE_PREFIX . "vblinklist_comment
			WHERE entryid IN (" . $entryids . ")
		");

		require_once(DIR . '/includes/class_bootstrap_framework.php');
		require_once(DIR . '/vb/types.php');
		vB_Bootstrap_Framework::init();
		$types = vB_Types::instance();
		$contenttypeid = intval($types->getContentTypeID('vbLinklist_LinklistEntry'));

		// rebuild datastore
		require_once(DIR . '/includes/adminfunctions_vblinklist.php');
		build_vblinklist_datastore();

		$vbulletin->url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showcat&amp;catid=' . $catid;
		eval(print_standard_redirect('redirect_delete_link_entries'));
	}
	else
	{
		$vbulletin->url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showcat&amp;catid=' . $catid;
		eval(print_standard_redirect('redirect_no_delete_link_entries'));
	}
}

// #######################################################################
if ($_POST['do'] == 'moveentries')
{
	if (!($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']))
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'entryids'  => TYPE_NOHTML,
		'catid'     => TYPE_INT,
		'destcatid' => TYPE_INT
	));

	// get values
	$entryids =& $vbulletin->GPC['entryids'];
	$catid =& $vbulletin->GPC['catid'];
	$destcatid =& $vbulletin->GPC['destcatid'];

	$db->query_write("UPDATE " . TABLE_PREFIX . "vblinklist_entry
		SET categoryid = '" . intval($destcatid) . "'
		WHERE id IN(" . $entryids . ")
	");

	// rebuild datastore
	require_once(DIR . '/includes/adminfunctions_vblinklist.php');
	build_vblinklist_datastore();

	$vbulletin->url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showcat&amp;catid=' . $destcatid;
	eval(print_standard_redirect('redirect_move_link_entries'));
}

// #######################################################################
if ($_REQUEST['do'] == 'search')
{
	if (!($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_search_linklist']))
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('p', array(
		'keyword'  => TYPE_STR
	));

	exec_header_redirect('search.php?' . $vbulletin->session->vars['sessionurl'] . 'do=process&query=' . urlencode($vbulletin->GPC['keyword']) . '&contenttype=vBLinklist_LinklistEntry', 301);
}

// #######################################################################
if ($_REQUEST['do'] == 'extendedsearch')
{
	if (!($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_search_linklist']))
	{
		print_no_permission();
	}

	exec_header_redirect('search.php?' . $vbulletin->session->vars['sessionurl'] . 'search_type=1&contenttype=vBLinklist_LinklistEntry', 301);
}

// #######################################################################
if ($_POST['do'] == 'comment')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'id'		=> TYPE_INT,
		'catid'		=> TYPE_INT,
		'message'	=> TYPE_STR,
		'wysiwyg'	=> TYPE_BOOL,
		'posthash'	=> TYPE_NOHTML,
		'poststarttime'	=> TYPE_UNIXTIME,
		'parseurl'	=> TYPE_BOOL
	));

	// if we get an id, check if the entry exists
	if ($vbulletin->GPC['id'] AND !($existingentry = fetch_linkinfo($vbulletin->GPC['id'])))
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_entry'], $vbulletin->options['contactuslink'])));
	}

	if (!($permissions['vblinklist_comment_permissions'] & $vbulletin->bf_ugp['vblinklist_comment_permissions']['can_link_comment']))
	{
		print_no_permission();
	}

	($hook = vBulletinHook::fetch_hook('vblinklist_comment_start')) ? eval($hook) : false;

	// convert WYSIWYG
	if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$message = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message'],$vbulletin->options['allowhtml']);
	}

	// parse URLs in message text
	if ($vbulletin->options['allowbbcode'])
	{
		require_once(DIR . '/includes/functions_newpost.php');
		$vbulletin->GPC['message'] = convert_url_to_bbcode($vbulletin->GPC['message']);
	}

	// check text length
	$textlen = vbstrlen(strip_bbcode($vbulletin->GPC['message'], $vbulletin->options['ignorequotechars']));
	if ($textlen < $vbulletin->options['vblinklist_comment_min_chars'])
	{
		eval(standard_error(fetch_error('tooshort', $vbulletin->options['vblinklist_comment_min_chars'], $vbulletin->options['contactuslink'])));
	}
	else if ($textlen > $vbulletin->options['vblinklist_comment_max_chars'])
	{
		eval(standard_error(fetch_error('toolong', $vbulletin->options['vblinklist_comment_max_chars'], $vbulletin->options['contactuslink'])));
	}

	($hook = vBulletinHook::fetch_hook('vblinklist_comment_moderation')) ? eval($hook) : false;

	// fetch moderation
	if (($permissions['vblinklist_comment_permissions'] & $vbulletin->bf_ugp['vblinklist_comment_permissions']['follow_link_comment_moderation']))
	{
		$state = 'visible';
	}
	else
	{
		$state = 'moderation';
	}

	$db->query_write("INSERT INTO " . TABLE_PREFIX . "vblinklist_comment (entryid, postuserid, postusername, ipaddress, dateline, state, pagetext) 
	VALUES (
		'" . intval($vbulletin->GPC['id']) . "',
		'" . intval($vbulletin->userinfo['userid']) . "',
		'" . $db->escape_string($vbulletin->userinfo['username']) . "',
		'" . IPADDRESS . "',
		'" . TIMENOW . "',
		'" . $state . "',
		'" . $db->escape_string($vbulletin->GPC['message']) . "'
	)");

	($hook = vBulletinHook::fetch_hook('vblinklist_comment_complete')) ? eval($hook) : false;

	// redirect to link entry
	$vbulletin->url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showentry&amp;catid=' . $vbulletin->GPC['catid'] . '&amp;id=' . $vbulletin->GPC['id'];
	eval(print_standard_redirect('redirect_no_moderated_entry'));
}

// ############################### start retrieve ip ###############################
if ($_REQUEST['do'] == 'commentviewip')
{
	if (!($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_view_ip_address']))
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'commentid' => TYPE_INT
	));

	// entry available?
	if (!$comment = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "vblinklist_comment
		WHERE commentid = " . intval($vbulletin->GPC['commentid']) . "
	"))
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_entry'], $vbulletin->options['contactuslink'])));
	}

	$ipaddress = $comment['ipaddress'];

	if (!empty($ipaddress) AND preg_match('#^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$#', $ipaddress))
	{
		$ipaddress =& $ipaddress;
	}
	else if (!$vbulletin->GPC['commentid'])
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_name_of_entry'], $vbulletin->options['contactuslink'])));
	}

	$hostaddress = @gethostbyaddr($comment['ipaddress']);

	($hook = vBulletinHook::fetch_hook('vblinklist_comment_getip')) ? eval($hook) : false;
	eval(standard_error(fetch_error('thread_displayip',$comment['ipaddress'], $hostaddress), '', 0));
}

// #######################################################################
if ($_REQUEST['do'] == 'commentoffline')
{
	if (!($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']))
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'commentid' => TYPE_INT
	));

	// entry available?
	if (!$comment = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "vblinklist_comment
		WHERE commentid = " . intval($vbulletin->GPC['commentid']) . "
	"))
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_entry'], $vbulletin->options['contactuslink'])));
	}

	$db->query_write("UPDATE " . TABLE_PREFIX . "vblinklist_comment SET
		state = 'moderation'
		WHERE commentid = " . intval($vbulletin->GPC['commentid']) . "
	");

	eval(print_standard_redirect('redirect_link_deactivated'));
}

// #######################################################################
if ($_REQUEST['do'] == 'commentonline')
{
	if (!($permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']))
	{
		print_no_permission();
	}

	$vbulletin->input->clean_array_gpc('r', array(
		'commentid' => TYPE_INT
	));

	// entry available?
	if (!$comment = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "vblinklist_comment
		WHERE commentid = " . intval($vbulletin->GPC['commentid']) . "
	"))
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_entry'], $vbulletin->options['contactuslink'])));
	}

	$db->query_write("UPDATE " . TABLE_PREFIX . "vblinklist_comment SET
		state = 'visible'
		WHERE commentid = " . intval($vbulletin->GPC['commentid']) . "
	");

	eval(print_standard_redirect('redirect_link_activated'));
}

// #######################################################################
if ($_REQUEST['do'] == 'commentdelete')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'commentid' => TYPE_INT
	));

	// entry available?
	if (!$comment = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "vblinklist_comment
		WHERE commentid = " . intval($vbulletin->GPC['commentid']) . "
	"))
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_entry'], $vbulletin->options['contactuslink'])));
	}

	if (!($vbulletin->userinfo['userid'] == $comment['postuserid'] AND $permissions['vblinklist_comment_permissions'] & $vbulletin->bf_ugp['vblinklist_comment_permissions']['can_delete_own_link_comment'] OR $permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']))
	{
		print_no_permission();
	}

	// navbar and output
	$navbits = array(
		'vblinklist.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['vblinklist_navbit_headline'],
	);

	if ($catinfo['parentid'] != -1)
	{
		$parentcat = fetch_linkcatinfo($catinfo['parentid']);
		construct_linklist_category_url($parentcat);
		$navbits["$parentcat[url]"] = $parentcat['name'];
	}

	$navbits["$catinfo[url]"] = $catinfo['name'];
	$navbits["$entry[url]"] = $entry['name'];

	$navbits[] = $vbphrase['vblinklist_navbit_delete_entry'];

	$navbits = construct_navbits($navbits);

	$navbar = render_navbar_template($navbits);

	$templater = vB_Template::create('vblinklist_deletecomment');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('commentid', $vbulletin->GPC['commentid']);
		$templater->register('comment', $comment);
	print_output($templater->render());
}

// #######################################################################
if ($_REQUEST['do'] == 'deletecomment')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'id'		=> TYPE_INT,
		'deletetype'	=> TYPE_INT
	));

	// entry available?
	if (!$comment = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "vblinklist_comment
		WHERE commentid = " . intval($vbulletin->GPC['id']) . "
	"))
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_entry'], $vbulletin->options['contactuslink'])));
	}

	if ((!$permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']) OR (!$permissions['vblinklist_comment_permissions'] & $vbulletin->bf_ugp['vblinklist_comment_permissions']['can_delete_own_link_comment'] AND $comment['postuserid'] == $vbulletin->userinfo['userid']))
	{
		print_no_permission();
	}

	if ($vbulletin->GPC['deletetype'])
	{
		$deletecomment = $db->query_write("
			DELETE FROM " . TABLE_PREFIX . "vblinklist_comment
			WHERE commentid = '" . $db->escape_string($vbulletin->GPC['id']) . "'
		");

		$vbulletin->url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showentry&amp;id=' . $comment['entryid'];
		eval(print_standard_redirect('redirect_comment_deleted'));
	}
	else
	{
		$vbulletin->url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showentry&amp;id=' . $comment['entryid'];
		eval(print_standard_redirect('redirect_comment_not_deleted'));
	}
}

// #######################################################################
if ($_REQUEST['do'] == 'commentreport')
{
	$vbulletin->input->clean_array_gpc('g', array(
		'commentid'	=> TYPE_INT,
		'what'		=> TYPE_NOHTML
	));

	// entry available?
	if (!$comment = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "vblinklist_comment
		WHERE commentid = " . intval($vbulletin->GPC['commentid']) . "
	"))
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_entry'], $vbulletin->options['contactuslink'])));
	}

	if ((!$permissions['vblinklist_comment_permissions'] & $vbulletin->bf_ugp['vblinklist_comment_permissions']['can_report_link_comment']) OR (!$permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']))
	{
			print_no_permission();
	}

	($hook = vBulletinHook::fetch_hook('vblinklist_report_comment_start')) ? eval($hook) : false;

	if ($vbulletin->GPC['what'])
	{
		$vbulletin->input->clean_array_gpc('p', array(
			'reason' => TYPE_STR,
			'url'  => TYPE_NOHTML
		));

		$reportinfo['reason'] =& $vbulletin->GPC['reason'];
		$reportinfo['rusername'] = unhtmlspecialchars($vbulletin->userinfo['username']);
		$reportinfo['ruserid'] = $vbulletin->userinfo['userid'];

		if ($vbulletin->GPC['reason'] == '')
		{
			eval(standard_error(fetch_error('vblinklist_no_report_reason')));
		}

		// fetch title and message
		eval(fetch_email_phrases('vblinklist_mail_link_report_comment', $userinfo['languageid']));

		// send pm
		$botpermissions = 2;
		$linklist_report_mods = $vbulletin->options['vblinklist_reportmods'];

		if ($linklist_report_mods)
		{
			// create the dm to do error checking and insert the new PM
			$pmdm =& datamanager_init('PM', $vbulletin, ERRTYPE_ARRAY);

			$pmdm->set('fromuserid', $vbulletin->userinfo['userid']);
			$pmdm->set('fromusername', $vbulletin->userinfo['username']);
			$pmdm->set('title', $subject);
			$pmdm->set('message', $message);
			$pmdm->set_recipients($linklist_report_mods, $botpermissions);
			$pmdm->set('dateline', TIMENOW);

			$pmdm->pre_save();

			// process errors if there are any
			if (empty($pmdm->errors))
			{
				// somewhere over the rainbow!
				$pmdm->save();
			}
		}
		$vbulletin->url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showentry&amp;id=' . intval($comment['entryid']);
		eval(print_standard_redirect('redirect_report_linklist_comment'));
	}
	else
	{
		require_once(DIR . '/includes/class_reportitem.php');
		require_once(DIR . '/includes/functions_editor.php');

		// navbar and output
		$navbits = array(
			'vblinklist.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['vblinklist_navbit_headline'],
		);

		$navbits["$catinfo[url]"] = $catinfo['name'];
		$navbits["$entry[url]"] = $entry['name'];

		$navbits[] = $vbphrase['vblinklist_navbit_report_comment'];

		$navbits = construct_navbits($navbits);

		$navbar = render_navbar_template($navbits);

		($hook = vBulletinHook::fetch_hook('vblinklist_report_comment_complete')) ? eval($hook) : false;

		$templater = vB_Template::create('vblinklist_reportcomment');
			$templater->register_page_templates();
			$templater->register('navbar', $navbar);
			$templater->register('id', $comment['commentid']);
			$templater->register('comment', $comment);
		print_output($templater->render());
	}
}

// #######################################################################
if ($_REQUEST['do'] == 'commentmessage')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'commentid'		=> TYPE_INT
	));

	// entry available?
	if (!$comment = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "vblinklist_comment
		WHERE commentid = " . intval($vbulletin->GPC['commentid']) . "
	"))
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_entry'], $vbulletin->options['contactuslink'])));
	}

	if ((!$permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']) OR (!$permissions['vblinklist_comment_permissions'] & $vbulletin->bf_ugp['vblinklist_comment_permissions']['can_edit_own_link_comment'] AND $comment['postuserid'] == $vbulletin->userinfo['userid']))
	{
		print_no_permission();
	}

	require_once(DIR . '/includes/functions_editor.php');
	require_once(DIR . '/includes/functions_newpost.php');

	($hook = vBulletinHook::fetch_hook('vblinklist_comment_message_start')) ? eval($hook) : false;

	$editorid = construct_edit_toolbar(
		$comment['pagetext'],
		false,
		'vblinklist',
		false,
		false,
		false,
		'fe',
		'',
		''
	);

	($hook = vBulletinHook::fetch_hook('vblinklist_comment_message_complete')) ? eval($hook) : false;

	$navbittemp = $vbphrase['vblinklist_navbit_change_comment'];

	// navbar and output
	$navbits = array(
		'vblinklist.php' . $vbulletin->session->vars['sessionurl_q'] => $vbphrase['vblinklist_navbit_headline'],
	);

	$navbits["$parentcat[url]"] = $parentcat['name'];

	$navbits["$catinfo[url]"] = $catinfo['name'];
	if ($entry)
	{
		$navbits["$entry[url]"] = $entry['name'];
	}

	$navbits[''] = $navbittemp;

	$navbits = construct_navbits($navbits);

	$navbar = render_navbar_template($navbits);

	$templater = vB_Template::create('vblinklist_editcomment');
		$templater->register_page_templates();
		$templater->register('navbar', $navbar);
		$templater->register('comment', $comment);
		$templater->register('messagearea', $messagearea);
		$templater->register('editorid', $editorid);
	print_output($templater->render());
}

// #######################################################################
if ($_POST['do'] == 'updatecomment')
{
	$vbulletin->input->clean_array_gpc('p', array(
		'commentid'	=> TYPE_INT,
		'message'	=> TYPE_STR,
		'wysiwyg'	=> TYPE_BOOL,
		'parseurl'	=> TYPE_BOOL
	));

	($hook = vBulletinHook::fetch_hook('vblinklist_comment_update_start')) ? eval($hook) : false;

	// entry available?
	if (!$comment = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "vblinklist_comment
		WHERE commentid = " . intval($vbulletin->GPC['commentid']) . "
	"))
	{
		eval(standard_error(fetch_error('invalidid', $vbphrase['vblinklist_entry'], $vbulletin->options['contactuslink'])));
	}

	if ((!$permissions['vblinklist_general_permissions'] & $vbulletin->bf_ugp['vblinklist_general_permissions']['can_administrate']) OR (!$permissions['vblinklist_comment_permissions'] & $vbulletin->bf_ugp['vblinklist_comment_permissions']['can_edit_own_link_comment'] AND $comment['postuserid'] == $vbulletin->userinfo['userid']))
	{
		print_no_permission();
	}

	// check text length
	$textlen = vbstrlen(strip_bbcode($vbulletin->GPC['message'], $vbulletin->options['ignorequotechars']));
	if ($textlen < $vbulletin->options['vblinklist_comment_min_chars'])
	{
		eval(standard_error(fetch_error('tooshort', $vbulletin->options['vblinklist_comment_min_chars'], $vbulletin->options['contactuslink'])));
	}
	else if ($textlen > $vbulletin->options['vblinklist_comment_max_chars'])
	{
		eval(standard_error(fetch_error('toolong', $vbulletin->options['vblinklist_comment_max_chars'], $vbulletin->options['contactuslink'])));
	}

	// convert WYSIWYG
	if ($vbulletin->GPC['wysiwyg'])
	{
		require_once(DIR . '/includes/class_wysiwygparser.php');
		$html_parser = new vB_WysiwygHtmlParser($vbulletin);
		$message = $html_parser->parse_wysiwyg_html_to_bbcode($vbulletin->GPC['message'],$vbulletin->options['allowhtml']);
	}

	// parse URLs in message text
	if ($vbulletin->options['allowbbcode'])
	{
		require_once(DIR . '/includes/functions_newpost.php');
		$vbulletin->GPC['message'] = convert_url_to_bbcode($vbulletin->GPC['message']);
	}

	($hook = vBulletinHook::fetch_hook('vblinklist_comment_update_moderation')) ? eval($hook) : false;

	// fetch moderation
	if (($permissions['vblinklist_comment_permissions'] & $vbulletin->bf_ugp['vblinklist_comment_permissions']['follow_link_comment_moderation']))
	{
		$state = 'visible';
	}
	else
	{
		$state = 'moderation';
	}

	$db->query_write("UPDATE " . TABLE_PREFIX . "vblinklist_comment SET 
			state = '" . $db->escape_string($state) . "',
			pagetext = '" . $db->escape_string($vbulletin->GPC['message']) . "'
		WHERE commentid = " . intval($vbulletin->GPC['commentid']) . " 
	");

	($hook = vBulletinHook::fetch_hook('vblinklist_comment_update_complete')) ? eval($hook) : false;

	// redirect to link entry
	$vbulletin->url = 'vblinklist.php?' . $vbulletin->session->vars['sessionurl'] . 'do=showentry&amp;id=' . $comment['entryid'];
	eval(print_standard_redirect('redirect_comment_updated'));
}

// #######################################################################
?>
